 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                       IIIII  M   M   AAA   GGGG  EEEEE                      % O %                         I    MM MM  A   A G      E                          % O %                         I    M M M  AAAAA G  GG  EEE                        % O %                         I    M   M  A   A G   G  E                          % O %                       IIIII  M   M  A   A  GGGG  EEEEE                      % O %                                                                             % O %                                                                             % O %                          ImageMagick Image Routines                         % O %                                                                             % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A l l o c a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function AllocateImage allocates an Image structure and initializes each  %  field to a default value. % . %  The format of the AllocateImage routine is: % 0 %      allocated_image=AllocateImage(image_info) % + %  A description of each parameter follows:  % L %    o allocated_image: Function AllocateImage returns a pointer to an imageL %      structure initialized to default values.  A null image is returned if" %      there is a memory shortage. % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %  %  */  Image *AllocateImage(image_info)	 ImageInfo    *image_info; {    Image      *allocated_image;      /*     Allocate image structure.    */2   allocated_image=(Image *) malloc(sizeof(Image));(   if (allocated_image == (Image *) NULL)     { E       Warning("Unable to allocate image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize Image structure.    */&   allocated_image->file=(FILE *) NULL;    allocated_image->status=False;#   allocated_image->temporary=False; "   *allocated_image->filename='\0';   allocated_image->filesize=0;   allocated_image->pipe=False;0   (void) strcpy(allocated_image->magick,"MIFF");*   allocated_image->comments=(char *) NULL;'   allocated_image->label=(char *) NULL; &   allocated_image->text=(char *) NULL;"   allocated_image->id=UndefinedId;%   allocated_image->class=DirectClass;    allocated_image->matte=False; ;   allocated_image->compression=RunlengthEncodedCompression;    allocated_image->columns=0;    allocated_image->rows=0;   allocated_image->scene=0; 2   allocated_image->units=2;  /* pixels per inch */%   allocated_image->x_resolution=72.0; %   allocated_image->y_resolution=72.0; )   allocated_image->montage=(char *) NULL; +   allocated_image->directory=(char *) NULL; 1   allocated_image->colormap=(ColorPacket *) NULL;    allocated_image->colors=0;    allocated_image->colorspace=0;0   allocated_image->normalized_maximum_error=0.0;-   allocated_image->normalized_mean_error=0.0; *   allocated_image->mean_error_per_pixel=0;"   allocated_image->total_colors=0;+   allocated_image->signature=(char *) NULL; 3   allocated_image->pixels=(RunlengthPacket *) NULL; 3   allocated_image->packet=(RunlengthPacket *) NULL;    allocated_image->packets=0; !   allocated_image->packet_size=0; 8   allocated_image->packed_pixels=(unsigned char *) NULL;)   *allocated_image->magick_filename='\0'; $   allocated_image->magick_columns=0;!   allocated_image->magick_rows=0; 5   allocated_image->magick_time=time((time_t *) NULL);     allocated_image->orphan=False;+   allocated_image->previous=(Image *) NULL; '   allocated_image->next=(Image *) NULL; '   if (image_info != (ImageInfo *) NULL)      { D       (void) strcpy(allocated_image->filename,image_info->filename);@       (void) strcpy(allocated_image->magick,image_info->magick);     }    return(allocated_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A n n o t a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function AnnotateImage annotates an image with test.  Optionally the K %  annotation can include the image filename, type, width, height, or scene I %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  % " %  produces an image annotation of %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % . %  The format of the AnnotateImage routine is: % 4 %      AnnotateImage(image,font,color,geometry,text) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % H %    o font: The address of a character string containing the text font. % J %    o color: The address of a character string containing the text color. % F %    o geometry: The address of a character string containing the text %      position. % J %    o text: The address of a character string containing the text format. %  %  */2 void AnnotateImage(image,font,color,geometry,text) Image 	   *image;    char   *font,	   *color,    *geometry,   *text; { 	   Display 
     *display;      int      status;      register char      *p,      *q;      unsigned int     indirection,     length;      XAnnotateInfo      annotate_info;  
   XFontStruct      *font_info;      XPixelInfo     pixel_info;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      if (text == (char *) NULL)     return;    indirection=(*text == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*         Read text from a file.       */&       file=(FILE *) fopen(text+1,"r");        if (file == (FILE *) NULL)	         { 5           Warning("Unable to read text file",text+1);            return; 	         }        length=MaxTextLength; 0       text=(char *) malloc(length*sizeof(char));/       for (q=text ; text != (char *) NULL; q++)        {          c=fgetc(file);         if (c == EOF)            break;!         if ((q-text+1) >= length)            {              *q='\0';             length<<=1; E             text=(char *) realloc((char *) text,length*sizeof(char)); &             if (text == (char *) NULL)               break;              q=text+strlen(text);           }          *q=(unsigned char) c;        }        (void) fclose(file);        if (text == (char *) NULL)	         { I           Warning("Unable to annotate image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*'     Allocate and initialize image text.    */	   p=text; $   length=strlen(text)+MaxTextLength;3   image->text=(char *) malloc(length*sizeof(char)); 8   for (q=image->text; image->text != (char *) NULL; p++)   {      if (*p == '\0')        break;0     if ((q-image->text+MaxTextLength) >= length)       {          *q='\0';         length<<=1; O         image->text=(char *) realloc((char *) image->text,length*sizeof(char)); )         if (image->text == (char *) NULL)            break;*         q=image->text+strlen(image->text);       }      /*,       Process formatting characters in text.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { +         (void) sprintf(q,"%u",image->rows); *         q=image->text+strlen(image->text);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);*         q=image->text+strlen(image->text);         break;       }        case 'w':        { .         (void) sprintf(q,"%u",image->columns);*         q=image->text+strlen(image->text);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } #   if (image->text == (char *) NULL)      { E       Warning("Unable to annotate image","Memory allocation failed"); 
       return;      }    *q++='\0';   *q++='\0';   if (indirection)     free((char *) text);   /*     Open X server connection.    */&   display=XOpenDisplay((char *) NULL);"   if (display == (Display *) NULL)     { K       Warning("Unable to connect to X server",XDisplayName((char *) NULL)); 
       return;      }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); )   resource_info.colormap=PrivateColormap;    /*     Initialize annotate info.    */#   XGetAnnotateInfo(&annotate_info);     if (geometry != (char *) NULL)     { 	       int          flags;         /*         Get position of text.        */F       flags=XParseGeometry(geometry,&annotate_info.x,&annotate_info.y,4         &annotate_info.width,&annotate_info.height);#       if ((flags & XNegative) != 0) (         annotate_info.x+=image->columns;#       if ((flags & YNegative) != 0) %         annotate_info.y+=image->rows;      } $   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    else     {        /*         Initialize visual info.        */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL;        /*         Initialize font info.        */        if (font != (char *) NULL)          resource_info.font=font;8       font_info=XBestFont(display,&resource_info,False);,       if (font_info == (XFontStruct *) NULL):         Warning("Unable to load font",resource_info.font);(       annotate_info.font_info=font_info;@       annotate_info.height=font_info->ascent+font_info->descent;     } 1   if ((map_info == (XStandardColormap *) NULL) || .       (visual_info == (XVisualInfo *) NULL) ||*       (font_info == (XFontStruct *) NULL))     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL);        DestroyImage(image);
       return;      }    /*!     Initialize Standard Colormap.    */H   XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),     map_info);   if (color != (char *) NULL) )     resource_info.foreground_color=color; K   XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,      &pixel_info); F   pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);   pixel_info.annotate_index=1;   /*     Annotate the text image.   */&   for (p=image->text; *p != '\0'; p++)   { P     if ((annotate_info.x >= image->columns) || (annotate_info.y >= image->rows))       break;     annotate_info.text=p;      for (p++; *p != '\0'; p++)       if (*p == '\n')          break;$     if ((p-annotate_info.text) == 1)       { .         annotate_info.y+=annotate_info.height;         continue;        }      *p='\0';     annotate_info.width=J       XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));L     (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",annotate_info.width,<       annotate_info.height,annotate_info.x,annotate_info.y);J     status=XAnnotateImage(display,&pixel_info,&annotate_info,False,image);     if (status == 0)       { F         Warning("Unable to annotate image","Memory allocation error");         break;       } *     annotate_info.y+=annotate_info.height;   }    /*     Free resources.    */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,3     font_info,&resource_info,(XWindowInfo *) NULL);    XCloseDisplay(display);    free(image->text);   image->text=(char *) NULL; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     B l u r I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BlurImage creates a new image that is a copy of an existing J %  one with the pixels blurred.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % F %  BlurImage convolves the pixel neighborhood with this blurring mask: % 
 %     1  2  1 
 %     2  W  2 
 %     1  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the BlurImage routine is: % , %      blurred_image=BlurImage(image,factor) % + %  A description of each parameter follows:  % G %    o blurred_image: Function BlurImage returns a pointer to the image J %      after it is blurred.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */ Image *BlurImage(image,factor) Image 	   *image;    double	   factor;  {  #define Blur(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;     Image      *blurred_image;   
   long int     total_blue,      total_green,     total_red,     weight;      register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     { C       Warning("Unable to blur image","image size must exceed 3x3");        return((Image *) NULL);      }    /*(     Initialize blurred image attributes.   */B   blurred_image=CopyImage(image,image->columns,image->rows,False);&   if (blurred_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } #   blurred_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");"       DestroyImage(blurred_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=blurred_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */*   weight=(long int) ((100.0-factor)/2-13);   quantum=Max(weight+12,1); %   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        s=s0; !       Blur(1);  Blur(2); Blur(1);        s=s1; %       Blur(2); Blur(weight); Blur(2);        s=s2; !       Blur(1);  Blur(2); Blur(1); B       q->red=(unsigned char) ((total_red+(quantum >> 1))/quantum);F       q->green=(unsigned char) ((total_green+(quantum >> 1))/quantum);D       q->blue=(unsigned char) ((total_blue+(quantum >> 1))/quantum);       q->index=0;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;   }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   return(blurred_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   B o r d e r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BorderImage takes an image and puts a border around it of a I %  particular color.  It allocates the memory necessary for the new Image H %  structure and returns a pointer to the new image.  Set the border and5 %  highlight to the same color to get a solid border.  % , %  The format of the BorderImage routine is: % A %      bordered_image=BorderImage(image,border_info,border_color)  % + %  A description of each parameter follows:  % M %    o bordered_image: Function BorderImage returns a pointer to the bordered H %      image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % I %    o border_info: Specifies a pointer to a XRectangle which defines the  %      border region.  % G %    o border_color: A pointer to a ColorPacket which contains the red, 6 %      green, and blue components of the border color. %  %  */2 Image *BorderImage(image,border_info,border_color) Image 	   *image;   
 RectangleInfo    *border_info;    ColorPacket    *border_color; {    Image      *bordered_image;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      border;      /*)     Initialize bordered image attributes.    */J   bordered_image=CopyImage(image,image->columns+(border_info->width << 1),2     image->rows+(border_info->height << 1),False);'   if (bordered_image == (Image *) NULL)      { C       Warning("Unable to border image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize border color.   */   border.red=border_color->red; #   border.green=border_color->green; !   border.blue=border_color->blue; #   border.index=border_color->index;    border.length=0;   /*(     Copy image and put border around it.   */   q=bordered_image->pixels; )   for (y=0; y < border_info->height; y++) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)    {      /*,       Initialize scanline with border color.     */*     for (x=0; x < border_info->width; x++)       *q++=border;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     }      x=0;K     while (x < (bordered_image->columns-image->columns-border_info->width))      {        *q++=border;
       x++;     }    } O   for (y=(bordered_image->rows-image->rows-border_info->height-1); y >= 0; y--) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   return(bordered_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C u t I m a g e                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ChopImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure and& %  returns a pointer to the new image. % * %  The format of the ChopImage routine is: % , %      chop_image=ChopImage(image,chop_info) % + %  A description of each parameter follows:  % C %    o chop_image: Function ChopImage returns a pointer to the chop J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o chop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */! Image *ChopImage(image,chop_info)  Image 	   *image;   
 RectangleInfo 
   *chop_info;  {    Image      *chopped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check chop geometry.   */4   if (((chop_info->x+(int) chop_info->width) < 0) ||5       ((chop_info->y+(int) chop_info->height) < 0) || .       (chop_info->x > (int) image->columns) ||)       (chop_info->y > (int) image->rows))      { H       Warning("Unable to chop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((chop_info->x+(int) chop_info->width) > (int) image->columns) H     chop_info->width=(unsigned int) ((int) image->columns-chop_info->x);A   if ((chop_info->y+(int) chop_info->height) > (int) image->rows) F     chop_info->height=(unsigned int) ((int) image->rows-chop_info->y);   if (chop_info->x < 0)      { 7       chop_info->width-=(unsigned int) (-chop_info->x);        chop_info->x=0;      }    if (chop_info->y < 0)      { 8       chop_info->height-=(unsigned int) (-chop_info->y);       chop_info->y=0;      }    /*%     Initialize chop image attributes.    */@   chopped_image=CopyImage(image,image->columns-chop_info->width,)     image->rows-chop_info->height,False); &   if (chopped_image == (Image *) NULL)     { A       Warning("Unable to chop image","Memory allocation failed");        return((Image *) NULL);      }    /*     Extract chop image.    */   p=image->pixels;   image->runlength=p->length+1;    q=chopped_image->pixels;"   for (y=0; y < chop_info->y; y++)&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      }    /*%     Skip pixels up to the chop image.    */8   for (x=0; x < (chop_info->height*image->columns); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract chop image.    */D   for (y=0; y < (image->rows-(chop_info->y+chop_info->height)); y++)&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      }    return(chopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o s e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CloseImage closes a file associated with the image.  If the H %  filename prefix is '|', the file is a pipe and is closed with pclose. % + %  The format of the CloseImage routine is:  %  %      CloseImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CloseImage(image) Image 	   *image;  {    /*     Close image file.    */#   if (image->file == (FILE *) NULL)      return; $   image->status=ferror(image->file);   if (image->pipe)     (void) pclose(image->file);    else:     if ((image->file != stdin) && (image->file != stdout))!       (void) fclose(image->file);    image->file=(FILE *) NULL; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m m e n t I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CommentImage initializes an image comment.  Optionally theH %  comment can include the image filename, type, width, height, or sceneI %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  %  %  produces an image comment of  %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % - %  The format of the CommentImage routine is:  % # %      CommentImage(image,comments)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % I %    o comments: The address of a character string containing the comment  %      format. %  %  */! void CommentImage(image,comments)  Image 	   *image;    char   *comments; {    register char      *p,      *q;      unsigned int     indirection,     length;   '   if (image->comments != (char *) NULL) #     free((char *) image->comments);     image->comments=(char *) NULL;    if (comments == (char *) NULL)     return; !   indirection=(*comments == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*"         Read comments from a file.       */*       file=(FILE *) fopen(comments+1,"r");        if (file == (FILE *) NULL)	         { =           Warning("Unable to read comments file",comments+1);            return; 	         }        length=MaxTextLength; 4       comments=(char *) malloc(length*sizeof(char));7       for (q=comments ; comments != (char *) NULL; q++)        {          c=fgetc(file);         if (c == EOF)            break;%         if ((q-comments+1) >= length)            {              *q='\0';             length<<=1; M             comments=(char *) realloc((char *) comments,length*sizeof(char)); *             if (comments == (char *) NULL)               break;(             q=comments+strlen(comments);           }          *q=(unsigned char) c;        }        (void) fclose(file);$       if (comments == (char *) NULL)	         { I           Warning("Unable to comments image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*+     Allocate and initialize image comments.    */
   p=comments; (   length=strlen(comments)+MaxTextLength;7   image->comments=(char *) malloc(length*sizeof(char)); @   for (q=image->comments; image->comments != (char *) NULL; p++)   {      if (*p == '\0')        break;4     if ((q-image->comments+MaxTextLength) >= length)       {          *q='\0';         length<<=1;           image->comments=(char *)@           realloc((char *) image->comments,length*sizeof(char));-         if (image->comments == (char *) NULL)            break;2         q=image->comments+strlen(image->comments);       }      /*0       Process formatting characters in comments.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { +         (void) sprintf(q,"%u",image->rows); 2         q=image->comments+strlen(image->comments);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);2         q=image->comments+strlen(image->comments);         break;       }        case 'w':        { .         (void) sprintf(q,"%u",image->columns);2         q=image->comments+strlen(image->comments);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } '   if (image->comments == (char *) NULL)      { D       Warning("Unable to comment image","Memory allocation failed");
       return;      } 
   *q='\0';   if (indirection)     free((char *) comments); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s C o l o r m a p                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressColormap compresses an image colormap removing any %  unused color entries. % 1 %  The format of the CompressColormap routine is:  %  %      CompressColormap(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CompressColormap(image) Image 	   *image;  { 
   ColorPacket      *colormap;     int      number_colors;     register int     i;     register RunlengthPacket     *p;      register unsigned short 
     index;     /*,     Determine if colormap can be compressed.   */"   if (image->class != PseudoClass)     return;    number_colors=image->colors;#   for (i=0; i < image->colors; i++) #     image->colormap[i].flags=False;    image->colors=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { )     if (!image->colormap[p->index].flags)        { 6         image->colormap[p->index].index=image->colors;-         image->colormap[p->index].flags=True;          image->colors++;       }      p++;   } %   if (image->colors == number_colors) $     return;  /* no unused entries */   /*     Compress colormap.   */E   colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket)); '   if (colormap == (ColorPacket *) NULL)      { H       Warning("Unable to compress colormap","Memory allocation failed");"       image->colors=number_colors;
       return;      } #   for (i=0; i < number_colors; i++) !     if (image->colormap[i].flags)        { '         index=image->colormap[i].index; 3         colormap[index].red=image->colormap[i].red; 7         colormap[index].green=image->colormap[i].green; 5         colormap[index].blue=image->colormap[i].blue;        }    /*     Remap pixels.    */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { -     p->index=image->colormap[p->index].index;      p++;   } !   free((char *) image->colormap);    image->colormap=colormap;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressImage compresses an image to the minimum number of %  runlength-encoded packets.  % . %  The format of the CompressImage routine is: %  %      CompressImage(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CompressImage(image)  Image 	   *image;  {    register int     i;     register RunlengthPacket     *p,      *q;      /*     Compress image.    */   p=image->pixels;   image->runlength=p->length+1;    image->packets=0;    q=image->pixels;   q->length=MaxRunlength;    if (image->matte) 4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && %           (q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      }    else4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && =           (p->blue == q->blue) && (q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      } C   image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, ,     image->packets*sizeof(RunlengthPacket));   /*I     Runlength-encode only if it consumes less memory than no compression.    */8   if (image->compression == RunlengthEncodedCompression)$     if (image->class == DirectClass)       { D         if (image->packets >= ((image->columns*image->rows*3) >> 2))+           image->compression=NoCompression;        }      else@       if (image->packets >= ((image->columns*image->rows) >> 1)))         image->compression=NoCompression;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p o s i t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CompositeImage returns the second image composited onto the " %  first at the specified offsets. % / %  The format of the CompositeImage routine is:  % F %      CompositeImage(image,compose,composite_image,x_offset,y_offset) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 6 %    o compose: Specifies an image composite operator. % A %    o composite_image: The address of a structure of type Image.  % N %    o x_offset: An integer that specifies the column offset of the composited
 %      image.  % K %    o y_offset: An integer that specifies the row offset of the composited 
 %      image.  %  %  */D void CompositeImage(image,compose,composite_image,x_offset,y_offset) Image 	   *image;    unsigned int
   compose;   Image    *composite_image;    int    x_offset,    y_offset;  {    int 	     blue, 
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *p,      *q;      register short
     index;     /*     Check composite geometry.    */.   if (((x_offset+(int) image->columns) < 0) ||+       ((y_offset+(int) image->rows) < 0) || J       (x_offset > (int) image->columns) || (y_offset > (int) image->rows))     { M       Warning("Unable to composite image","geometry does not contain image"); 
       return;      }    /*     Image must be uncompressed.    */   if (!UncompressImage(image))     return; $   if (compose == ReplaceCompositeOp)     {        /*9         Promote image to DirectClass if colormaps differ.        */&       if (image->class == PseudoClass)2         if (composite_image->class == DirectClass)#           image->class=DirectClass;          else           { 2             if (image->signature == (char *) NULL)'               ColormapSignature(image); <             if (composite_image->signature == (char *) NULL)1               ColormapSignature(composite_image); I             if (strcmp(image->signature,composite_image->signature) != 0) '               image->class=DirectClass;            } 2       if (image->matte && !composite_image->matte)	         { $           p=composite_image->pixels;6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;             p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      }    else     {        /*$         Initialize image matte data.       */       if (!image->matte)	         {            q=image->pixels;           red=q->red;            green=q->green;            blue=q->blue; ,           for (i=0; i < image->packets; i++)           {              q->index=Opaque;             q++;           } #           image->class=DirectClass;            image->matte=True;	         } "       if (!composite_image->matte)	         { $           p=composite_image->pixels;           red=p->red;            green=p->green;            blue=p->blue; 6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;L             if ((p->red == red) && (p->green == green) && (p->blue == blue))#               p->index=Transparent;              p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      }    /*      Initialize composited image.   */   p=composite_image->pixels;)   composite_image->runlength=p->length+1; +   for (y=0; y < composite_image->rows; y++)    { <     if (((y_offset+y) < 0) || ((y_offset+y) >= image->rows))       continue; 9     q=image->pixels+(y_offset+y)*image->columns+x_offset; 0     for (x=0; x < composite_image->columns; x++)     { *       if (composite_image->runlength != 0)%         composite_image->runlength--; 
       else	         {            p++;/           composite_image->runlength=p->length; 	         } A       if (((x_offset+x) < 0) || ((x_offset+x) >= image->columns)) 	         {            q++;           continue; 	         }        switch (compose)       {          case OverCompositeOp:          default:	         { &           if (p->index == Transparent)
             {                red=q->red;                green=q->green;                blue=q->blue;                index=q->index; 
             }            else#             if (p->index == Opaque)                {                  red=p->red;                  green=p->green;                  blue=p->blue;                  index=p->index;                }              else               { J                 red=(int) (p->red*MaxRGB+q->red*(MaxRGB-p->index))/MaxRGB;P                 green=(int) (p->green*MaxRGB+q->green*(MaxRGB-p->index))/MaxRGB;M                 blue=(int) (p->blue*MaxRGB+q->blue*(MaxRGB-p->index))/MaxRGB; P                 index=(int) (p->index*MaxRGB+q->index*(MaxRGB-p->index))/MaxRGB;               }            break;	         }          case InCompositeOp: 	         { -           red=(int) (p->red*q->index)/MaxRGB; 1           green=(int) (p->green*q->index)/MaxRGB; /           blue=(int) (p->blue*q->index)/MaxRGB; 1           index=(int) (p->index*q->index)/MaxRGB;            break;	         }          case OutCompositeOp:	         { 6           red=(int) (p->red*(MaxRGB-q->index))/MaxRGB;:           green=(int) (p->green*(MaxRGB-q->index))/MaxRGB;8           blue=(int) (p->blue*(MaxRGB-q->index))/MaxRGB;:           index=(int) (p->index*(MaxRGB-q->index))/MaxRGB;           break;	         }          case AtopCompositeOp: 	         { F           red=(int) (p->red*q->index+q->red*(MaxRGB-p->index))/MaxRGB;L           green=(int) (p->green*q->index+q->green*(MaxRGB-p->index))/MaxRGB;I           blue=(int) (p->blue*q->index+q->blue*(MaxRGB-p->index))/MaxRGB; L           index=(int) (p->index*q->index+q->index*(MaxRGB-p->index))/MaxRGB;           break;	         }          case XorCompositeOp:	         { O           red=(int) (p->red*(MaxRGB-q->index)+q->red*(MaxRGB-p->index))/MaxRGB; N           green=(int) (p->green*(MaxRGB-q->index)+q->green*(MaxRGB-p->index))/             MaxRGB; K           blue=(int) (p->blue*(MaxRGB-q->index)+q->blue*(MaxRGB-p->index))/              MaxRGB; N           index=(int) (p->index*(MaxRGB-q->index)+q->index*(MaxRGB-p->index))/             MaxRGB;            break;	         }          case PlusCompositeOp: 	         { (           red=(int) p->red+(int) q->red;.           green=(int) p->green+(int) q->green;+           blue=(int) p->blue+(int) q->blue; .           index=(int) p->index+(int) q->index;           break;	         }          case MinusCompositeOp:	         { (           red=(int) p->red-(int) q->red;.           green=(int) p->green-(int) q->green;+           blue=(int) p->blue-(int) q->blue;            index=Opaque;            break;	         }          case AddCompositeOp:	         { (           red=(int) p->red+(int) q->red;           if (red > MaxRGB)              red-=(MaxRGB+1);.           green=(int) p->green+(int) q->green;           if (green > MaxRGB)              green-=(MaxRGB+1);+           blue=(int) p->blue+(int) q->blue;            if (blue > MaxRGB)             blue-=(MaxRGB+1); .           index=(int) p->index+(int) q->index;           if (index > MaxRGB)              index-=(MaxRGB+1);           break;	         } !         case SubtractCompositeOp: 	         { (           red=(int) p->red-(int) q->red;           if (red < 0)             red+=(MaxRGB+1);.           green=(int) p->green-(int) q->green;           if (green < 0)             green+=(MaxRGB+1);+           blue=(int) p->blue-(int) q->blue;            if (blue < 0)              blue+=(MaxRGB+1); .           index=(int) p->index-(int) q->index;           if (index < 0)             index+=(MaxRGB+1);           break;	         } #         case DifferenceCompositeOp: 	         { 7           red=AbsoluteValue((int) p->red-(int) q->red); =           green=AbsoluteValue((int) p->green-(int) q->green); :           blue=AbsoluteValue((int) p->blue-(int) q->blue);=           index=AbsoluteValue((int) p->index-(int) q->index);            break;	         }           case ReplaceCompositeOp:	         {            red=p->red;            green=p->green;            blue=p->blue;            index=p->index;            break;	         }        }        if (red > MaxRGB)          q->red=MaxRGB;
       else         if (red < 0)           q->red=0;          else           q->red=red;        if (green > MaxRGB)          q->green=MaxRGB;
       else         if (green < 0)           q->green=0;          else           q->green=green;        if (blue > MaxRGB)         q->blue=MaxRGB; 
       else         if (blue < 0)            q->blue=0;         else           q->blue=blue;        if (index > Opaque)          q->index=Opaque;
       else          if (index < Transparent)           q->index=Transparent;          else           q->index=index;        q->length=0;
       q++;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C o n t r a s t I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ContrastImage enhances the intensity differences between the, %  lighter and darker elements of the image. % . %  The format of the ContrastImage routine is: % # %      ContrastImage(image,sharpen)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % C %    o sharpen: If True, the intensity is increased otherwise it is  %      decreased.  %  %  */  ) static void Contrast(sign,red,green,blue)  int    sign;   
 unsigned char    *red, 	   *green,    *blue; {    double     brightness,      hue,     minimum,     saturation, 
     theta;     register double      b,     g,     r;     /*"     Convert RGB to HSV colorspace.   */
   hue=(-1.0);    saturation=0.0; $   r=(double) (*red)/(double) MaxRGB;&   g=(double) (*green)/(double) MaxRGB;%   b=(double) (*blue)/(double) MaxRGB; 
   if (r >= g)      {        if (r >= b)          brightness=r; 
       else         brightness=b;      }    else     if (g >= b)        brightness=g;      else       brightness=b; 
   if (r <= g)      {        if (r <= b)          minimum=r;
       else         minimum=b;     }    else     if (g <= b)        minimum=g;     else       minimum=b;   if (brightness != 0.0)/     saturation=(brightness-minimum)/brightness;    if (saturation != 0.0)     {        if (r == brightness)'         hue=(g-b)/(brightness-minimum); 
       else         if (g == brightness)-           hue=2.0+(b-r)/(brightness-minimum);          else           if (b == brightness)/             hue=4.0+(r-g)/(brightness-minimum);        hue=hue*60.0;        if (hue < 0.0)         hue+=360.0;      }    /*K     Enhance contrast: dark color become darker, light color become lighter.    */   theta=(brightness-0.5)*M_PI;?   brightness+=(((((sin(theta)+1.0))*0.5)-brightness)*sign)*0.5;    if (brightness > 1.0)      brightness=1.0;    else     if (brightness < 0)        brightness=0.0;    /*     Convert HSV to RGB   */   r=brightness;    g=brightness;    b=brightness; +   if ((hue != -1.0) && (saturation != 0.0))      {        double
         f,
         j,
         k,
         l,
         v;  	       int 
         i;         if (hue == 360.0)          hue=0.0;       hue=hue/60.0;        i=floor(hue);        if (i < 0)         i=0;       f=hue-i;$       j=brightness*(1.0-saturation);(       k=brightness*(1.0-(saturation*f));.       l=brightness*(1.0-(saturation*(1.0-f)));       v=brightness;        switch (i)       { )         case 0:  r=v;  g=l;  b=j;  break; )         case 1:  r=k;  g=v;  b=j;  break; )         case 2:  r=j;  g=v;  b=l;  break; )         case 3:  r=j;  g=k;  b=v;  break; )         case 4:  r=l;  g=j;  b=v;  break; )         case 5:  r=v;  g=j;  b=k;  break;        }      } 6   *red=(unsigned char) floor((r*(double) MaxRGB)+0.5);8   *green=(unsigned char) floor((g*(double) MaxRGB)+0.5);7   *blue=(unsigned char) floor((b*(double) MaxRGB)+0.5);  }   ! void ContrastImage(image,sharpen)  Image 	   *image;    unsigned int
   sharpen; {    int 	     sign;      register int     i;     register RunlengthPacket     *p;      sign=sharpen ? 1 : -1;   switch (image->class)    {      case DirectClass:      {        /*+         Contrast enhance DirectClass image.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { 2         Contrast(sign,&p->red,&p->green,&p->blue);         p++;       }        break;     }      case PseudoClass:      {        /*+         Contrast enhance PseudoClass image.        */'       for (i=0; i < image->colors; i++) H         Contrast(sign,&image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o p y I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function CopyImage returns a copy of all fields of the input image.  The B %  the pixel memory is allocated but the pixel data is not copied. % * %  The format of the CopyImage routine is: % ; %      copy_image=CopyImage(image,columns,rows,copy_pixels)  % + %  A description of each parameter follows:  % J %    o copy_image: Function CopyImage returns a pointer to the image afterH %      copying.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the copied 
 %      image.  % G %    o rows: An integer that specifies the number of rows in the copied 
 %      image.  % H %    o copy_pixels: Specifies whether the pixel data is copied.  Must be %      either True or False; %  %  */0 Image *CopyImage(image,columns,rows,copy_pixels) Image 	   *image;    unsigned int
   columns,   rows,    copy_pixels; {    Image      *copy_image;     register int     i;     /*     Allocate image structure.    */-   copy_image=(Image *) malloc(sizeof(Image)); #   if (copy_image == (Image *) NULL)      return((Image *) NULL);    *copy_image=(*image); '   if (image->comments != (char *) NULL)      {        /*-         Allocate and copy the image comments.        */#       copy_image->comments=(char *) ;         malloc(((strlen(image->comments)+1)*sizeof(char))); 0       if (copy_image->comments == (char *) NULL)         return((Image *) NULL); :       (void) strcpy(copy_image->comments,image->comments);     } $   if (image->label != (char *) NULL)     {        /**         Allocate and copy the image label.       */        copy_image->label=(char *)8         malloc(((strlen(image->label)+1)*sizeof(char)));-       if (copy_image->label == (char *) NULL)          return((Image *) NULL); 4       (void) strcpy(copy_image->label,image->label);     }    copy_image->columns=columns;   copy_image->rows=rows;$   copy_image->montage=(char *) NULL;&   copy_image->directory=(char *) NULL;.   if (image->colormap != (ColorPacket *) NULL)     {        /*-         Allocate and copy the image colormap.        */*       copy_image->colormap=(ColorPacket *)2         malloc(image->colors*sizeof(ColorPacket));7       if (copy_image->colormap == (ColorPacket *) NULL)          return((Image *) NULL); '       for (i=0; i < image->colors; i++) 3         copy_image->colormap[i]=image->colormap[i];      } (   if (image->signature != (char *) NULL)     {        /*.         Allocate and copy the image signature.       */$       copy_image->signature=(char *)<         malloc(((strlen(image->signature)+1)*sizeof(char)));1       if (copy_image->signature == (char *) NULL)          return((Image *) NULL); <       (void) strcpy(copy_image->signature,image->signature);     }    /*     Allocate the image pixels.   */   if (!copy_pixels) =     copy_image->packets=copy_image->columns*copy_image->rows; (   copy_image->pixels=(RunlengthPacket *)G     malloc((unsigned int) copy_image->packets*sizeof(RunlengthPacket)); 5   if (copy_image->pixels == (RunlengthPacket *) NULL)      return((Image *) NULL);    if (copy_pixels)     {        register RunlengthPacket         *p,          *q;   ?       if ((image->columns != columns) || (image->rows != rows))          return((Image *) NULL);        /*         Copy the image pixels.       */       p=image->pixels;       q=copy_image->pixels; (       for (i=0; i < image->packets; i++)       {          *q=(*p);         p++;         q++;       }      }    if (image->orphan)#     copy_image->file=(FILE *) NULL;    else     {        /*#         Link image into image list.        */1       if (copy_image->previous != (Image *) NULL) .         copy_image->previous->next=copy_image;-       if (copy_image->next != (Image *) NULL) .         copy_image->next->previous=copy_image;     }    copy_image->orphan=False;    return(copy_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C r o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function CropImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure and& %  returns a pointer to the new image. % * %  The format of the CropImage routine is: % / %      cropped_image=CropImage(image,crop_info)  % + %  A description of each parameter follows:  % I %    o cropped_image: Function CropImage returns a pointer to the cropped J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o crop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */! Image *CropImage(image,crop_info)  Image 	   *image;   
 RectangleInfo 
   *crop_info;  {    Image      *cropped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      background;      /*     Check crop geometry.   */4   if (((crop_info->x+(int) crop_info->width) < 0) ||5       ((crop_info->y+(int) crop_info->height) < 0) || .       (crop_info->x > (int) image->columns) ||)       (crop_info->y > (int) image->rows))      { H       Warning("Unable to crop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((crop_info->x+(int) crop_info->width) > (int) image->columns) H     crop_info->width=(unsigned int) ((int) image->columns-crop_info->x);A   if ((crop_info->y+(int) crop_info->height) > (int) image->rows) F     crop_info->height=(unsigned int) ((int) image->rows-crop_info->y);   if (crop_info->x < 0)      { 7       crop_info->width-=(unsigned int) (-crop_info->x);        crop_info->x=0;      }    if (crop_info->y < 0)      { 8       crop_info->height-=(unsigned int) (-crop_info->y);       crop_info->y=0;      } :   if ((crop_info->width == 0) && (crop_info->height == 0))     {        /*<         Remove vertical edges that are the background color.       */"       if (!UncompressImage(image))         return((Image *) NULL); "       background=image->pixels[0];(       for (x=0; x < image->columns; x++)       {          p=image->pixels+x;'         for (y=0; y < image->rows; y++) 	         { M           if ((p->red != background.red) || (p->green != background.green) || +               (p->blue != background.blue))              break;           p+=image->columns;	         }          if (y < image->rows)           break;       }        crop_info->x=x; /       if (crop_info->x == (int) image->columns) 	         { L           Warning("Unable to crop image","geometry does not contain image");!           return((Image *) NULL); 	         } 1       background=image->pixels[image->packets-1]; *       for (x=image->columns-1; x > 0; x--)       {          p=image->pixels+x;'         for (y=0; y < image->rows; y++) 	         { M           if ((p->red != background.red) || (p->green != background.green) || +               (p->blue != background.blue))              break;           p+=image->columns;	         }          if (y < image->rows)           break;       } (       crop_info->width=x-crop_info->x+1;       /*>         Remove horizontal edges that are the background color.       */"       background=image->pixels[0];       p=image->pixels;%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { M           if ((p->red != background.red) || (p->green != background.green) || +               (p->blue != background.blue))              break;           p++;	         }          if (x < image->columns)            break;       }        crop_info->y=y; 1       background=image->pixels[image->packets-1]; 5       p=image->pixels+(image->columns*image->rows)-1; '       for (y=image->rows-1; y > 0; y--)        { *         for (x=0; x < image->columns; x++)	         { M           if ((p->red != background.red) || (p->green != background.green) || +               (p->blue != background.blue))              break;           p--;	         }          if (x < image->columns)            break;       } )       crop_info->height=y-crop_info->y+1;      } :   if ((crop_info->width == 0) || (crop_info->height == 0))     { E       Warning("Unable to crop image","geometry dimensions are zero");        return((Image *) NULL);      }    /*(     Initialize cropped image attributes.   */J   cropped_image=CopyImage(image,crop_info->width,crop_info->height,False);&   if (cropped_image == (Image *) NULL)     { A       Warning("Unable to crop image","Memory allocation failed");        return((Image *) NULL);      }    /*(     Skip pixels up to the cropped image.   */   p=image->pixels;   image->runlength=p->length+1; @   for (x=0; x < (crop_info->y*image->columns+crop_info->x); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract cropped image.   */   q=cropped_image->pixels;-   for (y=0; y < (cropped_image->rows-1); y++)    {      /*       Transfer scanline.     */.     for (x=0; x < cropped_image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     }      /*       Skip to next scanline.     */?     for (x=0; x < (image->columns-cropped_image->columns); x++)         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }    }    /*     Transfer last scanline.    */,   for (x=0; x < cropped_image->columns; x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *q=(*p);     q->length=0;     q++;   }    return(cropped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s c r i b e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DescribeImage describes an image by printing its attributes to
 %  stderr. % . %  The format of the DescribeImage routine is: %  %      DescribeImage(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DescribeImage(image)  Image 	   *image;  {    /**     Display detailed info about the image.   */&   if (*image->magick_filename != '\0')<     if (strcmp(image->magick_filename,image->filename) != 0);       (void) fprintf(stderr,"%s=>",image->magick_filename); P    if ((image->previous == (Image *) NULL) && (image->next == (Image *) NULL) &&        (image->scene == 0)) 1     (void) fprintf(stderr,"%s ",image->filename);    elseB     (void) fprintf(stderr,"%s[%u] ",image->filename,image->scene);@   if ((image->magick_columns != 0) || (image->magick_rows != 0))4     if ((image->magick_columns != image->columns) ||,         (image->magick_rows != image->rows))P       (void) fprintf(stderr,"%ux%u=>",image->magick_columns,image->magick_rows);=   (void) fprintf(stderr,"%ux%u ",image->columns,image->rows); "   if (image->class == DirectClass)     { ,       (void) fprintf(stderr,"DirectClass ");#       if (image->total_colors != 0) ;         (void) fprintf(stderr,"%luc ",image->total_colors);      }    else-     if (image->total_colors <= image->colors) >       (void) fprintf(stderr,"PseudoClass %uc ",image->colors);     else       { J         (void) fprintf(stderr,"PseudoClass %lu=>%uc ",image->total_colors,           image->colors); K         (void) fprintf(stderr,"%u/%.6f/%.6fe ",image->mean_error_per_pixel, H           image->normalized_mean_error,image->normalized_maximum_error);       }    if (image->filesize != 0) 3     (void) fprintf(stderr,"%lub ",image->filesize); H   (void) fprintf(stderr,"%s %lds\n",image->magick,time((time_t *) NULL)-     image->magick_time+1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     D e s p e c k l e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function DespeckleImage creates a new image that is a copy of an existingH %  one with the speckle noise reduced.  It uses the eight hull algorithmO %  described in Applied Optics, Vol. 24, No. 10, 15 May 1985, "Geometric filter L %  for Speckle Reduction", by Thomas R Crimmins.  Each pixel in the image isN %  replaced by one of its eight of its surrounding pixels using a polarity andM %  negative hull function.  DespeckleImage allocates the memory necessary for B %  the new Image structure and returns a pointer to the new image. % / %  The format of the DespeckleImage routine is:  % - %      despeckled_image=DespeckleImage(image)  % + %  A description of each parameter follows:  % O %    o despeckled_image: Function DespeckleImage returns a pointer to the image M %      after it is despeckled.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  = static void Hull(x_offset,y_offset,polarity,columns,rows,f,g)  int    x_offset,    y_offset,    polarity;    unsigned int
   columns,   rows;   
 unsigned char    *f,    *g;  {    int      y;     register int     x;     register unsigned char     *p,      *q,      *r,      *s;      unsigned char      v;     p=f+(columns+2);   q=g+(columns+2);,   r=p+(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*p);          if (*r > v)            v++;
         *q=v;          p++;         q++;         r++;       }      else!       for (x=0; x < columns; x++)        {          v=(*p); '         if (v > (unsigned char) (*r+1))            v--;
         *q=v;          p++;         q++;         r++;       }      p++;     q++;     r++;   }    p=f+(columns+2);   q=g+(columns+2);,   r=q+(y_offset*((int) columns+2)+x_offset);,   s=q-(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     s++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*q); 5         if (((unsigned char) (*s+1) > v) && (*r > v))            v++;
         *p=v;          p++;         q++;         r++;         s++;       }      else!       for (x=0; x < columns; x++)        {          v=(*q); 5         if (((unsigned char) (*s+1) < v) && (*r < v))            v--;
         *p=v;          p++;         q++;         r++;         s++;       }      p++;     q++;     r++;     s++;   }  }    Image *DespeckleImage(image) Image 	   *image;  {    Image      *despeckled_image;     int      x;     register int     i,     j;     register RunlengthPacket     *p,      *q;      static int     X[4]= {0, 1, 1,-1},      Y[4]= {1, 0, 1, 1};      unsigned char      *blue_channel,     *buffer,     *green_channel,      *red_channel;      unsigned int     packets;     /*     Allocate despeckled image.   */E   despeckled_image=CopyImage(image,image->columns,image->rows,False); )   if (despeckled_image == (Image *) NULL)      { F       Warning("Unable to despeckle image","Memory allocation failed");       return((Image *) NULL);      } &   despeckled_image->class=DirectClass;   /*     Allocate image buffers.    */-   packets=(image->columns+2)*(image->rows+2); 0   red_channel=(unsigned char *) malloc(packets);2   green_channel=(unsigned char *) malloc(packets);1   blue_channel=(unsigned char *) malloc(packets); +   buffer=(unsigned char *) malloc(packets); 0   if ((red_channel == (unsigned char *) NULL) ||2       (green_channel == (unsigned char *) NULL) ||1       (blue_channel == (unsigned char *) NULL) || D       (buffer == (unsigned char *) NULL) || !UncompressImage(image))     { F       Warning("Unable to despeckle image","Memory allocation failed");%       DestroyImage(despeckled_image);        return((Image *) NULL);      }    /*     Zero image buffers.    */   for (i=0; i < packets; i++)    {      red_channel[i]=0;      green_channel[i]=0;      blue_channel[i]=0;     buffer[i]=0;   }    /*0     Copy image pixels to color component buffers   */   x=image->columns+2;    p=image->pixels;!   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        red_channel[x]=p->red;        green_channel[x]=p->green;       blue_channel[x]=p->blue;
       x++;
       p++;     }      x++;   }    /*"     Reduce speckle in red channel.   */   for (i=0; i < 4; i++)    { D     Hull(X[i],Y[i],1,image->columns,image->rows,red_channel,buffer);F     Hull(-X[i],-Y[i],1,image->columns,image->rows,red_channel,buffer);G     Hull(-X[i],-Y[i],-1,image->columns,image->rows,red_channel,buffer); E     Hull(X[i],Y[i],-1,image->columns,image->rows,red_channel,buffer);    }    /*$     Reduce speckle in green channel.   */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { F     Hull(X[i],Y[i],1,image->columns,image->rows,green_channel,buffer);H     Hull(-X[i],-Y[i],1,image->columns,image->rows,green_channel,buffer);I     Hull(-X[i],-Y[i],-1,image->columns,image->rows,green_channel,buffer); G     Hull(X[i],Y[i],-1,image->columns,image->rows,green_channel,buffer);    }    /*#     Reduce speckle in blue channel.    */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { E     Hull(X[i],Y[i],1,image->columns,image->rows,blue_channel,buffer); G     Hull(-X[i],-Y[i],1,image->columns,image->rows,blue_channel,buffer); H     Hull(-X[i],-Y[i],-1,image->columns,image->rows,blue_channel,buffer);F     Hull(X[i],Y[i],-1,image->columns,image->rows,blue_channel,buffer);   }    /*5     Copy color component buffers to despeckled image.    */   x=image->columns+2;    q=despeckled_image->pixels; !   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        q->red=red_channel[x];        q->green=green_channel[x];       q->blue=blue_channel[x];       q->index=0;        q->length=0;
       q++;
       x++;     }      x++;   }    /*     Free memory.   */   free((char *) buffer);   free((char *) blue_channel);   free((char *) green_channel);    free((char *) red_channel);    return(despeckled_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function DestroyImage deallocates memory associated with an image.  % - %  The format of the DestroyImage routine is:  %  %      DestroyImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DestroyImage(image) Image 	   *image;  {    /*     Close image.   */   CloseImage(image);   /*"     Deallocate the image comments.   */'   if (image->comments != (char *) NULL) #     free((char *) image->comments);    /*     Deallocate the image label.    */$   if (image->label != (char *) NULL)      free((char *) image->label);   /*+     Deallocate the image montage directory.    */&   if (image->montage != (char *) NULL)"     free((char *) image->montage);(   if (image->directory != (char *) NULL)$     free((char *) image->directory);   /*"     Deallocate the image colormap.   */.   if (image->colormap != (ColorPacket *) NULL)#     free((char *) image->colormap);    /*#     Deallocate the image signature.    */(   if (image->signature != (char *) NULL)$     free((char *) image->signature);   /*      Deallocate the image pixels.   */0   if (image->pixels != (RunlengthPacket *) NULL)!     free((char *) image->pixels); 5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);   /*#     Deallocate the image structure.    */   free((char *) image);    image=(Image *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DestroyImages deallocates memory associated with a linked list
 %  of images.  % . %  The format of the DestroyImages routine is: %  %      DestroyImages(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DestroyImages(image)  Image 	   *image;  {    Image      *next_image;     /*)     Proceed to the top of the image list.    */+   while (image->previous != (Image *) NULL)      image=image->previous;   do   {      /*       Destroy this image.      */     next_image=image->next;      DestroyImage(image);     image=next_image; $   } while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E m b o s s I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function EmbossImage creates a new image that is a copy of an existing L %  one with the edge highlighted.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % N %  EmbossImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1 -2  0 
 %    -2  0  2 
 %     0  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % , %  The format of the EmbossImage routine is: % ( %      embossed_image=EmbossImage(image) % + %  A description of each parameter follows:  % J %    o embossed_image: Function EmbossImage returns a pointer to the imageK %      after it is embossed.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ Image *EmbossImage(image)  Image 	   *image;  {  #define Emboss(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;     Image      *embossed_image;  
   long int     total_blue,      total_green,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to emboss image","image size must exceed 3x3");        return((Image *) NULL);      }    /*)     Initialize embossed image attributes.    */C   embossed_image=CopyImage(image,image->columns,image->rows,False); '   if (embossed_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   embossed_image->class=DirectClass;   /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(embossed_image);        return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=embossed_image->pixels; $   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */%   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0; 
       s=s1+1;        s=s0; )       Emboss(-1); Emboss(-2); Emboss( 0);        s=s1; )       Emboss(-2); Emboss( 0); Emboss( 2);        s=s2; )       Emboss( 0); Emboss( 2); Emboss( 1); !       total_red+=(MaxRGB+1) >> 1;        if (total_red < 0)         total_red=0;
       else         if (total_red > MaxRGB)            total_red=MaxRGB; #       total_green+=(MaxRGB+1) >> 1;        if (total_green < 0)         total_green=0;
       else!         if (total_green > MaxRGB)            total_green=MaxRGB; "       total_blue+=(MaxRGB+1) >> 1;       if (total_blue < 0)          total_blue=0; 
       else          if (total_blue > MaxRGB)           total_blue=MaxRGB;'       q->red=(unsigned char) total_red; +       q->green=(unsigned char) total_green; )       q->blue=(unsigned char) total_blue;        q->index=0;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;   }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*-     Convert image to Grayscale and normalize.    */%   (void) IsGrayImage(embossed_image); !   NormalizeImage(embossed_image);    return(embossed_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E d g e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function EdgeImage creates a new image that is a copy of an existing M %  one with the edges highlighted.  It allocates the memory necessary for the > %  new Image structure and returns a pointer to the new image. % L %  EdgeImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1 -2  0 
 %    -2  0  2 
 %     0  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the EdgeImage routine is: % # %      edged_image=EdgeImage(image)  % + %  A description of each parameter follows:  % E %    o edged_image: Function EdgeImage returns a pointer to the image H %      after it is edged.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ Image *EdgeImage(image)  Image 	   *image;  {  #define Edge(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;     Image      *edged_image;   
   long int     total_blue,      total_green,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to detect edges","image size must exceed 3x3");        return((Image *) NULL);      }    /*&     Initialize edged image attributes.   */@   edged_image=CopyImage(image,image->columns,image->rows,False);$   if (edged_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } !   edged_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");        DestroyImage(edged_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=edged_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */%   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0; 
       s=s1+1;        s=s0; #       Edge(-1); Edge(-2); Edge( 0);        s=s1; #       Edge(-2); Edge( 0); Edge( 2);        s=s2; #       Edge( 0); Edge( 2); Edge( 1);        if (total_red < 0)         total_red=(-total_red);        if (total_red > MaxRGB)          total_red=MaxRGB;        if (total_green < 0)#         total_green=(-total_green);        if (total_green > MaxRGB)          total_green=MaxRGB;        if (total_blue < 0) !         total_blue=(-total_blue);        if (total_blue > MaxRGB)         total_blue=MaxRGB;'       q->red=(unsigned char) total_red; +       q->green=(unsigned char) total_green; )       q->blue=(unsigned char) total_blue;        q->index=0;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;   }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*     Normalize image.   */   NormalizeImage(edged_image);   return(edged_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E n h a n c e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EnhanceImage creates a new image that is a copy of an existingM %  one with the noise reduced.  It allocates the memory necessary for the new : %  Image structure and returns a pointer to the new image. % K %  EnhanceImage does a weighted average of pixels in a 5x5 cell around each L %  target pixel.  Only pixels in the 5x5 cell that are within a RGB distance. %  threshold of the target pixel are averaged. % G %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % - %  The format of the EnhanceImage routine is:  % ) %      enhanced_image=EnhanceImage(image)  % + %  A description of each parameter follows:  % K %    o enhanced_image: Function EnhanceImage returns a pointer to the image K %      after it is enhanced.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ Image *EnhanceImage(image) Image 	   *image;  {  #define Enhance(weight) \    red_distance=s->red-red; \"   green_distance=s->green-green; \   blue_distance=s->blue-blue; \ E   distance=red_distance*red_distance+green_distance*green_distance+ \ "     blue_distance*blue_distance; \   if (distance < Threshold) \      { \ %       total_red+=(weight)*(s->red); \ )       total_green+=(weight)*(s->green); \ '       total_blue+=(weight)*(s->blue); \        total_weight+=(weight); \      } \    s++; #define Threshold  2500      Image      *enhanced_image;     int      blue_distance,     green_distance,      red_distance;      register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2,     *s3,     *s4;     register unsigned int      x;     RunlengthPacket      *scanline;     unsigned char 	     blue, 
     green,     red;     unsigned int     y;     unsigned long 
     distance,      total_blue,      total_green,     total_red,     total_weight;   0   if ((image->columns < 5) || (image->rows < 5))     { F       Warning("Unable to enhance image","image size must exceed 4x4");       return((Image *) NULL);      }    /*)     Initialize enhanced image attributes.    */C   enhanced_image=CopyImage(image,image->columns,image->rows,False); '   if (enhanced_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   enhanced_image->class=DirectClass;   /*6     Allocate scan line buffer for 5 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(5*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(enhanced_image);        return((Image *) NULL);      }    /*'     Read the first 4 rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; (   for (x=0; x < (image->columns*4); x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*$     Dump first 2 scanlines of image.   */   q=enhanced_image->pixels; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    /*     Enhance each row.    */%   for (y=2; y < (image->rows-2); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-2) % 5); +     s1=scanline+image->columns*((y-1) % 5); '     s2=scanline+image->columns*(y % 5); +     s3=scanline+image->columns*((y+1) % 5); +     s4=scanline+image->columns*((y+2) % 5);      /*       Read another scan line.      */	     s=s4; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*.       Transfer first 2 pixels of the scanline.     */	     s=s2;      for (x=0; x < 2; x++)      {        *q=(*s);       q->length=0;
       q++;
       s++;     } *     for (x=2; x < (image->columns-2); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        total_weight=0; 
       s=s2+2;        red=s->red;        green=s->green;        blue=s->blue;        s=s0; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5);        s=s1; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=s2; F       Enhance(10); Enhance(40); Enhance(80); Enhance(40); Enhance(10);       s=s3; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=s4; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5); N       q->red=(unsigned char) ((total_red+(total_weight >> 1)-1)/total_weight);       q->green= K         (unsigned char) ((total_green+(total_weight >> 1)-1)/total_weight); P       q->blue=(unsigned char) ((total_blue+(total_weight >> 1)-1)/total_weight);       q->index=0;        q->length=0;
       q++;       s0++;        s1++;        s2++;        s3++;        s4++;      }      /*-       Transfer last 2 pixels of the scanline.      */	     s=s2;      for (x=0; x < 2; x++)      {        *q=(*s);       q->length=0;
       q++;
       s++;     }    }    /*$     Dump last 2 scanlines of pixels.   */$   s=scanline+image->columns*(y % 5);+   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    free((char *) scanline);   return(enhanced_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E q u a l i z e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EqualizeImage performs histogram equalization on the reference	 %  image.  % . %  The format of the EqualizeImage routine is: %  %      EqualizeImage(image)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ void EqualizeImage(image)  Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      unsigned char      *equalize_map;     unsigned int	     high,      *histogram,      low,	     *map;      /*-     Allocate and initialize histogram arrays.    */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); ?   map=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); J   equalize_map=(unsigned char *) malloc((MaxRGB+1)*sizeof(unsigned char));-   if ((histogram == (unsigned int *) NULL) || '       (map == (unsigned int *) NULL) || /       (equalize_map == (unsigned char *) NULL))      { E       Warning("Unable to equalize image","Memory allocation failed"); 
       return;      }    /*     Form histogram.    */   for (i=0; i <= MaxRGB; i++)      histogram[i]=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)   { ,     histogram[Intensity(*p)]+=(p->length+1);     p++;   }    /*8     Integrate the histogram to get the equalization map.   */   j=0;   for (i=0; i <= MaxRGB; i++)    {      j+=histogram[i];
     map[i]=j;    }    free((char *) histogram);    if (map[MaxRGB] == 0)      { "       free((char *) equalize_map);       free((char *) map); 
       return;      }    /*
     Equalize.    */
   low=map[0];    high=map[MaxRGB];    for (i=0; i <= MaxRGB; i++) N     equalize_map[i]=(unsigned char) ((((map[i]-low))*MaxRGB)/Max(high-low,1));   free((char *) map);    /*     Stretch the histogram.   */   switch (image->class)    {      case DirectClass:      {        /*%         Equalize DirectClass packets.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { $         p->red=equalize_map[p->red];(         p->green=equalize_map[p->green];&         p->blue=equalize_map[p->blue];         p++;       }        break;     }      case PseudoClass:      {        /*%         Equalize PseudoClass packets.        */'       for (i=0; i < image->colors; i++)        { D         image->colormap[i].red=equalize_map[image->colormap[i].red];H         image->colormap[i].green=equalize_map[image->colormap[i].green];F         image->colormap[i].blue=equalize_map[image->colormap[i].blue];       }        SyncImage(image);        break;     }    }    free((char *) equalize_map); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F l i p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function FlipImage creates a new image that reflects each scanline in theI %  vertical direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % * %  The format of the FlipImage routine is: % % %      flipped_image=FlipImage(image)  % + %  A description of each parameter follows:  % G %    o flipped_image: Function FlipImage returns a pointer to the image G %      after reflecting.  A null image is returned if there is a memory  %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *FlipImage(image)  Image 	   *image;  {    Image      *flipped_image;      register RunlengthPacket     *p,      *q,      *s;      register unsigned int      x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flipped image attributes.   */B   flipped_image=CopyImage(image,image->columns,image->rows,False);&   if (flipped_image == (Image *) NULL)     { A       Warning("Unable to flip image","Memory allocation failed");        return((Image *) NULL);      }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flipped_image);       return((Image *) NULL);      }    /*     Flip each row.   */   p=image->pixels;   image->runlength=p->length+1; 3   q=flipped_image->pixels+flipped_image->packets-1; )   for (y=0; y < flipped_image->rows; y++)    {      /*       Read a scan line.      */     s=scanline; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*       Flip each column.      */     s=scanline+image->columns;.     for (x=0; x < flipped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q--;     }    }    free((char *) scanline);   return(flipped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F l o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function FlopImage creates a new image that reflects each scanline in theK %  horizontal direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % * %  The format of the FlopImage routine is: % % %      flopped_image=FlopImage(image)  % + %  A description of each parameter follows:  % G %    o flopped_image: Function FlopImage returns a pointer to the image G %      after reflecting.  A null image is returned if there is a memory  %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *FlopImage(image)  Image 	   *image;  {    Image      *flopped_image;      register RunlengthPacket     *p,      *q,      *s;      register unsigned int      x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flopped image attributes.   */B   flopped_image=CopyImage(image,image->columns,image->rows,False);&   if (flopped_image == (Image *) NULL)     { D       Warning("Unable to reflect image","Memory allocation failed");       return((Image *) NULL);      }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flopped_image);       return((Image *) NULL);      }    /*     Flop each row.   */   p=image->pixels;   image->runlength=p->length+1;    q=flopped_image->pixels;)   for (y=0; y < flopped_image->rows; y++)    {      /*       Read a scan line.      */     s=scanline; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*       Flop each column.      */     s=scanline+image->columns;.     for (x=0; x < flopped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q++;     }    }    free((char *) scanline);   return(flopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F r a m e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function FrameImage takes an image and puts a frame around it of a I %  particular color.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % + %  The format of the FrameImage routine is:  % H %      framed_image=FrameImage(image,frame_info,bevel_width,matte_color,& %        highlight_color,shadow_color) % + %  A description of each parameter follows:  % H %    o framed_image: Function FrameImage returns a pointer to the framedH %      image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % H %    o frame_info: Specifies a pointer to a XRectangle which defines the %      framed region.  % J %    o bevel_width: An unsigned integer that is the width of the border of %      the frame.  % F %    o matte_color: A pointer to a ColorPacket which contains the red,6 %      green, and blue components of the border color. % J %    o highlight_color: A pointer to a ColorPacket which contains the red,9 %      green, and blue components of the highlight color.  % G %    o shadow_color: A pointer to a ColorPacket which contains the red, 6 %      green, and blue components of the shadow color. %  %  */K Image *FrameImage(image,frame_info,bevel_width,matte_color,highlight_color,    shadow_color)  Image 	   *image;   
 RectangleInfo    *frame_info;   unsigned int   bevel_width;   ColorPacket    *matte_color,    *highlight_color,    *shadow_color; {    Image      *framed_image;     int      height, 
     width;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket 
     black,     highlight,
     matte,     shadow;      /*     Check frame geometry.    */A   width=(int) frame_info->width-frame_info->x-(bevel_width << 1); C   height=(int) frame_info->height-frame_info->y-(bevel_width << 1); 9   if ((width < image->columns) || (height < image->rows))      { G       Warning("Unable to frame image","frame is less than image size");        return((Image *) NULL);      }    /*'     Initialize framed image attributes.    */K   framed_image=CopyImage(image,frame_info->width,frame_info->height,False); %   if (framed_image == (Image *) NULL)      { C       Warning("Unable to border image","Memory allocation failed");        return((Image *) NULL);      }    image->class=DirectClass;    /*     Initialize frame colors.   */   black.red=0;   black.green=0;   black.blue=0;    black.index=0;   black.length=0;    matte.red=matte_color->red; !   matte.green=matte_color->green;    matte.blue=matte_color->blue;    matte.index=0;   matte.length=0; %   highlight.red=highlight_color->red; )   highlight.green=highlight_color->green; '   highlight.blue=highlight_color->blue;    highlight.index=0;   highlight.length=0;    shadow.red=shadow_color->red; #   shadow.green=shadow_color->green; !   shadow.blue=shadow_color->blue;    shadow.index=0;    shadow.length=0;   /*6     Copy image and put an ornamental border around it.   */   q=framed_image->pixels; +   for (x=0; x < framed_image->columns; x++)      *q++=black; %   for (y=0; y < (bevel_width-1); y++)    {      *q++=black; 3     for (x=0; x < (framed_image->columns-y-2); x++)        *q++=highlight; /     for ( ; x < (framed_image->columns-2); x++)        *q++=shadow;     *q++=black;    } 8   for (y=0; y < (frame_info->y-(bevel_width << 1)); y++)   {      *q++=black; '     for (x=0; x < (bevel_width-1); x++)        *q++=highlight; B     for (x=0; x < (framed_image->columns-(bevel_width << 1)); x++)       *q++=matte; '     for (x=0; x < (bevel_width-1); x++)        *q++=shadow;     *q++=black;    } %   for (y=0; y < (bevel_width-1); y++)    {      *q++=black; '     for (x=0; x < (bevel_width-1); x++)        *q++=highlight; :     for (x=0; x < (frame_info->x-(bevel_width << 1)); x++)       *q++=matte; =     for (x=0; x < (image->columns+(bevel_width << 1)-y); x++)        *q++=shadow;9     for ( ; x < (image->columns+(bevel_width << 1)); x++)        *q++=highlight; L     width=frame_info->width-frame_info->x-image->columns-(bevel_width << 1);     for (x=0; x < width; x++)        *q++=matte; '     for (x=0; x < (bevel_width-1); x++)        *q++=shadow;     *q++=black;    } 
   *q++=black; %   for (x=0; x < (bevel_width-1); x++)      *q++=highlight; 8   for (x=0; x < (frame_info->x-(bevel_width << 1)); x++)     *q++=matte; %   for (x=0; x < (bevel_width-1); x++)      *q++=shadow;(   for (x=0; x < (image->columns+2); x++)     *q++=black; %   for (x=0; x < (bevel_width-1); x++)      *q++=highlight; J   width=frame_info->width-frame_info->x-image->columns-(bevel_width << 1);   for (x=0; x < width; x++)      *q++=matte; %   for (x=0; x < (bevel_width-1); x++)      *q++=shadow;
   *q++=black;    p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)    {      /*,       Initialize scanline with border color.     */     *q++=black; '     for (x=0; x < (bevel_width-1); x++)        *q++=highlight; :     for (x=0; x < (frame_info->x-(bevel_width << 1)); x++)       *q++=matte; '     for (x=0; x < (bevel_width-1); x++)        *q++=shadow;     *q++=black;      /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     }      *q++=black; '     for (x=0; x < (bevel_width-1); x++)        *q++=highlight; L     width=frame_info->width-frame_info->x-image->columns-(bevel_width << 1);     for (x=0; x < width; x++)        *q++=matte; '     for (x=0; x < (bevel_width-1); x++)        *q++=shadow;     *q++=black;    } 
   *q++=black; %   for (x=0; x < (bevel_width-1); x++)      *q++=highlight; 8   for (x=0; x < (frame_info->x-(bevel_width << 1)); x++)     *q++=matte; %   for (x=0; x < (bevel_width-1); x++)      *q++=shadow;(   for (x=0; x < (image->columns+2); x++)     *q++=black; %   for (x=0; x < (bevel_width-1); x++)      *q++=highlight; J   width=frame_info->width-frame_info->x-image->columns-(bevel_width << 1);   for (x=0; x < width; x++)      *q++=matte; %   for (x=0; x < (bevel_width-1); x++)      *q++=shadow;
   *q++=black; $   for (y=bevel_width-2; y >= 0; y--)   {      *q++=black; '     for (x=0; x < (bevel_width-1); x++)        *q++=highlight; :     for (x=0; x < (frame_info->x-(bevel_width << 1)); x++)       *q++=matte;      for (x=0; x < y; x++)        *q++=shadow;9     for ( ; x < (image->columns+(bevel_width << 1)); x++)        *q++=highlight; L     width=frame_info->width-frame_info->x-image->columns-(bevel_width << 1);     for (x=0; x < width; x++)        *q++=matte; '     for (x=0; x < (bevel_width-1); x++)        *q++=shadow;     *q++=black;    } I   height=frame_info->height-frame_info->y-image->rows-(bevel_width << 1);    for (y=0; y < height; y++)   {      *q++=black; '     for (x=0; x < (bevel_width-1); x++)        *q++=highlight; B     for (x=0; x < (framed_image->columns-(bevel_width << 1)); x++)       *q++=matte; '     for (x=0; x < (bevel_width-1); x++)        *q++=shadow;     *q++=black;    } $   for (y=bevel_width-2; y >= 0; y--)   {      *q++=black;      for (x=0; x < y; x++)        *q++=highlight; /     for ( ; x < (framed_image->columns-2); x++)        *q++=shadow;     *q++=black;    } +   for (x=0; x < framed_image->columns; x++)      *q++=black;    return(framed_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     G a m m a I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function GammaImage converts the reference image to gamma corrected colors. % + %  The format of the GammaImage routine is:  %  %      GammaImage(image,gamma) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % J %    o gamma: A character string indicating the level of gamma correction. %  %  */ void GammaImage(image,gamma) Image 	   *image;    char	   *gamma;  { 
   ColorPacket      *gamma_map;      double     blue_gamma,      green_gamma,     red_gamma;     int 
     count;     register int     i;     register RunlengthPacket     *p;      /*'     Allocate and initialize gamma maps.    */C   gamma_map=(ColorPacket *) malloc((MaxRGB+1)*sizeof(ColorPacket)); (   if (gamma_map == (ColorPacket *) NULL)     { B       Warning("Unable to gamma image","Memory allocation failed");
       return;      }    for (i=0; i <= MaxRGB; i++)    {      gamma_map[i].red=0;      gamma_map[i].green=0;      gamma_map[i].blue=0;   }    /*     Initialize gamma table.    */   red_gamma=1.0;   green_gamma=1.0;   blue_gamma=1.0; H   count=sscanf(gamma,"%lf,%lf,%lf",&red_gamma,&green_gamma,&blue_gamma);   if (count == 1)      {        green_gamma=red_gamma;       blue_gamma=red_gamma;      }    for (i=0; i <= MaxRGB; i++)    {      if (red_gamma != 0.0) &       gamma_map[i].red=(unsigned char)<         ((pow((double) i/MaxRGB,1.0/red_gamma)*MaxRGB)+0.5);     if (green_gamma != 0.0) (       gamma_map[i].green=(unsigned char)>         ((pow((double) i/MaxRGB,1.0/green_gamma)*MaxRGB)+0.5);     if (blue_gamma != 0.0)'       gamma_map[i].blue=(unsigned char) =         ((pow((double) i/MaxRGB,1.0/blue_gamma)*MaxRGB)+0.5);    }    switch (image->class)    {      case DirectClass:      {        /*(         Gamma-correct DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { %         p->red=gamma_map[p->red].red; +         p->green=gamma_map[p->green].green; (         p->blue=gamma_map[p->blue].blue;         p++;       }        break;     }      case PseudoClass:      {        /*(         Gamma-correct PseudoClass image.       */'       for (i=0; i < image->colors; i++)        { E         image->colormap[i].red=gamma_map[image->colormap[i].red].red; J         image->colormap[i].green=gamma_map[image->colormap[i].green].blue;I         image->colormap[i].blue=gamma_map[image->colormap[i].blue].green;        }        SyncImage(image);        break;     }    }    free((char *) gamma_map);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t I m a g e I n f o                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function GetImageInfo initializes the ImageInfo structure.  % - %  The format of the GetImageInfo routine is:  %  %      GetImageInfo(image_info)  % + %  A description of each parameter follows:  % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %  %  */ void GetImageInfo(image_info) 	 ImageInfo    *image_info; { C   image_info->filename=(char *) malloc(MaxTextLength*sizeof(char)); ,   if (image_info->filename == (char *) NULL)A     Error("Unable to get image info","Memory allocation failed");    *image_info->filename='\0';    image_info->assert=False;    image_info->subimage=0; (   image_info->server_name=(char *) NULL;!   image_info->font=(char *) NULL; !   image_info->size=(char *) NULL; $   image_info->density=(char *) NULL;!   image_info->page=(char *) NULL;    image_info->dither=True;&   image_info->interlace=NoneInterlace;   image_info->monochrome=False;    image_info->quality=85;    image_info->verbose=False;'   image_info->undercolor=(char *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     I s G r a y I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function IsGrayImage returns True if the image is grayscale otherwiseO %  False is returned.  If the image is DirectClass and grayscale, it is demoted  %  to PseudoClass. % , %  The format of the IsGrayImage routine is: %   %      status=IsGrayImage(image) % + %  A description of each parameter follows:  % J %    o status: Function IsGrayImage returns True if the image is grayscale# %      otherwise False is returned.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ unsigned int IsGrayImage(image)  Image 	   *image;  {    register int     i;     unsigned int     grayscale;     /*$     Determine if image is grayscale.   */   grayscale=True;    switch (image->class)    {      case DirectClass:      {        register RunlengthPacket         *p;          p=image->pixels;(       for (i=0; i < image->packets; i++)       { :         if ((p->red != p->green) || (p->green != p->blue))           {              grayscale=False;             break;           }          p++;       }        if (grayscale)	         { :           QuantizeImage(image,256,8,False,GRAYColorspace);           SyncImage(image); 	         }        break;     }      case PseudoClass:      { '       for (i=0; i < image->colors; i++) C         if ((image->colormap[i].red != image->colormap[i].green) || B             (image->colormap[i].green != image->colormap[i].blue))           {              grayscale=False;             break;           }        break;     }    }    return(grayscale); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a b e l I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function LabelImage initializes an image label.  Optionally the labelJ %  can include the image filename, type, width, height, or scene number byF %  embedding special format characters.  Embed %f for filename, %m forD %  magick, %w for width, %h for height, or %s for scene number.  For %  example,  %  %     %f  %wx%h  %  %  produces an image label of  %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % + %  The format of the LabelImage routine is:  %  %      LabelImage(image,label) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % L %    o label: The address of a character string containing the label format. %  %  */ void LabelImage(image,label) Image 	   *image;    char	   *label;  {    register char      *p,      *q;      unsigned int     indirection,     length;   $   if (image->label != (char *) NULL)      free((char *) image->label);   image->label=(char *) NULL;    if (label == (char *) NULL)      return;    indirection=(*label == '@');   if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*         Read label from a file.        */'       file=(FILE *) fopen(label+1,"r");         if (file == (FILE *) NULL)	         { 7           Warning("Unable to read label file",label+1);            return; 	         }        length=MaxTextLength; 1       label=(char *) malloc(length*sizeof(char)); 1       for (q=label ; label != (char *) NULL; q++)        {          c=fgetc(file);         if (c == EOF)            break;"         if ((q-label+1) >= length)           {              *q='\0';             length<<=1; G             label=(char *) realloc((char *) label,length*sizeof(char)); '             if (label == (char *) NULL)                break;"             q=label+strlen(label);           }          *q=(unsigned char) c;        }        (void) fclose(file);!       if (label == (char *) NULL) 	         { F           Warning("Unable to label image","Memory allocation failed");           return; 	         }        *q='\0';     }    /*(     Allocate and initialize image label.   */
   p=label;%   length=strlen(label)+MaxTextLength; 4   image->label=(char *) malloc(length*sizeof(char));:   for (q=image->label; image->label != (char *) NULL; p++)   {      if (*p == '\0')        break;1     if ((q-image->label+MaxTextLength) >= length)        {          *q='\0';         length<<=1;          image->label=(char *) =           realloc((char *) image->label,length*sizeof(char)); *         if (image->label == (char *) NULL)           break;,         q=image->label+strlen(image->label);       }      /*-       Process formatting characters in label.      */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { +         (void) sprintf(q,"%u",image->rows); ,         q=image->label+strlen(image->label);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);,         q=image->label+strlen(image->label);         break;       }        case 'w':        { .         (void) sprintf(q,"%u",image->columns);,         q=image->label+strlen(image->label);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } $   if (image->label == (char *) NULL)     { B       Warning("Unable to label image","Memory allocation failed");
       return;      } 
   *q='\0';   if (indirection)     free((char *) label);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     M o d u l a t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ModulateImage modulates the brightness, saturation, and hue of an 	 %  image.  % . %  The format of the ModulateImage routine is: % $ %      ModulateImage(image,modulate) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % I %    o modulate: A character string indicating the percent change in hue, " %      saturation, and brightness. %  %  %  */  G static void Modulate(percent_hue,percent_saturation,percent_brightness,    red,green,blue)  double   percent_hue,   percent_saturation,%   percent_brightness;%  
 unsigned char%   *red,%	   *green,%   *blue; {    double     brightness,      hue,     minimum,     saturation;      register double      b,     g,     r;     /*"     Convert RGB to HSV colorspace.   */
   hue=(-1.0);    saturation=0.0; $   r=(double) (*red)/(double) MaxRGB;&   g=(double) (*green)/(double) MaxRGB;%   b=(double) (*blue)/(double) MaxRGB; 
   if (r >= g)      {        if (r >= b)          brightness=r; 
       else         brightness=b;      }    else     if (g >= b)E       brightness=g;      else       brightness=b; 
   if (r <= g)      {        if (r <= b)          minimum=r;
       else         minimum=b;     }G   else     if (g <= b)        minimum=g;     else       minimum=b;   if (brightness != 0.0)/     saturation=(brightness-minimum)/brightness;    if (saturation != 0.0)     {        if (r == brightness)'         hue=(g-b)/(brightness-minimum);e
       else         if (g == brightness)-           hue=2.0+(b-r)/(brightness-minimum);          else           if (b == brightness)/             hue=4.0+(r-g)/(brightness-minimum);        hue=hue*60.0;        if (hue < 0.0)         hue+=360.0;      }    /*>     Increase or decrease color brightness, saturation, or hue.   */'   brightness+=percent_brightness/100.0;    if (brightness < 0.0)      brightness=0.0;    else     if (brightness > 1.0)        brightness=1.0; '   saturation+=percent_saturation/100.0;    if (saturation < 0.0)      saturation=0.0;    else     if (saturation > 1.0)        saturation=1.0;    if (hue != -1.0)     { #       hue+=360.0*percent_hue/100.0;9       if (hue < 0.0)         hue+=360.0; 
       else         if (hue > 360.0)           hue-=360.0;      }    /*     Convert HSV to RGB   */   r=brightness;e   g=brightness;i   b=brightness;l+   if ((hue != -1.0) && (saturation != 0.0))n     {y       double
         f,
         j,
         k,
         l,
         v;  	       intg
         i;         if (hue == 360.0)          hue=0.0;       hue=hue/60.0;n       i=floor(hue);i       if (i < 0)         i=0;       f=hue-i;$       j=brightness*(1.0-saturation);(       k=brightness*(1.0-(saturation*f));.       l=brightness*(1.0-(saturation*(1.0-f)));       v=brightness;s       switch (i)       {i)         case 0:  r=v;  g=l;  b=j;  break; )         case 1:  r=k;  g=v;  b=j;  break;s)         case 2:  r=j;  g=v;  b=l;  break; )         case 3:  r=j;  g=k;  b=v;  break; )         case 4:  r=l;  g=j;  b=v;  break;i)         case 5:  r=v;  g=j;  b=k;  break;        }      } 6   *red=(unsigned char) floor((r*(double) MaxRGB)+0.5);8   *green=(unsigned char) floor((g*(double) MaxRGB)+0.5);7   *blue=(unsigned char) floor((b*(double) MaxRGB)+0.5);  }   " void ModulateImage(image,modulate) Imager	   *image;m   char   *modulate; {    double     percent_brightness,I     percent_hue,     percent_saturation;      register int     i;     register RunlengthPacket     *p;n     /*     Initialize gamma table.    */   percent_hue=0.0;   percent_brightness=0.0;    percent_saturation=0.0;nH   (void) sscanf(modulate,"%lf,%lf,%lf",&percent_hue,&percent_saturation,     &percent_brightness);r   switch (image->class)w   {      case DirectClass:      {        /*3         Modulate the color for a DirectClass image.%       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { C         Modulate(percent_hue,percent_saturation,percent_brightness,c&           &p->red,&p->green,&p->blue);         p++;       }i       break;     }      case PseudoClass:%     {%       /*3         Modulate the color for a PseudoClass image.        */'       for (i=0; i < image->colors; i++) C         Modulate(percent_hue,percent_saturation,percent_brightness, <           &image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     M o g r i f y I m a g e                                                 %%O %                                                                             %uO %                                                                             %AO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %AH %  Function MogrifyImage applies image processing options to an image as& %  prescribed by command line options. % - %  The format of the MogrifyImage routine is:  %i %      MogrifyImage(image) %t+ %  A description of each parameter follows:A %cF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */- void MogrifyImage(image_info,argc,argv,image)=	 ImageInfoa   *image_info;   int    argc;a   char	   **argv;    Image 
   **image; {a
   ColorPacketo     border_color;e     char
     *font,     *geometry,     *option,	     *pen;      int 
     flags,     x,     y;     register int     i;     unsigned int     colorspace,e     number_colors,     tree_depth;m     if (*image == (Image *) NULL)d     return;a   /*!     Initialize routine variables.    */   border_color.red=0;;   border_color.green=0;e   border_color.blue=0;   font=(char *) NULL;m   geometry=(char *) NULL;o   number_colors=0;   pen=(char *) NULL;   tree_depth=0;=   colorspace=RGBColorspace;m   if (image_info->monochrome)e     {-       number_colors=2;       tree_depth=8;e        colorspace=GRAYColorspace;     }R   /*     Transmogrify the image.o   */   for (i=1; i < argc; i++)   {m     option=argv[i];aN     if (((int) strlen(option) <= 1) || ((*option != '-') && (*option != '+')))       continue;s,     if (strncmp("annotate",option+1,2) == 0)8       AnnotateImage(*image,font,pen,geometry,argv[++i]);'     if (strncmp("-blur",option,3) == 0)        {e         double           factor;U  
         Image_           *blurred_image;e  
         /*           Blur an image.
         */         factor=atof(argv[++i]);_/         blurred_image=BlurImage(*image,factor);m,         if (blurred_image != (Image *) NULL)           {r!             DestroyImage(*image);(!             *image=blurred_image;p           }g       }*&     if (strcmp("-border",option) == 0)       {k
         Image            *bordered_image;           RectangleInfoe           border_info;  
         /*6           Surround image with a border of solid color.
         */         border_info.width=0;         border_info.height=0;gE         flags=XParseGeometry(argv[++i],&border_info.x,&border_info.y,)2           &border_info.width,&border_info.height);'         if ((flags & HeightValue) == 0)e/           border_info.height=border_info.width;!F         bordered_image=BorderImage(*image,&border_info,&border_color);-         if (bordered_image != (Image *) NULL)p           {m!             DestroyImage(*image); .             bordered_image->class=DirectClass;"             *image=bordered_image;           }%       }%.     if (strncmp("-bordercolor",option,8) == 0)       {          Display            *display;   
         /*           Open X server.
         */6         display=XOpenDisplay(image_info->server_name);(         if (display != (Display *) NULL)           {              Colormap               colormap;                XColor               color;               /*               Get border color.              */G             colormap=XDefaultColormap(display,XDefaultScreen(display)); B             (void) XParseColor(display,colormap,argv[++i],&color);3             border_color.red=ColorShift(color.red);%7             border_color.green=ColorShift(color.green); 5             border_color.blue=ColorShift(color.blue);e           }l       } *     if (strncmp("colors",option+1,7) == 0)$       number_colors=atoi(argv[++i]);-     if (strncmp("-colorspace",option,8) == 0)b       {          i++;         option=argv[i];d.         if (Latin1Compare("gray",option) == 0)           {e&             colorspace=GRAYColorspace;#             if (number_colors == 0)f                number_colors=256;             tree_depth=8;r           }o.         if (Latin1Compare("ohta",option) == 0)$           colorspace=OHTAColorspace;-         if (Latin1Compare("rgb",option) == 0)m#           colorspace=RGBColorspace;a-         if (Latin1Compare("xyz",option) == 0)d#           colorspace=XYZColorspace; /         if (Latin1Compare("ycbcr",option) == 0)g%           colorspace=YCbCrColorspace;c-         if (Latin1Compare("yiq",option) == 0)i#           colorspace=YIQColorspace;r/         if (Latin1Compare("ypbpr",option) == 0)h%           colorspace=YPbPrColorspace;x-         if (Latin1Compare("yuv",option) == 0) #           colorspace=YUVColorspace;n       }e+     if (strncmp("comment",option+1,4) == 0)i       if (*option == '-') '         CommentImage(*image,argv[++i]);i
       else+         CommentImage(*image,(char *) NULL);t,     if (strncmp("contrast",option+1,3) == 0)<       ContrastImage(*image,(unsigned int) (*option == '-'));'     if (strncmp("-crop",option,3) == 0)n4       TransformImage(image,argv[++i],(char *) NULL);,     if (strncmp("-despeckle",option,4) == 0)       {e
         Image            *despeckled_image;  
         /*.           Reduce the speckles within an image.
         */0         despeckled_image=DespeckleImage(*image);/         if (despeckled_image != (Image *) NULL)l           {n!             DestroyImage(*image); $             *image=despeckled_image;           }*       }e'     if (strncmp("-edge",option,3) == 0)L       { 
         Image            *edged_image;e  
         /*$           Detect edges in the image.
         */&         edged_image=EdgeImage(*image);*         if (edged_image != (Image *) NULL)           {c!             DestroyImage(*image);              *image=edged_image;=           }        };*     if (strncmp("-enhance",option,3) == 0)       { 
         Image0           *enhanced_image;  
         /*           Enhance image.
         */,         enhanced_image=EnhanceImage(*image);-         if (enhanced_image != (Image *) NULL)            {e!             DestroyImage(*image);("             *image=enhanced_image;           }(       } +     if (strncmp("-equalize",option,3) == 0)        EqualizeImage(*image);'     if (strncmp("-flip",option,4) == 0)        { 
         Image            *flipped_image;   
         /*           Flip image scanlines.t
         */(         flipped_image=FlipImage(*image);,         if (flipped_image != (Image *) NULL)           { !             DestroyImage(*image);=!             *image=flipped_image;(           }        }a'     if (strncmp("-flop",option,4) == 0)        {)
         Image            *flopped_image;h  
         /*           Flop image scanlines.h
         */(         flopped_image=FlopImage(*image);,         if (flopped_image != (Image *) NULL)           {=!             DestroyImage(*image); !             *image=flopped_image;t           }r       }.'     if (strncmp("-font",option,3) == 0)        font=argv[++i]; (     if (strncmp("-gamma",option,3) == 0)#       GammaImage(*image,argv[++i]); +     if (strncmp("-geometry",option,4) == 0)e       {          geometry=argv[++i]; 5         TransformImage(image,(char *) NULL,geometry);c       } )     if (strncmp("label",option+1,2) == 0)e       if (*option == '-')l%         LabelImage(*image,argv[++i]);l
       else)         LabelImage(*image,(char *) NULL);m+     if (strncmp("-modulate",option,4) == 0) &       ModulateImage(*image,argv[++i]);)     if (strncmp("-negate",option,4) == 0)        NegateImage(*image);(     if (strncmp("-noise",option,4) == 0)       { 
         Imagex           *noisy_image;   
         /*            Reduce noise in image.
         */'         noisy_image=NoisyImage(*image); *         if (noisy_image != (Image *) NULL)           { !             DestroyImage(*image);i             *image=noisy_image;            }g       }t,     if (strncmp("-normalize",option,4) == 0)       NormalizeImage(*image); &     if (strncmp("-pen",option,3) == 0)       pen=argv[++i];'     if (strncmp("-roll",option,4) == 0)        { 
         Image            *rolled_image;           unsigned int           height,            width;  
         /*           Roll image. 
         */         x=0;         y=0;=         flags=XParseGeometry(argv[++i],&x,&y,&width,&height); +         rolled_image=RollImage(*image,x,y);o+         if (rolled_image != (Image *) NULL)X           {c!             DestroyImage(*image);y              *image=rolled_image;           }N       } )     if (strncmp("-rotate",option,4) == 0)e       {s         double           degrees;  
         Image            *rotated_image;r  
         /*           Rotate image.X
         */          degrees=atof(argv[++i]);F         rotated_image=RotateImage(*image,degrees,&border_color,False);,         if (rotated_image != (Image *) NULL)           {n!             DestroyImage(*image);e!             *image=rotated_image;            }a       }t)     if (strncmp("-sample",option,3) == 0)a       { 
         Imagey           *sampled_image;            unsigned int           height,            width;  
         /*.           Sample image with pixel replication.
         */          width=(*image)->columns;         height=(*image)->rows;5         ParseImageGeometry(argv[++i],&width,&height);o7         sampled_image=SampleImage(*image,width,height);e,         if (sampled_image != (Image *) NULL)           { !             DestroyImage(*image); !             *image=sampled_image;p           }        }(*     if (strncmp("-sharpen",option,4) == 0)       {o         double           factor;   
         Imagea           *sharpened_image;   
         /*           Sharpen an image.a
         */         factor=atof(argv[++i]);f4         sharpened_image=SharpenImage(*image,factor);.         if (sharpened_image != (Image *) NULL)           {o!             DestroyImage(*image);_#             *image=sharpened_image;            }        }a(     if (strncmp("-shear",option,4) == 0)       { 
         float            x_shear,           y_shear;  
         Imagep           *sheared_image;   
         /*           Shear image.
         */         x_shear=0.0;         y_shear=0.0;;         (void) sscanf(argv[++i],"%fx%f",&x_shear,&y_shear);n9         sheared_image=ShearImage(*image,(double) x_shear, 0           (double) y_shear,&border_color,False);,         if (sheared_image != (Image *) NULL)           { !             DestroyImage(*image);L-             sheared_image->class=DirectClass;_!             *image=sheared_image;            }i       }u/     if (strncmp("-transparency",option,4) == 0)a)       TransparentImage(*image,argv[++i]); ,     if (strncmp("-treedepth",option,4) == 0)!       tree_depth=atoi(argv[++i]);p   }l   if (number_colors != 0)      {n       /*1         Reduce the number of colors in the image.r       */-       if (((*image)->class == DirectClass) ||aO           ((*image)->colors > number_colors) || (colorspace == GRAYColorspace))_I         QuantizeImage(*image,number_colors,tree_depth,image_info->dither,e           colorspace);       /*#         Measure quantization error.p       */       if (image_info->verbose)"         QuantizationError(*image);       SyncImage(*image);     }r };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %.O %                                                                             %eO %     N e g a t e I m a g e                                                   %tO %                                                                             %tO %                                                                             %oO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Function NegateImage negates the colors in the reference image. % , %  The format of the NegateImage routine is: %s %      NegateImage(image)f %X+ %  A description of each parameter follows:n %(F %    o image: The address of a structure of type Image;  returned from %      ReadImage.a %) %L */ void NegateImage(image)% Image%	   *image;% {%   register int     i;     register RunlengthPacket     *p;      switch (image->class)    {      case DirectClass:      {        /*#         Negate DirectClass packets.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          p->red=(~p->red);          p->green=(~p->green);          p->blue=(~p->blue);          p++;       }        break;     }      case PseudoClass:      {        /*#         Negate PseudoClass packets.        */'       for (i=0; i < image->colors; i++)        {%9         image->colormap[i].red=(~image->colormap[i].red);%=         image->colormap[i].green=(~image->colormap[i].green);h;         image->colormap[i].blue=(~image->colormap[i].blue);        }a       SyncImage(image);f       break;     }s   }u }a r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %iO %     N o i s y I m a g e                                                     % O %                                                                             %aO %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g % H %  Function NoisyImage creates a new image that is a copy of an existingG %  one with the noise reduced with a noise peak elimination filter.  ItpK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %oK %  The principal function of noise peak elimination filter is to smooth theoF %  objects within an image without losing edge information and withoutJ %  creating undesired structures.  The central idea of the algorithm is toI %  replace a pixel with its next neighbor in value within a 3 x 3 window, I %  if this pixel has been found to be noise.  A pixel is defined as noise E %  if and only if this pixel is a maximum or minimum within the 3 x 3 
 %  window. %t+ %  The format of the NoisyImage routine is:n % $ %      noisy_image=NoisyImage(image) % + %  A description of each parameter follows:3 % L %    o noisy_image: Function NoisyImage returns a pointer to the image afterK %      the noise is reduced.  A null image is returned if there is a memoryt %      shortage. %rF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %N %) */ static int NoisyCompare(x,y)
 const void   *x,m   *y;o {i
   ColorPacket 
     *color_1,g
     *color_2;      color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_1)-(int) Intensity(*color_2)); }n   Image *NoisyImage(image) Images	   *image;l {t   Image;     *noisy_image;      inth     i;     register RunlengthPacket     *p,      *q,e     *s,M     *s0,     *s1,     *s2;     register unsigned inta     x;     RunlengthPacketN
     pixel,     *scanline,     window[9];     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     {=I       Warning("Unable to reduce noise","the image size must exceed 2x2");g       return((Image *) NULL);-     }g   /*&     Initialize noisy image attributes.   */@   noisy_image=CopyImage(image,image->columns,image->rows,False);$   if (noisy_image == (Image *) NULL)     { C       Warning("Unable to reduce noise","Memory allocation failed");r       return((Image *) NULL);d     }i   /*5     Allocate scanline buffer for 3 rows of the image.x   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)g     {gC       Warning("Unable to reduce noise","Memory allocation failed");1        DestroyImage(noisy_image);       return((Image *) NULL);i     }o   /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline;++   for (x=0; x < (image->columns << 1); x++)e   {o     if (image->runlength != 0)       image->runlength--;g     else       {          p++;#         image->runlength=p->length;g       }g     *s=(*p);     s++;   }    /*!     Dump first scanline of image.g   */   q=noisy_image->pixels;
   s=scanline; $   for (x=0; x < image->columns; x++)   {t     *q=(*s);     q->length=0;     q++;     s++;   };   /*     Reduce noise in each row.>   */%   for (y=1; y < (image->rows-1); y++)o   {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3);l+     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2;r&     for (x=0; x < image->columns; x++)     {d        if (image->runlength != 0)         image->runlength--;n
       else	         {e           p++;%           image->runlength=p->length;h	         }_       *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */	     s=s1;      *q=(*s);     q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {c       /*3         Sort window pixels by increasing intensity.        */       s=s0;x       window[0]=(*s++);+       window[1]=(*s++);n       window[2]=(*s++);        s=s1;*       window[3]=(*s++);u       window[4]=(*s++);        window[5]=(*s++);%       s=s2;%       window[6]=(*s++);%       window[7]=(*s++);        window[8]=(*s++);        pixel=window[4];6       qsort((void *) window,9,sizeof(RunlengthPacket),G         (int (*) _Declare((const void *, const void *))) NoisyCompare); 3       if (Intensity(pixel) == Intensity(window[0])) 	         {            /*H             Pixel is minimum noise; replace with next neighbor in value.           */           for (i=1; i < 8; i++) =             if (Intensity(window[i]) != Intensity(window[0]))                break;           pixel=window[i];	         } 
       else5         if (Intensity(pixel) == Intensity(window[8]))%           {%             /*J               Pixel is maximum noise; replace with next neighbor in value.             */!             for (i=7; i > 0; i--)u?               if (Intensity(window[i]) != Intensity(window[8]))                  break;             pixel=window[i];           }r       *q=pixel;t       q->length=0;
       q++;       s0++;        s1++;a       s2++;e     }r     /**       Transfer last pixel of the scanline.     */	     s=s1;d     *q=(*s);     q->length=0;     q++;   }t   /*!     Dump last scanline of pixels.F   */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {r     *q=(*s);     q->length=0;     q++;     s++;   }e   free((char *) scanline);   return(noisy_image); }o r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             % O %                                                                             %IO %     N o r m a l i z e I m a g e                                             %rO %                                                                             % O %                                                                             % O %                                                                             %bO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %1G %  Function NormalizeImage normalizes the pixel values to span the fullaD %  range of color values.  This is a contrast enhancement technique. %e/ %  The format of the NormalizeImage routine is:) %L %      NormalizeImage(image) %e+ %  A description of each parameter follows:o %rF %    o image: The address of a structure of type Image;  returned from %      ReadImage.d %b %e */ void NormalizeImage(image) Image 	   *image;y {a   intp     histogram[MaxRGB+1],     threshold_intensity;     register int     i,     intensity;     register RunlengthPacket     *p;e     unsigned char      gray_value,      normalize_map[MaxRGB+1];     unsigned int	     high,      low;     /*     Form histogram.    */   for (i=0; i <= MaxRGB; i++)r     histogram[i]=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)   {      gray_value=Intensity(*p); '     histogram[gray_value]+=p->length+1;      p++;   }    /*C     Find the histogram boundaries by locating the 1 percent levels.    */7   threshold_intensity=(image->columns*image->rows)/100;    intensity=0;"   for (low=0; low < MaxRGB; low++)   {+     intensity+=histogram[low];(     if (intensity > threshold_intensity)       break;   }t   intensity=0;&   for (high=MaxRGB; high != 0; high--)   {      intensity+=histogram[high];e(     if (intensity > threshold_intensity)       break;   }    if (low == high)     {x       /*K         Unreasonable contrast;  use zero threshold to determine boundaries.%       */       threshold_intensity=0;       intensity=0;&       for (low=0; low < MaxRGB; low++)       { "         intensity+=histogram[low];,         if (intensity > threshold_intensity)           break;       }        intensity=0;*       for (high=MaxRGB; high != 0; high--)       { #         intensity+=histogram[high]; ,         if (intensity > threshold_intensity)           break;       }        if (low == high)&         return;  /* zero span bound */     }    /*A     Stretch the histogram to create the normalized image mapping.    */   for (i=0; i <= MaxRGB; i++)      if (i < (int) low)       normalize_map[i]=0;%     else       if (i > (int) high)%"         normalize_map[i]=MaxRGB-1;
       else7         normalize_map[i]=(MaxRGB-1)*(i-low)/(high-low);a   /*     Normalize the image.   */   switch (image->class)n   {a     case DirectClass:t     {p       /*$         Normalize DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {d%         p->red=normalize_map[p->red]; )         p->green=normalize_map[p->green];e'         p->blue=normalize_map[p->blue];e         p++;       }r       break;     }e     case PseudoClass:      {        /*$         Normalize PseudoClass image.       */'       for (i=0; i < image->colors; i++)        {_E         image->colormap[i].red=normalize_map[image->colormap[i].red];rI         image->colormap[i].green=normalize_map[image->colormap[i].green]; G         image->colormap[i].blue=normalize_map[image->colormap[i].blue];        }i       SyncImage(image);        break;     }e   }r }n g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             %tO %                                                                             % O %                                                                             % O %   O p e n I m a g e                                                         %+O %                                                                             %iO %                                                                             %iO %                                                                             %wO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g % L %  Function OpenImage open a file associated with the image.  A file name ofK %  '-' sets the file to stdin for type 'r' and stdout for type 'w'.  If thehK %  filename suffix is '.gz' or '.Z', the image is decompressed for type 'r' K %  and compressed for type 'w'.  If the filename prefix is '|', it is pipedw %  to or from a system command.f %h* %  The format of the OpenImage routine is: %a %      OpenImage(image,type) %o+ %  A description of each parameter follows:  %N7 %    o image: The address of a structure of type Image.= %g. %    o type: 'r' for reading; 'w' for writing. %h */ void OpenImage(image,type) Imageh	   *image;    char   *type; {    char     filename[MaxTextLength];  *   (void) strcpy(filename,image->filename);   if (*filename != '|') 7     if (strcmp(filename+strlen(filename)-3,".gz") == 0)e       { 
         /*E           Uncompress/compress image file with GNU compress utilities. 
         */         if (*type == 'r') F           (void) sprintf(filename,"|gunzip -f -c %s",image->filename);         elseF           (void) sprintf(filename,"|gzip -f -c > %s",image->filename);       }f     else8       if (strcmp(filename+strlen(filename)-2,".Z") == 0)	         {            /*H             Uncompress/compress image file with UNIX compress utilities.           */           if (*type == 'r')fI             (void) sprintf(filename,"|uncompress -c %s",image->filename);            elseI             (void) sprintf(filename,"|compress -c > %s",image->filename); 	         }+   /*     Open image file.   */   image->pipe=False;    if (strcmp(filename,"-") == 0)0     image->file=(*type == 'r') ? stdin : stdout;   else     if (*filename != '|')l       {          if (*type == 'w') 4           if ((image->previous != (Image *) NULL) ||.               (image->next != (Image *) NULL))
             {%               /*4                 Form filename for multi-part images.               */D               (void) sprintf(filename,image->filename,image->scene);8               if (strcmp(filename,image->filename) == 0)N                 (void) sprintf(filename,"%s.%u",image->filename,image->scene);0               if (image->next != (Image *) NULL)A                 (void) strcpy(image->next->magick,image->magick); 6               (void) strcpy(image->filename,filename);
             } 2         image->file=(FILE *) fopen(filename,type);)         if (image->file != (FILE *) NULL)            {%+             (void) fseek(image->file,0L,2);%/             image->filesize=ftell(image->file);c+             (void) fseek(image->file,0L,0);h           }m       }i     else       {a
         /*1           Pipe image to or from a system command.e
         */         if (*type == 'w')g)           (void) signal(SIGPIPE,SIG_IGN);m4         image->file=(FILE *) popen(filename+1,type);         image->pipe=True;        }o   image->status=False; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             %!O %                                                                             % O %   P a r s e I m a g e G e o m e t r y                                       %%O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ParseImageGeometry parse a geometry specification and returns the  %  width and height values.  % 3 %  The format of the ParseImageGeometry routine is:  % 6 %      ParseImageGeometry(image_geometry,width,height) % + %  A description of each parameter follows:% %%N %    o image_geometry:  Specifies a character string representing the geometry %      specification.m %.L %    o width:  A pointer to an unsigned integer.  The width as determined by3 %      the geometry specification is returned here.h %cN %    o height:  A pointer to an unsigned integer.  The height as determined by3 %      the geometry specification is returned here.p %  %  */4 void ParseImageGeometry(image_geometry,width,height) char   *image_geometry;   unsigned int	   *width,l
   *height; {d   char     geometry[MaxTextLength];     intT
     flags,     x,     y;     register char      *p;m     unsigned int     aspect_ratio,d     former_height,     former_width,      percentage;      unsigned longr     scale_factor;e  &   if (image_geometry == (char *) NULL)     return;i   /*J     Remove whitespaces and % and ! characters from geometry specification.   */)   (void) strcpy(geometry,image_geometry);;   aspect_ratio=True;   percentage=False; 
   p=geometry;t   while ((int) strlen(p) > 0)    {      if (isspace(*p))       (void) strcpy(p,p+1);h     else       if (*p == '%')	         {=           percentage=True;           (void) strcpy(p,p+1); 	         }t
       else         if (*p == '!')           {              aspect_ratio=False; !             (void) strcpy(p,p+1);            }c         else           p++;   }    /*(     Parse geometry using XParseGeometry.   */   former_width=(*width);   former_height=(*height);4   flags=XParseGeometry(geometry,&x,&y,width,height);@   if (((flags & WidthValue) != 0) && (flags & HeightValue) == 0)     *height=(*width);i   if (percentage)      {c       /*3         Geometry is a percentage of the image size.=       */)       *width=(former_width*(*width))/100;;,       *height=(former_height*(*height))/100;       former_width=(*width);       former_height=(*height);     }    if (aspect_ratio)l     {a       /**         Respect aspect ratio of the image.       */0       scale_factor=UpShift(*width)/former_width;:       if (scale_factor > (UpShift(*height)/former_height))4         scale_factor=UpShift(*height)/former_height;2       *width=DownShift(former_width*scale_factor);4       *height=DownShift(former_height*scale_factor);     }o }a d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %xO %                                                                             %eO %     O i l P a i n t I m a g e                                               % O %                                                                             % O %                                                                             %lO %                                                                             %=O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %;K %  Function OilPaintImage creates a new image that is a copy of an existing N %  one with each pixel component replaced with the color of greatest number in %  a 5x5 neighborhood. % . %  The format of the OilPaintImage routine is: %() %      painted_image=OilPaintImage(image); % + %  A description of each parameter follows:  % K %    o painted_image: Function OilPaintImage returns a pointer to the imagenL %      after it is `painted'.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.p %, %  */ Image *OilPaintImage(image)  Image 	   *image;  {    Image      *painted_image;v     intn
     count;     register int     i,     j;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2,     *s3,     *s4;     register unsigned int+     x;     RunlengthPacket 
     pixel,     *scanline,     window[25];      unsigned int     *histogram,m     y;  0   if ((image->columns < 5) || (image->rows < 5))     { F       Warning("Unable to oil paint","the image size must exceed 4x4");       return((Image *) NULL);      }m   /*(     Initialize painted image attributes.   */B   painted_image=CopyImage(image,image->columns,image->rows,False);&   if (painted_image == (Image *) NULL)     { @       Warning("Unable to oil paint","Memory allocation failed");       return((Image *) NULL);r     }a#   painted_image->class=DirectClass;    /*$     Allocate histogram and scanline.   */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int));%P   scanline=(RunlengthPacket *) malloc(5*image->columns*sizeof(RunlengthPacket));-   if ((histogram == (unsigned int *) NULL) || -       (scanline == (RunlengthPacket *) NULL))      { @       Warning("Unable to oil paint","Memory allocation failed");"       DestroyImage(painted_image);       return((Image *) NULL);      }    /**     Preload the first 4 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 2); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;%       }%     *s=(*p);     s++;   }%   /*!     Dump first scanline of image.o   */   q=painted_image->pixels;
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)t   {m     *q=(*s);     q->length=0;     q++;     s++;   }m   /*      Paint each row of the image.   */%   for (y=2; y < (image->rows-2); y++)    {s     /*)       Initialize sliding window pointers.C     */+     s0=scanline+image->columns*((y-2) % 5); +     s1=scanline+image->columns*((y-1) % 5);;'     s2=scanline+image->columns*(y % 5);R+     s3=scanline+image->columns*((y+1) % 5);e+     s4=scanline+image->columns*((y+2) % 5);f     /*       Read another scan line.f     */	     s=s4;s&     for (x=0; x < image->columns; x++)     {-        if (image->runlength != 0)         image->runlength--;r
       else	         {            p++;%           image->runlength=p->length;m	         }s       *s=(*p);
       s++;     }m     /*+       Transfer first pixel of the scanline.a     */	     s=s2;m     *q=(*s);     q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*.         Note each pixel in a 5x5 neighborhood.       */       s=s0;u       window[0]=(*s++);        window[1]=(*s++);        window[2]=(*s++);)       window[3]=(*s++);e       window[4]=(*s++);(       s=s1;C       window[5]=(*s++);        window[6]=(*s++);        window[7]=(*s++);m       window[8]=(*s++);        window[9]=(*s++);r       s=s2;        window[10]=(*s++);       window[11]=(*s++);       window[12]=(*s++);       window[13]=(*s++);       window[14]=(*s++);       s=s3;        window[15]=(*s++);       window[16]=(*s++);       window[17]=(*s++);       window[18]=(*s++);       window[19]=(*s++);       s=s4;i       window[20]=(*s++);       window[21]=(*s++);       window[22]=(*s++);       window[23]=(*s++);       window[24]=(*s++);       /*&         Determine most frequent color.       */       count=0;$       for (i=0; i < (MaxRGB+1); i++)         histogram[i]=0;        for (i=0; i < 25; i++)       {%%          j=Intensity(window[i]) >> 2;%          histogram[j]++;          j=histogram[j];          if (j > count)             {              pixel=window[i];               count=j;             }       }        *q=pixel;        q->length=0;
       q++;       s0++;        s1++;        s2++;        s3++;        s4++;      }      /**       Transfer last pixel of the scanline.     */	     s=s2;      *q=(*s);     q->length=0;     q++;   }    /*!     Dump last scanline of pixels.    */$   s=scanline+image->columns*(y % 5);+   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }%   free((char *) histogram);%   free((char *) scanline);   return(painted_image); }a m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %nO %                                                                             %eO %                                                                             %tO %   R e d u c e I m a g e                                                     %pO %                                                                             %-O %                                                                             % O %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+ % M %  Function ReduceImage creates a new image that is a integral size less than)H %  an existing one.  It allocates the memory necessary for the new Image4 %  structure and returns a pointer to the new image. % O %  ReduceImage scans the reference image to create a reduced image by computing)L %  the weighted average of a 4x4 cell centered at each reference pixel.  TheJ %  target pixel requires two columns and two rows of the reference pixels.7 %  Therefore the reduced image columns and rows become:! %) %    number_columns/2g %    number_rows/2 % G %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. %>L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.+ % , %  The format of the ReduceImage routine is: % ' %      reduced_image=ReduceImage(image)a %t+ %  A description of each parameter follows:g %pI %    o reduced_image: Function ReduceImage returns a pointer to the imagesG %      after reducing.  A null image is returned if there is a a memory = %      shortage or if the image size is less than IconSize*2.s % 7 %    o image: The address of a structure of type Image.i %e %o */ Image *ReduceImage(image)c Imagei	   *image;s {n #define Reduce(weight) \!   total_red+=(weight)*(s->red); \c%   total_green+=(weight)*(s->green); \g#   total_blue+=(weight)*(s->blue); \ %   total_matte+=(weight)*(s->index); \%   s++;     Image%     *reduced_image;%     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2,     *s3;     register unsigned int      x;     RunlengthPacket      *scanline;     unsigned int     y;     unsigned long      total_matte,     total_blue,      total_green,     total_red;  0   if ((image->columns < 4) || (image->rows < 4))     { E       Warning("Unable to reduce image","image size must exceed 3x3");        return((Image *) NULL);      }    /*(     Initialize reduced image attributes.   */L   reduced_image=CopyImage(image,image->columns >> 1,image->rows >> 1,False);&   if (reduced_image == (Image *) NULL)     {%C       Warning("Unable to reduce image","Memory allocation failed");        return((Image *) NULL);f     } #   reduced_image->class=DirectClass;r   /*F     Allocate image buffer and scanline buffer for 4 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(4*(image->columns+1)*sizeof(RunlengthPacket));o+   if (scanline == (RunlengthPacket *) NULL)a     { C       Warning("Unable to reduce image","Memory allocation failed");c"       DestroyImage(reduced_image);       return((Image *) NULL);      }f   /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1;n
   s=scanline;i+   for (x=0; x < (image->columns << 1); x++)    {e     if (image->runlength != 0)       image->runlength--;_     else       {f         p++;#         image->runlength=p->length;;       }      *s=(*p);     s++;   }    /*     Reduce each row.   */   p=image->pixels;   image->runlength=p->length+1;r   q=reduced_image->pixels;&   for (y=0; y < (image->rows-1); y+=2)   {      /*)       Initialize sliding window pointers.h     */+     s0=scanline+image->columns*((y+0) % 4);)+     s1=scanline+image->columns*((y+1) % 4);n+     s2=scanline+image->columns*((y+2) % 4);i+     s3=scanline+image->columns*((y+3) % 4);e     /*       Read another scan line.      */	     s=s2;,&     for (x=0; x < image->columns; x++)     {u        if (image->runlength != 0)         image->runlength--;f
       else	         {e           p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }c     /*       Read another scan line.      */	     s=s3;a&     for (x=0; x < image->columns; x++)     {-        if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     } +     for (x=0; x < (image->columns-1); x+=2))     {        /*B         Compute weighted average of target pixel color components.  I         These particular coefficients total to 128.  Use 128/2-1 or 63 toD!         insure correct round off.f       */       total_red=0;       total_green=0;       total_blue=0;s       total_matte=0;       s=s0;i3       Reduce(3); Reduce(7);  Reduce(7);  Reduce(3);        s=s1;-3       Reduce(7); Reduce(15); Reduce(15); Reduce(7);        s=s2;_3       Reduce(7); Reduce(15); Reduce(15); Reduce(7);-       s=s3; 3       Reduce(3); Reduce(7);  Reduce(7);  Reduce(3);        s0+=2;       s1+=2;       s2+=2;       s3+=2;3       q->red=(unsigned char) ((total_red+63) >> 7); 7       q->green=(unsigned char) ((total_green+63) >> 7); 5       q->blue=(unsigned char) ((total_blue+63) >> 7); 7       q->index=(unsigned char) ((total_matte+63) >> 7);        q->length=0;
       q++;     }-   }s   free((char *) scanline);   return(reduced_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %xO %     R G B T r a n s f o r m I m a g e                                       %lO %                                                                             % O %                                                                             % O %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %mF %  Function RGBTransformImage converts the reference image from RGB toM %  an alternate colorspace.  The transformation matrices are not the standard+L %  ones: the weights are rescaled to normalized the range of the transformed %  values to be [0..255].h % 2 %  The format of the RGBTransformImage routine is: % * %      RGBTransformImage(image,colorspace) %_+ %  A description of each parameter follows:  %fF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o colorspace: An unsigned integer value that indicates which colorspace %      to transform the image. %  %  */( void RGBTransformImage(image,colorspace) Image 	   *image;    unsigned int
   colorspace;  {  #define X 0n #define Y (MaxRGB+1) #define Z (MaxRGB+1)*2     long     tx,      ty,      tz,      *x,e     *y,      *z;-     register int	     blue, 
     green,     i,     red;     register RunlengthPacket     *p;      register unsigned char     *range_limit;      unsigned char      *range_table;   "   if (colorspace == RGBColorspace)     return;e   /*     Allocate the tables.   *//   x=(long *) malloc(3*(MaxRGB+1)*sizeof(long));p/   y=(long *) malloc(3*(MaxRGB+1)*sizeof(long));;/   z=(long *) malloc(3*(MaxRGB+1)*sizeof(long));lK   range_table=(unsigned char *) malloc(3*(MaxRGB+1)*sizeof(unsigned char));q5   if ((x == (long *) NULL) || (y == (long *) NULL) || F       (z == (long *) NULL) || (range_table == (unsigned char *) NULL))     { L       Warning("Unable to transform color space","Memory allocation failed");
       return;      }l   /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)/   {B     range_table[i]=0; 0     range_table[i+(MaxRGB+1)]=(unsigned char) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;i   })%   range_limit=range_table+(MaxRGB+1);e   tx=0;-   ty=0;)   tz=0;    switch (colorspace)-   {*     case GRAYColorspace:     {        /*         Initialize GRAY tables:)  +           G = 0.29890*R+0.58660*G+0.11450*B        */!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.29890)*i;$         y[i+X]=UpShifted(0.58660)*i;$         z[i+X]=UpShifted(0.11450)*i;$         x[i+Y]=UpShifted(0.29890)*i;$         y[i+Y]=UpShifted(0.58660)*i;$         z[i+Y]=UpShifted(0.11450)*i;$         x[i+Z]=UpShifted(0.29890)*i;$         y[i+Z]=UpShifted(0.58660)*i;$         z[i+Z]=UpShifted(0.11450)*i;       }        break;     }t     case OHTAColorspace:     {d       /*         Initialize OHTA tables:e  ,           I1 = 0.33333*R+0.33334*G+0.33333*B,           I2 = 0.50000*R+0.00000*G-0.50000*B,           I3 =-0.25000*R+0.50000*G-0.25000*B  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0e         through MaxRGB.d       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        {e$         x[i+X]=UpShifted(0.33333)*i;$         y[i+X]=UpShifted(0.33334)*i;$         z[i+X]=UpShifted(0.33333)*i;$         x[i+Y]=UpShifted(0.50000)*i;         y[i+Y]=0; '         z[i+Y]=(-UpShifted(0.50000))*i;e'         x[i+Z]=(-UpShifted(0.25000))*i; $         y[i+Z]=UpShifted(0.50000)*i;'         z[i+Z]=(-UpShifted(0.25000))*i;        }        break;     }n     case XYZColorspace:n     {q       /*'         Initialize XYZ ITU601-1 tables:d  +           X = 0.43060*X+0.34155*Y+0.17833*Z-+           Y = 0.22202*X+0.70666*Y+0.07133*ZB+           Z = 0.02018*X+0.12955*Y+0.93918*Zr       */!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.43060)*i;$         y[i+X]=UpShifted(0.34155)*i;$         z[i+X]=UpShifted(0.17833)*i;$         x[i+Y]=UpShifted(0.22202)*i;$         y[i+Y]=UpShifted(0.70666)*i;$         z[i+Y]=UpShifted(0.07133)*i;$         x[i+Z]=UpShifted(0.02018)*i;$         y[i+Z]=UpShifted(0.12955)*i;$         z[i+Z]=UpShifted(0.93918)*i;       }        break;     })     case YCbCrColorspace:      {        /*          Initialize YCbCr tables:  ,           Y =  0.29890*R+0.58660*G+0.11450*B,           Cb= -0.16874*R-0.33126*G+0.50000*B,           Cr=  0.50000*R-0.41830*G-0.08160*B  K         Cb and Cr, normally -0.5 through 0.5, are normalized to the range 0i         through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.29890)*i;$         y[i+X]=UpShifted(0.58660)*i;$         z[i+X]=UpShifted(0.11450)*i;'         x[i+Y]=(-UpShifted(0.16874))*i;n'         y[i+Y]=(-UpShifted(0.33126))*i;e$         z[i+Y]=UpShifted(0.50000)*i;$         x[i+Z]=UpShifted(0.50000)*i;'         y[i+Z]=(-UpShifted(0.41830))*i; '         z[i+Z]=(-UpShifted(0.08160))*i;        }g       break;     }e     case YCCColorspace:e     {d       /*         Initialize YCC tables:  +           Y = 0.29890*R+0.58660*G+0.11450*Bx+           C1=-0.29890*R-0.58660*G+0.88600*B +           C2= 0.70100*R-0.58660*G+0.11450*Bd  B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */       ty=UpShifted(156);       tz=UpShifted(137);!       for (i=0; i <= MaxRGB; i++)        {e$         x[i+X]=UpShifted(0.29890)*i;$         y[i+X]=UpShifted(0.58660)*i;$         z[i+X]=UpShifted(0.11450)*i;'         x[i+Y]=(-UpShifted(0.29890))*i;p'         y[i+Y]=(-UpShifted(0.58660))*i;l$         z[i+Y]=UpShifted(0.88600)*i;$         x[i+Z]=UpShifted(0.70100)*i;'         y[i+Z]=(-UpShifted(0.58660))*i; '         z[i+Z]=(-UpShifted(0.11450))*i;        }*       break;     }%     case YIQColorspace:%     {%       /*         Initialize YIQ tables:  +           Y = 0.29890*R+0.58660*G+0.11450*B +           I = 0.50000*R-0.23000*G-0.27000*B +           Q = 0.20200*R-0.50000*G+0.29800*B   I         I and Q, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.29890)*i;$         y[i+X]=UpShifted(0.58660)*i;$         z[i+X]=UpShifted(0.11450)*i;$         x[i+Y]=UpShifted(0.50000)*i;'         y[i+Y]=(-UpShifted(0.23000))*i;n'         z[i+Y]=(-UpShifted(0.27000))*i;y$         x[i+Z]=UpShifted(0.20200)*i;'         y[i+Z]=(-UpShifted(0.50000))*i;T$         z[i+Z]=UpShifted(0.29800)*i;       }        break;     }i     case YPbPrColorspace:s     {n       /*          Initialize YPbPr tables:  ,           Y =  0.21220*R+0.70130*G+0.08650*B,           Pb= -0.11620*R-0.38380*G+0.50000*B,           Pr=  0.50000*R-0.44510*G-0.05490*B  K         Pb and Pr, normally -0.5 through 0.5, are normalized to the range 0,         through MaxRGB.n       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)i       { $         x[i+X]=UpShifted(0.21220)*i;$         y[i+X]=UpShifted(0.70130)*i;$         z[i+X]=UpShifted(0.08650)*i;'         x[i+Y]=(-UpShifted(0.11620))*i;r'         y[i+Y]=(-UpShifted(0.38380))*i;n$         z[i+Y]=UpShifted(0.50000)*i;$         x[i+Z]=UpShifted(0.50000)*i;'         y[i+Z]=(-UpShifted(0.44510))*i;t'         z[i+Z]=(-UpShifted(0.05490))*i;b       }        break;     }=     case YUVColorspace:      default:     {g       /*         Initialize YUV tables:  ,           Y =  0.29890*R+0.58660*G+0.11450*B,           U = -0.14740*R-0.28950*G+0.43690*B,           V =  0.61500*R-0.51500*G-0.10000*B  I         U and V, normally -0.5 through 0.5, are normalized to the range 0sD         through MaxRGB.  Note that U = 0.493*(B-Y), V = 0.877*(R-Y).       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)u       { $         x[i+X]=UpShifted(0.29890)*i;$         y[i+X]=UpShifted(0.58660)*i;$         z[i+X]=UpShifted(0.11450)*i;'         x[i+Y]=(-UpShifted(0.14740))*i; '         y[i+Y]=(-UpShifted(0.28950))*i;k$         z[i+Y]=UpShifted(0.43690)*i;$         x[i+Z]=UpShifted(0.61500)*i;'         y[i+Z]=(-UpShifted(0.51500))*i;a'         z[i+Z]=(-UpShifted(0.10000))*i;f       }e       break;     }t   }1   /*     Convert from RGB.e   */   switch (image->class)    {*     case DirectClass:B     {        /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {,         red=p->red;          green=p->green;;         blue=p->blue; H         p->red=range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)];J         p->green=range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];I         p->blue=range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];          p++;       }t       break;     }      case PseudoClass:      {h       /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)e       { #         red=image->colormap[i].red; '         green=image->colormap[i].green;k%         blue=image->colormap[i].blue;b         image->colormap[i].red=jC           range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)];d!         image->colormap[i].green=iC           range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];l          image->colormap[i].blue=C           range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];d       }h       SyncImage(image);i       break;     }t   }    /*     Free allocated memory.   */   free((char *) range_table);    free((char *) z);s   free((char *) y);r   free((char *) x);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             %sO %                                                                             % O %   R o l l I m a g e                                                         %eO %                                                                             %gO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function RollImage rolls an image vertically and horizontally.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % * %  The format of the RollImage routine is: % 1 %      rolled_image=RollImage(image,columns,rows)  % + %  A description of each parameter follows:  % L %    o rolled_image: Function RollImage returns a pointer to the image afterH %      rolling.  A null image is returned if there is a memory shortage. %%7 %    o image: The address of a structure of type Image.t % H %    o x_offset: An integer that specifies the number of columns to roll# %      in the horizontal direction.l %tL %    o y_offset: An integer that specifies the number of rows to roll in the %      veritical direction.u %, %s */) Image *RollImage(image,x_offset,y_offset)r Imagef	   *image;    into   x_offset,F   y_offset;m {    Image      *rolled_image;     register RunlengthPacket     *p,s     *q;      register unsigned intg     packets,     x;     unsigned int     y;     /*'     Initialize rolled image attributes.t   */A   rolled_image=CopyImage(image,image->columns,image->rows,False); %   if (rolled_image == (Image *) NULL)e     { A       Warning("Unable to roll image","Memory allocation failed");c       return((Image *) NULL);      }    /*     Roll image.    */   p=image->pixels;   image->runlength=p->length+1;r%   packets=image->columns*image->rows; !   for (y=0; y < image->rows; y++)    {y     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {i        if (image->runlength != 0)         image->runlength--;a
       else	         {e           p++;%           image->runlength=p->length;c	         }*D       q=rolled_image->pixels+(y_offset+y)*image->columns+x+x_offset;#       if (q < rolled_image->pixels)o         q+=packets; 
       else0         if (q >= (rolled_image->pixels+packets))           q-=packets;f       *q=(*p);       q->length=0;     }=   }a   return(rolled_image);n }m   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             %mO %                                                                             %mO %                                                                             % O %   S a m p l e I m a g e                                                     %lO %                                                                             %eO %                                                                             %lO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %iG %  Function SampleImage creates a new image that is a scaled size of anlH %  existing one using pixel sampling.  It allocates the memory necessaryF %  for the new Image structure and returns a pointer to the new image. % , %  The format of the SampleImage routine is: % 4 %      sampled_image=SampleImage(image,columns,rows) %n+ %  A description of each parameter follows:= %aO %    o sampled_image: Function SampleImage returns a pointer to the image afteryH %      scaling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % N %    o columns: An integer that specifies the number of columns in the sampled
 %      image.y %aH %    o rows: An integer that specifies the number of rows in the sampled
 %      image.i %d %t */& Image *SampleImage(image,columns,rows) Image 	   *image;a   unsigned int
   columns,   rows;L {    Imagen     *sampled_image;      intp     y;     register RunlengthPacket     *p,      *q,p     *s;      register int     x;     RunlengthPacket      *scanline;     unsigned int     *x_offset,     *y_offset;     unsigned longt     scale_factor;   $   if ((columns == 0) || (rows == 0))     {aD       Warning("Unable to sample image","image dimensions are zero");       return((Image *) NULL);      };8   if ((columns > MaxImageSize) || (rows > MaxImageSize))     {I:       Warning("Unable to sample image","image too large");       return((Image *) NULL);      }o   /*(     Initialize sampled image attributes.   */4   sampled_image=CopyImage(image,columns,rows,False);&   if (sampled_image == (Image *) NULL)     {>C       Warning("Unable to sample image","Memory allocation failed");e       return((Image *) NULL);      }%   /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));P   x_offset=(unsigned int *) malloc(sampled_image->columns*sizeof(unsigned int));M   y_offset=(unsigned int *) malloc(sampled_image->rows*sizeof(unsigned int)); /   if ((scanline == (RunlengthPacket *) NULL) || ,       (x_offset == (unsigned int *) NULL) ||*       (y_offset == (unsigned int *) NULL))     { C       Warning("Unable to sample image","Memory allocation failed"); "       DestroyImage(sampled_image);       return((Image *) NULL);      }    /*$     Initialize column pixel offsets.   */>   scale_factor=UpShift(image->columns)/sampled_image->columns;   columns=0;,   for (x=0; x < sampled_image->columns; x++)   { 8     x_offset[x]=DownShift(x*scale_factor)-(int) columns;     columns+=x_offset[x];e   }c   /*!     Initialize row pixel offsets.    */8   scale_factor=UpShift(image->rows)/sampled_image->rows;	   rows=0;i)   for (y=0; y < sampled_image->rows; y++)d   {p5     y_offset[y]=DownShift(y*scale_factor)-(int) rows;a     rows+=y_offset[y];   }s$   y_offset[sampled_image->rows-1]=0;   /*     Preload first scanline.e   */   p=image->pixels;   image->runlength=p->length+1;h
   s=scanline; $   for (x=0; x < image->columns; x++)   {e     if (image->runlength != 0)       image->runlength--;      else       {w         p++;#         image->runlength=p->length;p       }      *s=(*p);     s->length=0;     s++;   }    /*     Sample each row.   */   q=sampled_image->pixels;)   for (y=0; y < sampled_image->rows; y++)    {      /*       Sample each column.      */     s=scanline;u.     for (x=0; x < sampled_image->columns; x++)     {p       *q=(*s);
       q++;       s+=x_offset[x];n     }t     if (y_offset[y] != 0)f       {)
         /*           Skip a scan line._
         */         if (y_offset[y] > 1)>           for (x=0; x < (image->columns*(y_offset[y]-1)); x++)&             if (image->runlength != 0)!               image->runlength--;              else               {o                 p++;+                 image->runlength=p->length;-               }i
         /*           Read a scan line. 
         */         s=scanline;f*         for (x=0; x < image->columns; x++)	         {=$           if (image->runlength != 0)             image->runlength--;0           else
             {d               p++;)               image->runlength=p->length; 
             }p           *s=(*p);           s->length=0;           s++;	         }i       }    }    free((char *) scanline);   free((char *) x_offset);   free((char *) y_offset);   return(sampled_image); }e e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             % O %                                                                             %nO %   S c a l e I m a g e                                                       %dO %                                                                             %fO %                                                                             %(O %                                                                             %cO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function ScaleImage creates a new image that is a scaled size of anE %  existing one.  It allocates the memory necessary for the new Image I %  structure and returns a pointer to the new image.  To scale a scanline K %  from x pixels to y pixels, each new pixel represents x/y old pixels.  TolL %  read x/y pixels, read (x/y rounded up) pixels but only count the requiredH %  fraction of the last old pixel read in your new pixel.  The remainder: %  of the old pixel will be counted in the next new pixel. %rK %  The scaling algorithm was suggested by rjohnson@shell.com and is adaptede0 %  from pnmscale(1) of PBMPLUS by Jef Poskanzer. % + %  The format of the ScaleImage routine is:  %02 %      scaled_image=ScaleImage(image,columns,rows) %p+ %  A description of each parameter follows:g %nM %    o scaled_image: Function ScaleImage returns a pointer to the image after H %      scaling.  A null image is returned if there is a memory shortage. %;7 %    o image: The address of a structure of type Image.e %iM %    o columns: An integer that specifies the number of columns in the scaled 
 %      image.i %eG %    o rows: An integer that specifies the number of rows in the scaled+
 %      image.  %  %  */% Image *ScaleImage(image,columns,rows)e Imagec	   *image;e   unsigned int
   columns,   rows;k {u   typedef struct ScaledPacket    {      long
       red,       green,       blue,m       index;   } ScaledPacket;      Imagei     *scaled_image;     int 
     next_row,(     number_rows;     long     x_scale,     x_span;      register RunlengthPacket     *p,g     *q;t     register ScaledPacket      *s,u     *t;      register unsigned int      x;     ScaledPacket     *scaled_scanline,r     *scanline,     *y_vector,     *x_vector;     unsigned int     y;     unsigned long=	     blue,N
     green,
     index,     red;  $   if ((columns == 0) || (rows == 0))     { C       Warning("Unable to scale image","image dimensions are zero");h       return((Image *) NULL);g     }l8   if ((columns > MaxImageSize) || (rows > MaxImageSize))     {>9       Warning("Unable to scale image","image too large");g       return((Image *) NULL);h     }    /*'     Initialize scaled image attributes.r   */3   scaled_image=CopyImage(image,columns,rows,False);m%   if (scaled_image == (Image *) NULL)      {yB       Warning("Unable to scale image","Memory allocation failed");       return((Image *) NULL);0     }r"   scaled_image->class=DirectClass;   /*     Allocate memory.   */H   x_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));   scanline=x_vector;(   if (scaled_image->rows != image->rows)J     scanline=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));"   scaled_scanline=(ScaledPacket *)7     malloc(scaled_image->columns*sizeof(ScaledPacket));rH   y_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));,   if ((x_vector == (ScaledPacket *) NULL) ||,       (scanline == (ScaledPacket *) NULL) ||3       (scaled_scanline == (ScaledPacket *) NULL) ||l*       (y_vector == (ScaledPacket *) NULL))     { B       Warning("Unable to scale image","Memory allocation failed");!       DestroyImage(scaled_image);        return((Image *) NULL);=     }    /*     Scale image.   */   number_rows=0;   next_row=True;2   x_scale=UpShift(scaled_image->rows)/image->rows;   x_span=UpShift(1);$   for (x=0; x < image->columns; x++)   {      y_vector[x].red=0;     y_vector[x].green=0;     y_vector[x].blue=0;      y_vector[x].index=0;   }    p=image->pixels;   image->runlength=p->length+1;    q=scaled_image->pixels; (   for (y=0; y < scaled_image->rows; y++)   { *     if (scaled_image->rows == image->rows)(       for (x=0; x < image->columns; x++)       { 
         /*           Read a new scanline.
         */"         if (image->runlength != 0)           image->runlength--;          else           {              p++;'             image->runlength=p->length;%           }%         x_vector[x].red=p->red;%#         x_vector[x].green=p->green;g!         x_vector[x].blue=p->blue;s#         x_vector[x].index=p->index;e       }f     else       {r
         /*           Scale Y direction.
         */          while (x_scale < x_span)	         { 6           if (next_row && (number_rows < image->rows))
             {o               /*$                 Read a new scanline.               */0               for (x=0; x < image->columns; x++)               {0*                 if (image->runlength != 0)%                   image->runlength--;n                 else                   {                      p++;/                     image->runlength=p->length;L                   }s'                 x_vector[x].red=p->red;%+                 x_vector[x].green=p->green;r)                 x_vector[x].blue=p->blue;-+                 x_vector[x].index=p->index;|               }r               number_rows++;
             } ,           for (x=0; x < image->columns; x++)           {o5             y_vector[x].red+=x_scale*x_vector[x].red;c9             y_vector[x].green+=x_scale*x_vector[x].green;x7             y_vector[x].blue+=x_scale*x_vector[x].blue; 9             y_vector[x].index+=x_scale*x_vector[x].index;a           }            x_span-=x_scale;:           x_scale=UpShift(scaled_image->rows)/image->rows;           next_row=True;	         }t4         if (next_row && (number_rows < image->rows))           {C             /*"               Read a new scanline.             */.             for (x=0; x < image->columns; x++)
             { (               if (image->runlength != 0)#                 image->runlength--;e               else                 {a                   p++;-                   image->runlength=p->length;g                 } %               x_vector[x].red=p->red;-)               x_vector[x].green=p->green;l'               x_vector[x].blue=p->blue;-)               x_vector[x].index=p->index;%
             }%             number_rows++;             next_row=False;%           }          s=scanline; *         for (x=0; x < image->columns; x++)	         { @           red=DownShift(y_vector[x].red+x_span*x_vector[x].red);F           green=DownShift(y_vector[x].green+x_span*x_vector[x].green);C           blue=DownShift(y_vector[x].blue+x_span*x_vector[x].blue); F           index=DownShift(y_vector[x].index+x_span*x_vector[x].index);-           s->red=red > MaxRGB ? MaxRGB : red; 3           s->green=green > MaxRGB ? MaxRGB : green; 0           s->blue=blue > MaxRGB ? MaxRGB : blue;E           s->index=index > MaxColormapSize ? MaxColormapSize : index;            s++;           y_vector[x].red=0;           y_vector[x].green=0;           y_vector[x].blue=0;u           y_vector[x].index=0;	         }i         x_scale-=x_span;         if (x_scale == 0)e           { <             x_scale=UpShift(scaled_image->rows)/image->rows;             next_row=True;           }          x_span=UpShift(1);       } 0     if (scaled_image->columns == image->columns)       {a
         /*,           Transfer scanline to scaled image.
         */         s=scanline; 1         for (x=0; x < scaled_image->columns; x++) 	         { (           q->red=(unsigned char) s->red;,           q->green=(unsigned char) s->green;*           q->blue=(unsigned char) s->blue;-           q->index=(unsigned short) s->index;h           q->length=0;           q++;           s++;	         }i       }s     else       {s         int            next_column;           long int           y_scale,           y_span;I  
         /*           Scale X direction.
         */         red=0;         green=0;         blue=0;          next_column=False;         y_span=UpShift(1);         s=scanline;a         t=scaled_scanline;*         for (x=0; x < image->columns; x++)	         {g@           y_scale=UpShift(scaled_image->columns)/image->columns;#           while (y_scale >= y_span)=           {;             if (next_column)               {                  red=0;                 green=0;                 blue=0;a                 index=0;                 t++;               } -             red=DownShift(red+y_span*s->red); 3             green=DownShift(green+y_span*s->green);+0             blue=DownShift(blue+y_span*s->blue);3             index=DownShift(index+y_span*s->index); /             t->red=red > MaxRGB ? MaxRGB : red; 5             t->green=green > MaxRGB ? MaxRGB : green; 2             t->blue=blue > MaxRGB ? MaxRGB : blue;G             t->index=index > MaxColormapSize ? MaxColormapSize : index;              y_scale-=y_span;             y_span=UpShift(1);             next_column=True;            };         if (y_scale > 0)           {              if (next_column)               {                  red=0;                 green=0;                 blue=0;                  index=0;"                 next_column=False;                 t++;               }               red+=y_scale*s->red;$             green+=y_scale*s->green;"             blue+=y_scale*s->blue;$             index+=y_scale*s->index;             y_span-=y_scale;           };         s++;       }        if (y_span > 0) 	         {            s--;           red+=y_span*s->red; !           green+=y_span*s->green;            blue+=y_span*s->blue; !           index+=y_span*s->index; 	         }i       if (!next_column) 	         {q           red=DownShift(red);0!           green=DownShift(green);}           blue=DownShift(blue);_!           index=DownShift(index);c-           t->red=red > MaxRGB ? MaxRGB : red; 3           t->green=green > MaxRGB ? MaxRGB : green; 0           t->blue=blue > MaxRGB ? MaxRGB : blue;3           t->index=index > MaxRGB ? MaxRGB : index; 	         }U       /**         Transfer scanline to scaled image.       */       t=scaled_scanline;/       for (x=0; x < scaled_image->columns; x++)i       {s&         q->red=(unsigned char) t->red;*         q->green=(unsigned char) t->green;(         q->blue=(unsigned char) t->blue;+         q->index=(unsigned short) t->index;=         q->length=0;         q++;         t++;       }d     })   }o   /*     Free allocated memory.   */   free((char *) y_vector);!   free((char *) scaled_scanline);L   if (scanline != x_vector)      free((char *) scanline);   free((char *) x_vector);   return(scaled_image);  }b e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %_O %                                                                             % O %                                                                             %nO %   S e t I m a g e M a g i c k                                               %pO %                                                                             %;O %                                                                             %lO %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %*J %  Function SetImageMagick initializes the `magick' field of the ImageInfoI %  structure.  It is set to a type of image format based on the prefix oruI %  suffix of the filename.  For example, `ps:image' returns PS indicating-H %  a Postscript image.  JPEG is returned for this filename: `image.jpg'.M %  The filename prefix has precedance over the suffix.  Use an optional indexeL %  enclosed in brackets after a file name to specify a desired subimage of aE %  multi-resolution image format like Photo CD (e.g. img0001.pcd[4]).o %n/ %  The format of the SetImageMagick routine is:[ %-! %      SetImageMagick(image_info)r %_+ %  A description of each parameter follows:g %c@ %    o image_info: Specifies a pointer to a ImageInfo structure. %g %c */ void SetImageMagick(image_info)e	 ImageInfo    *image_info; {e
   static chara     *ImageFormats[]=     {        "AVS",       "BMP",
       "CMYK",0       "EPS",
       "EPSF",l
       "EPSI",a       "FAX",
       "FITS",c       "FTP",       "GIF",       "GIF87",       "GOPHER",-
       "GRAY",n       "G3",        "HISTOGRAM",
       "HTTP",m
       "IRIS",b
       "JPEG",f       "JPG",
       "LOGO",m       "MAP",       "MATTE",
       "MIFF",;       "MPG",
       "MPEG",c       "MTV",
       "NULL",d       "PBM",       "PCD",       "PCX",       "PGM",
       "PICT",        "PM",        "PPM",       "PNM",       "PS",        "PS2",       "RAD",       "RAS",       "RGB",       "RLE",       "SUN",       "TGA",
       "TEXT",        "TIF",
       "TIFF",        "VICAR",       "VID",
       "VIFF",;
       "X",       "XBM",       "XC",        "XPM",       "XV",        "XWD",       "YUV",
       "YUV3",l       (char *) NULL,     };     char     c,     magick[MaxTextLength];     register chark     *p,)     *q;      register int     i;     /*(     Look for 'image.format' in filename.   */   *magick='\0'; 8   p=image_info->filename+strlen(image_info->filename)-1;   if (*p == ']')     {        /*F         Look for sub-image enclosed in brackets (e.g. img0001.pcd[4]).       */0       for (q=p-1; q > image_info->filename; q--)         if (!isdigit(*q))            break;       if (*q == '[')	         {            p=q++;'           image_info->subimage=atoi(q);            *p='\0';	         }      } 3   while ((*p != '.') && (p > image_info->filename))      p--;6   if ((strcmp(p,".gz") == 0) || (strcmp(p,".Z") == 0))     do     { 
       p--;8     } while ((*p != '.') && (p > image_info->filename));2   if ((*p == '.') && (strlen(p) < sizeof(magick)))     {e       /*$         User specified image format.       */        (void) strcpy(magick,p+1);%       for (q=magick; *q != '\0'; q++)        {d         if (*q == '.')           {              *q='\0';             break;           }I         c=(*q);/%         if (isascii(c) && islower(c))i           *q=toupper(c);       } 6       for (i=0; ImageFormats[i] != (char *) NULL; i++)0         if (strcmp(magick,ImageFormats[i]) == 0)           {              /*)               IRIS and RGB are ambiguous.e             */;             if ((strcmp(image_info->magick,"IRIS") != 0) || 5                 (strcmp(ImageFormats[i],"RGB") != 0))d7               (void) strcpy(image_info->magick,magick);              break;           };     }(   /*1     Look for explicit 'format:image' in filename.g   */   image_info->assert=False;e   p=image_info->filename; %   while ((*p != ':') && (*p != '\0')))     p++;A   if ((*p == ':') && ((p-image_info->filename) < sizeof(magick)))s     {e       /*$         User specified image format.       */I       (void) strncpy(magick,image_info->filename,p-image_info->filename);/*       magick[p-image_info->filename]='\0';%       for (q=magick; *q != '\0'; q++))       {(         c=(*q);e%         if (isascii(c) && islower(c))e           *q=toupper(c);       } 6       for (i=0; ImageFormats[i] != (char *) NULL; i++)0         if (strcmp(magick,ImageFormats[i]) == 0)           {%             /*,               Strip off image format prefix.             */             p++;2             (void) strcpy(image_info->filename,p);5             (void) strcpy(image_info->magick,magick); $             image_info->assert=True;             break;           }      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     S h a r p e n I m a g e                                                 % O %                                                                             %%O %                                                                             %eO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %oJ %  Function SharpenImage creates a new image that is a copy of an existingL %  one with the pixels sharpened.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. %hK %  SharpenImage convolves the pixel neighborhood with this sharpening mask:  % 
 %    -1 -2 -1e
 %    -2  W -2e
 %    -1 -2 -1  %tL %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.% %%- %  The format of the SharpenImage routine is:  % 1 %      sharpened_image=SharpenImage(image,factor)  % + %  A description of each parameter follows:  % L %    o sharpened_image: Function SharpenImage returns a pointer to the imageL %      after it is sharpened.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %% %% */! Image *SharpenImage(image,factor)  Imagen	   *image;s   double	   factor;m {  #define Sharpen(weight) \n'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \w)   total_blue+=(weight)*(int) (s->blue); \h+   total_index+=(weight)*(int) (s->index); \e   s++;     Image      *sharpened_image;n  
   long int     total_blue,      total_green,     total_index,     total_red,     weight;      register RunlengthPacket     *p,e     *q,      *s,b     *s0,     *s1,     *s2;     register unsigned intt     x;     RunlengthPacket      *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     {aF       Warning("Unable to sharpen image","image size must exceed 3x3");       return((Image *) NULL);      }a   /**     Initialize sharpened image attributes.   */D   sharpened_image=CopyImage(image,image->columns,image->rows,False);(   if (sharpened_image == (Image *) NULL)     {ID       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);o     }+%   sharpened_image->class=DirectClass;r   /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)i     {nD       Warning("Unable to enhance image","Memory allocation failed");$       DestroyImage(sharpened_image);       return((Image *) NULL);k     }p   /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline;U+   for (x=0; x < (image->columns << 1); x++)d   {)     if (image->runlength != 0)       image->runlength--;a     else       {          p++;#         image->runlength=p->length;e       }o     *s=(*p);     s++;   }    /*!     Dump first scanline of image.    */   q=sharpened_image->pixels;
   s=scanline;r$   for (x=0; x < image->columns; x++)   {      *q=(*s);     q->index=0;i     q->length=0;     q++;     s++;   }e   /*     Convolve each row.   */*   weight=(long int) ((100.0-factor)/2+13);   quantum=Max(weight-12,1);o%   for (y=1; y < (image->rows-1); y++)    {e     /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3);u+     s2=scanline+image->columns*((y+1) % 3);t     /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--;m
       else	         {            p++;%           image->runlength=p->length;+	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.t     */
     *q=(*s1);      q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {l       /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;b       total_index=0;       s=s0; ,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       s=s1;o0       Sharpen(-2); Sharpen(weight); Sharpen(-2);       s=s2;n,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       if (total_red < 0)         q->red=0;s
       else)         if (total_red > (MaxRGB*quantum))            q->red=MaxRGB;         elseF           q->red=(unsigned char) ((total_red+(quantum >> 1))/quantum);       if (total_green < 0)         q->green=0;n
       else+         if (total_green > (MaxRGB*quantum))            q->green=MaxRGB;         elseJ           q->green=(unsigned char) ((total_green+(quantum >> 1))/quantum);       if (total_blue < 0)          q->blue=0;
       else*         if (total_blue > (MaxRGB*quantum))           q->blue=MaxRGB;          elseH           q->blue=(unsigned char) ((total_blue+(quantum >> 1))/quantum);       if (total_index < 0)         q->index=0; 
       else+         if (total_index > (MaxRGB*quantum))m           q->index=MaxRGB;         elseK           q->index=(unsigned short) ((total_index+(quantum >> 1))/quantum);s       q->length=0;
       q++;       s0++;        s1++;_       s2++;      }a     /**       Transfer last pixel of the scanline.     */	     s1++;_
     *q=(*s1);      q->length=0;     q++;   }    /*!     Dump last scanline of pixels.a   */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {B     *q=(*s);     q->length=0;     q++;     s++;   }l   free((char *) scanline);   return(sharpened_image); }o _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             % O %                                                                             % O %   S o r t C o l o r m a p B y I n t e n t s i t y                           % O %                                                                             %eO %                                                                             %aO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%M %  Function SortColormapByIntensity sorts the colormap of a PseudoClass image ! %  by decreasing color intensity.  % 8 %  The format of the SortColormapByIntensity routine is: % % %      SortColormapByIntensity(image)  % + %  A description of each parameter follows:  % - %    o image: A pointer to a Image structure.  %  %  */  static int IntensityCompare(x,y)
 const void   *x,    *y;  { 
   ColorPacket 
     *color_1, 
     *color_2;      color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }%  # void SortColormapByIntensity(image)% Image 	   *image;n {o   register int     i;     register RunlengthPacket     *p;      register unsigned shorth
     index;     unsigned short     *pixels;  "   if (image->class != PseudoClass)     return;    /*&     Allocate memory for pixel indexes.   */I   pixels=(unsigned short *) malloc(image->colors*sizeof(unsigned short));0(   if (pixels == (unsigned short *) NULL)     {sD       Warning("Unable to sort colormap","Memory allocation failed");
       return;d     }p   /*,     Assign index values to colormap entries.   */#   for (i=0; i < image->colors; i++)u0     image->colormap[i].index=(unsigned short) i;   /*7     Sort image colormap by decreasing color popularity.e   */I   qsort((void *) image->colormap,(int) image->colors,sizeof(ColorPacket),sG     (int (*) _Declare((const void *, const void *))) IntensityCompare);    /*;     Update image colormap indexes to sorted colormap order.e   */#   for (i=0; i < image->colors; i++)g8     pixels[image->colormap[i].index]=(unsigned short) i;   p=image->pixels;$   for (i=0; i < image->packets; i++)   {r     index=pixels[p->index];)&     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p->index=index;a     p++;   }i   free((char *) pixels); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %aO %                                                                             %)O %   S t e r e o I m a g e                                                     %yO %                                                                             %LO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %cL %  Function StereoImage combines two images and produces a single image thatI %  is the composite of a left and right image of a stereo pair.  The leftMH %  image is converted to grayscale and written to the red channel of theN %  stereo image.  The right image is converted to grayscale and written to theL %  blue channel of the stereo image.  View the composite image with red-blue% %  glasses to create a stereo effect.  % , %  The format of the StereoImage routine is: %r7 %      stereo_image=StereoImage(left_image,right_image)m %-+ %  A description of each parameter follows:; % I %    o stereo_image: Function StereoImage returns a pointer to the stereopF %      image.  A null image is returned if there is a memory shortage. %a< %    o left_image: The address of a structure of type Image. %_= %    o right_image: The address of a structure of type Image.  %b %g */* Image *StereoImage(left_image,right_image) Imageo   *left_image,   *right_image;> {s   Image      *stereo_image;     register int     i;     register RunlengthPacket     *p,m     *q,m     *r;   6   if ((left_image->columns != right_image->columns) ||.       (left_image->rows != right_image->rows))     {d.       Warning("Unable to create stereo image",-         "left and right image sizes differ");        return((Image *) NULL);      }g   /*'     Initialize stereo image attributes.    */P   stereo_image=CopyImage(left_image,left_image->columns,left_image->rows,False);%   if (stereo_image == (Image *) NULL)p     { J       Warning("Unable to create stereo image","Memory allocation failed");       return((Image *) NULL);      } "   stereo_image->class=DirectClass;   /*C     Copy left image to red channel and right image to blue channel.o   */7   QuantizeImage(left_image,256,8,False,GRAYColorspace);    SyncImage(left_image);   p=left_image->pixels; $   left_image->runlength=p->length+1;8   QuantizeImage(right_image,256,8,False,GRAYColorspace);   SyncImage(right_image);    q=right_image->pixels;%   right_image->runlength=q->length+1;    r=stereo_image->pixels; @   for (i=0; i < (stereo_image->columns*stereo_image->rows); i++)   {o#     if (left_image->runlength != 0)r       left_image->runlength--;     else       {o         p++;(         left_image->runlength=p->length;       } $     if (right_image->runlength != 0)       right_image->runlength--;g     else       {)         q++;)         right_image->runlength=q->length;        }-+     r->red=(unsigned int) (p->red*12) >> 4;      r->green=0;      r->blue=q->blue;     r->index=0;      r->length=0;     r++;   }a   return(stereo_image);c }o _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %hO %                                                                             %;O %                                                                             %%O %   S y n c I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function SyncImage initializes the red, green, and blue intensities of each* %  pixel as defined by the colormap index. %%* %  The format of the SyncImage routine is: %% %      SyncImage(image)  %F+ %  A description of each parameter follows:  %a7 %    o image: The address of a structure of type Image.a %c %s */ void SyncImage(image)h Image 	   *image;r {u   register int     i;     register RunlengthPacket     *p;      register unsigned shortx
     index;     p=image->pixels;$   for (i=0; i < image->packets; i++)   {      index=p->index; &     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p++;   }o }t a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %,O %                                                                             %fO %                                                                             %aO %   T r a n s f o r m I m a g e                                               %:O %                                                                             %eO %                                                                             %iO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %gL %  Function TransformImage creates a new image that is a transformed size ofE %  of existing one as specified by the crop and image geometries.  ItnK %  allocates the memory necessary for the new Image structure and returns an %  pointer to the new image. % H %  If a crop geometry is specified a subregion of the image is obtained.M %  If the specified image size, as defined by the image and scale geometries, J %  is smaller than the actual image size, the image is first reduced to anN %  integral of the specified image size with an antialias digital filter.  TheD %  image is then scaled to the exact specified image size with pixelM %  replication.  If the specified image size is greater than the actual imagelJ %  size, the image is first enlarged to an integral of the specified imageK %  size with bilinear interpolation.  The image is then scaled to the exacta/ %  specified image size with pixel replication.o %_/ %  The format of the TransformImage routine is:> %s9 %      TransformImage(image,crop_geometry,image_geometry)a %s+ %  A description of each parameter follows:) %LJ %    o image: The address of an address of a structure of type Image.  The7 %      transformed image is returned as this parameter.s % D %    o crop_geometry: Specifies a pointer to a crop geometry string.6 %      This geometry defines a subregion of the image. %eF %    o image_geometry: Specifies a pointer to a image geometry string.K %      The specified width and height of this geometry string are absolute.( %l %t */7 void TransformImage(image,crop_geometry,image_geometry)  Imagec
   **image;   char   *crop_geometry,    *image_geometry; {a   Imageh     *transformed_image;a     inte
     flags;     unsigned int     height,      sharpen,
     width;     transformed_image=(*image);f%   if (crop_geometry != (char *) NULL)m     {x       Image-         *cropped_image;          RectangleInfox         crop_info;         /*,         Crop image to a user specified size.       */       crop_info.x=0;       crop_info.y=0;       flags=O         XParseGeometry(crop_geometry,&crop_info.x,&crop_info.y,&width,&height);f$       if ((flags & WidthValue) == 0)L         width=(unsigned int) ((int) transformed_image->columns-crop_info.x);%       if ((flags & HeightValue) == 0)nJ         height=(unsigned int) ((int) transformed_image->rows-crop_info.y);#       if ((flags & XNegative) != 0) 6         crop_info.x+=transformed_image->columns-width;#       if ((flags & YNegative) != 0)(4         crop_info.y+=transformed_image->rows-height;5       if (strchr(crop_geometry,'%') != (char *) NULL)s	         {g           /*4             Crop geometry is relative to image size.           */;           ParseImageGeometry(crop_geometry,&width,&height);0           crop_info.x=width;           crop_info.y=height;h8           width=transformed_image->columns-(width << 1);7           height=transformed_image->rows-(height << 1); 	         }        crop_info.width=width;       crop_info.height=height;<       cropped_image=CropImage(transformed_image,&crop_info);*       if (cropped_image != (Image *) NULL)	         {t*           DestroyImage(transformed_image);*           transformed_image=cropped_image;	         }      }    /*)     Scale image to a user specified size.m   */#   width=transformed_image->columns; !   height=transformed_image->rows;04   ParseImageGeometry(image_geometry,&width,&height);2   sharpen=(transformed_image->columns != width) ||(     (transformed_image->rows != height);8   while ((transformed_image->columns >= (width << 1)) &&4          (transformed_image->rows >= (height << 1)))   {)	     Image)       *reduced_image;        /*3       Reduce image with a antialias digital filter.;     */1     reduced_image=ReduceImage(transformed_image);;(     if (reduced_image == (Image *) NULL)       break;$     DestroyImage(transformed_image);$     transformed_image=reduced_image;   }c8   while ((transformed_image->columns <= (width >> 1)) &&4          (transformed_image->rows <= (height >> 1)))   {l	     Image1       *zoomed_image;       /*-       Zoom image with bilinear interpolation.>     */.     zoomed_image=ZoomImage(transformed_image);'     if (zoomed_image == (Image *) NULL)1       break;$     DestroyImage(transformed_image);#     transformed_image=zoomed_image;e   } .   if ((transformed_image->columns != width) ||*       (transformed_image->rows != height))     {n       Image          *scaled_image;         /*+         Scale image with pixel replication.        */>       scaled_image=ScaleImage(transformed_image,width,height);)       if (scaled_image != (Image *) NULL)=	         {;*           DestroyImage(transformed_image);)           transformed_image=scaled_image;%	         }%     }%   if (sharpen)L     if ((transformed_image->columns >= 3) && (transformed_image->rows >= 3))       { 
         Image            *sharpened_image;   
         /*           Sharpen image.
         */F         sharpened_image=SharpenImage(transformed_image,SharpenFactor);.         if (sharpened_image != (Image *) NULL)           { ,             DestroyImage(transformed_image);.             transformed_image=sharpened_image;           }        }    *image=transformed_image;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             %mO %                                                                             %aO %     T r a n s f o r m R G B I m a g e                                       %sO %                                                                             %eO %                                                                             %eO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function TransformRGBImage converts the reference image from an alternateK %  colorspace.  The transformation matrices are not the standard ones:  the)L %  weights are rescaled to normalized the range of the transformed values to %  be [0..255].q %i2 %  The format of the TransformRGBImage routine is: %n* %      TransformRGBImage(image,colorspace) %)+ %  A description of each parameter follows:L %|F %    o image: The address of a structure of type Image;  returned from %      ReadImage.l % J %    o colorspace: An unsigned integer value that indicates the colorspaceD %      the image is currently in.  On return the image is in the RGB %      color space.; %  %  */( void TransformRGBImage(image,colorspace) Imagen	   *image;]   unsigned int
   colorspace;  {  #define R 0r #define G (MaxRGB+1) #define B (MaxRGB+1)*2     long
     *blue,     *green,x	     *red;      register int     i,     x,     y,     z;     register RunlengthPacket     *p;[     register unsigned char     *range_limit;a     unsigned charr     *range_table;   F   if ((colorspace == RGBColorspace) || (colorspace == GRAYColorspace))     return;    /*     Allocate the tables.   */1   red=(long *) malloc(3*(MaxRGB+1)*sizeof(long));x3   green=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); 2   blue=(long *) malloc(3*(MaxRGB+1)*sizeof(long));K   range_table=(unsigned char *) malloc(3*(MaxRGB+1)*sizeof(unsigned char));c;   if ((red == (long *) NULL) || (green == (long *) NULL) || I       (blue == (long *) NULL) || (range_table == (unsigned char *) NULL))d     { L       Warning("Unable to transform color space","Memory allocation failed");
       return;      }    /*     Initialize tables.   */   for (i=0; i <= MaxRGB; i++)    {q     range_table[i]=0;e0     range_table[i+(MaxRGB+1)]=(unsigned char) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;[   }d%   range_limit=range_table+(MaxRGB+1);    switch (colorspace)[   {e     case OHTAColorspace:     {]       /*         Initialize OHTA tables:q  &           R = I1+1.00000*I2-0.66668*I3&           G = I1+0.00000*I2+1.33333*I3&           B = I1-1.00000*I2-0.66668*I3  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0%         through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)        { &         red[i+R]=UpShifted(1.00000)*i;;         green[i+R]=UpShifted(1.0000*0.5)*((i << 1)-MaxRGB); >         blue[i+R]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);&         red[i+G]=UpShifted(1.00000)*i;         green[i+G]=0; ;         blue[i+G]=UpShifted(1.33333*0.5)*((i << 1)-MaxRGB); &         red[i+B]=UpShifted(1.00000)*i;?         green[i+B]=(-UpShifted(1.00000*0.5))*((i << 1)-MaxRGB); >         blue[i+B]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);       }        break;     }      case XYZColorspace:%     {%       /*'         Initialize XYZ ITU601-1t ables:%  ,           R =  3.06270*R-1.39280*G-0.47590*B,           G = -0.96890*R+1.87560*G+0.04170*B,           B =  0.05850*R-0.22860*G+1.06900*B       */!       for (i=0; i <= MaxRGB; i++)u       {t&         red[i+R]=UpShifted(3.06270)*i;+         green[i+R]=(-UpShifted(1.39280))*i; *         blue[i+R]=(-UpShifted(0.47590))*i;)         red[i+G]=(-UpShifted(0.96890))*i; (         green[i+G]=UpShifted(1.87560)*i;'         blue[i+G]=UpShifted(0.04170)*i; &         red[i+B]=UpShifted(0.05850)*i;+         green[i+B]=(-UpShifted(0.22860))*i;.'         blue[i+B]=UpShifted(1.06900)*i;c       }y       break;     }/     case YCbCrColorspace:      {        /*          Initialize YCbCr tables:  %           R = Y           +1.40200*Cr %           G = Y-0.34560*Cb-0.71450*Crg           B = Y+1.77100*Cb  O         Cb and Cr, normally -0.5 through 0.5, must be normalized to the range 0.         through MaxRGB.o       */!       for (i=0; i <= MaxRGB; i++)e       {(&         red[i+R]=UpShifted(1.00000)*i;         green[i+R]=0; ;         blue[i+R]=UpShifted(1.40200*0.5)*((i << 1)-MaxRGB);m&         red[i+G]=UpShifted(1.00000)*i;?         green[i+G]=(-UpShifted(0.34560*0.5))*((i << 1)-MaxRGB);(>         blue[i+G]=(-UpShifted(0.71450*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(1.00000)*i;<         green[i+B]=UpShifted(1.77100*0.5)*((i << 1)-MaxRGB);         blue[i+B]=0;       }        break;     }i     case YCCColorspace:g     {L       /*         Initialize YCC tables:  %           R = Y           +1.34092*C2h%           G = Y-0.31675*C1-0.68253*C2l           B = Y+1.63273*C1  B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */!       for (i=0; i <= MaxRGB; i++)        { &         red[i+R]=UpShifted(1.35840)*i;         green[i+R]=0; -         blue[i+R]=UpShifted(1.82150)*(i-137); &         red[i+G]=UpShifted(1.35840)*i;1         green[i+G]=(-UpShifted(0.43027))*(i-156);;0         blue[i+G]=(-UpShifted(0.92715))*(i-137);&         red[i+B]=UpShifted(1.35840)*i;.         green[i+B]=UpShifted(2.21790)*(i-156);         blue[i+B]=0;       }        break;     }n     case YIQColorspace:      {        /*         Initialize YIQ tables:  +           R = 0.97087*Y+1.17782*I+0.59800*Q%+           G = 0.97087*Y-0.28626*I-0.72851*Q%+           B = 0.97087*Y-1.27870*I+1.72801*Q   M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)        { &         red[i+R]=UpShifted(0.97087)*i;<         green[i+R]=UpShifted(1.17782*0.5)*((i << 1)-MaxRGB);;         blue[i+R]=UpShifted(0.59800*0.5)*((i << 1)-MaxRGB); &         red[i+G]=UpShifted(0.97087)*i;?         green[i+G]=(-UpShifted(0.28626*0.5))*((i << 1)-MaxRGB); >         blue[i+G]=(-UpShifted(0.72851*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(0.97087)*i;?         green[i+B]=(-UpShifted(1.27870*0.5))*((i << 1)-MaxRGB);%;         blue[i+B]=UpShifted(1.72801*0.5)*((i << 1)-MaxRGB);g       }f       break;     }n     case YPbPrColorspace:o     {l       /*          Initialize YPbPr tables:  %           R = Y           +1.57560*C2 %           G = Y-0.22530*C1+0.50000*C2e           B = Y+1.82700*C1  O         Pb and Pr, normally -0.5 through 0.5, must be normalized to the range 0o         through MaxRGB.i       */!       for (i=0; i <= MaxRGB; i++)        { &         red[i+R]=UpShifted(1.00000)*i;         green[i+R]=0;s;         blue[i+R]=UpShifted(1.57560*0.5)*((i << 1)-MaxRGB);f&         red[i+G]=UpShifted(1.00000)*i;?         green[i+G]=(-UpShifted(0.22530*0.5))*((i << 1)-MaxRGB); ;         blue[i+G]=UpShifted(0.50000*0.5)*((i << 1)-MaxRGB); &         red[i+B]=UpShifted(1.00000)*i;<         green[i+B]=UpShifted(1.82700*0.5)*((i << 1)-MaxRGB);         blue[i+B]=0;       }e       break;     }      case YUVColorspace:m     default:     {a       /*         Initialize YUV tables:  #           R = Y          +1.13980*VU#           G = Y-0.39380*U-0.58050*Va           B = Y+2.02790*Un  M         U and V, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.e       */!       for (i=0; i <= MaxRGB; i++)z       {n&         red[i+R]=UpShifted(1.00000)*i;         green[i+R]=0; ;         blue[i+R]=UpShifted(1.13980*0.5)*((i << 1)-MaxRGB);n&         red[i+G]=UpShifted(1.00000)*i;?         green[i+G]=(-UpShifted(0.39380*0.5))*((i << 1)-MaxRGB);c>         blue[i+G]=(-UpShifted(0.58050*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(1.00000)*i;<         green[i+B]=UpShifted(2.02790*0.5)*((i << 1)-MaxRGB);         blue[i+B]=0;       }n       break;     }    }m   /*     Convert to RGB.    */   switch (image->class))   {      case DirectClass:      {        /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          x=p->red;n         y=p->green;n         z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])]; G         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];*F         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;       }%       break;     }%     case PseudoClass:      {        /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)        { !         x=image->colormap[i].red; #         y=image->colormap[i].green; "         z=image->colormap[i].blue;         image->colormap[i].red= @           range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];!         image->colormap[i].green= @           range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];          image->colormap[i].blue=@           range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       {%         x=p->red;%         y=p->green;F         z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];tG         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];rF         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;       }a       break;     }i   }f   /*     Free allocated memory.   */   free((char *) range_table);o   free((char *) blue);   free((char *) green);s   free((char *) red);m }: n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %eO %                                                                             %hO %     T r a n s p a r e n t I m a g e                                         % O %                                                                             % O %                                                                             %tO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function TransparentImage creates a matte image associated with theF %  image.  All pixel locations are initially set to opague.  Any pixel; %  that matches the specified color are set to transparent.l %t1 %  The format of the TransparentImage routine is:e %n$ %      TransparentImage(image,color) % + %  A description of each parameter follows:r % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.g % B %    o color: A character string that contain an X11 color string. %a %t */" void TransparentImage(image,color) Image 	   *image;    char	   *color;t {  #define DeltaX 8  	   Display 
     *display;      register int     i;     register RunlengthPacket     *p;h     unsigned char(	     blue,i
     green,     red;     XPixelInfo     pixel_info;w     XResourceInfon     resource_info;  
   XrmDatabase      resource_database;     XStandardColormapi     *map_info;  
   XVisualInfo      *visual_info;L     /*     Open X server connection.e   */&   display=XOpenDisplay((char *) NULL);"   if (display == (Display *) NULL)     {hK       Warning("Unable to connect to X server",XDisplayName((char *) NULL));(
       return;e     }"   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);-   /*/     Get user defaults from X resource database..   */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);.)   resource_info.colormap=PrivateColormap;t$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)oM     Warning("Unable to create standard colormap","Memory allocation failed");t   else     {        /*         Initialize visual info.        */C       visual_info=XBestVisualInfo(display,map_info,&resource_info);d.       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;e/       pixel_info.pixels=(unsigned long *) NULL;      }q1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {gF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);
       return;t     })   /*!     Initialize Standard Colormap.x   */H   XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),     map_info);'   resource_info.foreground_color=color;tK   XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,b     &pixel_info); 2   red=ColorShift(pixel_info.foreground_color.red);6   green=ColorShift(pixel_info.foreground_color.green);4   blue=ColorShift(pixel_info.foreground_color.blue);   /*     Free resources.    */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   XCloseDisplay(display);q   /*!     Make image color transparent.t   */   p=image->pixels;   switch (image->class)    {o     case DirectClass:      {        /*+         Make DirectClass image transparent.        */       if (!image->matte)	         {q           /*-             Initialize image matte to opague.h           */,           for (i=0; i < image->packets; i++)           {              p->index=Opaque;             p++;           }+           image->matte=True;           p=image->pixels;	         } (       for (i=0; i < image->packets; i++)       {g2         if (((int) p->red < (int) (red+DeltaX)) &&2             ((int) p->red > (int) (red-DeltaX)) &&6             ((int) p->green < (int) (green+DeltaX)) &&6             ((int) p->green > (int) (green-DeltaX)) &&4             ((int) p->blue < (int) (blue+DeltaX)) &&2             ((int) p->blue > (int) (blue-DeltaX)))           p->index=Transparent;.         p++;       }k       break;     }      case PseudoClass:      {q       register int         index;         unsigned longt         blue_distance,         distance,          green_distance,;         min_distance,o         red_distance;          /*         Find closest color.        */(       min_distance=(unsigned long) (~0);       index=0;'       for (i=0; i < image->colors; i++)        {e<         red_distance=(int) red-(int) image->colormap[i].red;B         green_distance=(int) green-(int) image->colormap[i].green;?         blue_distance=(int) blue-(int) image->colormap[i].blue; I         distance=red_distance*red_distance+green_distance*green_distance+c&           blue_distance*blue_distance;$         if (distance < min_distance)           {0"             min_distance=distance;             index=i;           }        }b       /*+         Make PseudoClass image transparent.+       */       image->class=DirectClass;x       image->matte=True;(       for (i=0; i < image->packets; i++)       {;         if (p->index == index)           p->index=Transparent;)         else           p->index=Opaque;         p++;       }q       break;     }t   }m }n > /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %+O %                                                                             %xO %                                                                             %iO %   U n C o m p r e s s I m a g e                                             % O %                                                                             % O %                                                                             %eO %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %aL %  Function UncompressImage uncompresses runlength-encoded pixels packets to! %  a rectangular array of pixels.k % 0 %  The format of the UncompressImage routine is: %h$ %      status=UncompressImage(image) %g+ %  A description of each parameter follows:q %mD %    o status: Function UncompressImage returns True if the image is$ %      uncompressed otherwise False. %d7 %    o image: The address of a structure of type Image.  %  %x */# unsigned int UncompressImage(image)  Imagea	   *image;c {m   register int     i,     j,     length;a     register RunlengthPacket     *p,e     *q;;     RunlengthPacketk     *uncompressed_pixels;   5   if (image->packets == (image->columns*image->rows))%     return(True);%   /*)     Uncompress runlength-encoded packets.    */I   uncompressed_pixels=(RunlengthPacket *) realloc((char *) image->pixels, 8     image->columns*image->rows*sizeof(RunlengthPacket));6   if (uncompressed_pixels == (RunlengthPacket *) NULL)     return(False);$   image->pixels=uncompressed_pixels;#   p=image->pixels+image->packets-1; 5   q=uncompressed_pixels+image->columns*image->rows-1; $   for (i=0; i < image->packets; i++)   {      length=p->length;      for (j=0; j <= length; j++)      {        *q=(*p);       q->length=0;
       q--;     }%     p--;   }%,   image->packets=image->columns*image->rows;   return(True);m }  g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%GO %                                                                             % O %                                                                             %aO %                                                                             %oO %   Z o o m I m a g e                                                         %aO %                                                                             %_O %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %_I %  Function ZoomImage creates a new image that is a integral size greater,M %  than an existing one.  It allocates the memory necessary for the new Imagei4 %  structure and returns a pointer to the new image. %eK %  ZoomImage scans the reference image to create a zoomed image by bilinear < %  interpolation.  The zoomed image columns and rows become: %o %    number_columns << 1 %    number_rows << 1g %a* %  The format of the ZoomImage routine is: % $ %      zoomed_image=ZoomImage(image) %a+ %  A description of each parameter follows:; %+L %    o zoomed_image: Function ZoomImage returns a pointer to the image afterJ %      zooming.  A null image is returned if there is a a memory shortage. %m7 %    o image: The address of a structure of type Image.  %  %o */ Image *ZoomImage(image)_ ImageM	   *image;; {    Imagee     *zoomed_image;     inta     y;     register int     x;     register RunlengthPacket     *p,a     *q,+     *r;   9   if (((image->columns*image->rows) << 1) > MaxImageSize)      { =       Warning("Unable to zoom image","image size too large");        return((Image *) NULL);i     }    /*'     Initialize zoomed image attributes.g   */K   zoomed_image=CopyImage(image,image->columns << 1,image->rows << 1,False);u%   if (zoomed_image == (Image *) NULL);     { A       Warning("Unable to zoom image","Memory allocation failed");        return((Image *) NULL);s     }."   zoomed_image->class=DirectClass;   /*!     Initialize zoom image pixels.-   */   p=image->pixels;   image->runlength=p->length+1;    q=zoomed_image->pixels;e!   for (y=0; y < image->rows; y++)e   {u&     for (x=0; x < image->columns; x++)     {m        if (image->runlength != 0)         image->runlength--;)
       else	         {            p++;%           image->runlength=p->length;%	         }%       *q=(*p);       q->length=0;
       q++;     }%     q+=image->columns;   }    /*     Zoom each row.   */!   for (y=0; y < image->rows; y++)    { C     p=zoomed_image->pixels+(image->rows-1-y)*zoomed_image->columns+        (image->columns-1); J     q=zoomed_image->pixels+((image->rows-1-y) << 1)*zoomed_image->columns+        ((image->columns-1) << 1);     *q=(*p);     *(q+1)=(*(p));&     for (x=1; x < image->columns; x++)     { 
       p--;       q-=2;        *q=(*p);<       (q+1)->red=(((int) p->red)+((int) (p+1)->red)+1) >> 1;B       (q+1)->green=(((int) p->green)+((int) (p+1)->green)+1) >> 1;?       (q+1)->blue=(((int) p->blue)+((int) (p+1)->blue)+1) >> 1;%B       (q+1)->index=(((int) p->index)+((int) (p+1)->index)+1) >> 1;       (q+1)->length=0;     }    } %   for (y=0; y < (image->rows-1); y++)    { :     p=zoomed_image->pixels+(y << 1)*zoomed_image->columns;     q=p+zoomed_image->columns;     r=q+zoomed_image->columns;*     for (x=0; x < (image->columns-1); x++)     {G4       q->red=(((int) p->red)+((int) r->red)+1) >> 1;:       q->green=(((int) p->green)+((int) r->green)+1) >> 1;7       q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;):       q->index=(((int) p->index)+((int) r->index)+1) >> 1;       q->length=0;C       (q+1)->red=(((int) p->red)+((int) (p+2)->red)+((int) r->red)+i#         ((int) (r+2)->red)+2) >> 2;cK       (q+1)->green=(((int) p->green)+((int) (p+2)->green)+((int) r->green)+ %         ((int) (r+2)->green)+2) >> 2;NG       (q+1)->blue=(((int) p->blue)+((int) (p+2)->blue)+((int) r->blue)+m$         ((int) (r+2)->blue)+2) >> 2;K       (q+1)->index=(((int) p->index)+((int) (p+2)->index)+((int) r->index)+b%         ((int) (r+2)->index)+2) >> 2;h       (q+1)->length=0;       q+=2;%       p+=2;%       r+=2;%     }%2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1; 8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1; 8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;   }%A   p=zoomed_image->pixels+(2*image->rows-2)*zoomed_image->columns;nA   q=zoomed_image->pixels+(2*image->rows-1)*zoomed_image->columns; $   for (x=0; x < image->columns; x++)   {c     *q++=(*p++);     *q++=(*p++);   }t   return(zoomed_image);e }r