 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                      EEEEE  RRRR   RRRR   OOO   RRRR                        % O %                      E      R   R  R   R O   O  R   R                       % O %                      EEE    RRRR   RRRR  O   O  RRRR                        % O %                      E      R R    R R   O   O  R R                         % O %                      EEEEE  R  R   R  R   OOO   R  R                        % O %                                                                             % O %                                                                             % O %                         ImageMagick Error Routines                          % O %                                                                             % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1993                                   % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"    /*   Forward declaraations. */ static void 0   DefaultErrorHandler _Declare((char *,char *)),2   DefaultWarningHandler _Declare((char *,char *));   /*   Global declarations. */ char   *client_name;    static ErrorHandler &   error_handler = DefaultErrorHandler,*   warning_handler = DefaultWarningHandler;   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e f a u l t E r r o r H a n d l e r                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function DefaultErrorHandler displays an error message and then terminates  %  the program.  % 4 %  The format of the DefaultErrorHandler routine is: % - %      DefaultErrorHandler(message,qualifier)  % + %  A description of each parameter follows:  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */2 static void DefaultErrorHandler(message,qualifier) char   *message, 
   *qualifier;  {    if (message == (char *) NULL)      exit(1);6   (void) fprintf(stderr,"%s: %s",client_name,message);!   if (qualifier != (char *) NULL) -     (void) fprintf(stderr," (%s)",qualifier);    (void) fprintf(stderr,".\n"); 
   exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e f a u l t W a r n i n g H a n d l e r                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function DefaultWarningHandler displays a warning message.  % 6 %  The format of the DefaultWarningHandler routine is: % / %      DefaultWarningHandler(message,qualifier)  % + %  A description of each parameter follows:  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */4 static void DefaultWarningHandler(message,qualifier) char   *message, 
   *qualifier;  {    if (message == (char *) NULL)      return; 6   (void) fprintf(stderr,"%s: %s",client_name,message);!   if (qualifier != (char *) NULL) -     (void) fprintf(stderr," (%s)",qualifier);    (void) fprintf(stderr,".\n");  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   E r r o r                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function Error calls the error handler routines with an error message.  % & %  The format of the Error routine is: %  %      Error(message,qualifier)  % + %  A description of each parameter follows:  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */ void Error(message,qualifier)  char   *message, 
   *qualifier;  { +   if (error_handler != (ErrorHandler) NULL) (     (*error_handler)(message,qualifier); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t E r r o r H a n d l e r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function SetErrorHandler sets the error handler to the specified routine. % 0 %  The format of the SetErrorHandler routine is: %  %      SetErrorHandler(handler)  % + %  A description of each parameter follows:  % B %    o handler: Specifies a pointer to a routine to handle errors. %  %  */ void SetErrorHandler(handler)  ErrorHandler
   handler; {    error_handler=handler; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t W a r n i n g H a n d l e r                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % P %  Function SetWarningHandler sets the warning handler to the specified routine. % 2 %  The format of the SetWarningHandler routine is: % ! %      SetWarningHandler(handler)  % + %  A description of each parameter follows:  % D %    o handler: Specifies a pointer to a routine to handle warnings. %  %  */ void SetWarningHandler(handler)  ErrorHandler
   handler; {    warning_handler=handler; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W a r n i n g                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function Warning calls the warning handler routines with an warning message.  % ( %  The format of the Warning routine is: % ! %      Warning(message,qualifier)  % + %  A description of each parameter follows:  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */ void Warning(message,qualifier)  char   *message, 
   *qualifier;  { -   if (warning_handler != (ErrorHandler) NULL) *     (*warning_handler)(message,qualifier); } 