 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                   E      NN  N  C      O   O  D   D  E                      % O %                   EEE    N N N  C      O   O  D   D  EEE                    % O %                   E      N  NN  C      O   O  D   D  E                      % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Write Image Formats                  % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "X.h" #include "compress.h"  #include "utility.h" #include "XWDFile.h"   /*   Forward declarations.  */ static unsigned int 1   WriteMIFFImage _Declare((ImageInfo *,Image *)), 0   WriteSUNImage _Declare((ImageInfo *,Image *));   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e A V S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteAVSImage writes an image to a file in AVS X image format. % . %  The format of the WriteAVSImage routine is: % - %      status=WriteAVSImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteAVSImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteAVSImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *avs_pixels;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*"     Initialize raster file header.   */"   avs_header.width=image->columns;    avs_header.height=image->rows;   avs_pixels=(unsigned char *)?     malloc(4*image->columns*image->rows*sizeof(unsigned char)); +   if (avs_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     } F   (void) fwrite((char *) &avs_header,sizeof(AVSHeader),1,image->file);   p=image->pixels;   q=avs_pixels; $   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)     { 9       *q++=(unsigned char) (image->matte ? p->index : 0);        *q++=p->red;       *q++=p->green;       *q++=p->blue;      }      p++;   } H   (void) fwrite((char *) avs_pixels,4,(int)(image->columns*image->rows),     image->file);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e B M P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WriteBMPImage writes an image in Microsoft Windows bitmap encoded  %  image format. % . %  The format of the WriteBMPImage routine is: % - %      status=WriteBMPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteBMPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteBMPImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *bmp_data,     *bmp_pixels;     unsigned int     bytes_per_line;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*&     Initialize BMP raster file header.   */   bmp_header.file_size=14+40;    bmp_header.offset_bits=14+40;    if (!IsPseudoClass(image))     {        /*         Full color BMP raster.       */       bmp_header.bit_count=24;!       bmp_header.number_colors=0;      }    else     {        /*         Colormapped BMP raster.        */       bmp_header.bit_count=8; 5       if (IsGrayImage(image) && (image->colors == 2))          bmp_header.bit_count=1; :       bmp_header.file_size+=4*(1 << bmp_header.bit_count);<       bmp_header.offset_bits+=4*(1 << bmp_header.bit_count);9       bmp_header.number_colors=1 << bmp_header.bit_count;      }    bmp_header.reserved[0]=0;    bmp_header.reserved[1]=0;    bmp_header.size=40; "   bmp_header.width=image->columns;    bmp_header.height=image->rows;   bmp_header.planes=1;   bmp_header.compression=0; A   bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; 3   bmp_header.image_size=bytes_per_line*image->rows; .   bmp_header.file_size+=bmp_header.image_size;   bmp_header.x_pixels=75*39;   bmp_header.y_pixels=75*39;7   bmp_header.colors_important=bmp_header.number_colors;    /*&     Convert MIFF to BMP raster pixels.   */   bmp_pixels=(unsigned char *)8     malloc(bmp_header.image_size*sizeof(unsigned char));+   if (bmp_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   x=0;   y=image->rows-1;   switch (bmp_header.bit_count)    {      case 1:      {        register unsigned char         bit,
         byte,          polarity;          /*<         Convert PseudoClass image to a BMP monochrome image.       */       polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[1]) > Intensity(image->colormap[0]);        bit=0;
       byte=0; $       q=bmp_pixels+y*bytes_per_line;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) %                 *q++=byte << (8-bit);                bit=0;               byte=0;                x=0;               y--;,               q=bmp_pixels+y*bytes_per_line;            }	         }          p++;       }        break;     }      case 8:      {        /*0         Convert PseudoClass packet to BMP pixel.       */$       q=bmp_pixels+y*bytes_per_line;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            *q++=p->index;           x++;"           if (x == image->columns)
             {                x=0;               y--;,               q=bmp_pixels+y*bytes_per_line;
             } 	         }          p++;       }        break;     }      case 24:     {        /*4         Convert DirectClass packet to BMP RGB pixel.       */$       q=bmp_pixels+y*bytes_per_line;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            *q++=p->blue;            *q++=p->green;           *q++=p->red;           x++;"           if (x == image->columns)
             {                x=0;               y--;,               q=bmp_pixels+y*bytes_per_line;
             } 	         }          p++;       }        break;     }    }     if (bmp_header.bit_count == 8)     { <       if (image->compression == RunlengthEncodedCompression)         CompressImage(image); <       if (image->compression == RunlengthEncodedCompression)	         {            unsigned int             packets;             /*5             Convert run-length encoded raster pixels.            */@           packets=(bytes_per_line*(bmp_header.height+2)+1) << 1;K           bmp_data=(unsigned char *) malloc(packets*sizeof(unsigned char)); 3           if (bmp_pixels == (unsigned char *) NULL) 
             { ?               Warning("Memory allocation error",(char *) NULL); (               free((char *) bmp_pixels);               return(False);
             }             bmp_header.image_size=K             BMPEncodeImage(bmp_pixels,bmp_data,image->columns,image->rows); $           free((char *) bmp_pixels);           bmp_pixels=bmp_data;#           bmp_header.compression=1; 	         }      }    /*     Write BMP header.    */&   (void) fwrite("BM",1,2,image->file);6   LSBFirstWriteLong(bmp_header.file_size,image->file);9   LSBFirstWriteShort(bmp_header.reserved[0],image->file); 9   LSBFirstWriteShort(bmp_header.reserved[1],image->file); 8   LSBFirstWriteLong(bmp_header.offset_bits,image->file);1   LSBFirstWriteLong(bmp_header.size,image->file); 2   LSBFirstWriteLong(bmp_header.width,image->file);3   LSBFirstWriteLong(bmp_header.height,image->file); 4   LSBFirstWriteShort(bmp_header.planes,image->file);7   LSBFirstWriteShort(bmp_header.bit_count,image->file); 8   LSBFirstWriteLong(bmp_header.compression,image->file);7   LSBFirstWriteLong(bmp_header.image_size,image->file); 5   LSBFirstWriteLong(bmp_header.x_pixels,image->file); 5   LSBFirstWriteLong(bmp_header.y_pixels,image->file); :   LSBFirstWriteLong(bmp_header.number_colors,image->file);=   LSBFirstWriteLong(bmp_header.colors_important,image->file); "   if (image->class == PseudoClass)     {        unsigned char          *bmp_colormap;         /*         Dump colormap to file.       */$       bmp_colormap=(unsigned char *)D         malloc(4*(1 << bmp_header.bit_count)*sizeof(unsigned char));1       if (bmp_colormap == (unsigned char *) NULL) 	         { =           Warning("Unable to allocate memory",(char *) NULL);            return(False);	         }        q=bmp_colormap; '       for (i=0; i < image->colors; i++)        { %         *q++=image->colormap[i].blue; &         *q++=image->colormap[i].green;$         *q++=image->colormap[i].red;         q++;       } F       (void) fwrite((char *) bmp_colormap,4,1 << bmp_header.bit_count,         image->file); "       free((char *) bmp_colormap);     } O   (void) fwrite((char *) bmp_pixels,1,(int) bmp_header.image_size,image->file);    free((char *) bmp_pixels);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e C M Y K I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function WriteCMYKImage writes an image to a file in cyan, magenta,' %  yellow, and black rasterfile format.  % / %  The format of the WriteCMYKImage routine is:  % . %      status=WriteCMYKImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteCMYKImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteCMYKImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    float      black_generation,      undercolor;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char 
     black,	     cyan,      magenta,     *cmyk_pixels,      yellow;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*'     Convert MIFF to CMYK raster pixels.    */   cmyk_pixels=(unsigned char *) ?     malloc(4*image->columns*image->rows*sizeof(unsigned char)); ,   if (cmyk_pixels == (unsigned char *) NULL)     { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    undercolor=1.0;    black_generation=1.0; .   if (image_info->undercolor != (char *) NULL)     { ?       (void) sscanf(image_info->undercolor,"%fx%f",&undercolor,          &black_generation); "       if (black_generation == 1.0)$         black_generation=undercolor;     }    q=cmyk_pixels;    switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; %           *q++=cyan-undercolor*black; (           *q++=magenta-undercolor*black;'           *q++=yellow-undercolor*black; &           *q++=black_generation*black;	         }          p++;       }        break;     }      case LineInterlace:      {        register int
         x,
         y;         /*?         Line interlacing:  CCC...MMM...YYY...CCC...MMM...YYY...        */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)        { +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; %           *q++=cyan-undercolor*black;            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; (           *q++=magenta-undercolor*black;           p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; '           *q++=yellow-undercolor*black;            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; &           *q++=black_generation*black;           p++;	         }        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; %           *q++=cyan-undercolor*black; 	         }          p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; (           *q++=magenta-undercolor*black;	         }          p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {             cyan=MaxRGB-p->red;#            magenta=MaxRGB-p->green; !            yellow=MaxRGB-p->blue;             black=cyan;            if (magenta < black)               black=magenta;             if (yellow < black)              black=yellow;(            *q++=yellow-undercolor*black;	         }          p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; &           *q++=black_generation*black;	         }          p++;       }        break;     }    } J   (void) fwrite((char *) cmyk_pixels,4,(int) (image->columns*image->rows),     image->file);    free((char *) cmyk_pixels);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F A X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Procedure WriteFAXImage writes an image to a file in 1 dimensional Huffman  %  encoded format. % . %  The format of the WriteFAXImage routine is: % - %      status=WriteFAXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteFAXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteFAXImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Convert MIFF to monochrome.    */=   QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);    SyncImage(image); #   status=HuffmanEncodeImage(image);    CloseImage(image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F I T S I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteFITSImage writes a Flexible Image Transport System image to a+ %  file as gray scale intensities [0..255].  % / %  The format of the WriteFITSImage routine is:  % . %      status=WriteFITSImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteFITSImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteFITSImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    char     buffer[81],      *fits_header;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *fits_pixels;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Allocate image header.   */:   fits_header=(char *) malloc(2880*sizeof(unsigned char));#   if (fits_header == (char *) NULL)      { B       Warning("Unable to write image","Memory allocation failed");       return(False);     }    /*     Initialize image header.   */   for (i=0; i < 2880; i++)     fits_header[i]=' '; 9   (void) strcpy(buffer,"SIMPLE  =                    T"); 6   (void) strncpy(fits_header+0,buffer,strlen(buffer));9   (void) strcpy(buffer,"BITPIX  =                    8"); 7   (void) strncpy(fits_header+80,buffer,strlen(buffer)); 9   (void) strcpy(buffer,"NAXIS   =                    2"); 8   (void) strncpy(fits_header+160,buffer,strlen(buffer));C   (void) sprintf(buffer,"NAXIS1  =           %10u",image->columns); 8   (void) strncpy(fits_header+240,buffer,strlen(buffer));@   (void) sprintf(buffer,"NAXIS2  =           %10u",image->rows);8   (void) strncpy(fits_header+320,buffer,strlen(buffer));:   (void) strcpy(buffer,"HISTORY Created by ImageMagick.");8   (void) strncpy(fits_header+400,buffer,strlen(buffer));   (void) strcpy(buffer,"END");8   (void) strncpy(fits_header+480,buffer,strlen(buffer));9   (void) fwrite((char *) fits_header,1,2880,image->file);    free((char *) fits_header);    /*2     Convert image to fits scale PseudoColor class.   */   fits_pixels=(unsigned char *) =     malloc(image->columns*image->rows*sizeof(unsigned char)); ,   if (fits_pixels == (unsigned char *) NULL)     { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=fits_pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)       *q++=Intensity(*p);      p++;   } J   (void) fwrite((char *) fits_pixels,1,(int) (image->columns*image->rows),     image->file);    free((char *) fits_pixels);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G I F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteGIFImage writes an image to a file in the Compuserve Graphics %  image format. % . %  The format of the WriteGIFImage routine is: % - %      status=WriteGIFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteGIFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteGIFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     x;     register RunlengthPacket     *p;      unsigned char      bits_per_pixel,      c,     *matte_image;      unsigned int     colors,      status;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     } 
   colors=256; %   matte_image=(unsigned char *) NULL;    if (image->matte)      {        /*,         Allocate and initialize matte image.       */"       if (!UncompressImage(image))         return(False);       p=image->pixels;#       matte_image=(unsigned char *) A         malloc(image->columns*image->rows*sizeof(unsigned char)); 0       if (matte_image == (unsigned char *) NULL)N         Warning("Unable to set transparent pixel","Memory allocation failed");
       else8         for (x=0; x < (image->columns*image->rows); x++)	         { ;           matte_image[x]=(unsigned char) (p->index & 0xff);            p++;	         }        colors--;      } @   if ((image->class == DirectClass) || (image->colors > colors))     {        /**         Demote DirectClass to PseudoClass.       */E       QuantizeImage(image,colors,8,image_info->dither,RGBColorspace);        SyncImage(image);      }    colors=image->colors; ,   if (matte_image != (unsigned char *) NULL)
     colors++; >   for (bits_per_pixel=1; bits_per_pixel < 8; bits_per_pixel++)(     if ((1 << bits_per_pixel) >= colors)       break;   /*     Write GIF header.    */0   if ((matte_image == (unsigned char *) NULL) &&)       (image->comments == (char *) NULL)) ,     (void) fwrite("GIF87a",1,6,image->file);   else+     if (strcmp(image->magick,"GIF87") == 0) .       (void) fwrite("GIF87a",1,6,image->file);     else.       (void) fwrite("GIF89a",1,6,image->file);1   LSBFirstWriteShort(image->columns,image->file); .   LSBFirstWriteShort(image->rows,image->file);    c=0x80;  /* global colormap */(   c|=(8-1) << 4;  /* color resolution */8   c|=(bits_per_pixel-1);   /* size of global colormap */%   (void) fputc((char) c,image->file); 8   (void) fputc(0x0,image->file);  /* background color */0   (void) fputc(0x0,image->file);  /* reserved */   /*     Write colormap.    */#   for (i=0; i < image->colors; i++)    { <     (void) fputc((char) image->colormap[i].red,image->file);>     (void) fputc((char) image->colormap[i].green,image->file);=     (void) fputc((char) image->colormap[i].blue,image->file);    } ,   if (matte_image != (unsigned char *) NULL)     {        /*)         Write color of transparent pixel.        */       p=image->pixels;6       for (x=0; x < (image->columns*image->rows); x++)       { *         if (matte_image[x] == Transparent)           break;         p++;       } E       (void) fputc((char) image->colormap[p->index].red,image->file); G       (void) fputc((char) image->colormap[p->index].green,image->file); F       (void) fputc((char) image->colormap[p->index].blue,image->file);
       i++;     } /   for ( ; i < (int) (1 << bits_per_pixel); i++)    { "     (void) fputc(0x0,image->file);"     (void) fputc(0x0,image->file);"     (void) fputc(0x0,image->file);   } )   if (strcmp(image->magick,"GIF87") != 0)      { +       if (image->comments != (char *) NULL) 	         {            register char              *p;              register unsigned int              count;             /**             Write comment extension block.           */)           (void) fputc(0x21,image->file); )           (void) fputc(0xfe,image->file);            p=image->comments;%           while ((int) strlen(p) > 0)            { +             count=Min((int) strlen(p),255); ,             (void) fputc(count,image->file);%             for (i=0; i < count; i++) -               (void) fputc(*p++,image->file);            } (           (void) fputc(0x0,image->file);	         } 0       if (matte_image != (unsigned char *) NULL)	         {            /*<             Write out extension for transparent color index.           */)           (void) fputc(0x21,image->file); )           (void) fputc(0xf9,image->file); (           (void) fputc(0x4,image->file);(           (void) fputc(0x1,image->file);(           (void) fputc(0x0,image->file);(           (void) fputc(0x0,image->file);9           (void) fputc((char) image->colors,image->file); (           (void) fputc(0x0,image->file);           /*B             Set transparent pixels to the transparent color index.           */           p=image->pixels;:           for (x=0; x < (image->columns*image->rows); x++)           { .             if (matte_image[x] == Transparent)%               p->index=image->colors;              p++;           } %           free((char *) matte_image); 	         }      } 7   (void) fputc(',',image->file);  /* image separator */    /*     Write the image header.    */$   LSBFirstWriteShort(0,image->file);$   LSBFirstWriteShort(0,image->file);1   LSBFirstWriteShort(image->columns,image->file); .   LSBFirstWriteShort(image->rows,image->file);	   c=0x00; -   if (image_info->interlace != NoneInterlace) ,     c|=0x40;  /* pixel data is interlaced */%   (void) fputc((char) c,image->file);    c=Max(bits_per_pixel,2);%   (void) fputc((char) c,image->file); -   if (image_info->interlace == NoneInterlace) 9     status=LZWEncodeImage(image,Max(bits_per_pixel,2)+1);    else     {        Image          *interlaced_image;  	       int 
         pass, 
         y;         register RunlengthPacket         *q;          static int+         interlace_rate[4] = { 8, 8, 4, 2 }, ,         interlace_start[4] = { 0, 4, 2, 1 };         /*         Interlace image.       */"       if (!UncompressImage(image))         return(False);       image->orphan=True; I       interlaced_image=CopyImage(image,image->columns,image->rows,False);        image->orphan=False;-       if (interlaced_image == (Image *) NULL) 	         { F           Warning("Unable to write image","Memory allocation failed");           return(False);	         }        p=image->pixels;!       q=interlaced_image->pixels; $       for (pass=0; pass < 4; pass++)       {           y=interlace_start[pass];         while (y < image->rows) 	         { -           p=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              *q=(*p);             p++;             q++;           } "           y+=interlace_rate[pass];	         }        } )       interlaced_image->file=image->file; F       status=LZWEncodeImage(interlaced_image,Max(bits_per_pixel,2)+1);+       interlaced_image->file=(FILE *) NULL; %       DestroyImage(interlaced_image);      }    if (status == False)     { B       Warning("Unable to write image","Memory allocation failed");       return(False);     }     (void) fputc(0x0,image->file);1   (void) fputc(';',image->file); /* terminator */    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G R A Y I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteGRAYImage writes an image to a file as gray scale intensity %  values [0..255].  % / %  The format of the WriteGRAYImage routine is:  % . %      status=WriteGRAYImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteGRAYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteGRAYImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *gray_pixels;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*2     Convert image to gray scale PseudoColor class.   */   gray_pixels=(unsigned char *) =     malloc(image->columns*image->rows*sizeof(unsigned char)); ,   if (gray_pixels == (unsigned char *) NULL)     { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=gray_pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)       *q++=Intensity(*p);      p++;   } J   (void) fwrite((char *) gray_pixels,1,(int) (image->columns*image->rows),     image->file);    free((char *) gray_pixels);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H I S T O G R A M I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHISTOGRAMImage writes an image to a file in HISTOGRAM format.O %  The image shows a histogram of the color (or gray) values in the image.  The O %  image consists of three overlaid histograms:  a red one for the red channel, O %  a green one for the green channel, and a blue one for the blue channel.  The O %  image comment contains a list of unique pixel values and the number of times  %  each occurs in the image. % > %  This routine is strongly based on a similiar one written byI %  muquit@warm.semcor.com which in turn is based on ppmhistmap of netpbm.  % 4 %  The format of the WriteHISTOGRAMImage routine is: % 3 %      status=WriteHISTOGRAMImage(image_info,image)  % + %  A description of each parameter follows.  % P %    o status: Function WriteHISTOGRAMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */9 static unsigned int WriteHISTOGRAMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  { # #define HistogramDensity  "256x200"      char     filename[MaxTextLength];     double
     scale;     FILE
     *file;     Image      *histogram_image;      int 
     *blue,     *green,      maximum,	     *red,      sans_offset;     register RunlengthPacket     *p,      *q;      register int     i,     j;     unsigned int     status;      /*     Allocate histogram image.    */4   histogram_image=AllocateImage((ImageInfo *) NULL);(   if (histogram_image == (Image *) NULL)     { ;       Warning("Unable to allocate memory",image->filename);        return(False);     }    *histogram_image=(*image);%   histogram_image->class=DirectClass; C   (void) XParseGeometry(HistogramDensity,&sans_offset,&sans_offset, 6     &histogram_image->columns,&histogram_image->rows);F   (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,6     &histogram_image->columns,&histogram_image->rows);J   histogram_image->packets=histogram_image->rows*histogram_image->columns;-   histogram_image->pixels=(RunlengthPacket *) =     malloc(histogram_image->packets*sizeof(RunlengthPacket)); :   if (histogram_image->pixels == (RunlengthPacket *) NULL)     { ;       Warning("Unable to allocate memory",image->filename); $       DestroyImage(histogram_image);       return(False);     }    /*$     Allocate histogram count arrays.   */<   red=(int *) malloc (histogram_image->columns*sizeof(int));>   green=(int *) malloc (histogram_image->columns*sizeof(int));=   blue=(int *) malloc (histogram_image->columns*sizeof(int)); 9   if ((red == (int *) NULL) || (green == (int *) NULL) ||        (blue == (int *) NULL))      { ;       Warning("Unable to allocate memory",image->filename); $       DestroyImage(histogram_image);       return(False);     }    /*&     Initialize histogram count arrays.   */.   for (i=0; i < histogram_image->columns; i++)   { 
     red[i]=0;      green[i]=0;      blue[i]=0;   }    p=image->pixels;$   for (i=0; i < image->packets; i++)   {      red[p->red]+=(p->length+1); #     green[p->green]+=(p->length+1); !     blue[p->blue]+=(p->length+1);      p++;   }    maximum=0;.   for (i=0; i < histogram_image->columns; i++)   {      if (maximum < red[i])        maximum=red[i];      if (maximum < green[i])        maximum=green[i];      if (maximum < blue[i])       maximum=blue[i];   } .   for (i=0; i < histogram_image->columns; i++)   {      if (red[i] > maximum)        red[i]=maximum;      if (green[i] > maximum)        green[i]=maximum;      if (blue[i] > maximum)       blue[i]=maximum;   }    /*     Initialize histogram image.    */   q=histogram_image->pixels;.   for (i=0; i < histogram_image->packets; i++)   { 
     q->red=0;      q->green=0;      q->blue=0;     q->index=0;      q->length=0;     q++;   } /   scale=(double) histogram_image->rows/maximum;    q=histogram_image->pixels;-   for(i=0; i < histogram_image->columns; i++)    { 1     j=histogram_image->rows-(int) (scale*red[i]); %     while (j < histogram_image->rows)      { @       q=histogram_image->pixels+ (j*histogram_image->columns+i);       q->red=MaxRGB;       q->green=q->green;       q->blue=q->blue;
       j++;     } 3     j=histogram_image->rows-(int) (scale*green[i]); %     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->red=q->red;       q->green=MaxRGB;       q->blue=q->blue;
       j++;     } 2     j=histogram_image->rows-(int) (scale*blue[i]);%     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->red=q->red;       q->green=q->green;       q->blue=MaxRGB; 
       j++;     }    }    free ((char *) blue);    free ((char *) green);   free ((char *) red);   TemporaryFilename(filename);   file=fopen(filename,"w");    if (file != (FILE *) NULL)     { 
       char         command[MaxTextLength];          /*,         Add a histogram as an image comment.       */2       (void) fprintf(file,"%s\n",image->comments);       NumberColors(image,file);        (void) fclose(file);-       (void) sprintf(command,"@%s",filename); ,       CommentImage(histogram_image,command);       (void) unlink(filename);     }    /*"     Write HISTOGRAM image as MIFF.   */4   status=WriteMIFFImage(image_info,histogram_image);    DestroyImage(histogram_image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e I R I S I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteIRISImage writes an image in SGI RGB encoded image format.  % / %  The format of the WriteIRISImage routine is:  % . %      status=WriteIRISImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteIRISImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  + static int IRISEncode(pixels,count,packets) 
 unsigned char 
   *pixels;   int    count;  
 unsigned char    *packets;  {    short      runlength;     unsigned char      *limit, 
     *mark,     *p,      *q;      p=pixels;    limit=p+count*4;   q=packets;   while (p < limit)    {      mark=p; 	     p+=8; A     while ((p < limit) && ((*(p-8) != *(p-4)) || (*(p-4) != *p)))        p+=4; 	     p-=8;      count=((p-mark) >> 2);     while (count)      { *       runlength=count > 126 ? 126 : count;       count-=runlength;        *q++=0x80 | runlength;)       for ( ; runlength > 0; runlength--)        {          *q++=(*mark);          mark+=4;       }      }      mark=p; 	     p+=4; (     while ((p < limit) && (*p == *mark))       p+=4;      count=((p-mark) >> 2);     while (count)      { *       runlength=count > 126 ? 126 : count;       count-=runlength;        *q++=runlength;        *q++=(*mark);      }    } 	   *q++=0;    return(q-packets); }   4 static unsigned int WriteIRISImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _IRISHeader   {      unsigned short       magic;       unsigned char        storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned long        minimum_value,       maximum_value;       unsigned char        filler[492];   } IRISHeader;      IRISHeader     iris_header;     register int     i,     j,     x,     y,     z;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *iris_pixels, 
     *packets;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*'     Initialize IRIS raster file header.    */   iris_header.magic=0x01DA; *   if (image->compression == NoCompression)     iris_header.storage=0x00;    else     iris_header.storage=0x01; :   iris_header.bytes_per_pixel=1;  /* one byte per pixel */   iris_header.dimension=3;%   iris_header.columns=image->columns;    iris_header.rows=image->rows; )   iris_header.depth=image->matte ? 4 : 3; :   if ((image->class == PseudoClass) && IsGrayImage(image))     {        iris_header.dimension=2;       iris_header.depth=1;     }    iris_header.minimum_value=0;#   iris_header.maximum_value=MaxRGB; 0   for (i=0; i < sizeof(iris_header.filler); i++)     iris_header.filler[i]=0;   /*     Write IRIS header.   */4   MSBFirstWriteShort(iris_header.magic,image->file);0   (void) fputc(iris_header.storage,image->file);8   (void) fputc(iris_header.bytes_per_pixel,image->file);8   MSBFirstWriteShort(iris_header.dimension,image->file);6   MSBFirstWriteShort(iris_header.columns,image->file);3   MSBFirstWriteShort(iris_header.rows,image->file); 4   MSBFirstWriteShort(iris_header.depth,image->file);;   MSBFirstWriteLong(iris_header.minimum_value,image->file); ;   MSBFirstWriteLong(iris_header.maximum_value,image->file); M   (void) fwrite(iris_header.filler,1,sizeof(iris_header.filler),image->file);    /*     Allocate IRIS pixels.    */   iris_pixels=(unsigned char *) ?     malloc(4*image->columns*image->rows*sizeof(unsigned char)); ,   if (iris_pixels == (unsigned char *) NULL)     { ;       Warning("Unable to allocate memory",image->filename);        return(False);     }    /*B     Convert runlength-encoded packets to uncompressed IRIS pixels.   */   x=0;   y=0;   p=image->pixels;=   q=iris_pixels+(iris_header.rows-1)*(iris_header.columns*4); $   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {        *q++=p->red;       *q++=p->green;       *q++=p->blue; $       *q++=(unsigned char) p->index;
       x++;       if (x == image->columns)	         {            y++;I           q=iris_pixels+((iris_header.rows-1)-y)*(iris_header.columns*4);            x=0;	         }      }      p++;   } *   if (image->compression == NoCompression)     {        unsigned char          *scanline;         /*'         Write uncompressed IRIS pixels.        */        scanline=(unsigned char *):         malloc(iris_header.columns*sizeof(unsigned char));-       if (scanline == (unsigned char *) NULL) 	         { ?           Warning("Unable to allocate memory",image->filename);            return(False);	         } 1       for (z=0; z < (int) iris_header.depth; z++)        {          q=iris_pixels+z;2         for (y=0; y < (int) iris_header.rows; y++)	         { 7           for (x=0; x < (int) iris_header.columns; x++)            {              scanline[x]=(*q);              q+=4;            } K           (void) fwrite(scanline,sizeof(unsigned char),iris_header.columns,              image->file); 	         }        }        free(scanline);      }    else     {        unsigned long          length,          number_packets,          offset,          *offsets,          *runlength;          /*E         Convert IRIS uncompressed pixels to runlength-encoded pixels.        */       offsets=(unsigned long *) I         malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); I       packets=(unsigned char *) malloc(4*((iris_header.columns << 1)+10)* +         image->rows*sizeof(unsigned char)); !       runlength=(unsigned long *) I         malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); 0       if ((offsets == (unsigned long *) NULL) ||0           (packets == (unsigned char *) NULL) ||0           (runlength == (unsigned long *) NULL))	         { ?           Warning("Unable to allocate memory",image->filename);            return(False);	         } ?       offset=512+4*((iris_header.rows*iris_header.depth) << 1);        number_packets=0;        q=iris_pixels;0       for (y=0; y < (int) iris_header.rows; y++)       { 3         for (z=0; z < (int) iris_header.depth; z++) 	         {            length= M             IRISEncode(q+z,(int) iris_header.columns,packets+number_packets); !           number_packets+=length; /           offsets[y+z*iris_header.rows]=offset; 1           runlength[y+z*iris_header.rows]=length;            offset+=length; 	         } #         q+=(iris_header.columns*4);        }        /*L         Write out line start and length tables and runlength-encoded pixels.       */D       for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)2         MSBFirstWriteLong(offsets[i],image->file);D       for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)4         MSBFirstWriteLong(runlength[i],image->file);N       (void) fwrite(packets,sizeof(unsigned char),number_packets,image->file);       /*         Free memory.       */       free(runlength);       free(packets);       free(offsets);     }    free(iris_pixels);   CloseImage(image);   return(True);  }    #ifdef HasJPEG #include "jpeglib.h" #include "jerror.h"    static Image	   *image;  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  W r i t e J P E G I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WriteJPEGImage writes a JPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % / %  The format of the WriteJPEGImage routine is:  % . %      status=WriteJPEGImage(image_info,image) % + %  A description of each parameter follows:  % L %    o status:  Function WriteJPEGImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 3 %    o jpeg_image:  A pointer to a Image structure.  %  %  */  ( static void EmitMessage(jpeg_info,level) j_common_ptr   jpeg_info;   int    level; {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { H       if (jpeg_error->num_warnings == 0 || jpeg_error->trace_level >= 3)2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }   4 static unsigned int WriteJPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  { 	   JSAMPLE      *jpeg_pixels,      **scanlines;     register int     i,     j;     register JSAMPLE     *q;      register RunlengthPacket     *p;      struct jpeg_compress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int
     count,     packets;     /*     Open image file.   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Initialize JPEG parameters.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;#   jpeg_create_compress(&jpeg_info); *   jpeg_stdio_dest(&jpeg_info,image->file);'   jpeg_info.image_width=image->columns; %   jpeg_info.image_height=image->rows;    jpeg_info.input_components=3; #   jpeg_info.in_color_space=JCS_RGB;    if (IsGrayImage(image))      { #       jpeg_info.input_components=1; -       jpeg_info.in_color_space=JCS_GRAYSCALE;      }     jpeg_set_defaults(&jpeg_info);8   jpeg_set_quality(&jpeg_info,image_info->quality,True);!   jpeg_info.optimize_coding=True;  #ifdef DCT_FLOAT_SUPPORTED"   jpeg_info.dct_method=JDCT_FLOAT; #endif'   jpeg_start_compress(&jpeg_info,True); '   if (image->comments != (char *) NULL) :     for (i=0; i < (int) strlen(image->comments); i+=65533)P       jpeg_write_marker(&jpeg_info,JPEG_COM,(unsigned char *) image->comments+i,C         (unsigned int) Min((int) strlen(image->comments+i),65533));    /*'     Convert MIFF to JPEG raster pixels.    */@   packets=jpeg_info.input_components*image->columns*image->rows;:   jpeg_pixels=(JSAMPLE *) malloc(packets*sizeof(JSAMPLE));?   scanlines=(JSAMPLE **) malloc(image->rows*sizeof(JSAMPLE *)); L   if ((jpeg_pixels == (JSAMPLE *) NULL) || (scanlines == (JSAMPLE **) NULL))     { B       Warning("Unable to write image","Memory allocation failed");       return(False);     }    p=image->pixels;   q=jpeg_pixels;#   if (jpeg_info.data_precision > 8)      { 4       if (jpeg_info.in_color_space == JCS_GRAYSCALE)*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)0             *q++=(JSAMPLE) (Intensity(*p) << 4);           p++;	         } 
       else*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { )             *q++=(JSAMPLE) (p->red << 4); +             *q++=(JSAMPLE) (p->green << 4); *             *q++=(JSAMPLE) (p->blue << 4);           }            p++;	         }      }    else2     if (jpeg_info.in_color_space == JCS_GRAYSCALE)(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)'           *q++=(JSAMPLE) Intensity(*p);          p++;       }      else(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {             *q++=(JSAMPLE) p->red;"           *q++=(JSAMPLE) p->green;!           *q++=(JSAMPLE) p->blue; 	         }          p++;       }    /*     Write JPEG raster pixels.    */!   for (i=0; i < image->rows; i++) K     scanlines[i]=jpeg_pixels+(i*image->columns*jpeg_info.input_components); &   for (i=0; i < image->rows; i+=count)E     count=jpeg_write_scanlines(&jpeg_info,scanlines+i,image->rows-i); #   jpeg_finish_compress(&jpeg_info);    /*     Free memory.   */   free((char *) scanlines);    free((char *) jpeg_pixels); $   jpeg_destroy_compress(&jpeg_info);   CloseImage(image);   return(True);  }  #else 4 static unsigned int WriteJPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   ;   Warning("JPEG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e L O G O I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteLOGOImage writes an image in the LOGO encoded image format. % / %  The format of the WriteLOGOImage routine is:  % . %      status=WriteLOGOImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteLOGOImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteLOGOImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   6   Warning("Cannot write LOGO images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMAPImage writes an image to a file as red, green, and blue 3 %  colormap bytes followed by the colormap indexes.  % . %  The format of the WriteMAPImage routine is: % - %      status=WriteMAPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMAPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteMAPImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i;     register unsigned char     *q;      unsigned char      *colormap;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Allocate colormap.   */"   if (image->class == DirectClass)     {        /**         Demote DirectClass to PseudoClass.       */N       QuantizeImage(image,MaxColormapSize,8,image_info->dither,RGBColorspace);       SyncImage(image);      } K   colormap=(unsigned char *) malloc(3*image->colors*sizeof(unsigned char)); )   if (colormap == (unsigned char *) NULL)      { B       Warning("Unable to write image","Memory allocation failed");       return(False);     }    /*     Write colormap to file.    */
   q=colormap; #   for (i=0; i < image->colors; i++)    {       *q++=image->colormap[i].red;"     *q++=image->colormap[i].green;!     *q++=image->colormap[i].blue;    } E   (void) fwrite((char *) colormap,3,(int) image->colors,image->file);    free((char *) colormap);   /*     Write image pixels to file.    */#   image->compression=NoCompression; %   (void) RunlengthEncodeImage(image); G   (void) fwrite((char *) image->packed_pixels,(int) image->packet_size, &     (int) image->packets,image->file);&   free((char *) image->packed_pixels);.   image->packed_pixels=(unsigned char *) NULL;   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A T T E I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WriteMATTEImage writes an mage of matte bytes to a file.  ItC %  consists of data from the matte component of the image [0..255].  % 0 %  The format of the WriteMATTEImage routine is: % / %      status=WriteMATTEImage(image_info,image)  % + %  A description of each parameter follows.  % L %    o status: Function WriteMATTEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */5 static unsigned int WriteMATTEImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *matte_pixels;     if (!image->matte)     { E       Warning("Image does not have a matte channel",image->filename);        return(False);     }    /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Allocate matte pixels.   */    matte_pixels=(unsigned char *)=     malloc(image->columns*image->rows*sizeof(unsigned char)); -   if (matte_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=matte_pixels; $   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)$       *q++=(unsigned char) p->index;     p++;   } K   (void) fwrite((char *) matte_pixels,1,(int) (image->columns*image->rows),      image->file);    free((char *) matte_pixels);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M I F F I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 5 %  Function WriteMIFFImage writes an image to a file.  % / %  The format of the WriteMIFFImage routine is:  % . %      status=WriteMIFFImage(image_info,image) % + %  A description of each parameter follows:  % K %    o status: Function WriteMIFFImage return True if the image is written. K %      False is returned if there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % - %    o image: A pointer to a Image structure.  %  %  */4 static unsigned int WriteMIFFImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i;     unsigned long      packets;  E   if ((image->class != DirectClass) && (image->class != PseudoClass))      { =       Warning("Unable to write image","unknown image class");        return(False);     } <   if ((image->compression != RunlengthEncodedCompression) &&4       (image->compression != QEncodedCompression) &&,       (image->compression != NoCompression))     { C       Warning("Unable to write image","unknown image compression");        return(False);     }    /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     } &   (void) strcpy(image->magick,"MIFF");   /*     Pack image pixels.   */J   if (IsPseudoClass(image) && (image->compression == QEncodedCompression))     image->class=DirectClass; %   (void) RunlengthEncodeImage(image);    packets=image->packets; 0   if (image->compression == QEncodedCompression)     {        unsigned char          *compressed_pixels;          /*.         Compress image pixels with Q encoding.       */)       compressed_pixels=(unsigned char *) P         malloc((unsigned int) packets*image->packet_size*sizeof(unsigned char));6       if (compressed_pixels == (unsigned char *) NULL)	         { F           Warning("Unable to write image","Memory allocation failed");           return(False);	         } B       packets=QEncodeImage(image->packed_pixels,compressed_pixels,=         image->columns*(int) image->packet_size,image->rows); *       free((char *) image->packed_pixels);-       image->packed_pixels=compressed_pixels;        image->packet_size=1;      } "   if (image->class == PseudoClass)     ColormapSignature(image);    /*     Write header to file.    */'   if (image->comments != (char *) NULL) =     (void) fprintf(image->file,"{\n%s\n}\n",image->comments); 1   (void) fprintf(image->file,"id=ImageMagick\n"); "   if (image->class == PseudoClass)N     (void) fprintf(image->file,"class=PseudoClass  colors=%u  signature=%s\n",&       image->colors,image->signature);   else     if (image->matte) D       (void) fprintf(image->file,"class=DirectClass  matte=True\n");     else8       (void) fprintf(image->file,"class=DirectClass\n");8   if (image->compression == RunlengthEncodedCompression)M     (void) fprintf(image->file,"compression=RunlengthEncoded  packets=%lu\n",        packets);    else2     if (image->compression == QEncodedCompression)P       (void) fprintf(image->file,"compression=QEncoded  packets=%lu\n",packets);D   (void) fprintf(image->file,"columns=%u  rows=%u\n",image->columns,     image->rows);    if (image->scene != 0):     (void) fprintf(image->file,"scene=%u\n",image->scene);&   if (image->montage != (char *) NULL)>     (void) fprintf(image->file,"montage=%s\n",image->montage);(   (void) fprintf(image->file,"\f\n:\n");&   if (image->montage != (char *) NULL)     {        /*%         Write montage tile directory.        */,       if (image->directory != (char *) NULL):         (void) fprintf(image->file,"%s",image->directory);%       (void) fputc('\0',image->file);      } "   if (image->class == PseudoClass)     {        register unsigned char         *q;          unsigned char          *colormap;         /*         Allocate colormap.       */O       colormap=(unsigned char *) malloc(3*image->colors*sizeof(unsigned char)); -       if (colormap == (unsigned char *) NULL) 	         { F           Warning("Unable to write image","Memory allocation failed");           return(False);	         }        q=colormap; '       for (i=0; i < image->colors; i++)        { $         *q++=image->colormap[i].red;&         *q++=image->colormap[i].green;%         *q++=image->colormap[i].blue;        }        /*         Write colormap to file.        */I       (void) fwrite((char *) colormap,3,(int) image->colors,image->file);        free((char *) colormap);     }    /*     Write image pixels to file.    */G   (void) fwrite((char *) image->packed_pixels,(int) image->packet_size,      (int) packets,image->file); &   free((char *) image->packed_pixels);.   image->packed_pixels=(unsigned char *) NULL;   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M P E G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteMPEGImage writes an image in the MPEG encoded image format. % / %  The format of the WriteMPEGImage routine is:  % . %      status=WriteMPEGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteMPEGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteMPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   6   Warning("Cannot write MPEG images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M T V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMTVImage writes an image to a file in red, green, and blue  %  MTV rasterfile format.  % . %  The format of the WriteMTVImage routine is: % - %      status=WriteMTVImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMTVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteMTVImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *mtv_pixels;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*&     Convert MIFF to MTV raster pixels.   */   mtv_pixels=(unsigned char *)?     malloc(3*image->columns*image->rows*sizeof(unsigned char)); +   if (mtv_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=mtv_pixels; $   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {        *q++=p->red;       *q++=p->green;       *q++=p->blue;      }      p++;   } C   (void) fprintf(image->file,"%u %u\n",image->columns,image->rows); I   (void) fwrite((char *) mtv_pixels,3,(int) (image->columns*image->rows),      image->file);    free((char *) mtv_pixels);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C D I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WritePCDImage writes an image in the Photo CD encoded image 
 %  format. % . %  The format of the WritePCDImage routine is: % - %      status=WritePCDImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePCDImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   5   Warning("Cannot write PCD images",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WritePCXImage writes an image in the ZSoft IBM PC Paintbrush file 
 %  format. % . %  The format of the WritePCXImage routine is: % - %      status=WritePCXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePCXImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _PCXHeader    {      unsigned char        identifier,        version,       encoding,        bits_per_pixel;   
     short int        left, 
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int        bytes_per_line,        palette_info;        unsigned char        colormap_signature;    } PCXHeader;     PCXHeader      pcx_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char 
     count,     packet,      *pcx_colormap,     *pcx_pixels,
     previous;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*&     Initialize PCX raster file header.   */=   if ((image->class == DirectClass) || (image->colors > 256))      {        /**         Demote DirectClass to PseudoClass.       */B       QuantizeImage(image,256,8,image_info->dither,RGBColorspace);       SyncImage(image);      }    pcx_header.identifier=0x0a;    pcx_header.version=5;    pcx_header.encoding=1;   pcx_header.bits_per_pixel=8;1   if (IsGrayImage(image) && (image->colors == 2))       pcx_header.bits_per_pixel=1;   pcx_header.left=0;   pcx_header.top=0; $   pcx_header.right=image->columns-1;"   pcx_header.bottom=image->rows-1;2   pcx_header.horizontal_resolution=image->columns;-   pcx_header.vertical_resolution=image->rows;    pcx_header.reserved=0;   pcx_header.planes=1;K   pcx_header.bytes_per_line=(image->columns*pcx_header.bits_per_pixel+7)/8;    pcx_header.palette_info=1;%   pcx_header.colormap_signature=0x0c;    /*     Write PCX header.    */8   (void) fwrite(&pcx_header.identifier,1,1,image->file);5   (void) fwrite(&pcx_header.version,1,1,image->file); 6   (void) fwrite(&pcx_header.encoding,1,1,image->file);<   (void) fwrite(&pcx_header.bits_per_pixel,1,1,image->file);A   LSBFirstWriteShort((unsigned int) pcx_header.left,image->file); @   LSBFirstWriteShort((unsigned int) pcx_header.top,image->file);B   LSBFirstWriteShort((unsigned int) pcx_header.right,image->file);C   LSBFirstWriteShort((unsigned int) pcx_header.bottom,image->file); E   LSBFirstWriteShort((unsigned int) pcx_header.horizontal_resolution,      image->file); P   LSBFirstWriteShort((unsigned int) pcx_header.vertical_resolution,image->file);   /*     Dump colormap to file.   */E   pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); -   if (pcx_colormap == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    q=pcx_colormap; #   for (i=0; i < image->colors; i++)    {       *q++=image->colormap[i].red;"     *q++=image->colormap[i].green;!     *q++=image->colormap[i].blue;    } 8   (void) fwrite((char *) pcx_colormap,3,16,image->file);6   (void) fwrite(&pcx_header.reserved,1,1,image->file);4   (void) fwrite(&pcx_header.planes,1,1,image->file);K   LSBFirstWriteShort((unsigned int) pcx_header.bytes_per_line,image->file); I   LSBFirstWriteShort((unsigned int) pcx_header.palette_info,image->file);    for (i=0; i < 58; i++)(     (void) fwrite("\0",1,1,image->file);   /*&     Convert MIFF to PCX raster pixels.   */   pcx_pixels=(unsigned char *)H     malloc(pcx_header.bytes_per_line*image->rows*sizeof(unsigned char));+   if (pcx_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    x=0;   y=0;   p=image->pixels;   q=pcx_pixels; $   if (pcx_header.bits_per_pixel > 1)&     for (i=0; i < image->packets; i++)     { *       for (j=0; j <= (int) p->length; j++)       {          *q++=p->index;         x++;          if (x == image->columns)           {              x=0;             y++;5             q=pcx_pixels+y*pcx_header.bytes_per_line;            }        } 
       p++;     }    else     {        register unsigned char         bit,
         byte,          polarity;          /*<         Convert PseudoClass image to a PCX monochrome image.       */       polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);        bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) %                 *q++=byte << (8-bit);                bit=0;               byte=0;                x=0;               y++;7               q=pcx_pixels+y*pcx_header.bytes_per_line;             }	         }          p++;       }      }    /*!     Runlength-encoded PCX pixels.    */!   for (y=0; y < image->rows; y++)    { -     q=pcx_pixels+y*pcx_header.bytes_per_line;      previous=(*q++);     count=1;5     for (x=0; x < (pcx_header.bytes_per_line-1); x++)      {        packet=(*q++);/       if ((packet == previous) && (count < 63)) 	         {            count++;           continue; 	         } 5       if ((count > 1) || ((previous & 0xc0) == 0xc0)) 	         {            count|=0xc0;0           (void) fwrite(&count,1,1,image->file);	         } /       (void) fwrite(&previous,1,1,image->file);        previous=packet;       count=1;     } 3     if ((count > 1) || ((previous & 0xc0) == 0xc0))        {          count|=0xc0;.         (void) fwrite(&count,1,1,image->file);       } -     (void) fwrite(&previous,1,1,image->file);    }    if (image->colors > 16)      { D       (void) fwrite(&pcx_header.colormap_signature,1,1,image->file);=       (void) fwrite((char *) pcx_colormap,3,256,image->file);      }    free((char *) pcx_pixels);   free((char *) pcx_colormap);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P I C T I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WritePICTImage writes an image to a file in the Apple Macintosh  %  QuickDraw/PICT image format.  % / %  The format of the WritePICTImage routine is:  % . %      status=WritePICTImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WritePICTImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WritePICTImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {  #define MaxCount  128  #define PictCropRegionOp  0x01  #define PictEndOfPictureOp  0xff #define PictHeaderOp  0x0C00 #define PictHeaderSize  512  #define PictPixmapOp  0x9A #define PictPackbitsOp  0x98 #define PictVersion  0x11      typedef struct _PICTRectangle    {      unsigned short
       top,       left, 
       bottom,        right;   } PICTRectangle;     typedef struct _PICTPixmap   {      unsigned short       base_address,        row_bytes;       PICTRectangle 
       bounds;        unsigned short       version,       pack_type;       unsigned long        pack_size,       horizontal_resolution,       vertical_resolution;       unsigned short       pixel_type,        pixel_size,        component_count,       component_size;        unsigned short       plane_bytes,       table,       reserved;    } PICTPixmap;      int 
     count;     PICTPixmap     pixmap;      PICTRectangle      crop_rectangle,      destination_rectangle,     frame_rectangle,     size_rectangle,      source_rectangle;      register int     i,     j,     x;     register RunlengthPacket     *p;      unsigned char      *buffer,     *packed_scanline,      *scanline;     unsigned int     bytes_per_line;      unsigned short     transfer_mode;     unsigned long      horizontal_resolution,     vertical_resolution;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Allocate memory.   */    bytes_per_line=image->columns;"   if (image->class == DirectClass)     bytes_per_line*=3;H   buffer=(unsigned char *) malloc(PictHeaderSize*sizeof(unsigned char));#   packed_scanline=(unsigned char *) M     malloc((bytes_per_line+bytes_per_line/MaxCount+1)*sizeof(unsigned char)); J   scanline=(unsigned char *) malloc(bytes_per_line*sizeof(unsigned char));+   if ((buffer == (unsigned char *) NULL) || 4       (packed_scanline == (unsigned char *) NULL) ||+       (scanline == (unsigned char *) NULL))      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    /*     Initialize image info.   */   size_rectangle.top=0;    size_rectangle.left=0;#   size_rectangle.right=image->rows; '   size_rectangle.bottom=image->columns; !   frame_rectangle=size_rectangle;     crop_rectangle=size_rectangle;"   source_rectangle=size_rectangle;'   destination_rectangle=size_rectangle; #   horizontal_resolution=0x00480000; !   vertical_resolution=0x00480000;    pixmap.base_address=0xff;    pixmap.row_bytes= D     ((image->class == DirectClass ? 4 : 1)*image->columns) | 0x8000;   pixmap.version=0;    pixmap.bounds.top=0;   pixmap.bounds.left=0; "   pixmap.bounds.right=image->rows;&   pixmap.bounds.bottom=image->columns;=   pixmap.pack_type=(image->class == DirectClass ? 0x4 : 0x0);    pixmap.pack_size=0; 5   pixmap.horizontal_resolution=horizontal_resolution; 1   pixmap.vertical_resolution=vertical_resolution; ;   pixmap.pixel_type=(image->class == DirectClass ? 16 : 0); ;   pixmap.pixel_size=(image->class == DirectClass ? 32 : 8); ?   pixmap.component_count=(image->class == DirectClass ? 3 : 1);    pixmap.component_size=8;   pixmap.plane_bytes=0;    pixmap.table=0;    pixmap.reserved=0;9   transfer_mode=(image->class == DirectClass ? 0x40 : 0);    /*H     Write header, header size, size bounding box, version, and reserved.   */$   for (i=0; i < PictHeaderSize; i++)     buffer[i]=0;>   (void) fwrite((char *) buffer,1,PictHeaderSize,image->file);$   MSBFirstWriteShort(0,image->file);5   MSBFirstWriteShort(size_rectangle.top,image->file); 6   MSBFirstWriteShort(size_rectangle.left,image->file);7   MSBFirstWriteShort(size_rectangle.right,image->file); 8   MSBFirstWriteShort(size_rectangle.bottom,image->file);.   MSBFirstWriteShort(PictVersion,image->file);)   MSBFirstWriteShort(0x02FF,image->file); /   MSBFirstWriteShort(PictHeaderOp,image->file);    /*N     Write full size of the file, resolution, frame bounding box, and reserved.   */-   MSBFirstWriteLong(0xFFFE0000L,image->file); 7   MSBFirstWriteLong(horizontal_resolution,image->file); 5   MSBFirstWriteLong(vertical_resolution,image->file); 6   MSBFirstWriteShort(frame_rectangle.top,image->file);7   MSBFirstWriteShort(frame_rectangle.left,image->file); 8   MSBFirstWriteShort(frame_rectangle.right,image->file);9   MSBFirstWriteShort(frame_rectangle.bottom,image->file); $   MSBFirstWriteLong(0L,image->file);   /*3     Write crop region opcode and crop bounding box.    */3   MSBFirstWriteShort(PictCropRegionOp,image->file); &   MSBFirstWriteShort(0xA,image->file);5   MSBFirstWriteShort(crop_rectangle.top,image->file); 6   MSBFirstWriteShort(crop_rectangle.left,image->file);7   MSBFirstWriteShort(crop_rectangle.right,image->file); 8   MSBFirstWriteShort(crop_rectangle.bottom,image->file);   /*K     Write picture opcode, row bytes, and picture bounding box, and version.    */"   if (image->class == PseudoClass)3     MSBFirstWriteShort(PictPackbitsOp,image->file);    else     { 3       MSBFirstWriteShort(PictPixmapOp,image->file); I       MSBFirstWriteLong((unsigned long) pixmap.base_address,image->file);      }    if (pixmap.row_bytes & 0x01)     pixmap.row_bytes++; <   MSBFirstWriteShort(pixmap.row_bytes | 0x8000,image->file);4   MSBFirstWriteShort(pixmap.bounds.top,image->file);5   MSBFirstWriteShort(pixmap.bounds.left,image->file); 6   MSBFirstWriteShort(pixmap.bounds.right,image->file);7   MSBFirstWriteShort(pixmap.bounds.bottom,image->file); 1   MSBFirstWriteShort(pixmap.version,image->file);    /*G     Write pack type, pack size, resolution, pixel type, and pixel size.    */3   MSBFirstWriteShort(pixmap.pack_type,image->file); 2   MSBFirstWriteLong(pixmap.pack_size,image->file);>   MSBFirstWriteLong(pixmap.horizontal_resolution,image->file);<   MSBFirstWriteLong(pixmap.vertical_resolution,image->file);4   MSBFirstWriteShort(pixmap.pixel_type,image->file);4   MSBFirstWriteShort(pixmap.pixel_size,image->file);   /*G     Write component count, size, plane bytes, table size, and reserved.    */9   MSBFirstWriteShort(pixmap.component_count,image->file); 8   MSBFirstWriteShort(pixmap.component_size,image->file);D   MSBFirstWriteLong((unsigned long) pixmap.plane_bytes,image->file);>   MSBFirstWriteLong((unsigned long) pixmap.table,image->file);A   MSBFirstWriteLong((unsigned long) pixmap.reserved,image->file); "   if (image->class == PseudoClass)     {        unsigned short         red,         green,
         blue;          /*         Write image colormap.        */:       MSBFirstWriteLong(0L,image->file);  /* color seed */<       MSBFirstWriteShort(0L,image->file);  /* color flags */I       MSBFirstWriteShort((unsigned short) (image->colors-1),image->file); '       for (i=0; i < image->colors; i++)        { A         red=(image->colormap[i].red*65535)/(unsigned int) MaxRGB; E         green=(image->colormap[i].green*65535)/(unsigned int) MaxRGB; C         blue=(image->colormap[i].blue*65535)/(unsigned int) MaxRGB; 9         MSBFirstWriteShort((unsigned int) i,image->file); ,         MSBFirstWriteShort(red,image->file);.         MSBFirstWriteShort(green,image->file);-         MSBFirstWriteShort(blue,image->file);        }      }    /*+     Write source and destination rectangle.    */7   MSBFirstWriteShort(source_rectangle.top,image->file); 8   MSBFirstWriteShort(source_rectangle.left,image->file);9   MSBFirstWriteShort(source_rectangle.right,image->file); :   MSBFirstWriteShort(source_rectangle.bottom,image->file);<   MSBFirstWriteShort(destination_rectangle.top,image->file);=   MSBFirstWriteShort(destination_rectangle.left,image->file); >   MSBFirstWriteShort(destination_rectangle.right,image->file);?   MSBFirstWriteShort(destination_rectangle.bottom,image->file); 0   MSBFirstWriteShort(transfer_mode,image->file);   /*     Write picture data.    */
   count=0;   x=0;   p=image->pixels;"   if (image->class == PseudoClass)     {        register unsigned char         *index;          index=scanline; (       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { ,           *index++=(unsigned char) p->index;           x++;"           if (x == image->columns)
             { I               count+=PackbitsEncodeImage(image,scanline,packed_scanline);                index=scanline;                x=0;
             } 	         }          p++;       }      }    else     {        register unsigned char         *blue,
         *red,          *green;          red=scanline; $       green=scanline+image->columns;*       blue=scanline+(image->columns << 1);(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            *red++=p->red;           *green++=p->green;           *blue++=p->blue;           x++;"           if (x == image->columns)
             {                red=scanline; ,               green=scanline+image->columns;2               blue=scanline+(image->columns << 1);D               count+=PackbitsEncodeImage(image,red,packed_scanline);               x=0;
             } 	         }          p++;       }      }    if (count & 0x1)#     (void) fputc('\0',image->file); 5   MSBFirstWriteShort(PictEndOfPictureOp,image->file);    free((char *) scanline);!   free((char *) packed_scanline);    free((char *) buffer);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P N M I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Procedure WritePNMImage writes an image to a file in the PNM rasterfile
 %  format. % . %  The format of the WritePNMImage routine is: % - %      status=WritePNMImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePNMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePNMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      format,      *pnm_pixels;     unsigned int     packets;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*-     Promote/Demote image based on image type.    */'   if (strcmp(image->magick,"PPM") == 0)      image->class=DirectClass;    else)     if (strcmp(image->magick,"PGM") == 0)        { E         QuantizeImage(image,256,8,image_info->dither,GRAYColorspace);          SyncImage(image);        }      else+       if (strcmp(image->magick,"PBM") == 0) 	         { E           QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);            SyncImage(image); 	         }    /*     Write PNM file header.   */%   packets=image->columns*image->rows;    if (!IsPseudoClass(image))     {        /*         Full color PNM image.        */       format='6';        packets*=3;      }    else     {        /*         Colormapped PNM image.       */       format='6'; D       if (!IsGrayImage(image) || (strcmp(image->magick,"PPM") == 0))         packets*=3; 
       else	         {            /*              Grayscale PNM image.           */           format='5'; /           if (strcmp(image->magick,"PGM") != 0) #             if (image->colors == 2)                format='4'; 	         }      } -   (void) fprintf(image->file,"P%c\n",format); '   if (image->comments != (char *) NULL)      {        register char          *p;          /*         Write comments to file.        */'       (void) fprintf(image->file,"# "); .       for (p=image->comments; *p != '\0'; p++)       { %         (void) fputc(*p,image->file);          if (*p == '\n') +           (void) fprintf(image->file,"# ");        } %       (void) fputc('\n',image->file);      } C   (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);    /*&     Convert MIFF to PNM raster pixels.   */E   pnm_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); +   if (pnm_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=pnm_pixels;    switch (format)    { 
     case '4':      {        register unsigned char         bit,
         byte,          polarity;          unsigned int
         x;         /*%         Convert image to a PBM image.        */       polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);        bit=0;
       byte=0; 
       x=0;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) %                 *q++=byte << (8-bit);                bit=0;               byte=0;                x=0;            }	         }          p++;       }        packets=q-pnm_pixels;        break;     } 
     case '5':      {        /*%         Convert image to a PGM image.        */0       (void) fprintf(image->file,"%d\n",MaxRGB);(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)-           *q++=image->colormap[p->index].red;          p++;       }        break;     } 
     case '6':      {        /*%         Convert image to a PNM image.        */0       (void) fprintf(image->file,"%d\n",MaxRGB);(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            *q++=p->red;           *q++=p->green;           *q++=p->blue; 	         }          p++;       }        break;     }    } A   (void) fwrite((char *) pnm_pixels,1,(int) packets,image->file);    free((char *) pnm_pixels);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e R A D I A N C E I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteRADIANCEImage writes an image in the RADIANCE encoded image
 %  format. % 3 %  The format of the WriteRADIANCEImage routine is:  % 2 %      status=WriteRADIANCEImage(image_info,image) % + %  A description of each parameter follows.  % O %    o status: Function WriteRADIANCEImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */8 static unsigned int WriteRADIANCEImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   :   Warning("Cannot write RADIANCE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e R L E I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteRLEImage writes an image in the Utah Run length encoded image
 %  format. % . %  The format of the WriteRLEImage routine is: % - %      status=WriteRLEImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteRLEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteRLEImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    Image      *flipped_image;      unsigned int     status;   %   TemporaryFilename(image->filename); !   flipped_image=FlipImage(image); &   if (flipped_image == (Image *) NULL)+     status=WriteSUNImage(image_info,image);    else     { 5       status=WriteSUNImage(image_info,flipped_image); "       DestroyImage(flipped_image);     } 
   if (status)      { 
       char         command[MaxTextLength];   H       (void) sprintf(command,"rastorle -o %s %s\n",image_info->filename,         image->filename); $       status=SystemCommand(command);%       (void) unlink(image->filename);        if (!status)2         Warning("RLE translation failed",command);     }    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P S I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WritePSImage translates an image to encapsulated Postscript H %  Level I for printing.  If the supplied geometry is null, the image isJ %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.  % - %  The format of the WritePSImage routine is:  % , %      status=WritePSImage(image_info,image) % + %  A description of each parameter follows:  % I %    o status: Function WritePSImage return True if the image is printed. I %      False is returned if the image file cannot be opened for printing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */2 static unsigned int WritePSImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  { 
   static char      *Postscript[]=     {        "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on", G       "% Postscript viewers or printers that support color, otherwise", (       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",        "/byte 1 string def", #       "/color_packet 3 string def",        "/pixels 768 string def", 	       "",        "/DirectClassPacket", 
       "{",       "  %",&       "  % Get a DirectClass packet.",       "  %",       "  % Parameters: ",        "  %   red.",        "  %   green.",        "  %   blue.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",9       "  currentfile color_packet readhexstring pop pop",        "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", 0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse", "       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",        "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",'       "  systemdict /colorimage known",        "  {",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",5       "    { DirectClassPacket } false 3 colorimage",        "  }",       "  {",       "    %",=       "    % No colorimage operator;  convert to grayscale.",        "    %",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",,       "    { GrayDirectClassPacket } image",       "  } ifelse",        "} bind def", 	       "",        "/GrayDirectClassPacket", 
       "{",       "  %",=       "  % Get a DirectClass packet;  convert to grayscale.",        "  %",       "  % Parameters: ",        "  %   red",       "  %   green",       "  %   blue", K       "  %   length: number of pixels minus one of this color (optional).",        "  %",9       "  currentfile color_packet readhexstring pop pop", '       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add", +       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", *       "    /number_pixels exch 1 add def",       "  } ifelse", "       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/GrayPseudoClassPacket", 
       "{",       "  %",=       "  % Get a PseudoClass packet;  convert to grayscale.",        "  %",       "  % Parameters: ", .       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get", !       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",'       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add", +       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", *       "    /number_pixels exch 1 add def",       "  } ifelse", "       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/PseudoClassPacket", 
       "{",       "  %",&       "  % Get a PseudoClass packet.",       "  %",       "  % Parameters: ", .       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get", !       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",       "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", 0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse", "       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",        "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",        "  %",       "  % Parameters: ", 3       "  %   class: 0-PseudoClass or 1-Grayscale.",        "  %",*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",       "  class 0 gt",        "  {",&       "    /grays columns string def",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",:       "    { currentfile grays readhexstring pop } image",       "  }",       "  {",       "    %",       "    % Parameters: ", :       "    %   colors: number of colors in the colormap.",:       "    %   colormap: red, green, blue color packets.",       "    %",,       "    currentfile buffer readline pop",+       "    token pop /colors exch def pop", %       "    /colors colors 3 mul def", (       "    /colormap colors string def",7       "    currentfile colormap readhexstring pop pop", )       "    systemdict /colorimage known",        "    {",       "      columns rows 8",        "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",7       "      { PseudoClassPacket } false 3 colorimage",        "    }",       "    {",       "      %",?       "      % No colorimage operator;  convert to grayscale.",        "      %",       "      columns rows 8",        "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",.       "      { GrayPseudoClassPacket } image",       "    } ifelse",        "  } ifelse",        "} bind def", 	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters: ", !       "  %   x & y translation.",        "  %   x & y scale.",        "  %   image label.", $       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.", M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.", !       "  %   hex color packets.",        "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",@       "  /NewCenturySchlbk-Roman findfont 24 scalefont setfont",*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",        (char *) NULL      };     char     *label,      **q;     int      sans_offset,     x,     y;     register RunlengthPacket     *p;      register int     i,     j;     time_t
     timer;     unsigned int     dx_resolution,     dy_resolution,     height,      text_size,     x_resolution,      y_resolution, 
     width;     /*     Open output image file.    */   OpenImage(image,"w"); #   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*+     Scale image to size of Postscript page.    */3   text_size=image->label == (char *) NULL ? 0 : 36;    x=0;   y=0;   width=image->columns;    height=image->rows; &   if (strcmp(image->magick,"PS") == 0)     { 	       int          delta_x,         delta_y,         flags;         unsigned int         page_height,         page_width;          /*(         Center image on Postscript page.       */K       (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height); L       flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);,       if (((page_width-(x << 1)) < width) ||6           ((page_height-(y << 1)-text_size) < height))	         {            unsigned long              scale_factor;              /*4             Scale image relative to Postscript page.           */:           scale_factor=UpShift(page_width-(x << 1))/width;N           if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))H             scale_factor=UpShift(page_height-(y << 1)-text_size)/height;.           width=DownShift(width*scale_factor);0           height=DownShift(height*scale_factor);	         }         if ((flags & XValue) == 0)	         {            /*,             Center image in the X direction.           */.           delta_x=page_width-(width+(x << 1));           if (delta_x >= 0)              x=(delta_x >> 1)+x; 	         }         if ((flags & YValue) == 0)	         {            /*,             Center image in the X direction.           */:           delta_y=page_height-(height+(y << 1))-text_size;           if (delta_y >= 0)              y=(delta_y >> 1)+y; 	         }      }    /*$     Scale relative to dots-per-inch.   */D   (void) XParseGeometry(PSDensityGeometry,&sans_offset,&sans_offset,#     &dx_resolution,&dy_resolution);    x_resolution=dx_resolution;    y_resolution=dy_resolution; F   (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,!     &x_resolution,&y_resolution); +   width=(width*dx_resolution)/x_resolution; -   height=(height*dy_resolution)/y_resolution;    /*     Output Postscript header.    */&   if (strcmp(image->magick,"PS") == 0)4     (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");   else=     (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n"); @   (void) fprintf(image->file,"%%%%Title: %s\n",image->filename);;   (void) fprintf(image->file,"%%%%Creator: ImageMagick\n");    timer=time((time_t *) NULL);   (void) localtime(&timer); C   (void) fprintf(image->file,"%%%%CreationDate: %s",ctime(&timer)); P   (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",x,y,x+(int) width,     y+(int) height+text_size);&   if (strcmp(image->magick,"PS") == 0)     { @       (void) fprintf(image->file,"%%%%Orientation: Portrait\n");<       (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");     } P   (void) fprintf(image->file,"%%%%Pages: %d\n",strcmp(image->magick,"PS") == 0);2   (void) fprintf(image->file,"%%%%EndComments\n");(   if (strcmp(image->magick,"EPSI") == 0)     {        Image          *preview_image;          register unsigned char         bit,
         byte,          polarity;          unsigned int         count;         /*-         Initialize bordered image attributes.        */       image->orphan=True; E       preview_image=CopyImage(image,image->columns,image->rows,True);        image->orphan=False;*       if (preview_image == (Image *) NULL)	         { P           Warning("Unable to include preview image","Memory allocation failed");           return(False);	         }        /*&         Convert MIFF to bitmap pixels.       */I       QuantizeImage(preview_image,2,8,image_info->dither,GRAYColorspace);        polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);        bit=0;
       byte=0;        count=0;
       x=0;       p=preview_image->pixels;G       (void) fprintf(image->file,"%%%%BeginPreview: %u %u %u %u\n%%  ", D         preview_image->columns,preview_image->rows,(unsigned int) 1,G         (((preview_image->columns+7) >> 3)*preview_image->rows+35)/36); 0       for (i=0; i < preview_image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                /*6                 Write a bitmap byte to the image file.               */=               (void) fprintf(image->file,"%02x",byte & 0xff);                count++;               if (count == 36)                 { 7                   (void) fprintf(image->file,"\n%%  ");                    count=0;                 };               bit=0;               byte=0; 
             }            x++;*           if (x == preview_image->columns)
             {                if (bit != 0)                  {                    /*:                     Write a bitmap byte to the image file.                   */!                   byte<<=(8-bit); A                   (void) fprintf(image->file,"%02x",byte & 0xff);                    count++;"                   if (count == 36)                     { ;                       (void) fprintf(image->file,"\n%%  ");                        count=0;                     };                   bit=0;                   byte=0;                  };               x=0;
             }            }            p++;	         } 9         (void) fprintf(image->file,"\n%%%%EndPreview\n"); $         DestroyImage(preview_image);       }    /*     Output Postscript commands.    */   for (q=Postscript; *q; q++) *     (void) fprintf(image->file,"%s\n",*q);&   if (strcmp(image->magick,"PS") == 0)/     (void) fprintf(image->file,"  showpage\n"); -   (void) fprintf(image->file,"} bind def\n"); .   (void) fprintf(image->file,"%%EndProlog\n");/   (void) fprintf(image->file,"%%Page:  1 1\n"); &   if (strcmp(image->magick,"PS") != 0)3     (void) fprintf(image->file,"userdict begin\n"); 1   (void) fprintf(image->file,"%%%%BeginData:\n"); /   (void) fprintf(image->file,"DisplayImage\n");    /*     Output image data.   */8   if (image->compression == RunlengthEncodedCompression)     CompressImage(image);    label=image->label;    if (label == (char *) NULL)      label=" ";   p=image->pixels;   switch (image->class)    {      case DirectClass:      { P       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression); !       switch (image->compression)        { )         case RunlengthEncodedCompression:          default:	         {            /*7             Dump runlength-encoded DirectColor packets.            */           x=0;,           for (i=0; i < image->packets; i++)           {              x++;J             (void) fprintf(image->file,"%02x%02x%02x%02x",p->red,p->green,!               p->blue,p->length);              if (x == 9)                {                  x=0;1                 (void) fprintf(image->file,"\n");                }              p++;           }            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed DirectColor packets.           */           x=0;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {                x++;H               (void) fprintf(image->file,"%02x%02x%02x",p->red,p->green,                 p->blue);                if (x == 12)                 {                    x=0;3                   (void) fprintf(image->file,"\n");                  } 
             }              p++;           }            break;	         }        }        break;     }      case PseudoClass:      {        unsigned int         grayscale;  P       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression); L       grayscale=IsGrayImage(image) && (image->compression == NoCompression);3       (void) fprintf(image->file,"%d\n",grayscale);        if (!grayscale) 	         {            /*/             Dump number of colors and colormap.            */;           (void) fprintf(image->file,"%u\n",image->colors); +           for (i=0; i < image->colors; i++) O             (void) fprintf(image->file,"%02x%02x%02x\n",image->colormap[i].red, @               image->colormap[i].green,image->colormap[i].blue);	         } !       switch (image->compression)        { )         case RunlengthEncodedCompression:          default:	         {            /*7             Dump runlength-encoded PseudoColor packets.            */           x=0;,           for (i=0; i < image->packets; i++)           {              x++;F             (void) fprintf(image->file,"%02x%02x",p->index,p->length);             if (x == 18)               {                  x=0;1                 (void) fprintf(image->file,"\n");                }              p++;           }            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed PseudoColor packets.           */           x=0;           if (grayscale).             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               {                  x++;:                 (void) fprintf(image->file,"%02x",p->red);                 if (x == 36)                   {                      x=0;5                     (void) fprintf(image->file,"\n");                    }                }                p++;
             }            else.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               {                  x++;<                 (void) fprintf(image->file,"%02x",p->index);                 if (x == 36)                   {                      x=0;5                     (void) fprintf(image->file,"\n");                    }                }                p++;
             }            break;	         }        }      }    } #   (void) fprintf(image->file,"\n"); .   (void) fprintf(image->file,"%%%%EndData\n");&   if (strcmp(image->magick,"PS") != 0)(     (void) fprintf(image->file,"end\n");2   (void) fprintf(image->file,"%%%%PageTrailer\n");.   (void) fprintf(image->file,"%%%%Trailer\n");*   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P S 2 I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WritePS2Image translates an image to encapsulated PostscriptI %  Level II for printing.  If the supplied geometry is null, the image is J %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.  % . %  The format of the WritePS2Image routine is: % - %      status=WritePS2Image(image_info,image)  % + %  A description of each parameter follows:  % J %    o status: Function WritePS2Image return True if the image is printed.I %      False is returned if the image file cannot be opened for printing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */3 static unsigned int WritePS2Image(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  { 
   static char      *Postscript[]=     {        "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on", G       "% Postscript viewers or printers that support color, otherwise", (       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def", 	       "",        "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",#       "  /DeviceRGB setcolorspace", 
       "  <<",        "    /ImageType 1",        "    /Interpolate true",       "    /Width columns",        "    /Height rows",         "    /BitsPerComponent 8","       "    /Decode [0 1 0 1 0 1]",7       "    /ImageMatrix [columns 0 0 rows neg 0 rows]",        "    compression 0 gt",        "    {",=       "      /DataSource currentfile /ASCIIHexDecode filter",        "    }",       "    {",O       "      /DataSource currentfile /ASCIIHexDecode filter /LZWDecode filter",        "    } ifelse",        "  >> image",        "} bind def", 	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",        "  %",       "  % Parameters: ", 8       "  %   colors: number of colors in the colormap.",8       "  %   colormap: red, green, blue color packets.",       "  %",*       "  currentfile buffer readline pop",)       "  token pop /colors exch def pop", ,       "  /colormap colors 3 mul string def",5       "  currentfile colormap readhexstring pop pop", F       "  [ /Indexed /DeviceRGB colors 1 sub colormap ] setcolorspace",
       "  <<",        "    /ImageType 1",        "    /Interpolate true",       "    /Width columns",        "    /Height rows",         "    /BitsPerComponent 8",       "    /Decode [0 255]",7       "    /ImageMatrix [columns 0 0 rows neg 0 rows]",        "    compression 0 gt",        "    {",=       "      /DataSource currentfile /ASCIIHexDecode filter",        "    }",       "    {",O       "      /DataSource currentfile /ASCIIHexDecode filter /LZWDecode filter",        "    } ifelse",        "  >> image",        "} bind def", 	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters: ",%!       "  %   x & y translation.",%       "  %   x & y scale.",        "  %   image label.", $       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.", M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.", !       "  %   hex color packets.",        "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",@       "  /NewCenturySchlbk-Roman findfont 24 scalefont setfont",*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",        "  showpage",        "} bind def",        "%%EndProlog",       "%%Page:  1 1", 
       NULL     };     char     *label,n     **q;     int      sans_offset,     x,     y;     register RunlengthPacket     *p;      register int     i,     j;     time_t
     timer;     unsigned char      *pixels;     unsigned int     dx_resolution,     dy_resolution,     height,d     number_packets,      text_size,     x_resolution,      y_resolution, 
     width;     /*     Open output image file.s   */   OpenImage(image,"w");i#   if (image->file == (FILE *) NULL)      {s5       Warning("Unable to open file",image->filename);t       return(False);     }e   /*+     Scale image to size of Postscript page.i   */3   text_size=image->label == (char *) NULL ? 0 : 36;p   x=0;   y=0;   width=image->columns;    height=image->rows;t&   if (strcmp(image->magick,"PS") == 0)     {u	       int          delta_x,         delta_y,         flags;         unsigned int         page_height,         page_width;u         /*(         Center image on Postscript page.       */K       (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);iL       flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);,       if (((page_width-(x << 1)) < width) ||6           ((page_height-(y << 1)-text_size) < height))	         {            unsigned long              scale_factor;t             /*4             Scale image relative to Postscript page.           */:           scale_factor=UpShift(page_width-(x << 1))/width;N           if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))H             scale_factor=UpShift(page_height-(y << 1)-text_size)/height;.           width=DownShift(width*scale_factor);0           height=DownShift(height*scale_factor);	         }o        if ((flags & XValue) == 0)	         {c           /*,             Center image in the X direction.           */.           delta_x=page_width-(width+(x << 1));           if (delta_x >= 0)              x=(delta_x >> 1)+x; 	         }%        if ((flags & YValue) == 0)	         {%           /*,             Center image in the X direction.           */:           delta_y=page_height-(height+(y << 1))-text_size;           if (delta_y >= 0)e             y=(delta_y >> 1)+y;k	         }u     }g   /*$     Scale relative to dots-per-inch.   */D   (void) XParseGeometry(PSDensityGeometry,&sans_offset,&sans_offset,#     &dx_resolution,&dy_resolution);M   x_resolution=dx_resolution;I   y_resolution=dy_resolution;cF   (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,!     &x_resolution,&y_resolution);%+   width=(width*dx_resolution)/x_resolution; -   height=(height*dy_resolution)/y_resolution;    /*     Output Postscript header.    */&   if (strcmp(image->magick,"PS") == 0)4     (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");   else=     (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n"); @   (void) fprintf(image->file,"%%%%Title: %s\n",image->filename);;   (void) fprintf(image->file,"%%%%Creator: ImageMagick\n");    timer=time((time_t *) NULL);   (void) localtime(&timer); C   (void) fprintf(image->file,"%%%%CreationDate: %s",ctime(&timer)); P   (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",x,y,x+(int) width,     y+(int) height+text_size);&   if (strcmp(image->magick,"PS") == 0)     {n@       (void) fprintf(image->file,"%%%%Orientation: Portrait\n");<       (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");     }dP   (void) fprintf(image->file,"%%%%Pages: %d\n",strcmp(image->magick,"PS") == 0);2   (void) fprintf(image->file,"%%%%EndComments\n");   /*     Output Postscript commands.e   */   for (q=Postscript; *q; q++)t*     (void) fprintf(image->file,"%s\n",*q);&   if (strcmp(image->magick,"PS") != 0)3     (void) fprintf(image->file,"userdict begin\n"); 1   (void) fprintf(image->file,"%%%%BeginData:\n");o/   (void) fprintf(image->file,"DisplayImage\n");    /*     Output image data.   */   label=image->label;    if (label == (char *) NULL)      label=" ";   p=image->pixels;   if (!IsPseudoClass(image))     { P       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression);I!       switch (image->compression)(       {o)         case RunlengthEncodedCompression:n         default:	         {n            register unsigned char             *q;d             /*!             Allocate pixel array.;           */6           number_packets=3*image->columns*image->rows;P           pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));/           if (pixels == (unsigned char *) NULL) 
             { ?               Warning("Memory allocation error",(char *) NULL);z               return(False);
             }x           /*$             Dump LZW encoded pixels.           */           q=pixels;(,           for (i=0; i < image->packets; i++)           {m0             for (j=0; j <= (int) p->length; j++)
             {r               *q++=p->red;               *q++=p->green;               *q++=p->blue;,
             }c             p++;           }-D           (void) LZWEncodeFilter(image->file,pixels,number_packets);*           (void) fprintf(image->file,">");            free((char *) pixels);           break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed DirectColor packets.           */           x=0;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {                x++;H               (void) fprintf(image->file,"%02x%02x%02x",p->red,p->green,                 p->blue);                if (x == 12)                 {                    x=0;3                   (void) fprintf(image->file,"\n");                  } 
             }%             p++;           }%           break;	         }%       }      }F   else     {PP       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression);t       /*+         Dump number of colors and colormap.        */7       (void) fprintf(image->file,"%u\n",image->colors);h'       for (i=0; i < image->colors; i++)fK         (void) fprintf(image->file,"%02x%02x%02x\n",image->colormap[i].red,n<           image->colormap[i].green,image->colormap[i].blue);!       switch (image->compression)s       { )         case RunlengthEncodedCompression:          default:	         {             register unsigned char             *q;              /*!             Allocate pixel array.s           */4           number_packets=image->columns*image->rows;P           pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));/           if (pixels == (unsigned char *) NULL)p
             { ?               Warning("Memory allocation error",(char *) NULL);l               return(False);
             };           /*$             Dump LZW encoded pixels.           */           q=pixels; ,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++),               *q++=(unsigned char) p->index;             p++;           }oD           (void) LZWEncodeFilter(image->file,pixels,number_packets);*           (void) fprintf(image->file,">");            free((char *) pixels);           break;	         }          case NoCompression:P	         {e           /*2             Dump uncompressed PseudoColor packets.           */           x=0;,           for (i=0; i < image->packets; i++)           {s2             for (j=0; j <= ((int) p->length); j++)
             {m               x++;:               (void) fprintf(image->file,"%02x",p->index);               if (x == 36)                 {                    x=0;3                   (void) fprintf(image->file,"\n");c                 }_
             }e             p++;           };           break;	         }s       }      }d#   (void) fprintf(image->file,"\n");e.   (void) fprintf(image->file,"%%%%EndData\n");&   if (strcmp(image->magick,"PS") != 0)(     (void) fprintf(image->file,"end\n");2   (void) fprintf(image->file,"%%%%PageTrailer\n");.   (void) fprintf(image->file,"%%%%Trailer\n");*   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);3 }4   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %_O %                                                                             % O %                                                                             %_O %   W r i t e R G B I m a g e                                                 % O %                                                                             %;O %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %aF %  Function WriteRGBImage writes an image to a file in red, green, and %  blue rasterfile format. %I. %  The format of the WriteRGBImage routine is: %o- %      status=WriteRGBImage(image_info,image)  %m+ %  A description of each parameter follows.  %mJ %    o status: Function WriteRGBImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.q %b. %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteRGBImage(image_info,image)u	 ImageInfo    *image_info;   Image*	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;i     register unsigned char     *q;<     unsigned char      *rgb_pixels;     /*     Open output image file.;   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*&     Convert MIFF to RGB raster pixels.   */   rgb_pixels=(unsigned char *)?     malloc(3*image->columns*image->rows*sizeof(unsigned char)); +   if (rgb_pixels == (unsigned char *) NULL)h     { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    q=rgb_pixels;     switch (image_info->interlace)   {      case NoneInterlace:y     default:     {        /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            *q++=p->red;           *q++=p->green;           *q++=p->blue;(	         }g         p++;       }        break;     }      case LineInterlace:;     {        register int
         x,
         y;         /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...-       */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)r       { +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {o           *q++=p->red;           p++;	         }f+         p=image->pixels+(y*image->columns);e*         for (x=0; x < image->columns; x++)	         {            *q++=p->green;           p++;	         }g+         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {<           *q++=p->blue;(           p++;	         }k       }f       break;     }      case PlaneInterlace:     {e       /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...o       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)           *q++=p->red;         p++;       }b       p=image->pixels;(       for (i=0; i < image->packets; i++)       {m.         for (j=0; j <= ((int) p->length); j++)           *q++=p->green;         p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       {e.         for (j=0; j <= ((int) p->length); j++)           *q++=p->blue;t         p++;       }v       break;     }    }FI   (void) fwrite((char *) rgb_pixels,3,(int) (image->columns*image->rows),m     image->file);s   free((char *) rgb_pixels);   CloseImage(image);   return(True);  }F t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             %oO %                                                                             %nO %                                                                             %rO %   W r i t e S U N I m a g e                                                 %pO %                                                                             % O %                                                                             %sO %                                                                             %*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WriteSUNImage writes an image in the SUN rasterfile format.f %m. %  The format of the WriteSUNImage routine is: % - %      status=WriteSUNImage(image_info,image)c % + %  A description of each parameter follows.  % J %    o status: Function WriteSUNImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file; %      fails to write. %mA %    o image_info: Specifies a pointer to an ImageInfo structure.p %l. %    o image:  A pointer to a Image structure. %f %) */3 static unsigned int WriteSUNImage(image_info,image)f	 ImageInfo    *image_info;   Image_	   *image;e {z #define RMT_EQUAL_RGB  1 #define RMT_NONE  0  #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_FORMAT_RGB  3     typedef struct _SUNHeader%   {%     unsigned long%       magic,       width,
       height,        depth,
       length,        type,        maptype,       maplength;   } SUNHeader;     register int     i,     j,     x;     register RunlengthPacket     *p;      register unsigned char     *q;      SUNHeader      sun_header;      unsigned char      *sun_pixels;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*&     Initialize SUN raster file header.   */   sun_header.magic=0x59a66a95;"   sun_header.width=image->columns;    sun_header.height=image->rows;N   sun_header.type=(image->class == DirectClass ? RT_FORMAT_RGB : RT_STANDARD);   sun_header.maptype=RMT_NONE;   sun_header.maplength=0;n   if (!IsPseudoClass(image))     {a       /*         Full color SUN raster.       */0       sun_header.depth=(image->matte ? 32 : 24);J       sun_header.length=image->columns*image->rows*(image->matte ? 4 : 3);>       sun_header.length+=image->columns % 2 ? image->rows : 0;     }r   else3     if (IsGrayImage(image) && (image->colors == 2))n       {u
         /*            Monochrome SUN raster.
         */         sun_header.depth=1;n@         sun_header.length=((image->columns+7) >> 3)*image->rows;N         sun_header.length+=((image->columns/8)+(image->columns % 8 ? 1 : 0)) %           2 ? image->rows : 0;       }r     else       { 
         /*!           Colormapped SUN raster. 
         */         sun_header.depth=8; 5         sun_header.length=image->columns*image->rows; @         sun_header.length+=image->columns % 2 ? image->rows : 0;)         sun_header.maptype=RMT_EQUAL_RGB; -         sun_header.maplength=image->colors*3;m       }    /*     Write SUN header.*   */2   MSBFirstWriteLong(sun_header.magic,image->file);2   MSBFirstWriteLong(sun_header.width,image->file);3   MSBFirstWriteLong(sun_header.height,image->file);x2   MSBFirstWriteLong(sun_header.depth,image->file);3   MSBFirstWriteLong(sun_header.length,image->file); 1   MSBFirstWriteLong(sun_header.type,image->file);_4   MSBFirstWriteLong(sun_header.maptype,image->file);6   MSBFirstWriteLong(sun_header.maplength,image->file);   /*&     Convert MIFF to SUN raster pixels.   */O   sun_pixels=(unsigned char *) malloc(sun_header.length*sizeof(unsigned char)); +   if (sun_pixels == (unsigned char *) NULL)o     {l9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }i   p=image->pixels;   q=sun_pixels;    x=0;   if (!IsPseudoClass(image))     {        /*4         Convert DirectClass packet to SUN RGB pixel.       */(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {x           if (image->matte)=*             *q++=(unsigned char) p->index;           *q++=p->red;           *q++=p->green;           *q++=p->blue;e           x++;"           if (x == image->columns)
             {n,               if ((image->columns % 2) != 0)(                 q++;  /* pad scanline */               x=0;
             } 	         }          p++;       }      }a   else3     if (IsGrayImage(image) && (image->colors == 2))        {          register unsigned char           bit,           byte,M           polarity;   
         /*>           Convert PseudoClass image to a SUN monochrome image.
         */O         polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);0         bit=0;         byte=0; *         for (i=0; i < image->packets; i++)	         {=.           for (j=0; j <= (int) p->length; j++)           {              byte<<=1; %             if (p->index == polarity)=               byte|=0x01;l             bit++;             if (bit == 8)                {e                 *q++=byte;                 bit=0;                 byte=0;>               }              x++;$             if (x == image->columns)               {-                 /*/                   Advance to the next scanline.-                 */                 if (bit != 0)t'                   *q++=byte << (8-bit); )                 if ((((image->columns/8)+l<                     (image->columns % 8 ? 1 : 0)) % 2) != 0)*                   q++;  /* pad scanline */                 bit=0;                 byte=0;g                 x=0;              }           }-           p++;	         }=       }>     else       {e         unsigned char            *sun_colormap;  
         /*            Dump colormap to file.
         */&         sun_colormap=(unsigned char *)=           malloc(sun_header.maplength*sizeof(unsigned char)); 3         if (sun_colormap == (unsigned char *) NULL)e           { ?             Warning("Unable to allocate memory",(char *) NULL);              return(False);           }a         q=sun_colormap; )         for (i=0; i < image->colors; i++)n&           *q++=image->colormap[i].red;)         for (i=0; i < image->colors; i++)w(           *q++=image->colormap[i].green;)         for (i=0; i < image->colors; i++) '           *q++=image->colormap[i].blue;aI         (void) fwrite((char *) sun_colormap,1,(int) sun_header.maplength,l           image->file);.$         free((char *) sun_colormap);
         /*>           Convert PseudoClass packet to SUN colormapped pixel.
         */         q=sun_pixels;+*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {              *q++=p->index;             x++;$             if (x == image->columns)               {l.                 if ((image->columns % 2) != 0)*                   q++;  /* pad scanline */                 x=0;               }-           }            p++;	         }e       } K   (void) fwrite((char *) sun_pixels,1,(int) sun_header.length,image->file);    free((char *) sun_pixels);   CloseImage(image);   return(True);  }l M /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             % O %                                                                             %gO %                                                                             % O %   W r i t e T A R G A I m a g e                                             % O %                                                                             %kO %                                                                             % O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i % M %  Function WriteTARGAImage writes a image in the Truevision Targa rasterfile+
 %  format. % 0 %  The format of the WriteTARGAImage routine is: %R/ %      status=WriteTARGAImage(image_info,image)  % + %  A description of each parameter follows.c % L %    o status: Function WriteTARGAImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.s %a. %    o image:  A pointer to a Image structure. %k %x */5 static unsigned int WriteTARGAImage(image_info,image) 	 ImageInfo%   *image_info;   Image%	   *image;% {% #define TargaColormap 1  #define TargaRGB 2 #define TargaMonochrome 3  #define TargaRLEColormap  9  #define TargaRLERGB  10  #define TargaRLEMonochrome  11     typedef struct _TargaHeader    {      unsigned char        id_length,       colormap_type,       image_type;        unsigned short       colormap_index,        colormap_length;       unsigned char        colormap_size;       unsigned short       x_origin,        y_origin,        width,
       height;        unsigned char        pixel_size,        attributes;    } TargaHeader;     Image      *flopped_image;      int%
     count,     runlength;     register int     i,     j;     register RunlengthPacket     *p;I     register unsigned char     *q,i     *r;   
   TargaHeaderd     targa_header;T     unsigned chari     *targa_pixels;     /*     Open output image file.m   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      {o5       Warning("Unable to open file",image->filename);e       return(False);     }    /*     Flop image.m   */   image->orphan=True;e!   flopped_image=FlopImage(image);    image->orphan=False;&   if (flopped_image == (Image *) NULL)     { 5       Warning("Unable to flop file",image->filename);        return(False);     }F"   flopped_image->file=image->file;   image=flopped_image;8   if (image->compression == RunlengthEncodedCompression)     CompressImage(image);e   /*(     Initialize TARGA raster file header.   */   targa_header.id_length=0; '   if (image->comments != (char *) NULL)fB     targa_header.id_length=Min((int) strlen(image->comments),255);   targa_header.colormap_type=0;g    targa_header.colormap_index=0;!   targa_header.colormap_length=0;    targa_header.colormap_size=0;g   targa_header.x_origin=0;   targa_header.y_origin=0;$   targa_header.width=image->columns;"   targa_header.height=image->rows;   targa_header.pixel_size=8;   targa_header.attributes=0;   if (!IsPseudoClass(image))     {        /*          Full color TARGA raster.       */'       targa_header.image_type=TargaRGB; <       if (image->compression == RunlengthEncodedCompression),         targa_header.image_type=TargaRLERGB;5       targa_header.pixel_size=image->matte ? 32 : 24;      }    else     {        /*!         Colormapped TARGA raster.        */,       targa_header.image_type=TargaColormap;<       if (image->compression == RunlengthEncodedCompression)1         targa_header.image_type=TargaRLEColormap;%6       if (!IsGrayImage(image) || (image->colors != 2))	         { '           targa_header.colormap_type=1; (           targa_header.colormap_index=0;5           targa_header.colormap_length=image->colors;T(           targa_header.colormap_size=24;	         } 
       else	         {e           /*$             Monochrome TARGA raster.           */2           targa_header.image_type=TargaMonochrome;@           if (image->compression == RunlengthEncodedCompression)7             targa_header.image_type=TargaRLEMonochrome;s	         }      }    /*     Write TARGA header.t   */:   (void) fputc((char) targa_header.id_length,image->file);>   (void) fputc((char) targa_header.colormap_type,image->file);;   (void) fputc((char) targa_header.image_type,image->file);i>   LSBFirstWriteShort(targa_header.colormap_index,image->file);?   LSBFirstWriteShort(targa_header.colormap_length,image->file); >   (void) fputc((char) targa_header.colormap_size,image->file);8   LSBFirstWriteShort(targa_header.x_origin,image->file);8   LSBFirstWriteShort(targa_header.y_origin,image->file);5   LSBFirstWriteShort(targa_header.width,image->file);g6   LSBFirstWriteShort(targa_header.height,image->file);;   (void) fputc((char) targa_header.pixel_size,image->file);8;   (void) fputc((char) targa_header.attributes,image->file);L"   if (targa_header.id_length != 0)D     (void) fwrite((char *) image->comments,1,targa_header.id_length,       image->file);i   /*(     Convert MIFF to TARGA raster pixels.   */   count=(unsigned int)J     (targa_header.pixel_size*targa_header.width*targa_header.height) >> 3;8   if (image->compression == RunlengthEncodedCompression)     count+=(count/128)+1; E   targa_pixels=(unsigned char *) malloc(count*sizeof(unsigned char)); -   if (targa_pixels == (unsigned char *) NULL)      {)9       Warning("Unable to allocate memory",(char *) NULL);;       return(False);     }X%   p=image->pixels+(image->packets-1);    q=targa_pixels;f   if (!IsPseudoClass(image))     {;       /*6         Convert DirectClass packet to TARGA RGB pixel.       */<       if (image->compression != RunlengthEncodedCompression)*         for (i=0; i < image->packets; i++)	         {).           for (j=0; j <= (int) p->length; j++)           {r             *q++=p->blue;)             *q++=p->green;             *q++=p->red;             if (image->matte)r               *q++=p->index;           }s           p--;	         }r
       else*         for (i=0; i < image->packets; i++)	         {g            runlength=p->length+1;           if (runlength > 128)
             {f               *q++=0xff;               *q++=p->blue;                *q++=p->green;               *q++=p->red;               if (image->matte)g                 *q++=p->index;               runlength-=128;+
             }o           r=q;"           *q++=0x80+(runlength-1);           *q++=p->blue;            *q++=p->green;           *q++=p->red;           if (image->matte)              *q++=p->index;           if (runlength != 1)I             p--;           else
             {%.               for ( ; i < image->packets; i++)               {%                 p--;;                 if ((p->length != 0) || (runlength == 128))                    break;                 *q++=p->blue;                  *q++=p->green;                 *q++=p->red;!                 if (image->matte)                     *q++=p->index;                 runlength++;               }                *r=runlength-1; 
             } 	         }      }    else4     if (!IsGrayImage(image) || (image->colors != 2))       {          unsigned char            *targa_colormap;  
         /*>           Dump colormap to file (blue, green, red byte order).
         */(         targa_colormap=(unsigned char *)G           malloc(3*targa_header.colormap_length*sizeof(unsigned char));l5         if (targa_colormap == (unsigned char *) NULL)T           {t?             Warning("Unable to allocate memory",(char *) NULL);g             return(False);           }a         q=targa_colormap; )         for (i=0; i < image->colors; i++)n	         {e'           *q++=image->colormap[i].blue;n(           *q++=image->colormap[i].green;&           *q++=image->colormap[i].red;	         }a0         (void) fwrite((char *) targa_colormap,1,<           (int) 3*targa_header.colormap_length,image->file);&         free((char *) targa_colormap);
         /*@           Convert PseudoClass packet to TARGA colormapped pixel.
         */         q=targa_pixels;e>         if (image->compression != RunlengthEncodedCompression),           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)               *q++=p->index;             p--;           }l         else,           for (i=0; i < image->packets; i++)           {f"             runlength=p->length+1;              if (runlength > 128)               {*                 *q++=0xff;                 *q++=p->index;                 runlength-=128;.               }              r=q;$             *q++=0x80+(runlength-1);             *q++=p->index;             if (runlength != 1)                p--;             else               { 0                 for ( ; i < image->packets; i++)                 {a                   p--;=                   if ((p->length != 0) || (runlength == 128))                      break;                    *q++=p->index;                   runlength++;                 }x                 *r=runlength-1;                }s           }        }a     else       {C         unsigned int           polarity;   
         /*@           Convert PseudoClass image to a TARGA monochrome image.
         */         polarity=0;t         if (image->colors == 2)m           polarity= J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);>         if (image->compression != RunlengthEncodedCompression),           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)5               *q++=p->index == polarity ? 0 : MaxRGB;e             p--;           }          else,           for (i=0; i < image->packets; i++)           {e"             runlength=p->length+1;              if (runlength > 128)               {                  *q++=0xff;7                 *q++=p->index == polarity ? 0 : MaxRGB;-                 runlength-=128;a               }i             r=q;$             *q++=0x80+(runlength-1);3             *q++=p->index == polarity ? 0 : MaxRGB;/             if (runlength != 1)v               p--;             else               {i0                 for ( ; i < image->packets; i++)                 {;                   p--;=                   if ((p->length != 0) || (runlength == 128))                      break;9                   *q++=p->index == polarity ? 0 : MaxRGB;(                   runlength++;                 }v                 *r=runlength-1;[               }l           }        }_L   (void) fwrite((char *) targa_pixels,1,(int) (q-targa_pixels),image->file);   free((char *) targa_pixels);   CloseImage(image);   return(True);  }a > /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %-O %                                                                             %rO %                                                                             %eO %   W r i t e T E X T I m a g e                                               % O %                                                                             %vO %                                                                             % O %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function WriteTEXTImage writes an image in the TEXT image forma.  % / %  The format of the WriteTEXTImage routine is:  %i. %      status=WriteTEXTImage(image_info,image) %m+ %  A description of each parameter follows.  % K %    o status: Function WriteTEXTImage return True if the image is written.fK %      False is returned is there is a memory shortage or if the image file  %      fails to write. %fA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %) %  */4 static unsigned int WriteTEXTImage(image_info,image)	 ImageInfon   *image_info;   Image 	   *image;  {v   unsigned int     status;   6   Warning("Cannot write TEXT images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);> }e   #ifdef HasTIFF #ifndef va_start, #if defined(__STDC__) && !defined(NOSTDHDRS) #include <stdarg.h>f #elseh #include <varargs.h> #endif #endif #include "tiffio.h"0 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %aO %                                                                             %rO %                                                                             % O %   W r i t e T I F F I m a g e                                               %iO %                                                                             % O %                                                                             %rO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; %*K %  Function WriteTIFFImage writes an image in the Tagged image file format.( %s/ %  The format of the WriteTIFFImage routine is:l % . %      status=WriteTIFFImage(image_info,image) % + %  A description of each parameter follows:x %2L %    o status:  Function WriteTIFFImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.e % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %( %c */4 static unsigned int WriteTIFFImage(image_info,image)	 ImageInfoe   *image_info;   Imagee	   *image;i {e   Imageo     encode_image;a     register RunlengthPacket     *p;      register int     i,     j,     x,     y;     register unsigned char     *q;i     TIFF
     *tiff;     unsigned char      *scanline;     unsigned short     photometric,     rows_per_strip;c     /*     Open TIFF file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL);     { 5       Warning("Unable to open file",image->filename);g       return(False);     } .   if ((image->file != stdout) && !image->pipe)#     (void) unlink(image->filename);    else     {        /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);n       image->temporary=True;     }e   CloseImage(image);&   tiff=TIFFOpen(image->filename,"wb");   if (tiff == (TIFF *) NULL)     return(False);   /*     Initialize TIFF fields.    */:   TIFFSetField(tiff,TIFFTAG_DOCUMENTNAME,image->filename);4   TIFFSetField(tiff,TIFFTAG_SOFTWARE,"ImageMagick");'   if (image->comments != (char *) NULL) @     TIFFSetField(tiff,TIFFTAG_IMAGEDESCRIPTION,image->comments);   if (!IsPseudoClass(image))     {%       /*         Full color TIFF raster.        */"       photometric=PHOTOMETRIC_RGB;1       TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,8); H       TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,(image->matte ? 4 : 3));     }    else     {        /*          Colormapped TIFF raster.       */&       photometric=PHOTOMETRIC_PALETTE;3       TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,1); 1       TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,8);        if (IsGrayImage(image)) 	         {            /*"             Grayscale TIFF raster.           */-           photometric=PHOTOMETRIC_MINISBLACK; !           if (image->colors == 2)%7             TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,1);%	         }      }F5   TIFFSetField(tiff,TIFFTAG_PHOTOMETRIC,photometric);y5   TIFFSetField(tiff,TIFFTAG_IMAGELENGTH,image->rows);a7   TIFFSetField(tiff,TIFFTAG_IMAGEWIDTH,image->columns);r9   TIFFSetField(tiff,TIFFTAG_FILLORDER,FILLORDER_MSB2LSB);h=   TIFFSetField(tiff,TIFFTAG_ORIENTATION,ORIENTATION_TOPLEFT);e>   TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_CONTIG);9   TIFFSetField(tiff,TIFFTAG_RESOLUTIONUNIT,image->units); =   TIFFSetField(tiff,TIFFTAG_XRESOLUTION,image->x_resolution); =   TIFFSetField(tiff,TIFFTAG_YRESOLUTION,image->y_resolution);g9   TIFFSetField(tiff,TIFFTAG_COMPRESSION,COMPRESSION_LZW);e*   if (image->compression == NoCompression)<     TIFFSetField(tiff,TIFFTAG_COMPRESSION,COMPRESSION_NONE);-   rows_per_strip=8192/TIFFScanlineSize(tiff);i   if (rows_per_strip == 0)     rows_per_strip=1; 9   TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP,rows_per_strip);/<   scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff));)   if (scanline == (unsigned char *) NULL)i     {g7       Warning("Memory allocation error",(char *) NULL);o       return(False);     }u   p=image->pixels;
   q=scanline;=   x=0;   y=0;%   if (photometric == PHOTOMETRIC_RGB)w&     for (i=0; i < image->packets; i++)     {=*       for (j=0; j <= (int) p->length; j++)       {l
         /*B           Convert DirectClass packets to contiguous RGB scanlines.
         */         *q++=p->red;         *q++=p->green;         *q++=p->blue;j         if (image->matte) (           *q++=(unsigned char) p->index;         x++;          if (x == image->columns)           {cB             if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)               break;             q=scanline;              x=0;             y++;           }%       }%
       p++;     }%   else+     if (photometric == PHOTOMETRIC_PALETTE)        {          unsigned short           *blue,           *green,            *red;   
         /*!           Allocate TIFF colormap. 
         */M         blue=(unsigned short *) malloc(image->colors*sizeof(unsigned short)); N         green=(unsigned short *) malloc(image->colors*sizeof(unsigned short));L         red=(unsigned short *) malloc(image->colors*sizeof(unsigned short));0         if ((blue == (unsigned short *) NULL) ||1             (green == (unsigned short *) NULL) || -             (red == (unsigned short *) NULL))%           {%L             Warning("Unable to read TIFF image","Memory allocation failed");             return(False);           }l
         /*#           Initialize TIFF colormap.o
         */)         for (i=0; i < image->colors; i++) 	         {n!           red[i]=(unsigned short) C             ((image->colormap[i].red*65535)/(unsigned int) MaxRGB);l#           green[i]=(unsigned short).E             ((image->colormap[i].green*65535)/(unsigned int) MaxRGB); "           blue[i]=(unsigned short)D             ((image->colormap[i].blue*65535)/(unsigned int) MaxRGB);	         } ;         TIFFSetField(tiff,TIFFTAG_COLORMAP,red,green,blue);o
         /*O           Convert PseudoClass packets to contiguous colormap indexed scanlines.H
         */*         for (i=0; i < image->packets; i++)	         {m.           for (j=0; j <= (int) p->length; j++)           {g*             *q++=(unsigned char) p->index;             x++;$             if (x == image->columns)               { F                 if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                   break;                 q=scanline;                  x=0;                 y++;               }O           }g           p++;	         }          free((char *) red);i         free((char *) green);n         free((char *) blue);       }e     else       if (image->colors > 2)*         for (i=0; i < image->packets; i++)	         {e.           for (j=0; j <= (int) p->length; j++)           {d             /*L               Convert PseudoClass packets to contiguous grayscale scanlines.             */?             *q++=(unsigned char) image->colormap[p->index].red;              x++;$             if (x == image->columns)               {gF                 if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                   break;                 q=scanline;                  x=0;                 y++;               }c           }v           p++;	         }a
       else	         {s            register unsigned char             bit,             byte,              polarity;m             /*K             Convert PseudoClass packets to contiguous monochrome scanlines.>           */           polarity=0;s!           if (image->colors == 2)>             polarity=mL               Intensity(image->colormap[0]) < Intensity(image->colormap[1]);           bit=0;           byte=0;m           x=0;,           for (i=0; i < image->packets; i++)           {a0             for (j=0; j <= (int) p->length; j++)
             {i               byte<<=1;e'               if (p->index == polarity)c                 byte|=0x01;t               bit++;               if (bit == 8)                  {l                   *q++=byte;                   bit=0;                   byte=0;>                 })               x++;&               if (x == image->columns)                 {(                   /*1                     Advance to the next scanline.f                   */                   if (bit != 0) )                     *q++=byte << (8-bit);eH                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;;                   bit=0;                   byte=0;c                   x=0;                   y++;                }
             }t             p++;           }l	         }    free((char *) scanline);   (void) TIFFFlushData(tiff);g"   if (image_info->verbose == True)*     TIFFPrintDirectory(tiff,stderr,False);   (void) TIFFClose(tiff);    if (image->temporary)      {a
       FILE         *file;  	       int 
         c;         /*7         Copy temporary file to standard output or pipe.m       */'       file=fopen(image->filename,"rb");x        if (file == (FILE *) NULL)	         {e9           Warning("Unable to read file",image->filename);t           return(False);	         }i       c=fgetc(file);       while (c != EOF)       {-)         (void) putc(c,encode_image.file);-         c=fgetc(file);       }-       (void) fclose(file);%       (void) unlink(image->filename);o        CloseImage(&encode_image);     }_   return(True);  }( #else<4 static unsigned int WriteTIFFImage(image_info,image)	 ImageInfow   *image_info;   Image 	   *image;j {h   unsigned int     status;   ;   Warning("TIFF library is not available",image->filename);i*   status=WriteMIFFImage(image_info,image);   return(status);u }- #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             %eO %                                                                             %uO %                                                                             %hO %   W r i t e V I C A R I m a g e                                             %oO %                                                                             %-O %                                                                             % O %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%[ %TK %  Function WriteVICARImage writes an image in the VICAR rasterfile format.  % 0 %  The format of the WriteVICARImage routine is: % / %      status=WriteVICARImage(image_info,image)s %i+ %  A description of each parameter follows.n %)L %    o status: Function WriteVICARImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image fileF %      fails to write. %iA %    o image_info: Specifies a pointer to an ImageInfo structure.  %*. %    o image:  A pointer to a Image structure. %% %% */5 static unsigned int WriteVICARImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   7   Warning("Cannot write VICAR images",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   W r i t e V I F F I m a g e                                               % O %                                                                             % O %                                                                             %iO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eN %  Function WriteVIFFImage writes an image to a file in the VIFF image format. % / %  The format of the WriteVIFFImage routine is:I %e. %      status=WriteVIFFImage(image_info,image) % + %  A description of each parameter follows.I %cK %    o status: Function WriteVIFFImage return True if the image is written.nK %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %h. %    o image:  A pointer to a Image structure. %  %h */4 static unsigned int WriteVIFFImage(image_info,image)	 ImageInfo+   *image_info;   Imagen	   *image;  {2 #define VFF_CM_genericRGB  15  #define VFF_CM_NONE  0 #define VFF_DEP_IEEEORDER  0x2 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1  #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1*     typedef struct _ViffHeader   {a     char       identifier,        file_type,       release,       version,       machine_dependency,        reserve[3],g       comment[512];r       unsigned long        rows,e       columns,       subrows;       long       x_offset,a       y_offset;m       unsigned int       x_pixel_size,a       y_pixel_size;t       unsigned long        location_type,       location_dimension,d       number_of_images,        number_data_bands,       data_storage_type,       data_encode_scheme,        map_scheme,e       map_storage_type,        map_rows,a       map_columns,       map_subrows,       map_enable,l       maps_per_cycle,r       color_space_model;   } ViffHeader;e     register int     i,     j;     register RunlengthPacket     *p;h     register unsigned char     *q;e     unsigned char      buffer[8],     *viff_pixels;      unsigned long      packets;     ViffHeader     viff_header;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)-     {m5       Warning("Unable to open file",image->filename);e       return(False);     }    /*$     Initialize VIFF image structure.   */   viff_header.identifier=0xab;   viff_header.file_type=1;   viff_header.release=1;   viff_header.version=3;M   viff_header.machine_dependency=VFF_DEP_IEEEORDER;  /* IEEE byte ordering */r   *viff_header.comment='\0';'   if (image->comments != (char *) NULL)      {a9       (void) strncpy(viff_header.comment,image->comments,e0         Min((int) strlen(image->comments),511));G       viff_header.comment[Min((int) strlen(image->comments),511)]='\0';.     }_"   viff_header.rows=image->columns;"   viff_header.columns=image->rows;   viff_header.subrows=0;   viff_header.x_offset=(~0);   viff_header.y_offset=(~0);   viff_header.x_pixel_size=0;_   viff_header.y_pixel_size=0;v-   viff_header.location_type=VFF_LOC_IMPLICIT; #   viff_header.location_dimension=0;x!   viff_header.number_of_images=1;o-   viff_header.data_encode_scheme=VFF_DES_RAW;r%   viff_header.map_scheme=VFF_MS_NONE;>/   viff_header.map_storage_type=VFF_MAPTYP_NONE;g   viff_header.map_rows=0;S   viff_header.map_columns=0;   viff_header.map_subrows=0;.   viff_header.map_enable=1;  /* no colormap */   viff_header.maps_per_cycle=0;a   if (!IsPseudoClass(image))     {r       /*         Full color VIFF raster.r       */9       viff_header.number_data_bands=image->matte ? 4 : 3;l6       viff_header.color_space_model=VFF_CM_genericRGB;3       viff_header.data_storage_type=VFF_TYP_1_BYTE;(G       packets=image->columns*image->rows*viff_header.number_data_bands;,     }f   else     { &       viff_header.number_data_bands=1;0       viff_header.color_space_model=VFF_CM_NONE;3       viff_header.data_storage_type=VFF_TYP_1_BYTE; )       packets=image->columns*image->rows;a       if (!IsGrayImage(image))	         {c           /*$             Colormapped VIFF raster.           */3           viff_header.map_scheme=VFF_MS_ONEPERBAND;q9           viff_header.map_storage_type=VFF_MAPTYP_1_BYTE;+!           viff_header.map_rows=3; 0           viff_header.map_columns=image->colors;	         }a
       else         if (image->colors == 2)            {              /*%               Monochrome VIFF raster.i             */6             viff_header.data_storage_type=VFF_TYP_BIT;:             packets=((image->columns+7) >> 3)*image->rows;           }n     }n   /*0     Write VIFF image header (pad to 1024 bytes).   */#   buffer[0]=viff_header.identifier;u"   buffer[1]=viff_header.file_type;    buffer[2]=viff_header.release;    buffer[3]=viff_header.version;+   buffer[4]=viff_header.machine_dependency; #   buffer[5]=viff_header.reserve[0];+#   buffer[6]=viff_header.reserve[1];;#   buffer[7]=viff_header.reserve[2];a1   (void) fwrite((char *) buffer,1,8,image->file); @   (void) fwrite((char *) viff_header.comment,1,512,image->file);2   MSBFirstWriteLong(viff_header.rows,image->file);5   MSBFirstWriteLong(viff_header.columns,image->file);_5   MSBFirstWriteLong(viff_header.subrows,image->file); F   MSBFirstWriteLong((unsigned long) viff_header.x_offset,image->file);F   MSBFirstWriteLong((unsigned long) viff_header.y_offset,image->file);J   MSBFirstWriteLong((unsigned long) viff_header.x_pixel_size,image->file);J   MSBFirstWriteLong((unsigned long) viff_header.y_pixel_size,image->file);;   MSBFirstWriteLong(viff_header.location_type,image->file);.@   MSBFirstWriteLong(viff_header.location_dimension,image->file);>   MSBFirstWriteLong(viff_header.number_of_images,image->file);?   MSBFirstWriteLong(viff_header.number_data_bands,image->file); ?   MSBFirstWriteLong(viff_header.data_storage_type,image->file);)@   MSBFirstWriteLong(viff_header.data_encode_scheme,image->file);8   MSBFirstWriteLong(viff_header.map_scheme,image->file);>   MSBFirstWriteLong(viff_header.map_storage_type,image->file);6   MSBFirstWriteLong(viff_header.map_rows,image->file);9   MSBFirstWriteLong(viff_header.map_columns,image->file);r9   MSBFirstWriteLong(viff_header.map_subrows,image->file); 8   MSBFirstWriteLong(viff_header.map_enable,image->file);<   MSBFirstWriteLong(viff_header.maps_per_cycle,image->file);?   MSBFirstWriteLong(viff_header.color_space_model,image->file);o   for (i=0; i < 420; i++)l#     (void) fputc('\0',image->file);    /*'     Convert MIFF to VIFF raster pixels.[   */F   viff_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char));,   if (viff_pixels == (unsigned char *) NULL)     { 9       Warning("Unable to allocate memory",(char *) NULL);r       return(False);     }    p=image->pixels;   q=viff_pixels;   if (!IsPseudoClass(image))     {i       unsigned longh         offset;)         /*5         Convert DirectClass packet to VIFF RGB pixel.0       */(       offset=image->columns*image->rows;(       for (i=0; i < image->packets; i++)       {i,         for (j=0; j <= (int) p->length; j++)	         {u           *q=p->red;           *(q+offset)=p->green;r            *(q+offset*2)=p->blue;           if (image->matte) 3             *(q+offset*3)=(unsigned char) p->index;s           q++;	         }u         p++;       }s     }i   else     if (!IsGrayImage(image))       {t         unsigned char*           *viff_colormap;%  
         /*            Dump colormap to file.
         */'         viff_colormap=(unsigned char *) 8           malloc(image->colors*3*sizeof(unsigned char));4         if (viff_colormap == (unsigned char *) NULL)           { ?             Warning("Unable to allocate memory",(char *) NULL);              return(False);           }          q=viff_colormap;)         for (i=0; i < image->colors; i++) &           *q++=image->colormap[i].red;)         for (i=0; i < image->colors; i++) (           *q++=image->colormap[i].green;)         for (i=0; i < image->colors; i++) '           *q++=image->colormap[i].blue; E         (void) fwrite((char *) viff_colormap,1,(int) image->colors*3,%           image->file); %         free((char *) viff_colormap);G
         /*@           Convert PseudoClass packet to VIFF colormapped pixels.
         */         q=viff_pixels;*         for (i=0; i < image->packets; i++)	         {i.           for (j=0; j <= (int) p->length; j++)             *q++=p->index;           p++;	         }a       }t     else       if (image->colors == 2)n	         {m            register unsigned char             bit,             byte,h             polarity;t             register int             x;             /*A             Convert PseudoClass image to a VIFF monochrome image.s           */           polarity= J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);           x=0;           bit=0;           byte=0;e,           for (i=0; i < image->packets; i++)           {t0             for (j=0; j <= (int) p->length; j++)
             {;               byte>>=1;e'               if (p->index == polarity)                  byte|=0x80;e               bit++;               if (bit == 8)>                 {n                   *q++=byte;                   bit=0;                   byte=0;                  }e               x++;&               if (x == image->columns)                 {                    /*1                     Advance to the next scanline.                    */                   if (bit != 0) )                     *q++=byte >> (8-bit);t                   bit=0;                   byte=0;                    x=0;                }
             }_             p++;           };	         }t
       else	         {p           /*?             Convert PseudoClass packet to VIFF grayscale pixel.f           */,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)               *q++=p->red;             p++;           }t	         } B   (void) fwrite((char *) viff_pixels,1,(int) packets,image->file);   free((char *) viff_pixels);t   CloseImage(image);   return(True);i })   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             %.O %                                                                             %pO %   W r i t e X I m a g e                                                     %rO %                                                                             %.O %                                                                             %mO %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c %e7 %  Function WriteXImage writes an image to an X server.m %t, %  The format of the WriteXImage routine is: %s+ %      status=WriteXImage(image_info,image)_ %p+ %  A description of each parameter follows.x %=L %    o status: Function WriteXImage return True if the image is displayed onK %      the X server.  False is returned is there is a memory shortage or if(% %      the image file fails to write.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %g %x */1 static unsigned int WriteXImage(image_info,image) 	 ImageInfoi   *image_info;   Image_	   *image;  {    Atom     wm_delete_window,s     wm_protocols;      char     name[MaxTextLength];  	   Display 
     *display;(     register char(     *p;;     unsigned int     status;      XGCValues      context_values;-     XResourceInfo      resource_info;  
   XrmDatabase)     resource_database;     XEvent
     event;     XPixelInfo     pixel_info;      XStandardColormap-     *map_info;  
   XVisualInfo(     *visual_info;<  
   XWindowInfo      window_info;     /*     Open X server connection.g   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return(False);     }0   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);+   /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.+   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)0M     Warning("Unable to create standard colormap","Memory allocation failed");e   else     {-       /*         Initialize visual info.        */C       visual_info=XBestVisualInfo(display,map_info,&resource_info);g.       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;g/       pixel_info.pixels=(unsigned long *) NULL;      }n   /*     Initialize atoms.n   */1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {aF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }    /*!     Initialize Standard Colormap.    */J   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info);    /*%     Initialize window info structure.    */   window_info.id=(Window) NULL; O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info);    window_info.name=name;.   p=image->filename+strlen(image->filename)-1;A   while ((p > image->filename) && (*(p-1) != *BasenameSeparator))%     p--;H   (void) sprintf(window_info.name,"ImageMagick: %s[%u]",p,image->scene);   if (image->scene == 0)9     (void) sprintf(window_info.name,"ImageMagick: %s",p);e#   window_info.width=image->columns; !   window_info.height=image->rows;aC   window_info.attributes.event_mask=ButtonPressMask | ExposureMask; P   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);   window_info.x=0;   window_info.y=0;"   window_info.shared_memory=False;   /*     Graphic context.   */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL)m<     Error("Unable to create graphic context",(char *) NULL);;   window_info.annotate_context=pixel_info.annotate_context;%>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;N   pixel_info.highlight_context=XCreateGC(display,window_info.id,GCBackground |"     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);=   window_info.highlight_context=pixel_info.highlight_context; &   pixel_info.widget_context=(GC) NULL;'   window_info.widget_context=(GC) NULL;    /*     Initialize X image.    */M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,%     image->rows);%   if (status == False)     {F6       Warning("Unable to make X image",(char *) NULL);>       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);       return(False);     }g   free((char *) image->pixels);s)   image->pixels=(RunlengthPacket *) NULL; :   (void) XMakePixmap(display,&resource_info,&window_info);!   free(window_info.ximage->data);n)   window_info.ximage->data=(char *) NULL;i   /*4     Display image and wait for button press to exit.   */9   wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False); A   wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);r%   XMapWindow(display,window_info.id);f
   for ( ; ; )f   {      XNextEvent(display,&event);r"     if (event.type == ButtonPress)       break;$     if (event.type == ClientMessage)5       if (event.xclient.message_type == wm_protocols)(6         if (*event.xclient.data.l == wm_delete_window)5           if (event.xclient.window == window_info.id))             break;     if (event.type == Expose)e2       XRefreshWindow(display,&window_info,&event);   } =   XWithdrawWindow(display,window_info.id,window_info.screen);    /*     Free X resources.,   */O   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info);(   return(True);i }f s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             % O %                                                                             %lO %                                                                             %rO %   W r i t e X B M I m a g e                                                 %,O %                                                                             % O %                                                                             %eO %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %eL %  Procedure WriteXBMImage writes an image to a file in the X bitmap format. % . %  The format of the WriteXBMImage routine is: %%- %      status=WriteXBMImage(image_info,image)% %%+ %  A description of each parameter follows.  % J %    o status: Function WriteXBMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteXBMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    char     name[MaxTextLength];     register int     i,     j,     x;     register char      *q;      register RunlengthPacket     *p;%     register unsigned char     bit,	     byte, 
     polarity;t     unsigned int
     count;     /*     Open output image file.t   */   OpenImage(image,"w");e#   if (image->file == (FILE *) NULL)e     { 5       Warning("Unable to open file",image->filename);r       return(False);     }e   /*     Write X bitmap header.   */&   (void) strcpy(name,image->filename);	   q=name;E%   while ((*q != '.') && (*q != '\0'))e     q++;   if (*q == '.')     *q='\0';J   (void) fprintf(image->file,"#define %s_width %u\n",name,image->columns);H   (void) fprintf(image->file,"#define %s_height %u\n",name,image->rows);A   (void) fprintf(image->file,"static char %s_bits[] = {\n",name);n"   (void) fprintf(image->file," ");   /*$     Convert MIFF to X bitmap pixels.   */=   QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);k   SyncImage(image);i
   polarity=0;h   if (image->colors == 2)cK     polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);e   bit=0;	   byte=0;e
   count=0;   x=0;   p=image->pixels;"   (void) fprintf(image->file," ");$   for (i=0; i < image->packets; i++)   {,*     for (j=0; j <= ((int) p->length); j++)     {        byte>>=1;U       if (p->index == polarity)m         byte|=0x80;l       bit++;       if (bit == 8)t	         {            /*2             Write a bitmap byte to the image file.           */=           (void) fprintf(image->file,"0x%02x, ",byte & 0xff);            count++;           if (count == 12)
             { 1               (void) fprintf(image->file,"\n  ");-               count=0;             };           bit=0;           byte=0; 	         } 
       x++;       if (x == image->columns)	         {p           if (bit != 0) 
             {(               /*6                 Write a bitmap byte to the image file.               */               byte>>=(8-bit);aA               (void) fprintf(image->file,"0x%02x, ",byte & 0xff);%               count++;               if (count == 12)                 { 5                   (void) fprintf(image->file,"\n  ");                    count=0;                 };               bit=0;               byte=0;              };           x=0;	         }      }      p++;   } %   (void) fprintf(image->file,"};\n");    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %                                                                             % O %   W r i t e X C I m a g e                                                   %eO %                                                                             % O %                                                                             %tO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eH %  Function WriteXCImage writes an image in the X constant image format. %o- %  The format of the WriteXCImage routine is:c %s, %      status=WriteXCImage(image_info,image) %I+ %  A description of each parameter follows.  % I %    o status: Function WriteXCImage return True if the image is written.sK %      False is returned is there is a memory shortage or if the image fileU %      fails to write. %oA %    o image_info: Specifies a pointer to an ImageInfo structure.p %s. %    o image:  A pointer to a Image structure. %e %o */2 static unsigned int WriteXCImage(image_info,image)	 ImageInfoN   *image_info;   Image 	   *image;( {a   unsigned int     status;i  4   Warning("Cannot write XC images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }f m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %*O %                                                                             % O %                                                                             %eO %   W r i t e X P M I m a g e                                                 %oO %                                                                             %*O %                                                                             %lO %                                                                             %zO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Procedure WriteXPMImage writes an image to a file in the X pixmap format. % . %  The format of the WriteXPMImage routine is: %d- %      status=WriteXPMImage(image_info,image)  % + %  A description of each parameter follows.m %-J %    o status: Function WriteXPMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filec %      fails to write. %oA %    o image_info: Specifies a pointer to an ImageInfo structure.  %(. %    o image:  A pointer to a Image structure. %n %i */
 #ifdef HasXPM} #include "xpm.h"3 static unsigned int WriteXPMImage(image_info,image))	 ImageInfom   *image_info;   Image)	   *image;) {r   char     *resource_value,     *xpm_buffer;  	   Displayn
     *display;-     intm     status;e     register char(     *p;t     XResourceInfof     resource_info;  
   XrmDatabase      resource_database;     XImage     *matte_image;>     XPixelInfo     pixel_info;f     XpmAttributesn     xpm_attributes;o     XStandardColormapf     *map_info;  
   XVisualInfou     *visual_info;k  
   XWindowInfo      window_info;     /*     Open output image file.c   */   OpenImage(image,"w");f#   if (image->file == (FILE *) NULL)d     {k5       Warning("Unable to open file",image->filename);u       return(False);     }u   /*     Open X server connection.-   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {c.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));a       return(False);     }m   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);r   /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);=)   resource_info.colormap=PrivateColormap;g   /*     Allocate standard colormap.d   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)pM     Warning("Unable to create standard colormap","Memory allocation failed");o   else     {g       /*         Initialize visual info.a       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info);l.       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;./       pixel_info.pixels=(unsigned long *) NULL;      } 1   if ((map_info == (XStandardColormap *) NULL) ||/,       (visual_info == (XVisualInfo *) NULL))     {-F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }k   matte_image=(XImage *) NULL;   if (image->matte)e     {        /*         Create X shape image.L       */H       matte_image=XCreateImage(display,visual_info->visual,1,XYBitmap,0,H         (char *) NULL,image->columns,image->rows,XBitmapPad(display),0);)       if (matte_image == (XImage *) NULL) >         Warning("Unable to create matte image",(char *) NULL);
       else	         {            /*(             Allocate X shape image data.           */$           matte_image->data=(char *)D             malloc(matte_image->bytes_per_line*matte_image->height);1           if (matte_image->data == (char *) NULL) O             Warning("Unable to create matte image","Memory allocation failed");            else
             {                int                  x,                 y;                 register int                 i,                 j;  &               register RunlengthPacket                 *p;i                 /*)                 Initialize X shape image.a               */               x=0;               y=0;               p=image->pixels;0               for (i=0; i < image->packets; i++)               {:4                 for (j=0; j <= (int) p->length; j++)                 {lM                   XPutPixel(matte_image,x,y,p->index == Transparent ? 0 : 1);s                   x++;*                   if (x == image->columns)                     {                        x=0;                       y++;                     }t                 }f                 p++;               } 
             }e	         }n     }i   /*!     Initialize Standard Colormap.t   */=   if ((image->class == DirectClass) || (image->colors > 256))i     {        /**         Demote DirectClass to PseudoClass.       */B       QuantizeImage(image,256,8,image_info->dither,RGBColorspace);       SyncImage(image);      } J   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info); (   pixel_info.annotate_context=(GC) NULL;)   pixel_info.highlight_context=(GC) NULL; &   pixel_info.widget_context=(GC) NULL;   /*%     Initialize window info structure.    */   window_info.id=(Window) NULL; O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info); .   p=image->filename+strlen(image->filename)-1;2   while ((p > image->filename) && (*(p-1) != '/'))     p--;   window_info.name=p;%#   window_info.width=image->columns;%!   window_info.height=image->rows; P   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);"   window_info.shared_memory=False;   /*     Initialize X image.    */M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,e     image->rows);    if (status == False)     {r6       Warning("Unable to make X image",(char *) NULL);>       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);       return(False);     }t   /*     Intialize XPM attributes.n   */H   xpm_attributes.valuemask=XpmColormap | XpmDepth | XpmSize | XpmVisual;,   xpm_attributes.visual=visual_info->visual;*   xpm_attributes.depth=visual_info->depth;-   xpm_attributes.colormap=map_info->colormap; &   xpm_attributes.width=image->columns;$   xpm_attributes.height=image->rows;I   status=XpmCreateBufferFromImage(display,&xpm_buffer,window_info.ximage,-!     matte_image,&xpm_attributes);    /*     Free X resources.F   */%   if (matte_image != (XImage *) NULL)n     XDestroyImage(matte_image);e%   XpmFreeAttributes(&xpm_attributes);hO   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,l!     &resource_info,&window_info);)   if (status != XpmSuccess)      {=5       Warning("Unable to write image",(char *) NULL);-       return(False);     }    /*     Write XPM image.   */'   status=fputs(xpm_buffer,image->file);p   free((char *) xpm_buffer);   CloseImage(image);   return(status != EOF); }i #else%3 static unsigned int WriteXPMImage(image_info,image)c	 ImageInfop   *image_info;   Imageu	   *image;r {)   unsigned int     status;e  :   Warning("XPM library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);% }% #endif % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e Y U V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %gF %  Function WriteYUVImage writes an image to a file in the digital YUV %  (CCIR 601 4:1:1) format.m %_. %  The format of the WriteYUVImage routine is: %r- %      status=WriteYUVImage(image_info,image)D %g+ %  A description of each parameter follows.  %lJ %    o status: Function WriteYUVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filer %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.r %P. %    o image:  A pointer to a Image structure. %f %  */3 static unsigned int WriteYUVImage(image_info,image) 	 ImageInfoC   *image_info;   Imagem	   *image;m {    Images     *reduced_image;_     register int     i;     register RunlengthPacket     *p;%     register unsigned char     *q;%     unsigned char%     *yuv_pixels;     if (!UncompressImage(image))     return(False);   /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Initialize Y channel.    */   yuv_pixels=(unsigned char *)E     malloc((3*(image->columns*image->rows)/2)*sizeof(unsigned char)); +   if (yuv_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     } +   RGBTransformImage(image,YCbCrColorspace);%   p=image->pixels;   q=yuv_pixels;%2   for (i=0; i < (image->rows*image->columns); i++)   {m     *q=p->red;     p++;     q++;   }    /*     Scale image.   */   image->orphan=True;u#   reduced_image=ReduceImage(image);m   image->orphan=False;&   if (reduced_image == (Image *) NULL)     { 7       Warning("Unable to scale image",image->filename);f       return(False);     }    /*     Initialize U channel.m   */   p=reduced_image->pixels;B   for (i=0; i < (reduced_image->rows*reduced_image->columns); i++)   {      *q=p->green;     p++;     q++;   }    /*     Initialize V channel.    */   p=reduced_image->pixels;B   for (i=0; i < (reduced_image->rows*reduced_image->columns); i++)   {i     *q=p->blue;e     p++;     q++;   } O   (void) fwrite((char *) yuv_pixels,1,(int) (3*(image->columns*image->rows)/2),      image->file);    free((char *) yuv_pixels);   DestroyImage(reduced_image);+   TransformRGBImage(image,YCbCrColorspace);    return(True);t };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             %,O %                                                                             %hO %   W r i t e Y U V 3 I m a g e                                               % O %                                                                             %nO %                                                                             %UO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %-G %  Function WriteYUV3Image writes an image to a file in the digital YUVlM %  (CCIR 601 4:1:1) format.  This function differs from WriteYUVImage in thateK %  it write the Y, U, and V planes to separate files (image.Y, image.U, ande %  image.V). % / %  The format of the WriteYUV3Image routine is:i %=. %      status=WriteYUV3Image(image_info,image) %)+ %  A description of each parameter follows.e %rK %    o status: Function WriteYUV3Image return True if the image is written.eK %      False is returned is there is a memory shortage or if the image file; %      fails to write. %oA %    o image_info: Specifies a pointer to an ImageInfo structure.= % . %    o image:  A pointer to a Image structure. %d %b */4 static unsigned int WriteYUV3Image(image_info,image)	 ImageInfor   *image_info;   Image*	   *image;  {    char     filename[MaxTextLength];     Imagei     *reduced_image;;     register int     i;     register RunlengthPacket     *p;)     register unsigned char     *q;e     unsigned charf     *yuv_pixels;     if (!UncompressImage(image))     return(False);   /*     Open output image file.g   */*   (void) strcpy(filename,image->filename);'   if (strcmp(image->filename,"-") != 0)t(     (void) strcat(image->filename,".Y");   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)o     {-5       Warning("Unable to open file",image->filename);r       return(False);     }    /*     Write Y channel.   */   yuv_pixels=(unsigned char *)=     malloc(image->columns*image->rows*sizeof(unsigned char));.+   if (yuv_pixels == (unsigned char *) NULL)o     {*9       Warning("Unable to allocate memory",(char *) NULL);h       return(False);     }a+   RGBTransformImage(image,YCbCrColorspace);L   p=image->pixels;   q=yuv_pixels; 2   for (i=0; i < (image->rows*image->columns); i++)   {      *q=p->red;     p++;     q++;   } I   (void) fwrite((char *) yuv_pixels,1,(int) (image->columns*image->rows),      image->file);    CloseImage(image);   /*     Scale image.   */   image->orphan=True;1#   reduced_image=ReduceImage(image);h   image->orphan=False;&   if (reduced_image == (Image *) NULL)     {_7       Warning("Unable to scale image",image->filename);t       return(False);     }l   /*     Write U channel.   */2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0)l0     (void) strcat(reduced_image->filename,".U");    OpenImage(reduced_image,"wb");+   if (reduced_image->file == (FILE *) NULL)e     {u=       Warning("Unable to open file",reduced_image->filename);t"       DestroyImage(reduced_image);       return(False);     }    p=reduced_image->pixels;   q=yuv_pixels; B   for (i=0; i < (reduced_image->rows*reduced_image->columns); i++)   {+     *q=p->green;     p++;     q++;   }e+   (void) fwrite((char *) yuv_pixels,1,(int) F     (reduced_image->columns*reduced_image->rows),reduced_image->file);   CloseImage(reduced_image);   /*     Write V channel.   */2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0) 0     (void) strcat(reduced_image->filename,".V");    OpenImage(reduced_image,"wb");+   if (reduced_image->file == (FILE *) NULL)      {/=       Warning("Unable to open file",reduced_image->filename);o"       DestroyImage(reduced_image);       return(False);     }1   p=reduced_image->pixels;   q=yuv_pixels; B   for (i=0; i < (reduced_image->rows*reduced_image->columns); i++)   {>     *q=p->blue;      p++;     q++;   }1+   (void) fwrite((char *) yuv_pixels,1,(int) F     (reduced_image->columns*reduced_image->rows),reduced_image->file);   CloseImage(reduced_image);   DestroyImage(reduced_image);   free((char *) yuv_pixels);+   TransformRGBImage(image,YCbCrColorspace);e+   (void) sprintf(image->filename,filename);    return(True);d }c o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %eO %                                                                             %-O %   W r i t e X W D I m a g e                                                 %iO %                                                                             %xO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function WriteXWDImage writes an image to a file in X window dump %  rasterfile format.  % . %  The format of the WriteXWDImage routine is: % - %      status=WriteXWDImage(image_info,image)  %(+ %  A description of each parameter follows.  % J %    o status: Function WriteXWDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filec %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %v. %    o image:  A pointer to a Image structure. %) %  */3 static unsigned int WriteXWDImage(image_info,image)_	 ImageInfo    *image_info;   Imagee	   *image;  {    int*     x;     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *xwd_pixels;     unsigned int     bits_per_pixel,      bytes_per_line,      scanline_pad;      unsigned long      lsb_first,     packets;     XWDFileHeader      xwd_header;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Initialize XWD file header.    */@   xwd_header.header_size=sz_XWDheader+strlen(image->filename)+1;;   xwd_header.file_version=(unsigned long) XWD_FILE_VERSION;%3   xwd_header.pixmap_format=(unsigned long) ZPixmap;r)   xwd_header.pixmap_depth=(unsigned long)h+     (image->class == DirectClass ? 24 : 8);o9   xwd_header.pixmap_width=(unsigned long) image->columns; 7   xwd_header.pixmap_height=(unsigned long) image->rows; '   xwd_header.xoffset=(unsigned long) 0;s1   xwd_header.byte_order=(unsigned long) MSBFirst;rP   xwd_header.bitmap_unit=(unsigned long) (image->class == DirectClass ? 32 : 8);7   xwd_header.bitmap_bit_order=(unsigned long) MSBFirst; O   xwd_header.bitmap_pad=(unsigned long) (image->class == DirectClass ? 32 : 8);a8   bits_per_pixel=(image->class == DirectClass ? 24 : 8);;   xwd_header.bits_per_pixel=(unsigned long) bits_per_pixel;i?   bytes_per_line=(unsigned long) ((((xwd_header.bits_per_pixel*f:     xwd_header.pixmap_width)+((xwd_header.bitmap_pad)-1))/=     (xwd_header.bitmap_pad))*((xwd_header.bitmap_pad) >> 3));d;   xwd_header.bytes_per_line=(unsigned long) bytes_per_line;n)   xwd_header.visual_class=(unsigned long)I>     (image->class == DirectClass ? DirectColor : PseudoColor);%   xwd_header.red_mask=(unsigned long)T1     (image->class == DirectClass ? 0xff0000 : 0); '   xwd_header.green_mask=(unsigned long) /     (image->class == DirectClass ? 0xff00 : 0);sP   xwd_header.blue_mask=(unsigned long) (image->class == DirectClass ? 0xff : 0);)   xwd_header.bits_per_rgb=(unsigned long)o+     (image->class == DirectClass ? 24 : 8);d-   xwd_header.colormap_entries=(unsigned long) 8     (image->class == DirectClass ? 256 : image->colors);G   xwd_header.ncolors=(image->class == DirectClass ? 0 : image->colors);i9   xwd_header.window_width=(unsigned long) image->columns; 7   xwd_header.window_height=(unsigned long) image->rows;_   xwd_header.window_x=0;   xwd_header.window_y=0;/   xwd_header.window_bdrwidth=(unsigned long) 0;    /*     Write XWD header.t   */   lsb_first=1;   if (*(char *) &lsb_first) ?     MSBFirstOrderLong((char *) &xwd_header,sizeof(xwd_header));iA   (void) fwrite((char *) &xwd_header,sz_XWDheader,1,image->file); E   (void) fwrite((char *) image->filename,1,strlen(image->filename)+1,      image->file);t"   if (image->class == PseudoClass)     {w       XColor         *colors;         XWDColor         color;         /*         Dump colormap to file.       */=       colors=(XColor *) malloc(image->colors*sizeof(XColor));_$       if (colors == (XColor *) NULL)	         {t=           Warning("Unable to allocate memory",(char *) NULL);o           return(False);	         })'       for (i=0; i < image->colors; i++)        {c         colors[i].pixel=i;2         colors[i].red=image->colormap[i].red << 8;6         colors[i].green=image->colormap[i].green << 8;4         colors[i].blue=image->colormap[i].blue << 8;1         colors[i].flags=DoRed | DoGreen | DoBlue;          colors[i].pad=0;!         if (*(char *) &lsb_first)            {aF             MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(long));H             MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(short));           }=       }e'       for (i=0; i < image->colors; i++)c       {t$         color.pixel=colors[i].pixel;          color.red=colors[i].red;$         color.green=colors[i].green;"         color.blue=colors[i].blue;$         color.flags=colors[i].flags;A         (void) fwrite((char *) &color,sz_XWDColor,1,image->file);p       }r       free((char *) colors);     }    /*&     Convert MIFF to XWD raster pixels.   */%   packets=bytes_per_line*image->rows;i   xwd_pixels=(unsigned char *)9     malloc((unsigned int) packets*sizeof(unsigned char));b+   if (xwd_pixels == (unsigned char *) NULL)y     {g9       Warning("Unable to allocate memory",(char *) NULL);0       return(False);     }u   scanline_pad=(unsigned int) <     (bytes_per_line-((image->columns*bits_per_pixel) >> 3));   x=0;   p=image->pixels;   q=xwd_pixels;)$   for (i=0; i < image->packets; i++)   {r*     for (j=0; j <= ((int) p->length); j++)     {g&       if (image->class == PseudoClass)         *q++=p->index;
       else	         {            *q++=p->red;           *q++=p->green;           *q++=p->blue;=	         }s
       x++;       if (x == image->columns)	         {z           q+=scanline_pad;           x=0;	         }0     }i     p++;   }+   /*     Dump pixels to file.   */A   (void) fwrite((char *) xwd_pixels,1,(int) packets,image->file);t   free((char *) xwd_pixels);   CloseImage(image);   return(True);) }  S /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             % O %                                                                             %-O %                                                                             %sO %   W r i t e I m a g e                                                       %rO %                                                                             %gO %                                                                             %tO %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%F %tD %  Function WriteImage writes an image to a file.  You can specify aJ %  particular image format by prefixing the file with the image type and aI %  colon (i.e. ps:image) or specify the image type as the filename suffixt %  (i.e. image.ps).e % + %  The format of the WriteImage routine is:- %l* %      status=WriteImage(image_info,image) %i+ %  A description of each parameter follows:n %.G %    o status: Function WriteImage return True if the image is written.iK %      False is returned is there is a memory shortage or if the image filed %      fails to write. %gA %    o image_info: Specifies a pointer to an ImageInfo structure.g %f- %    o image: A pointer to a Image structure.t %c %x */) unsigned int WriteImage(image_info,image)u	 ImageInfog   *image_info;   Imageg	   *image;  {    unsigned int     status;0     /*6     Call appropriate image writer based on image type.   */6   (void) strcpy(image_info->filename,image->filename);2   (void) strcpy(image_info->magick,image->magick);   SetImageMagick(image_info);F6   (void) strcpy(image->filename,image_info->filename);2   (void) strcpy(image->magick,image_info->magick);   switch (*image_info->magick)   {m
     case 'A':      { -       status=WriteAVSImage(image_info,image);y       break;     } 
     case 'B':t     {o-       status=WriteBMPImage(image_info,image);r       break;     }i
     case 'C':;     {F.       status=WriteCMYKImage(image_info,image);       break;     }r
     case 'E':v     {_,       status=WritePSImage(image_info,image);       break;     }a
     case 'F':S     {r0       if (strcmp(image_info->magick,"FAX") == 0)/         status=WriteFAXImage(image_info,image); 
       else0         status=WriteFITSImage(image_info,image);       break;     })
     case 'G':r     {t0       if (strcmp(image_info->magick,"GIF") == 0)/         status=WriteGIFImage(image_info,image);>
       else4         if (strcmp(image_info->magick,"GIF87") == 0)1           status=WriteGIFImage(image_info,image);s         else5           if (strcmp(image_info->magick,"GRAY") == 0) 4             status=WriteGRAYImage(image_info,image);           else3             status=WriteFAXImage(image_info,image);        break;     }i
     case 'H':*     {s3       status=WriteHISTOGRAMImage(image_info,image);        break;     } 
     case 'I':o     {i.       status=WriteIRISImage(image_info,image);       break;     }g
     case 'J':      { .       status=WriteJPEGImage(image_info,image);       break;     } 
     case 'M':=     {>0       if (strcmp(image_info->magick,"MAP") == 0)/         status=WriteMAPImage(image_info,image);i
       else4         if (strcmp(image_info->magick,"MATTE") == 0)3           status=WriteMATTEImage(image_info,image);i         else5           if (strcmp(image_info->magick,"MIFF") == 0)t4             status=WriteMIFFImage(image_info,image);           else;             if ((strcmp(image_info->magick,"MPEG") == 0) ||u8                 (strcmp(image_info->magick,"MPG") == 0))6               status=WriteMPEGImage(image_info,image);             else5               status=WriteMTVImage(image_info,image);l       break;     };
     case 'N':t       break;
     case 'P':t     {e0       if (strcmp(image_info->magick,"PCD") == 0)/         status=WritePCDImage(image_info,image);i
       else2         if (strcmp(image_info->magick,"PCX") == 0)1           status=WritePCXImage(image_info,image);r         else5           if (strcmp(image_info->magick,"PICT") == 0) 4             status=WritePICTImage(image_info,image);           else5             if (strcmp(image_info->magick,"PM") == 0) 5               status=WriteXPMImage(image_info,image);              else7               if (strcmp(image_info->magick,"PS") == 0)+6                 status=WritePSImage(image_info,image);               else:                 if (strcmp(image_info->magick,"PS2") == 0)                   status=d4                     WritePS2Image(image_info,image);                 else9                   status=WritePNMImage(image_info,image);        break;     }l
     case 'R':      {t0       if (strcmp(image_info->magick,"RAD") == 0)4         status=WriteRADIANCEImage(image_info,image);
       else2         if (strcmp(image_info->magick,"RAS") == 0)1           status=WriteSUNImage(image_info,image);          else4           if (strcmp(image_info->magick,"RGB") == 0)3             status=WriteRGBImage(image_info,image);            else3             status=WriteRLEImage(image_info,image);o       break;     } 
     case 'S':      {n-       status=WriteSUNImage(image_info,image);u       break;     }l
     case 'T':a     {u0       if (strcmp(image_info->magick,"TGA") == 0)1         status=WriteTARGAImage(image_info,image); 
       else6         if ((strcmp(image_info->magick,"TIF") == 0) ||5             (strcmp(image_info->magick,"TIFF") == 0))F2           status=WriteTIFFImage(image_info,image);         else2           status=WriteTEXTImage(image_info,image);       break;     } 
     case 'V':a     { 2       if (strcmp(image_info->magick,"VICAR") == 0)1         status=WriteVICARImage(image_info,image);%
       else2         if (strcmp(image_info->magick,"VID") == 0)2           status=WriteMIFFImage(image_info,image);         else2           status=WriteVIFFImage(image_info,image);       break;     } 
     case 'X':      { .       if (strcmp(image_info->magick,"X") == 0)-         status=WriteXImage(image_info,image); 
       else2         if (strcmp(image_info->magick,"XBM") == 0)1           status=WriteXBMImage(image_info,image);          else3           if (strcmp(image_info->magick,"XC") == 0) 2             status=WriteXCImage(image_info,image);           else6             if (strcmp(image_info->magick,"XPM") == 0)5               status=WriteXPMImage(image_info,image);I             else7               if (strcmp(image_info->magick,"XV") == 0)e8                 status=WriteVIFFImage(image_info,image);               else7                 status=WriteXWDImage(image_info,image);l       break;     }a
     case 'Y':r     {m0       if (strcmp(image_info->magick,"YUV") == 0)/         status=WriteYUVImage(image_info,image); 
       else0         status=WriteYUV3Image(image_info,image);       break;     }t     default:.       status=WriteMIFFImage(image_info,image);   }m   if (image->status)     {tG       Warning("An error has occurred writing to file",image->filename);i       return(False);     }    return(status);  },