 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                   D   D  E      C      O   O  D   D  E                      % O %                   D   D  EEE    C      O   O  D   D  EEE                    % O %                   D   D  E      C      O   O  D   D  E                      % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Read Image Formats                   % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h" #include "XWDFile.h"   /*   Forward declarations.  */ Image %   *ReadImage _Declare((ImageInfo *));    static Image)   *ReadMIFFImage _Declare((ImageInfo *)), (   *ReadPNMImage _Declare((ImageInfo *)),'   *ReadXCImage _Declare((ImageInfo *));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d A V S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadAVSImage reads a AVS X image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadAVSImage routine is:  % % %      image=ReadAVSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadAVSImage returns a pointer to the image after N %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadAVSImage(image_info)	 ImageInfo    *image_info; {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      Image      *image;      register int     i;     register unsigned char     *p;      register RunlengthPacket     *q;      unsigned char      *avs_pixels;     unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Read AVS image.    */J   status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),     image->file);    if (status == False)     { 4       Warning("Not a AVS image file",(char *) NULL);       DestroyImage(image);       return((Image *) NULL);      }    do   {      /*!       Initialize image structure.      */     image->matte=True;$     image->columns=avs_header.width;"     image->rows=avs_header.height;.     image->packets=image->columns*image->rows;P     avs_pixels=(unsigned char *) malloc(4*image->packets*sizeof(unsigned char));%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 1     if ((avs_pixels == (unsigned char *) NULL) || 4         (image->pixels == (RunlengthPacket *) NULL))       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*<       Convert AVS raster image to runlength-encoded packets.     */F     (void) ReadData((char *) avs_pixels,4,image->packets,image->file);     p=avs_pixels;      q=image->pixels;&     for (i=0; i < image->packets; i++)     { &       q->index=(unsigned char) (*p++);       q->red=(*p++);       q->green=(*p++);       q->blue=(*p++);        q->length=0;
       q++;     }      free((char *) avs_pixels);L     status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),       image->file);      if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d B M P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadBMPImage reads a Microsoft Windows bitmap image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadBMPImage routine is:  % % %      image=ReadBMPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadBMPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadBMPImage(image_info)	 ImageInfo    *image_info; {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *bmp_data,     *bmp_pixels,     magick[12];      unsigned int     bytes_per_line,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*$     Determine if this is a BMP file.   */3   status=ReadData((char *) magick,1,2,image->file);    do   {      /*       Verify BMP identifier.     */D     if ((status == False) || (strncmp((char *) magick,"BM",2) != 0))       { 6         Warning("Not a BMP image file",(char *) NULL);         DestroyImages(image);          return((Image *) NULL);        } 7     bmp_header.file_size=LSBFirstReadLong(image->file); :     bmp_header.reserved[0]=LSBFirstReadShort(image->file);:     bmp_header.reserved[1]=LSBFirstReadShort(image->file);9     bmp_header.offset_bits=LSBFirstReadLong(image->file); 2     bmp_header.size=LSBFirstReadLong(image->file);     if (bmp_header.size == 12)       { 
         /*           OS/2 BMP image file.
         */H         bmp_header.width=(unsigned long) LSBFirstReadShort(image->file);I         bmp_header.height=(unsigned long) LSBFirstReadShort(image->file); 9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);#         bmp_header.number_colors=0; !         bmp_header.compression=0;           bmp_header.image_size=0;       }      else       { 
         /*+           Microsoft Windows BMP image file. 
         */7         bmp_header.width=LSBFirstReadLong(image->file); 8         bmp_header.height=LSBFirstReadLong(image->file);9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);=         bmp_header.compression=LSBFirstReadLong(image->file); <         bmp_header.image_size=LSBFirstReadLong(image->file);:         bmp_header.x_pixels=LSBFirstReadLong(image->file);:         bmp_header.y_pixels=LSBFirstReadLong(image->file);?         bmp_header.number_colors=LSBFirstReadLong(image->file); B         bmp_header.colors_important=LSBFirstReadLong(image->file);6         for (i=0; i < ((int) bmp_header.size-40); i++)$           (void) fgetc(image->file);       } "     if (bmp_header.bit_count < 24)       {          unsigned char            *bmp_colormap;           unsigned int           packet_size;  
         /*#           Read BMP raster colormap. 
         */!         image->class=PseudoClass; 0         image->colors=1 << bmp_header.bit_count;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         bmp_colormap=(unsigned char *)8           malloc(4*image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (bmp_colormap == (unsigned char *) NULL))            { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            }          packet_size=4;"         if (bmp_header.size == 12)           packet_size=3;H         (void) ReadData((char *) bmp_colormap,packet_size,image->colors,           image->file);          p=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { )           image->colormap[i].blue=(*p++); *           image->colormap[i].green=(*p++);(           image->colormap[i].red=(*p++);$           if (bmp_header.size != 12)             p++;	         } $         free((char *) bmp_colormap);       }      /*       Read image data.     */#     if (bmp_header.image_size == 0)        bmp_header.image_size=L         ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;     bmp_data=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));+     if (bmp_data == (unsigned char *) NULL)        { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        } M     status=ReadData((char *) bmp_data,1,(unsigned int) bmp_header.image_size,        image->file);      if (status == False)       { B         Warning("Unable to read image data",image_info->filename);         DestroyImages(image);          return((Image *) NULL);        }      bmp_pixels=bmp_data;$     if (bmp_header.compression != 0)       {          unsigned int           packets;  
         /*3           Convert run-length encoded raster pixels. 
         */         packets=N           ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;(         if (bmp_header.compression == 2)           packets<<=1;K         bmp_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); 1         if (bmp_pixels == (unsigned char *) NULL)            { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            } 2         (void) BMPDecodeImage(bmp_data,bmp_pixels,P           (unsigned int) bmp_header.compression,(unsigned int) bmp_header.width,,           (unsigned int) bmp_header.height);(         if (bmp_header.compression == 2)#           bmp_header.bit_count<<=1;           free((char *) bmp_data);       }      /*!       Initialize image structure.      */$     image->columns=bmp_header.width;"     image->rows=bmp_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*<       Convert BMP raster image to runlength-encoded packets.     */C     bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; !     switch (bmp_header.bit_count)      { 
       case 1:        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-7); x+=8)            { '             for (bit=0; bit < 8; bit++) 
             { <               q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);               q->length=0;               q++;
             }              p++;           } (           if ((image->columns % 8) != 0)
             { <               for (bit=0; bit < (image->columns % 8); bit++)               { >                 q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);                 q->length=0;                 q++;               }                p++;
             } 	         }          SyncImage(image);          break;       } 
       case 4:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-1); x+=2)            { %             q->index=(*p >> 4) & 0xf;              q->length=0;             q++;              q->index=(*p) & 0xf;             q->length=0;             p++;             q++;           } (           if ((image->columns % 2) != 0)
             { '               q->index=(*p >> 4) & 0xf;                q->length=0;               q++;               p++;
             } 	         }          SyncImage(image);           CompressColormap(image);         break;       } 
       case 8:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } 	         }          SyncImage(image);           CompressColormap(image);         break;       }        case 24:       { 
         /*J           Convert DirectColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           { B             q->index=(unsigned short) (image->matte ? (*p++) : 0);             q->blue=(*p++);              q->green=(*p++);             q->red=(*p++);             q->length=0;             q++;           } 	         }          break;       }        default:       { 6         Warning("Not a BMP image file",(char *) NULL);         DestroyImages(image);          return((Image *) NULL);        }      }      free((char *) bmp_pixels);     /*       Proceed to next image.     */5     status=ReadData((char *) magick,1,2,image->file); C     if ((status == True) && (strncmp((char *) magick,"BM",2) == 0))        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } G   } while ((status == True) && (strncmp((char *) magick,"BM",2) == 0)); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d C M Y K I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ReadCMYKImage reads an image of raw cyan, magenta, yellow, andM %  black bytes and returns it.  It allocates the memory necessary for the new : %  Image structure and returns a pointer to the new image. % . %  The format of the ReadCMYKImage routine is: % & %      image=ReadCMYKImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadCMYKImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadCMYKImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char 
     black,     *cmyk_pixels, 	     cyan,      magenta,     yellow;      unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize image structure.    */   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;O   cmyk_pixels=(unsigned char *) malloc(4*image->packets*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if ((cmyk_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))     { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*6     Convert raster image to runlength-encoded packets.   */E   (void) ReadData((char *) cmyk_pixels,4,image->packets,image->file);    p=cmyk_pixels;    switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->red=(*p++);         q->green=(*p++);         q->blue=(*p++);          q->index=(*p++);         q->length=0;         q++;       }        break;     }      case LineInterlace:      {        /*K         Line interlacing:  CCC...MMM...YYY...KKK...CCC...MMM...YYY...KKK...        */%       for (y=0; y < image->rows; y++)        { )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {            q->red=(*p++);           q->length=0;           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {            q->green=(*p++);           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {            q->blue=(*p++);            q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {            q->index=(*p++);           q++;	         }        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->red=(*p++);         q->length=0;         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->green=(*p++);         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->blue=(*p++);          q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->index=(*p++);         q++;       }        break;     }    }    /*     Transform image to CMYK.   */   q=image->pixels;$   for (i=0; i < image->packets; i++)   {      cyan=q->red;     magenta=q->green;      yellow=q->blue;      black=q->index; -     if ((unsigned int) (cyan+black) > MaxRGB)        q->red=0;      else!       q->red=MaxRGB-(cyan+black); 0     if ((unsigned int) (magenta+black) > MaxRGB)       q->green=0;      else&       q->green=MaxRGB-(magenta+black);/     if ((unsigned int) (yellow+black) > MaxRGB)        q->blue=0;     else$       q->blue=MaxRGB-(yellow+black);     q->index=0;      q->length=0;     q++;   }    free((char *) cmyk_pixels);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d F A X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadFAXImage reads a Group 3 FAX image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadFAXImage routine is:  % % %      image=ReadFAXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadFAXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadFAXImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Initialize image structure.    */   image->class=PseudoClass;    image->columns=1728;   image->rows=2156; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*     Monochrome colormap.   */    image->colormap[0].red=MaxRGB;"   image->colormap[0].green=MaxRGB;!   image->colormap[0].blue=MaxRGB;    image->colormap[1].red=0;    image->colormap[1].green=0;    image->colormap[1].blue=0;#   status=HuffmanDecodeImage(image);    if (status == False)     { 9       Warning("Unable to read image data",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    SyncImage(image);    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d F I T S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadFITSImage reads a FITS image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadFITSImage routine is: % & %      image=ReadFITSImage(image_info) % + %  A description of each parameter follows:  % I %    o image: Function ReadFITSImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */' static Image *ReadFITSImage(image_info) 	 ImageInfo    *image_info; {    typedef struct _FITSHeader   {      unsigned int
       simple;        int        bits_per_pixel;        unsigned int       number_of_axis,        columns,       rows,        depth;  
     double       min_data,        max_data,        zero,        scale;   } FITSHeader;      char     keyword[MaxTextLength],      value[MaxTextLength];      double
     pixel,
     scale,     scaled_pixel;      FITSHeader     fits_header;     Image      *image;      int      packet_size;     long
     count,     quantum;     register int     c,     i,     j;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *fits_pixels;      unsigned int     status,      value_expected;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Initialize image header.   */   fits_header.simple=False;    fits_header.bits_per_pixel=8;    fits_header.columns=1;   fits_header.rows=1;    fits_header.depth=1;   fits_header.min_data=0.0;    fits_header.max_data=0.0;    fits_header.zero=0.0;    fits_header.scale=1.0;   /*     Decode image header.   */   c=fgetc(image->file); 
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      } 
   for ( ; ; )    {      if (!isalnum(c))       {          c=fgetc(image->file);          count++;       }      else       {          register char 
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;+         } while (isalnum(c) || (c == '_'));          *p='\0';'         if (strcmp(keyword,"END") == 0)            break;         value_expected=False; (         while (isspace(c) || (c == '='))	         {            if (c == '=')               value_expected=True;           c=fgetc(image->file);            count++;	         } $         if (value_expected == False)           continue;          p=value;D         while (isalnum(c) || (c == '-') || (c == '+') || (c == '.'))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */*         if (strcmp(keyword,"SIMPLE") == 0)@           fits_header.simple=(*value == 'T') || (*value == 't');*         if (strcmp(keyword,"BITPIX") == 0)@           fits_header.bits_per_pixel=(unsigned int) atoi(value);)         if (strcmp(keyword,"NAXIS") == 0) @           fits_header.number_of_axis=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS1") == 0)9           fits_header.columns=(unsigned int) atoi(value); *         if (strcmp(keyword,"NAXIS2") == 0)6           fits_header.rows=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS3") == 0)7           fits_header.depth=(unsigned int) atoi(value); +         if (strcmp(keyword,"DATAMAX") == 0) +           fits_header.max_data=atof(value); +         if (strcmp(keyword,"DATAMIN") == 0) +           fits_header.min_data=atof(value); )         if (strcmp(keyword,"BZERO") == 0) '           fits_header.zero=atof(value); *         if (strcmp(keyword,"BSCALE") == 0)(           fits_header.scale=atof(value);       }      while (isspace(c))     {        c=fgetc(image->file);        count++;     }    }    while (count > 2880)     count-=2880;    for ( ; count < 2880; count++)     (void) fgetc(image->file);   /*6     Verify that required image information is defined.   */B   if ((!fits_header.simple) || (fits_header.number_of_axis < 1) ||)       (fits_header.number_of_axis > 3) || 2       (fits_header.columns*fits_header.rows) == 0)     { F       Warning("Unable to read FITS image","image type not supported");       DestroyImage(image);       return((Image *) NULL);      }    /*     Create linear colormap.    */%   image->columns=fits_header.columns;    image->rows=fits_header.rows;    image->class=PseudoClass;    image->colors=MaxRGB+1; L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      } #   for (i=0; i < image->colors; i++)    { -     image->colormap[i].red=(unsigned char) i; /     image->colormap[i].green=(unsigned char) i; .     image->colormap[i].blue=(unsigned char) i;   }    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); +   packet_size=fits_header.bits_per_pixel/8;    if (packet_size < 0)     packet_size=(-packet_size);    fits_pixels=(unsigned char *) =     malloc(image->packets*packet_size*sizeof(unsigned char)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||.       (fits_pixels == (unsigned char *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*5     Convert FITS pixels to runlength-encoded packets.    */B   status=ReadData((char *) fits_pixels,(unsigned int) packet_size,      image->packets,image->file);   if (status == False)?     Warning("Insufficient image data in file",image->filename); E   if ((fits_header.min_data == 0.0) && (fits_header.max_data == 0.0))      {        /*0         Determine minimum and maximum intensity.       */       p=fits_pixels;       quantum=(*p++); )       for (j=0; j < (packet_size-1); j++) (         quantum=(quantum << 8) | (*p++);       pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum)); D       fits_header.min_data=pixel*fits_header.scale+fits_header.zero;D       fits_header.max_data=pixel*fits_header.scale+fits_header.zero;(       for (i=1; i < image->packets; i++)       {          quantum=(*p++); +         for (j=0; j < (packet_size-1); j++) *           quantum=(quantum << 8) | (*p++);         pixel=(double) quantum; .         if (fits_header.bits_per_pixel == -32)1           pixel=(double) (*((float *) &quantum)); >         scaled_pixel=pixel*fits_header.scale+fits_header.zero;0         if (scaled_pixel < fits_header.min_data),           fits_header.min_data=scaled_pixel;0         if (scaled_pixel > fits_header.max_data),           fits_header.max_data=scaled_pixel;       }      }    /*5     Convert FITS pixels to runlength-encoded packets.    */   scale=1.0;3   if (fits_header.min_data != fits_header.max_data) A     scale=(MaxRGB+1)/(fits_header.max_data-fits_header.min_data);    p=fits_pixels;   q=image->pixels;$   for (i=0; i < image->packets; i++)   {      quantum=(*p++); '     for (j=0; j < (packet_size-1); j++) &       quantum=(quantum << 8) | (*p++);     pixel=(double) quantum; *     if (fits_header.bits_per_pixel == -32)-       pixel=(double) (*((float *) &quantum));      scaled_pixel=scale* F       (pixel*fits_header.scale+fits_header.zero-fits_header.min_data);     while (scaled_pixel < 0)       scaled_pixel+=(MaxRGB+1); !     while (scaled_pixel > MaxRGB)        scaled_pixel-=(MaxRGB+1); +     q->index=(unsigned short) scaled_pixel;      q->length=0;     q++;   }    free((char *) fits_pixels);    SyncImage(image);    CompressColormap(image);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G I F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGIFImage reads a Compuserve Graphics image file and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % - %  The format of the ReadGIFImage routine is:  % % %      image=ReadGIFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadGIFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or %      an error occurs.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadGIFImage(image_info)	 ImageInfo    *image_info; { 5 #define BitSet(byte,bit)  (((byte) & (bit)) == (bit)) . #define LSBFirstOrder(x,y)  (((y) << 8) | (x))     Image      *image;      int      status,      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      short int      transparency_index;      unsigned char      c,     *global_colormap,      header[MaxTextLength],     magick[12];      unsigned int     global_colors,     image_count,     interlace,     local_colormap;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*$     Determine if this is a GIF file.   */3   status=ReadData((char *) magick,1,6,image->file); 4   status|=ReadData((char *) header,1,7,image->file);H   if ((status == False) || ((strncmp((char *) magick,"GIF87",5) != 0) &&1       (strncmp((char *) magick,"GIF89",5) != 0)))      { 6       Warning("Not a GIF image file",image->filename);       DestroyImage(image);       return((Image *) NULL);      }    global_colors=0;)   global_colormap=(unsigned char *) NULL;    if (BitSet(header[4],0x80))      {        /*         Read global colormap.        */0       global_colors=1 << ((header[4] & 0x07)+1);'       global_colormap=(unsigned char *) 6         malloc(3*global_colors*sizeof(unsigned char));4       if (global_colormap == (unsigned char *) NULL)	         { N           Warning("Unable to read image colormap","Memory allocation failed");           DestroyImage(image);!           return((Image *) NULL); 	         } L       (void) ReadData((char *) global_colormap,3,global_colors,image->file);     }    transparency_index=(-1);   image_count=0;
   for ( ; ; )    { 1     status=ReadData((char *) &c,1,1,image->file);      if (status == False)       break;     if (c == ';')        break;  /* terminator */     if (c == '!')        { 
         /*           GIF Extension block.
         */5         status=ReadData((char *) &c,1,1,image->file);          if (status == False)           { D             Warning("Unable to read extention block",(char *) NULL);!             DestroyImages(image); #             return((Image *) NULL);            }          switch (c)	         {            case 0xf9:           {              /*+               Transparency extension block.              */C             while (ReadDataBlock((char *) header,image->file) > 0); (             if ((header[0] & 0x01) == 1)+               transparency_index=header[3];              break;           }            case 0xfe:           {              int                length;                /*&               Comment extension block.             */             for ( ; ; ) 
             { @               length=ReadDataBlock((char *) header,image->file);               if (length <= 0)                 break;3               if (image->comments != (char *) NULL) J                 image->comments=(char *) realloc((char *) image->comments,C                   (strlen(image->comments)+length+1)*sizeof(char));                else                 { K                   image->comments=(char *) malloc((length+1)*sizeof(char)); 7                   if (image->comments != (char *) NULL) *                     *image->comments='\0';                 } 3               if (image->comments == (char *) NULL)                  { C                   Warning("Memory allocation error",(char *) NULL); '                   DestroyImages(image); )                   return((Image *) NULL);                  } "               header[length]='\0';=               (void) strcat(image->comments,(char *) header); 
             }              break;           }            default:           { C             while (ReadDataBlock((char *) header,image->file) > 0);              break;           } 	         }        }      if (c != ',')        continue;      /*       Read image attributes.     */     if (image_count != 0)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }      image_count++;5     status=ReadData((char *) header,1,9,image->file);      if (status == False)       { F         Warning("Unable to read left/top/width/height",(char *) NULL);         DestroyImages(image);          return((Image *) NULL);        } %     interlace=BitSet(header[8],0x40); *     local_colormap=BitSet(header[8],0x80);     /*       Allocate image.      */6     image->columns=LSBFirstOrder(header[4],header[5]);3     image->rows=LSBFirstOrder(header[6],header[7]); .     image->packets=image->columns*image->rows;     if (image->packets == 0)       { <         Warning("Unable to read image","image size is 0x0");         DestroyImages(image);          return((Image *) NULL);        } 2     if (image->pixels != (RunlengthPacket *) NULL)#       free((char *) image->pixels); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { C         Warning("Unable to read image","Memory allocation failed");          DestroyImages(image);          return((Image *) NULL);        }      /*       Inititialize colormap.     */     image->class=PseudoClass; P     image->colors=!local_colormap ? global_colors : 1 << ((header[8] & 0x07)+1);N     image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));0     if (image->colormap == (ColorPacket *) NULL)       { C         Warning("Unable to read image","Memory allocation failed");          DestroyImages(image);          return((Image *) NULL);        }      if (!local_colormap)       { 
         /*           Use global colormap.
         */         p=global_colormap;)         for (i=0; i < image->colors; i++) 	         { (           image->colormap[i].red=(*p++);*           image->colormap[i].green=(*p++);)           image->colormap[i].blue=(*p++); 	         }        }      else       {          unsigned char            *colormap;  
         /*           Read local colormap.
         */"         colormap=(unsigned char *)8           malloc(3*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL)            { P             Warning("Unable to read local colormap","Memory allocation failed");!             DestroyImages(image); #             return((Image *) NULL);            } G         (void) ReadData((char *) colormap,3,image->colors,image->file);          p=colormap; )         for (i=0; i < image->colors; i++) 	         { (           image->colormap[i].red=(*p++);*           image->colormap[i].green=(*p++);)           image->colormap[i].blue=(*p++); 	         }           free((char *) colormap);       }      /*       Decode image.      */!     status=LZWDecodeImage(image);      if (interlace)       { 
         Image            *interlaced_image;           int            pass;             register RunlengthPacket
           *p;            static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */         image->orphan=True; J         interlaced_image=CopyImage(image,image->columns,image->rows,True);         image->orphan=False;/         if (interlaced_image == (Image *) NULL)            { G             Warning("Unable to read image","Memory allocation failed"); !             DestroyImages(image); #             return((Image *) NULL);            } #         p=interlaced_image->pixels;          q=image->pixels;&         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             q=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } '         DestroyImage(interlaced_image);        }       if (transparency_index >= 0)       { 
         /*           Create matte channel. 
         */         q=image->pixels;*         for (i=0; i < image->packets; i++)	         { >           if (q->index != (unsigned short) transparency_index)             q->index=Opaque;           else!             q->index=Transparent;            q++;	         }           transparency_index=(-1);!         image->class=DirectClass;          image->matte=True;       }      if (status == False)       { 5         Warning("Corrupt GIF image",image->filename);          break;       }    } 0   if (global_colormap != (unsigned char *) NULL)#     free((char *) global_colormap); 0   if (image->pixels == (RunlengthPacket *) NULL)     { 3       Warning("Corrupt GIF image",image->filename);        DestroyImages(image);        return((Image *) NULL);      } +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G R A Y I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGRAYImage reads an image of raw grayscale bytes and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % . %  The format of the ReadGRAYImage routine is: % & %      image=ReadGRAYImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadGRAYImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadGRAYImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char
     index,     *p;      unsigned char      *gray_pixels;      unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Create linear colormap.    */   image->class=PseudoClass;    image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      } #   for (i=0; i < image->colors; i++)    { -     image->colormap[i].red=(unsigned char) i; /     image->colormap[i].green=(unsigned char) i; .     image->colormap[i].blue=(unsigned char) i;   }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize image structure.    */   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;M   gray_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if ((gray_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*6     Convert raster image to runlength-encoded packets.   */E   (void) ReadData((char *) gray_pixels,1,image->packets,image->file);    p=gray_pixels;   q=image->pixels;$   for (i=0; i < image->packets; i++)   {      index=(*p++);      q->red=index;      q->green=index;      q->blue=index;$     q->index=(unsigned short) index;     q->length=0;     q++;   }    free((char *) gray_pixels);    CompressColormap(image);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H I S T O G R A M I m a g e                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadHISTOGRAMImage reads a HISTOGRAM image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % 3 %  The format of the ReadHISTOGRAMImage routine is:  % + %      image=ReadHISTOGRAMImage(image_info)  % + %  A description of each parameter follows:  % O %    o image:  Function ReadHISTOGRAMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */, static Image *ReadHISTOGRAMImage(image_info)	 ImageInfo    *image_info; {    Image      *image;   "   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d I R I S I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadIRISImage reads a SGI RGB image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadIRISImage routine is: % & %      image=ReadIRISImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadIRISImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  & static void IRISDecode(packets,pixels)
 unsigned char    *packets, 
   *pixels; {    unsigned char 
     count,
     pixel;     for ( ; ;)   {      pixel=(*packets++);      count=pixel & 0x7f;      if (count == 0)        break;     if (pixel & 0x80) "       for ( ; count != 0; count--)       {          *pixels=(*packets++);          pixels+=4;       }      else       {          pixel=(*packets++); $         for ( ; count != 0; count--)	         {            *pixels=pixel;           pixels+=4;	         }        }    }  }   ' static Image *ReadIRISImage(image_info) 	 ImageInfo    *image_info; {    typedef struct _IRISHeader   {      unsigned short       magic;       unsigned char        storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned long        minimum_value,       maximum_value;       unsigned char        filler[492];   } IRISHeader;      Image      *image;      IRISHeader     iris_header;     register int     i,     x,     y,     z;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *iris_pixels;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Read IRIS raster header.   */3   iris_header.magic=MSBFirstReadShort(image->file);    do   {      /*       Verify IRIS identifier.      */$     if (iris_header.magic != 0x01DA)       { 9         Warning("Not a IRIS RGB image,",image->filename);          DestroyImages(image);          return((Image *) NULL);        } +     iris_header.storage=fgetc(image->file); 3     iris_header.bytes_per_pixel=fgetc(image->file); )     if (iris_header.bytes_per_pixel != 1)        { M         Warning("Image must have 1 byte per pixel channel,",image->filename);          DestroyImages(image);          return((Image *) NULL);        } 9     iris_header.dimension=MSBFirstReadShort(image->file); 7     iris_header.columns=MSBFirstReadShort(image->file); 4     iris_header.rows=MSBFirstReadShort(image->file);5     iris_header.depth=MSBFirstReadShort(image->file); <     iris_header.minimum_value=MSBFirstReadLong(image->file);<     iris_header.maximum_value=MSBFirstReadLong(image->file);2     (void) ReadData((char *) iris_header.filler,1,=       (unsigned int) sizeof(iris_header.filler),image->file);      /*       Allocate IRIS pixels.      */!     iris_pixels=(unsigned char *) K       malloc(4*iris_header.columns*iris_header.rows*sizeof(unsigned char)); .     if (iris_pixels == (unsigned char *) NULL)       { ;         Warning("Memory allocation error",image->filename);          DestroyImages(image);          return((Image *) NULL);        } $     if (iris_header.storage != 0x01)       {          unsigned char            *scanline;  
         /*%           Read standard image format. 
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL)            { ?             Warning("Memory allocation error",image->filename); !             DestroyImages(image); #             return((Image *) NULL);            } 3         for (z=0; z < (int) iris_header.depth; z++) 	         {            p=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           { D             (void) ReadData((char *) scanline,1,iris_header.columns,               image->file); 9             for (x=0; x < (int) iris_header.columns; x++) 
             {                *p=scanline[x];                p+=4; 
             }            } 	         }           free((char *) scanline);       }      else       {          unsigned char            *packets;            unsigned int           data_order;            unsigned long            offset,            *offsets,            *runlength;   
         /*.           Read runlength-encoded image format.
         */!         offsets=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); !         packets=(unsigned char *) H           malloc(((iris_header.columns << 1)+10)*sizeof(unsigned char));#         runlength=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); 2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL))           { ?             Warning("Memory allocation error",image->filename); !             DestroyImages(image); #             return((Image *) NULL);            } F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)3           offsets[i]=MSBFirstReadLong(image->file); F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)5           runlength[i]=MSBFirstReadLong(image->file); 
         /*           Check data order. 
         */         offset=0;          data_order=0; E         for (y=0; ((y < (int) iris_header.rows) && !data_order); y++) H           for (z=0; ((z < (int) iris_header.depth) && !data_order); z++)           { 7             if (offsets[y+z*iris_header.rows] < offset)                data_order=1; 1             offset=offsets[y+z*iris_header.rows];            } A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);          if (data_order == 1)           { 7             for (z=0; z < (int) iris_header.depth; z++) 
             {                p=iris_pixels;8               for (y=0; y < (int) iris_header.rows; y++)               { <                 if (offset != offsets[y+z*iris_header.rows])                   { 9                     offset=offsets[y+z*iris_header.rows]; =                     (void) fseek(image->file,(int) offset,0);                    } 3                 (void) ReadData((char *) packets,1, N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];(                 IRISDecode(packets,p+z);+                 p+=(iris_header.columns*4);                } 
             }            }          else           {              p=iris_pixels;6             for (y=0; y < (int) iris_header.rows; y++)
             { 9               for (z=0; z < (int) iris_header.depth; z++)                { <                 if (offset != offsets[y+z*iris_header.rows])                   { 9                     offset=offsets[y+z*iris_header.rows]; =                     (void) fseek(image->file,(int) offset,0);                    } 3                 (void) ReadData((char *) packets,1, N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];(                 IRISDecode(packets,p+z);               } )               p+=(iris_header.columns*4); 
             }            }          free(runlength);         free(packets);         free(offsets);       }      /*!       Initialize image structure.      */(     image->matte=iris_header.depth == 4;'     image->columns=iris_header.columns; !     image->rows=iris_header.rows; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*=       Convert IRIS raster image to runlength-encoded packets.      */     q=image->pixels;     if (iris_header.depth >= 3)        { 
         /*F           Convert IRIS image to DirectClass runlength-encoded packets.
         */'         for (y=0; y < image->rows; y++) 	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4); ,           for (x=0; x < image->columns; x++)           {              q->red=(*p);             q->green=(*(p+1));             q->blue=(*(p+2));              q->index=(*(p+3));             q->length=0;             p+=4;              q++;           } 	         }        }      else       {          unsigned short           index;  
         /*           Create grayscale map. 
         */!         image->class=PseudoClass;          image->colors=256;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL)           { G             Warning("Unable to read image","Memory allocation failed");               DestroyImage(image);#             return((Image *) NULL);            } )         for (i=0; i < image->colors; i++) 	         { 3           image->colormap[i].red=(unsigned char) i; 5           image->colormap[i].green=(unsigned char) i; 4           image->colormap[i].blue=(unsigned char) i;	         } 
         /*F           Convert IRIS image to PseudoClass runlength-encoded packets.
         */'         for (y=0; y < image->rows; y++) 	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4); ,           for (x=0; x < image->columns; x++)           { (             index=(unsigned short) (*p);.             q->red=image->colormap[index].red;2             q->green=image->colormap[index].green;0             q->blue=image->colormap[index].blue;             q->index=index;              q->length=0;             p+=4;              q++;           } 	         }        }      free((char *) iris_pixels);      /*       Proceed to next image.     */5     iris_header.magic=MSBFirstReadShort(image->file); $     if (iris_header.magic == 0x01DA)       { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } (   } while (iris_header.magic == 0x01DA);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    #ifdef HasJPEG #include <setjmp.h>  #include "jpeglib.h" #include "jerror.h"    static Image	   *image;    static jmp_buf   error_recovery;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadJPEGImage reads a JPEG image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % . %  The format of the ReadJPEGImage routine is: % & %      image=ReadJPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJPEGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % ? %    o filename:  Specifies the name of the jpeg image to read.  %  %  */  + static unsigned int GetCharacter(jpeg_info)  j_decompress_ptr   jpeg_info; {    struct jpeg_source_mgr
     *data;     data=jpeg_info->src;!   if (data->bytes_in_buffer == 0) +     (*data->fill_input_buffer) (jpeg_info);    data->bytes_in_buffer--;.   return(GETJOCTET(*data->next_input_byte++)); }   $ static int CommentHandler(jpeg_info) j_decompress_ptr   jpeg_info; { 
   long int     length;      register char      *p;      /*      Determine length of comment.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2;'   if (image->comments != (char *) NULL) >     image->comments=(char *) realloc((char *) image->comments,F       (unsigned int) (strlen(image->comments)+length+1)*sizeof(char));   else     {        image->comments=(char *)7         malloc((unsigned int) (length+1)*sizeof(char)); +       if (image->comments != (char *) NULL)          *image->comments='\0';     } '   if (image->comments == (char *) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        return(False);     }    /*     Read comment.    */,   p=image->comments+strlen(image->comments);   while (--length >= 0) !     *p++=GetCharacter(jpeg_info); 
   *p='\0';   return(True);  }   ( static void EmitMessage(jpeg_info,level) j_common_ptr   jpeg_info;   int    level; {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { L       if ((jpeg_error->num_warnings == 0) || (jpeg_error->trace_level >= 3))2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }     static void ErrorExit(jpeg_info) j_common_ptr   jpeg_info; {    EmitMessage(jpeg_info,0);    longjmp(error_recovery,1); }   ' static Image *ReadJPEGImage(image_info) 	 ImageInfo    *image_info; { 	   JSAMPLE      *jpeg_pixels,      **scanlines;     register int     i,     j;     register JSAMPLE     *p;      register RunlengthPacket     *q;      struct jpeg_decompress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned char      gray_value;      unsigned int
     count,     packets;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Initialize image structure.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;&   jpeg_info.err->error_exit=ErrorExit;)   image->pixels=(RunlengthPacket *) NULL;    if (setjmp(error_recovery))      {        /*         JPEG image is corrupt.       */*       jpeg_destroy_decompress(&jpeg_info);       CloseImage(image);6       if ((image->columns == 0) || (image->rows == 0))	         {            DestroyImage(image);!           return((Image *) NULL); 	         }        return(image);     } %   jpeg_create_decompress(&jpeg_info); @   jpeg_set_marker_processor(&jpeg_info,JPEG_COM,CommentHandler);)   jpeg_stdio_src(&jpeg_info,image->file); +   (void) jpeg_read_header(&jpeg_info,True); (   if (image_info->size != (char *) NULL)     {        unsigned int         height,          width;         unsigned long          scale_factor;          /*.         Let the JPEG library subsample for us.       */.       jpeg_calc_output_dimensions(&jpeg_info);3       image->magick_columns=jpeg_info.output_width; 1       image->magick_rows=jpeg_info.output_height; #       width=jpeg_info.output_width; %       height=jpeg_info.output_height; :       ParseImageGeometry(image_info->size,&width,&height);9       scale_factor=UpShift(jpeg_info.output_width)/width; C       if (scale_factor > (UpShift(jpeg_info.output_height)/height)) =         scale_factor=UpShift(jpeg_info.output_height)/height; 4       jpeg_info.scale_denom=DownShift(scale_factor);.       jpeg_calc_output_dimensions(&jpeg_info);     }  #ifdef DCT_FLOAT_SUPPORTED"   jpeg_info.dct_method=JDCT_FLOAT; #endif$   jpeg_start_decompress(&jpeg_info);(   image->columns=jpeg_info.output_width;&   image->rows=jpeg_info.output_height;,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); A   packets=jpeg_info.output_components*image->rows*image->columns; :   jpeg_pixels=(JSAMPLE *) malloc(packets*sizeof(JSAMPLE));?   scanlines=(JSAMPLE **) malloc(image->rows*sizeof(JSAMPLE *)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||L       (jpeg_pixels == (JSAMPLE *) NULL) || (scanlines == (JSAMPLE **) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      } 1   if (jpeg_info.out_color_space == JCS_GRAYSCALE)      {        /*&         Initialize grayscale colormap.       */       image->class=PseudoClass;        image->colors=256;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         { P           Warning("Unable to create image colormap","Memory allocation failed");           DestroyImage(image);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { 1         image->colormap[i].red=(unsigned char) i; 3         image->colormap[i].green=(unsigned char) i; 2         image->colormap[i].blue=(unsigned char) i;       }      }    /*     Initialize image.    */   q=image->pixels;$   for (i=0; i < image->packets; i++)   { 
     q->red=0;      q->green=0;      q->blue=0;     q->index=0;      q->length=0;     q++;   }    /*5     Convert JPEG pixels to runlength-encoded packets.    */!   for (i=0; i < image->rows; i++) L     scanlines[i]=jpeg_pixels+(i*image->columns*jpeg_info.output_components);   q=image->pixels;&   for (i=0; i < image->rows; i+=count)   { B     count=jpeg_read_scanlines(&jpeg_info,scanlines+i,image->rows);     p=scanlines[i]; %     if (jpeg_info.data_precision > 8)        { 7         if (jpeg_info.out_color_space == JCS_GRAYSCALE) 4           for (j=0; j < (count*image->columns); j++)           { +             gray_value=GETJSAMPLE(*p) >> 4; .             q->red=(unsigned char) gray_value;0             q->green=(unsigned char) gray_value;/             q->blue=(unsigned char) gray_value; 1             q->index=(unsigned short) gray_value;              q->length=0;             p++;             q++;           }          else4           for (j=0; j < (count*image->columns); j++)           { ;             q->red=(unsigned char) (GETJSAMPLE(*p++) >> 4); =             q->green=(unsigned char) (GETJSAMPLE(*p++) >> 4); <             q->blue=(unsigned char) (GETJSAMPLE(*p++) >> 4);             q->index=0;              q->length=0;             q++;           }        }      else5       if (jpeg_info.out_color_space == JCS_GRAYSCALE) 2         for (j=0; j < (count*image->columns); j++)	         { $           gray_value=GETJSAMPLE(*p);,           q->red=(unsigned char) gray_value;.           q->green=(unsigned char) gray_value;-           q->blue=(unsigned char) gray_value; /           q->index=(unsigned short) gray_value;            q->length=0;           p++;           q++;	         } 
       else2         for (j=0; j < (count*image->columns); j++)	         { 2           q->red=(unsigned char) GETJSAMPLE(*p++);4           q->green=(unsigned char) GETJSAMPLE(*p++);3           q->blue=(unsigned char) GETJSAMPLE(*p++);            q->index=0;            q->length=0;           q++;	         }    }    /*     Free memory.   */   free((char *) scanlines);    free((char *) jpeg_pixels); ,   (void) jpeg_finish_decompress(&jpeg_info);&   jpeg_destroy_decompress(&jpeg_info);   CloseImage(image);   return(image); }  #else ' static Image *ReadJPEGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("JPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d L O G O I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadLOGOImage reads a LOGO image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadLOGOImage routine is: % & %      image=ReadLOGOImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadLOGOImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadLOGOImage(image_info) 	 ImageInfo    *image_info; {  #include "logo.h"      char     *filename,!     logo_filename[MaxTextLength];      FILE
     *file;     Image      *image;      register int     i;     register unsigned char     *p;      /*     Open temporary output file.    */#   TemporaryFilename(logo_filename);     file=fopen(logo_filename,"w");   if (file == (FILE *) NULL)     { 4       Warning("Unable to write file",logo_filename);&       return(ReadXCImage(image_info));     }    p=LogoImage;%   for (i=0; i < LogoImageLength; i++)    { !     (void) fputc((char) *p,file);      p++;   }    if (ferror(file))      { E       Warning("An error has occurred writing to file",logo_filename);        (void) fclose(file);#       (void) unlink(logo_filename); &       return(ReadXCImage(image_info));     }    (void) fclose(file);    filename=image_info->filename;%   image_info->filename=logo_filename; "   image=ReadMIFFImage(image_info);    image_info->filename=filename;   if (image != (Image *) NULL)8     (void) strcpy(image->filename,image_info->filename);   (void) unlink(logo_filename);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadMAPImage reads an image of raw RGB colormap and colormap indexM %  bytes and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadMAPImage routine is:  % % %      image=ReadMAPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMAPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadMAPImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int      colors;      register int     i;     register unsigned char     *p;      unsigned char      *colormap;     unsigned int     height,      packet_size,     status, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*D     Determine width, height, and number of colors, e.g. 640x512+256.   */   width=512;
   height=512; 
   colors=256; (   if (image_info->size != (char *) NULL)K     (void) XParseGeometry(image_info->size,&colors,&colors,&width,&height);    /*     Initialize image structure.    */   image->class=PseudoClass; #   image->compression=NoCompression;    image->columns=width;    image->rows=height;    image->colors=colors; ,   image->packets=image->columns*image->rows;   packet_size=1;   if (image->colors > 256)     packet_size++;K   colormap=(unsigned char *) malloc(3*image->colors*sizeof(unsigned char)); L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));(   image->packed_pixels=(unsigned char *)=     malloc(image->packets*packet_size*sizeof(unsigned char)); -   if ((colormap == (unsigned char *) NULL) || 2       (image->colormap == (ColorPacket *) NULL) ||7       (image->packed_pixels == (unsigned char *) NULL))      { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*     Read image colormap.   */A   (void) ReadData((char *) colormap,3,image->colors,image->file); 
   p=colormap; #   for (i=0; i < image->colors; i++)    { "     image->colormap[i].red=(*p++);$     image->colormap[i].green=(*p++);#     image->colormap[i].blue=(*p++);    }    free((char *) colormap);   /*6     Convert raster image to runlength-encoded packets.   */K   (void) ReadData((char *) image->packed_pixels,packet_size,image->packets,      image->file); %   status=RunlengthDecodeImage(image);    if (status == False)     {        DestroyImages(image);        return((Image *) NULL);      }    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A T T E I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadMATTEImage reads an image of raw matte bytes and returns it.N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % / %  The format of the ReadMATTEImage routine is:  % ' %      image=ReadMATTEImage(image_info)  % + %  A description of each parameter follows:  % K %    o image:  Function ReadMATTEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */( static Image *ReadMATTEImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char
     index,     *p;      unsigned char      *matte_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize image structure.    */   image->matte=True;   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;N   matte_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 1   if ((matte_pixels == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*6     Convert raster image to runlength-encoded packets.   */F   (void) ReadData((char *) matte_pixels,1,image->packets,image->file);   p=matte_pixels;    q=image->pixels;$   for (i=0; i < image->packets; i++)   {      index=(*p++); 
     q->red=0;      q->green=0;      q->blue=0;$     q->index=(unsigned short) index;     q->length=0;     q++;   }    free((char *) matte_pixels);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d M I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMIFFImage reads a MIFF image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMIFFImage routine is: % $ %      image=ReadMIFFImage(filename) % + %  A description of each parameter follows:  % I %    o image: Function ReadMIFFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadMIFFImage(image_info) 	 ImageInfo    *image_info; {    char     keyword[MaxTextLength],      value[MaxTextLength];      Image      *image;      register int     c,     i;     register unsigned char     *p;      unsigned int     length,      packet_size,     status;      unsigned long 
     count,     packets;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*G     Decode image header;  header terminates one character beyond a ':'.    */   c=fgetc(image->file);    if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    do   {      /*I       Decode image header;  header terminates one character beyond a ':'.      */%     image->compression=NoCompression; $     while (isgraph(c) && (c != ':'))     {        register char          *p;          if (c == '{') 	         {            /*0             Read comment-- any text between { }.           *//           if (image->comments != (char *) NULL) 
             { -               length=strlen(image->comments); '               p=image->comments+length; 
             }            else
             { #               length=MaxTextLength; C               image->comments=(char *) malloc(length*sizeof(char));                 p=image->comments;
             } 8           for ( ; image->comments != (char *) NULL; p++)           { !             c=fgetc(image->file); )             if ((c == EOF) || (c == '}'))                break;0             if ((p-image->comments+1) >= length)               {                  *p='\0';                 length<<=1; (                 image->comments=(char *)H                   realloc((char *) image->comments,length*sizeof(char));5                 if (image->comments == (char *) NULL)                    break;:                 p=image->comments+strlen(image->comments);               } !             *p=(unsigned char) c;            } /           if (image->comments == (char *) NULL) 
             { I               Warning("Unable to read image","Memory allocation failed"); #               DestroyImages(image); %               return((Image *) NULL); 
             }            *p='\0';           c=fgetc(image->file); 	         } 
       else         if (isalnum(c))            {              /*0               Determine a keyword and its value.             */             p=keyword;             do
             { 2               if ((p-keyword) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); !             } while (isalnum(c));              *p='\0';,             while (isspace(c) || (c == '='))#               c=fgetc(image->file);              p=value;-             while (!isspace(c) && (c != EOF)) 
             { 0               if ((p-value) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); 
             }              *p='\0';             /*6               Assign a value to the specified keyword.             */-             if (strcmp(keyword,"class") == 0) 3               if (strcmp(value,"PseudoClass") == 0) )                 image->class=PseudoClass;                else5                 if (strcmp(value,"DirectClass") == 0) +                   image->class=DirectClass;                  else.                   image->class=UndefinedClass;.             if (strcmp(keyword,"colors") == 0)7               image->colors=(unsigned int) atoi(value); 3             if (strcmp(keyword,"compression") == 0) 0               if (strcmp(value,"QEncoded") == 0)7                 image->compression=QEncodedCompression;                else:                 if (strcmp(value,"RunlengthEncoded") == 0)A                   image->compression=RunlengthEncodedCompression;                  else:                   image->compression=UndefinedCompression;/             if (strcmp(keyword,"columns") == 0) 8               image->columns=(unsigned int) atoi(value);*             if (strcmp(keyword,"id") == 0)3               if (strcmp(value,"ImageMagick") == 0) (                 image->id=ImageMagickId;               else&                 image->id=UndefinedId;1             if ((strcmp(keyword,"matte") == 0) || /                 (strcmp(keyword,"alpha") == 0)) M               if ((strcmp(value,"True") == 0) || (strcmp(value,"true") == 0)) "                 image->matte=True;               else#                 image->matte=False; /             if (strcmp(keyword,"montage") == 0)                { M                 image->montage=(char *) malloc(strlen(value)+1*sizeof(char)); 4                 if (image->montage == (char *) NULL)                   { O                     Warning("Unable to read image","Memory allocation failed"); )                     DestroyImages(image); +                     return((Image *) NULL);                    } 4                 (void) strcpy(image->montage,value);               } /             if (strcmp(keyword,"packets") == 0) 8               image->packets=(unsigned int) atoi(value);,             if (strcmp(keyword,"rows") == 0)5               image->rows=(unsigned int) atoi(value); -             if (strcmp(keyword,"scene") == 0) 6               image->scene=(unsigned int) atoi(value);1             if (strcmp(keyword,"signature") == 0)                { )                 image->signature=(char *) 9                   malloc((strlen(value)+1)*sizeof(char)); 6                 if (image->signature == (char *) NULL)                   { O                     Warning("Unable to read image","Memory allocation failed"); )                     DestroyImages(image); +                     return((Image *) NULL);                    } 6                 (void) strcpy(image->signature,value);               }            }          else           c=fgetc(image->file);        while (isspace(c))         c=fgetc(image->file);      }      (void) fgetc(image->file);     /*8       Verify that required image information is defined.     */I     if ((image->id == UndefinedId) || (image->class == UndefinedClass) || P         (image->compression == UndefinedCompression) || (image->columns == 0) ||         (image->rows == 0))        { B         Warning("Incorrect image header in file",image->filename);         DestroyImages(image);          return((Image *) NULL);        } 4     if ((image->columns*image->rows) > MaxImageSize)       { ?         Warning("Unable to read image","image size too large");          DestroyImages(image);          return((Image *) NULL);        } (     if (image->montage != (char *) NULL)       {          register char 
           *p;   
         /*           Image directory.
         */E         image->directory=(char *) malloc(MaxTextLength*sizeof(char)); .         if (image->directory == (char *) NULL)           { G             Warning("Unable to read image","Memory allocation failed"); !             DestroyImages(image); #             return((Image *) NULL);            }          p=image->directory; 
         do	         { H           if ((((int) strlen(image->directory)+1) % MaxTextLength) == 0)
             {                /*=                 Allocate more memory for the image directory.                */               *p='\0';J               image->directory=(char *) realloc((char *) image->directory,I                 (strlen(image->directory)+MaxTextLength+1)*sizeof(char)); 4               if (image->directory == (char *) NULL)                 { M                   Warning("Unable to read image","Memory allocation failed"); '                   DestroyImages(image); )                   return((Image *) NULL);                  } :               p=image->directory+strlen(image->directory);
             }            c=fgetc(image->file); !           *p++=(unsigned char) c;          } while (c != '\0');       } $     if (image->class == PseudoClass)       {          unsigned int           colors;   
         /*B           PseudoClass image cannot have matte data or be QEncoded.
         */         if (image->matte)            { O             Warning("Unable to read image","matte images must be DirectClass"); !             DestroyImages(image); #             return((Image *) NULL);            } 6         if (image->compression == QEncodedCompression)           { +             Warning("Unable to read image", 5               "QEncoded images must be DirectClass"); !             DestroyImages(image); #             return((Image *) NULL);            } 
         /*            Create image colormap.
         */         colors=image->colors;          if (colors == 0)           colors=256; K         image->colormap=(ColorPacket *) malloc(colors*sizeof(ColorPacket)); 4         if (image->colormap == (ColorPacket *) NULL)           { G             Warning("Unable to read image","Memory allocation failed"); !             DestroyImages(image); #             return((Image *) NULL);            }          if (image->colors == 0) $           for (i=0; i < colors; i++)           { 5             image->colormap[i].red=(unsigned char) i; 7             image->colormap[i].green=(unsigned char) i; 6             image->colormap[i].blue=(unsigned char) i;             image->colors++;           }          else           {              unsigned char                *colormap;               /*,               Read image colormap from file.             */&             colormap=(unsigned char *)<               malloc(3*image->colors*sizeof(unsigned char));3             if (colormap == (unsigned char *) NULL)                { K                 Warning("Unable to read image","Memory allocation failed"); %                 DestroyImages(image); '                 return((Image *) NULL);                } M             (void) ReadData((char *) colormap,1,3*image->colors,image->file);              p=colormap; -             for (i=0; i < image->colors; i++) 
             { ,               image->colormap[i].red=(*p++);.               image->colormap[i].green=(*p++);-               image->colormap[i].blue=(*p++); 
             } $             free((char *) colormap);           }        }      /*#       Determine packed packet size.      */$     if (image->class == PseudoClass)       {          image->packet_size=1;           if (image->colors > 256)           image->packet_size++;        }      else       {          image->packet_size=3;          if (image->matte)            image->packet_size++;        } :     if (image->compression == RunlengthEncodedCompression)       image->packet_size++; #     packet_size=image->packet_size; 2     if (image->compression == QEncodedCompression)       packet_size=1;     /*       Allocate image pixels.     */,     if (image->compression == NoCompression)0       image->packets=image->columns*image->rows;     packets=image->packets;      if (image->packets == 0))       packets=image->columns*image->rows; *     image->packed_pixels=(unsigned char *)G       malloc((unsigned int) packets*packet_size*sizeof(unsigned char)); 7     if (image->packed_pixels == (unsigned char *) NULL)        { C         Warning("Unable to read image","Memory allocation failed");          DestroyImages(image);          return((Image *) NULL);        }      /*"       Read image pixels from file.     */>     if ((image->compression != RunlengthEncodedCompression) ||         (image->packets != 0))D       (void) ReadData((char *) image->packed_pixels,1,(unsigned int))         packets*packet_size,image->file);      else       { 
         /*5           Number of runlength packets is unspecified. 
         */         count=0;         p=image->packed_pixels; 
         do	         { @           (void) ReadData((char *) p,1,packet_size,image->file);           image->packets++;            p+=(packet_size-1);            count+=(*p+1);           p++;	         } 5         while (count < (image->columns*image->rows));        } 3     if (image->compression ==  QEncodedCompression)        {          unsigned char            *compressed_pixels;   
         /*2           Uncompress image pixels with Q encoding.
         */2         image->packets=image->columns*image->rows;/         compressed_pixels=image->packed_pixels; D         image->packed_pixels=(unsigned char *) malloc((unsigned int)C           image->packets*image->packet_size*sizeof(unsigned char)); ;         if (image->packed_pixels == (unsigned char *) NULL)            { H             Warning("Unable to write image","Memory allocation failed");              DestroyImage(image);#             return((Image *) NULL);            } D         packets=QDecodeImage(compressed_pixels,image->packed_pixels,?           image->columns*(int) image->packet_size,image->rows); ;         if (packets != (image->packets*image->packet_size))            { 9             Warning("Q encoding failed",image->filename); !             DestroyImages(image); #             return((Image *) NULL);            } )         free((char *) compressed_pixels);        }      /*J       Unpack the packed image pixels into runlength-encoded pixel packets.     */'     status=RunlengthDecodeImage(image);      if (status == False)       {          DestroyImages(image);          return((Image *) NULL);        }      /*       Proceed to next image.     */     do     {        c=fgetc(image->file); (     } while (!isgraph(c) && (c != EOF));     if (c != EOF)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (c != EOF); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #ifdef HasMPEG #undef BitmapPad #include "mpeg.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMPEGImage reads a MPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMPEGImage routine is: % & %      image=ReadMPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadMPEGImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadMPEGImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      ImageDesc      mpeg_info;     register int     i;     register unsigned char     *p;      register RunlengthPacket     *q;      unsigned char      *mpeg_pixels;      unsigned int     status;      unsigned long      lsb_first;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Allocate MPEG pixels.    */*   (void) OpenMPEG(image->file,&mpeg_info);M   mpeg_pixels=(unsigned char *) malloc(mpeg_info.Size*sizeof(unsigned char)); ,   if (mpeg_pixels == (unsigned char *) NULL)     { A       Warning("Unable to read image","Memory allocation failed");        DestroyImages(image);        return((Image *) NULL);      }    /*     Read MPEG image.   */,   status=GetMPEGFrame((char *) mpeg_pixels);   if (status == False)     { 4       Warning("Corrupt MPEG image",image->filename);       DestroyImage(image);       return((Image *) NULL);      }    while (status == True)   {      /*!       Initialize image structure.      */#     image->columns=mpeg_info.Width; #     image->rows=mpeg_info.Height-8; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { C         Warning("Unable to read image","Memory allocation failed");          DestroyImages(image);          return((Image *) NULL);        }      /*=       Convert MPEG raster image to runlength-encoded packets.      */     p=mpeg_pixels;     q=image->pixels;     lsb_first=1;     if (*(char *) &lsb_first) (       for (i=0; i < image->packets; i++)       {          q->red=(*p++);         q->green=(*p++);         q->blue=(*p++);          q->length=0;         p++;         q++;       }      else(       for (i=0; i < image->packets; i++)       {          p++;         q->blue=(*p++);          q->green=(*p++);         q->red=(*p++);         q->length=0;         q++;       }      if (image_info->verbose)       DescribeImage(image); .     status=GetMPEGFrame((char *) mpeg_pixels);     if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    }    free((char *) mpeg_pixels); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #else ' static Image *ReadMPEGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("MPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M T V I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadMTVImage reads a MTV image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % - %  The format of the ReadMTVImage routine is:  % % %      image=ReadMTVImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMTVImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadMTVImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int 
     count;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *mtv_pixels;     unsigned int     columns,	     rows;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Read MTV image.    */5   count=fscanf(image->file,"%u %u\n",&columns,&rows);    if (count == 0)      { 2       Warning("Not a MTV image,",image->filename);       DestroyImage(image);       return((Image *) NULL);      }    do   {      /*!       Initialize image structure.      */     image->columns=columns;      image->rows=rows; .     image->packets=image->columns*image->rows;P     mtv_pixels=(unsigned char *) malloc(3*image->packets*sizeof(unsigned char));%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 1     if ((mtv_pixels == (unsigned char *) NULL) || 4         (image->pixels == (RunlengthPacket *) NULL))       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*<       Convert MTV raster image to runlength-encoded packets.     */F     (void) ReadData((char *) mtv_pixels,3,image->packets,image->file);     p=mtv_pixels;      q=image->pixels;&     for (i=0; i < image->packets; i++)     {        q->red=(*p++);       q->green=(*p++);       q->blue=(*p++);        q->index=0;        q->length=0;
       q++;     }      free((char *) mtv_pixels);     /*       Proceed to next image.     */7     count=fscanf(image->file,"%u %u\n",&columns,&rows);      if (count > 0)       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (count > 0);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d N U L L I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadNULLImage reads a NULL image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadNULLImage routine is: % & %      image=ReadNULLImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadNULLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadNULLImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;   :   Warning("Cannot read NULL images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d P C D I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadPCDImage reads a Photo CD image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a F %  pointer to the new image.  Much of the PCD decoder was derived from. %  the program hpcdtoppm(1) by Hadmut Danisch. % - %  The format of the ReadPCDImage routine is:  % % %      image=ReadPCDImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPCDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  ; static Image *OverviewImage(image_info,image,number_images) 	 ImageInfo    *image_info;   Image 	   *image;    unsigned int   number_images; {  #define ClientName  "montage"      char     *resource_value;  	   Display 
     *display;      Image 
     **images;      register int     i,     j;     XMontageInfo     montage_info;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return((Image *) NULL);      }    /*     Allocate images array.   */:   images=(Image **) malloc(number_images*sizeof(Image *));    if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);        return((Image *) NULL);      }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);@   XGetResourceInfo(resource_database,ClientName,&resource_info);H   resource_info.background_color=XGetResourceInstance(resource_database,3     ClientName,"background",DefaultTileBackground); N   resource_value=XGetResourceClass(resource_database,ClientName,"borderWidth",     DefaultTileBorderwidth);2   resource_info.border_width=atoi(resource_value);&   resource_info.font=image_info->font;H   resource_info.foreground_color=XGetResourceInstance(resource_database,3     ClientName,"foreground",DefaultTileForeground); F   resource_info.image_geometry=XGetResourceInstance(resource_database,4     ClientName,"imageGeometry",DefaultTileGeometry);N   resource_info.matte_color=XGetResourceInstance(resource_database,ClientName,#     "mattecolor",DefaultTileMatte); !   XGetMontageInfo(&montage_info); *   montage_info.number_tiles=number_images;   /*/     Read each image and convert them to a tile.    */   j=0;#   for (i=0; i < number_images; i++)    {      LabelImage(image,"%f"); F     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)       DescribeImage(image);      images[j]=image;     image=image->next;     j++;   }    /*"     Create the PCD Overview image.   */%   if (montage_info.number_tiles != 0) =     image=XMontageImage(display,&resource_info,&montage_info, #       image_info->filename,images);    XCloseDisplay(display);    free((char *) images);   if (image == (Image *) NULL)     { F       Warning("PCD Overview translation failed",image_info->filename);       return((Image *) NULL);      }    return(image); }   & static Image *ReadPCDImage(image_info)	 ImageInfo    *image_info; {    Image      *image;   
   long int     offset;      register int     i;     register RunlengthPacket     *p;      register unsigned char     *c1,     *c2,     *y;      unsigned char 
     *chroma1, 
     *chroma2,      *header,
     *luma;     unsigned int     height, 
     overview,      rotate,      status, 
     subimage, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*$     Determine if this is a PCD file.   */A   header=(unsigned char *) malloc(3*0x800*sizeof(unsigned char)); '   if (header == (unsigned char *) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      } 9   status=ReadData((char *) header,1,3*0x800,image->file); 5   overview=strncmp((char *) header,"PCD_OPA",7) == 0;    if ((status == False) ||C       ((strncmp((char *) header+0x800,"PCD",3) != 0) && !overview))      { 4       Warning("Not a PCD image file",(char *) NULL);       DestroyImages(image);        return((Image *) NULL);      }    rotate=header[0x0e02] & 0x03;    free((char *) header);
   subimage=3;     if (image_info->subimage != 0)"     subimage=image_info->subimage;(   if (image_info->size != (char *) NULL)     { 	       int 
         x,
         y;         /*.         Determine which image size to extract.       */       width=768;       height=512; C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height); 1       for (subimage=1; subimage <= 6; subimage++)        { .         if ((width <= 192) && (height <= 128))           break;         width>>=1;         height>>=1;        }      }    if (overview)      subimage=1;    /*     Initialize image structure.    */   width=192;
   height=128; %   for (i=1; i < Min(subimage,3); i++)    {      width<<=1;     height<<=1;    }    image->columns=width;    image->rows=height;    for ( ; i < subimage; i++)   {      image->columns<<=1;      image->rows<<=1;   }    /*$     Allocate luma and chroma memory.   */,   image->packets=image->columns*image->rows;I   chroma1=(unsigned char *) malloc(image->packets*sizeof(unsigned char)); I   chroma2=(unsigned char *) malloc(image->packets*sizeof(unsigned char)); F   luma=(unsigned char *) malloc(image->packets*sizeof(unsigned char));,   if ((chroma1 == (unsigned char *) NULL) ||N       (chroma2 == (unsigned char *) NULL) || (luma == (unsigned char *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*     Advance to image data.   */   offset=93;   if (overview) 
     offset=2;    else     if (subimage == 2)       offset=20;     else       if (subimage == 1)         offset=1; $   for (i=0; i < (offset*0x800); i++)     (void) fgetc(image->file);   if (overview)      {        Image          *overview_image;         register int
         j;         unsigned int         number_images;         /*,         Read thumbnails from overview image.       */3       number_images=(header[10] << 8) | header[11]; (       for (j=1; j <= number_images; j++)       { 8         (void) sprintf(image->filename,"img%04d.pcd",j);         image->scene=j;          image->columns=width;          image->rows=height; 2         image->packets=image->columns*image->rows;)         image->pixels=(RunlengthPacket *) 9           malloc(image->packets*sizeof(RunlengthPacket)); 6         if (image->pixels == (RunlengthPacket *) NULL)           { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            }          y=luma;          c1=chroma1;          c2=chroma2; #         for (i=0; i < height; i+=2) 	         { :           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;@           (void) ReadData((char *) c1,1,width >> 1,image->file);           c1+=image->columns; @           (void) ReadData((char *) c2,1,width >> 1,image->file);           c2+=image->columns; 	         } N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);
         /*6           Transfer luminance and chrominance channels.
         */         p=image->pixels;         y=luma;          c1=chroma1;          c2=chroma2; *         for (i=0; i < image->packets; i++)	         {            p->red=(*y++);           p->green=(*c1++);            p->blue=(*c2++);           p->index=0;            p->length=0;           p++;	         } /         TransformRGBImage(image,YCCColorspace);          if (j < number_images)           {              /*'               Allocate image structure.              */2             image->next=AllocateImage(image_info);.             if (image->next == (Image *) NULL)               { %                 DestroyImages(image); '                 return((Image *) NULL);                } *             image->next->file=image->file;(             image->next->previous=image;             image=image->next;           }        }        free(chroma2);       free(chroma1);       free(luma); /       while (image->previous != (Image *) NULL)          image=image->previous;       CloseImage(image);C       overview_image=OverviewImage(image_info,image,number_images);        return(overview_image);      }    /*     Allocate image pixels.   */#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImages(image);        return((Image *) NULL);      }    /*     Read interleaved image.    */	   y=luma; 
   c1=chroma1; 
   c2=chroma2;    for (i=0; i < height; i+=2)    { 4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;:     (void) ReadData((char *) c1,1,width >> 1,image->file);     c1+=image->columns; :     (void) ReadData((char *) c2,1,width >> 1,image->file);     c2+=image->columns;    }    if (subimage >= 4)     {        /*5         Recover luminance deltas for 1536x1024 image.        */,       Upsample(768,512,image->columns,luma);/       Upsample(384,256,image->columns,chroma1); /       Upsample(384,256,image->columns,chroma2);        image->rows=1024; #       for (i=0; i < (4*0x800); i++) "         (void) fgetc(image->file);8       status=PCDDecodeImage(image,luma,chroma1,chroma2);$       if ((subimage >= 5) && status)	         {            /*9             Recover luminance deltas for 3072x2048 image.            */2           Upsample(1536,1024,image->columns,luma);3           Upsample(768,512,image->columns,chroma1); 3           Upsample(768,512,image->columns,chroma2);            image->rows=2048; -           offset=ftell(image->file)/0x800+12; 3           (void) fseek(image->file,offset*0x800,0); <           (void) PCDDecodeImage(image,luma,chroma1,chroma2);	         }      } H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);   /*0     Transfer luminance and chrominance channels.   */   p=image->pixels;	   y=luma; 
   c1=chroma1; 
   c2=chroma2; $   for (i=0; i < image->packets; i++)   {      p->red=(*y++);     p->green=(*c1++);      p->blue=(*c2++);     p->index=0;      p->length=0;     p++;   }    free(chroma2);   free(chroma1);
   free(luma); )   TransformRGBImage(image,YCCColorspace); %   if ((rotate == 1) || (rotate == 3))      {        double         degrees;         Image          *rotated_image;          /*         Rotate image.        */)       degrees=rotate == 1 ? -90.0 : 90.0;        image->orphan=True; J       rotated_image=RotateImage(image,degrees,(ColorPacket *) NULL,False);       image->orphan=False;*       if (rotated_image != (Image *) NULL)	         {            DestroyImage(image);           image=rotated_image;	         }      }    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d P C X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadPCXImage reads a ZSoft IBM PC Paintbrush file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % - %  The format of the ReadPCXImage routine is:  % % %      image=ReadPCXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPCXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadPCXImage(image_info)	 ImageInfo    *image_info; {    typedef struct _PCXHeader    {      unsigned char        identifier,        version,       encoding,        bits_per_pixel;   
     short int        left, 
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int        bytes_per_line,        palette_info;        unsigned char        colormap_signature;    } PCXHeader;     PCXHeader      pcx_header;      Image      *image;      int 
     count,     packets;     register int     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      packet,      *pcx_colormap,     *pcx_pixels;     unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*$     Determine if this is a PCX file.   */C   status=ReadData((char *) &pcx_header.identifier,1,1,image->file);    do   {      /*       Verify PCX identifier.     */=     if ((status == False) || (pcx_header.identifier != 0x0a))        { 6         Warning("Not a PCX image file",(char *) NULL);         DestroyImages(image);          return((Image *) NULL);        } B     (void) ReadData((char *) &pcx_header.version,1,1,image->file);C     (void) ReadData((char *) &pcx_header.encoding,1,1,image->file); I     (void) ReadData((char *) &pcx_header.bits_per_pixel,1,1,image->file); 3     pcx_header.left=LSBFirstReadShort(image->file); 2     pcx_header.top=LSBFirstReadShort(image->file);4     pcx_header.right=LSBFirstReadShort(image->file);5     pcx_header.bottom=LSBFirstReadShort(image->file); D     pcx_header.horizontal_resolution=LSBFirstReadShort(image->file);B     pcx_header.vertical_resolution=LSBFirstReadShort(image->file);     /*       Read PCX raster colormap.      */8     image->columns=(pcx_header.right-pcx_header.left)+1;5     image->rows=(pcx_header.bottom-pcx_header.top)+1;      image->class=PseudoClass;      image->colors=16; D     image->colormap=(ColorPacket *) malloc(256*sizeof(ColorPacket));G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); 4     if ((image->colormap == (ColorPacket *) NULL) ||1         (pcx_colormap == (unsigned char *) NULL))        { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        } G     (void) ReadData((char *) pcx_colormap,3,image->colors,image->file);      p=pcx_colormap; %     for (i=0; i < image->colors; i++)      { $       image->colormap[i].red=(*p++);&       image->colormap[i].green=(*p++);%       image->colormap[i].blue=(*p++);      } C     (void) ReadData((char *) &pcx_header.reserved,1,1,image->file); A     (void) ReadData((char *) &pcx_header.planes,1,1,image->file); =     pcx_header.bytes_per_line=LSBFirstReadShort(image->file); ;     pcx_header.palette_info=LSBFirstReadShort(image->file);      for (i=0; i < 58; i++)        (void) fgetc(image->file);     /*       Read image data.     */D     packets=image->rows*pcx_header.bytes_per_line*pcx_header.planes;G     pcx_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); -     if (pcx_pixels == (unsigned char *) NULL)        { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*       Uncompress image data.     */     p=pcx_pixels;      while (packets > 0)      {         packet=fgetc(image->file);"       if ((packet & 0xc0) != 0xc0)	         {            *p++=packet;           packets--;           continue; 	         }        count=packet & 0x3f;        packet=fgetc(image->file);       packets-=count;        while (--count >= 0)         *p++=packet;     } E     image->colors=1 << (pcx_header.bits_per_pixel*pcx_header.planes);      if (image->colors > 256)       { I         Warning("PCX colormap exceeded 256 colors",image_info->filename);          DestroyImages(image);%         return((Image *) NULL);%       }%     if (image->colors > 16)        { 
         /*G           256 color images have their color map at the end of the file. 
         */D         (void) ReadData((char *) &pcx_header.colormap_signature,1,1,           image->file); K         (void) ReadData((char *) pcx_colormap,3,image->colors,image->file);          p=pcx_colormap; )         for (i=0; i < image->colors; i++)O	         { (           image->colormap[i].red=(*p++);*           image->colormap[i].green=(*p++);)           image->colormap[i].blue=(*p++); 	         }        }O     else       if (image->colors == 2) K         if (Intensity(image->colormap[0]) == Intensity(image->colormap[1]))            {              /*"               Monochrome colormap.             */*             image->colormap[0].red=MaxRGB;,             image->colormap[0].green=MaxRGB;+             image->colormap[0].blue=MaxRGB; %             image->colormap[1].red=0; '             image->colormap[1].green=0; &             image->colormap[1].blue=0;           }       free((char *) pcx_colormap);     /*!       Initialize image structure.      */.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)t5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { @         Warning("Memory allocation error",image_info->filename);         DestroyImages(image);          return((Image *) NULL);        }      /*<       Convert PCX raster image to runlength-encoded packets.     */     q=image->pixels;     if (pcx_header.planes > 1)       {u         register int           bits,            mask;   
         /*C           Convert multi-plane format into runlength-encoded pixels.P
         */*         for (i=0; i < image->packets; i++)	         {a           q->index=0;n           q->length=0;           q++;	         }e'         for (y=0; y < image->rows; y++)e	         {nG           p=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes); 5           for (i=0; i < (int) pcx_header.planes; i++)s           {u-             q=image->pixels+y*image->columns;e9             for (x=0; x < pcx_header.bytes_per_line; x++)r
             {a               bits=(*p++);2               for (mask=0x80; mask != 0; mask>>=1)               {                   if (bits & mask)#                   q->index|=1 << i;r                 q++;               }y
             }r           }p	         }        }      else%       for (y=0; y < image->rows; y++)n       { 1         p=pcx_pixels+y*pcx_header.bytes_per_line; *         switch (pcx_header.bits_per_pixel)	         {            case 1:d           {              register int               bit;  3             for (x=0; x < (image->columns-7); x+=8)e
             {i*               for (bit=7; bit >= 0; bit--)               { >                 q->index=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 q->length=0;                 q++;               }e               p++;
             }a*             if ((image->columns % 8) != 0)               {iC                 for (bit=7; bit >= (8-(image->columns % 8)); bit--)c                 {r@                   q->index=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   q->length=0;                   q++;                 }%                 p++;               }%             break;           }t           case 2:y           {n3             for (x=0; x < (image->columns-3); x+=4)o
             { '               q->index=(*p >> 6) & 0x3;                q->length=0;               q++;'               q->index=(*p >> 4) & 0x3;i               q->length=0;               q++;'               q->index=(*p >> 2) & 0x3;I               q->length=0;               q++;"               q->index=(*p) & 0x3;               q->length=0;               q++;               p++;
             }o*             if ((image->columns % 4) != 0)               {%=                 for (i=3; i >= (4-(image->columns % 4)); i--)                  { 0                   q->index=(*p >> (i*2)) & 0x03;                   q->length=0;                   q++;                 }                  p++;               }              break;           }            case 4:a           { 3             for (x=0; x < (image->columns-1); x+=2) 
             { '               q->index=(*p >> 4) & 0xf;                q->length=0;               q++;"               q->index=(*p) & 0xf;               q->length=0;               q++;               p++;
             } *             if ((image->columns % 2) != 0)               {%)                 q->index=(*p >> 4) & 0xf;t                 q->length=0;                 q++;                 p++;               }e             break;           }            case 8:p           { .             for (x=0; x < image->columns; x++)
             {                q->index=(*p);               q->length=0;               q++;               p++;
             }F             break;           }i           default:             break;	         }a       }u     free((char *) pcx_pixels);     SyncImage(image);i     /*       Proceed to next image.     */E     status=ReadData((char *) &pcx_header.identifier,1,1,image->file);e<     if ((status == True) && (pcx_header.identifier == 0x0a))       {t
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }dB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }.@   } while ((status == True) && (pcx_header.identifier == 0x0a));+   while (image->previous != (Image *) NULL)i     image=image->previous;   CloseImage(image);   return(image); }  N /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %)O %                                                                             %eO %                                                                             %aO %  R e a d P I C T I m a g e                                                  %aO %                                                                             %*O %                                                                             %iO %                                                                             %*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadPICTImage reads an Apple Macintosh QuickDraw/PICT image fileG %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. %o. %  The format of the ReadPICTImage routine is: %.& %      image=ReadPICTImage(image_info) %p+ %  A description of each parameter follows:v %iJ %    o image:  Function ReadPICTImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %-A %    o image_info: Specifies a pointer to an ImageInfo structure.  %t %R */' static Image *ReadPICTImage(image_info) 	 ImageInfoe   *image_info; {-   char     filename[MaxTextLength];     Image      *image,      *next_image;     /*     Allocate image structure.-   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)(     {n5       Warning("Unable to open file",image->filename);x       DestroyImage(image);       return((Image *) NULL);n     }    CloseImage(image);   DestroyImage(image);   /*2     Use picttoppm to convert Macintosh PICT image.   *//   (void) strcpy(filename,image_info->filename);=@   (void) sprintf(image_info->filename,"|picttoppm %s",filename);!   image=ReadPNMImage(image_info);%   if (image == (Image *) NULL)     {%>       Warning("PICT translation failed",image_info->filename);       return((Image *) NULL);      }    /*     Assign proper filename.    */   do   { ,     (void) strcpy(image->filename,filename);     next_image=image->next; %     if (next_image != (Image *) NULL)I       image=next_image; )   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             %eO %                                                                             %eO %  R e a d P N M I m a g e                                                    %eO %                                                                             %aO %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %gK %  Function ReadPNMImage reads a Portable Anymap image file and returns it.oL %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %t- %  The format of the ReadPNMImage routine is:i %s% %      image=ReadPNMImage(image_info)v %2+ %  A description of each parameter follows:  % I %    o image:  Function ReadPNMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.M %a %  */* static unsigned int PNMInteger(image,base) Imaget	   *image;    unsigned int   base;  {    inti     c;     unsigned int
     value;     /*      Skip any leading whitespace.   */   do   {p     c=fgetc(image->file);      if (c == EOF)        return(0);     if (c == '#')        {          register chari
           *p;            unsigned int           length;   
         /*           Read comment.u
         */-         if (image->comments != (char *) NULL)p           {,+             length=strlen(image->comments); %             p=image->comments+length;i           }l         else           {e!             length=MaxTextLength;LA             image->comments=(char *) malloc(length*sizeof(char));t             p=image->comments;           })6         for ( ; image->comments != (char *) NULL; p++)	         {f.           if ((p-image->comments+2) >= length)
             {                *p='\0';               length<<=1;h&               image->comments=(char *)F                 realloc((char *) image->comments,length*sizeof(char));3               if (image->comments == (char *) NULL)s                 break;8               p=image->comments+strlen(image->comments);
             }e           c=fgetc(image->file);B(           if ((c == EOF) || (c == '\n'))             break;           *p=(unsigned char) c;e	         }=-         if (image->comments == (char *) NULL)i           { =             Warning("Memory allocation error",(char *) NULL);S             return(0);           }r         *p++='\n';         *p='\0';       }-   } while (!isdigit(c));   if (base == 2)     return(c-'0');   /*     Evaluate number.   */
   value=0;   do   {e     value*=10;     value+=c-'0';_     c=fgetc(image->file);d     if (c == EOF)        return(0);   }e   while (isdigit(c));    return(value); }   & static Image *ReadPNMImage(image_info)	 ImageInfo    *image_info; {m   char     format;s     Imagem     *image;      register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;m     unsigned char      *pixels,     *scale;i     unsigned int     max_value,     status;c     /*     Allocate image structure.)   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)d     {e5       Warning("Unable to open file",image->filename);e       DestroyImage(image);       return((Image *) NULL);      }i   /*     Read PNM image.i   */4   status=ReadData((char *) &format,1,1,image->file);   do   {m     /*       Verify PNM identifier.     */-     if ((status == False) || (format != 'P'))        {d6         Warning("Not a PNM image file",(char *) NULL);         DestroyImage(image);         return((Image *) NULL);d       }      /*!       Initialize image structure.o     */     format=fgetc(image->file);     if (format == '7')"       (void) PNMInteger(image,10);(     image->columns=PNMInteger(image,10);%     image->rows=PNMInteger(image,10);(.     image->packets=image->columns*image->rows;     if (image->packets == 0)       { D         Warning("Unable to read image","image dimensions are zero");         return((Image *) NULL);,       }N%     image->pixels=(RunlengthPacket *))5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { 9         Warning("Memory allocation error",(char *) NULL);p         DestroyImages(image);l         return((Image *) NULL);        }m+     if ((format == '1') || (format == '4'))l        max_value=1;  /* bitmap */     else%       max_value=PNMInteger(image,10);-!     scale=(unsigned char *) NULL;      if (max_value != MaxRGB)       { 
         /*&           Compute pixel scaling table.
         */L         scale=(unsigned char *) malloc((max_value+1)*sizeof(unsigned char));,         if (scale == (unsigned char *) NULL)           {dG             Warning("Unable to read image","Memory allocation failed");*!             DestroyImages(image);n#             return((Image *) NULL);e           }s&         for (i=0; i <= max_value; i++)K           scale[i]=(unsigned char) ((i*MaxRGB+(max_value >> 1))/max_value);r       } +     if ((format != '3') && (format != '6'))        {u
         /*           Create colormap.
         */!         image->class=PseudoClass;b.         image->colors=Min(max_value,MaxRGB)+1;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL)           {)=             Warning("Memory allocation error",(char *) NULL);r!             DestroyImages(image);i#             return((Image *) NULL);            }          if (format != '7')+           for (i=0; i < image->colors; i++)=           {(@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);            }          else           {g             int                blue,                green,               red;               /*&               Initialize 332 colormap.             */             i=0;'             for (red=0; red < 8; red++)(/               for (green=0; green < 8; green++)p.                 for (blue=0; blue < 4; blue++)                 {s8                   image->colormap[i].red=(red*MaxRGB)/7;<                   image->colormap[i].green=(green*MaxRGB)/7;:                   image->colormap[i].blue=(blue*MaxRGB)/3;                   i++;                 }m           }.       }      /*;       Convert PNM pixels to runlength-encoded MIFF packets.m     */     q=image->pixels;     switch (format)      {a       case '1':t       {R
         /*9           Convert PBM image to runlength-encoded packets. 
         */*         for (i=0; i < image->packets; i++)	         { (           q->index=!PNMInteger(image,2);           q->length=0;           q++;	         }o         SyncImage(image);u         break;       }        case '2':_       {(
         /*9           Convert PGM image to runlength-encoded packets.r
         */          if (max_value == MaxRGB),           for (i=0; i < image->packets; i++)           {h*             q->index=PNMInteger(image,10);             q->length=0;             q++;           }          else,           for (i=0; i < image->packets; i++)           {l1             q->index=scale[PNMInteger(image,10)];a             q->length=0;             q++;           }t         SyncImage(image);          break;       }-       case '3':x       {)
         /*9           Convert PNM image to runlength-encoded packets. 
         */          if (max_value == MaxRGB),           for (i=0; i < image->packets; i++)           { (             q->red=PNMInteger(image,10);*             q->green=PNMInteger(image,10);)             q->blue=PNMInteger(image,10);              q->index=0;-             q->length=0;             q++;           }          else,           for (i=0; i < image->packets; i++)           { /             q->red=scale[PNMInteger(image,10)]; 1             q->green=scale[PNMInteger(image,10)]; 0             q->blue=scale[PNMInteger(image,10)];             q->index=0;              q->length=0;             q++;           }r         break;       }        case '4':-       {y         unsigned char            bit,           byte;n           unsigned int           x,           y;  
         /*=           Convert PBM raw image to runlength-encoded packets.d
         */'         for (y=0; y < image->rows; y++) 	         {            bit=0;           byte=0;f,           for (x=0; x < image->columns; x++)           {              if (bit == 0) &               byte=fgetc(image->file);+             q->index=(byte & 0x80) ? 0 : 1;              q->length=0;             q++;             bit++;             if (bit == 8)                bit=0;             byte<<=1;            }r	         }o         SyncImage(image);o         break;       }        case '5':        case '7':        {-
         /*=           Convert PGM raw image to runlength-encoded packets. 
         */         if (max_value > 255)           {              /*"               Two byte PNM images.             */.             for (i=0; i < image->packets; i++)
             { =               q->index=scale[LSBFirstReadShort(image->file)];o               q->length=0;               q++;
             }              SyncImage(image);r             break;           }tN         pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));-         if (pixels == (unsigned char *) NULL)w           {p=             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image);+#             return((Image *) NULL);x           }oF         status=ReadData((char *) pixels,1,image->packets,image->file);         if (status == False)           {pG             Warning("Insufficient image data in file",image->filename); !             DestroyImages(image);e#             return((Image *) NULL);t           }f
         /*=           Convert PNM raw image to runlength-encoded packets. 
         */         p=pixels;           if (max_value == MaxRGB),           for (i=0; i < image->packets; i++)           {t             q->index=(*p++);             q->length=0;             q++;           }i         else,           for (i=0; i < image->packets; i++)           {u!             q->index=scale[*p++];x             q->length=0;             q++;           }(         SyncImage(image);          free((char *) pixels);         break;       }(       case '6':        { 
         /*@           Convert PNM raster image to runlength-encoded packets.
         */         if (max_value > 255)           {s             /*"               Two byte PNM images.             */.             for (i=0; i < image->packets; i++)
             {t;               q->red=scale[LSBFirstReadShort(image->file)];o=               q->green=scale[LSBFirstReadShort(image->file)];e<               q->blue=scale[LSBFirstReadShort(image->file)];               q->index=0;%               q->length=0;               q++;
             }              break;           } P         pixels=(unsigned char *) malloc(image->packets*3*sizeof(unsigned char));-         if (pixels == (unsigned char *) NULL)            { =             Warning("Memory allocation error",(char *) NULL);e!             DestroyImages(image); #             return((Image *) NULL);            } H         status=ReadData((char *) pixels,1,3*image->packets,image->file);         if (status == False)           { G             Warning("Insufficient image data in file",image->filename); !             DestroyImages(image);%#             return((Image *) NULL);%           }%         p=pixels;           if (max_value == MaxRGB),           for (i=0; i < image->packets; i++)           {r             q->red=(*p++);             q->green=(*p++);             q->blue=(*p++);r             q->index=0;m             q->length=0;             q++;           }          else,           for (i=0; i < image->packets; i++)           {p             q->red=scale[*p++];a!             q->green=scale[*p++];               q->blue=scale[*p++];             q->index=0;              q->length=0;             q++;           }          free((char *) pixels);         break;       }i       default:       {n6         Warning("Not a PNM image file",(char *) NULL);         DestroyImages(image);a         return((Image *) NULL);e       }n     } (     if (scale != (unsigned char *) NULL)       free((char *) scale); $     if (image->class == PseudoClass)       CompressColormap(image);     /*       Proceed to next image.     */>     if ((format == '1') || (format == '2') || (format == '3'))       do       {e
         /*           Skip to end of line.
         */1         status=ReadData(&format,1,1,image->file);m         if (status == False)           break;       } while (format != '\n');(6     status=ReadData((char *) &format,1,1,image->file);,     if ((status == True) && (format == 'P'))       {a
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);o#             return((Image *) NULL);h           }*B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }-0   } while ((status == True) && (format == 'P'));+   while (image->previous != (Image *) NULL)_     image=image->previous;   CloseImage(image);   return(image); }h k /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %tO %                                                                             %eO %                                                                             %lO %  R e a d P S I m a g e                                                      %iO %                                                                             % O %                                                                             %gO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadPSImage reads a Adobe Postscript image file and returns it.  ItKK %  allocates the memory necessary for the new Image structure and returns am %  pointer to the new image. % , %  The format of the ReadPSImage routine is: % $ %      image=ReadPSImage(image_info) %-+ %  A description of each parameter follows:  %=H %    o image:  Function ReadPSImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.u %* %) */% static Image *ReadPSImage(image_info)m	 ImageInfo+   *image_info; { % #define BoundingBox  "%%BoundingBox:"+- #define PageBoundingBox  "%%PageBoundingBox:"      char     command[MaxTextLength], !     crop_geometry[MaxTextLength],l     *device,     filename[MaxTextLength],     options[MaxTextLength],Y'     postscript_filename[MaxTextLength];p     FILE
     *file;     Image-     *image,)     *next_image;     int(     status;   
   long int
     filesize;      register int     i;     unsigned int
     showpage;-     /*     Allocate image structure.e   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      {g5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }r   /*     Open temporary output file.l   */)   TemporaryFilename(postscript_filename); &   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)     {d:       Warning("Unable to write file",postscript_filename);       return((Image *) NULL);r     }G   /*5     Determine if Postscript specifies a bounding box.x   */   showpage=False;    *options='\0';   *crop_geometry='\0';E   while (fgets(command,MaxTextLength-1,image->file) != (char *) NULL)=   {      if (!(*command == '%'))(5       showpage|=GlobExpression(command,"*showpage*"); B     if ((strncmp(BoundingBox,command,strlen(BoundingBox)) == 0) ||H         (strncmp(PageBoundingBox,command,strlen(PageBoundingBox)) == 0))       {%         int%           count,           flags,           lower_x,           lower_y,           upper_x,           upper_y,           x,           y;           unsigned int           dx_resolution,           dy_resolution,           x_resolution,            y_resolution;A  B         if (strncmp(BoundingBox,command,strlen(BoundingBox)) == 0)P           count=sscanf(command,"%%%%BoundingBox: %d %d %d %d",&lower_x,&lower_y,             &upper_x,&upper_y); J         if (strncmp(PageBoundingBox,command,strlen(PageBoundingBox)) == 0)B           count=sscanf(command,"%%%%PageBoundingBox: %d %d %d %d",1             &lower_x,&lower_y,&upper_x,&upper_y);%         if (count != 4)t           continue;s
         /*!           Determine bounding box. 
         */E         (void) XParseGeometry(PSDensityGeometry,&x,&y,&dx_resolution,i           &dy_resolution);#         x_resolution=dx_resolution;t#         y_resolution=dy_resolution;gE         flags=XParseGeometry(image_info->density,&x,&y,&x_resolution,            &y_resolution);A'         if ((flags & HeightValue) == 0)e$           y_resolution=x_resolution;.         if (image_info->page == (char *) NULL)           {g             unsigned int               height,i               width;               /*-               Set Postscript render geometry.i             */H             width=((lower_x+upper_x)*x_resolution+(dx_resolution >> 1))/               dx_resolution;I             height=((lower_x+upper_y)*y_resolution+(dy_resolution >> 1))/g               dy_resolution;:             (void) sprintf(options,"-g%ux%u",width,width);             if (width < height)(>               (void) sprintf(options,"-g%ux%u",height,height);/             (void) strcpy(crop_geometry,"0x0");            }        }      (void) fputs(command,file);a   }r   if (!showpage)$     (void) fputs("showpage\n",file);   if (ferror(file))-     {1K       Warning("An error has occurred writing to file",postscript_filename);h       (void) fclose(file);       return((Image *) NULL);t     }    (void) fclose(file);   CloseImage(image);   filesize=image->filesize;z   DestroyImage(image);   /*@     Determine if page geometry or density options are specified.   */(   if (image_info->page != (char *) NULL)     {r#       (void) strcat(options," -g"); .       (void) strcat(options,image_info->page);     })+   if (image_info->density != (char *) NULL)      {m#       (void) strcat(options," -r");-1       (void) strcat(options,image_info->density);u     }B   /*0     Use Ghostscript to convert Postscript image.   */   device="ppmraw";   if (image_info->monochrome)e     device="pbmraw";/   (void) strcpy(filename,image_info->filename);l   for (i=0; i < 50; i++)   {N     /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   }%O   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,      postscript_filename);     status=SystemCommand(command);
   if (status)      { D       Warning("Postscript translation failed",image_info->filename);)       (void) unlink(postscript_filename);        return((Image *) NULL);      } !   image=ReadPNMImage(image_info); %   (void) unlink(postscript_filename); &   (void) unlink(image_info->filename);   if (image == (Image *) NULL)     { D       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);      }    do   { ,     (void) strcpy(image->filename,filename);     image->filesize=filesize;%     if (*crop_geometry != '\0')%0       if (Intensity(image->pixels[0]) == MaxRGB)	         {I           /*!             Crop to bounding box.t           */=           TransformImage(&image,crop_geometry,(char *) NULL); ,           if (image->next != (Image *) NULL)(             image->next->previous=image;	         }i     next_image=image->next;i%     if (next_image != (Image *) NULL)        image=next_image;T)   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)f     image=image->previous;   return(image); }i e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %,O %  R e a d R A D I A N C E I m a g e                                          % O %                                                                             % O %                                                                             %lO %                                                                             %kO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %;I %  Function ReadRADIANCEImage reads a RADIANCE image file and returns it.pL %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %o2 %  The format of the ReadRADIANCEImage routine is: %g* %      image=ReadRADIANCEImage(image_info) %e+ %  A description of each parameter follows:f %.N %    o image:  Function ReadRADIANCEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.F %e %  */+ static Image *ReadRADIANCEImage(image_info)o	 ImageInfo    *image_info; {    char     command[MaxTextLength],e     filename[MaxTextLength];     Image0     *image,h     *next_image;     inta     status;;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);n   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)(     {f5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }e   CloseImage(image);   DestroyImage(image);   /*)     Use ra_ppm to convert RADIANCE image.    *//   (void) strcpy(filename,image_info->filename);+*   TemporaryFilename(image_info->filename);G   (void) sprintf(command,"ra_ppm %s %s",filename,image_info->filename);     status=SystemCommand(command);
   if (status)0     { B       Warning("RADIANCE translation failed",image_info->filename);       return((Image *) NULL);      } !   image=ReadPNMImage(image_info);_&   (void) unlink(image_info->filename);   if (image == (Image *) NULL)     { B       Warning("RADIANCE translation failed",image_info->filename);       return((Image *) NULL);n     }|   /*     Assign proper filename.'   */   do   { ,     (void) strcpy(image->filename,filename);     next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL);n+   while (image->previous != (Image *) NULL)/     image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"O %                                                                             % O %                                                                             %(O %                                                                             % O %  R e a d R G B I m a g e                                                    %IO %                                                                             %tO %                                                                             %uO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %iM %  Function ReadRGBImage reads an image of raw red, green, and blue bytes andsM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadRGBImage routine is:- %l% %      image=ReadRGBImage(image_info)h % + %  A description of each parameter follows:o % I %    o image:  Function ReadRGBImage returns a pointer to the image afteruL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %tA %    o image_info: Specifies a pointer to an ImageInfo structure.e %r %w */& static Image *ReadRGBImage(image_info)	 ImageInfoa   *image_info; {    Image"     *image;t     inti     x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;c     unsigned charr     *rgb_pixels;     unsigned int     height,s
     width;     /*     Allocate image structure.C   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);)   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      {u5       Warning("Unable to open file",image->filename);l       DestroyImage(image);       return((Image *) NULL);)     }    /*-     Determine width and height, e.g. 640x512.m   */   width=512;
   height=512;r(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);g   /*     Initialize image structure.l   */   image->columns=width;g   image->rows=height;s,   image->packets=image->columns*image->rows;N   rgb_pixels=(unsigned char *) malloc(3*image->packets*sizeof(unsigned char));#   image->pixels=(RunlengthPacket *)z3     malloc(image->packets*sizeof(RunlengthPacket));R/   if ((rgb_pixels == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))     {o7       Warning("Memory allocation error",(char *) NULL);;       DestroyImage(image);       return((Image *) NULL);      }x   /*6     Convert raster image to runlength-encoded packets.   */D   (void) ReadData((char *) rgb_pixels,3,image->packets,image->file);   p=rgb_pixels;s    switch (image_info->interlace)   {m     case NoneInterlace:f     default:     {t       /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->red=(*p++);         q->green=(*p++);         q->blue=(*p++);1         q->index=0;n         q->length=0;         q++;       }u       break;     }      case LineInterlace:p     {        /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...i       */%       for (y=0; y < image->rows; y++)        {s)         q=image->pixels+y*image->columns;t*         for (x=0; x < image->columns; x++)	         {)           q->red=(*p++);           q->index=0;            q->length=0;           q++;	         }=)         q=image->pixels+y*image->columns;u*         for (x=0; x < image->columns; x++)	         {=           q->green=(*p++);           q++;	         }))         q=image->pixels+y*image->columns;s*         for (x=0; x < image->columns; x++)	         {_           q->blue=(*p++);            q++;	         }_       }        break;     }l     case PlaneInterlace:     {        /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...o       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {e         q->red=(*p++);         q->index=0;l         q->length=0;         q++;       }r       q=image->pixels;(       for (i=0; i < image->packets; i++)       {p         q->green=(*p++);         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->blue=(*p++);          q++;       }i       break;     }    }    free((char *) rgb_pixels);   CloseImage(image);   return(image); }  x /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %lO %                                                                             % O %  R e a d R L E I m a g e                                                    %%O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%R %aG %  Function ReadRLEImage reads a run-length encoded Utah Raster Toolkit L %  image file and returns it.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. % - %  The format of the ReadRLEImage routine is:  % % %      image=ReadRLEImage(image_info)  % + %  A description of each parameter follows:% %%I %    o image:  Function ReadRLEImage returns a pointer to the image afteraL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.a %rA %    o image_info: Specifies a pointer to an ImageInfo structure.a %F %g */& static Image *ReadRLEImage(image_info)	 ImageInfoo   *image_info; {p #define SkipLinesOp  0x01o #define SetColorOp  0x02 #define SkipPixelsOp  0x03 #define ByteDataOp  0x05 #define RunDataOp  0x06n #define EOFOp  0x07      char     magick[12];t     Image      *image;c     int      opcode,e     operand,     status,t     x,     y;     register int     i,     j;     register RunlengthPacket     *q;      register unsigned char     *p;b     unsigned char&     background_color[256],     *colormap,
     pixel,
     plane,     *rle_pixels;     unsigned int     bits_per_pixel, 
     flags,     map_length,      number_colormaps,g     number_planes;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);M   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)e     { 5       Warning("Unable to open file",image->filename);u       DestroyImage(image);       return((Image *) NULL);      }g   /*$     Determine if this is a RLE file.   */3   status=ReadData((char *) magick,1,2,image->file); ?   if ((status == False) || (strncmp(magick,"\122\314",2) != 0))      { 4       Warning("Not a RLE image file",(char *) NULL);       DestroyImage(image);       return((Image *) NULL);      }    do   {l     /*       Read image header.     */*     (void) LSBFirstReadShort(image->file);*     (void) LSBFirstReadShort(image->file);2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file);5.     image->packets=image->columns*image->rows;     flags=fgetc(image->file);      image->matte=flags & 0x04;%     number_planes=fgetc(image->file);l&     bits_per_pixel=fgetc(image->file);(     number_colormaps=fgetc(image->file);'     map_length=1 << fgetc(image->file);aP     if ((number_planes == 0) || (number_planes == 2) || (bits_per_pixel != 8) ||         (image->columns == 0))       { <         Warning("Unsupported RLE image file",(char *) NULL);         DestroyImage(image);         return((Image *) NULL);a       }a     if (flags & 0x02)m       {r
         /*4           No background color-- initialize to black.
         */)         for (i=0; i < number_planes; i++)D0           background_color[i]=(unsigned char) 0;"         (void) fgetc(image->file);       }      else       { 
         /*&           Initialize background color.
         */         p=background_color;s)         for (i=0; i < number_planes; i++) 2           *p++=(unsigned char) fgetc(image->file);       } $     if ((number_planes & 0x01) == 0)        (void) fgetc(image->file);$     colormap=(unsigned char *) NULL;     if (number_colormaps != 0)       { 
         /*           Read image colormaps.l
         */"         colormap=(unsigned char *)D           malloc(number_colormaps*map_length*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL)            { =             Warning("Memory allocation error",(char *) NULL);               DestroyImage(image);#             return((Image *) NULL);            }          p=colormap;&,         for (i=0; i < number_colormaps; i++)(           for (j=0; j < map_length; j++)<             *p++=ColorShift(LSBFirstReadShort(image->file));       }      if (flags & 0x08)        {          unsigned int           length;   
         /*           Read image comment. 
         */.         length=LSBFirstReadShort(image->file);=         image->comments=(char *) malloc(length*sizeof(char));a-         if (image->comments == (char *) NULL)*           { =             Warning("Memory allocation error",(char *) NULL);m              DestroyImage(image);#             return((Image *) NULL);r           } I         (void) ReadData((char *) image->comments,1,length-1,image->file);m'         image->comments[length-1]='\0'; !         if ((length & 0x01) == 0)h$           (void) fgetc(image->file);       }n     /*       Allocate RLE pixels.     */     if (image->matte)(       number_planes++;      rle_pixels=(unsigned char *)A       malloc(image->packets*number_planes*sizeof(unsigned char));e-     if (rle_pixels == (unsigned char *) NULL)(       {N9         Warning("Memory allocation error",(char *) NULL);0         DestroyImage(image);         return((Image *) NULL);)       } *     if ((flags & 0x01) && !(flags & 0x02))       { 
         /*           Set background color.a
         */         p=rle_pixels;i*         for (i=0; i < image->packets; i++)	         {            if (!image->matte)-             for (j=0; j < number_planes; j++)t'               *p++=background_color[j];0           else
             { 3               for (j=0; j < (number_planes-1); j++)m)                 *p++=background_color[j]; 5               *p++=0;  /* initialize matte channel */ 
             }I	         })       }      /*#       Read runlength-encoded image.      */     plane=0;     x=0;     y=0;     opcode=fgetc(image->file);     do     {f       switch (opcode & 0x3f)       {s         case SkipLinesOp: 	         {x%           operand=fgetc(image->file);-           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);-           x=0;           y+=operand;            break;	         }          case SetColorOp:	         {*%           operand=fgetc(image->file);            plane=operand;           if (plane == 255)l"             plane=number_planes-1;           x=0;           break;	         }          case SkipPixelsOp:	         {g%           operand=fgetc(image->file);e           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);a           x+=operand;;           break;	         })         case ByteDataOp:	         {o%           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);gH           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;           operand++;%           for (i=0; i < operand; i++)            {g%             pixel=fgetc(image->file); >             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;e             p+=number_planes;e           })           if (operand & 0x01) &             (void) fgetc(image->file);           x+=operand;            break;	         }l         case RunDataOp: 	         {[%           operand=fgetc(image->file);l           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);(#           pixel=fgetc(image->file); $           (void) fgetc(image->file);           operand++;H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;%           for (i=0; i < operand; i++)c           { >             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;              p+=number_planes;r           }            x+=operand;[           break;	         }m         default:           break;       }         opcode=fgetc(image->file);<     } while (((opcode & 0x3f) != EOFOp) && (opcode != EOF));     if (number_colormaps != 0)       {          unsigned int           mask;   
         /*1           Apply colormap transformation to image.m
         */         mask=(map_length-1);         p=rle_pixels;("         if (number_colormaps == 1),           for (i=0; i < image->packets; i++)           { 3             *p=(unsigned char) colormap[*p & mask];              p++;           })         else>           if ((number_planes >= 3) && (number_colormaps >= 3)).             for (i=0; i < image->packets; i++)/               for (j=0; j < number_planes; j++)g               {eF                 *p=(unsigned char) colormap[j*map_length+(*p & mask)];                 p++;               }        }      /*!       Initialize image structure.e     */%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { 9         Warning("Memory allocation error",(char *) NULL);a         DestroyImage(image);         return((Image *) NULL);,       }      q=image->pixels;     if (number_planes >= 3)/       { 
         /*H           Convert raster image to DirectClass runlength-encoded packets.
         */         p=rle_pixels;a*         for (i=0; i < image->packets; i++)	         {            q->red=(*p++);           q->green=(*p++);           q->blue=(*p++);d@           q->index=(unsigned short) (image->matte ? (*p++) : 0);           q->length=0;           q++;	         }a       }s     else       {-
         /*           Create colormap.
         */!         image->class=PseudoClass;r"         if (number_colormaps == 0)           map_length=256; !         image->colors=map_length;o'         image->colormap=(ColorPacket *)-4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL)           { G             Warning("Unable to read image","Memory allocation failed");e              DestroyImage(image);#             return((Image *) NULL);            }*         p=colormap;t"         if (number_colormaps == 0)+           for (i=0; i < image->colors; i++)p           {              /*               Grayscale.             */@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);            }t         else$           if (number_colormaps == 1)-             for (i=0; i < image->colors; i++)f
             {                /*                 Pseudocolor.               */7               image->colormap[i].red=(unsigned char) i;m9               image->colormap[i].green=(unsigned char) i;n8               image->colormap[i].blue=(unsigned char) i;
             }            else-             for (i=0; i < image->colors; i++)s
             {U*               image->colormap[i].red=(*p);9               image->colormap[i].green=(*(p+map_length));%:               image->colormap[i].blue=(*(p+map_length*2));               p++;
             }          p=rle_pixels;          if (!image->matte)           {              /*L               Convert raster image to PseudoClass runlength-encoded packets.             */.             for (i=0; i < image->packets; i++)
             {g/               q->index=(unsigned short) (*p++);                q->length=0;               q++;
             }              SyncImage(image);            }          else           {              /*A               Image has a matte channel-- promote to DirectClass.              */.             for (i=0; i < image->packets; i++)
             {%-               q->red=image->colormap[*p].red; 1               q->green=image->colormap[*p].green; 1               q->blue=image->colormap[*p++].blue;a/               q->index=(unsigned short) (*p++);p               q->length=0;               q++;
             }e"             free(image->colormap);1             image->colormap=(ColorPacket *) NULL;p%             image->class=DirectClass;F             image->colors=0;           }t       }a     if (number_colormaps != 0)       free((char *) colormap);     free((char *) rle_pixels);     /*       Proceed to next image.     */     (void) fgetc(image->file);5     status=ReadData((char *) magick,1,2,image->file);m@     if ((status == True) && (strncmp(magick,"\122\314",2) == 0))       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {i!             DestroyImages(image);t#             return((Image *) NULL);i           }eB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }(D   } while ((status == True) && (strncmp(magick,"\122\314",2) == 0));+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }g c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             % O %                                                                             %gO %                                                                             %rO %  R e a d S U N I m a g e                                                    % O %                                                                             %nO %                                                                             %iO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %gM %  Function ReadSUNImage reads a SUN image file and returns it.  It allocatesuL %  the memory necessary for the new Image structure and returns a pointer to %  the new image.* % - %  The format of the ReadSUNImage routine is:t % % %      image=ReadSUNImage(image_info)* %U+ %  A description of each parameter follows:k %*I %    o image:  Function ReadSUNImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.o % A %    o image_info: Specifies a pointer to an ImageInfo structure.k %, %g */& static Image *ReadSUNImage(image_info)	 ImageInfo    *image_info; {c #define RMT_EQUAL_RGB  1 #define RMT_NONE  0d #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_ENCODED  2n #define RT_FORMAT_RGB  3     typedef struct _SUNHeader    {(     unsigned long)       magic,       width,
       height,e       depth,
       length,        type,%       maptype,       maplength;   } SUNHeader;     Image%     *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      SUNHeader      sun_header;      unsigned char      *sun_data,     *sun_pixels;     unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);%     }%   /*     Read SUN raster header.    */1   sun_header.magic=MSBFirstReadLong(image->file);f   do   {u     /*       Verify SUN identifier.     */'     if (sun_header.magic != 0x59a66a95)        {i5         Warning("Not a SUN raster,",image->filename);S         DestroyImages(image);          return((Image *) NULL);g       } 3     sun_header.width=MSBFirstReadLong(image->file); 4     sun_header.height=MSBFirstReadLong(image->file);3     sun_header.depth=MSBFirstReadLong(image->file);m4     sun_header.length=MSBFirstReadLong(image->file);2     sun_header.type=MSBFirstReadLong(image->file);5     sun_header.maptype=MSBFirstReadLong(image->file); 7     sun_header.maplength=MSBFirstReadLong(image->file);      switch (sun_header.maptype)      {        case RMT_NONE:       {F"         if (sun_header.depth < 24)           {              /*'               Create linear color ramp.%             */0             image->colors=1 << sun_header.depth;+             image->colormap=(ColorPacket *) 8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)               { A                 Warning("Memory allocation error",(char *) NULL); '                 return((Image *) NULL);                } -             for (i=0; i < image->colors; i++) 
             { B               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);%
             }%           }%         break;       }R       case RMT_EQUAL_RGB:g       {d         unsigned charl           *sun_colormap;  
         /*#           Read SUN raster colormap.i
         */-         image->colors=sun_header.maplength/3;a'         image->colormap=(ColorPacket *)I4           malloc(image->colors*sizeof(ColorPacket));&         sun_colormap=(unsigned char *)6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (sun_colormap == (unsigned char *) NULL))            {a=             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image);e#             return((Image *) NULL);s           };K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);e)         for (i=0; i < image->colors; i++) 1           image->colormap[i].red=sun_colormap[i]; K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);t)         for (i=0; i < image->colors; i++)l3           image->colormap[i].green=sun_colormap[i];oK         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);i)         for (i=0; i < image->colors; i++) 2           image->colormap[i].blue=sun_colormap[i];$         free((char *) sun_colormap);         break;       }n       case RMT_RAW:a       {          unsigned char            *sun_colormap;  
         /*#           Read SUN raster colormap. 
         */&         sun_colormap=(unsigned char *)=           malloc(sun_header.maplength*sizeof(unsigned char));i3         if (sun_colormap == (unsigned char *) NULL)            {i=             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image);i#             return((Image *) NULL);e           }e>         (void) ReadData((char *) sun_colormap,1,(unsigned int),           sun_header.maplength,image->file);$         free((char *) sun_colormap);         break;       }        default:       { B         Warning("Colormap type is not supported",image->filename);         DestroyImages(image);          return((Image *) NULL);o       },     }fO     sun_data=(unsigned char *) malloc(sun_header.length*sizeof(unsigned char)); +     if (sun_data == (unsigned char *) NULL)s       {a9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);=       } I     status=ReadData((char *) sun_data,1,(unsigned int) sun_header.length,        image->file);)=     if ((status == False) && (sun_header.type != RT_ENCODED)).       {gB         Warning("Unable to read image data",image_info->filename);         DestroyImages(image);_         return((Image *) NULL);        }(     sun_pixels=sun_data;&     if (sun_header.type == RT_ENCODED)       {t         unsigned int           width,           height;   
         /*0           Read run-length encoded raster pixels.
         */?         width=sun_header.width*(((sun_header.depth-1) >> 3)+1);s!         height=sun_header.height; P         sun_pixels=(unsigned char *) malloc(width*height*sizeof(unsigned char));1         if (sun_pixels == (unsigned char *) NULL)a           {S=             Warning("Memory allocation error",(char *) NULL);_!             DestroyImages(image);n#             return((Image *) NULL);f           }*@         (void) SUNDecodeImage(sun_data,sun_pixels,width,height);          free((char *) sun_data);       }s     /*!       Initialize image structure.      */*     image->matte=(sun_header.depth == 32);E     image->class=(sun_header.depth < 24 ? PseudoClass : DirectClass); $     image->columns=sun_header.width;"     image->rows=sun_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)n5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       {a9         Warning("Memory allocation error",(char *) NULL);f         DestroyImages(image);          return((Image *) NULL);        }M     /*<       Convert SUN raster image to runlength-encoded packets.     */     p=sun_pixels;n     q=image->pixels;     if (sun_header.depth == 1)%       for (y=0; y < image->rows; y++)        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */1         for (x=0; x < (image->columns >> 3); x++)a	         {,&           for (bit=7; bit >= 0; bit--)           { :             q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);             q->length=0;             q++;           }            p++;	         } &         if ((image->columns % 8) != 0)           {l?             for (bit=7; bit >= (8-(image->columns % 8)); bit--) 
             {t<               q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);               q->length=0;               q++;
             }              p++;           }eI         if ((((image->columns/8)+(image->columns % 8 ? 1 : 0)) % 2) != 0)            p++;       }w     else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++) 	         {i           /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } (           if ((image->columns % 2) != 0)             p++;	         } 
       else'         for (y=0; y < image->rows; y++)r	         {f           /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           { B             q->index=(unsigned short) (image->matte ? (*p++) : 0);/             if (sun_header.type == RT_STANDARD).               {                  q->blue=(*p++);n                  q->green=(*p++);                 q->red=(*p++);               }s             else               {                  q->red=(*p++);                  q->green=(*p++);                 q->blue=(*p++);                })#             if (image->colors != 0)                {f3                 q->red=image->colormap[q->red].red; 9                 q->green=image->colormap[q->green].green;r6                 q->blue=image->colormap[q->blue].blue;               }.             q->length=0;             q++;           } E           if (((image->columns % 2) != 0) && (image->matte == False))              p++;	         }l     free((char *) sun_pixels);$     if (image->class == PseudoClass)       {          SyncImage(image);!          CompressColormap(image);       }      /*       Proceed to next image.     */3     sun_header.magic=MSBFirstReadLong(image->file);f'     if (sun_header.magic == 0x59a66a95)        { 
         /*#           Allocate image structure.c
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {l!             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }0+   } while (sun_header.magic == 0x59a66a95); +   while (image->previous != (Image *) NULL)t     image=image->previous;   CloseImage(image);   return(image); }s o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             %1O %                                                                             %;O %                                                                             %eO %  R e a d T A R G A I m a g e                                                % O %                                                                             % O %                                                                             %/O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %;J %  Function ReadTARGAImage reads a Truevision Targa image file and returnsI %  it.  It allocates the memory necessary for the new Image structure and & %  returns a pointer to the new image. %e/ %  The format of the ReadTARGAImage routine is:g % ' %      image=ReadTARGAImage(image_info)  % + %  A description of each parameter follows:n %gK %    o image:  Function ReadTARGAImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.x %+ %m */( static Image *ReadTARGAImage(image_info)	 ImageInfo    *image_info; {  #define TargaColormap 1  #define TargaRGB 2 #define TargaMonochrome 3) #define TargaRLEColormap  92 #define TargaRLERGB  10x #define TargaRLEMonochrome  11     typedef struct _TargaHeader    {+     unsigned char        id_length,       colormap_type,       image_type;o       unsigned short       colormap_index,        colormap_length;       unsigned charm       colormap_size;       unsigned short       x_origin,        y_origin,C       width,
       height;l       unsigned charo       pixel_size,        attributes;l   } TargaHeader;     Image)     *image;      register int     i,     x,     y;     register RunlengthPacket     *q;   
   TargaHeadere     targa_header;      unsigned charN	     blue, 
     green,     j,     k,     red,     runlength;     unsigned int	     base,c	     flag,r	     real,d	     skip,      status,g	     true;[     unsigned short
     index;     /*     Allocate image structure.e   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);t   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)m     {w5       Warning("Unable to open file",image->filename);m       DestroyImage(image);       return((Image *) NULL);e     })   /*"     Read TARGA header information.   */D   status=ReadData((char *) &targa_header.id_length,1,1,image->file);0   targa_header.colormap_type=fgetc(image->file);-   targa_header.image_type=fgetc(image->file);    do   {+>     if ((status == False) || (targa_header.image_type == 0) ||'         (targa_header.image_type > 11))        { 8         Warning("Not a TARGA image file",(char *) NULL);         DestroyImages(image);r         return((Image *) NULL);        } ?     targa_header.colormap_index=LSBFirstReadShort(image->file);m@     targa_header.colormap_length=LSBFirstReadShort(image->file);2     targa_header.colormap_size=fgetc(image->file);9     targa_header.x_origin=LSBFirstReadShort(image->file); 9     targa_header.y_origin=LSBFirstReadShort(image->file);o6     targa_header.width=LSBFirstReadShort(image->file);7     targa_header.height=LSBFirstReadShort(image->file);n/     targa_header.pixel_size=fgetc(image->file); /     targa_header.attributes=fgetc(image->file);;     /*!       Initialize image structure.L     *//     image->matte=targa_header.pixel_size == 32;e&     image->columns=targa_header.width;$     image->rows=targa_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)y5       malloc(image->packets*sizeof(RunlengthPacket));%2     if (image->pixels == (RunlengthPacket *) NULL)       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        } $     if (targa_header.id_length != 0)       { 
         /*           TARGA image comment.
         */          image->comments=(char *):           malloc((targa_header.id_length+1)*sizeof(char));-         if (image->comments == (char *) NULL)            { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            } N         (void) ReadData(image->comments,1,targa_header.id_length,image->file);5         image->comments[targa_header.id_length]='\0';l       }u(     if (targa_header.colormap_type != 0)       { 
         /*%           Read TARGA raster colormap. 
         */<         if ((targa_header.image_type == TargaRLEColormap) ||5             (targa_header.image_type == TargaRLERGB))p#           image->class=PseudoClass; 3         image->colors=targa_header.colormap_length;e'         image->colormap=(ColorPacket *)n4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL)           {c=             Warning("Memory allocation error",(char *) NULL);c!             DestroyImages(image);o#             return((Image *) NULL);            }e)         for (i=0; i < image->colors; i++)o	         {f-           switch (targa_header.colormap_size)l           {)             case 8:a             default:
             {T               /*                 Gray scale.t               */%               red=fgetc(image->file);;               green=red;               blue=red;                break;
             }h             case 15:             case 16:
             {                /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file);l#               k=fgetc(image->file);uH               red=(unsigned char) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);#               green=(unsigned char) P                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);D               blue=(unsigned char) ((MaxRGB*((int) (j & 0x1f)))/31);               break;
             }              case 32:             case 24:
             {                /*2                 8 bits each of blue green and red.               */&               blue=fgetc(image->file);'               green=fgetc(image->file); %               red=fgetc(image->file);t               break;
             })           }r%           image->colormap[i].red=red; )           image->colormap[i].green=green;t'           image->colormap[i].blue=blue; 	         }r       }o     /*8       Convert TARGA pixels to runlength-encoded packets.     */     base=0;      flag=0;e     index=0;     skip=False;(     real=0;r     runlength=0;     true=0;n#     for (y=0; y < image->rows; y++)      {p       real=true;G       if (((unsigned char) (targa_header.attributes & 0x20) >> 5) == 0)           real=image->rows-real-1;,       q=image->pixels+(real*image->columns);(       for (x=0; x < image->columns; x++)       {(<         if ((targa_header.image_type == TargaRLEColormap) ||7             (targa_header.image_type == TargaRLERGB) ||;<             (targa_header.image_type == TargaRLEMonochrome))           if (runlength != 0) 
             {E               runlength--;               skip=flag != 0;u
             }e           else
             { C               status=ReadData((char *) &runlength,1,1,image->file);y"               if (status == False)                 { L                   Warning("Unable to read image data",image_info->filename);'                   DestroyImages(image);u)                   return((Image *) NULL);f                 }m$               flag=runlength & 0x80;               if (flag != 0)                 runlength-=128;m               skip=False;t
             };         if (!skip)*           switch (targa_header.pixel_size)           {e             case 8:.             default:
             {p               /*                 Gray scale.i               */'               index=fgetc(image->file);a2               if (targa_header.colormap_type == 0)                 { ,                   red=(unsigned char) index;.                   green=(unsigned char) index;-                   blue=(unsigned char) index;(                 }                else                 {e1                   red=image->colormap[index].red; 5                   green=image->colormap[index].green;&3                   blue=image->colormap[index].blue;J                 }l               break;
             }g             case 15:             case 16:
             {                /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file); #               k=fgetc(image->file); H               red=(unsigned char) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);#               green=(unsigned char)mP                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);D               blue=(unsigned char) ((MaxRGB*((int) (j & 0x1f)))/31);.               index=((unsigned int) k << 8)+j;               break;
             }              case 24:             case 32:
             {                /*2                 8 bits each of blue green and red.               */&               blue=fgetc(image->file);'               green=fgetc(image->file);(%               red=fgetc(image->file);d0               if (targa_header.pixel_size == 32))                 index=fgetc(image->file);;               break;
             }e           }m         if (status == False)           {gF             Warning("Unable to read image data",image_info->filename);!             DestroyImages(image);a#             return((Image *) NULL);i           }h         q->red=red;=         q->green=green;t         q->blue=blue;l         q->index=index;A         q->length=0;         q++;       }cG       if (((unsigned char) (targa_header.attributes & 0xc0) >> 6) == 4)e         true+=4;
       elseI         if (((unsigned char) (targa_header.attributes & 0xc0) >> 6) == 2)L           true+=2;         else           true++;n       if (true >= image->rows)	         {e           base++;u           true=base;	         }f     }i$     if (image->class == PseudoClass)       SyncImage(image); F     status=ReadData((char *) &targa_header.id_length,1,1,image->file);2     targa_header.colormap_type=fgetc(image->file);/     targa_header.image_type=fgetc(image->file);oP     status&=((targa_header.image_type != 0) && (targa_header.image_type <= 11));     if (status == True)e       { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);(#             return((Image *) NULL);l           }nB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %oO %                                                                             % O %                                                                             %oO %  R e a d T E X T I m a g e                                                  % O %                                                                             %nO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadTEXTImage reads a text file and returns it as an image.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %J. %  The format of the ReadTEXTImage routine is: % & %      image=ReadTEXTImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadTEXTImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. %(A %    o image_info: Specifies a pointer to an ImageInfo structure.e %( %i */' static Image *ReadTEXTImage(image_info)s	 ImageInfo    *image_info; {    char     *text_status,t     text[MaxTextLength];  	   Display 
     *display;      Image+     *image;      intl     status,o     offset,c     x,     y;     register int     i;     register RunlengthPacket     *p;L     RunlengthPacket-     background_color;G     unsigned int     height,b
     width;     XAnnotateInfo*     annotate_info;  
   XFontStruct      *font_info;      XPixelInfo     pixel_info;      XResourceInfor     resource_info;  
   XrmDatabase      resource_database;     XStandardColormap_     *map_info;  
   XVisualInfo      *visual_info;r     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)f     { 5       Warning("Unable to open file",image->filename);%       DestroyImage(image);       return((Image *) NULL);      }    /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));O       DestroyImage(image);       return((Image *) NULL);      }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);%)   resource_info.colormap=PrivateColormap;%   /*     Allocate standard colormap.    */#   XGetAnnotateInfo(&annotate_info); $   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)iM     Warning("Unable to create standard colormap","Memory allocation failed");    else     {a       /*         Initialize visual info.n       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;a/       pixel_info.pixels=(unsigned long *) NULL;c       /*         Initialize font info.O       */,       if (image_info->font != (char *) NULL),         resource_info.font=image_info->font;8       font_info=XBestFont(display,&resource_info,False);,       if (font_info == (XFontStruct *) NULL):         Warning("Unable to load font",resource_info.font);(       annotate_info.font_info=font_info;@       annotate_info.height=font_info->ascent+font_info->descent;     }F1   if ((map_info == (XStandardColormap *) NULL) ||e.       (visual_info == (XVisualInfo *) NULL) ||*       (font_info == (XFontStruct *) NULL))     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL);(       DestroyImage(image);       return((Image *) NULL);      }i   /*!     Initialize Standard Colormap.o   */H   XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),     map_info);K   XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,I     &pixel_info);;F   pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);   pixel_info.annotate_index=1;C   background_color.red=ColorShift(pixel_info.background_color.red);eE   background_color.green=ColorShift(pixel_info.background_color.red);%D   background_color.blue=ColorShift(pixel_info.background_color.red);   background_color.index=0;    background_color.length=0;   /*     Initialize Image structure.    */?   (void) XParseGeometry(TextPageGeometry,&x,&y,&width,&height); (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))     {rD       Warning("Unable to allocate image","Memory allocation error");F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL);g       DestroyImage(image);       return((Image *) NULL);o     }    /*     Initialize colormap.   */E   image->colormap[0].red=ColorShift(pixel_info.background_color.red);sI   image->colormap[0].green=ColorShift(pixel_info.background_color.green); G   image->colormap[0].blue=ColorShift(pixel_info.background_color.blue);uE   image->colormap[1].red=ColorShift(pixel_info.foreground_color.red); I   image->colormap[1].green=ColorShift(pixel_info.foreground_color.green);tG   image->colormap[1].blue=ColorShift(pixel_info.foreground_color.blue);    /*.     Initialize text image to background color.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)     *p++=background_color;   /*     Annotate the text image.   */A   annotate_info.text=(char *) malloc(MaxTextLength*sizeof(char));e*   if (annotate_info.text == (char *) NULL)     {-A       Warning("Unable to read image","Memory allocation failed");eF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL);n       DestroyImage(image);       return((Image *) NULL);e     }2   text[MaxTextLength-1]='\0';_6   text_status=fgets(text,MaxTextLength-1,image->file);   if ((int) strlen(text) > 0)s     text[strlen(text)-1]='\0';   offset=0;e&   while (text_status != (char *) NULL)   {s     *annotate_info.text='\0';r     if (*text != '\0')       { 
         /*            Compute width of text.
         *//         (void) strcpy(annotate_info.text,text);s         annotate_info.width=N           XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));6         if ((annotate_info.width+4) >= image->columns)           {e             /*7               Reduce text until width is within bounds.              */)             i=strlen(annotate_info.text);)I             for (; (annotate_info.width+(x << 1)) >= image->columns; i--)="               annotate_info.width=J                 XTextWidth(font_info,annotate_info.text,(unsigned int) i);'             annotate_info.text[i]='\0'; >             while ((i > 0) && !isspace(annotate_info.text[i]))               i--;             if (i > 0))               annotate_info.text[i]='\0';lH             annotate_info.width=XTextWidth(font_info,annotate_info.text,*               strlen(annotate_info.text));           }r
         /*#           Annotate image with text.=
         */<         (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",?           annotate_info.width,annotate_info.height,x,y+offset);iN         status=XAnnotateImage(display,&pixel_info,&annotate_info,False,image);         if (status == 0)           {tJ             Warning("Unable to annotate image","Memory allocation error");             break;           }e       }u     /*       Get next string.     */3     if (strlen(text) != strlen(annotate_info.text))%<       (void) strcpy(text,text+strlen(annotate_info.text)+1);     else       { <         text_status=fgets(text,MaxTextLength-1,image->file);#         if ((int) strlen(text) > 0) $           text[strlen(text)-1]='\0';       } !     offset+=annotate_info.height;a)     if ((text_status != (char *) NULL) && @         (((y << 1)+offset+annotate_info.height) >= image->rows))       { 
         /*7           Page is full-- allocate next image structure. 
         */         image->orphan=True; F         image->next=CopyImage(image,image->columns,image->rows,False);         image->orphan=False;*         if (image->next == (Image *) NULL)           {%J             Warning("Unable to annotate image","Memory allocation error");             break;           }hB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;
         /*4           Initialize text image to background color.
         */         p=image->pixels;*         for (i=0; i < image->packets; i++)            *p++=background_color;         offset=0;g       }b   }d   /*     Force class to PseudoClass.p   */+   while (image->previous != (Image *) NULL)t   {a     image->class=PseudoClass;      image=image->previous;   }    image->class=PseudoClass;    CloseImage(image);   /*     Free resources.e   */$   free((char *) annotate_info.text);B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,3     font_info,&resource_info,(XWindowInfo *) NULL);;   XCloseDisplay(display);e   return(image); }  g #ifdef HasTIFF #ifndef va_start, #if defined(__STDC__) && !defined(NOSTDHDRS) #include <stdarg.h>  #elsea #include <varargs.h> #endif #endif #include "tiffio.h"  ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %_O %                                                                             %iO %  R e a d T I F F I m a g e                                                  %;O %                                                                             %nO %                                                                             %iO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %aG %  Function ReadTIFFImage reads a Tagged image file and returns it.  ItlK %  allocates the memory necessary for the new Image structure and returns am %  pointer to the new image. % . %  The format of the ReadTIFFImage routine is: % & %      image=ReadTIFFImage(image_info) %l+ %  A description of each parameter follows:i %sJ %    o image:  Function ReadTIFFImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.; % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %e %n */  5 static void TIFFWarningMessage(module,format,warning)%
 const char
   *module,
   *format;   va_list 
   warning; {    char     message[MaxTextLength];      register char      *p;      p=message;   if (module != (char *) NULL)     {        sprintf(p,"%s: ",module);        p+=strlen(message);      }    vsprintf(p,format,warning);    strcat(p,".");!   Warning(message,(char *) NULL);  }   ' static Image *ReadTIFFImage(image_info) 	 ImageInfo    *image_info; {    char
     *comment;      Image      *image;      int 
     range;     register int     i,     quantum,     x,     y;     register RunlengthPacket     *q;      TIFF
     *tiff;     unsigned int     height,%     status,%
     width;     unsigned short     bits_per_sample,     max_sample_value,I     min_sample_value,n     photometric,     samples_per_pixel;     /*     Allocate image structure.u   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);a   /*     Open image.m   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)e     {i5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);e     }o,   if ((image->file == stdin) || image->pipe)     { 
       FILE         *file;  	       intn
         c;         /*6         Copy standard input or pipe to temporary file.       */.       TemporaryFilename(image_info->filename);,       file=fopen(image_info->filename,"wb");        if (file == (FILE *) NULL)	         { :           Warning("Unable to write file",image->filename);!           return((Image *) NULL); 	         }        c=fgetc(image->file);,       while (c != EOF)       {a         (void) putc(c,file);         c=fgetc(image->file);;       }m       (void) fclose(file);:       (void) strcpy(image->filename,image_info->filename);       image->temporary=True;     }-   CloseImage(image);*   TIFFSetErrorHandler(TIFFWarningMessage);,   TIFFSetWarningHandler(TIFFWarningMessage);&   tiff=TIFFOpen(image->filename,"rb");   if (tiff == (TIFF *) NULL)     { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);t     }e   do   {      if (image_info->verbose),       TIFFPrintDirectory(tiff,stderr,False);     /*5       Allocate memory for the image and pixel buffer./     */1     TIFFGetField(tiff,TIFFTAG_IMAGEWIDTH,&width);h3     TIFFGetField(tiff,TIFFTAG_IMAGELENGTH,&height); /     for (quantum=1; quantum <= 16; quantum<<=1)      {*#       image->columns=width/quantum; !       image->rows=height/quantum; 0       image->packets=image->columns*image->rows;'       image->pixels=(RunlengthPacket *)-7         malloc(image->packets*sizeof(RunlengthPacket)); 6       if ((image->pixels != (RunlengthPacket *) NULL))         break;     }h2     if (image->pixels == (RunlengthPacket *) NULL)       {o;         Warning("Unable to allocate memory",(char *) NULL);          DestroyImages(image);t         TIFFClose(tiff);         return((Image *) NULL);(       }lG     TIFFGetFieldDefaulted(tiff,TIFFTAG_BITSPERSAMPLE,&bits_per_sample); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MINSAMPLEVALUE,&min_sample_value); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MAXSAMPLEVALUE,&max_sample_value);tA     TIFFGetFieldDefaulted(tiff,TIFFTAG_PHOTOMETRIC,&photometric);tK     TIFFGetFieldDefaulted(tiff,TIFFTAG_SAMPLESPERPIXEL,&samples_per_pixel); E     TIFFGetFieldDefaulted(tiff,TIFFTAG_RESOLUTIONUNIT,&image->units);oI     TIFFGetFieldDefaulted(tiff,TIFFTAG_XRESOLUTION,&image->x_resolution); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_YRESOLUTION,&image->y_resolution);      comment=(char *) NULL;9     TIFFGetField(tiff,TIFFTAG_IMAGEDESCRIPTION,&comment);o!     if (comment != (char *) NULL)u$       if ((int) strlen(comment) > 4)	         {p"           image->comments=(char *)D             malloc((unsigned int) (strlen(comment)+1)*sizeof(char));/           if (image->comments == (char *) NULL) 
             { A               Warning("Unable to allocate memory",(char *) NULL); #               DestroyImages(image);M               TIFFClose(tiff);%               return((Image *) NULL);(
             } 1           (void) strcpy(image->comments,comment);'	         } ,     range=max_sample_value-min_sample_value;     if (range < 0)       range=max_sample_value;;N     if ((bits_per_sample > 8) || (samples_per_pixel > 1) || TIFFIsTiled(tiff))       {l         register uint32 
           *p,            *pixels;  
         /*7           Convert TIFF image to DirectClass MIFF image. 
         */+         image->matte=samples_per_pixel > 3;f         pixels=(uint32 *)/A           malloc((image->packets+image->columns)*sizeof(uint32));(&         if (pixels == (uint32 *) NULL)           {m?             Warning("Unable to allocate memory",(char *) NULL);(!             DestroyImages(image);              TIFFClose(tiff);#             return((Image *) NULL);            }          if (quantum > 1);           Warning("Not enough memory","cropping required"); K         status=TIFFReadRGBAImage(tiff,image->columns,image->rows,pixels,0);y         if (status == False)           {f?             Warning("Unable to read TIFF image",(char *) NULL);i"             free((char *) pixels);!             DestroyImages(image);p             TIFFClose(tiff);#             return((Image *) NULL);i           }n
         /*A           Convert image to DirectClass runlength-encoded packets.U
         */         q=image->pixels;*         for (y=image->rows-1; y >= 0; y--)	         {c$           p=pixels+y*image->columns;,           for (x=0; x < image->columns; x++)           {(              q->red=TIFFGetR(*p);"             q->green=TIFFGetG(*p);!             q->blue=TIFFGetB(*p); H             q->index=(unsigned short) (image->matte ? TIFFGetA(*p) : 0);             q->length=0;             p++;             q++;           }f	         }a         free((char *) pixels);#         if (samples_per_pixel == 1)mJ           QuantizeImage(image,(unsigned int) range,8,False,RGBColorspace);       }      else       {d         unsigned char 
           *p, 
           *r,m           *quantum_scanline,           *scanline;  
         /*7           Convert TIFF image to PseudoClass MIFF image. 
         */!         image->class=PseudoClass;l         image->colors=range+1;'         image->colormap=(ColorPacket *)o4           malloc(image->colors*sizeof(ColorPacket));O         quantum_scanline=(unsigned char *) malloc(width*sizeof(unsigned char));eB         scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff));8         if ((image->colormap == (ColorPacket *) NULL) ||;             (quantum_scanline == (unsigned char *) NULL) || 1             (scanline == (unsigned char *) NULL))            {p?             Warning("Unable to allocate memory",(char *) NULL);t!             DestroyImages(image);c             TIFFClose(tiff);#             return((Image *) NULL);m           }e
         /*           Create colormap.
         */         switch (photometric)	         {m&           case PHOTOMETRIC_MINISBLACK:           { -             for (i=0; i < image->colors; i++)m
             {l6               image->colormap[i].red=(MaxRGB*i)/range;8               image->colormap[i].green=(MaxRGB*i)/range;7               image->colormap[i].blue=(MaxRGB*i)/range;g
             }              break;           } &           case PHOTOMETRIC_MINISWHITE:           {h-             for (i=0; i < image->colors; i++) 
             {v>               image->colormap[i].red=((range-i)*MaxRGB)/range;@               image->colormap[i].green=((range-i)*MaxRGB)/range;?               image->colormap[i].blue=((range-i)*MaxRGB)/range;p
             }f             break;           }n#           case PHOTOMETRIC_PALETTE:)           {              unsigned short               *blue_colormap,e               *green_colormap,               *red_colormap;  M             TIFFGetField(tiff,TIFFTAG_COLORMAP,&red_colormap,&green_colormap,                &blue_colormap);-             for (i=0; i < image->colors; i++)e
             {gJ               image->colormap[i].red=((int) red_colormap[i]*MaxRGB)/65535;N               image->colormap[i].green=((int) green_colormap[i]*MaxRGB)/65535;L               image->colormap[i].blue=((int) blue_colormap[i]*MaxRGB)/65535;
             }h             break;           }g           default:             break;	         } 
         /*A           Convert image to PseudoClass runlength-encoded packets. 
         */         if (quantum > 1)>           Warning("Not enough memory","subsampling required");         q=image->pixels;'         for (y=0; y < image->rows; y++)e	         { %           for (i=0; i < quantum; i++) C             TIFFReadScanline(tiff,(char *) scanline,y*quantum+i,0);r           p=scanline;            r=quantum_scanline; "           switch (bits_per_sample)           {              case 1: 
             {                register int                 bit;  2               for (x=0; x < ((int) width-7); x+=8)               { ,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               } #               if ((width % 8) != 0)                  { <                   for (bit=7; bit >= (8-(width % 8)); bit--)>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }                break;
             }o             case 2: 
             {t2               for (x=0; x < ((int) width-3); x+=4)               {t%                 *r++=(*p >> 6) & 0x3; %                 *r++=(*p >> 4) & 0x3; %                 *r++=(*p >> 2) & 0x3;r                  *r++=(*p) & 0x3;                 p++;               }e#               if ((width % 4) != 0)                  { 6                   for (i=3; i >= (4-(width % 4)); i--).                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }m               break;
             }              case 4:g
             { 2               for (x=0; x < ((int) width-1); x+=2)               {e%                 *r++=(*p >> 4) & 0xf;o                  *r++=(*p) & 0xf;                 p++;               } #               if ((width % 2) != 0)                  {f'                   *r++=(*p >> 4) & 0xf;r                   p++;                 }                break;
             }m             case 8:o
             { '               for (x=0; x < width; x++)                {                  *r++=(*p);                 p++;               }                break;
             }              default:               break;           }i           /*'             Subsample quantum scanline.)           */           r=quantum_scanline;s,           for (x=0; x < image->columns; x++)           {              q->index=(*r);             q->length=0;             q++;             r+=quantum;*           } 	         }e(         free((char *) quantum_scanline);          free((char *) scanline);       } $     if (image->class == PseudoClass)       {a         SyncImage(image);m          CompressColormap(image);       }      /*       Proceed to next image.     */#     status=TIFFReadDirectory(tiff);      if (status == True)a       {)
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);c#             return((Image *) NULL);            }cB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }d   } while (status == True);f   TIFFClose(tiff);   if (image->temporary) (     (void) unlink(image_info->filename);+   while (image->previous != (Image *) NULL)i     image=image->previous;   return(image); }g #elsee' static Image *ReadTIFFImage(image_info) 	 ImageInfog   *image_info; { @   Warning("TIFF library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }k #endif g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%zO %                                                                             % O %                                                                             %gO %                                                                             %oO %   R e a d V I C A R I m a g e                                               %kO %                                                                             %eO %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %sG %  Function ReadVICARImage reads a VICAR image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns aa %  pointer to the new image. % / %  The format of the ReadVICARImage routine is:o %u' %      image=ReadVICARImage(image_info)  % + %  A description of each parameter follows:e % J %    o image: Function ReadVICARImage returns a pointer to the image afterO %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.o %) %  */( static Image *ReadVICARImage(image_info)	 ImageInfoi   *image_info; {    char     keyword[MaxTextLength],s     value[MaxTextLength];      Imagen     *image;e     long
     count;     register int     c,     i;     register RunlengthPacket     *q;      register unsigned char     *p;e     unsigned char-     *vicar_pixels;     unsigned int     header_length,     status,-     value_expected;t     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      {)5       Warning("Unable to open file",image->filename);e       DestroyImage(image);       return((Image *) NULL);n     }e   /*     Decode image header.   */   c=fgetc(image->file);c
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);)     }    header_length=0;;   while (isgraph(c) && ((image->columns*image->rows) == 0))    {      if (!isalnum(c))       {x         c=fgetc(image->file);          count++;       }e     else       {n         register char 
           *p;s  
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         {(.           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);-           count++;+         } while (isalnum(c) || (c == '_'));E         *p='\0';         value_expected=False;a(         while (isspace(c) || (c == '='))	         {a           if (c == '=')               value_expected=True;           c=fgetc(image->file);e           count++;	         } $         if (value_expected == False)           continue;r         p=value;         while (isalnum(c))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);m           count++;	         };         *p='\0';
         /*2           Assign a value to the specified keyword.
         */1         if (strcmp(keyword,"LABEL_RECORDS") == 0)e3           header_length=(unsigned int) atoi(value);p+         if (strcmp(keyword,"LBLSIZE") == 0)%3           header_length=(unsigned int) atoi(value); 0         if (strcmp(keyword,"RECORD_BYTES") == 0)4           image->columns=(unsigned int) atoi(value);&         if (strcmp(keyword,"NS") == 0)4           image->columns=(unsigned int) atoi(value);)         if (strcmp(keyword,"LINES") == 0) 1           image->rows=(unsigned int) atoi(value); &         if (strcmp(keyword,"NL") == 0)1           image->rows=(unsigned int) atoi(value);        }      while (isspace(c))     {        c=fgetc(image->file);        count++;     }    }    /*      Read the rest of the header.   */   while (count < header_length)    {%     c=fgetc(image->file);%     count++;   }%   /*6     Verify that required image information is defined.   */(   if ((image->columns*image->rows) == 0)     {t@       Warning("Incorrect image header in file",image->filename);       DestroyImage(image);       return((Image *) NULL);a     }a   /*     Create linear colormap.a   */   image->class=PseudoClass;s   image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)     {n7       Warning("Memory allocation error",(char *) NULL);e       DestroyImage(image);       return((Image *) NULL);r     }I#   for (i=0; i < image->colors; i++)t   {a-     image->colormap[i].red=(unsigned char) i;i/     image->colormap[i].green=(unsigned char) i;D.     image->colormap[i].blue=(unsigned char) i;   }e   /*     Initialize image structure.i   */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); N   vicar_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (vicar_pixels == (unsigned char *) NULL))g     {,7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);e     }a   /*6     Convert VICAR pixels to runlength-encoded packets.   */F   status=ReadData((char *) vicar_pixels,1,image->packets,image->file);   if (status == False)     {lA       Warning("Insufficient image data in file",image->filename);n       DestroyImage(image);       return((Image *) NULL);      }"   /*6     Convert VICAR pixels to runlength-encoded packets.   */   p=vicar_pixels;)   q=image->pixels;$   for (i=0; i < image->packets; i++)   {r     q->red=(*p);     q->green=(*p);     q->blue=(*p); !     q->index=(unsigned short) *p;"     q->length=0;     p++;     q++;   }e   free((char *) vicar_pixels);   CompressColormap(image);   CloseImage(image);   return(image); }a s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %eO %                                                                             %mO %                                                                             %aO %  R e a d M I D I m a g e                                                    %eO %                                                                             %eO %                                                                             %_O %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+ % L %  Function ReadVIDImage reads one of more images and creates a Visual ImageG %  Directory file.  It allocates the memory necessary for the new Imageu4 %  structure and returns a pointer to the new image. %+- %  The format of the ReadVIDImage routine is:  % % %      image=ReadVIDImage(image_info)i %m+ %  A description of each parameter follows:) %eI %    o image:  Function ReadVIDImage returns a pointer to the image afteraL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %NA %    o image_info: Specifies a pointer to an ImageInfo structure.  %u %( */& static Image *ReadVIDImage(image_info)	 ImageInfom   *image_info; {, #define ClientName  "montage"      char     **filelist,l     *resource_value;  	   Displaye
     *display;      Imagen     *image,=
     **images;      ImageInfox     local_info;      int(     number_files;)     register int     i,     j;     XMontageInfo     montage_info;i     XResourceInfoi     resource_info;  
   XrmDatabase      resource_database;     /*     Expand the filename.   */,   filelist=(char **) malloc(sizeof(char *));!   if (filelist == (char **) NULL)u     {M7       Warning("Memory allocation error",(char *) NULL);%       return((Image *) NULL);%     }%   number_files=1;%#   filelist[0]=image_info->filename; +   ExpandFilenames(&number_files,&filelist);    if (number_files == 0)     { =       Warning("VID translation failed",image_info->filename);        return((Image *) NULL);      }    /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));     if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL); &       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);        free((char *) filelist);       return((Image *) NULL);      }    /*     Open X server connection.%   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {e.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));u&       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);o       free((char *) filelist);       free((char *) images);       return((Image *) NULL);r     }s   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);e   /*/     Get user defaults from X resource database.i   */>   resource_database=XGetResourceDatabase(display,client_name);@   XGetResourceInfo(resource_database,ClientName,&resource_info);H   resource_info.background_color=XGetResourceInstance(resource_database,3     ClientName,"background",DefaultTileBackground);;N   resource_value=XGetResourceClass(resource_database,ClientName,"borderWidth",     DefaultTileBorderwidth);2   resource_info.border_width=atoi(resource_value);&   resource_info.font=image_info->font;H   resource_info.foreground_color=XGetResourceInstance(resource_database,3     ClientName,"foreground",DefaultTileForeground); F   resource_info.image_geometry=XGetResourceInstance(resource_database,4     ClientName,"imageGeometry",DefaultTileGeometry);N   resource_info.matte_color=XGetResourceInstance(resource_database,ClientName,#     "mattecolor",DefaultTileMatte);e   /*/     Read each image and convert them to a tile.\   */   j=0;"   for (i=0; i < number_files; i++)   {      local_info=(*image_info);e)     if (local_info.size == (char *) NULL) 3       local_info.size=resource_info.image_geometry; $     local_info.filename=filelist[i];     *local_info.magick='\0';!     image=ReadImage(&local_info);      free((char *) filelist[i]);m      if (image == (Image *) NULL)       continue;(     image->scene=j;o     LabelImage(image,"%f");-F     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)       DescribeImage(image);)     images[j]=image;     j++;   }e   free((char *) filelist);   /*&     Create the visual image directory.   */!   XGetMontageInfo(&montage_info);m   montage_info.number_tiles=j;   image=(Image *) NULL;*%   if (montage_info.number_tiles != 0)l=     image=XMontageImage(display,&resource_info,&montage_info,v#       image_info->filename,images);;   XCloseDisplay(display);=   free((char *) images);   if (image == (Image *) NULL)     { =       Warning("VID translation failed",image_info->filename);)       return((Image *) NULL);-     }=   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             % O %                                                                             %=O %                                                                             % O %   R e a d V I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %uM %  Function ReadVIFFImage reads a Khoros Visualization image file and returns%I %  it.  It allocates the memory necessary for the new Image structure and & %  returns a pointer to the new image. % . %  The format of the ReadVIFFImage routine is: % & %      image=ReadVIFFImage(image_info) % + %  A description of each parameter follows:  % I %    o image: Function ReadVIFFImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */' static Image *ReadVIFFImage(image_info) 	 ImageInfo    *image_info; {  #define VFF_CM_genericRGB  15% #define VFF_CM_ntscRGB  1% #define VFF_CM_NONE  0 #define VFF_DEP_DECORDER  0x4n #define VFF_DEP_NSORDER  0x8 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1m #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_MS_SHARED  3 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1  #define VFF_TYP_2_BYTE  2r #define VFF_TYP_4_BYTE  4o     typedef struct _ViffHeader   {n     unsigned chari       identifier,r       file_type,       release,       version,       machine_dependency,i       reserve[3];b       char       comment[512];S       unsigned long        rows,s       columns,       subrows;       long       x_offset,o       y_offset;   	     float        x_pixel_size,a       y_pixel_size;n       unsigned long,       location_type,       location_dimension,g       number_of_images,;       number_data_bands,       data_storage_type,       data_encode_scheme,%       map_scheme,        map_storage_type,        map_rows,        map_columns,       map_subrows,       map_enable,        maps_per_cycle,        color_space_model;   } ViffHeader;      Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      buffer[7],     *viff_pixels;      unsigned int     bytes_per_pixel,     status;      unsigned long      packets;     ViffHeader     viff_header;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)m     {e5       Warning("Unable to open file",image->filename);p       DestroyImage(image);       return((Image *) NULL);e     }    /*"     Read VIFF header (1024 bytes).   */D   status=ReadData((char *) &viff_header.identifier,1,1,image->file);   do   {(     /*       Verify VIFF identifier.a     */N     if ((status == False) || ((unsigned char) viff_header.identifier != 0xab))       {f6         Warning("Not a VIFF raster,",image->filename);         DestroyImages(image);          return((Image *) NULL);        }o     /*       Initialize VIFF image.     */5     (void) ReadData((char *) buffer,1,7,image->file);g$     viff_header.file_type=buffer[0];"     viff_header.release=buffer[1];"     viff_header.version=buffer[2];-     viff_header.machine_dependency=buffer[3]; D     (void) ReadData((char *) viff_header.comment,1,512,image->file);"     viff_header.comment[511]='\0';.     if ((int) strlen(viff_header.comment) > 4)       {           image->comments=(char *)N           malloc((unsigned int) (strlen(viff_header.comment)+1)*sizeof(char));-         if (image->comments == (char *) NULL)r           { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image);D#             return((Image *) NULL);            }n;         (void) strcpy(image->comments,viff_header.comment);        }m?     if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||g<         (viff_header.machine_dependency == VFF_DEP_NSORDER))       {,7         viff_header.rows=LSBFirstReadLong(image->file); :         viff_header.columns=LSBFirstReadLong(image->file);:         viff_header.subrows=LSBFirstReadLong(image->file);;         viff_header.x_offset=LSBFirstReadLong(image->file);e;         viff_header.y_offset=LSBFirstReadLong(image->file);CG         viff_header.x_pixel_size=(float) LSBFirstReadLong(image->file);IG         viff_header.y_pixel_size=(float) LSBFirstReadLong(image->file);o@         viff_header.location_type=LSBFirstReadLong(image->file);E         viff_header.location_dimension=LSBFirstReadLong(image->file);dC         viff_header.number_of_images=LSBFirstReadLong(image->file);;D         viff_header.number_data_bands=LSBFirstReadLong(image->file);D         viff_header.data_storage_type=LSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=LSBFirstReadLong(image->file);t=         viff_header.map_scheme=LSBFirstReadLong(image->file);tC         viff_header.map_storage_type=LSBFirstReadLong(image->file);e;         viff_header.map_rows=LSBFirstReadLong(image->file); >         viff_header.map_columns=LSBFirstReadLong(image->file);>         viff_header.map_subrows=LSBFirstReadLong(image->file);=         viff_header.map_enable=LSBFirstReadLong(image->file); A         viff_header.maps_per_cycle=LSBFirstReadLong(image->file);;D         viff_header.color_space_model=LSBFirstReadLong(image->file);       }g     else       {-7         viff_header.rows=MSBFirstReadLong(image->file); :         viff_header.columns=MSBFirstReadLong(image->file);:         viff_header.subrows=MSBFirstReadLong(image->file);;         viff_header.x_offset=MSBFirstReadLong(image->file); ;         viff_header.y_offset=MSBFirstReadLong(image->file); G         viff_header.x_pixel_size=(float) MSBFirstReadLong(image->file);eG         viff_header.y_pixel_size=(float) MSBFirstReadLong(image->file);c@         viff_header.location_type=MSBFirstReadLong(image->file);E         viff_header.location_dimension=MSBFirstReadLong(image->file); C         viff_header.number_of_images=MSBFirstReadLong(image->file);hD         viff_header.number_data_bands=MSBFirstReadLong(image->file);D         viff_header.data_storage_type=MSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=MSBFirstReadLong(image->file);t=         viff_header.map_scheme=MSBFirstReadLong(image->file);aC         viff_header.map_storage_type=MSBFirstReadLong(image->file);g;         viff_header.map_rows=MSBFirstReadLong(image->file);m>         viff_header.map_columns=MSBFirstReadLong(image->file);>         viff_header.map_subrows=MSBFirstReadLong(image->file);=         viff_header.map_enable=MSBFirstReadLong(image->file); A         viff_header.maps_per_cycle=MSBFirstReadLong(image->file);mD         viff_header.color_space_model=MSBFirstReadLong(image->file);       }      for (i=0; i < 420; i++)r        (void) fgetc(image->file);     /*.       Verify that we can read this VIFF image.     */4     if ((viff_header.columns*viff_header.rows) == 0)       {)M         Warning("Image column or row size is not supported",image->filename);l         DestroyImages(image);)         return((Image *) NULL);o       } 9     if ((viff_header.data_storage_type != VFF_TYP_BIT) &&L<         (viff_header.data_storage_type != VFF_TYP_1_BYTE) &&<         (viff_header.data_storage_type != VFF_TYP_2_BYTE) &&:         (viff_header.data_storage_type != VFF_TYP_4_BYTE))       {aF         Warning("Data storage type is not supported",image->filename);         DestroyImages(image);          return((Image *) NULL);m       } 6     if (viff_header.data_encode_scheme != VFF_DES_RAW)       {5I         Warning("Data encoding scheme is not supported",image->filename);          DestroyImages(image);          return((Image *) NULL);        }w<     if ((viff_header.map_storage_type != VFF_MAPTYP_NONE) &&<         (viff_header.map_storage_type != VFF_MAPTYP_1_BYTE))       { E         Warning("Map storage type is not supported",image->filename);;         DestroyImages(image);          return((Image *) NULL);        }=9     if ((viff_header.color_space_model != VFF_CM_NONE) &&g<         (viff_header.color_space_model != VFF_CM_ntscRGB) &&=         (viff_header.color_space_model != VFF_CM_genericRGB))e       { F         Warning("Color space model is not supported",image->filename);         DestroyImages(image);i         return((Image *) NULL);r       }h6     if (viff_header.location_type != VFF_LOC_IMPLICIT)       {rB         Warning("Location type is not supported",image->filename);         DestroyImages(image);s         return((Image *) NULL);r       }u*     if (viff_header.number_of_images != 1)       {UE         Warning("Number of images is not supported",image->filename);          DestroyImages(image);          return((Image *) NULL);        } #     switch (viff_header.map_scheme)s     {        case VFF_MS_NONE:s       { .         if (viff_header.number_data_bands < 3)           {              /*'               Create linear color ramp.              */=             if (viff_header.data_storage_type == VFF_TYP_BIT)                image->colors=2;             elseC               image->colors=1 << (viff_header.number_data_bands*8); +             image->colormap=(ColorPacket *)v8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)               { A                 Warning("Memory allocation error",(char *) NULL);s'                 return((Image *) NULL);                }w-             for (i=0; i < image->colors; i++)n
             { B               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);a
             }a           }          break;       }(       case VFF_MS_ONEPERBAND:m       case VFF_MS_SHARED:        {          unsigned charr           *viff_colormap;   
         /*$           Read VIFF raster colormap.
         */.         image->colors=viff_header.map_columns;'         image->colormap=(ColorPacket *)v4           malloc(image->colors*sizeof(ColorPacket));'         viff_colormap=(unsigned char *)R6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||6             (viff_colormap == (unsigned char *) NULL))           { =             Warning("Memory allocation error",(char *) NULL);g!             DestroyImages(image);p#             return((Image *) NULL);            }mL         (void) ReadData((char *) viff_colormap,1,image->colors,image->file);)         for (i=0; i < image->colors; i++) 	         {a2           image->colormap[i].red=viff_colormap[i];4           image->colormap[i].green=viff_colormap[i];3           image->colormap[i].blue=viff_colormap[i]; 	         }-%         if (viff_header.map_rows > 1)            {lP             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++) 8               image->colormap[i].green=viff_colormap[i];           } %         if (viff_header.map_rows > 2)m           {oP             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++)u7               image->colormap[i].blue=viff_colormap[i];-           }m%         free((char *) viff_colormap);e         break;       }        default:       { B         Warning("Colormap type is not supported",image->filename);         DestroyImages(image);e         return((Image *) NULL);        }g     }-     /*       Allocate VIFF pixels.      */     bytes_per_pixel=1;8     if (viff_header.data_storage_type == VFF_TYP_2_BYTE)       bytes_per_pixel=2;8     if (viff_header.data_storage_type == VFF_TYP_4_BYTE)       bytes_per_pixel=4;5     if (viff_header.data_storage_type == VFF_TYP_BIT)p>       packets=((viff_header.columns+7) >> 3)*viff_header.rows;     else       packets=K         viff_header.columns*viff_header.rows*viff_header.number_data_bands; !     viff_pixels=(unsigned char *)e<       malloc(bytes_per_pixel*packets*sizeof(unsigned char));.     if (viff_pixels == (unsigned char *) NULL)       {)9         Warning("Memory allocation error",(char *) NULL);)         DestroyImages(image);a         return((Image *) NULL);;       }iP     (void) ReadData((char *) viff_pixels,bytes_per_pixel,(unsigned int) packets,       image->file); 8     if (viff_header.data_storage_type == VFF_TYP_2_BYTE)       {          register short int
           *p;            register unsigned char
           *q;            short intp           max_value,           min_value,           value;           unsigned long            scale_factor;>  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||c@             (viff_header.machine_dependency == VFF_DEP_NSORDER))3           MSBFirstOrderShort((char *) &viff_header,x6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor.5
         */$         p=(short int *) viff_pixels;         max_value=(*p);o         min_value=(*p);r#         for (i=0; i < packets; i++)a	         {x           if (*p > max_value)k             max_value=(*p);            else             if (*p < min_value)m               min_value=(*p);            p++;	         } 1         if ((min_value == 0) && (max_value == 0))p           scale_factor=0;i         else%           if (min_value == max_value)r
             {e5               scale_factor=UpShift(MaxRGB)/min_value;                min_value=0;
             }            else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value);)
         /*.           Scale integer pixels to [0..MaxRGB].
         */$         p=(short int *) viff_pixels;         q=viff_pixels;#         for (i=0; i < packets; i++) 	         {t7           value=DownShift((*p-min_value)*scale_factor);            if (value > MaxRGB)              value=MaxRGB;            else             if (value < 0)               value=0;#           *q=(unsigned char) value;r           p++;           q++;	         },       }C8     if (viff_header.data_storage_type == VFF_TYP_4_BYTE)       {o         int=           max_value,           min_value,           value;           register int
           *p;            register unsigned char
           *q;;           unsigned long%           scale_factor;%  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || @             (viff_header.machine_dependency == VFF_DEP_NSORDER))2           MSBFirstOrderLong((char *) &viff_header,6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor. 
         */         p=(int *) viff_pixels;         max_value=(*p);          min_value=(*p); #         for (i=0; i < packets; i++) 	         {            if (*p > max_value)              max_value=(*p);            else             if (*p < min_value)%               min_value=(*p);%           p++;	         }F1         if ((min_value == 0) && (max_value == 0))h           scale_factor=0;I         else%           if (min_value == max_value)r
             {r5               scale_factor=UpShift(MaxRGB)/min_value;f               min_value=0;
             }i           else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value); 
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=(int *) viff_pixels;         q=viff_pixels;#         for (i=0; i < packets; i++)i	         { 7           value=DownShift((*p-min_value)*scale_factor);t           if (value > MaxRGB)              value=MaxRGB;e           else             if (value < 0)               value=0;#           *q=(unsigned char) value;c           p++;           q++;	         }        }i     /*!       Initialize image structure.n     */6     image->matte=(viff_header.number_data_bands == 4);     image->class=tF       (viff_header.number_data_bands < 3 ? PseudoClass : DirectClass);$     image->columns=viff_header.rows;$     image->rows=viff_header.columns;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { 9         Warning("Memory allocation error",(char *) NULL);s         DestroyImages(image);n         return((Image *) NULL);c       }      /*=       Convert VIFF raster image to runlength-encoded packets.i     */     p=viff_pixels;     q=image->pixels;5     if (viff_header.data_storage_type == VFF_TYP_BIT)m       {L         unsigned int           polarity;p  
         /*E           Convert bitmap scanline to runlength-encoded color packets.a
         */H         polarity=(viff_header.machine_dependency == VFF_DEP_DECORDER) ||>           (viff_header.machine_dependency == VFF_DEP_NSORDER);'         for (y=0; y < image->rows; y++)d	         {e           /*G             Convert bitmap scanline to runlength-encoded color packets.(           */3           for (x=0; x < (image->columns >> 3); x++)            {('             for (bit=0; bit < 8; bit++) 
             {aE               q->index=((*p) & (0x01 << bit) ? polarity : !polarity);a               q->length=0;               q++;
             })             p++;           }e(           if ((image->columns % 8) != 0)
             {&<               for (bit=0; bit < (image->columns % 8); bit++)               {hG                 q->index=((*p) & (0x01 << bit) ? polarity : !polarity);                  q->length=0;                 q++;               }t               p++;
             } 	         }e       }z     else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++)s	         {i           /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {e             q->index=(*p++);             q->length=0;             q++;           }=	         }t
       else	         {o           unsigned longo             offset;)             /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           offset=image->columns*image->rows;)           for (y=0; y < image->rows; y++),           {).             for (x=0; x < image->columns; x++)
             {L               q->red=(*p);%               q->green=(*(p+offset));c&               q->blue=(*(p+offset*2));%               if (image->colors != 0)+                 {m5                   q->red=image->colormap[q->red].red;g;                   q->green=image->colormap[q->green].green; 8                   q->blue=image->colormap[q->blue].blue;                 }iM               q->index=(unsigned short) (image->matte ? (*(p+offset*3)) : 0);s               q->length=0;               p++;               q++;
             }d           }f	         }      free((char *) viff_pixels);i$     if (image->class == PseudoClass)       {e         SyncImage(image);=          CompressColormap(image);       }e     /*       Proceed to next image.     */F     status=ReadData((char *) &viff_header.identifier,1,1,image->file);=     if ((status == True) && (viff_header.identifier == 0xab))e       {a
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {p!             DestroyImages(image);f#             return((Image *) NULL);            }cB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }eA   } while ((status == True) && (viff_header.identifier == 0xab));e+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }- l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %vO %                                                                             %cO %                                                                             %iO %   R e a d X I m a g e                                                       %oO %                                                                             %-O %                                                                             %mO %                                                                             %cO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %18 %  Procedure ReadXImage reads an image from an X window. %c+ %  The format of the ReadXImage routine is:c %r@ %      image=ReadXImage(image_info,frame,borders,screen,descend) % + %  A description of each parameter follows:  % A %    o image_info: Specifies a pointer to an ImageInfo structure.n % L %    o frame: Specifies whether to include the window manager frame with the
 %      image.  % E %    o borders: Specifies whether borders pixels are to be saved witho %      the image.  % N %    o screen: Specifies whether the GetImage request used to obtain the imageO %      should be done on the root window, rather than directly on the specified  %      window. %oO %    o descend: If this option is zero, check to see if the WM_COLORMAP_WINDOWSuJ %      property is set or if XListInstalledColormaps returns more than oneG %      colormap.  If so, the image is obtained by descending the windowr= %      hierarchy and reading each subwindow and its colormap.  %  %  */: Image *ReadXImage(image_info,frame,borders,screen,descend)	 ImageInfo-   *image_info;   unsigned int   frame,
   borders,	   screen,s
   descend; { 
   Colormap     *colormaps;   	   Displayn
     *display;      Image      *image;      int0     status,r     x;     RectangleInfo      crop_info;     Window     *children,     client,r	     root,      target;      XTextProperty_     window_name;     /*     Open X server connection.p   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {a.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return((Image *) NULL);s     }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*     Select target window.    */   crop_info.x=0;   crop_info.y=0;   crop_info.width=0;   crop_info.height=0;i4   root=XRootWindow(display,XDefaultScreen(display));   target=(Window) NULL; 0   if ((image_info->filename != (char *) NULL) &&&       (*image_info->filename != '\0'))8     if (Latin1Compare(image_info->filename,"root") == 0)       target=root;     else       {7
         /*&           Select window by ID or name.
         */+         if (isdigit(*image_info->filename)) O           target=XWindowByID(display,root,(Window) strtol(image_info->filename,              (char **) NULL,0));i$         if (target == (Window) NULL)B           target=XWindowByName(display,root,image_info->filename);$         if (target == (Window) NULL)M           Warning("No window with specified id exists",image_info->filename);n       }    /*>     If target window is not defined, interactively select one.   */   if (target == (Window) NULL)-     target=XSelectWindow(display,&crop_info);    client=target;   if (target != root)+     {        unsigned int
         d;  B       status=XGetGeometry(display,target,&root,&x,&x,&d,&d,&d,&d);       if (status != 0)	         {&           if (frame)             for ( ; ; ) 
             {                Window                 parent;                  /**                 Find window manager frame.               */K               status=XQueryTree(display,target,&root,&parent,&children,&d); K               if (!status || (parent == (Window) NULL) || (parent == root))i                 break;               target=parent;:               if (status && (children != (Window *) NULL)))                 XFree((char *) children); 
             }            /*             Get client window.           *//           client=XClientWindow(display,target);            if (!frame)              target=client;	         }      } 
   if (screen)      { 	       intp
         y;         Window         child;         XWindowAttributes          window_attributes;         /*1         Obtain window image directly from screen.+       */E       status=XGetWindowAttributes(display,target,&window_attributes);        if (status == False)	         {fM           Warning("Unable to read X window attributes",image_info->filename); !           XCloseDisplay(display); !           return((Image *) NULL); 	         } B       XTranslateCoordinates(display,target,root,0,0,&x,&y,&child);       crop_info.x=x;       crop_info.y=y;.       crop_info.width=window_attributes.width;0       crop_info.height=window_attributes.height;       if (borders)	         {            /*$             Include border in image.           */6           crop_info.x-=window_attributes.border_width;6           crop_info.y-=window_attributes.border_width;?           crop_info.width+=window_attributes.border_width << 1;e@           crop_info.height+=window_attributes.border_width << 1;	         }u       target=root;     }m   if (descend)     {(	       int;         number_colormaps,=         number_windows;          /*N         If WM_COLORMAP_WINDOWS property is set or multiple colormaps, descend.       */       descend=False;       number_windows=0;>M       status=XGetWMColormapWindows(display,target,&children,&number_windows);i3       if ((status == True) && (number_windows > 0)) 	         {g           descend=True; $           XFree ((char *) children);	         }fJ       colormaps=XListInstalledColormaps(display,target,&number_colormaps);       if (number_colormaps > 0);	         {i#           if (number_colormaps > 1)%             descend=True;%$           XFree((char *) colormaps);	         }      }    /*+     Alert the user not to alter the screen.    */   XBell(display,0);    /*     Get image by window id.    */   XGrabServer(display); 8   image=XGetWindowImage(display,target,borders,descend);   XUngrabServer(display);d6   (void) strcpy(image->filename,image_info->filename);   if (image == (Image *) NULL)B     Warning("Unable to read X window image",image_info->filename);   else     { <       if ((crop_info.width != 0) && (crop_info.height != 0))	         {            Image              *cropped_image;              /*<             Crop image as defined by the cropping rectangle.           */4           cropped_image=CropImage(image,&crop_info);.           if (cropped_image != (Image *) NULL)
             {t"               DestroyImage(image);"               image=cropped_image;
             }t	         }m5       status=XGetWMName(display,target,&window_name);:       if (status == True)I	         {i8           if ((image_info->filename != (char *) NULL) &&.               (*image_info->filename == '\0'))
             {e               /**                 Initialize image filename.               */H               (void) strncpy(image->filename,(char *) window_name.value,*                 (int) window_name.nitems);7               image->filename[window_name.nitems]='\0'; 
             }i	         }      }h   /*     Alert the user we're done.   */   XBell(display,0);n   XBell(display,0);    XCloseDisplay(display);-   return(image); }a m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %*O %                                                                             %eO %                                                                             % O %  R e a d X B M I m a g e                                                    % O %                                                                             %fO %                                                                             %(O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %aK %  Function ReadXBMImage reads an X11 bitmap image file and returns it.  IttK %  allocates the memory necessary for the new Image structure and returns at %  pointer to the new image. %=- %  The format of the ReadXBMImage routine is:  %a% %      image=ReadXBMImage(image_info); % + %  A description of each parameter follows:% %%I %    o image:  Function ReadXBMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static int XBMInteger(file,hex_digits) FILE   *file;  	 short int    *hex_digits; {    int      c,	     flag, 
     value;  
   value=0;	   flag=0; 
   for ( ; ; )    {      c=getc(file);      if (c == EOF)        {          value=(-1);          break;       }      c&=0xff;"     if (isascii(c) && isxdigit(c))       { )         value=(value << 4)+hex_digits[c];%         flag++;%         continue;%       }%$     if ((hex_digits[c]) < 0 && flag)       break;   }    return(value); }   & static Image *ReadXBMImage(image_info)	 ImageInfor   *image_info; {c   char     buffer[MaxTextLength],     name[MaxTextLength];     Imagee     *image;      register int     x,     y;     register RunlengthPacket     *q;p     register unsigned char     *p;      register unsigned shortN
     index;     short int      hex_digits[256];     unsigned char      bit,
     *data;     unsigned int	     byte,r     bytes_per_line,      packets,     padding,
     value,     version;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);u       DestroyImage(image);       return((Image *) NULL);i     }    /*     Read X bitmap header.    */D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)?     if (sscanf(buffer,"#define %*32s %u",&image->columns) == 1)        break;D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)<     if (sscanf(buffer,"#define %*32s %u",&image->rows) == 1)       break;   /*     Scan until hex digits.   */
   version=11;hD   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)   {-7     if (sscanf(buffer,"static short %s = {",name) == 1)f       version=10;s     elseA       if (sscanf(buffer,"static unsigned char %s = {",name) == 1)<         version=11;m
       else:         if (sscanf(buffer,"static char %s = {",name) == 1)           version=11;          else           continue;=)     p=(unsigned char *) strchr(name,'_'); $     if (p == (unsigned char *) NULL)       p=(unsigned char *) name;      else
       p++;)     if (strcmp("bits[]",(char *) p) == 0)=       break;   } G   if ((image->columns == 0) || (image->rows == 0) || feof(image->file))-     {tG       Warning("XBM file is not in the correct format",image->filename);n       DestroyImage(image);       return((Image *) NULL);      }    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)m3     malloc(image->packets*sizeof(RunlengthPacket));    padding=0;O   if ((image->columns % 16) && ((image->columns % 16) < 9)  && (version == 10))l     padding=1;.   bytes_per_line=(image->columns+7)/8+padding;%   packets=bytes_per_line*image->rows;iA   data=(unsigned char *) malloc(packets*sizeof(unsigned char *));t4   if ((image->pixels == (RunlengthPacket *) NULL) ||'       (data == (unsigned char *) NULL))      {n7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);c     }    /*     Create colormap.   */   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)     {a7       Warning("Memory allocation error",(char *) NULL);t       DestroyImage(image);       return((Image *) NULL);      }    image->colormap[0].red=0;t   image->colormap[0].green=0;1   image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    /*     Initialize hex values.   */   hex_digits['0']=0;   hex_digits['1']=1;   hex_digits['2']=2;   hex_digits['3']=3;   hex_digits['4']=4;   hex_digits['5']=5;   hex_digits['6']=6;   hex_digits['7']=7;   hex_digits['8']=8;   hex_digits['9']=9;   hex_digits['A']=10;l   hex_digits['B']=11;0   hex_digits['C']=12;I   hex_digits['D']=13;    hex_digits['E']=14;o   hex_digits['F']=15;    hex_digits['a']=10;)   hex_digits['b']=11;n   hex_digits['c']=12;g   hex_digits['d']=13;e   hex_digits['e']=14;n   hex_digits['f']=15;    hex_digits[' ']=(-1);R   hex_digits[',']=(-1);    hex_digits['}']=(-1);e   hex_digits['\n']=(-1);   hex_digits['\t']=(-1);   /*     Read hex image data.   */	   p=data;(   if (version == 10)"     for (x=0; x < packets; (x+=2))     {(/       value=XBMInteger(image->file,hex_digits);        *p++=value; /       if (!padding || ((x+2) % bytes_per_line))          *p++=value >> 8;     }_   else     for (x=0; x < packets; x++)u     { /       value=XBMInteger(image->file,hex_digits);        *p++=value;      }    /*8     Convert X bitmap image to runlength-encoded packets.   */	   p=data;(   q=image->pixels;!   for (y=0; y < image->rows; y++)    {n
     bit=0;&     for (x=0; x < image->columns; x++)     {a       if (bit == 0)e         byte=(*p++);"       index=(byte & 0x01) ? 0 : 1;(       q->red=image->colormap[index].red;,       q->green=image->colormap[index].green;*       q->blue=image->colormap[index].blue;       q->index=index;>       q->length=0;
       q++;       bit++;       byte>>=1;t       if (bit == 8)          bit=0;     }r   }c   CloseImage(image);   return(image); }P d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %mO %                                                                             % O %                                                                             % O %  R e a d X C I m a g e                                                      %oO %                                                                             %dO %                                                                             %iO %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % G %  Function ReadXCImage creates a constant image and initializes to the H %  X server color as specified by the filename.  It allocates the memoryI %  necessary for the new Image structure and returns a pointer to the newp	 %  image.  % , %  The format of the ReadXCImage routine is: % $ %      image=ReadXCImage(image_info) %r+ %  A description of each parameter follows:c %rH %    o image:  Function ReadXCImage returns a pointer to the image afterL %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %t %( */% static Image *ReadXCImage(image_info)R	 ImageInfo*   *image_info; { 	   Displayo
     *display;d     Image      *image;      into     x,     y;     register int     i;     register RunlengthPacket     *q;e     unsigned int     height, 
     width;     XPixelInfo     pixel_info;m     XResourceInfoa     resource_info;  
   XrmDatabase      resource_database;     XStandardColormapr     *map_info;  
   XVisualInfo      *visual_info;a     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);t   /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {e.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));m       DestroyImage(image);       return((Image *) NULL);      }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.0   */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");s   else     {(       /*         Initialize visual info.M       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL;t     } 1   if ((map_info == (XStandardColormap *) NULL) ||r,       (visual_info == (XVisualInfo *) NULL))     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);      }e   /*6     Determine image color-- specified by the filename.   */$   if (*image_info->filename != '\0')8     resource_info.background_color=image_info->filename;H   XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),     map_info);K   XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,      &pixel_info);oF   pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);B   /*     Initialize Image structure.    */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)a3     malloc(image->packets*sizeof(RunlengthPacket));    image->class=PseudoClass;n   image->colors=1;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))     { D       Warning("Unable to allocate image","Memory allocation error");F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);p     }    /*     Initialize colormap.   */E   image->colormap[0].red=ColorShift(pixel_info.background_color.red);+I   image->colormap[0].green=ColorShift(pixel_info.background_color.green); G   image->colormap[0].blue=ColorShift(pixel_info.background_color.blue);-   q=image->pixels;$   for (i=0; i < image->packets; i++)   {x     q->index=0;l     q->length=0;     q++;   }    SyncImage(image);m   /*     Free resources.(   */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   return(image); }/   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             % O %                                                                             %FO %  R e a d X P M I m a g e                                                    %=O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eK %  Function ReadXBMImage reads an X11 pixmap image file and returns it.  It,K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadXPMImage routine is:  % % %      image=ReadXPMImage(image_info)u %(+ %  A description of each parameter follows:e % I %    o image:  Function ReadXPMImage returns a pointer to the image after L %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. %-A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasXPMo #include "xpm.h"& static Image *ReadXPMImage(image_info)	 ImageInfoa   *image_info; {    char     *resource_value,     *xpm_buffer;  	   Display 
     *display;i     Image      *image;l     int      length,+     status,      x,     y;     register char      *q;r     register int     i;     register RunlengthPacket     *p;P     register unsigned long
     pixel;     XColor     *colors;     XImage     *matte_image,      *ximage;     XpmAttributes=     xpm_attributes;L     XResourceInfor     resource_info;  
   XrmDatabase      resource_database;     XStandardColormap      *map_info;  
   XVisualInfo.     *visual_info;f     /*     Allocate image structure.r   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);s   /*     Open image file.   */   OpenImage(image,"r"); #   if (image->file == (FILE *) NULL)l     {a5       Warning("Unable to open file",image->filename);i       DestroyImage(image);       return((Image *) NULL);      }a   /*     Read XPM file.   */   length=MaxTextLength; 2   xpm_buffer=(char *) malloc(length*sizeof(char));"   if (xpm_buffer != (char *) NULL)     {)       q=xpm_buffer; C       while (fgets(q,MaxTextLength-1,image->file) != (char *) NULL)        {*         q+=strlen(q);(2         if ((q-xpm_buffer+MaxTextLength) > length)           {-             *q='\0';             length<<=1;i             xpm_buffer=(char *)x?               realloc((char *) xpm_buffer,length*sizeof(char));l,             if (xpm_buffer == (char *) NULL)               break;,             q=xpm_buffer+strlen(xpm_buffer);           }e       }      }n"   if (xpm_buffer == (char *) NULL)     {%E       Warning("Unable to read XPM image","Memory allocation failed");        DestroyImage(image);       return((Image *) NULL);      }t   CloseImage(image);   /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        DestroyImage(image);       return((Image *) NULL);      }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);m   /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)uM     Warning("Unable to create standard colormap","Memory allocation failed");i   else     {        /*         Initialize visual info.d       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;      }a1   if ((map_info == (XStandardColormap *) NULL) ||u,       (visual_info == (XVisualInfo *) NULL))     {oF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);      }v   /*     Initialize X colormap.   */-   map_info->colormap=XCreateColormap(display,mA     XRootWindow(display,visual_info->screen),visual_info->visual, >     visual_info->class == DirectColor ? AllocAll : AllocNone);,   if (map_info->colormap == (Colormap) NULL)     { 9       Warning("Unable to create colormap",(char *) NULL); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);      }    /*     Initialize XPM attributes.   */L   xpm_attributes.valuemask=XpmColorKey | XpmColormap | XpmDepth | XpmVisual;,   xpm_attributes.visual=visual_info->visual;-   xpm_attributes.colormap=map_info->colormap;e*   xpm_attributes.depth=visual_info->depth;%   xpm_attributes.color_key=XPM_COLOR;n   /*>     Read in a file in the XPM format into a X image structure.   */J   status=XpmCreateImageFromBuffer(display,xpm_buffer,&ximage,&matte_image,     &xpm_attributes);    if (status != XpmSuccess)m     {08       Warning("Unable to read XPM image",(char *) NULL);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);B     }B   free((char *) xpm_buffer);%   XpmFreeAttributes(&xpm_attributes);    /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {i9       Warning("Unable to read X colormap",(char *) NULL);,F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);       DestroyImage(image);       return((Image *) NULL);p     } O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor)) 2     for (i=0; i < visual_info->colormap_size; i++)     {d       colors[i].pixel=i;       colors[i].pad=0;     }    else     {        unsigned longt
         blue,          blue_bit,m         green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0; C       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1);-I       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1);aF       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       { +         colors[i].pixel=red | green | blue;          colors[i].pad=0;         red+=red_bit;e(         if (red > visual_info->red_mask)           red=0;         green+=green_bit;r,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit;x*         if (blue > visual_info->blue_mask)           blue=0;y       }o     } M   XQueryColors(display,map_info->colormap,colors,visual_info->colormap_size);    /*#     Convert X image to MIFF format.o   */O   if ((visual_info->class != TrueColor) && (visual_info->class != DirectColor))      image->class=PseudoClass;s   image->columns=ximage->width;o   image->rows=ximage->height;a,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)i3     malloc(image->packets*sizeof(RunlengthPacket));l0   if (image->pixels == (RunlengthPacket *) NULL)     {i       free((char *) colors);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);       DestroyImage(image);       return((Image *) NULL);      }v   p=image->pixels;   switch (image->class))   {f     case DirectClass:=     {*       register unsigned long         color,         index;         unsigned longm         blue_mask,         blue_shift,s         green_mask,e         green_shift,         red_mask,r         red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;        red_shift=0;$       while ((red_mask & 0x01) == 0)       {F         red_mask>>=1;e         red_shift++;       }f)       green_mask=visual_info->green_mask;r       green_shift=0;&       while ((green_mask & 0x01) == 0)       {m         green_mask>>=1;          green_shift++;       }S'       blue_mask=visual_info->blue_mask;        blue_shift=0;P%       while ((blue_mask & 0x01) == 0)o       {e         blue_mask>>=1;         blue_shift++;        }u       /*/         Convert X image to DirectClass packets.f       */-       if ((visual_info->colormap_size > 0) &&l.           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++)r	         {t,           for (x=0; x < image->columns; x++)           {N(             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=ColorShift(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=ColorShift(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=ColorShift(colors[index].blue);              p->index=0;g             p->length=0;             p++;           }e	         } 
       else'         for (y=0; y < image->rows; y++)t,           for (x=0; x < image->columns; x++)           {l(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;F             p->red=ColorShift(((unsigned long) color*65535)/red_mask);6             color=(pixel >> green_shift) & green_mask;J             p->green=ColorShift(((unsigned long) color*65535)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;H             p->blue=ColorShift(((unsigned long) color*65535)/blue_mask);             p->index=0;E             p->length=0;             p++;           }        break;     }      case PseudoClass:      {        /*         Create colormap.       *//       image->colors=visual_info->colormap_size; P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {%            free((char *) colors);J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);            XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL); 	         }a'       for (i=0; i < image->colors; i++)r       { G         image->colormap[colors[i].pixel].red=ColorShift(colors[i].red);eK         image->colormap[colors[i].pixel].green=ColorShift(colors[i].green); I         image->colormap[colors[i].pixel].blue=ColorShift(colors[i].blue);        }i       /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++)_*         for (x=0; x < image->columns; x++)	         {m:           p->index=(unsigned short) XGetPixel(ximage,x,y);           p->length=0;           p++;	         }t       SyncImage(image);a       break;     }    } %   if (matte_image != (XImage *) NULL)f     {        /*         Initialize image matte.L       */       image->class=DirectClass;p       image->matte=True;       p=image->pixels;%       for (y=0; y < image->rows; y++) *         for (x=0; x < image->columns; x++)	         {a           p->index=Opaque;*           if (!XGetPixel(matte_image,x,y))!             p->index=Transparent;a           p++;	         }a!       XDestroyImage(matte_image);e     }i"   if (image->class == PseudoClass)     CompressColormap(image);   /*     Free resources.m   */   free((char *) colors);   XDestroyImage(ximage);B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   return(image); }m #elsed& static Image *ReadXPMImage(image_info)	 ImageInfo>   *image_info; {m?   Warning("XPM library is not available",image_info->filename);o$   return(ReadMIFFImage(image_info)); }e #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %eO %                                                                             %)O %                                                                             %;O %  R e a d X W D I m a g e                                                    %%O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadXWDImage reads an X Window System window dump image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadXWDImage routine is:  % % %      image=ReadXWDImage(image_info)% %%+ %  A description of each parameter follows:% %%I %    o image:  Function ReadXWDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.r % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadXWDImage(image_info)	 ImageInfon   *image_info; {f   char     *window_name;      Imagee     *image;t     inti     status,m     x,     y;     register int     i;     register RunlengthPacket     *q;t     register unsigned shorta
     index;     register unsigned long
     pixel;     unsigned longn     lsb_first;     unsigned int     packets;     XColor     *colors;     XImage     *ximage;     XWDFileHeadere     header;      /*     Allocate image structure.;   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);e     }    /*       Read in header information.   */?   status=ReadData((char *) &header,sz_XWDheader,1,image->file);e   if (status == False)     {tA       Warning("Unable to read dump file header",image->filename);        DestroyImage(image);       return((Image *) NULL);1     }e   /*@     Ensure the header byte-order is most-significant byte first.   */   lsb_first=1;   if (*(char *) &lsb_first) 5     MSBFirstOrderLong((char *) &header,sz_XWDheader);l   /*:     Check to see if the dump file is in the proper format.   */.   if (header.file_version != XWD_FILE_VERSION)     {gB       Warning("XWD file format version mismatch",image->filename);       DestroyImage(image);       return((Image *) NULL);      }r(   if (header.header_size < sz_XWDheader)     {i>       Warning("XWD header size is too small",image->filename);       DestroyImage(image);       return((Image *) NULL);I     }a,   packets=(header.header_size-sz_XWDheader);C   window_name=(char *) malloc((unsigned int) packets*sizeof(char)); #   if (window_name == (char *) NULL),     {p9       Warning("Unable to allocate memory",(char *) NULL);o       DestroyImage(image);       return((Image *) NULL);      } >   status=ReadData((char *) window_name,1,packets,image->file);   if (status == False)     { K       Warning("Unable to read window name from dump file",image->filename);        DestroyImage(image);       return((Image *) NULL);d     }    /*     Initialize the X image.    */+   ximage=(XImage *) malloc(sizeof(XImage));a    if (ximage == (XImage *) NULL)     {r9       Warning("Unable to allocate memory",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);m     }x$   ximage->depth=header.pixmap_depth;&   ximage->format=header.pixmap_format;!   ximage->xoffset=header.xoffset;    ximage->data=(char *) NULL;n$   ximage->width=header.pixmap_width;&   ximage->height=header.pixmap_height;'   ximage->bitmap_pad=header.bitmap_pad;+/   ximage->bytes_per_line=header.bytes_per_line; '   ximage->byte_order=header.byte_order;x)   ximage->bitmap_unit=header.bitmap_unit; 3   ximage->bitmap_bit_order=header.bitmap_bit_order;=/   ximage->bits_per_pixel=header.bits_per_pixel; #   ximage->red_mask=header.red_mask;e'   ximage->green_mask=header.green_mask;n%   ximage->blue_mask=header.blue_mask;o   status=XInitImage(ximage);   if (status == False)     {-2       Warning("Invalid XWD header",(char *) NULL);       DestroyImage(image);       return((Image *) NULL);      }    /*     Read colormap.   */   colors=(XColor *) NULL;+   if (header.ncolors != 0)     {+       XWDColor         color;  M       colors=(XColor *) malloc((unsigned int) header.ncolors*sizeof(XColor));-$       if (colors == (XColor *) NULL)	         {a=           Warning("Unable to allocate memory",(char *) NULL);a           DestroyImage(image);!           return((Image *) NULL);%	         }%(       for (i=0; i < header.ncolors; i++)       { C         status=ReadData((char *) &color,sz_XWDColor,1,image->file);          if (status == False)           { O             Warning("Unable to read color map from dump file",image->filename);               DestroyImage(image);#             return((Image *) NULL);            } $         colors[i].pixel=color.pixel;          colors[i].red=color.red;$         colors[i].green=color.green;"         colors[i].blue=color.blue;$         colors[i].flags=color.flags;       }        /*D         Ensure the header byte-order is most-significant byte first.       */       lsb_first=1;       if (*(char *) &lsb_first)%*         for (i=0; i < header.ncolors; i++)	         {sM           MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(unsigned long));lO           MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(unsigned short));r	         }      }    /*     Allocate the pixel buffer.   */    if (ximage->format == ZPixmap)2     packets=ximage->bytes_per_line*ximage->height;   else@     packets=ximage->bytes_per_line*ximage->height*ximage->depth;>   ximage->data=(char *) malloc(packets*sizeof(unsigned char));$   if (ximage->data == (char *) NULL)     { 9       Warning("Unable to allocate memory",(char *) NULL);s       DestroyImage(image);       return((Image *) NULL);I     }e6   status=ReadData(ximage->data,1,packets,image->file);   if (status == False)     {f<       Warning("Unable to read dump pixmap",image->filename);       DestroyImage(image);       return((Image *) NULL);      }h   /*!     Convert image to MIFF format.a   */   image->columns=ximage->width;n   image->rows=ximage->height;;?   if ((colors == (XColor *) NULL) || (ximage->red_mask != 0) || <       (ximage->green_mask != 0) || (ximage->blue_mask != 0))     image->class=DirectClass;,   else     image->class=PseudoClass;,   image->colors=header.ncolors;i,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     {=9       Warning("Unable to allocate memory",(char *) NULL);p       DestroyImage(image);       return((Image *) NULL);-     }=   q=image->pixels;   switch (image->class)l   {o     case DirectClass:m     {        register unsigned long         color;         unsigned long*         blue_mask,         blue_shift,          green_mask,(         green_shift,         red_mask,(         red_shift;         /*:         Determine shift and mask for red, green, and blue.       */        red_mask=ximage->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;h         red_shift++;       }i$       green_mask=ximage->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {i         green_mask>>=1;r         green_shift++;       })"       blue_mask=ximage->blue_mask;       blue_shift=0;l%       while ((blue_mask & 0x01) == 0)t       {&         blue_mask>>=1;         blue_shift++;        }p       /*/         Convert X image to DirectClass packets.a       */       if (image->colors != 0)g'         for (y=0; y < image->rows; y++)|	         {l,           for (x=0; x < image->columns; x++)           {u(             pixel=XGetPixel(ximage,x,y);E             index=(unsigned short) ((pixel >> red_shift) & red_mask); 1             q->red=ColorShift(colors[index].red);(I             index=(unsigned short) ((pixel >> green_shift) & green_mask);a5             q->green=ColorShift(colors[index].green);rG             index=(unsigned short) ((pixel >> blue_shift) & blue_mask); 3             q->blue=ColorShift(colors[index].blue);              q->index=0;              q->length=0;             q++;           }r	         }s
       else'         for (y=0; y < image->rows; y++) ,           for (x=0; x < image->columns; x++)           {f(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;F             q->red=ColorShift(((unsigned long) color*65535)/red_mask);6             color=(pixel >> green_shift) & green_mask;J             q->green=ColorShift(((unsigned long) color*65535)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;H             q->blue=ColorShift(((unsigned long) color*65535)/blue_mask);             q->index=0;e             q->length=0;             q++;           }        break;     }      case PseudoClass:o     {        /*/         Convert X image to PseudoClass packets.g       */P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         { =           Warning("Unable to allocate memory",(char *) NULL);            DestroyImage(image);!           return((Image *) NULL);=	         }l'       for (i=0; i < image->colors; i++)m       {e9         image->colormap[i].red=ColorShift(colors[i].red);M=         image->colormap[i].green=ColorShift(colors[i].green);a;         image->colormap[i].blue=ColorShift(colors[i].blue);        } %       for (y=0; y < image->rows; y++)s*         for (x=0; x < image->columns; x++)	         {g&           pixel=XGetPixel(ximage,x,y);/           q->red=ColorShift(colors[pixel].red); 3           q->green=ColorShift(colors[pixel].green); 1           q->blue=ColorShift(colors[pixel].blue);l*           q->index=(unsigned short) pixel;           q->length=0;           q++;	         }        CompressColormap(image);       break;     }    }    /*     Free image and colormap.   */   free((char *) window_name);I   if (header.ncolors != 0)     free((char *) colors);   XDestroyImage(ximage);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %jO %                                                                             % O %                                                                             % O %  R e a d Y U V I m a g e                                                    %cO %                                                                             %cO %                                                                             %iO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%& %4O %  Function ReadYUVImage reads an image with digital YUV (CCIR 601 4:1:1) bytes G %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadYUVImage routine is:  % % %      image=ReadYUVImage(image_info)  %=+ %  A description of each parameter follows:e %iI %    o image:  Function ReadYUVImage returns a pointer to the image afterfL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.( %g %f */& static Image *ReadYUVImage(image_info)	 ImageInfon   *image_info; {(   Imagel     *image,      *zoomed_image;     inty     x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;p     unsigned char      *yuv_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.c   */)   zoomed_image=AllocateImage(image_info);+%   if (zoomed_image == (Image *) NULL)      return((Image *) NULL);    /*     Open image file.   */=   (void) strcpy(zoomed_image->filename,image_info->filename);a   OpenImage(zoomed_image,"rb"); *   if (zoomed_image->file == (FILE *) NULL)     {o<       Warning("Unable to open file",zoomed_image->filename);!       DestroyImage(zoomed_image);l       return((Image *) NULL);a     }e   /*-     Determine width and height, e.g. 640x512.a   */   width=512;
   height=512;_(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Read Y channel.(   */#   zoomed_image->columns=width >> 1;p!   zoomed_image->rows=height >> 1;sA   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;    yuv_pixels=(unsigned char *)7     malloc((3*(width*height)/2)*sizeof(unsigned char)); *   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));/   if ((yuv_pixels == (unsigned char *) NULL) || 9       (zoomed_image->pixels == (RunlengthPacket *) NULL))/     { 7       Warning("Memory allocation error",(char *) NULL);f!       DestroyImage(zoomed_image);        return((Image *) NULL);+     } O   (void) ReadData((char *) yuv_pixels,1,3*(width*height)/2,zoomed_image->file);    /*     Initialize U channel.    */   p=yuv_pixels+(width*height);   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)    {      q->green=(*p);     q->index=0;      q->length=0;     p++;     q++;   }n   /*     Initialize V channel.p   */   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)t   {e     q->blue=(*p);      p++;     q++;   }=   /*     Scale image.   */   zoomed_image->orphan=True;    image=ZoomImage(zoomed_image);   zoomed_image->orphan=False;L   DestroyImage(zoomed_image);M   if (image == (Image *) NULL)     {aA       Warning("Unable to read image","Memory allocation failed");        return((Image *) NULL);      }u   p=yuv_pixels;/   q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {t     q->red=(*p);     p++;     q++;   }l   free((char *) yuv_pixels);+   TransformRGBImage(image,YCbCrColorspace);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             % O %                                                                             %aO %  R e a d Y U V 3 I m a g e                                                  %rO %                                                                             %gO %                                                                             %oO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %bJ %  Function ReadYUV3Image reads an image with digital YUV (CCIR 601 2:1:1)M %  bytes and returns it.  It allocates the memory necessary for the new Image-K %  structure and returns a pointer to the new image.  This function differs]J %  from ReadYUVImage in that it reads the Y, U, and V planes from separate) %  files (image.Y, image.U, and image.V).  % . %  The format of the ReadYUV3Image routine is: % & %      image=ReadYUV3Image(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadYUV3Image returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.s %eA %    o image_info: Specifies a pointer to an ImageInfo structure.  %m %- */' static Image *ReadYUV3Image(image_info) 	 ImageInfor   *image_info; {    char     filename[MaxTextLength];     Imageg     *image,      *zoomed_image;     intu     x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char*     *uv_pixels,o     *y_pixels;     unsigned int     height,o
     width;     /*     Allocate image structure.    */)   zoomed_image=AllocateImage(image_info); %   if (zoomed_image == (Image *) NULL)      return((Image *) NULL);    /*     Open image file.   *//   (void) strcpy(filename,image_info->filename); 1   (void) strcpy(zoomed_image->filename,filename); .   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".Y");    OpenImage(zoomed_image,"rb"); *   if (zoomed_image->file == (FILE *) NULL)     { <       Warning("Unable to open file",zoomed_image->filename);!       DestroyImage(zoomed_image);.       return((Image *) NULL);(     }d   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);c   /*     Read Y channel.-   */#   zoomed_image->columns=width >> 1;(!   zoomed_image->rows=height >> 1;(A   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;r   uv_pixels=(unsigned char *) 8     malloc(zoomed_image->packets*sizeof(unsigned char));   y_pixels=(unsigned char *):     malloc(4*zoomed_image->packets*sizeof(unsigned char));*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));.   if ((uv_pixels == (unsigned char *) NULL) ||-       (y_pixels == (unsigned char *) NULL) ||e9       (zoomed_image->pixels == (RunlengthPacket *) NULL))      { 7       Warning("Memory allocation error",(char *) NULL);n!       DestroyImage(zoomed_image);-       return((Image *) NULL);g     }-P   (void) ReadData((char *) y_pixels,4,zoomed_image->packets,zoomed_image->file);   CloseImage(zoomed_image);(   /*     Read U channel.(   */1   (void) strcpy(zoomed_image->filename,filename); .   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".U");    OpenImage(zoomed_image,"rb");%*   if (zoomed_image->file == (FILE *) NULL)     { <       Warning("Unable to open file",zoomed_image->filename);!       DestroyImage(zoomed_image);        return((Image *) NULL);      } =   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,      zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)    {      q->green=(*p);     q->index=0;      q->length=0;     p++;     q++;   }    CloseImage(zoomed_image);    /*     Read V channel.    */1   (void) strcpy(zoomed_image->filename,filename); .   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".V");%   OpenImage(zoomed_image,"rb");g*   if (zoomed_image->file == (FILE *) NULL)     {n<       Warning("Unable to open file",zoomed_image->filename);!       DestroyImage(zoomed_image);o       return((Image *) NULL);      }e=   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,S     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;k+   for (i=0; i < zoomed_image->packets; i++)t   {a     q->blue=(*p);g     p++;     q++;   }    CloseImage(zoomed_image);t   free((char *) uv_pixels);r   /*     Scale image.   */   zoomed_image->orphan=True;    image=ZoomImage(zoomed_image);   zoomed_image->orphan=False;t   DestroyImage(zoomed_image);i   if (image == (Image *) NULL)     {dA       Warning("Unable to read image","Memory allocation failed");d       return((Image *) NULL);T     }D
   p=y_pixels;T   q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {      q->red=(*p);     p++;     q++;   }    free((char *) y_pixels);+   TransformRGBImage(image,YCbCrColorspace); *   (void) strcpy(image->filename,filename);   return(image); }i   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             %sO %                                                                             %LO %   R e a d I m a g e                                                         %mO %                                                                             %oO %                                                                             %)O %                                                                             %BO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %/B %  Function ReadImage reads an image and returns it.  It allocatesL %  the memory necessary for the new Image structure and returns a pointer toJ %  the new image.  By default, the image format is determined by its magicM %  number. To specify a particular image format, precede the filename with an_M %  explicit image format name and a colon (i.e.  ps:image) or as the filenamed %  suffix  (i.e. image.ps).e %r* %  The format of the ReadImage routine is: %e" %      image=ReadImage(image_info) %l+ %  A description of each parameter follows:n %mE %    o image: Function ReadImage returns a pointer to the image afterNL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %pA %    o image_info: Specifies a pointer to an ImageInfo structure.; %  %  */ Image *ReadImage(image_info)	 ImageInfo    *image_info; {e   char      magic_number[MaxTextLength];     Image-     decode_image,P     *image;)     ImageInfo      decode_info;     SetImageMagick(image_info);r   decode_info=(*image_info);   decode_image.temporary=False; 3   if ((strncmp(decode_info.magick,"FTP",3) == 0) ||r4       (strncmp(decode_info.magick,"HTTP",4) == 0) ||4       (strncmp(decode_info.magick,"GOPHER",6) == 0))     {c
       char         command[MaxTextLength],;          filename[MaxTextLength];         /*H         Retrieve image as specified with a WWW uniform resource locator.       */"       decode_image.temporary=True;"       TemporaryFilename(filename);P       (void) sprintf(command,WWWCommand,decode_info.magick,decode_info.filename,         filename);$       (void) SystemCommand(command);#       SetImageMagick(&decode_info); 3       (void) strcpy(decode_info.filename,filename);u     }mK   if (!decode_info.assert || (strncmp(decode_info.magick,"IRIS",4) == 0) || 1       (strncmp(decode_info.magick,"PCD",3) == 0))L     {        /*/         Determine type from image magic number.        */       *magic_number='\0';l@       (void) strcpy(decode_image.filename,decode_info.filename);$       OpenImage(&decode_image,"rb");-       if (decode_image.file != (FILE *) NULL) >         if ((decode_image.file == stdin) || decode_image.pipe)           {c             FILE               *file;               int[               c;               /*<               Copy standard input or pipe to temporary file.             */(             decode_image.temporary=True;5             TemporaryFilename(decode_image.filename); 7             decode_info.filename=decode_image.filename;o3             file=fopen(decode_image.filename,"wb");l&             if (file == (FILE *) NULL)               {_E                 Warning("Unable to write file",decode_info.filename); '                 return((Image *) NULL);r               }*'             c=fgetc(decode_image.file);              while (c != EOF)
             { "               (void) putc(c,file);)               c=fgetc(decode_image.file);(
             }               (void) fclose(file);&             CloseImage(&decode_image);*             OpenImage(&decode_image,"rb");           }m-       if (decode_image.file != (FILE *) NULL) 	         {            /*             Read magic number.           */C           (void) ReadData(magic_number,(unsigned int) sizeof(char),*C             (unsigned int) sizeof(magic_number),decode_image.file); :           if (((unsigned char) magic_number[0] == 0xff) &&8               ((unsigned char) magic_number[1] == 0xff))
             {                register int                 i;                 /*6                 For PCD image type, skip to byte 2048.               */D               for (i=0; i < (int) (0x800-sizeof(magic_number)); i++)0                 (void) fgetc(decode_image.file);G               (void) ReadData(magic_number,(unsigned int) sizeof(char),sG                 (unsigned int) sizeof(magic_number),decode_image.file);F
             }e$           CloseImage(&decode_image);	         }n       /*#         Determine the image format.e       */,       if (strncmp(magic_number,"BM",2) == 0)0         (void) strcpy(decode_info.magick,"BMP");.       if (strncmp(magic_number,"GIF8",4) == 0)0         (void) strcpy(decode_info.magick,"GIF");2       if (strncmp(magic_number,"\001\332",2) == 0)1         (void) strcpy(decode_info.magick,"IRIS");t6       if (strncmp(magic_number,"\377\330\377",3) == 0)1         (void) strcpy(decode_info.magick,"JPEG");s
       else7         if ((strcmp(decode_info.magick,"JPEG") == 0) || 4             (strcmp(decode_info.magick,"JPG") == 0))3           (void) strcpy(decode_info.magick,"MIFF");c-       if (strncmp(magic_number,"PCD",3) == 0))0         (void) strcpy(decode_info.magick,"PCD");0       if ((unsigned char) *magic_number == 0x0a)0         (void) strcpy(decode_info.magick,"PCX");=       if ((*magic_number == 'P') && isdigit(magic_number[1])) 0         (void) strcpy(decode_info.magick,"PNM");,       if (strncmp(magic_number,"%!",2) == 0)/         (void) strcpy(decode_info.magick,"PS");a5       if (strncmp(magic_number,"#?RADIANCE",10) == 0)g0         (void) strcpy(decode_info.magick,"RAD");2       if (strncmp(magic_number,"\122\314",2) == 0)0         (void) strcpy(decode_info.magick,"RLE");:       if (strncmp(magic_number,"\131\246\152\225",4) == 0)0         (void) strcpy(decode_info.magick,"SUN");6       if ((strncmp(magic_number,"\115\115",2) == 0) ||4           (strncmp(magic_number,"\111\111",2) == 0))1         (void) strcpy(decode_info.magick,"TIFF");i5       if ((strncmp(magic_number,"LBLSIZE",7) == 0) ||=1          (strncmp(magic_number,"NJPL1I",6) == 0)) 2         (void) strcpy(decode_info.magick,"VICAR");0       if ((unsigned char) *magic_number == 0xab)1         (void) strcpy(decode_info.magick,"VIFF"); 1       if (strncmp(magic_number,"#define",7) == 0) 0         (void) strcpy(decode_info.magick,"XBM");3       if (strncmp(magic_number,"/* XPM */",9) == 0) 0         (void) strcpy(decode_info.magick,"XPM");A       if ((magic_number[1] == 0x00) && (magic_number[2] == 0x00)) C         if ((magic_number[5] == 0x00) && (magic_number[6] == 0x00))tE           if ((magic_number[4] == 0x07) || (magic_number[7] == 0x07)) 4             (void) strcpy(decode_info.magick,"XWD");     }    /*6     Call appropriate image reader based on image type.   */   switch (*decode_info.magick)   { 
     case 'A':      { '       image=ReadAVSImage(&decode_info);l       break;     }0
     case 'B':w     { '       image=ReadBMPImage(&decode_info);o       break;     }n
     case 'C':t     {e(       image=ReadCMYKImage(&decode_info);       break;     }c
     case 'E':      { &       image=ReadPSImage(&decode_info);       break;     } 
     case 'F':      { 0       if (strcmp(decode_info.magick,"FAX") == 0))         image=ReadFAXImage(&decode_info); 
       else*         image=ReadFITSImage(&decode_info);       break;     }o
     case 'G':o     {i0       if (strcmp(decode_info.magick,"GIF") == 0))         image=ReadGIFImage(&decode_info); 
       else4         if (strcmp(decode_info.magick,"GIF87") == 0)+           image=ReadGIFImage(&decode_info);d         else5           if (strcmp(decode_info.magick,"GRAY") == 0)*.             image=ReadGRAYImage(&decode_info);           else-             image=ReadFAXImage(&decode_info);        break;     } 
     case 'H':d     {;-       image=ReadHISTOGRAMImage(&decode_info);        break;     } 
     case 'I':)     { (       image=ReadIRISImage(&decode_info);       break;     } 
     case 'J':>     {p(       image=ReadJPEGImage(&decode_info);       break;     }e
     case 'L':      { (       image=ReadLOGOImage(&decode_info);       break;     } 
     case 'M':n     { 0       if (strcmp(decode_info.magick,"MAP") == 0))         image=ReadMAPImage(&decode_info); 
       else4         if (strcmp(decode_info.magick,"MATTE") == 0)-           image=ReadMATTEImage(&decode_info);          else5           if (strcmp(decode_info.magick,"MIFF") == 0) .             image=ReadMIFFImage(&decode_info);           else;             if ((strcmp(decode_info.magick,"MPEG") == 0) ||r8                 (strcmp(decode_info.magick,"MPG") == 0))0               image=ReadMPEGImage(&decode_info);             else/               image=ReadMTVImage(&decode_info);g       break;     } 
     case 'N':      {I(       image=ReadNULLImage(&decode_info);       break;     } 
     case 'P':i     {p0       if (strcmp(decode_info.magick,"PCD") == 0))         image=ReadPCDImage(&decode_info); 
       else2         if (strcmp(decode_info.magick,"PCX") == 0)+           image=ReadPCXImage(&decode_info);          else5           if (strcmp(decode_info.magick,"PICT") == 0)v.             image=ReadPICTImage(&decode_info);           else5             if (strcmp(decode_info.magick,"PM") == 0)%/               image=ReadXPMImage(&decode_info);%             else;               if ((strcmp(decode_info.magick,"PS") == 0) || :                   (strcmp(decode_info.magick,"PS2") == 0))0                 image=ReadPSImage(&decode_info);               else1                 image=ReadPNMImage(&decode_info);e       break;     }A
     case 'R':      { 0       if (strcmp(decode_info.magick,"RAD") == 0).         image=ReadRADIANCEImage(&decode_info);
       else2         if (strcmp(decode_info.magick,"RAS") == 0)+           image=ReadSUNImage(&decode_info);          else4           if (strcmp(decode_info.magick,"RGB") == 0)-             image=ReadRGBImage(&decode_info);%           else-             image=ReadRLEImage(&decode_info);A       break;     }v
     case 'S':g     {a'       image=ReadSUNImage(&decode_info);r       break;     }e
     case 'T':r     { 0       if (strcmp(decode_info.magick,"TGA") == 0)+         image=ReadTARGAImage(&decode_info); 
       else6         if ((strcmp(decode_info.magick,"TIF") == 0) ||5             (strcmp(decode_info.magick,"TIFF") == 0))e,           image=ReadTIFFImage(&decode_info);         else,           image=ReadTEXTImage(&decode_info);       break;     }r
     case 'V':      {a2       if (strcmp(decode_info.magick,"VICAR") == 0)+         image=ReadVICARImage(&decode_info);/
       else2         if (strcmp(decode_info.magick,"VID") == 0)           {d#             if (decode_info.assert)R/               image=ReadVIDImage(&decode_info);E             else0               image=ReadMIFFImage(&decode_info);           }e         else,           image=ReadVIFFImage(&decode_info);       break;     }p
     case 'X':m     {e.       if (strcmp(decode_info.magick,"X") == 0)>         image=ReadXImage(&decode_info,False,False,False,True);
       else1         if (strcmp(decode_info.magick,"XC") == 0) *           image=ReadXCImage(&decode_info);         else4           if (strcmp(decode_info.magick,"XBM") == 0)-             image=ReadXBMImage(&decode_info);,           else6             if (strcmp(decode_info.magick,"XPM") == 0)/               image=ReadXPMImage(&decode_info);l             else7               if (strcmp(decode_info.magick,"XV") == 0)t2                 image=ReadVIFFImage(&decode_info);               else1                 image=ReadXWDImage(&decode_info);o       break;     }e
     case 'Y':=     {e0       if (strcmp(decode_info.magick,"YUV") == 0))         image=ReadYUVImage(&decode_info);p
       else*         image=ReadYUV3Image(&decode_info);       break;     }      default:     { /       (void) strcpy(decode_info.magick,"MIFF"); (       image=ReadMIFFImage(&decode_info);     })   })   if (decode_image.temporary)A(     (void) unlink(decode_info.filename);   if (image != (Image *) NULL)     {1       if (image->status)K         Warning("An error has occurred reading from file",image->filename);-!       if (decode_image.temporary)u<         (void) strcpy(image->filename,image_info->filename);+       if (image->comments == (char *) NULL) ;         CommentImage(image,"  Imported from %m image: %f");eA       (void) strcpy(image->magick_filename,image_info->filename); %       if (image->magick_columns == 0)e-         image->magick_columns=image->columns;a"       if (image->magick_rows == 0)'         image->magick_rows=image->rows;c     }>   return(image); }d