 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                  CCCC   OOO   L       OOO   RRRR    SSSSS                   % O %                 C      O   O  L      O   O  R   R   SS                      % O %                 C      O   O  L      O   O  RRRR     SSS                    % O %                 C      O   O  L      O   O  R R        SS                   % O %                  CCCC   OOO   LLLLL   OOO   R  R    SSSSS                   % O %                                                                             % O %                                                                             % O %                       Count the Colors in an Image                          % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" /*   Define declarations. */+ #define MaxTreeDepth  8  /* Log2(MaxRGB) */ # #define NodesInAList  MaxTextLength    /*
   Structures.  */ typedef struct _Node {    struct _Node     *child[8];     unsigned char 
     level,     mid_red,     mid_green,
     mid_blue;      unsigned long      number_colors; } Node;    typedef struct _Nodes  {    Node     nodes[NodesInAList];     struct _Nodes 
     *next; } Nodes;   typedef struct _Cube {    Node
     *root;     unsigned int     colors;      unsigned int     free_nodes;      Node
     *node;     Nodes      *node_list;  } Cube;    /*   Global variables.  */ static Cube    cube;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  H i s t o g r a m                                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Procedure Histogram traverses the color cube tree and produces a list of N %  unique pixel field values and the number of times each occurs in the image. % * %  The format of the Histogram routine is: %  %      Histogram(node,file)  % + %  A description of each parameter follows.  % F %    o node: The address of a structure of type Node which points to a8 %      node in the color cube tree that is to be pruned. %  %  */  static void Histogram(node,file)
 register Node    *node;   FILE   *file; {    register unsigned int      id;      /*     Traverse any children.   */   for (id=0; id < 8; id++))     if (node->child[id] != (Node *) NULL) &       Histogram(node->child[id],file);"   if (node->level == MaxTreeDepth)?     (void) fprintf(file,"%10lu%6d%6d%6d\n",node->number_colors, 4       node->mid_red,node->mid_green,node->mid_blue); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  I n i t i a l i z e N o d e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function InitializeNode allocates memory for a new node in the color cube' %  tree and presets all fields to zero.  % / %  The format of the InitializeNode routine is:  % < %      node=InitializeNode(level,mid_red,mid_green,mid_blue) % + %  A description of each parameter follows.  % I %    o level: Specifies the level in the classification the node resides.  % F %    o mid_red: Specifies the mid point of the red axis for this node. % J %    o mid_green: Specifies the mid point of the green axis for this node. % H %    o mid_blue: Specifies the mid point of the blue axis for this node. %  %  */= static Node *InitializeNode(level,mid_red,mid_green,mid_blue)  unsigned int   level,
   mid_red,   mid_green,   mid_blue;  {    register int     i;     register Node 
     *node;     if (cube.free_nodes == 0)      {        register Nodes         *nodes;          /*&         Allocate a new nodes of nodes.       */,       nodes=(Nodes *) malloc(sizeof(Nodes));"       if (nodes == (Nodes *) NULL)         return((Node *) NULL);!       nodes->next=cube.node_list;        cube.node_list=nodes;        cube.node=nodes->nodes; #       cube.free_nodes=NodesInAList;      }    cube.free_nodes--;   node=cube.node++;    for (i=0; i < 8; i++) !     node->child[i]=(Node *) NULL;    node->level=level;   node->mid_red=mid_red;   node->mid_green=mid_green;   node->mid_blue=mid_blue;   node->number_colors=0;   return(node);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  I s P s e u d o C l a s s                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function IsPseudoClass returns True if the image is PseudoClass or has 256 N %  unique colors or less.  If the image is DirectClass and has less 256 colors0 %  or less, the image is demoted to PseudoClass. % . %  The format of the IsPseudoClass routine is: % " %      status=IsPseudoClass(image) % + %  A description of each parameter follows.  % C %    o status:  Function IsPseudoClass returns True is the image is , %      PseudoClass or has 256 color or less. % @ %    o image: The address of a byte (8 bits) array of run-length? %      encoded pixel data of your source image.  The sum of the G %      run-length counts in the source image must be equal to or exceed  %      the number of pixels. %  %  */! unsigned int IsPseudoClass(image)  Image 	   *image;  {    Nodes      *nodes;      register RunlengthPacket     *p;      register int     i;     register Node 
     *node;     register unsigned int 
     count,     id, 
     level;     unsigned int     bisect;   "   if (image->class == PseudoClass)     return(True);    if (image->matte)      return(False);   /*&     Initialize color description tree.   */    cube.node_list=(Nodes *) NULL;   cube.colors=0;   cube.free_nodes=0;<   cube.root=InitializeNode(0,(unsigned int) (MaxRGB+1) >> 1,C     (unsigned int) (MaxRGB+1) >> 1,(unsigned int) (MaxRGB+1) >> 1); !   if (cube.root == (Node *) NULL)      { C       Warning("Unable to count colors","Memory allocation failed");        return(0);     }    p=image->pixels;@   for (i=0; ((i < image->packets) && (cube.colors <= 256)); i++)   {      /*3       Start at the root and proceed level by level.      */     count=p->length+1;     node=cube.root; 1     for (level=1; level <= MaxTreeDepth; level++)      { ,       id=(p->red >= node->mid_red ? 1 : 0) |4         (p->green >= node->mid_green ? 1 : 0) << 1 |1         (p->blue >= node->mid_blue ? 1 : 0) << 2; +       if (node->child[id] == (Node *) NULL) 	         { $           if (level == MaxTreeDepth)
             { I               node->child[id]=InitializeNode(level,(unsigned int) p->red, @                 (unsigned int) p->green,(unsigned int) p->blue);               cube.colors++;
             }            else
             { E               bisect=(unsigned int) (1 << (MaxTreeDepth-level)) >> 1; 3               node->child[id]=InitializeNode(level, :                 node->mid_red+(id & 1 ? bisect : -bisect),<                 node->mid_green+(id & 2 ? bisect : -bisect),<                 node->mid_blue+(id & 4 ? bisect : -bisect));
             } /           if (node->child[id] == (Node *) NULL) 
             { K               Warning("Unable to count colors","Memory allocation failed");                return(0);
             } 	         }        node=node->child[id];      }      node->number_colors+=count;      p++;   }    /*$     Release color cube tree storage.   */   do   {      nodes=cube.node_list->next; "     free((char *) cube.node_list);     cube.node_list=nodes;    } +   while (cube.node_list != (Nodes *) NULL);    if (cube.colors <= 256)      {        /**         Demote DirectClass to PseudoClass.       */5       QuantizeImage(image,256,8,False,RGBColorspace);        SyncImage(image);      } &   return(image->class == PseudoClass); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  N u m b e r C o l o r s                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function NumberColors returns the number of unique colors in an image.  % - %  The format of the NumberColors routine is:  %  %      NumberColors(image,file)  % + %  A description of each parameter follows.  % @ %    o image: The address of a byte (8 bits) array of run-length? %      encoded pixel data of your source image.  The sum of the G %      run-length counts in the source image must be equal to or exceed  %      the number of pixels. % M %    o file:  An pointer to a FILE.  If it is non-null a list of unique pixel G %      field values and the number of times each occurs in the image is  %      written to the file.  %  %  %  */ void NumberColors(image,file)  Image 	   *image;    FILE   *file; {    Nodes      *nodes;      register RunlengthPacket     *p;      register int     i;     register Node 
     *node;     register unsigned int 
     count,     id, 
     level;     unsigned int     bisect;      /*&     Initialize color description tree.   */   image->total_colors=0;    cube.node_list=(Nodes *) NULL;   cube.colors=0;   cube.free_nodes=0;<   cube.root=InitializeNode(0,(unsigned int) (MaxRGB+1) >> 1,C     (unsigned int) (MaxRGB+1) >> 1,(unsigned int) (MaxRGB+1) >> 1); !   if (cube.root == (Node *) NULL)      { C       Warning("Unable to count colors","Memory allocation failed"); 
       return;      }    p=image->pixels;$   for (i=0; i < image->packets; i++)   {      /*3       Start at the root and proceed level by level.      */     count=p->length+1;     node=cube.root; 1     for (level=1; level <= MaxTreeDepth; level++)      { ,       id=(p->red >= node->mid_red ? 1 : 0) |4         (p->green >= node->mid_green ? 1 : 0) << 1 |1         (p->blue >= node->mid_blue ? 1 : 0) << 2; +       if (node->child[id] == (Node *) NULL) 	         { $           if (level == MaxTreeDepth)
             { I               node->child[id]=InitializeNode(level,(unsigned int) p->red, @                 (unsigned int) p->green,(unsigned int) p->blue);               cube.colors++;
             }            else
             { E               bisect=(unsigned int) (1 << (MaxTreeDepth-level)) >> 1; 3               node->child[id]=InitializeNode(level, :                 node->mid_red+(id & 1 ? bisect : -bisect),<                 node->mid_green+(id & 2 ? bisect : -bisect),<                 node->mid_blue+(id & 4 ? bisect : -bisect));
             } /           if (node->child[id] == (Node *) NULL) 
             { K               Warning("Unable to count colors","Memory allocation failed");                return; 
             } 	         }        node=node->child[id];      }      node->number_colors+=count;      p++;   }    if (file != (FILE *) NULL)     { 8       (void) fprintf(file,"\n  Histogram of colors:\n");>       (void) fprintf(file,"\n     Count   Red Green  Blue\n");        Histogram(cube.root,file);     }    /*$     Release color cube tree storage.   */   do   {      nodes=cube.node_list->next; "     free((char *) cube.node_list);     cube.node_list=nodes;    } +   while (cube.node_list != (Nodes *) NULL); "   image->total_colors=cube.colors; } 