 .ad l  .nh ' .TH import 1 "1 May 1994" "ImageMagick"  .SH NAMEH import - capture some or all of an X server screen and save the image to a file.  .SH SYNOPSIS .B "import"   [ \fIoptions\fP ... ] \fIfile\fP .SH DESCRIPTION F \fBimport\fP reads an image from any visible window on an X server andB outputs it as an image file.  You can capture a single window, the= entire screen, or any rectangular portion of the screen.  Use F \fBdisplay\fP (see \fBdisplay(1)\fP) for redisplay, printing, editing,D formatting, archiving, image processing, etc. of the captured image. .PP E The target window can be specified by id, name, or may be selected by D clicking the mouse in the desired window.  If you press a button and? then drag, a rectangle will form which expands and contracts as C the mouse moves.  To save the portion of the screen  defined by the F rectangle, just release the button.  The keyboard bell is rung once at@ the beginning of the screen capture and twice when it completes. .PP  .SH EXAMPLES .PP B To select an X window with the mouse and save it in the MIFF image) format to a file titled window.miff, use:  .PP  .B      import window.miff  .PP G To select an X window and save it in the Encapsulated Postscript format $ to include in another document, use: .PP  .B      import figure.eps .PP H To capture the entire X server screen in the JPEG image format in a file titled root.jpeg, use: .PP  .B"      import -window root root.jpeg .SH OPTIONS J \fBimport\fP options can appear on the command line or in your X resourcesN file (see \fBX(1)\fP).  Options on the command line supersede values specified in your X resources file.  .TP 5  .B "-border"* include image borders in the output image. .B "-colors \fIvalue\fP"( preferred number of colors in the image.  G The actual number of colors in the image may be less than your request, E but never more.  Note, this is a color reduction option.  Images with I less unique colors than specified with this option will remain unchanged. , Refer to \fBquantize(9)\fP for more details.  K Note, options \fB-dither\fP, \fB-colorspace\fP, and \fB-treedepth\fP affect  the color reduction algorithm. .TP 5  .B "-colorspace \fIvalue\fP"E the type of colorspace: \fBGRAY\fP, \fBOHTA\fP, \fBRGB\fP, \fBXYZ\fP, 2 \fBYCbCr\fP, \fBYIQ\fP, \fBYPbPr\fP, or \fBYUV\fP.  @ Color reduction, by default, takes place in the RGB color space.F Empirical evidence suggests that distances in color spaces such as YUV> or YIQ correspond to perceptual color differences more closelyC than do distances in RGB space.  These color spaces may give better E results when color reducing an image.  Refer to \fBquantize(9)\fP for 
 more details.   I The \fB-colors\fP or \fB-monochrome\fP option is required for this option  to take effect.  .TP 5  .B "-comment \fIstring\fP"! annotate an image with a comment.   A By default, each image is commented with its file name.  Use this E option to assign a specific comment to the image.  Optionally you can C include the image filename, type, width, height, or scene number by B embedding special format characters.  Embed \fB%f\fP for filename,F \fB%m\fP for magick, \fB%w\fP for width, \fB%h\fP for height, \fB%s\fP9 for scene number, or \fB\\n\fP for newline.  For example,    .nf       -comment "%m:%f %wx%h"  .fi   F produces an image comment of \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.  L If the first character of \fIstring\fP is \fB@\fP, the image comment is read= from a file titled by the remaining characters in the string.  .TP 5  .B "-compress \fItype\fP" H the type of image compression: \fIQEncoded\fP or \fIRunlengthEncoded\fP. See \fBmiff(5)\fP for details.  M Specify \fB\+compress\fP to store the binary image in an uncompressed format. @ The default is the compression type of the specified image file. .TP 5 E .B "-crop \fI<width>{%}x<height>{%}{\+-}<x offset>{\+-}<y offset>\fP" M preferred size and location of the cropped image.  See \fBX(1)\fP for details ! about the geometry specification.   M To specify a percentage width or height instead, append \fB%\fP.  For example P to crop the image by ten percent on all sides of the image, use \fB-crop 10%\fP.  B Use cropping to crop a particular area of an image.   Use \fB-crop5 0x0\fP to remove edges that are the background color.  .TP 5  .B "-delay \fIseconds\fP" % pause before selecting target window.   J This option is useful when you need time to ready the target window before it is captured to a file.  .TP 5 # .B "-density \fI<width>x<height>\fP : vertical and horizontal resolution in pixels of the image.  = This option specifies an image density for a Postscript page. K The default is 72 pixels per inch in the horizontal and vertical direction. J The density is given to Ghostscript as the \fB-r\fP option when decoding a/ Postscript image.  See \fIgs(1)\fP for details.  .TP 5 
 .B "-descend" , obtain image by descending window hierarchy.  G This option reads each subwindow and its colormap of the chosen window. F The final image is guaranteed to have the correct colors but obtaining" the image is significantly slower. .TP 5 ) .B "-display \fIhost:display[.screen]\fP" 2 specifies the X server to contact; see \fBX(1)\fP. .TP 5  .B "-dither"3 apply Floyd/Steinberg error diffusion to the image.   D The basic strategy of dithering is to trade intensity resolution forF spatial resolution by averaging the intensities of several neighboringH pixels.  Images which suffer from severe contouring when reducing colors! can be improved with this option.   B The \fB-colors\fP option is required for dithering to take effect. .TP 5  .B "-frame"  include window manager frame.  .TP 5 . .B "-geometry \fI<width>{%}x<height>{%}{!}"\fP" the width and height of the image.  B By default, the width and height are maximum values.  That is, theG image is expanded or contracted to fit the width and height value while G maintaining the aspect ratio of the image.  Append an exclamation point ? to the geometry to force the image size to exactly the size you G specify.  For example, if you specify \fB640x480!\fP the image width is ; set to 640 pixels and height to 480.  If only one factor is 6 specified, both the width and height assume the value.  E To specify a percentage width or height instead, append \fB%\fP.  The F image size is multiplied by the width and height percentages to obtainD the final image dimensions.  To increase the size of an image, use aG value greater than 100 (e.g. 125%).  To decrease an image's size, use a  percentage less than 100.  .TP 5  .B "-interlace \fItype\fP"G the type of interlacing scheme: \fBNONE\fP, \fBLINE\fP, or \fBPLANE\fP.   E This option is used to specify the type of interlacing scheme for raw F image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNONE\fP means do not; interlace (RGBRGBRGBRGBRGBRGB...), \fBLINE\fP uses scanline H interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPLANE\fP uses0 plane interlacing (RRRRRR...GGGGGG...BBBBBB...).  A Use \fBLINE\fP, or \fBPLANE\fP to create an interlaced GIF image.  .B "-label \fIname\fP" assign a label to an image.   D Use this option to assign a specific label to the image.  OptionallyA you can include the image filename, type, width, height, or scene C number in the label by embedding special format characters.   Embed ? \fB%f\fP for filename, \fB%m\fP for magick, \fB%w\fP for width, @ \fB%h\fP for height, or \fB%s\fP for scene number.  For example, .nf       -label "%m:%f %wx%h"  .fi D produces an image label of \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.  J If the first character of \fIstring\fP is \fB@\fP, the image label is read= from a file titled by the remaining characters in the string.   I When converting to Postscript, use this option to specify a header string  to print above the image.  .TP 5  .B "-monochrome"# transform image to black and white.  .TP 5  .B "-negate" apply color inversion to image.   = The red, green, and blue intensities of an image are negated.  .TP 5 ? .B "-page \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP" 3 preferred size and location of the Postscript page.   C Use this option to specify the dimensions of the Postscript page in O pixels per inch or a TEXT page in pixels.  The default for a Postscript page is ; to center the image on a letter page 612 by 792 pixels. The @ margins are 1/2" (i.e.  612x792+36+36).  Other common sizes are:       Letter      612x 792     Tabloid     792x1224     Ledger     1224x 792     Legal       612x1008     Statement   396x 612     Executive   540x 720     A3          842x1190     A4          595x 842     A5          420x 595     B4          729x1032     B5          516x 729     Folio       612x 936     Quarto      610x 780     10x14       720x1008  < For convenience you can specify the page size by media (e.g. A4, Ledger, etc.).  K The page geometry is relative to the vertical and horizontal density of the 1 Postscript page.  See \fB-density\fP for details.   8 The default page dimensions for a TEXT image is 612x792. .TP 5  .B "-quality \fIvalue\fP"  JPEG quality setting.   6 Quality is 0 (worst) to 100 (best). The default is 85. .TP 5  .B "-rotate \fIdegrees\fP"( apply Paeth image rotation to the image.  A Empty triangles left over from rotating the image are filled with A the color defined as \fBbordercolor\fP (class \fBborderColor\fP).  See \fBX(1)\fP for details.  .TP 5  .B "-scene \fIvalue\fP"  image scene number.  .TP 5  .B "-screen"H This option indicates that the GetImage request used to obtain the imageH should be done on the root window, rather than directly on the specifiedI window.  In this way, you can obtain pieces of other windows that overlap J the specified window, and more importantly, you can capture menus or otherI popups that are independent windows but appear over the specified window.  .TP 5  .B "-transparency \fIcolor\fP"- make this color transparent within the image.  .TP 5  .B "-treedepth \fIvalue\fP" A Normally, this integer value is zero or one.  A zero or one tells D \fBconvert\fP to choose a optimal tree depth for the color reduction
 algorithm.  G An optimal depth generally allows the best representation of the source B image with the fastest computational speed and the least amount ofE memory.  However, the default depth is inappropriate for some images. F To assure the best representation, try values between 2 and 8 for this8 parameter.  Refer to \fBquantize(9)\fP for more details.  D The \fB-colors\fP option is required for this option to take effect. .TP 5  .B -verbose + print detailed information about the image.   J This information is printed: image scene number;  image name;  image size;D the image class (\fIDirectClass\fP or \fIPseudoClass\fP);  the totalI number of unique colors;  and the number of seconds to read and write the  image. .TP 5  .B "-window \fIid\fP" # select window with this id or name.   G With this option you can specify the target window by id or name rather F than using the mouse.  Specify 'root' to select X's root window as the target window. .PP , Options are processed in command line order.H Any option you specify on the command line remains in effect until it isJ explicitly changed by specifying the option again with a different effect. .PP I Change \fI-\fP to \fI+\fP in any option above to reverse its effect.  For ; example \fB+frame\fP means do include window manager frame.  .PP B \fIfile\fP specifies the image filename.  By default, the image isF written in the Postscript image format.  To specify a particular imageB format, precede the filename with an image format name and a colonG (i.e.  ps:image) or specify the image type as the filename suffix (i.e. C image.ps).  See \fBconvert(1)\fP for a list of valid image formats.  .PP E Specify \fIfile\fP as \fI-\fP for standard output.  If \fIfile\fP has F the extension \fB.Z\fP or \fB.gz\fP, the file size is compressed usingG with \fBcompress\fP or \fBgzip\fP respectively.  Precede the image file G name \fI|\fP to pipe to a system command. If \fIfile\fP already exists, < you will be prompted as to whether it should be overwritten. .SH ENVIRONMENT  .PP  .TP 5 
 .B display4 To get the default host, display number, and screen. .SH SEE ALSO .B; display(1), animate(1), montage(1), mogrify(1), convert(1),  segment(1), combine(1), xtp(1)
 .SH COPYRIGHT 3 Copyright 1995 E. I. du Pont de Nemours and Company  .PP G Permission to use, copy, modify, distribute, and sell this software and @ its documentation for any purpose is hereby granted without fee,F provided that the above copyright notice appear in all copies and that? both that copyright notice and this permission notice appear in G supporting documentation, and that the name of E. I. du Pont de Nemours A and Company not be used in advertising or publicity pertaining to < distribution of the software without specific, written priorJ permission.  E. I. du Pont de Nemours and Company makes no representationsG about the suitability of this software for any purpose.  It is provided , "as is" without express or implied warranty. .PP I E. I. du Pont de Nemours and Company disclaims all warranties with regard E to this software, including all implied warranties of merchantability F and fitness, in no event shall E. I. du Pont de Nemours and Company be@ liable for any special, indirect or consequential damages or anyG damages whatsoever resulting from loss of use, data or profits, whether F in an action of contract, negligence or other tortuous action, arisingE out of or in connection with the use or performance of this software.  .SH AUTHORS = John Cristy, E.I. du Pont De Nemours and Company Incorporated 