 .ad l  .nh ( .TH display 1 "1 Feb 1995" "ImageMagick" .SH NAME7 display - display an image on any workstation running X  .SH SYNOPSIS, .B "display" [ \fIoptions\fP ...] \fIfile\fP& [ [ \fIoptions\fP ...] \fIfile\fP ...] .SH DESCRIPTION D \fBDisplay\fP is a machine architecture independent image processing@ and display program.  It can display an image on any workstationE screen running an X server.  \fBDisplay\fP can read and write many of F the more popular image formats (e.g. JPEG, TIFF, PNM, Photo CD, etc.).@ With \fBdisplay\fP, you can perform these functions on an image: .PP      o load an image from a file      o display the next image     o display the former image2     o display a sequence of images as a slide show     o write the image to a file -     o print the image to a Postscript printer      o delete the image file %     o create a Visual Image Directory C     o select the image to display by its thumbnail rather than name $     o undo last image transformation      o copy a region of the image!     o paste a region to the image ,     o restore the image to its original size     o refresh the image      o half the image size      o double the image size      o resize the image     o crop the image     o cut the image ,     o flop image in the horizontal direction*     o flip image in the vertical direction+     o rotate the image 90 degrees clockwise 3     o rotate the image 90 degrees counter-clockwise      o rotate the image     o shear the image      o trim the image edges$     o invert the colors of the image     o vary the color brightness      o vary the color saturation      o vary the image hue     o gamma correct the image       o sharpen the image contrast     o dull the image contrast 1     o perform histogram equalization on the image 2     o perform histogram normalization on the image     o negate the image colors 3     o toggle the colormap type: : Shared or Private )     o reduce the speckles within an image (     o eliminate peak noise from an image#     o detect edges within the image      o emboss an image      o oil paint an image$     o convert the image to grayscale:     o set the maximum number of unique colors in the image      o segment the image by color?     o apply image processing techniques to a region of interest "     o annotate the image with text     o draw on the image      o edit an image pixel color &     o edit the image matte information%     o composite an image with another      o add a border to the image      o add an image comment)     o display information about the image ,     o display information about this program)     o discard all images and exit program '     o change the level of magnification W     o display images specified by a World Wide Web (WWW) uniform resource locator (URL)  .SH EXAMPLESF To scale an image of a cockatoo to exactly 640 pixels in width and 480D pixels in height and position the window at location (200,200), use: .PP  .B7      display -geometry 640x480\+200\+200! cockatoo.miff  .PP @ To display an image of a cockatoo without a border centered on a backdrop, use: .PP  .B1      display +borderwidth -backdrop cockatoo.miff  .PP 9 To tile an image of a cockatoo onto the root window, use:  .PP  .B<      display -geometry 1280x1024! -window root cockatoo.miff .PP A To display a visual image directory of all your JPEG images, use:  .PP  .B      display 'vid:*.jpg' .PP : To display a MAP image that is 640 pixels in width and 480& pixels in height with 256 colors, use: .PP  .B,      display -size 640x480\+256 cockatoo.map .PP G To display an image of a cockatoo specified with a World Wide Web (WWW) # uniform resource locator (URL), use  .PP  .B9      display ftp://wizards.dupont.com/images/cockatoo.jpg  .SH OPTIONS  .TP 5  .B "-annotate \fIstring\fP"  annotate an image with text.   C Use this option to annotate an image with text.  Optionally you can C include the image filename, type, width, height, or scene number by B embedding special format characters.  Embed \fB%f\fP for filename,F \fB%m\fP for magick, \fB%w\fP for width, \fB%h\fP for height, \fB%s\fP9 for scene number, or \fB\\n\fP for newline.  For example,     .nf       -annotate "%m:%f %wx%h" .fi    B annotates the image with \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.   C If the first character of \fIstring\fP is \fB@\fP, the text is read = from a file titled by the remaining characters in the string.    I You can set the text position, font, and font color with \fB-geometry\fP, ) \fB-font\fP, and \fB-pen\fP respectively.  .TP 5  .B "-backdrop") display the image centered on a backdrop.   D This backdrop covers the entire workstation screen and is useful forF hiding other X window activity while viewing the image.   The color ofA the backdrop is specified as the background color.  Refer to \fBX  RESOURCES\fP for details.  .TP 5  .B "-blur \fIfactor\fP" @ blurs an image.  Specify \fIfactor\fP as the percent enhancement (0.0 - 99.9%). .TP 5 " .B "-border \fI<width>x<height>fP"F surround the image with a border or color.  See \fBX(1)\fP for details! about the geometry specification.   G The color of the border is obtained from the X server and is defined as I \fBbordercolor\fP (class \fBborderColor\fP).  See \fBX(1)\fP for details.  .TP 5  .B "-colormap \fItype\fP" 4 the type of colormap: \fBShared\fP or \fBPrivate\fP.  < This option only applies when the default X server visual isF \fIPseudoColor\fP or \fIGrayScale\fP.  Refer to \fB-visual\fP for moreG details.  By default, a shared colormap is allocated.  The image shares F colors with other X clients.  Some image colors could be approximated,C therefore your image may look very different than intended.  Choose = \fBPrivate\fP and the image colors appear exactly as they are H defined.  However, other clients may go \fItechnicolor\fP when the image colormap is installed. .TP 5  .B "-colors \fIvalue\fP"( preferred number of colors in the image.  G The actual number of colors in the image may be less than your request, E but never more.  Note, this is a color reduction option.  Images with I less unique colors than specified with this option will remain unchanged. , Refer to \fBquantize(9)\fP for more details.  K Note, options \fB-dither\fP, \fB-colorspace\fP, and \fB-treedepth\fP affect  the color reduction algorithm. .TP 5  .B "-colorspace \fIvalue\fP"E the type of colorspace: \fBGRAY\fP, \fBOHTA\fP, \fBRGB\fP, \fBXYZ\fP, 2 \fBYCbCr\fP, \fBYIQ\fP, \fBYPbPr\fP, or \fBYUV\fP.  @ Color reduction, by default, takes place in the RGB color space.F Empirical evidence suggests that distances in color spaces such as YUV> or YIQ correspond to perceptual color differences more closelyC than do distances in RGB space.  These color spaces may give better E results when color reducing an image.  Refer to \fBquantize(9)\fP for 
 more details.   I The \fB-colors\fP or \fB-monochrome\fP option is required for this option  to take effect.  .TP 5  .B "-comment \fIstring\fP"! annotate an image with a comment.   A By default, each image is commented with its file name.  Use this E option to assign a specific comment to the image.  Optionally you can C include the image filename, type, width, height, or scene number by B embedding special format characters.  Embed \fB%f\fP for filename,F \fB%m\fP for magick, \fB%w\fP for width, \fB%h\fP for height, \fB%s\fP9 for scene number, or \fB\\n\fP for newline.  For example,  .PP  .B      -comment "%m:%f %wx%h"  .PP F produces an image comment of \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.  L If the first character of \fIstring\fP is \fB@\fP, the image comment is read= from a file titled by the remaining characters in the string.  .TP 5  .B "-compress \fItype\fP" H the type of image compression: \fIQEncoded\fP or \fIRunlengthEncoded\fP.  B Use this option with \fB-write\fP to specify the the type of image, compression.  See \fBmiff(5)\fP for details.  M Specify \fB\+compress\fP to store the binary image in an uncompressed format. @ The default is the compression type of the specified image file. .TP 5  .B "-contrast"% enhance or reduce the image contrast.   : This option enhances the intensity differences between theA lighter and darker elements of the image.  Use \fB-contrast\fP to B enhance the image or \fB+contrast\fP to reduce the image contrast. .TP 5 E .B "-crop \fI<width>{%}x<height>{%}{\+-}<x offset>{\+-}<y offset>\fP" M preferred size and location of the cropped image.  See \fBX(1)\fP for details ! about the geometry specification.   M To specify a percentage width or height instead, append \fB%\fP.  For example ? to crop the image by ten percent on all sides of the image, use  \fB-crop 10%\fP.  @ Use cropping to apply image processing options to, or display, aJ particular area of an image.  Use \fB-crop 0x0\fP to remove edges that are the background color.   ? The equivalent X resource for this option is \fBcropGeometry\fP ? (class \fBCropGeometry\fP).  See \fBX RESOURCES\fP for details.  .TP 5  .B "-delay \fIseconds\fP" % display the next image after pausing.   D This option is useful when viewing several images in sequence.  EachF image will display and wait the number of seconds specified before the= next image is displayed.  The default is to display the image D and wait until you choose to display the next image or terminate the program. .TP 5 # .B "-density \fI<width>x<height>\fP : vertical and horizontal resolution in pixels of the image.  = This option specifies an image density for a Postscript page. K The default is 72 pixels per inch in the horizontal and vertical direction. J The density is given to Ghostscript as the \fB-r\fP option when decoding a/ Postscript image.  See \fIgs(1)\fP for details.  .TP 5  .B "-despeckle" $ reduce the speckles within an image. .TP 5 ) .B "-display \fIhost:display[.screen]\fP" 2 specifies the X server to contact; see \fBX(1)\fP. .TP 5  .B "-dither"3 apply Floyd/Steinberg error diffusion to the image.   D The basic strategy of dithering is to trade intensity resolution forF spatial resolution by averaging the intensities of several neighboringH pixels.  Images which suffer from severe contouring when reducing colors! can be improved with this option.   9 The \fB-colors\fP or \fB-monochrome\fP option is required  for this option to take effect.  .TP 5 
 .B "-edge" detect edges within an image.  .TP 5 
 .B "-enhance" 0 apply a digital filter to enhance a noisy image. .TP 5  .B "-equalize", perform histogram equalization to the image. .TP 5 
 .B "-flip"I create a "mirror image" by reflecting the image scanlines in the vertical 
 direction. .TP 5 
 .B "-flop"K create a "mirror image" by reflecting the image scanlines in the horizontal 
 direction. .TP 5  .B "-gamma \fIvalue\fP"  level of gamma correction.  E The same color image displayed on two different workstations may look ? different due to differences in the display monitor.  Use gamma B correction to adjust for this color difference.  Reasonable values extend from 0.8 to 2.3.   ? You can apply separate gamma values to the red, green, and blue D channels of the image with a gamma value list delineated with commas (i.e. 1.7,2.3,1.2).  .TP 5 L .B "-geometry \fI<width>{%}x<height>{%}{\+-}<x offset>{\+-}<y offset>{!}\fP"L preferred size and location of the Image window.  See \fBX(1)\fP for detailsK about the geometry specification.  By default, the window size is the image 9 size and the location is chosen by you when it is mapped.   B By default, the width and height are maximum values.  That is, theG image is expanded or contracted to fit the width and height value while G maintaining the aspect ratio of the image.  Append an exclamation point ? to the geometry to force the image size to exactly the size you G specify.  For example, if you specify \fB640x480!\fP the image width is ; set to 640 pixels and height to 480.  If only one factor is 6 specified, both the width and height assume the value.  E To specify a percentage width or height instead, append \fB%\fP.  The F image size is multiplied by the width and height percentages to obtainD the final image dimensions.  To increase the size of an image, use aG value greater than 100 (e.g. 125%).  To decrease an image's size, use a  percentage less than 100.   = When displaying an image on an X server, \fI<x offset>\fP and 0 \fI<y offset>\fP is relative to the root window.  ; The equivalent X resource for this option is \fBgeometry\fP ; (class \fBGeometry\fP).  See \fBX RESOURCES\fP for details.  .TP 5  .B "-interlace \fItype\fP"G the type of interlacing scheme: \fBNONE\fP, \fBLINE\fP, or \fBPLANE\fP.   E This option is used to specify the type of interlacing scheme for raw F image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNONE\fP means do not; interlace (RGBRGBRGBRGBRGBRGB...), \fBLINE\fP uses scanline H interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPLANE\fP uses0 plane interlacing (RRRRRR...GGGGGG...BBBBBB...).  A Use \fBLINE\fP, or \fBPLANE\fP to create an interlaced GIF image.  .TP 5  .B "-label \fIname\fP" assign a label to an image.   D Use this option to assign a specific label to the image.  OptionallyA you can include the image filename, type, width, height, or scene C number in the label by embedding special format characters.   Embed ? \fB%f\fP for filename, \fB%m\fP for magick, \fB%w\fP for width, @ \fB%h\fP for height, or \fB%s\fP for scene number.  For example, .PP  .B      -label "%m:%f %wx%h"  .PP D produces an image label of \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.  J If the first character of \fIstring\fP is \fB@\fP, the image label is read= from a file titled by the remaining characters in the string.   I When converting to Postscript, use this option to specify a header string  to print above the image.  .TP 5  .B "-map \fItype\fP"0 display image using this Standard Colormap type.  * Choose from these Standard Colormap types: .PP      best     default      gray     red 	     green      blue .PP H The X server must support the Standard Colormap you choose, otherwise anG error occurs.  Use \fBlist\fP as the type and \fBdisplay(1)\fP searches K the list of colormap types in top-to-bottom order until one is located. See = \fBxstdcmap(1)\fP for one way of creating Standard Colormaps.  .TP 5  .B "-matte" ) store matte channel if the image has one.  .TP 5  .B "-modulate \fIvalue\fP"5 vary the hue, saturation, and brightness of an image.   K Specify the percent change in hue, the color saturation, and the brightness < separated by commas.  For example, to increase the color hueH by 20% and decrease the color saturation by 10% and leave the brightness' unchanged, use: \fB-modulate 20,-10\fP.  .TP 5  .B "-monochrome"' transform the image to black and white.  .TP 5  .B "-negate" apply color inversion to image.   = The red, green, and blue intensities of an image are negated.  .TP 5  .B "-noise" B reduce the noise in an image with a noise peak elimination filter.  D The principal function of noise peak elimination filter is to smoothG the objects within an image without losing edge information and without G creating undesired structures.  The central idea of the algorithm is to F replace a pixel with its next neighbor in value within a 3 x 3 window,F if this pixel has been found to be noise.  A pixel is defined as noiseJ if and only if this pixel is a maximum or minimum within the 3 x 3 window. .TP 5  .B "-normalize" 7 transform image to span the full range of color values.   ) This is a contrast enhancement technique.  .TP 5 ? .B "-page \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP" ) size and location of the Postscript page.   C Use this option to specify the dimensions of the Postscript page in O pixels per inch or a TEXT page in pixels.  The default for a Postscript page is ; to center the image on a letter page 612 by 792 pixels. The @ margins are 1/2" (i.e.  612x792+36+36).  Other common sizes are: .PP      Letter      612x 792     Tabloid     792x1224     Ledger     1224x 792     Legal       612x1008     Statement   396x 612     Executive   540x 720     A3          842x1190     A4          595x 842     A5          420x 595     B4          729x1032     B5          516x 729     Folio       612x 936     Quarto      610x 780     10x14       720x1008 .PP O For convenience you can specify the page size by media (e.g. A4, Ledger, etc.).   K The page geometry is relative to the vertical and horizontal density of the 1 Postscript page.  See \fB-density\fP for details.   8 The default page dimensions for a TEXT image is 612x792. .TP 5  .B "-pen \fIcolor\fP" D set the color of the font.  See \fB-annotate\fP for further details.   9 See \fBX(1)\fP for details about the color specification.  .TP 5  .B "-quality \fIvalue\fP"  JPEG quality setting.   6 Quality is 0 (worst) to 100 (best). The default is 85. .TP 5 / .B "-roll \fI{\+-}<x offset>{\+-}<y offset>\fP" E roll an image vertically or horizontally.  See \fBX(1)\fP for details ! about the geometry specification.   D A negative \fIx offset\fP rolls the image left-to-right.  A negative- \fIy offset\fP rolls the image top-to-bottom.  .TP 5  .B "-rotate \fIdegrees\fP"( apply Paeth image rotation to the image.  A Empty triangles left over from rotating the image are filled with A the color defined as \fBbordercolor\fP (class \fBborderColor\fP).  See \fBX(1)\fP for details.  .TP 5  .B "-sample \fIgeometry\fP" A scale image with pixel sampling.  See \fB-geometry\fP for details ! about the geometry specification.  .TP 5  .B "-scene \fIvalue\fP"  image scene number.   I Use this option to specify an image sequence with a single filename.  See / the discussion of \fIfile\fP below for details.  .TP 5  .B "-sharpen \fIfactor\fP"B sharpen an image.  Specify \fIfactor\fP as the percent enhancement (0.0 - 99.9%). .TP 5 ) .B "-shear \fI<x degrees>x<y degrees>\fP" L shear the image along the X or Y axis by a positive or negative shear angle.  F Shearing slides one edge of an image along the X or Y axis, creating aE parallelogram.  An X direction shear slides an edge along the X axis, F while a Y direction shear slides an edge along the Y axis.  The amountE of the shear is controlled by a shear angle.  For X direction shears, G \fIx degrees>\fP is measured relative to the Y axis, and similarly, for F Y direction shears \fIy degrees\fP is measured relative to the X axis.  A Empty triangles left over from shearing the image are filled with A the color defined as \fBbordercolor\fP (class \fBborderColor\fP).  See \fBX(1)\fP for details.  .TP 5 0 .B "-size \fI<width>{%}x<height>{%}{+colors}{!}" width and height of the image.  C Use this option to specify the width and height of raw images whose D dimensions are unknown such as \fBGRAY\fP, \fBRGB\fP, or \fBCMYK\fP.C In addition to width and height, use \fB-size\fP to tell the number > of colors in a \fBMAP\fP image file, (e.g. -size 640x512+256).  - For Photo CD images, choose from these sizes:  .PP       192x128      384x256      768x512
     1536x1024 
     3072x2048  .TP 5  .B "-transparency \fIcolor\fP"- make this color transparent within the image.  .TP 5  .B "-treedepth \fIvalue\fP" A Normally, this integer value is zero or one.  A zero or one tells D \fBdisplay\fP to choose a optimal tree depth for the color reduction
 algorithm.  G An optimal depth generally allows the best representation of the source B image with the fastest computational speed and the least amount ofE memory.  However, the default depth is inappropriate for some images. F To assure the best representation, try values between 2 and 8 for this8 parameter.  Refer to \fBquantize(9)\fP for more details.  9 The \fB-colors\fP or \fB-monochrome\fP option is required  for this option to take effect.  .TP 5  .B "-update \fIseconds\fP"1 detect when image file is modified and redisplay.   ? Suppose that while you are displaying an image the file that is F currently displayed is over-written.  \fBdisplay\fP will automaticallyD detect that the input file has been changed and update the displayed image accordingly. .TP 5  .B -verbose + print detailed information about the image.   D This information is printed: image scene number;  image name;  imageJ size; the image class (\fIDirectClass\fP or \fIPseudoClass\fP);  the total? number of unique colors;  and the number of seconds to read and A transform the image.  Refer to \fBmiff(5)\fP for a description of  the image class.  H If \fB-colors\fP is also specified, the total unique colors in the imageI and color reduction error values are printed.  Refer to \fBquantize(9)\fP " for a description of these values. .TP 5  .B "-visual \fItype\fP" % display image using this visual type.   ! Choose from these visual classes:  .PP      StaticGray
     GrayScale      StaticColor      PseudoColor 
     TrueColor      DirectColor      default      \fIvisual id\fP  .PP K The X server must support the visual you choose, otherwise an error occurs. H If a visual is not specified, the visual class that can display the most= simultaneous colors on the default X server screen is chosen.  .TP 5  .B "-window \fIid\fP" 6 set the background pixmap of this window to the image.  K \fIid\fP can be a window id or name.  Specify \fBroot\fP to select X's root  window as the target window.  ? By default the image is tiled onto the background of the target B window.   If \fB-backdrop\fP or \fB-geometry\fP are specified, the; image is surrounded by the background color.  Refer to \fBX  RESOURCES\fP for details.   C The image will not display on the root window if the image has more : unique colors than the target window colormap allows.  Use- \fB-colors\fP to reduce the number of colors.  .TP 5  .B "-write \fIfilename\fP" write image to a file.  @ If \fIfile\fP already exists, you will be prompted as to whether it should be overwritten.   F By default, the image is written in the format that it was read in as.F To specify a particular image format, prefix \fIfile\fP with the imageA type and a colon (i.e. ps:image) or specify the image type as the D filename suffix (i.e. image.ps).  See \fBconvert(1)\fP for a list of@ valid image formats.  Specify \fIfile\fP as \fI-\fP for standardC output.  If \fIfile\fP has the extension \fB.Z\fP or \fB.gz\fP, the ? file size is compressed using with \fBcompress\fP or \fBgzip\fP F respectively.  Precede the image file name \fI|\fP to pipe to a systemA command. If \fIfile\fP already exists, you will be prompted as to ! whether it should be overwritten.   = Use \fB-compress\fP to specify the type of image compression.   @ The equivalent X resource for this option is \fBwriteFilename\fP@ (class \fBWriteFilename\fP).  See \fBX RESOURCES\fP for details. .PP C In addition to those listed above, you can specify these standard X 6 resources as command line options:  \fB-background\fP,G \fB-bordercolor\fP, \fB-borderwidth\fP, \fB-font\fP, \fB-foreground\fP, C \fB-iconGeometry\fP, \fB-iconic\fP, \fB-mattecolor\fP, \fB-name\fP, 4 or \fB-title\fP.  See \fBX RESOURCES\fP for details. .PP , Options are processed in command line order.H Any option you specify on the command line remains in effect until it isJ explicitly changed by specifying the option again with a different effect.D For example to display two images, the first with 32 colors, and the  second with only 16 colors, use: .PP  .B;      display -colors 32 cockatoo.miff -colors 16 macaw.miff  .PP E Change \fI-\fP to \fI\+\fP in any option above to reverse its effect. G For example, specify \fB\+matte\fP to store the image without its matte  channel. .PP B By default, the image format is determined by its magic number. ToE specify a particular image format, precede the filename with an image D format name and a colon (i.e. ps:image) or specify the image type asE the filename suffix (i.e. image.ps).  See \fBconvert(1)\fP for a list  of valid image formats.  .PP E When you specify \fBX\fP as your image type, the filename has special E meaning.  It specifies an X window by id, name, or \fBroot\fP.  If no F filename is specified, the window is selected by clicking the mouse in the desired window.  .PP D Specify \fIfile\fP as \fI-\fP for standard input.  If \fIfile\fP hasB the extension \fB.Z\fP or \fB.gz\fP, the file is uncompressed withF \fBuncompress\fP or \fBgunzip\fP respectively.  Precede the image file+ name \fI|\fP to pipe from a system command.  .PP G Use an optional index enclosed in brackets after a file name to specify C a desired subimage of a multi-resolution image format like Photo CD  (e.g. img0001.pcd[4]). .PP E Single images are read with the filename you specify.  Alternatively, E you can display an image sequence with a single filename.  Define the A range of the image sequence with \fI-scene\fP.  Each image in the > range is read with the filename followed by a period (\fB.\fP)B and the scene number.  You can change this behavior by embedding aA \fBprintf\fP format specification in the file name.  For example,  .PP  .B!         -scene 0-9 image%02d.miff  .PP @ displays files image00.miff, image01.miff, through image09.miff. .SH BUTTONS G The effects of each button press is described below.  Three buttons are G required.  If you have a two button mouse, button 1 and 3 are returned. , Press ALT and button 3 to simulate button 2. .TP 5  .B "1": Press this button to map or unmap the Command widget.  See? the next section for more information about the Command widget.  .TP 5  .B "2": Press and drag to define a region of the image to magnify. .TP 5  .B "3"E Choose a particular tile of the visual image directory and press this D button and drag to select a command from a pop-up menu.  Choose from these menu items:  .PP      Load
     Delete .PP @ If you choose \fBDelete\fP, the image represented by the tile isD deleted.  Otherwise, it is displayed.  To return to the visual image> directory, choose \fBNext\fP from the Command widget (refer toA COMMAND WIDGET).  See \fBmontage(1)\fP and \fBmiff(5)\fP for more  details. .SH COMMAND WIDGETF The Command widget lists a number of sub-menus and commands.  They are .PP      File
       Load... 
       Next       Former       Select...        Write...       Print...       Delete...        Canvas...        Slide Show       Visual Directory...      Edit
       Undo	       Cut 
       Copy       Paste 
       Refresh      Size       Half Size        Original Size        Double Size        Resize... 
       Restore        Apply      Pixel Transform 
       Crop
       Chop
       Flop
       Flip       Rotate Right       Rotate Left        Rotate...        Shear...       Trim Edges     Color Enhance        Hue...       Saturation...        Brightness...        Gamma...       Spiff...
       Dull       Equalize       Normalize        Negate       Toggle Colormap      Effects        Despeckle        Peak Noise       Sharpen...
       Blur...        Edge Detect        Emboss       Oil Painting
       Segment        Grayscale        Quantize...      Image Edit       Annotate
       Draw       Color        Matte        Composite...       Add Border... 
       Comment        Region of Interest     Info       Image Info
       Version 
       Help     Quit .PP > Menu items with a indented triangle have a sub-menu.  They areD represented above as the indented items.  To access a sub-menu item,E move the pointer to the appropriate menu and press a button and drag. C When you find the desired sub-menu item, release the button and the D command is executed.  Move the pointer away from the sub-menu if you+ decide not to execute a particular command.  .SH KEYBOARD ACCELERATORS I Accelerators are one or two key presses that effect a particular command. ? The keyboard accelerators that \fBdisplay(1)\fP understands is:  .TP 5  .B "l"# Press to load an image from a file.   . Refer to \fBIMAGE LOADING\fP for more details. .TP 5  .B "n"  Press to display the next image. .TP 5  .B "f"" Press to display the former image. .TP 5  .B "F2" / Press to select an image from the command line.  .TP 5  .B "w"# Press to write the image to a file.  .TP 5  .B "p"1 Press to print the image to a Postscript printer.  .TP 5  .B "^" Press to delete an image file. .TP 5  .B "C" Press to create a blank canvas.  .TP 5  .B ",". Press to display the next image after pausing. .TP 5  .B "V") Press to create a Visual Image Directory.   7 Refer to \fBVISUAL IMAGE DIRECTORY\fP for more details.  .TP 5  .B "u"( Press to undo last image transformation. .TP 5  .B "F3" # Press to cut a region of the image.   . Refer to \fBIMAGE CUTTING\fP for more details. .TP 5  .B "F4" $ Press to copy a region of the image.  . Refer to \fBIMAGE COPYING\fP for more details. .TP 5  .B "F5" % Press to paste a region to the image.   . Refer to \fBIMAGE PASTING\fP for more details. .TP 5  .B "@"" Press to refresh the Image window. .TP 5  .B "<" Press to half the image size.  .TP 5  .B "o"+ Press to return to the original image size.  .TP 5  .B ">" Press to double the image size.  .TP 5  .B "%"< Press to resize the image to a width and height you specify. .TP 5  .B "r"0 Press to restore the image to its original size. .TP 5  .B "A"2 Press to make any image transformations permanent.  = By default, any image size transformations are applied to the K original image to create the image displayed on the X server.  However, the J transformations are not permanent (i.e. the original image does not changeK size only the X image does).  For example, if you press \fB>\fP the X image L will appear to double in size, but the orginal image will in fact remain theH same size.  To force the original image to double in size, press \fB>\fP followed by \fBA\fP. .TP 5  .B "[" Press to crop the image.  / Refer to \fBIMAGE CROPPING\fP for more details.  .TP 5  .B "]" Press to chop the image.  / Refer to \fBIMAGE CHOPPING\fP for more details.  .TP 5  .B "|"0 Press to flop image in the horizontal direction. .TP 5  .B "-". Press to flip image in the vertical direction. .TP 5  .B "/"/ Press to rotate the image 90 degrees clockwise.  .TP 5  .B \(bs 7 Press to rotate the image 90 degrees counter-clockwise.  .TP 5  .B "*"< Press to rotate the image the number of degrees you specify.  / Refer to \fBIMAGE ROTATION\fP for more details.  .TP 5  .B "s"; Press to shear the image the number of degrees you specify.  .TP 5  .B "t" Press to trim the image edges. .TP 5  .B "F7"  Press to vary the color hue. .TP 5  .B "F8" # Press to vary the color saturation.  .TP 5  .B "F9" # Press to vary the image brightness.  .TP 5  .B "g"! Press to gamma correct the image.  .TP 5  .B "F10"% Press to spiff up the image contrast.  .TP 5  .B "F11"! Press to dull the image contrast.  .TP 5  .B "="5 Press to perform histogram equalization on the image.  .TP 5  .B "N"6 Press to perform histogram normalization on the image. .TP 5  .B "~"( Press to negate the colors of the image. .TP 5  .B "F12"- toggle the colormap type: : Shared or Private  .TP 5  .B "D") Press to reduce the speckles in an image.  .TP 5  .B "P", Press to eliminate peak noise from an image. .TP 5  .B "S" Press to sharpen an image. .TP 5  .B "B" Press to blur image an image.  .TP 5  .B "E"& Press to detect edges within an image. .TP 5  .B "M" Press to emboss an image.  .TP 5  .B "O" Press to oil paint an image. .TP 5  .B "G"* Press to convert the image colors to gray. .TP 5  .B "#"> Press to set the maximum number of unique colors in the image. .TP 5  .B "Z"$ Press to segment the image by color. .TP 5  .B "R"E Press to apply an image processing technique to a region of interest.   3 Refer to \fBREGION OF INTEREST\fP for more details.  .TP 5  .B "a"& Press to annotate the image with text.  1 Refer to \fBIMAGE ANNOTATION\fP for more details.  .TP 5  .B "d"" Press to draw a line on the image.  . Refer to \fBIMAGE DRAWING\fP for more details. .TP 5  .B "C"# Press to edit an image pixel color.   . Refer to \fBCOLOR EDITING\fP for more details. .TP 5  .B "m"* Press to edit the image matte information.  . Refer to \fBMATTE EDITING\fP for more details. .TP 5  .B "x"* Press to composite the image with another.  2 Refer to \fBIMAGE COMPOSITING\fP for more details. .TP 5  .B "a"# Press to add a border to the image.  .TP 5  .B "!" Press to add an image comment. .TP 5  .B "i"- Press to display information about the image.  .TP 5  .B "v"8 Press to display the version number of \fBdisplay(1)\fP. .TP 5  .B "h"< Press to display helpful information about \fBdisplay(1)\fP.  I Function keys \fIHELP\fP or \fIF1\fP are synonymous with the \fIh\fP key.  .TP 5  .B "q"- Press to discard all images and exit program.  .TP 5  .B "1-9"+ Press to change the level of magnification.  .PP N Use the arrow keys to move the image one pixel up, down, left, or right withinH the magnify window.  Be sure to first map the magnify window by pressing	 button 2.   D Press \fBALT\fP and one of the arrow keys to trim off one pixel from any side of the image. .SH "X RESOURCES" A \fBDisplay\fP options can appear on the command line or in your X F resource file.  Options on the command line supersede values specifiedB in your X resource file.  See \fBX(1)\fP for more information on X
 resources.  I Most \fBdisplay\fP options have a corresponding X resource.  In addition, - \fBdisplay\fP uses the following X resources:  .TP 5 & .B background (\fIclass\fP Background)J Specifies the preferred color to use for the Image window background.  The default is #ccc. .TP 5 ( .B borderColor (\fIclass\fP BorderColor)F Specifies the preferred color to use for the Image window border.  The default is black.  .TP 5 ( .B borderWidth (\fIclass\fP BorderWidth)L Specifies the width in pixels of the Image window border.  The default is 2. .TP 5 , .B editorCommand (\fIclass\fP editorCommand)G Specifies the name of the preferred editor when editing image comments.  The default is \fInedit  %s\fP.  .TP 5  .B font (\fIclass\fP FontList)C Specifies the name of the preferred font to use in normal formatted / text.  The default is 14 point \fIHelvetica\fP.  .TP 5 $ .B font[1-9] (\fIclass\fP Font[1-9])C Specifies the name of the preferred font to use when annotating the ; Image window with text.  The default fonts are \fIfixed\fP, F \fIvariable\fP, \fI5x8\fP, \fI6x10\fP, \fI7x13bold\fP, \fI8x13bold\fP,@ \fI9x15bold\fP, \fI10x20\fP, and \fI12x24\fP.  Refer to \fBIMAGE ANNOTATION\fP for more details.  .TP 5 & .B foreground (\fIclass\fP Foreground)K Specifies the preferred color to use for text within the Image window.  The  default is black.  .TP 5 " .B geometry (\fIclass\fP Geometry)> Specifies the preferred size and position of the image window.4 It is not necessarily obeyed by all window managers. .TP 5 * .B iconGeometry (\fIclass\fP IconGeometry)A Specifies the preferred size and position of the application when @ iconified.  It is not necessarily obeyed by all window managers. .TP 5  .B iconic (\fIclass\fP Iconic)D This resource indicates that you would prefer that the application'sE windows initially not be visible as if the windows had be immediately > iconified by you.  Window managers may choose not to honor the application's request. .TP 5   .B magnify (\fIclass\fP Magnify)H specifies an integral factor by which the image should be enlarged.  The
 default is 3.   F This value only affects the magnification window which is invoked withE button number 3 after the image is displayed.  Refer to \fBBUTTONS\fP  for more details.  .TP 5 & .B matteColor (\fIclass\fP MatteColor)@ Specify the color of windows.  It is used for the backgrounds of; windows, menus, and notices.  A 3D  effect  is achieved  by C using highlight and shadow colors derived from this color.  Default  value: #ccc. .TP 5  .B name (\fIclass\fP Name)> This resource specifies the name under which resources for theI application should be found.  This resource is useful in shell aliases to G distinguish between invocations of an application, without resorting to E creating links to alter the executable file name.  The default is the  application name.  .TP 5 " .B pen[1-9] (\fIclass\fP Pen[1-9])D Specifies the color of the preferred font to use when annotating the< Image window with text.  The default colors are \fIblack\fP,; \fIblue\fP, \fIgreen\fP, \fIcyan\fP, \fIgray\fP, \fIred\fP, @ \fImagenta\fP, \fIyellow\fP, and \fIwhite\fP.  Refer to \fBIMAGE ANNOTATION\fP for more details.  .TP 5 * .B printCommand (\fIclass\fP PrintCommand)K This command is executed whenever \fBPrint\fP is issued (see \fBBUTTONS\fP. B In general, it is the command to print Postscript to your printer. Default value: \fBlpr %s\fP. .TP 5 * .B sharedMemory (\fIclass\fP SharedMemory)H This resource specifies whether display should attempt use shared memoryF for pixmaps.  ImageMagick must be compiled with shared memory support,D and the display must support the MIT-SHM extension.  Otherwise, this* resource is ignored.  The default is True. .TP 5 " .B textFont (\fIclass\fP textFont)K Specifies the name of the preferred font to use in fixed (typewriter style) 7 formatted text.  The default is 14 point \fICourier\fP.  .TP 5  .B title (\fIclass\fP Title)H This resource specifies the title to be used for the Image window.  This> information is sometimes used by a window manager to provide aC header identifying the window.  The default is the image file name.  .TP 5 $ .B usePixmap (\fIclass\fP UsePixmap)H Images are maintained as a XImage by default.  Set this resource to TrueH to utilize a server Pixmap instead.  This option is useful if your imageF exceeds the dimensions of your server screen and you intend to pan the? image.  Panning is much faster with Pixmaps than with a XImage. E Pixmaps are considered a precious resource, use them with discretion.  .SH IMAGE LOADING K To select an image to display, choose \fBLoad\fP of the \fBFile\fP sub-menu C from the Command widget.  A file browser is displayed.  To choose a E particular image file, move the pointer to the filename and press any @ button.  The filename is copied to the text window.  Next, pressD \fBLoad\fP or press the RETURN key.  Alternatively, you can type theG image file name directly into the text window.  To descend directories, H choose a directory name and press the button twice quickly.  A scrollbarH allows a large list of filenames to be moved through the viewing area if% it exceeds the size of the list area.  .PP G You can trim the list of file names by using shell globbing characters. J For example, type \fB*.jpg\fP to list only files that end with \fB.jpg\fP. .PP E To select your image from the X server screen instead of from a file, + Choose \fBGrab\fP of the \fBLoad\fP widget.  .SH VISUAL IMAGE DIRECTORYD To create a Visual Image Directory, choose \fBVisual Directory\fP ofC the \fBFile\fP sub-menu from the Command widget.  A file browser is E displayed.  To create a Visual Image Directory from all the images in E the current directory, press \fBDirectory\fP or press the RETURN key. A Alternatively, you can select a set of image names by using shell C globbing characters.  For example, type \fB*.jpg\fP to include only A files that end with \fB.jpg\fP.  To descend directories, choose a F directory name and press the button twice quickly.  A scrollbar allowsD a large list of filenames to be moved through the viewing area if it" exceeds the size of the list area. .PP D After you select a set of files, they are turned into thumbnails and@ tiled onto a single image.  Now move the pointer to a particularH thumbnail and press button 3 and drag.  Finally, select \fBLoad\fP.  TheA image represented by the thumbnail is displayed at its full size. G Choose \fBNext\fP from the \fBFile\fP sub-menu of the Command widget to % return to the Visual Image Directory.  .SH IMAGE CUTTING D Note that cut information for \fIImage window\fP is not retained for5 colormapped X server visuals (e.g. \fIStaticColor\fP, @ \fIStaticColor\fP, \fIGrayScale\fP, \fIPseudoColor\fP).  CorrectC cutting behavior may require a \fITrueColor\fP or \fIDirectColor\fP $ visual or a \fIStandard Colormap\fP. .PP @ To begin, press choose \fBCut\fP of the \fBEdit\fP sub-menu fromM the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fBF3\fP 6 in the Image window (see \fBKEYBOARD ACCELERATORS\fP). .PP F A small window appears showing the location of the cursor in the imageG window.  You are now in \fIcut\fP mode.  In \fIcut\fP mode, the Command  widget has these options:  .PP      Help
     Return .PP 9 To define a cut region, press button 1 and drag.  The cut F region is defined by a highlighted rectangle that expands or contracts? as it follows the pointer.  Once you are satisfied with the cut ? region, release the button.  You are now in \fIrectify\fP mode. < In \fIrectify\fP mode, the Command widget has these options: .PP      Cut      Help
     Return .PP @ You can make adjustments by moving the pointer to one of the cut3 rectangle corners, pressing a button, and dragging. E Finally, press \fBCut\fP to commit your copy region.  To exit without & cutting the image, press \fBReturn\fP. .SH IMAGE COPYING A To begin, press choose \fBCopy\fP of the \fBEdit\fP sub-menu from M the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fBF4\fP 6 in the Image window (see \fBKEYBOARD ACCELERATORS\fP). .PP F A small window appears showing the location of the cursor in the imageI window.  You are now in \fIcopy\fP mode.  In \fIcopy\fP mode, the Command  widget has these options:  .PP      Help
     Return .PP ; To define a copy region, press button 1 and drag.  The copy F region is defined by a highlighted rectangle that expands or contracts@ as it follows the pointer.  Once you are satisfied with the copy? region, release the button.  You are now in \fIrectify\fP mode. < In \fIrectify\fP mode, the Command widget has these options: .PP      Copy     Help
     Return .PP A You can make adjustments by moving the pointer to one of the copy 3 rectangle corners, pressing a button, and dragging. F Finally, press \fBCopy\fP to commit your copy region.  To exit without& copying the image, press \fBReturn\fP. .SH IMAGE PASTING B To begin, press choose \fBPaste\fP of the \fBEdit\fP sub-menu fromM the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fBF5\fP 6 in the Image window (see \fBKEYBOARD ACCELERATORS\fP). .PP F A small window appears showing the location of the cursor in the image> window. You are now in \fIPaste\fP mode.  To exit immediately,F press \fBReturn\fP.  In \fIPaste\fP mode, the Command widget has these options: .PP 
     Operators 
       over       in	       out 
       atop	       xor 
       plus       minus 	       add        subtract       difference
       replace      Help
     Return .PP E Choose a composite operation from the \fBOperators\fP sub-menu of the > Command widget.  How each operator behaves is described below.H \fIImage window\fP is the image currently displayed on your X server and? \fIimage\fP is the image obtained with the File Browser widget.  .PP  .TP 9  .B over A The result is the union of the two image shapes, with \fIimage\fP 6 obscuring \fIImage window\fP in the region of overlap. .TP 9  .B in = The result is simply \fIimage\fP cut by the shape of \fIimage B window\fP.  None of the image data of \fIImage window\fP is in the result.  .TP 9  .B outG The resulting image is \fIimage\fP with the shape of \fIImage window\fP  cut out. .TP 9  .B atop > The result is the same shape as image \fIImage window\fP, with? \fIimage\fP obscuring \fIImage window\fP where the image shapes B overlap.  Note this differs from \fBover\fP because the portion ofE \fIimage\fP outside \fIImage window\fP's shape does not appear in the  result.  .TP 9  .B xorI The result is the image data from both \fIimage\fP and \fIImage window\fP A that is outside the overlap region.  The overlap region is blank.  .TP 9  .B plus @ The result is just the sum of the image data.  Output values are< cropped to 255 (no overflow).  This operation is independent of the matte channels. .TP 9  .B minusG The result of \fIimage\fP \- \fIImage window\fP, with underflow cropped C to zero.  The matte channel is ignored (set to 255, full coverage).  .TP 9  .B addF The result of \fIimage\fP + \fIImage window\fP, with overflow wrapping around (\fImod\fP 256).  .TP 9  .B subtract G The result of \fIimage\fP - \fIImage window\fP, with underflow wrapping G around (\fImod\fP 256).  The \fBadd\fP and \fBsubtract\fP operators can . be used to perform reversible transformations. .TP 9 
 .B difference E The result of abs(\fIimage\fP \- \fIImage window\fP).  This is useful & for comparing two very similar images. .TP 9 
 .B replaceD The resulting image is \fIImage window\fP replaced with \fIimage\fP.& Here the matte information is ignored. .PP D The image compositor requires a matte, or alpha channel in the imageE for some operations.  This extra channel usually defines a mask which E represents a sort of a cookie-cutter for the image.  This is the case C when matte is 255 (full coverage) for pixels inside the shape, zero G outside, and between zero and 255 on the boundary.  If \fIimage\fP does @ not have a matte channel, it is initialized with 0 for any pixel> matching in color to pixel location (0,0), otherwise 255.  See= \fBMATTE EDITING\fP for a method of defining a matte channel.  .PP F Note that matte information for \fIImage window\fP is not retained for5 colormapped X server visuals (e.g. \fIStaticColor\fP, @ \fIStaticColor\fP, \fIGrayScale\fP, \fIPseudoColor\fP).  CorrectG compositing behavior may require a \fITrueColor\fP or \fIDirectColor\fP $ visual or a \fIStandard Colormap\fP. .PP C Choosing a composite operator is optional.  The default operator is K \fIreplace\fP.  However, you must choose a location to composite your image F and press a button.  Press and hold the button before releasing and anD outline of the image will appear to help you identify your location. .PP C The actual colors of the pasted image is saved.  However, the color G that appears in \fIImage window\fP may be different.  For example, on a D monochrome screen \fIImage window\fP will appear black or white even? though your pasted image may have many colors.  If the image is E saved to a file it is written with the correct colors.  To assure the B correct colors are saved in the final image, any \fIPseudoClass\fPG image is promoted to \fIDirectClass\fP (see \fBmiff(5)\fP).  To force a G \fIPseudoClass\fP image to remain \fIPseudoClass\fP, use \fB-colors\fP.  .SH IMAGE CROPPINGL To begin, press choose \fBCrop\fP of the \fBPixel Transform\fP sub-menu fromL the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fB[\fP6 in the Image window (see \fBKEYBOARD ACCELERATORS\fP). .PP F A small window appears showing the location of the cursor in the imageI window.  You are now in \fIcrop\fP mode.  In \fIcrop\fP mode, the Command  widget has these options:  .PP      Help
     Return .PP C To define a cropping region, press button 1 and drag.  The cropping F region is defined by a highlighted rectangle that expands or contractsD as it follows the pointer.  Once you are satisfied with the cropping? region, release the button.  You are now in \fIrectify\fP mode. < In \fIrectify\fP mode, the Command widget has these options: .PP      Crop     Help
     Return .PP E You can make adjustments by moving the pointer to one of the cropping 3 rectangle corners, pressing a button, and dragging. J Finally, press \fBCrop\fP to commit your cropping region.  To exit without' cropping the image, press \fBReturn\fP.  .SH IMAGE CHOPPINGH An image is chopped interactively.  There is no command line argument toH chop an image.  To begin, choose \fBChop\fP of the \fBPixel Transform\fPL sub-menu from the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively,D press \fB]\fP in the Image window (see \fBKEYBOARD ACCELERATORS\fP). .PP I You are now in \fIChop\fP mode.  To exit immediately, press \fBReturn\fP. 9 In \fIChop\fP mode, the Command widget has these options:  .PP 
     Direction        horizontal       vertical     Help
     Return .PP G If the you choose the \fBhorizontal\fP direction (this is the default), F the area of the image between the two horizontal endpoints of the chopB line is removed.  Otherwise, the area of the image between the two/ vertical endpoints of the chop line is removed.  .PP L Select a location within the Image window to begin your chop, press and holdM any button.  Next, move the pointer to another location in the image.  As you H move a line will connect the initial location and the pointer.  When youF release the button, the area within the image to chop is determined by3 which direction you choose from the Command widget.  .PP C To cancel the image chopping, move the pointer back to the starting ) point of the line and release the button.  .SH IMAGE ROTATIONC Press the \fB/\fP key to rotate the image 90 degrees or \fB\\\fP to G rotate -90 degrees (see \fBKEYBOARD ACCELERATORS\fP).  To interactively E choose the degree of rotation, choose \fBRotate...\fP of the \fBPixel < Transform\fP submenu from the Command Widget (see \fBCOMMANDB WIDGET\fP).  Alternatively, press \fI*\fP in the Image window (see \fBKEYBOARD ACCELERATORS\fP).  .PP E A small horizontal line is drawn next to the pointer.  You are now in < \fIrotate\fP mode.  To exit immediately, press \fBReturn\fP.; In \fIrotate\fP mode, the Command widget has these options:  .PP      Pixel Color        black 
       blue
       cyan       green 
       gray	       red 
       magenta        yellow       white        Browser...
     Direction        horizontal       vertical     Help
     Return .PP > Choose a background color from the \fBPixel Color\fP sub-menu.E Additional background colors can be specified with the color browser. D You can change the menu colors by setting the X resources \fBpen1\fPA through \fBpen9\fP.  Refer to \fBX RESOURCES\fP for more details.  .PP D If you choose the color browser and press \fBGrab\fP, you can selectF the background color by moving the pointer to the desired color on the screen and press any button. .PP B Choose a point in the Image window and press this button and hold.G Next, move the pointer to another location in the image.  As you move a E line connects the initial location and the pointer.  When you release F the button, the degree of image rotation is determined by the slope ofC the line you just drew.  The slope is relative to the direction you ? choose from the \fBDirection\fP sub-menu of the Command widget.  .PP C To cancel the image rotation, move the pointer back to the starting ) point of the line and release the button.  .SH IMAGE ANNOTATIONG An image is annotated interactively.  There is no command line argument F to annotate an image.  To begin, choose \fIAnnotate\fP of the \fBImageD Edit\fP sub-menu from the Command widget (see \fBCOMMAND WIDGET\fP).A Alternatively, press \fIa\fP in the Image window (see \fBKEYBOARD  ACCELERATORS\fP).  .PP F A small window appears showing the location of the cursor in the imageB window.  You are now in \fIannotate\fP mode.  To exit immediately,I press \fBReturn\fP.  In \fIannotate\fP mode, the Command widget has these  options: .PP 
     Font Name        fixed        variable	       5x8 
       6x10       7x13bold       8x13bold       9x15bold       10x20        12x24        Browser...     Font Color       black 
       blue
       cyan       green 
       gray	       red 
       magenta        yellow       white        Browser...     Rotate Text        45       90	       135 	       180 	       225 	       270 	       315        Dialog...      Help
     Return .PP 5 Choose a font name from the \fBFont Name\fP sub-menu. = Additional font names can be specified with the font browser. D You can change the menu names by setting the X resources \fBfont1\fPB through \fBfont9\fP.  Refer to \fBX RESOURCES\fP for more details. .PP 7 Choose a font color from the \fBFont Color\fP sub-menu. ? Additional font colors can be specified with the color browser. D You can change the menu colors by setting the X resources \fBpen1\fPA through \fBpen9\fP.  Refer to \fBX RESOURCES\fP for more details.  .PP D If you select the color browser and press \fBGrab\fP, you can chooseG the font color by moving the pointer to the desired color on the screen  and press any button.  .PP = If you choose to rotate the text, choose Rotate Text from the : menu and select an angle.  Typically you will only want to> rotate one line of text at a time.  Depending on the angle you; choose, subsequent lines may end up overwriting each other.  .PP ? Choosing a font and its color is optional.  The default font is D \fIfixed\fP and the default color is \fIblack\fP.  However, you must@ choose a location to begin entering text and press a button.  AnE underscore character will appear at the location of the pointer.  The F cursor changes to a pencil to indicate you are in \fItext\fP mode.  To% exit immediately, press \fBReturn\fP.  .PP A In \fItext\fP mode, any key presses will display the character at A the location of the underscore and advance the underscore cursor. J Enter your text and once completed press \fBReturn\fP to finish your imageD annotation.  To correct errors press \fBBACK SPACE\fP.  To delete anC entire line of text, press \fBDELETE\fP.  Any text that exceeds the G boundaries of the Image window is automatically continued onto the next  line.  .PP @ The actual color you request for the font is saved in the image.F However, the color that appears in your Image window may be different.L For example, on a monochrome screen the text will appear black or white evenK if you choose the color red as the font color.  However, the image saved to B a file with \fB-write\fP is written with red lettering.  To assureF the correct color text in the final image, any \fIPseudoClass\fP image9 is promoted to \fIDirectClass\fP (see \fBmiff(5)\fP).  To @ force a \fIPseudoClass\fP image to remain \fIPseudoClass\fP, use \fB-colors\fP. .SH IMAGE COMPOSITING F An image composite is created interactively.  There is no command lineD argument to composite an image.  To begin, choose \fBComposite\fP of< the \fBImage Edit\fP from the Command widget (see \fBCOMMANDB WIDGET\fP).  Alternatively, press \fIx\fP in the Image window (see \fBKEYBOARD ACCELERATORS\fP).  .PP H First a popup window is displayed requesting you to enter an image name.J Press \fBComposite\fP, \fBGrab\fP or type a file name.  Press \fBCancel\fPK if you choose not to create a composite image.  When you choose \fBGrab\fP, < move the pointer to the desired window and press any button. .PP F A small window appears showing the location of the cursor in the imageB window. You are now in \fIcomposite\fP mode.  To exit immediately,J press \fBReturn\fP.  In \fIcomposite\fP mode, the Command widget has these options: .PP 
     Operators 
       over       in	       out 
       atop	       xor 
       plus       minus 	       add        subtract       difference
       replace      Help
     Return .PP E Choose a composite operation from the \fBOperators\fP sub-menu of the > Command widget.  How each operator behaves is described below.H \fIImage window\fP is the image currently displayed on your X server and? \fIimage\fP is the image obtained with the File Browser widget.  .PP  .TP 9  .B over A The result is the union of the two image shapes, with \fIimage\fP 6 obscuring \fIImage window\fP in the region of overlap. .TP 9  .B in = The result is simply \fIimage\fP cut by the shape of \fIimage B window\fP.  None of the image data of \fIImage window\fP is in the result.  .TP 9  .B outG The resulting image is \fIimage\fP with the shape of \fIImage window\fP  cut out. .TP 9  .B atop > The result is the same shape as image \fIImage window\fP, with? \fIimage\fP obscuring \fIImage window\fP where the image shapes B overlap.  Note this differs from \fBover\fP because the portion ofE \fIimage\fP outside \fIImage window\fP's shape does not appear in the  result.  .TP 9  .B xorI The result is the image data from both \fIimage\fP and \fIImage window\fP A that is outside the overlap region.  The overlap region is blank.  .TP 9  .B plus @ The result is just the sum of the image data.  Output values are< cropped to 255 (no overflow).  This operation is independent of the matte channels. .TP 9  .B minusG The result of \fIimage\fP \- \fIImage window\fP, with underflow cropped C to zero.  The matte channel is ignored (set to 255, full coverage).  .TP 9  .B addF The result of \fIimage\fP + \fIImage window\fP, with overflow wrapping around (\fImod\fP 256).  .TP 9  .B subtract G The result of \fIimage\fP - \fIImage window\fP, with underflow wrapping G around (\fImod\fP 256).  The \fBadd\fP and \fBsubtract\fP operators can . be used to perform reversible transformations. .TP 9 
 .B difference E The result of abs(\fIimage\fP \- \fIImage window\fP).  This is useful & for comparing two very similar images. .TP 9 
 .B replaceD The resulting image is \fIImage window\fP replaced with \fIimage\fP.& Here the matte information is ignored. .PP D The image compositor requires a matte, or alpha channel in the imageE for some operations.  This extra channel usually defines a mask which E represents a sort of a cookie-cutter for the image.  This is the case C when matte is 255 (full coverage) for pixels inside the shape, zero G outside, and between zero and 255 on the boundary.  If \fIimage\fP does @ not have a matte channel, it is initialized with 0 for any pixel> matching in color to pixel location (0,0), otherwise 255.  See= \fBMATTE EDITING\fP for a method of defining a matte channel.  .PP F Note that matte information for \fIImage window\fP is not retained for5 colormapped X server visuals (e.g. \fIStaticColor\fP, @ \fIStaticColor\fP, \fIGrayScale\fP, \fIPseudoColor\fP).  CorrectG compositing behavior may require a \fITrueColor\fP or \fIDirectColor\fP $ visual or a \fIStandard Colormap\fP. .PP C Choosing a composite operator is optional.  The default operator is K \fIreplace\fP.  However, you must choose a location to composite your image F and press a button.  Press and hold the button before releasing and anD outline of the image will appear to help you identify your location. .PP F The actual colors of the composite image is saved.  However, the colorG that appears in \fIImage window\fP may be different.  For example, on a D monochrome screen \fIImage window\fP will appear black or white evenC though your composited image may have many colors.  If the image is E saved to a file it is written with the correct colors.  To assure the B correct colors are saved in the final image, any \fIPseudoClass\fPG image is promoted to \fIDirectClass\fP (see \fBmiff(5)\fP).  To force a G \fIPseudoClass\fP image to remain \fIPseudoClass\fP, use \fB-colors\fP.  .SH COLOR EDITING E Changing the the color of a set of pixels is performed interactively. D There is no command line argument to edit a pixel.  To begin, chooseC \fBColor\fP from the \fBImage Edit\fP submenu of the Command widget F (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fIc\fP in the image) window (see \fBKEYBOARD ACCELERATORS\fP).  .PP F A small window appears showing the location of the cursor in the imageC window. You are now in \fIcolor edit\fP mode.  To exit immediately, K press \fBReturn\fP.  In \fIcolor edit\fP mode, the Command widget has these  options: .PP      Pixel Color        black 
       blue
       cyan       green 
       gray	       red 
       magenta        yellow       white        Browser...
     Method       point 
       replace        floodfill      Undo     Help
     Return .PP 9 Choose a pixel color from the \fBPixel Color\fP sub-menu. @ Additional pixel colors can be specified with the color browser.D You can change the menu colors by setting the X resources \fBpen1\fPA through \fBpen9\fP.  Refer to \fBX RESOURCES\fP for more details.  .PP E Next, choose a color editing method from the \fBMethod\fP sub-menu of G the Command widget.  The \fBpoint\fP method recolors any pixel selected B with the pointer unless the button is released.  The \fBreplace\fPA method recolors any pixel that matches the color of the pixel you D select with a button press.  \fBFloodfill\fP recolors any pixel thatF matches the color of the pixel you select with a button press and is a	 neighbor.  .PP J Now press a button to select a pixel within the Image window to change itsJ color.  Additional pixels may be recolored as prescribed by the method youJ choose.  If the Magnify widget is mapped, it can be helpful in positioning2 your pointer within the image (refer to button 2). .PP B The actual color you request for the pixels is saved in the image.F However, the color that appears in your Image window may be different.B For example, on a monochrome screen the pixel will appear black orH white even if you choose the color red as the pixel color.  However, theG image saved to a file with \fB-write\fP is written with red pixels.  To G assure the correct color text in the final image, any \fIPseudoClass\fP G image is promoted to \fIDirectClass\fP (see \fBmiff(5)\fP).  To force a G \fIPseudoClass\fP image to remain \fIPseudoClass\fP, use \fB-colors\fP.  .SH MATTE EDITING G Matte information within an image is useful for some operations such as D image compositing (See \fBIMAGE COMPOSITING\fP).  This extra channelE usually defines a mask which represents a sort of a cookie-cutter for B the image.  This is the case when matte is 255 (full coverage) forF pixels inside the shape, zero outside, and between zero and 255 on the	 boundary.  .PP G Setting the matte information in an image is done interactively.  There B is no command line argument to edit a pixel.  To begin, and chooseD \fIMatte\fP of the \fBImage Edit\fP sub-menu from the Command widgetF (see \fBCOMMAND WIDGET\fP).  Alternatively, press \fIm\fP in the image) window (see \fBKEYBOARD ACCELERATORS\fP).  .PP F A small window appears showing the location of the cursor in the imageC window. You are now in \fImatte edit\fP mode.  To exit immediately, K press \fBReturn\fP.  In \fImatte edit\fP mode, the Command widget has these  options: .PP 
     Method       point 
       replace        floodfill 	     Matte      Undo     Help
     Return .PP C Choose a matte editing method from the \fBMethod\fP sub-menu of the F Command widget.  The \fBpoint\fP method changes the matte value of theF any pixel selected with the pointer until the button is released.  TheF \fBreplace\fP method changes the matte value of any pixel that matchesG the color of the pixel you select with a button press.  \fBFloodfill\fP H changes the matte value of any pixel that matches the color of the pixel1 you select with a button press and is a neighbor.  .PP N Choose \fBMatte Value\fP and a dialog appears requesting a matte value.  EnterL a value between 0 and 255.  This value is assigned as the matte value of the selected pixel or pixels.  .PP I Now, press any button to select a pixel within the Image window to change D its matte value.  If the Magnify widget is mapped, it can be helpfulA in positioning your pointer within the image (refer to button 2).  .PP = Matte information is only valid in a \fIDirectClass\fP image. G Therefore, any \fIPseudoClass\fP image is promoted to \fIDirectClass\fP G (see \fBmiff(5)\fP).  Note that matte information for \fIPseudoClass\fP 6 is not retained for colormapped X server visuals (e.g.6 \fIStaticColor\fP, \fIStaticColor\fP, \fIGrayScale\fP,C \fIPseudoColor\fP) unless you immediately save your image to a file E (refer to \fBWrite\fP).  Correct matte editing behavior may require a I \fITrueColor\fP or \fIDirectColor\fP visual or a \fIStandard Colormap\fP.  .SH IMAGE DRAWING : An image is drawn upon interactively.  There is no commandB line argument to draw on an image.  To begin, choose \fIDraw\fP ofE the \fBImage Edit\fP sub-menu from the Command widget (see \fBCOMMAND B WIDGET\fP).  Alternatively, press \fId\fP in the Image window (see \fBKEYBOARD ACCELERATORS\fP).  .PP I The cursor changes to a crosshair to indicate you are in \fIdraw\fP mode. I To exit immediately, press \fBReturn\fP.  In \fIdraw\fP mode, the Command  widget has these options:  .PP 
     Primitive 
       line       rectangle        fill rectangle	     Color        black 
       blue
       cyan       green 
       gray	       red 
       magenta        yellow       white        Browser...	     Width        1        2        4        6        8        Dialog...      Undo     Help
     Return .PP = Choose a drawing primitive from the \fBPrimitive\fP sub-menu.  .PP 3 Next, choose a color from the \fBColor\fP sub-menu. : Additional colors can be specified with the color browser.D You can change the menu colors by setting the X resources \fBpen1\fPA through \fBpen9\fP.  Refer to \fBX RESOURCES\fP for more details.  .PP D If you choose the color browser and press \fBGrab\fP, you can selectE the primitive color by moving the pointer to the desired color on the  screen and press any button. .PP 2 Choose a line width from the \fBWidth\fP sub-menu.4 To choose a specific width select the Dialog widget. .PP ? Choose a point in the Image window and press a button and hold. H Next, move the pointer to another location in the image.  As you move, aE line connects the initial location and the pointer.  When you release B the button, the image is updated with the primitive you just drew. .PP > To cancel image drawing, move the pointer back to the starting) point of the line and release the button.  .SH REGION OF INTERESTL To begin, press choose \fBRegion of Interest\fP of the \fBPixel Transform\fPL sub-menu from the Command widget (see \fBCOMMAND WIDGET\fP).  Alternatively,D press \fBR\fP in the Image window (see \fBKEYBOARD ACCELERATORS\fP). .PP F A small window appears showing the location of the cursor in the imageG window.  You are now in \fIregion of interest\fP mode.  In \fIregion of 7 interest\fP mode, the Command widget has these options:  .PP      Help
     Return .PP D To define a region of interest, press button 1 and drag.  The regionK of interest is defined by a highlighted rectangle that expands or contracts E as it follows the pointer.  Once you are satisfied with the region of ? interest, release the button.  You are now in \fIapply\fP mode. 9 In \fIapply\fP mode the Command widget has these options:  .PP      File       Image Info     Edit
       Undo     Pixel Transform 
       Flip
       Flop       Rotate Right       Rotate Left      Color Enhance        Brightness...        Saturation...        Hue...       Gamma...       Sharpen...
       Dull       Equalize       Normalize        Negate     Effects        Despeckle        Peak Noise
       Sharpen 
       Blur       Edge Detect        Emboss       Oil Painting
       Segment        Grayscale        Quantize...      Help
     Return .PP K You can make adjustments to the region of interest by moving the pointer to > one of the rectangle corners, pressing a button, and dragging.K Finally, choose an image processing technique from the Command widget.  You H can choose more than one image processing technique to apply to an area.B Alternatively, you can move the region of interest before applyingA another image processing technique.  To exit, press \fBReturn\fP.  .SH IMAGE PANNING A When an image exceeds the width or height of the X server screen, B \fBdisplay\fP maps a small panning icon.  The rectangle within the> panning icon shows the area that is currently displayed in theN the Image window.  To \fIpan\fP about the image, press any button and drag theJ pointer within the panning icon.  The pan rectangle moves with the pointer> and the Image window is updated to reflect the location of theC rectangle within the panning icon.  When you have selected the area 2 of the image you wish to view, release the button.  M Use the arrow keys to pan the image one pixel up, down, left, or right within  the Image window.   C The panning icon is withdrawn if the image becomes smaller than the " dimensions of the X server screen. .SH ENVIRONMENT  .TP 5 
 .B display4 To get the default host, display number, and screen. .SH SEE ALSO .Bd animate(1), import(1), montage(1), mogrify(1), mosaic(1), convert(1), segment(1), combine(1), xtp(1)
 .SH COPYRIGHT 3 Copyright 1995 E. I. du Pont de Nemours and Company  .PP G Permission to use, copy, modify, distribute, and sell this software and @ its documentation for any purpose is hereby granted without fee,F provided that the above copyright notice appear in all copies and that? both that copyright notice and this permission notice appear in G supporting documentation, and that the name of E. I. du Pont de Nemours A and Company not be used in advertising or publicity pertaining to < distribution of the software without specific, written priorJ permission.  E. I. du Pont de Nemours and Company makes no representationsG about the suitability of this software for any purpose.  It is provided , "as is" without express or implied warranty. .PP I E. I. du Pont de Nemours and Company disclaims all warranties with regard E to this software, including all implied warranties of merchantability F and fitness, in no event shall E. I. du Pont de Nemours and Company be@ liable for any special, indirect or consequential damages or anyG damages whatsoever resulting from loss of use, data or profits, whether F in an action of contract, negligence or other tortuous action, arisingE out of or in connection with the use or performance of this software.  .SH ACKNOWLEDGEMENTSG The MIT X Consortium for making network transparent graphics a reality.  .PP J Peder Langlo, Hewlett Packard, Norway made hundreds of suggestions and bugE reports.  Without Peder, ImageMagick would not be nearly as useful as  it is today. .PP ; Rod Bogart and John W. Peterson, University of Utah.  Image @ compositing is loosely based on \fIrlecomp\fP of the Utah Raster Toolkit. .PP < Michael Halle, Spatial Imaging Group at MIT, for the initial8 implementation of Alan Paeth's image rotation algorithm. .PP C David Pensak, E. I. du Pont de Nemours and Company, for providing a 6 computing environment that made this program possible. .PP > Paul Raveling, USC Information Sciences Institute. The spacialI subdivision color reduction algorithm is based on his \fIImg\fP software.  .SH AUTHORS = John Cristy, E.I. du Pont de Nemours and Company Incorporated 