 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             DDDD   IIIII  SSSSS  PPPP   L       AAA   Y   Y                 % O %             D   D    I    SS     P   P  L      A   A   Y Y                  % O %             D   D    I     SSS   PPPP   L      AAAAA    Y                   % O %             D   D    I       SS  P      L      A   A    Y                   % O %             DDDD   IIIII  SSSSS  P      LLLLL  A   A    Y                   % O %                                                                             % O %                                                                             % O %          Display Machine Independent File Format Image via X11.             % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Display is a machine architecture independent image processing G %  and display program.  It can display any image in the MIFF format on C %  any workstation display running X.  Display first determines the E %  hardware capabilities of the workstation.  If the number of unique J %  colors in the image is less than or equal to the number the workstationE %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Display program command syntax is:  % > %  Usage: display [options ...] file [ [options ...] file ...] %  %  Where options include: < %    -backdrop          display image centered on a backdrop8 %    -blur factor       apply a filter to blur the image= %    -border geometry   surround image with a border of color ) %    -colormap type     Shared or Private ? %    -colors value      preferred number of colors in the image G %    -colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV 5 %    -comment string    annotate image with comment", 4 %    -compress type     RunlengthEncoded or QEncoded< %    -contrast          enhance or reduce the image contrastH %    -crop geometry     preferred size and location of the cropped image< %    -delay seconds     display the next image after pausingD %    -density geometry  vertical and horizontal density of the image; %    -despeckle         reduce the speckles within an image 6 %    -display server    display image to this X serverF %    -dither            apply Floyd/Steinberg error diffusion to imageC %    -edge              apply a filter to detect edges in the image G %    -enhance           apply a digital filter to enhance a noisy image B %    -equalize          perform histogram equalization to an image< %    -flip              flip image in the vertical direction> %    -flop              flop image in the horizontal direction1 %    -gamma value       level of gamma correction G %    -geometry geometry preferred size and location of the Image window , %    -interlace type    NONE, LINE, or PLANE2 %    -label name        assign a label to an imageB %    -map type          display image using this Standard Colormap@ %    -matte             store matte channel if the image has one@ %    -modulate value    vary the hue, saturation, and saturation: %    -monochrome        transform image to black and white6 %    -negate            apply color inversion to imageI %    -noise             reduce noise with a noise peak elimination filter L %    -normalize         transform image to span the full the range of colors@ %    -page geometry     size and location of the Postscript page9 %    -pen color         X11 color for annotating an image , %    -quality value     JPEG quality setting@ %    -roll geometry     roll an image vertically or horizontally9 %    -rotate degrees    apply Paeth rotation to the image 7 %    -sample geometry   scale image with pixel sampling * %    -scene value       image scene number1 %    -size geometry     width and height of image ; %    -sharpen factor    apply a filter to sharpen the image I %    -shear geometry    slide one edge of the image along the X or Y axis 1 %    -size geometry     width and height of image > %    -treedepth value   depth of the color classification treeH %    -update seconds    detect when image file is modified and redisplayB %    -verbose           print detailed information about the image< %    -visual type       display image using this visual typeB %    -window id         display image to background of this window- %    -write filename    write image to a file  % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, I %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor, 0 %  -name, -shared_memory, -usePixmap, or -title. % D %  Change '-' to '+' in any option above to reverse its effect.  ForH %  example, specify +matte to store the image without its matte channel. % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 2 %    1    press to map or unmap the Command widget8 %    2    press and drag to magnify a region of an image> %    3    press to load an image from a visual image directory %  %  Keyboard accelerators: # %    l    load an image from a file   %    n    display the next image" %    f    display the former image7 %    F2   select an image to load from the command line # %    w    write the image to a file 1 %    p    print the image to a Postscript printer  %    ^    delete the image file  %    C    create a blank canvas . %    ,    display the next image after pausing) %    V    create a Visual Image Directory ( %    u    undo last image transformation% %    F3   cut a region from the image $ %    F4   copy a region of the image% %    F5   paste a region to the image " %    @    refresh the Image window %    <    half the image size  %    o    original image size  %    >    double the image size  %    %    resize the image0 %    r    restore the image to its original size. %    A    make image transformations permanent %    [    crop the image %    ]    chop the image0 %    |    flop image in the horizontal direction. %    -    flip image in the vertical direction/ %    /    rotate the image 90 degrees clockwise 7 %    \    rotate the image 90 degrees counter-clockwise  %    *    rotate the image %    s    shear the image  %    t    trim the image edges %    F7   vary the image hue# %    F8   vary the color saturation # %    F9   vary the color brightness ! %    g    gamma correct the image $ %    F10  sharpen the image contrast! %    F11  dull the image contrast 5 %    =    perform histogram equalization on the image 6 %    N    perform histogram normalization on the image( %    ~    negate the colors of the image7 %    F12  toggle the colormap type: : Shared or Private - %    D    reduce the speckles within an image , %    P    eliminate peak noise from an image %    S    sharpen the image  %    B    blur the image& %    E    detect edges within an image %    M    emboss an image  %    O    oil paint an image$ %    Z    segment the image by color( %    G    convert the image to grayscale> %    #    set the maximum number of unique colors in the image& %    a    annotate the image with text %    d    draw on the image # %    c    edit an image pixel color * %    m    edit the image matte information& %    x    composite image with another# %    b    add a border to the image  %    !    add an image commentC %    R    apply image processing techniques to a region of interest - %    i    display information about the image 0 %    v    display version number of this program0 %    h    display information about this program- %    q    discard all images and exit program + %    1-9  change the level of magnification  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h" #include "widget.h"  #include "PreRvIcccm.h"  #include "display.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Function Usage displays the program command syntax. % & %  The format of the Usage routine is: %  %      Usage(terminate)  % + %  A description of each parameter follows:  % J %    o terminate: A value other than zero is returned if the program is to %      terminate immediately.  %  */ static void Usage(terminate) unsigned int   terminate; {    char     **p;  
   static char      *buttons[]=      { 6       "1    press to map or unmap the Command widget",<       "2    press and drag to magnify a region of an image",B       "3    press to load an image from a visual image directory",       (char *) NULL      },     *keys[]=     { '       "l    load an image from a file", $       "n    display the next image",&       "f    display the former image",;       "F2   select an image to load from the command line", '       "w    write the image to a file", 5       "p    print the image to a Postscript printer", #       "^    delete the image file", #       "C    create a blank canvas", 2       ",    display the next image after pausing",-       "V    create a Visual Image Directory", ,       "u    undo last image transformation",)       "F3   cut a region from the image", (       "F4   copy a region of the image",)       "F5   paste a region to the image", &       "@    refresh the Image window",!       "<    half the image size", !       "o    original image size", #       ">    double the image size",        "%    resize the image",4       "r    restore the image to its original size",2       "A    make image transformations permanent",       "[    crop the image",       "]    chop the image",4       "|    flop image in the horizontal direction",2       "-    flip image in the vertical direction",3       "/    rotate the image 90 degrees clockwise", <       "\\    rotate the image 90 degrees counter-clockwise",       "*    rotate the image",       "s    shear the image", "       "t    trim the image edges",        "F7   vary the image hue",'       "F8   vary the color saturation", '       "F9   vary the color brightness", %       "g    gamma correct the image", (       "F10  sharpen the image contrast",%       "F11  dull the image contrast", 9       "=    perform histogram equalization on the image", :       "N    perform histogram normalization on the image",,       "~    negate the colors of the image",9       "F12  toggle the colormap type: Shared or Private", 1       "D    reduce the speckles within an image", 0       "P    eliminate peak noise from an image",       "S    sharpen the image",        "B    blur the image",*       "E    detect edges within an image",       "M    emboss an image",         "O    oil paint an image",)       "Z    segment the image by color.", ,       "G    convert the image to grayscale",B       "#    set the maximum number of unique colors in the image",*       "a    annotate the image with text",       "d    draw on the image", '       "c    edit an image pixel color", .       "m    edit the image matte information",*       "x    composite image with another",'       "b    add a border to the image", "       "!    add an image comment",G       "R    apply image processing techniques to a region of interest", 1       "i    display information about the image", 4       "v    display version number of this program",4       "h    display information about this program",1       "q    discard all images and exit program", /       "1-9  change the level of magnification",        (char *) NULL      },     *options[]=      { @       "-backdrop          display image centered on a backdrop",<       "-blur factor       apply a filter to blur the image",A       "-border geometry   surround image with a border of color", -       "-colormap type     Shared or Private", C       "-colors value      preferred number of colors in the image", K       "-colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV", 7       "-comment string    annotate image with comment", 8       "-compress type     RunlengthEncoded or QEncoded",@       "-contrast          enhance or reduce the image contrast",L       "-crop geometry     preferred size and location of the cropped image",@       "-delay seconds     display the next image after pausing",H       "-density geometry  vertical and horizontal density of the image",?       "-despeckle         reduce the speckles within an image", :       "-display server    display image to this X server",J       "-dither            apply Floyd/Steinberg error diffusion to image",G       "-edge              apply a filter to detect edges in the image", K       "-enhance           apply a digital filter to enhance a noisy image", F       "-equalize          perform histogram equalization to an image",@       "-flip              flip image in the vertical direction",B       "-flop              flop image in the horizontal direction",5       "-gamma value       level of gamma correction", K       "-geometry geometry preferred size and location of the Image window", /       "-interlace type    ONE, LINE, or PLANE", 6       "-label name        assign a label to an image",F       "-map type          display image using this Standard Colormap",D       "-matte             store matte channel if the image has one",D       "-modulate value    vary the hue, saturation, and brightness",>       "-monochrome        transform image to black and white",:       "-negate            apply color inversion to image",M       "-noise             reduce noise with a noise peak elimination filter", L       "-normalize         transform image to span the full range of colors",D       "-page geometry     size and location of the Postscript page",=       "-pen color         X11 color for annotating an image", 0       "-quality value     JPEG quality setting",D       "-roll geometry     roll an image vertically or horizontally",=       "-rotate degrees    apply Paeth rotation to the image", .       "-scene value       image scene number",5       "-size geometry     width and height of image", ;       "-sample geometry   scale image with pixel sampling", ?       "-sharpen factor    apply a filter to sharpen the image", M       "-shear geometry    slide one edge of the image along the X or Y axis", 5       "-size geometry     width and height of image", B       "-treedepth value   depth of the color classification tree",L       "-update seconds    detect when image file is modified and redisplay",F       "-verbose           print detailed information about the image",@       "-visual type       display image using this visual type",F       "-window id         display image to background of this window",1       "-write filename    write image to a file",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version);    (void) printf(N     "Usage: %s [-options ...] file [ [-options ...] file ...]\n",client_name);/   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) printf(H     "resources as command line options:  -background, -bordercolor,\n");   (void) printf(P     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor,\n");   (void) printf(7     "-name, -shared_memory, -usePixmap, or -title.\n");    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(M     "example, specify +matte to store the image without a matte channel.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); !   (void) printf("\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p); /   (void) printf("\nKeyboard accelerators: \n"); (   for (p=keys; *p != (char *) NULL; p++)     (void) printf("  %s\n",*p);    if (terminate)     exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % : %  Function _XAnnotateImage annotates the image with text. % 0 %  The format of the _XAnnotateImage routine is: % 9 %    _XAnnotateImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */H static unsigned int _XAnnotateImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {  #define AnnotateModeNameOp  0  #define AnnotateModeColorOp  1 #define AnnotateModeRotateOp  2  #define AnnotateModeHelpOp  3  #define AnnotateModeReturnOp  4  #define TextModeHelpOp  0  #define TextModeReturnOp  1   
   static char      *AnnotateModeMenu[]=     {        "Font Name",       "Font Color",        "Rotate Text",
       "Help",        "Return",        (char *) NULL      },     *TextModeMenu[]=     { 
       "Help",        "Return",        (char *) NULL      };     char     command[MaxTextLength],      *p,      text[MaxTextLength];     Cursor     cursor;      GC     annotate_context;      int      id,      x,     y;     KeySym     key_symbol;      register int     i;     static double      degrees = 0.0;     static unsigned int      font_id = 0,     pen_id = 0;      unsigned int     height,      status, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XAnnotateInfo      *annotate_info,      *previous_info;   
   XFontStruct      *font_info;      XEvent
     event,     text_event;      /*     Map Command widget.    */#   windows->command.name="Annotate";    windows->command.data=3;J   (void) XCommandWidget(display,windows,AnnotateModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { "           case AnnotateModeNameOp:           {              char'               font_name[MaxTextLength], *               *FontMenu[MaxNumberFonts+1];               int                font_number;               /*)               Initialize menu selections.              */.             for (i=0; i < MaxNumberFonts; i++)6               FontMenu[i]=resource_info->font_name[i];4             FontMenu[MaxNumberFonts-1]="Browser...";3             FontMenu[MaxNumberFonts]=(char *) NULL;              /*6               Select a font name from the pop-up menu.             */I             font_number=XMenuWidget(display,windows,AnnotateModeMenu[id], "               FontMenu,font_name);2             if (font_number == (MaxNumberFonts-1))               {                  static char 3                   font_name[MaxTextLength]="fixed";                    /*4                   Select a font name from a browser.                 */E                 resource_info->font_name[MaxNumberFonts-1]=font_name; G                 XFontBrowserWidget(display,windows,"Select",font_name); '                 if (*font_name == '\0')                    break;               } !             if (font_number >= 0)                {                  /*'                   Initialize font info.                  */O                 (void) strcpy(font_name,resource_info->font_name[font_number]); <                 font_info=XLoadQueryFont(display,font_name);6                 if (font_info == (XFontStruct *) NULL)G                   XNoticeWidget(display,windows,"Unable to load font:",                      font_name);                  else                   { (                     font_id=font_number;1                     XFreeFont(display,font_info);                    }                }              break;           } #           case AnnotateModeColorOp:            {              char(               color_name[MaxTextLength],*               *ColorMenu[MaxNumberPens+1];               int                pen_number;                /*)               Initialize menu selections.              */-             for (i=0; i < MaxNumberPens; i++) 7               ColorMenu[i]=resource_info->pen_color[i]; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */H             pen_number=XMenuWidget(display,windows,AnnotateModeMenu[id],$               ColorMenu,color_name);0             if (pen_number == (MaxNumberPens-1))               {                  static char 3                   color_name[MaxTextLength]="gray";                    /*3                   Select a pen color from a dialog.                  */E                 resource_info->pen_color[MaxNumberPens-1]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }               if (pen_number >= 0)               {                  /*                    Set pen color.                 */"                 pen_id=pen_number;K                 (void) strcpy(color_name,resource_info->pen_color[pen_id]); M                 status=XParseColor(display,windows->image.map_info->colormap, L                   color_name,&windows->image.pixel_info->pen_color[pen_id]);                  if (status == 0)P                   XNoticeWidget(display,windows,"Color is unknown to X server:",                      color_name);E                 XBestPixel(display,windows->image.map_info->colormap, 0                   (XColor *) NULL,(unsigned int)E                   Min(windows->image.visual_info->colormap_size,256), A                   &windows->image.pixel_info->pen_color[pen_id]);                }              break;           } $           case AnnotateModeRotateOp:           {              char%               command[MaxTextLength];                int                entry;               static char                *RotateMenu[]=               {                  "45",                  "90",                  "135",                 "180",                 "225",                 "270",                 "315",                 (char *) NULL,                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */&             RotateMenu[7]="Dialog...";N             entry=XMenuWidget(display,windows,AnnotateModeMenu[id],RotateMenu,               command);              if (entry < 0)               break;             if (entry != 7) .               degrees=atof(RotateMenu[entry]);             else               { .                 (void) strcpy(command,"30.0");K                 XDialogWidget(display,windows,"OK","Enter rotation angle:",                    command); %                 if (*command == '\0')                    break;&                 degrees=atof(command);               }              break;           } "           case AnnotateModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           } $           case AnnotateModeReturnOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 6         if (event.xbutton.window != windows->image.id)           break;
         /*'           Change to text entering mode. 
         */         x=event.xbutton.x;         y=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       { 
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*0     Set font info and check boundary conditions.   */F   font_info=XLoadQueryFont(display,resource_info->font_name[font_id]);(   if (font_info == (XFontStruct *) NULL)     { ;       XNoticeWidget(display,windows,"Unable to load font:", +         resource_info->font_name[font_id]); )       font_info=windows->image.font_info;      } >   if ((x+font_info->max_bounds.width) >= windows->image.width)7     x=windows->image.width-font_info->max_bounds.width; 1   if (y < (font_info->ascent+font_info->descent)) +     y=font_info->ascent+font_info->descent; =   if ((font_info->max_bounds.width > windows->image.width) || H       ((font_info->ascent+font_info->descent) >= windows->image.height))     return(False);   /*"     Initialize annotate structure.   */@   annotate_info=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));.   if (annotate_info == (XAnnotateInfo *) NULL)     return(False);"   XGetAnnotateInfo(annotate_info);   annotate_info->x=x;    annotate_info->y=y; =   annotate_info->height=font_info->ascent+font_info->descent; !   annotate_info->degrees=degrees; %   annotate_info->font_info=font_info; &   annotate_info->text=(char *) malloc(N     (windows->image.width/Max(font_info->min_bounds.width,1)+2)*sizeof(char));+   if (annotate_info->text == (char *) NULL)      return(False);   /**     Create cursor and set graphic context.   */.   cursor=XCreateFontCursor(display,XC_pencil);2   XDefineCursor(display,windows->image.id,cursor);=   annotate_context=XDefaultGC(display,windows->image.screen); 4   XSetFont(display,annotate_context,font_info->fid);*   XSetForeground(display,annotate_context,8     windows->image.pixel_info->pen_color[pen_id].pixel);   /*)     Begin annotating the image with text.    */   windows->command.name="Text";    windows->command.data=0;F   (void) XCommandWidget(display,windows,TextModeMenu,(XEvent *) NULL);   state=DefaultState; D   XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);F   text_event.xexpose.width=(unsigned int) font_info->max_bounds.width;9   text_event.xexpose.height=font_info->max_bounds.ascent+ "     font_info->max_bounds.descent;   p=annotate_info->text;   do   {      /*       Display text cursor.     */     *p='\0';F     XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         {            case TextModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);<             XDefineCursor(display,windows->image.id,cursor);             break;           }             case TextModeReturnOp:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:             break;	         }          continue;        }      /*       Erase text cursor.     */     text_event.xexpose.x=x; 8     text_event.xexpose.y=y-font_info->max_bounds.ascent;@     XClearArea(display,windows->image.id,x,text_event.xexpose.y,@       text_event.xexpose.width,text_event.xexpose.height,False);8     XRefreshWindow(display,&windows->image,&text_event);     switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);             break;           } ,         if (event.xbutton.button == Button2)           {              /*(               Request primary selection.             */E             XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, -               windows->image.id,CurrentTime);              break;           }          break;       }        case Expose:       { %         if (event.xexpose.count == 0)            {              XAnnotateInfo                *text_info;                /*#               Refresh Image window.              */D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);$             text_info=annotate_info;7             while (text_info != (XAnnotateInfo *) NULL) 
             { E               XDrawString(display,windows->image.id,annotate_context, :                 text_info->x,text_info->y,text_info->text,)                 strlen(text_info->text)); ,               text_info=text_info->previous;
             } N             XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);           }          break;       }        case KeyPress:       {          int            length;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; N         if ((event.xkey.state & ControlMask) || (event.xkey.state & Mod1Mask))           state|=ModifierState; "         if (state & ModifierState)           switch (key_symbol)            {              case XK_u:             case XK_U:
             { #               key_symbol=XK_Delete;                break;
             }              default:               break;           }          switch (key_symbol) 	         {            case XK_BackSpace:           {              /*"               Erase one character.             */)             if (p == annotate_info->text) D               if (annotate_info->previous == (XAnnotateInfo *) NULL)                 break;               else                 {                    /*;                     Go to end of the previous line of text.                    */8                   annotate_info=annotate_info->previous;(                   p=annotate_info->text;:                   x=annotate_info->x+annotate_info->width;%                   y=annotate_info->y; 0                   if (annotate_info->width != 0)3                     p+=strlen(annotate_info->text);                    break;                 }              p--;)             x-=XTextWidth(font_info,p,1); #             text_event.xexpose.x=x; @             text_event.xexpose.y=y-font_info->max_bounds.ascent;@             XRefreshWindow(display,&windows->image,&text_event);             break;           }            case XK_Delete:            {              /*,               Erase the entire line of text.             */,             while (p != annotate_info->text)
             {                p--;+               x-=XTextWidth(font_info,p,1); %               text_event.xexpose.x=x; B               XRefreshWindow(display,&windows->image,&text_event);
             }              break;           }            case XK_Escape:            case XK_F20:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:           {              /*:               Draw a single character on the Image window.             */&             if (state & ModifierState)               break;!             if (*command == '\0')                break;             *p=(*command);L             XDrawString(display,windows->image.id,annotate_context,x,y,p,1);)             x+=XTextWidth(font_info,p,1);              p++;G             if ((x+font_info->max_bounds.width) < windows->image.width)                break;           }            case XK_Return:            case XK_KP_Enter:            {              /*/               Advance to the next line of text.              */             *p='\0';J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); >             if (annotate_info->next != (XAnnotateInfo *) NULL)               {                  /*.                   Line of text already exists.                 */2                 annotate_info=annotate_info->next;#                 x=annotate_info->x; #                 y=annotate_info->y; &                 p=annotate_info->text;                 break;               } P             annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));>             if (annotate_info->next == (XAnnotateInfo *) NULL)               return(False);2             *annotate_info->next=(*annotate_info);8             annotate_info->next->previous=annotate_info;.             annotate_info=annotate_info->next;F             annotate_info->text=(char *) malloc((windows->image.width/B               Max(font_info->min_bounds.width,1)+2)*sizeof(char));5             if (annotate_info->text == (char *) NULL)                return(False);4             annotate_info->y+=annotate_info->height;9             if (annotate_info->y > windows->image.height) 5               annotate_info->y=annotate_info->height; 7             annotate_info->next=(XAnnotateInfo *) NULL;              x=annotate_info->x;              y=annotate_info->y; "             p=annotate_info->text;             break;           } 	         }          break;       }        case KeyRelease:       { 
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);           state&=(~ModifierState);         break;       }        case SelectionNotify:        {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;
         /*7           Annotate Image window with primary selection. 
         */"         for (i=0; i < length; i++)	         {            if (data[i] != '\n')
             {                /*<                 Draw a single character on the Image window.               */               *p=data[i]; N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);+               x+=XTextWidth(font_info,p,1);                p++;I               if ((x+font_info->max_bounds.width) < windows->image.width)                  continue; 
             }            /*-             Advance to the next line of text.            */           *p='\0';H           annotate_info->width=XTextWidth(font_info,annotate_info->text,)             strlen(annotate_info->text)); <           if (annotate_info->next != (XAnnotateInfo *) NULL)
             {                /*,                 Line of text already exists.               */0               annotate_info=annotate_info->next;!               x=annotate_info->x; !               y=annotate_info->y; $               p=annotate_info->text;               continue; 
             } /           annotate_info->next=(XAnnotateInfo *) *             malloc(sizeof(XAnnotateInfo));<           if (annotate_info->next == (XAnnotateInfo *) NULL)             return(False);0           *annotate_info->next=(*annotate_info);6           annotate_info->next->previous=annotate_info;,           annotate_info=annotate_info->next;D           annotate_info->text=(char *) malloc((windows->image.width/@             Max(font_info->min_bounds.width,1)+2)*sizeof(char));3           if (annotate_info->text == (char *) NULL)              return(False);2           annotate_info->y+=annotate_info->height;7           if (annotate_info->y > windows->image.height) 3             annotate_info->y=annotate_info->height; 5           annotate_info->next=(XAnnotateInfo *) NULL;            x=annotate_info->x;            y=annotate_info->y;             p=annotate_info->text;	         }          XFree((void *) data);          break;       }        default:         break;     } !   } while (!(state & ExitState));    XFreeCursor(display,cursor);   /*2     Annotation is relative to image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    /*     Initialize annotated image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);1   while (annotate_info != (XAnnotateInfo *) NULL)    { "     if (annotate_info->width == 0)       { 
         /*>           No text on this line--  go to the next line of text.
         */.         previous_info=annotate_info->previous;+         free((char *) annotate_info->text); %         free((char *) annotate_info); $         annotate_info=previous_info;         continue;        }      /*6       Determine foreground pixel index for font color.     */.     windows->image.pixel_info->annotate_color=3       windows->image.pixel_info->pen_color[pen_id]; 0     windows->image.pixel_info->annotate_index=0;/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == ?             windows->image.pixel_info->pen_color[pen_id].pixel)            { 8             windows->image.pixel_info->annotate_index=i;             break;           }      /**       Define the annotate geometry string.     */9     x_factor=UpShift(width)/windows->image.ximage->width; '     annotate_info->x+=windows->image.x; :     annotate_info->x=DownShift(annotate_info->x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height; ;     annotate_info->y+=(windows->image.y-font_info->ascent); :     annotate_info->y=DownShift(annotate_info->y*y_factor);9     (void) sprintf(annotate_info->geometry,"%ux%u%+d%+d", >       (unsigned int) DownShift(annotate_info->width*x_factor),?       (unsigned int) DownShift(annotate_info->height*y_factor), -       annotate_info->x+x,annotate_info->y+y);      /*       Annotate image with text.      */J     status=XAnnotateImage(display,windows->image.pixel_info,annotate_info,       False,image);      if (status == 0)       return(False);     /*       Free up memory.      */*     previous_info=annotate_info->previous;'     free((char *) annotate_info->text); !     free((char *) annotate_info);       annotate_info=previous_info;   } )   XSetCursorState(display,windows,False);    XFreeFont(display,font_info);    /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B l u r I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % & %  Function XBlurImage blurs an image. % + %  The format of the XBlurImage routine is:  % ; %    status=XBlurImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % > %    o status: Function XBlurImage return True if the image isF %      blurred.  False is returned is there is a memory shortage or if# %      the image cannot be blurred.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */C static unsigned int XBlurImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { . #define BlurImageText  "  Blurring image...  "  
   static char #     factor[MaxTextLength] = "60.0";      Image      *blurred_image;   '   XDialogWidget(display,windows,"Blur", 7     "Enter the blurring factor (0.0 - 99.9%):",factor);    if (*factor == '\0')     return(True);    /*     Blur image scanlines.    */-   XInfoWidget(display,windows,BlurImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);/   blurred_image=BlurImage(*image,atof(factor)); )   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); &   if (blurred_image == (Image *) NULL)     return(False);   DestroyImage(*image);    *image=blurred_image;    if (windows->image.orphan)     return(True);    /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B o r d e r I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 3 %  Function XBorderImage adds a border to an image.  % - %  The format of the XBorderImage routine is:  % = %    status=XBorderImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % A %    o status: Function XBorderImage return True if the border is B %      added to the image.  False is returned is there is a memory1 %      shortage or if the border cannot be added.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */E static unsigned int XBorderImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { / #define BorderImageText  "  Adding border...  "   
   ColorPacket      border_color;      int 
     flags;     Image      *bordered_image;     RectangleInfo      border_info;  
   static char '     color_name[MaxTextLength] = "gray", &     geometry[MaxTextLength] = "10x10";     XColor
     color;     /*     Add a border to the image.   */;   XColorBrowserWidget(display,windows,"Select",color_name);    if (*color_name == '\0')     return(True); J   (void) XParseColor(display,windows->image.map_info->colormap,color_name,     &color);)   border_color.red=ColorShift(color.red); -   border_color.green=ColorShift(color.green); +   border_color.blue=ColorShift(color.blue); F   XDialogWidget(display,windows,"Add Border","Enter border geometry:",     geometry);   if (*geometry == '\0')     return(True);    /*     Add a border to the image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); /   XInfoWidget(display,windows,BorderImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   border_info.width=0;   border_info.height=0; >   flags=XParseGeometry(geometry,&border_info.x,&border_info.y,,     &border_info.width,&border_info.height);!   if ((flags & HeightValue) == 0) )     border_info.height=border_info.width; @   bordered_image=BorderImage(*image,&border_info,&border_color);)   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); '   if (bordered_image == (Image *) NULL)      return(False);   DestroyImage(*image); $   bordered_image->class=DirectClass;   *image=bordered_image;8   windows->image.window_changes.width=(*image)->columns;6   windows->image.window_changes.height=(*image)->rows;@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ) %  Function XChopImage chops the X image.  % + %  The format of the XChopImage routine is:  % ; %    status=XChopImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % > %    o status: Function XChopImage return True if the image isF %      cut.  False is returned is there is a memory shortage or if the %      image fails to cut. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */C static unsigned int XChopImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { . #define ChopImageText  "  Chopping image...  " #define ChopModeDirectionOp  0 #define ChopModeHelpOp  1  #define ChopModeReturnOp  2  #define HorizontalChopOp  0  #define VerticalChopOp  1   
   static char      *ChopModeMenu[]=     {        "Direction",
       "Help",        "Return",        (char *) NULL      };     char     text[MaxTextLength];     Image      *chop_image;     int      id,      x,     y;     RectangleInfo      chop_info;     static unsigned int !     direction = HorizontalChopOp;      unsigned int
     distance,      height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;  
   XSegment     segment_info;      /*     Map Command widget.    */   windows->command.name="Chop";    windows->command.data=1;F   (void) XCommandWidget(display,windows,ChopModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,ChopModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { #           case ChopModeDirectionOp:            {              char%               command[MaxTextLength];                static char                *Directions[]=               {                  "horizontal",                  "vertical",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */             direction=O               XMenuWidget(display,windows,ChopModeMenu[id],Directions,command);              break;           }            case ChopModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);             break;           }             case ChopModeReturnOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*=           User has committed to start point of chopting line. 
         */(         segment_info.x1=event.xbutton.x;(         segment_info.x2=event.xbutton.x;(         segment_info.y1=event.xbutton.y;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   
         /*&           Respond to a user key press.
         */?         (void) XLookupString((XKeyEvent *) &event.xkey,command, ?           sizeof(command),&key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);        }      } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*B     Draw line as pointer moves until the mouse button is released.   */   chop_info.width=0;   chop_info.height=0;    chop_info.x=0;   chop_info.y=0;
   distance=0; B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      if (distance > 9)        { 
         /*.           Display info and draw chopping line.
         */"         if (!windows->info.mapped)/           XMapWindow(display,windows->info.id); L         (void) sprintf(text," %ux%u%+d%+d",chop_info.width,chop_info.height,#           chop_info.x,chop_info.y); *         XInfoWidget(display,windows,text);1         XHighlightLine(display,windows->image.id, :           windows->image.highlight_context,&segment_info);       }      else       if (windows->info.mapped) G         XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      if (distance > 9) /       XHighlightLine(display,windows->image.id, 8         windows->image.highlight_context,&segment_info);     switch (event.type)      {        case ButtonPress:        { (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;         break;       }        case ButtonRelease:        { 
         /*.           User has committed to chopping line.
         */(         segment_info.x2=event.xbutton.x;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case Expose:         break;       case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;       }        default:         break;     }      /*        Check boundary conditions.     */     if (segment_info.x2 < 0)       segment_info.x2=0;     else9       if (segment_info.x2 > windows->image.ximage->width) 5         segment_info.x2=windows->image.ximage->width;      if (segment_info.y2 < 0)       segment_info.y2=0;     else:       if (segment_info.y2 > windows->image.ximage->height)6         segment_info.y2=windows->image.ximage->height;
     distance= L       ((segment_info.x2-segment_info.x1)*(segment_info.x2-segment_info.x1))+L       ((segment_info.y2-segment_info.y1)*(segment_info.y2-segment_info.y1));     /*        Compute chopping geometry.     */&     if (direction == HorizontalChopOp)       { :         chop_info.width=segment_info.x2-segment_info.x1+1;5         chop_info.x=windows->image.x+segment_info.x1;          chop_info.height=0;          chop_info.y=0;.         if (segment_info.x1 > segment_info.x2)           { >             chop_info.width=segment_info.x1-segment_info.x2+1;9             chop_info.x=windows->image.x+segment_info.x2;            }        }      else       {          chop_info.width=0;;         chop_info.height=segment_info.y2-segment_info.y1+1;          chop_info.x=0;5         chop_info.y=windows->image.y+segment_info.y1; .         if (segment_info.y1 > segment_info.y2)           { ?             chop_info.height=segment_info.y1-segment_info.y2+1; 9             chop_info.y=windows->image.y+segment_info.y2;            }        } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (distance <= 9)     return(True);    /*6     Image chopping is relative to image configuration.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); -   XInfoWidget(display,windows,ChopImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   windows->image.window_changes.width=1     windows->image.ximage->width-chop_info.width; '   windows->image.window_changes.height= 3     windows->image.ximage->height-chop_info.height;    x=0;   y=0;   width=(*image)->columns;   height=(*image)->rows;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    chop_info.x+=x; 2   chop_info.x=DownShift(chop_info.x*scale_factor);:   chop_info.width=DownShift(chop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    chop_info.y+=y; 2   chop_info.y=DownShift(chop_info.y*scale_factor);<   chop_info.height=DownShift(chop_info.height*scale_factor);   /*     Chop image.    */*   chop_image=ChopImage(*image,&chop_info);)   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); #   if (chop_image == (Image *) NULL)      return(False);   DestroyImage(*image);    *image=chop_image;   /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r E d i t I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XColorEditImage allows the user to interactively change K %  the color of one pixel for a DirectColor image or one colormap entry for G %  a PseudoClass image.  The floodfill algorithm is strongly based on a : %  similiar algorithm in "Graphics Gems" by Paul Heckbert. % 0 %  The format of the XColorEditImage routine is: % 9 %    XColorEditImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */  + static void ColorFloodfill(image,x,y,color)  Image 	   *image;    int    x,   y;   XColor   color; {    int 
     delta,	     skip, 
     start,     x1,      x2;      register RunlengthPacket     *pixel;      register XSegment      *p;      RunlengthPacket      target;   
   XSegment     *segment_stack;      /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))      return; +   target=image->pixels[y*image->columns+x]; .   if ((target.red == ColorShift(color.red)) &&2       (target.green == ColorShift(color.green)) &&.       (target.blue == ColorShift(color.blue)))     return;    /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)      { D       Warning("Unable to recolor image","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (p > segment_stack)    {      /*       Pop segment off stack.     */     p--;
     x1=p->x1; 
     x2=p->x2;      delta=p->y2;     y=p->y1+delta;     /*!       Recolor neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     { /       pixel=image->pixels+(y*image->columns+x); '       if ((pixel->red != target.red) || +           (pixel->green != target.green) || '           (pixel->blue != target.blue))          break;'       pixel->red=ColorShift(color.red); +       pixel->green=ColorShift(color.green); )       pixel->blue=ColorShift(color.blue);      }      skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) $           Push(y,start,x1-1,-delta);         x=x1+1;        }      do     {        if (!skip)	         { *           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x); -             if ((pixel->red != target.red) || 1                 (pixel->green != target.green) || -                 (pixel->blue != target.blue))                break;-             pixel->red=ColorShift(color.red); 1             pixel->green=ColorShift(color.green); /             pixel->blue=ColorShift(color.blue);            } "           Push(y,start,x-1,delta);           if (x > (x2+1)) $             Push(y,x2+1,x-1,-delta);	         }        skip=False;        for (x++; x <= x2 ; x++)       { 1         pixel=image->pixels+(y*image->columns+x); )         if ((pixel->red == target.red) && -             (pixel->green == target.green) && )             (pixel->blue == target.blue))            break;       }        start=x;     } while (x <= x2);   }    free((char *) segment_stack);  }   H static unsigned int XColorEditImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; {  #define ColorEditColorOp  0  #define ColorEditMethodOp  1 #define ColorEditUndoOp  2 #define ColorEditHelpOp  3 #define ColorEditReturnOp  4  
   static char      *ColorEditMenu[]=      {        "Pixel Color",       "Method", 
       "Undo", 
       "Help",        "Return",        (char *) NULL      };     char     text[MaxTextLength];     Cursor     cursor;      int      id,      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *p;      static unsigned int      method = PointMethodOp,      pen_id = 0;      unsigned int     height,      status, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XColor
     color;     XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Color Edit";    windows->command.data=2;G   (void) XCommandWidget(display,windows,ColorEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,ColorEditMenu,&event);         if (id < 0)            continue;          switch (id) 	         {             case ColorEditColorOp:           {              char(               color_name[MaxTextLength],*               *ColorMenu[MaxNumberPens+1];               int                pen_number;                /*)               Initialize menu selections.              */-             for (i=0; i < MaxNumberPens; i++) 7               ColorMenu[i]=resource_info->pen_color[i]; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */O             pen_number=XMenuWidget(display,windows,ColorEditMenu[id],ColorMenu,                color_name);0             if (pen_number == (MaxNumberPens-1))               {                  static char 3                   color_name[MaxTextLength]="gray";                    /*3                   Select a pen color from a dialog.                  */E                 resource_info->pen_color[MaxNumberPens-1]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }               if (pen_number >= 0)               {                  /*                    Set pen color.                 */"                 pen_id=pen_number;K                 (void) strcpy(color_name,resource_info->pen_color[pen_id]); M                 status=XParseColor(display,windows->image.map_info->colormap, L                   color_name,&windows->image.pixel_info->pen_color[pen_id]);                  if (status == 0)P                   XNoticeWidget(display,windows,"Color is unknown to X server:",                      color_name);E                 XBestPixel(display,windows->image.map_info->colormap, 0                   (XColor *) NULL,(unsigned int)E                   Min(windows->image.visual_info->colormap_size,256), A                   &windows->image.pixel_info->pen_color[pen_id]);                } <             XDefineCursor(display,windows->image.id,cursor);             break;           } !           case ColorEditMethodOp:            {              char%               command[MaxTextLength];                static char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */             method= P               XMenuWidget(display,windows,ColorEditMenu[id],MethodMenu,command);<             XDefineCursor(display,windows->image.id,cursor);             break;           }            case ColorEditUndoOp:            { B             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);              break;           }            case ColorEditHelpOp:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           } !           case ColorEditReturnOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           } 	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Exit loop.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        { 
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image); *         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     }      x_offset=x;      y_offset=y; )     if (state & UpdateConfigurationState)        {          int            x,           y;  
         /*8           Pixel edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True);          x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height); =         x_factor=UpShift(width)/windows->image.ximage->width; C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x; ?         y_factor=UpShift(height)/windows->image.ximage->height; C         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y; ;         color=windows->image.pixel_info->pen_color[pen_id]; G         XPutPixel(windows->image.ximage,x_offset,y_offset,color.pixel);          switch (method) 	         {            case PointMethodOp:            default:           {              /*=               Update color information using point algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset); )             p->red=ColorShift(color.red); -             p->green=ColorShift(color.green); +             p->blue=ColorShift(color.blue);              break;           }            case ReplaceMethodOp:            {              RunlengthPacket                target;                /*?               Update color information using replace algorithm.              */             x=0;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             {                x+=(p->length+1); =               if (x >= (y_offset*(*image)->columns+x_offset))                  break;               p++;
             } '             target=(*image)->pixels[i]; /             if ((*image)->class == DirectClass)                { #                 p=(*image)->pixels; 5                 for (i=0; i < (*image)->packets; i++)                  { /                   if ((p->red == target.red) && 3                       (p->green == target.green) && /                       (p->blue == target.blue))                      { 3                       p->red=ColorShift(color.red); 7                       p->green=ColorShift(color.green); 5                       p->blue=ColorShift(color.blue);                      }                    p++;                 }                }              else               { '                 register unsigned short                    index;  #                 index=target.index; D                 (*image)->colormap[index].red=ColorShift(color.red);H                 (*image)->colormap[index].green=ColorShift(color.green);F                 (*image)->colormap[index].blue=ColorShift(color.blue);"                 SyncImage(*image);               } /             state&=(~UpdateConfigurationState);              break;           } !           case FloodfillMethodOp:            {              /*A               Update color information using floodfill algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;;             ColorFloodfill(*image,x_offset,y_offset,color); /             state&=(~UpdateConfigurationState);              break;           } 	         }        } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m p o s i t e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XCompositeImage requests an image name from the user, reads M %  the image and composites it with the X window image at a location the user  %  chooses with the pointer. % 0 %  The format of the XCompositeImage routine is: % @ %    status=XCompositeImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % D %    o status: Function XCompositeImage returns True if the image isM %      composited.  False is returned is there is a memory shortage or if the $ %      image fails to be composited. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */H static unsigned int XCompositeImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { # #define CompositeModeOperatorsOp  0  #define CompositeModeHelpOp  1  #define CompositeModeReturnOp  2  
   static char      *CompositeModeMenu[]=      {        "Operators",
       "Help",        "Return",        (char *) NULL      };     char     filename[MaxTextLength],     text[MaxTextLength];     Cursor     cursor;      Image      *composite_image;      int      id,      x,     y;     RectangleInfo      highlight_info,      composite_info;      static unsigned int "     operator = ReplaceCompositeOp;     unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*&     Request image file name from user.   */*   (void) strcpy(filename,image->filename);;   XFileBrowserWidget(display,windows,"Composite",filename);    if (*filename == '\0')     return(True);    /*     Read image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);7   composite_image=ReadImage(resource_info->image_info); )   XSetCursorState(display,windows,False); (   if (composite_image == (Image *) NULL)     { F       XNoticeWidget(display,windows,"Unable to read image:",filename);       return(False);     }    /*     Map Command widget.    */$   windows->command.name="Composite";   windows->command.data=1;K   (void) XCommandWidget(display,windows,CompositeModeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);&   composite_info.x=windows->image.x+x;&   composite_info.y=windows->image.y+y;   composite_info.width=0;    composite_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); 0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */J         (void) sprintf(text," %+d%+d ",composite_info.x,composite_info.y);*         XInfoWidget(display,windows,text);       } "     highlight_info=composite_info;7     highlight_info.x=composite_info.x-windows->image.x; 7     highlight_info.y=composite_info.y-windows->image.y; P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &highlight_info);      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &highlight_info); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */D         id=XCommandWidget(display,windows,CompositeModeMenu,&event);         if (id < 0)            continue;          switch (id) 	         { (           case CompositeModeOperatorsOp:           {              char%               command[MaxTextLength];                static char                *OperatorMenu[]=               {                  "over",                  "in",                  "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",                  "difference",                  "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */G             operator=XMenuWidget(display,windows,CompositeModeMenu[id], &               OperatorMenu,command)+1;             break;           } #           case CompositeModeHelpOp:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           } %           case CompositeModeReturnOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Change cursor.
         */6         composite_info.width=composite_image->columns;4         composite_info.height=composite_image->rows;8         XDefineCursor(display,windows->image.id,cursor);:         composite_info.x=windows->image.x+event.xbutton.x;:         composite_info.y=windows->image.y+event.xbutton.y;         break;       }        case ButtonRelease:        { !         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); H         if ((composite_info.width != 0) && (composite_info.height != 0))           {              /*D               User has selected the location of the composite image.             */>             composite_info.x=windows->image.x+event.xbutton.x;>             composite_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;            int            length;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */*             DestroyImage(composite_image);             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); ,         composite_info.x=windows->image.x+x;,         composite_info.y=windows->image.y+y;         break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*9     Image compositing is relative to image configuration.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    composite_info.x+=x;<   composite_info.x=DownShift(composite_info.x*scale_factor);D   composite_info.width=DownShift(composite_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    composite_info.y+=y;<   composite_info.y=DownShift(composite_info.y*scale_factor);F   composite_info.height=DownShift(composite_info.height*scale_factor);;   if ((composite_info.width != composite_image->columns) || 7       (composite_info.height != composite_image->rows))      {        Image          *scaled_image;         /*         Scale composite image.       */       scaled_image= O         ScaleImage(composite_image,composite_info.width,composite_info.height); $       DestroyImage(composite_image);)       if (scaled_image == (Image *) NULL) 	         { 1           XSetCursorState(display,windows,False);            return(False);	         } #       composite_image=scaled_image;      }    /*(     Composite image with X Image window.   */A   CompositeImage(image,operator,composite_image,composite_info.x,      composite_info.y);    DestroyImage(composite_image);)   XSetCursorState(display,windows,False);    /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e C o l o r m a p                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XConfigureImageColormap creates a new X colormap.  % 8 %  The format of the XConfigureImageColormap routine is: % A %    XConfigureImageColormap(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H static void XConfigureImageColormap(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { < #define ConfigureColormapText  "  Configuring colormap...  "  
   Colormap
     colormap;      /*     Make standard colormap.    */5   XInfoWidget(display,windows,ConfigureColormapText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);I   XMakeStandardColormap(display,windows->image.visual_info,resource_info, =     image,windows->image.map_info,windows->image.pixel_info); -   colormap=windows->image.map_info->colormap; 9   XSetWindowColormap(display,windows->image.id,colormap); ;   XSetWindowColormap(display,windows->command.id,colormap); :   XSetWindowColormap(display,windows->widget.id,colormap);   if (windows->magnify.mapped)=     XSetWindowColormap(display,windows->magnify.id,colormap);    if (windows->pan.mapped)9     XSetWindowColormap(display,windows->pan.id,colormap); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False); A   XClientMessage(display,windows->image.id,windows->im_protocols, -     windows->im_update_colormap,CurrentTime);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XConfigureImage creates a new X image.  It also notifies theL %  window manager of the new image size and configures the transient widows. % 0 %  The format of the XConfigureImage routine is: % @ %    status=XConfigureImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o status: Function XConfigureImage returns True if the window is J %      resized.  False is returned is there is a memory shortage or if the %      window fails to resize. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H static unsigned int XConfigureImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { ; #define ConfigureImageText  "  Configuring image...       "      unsigned int     height, 	     mask,      status, 
     width,
     x_factor, 
     y_factor;      XSizeHints     *size_hints;     XWindowChanges     window_changes;      /*)     Return if window dimensions are zero.    */,   width=windows->image.window_changes.width;.   height=windows->image.window_changes.height;   if (resource_info->debug) <     (void) fprintf(stderr,"Configure Image: %dx%d=>%ux%u\n",O       windows->image.ximage->width,windows->image.ximage->height,width,height);    if ((width*height) == 0)     return(True);    /*0     Resize image to fit Image window dimensions.   */2   XInfoWidget(display,windows,ConfigureImageText);(   XSetCursorState(display,windows,True);   XFlush(display);7   x_factor=UpShift(width)/windows->image.ximage->width; 9   y_factor=UpShift(height)/windows->image.ximage->height; N   status=XMakeImage(display,resource_info,&windows->image,image,width,height);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);   if (status == False)A     XNoticeWidget(display,windows,"Unable to configure X image:",        windows->image.name);    /*3     Notify window manager of the new configuration.    */;   if (width > XDisplayWidth(display,windows->image.screen)) 7     width=XDisplayWidth(display,windows->image.screen);    window_changes.width=width; =   if (height > XDisplayHeight(display,windows->image.screen)) 9     height=XDisplayHeight(display,windows->image.screen);    window_changes.height=height;    mask=CWWidth | CWHeight;   if (resource_info->backdrop)     {        mask|=CWX | CWY;       window_changes.x= I         (XDisplayWidth(display,windows->image.screen) >> 1)-(width >> 1);        window_changes.y= K         (XDisplayHeight(display,windows->image.screen) >> 1)-(height >> 1);      } L   XReconfigureWMWindow(display,windows->image.id,windows->image.screen,mask,     &window_changes);    if (image->matte) ,     XClearWindow(display,windows->image.id);;   if ((x_factor == UpShift(1)) && (y_factor == UpShift(1))) <     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*(     Update Magnify window configuration.   */<   windows->magnify.x=DownShift(x_factor*windows->magnify.x);<   windows->magnify.y=DownShift(y_factor*windows->magnify.y);   if (windows->magnify.mapped)'     XMakeMagnifyImage(display,windows);    /*$     Update pan window configuration.   */8   windows->image.x=DownShift(x_factor*windows->image.x);8   windows->image.y=DownShift(y_factor*windows->image.y);:   windows->pan.crop_geometry=windows->image.crop_geometry;-   XBestIconSize(display,&windows->pan,image); -   while ((windows->pan.width < MinPanSize) && ,          (windows->pan.height < MinPanSize))   {      windows->pan.width<<=1;      windows->pan.height<<=1;   } 4   windows->pan.geometry=resource_info->pan_geometry;-   if (windows->pan.geometry != (char *) NULL) A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,        &windows->pan.height);*   window_changes.width=windows->pan.width;,   window_changes.height=windows->pan.height;   size_hints=XAllocSizeHints(); (   if (size_hints != (XSizeHints *) NULL)     {        /*         Set new size hints.        */4       size_hints->flags=PSize | PMinSize | PMaxSize;-       size_hints->width=window_changes.width; /       size_hints->height=window_changes.height; .       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;:       XSetNormalHints(display,windows->pan.id,size_hints);!       XFree((void *) size_hints);      } L   XReconfigureWMWindow(display,windows->pan.id,windows->pan.screen,CWWidth |     CWHeight,&window_changes);   if (windows->pan.mapped)=     if ((x_factor == UpShift(1)) && (y_factor == UpShift(1))) 9       XMakePanImage(display,resource_info,windows,image);      elseC       XWithdrawWindow(display,windows->pan.id,windows->pan.screen);    /*%     Update icon window configuration.    */;   windows->icon.crop_geometry=windows->image.crop_geometry; .   XBestIconSize(display,&windows->icon,image);+   window_changes.width=windows->icon.width; -   window_changes.height=windows->icon.height; E   XReconfigureWMWindow(display,windows->icon.id,windows->icon.screen, (     CWWidth | CWHeight,&window_changes);A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o p y I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCopyImage copies the image or a region of the image.  The imageB %  can subsequently be composited onto the image with XPasteImage. % + %  The format of the XCopyImage routine is:  % ; %    status=XCopyImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % ? %    o status: Function XCopyImage returns True if the image is J %      copyped.  False is returned is there is a memory shortage or if the! %      image fails to be copyped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */C static unsigned int XCopyImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { - #define CopyImageText  "  Copying image...  "  #define CopyModeHelpOp  0  #define CopyModeReturnOp  1  #define RectifyModeCopyOp  0 #define RectifyModeHelpOp  1 #define RectifyModeReturnOp  2  
   static char      *CopyModeMenu[]=     { 
       "Help",        "Return",        (char *) NULL      },     *RectifyModeMenu[]=      { 
       "Copy", 
       "Help",        "Return",        (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int      id,      x,     y;     KeySym     key_symbol;      RectangleInfo      copy_info,     highlight_info;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget.    */   windows->command.name="Copy";    windows->command.data=0;F   (void) XCommandWidget(display,windows,CopyModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);!   copy_info.x=windows->image.x+x; !   copy_info.y=windows->image.y+y;    copy_info.width=0;   copy_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */@         (void) sprintf(text," %+d%+d ",copy_info.x,copy_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,CopyModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         {            case CopyModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,;               "Help Viewer - Image Copying",ImageCopyHelp);              break;           }             case CopyModeReturnOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {              /*B               Note first corner of copyping rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);9             copy_info.x=windows->image.x+event.xbutton.x; 9             copy_info.y=windows->image.y+event.xbutton.y;              state|=ExitState;              break;           }          break;       }        case Expose:         break;       case KeyPress:       { 
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,;               "Help Viewer - Image Copying",ImageCopyHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         copy_info.x=windows->image.x+x; '         copy_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {        /*+         User want to exit without copyping.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=copy_info.x;     y=copy_info.y;     copy_info.width=0;     copy_info.height=0;      state=DefaultState; +     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {        highlight_info=copy_info; 4       highlight_info.x=copy_info.x-windows->image.x;4       highlight_info.y=copy_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*5             Display info and draw copyping rectangle.            */N           (void) sprintf(text," %ux%u%+d%+d",copy_info.width,copy_info.height,%             copy_info.x,copy_info.y); ,           XInfoWidget(display,windows,text);5           XHighlightRegion(display,windows->image.id, >             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))3         XHighlightRegion(display,windows->image.id, <           windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */A           id=XCommandWidget(display,windows,CopyModeMenu,&event);            if (id < 0)              continue;            switch (id)            {               case CopyModeHelpOp:
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,=                 "Help Viewer - Image Copying",ImageCopyHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             } "             case CopyModeReturnOp:
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;                state|=ExitState;                break;
             }              default:               break;           }            continue; 	         }        switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 7           copy_info.x=windows->image.x+event.xbutton.x; 7           copy_info.y=windows->image.y+event.xbutton.y;            break;	         }          case ButtonRelease: 	         {            /*5             User has committed to copyping rectangle.            */7           copy_info.x=windows->image.x+event.xbutton.x; 7           copy_info.y=windows->image.y+event.xbutton.y; 1           XSetCursorState(display,windows,False); *           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);            state|=ExitState;            break;	         }          case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.            */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 7           copy_info.x=windows->image.x+event.xmotion.x; 7           copy_info.y=windows->image.y+event.xmotion.y; 	         }          default:           break;       } 3       if ((copy_info.x != x) && (copy_info.y != y)) 	         {            /*&             Check boundary conditions.           */           if (copy_info.x < 0)             copy_info.x=0;           else;             if (copy_info.x > windows->image.ximage->width) 7               copy_info.x=windows->image.ximage->width;            if (copy_info.x < x);             copy_info.width=(unsigned int) (x-copy_info.x);            else
             { =               copy_info.width=(unsigned int) (copy_info.x-x);                copy_info.x=x;
             }            if (copy_info.y < 0)             copy_info.y=0;           else<             if (copy_info.y > windows->image.ximage->height)8               copy_info.y=windows->image.ximage->height;           if (copy_info.y < y)<             copy_info.height=(unsigned int) (y-copy_info.y);           else
             { >               copy_info.height=(unsigned int) (copy_info.y-y);               copy_info.y=y;
             } 	         } #     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*F       Wait for user to grab a corner of the rectangle or press return.     */     state&=(~ExitState);     do     {        if (windows->info.mapped) 	         {            /*%             Display pointer position.            */B           (void) sprintf(text," %+d%+d ",copy_info.x,copy_info.y);,           XInfoWidget(display,windows,text);	         }        highlight_info=copy_info; 4       highlight_info.x=copy_info.x-windows->image.x;4       highlight_info.y=copy_info.y-windows->image.y;F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;            state|=ExitState;            break;	         } 1       XHighlightRegion(display,windows->image.id, :         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 1       XHighlightRegion(display,windows->image.id, :         windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);           if (id < 0)              continue;            switch (id)            { #             case RectifyModeCopyOp: 
             {                state|=ExitState;                break;
             } #             case RectifyModeHelpOp: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,=                 "Help Viewer - Image Copying",ImageCopyHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             } %             case RectifyModeReturnOp: 
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;                state|=ExitState;                break;
             }              default:               break;           }            continue; 	         }        switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; M           if ((x < (copy_info.x+RoiDelta)) && (x > (copy_info.x-RoiDelta)) && K               (y < (copy_info.y+RoiDelta)) && (y > (copy_info.y-RoiDelta))) 
             { 6               copy_info.x=copy_info.x+copy_info.width;7               copy_info.y=copy_info.y+copy_info.height; .               state|=UpdateConfigurationState;               break;
             } M           if ((x < (copy_info.x+RoiDelta)) && (x > (copy_info.x-RoiDelta)) && >               (y < (copy_info.y+copy_info.height+RoiDelta)) &&<               (y > (copy_info.y+copy_info.height-RoiDelta)))
             { 6               copy_info.x=copy_info.x+copy_info.width;.               state|=UpdateConfigurationState;               break;
             } =           if ((x < (copy_info.x+copy_info.width+RoiDelta)) && =               (x > (copy_info.x+copy_info.width-RoiDelta)) && K               (y < (copy_info.y+RoiDelta)) && (y > (copy_info.y-RoiDelta))) 
             { 7               copy_info.y=copy_info.y+copy_info.height; .               state|=UpdateConfigurationState;               break;
             } =           if ((x < (copy_info.x+copy_info.width+RoiDelta)) && =               (x > (copy_info.x+copy_info.width-RoiDelta)) && >               (y < (copy_info.y+copy_info.height+RoiDelta)) &&<               (y > (copy_info.y+copy_info.height-RoiDelta)))
             { .               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease:            break;         case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                { 1                 event.xexpose.x=highlight_info.x; 1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width; ;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);                } 7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         {            /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return: 
             {                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,=                 "Help Viewer - Image Copying",ImageCopyHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);                break;
             }            }            break;	         }          case KeyRelease:           break;         case MotionNotify:	         {            /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));            x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped) 
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState)); !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*0     Copy image before applying image transforms.   */   windows->info.mapped=False; -   XInfoWidget(display,windows,CopyImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    copy_info.x+=x; 2   copy_info.x=DownShift(copy_info.x*scale_factor);:   copy_info.width=DownShift(copy_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    copy_info.y+=y; 2   copy_info.y=DownShift(copy_info.y*scale_factor);<   copy_info.height=DownShift(copy_info.height*scale_factor);#   if (copy_image != (Image *) NULL)      DestroyImage(copy_image); )   copy_image=CropImage(image,&copy_info); )   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); #   if (copy_image == (Image *) NULL)      return(False);   /*     Update image.    */>   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C r o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Function XCropImage crops the Image window. % + %  The format of the XCropImage routine is:  % ; %    status=XCropImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % ? %    o status: Function XCropImage returns True if the image is J %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */C static unsigned int XCropImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {  #define CropModeHelpOp  0  #define CropModeReturnOp  1  #define RectifyModeCropOp  0 #define RectifyModeHelpOp  1 #define RectifyModeReturnOp  2  
   static char      *CropModeMenu[]=     { 
       "Help",        "Return",        (char *) NULL      },     *RectifyModeMenu[]=      { 
       "Crop", 
       "Help",        "Return",        (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int      id,      x,     y;     KeySym     key_symbol;      RectangleInfo      crop_info,     highlight_info;      unsigned long 
     state;     XEvent
     event;     /*     Map Command widget.    */   windows->command.name="Crop";    windows->command.data=0;F   (void) XCommandWidget(display,windows,CropModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);!   crop_info.x=windows->image.x+x; !   crop_info.y=windows->image.y+y;    crop_info.width=0;   crop_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */@         (void) sprintf(text," %+d%+d ",crop_info.x,crop_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,CropModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         {            case CropModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Cropping",ImageCropHelp);             break;           }             case CropModeReturnOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {              /*B               Note first corner of cropping rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);9             crop_info.x=windows->image.x+event.xbutton.x; 9             crop_info.y=windows->image.y+event.xbutton.y;              state|=ExitState;              break;           }          break;       }        case Expose:         break;       case KeyPress:       { 
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.%             */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Cropping",ImageCropHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }P       case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            {D>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         crop_info.x=windows->image.x+x; '         crop_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {        /*+         User want to exit without cropping.d       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      }oB   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {y     /*I       Size rectangle as pointer moves until the mouse button is released.p     */     x=crop_info.x;     y=crop_info.y;     crop_info.width=0;     crop_info.height=0;s     state=DefaultState; +     XSelectInput(display,windows->image.id,a@       windows->image.attributes.event_mask | PointerMotionMask);     do     {t       highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {s           /*5             Display info and draw cropping rectangle.            */N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);5           XHighlightRegion(display,windows->image.id,a>             windows->image.highlight_context,&highlight_info);	         }i
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);i       /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);rD       if ((highlight_info.width > 3) && (highlight_info.height > 3))3         XHighlightRegion(display,windows->image.id,n<           windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.%           */A           id=XCommandWidget(display,windows,CropModeMenu,&event);i           if (id < 0)d             continue;a           switch (id)t           {t              case CropModeHelpOp:
             {lL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Cropping",ImageCropHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }o"             case CropModeReturnOp:
             {                /*!                 Prematurely exit.i               */!               state|=EscapeState;o               state|=ExitState;t               break;
             }o             default:               break;           }r           continue;m	         }p       switch (event.type)        {-         case ButtonPress:T	         {p6           if (event.xbutton.window == windows->pan.id)
             {[0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 7           crop_info.x=windows->image.x+event.xbutton.x;r7           crop_info.y=windows->image.y+event.xbutton.y;p           break;	         }          case ButtonRelease:r	         {o           /*5             User has committed to cropping rectangle.            */7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y;E1           XSetCursorState(display,windows,False);h*           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);            state|=ExitState;t           break;	         }l         case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.b           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));s7           crop_info.x=windows->image.x+event.xmotion.x;i7           crop_info.y=windows->image.y+event.xmotion.y;e	         }g         default:           break;       } 3       if ((crop_info.x != x) && (crop_info.y != y))l	         {            /*&             Check boundary conditions.           */           if (crop_info.x < 0)             crop_info.x=0;           else;             if (crop_info.x > windows->image.ximage->width) 7               crop_info.x=windows->image.ximage->width;a           if (crop_info.x < x);             crop_info.width=(unsigned int) (x-crop_info.x);            else
             {a=               crop_info.width=(unsigned int) (crop_info.x-x);n               crop_info.x=x;
             }r           if (crop_info.y < 0)             crop_info.y=0;           else<             if (crop_info.y > windows->image.ximage->height)8               crop_info.y=windows->image.ximage->height;           if (crop_info.y < y)<             crop_info.height=(unsigned int) (y-crop_info.y);           else
             { >               crop_info.height=(unsigned int) (crop_info.y-y);               crop_info.y=y;
             } 	         }m#     } while (!(state & ExitState));-+     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);-     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state&=(~ExitState);     do     {        if (windows->info.mapped)n	         {Y           /*%             Display pointer position.m           */B           (void) sprintf(text," %+d%+d ",crop_info.x,crop_info.y);,           XInfoWidget(display,windows,text);	         }l       highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;I           state|=ExitState;o           break;	         }n1       XHighlightRegion(display,windows->image.id,k:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows);y1       XHighlightRegion(display,windows->image.id,i:         windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id)h	         {            /*5             Select a command from the Command widget.            */D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);           if (id < 0)c             continue;            switch (id)t           {l#             case RectifyModeCropOp:y
             {'               state|=ExitState;                break;
             }m#             case RectifyModeHelpOp:2
             {rL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Cropping",ImageCropHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }a%             case RectifyModeReturnOp:P
             {e               /*!                 Prematurely exit.e               */!               state|=EscapeState;t               state|=ExitState;s               break;
             }l             default:               break;           }            continue;y	         }f       switch (event.type)        {t         case ButtonPress:r	         {g6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }a8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta)))m
             { 6               crop_info.x=crop_info.x+crop_info.width;7               crop_info.y=crop_info.y+crop_info.height;r.               state|=UpdateConfigurationState;               break;
             }tM           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) &&o>               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { 6               crop_info.x=crop_info.x+crop_info.width;.               state|=UpdateConfigurationState;               break;
             }h=           if ((x < (crop_info.x+crop_info.width+RoiDelta)) &&i=               (x > (crop_info.x+crop_info.width-RoiDelta)) &&iK               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta)))a
             { 7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) &&t>               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             {t.               state|=UpdateConfigurationState;               break;
             }p	         }t         case ButtonRelease:q           break;         case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)k               {m1                 event.xexpose.x=highlight_info.x;"1                 event.xexpose.y=highlight_info.y;r9                 event.xexpose.width=highlight_info.width;%;                 event.xexpose.height=highlight_info.height;%?                 XRefreshWindow(display,&windows->image,&event);                } 7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         {            /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:%             case XK_F20:!               state|=EscapeState;%             case XK_Return: 
             {t               state|=ExitState;                break;
             }              case XK_F1:e             case XK_Help: 
             {fL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Cropping",ImageCropHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {a               XBell(display,0);n               break;
             },           }            break;	         }=         case KeyRelease:           break;         case MotionNotify:	         {a           /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));            x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)a
             {i@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height)))tO                 XWithdrawWindow(display,windows->info.id,windows->info.screen);m
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }t         default:           break;       },+       if (state & UpdateConfigurationState)l	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState));g!   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);eA   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True); :   if ((crop_info.width != windows->image.ximage->width) ||:       (crop_info.height != windows->image.ximage->height))     {t       /*B         Reconfigure Image window as defined by cropping rectangle.       */9       XSetCropGeometry(display,windows,&crop_info,image); :       windows->image.window_changes.width=crop_info.width;<       windows->image.window_changes.height=crop_info.height;B       (void) XConfigureImage(display,resource_info,windows,image);     }B   return(True);e }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %rO %                                                                             %nO %                                                                             % O %   X C o p y I m a g e                                                       %tO %                                                                             %oO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%h % 3 %  Function XCutImage cuts a region from the image.  %c* %  The format of the XCutImage routine is: % : %    status=XCutImage(display,resource_info,windows,image) % + %  A description of each parameter follows:p % > %    o status: Function XCutImage returns True if the image isI %      cutped.  False is returned is there is a memory shortage or if theu  %      image fails to be cutped. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %oK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.Q %P< %    o windows: Specifies a pointer to a XWindows structure. %mE %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %a %  */B static unsigned int XCutImage(display,resource_info,windows,image) Displayt   *display;o  
 XResourceInfo    *resource_info;    XWindows   *windows;a   Imagei	   *image;  {e, #define CutImageText  "  Cutting image...  " #define CutModeHelpOp  0 #define CutModeReturnOp  1 #define RectifyModeCutOp  0  #define RectifyModeHelpOp  1 #define RectifyModeReturnOp  2  
   static char      *CutModeMenu[]=i     {r
       "Help",o       "Return",-       (char *) NULLl     },     *RectifyModeMenu[]=      {        "Cut",
       "Help",p       "Return",t       (char *) NULL      };     char     command[MaxTextLength],t     text[MaxTextLength];     Cursor     cursor;      intl     id,i     x,     y;     KeySym     key_symbol;      RectangleInfoi
     cut_info,l     highlight_info;-     register RunlengthPacket     *p;t     unsigned int     height,r
     width;     unsigned longf     scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget.e   */   windows->command.name="Cut";   windows->command.data=0;E   (void) XCommandWidget(display,windows,CutModeMenu,(XEvent *) NULL);t*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);b   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);    cut_info.x=windows->image.x+x;    cut_info.y=windows->image.y+y;   cut_info.width=0;    cut_info.height=0;-   cursor=XCreateFontCursor(display,XC_fleur);dO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |a     PointerMotionMask);-   state=DefaultState;q   do   {i     if (windows->info.mapped)        {m
         /*#           Display pointer position.d
         */>         (void) sprintf(text," %+d%+d ",cut_info.x,cut_info.y);*         XInfoWidget(display,windows,text);       }n     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);r1     if (event.xany.window == windows->command.id)-       {m
         /*3           Select a command from the Command widget. 
         */>         id=XCommandWidget(display,windows,CutModeMenu,&event);         if (id < 0)c           continue;          switch (id)s	         {w           case CutModeHelpOp:r           { @             XTextViewWidget(display,resource_info,windows,False,:               "Help Viewer - Image Cutping",ImageCutHelp);             break;           }            case CutModeReturnOp:t           {              /*               Prematurely exit.              */             state|=EscapeState;(             state|=ExitState;              break;           }o           default:             break;	         }n         continue;p       }W     switch (event.type))     {o       case ButtonPress:        {p4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {o             /*=               Note first corner of cut rectangle-- exit loop.i             */<             XDefineCursor(display,windows->image.id,cursor);8             cut_info.x=windows->image.x+event.xbutton.x;8             cut_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;h             break;           }n         break;       }        case Expose:         break;       case KeyPress:       {g
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),f/           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {p           case XK_Escape:.           case XK_F20:           {              /*               Prematurely exit.u             */             state|=EscapeState;o             state|=ExitState;L             break;           }\           case XK_F1:t           case XK_Help:s           {o@             XTextViewWidget(display,resource_info,windows,False,:               "Help Viewer - Image Cutping",ImageCutHelp);             break;           }%           default:           {%             XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))%M               XWithdrawWindow(display,windows->info.id,windows->info.screen);o           }g         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); &         cut_info.x=windows->image.x+x;&         cut_info.y=windows->image.y+y;         break;       }u       default:         break;     }X!   } while (!(state & ExitState));oO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);e   if (state & EscapeState)     {e       /*&         User want to exit without cut.       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen);s"       XFreeCursor(display,cursor);       return(True);      }oB   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {e     /*I       Size rectangle as pointer moves until the mouse button is released.d     */     x=cut_info.x;      y=cut_info.y;e     cut_info.width=0;t     cut_info.height=0;     state=DefaultState;M+     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {a       highlight_info=cut_info;3       highlight_info.x=cut_info.x-windows->image.x; 3       highlight_info.y=cut_info.y-windows->image.y;TD       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {C           /*0             Display info and draw cut rectangle.           */L           (void) sprintf(text," %ux%u%+d%+d",cut_info.width,cut_info.height,#             cut_info.x,cut_info.y);i,           XInfoWidget(display,windows,text);5           XHighlightRegion(display,windows->image.id, >             windows->image.highlight_context,&highlight_info);	         }t
       else!         if (windows->info.mapped)cI           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);dD       if ((highlight_info.width > 3) && (highlight_info.height > 3))3         XHighlightRegion(display,windows->image.id,y<           windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id)n	         {1           /*5             Select a command from the Command widget.;           */@           id=XCommandWidget(display,windows,CutModeMenu,&event);           if (id < 0)s             continue;a           switch (id)f           {f             case CutModeHelpOp: 
             {aL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Cutping",ImageCutHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             } !             case CutModeReturnOp:e
             {o               /*!                 Prematurely exit.n               */!               state|=EscapeState;                state|=ExitState;t               break;
             }              default:               break;           }            continue; 	         }n       switch (event.type)        {F         case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             {t0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }a6           cut_info.x=windows->image.x+event.xbutton.x;6           cut_info.y=windows->image.y+event.xbutton.y;           break;	         }          case ButtonRelease:h	         {n           /*0             User has committed to cut rectangle.           */6           cut_info.x=windows->image.x+event.xbutton.x;6           cut_info.y=windows->image.y+event.xbutton.y;1           XSetCursorState(display,windows,False); *           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);a           state|=ExitState;e           break;	         }s         case Expose:           break;         case MotionNotify:	         {=           /*1             Discard pending button motion events.            */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));t6           cut_info.x=windows->image.x+event.xmotion.x;6           cut_info.y=windows->image.y+event.xmotion.y;	         }          default:           break;       }y1       if ((cut_info.x != x) && (cut_info.y != y))n	         {N           /*&             Check boundary conditions.           */           if (cut_info.x < 0)              cut_info.x=0;            else:             if (cut_info.x > windows->image.ximage->width)6               cut_info.x=windows->image.ximage->width;           if (cut_info.x < x) 9             cut_info.width=(unsigned int) (x-cut_info.x);d           else
             { ;               cut_info.width=(unsigned int) (cut_info.x-x);                cut_info.x=x;s
             }            if (cut_info.y < 0)b             cut_info.y=0;            else;             if (cut_info.y > windows->image.ximage->height) 7               cut_info.y=windows->image.ximage->height;u           if (cut_info.y < y) :             cut_info.height=(unsigned int) (y-cut_info.y);           else
             {*<               cut_info.height=(unsigned int) (cut_info.y-y);               cut_info.y=y; 
             } 	         }r#     } while (!(state & ExitState));M+     XSelectInput(display,windows->image.id,a,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*F       Wait for user to grab a corner of the rectangle or press return.     */     state&=(~ExitState);     do     {        if (windows->info.mapped)i	         {l           /*%             Display pointer position.l           */@           (void) sprintf(text," %+d%+d ",cut_info.x,cut_info.y);,           XInfoWidget(display,windows,text);	         }        highlight_info=cut_info;3       highlight_info.x=cut_info.x-windows->image.x; 3       highlight_info.y=cut_info.y-windows->image.y; F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {e           state|=EscapeState;            state|=ExitState;y           break;	         }o1       XHighlightRegion(display,windows->image.id,e:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows);i1       XHighlightRegion(display,windows->image.id,_:         windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id),	         {n           /*5             Select a command from the Command widget.5           */D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);           if (id < 0)a             continue;            switch (id)t           { "             case RectifyModeCutOp:
             {T               state|=ExitState;                break;
             }t#             case RectifyModeHelpOp:[
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Cutping",ImageCutHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }.%             case RectifyModeReturnOp:u
             {;               /*!                 Prematurely exit.a               */!               state|=EscapeState;                state|=ExitState;                break;
             }              default:               break;           }            continue; 	         }        switch (event.type)p       {,         case ButtonPress:D	         {(6           if (event.xbutton.window == windows->pan.id)
             {n0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x;,-           y=windows->image.y+event.xbutton.y;aK           if ((x < (cut_info.x+RoiDelta)) && (x > (cut_info.x-RoiDelta)) && I               (y < (cut_info.y+RoiDelta)) && (y > (cut_info.y-RoiDelta)))r
             { 3               cut_info.x=cut_info.x+cut_info.width; 4               cut_info.y=cut_info.y+cut_info.height;.               state|=UpdateConfigurationState;               break;
             } K           if ((x < (cut_info.x+RoiDelta)) && (x > (cut_info.x-RoiDelta)) && <               (y < (cut_info.y+cut_info.height+RoiDelta)) &&:               (y > (cut_info.y+cut_info.height-RoiDelta)))
             {(3               cut_info.x=cut_info.x+cut_info.width; .               state|=UpdateConfigurationState;               break;
             } ;           if ((x < (cut_info.x+cut_info.width+RoiDelta)) && ;               (x > (cut_info.x+cut_info.width-RoiDelta)) &&tI               (y < (cut_info.y+RoiDelta)) && (y > (cut_info.y-RoiDelta))) 
             { 4               cut_info.y=cut_info.y+cut_info.height;.               state|=UpdateConfigurationState;               break;
             }i;           if ((x < (cut_info.x+cut_info.width+RoiDelta)) &&m;               (x > (cut_info.x+cut_info.width-RoiDelta)) && <               (y < (cut_info.y+cut_info.height+RoiDelta)) &&:               (y > (cut_info.y+cut_info.height-RoiDelta)))
             {m.               state|=UpdateConfigurationState;               break;
             }E	         }          case ButtonRelease:            break;         case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                {n1                 event.xexpose.x=highlight_info.x; 1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width; ;                 event.xexpose.height=highlight_info.height;:?                 XRefreshWindow(display,&windows->image,&event);e               }/7           if (event.xexpose.window == windows->info.id)k)             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }o         case KeyPress:	         {            /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command,<A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);W           switch (key_symbol)w           {s             case XK_Escape:              case XK_F20:!               state|=EscapeState;t             case XK_Return:i
             {i               state|=ExitState;                break;
             })             case XK_F1:              case XK_Help: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Cutping",ImageCutHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }s             default:
             {]               XBell(display,0);c               break;
             }e           }d           break;	         }          case KeyRelease:           break;         case MotionNotify:	         {n           /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));n           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)s
             {)@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))))O                 XWithdrawWindow(display,windows->info.id,windows->info.screen);o
             }t           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height)))e3               XMapWindow(display,windows->info.id);            break;	         })         default:           break;       }i+       if (state & UpdateConfigurationState) 	         {e(           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         }s#     } while (!(state & ExitState));o!   } while (!(state & ExitState));;@   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);fA   XWithdrawWindow(display,windows->info.id,windows->info.screen);i   if (state & EscapeState)     return(True);*   /*2     Cut region is relative to image configuration.   */   windows->info.mapped=False;-,   XInfoWidget(display,windows,CutImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;x   height=image->rows;t4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);-;   scale_factor=UpShift(width)/windows->image.ximage->width;    cut_info.x+=x;0   cut_info.x=DownShift(cut_info.x*scale_factor);8   cut_info.width=DownShift(cut_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;l   cut_info.y+=y;0   cut_info.y=DownShift(cut_info.y*scale_factor);:   cut_info.height=DownShift(cut_info.height*scale_factor);#   if (copy_image != (Image *) NULL)g     DestroyImage(copy_image);o(   copy_image=CropImage(image,&cut_info);)   XSetCursorState(display,windows,False);    /*     Cut image.   */   image->class=DirectClass;    if (!image->matte)     {        /*         Initialize matte data.       */       p=image->pixels;(       for (x=0; x < image->packets; x++)       {o         p->index=Opaque;         p++;       }d       image->matte=True;     }    if (UncompressImage(image)) '     for (y=0; y < cut_info.height; y++)      { ?       p=image->pixels+(cut_info.y+y)*image->columns+cut_info.x; (       for (x=0; x < cut_info.width; x++)       {a         p->index=Transparent;t         p++;       }t     }    /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }o n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %yO %                                                                             %vO %                                                                             %tO %   X D e s p e c k l e I m a g e                                             % O %                                                                             %(O %                                                                             %tO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_ %IA %  Function XDespeckleImage reduces the speckles within an image.  % 0 %  The format of the XDespeckleImage routine is: % @ %    status=XDespeckleImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % G %    o status: Function XDespeckleImage return True if the edges within F %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %iK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure._ %o< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.a %i %w */H static unsigned int XDespeckleImage(display,resource_info,windows,image) Display    *display;:  
 XResourceInfo    *resource_info;e   XWindows   *windows;    Imagep
   **image; {e6 #define DespeckleImageText  "  Despeckling image...  "     Imagev     *despeckled_image;     /*     Despeckle image.   */2   XInfoWidget(display,windows,DespeckleImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);*   despeckled_image=DespeckleImage(*image);)   XSetCursorState(display,windows,False);tA   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   if (despeckled_image == (Image *) NULL)e     return(False);   DestroyImage(*image);    *image=despeckled_image;   if (windows->image.orphan)     return(True);    /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);_   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             %oO %                                                                             % O %   X D i s p l a y B a c k g r o u n d I m a g e                             %aO %                                                                             % O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % L %  Function XDisplayBackgroundImage displays an image in the background of a
 %  window. % 8 %  The format of the XDisplayBackgroundImage routine is: % ; %      XDisplayBackgroundImage(display,resource_info,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %tK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %;E %    o image: Specifies a pointer to a Image structure; returned froms %      ReadImage.a %X %2 */@ static void XDisplayBackgroundImage(display,resource_info,image) Display    *display;   
 XResourceInfo-   *resource_info;o   Imagen	   *image;- {x   char     visual_type[MaxTextLength];e     unsigned int     height,d     status,i
     width;     Window     root_window;     XGCValues      context_values;      XPixelInfo     pixel_info;      XResourceInfo      resources;     XStandardColormaph     *map_info;  
   XVisualInfo      *visual_info;      XWindowAttributesr     window_attributes;  
   XWindowInfo      window_info;     /*     Determine target window.   */   window_info.id=(Window) NULL;n%   window_info.ximage=(XImage *) NULL;n*   window_info.matte_image=(XImage *) NULL;#   window_info.pixmap=(Pixmap) NULL; )   window_info.matte_pixmap=(Pixmap) NULL; "   window_info.shared_memory=False;;   root_window=XRootWindow(display,XDefaultScreen(display)); :   if (Latin1Compare(resource_info->window_id,"root") == 0)     window_info.id=root_window;    else     { -       if (isdigit(*resource_info->window_id))a7         window_info.id=XWindowByID(display,root_window, O           (Window) strtol((char *) resource_info->window_id,(char **) NULL,0)); *       if (window_info.id == (Window) NULL)         window_info.id= F           XWindowByName(display,root_window,resource_info->window_id);*       if (window_info.id == (Window) NULL)M         Error("No window with specified id exists",resource_info->window_id);      }    /*     Determine window visual id.    */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display));aK   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display));t'   (void) strcpy(visual_type,"default");eI   status=XGetWindowAttributes(display,window_info.id,&window_attributes);e   if (status != False)'     (void) sprintf(visual_type,"0x%lx",n5       XVisualIDFromVisual(window_attributes.visual));a   /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)fK     Error("Unable to create standard colormap","Memory allocation failed");e%   map_info->colormap=(Colormap) NULL; +   pixel_info.pixels=(unsigned long *) NULL;e   /*     Initialize visual info.-   */   resources=(*resource_info); #   resources.map_type=(char *) NULL;*$   resources.visual_type=visual_type;;   visual_info=XBestVisualInfo(display,map_info,&resources);e*   if (visual_info == (XVisualInfo *) NULL)=     Error("Unable to get visual",resource_info->visual_type);:   /*     Free previous root colors.   */$   if (window_info.id == root_window).     XDestroyWindowColors(display,root_window);   /*     Initialize colormap.   */$   resources.colormap=SharedColormap;F   XMakeStandardColormap(display,visual_info,&resources,image,map_info,     &pixel_info);    /*     Graphic context superclass.e   */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);   /*'     Initialize Image window attributes.L   */O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,a      resource_info,&window_info);   /*     Create the X image.    */#   window_info.width=image->columns; 3   if (window_info.width >= window_attributes.width)y.     window_info.width=window_attributes.width;!   window_info.height=image->rows; 5   if (window_info.height >= window_attributes.height) 0     window_info.height=window_attributes.height;O   status=XMakeImage(display,resource_info,&window_info,image,window_info.width,n     window_info.height);   if (status == False)4     Error("Unable to create X image",(char *) NULL);   /*I     Adjust image dimensions as specified by backdrop or geometry options.a   */   width=window_info.width;   height=window_info.height;   if (resource_info->backdrop)     {i       /*$         Center image on root window.       */3       window_info.x=(window_attributes.width >> 1)-f)         (window_info.ximage->width >> 1);>4       window_info.y=(window_attributes.height >> 1)-*         (window_info.ximage->height >> 1);$       width=window_attributes.width;&       height=window_attributes.height;     } 5   if (resource_info->image_geometry != (char *) NULL)o     {f
       char(         default_geometry[MaxTextLength];  	       inte         flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints();a,       if (size_hints == (XSizeHints *) NULL)H         Error("Unable to display on window","Memory allocation failed");$       size_hints->flags=(long) NULL;<       (void) sprintf(default_geometry,"%ux%u",width,height);4       flags=XWMGeometry(display,visual_info->screen,7         resource_info->image_geometry,default_geometry,iJ         window_info.border_width,size_hints,&window_info.x,&window_info.y,1         (int *) &width,(int *) &height,&gravity);i$       if (flags & (XValue | YValue))	         {o(           width=window_attributes.width;*           height=window_attributes.height;	         } !       XFree((void *) size_hints);e     }    /*     Create the X pixmap.   */   window_info.pixmap=iI     XCreatePixmap(display,window_info.id,width,height,window_info.depth); *   if (window_info.pixmap == (Pixmap) NULL)5     Error("Unable to create X pixmap",(char *) NULL);E   /*!     Display pixmap on the window.r   */C   if ((width > window_info.width) || (height > window_info.height)) K     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,e       0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,r     window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);o   /*     Free resources.    */*   XFreePixmap(display,window_info.pixmap);$   XDestroyImage(window_info.ximage);0   XFreeGC(display,window_info.annotate_context);*   XFreeCursor(display,window_info.cursor);/   XFreeCursor(display,window_info.busy_cursor); $   if (window_info.id != root_window)D     XFreeStandardColormap(display,visual_info,map_info,&pixel_info);   else     {o/       XRetainWindowColors(display,root_window);t6       if (pixel_info.pixels != (unsigned long *) NULL))         free((char *) pixel_info.pixels);t     }e   XFree((void *) map_info);p   XFree((void *) visual_info); }  0 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             % O %                                                                             % O %                                                                             %/O %   X D i s p l a y I m a g e                                                 %xO %                                                                             % O %                                                                             %yO %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDisplayImage displays an image via X11.  A new image is createdI %  and returned if the user interactively transforms the displayed image.t %_. %  The format of the XDisplayImage routine is: %tN %      loaded_image=XDisplayImage(display,resource_info,argv,argc,image,state) %f+ %  A description of each parameter follows:) % F %    o loaded_image:  Function XDisplayImage returns an image when theF %      user chooses 'Load Image' from the command menu or picks a tileE %      from the image directory.  Otherwise a null image is returned.  % E %    o display: Specifies a connection to an X server;  returned fromi %      XOpenDisplay. %iK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure., %g7 %    o argv: Specifies the application's argument list.o %i/ %    o argc: Specifies the number of arguments.% %%G %    o image: Specifies an address to an address of an Image structure;  %      returned from ReadImage.  %  %  */H static Image *XDisplayImage(display,resource_info,argv,argc,image,state) Display    *display;   
 XResourceInfo    *resource_info;    char	   **argv;    int    argc;    Image 
   **image;  
 unsigned long 	   *state;  { 4 #define MagnifySize  256  /* must be a power of 2 */ #define MagickMenus  8 #define MaxWindows  10 #define MagickTitle  "Commands"   
   static char      *CommandMenu[]=      { 
       "File", 
       "Edit", 
       "Size",        "Pixel Transform",       "Color Enhance",       "Effects",       "Image Edit",%
       "Info",%
       "Quit",%       (char *) NULL      },     *FileMenu[]=     {m       "Load...",
       "Next",l       "Former",s       "Select...",       "Write...",r       "Print...",s       "Delete...",       "Canvas...",       "Slide Show...",       "Visual Directory...",       (char *) NULLh     },     *EditMenu[]=     {e
       "Undo",        "Cut",
       "Copy",        "Paste",       "Refresh",       (char *) NULLs     },     *SizeMenu[]=     {n       "Half Size",       "Original Size",       "Double Size",       "Resize...",       "Restore",       "Apply",       (char *) NULLw     },     *PixelTransformMenu[]=     {t
       "Crop", 
       "Chop",c
       "Flop", 
       "Flip",c       "Rotate Right",        "Rotate Left",       "Rotate...",       "Shear...",d       "Trim Edges",w       (char *) NULLa     },     *ColorEnhanceMenu[]=     {s       "Hue...",W       "Saturation...",       "Brightness...",       "Gamma...",x       "Spiff",
       "Dull",        "Equalize",a       "Normalize",       "Negate",m       "Toggle Colormap",       (char *) NULLi     },     *EffectsMenu[]=E     {e       "Despeckle",       "Peak Noise",        "Sharpen...",0       "Blur...",       "Edge Detect",       "Emboss",        "Oil Painting",p       "Segment",       "Grayscale",       "Quantize...",       (char *) NULLe     },     *ImageEditMenu[]=      {e       "Annotate",i
       "Draw",r       "Color",       "Matte",       "Composite...",t       "Add Border...",       "Comment",       "Region of Interest",r       (char *) NULL)     },     *InfoMenu[]=     {t       "Image Info",        "Version",
       "Help",d       (char *) NULL      };  
   static char      **Menus[MagickMenus]=n     {/       FileMenu,g       EditMenu,,       SizeMenu,d       PixelTransformMenu,f       ColorEnhanceMenu,c       EffectsMenu,       ImageEditMenu,       InfoMenu     };     static KeySym%     CommandKeys[]=     {%       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_h, 
       XK_q     },     FileKeys[]=      {        XK_l,        XK_n,        XK_f,        XK_F2,       XK_w,        XK_p,        XK_asciicircum,        XK_C,        XK_comma, 
       XK_V     },     EditKeys[]=      {        XK_u,        XK_F3,       XK_F4,       XK_F5,       XK_at,     },     SizeKeys[]=      {        XK_less,       XK_o,        XK_greater,        XK_percent,        XK_r, 
       XK_A     },     PixelTransformKeys[]=%     {%       XK_bracketleft,%       XK_bracketright,
       XK_bar,e       XK_minus,        XK_slash,        XK_backslash,o       XK_asterisk,       XK_s,s
       XK_t     },     ColorEnhanceKeys[]=o     {e       XK_F7,       XK_F8,       XK_F9,       XK_g, 
       XK_F10,:
       XK_F11,e       XK_equal,e       XK_N,r       XK_asciitilde,       XK_F12     },     EffectsKeys[]=     {y       XK_D,t       XK_P,        XK_S,        XK_B,        XK_E,l       XK_M,        XK_O,t       XK_Z,;       XK_G,m       XK_numbersign.     },     ImageEditKeys[]=     {        XK_a,a       XK_d,e       XK_c,e       XK_m,o       XK_x,c       XK_b,e       XK_exclam,
       XK_R     },     InfoKeys[]=      {e       XK_i,s       XK_v,t
       XK_h     };     static KeySym      *Keys[MagickMenus]=B     {a       FileKeys,c       EditKeys,a       SizeKeys,        PixelTransformKeys,        ColorEnhanceKeys,W       EffectsKeys,       ImageEditKeys,       InfoKeys,d     };     static unsigned charB     HighlightBitmap[] = {0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55},?     ShadowBitmap[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};;     char     command[MaxTextLength],e!     resource_name[MaxTextLength];M     Imageh     *displayed_image,r     *loaded_image;     int      id,t     status;      KeySym     key_symbol;i     register int     i;  
   static char("     home_directory[MaxTextLength],%     working_directory[MaxTextLength];o     static Window>     root_window;     static XClassHintd     *class_hint;     static XFontStruct     *font_info;C     static XImagee     former_ximage;     static XPixelInfob     icon_pixel,W     pixel_info;d     static XPointn
     vid_info;e     static XResourceInfo     icon_resources;)     static XStandardColormap     *icon_map,     *map_info;     static XVisualInfo     *icon_visual,e(     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo      *magick_windows[MaxWindows];     static XWMHintsw     *manager_hints;r     static unsigned ints     number_windows;t  
   struct statf     file_info;     time_t
     timer,     time_stamp,o     update_time;     unsigned int     context_mask;.     XEvent
     event;     XGCValues=     context_values;.     XWindowChanges     window_changes;a  *   if (visual_info != (XVisualInfo *) NULL)$     (void) chdir(working_directory);   else     {W       /*#         Allocate standard colormap.>       */       if (resource_info->debug)a	         { %           XSynchronize(display,True);m9           (void) fprintf(stderr,"Version: %s\n",Version);e	         } (       map_info=XAllocStandardColormap();(       icon_map=XAllocStandardColormap();5       if ((map_info == (XStandardColormap *) NULL) ||(3           (icon_map == (XStandardColormap *) NULL))fO         Error("Unable to create standard colormap","Memory allocation failed"); )       map_info->colormap=(Colormap) NULL;%)       icon_map->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL; ,       pixel_info.annotate_context=(GC) NULL;-       pixel_info.highlight_context=(GC) NULL; *       pixel_info.widget_context=(GC) NULL;%       font_info=(XFontStruct *) NULL; /       icon_pixel.pixels=(unsigned long *) NULL;        /*         Allocate visual.       */&       icon_resources=(*resource_info);,       icon_resources.map_type=(char *) NULL;+       icon_resources.visual_type="default"; -       icon_resources.colormap=SharedColormap; B       visual_info=XBestVisualInfo(display,map_info,resource_info);D       icon_visual=XBestVisualInfo(display,icon_map,&icon_resources);2       if ((visual_info == (XVisualInfo *) NULL) ||0           (icon_visual == (XVisualInfo *) NULL))A         Error("Unable to get visual",resource_info->visual_type);        if (resource_info->debug)r	         {o-           (void) fprintf(stderr,"Visual:\n");tN           (void) fprintf(stderr,"  visual id: 0x%lx\n",visual_info->visualid);0           (void) fprintf(stderr,"  class: %s\n",2             XVisualClassName(visual_info->class));K           (void) fprintf(stderr,"  depth: %d planes\n",visual_info->depth); C           (void) fprintf(stderr,"  size of colormap: %d entries\n",f(             visual_info->colormap_size);P           (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",:             visual_info->red_mask,visual_info->green_mask,$             visual_info->blue_mask);I           (void) fprintf(stderr,"  significant bits in color: %d bits\n",n'             visual_info->bits_per_rgb); 	         }x       /*         Allocate atoms.        */4       windows=(XWindows *) malloc(sizeof(XWindows));'       if (windows == (XWindows *) NULL)pG         Error("Unable to create X windows","Memory allocation failed"); F       windows->wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);N       windows->wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);H       windows->wm_take_focus=XInternAtom(display,"WM_TAKE_FOCUS",False);F       windows->im_protocols=XInternAtom(display,"IM_PROTOCOLS",False);N       windows->im_update_widget=XInternAtom(display,"IM_UPDATE_WIDGET",False);"       windows->im_update_colormap=8         XInternAtom(display,"IM_UPDATE_COLORMAP",False);L       windows->im_former_image=XInternAtom(display,"IM_FORMER_IMAGE",False);H       windows->im_next_image=XInternAtom(display,"IM_NEXT_IMAGE",False);<       windows->im_exit=XInternAtom(display,"IM_EXIT",False);       if (resource_info->debug).	         {>0           (void) fprintf(stderr,"Protocols:\n");<           (void) fprintf(stderr,"  Window Manager: 0x%lx\n",#             windows->wm_protocols);o=           (void) fprintf(stderr,"    delete window: 0x%lx\n",w'             windows->wm_delete_window); :           (void) fprintf(stderr,"    take focus: 0x%lx\n",$             windows->wm_take_focus);9           (void) fprintf(stderr,"  ImageMagick: 0x%lx\n", #             windows->im_protocols);+=           (void) fprintf(stderr,"    update widget: 0x%lx\n",d'             windows->im_update_widget); ?           (void) fprintf(stderr,"    update colormap: 0x%lx\n",n)             windows->im_update_colormap);(<           (void) fprintf(stderr,"    former image: 0x%lx\n",&             windows->im_former_image);:           (void) fprintf(stderr,"    next image: 0x%lx\n",$             windows->im_next_image);F           (void) fprintf(stderr,"    exit: 0x%lx\n",windows->im_exit);	         }        /*)         Allocate class and manager hints.        */#       class_hint=XAllocClassHint(); $       manager_hints=XAllocWMHints();0       if ((class_hint == (XClassHint *) NULL) ||/           (manager_hints == (XWMHints *) NULL)) :         Error("Unable to allocate X hints",(char *) NULL);       /*         Initialize window id's.        */;       root_window=XRootWindow(display,visual_info->screen);        number_windows=0;w8       magick_windows[number_windows++]=(&windows->icon);<       magick_windows[number_windows++]=(&windows->backdrop);9       magick_windows[number_windows++]=(&windows->image);,8       magick_windows[number_windows++]=(&windows->info);;       magick_windows[number_windows++]=(&windows->command);C:       magick_windows[number_windows++]=(&windows->widget);9       magick_windows[number_windows++]=(&windows->popup);c;       magick_windows[number_windows++]=(&windows->magnify);;7       magick_windows[number_windows++]=(&windows->pan); (       for (i=0; i < number_windows; i++),         magick_windows[i]->id=(Window) NULL;       vid_info.x=0;        vid_info.y=0;t4       (void) getcwd(home_directory,MaxTextLength-1);     }n   /*!     Initialize Standard Colormap.    */   loaded_image=(Image *) NULL;   displayed_image=(*image);    if (resource_info->debug)r     {mM       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",displayed_image->filename,vO         displayed_image->scene,displayed_image->columns,displayed_image->rows);='       if (displayed_image->colors != 0)=>         (void) fprintf(stderr,"%uc ",displayed_image->colors);<       (void) fprintf(stderr,"%s\n",displayed_image->magick);     }:J   XMakeStandardColormap(display,visual_info,resource_info,displayed_image,     map_info,&pixel_info);   /*     Initialize font info.l   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info);)3   font_info=XBestFont(display,resource_info,False); (   if (font_info == (XFontStruct *) NULL)5     Error("Unable to load font",resource_info->font);    /*     Initialize graphic context.    */$   windows->context.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->context);E$   class_hint->res_name="superclass";&   class_hint->res_class="ImageMagick";-   manager_hints->flags=InputHint | StateHint;t   manager_hints->input=False;..   manager_hints->initial_state=WithdrawnState;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,r     &windows->context);h   if (resource_info->debug)cN     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);>   context_values.background=pixel_info.background_color.pixel;%   context_values.font=font_info->fid; >   context_values.foreground=pixel_info.foreground_color.pixel;*   context_values.graphics_exposures=False;/   if (pixel_info.annotate_context != (GC) NULL) 1     XFreeGC(display,pixel_info.annotate_context);aJ   context_mask=GCBackground | GCFont | GCForeground | GCGraphicsExposures;   pixel_info.annotate_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);9   context_values.background=pixel_info.depth_color.pixel; -   if (pixel_info.widget_context != (GC) NULL)d/     XFreeGC(display,pixel_info.widget_context);l   pixel_info.widget_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);-   if (pixel_info.widget_context == (GC) NULL)d<     Error("Unable to create graphic context",(char *) NULL);>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;   context_values.plane_mask=:     context_values.background ^ context_values.foreground;0   if (pixel_info.highlight_context != (GC) NULL)2     XFreeGC(display,pixel_info.highlight_context);E   pixel_info.highlight_context=XCreateGC(display,windows->context.id,00     context_mask | GCPlaneMask,&context_values);0   if (pixel_info.highlight_context == (GC) NULL)<     Error("Unable to create graphic context",(char *) NULL);.   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.e   */O   XGetWindowInfo(display,icon_visual,icon_map,&icon_pixel,(XFontStruct *) NULL,%$     &icon_resources,&windows->icon);6   windows->icon.geometry=resource_info->icon_geometry;8   XBestIconSize(display,&windows->icon,displayed_image);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);I   windows->icon.attributes.event_mask=ExposureMask | StructureNotifyMask;i   class_hint->res_name="icon";-   manager_hints->flags=InputHint | StateHint;n   manager_hints->input=False;y+   manager_hints->initial_state=IconicState; E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,      &windows->icon);   if (resource_info->debug)oH     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window.n   */>   context_values.background=icon_pixel.background_color.pixel;>   context_values.foreground=icon_pixel.foreground_color.pixel;A   icon_pixel.annotate_context=XCreateGC(display,windows->icon.id,.1     GCBackground | GCForeground,&context_values); /   if (icon_pixel.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);=   windows->icon.annotate_context=icon_pixel.annotate_context;n   /*     Initialize Image window.   */)   if (windows->image.id != (Window) NULL)      { )       free((char *) windows->image.name);e.       free((char *) windows->image.icon_name);     }:D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->image); B   windows->image.name=(char *) malloc(MaxTextLength*sizeof(char));G   windows->image.icon_name=(char *) malloc(MaxTextLength*sizeof(char));wJ   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))F     Error("Unable to create Image window","Memory allocation failed");O   if ((resource_info->title != (char *) NULL) && !(*state & MontageImageState))-     {_       /*#         User specified window name.        */>       (void) strcpy(windows->image.name,resource_info->title);C       (void) strcpy(windows->image.icon_name,resource_info->title);      }z   else     { 
       char         *p;.         /*0         Window name is the base of the filename.       */F       p=displayed_image->filename+strlen(displayed_image->filename)-1;O       while ((p > displayed_image->filename) && (*(p-1) != *BasenameSeparator))          p--;A       (void) sprintf(windows->image.name,"ImageMagick: %s[%u]",p,w          displayed_image->scene);:       if ((displayed_image->previous == (Image *) NULL) &&6           (displayed_image->next == (Image *) NULL) &&(           (displayed_image->scene == 0))@         (void) sprintf(windows->image.name,"ImageMagick: %s",p);0       (void) strcpy(windows->image.icon_name,p);     } 8   windows->image.geometry=resource_info->image_geometry;0   windows->image.width=displayed_image->columns;H   if (windows->image.width > XDisplayWidth(display,visual_info->screen))D     windows->image.width=XDisplayWidth(display,visual_info->screen);.   windows->image.height=displayed_image->rows;J   if (windows->image.height > XDisplayHeight(display,visual_info->screen))F     windows->image.height=XDisplayHeight(display,visual_info->screen);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask |dG     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |e<     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,&     resource_info,&windows->backdrop);I   if (resource_info->backdrop || (windows->backdrop.id != (Window) NULL))(     {-       /*#         Initialize backdrop window.c       */4       windows->backdrop.name="ImageMagick Backdrop";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen);oK       windows->backdrop.height=XDisplayHeight(display,visual_info->screen);t'       windows->backdrop.border_width=0;h'       windows->backdrop.immutable=True; J       windows->backdrop.attributes.do_not_propagate_mask=ButtonPressMask |         ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;&       class_hint->res_name="backdrop";B       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state=e:         resource_info->iconic ? IconicState : NormalState;I       XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,%         &windows->backdrop);       if (resource_info->debug)%>         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id); 1       XClearWindow(display,windows->backdrop.id); -       if (windows->image.id != (Window) NULL) 	         { 4           XDestroyWindow(display,windows->image.id);*           windows->image.id=(Window) NULL;	         }        /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition; I       windows->image.x=(XDisplayWidth(display,visual_info->screen) >> 1)- $         (windows->image.width >> 1);J       windows->image.y=(XDisplayHeight(display,visual_info->screen) >> 1)-%         (windows->image.height >> 1);o     }c+   if (resource_info->name == (char *) NULL) %     class_hint->res_name=client_name;r   else-     class_hint->res_name=resource_info->name;m>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state=s6     resource_info->iconic ? IconicState : NormalState;   XMakeWindow(display,L     (Window) (resource_info->backdrop ? windows->backdrop.id : root_window),8     argv,argc,class_hint,manager_hints,&windows->image);   if (resource_info->debug)sJ     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*!     Initialize X image structure.o   */   windows->image.x=0;f   windows->image.y=0; J   status=XMakeImage(display,resource_info,&windows->image,displayed_image,4     displayed_image->columns,displayed_image->rows);   if (status == False)4     Error("Unable to create X image",(char *) NULL);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);(   XMapWindow(display,windows->image.id);   if (windows->image.mapped)@     if ((windows->image.ximage->width == former_ximage.width) &&@         (windows->image.ximage->height == former_ximage.height))>       XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*     Initialize Info widget.l   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,"     resource_info,&windows->info);   windows->info.name="Info";   windows->info.border_width=1;i   windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition; +   windows->info.attributes.save_under=True;l4   windows->info.attributes.win_gravity=UnmapGravity;&   windows->info.attributes.event_mask=9     ButtonPressMask | ExposureMask | StructureNotifyMask;    class_hint->res_name="info";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;p   manager_hints->input=False;t+   manager_hints->initial_state=NormalState;e0   manager_hints->window_group=windows->image.id;K   XMakeWindow(display,windows->image.id,argv,argc,class_hint,manager_hints,      &windows->info);C   XSetTransientForHint(display,windows->info.id,windows->image.id);    if (windows->info.mapped))C     XWithdrawWindow(display,windows->info.id,windows->info.screen);i   if (resource_info->debug)rH     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*     Initialize Command widget.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->command); 9   (void) sprintf(resource_name,"%s.Command",client_name);mO   windows->command.geometry=XGetResourceClass(resource_info->resource_database,n,     resource_name,"geometry",(char *) NULL);$   windows->command.name=MagickTitle;"   windows->command.border_width=0;$   windows->command.flags|=PPosition;7   windows->command.attributes.backing_store=WhenMapped;o.   windows->command.attributes.save_under=True;M   windows->command.attributes.event_mask=ButtonMotionMask | ButtonPressMask | J     ButtonReleaseMask | EnterWindowMask | ExposureMask | LeaveWindowMask |.     OwnerGrabButtonMask | StructureNotifyMask;!   class_hint->res_name="command";+?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False;e+   manager_hints->initial_state=NormalState;e0   manager_hints->window_group=windows->image.id;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,2     &windows->command); C   windows->command.highlight_stipple=XCreateBitmapFromData(display,e6     windows->command.id,(char *) HighlightBitmap,8,8);@   windows->command.shadow_stipple=XCreateBitmapFromData(display,3     windows->command.id,(char *) ShadowBitmap,8,8);fF   XSetTransientForHint(display,windows->command.id,windows->image.id);   if (windows->command.mapped),     XMapRaised(display,windows->command.id);$   windows->command.data=MagickMenus;E   (void) XCommandWidget(display,windows,CommandMenu,(XEvent *) NULL);c   if (resource_info->debug)rN     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);   /*     Initialize widget window.t   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,$     resource_info,&windows->widget);C   windows->widget.name=(char *) malloc(MaxTextLength*sizeof(char));t#   if (windows->widget.name == NULL) G     Error("Unable to create widget window","Memory allocation failed");E!   windows->widget.border_width=0;o#   windows->widget.flags|=PPosition;a6   windows->widget.attributes.backing_store=WhenMapped;-   windows->widget.attributes.save_under=True;nL   windows->widget.attributes.event_mask=ButtonMotionMask | ButtonPressMask |G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |p;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;u    class_hint->res_name="widget";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;b   manager_hints->input=True;+   manager_hints->initial_state=NormalState;i0   manager_hints->window_group=windows->image.id;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,o     &windows->widget);G   windows->widget.highlight_stipple=windows->command.highlight_stipple;sA   windows->widget.shadow_stipple=windows->command.shadow_stipple; E   XSetTransientForHint(display,windows->widget.id,windows->image.id);    if (resource_info->debug)/L     (void) fprintf(stderr,"Window id: 0x%lx (widget)\n",windows->widget.id);   /*     Initialize popup window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->popup);*B   windows->popup.name=(char *) malloc(MaxTextLength*sizeof(char));"   if (windows->popup.name == NULL)F     Error("Unable to create popup window","Memory allocation failed");    windows->popup.border_width=0;"   windows->popup.flags|=PPosition;5   windows->popup.attributes.backing_store=WhenMapped; ,   windows->popup.attributes.save_under=True;K   windows->popup.attributes.event_mask=ButtonMotionMask | ButtonPressMask |rG     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | ;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;    class_hint->res_name="popup";0?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;n   manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,.     &windows->popup); F   windows->popup.highlight_stipple=windows->command.highlight_stipple;@   windows->popup.shadow_stipple=windows->command.shadow_stipple;D   XSetTransientForHint(display,windows->popup.id,windows->image.id);   if (resource_info->debug)tK     (void) fprintf(stderr,"Window id: 0x%lx (pop up)\n",windows->popup.id);f   /*)     Initialize Magnify window and cursor.    */+   if (windows->magnify.id != (Window) NULL)a)     free((char *) windows->magnify.name);iD   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->magnify); 9   (void) sprintf(resource_name,"%s.Magnify",client_name); O   windows->magnify.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);D   windows->magnify.name=(char *) malloc(MaxTextLength*sizeof(char));$   if (windows->magnify.name == NULL)H     Error("Unable to create Magnify window","Memory allocation failed");M   (void) sprintf(windows->magnify.name,"Magnify %uX",resource_info->magnify); @   windows->magnify.cursor=XMakeCursor(display,windows->image.id,7     map_info->colormap,resource_info->background_color, %     resource_info->foreground_color);a/   if (windows->magnify.cursor == (Cursor) NULL)N3     Error("Unable to create cursor",(char *) NULL);a%   windows->magnify.width=MagnifySize; &   windows->magnify.height=MagnifySize;$   windows->magnify.flags|=PPosition;)   windows->magnify.min_width=MagnifySize;d*   windows->magnify.min_height=MagnifySize;)   windows->magnify.width_inc=MagnifySize;d*   windows->magnify.height_inc=MagnifySize;/   windows->magnify.data=resource_info->magnify;t.   windows->magnify.attributes.save_under=True;=   windows->magnify.attributes.cursor=windows->magnify.cursor;,N   windows->magnify.attributes.event_mask=ButtonPressMask | ButtonReleaseMask |H     ExposureMask | KeyPressMask | KeyReleaseMask | OwnerGrabButtonMask |     StructureNotifyMask;!   class_hint->res_name="magnify";e?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,w     &windows->magnify);y   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (magnify)\n",windows->magnify.id);F   XSetTransientForHint(display,windows->magnify.id,windows->image.id);   if (windows->magnify.mapped),     XMapRaised(display,windows->magnify.id);   /*     Initialize panning window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,!     resource_info,&windows->pan);p   windows->pan.name="Pan Icon";S7   XBestIconSize(display,&windows->pan,displayed_image); -   while ((windows->pan.width < MinPanSize) &&e,          (windows->pan.height < MinPanSize))   {      windows->pan.width<<=1;=     windows->pan.height<<=1;   } 5   (void) sprintf(resource_name,"%s.Pan",client_name); K   windows->pan.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);-   if (windows->pan.geometry != (char *) NULL);A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,        &windows->pan.height);    windows->pan.flags|=PPosition;   windows->pan.immutable=True;*   windows->pan.attributes.save_under=True;I   windows->pan.attributes.event_mask=ButtonMotionMask | ButtonPressMask |=F     ButtonReleaseMask | ExposureMask | KeyPressMask | KeyReleaseMask |     StructureNotifyMask;   class_hint->res_name="pan";i?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState;-0   manager_hints->window_group=windows->image.id;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,r     &windows->pan);r   if (resource_info->debug) F     (void) fprintf(stderr,"Window id: 0x%lx (pan)\n",windows->pan.id);B   XSetTransientForHint(display,windows->pan.id,windows->image.id);   if (windows->image.mapped)@     if ((windows->image.width < windows->image.ximage->width) ||@         (windows->image.height < windows->image.ximage->height))*       XMapRaised(display,windows->pan.id);   /*     Respond to events.   */   SetWarningHandler(XWarning);3   timer=time((time_t *) NULL)+resource_info->delay;|   update_time=0;   if (resource_info->update)     {        /*3         Determine when file data was last modified.        */8       status=stat(displayed_image->filename,&file_info);       if (status == 0)'         update_time=file_info.st_mtime;      }r   *state&=(~FormerImageState);   *state&=(~MontageImageState);    *state&=(~NextImageState);   do   {      /*       Handle a window event.     */"     if (resource_info->delay != 0)       { *         if (timer < time((time_t *) NULL))%           if (!resource_info->update)X/             *state|=NextImageState | ExitState;;           else
             {                /*5                 Determine if image file was modified.                */@               status=stat(displayed_image->filename,&file_info);               if (status == 0)6                 if (update_time != file_info.st_mtime)                   {i                     /*&                       Redisplay image.                     */F                     loaded_image=ReadImage(resource_info->image_info);7                     if (loaded_image != (Image *) NULL)y9                       *state|=NextImageState | ExitState;M                   }o?               timer=time((time_t *) NULL)+resource_info->delay; 
             } 9         if (XEventsQueued(display,QueuedAfterFlush) == 0)o           {a             /*(               Do not block if delay > 0.             */-             XDelay(display,SuspendTime << 2);r             continue;            }a       }w%     time_stamp=time((time_t *) NULL);T     XNextEvent(display,&event);;     if (!windows->image.stasis);C       windows->image.stasis=(time((time_t *) NULL)-time_stamp) > 0;m1     if (event.xany.window == windows->command.id)e       {w
         /*3           Select a command from the Command widget. 
         */>         id=XCommandWidget(display,windows,CommandMenu,&event);         if (id < 0)i           continue;c/         (void) strcpy(command,CommandMenu[id]);s#         key_symbol=CommandKeys[id];f         if (id < MagickMenus)y           {f             int                entry;               /*2               Select a command from a pop-up menu.             */H             entry=XMenuWidget(display,windows,CommandMenu[id],Menus[id],               command);              if (entry < 0)               continue; 4             (void) strcpy(command,Menus[id][entry]);'             key_symbol=Keys[id][entry];=           } (         if (key_symbol != XK_VoidSymbol)F           loaded_image=XMagickCommand(display,resource_info,windows,0,)             key_symbol,&displayed_image);C         continue;)       }      switch (event.type)(     {r       case ButtonPress:u       {i!         if (resource_info->debug);B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);i0         if ((event.xbutton.button == Button3) &&-             (event.xbutton.state & Mod1Mask))            {o             /*-               Convert Alt-Button3 to Button2.              */)             event.xbutton.button=Button2;i-             event.xbutton.state&=(~Mod1Mask);a           } 9         if (event.xbutton.window == windows->backdrop.id)l           { G             XSetInputFocus(display,event.xbutton.window,RevertToParent, "               event.xbutton.time);             break;           }k6         if (event.xbutton.window == windows->image.id)           {e)             switch (event.xbutton.button) 
             {)               case Button1:p               {b                 /*+                   Map/unmap Command widget.r                 */,                 if (windows->command.mapped)>                   XWithdrawWindow(display,windows->command.id,-                     windows->command.screen);+                 else                   { F                     (void) XCommandWidget(display,windows,CommandMenu,'                       (XEvent *) NULL); <                     XMapRaised(display,windows->command.id);                   }t                 break;               }o               case Button2:t               {                  /*8                   User pressed the image magnify button.                 */,                 if (windows->magnify.mapped)<                   XRaiseWindow(display,windows->magnify.id);                 else                   {                      /*)                       Make magnify image.g                     */N                     status=XMakeImage(display,resource_info,&windows->magnify,<                       (Image *) NULL,windows->magnify.width,/                       windows->magnify.height);                      status|=K                       XMakePixmap(display,resource_info,&windows->magnify);l(                     if (status == False)L                       Error("Unable to create magnify image",(char *) NULL);<                     XMapRaised(display,windows->magnify.id);                   },6                 XMagnifyImage(display,windows,&event);                 break;               }%               case Button3:%               {%>                 if (displayed_image->montage == (char *) NULL)                   { %                     XBell(display,0);                      break;                   }                  /*F                   Load or delete a tile from a visual image directory.                 */.                 windows->widget.x_origin=(-1);.                 windows->widget.y_origin=(-1);F                 loaded_image=XTileImage(display,resource_info,windows,*                   displayed_image,&event);3                 if (loaded_image != (Image *) NULL) I                   *state|=MontageImageState | NextImageState | ExitState;%,                 vid_info.x=windows->image.x;,                 vid_info.y=windows->image.y;                 break;               }a               default:                 break;
             }              break;           } 8         if (event.xbutton.window == windows->magnify.id)           {m             char%               command[MaxTextLength];A               inth               factor;                static charC               *MagnifyMenu[]=h               {                  "2",                 "4",                 "5",                 "6",                 "7",                 "8",                 "9",                 "3",                 (char *) NULL,               };               static KeySym                MagnifyKeys[]=               {w                 XK_2,n                 XK_4,t                 XK_5,                  XK_6,a                 XK_7,n                 XK_8,a                 XK_9,s                 XK_3               };               /*;               Select a magnify factor from the pop-up menu.n             */N             factor=XMenuWidget(display,windows,"Magnify",MagnifyMenu,command);             if (factor >= 0)I               XMagnifyWindowCommand(display,windows,MagnifyKeys[factor]);u             break;           } 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);             break;           }s9         timer=time((time_t *) NULL)+resource_info->delay;          break;       }t       case ButtonRelease:n         break;       case ClientMessage:g       { !         if (resource_info->debug) I           (void) fprintf(stderr,"Client Message: 0x%lx 0x%lx %d 0x%lx\n",a<             event.xclient.window,event.xclient.message_type,:             event.xclient.format,event.xclient.data.l[0]);@         if (event.xclient.message_type == windows->im_protocols)           { C             if (*event.xclient.data.l == windows->im_update_widget)                {s2                 windows->command.name=MagickTitle;2                 windows->command.data=MagickMenus;B                 (void) XCommandWidget(display,windows,CommandMenu,#                   (XEvent *) NULL);t                 break;               }sE             if (*event.xclient.data.l == windows->im_update_colormap)w               {                  /*=                   Update graphic context and window colormap.                  */2                 for (i=0; i < number_windows; i++)                 {e@                   if (magick_windows[i]->id == windows->icon.id)                     continue;;N                   context_values.background=pixel_info.background_color.pixel;N                   context_values.foreground=pixel_info.foreground_color.pixel;H                   XChangeGC(display,magick_windows[i]->annotate_context,2                     context_mask,&context_values);F                   XChangeGC(display,magick_windows[i]->widget_context,2                     context_mask,&context_values);N                   context_values.background=pixel_info.foreground_color.pixel;N                   context_values.foreground=pixel_info.background_color.pixel;,                   context_values.plane_mask=J                     context_values.background ^ context_values.foreground;I                   XChangeGC(display,magick_windows[i]->highlight_context,c@                     context_mask | GCPlaneMask,&context_values);A                   magick_windows[i]->attributes.background_pixel=h6                     pixel_info.background_color.pixel;=                   magick_windows[i]->attributes.border_pixel=g2                     pixel_info.border_color.pixel;L                   magick_windows[i]->attributes.colormap=map_info->colormap;H                   XChangeWindowAttributes(display,magick_windows[i]->id,L                     magick_windows[i]->mask,&magick_windows[i]->attributes);                 }i:                 if (windows->backdrop.id != (Window) NULL)?                   XInstallColormap(display,map_info->colormap);                  break;               }WB             if (*event.xclient.data.l == windows->im_former_image)               {t5                 *state|=FormerImageState | ExitState;e                 break;               } @             if (*event.xclient.data.l == windows->im_next_image)               { 3                 *state|=NextImageState | ExitState;                  break;               }i:             if (*event.xclient.data.l == windows->im_exit)               {,"                 *state|=ExitState;                 break;               }              break;           } 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;?         if (*event.xclient.data.l != windows->wm_delete_window)g           break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {              *state|=ExitState;             break;           }o4         if (event.xclient.window == windows->pan.id)           {i             /*E               Restore original image size when pan window is deleted.              */M             windows->image.window_changes.width=windows->image.ximage->width; O             windows->image.window_changes.height=windows->image.ximage->height; A             (void) XConfigureImage(display,resource_info,windows,|               displayed_image);|           }          break;       }        case ConfigureNotify:        { !         if (resource_info->debug)eK           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d %d\n", ;             event.xconfigure.window,event.xconfigure.width,rJ             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y,)             event.xconfigure.send_event); 9         if (event.xconfigure.window == windows->image.id)i           {w             /*3               Image window has a new configuration.t             */1             if (event.xconfigure.send_event != 0)a               {                  XWindowChanges!                   window_changes;_                   /*N                   Position the transient windows relative of the Image window.                 */?                 if (windows->command.geometry == (char *) NULL)g/                   if (!windows->command.mapped)n                     {t)                       windows->command.x=eE                         event.xconfigure.x-windows->command.width-25; <                       windows->command.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->command);:                       window_changes.x=windows->command.x;:                       window_changes.y=windows->command.y;G                       XReconfigureWMWindow(display,windows->command.id, K                         windows->command.screen,CWX | CWY,&window_changes);b                     }o?                 if (windows->magnify.geometry == (char *) NULL)t/                   if (!windows->magnify.mapped)                      {:)                       windows->magnify.x= E                         event.xconfigure.x+event.xconfigure.width+25;m<                       windows->magnify.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->magnify);:                       window_changes.x=windows->magnify.x;:                       window_changes.y=windows->magnify.y;G                       XReconfigureWMWindow(display,windows->magnify.id, K                         windows->magnify.screen,CWX | CWY,&window_changes);                      }b;                 if (windows->pan.geometry == (char *) NULL)X+                   if (!windows->pan.mapped)                      { %                       windows->pan.x=aE                         event.xconfigure.x+event.xconfigure.width+25;t%                       windows->pan.y= F                         event.xconfigure.y+windows->magnify.height+50;F                       XConstrainWindowPosition(display,&windows->pan);6                       window_changes.x=windows->pan.x;6                       window_changes.y=windows->pan.y;C                       XReconfigureWMWindow(display,windows->pan.id,sG                         windows->pan.screen,CWX | CWY,&window_changes);                      }                } C             if ((event.xconfigure.width == windows->image.width) && C                 (event.xconfigure.height == windows->image.height))*               break;8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             windows->image.x=0;n             windows->image.y=0; :             if (displayed_image->montage != (char *) NULL)               {/,                 windows->image.x=vid_info.x;,                 windows->image.y=vid_info.y;               })?             if (windows->image.mapped && windows->image.stasis))               {                  /*4                   Update Image window configuration.                 */K                 windows->image.window_changes.width=event.xconfigure.width;yM                 windows->image.window_changes.height=event.xconfigure.height;nE                 (void) XConfigureImage(display,resource_info,windows, #                   displayed_image);                }              elseL               if ((event.xconfigure.width < windows->image.ximage->width) ||L                   (event.xconfigure.height < windows->image.ximage->height))                 {i6                   XMapRaised(display,windows->pan.id);5                   XDrawPanRectangle(display,windows);m                 }g               else(                 if (windows->pan.mapped)O                   XWithdrawWindow(display,windows->pan.id,windows->pan.screen);.             break;           }(;         if (event.xconfigure.window == windows->magnify.id)p           {l             unsigned int               magnify;               /*5               Magnify window has a new configuration.              */:             windows->magnify.width=event.xconfigure.width;<             windows->magnify.height=event.xconfigure.height;)             if (!windows->magnify.mapped)i               break;             magnify=1;5             while (magnify <= event.xconfigure.width)                magnify<<=1;6             while (magnify <= event.xconfigure.height)               magnify<<=1;             magnify>>=1;6             if ((magnify != event.xconfigure.width) ||5                 (magnify != event.xconfigure.height))c               {c-                 window_changes.width=magnify;(.                 window_changes.height=magnify;A                 XReconfigureWMWindow(display,windows->magnify.id,eN                   windows->magnify.screen,CWWidth | CWHeight,&window_changes);                 break;               }tF             status=XMakeImage(display,resource_info,&windows->magnify,M               (Image *) NULL,windows->magnify.width,windows->magnify.height);eI             status|=XMakePixmap(display,resource_info,&windows->magnify);               if (status == False)D               Error("Unable to create magnify image",(char *) NULL);/             XMakeMagnifyImage(display,windows);i             break;           }s7         if (event.xconfigure.window == windows->pan.id)            {t             /*6               Pan icon window has a new configuration.             */1             if (event.xconfigure.send_event != 0)u               {i2                 windows->pan.x=event.xconfigure.x;2                 windows->pan.y=event.xconfigure.y;               } 6             windows->pan.width=event.xconfigure.width;8             windows->pan.height=event.xconfigure.height;             break;           } 8         if (event.xconfigure.window == windows->icon.id)           {              /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width; 9             windows->icon.height=event.xconfigure.height;              break;           }          break;       }        case EnterNotify:        { 
         /*'           Selectively install colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)%8             XInductColormap(display,map_info->colormap);         break;       }        case Expose:       { !         if (resource_info->debug)i>           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y);;
         /*/           Refresh windows that are now exposed.o
         */6         if (event.xexpose.window == windows->image.id)$           if (windows->image.mapped)
             {.=               XRefreshWindow(display,&windows->image,&event);r?               timer=time((time_t *) NULL)+resource_info->delay;u               break;
             },8         if (event.xexpose.window == windows->magnify.id)'           if (event.xexpose.count == 0)s(             if (windows->magnify.mapped)               { 3                 XMakeMagnifyImage(display,windows);o                 break;               }p4         if (event.xexpose.window == windows->pan.id)'           if (event.xexpose.count == 0)d
             {C1               XDrawPanRectangle(display,windows);r               break;
             }a5         if (event.xexpose.window == windows->icon.id)f'           if (event.xexpose.count == 0)p
             {.<               XRefreshWindow(display,&windows->icon,&event);               break;
             }m         break;       }n       case KeyPress:       {o         inty           length;,  
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),d/           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0';i!         if (resource_info->debug)SN           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);3         if (event.xkey.window == windows->image.id)lD           loaded_image=XMagickCommand(display,resource_info,windows,:             event.xkey.state,key_symbol,&displayed_image);5         if (event.xkey.window == windows->magnify.id) <           XMagnifyWindowCommand(display,windows,key_symbol);1         if (event.xkey.window == windows->pan.id)            { #             if (key_symbol == XK_q) K               XWithdrawWindow(display,windows->pan.id,windows->pan.screen); A             if ((key_symbol == XK_F1) || (key_symbol == XK_Help)) B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Panning",ImagePanHelp);           } 9         timer=time((time_t *) NULL)+resource_info->delay;%         break;       }%       case KeyRelease:       {%
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),t/           &key_symbol,(XComposeStatus *) NULL);g!         if (resource_info->debug)uG           (void) fprintf(stderr,"Key release: 0x%lx (%c)\n",key_symbol,i             *command);         break;       }:       case LeaveNotify:        {r
         /*)           Selectively uninstall colormap.d
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) :             XUninductColormap(display,map_info->colormap);         break;       }e       case MapNotify:        {o!         if (resource_info->debug)wI           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window);r6         if (event.xmap.window == windows->backdrop.id)           {nD             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime);u             break;           }s3         if (event.xmap.window == windows->image.id)e           {u6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap);a<             if (strcmp(displayed_image->magick,"LOGO") == 0)               loaded_image= P                 XLoadImage(display,resource_info,windows,False,displayed_image);H             if ((windows->image.width < windows->image.ximage->width) ||H                 (windows->image.height < windows->image.ximage->height))2               XMapRaised(display,windows->pan.id);'             windows->image.mapped=True;(             break;           }T5         if (event.xmap.window == windows->magnify.id)n           { /             XMakeMagnifyImage(display,windows);;)             windows->magnify.mapped=True;              break;           }S1         if (event.xmap.window == windows->pan.id)t           {iD             XRefreshWindow(display,&windows->image,(XEvent *) NULL);I             XMakePanImage(display,resource_info,windows,displayed_image);x%             windows->pan.mapped=True;s             break;           }f2         if (event.xmap.window == windows->info.id)           {c&             windows->info.mapped=True;             break;           }o2         if (event.xmap.window == windows->icon.id)           {y             /*#               Create an icon image.s             */F             XMakeStandardColormap(display,icon_visual,&icon_resources,4               displayed_image,icon_map,&icon_pixel);E             (void) XMakeImage(display,&icon_resources,&windows->icon,gH               displayed_image,windows->icon.width,windows->icon.height);G             (void) XMakePixmap(display,&icon_resources,&windows->icon);X@             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id);g&             windows->icon.mapped=True;             break;           }o5         if (event.xmap.window == windows->command.id)m           { )             windows->command.mapped=True;;             break;           }&3         if (event.xmap.window == windows->popup.id)l           {i'             windows->popup.mapped=True;M             break;           }/4         if (event.xmap.window == windows->widget.id)           {i(             windows->widget.mapped=True;             break;           }g         break;       }g       case MappingNotify:        { 1         XRefreshKeyboardMapping(&event.xmapping);-         break;       }o       case NoExpose:         break;       case ReparentNotify:       {y!         if (resource_info->debug)nB           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);          break;       }        case UnmapNotify:i       {n!         if (resource_info->debug)hM           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window);w5         if (event.xunmap.window == windows->image.id)t           {a(             windows->image.mapped=False;             break;           }a7         if (event.xunmap.window == windows->magnify.id)i           {i*             windows->magnify.mapped=False;             break;           }L3         if (event.xunmap.window == windows->pan.id)            { &             windows->pan.mapped=False;             break;           }i4         if (event.xunmap.window == windows->info.id)           {t'             windows->info.mapped=False;s             break;           }e4         if (event.xunmap.window == windows->icon.id)           {i9             if (map_info->colormap == icon_map->colormap) D               XConfigureImageColormap(display,resource_info,windows,!                 displayed_image);cL             XFreeStandardColormap(display,icon_visual,icon_map,&icon_pixel);'             windows->icon.mapped=False;p             break;           }U7         if (event.xunmap.window == windows->command.id)m           {e*             windows->command.mapped=False;             break;           }-5         if (event.xunmap.window == windows->popup.id)i           {a6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);n(             windows->popup.mapped=False;             break;           }i6         if (event.xunmap.window == windows->widget.id)           {W6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime); )             windows->widget.mapped=False;%             break;           }%       }%       default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      }    }     while (!(*state & ExitState));?   if ((*state & FormerImageState) || (*state & NextImageState))      *state&=(~ExitState); )   former_ximage=(*windows->image.ximage);    /*$     Withdraw pan and Magnify window.   */   if (windows->pan.mapped)A     XWithdrawWindow(display,windows->pan.id,windows->pan.screen);    if (windows->magnify.mapped)I     XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);%   if (windows->command.mapped)I     XWithdrawWindow(display,windows->command.id,windows->command.screen);g(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   if (!(*state & ExitState))     {r9       if (resource_info->write_filename != (char *) NULL)aL         (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,           &displayed_image);1       XInfoWidget(display,windows,LoadImageText);      }    else     {e       /*         Destroy X windows.       */(       for (i=0; i < number_windows; i++)       {o3         if (magick_windows[i]->id != (Window) NULL)r8           XDestroyWindow(display,magick_windows[i]->id);9         if (magick_windows[i]->ximage != (XImage *) NULL) 3           XDestroyImage(magick_windows[i]->ximage);u7         if (magick_windows[i]->pixmap != (Pixmap) NULL)s9           XFreePixmap(display,magick_windows[i]->pixmap);t       }g       /*         Free Standard Colormap.n       */3       if (resource_info->map_type == (char *) NULL)uH         XFreeStandardColormap(display,visual_info,map_info,&pixel_info);       free((void *) windows);.!       XFree((void *) class_hint);d$       XFree((void *) manager_hints);"       XFree((void *) icon_visual);"       XFree((void *) visual_info);       XFree((void *) icon_map);C       XFree((void *) map_info);l'       visual_info=(XVisualInfo *) NULL;L'       if (copy_image != (Image *) NULL) !         DestroyImage(copy_image);      }R(   XCheckRefreshWindows(display,windows);3   (void) getcwd(working_directory,MaxTextLength-1);t   (void) chdir(home_directory);    *image=displayed_image;,   return(loaded_image);  }_ b /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             %CO %                                                                             %oO %   X D r a w I m a g e                                                       %sO %                                                                             %dO %                                                                             %QO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ? %  Function _XDrawImage draws a line or rectangle on the image.l %w, %  The format of the _XDrawImage routine is: %mD %    status=_XDrawImage(display,resource_info,windows,degrees,image) % + %  A description of each parameter follows:  % E %    o status: Function _XDrawImage return True if the image is drawnfG %      upon.  False is returned is there is a memory shortage or if thei  %      image cannot be drawn on. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %e< %    o windows: Specifies a pointer to a XWindows structure. %XF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.n %  %  */D static unsigned int _XDrawImage(display,resource_info,windows,image) Display    *display;e  
 XResourceInfoe   *resource_info;,   XWindows   *windows;l   Image-
   **image; {,- #define DrawImageText  "  Drawing image...  "  #define DrawModePrimitiveOp  0 #define DrawModeColorOp  1 #define DrawModeWidthOp  2 #define DrawModeUndoOp  3/ #define DrawModeHelpOp  4S #define DrawModeReturnOp  5i0 #define Swap(x,y) ((x)^=(y), (y)^=(x), (x)^=(y))  
   static char      *DrawModeMenu[]=     {        "Primitive",       "Color",       "Width",
       "Undo", 
       "Help",s       "Return",        (char *) NULL.     };     char     text[MaxTextLength];     Cursor     cursor;a     double     degrees;     intf     id,i     x,     y;     RectangleInfor     rectangle_info;      register int     i;     static unsigned int      pen_id = 0,      primitive = LinePrimitive,     line_width = 1;n     unsigned int
     distance,      height,D     status,i
     width;     unsigned long;
     state,
     x_factor,i
     y_factor;e     XDrawInfo      draw_info;     XEvent
     event;  
   XSegment     line_info;     /*     Map Command widget.    */   windows->command.name="Draw";    windows->command.data=3;*   XMapRaised(display,windows->command.id);F   (void) XCommandWidget(display,windows,DrawModeMenu,(XEvent *) NULL);A   XClientMessage(display,windows->image.id,windows->im_protocols,(+     windows->im_update_widget,CurrentTime);a   /*      Wait for first button press.   */   status=True;.   cursor=XCreateFontCursor(display,XC_tcross);
   for ( ; ; )    { 4     XQueryPosition(display,windows->image.id,&x,&y);4     XDefineCursor(display,windows->image.id,cursor);+     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     state=DefaultState;d     do     {o       if (windows->info.mapped) 	         {            /*%             Display pointer position.            */P           (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);,           XInfoWidget(display,windows,text);	         }        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);/3       if (event.xany.window == windows->command.id)n	         {)           /*5             Select a command from the Command widget.*           */A           id=XCommandWidget(display,windows,DrawModeMenu,&event);            if (id < 0)d             continue;            switch (id)f           {w%             case DrawModePrimitiveOp: 
             {<               char'                 command[MaxTextLength];t                 static chari                 *Primitives[]=                 {                    "line",(                   "rectangle",#                   "fill rectangle",-                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */P               primitive=XMenuWidget(display,windows,DrawModeMenu[id],Primitives,                 command);E               break;
             }w!             case DrawModeColorOp:r
             {s               char*                 color_name[MaxTextLength],,                 *ColorMenu[MaxNumberPens+1];                 inti                 pen_number;s                 /*+                 Initialize menu selections.n               *//               for (i=0; i < MaxNumberPens; i++)o9                 ColorMenu[i]=resource_info->pen_color[i];a6               ColorMenu[MaxNumberPens-1]="Browser...";5               ColorMenu[MaxNumberPens]=(char *) NULL;i               /*8                 Select a pen color from the pop-up menu.               */P               pen_number=XMenuWidget(display,windows,DrawModeMenu[id],ColorMenu,                 color_name);2               if (pen_number == (MaxNumberPens-1))                 {.                   static char_7                     color_name[MaxTextLength] = "gray";                      /*5                     Select a pen color from a dialog.p                   */G                   resource_info->pen_color[MaxNumberPens-1]=color_name;+K                   XColorBrowserWidget(display,windows,"Select",color_name); *                   if (*color_name == '\0')                     break;                 }m"               if (pen_number >= 0)                 {&                   /*"                     Set pen color.                   */$                   pen_id=pen_number;M                   (void) strcpy(color_name,resource_info->pen_color[pen_id]); O                   status=XParseColor(display,windows->image.map_info->colormap,hN                     color_name,&windows->image.pixel_info->pen_color[pen_id]);"                   if (status == 0)2                     XNoticeWidget(display,windows,A                       "Color is unknown to X server",color_name); G                   XBestPixel(display,windows->image.map_info->colormap, 2                     (XColor *) NULL,(unsigned int)G                     Min(windows->image.visual_info->colormap_size,256),eC                     &windows->image.pixel_info->pen_color[pen_id]);l                 }                break;
             }w!             case DrawModeWidthOp:o
             {                char'                 command[MaxTextLength];                  intw                 entry;                 static charS                 *WidthsMenu[]=                 {,                   "1",                   "2",                   "4",                   "6",                   "8",                    (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               WidthsMenu[5]="Dialog...";L               entry=XMenuWidget(display,windows,DrawModeMenu[id],WidthsMenu,                 command);                if (entry < 0)                 break;               if (entry != 5) 3                 line_width=atoi(WidthsMenu[entry]);I               else                 { -                   (void) strcpy(command,"3");iI                   XDialogWidget(display,windows,"Ok","Enter line width:",a                     command); '                   if (*command == '\0')R                     break;+                   line_width=atoi(command);y                 }                break;
             }d              case DrawModeUndoOp:
             {fD               (void) XMagickCommand(display,resource_info,windows,0,%                 (KeySym) XK_u,image);-               break;
             }i              case DrawModeHelpOp:
             {WB               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);>               XDefineCursor(display,windows->image.id,cursor);               break;
             } "             case DrawModeReturnOp:
             {                /*!                 Prematurely exit.M               */!               state|=EscapeState;i               state|=ExitState;                break;
             }x             default:               break;           };:           XDefineCursor(display,windows->image.id,cursor);           continue; 	         }        switch (event.type)n       {          case ButtonPress:(	         { 6           if (event.xbutton.window == windows->pan.id)
             {i0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }            /*             Exit loop.           */           x=event.xbutton.x;           y=event.xbutton.y;           state|=ExitState;.           break;	         }f         case ButtonRelease:            break;         case Expose:           break;         case KeyPress:	         {f           char#             command[MaxTextLength];o             KeySym             key_symbol;              /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command,yA             sizeof(command),&key_symbol,(XComposeStatus *) NULL);f           switch (key_symbol)            {l             case XK_Escape:              case XK_F20:
             {                /*!                 Prematurely exit.W               */!               state|=EscapeState;s               state|=ExitState;u               break;
             }              case XK_F1:              case XK_Help: 
             { B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);               break;
             }_             default:
             {a               XBell(display,0);                break;
             }i           }x           break;	         };         case MotionNotify:	         {n           /*2             Discard pending pointer motion events.           */D           while (XCheckMaskEvent(display,PointerMotionMask,&event));           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)*
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height)))wO                 XWithdrawWindow(display,windows->info.id,windows->info.screen);m
             }o           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height)))e3               XMapWindow(display,windows->info.id);            break;	         }        } #     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);o     if (state & EscapeState)       break;     /*K       Draw line or rectangle as pointer moves until the button is released.H     */     line_info.x1=x;c     line_info.y1=y;>     line_info.x2=x;x     line_info.y2=y;      distance=0;      degrees=0.0;     rectangle_info.x=x;u     rectangle_info.y=y;      rectangle_info.width=0;      rectangle_info.height=0;D     XSetFunction(display,windows->image.highlight_context,GXinvert);     state=DefaultState;r     do     {        switch (primitive)       {          case LinePrimitive:          default:	         {            if (distance > 9) 
             {                /*+                 Display angle of line line.i               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2-;E                 line_info.y1),(double) (line_info.x2-line_info.x1)));;3               (void) sprintf(text," %.2f",degrees);!0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,w=                 windows->image.highlight_context,&line_info);o
             }>           else%             if (windows->info.mapped)iM               XWithdrawWindow(display,windows->info.id,windows->info.screen);            break;	         }y          case RectanglePrimitive:$         case FillRectanglePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {x               /*>                 Display info and draw rectangleping rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);y0               XInfoWidget(display,windows,text);9               XHighlightRegion(display,windows->image.id, B                 windows->image.highlight_context,&rectangle_info);
             }.           else%             if (windows->info.mapped)oM               XWithdrawWindow(display,windows->info.id,windows->info.screen);            break;	         }+       }.       /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);<       switch (primitive)       {l         case LinePrimitive:(         default:	         {o           if (distance > 9)y5             XHighlightLine(display,windows->image.id, ;               windows->image.highlight_context,&line_info);            break;	         }U          case RectanglePrimitive:$         case FillRectanglePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))7             XHighlightRegion(display,windows->image.id, @               windows->image.highlight_context,&rectangle_info);           break;	         }i       }n       switch (event.type)n       {.         case ButtonPress:            break;         case ButtonRelease:d	         {            /*,             User has committed to primitive.           */'           line_info.x2=event.xbutton.x;n'           line_info.y2=event.xbutton.y;n+           rectangle_info.x=event.xbutton.x; +           rectangle_info.y=event.xbutton.y;            state|=ExitState;d           break;	         }          case Expose:           break;         case MotionNotify:	         {n           /*1             Discard pending button motion events.i           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));o'           line_info.x2=event.xmotion.x;('           line_info.y2=event.xmotion.y;a+           rectangle_info.x=event.xmotion.x; +           rectangle_info.y=event.xmotion.y;a	         }n         default:           break;       }S       /*"         Check boundary conditions.       */       if (line_info.x2 < 0)a         line_info.x2=0; 
       else0         if (line_info.x2 > windows->image.width),           line_info.x2=windows->image.width;       if (line_info.y2 < 0)d         line_info.y2=0; 
       else1         if (line_info.y2 > windows->image.height) -           line_info.y2=windows->image.height;o       distance= F         ((line_info.x2-line_info.x1+1)*(line_info.x2-line_info.x1+1))+F         ((line_info.y2-line_info.y1+1)*(line_info.y2-line_info.y1+1));=       if ((rectangle_info.x != x) && (rectangle_info.y != y))y	         { #           if (rectangle_info.x < 0)t             rectangle_info.x=0;            else8             if (rectangle_info.x > windows->image.width)4               rectangle_info.x=windows->image.width;#           if (rectangle_info.x < x) E             rectangle_info.width=(unsigned int) (x-rectangle_info.x);o           else
             {iG               rectangle_info.width=(unsigned int) (rectangle_info.x-x); !               rectangle_info.x=x;i
             }i#           if (rectangle_info.y < 0)              rectangle_info.y=0;-           else9             if (rectangle_info.y > windows->image.height)w5               rectangle_info.y=windows->image.height; #           if (rectangle_info.y < y)+F             rectangle_info.height=(unsigned int) (y-rectangle_info.y);           else
             { H               rectangle_info.height=(unsigned int) (rectangle_info.y-y);!               rectangle_info.y=y; 
             }(	         }a#     } while (!(state & ExitState)); B     XSetFunction(display,windows->image.highlight_context,GXcopy);     if (distance <= 9)       continue;      /*1       Drawing is relative to image configuration.      */$     if (line_info.x2 < line_info.x1)&       Swap(line_info.x1,line_info.x2);     draw_info.x=line_info.x1;($     if (line_info.y2 < line_info.y1)&       Swap(line_info.y1,line_info.y2);     draw_info.y=line_info.y1;sM     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_Select,s
       image);      x=0;     y=0;     width=(*image)->columns;     height=(*image)->rows;6     if (windows->image.crop_geometry != (char *) NULL)O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);a9     x_factor=UpShift(width)/windows->image.ximage->width;N4     draw_info.x+=windows->image.x-(line_width >> 1);0     draw_info.x=DownShift(draw_info.x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height; 4     draw_info.y+=windows->image.y-(line_width >> 1);0     draw_info.y=DownShift(draw_info.y*y_factor);;     draw_info.width=rectangle_info.width+(line_width << 1);e=     draw_info.height=rectangle_info.height+(line_width << 1);f4     (void) sprintf(draw_info.geometry,"%ux%u%+d%+d",9       (unsigned int) DownShift(draw_info.width*x_factor),U:       (unsigned int) DownShift(draw_info.height*y_factor),#       draw_info.x+x,draw_info.y+y);t"     draw_info.primitive=primitive;+     draw_info.line_info.x1=line_width >> 1;nG     draw_info.line_info.x2=line_info.x2-line_info.x1+(line_width >> 1); +     draw_info.line_info.y1=line_width >> 1;gG     draw_info.line_info.y2=line_info.y2-line_info.y1+(line_width >> 1); /     draw_info.rectangle_info.x=line_width >> 1;%/     draw_info.rectangle_info.y=line_width >> 1; 8     draw_info.rectangle_info.width=rectangle_info.width;:     draw_info.rectangle_info.height=rectangle_info.height;$     draw_info.line_width=line_width;     draw_info.degrees=0.0;.     windows->image.pixel_info->annotate_color=3       windows->image.pixel_info->pen_color[pen_id];      /*       Draw primitive on image.     *//     XInfoWidget(display,windows,DrawImageText); *     XSetCursorState(display,windows,True);*     XCheckRefreshWindows(display,windows);K     status=XDrawImage(display,windows->image.pixel_info,&draw_info,*image); +     XSetCursorState(display,windows,False);%     /*8       Update image colormap and return to image drawing.     */B     XConfigureImageColormap(display,resource_info,windows,*image);A     (void) XConfigureImage(display,resource_info,windows,*image);e   } A   XWithdrawWindow(display,windows->info.id,windows->info.screen);F)   XSetCursorState(display,windows,False);e   return(status);d }F e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             % O %                                                                             %eO %                                                                             %.O %   X D r a w P a n R e c t a n g l e                                         % O %                                                                             %wO %                                                                             %WO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%1 %dK %  Function XDrawPanRectangle draws a rectangle in the pan window.  The pan J %  window displays a scaled image and the rectangle shows which portion of. %  the image is displayed in the Image window. % 2 %  The format of the XDrawPanRectangle routine is: %h' %    XDrawPanRectangle(display,windows)t %x+ %  A description of each parameter follows:n % E %    o display: Specifies a connection to an X server;  returned fromf %      XOpenDisplay. %i< %    o windows: Specifies a pointer to a XWindows structure. %v %; */. static void XDrawPanRectangle(display,windows) Displayn   *display;    XWindows   *windows;; {    unsigned longd     scale_factor;,     RectangleInfot     highlight_info;s     /*2     Determine dimensions of the panning rectangle.   */   scale_factor=(unsigned long)?     (UpShift(windows->pan.width)/windows->image.ximage->width); <   highlight_info.x=DownShift(windows->image.x*scale_factor);D   highlight_info.width=DownShift(windows->image.width*scale_factor);   scale_factor=(unsigned long)A     (UpShift(windows->pan.height)/windows->image.ximage->height);t<   highlight_info.y=DownShift(windows->image.y*scale_factor);F   highlight_info.height=DownShift(windows->image.height*scale_factor);   /*"     Display the panning rectangle.   */(   XClearWindow(display,windows->pan.id);I   XHighlightRegion(display,windows->pan.id,windows->pan.annotate_context,t     &highlight_info);o }c _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             % O %                                                                             %dO %   X E m b o s s I m a g e                                                   %nO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %t+ %  Function XEmbossImage embosses an image.t %E- %  The format of the XEmbossImage routine is:  % = %    status=XEmbossImage(display,resource_info,windows,image)a % + %  A description of each parameter follows:  %tD %    o status: Function XEmbossImage return True if the edges withinF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.W %eD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %n< %    o windows: Specifies a pointer to a XWindows structure. %oF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.n %  %  */E static unsigned int XEmbossImage(display,resource_info,windows,image)| Displaye   *display;   
 XResourceInfo    *resource_info;;   XWindows   *windows;p   Image 
   **image; { 1 #define EmbossImageText  "  Embossing image...  "e     Imageu     *embossed_image;     /*     Emboss image scanlines.K   *//   XInfoWidget(display,windows,EmbossImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);%   embossed_image=EmbossImage(*image); )   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);|'   if (embossed_image == (Image *) NULL)a     return(False);   DestroyImage(*image);    *image=embossed_image;   if (windows->image.orphan)     return(True);V   /*     Update image configuration.,   */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);( }p , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %eO %                                                                             %nO %                                                                             % O %   X E d g e I m a g e                                                       % O %                                                                             %fO %                                                                             %.O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %f5 %  Function XEdgeImage detects edges within an image.w %i+ %  The format of the XEdgeImage routine is:y %n; %    status=XEdgeImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:r %;B %    o status: Function XEdgeImage return True if the edges withinF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.t % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %(K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.u %r< %    o windows: Specifies a pointer to a XWindows structure. %>F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.e %n %  */C static unsigned int XEdgeImage(display,resource_info,windows,image)f Display    *display;t  
 XResourceInfof   *resource_info;t   XWindows   *windows;S   Imaget
   **image; {s/ #define EdgeImageText  "  Detecting edges...  "n     Imagei     *edged_image;      /*     Edge image scanlines.c   */-   XInfoWidget(display,windows,EdgeImageText);s(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);    edged_image=EdgeImage(*image);)   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);/$   if (edged_image == (Image *) NULL)     return(False);   DestroyImage(*image);    *image=edged_image;r   if (windows->image.orphan)     return(True);w   /*     Update image configuration.s   */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);f   return(True);  }  t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             %dO %                                                                             % O %                                                                             %gO %   X F l i p I m a g e                                                       % O %                                                                             %%O %                                                                             %iO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %sH %  Function XFlipImage flips the scanlines of an image in the horizontal
 %  direction.o %e+ %  The format of the XFlipImage routine is:i %r; %    status=XFlipImage(display,resource_info,windows,image)n %s+ %  A description of each parameter follows:t % F %    o status: Function XFlipImage return True if the window scanlinesJ %      reverse.  False is returned is there is a memory shortage or if the) %      window scanlines fails to reverse.a %oD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.w %h< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.m %( %p */C static unsigned int XFlipImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;d   XWindows   *windows;n   Image 
   **image; {.. #define FlipImageText  "  Flipping image...  "     Image      *flipped_image;B     /*     Flip image scanlines.    */-   XInfoWidget(display,windows,FlipImageText);a(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   flipped_image=FlipImage(*image);)   XSetCursorState(display,windows,False);(A   XWithdrawWindow(display,windows->info.id,windows->info.screen);;&   if (flipped_image == (Image *) NULL)     return(False);   DestroyImage(*image);,   *image=flipped_image; 4   if (windows->image.crop_geometry != (char *) NULL)     { 	       int 
         x,
         y;         unsigned int         height,M         width;         /*         Flip crop geometry.r       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);tM       (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,x/         x,(int) (*image)->rows-(int) height-y);x     }y   if (windows->image.orphan)     return(True);;   /*     Update image configuration.)   */?   (void) XConfigureImage(display,resource_info,windows,*image);o   return(True);. }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %fO %                                                                             %rO %                                                                             % O %   X F l o p I m a g e                                                       %iO %                                                                             %=O %                                                                             % O %                                                                             %.O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l % H %  Function XFlopImage flops the scanlines of an image in the horizontal
 %  direction.  % + %  The format of the XFlopImage routine is:  % ; %    status=XFlopImage(display,resource_info,windows,image)o %>+ %  A description of each parameter follows:v %_F %    o status: Function XFlopImage return True if the window scanlinesJ %      reverse.  False is returned is there is a memory shortage or if the) %      window scanlines fails to reverse.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %nK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.n %x< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.. %  %  */C static unsigned int XFlopImage(display,resource_info,windows,image)f Display=   *display;i  
 XResourceInfo=   *resource_info;    XWindows   *windows;e   Image 
   **image; {S. #define FlopImageText  "  Flopping image...  "     Imagen     *flopped_image;g     /*     Flop image scanlines.l   */-   XInfoWidget(display,windows,FlopImageText);y(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   flopped_image=FlopImage(*image);)   XSetCursorState(display,windows,False);(A   XWithdrawWindow(display,windows->info.id,windows->info.screen);*&   if (flopped_image == (Image *) NULL)     return(False);   DestroyImage(*image);X   *image=flopped_image;d4   if (windows->image.crop_geometry != (char *) NULL)     { 	       inte
         x,
         y;         unsigned int         height,i         width;         /*         Flop crop geometry.S       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); M       (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,o1         (int) (*image)->columns-(int) width-x,y);e     }i   if (windows->image.orphan)     return(True);e   /*     Update image configuration.    */?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             % O %                                                                             % O %   X L o a d I m a g e                                                       % O %                                                                             % O %                                                                             %,O %                                                                             %!O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %x2 %  Function XLoadImage loads an image from a file. % + %  The format of the XLoadImage routine is:> %rI %    loaded_image=XLoadImage(display,resource_info,windows,command,image)> %r+ %  A description of each parameter follows:  % J %    o loaded_image: Function XLoadImage returns an image if can be loaded9 %      successfully.  Otherwise a null image is returned.i %aD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %t< %    o windows: Specifies a pointer to a XWindows structure. %RK %    o command: A value other than zero indicates that the file is selectedi+ %      from the command line argument list.n %tF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.o %l %) */E static Image *XLoadImage(display,resource_info,windows,command,image)  Displayy   *display;.  
 XResourceInfoy   *resource_info;D   XWindows   *windows;    unsigned int
   command;   Image+	   *image;e {t   char     filename[MaxTextLength];     Image;     *loaded_image;     ImageInfo      image_info;(     /*      Request file name from user.   */*   (void) strcpy(filename,image->filename);   if (!command)&8     XFileBrowserWidget(display,windows,"Load",filename);   else     { 
       char         **filelist,f         **files;  	       int          count,         status;C         register int
         i,
         j;         /*0         Select next image from the command line.       */B       status=XGetCommand(display,windows->image.id,&files,&count);       if (!status)	         { A           Warning("Unable to select image","XGetCommand failed"); !           return((Image *) NULL);"	         } 6       filelist=(char **) malloc(count*sizeof(char *));%       if (filelist == (char **) NULL)d	         { G           Warning("Unable to select image","Memory allocation failed");R!           XFreeStringList(files);e!           return((Image *) NULL); 	         }n
       j=0;       for (i=1; i < count; i++)          if (*files[i] != '-')=!           filelist[j++]=files[i];p        filelist[j]=(char *) NULL;J       XListBrowserWidget(display,windows,&windows->widget,filelist,"Load",*         "Select Image to Load:",filename);       free((char *) filelist);       XFreeStringList(files);a     }    if (*filename == '\0')     return((Image *) NULL);)   GetImageInfo(&image_info);.   (void) strcpy(image_info.filename,filename);   SetImageMagick(&image_info);)   if (strcmp(image_info.magick,"X") == 0)      {a
       char         seconds[MaxTextLength];          /*8         User may want to delay the X server screen grab.       */!       (void) strcpy(seconds,"0"); I       XDialogWidget(display,windows,"Grab","Enter any delay in seconds:",t         seconds); "       (void) sleep(atoi(seconds));     }f   /*     Load the image.    */-   XInfoWidget(display,windows,LoadImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);4   loaded_image=ReadImage(resource_info->image_info);)   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);;%   if (loaded_image != (Image *) NULL)aC     XClientMessage(display,windows->image.id,windows->im_protocols, *       windows->im_next_image,CurrentTime);   else     {M
       char         *text,         **textlist;;  
       FILE         *file;  	       int*
         c;         register chard         *p;u         unsigned int         length;          /*         Unknown image format.        */(       file=(FILE *) fopen(filename,"r");        if (file == (FILE *) NULL)         return((Image *) NULL);+       length=MaxTextLength; 0       text=(char *) malloc(length*sizeof(char));/       for (p=text ; text != (char *) NULL; p++)        {          c=fgetc(file);         if (c == EOF)i           break;!         if ((p-text+1) >= length)+           {.             *p='\0';             length<<=1;nE             text=(char *) realloc((char *) text,length*sizeof(char)); &             if (text == (char *) NULL)               break;              p=text+strlen(text);           }a         *p=(unsigned char) c;r       }a       (void) fclose(file);        if (text == (char *) NULL)         return((Image *) NULL);g       *p='\0';"       textlist=StringToList(text);%       if (textlist != (char **) NULL)x	         {            char!             title[MaxTextLength];d             register int             i;  >           (void) sprintf(title,"Unknown format: %s",filename);M           XTextViewWidget(display,resource_info,windows,True,title,textlist);i6           for (i=0; textlist[i] != (char *) NULL; i++)'             free((char *) textlist[i]);i"           free((char *) textlist);	         }t       free((char *) text);     }i   return(loaded_image);w }i e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %;O %                                                                             %%O %                                                                             % O %   X M a g i c k C o m m a n d                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XMagickCommand makes a transform to the image or Image window : %  as specified by a user menu button or keyboard command. %%/ %  The format of the XMagickCommand routine is:% %%E %    loaded_image=XMagickCommand(display,resource_info,windows,state,T %      key_symbol,image) %u+ %  A description of each parameter follows:e %rG %    o loaded_image:  Function XMagickCommand returns an image when the I %      user chooses 'Load Image' from the command menu.  Otherwise a nullc %      image is returned.s %eD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %fK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %r< %    o windows: Specifies a pointer to a XWindows structure. %e %    o state: key mask.p %f2 %    o key_symbol: Specifies a command to perform. %eG %    o image: Specifies a pointer to a Image structure;  XMagickCommanda> %      may transform the image and return a new image pointer. %f %i */L static Image *XMagickCommand(display,resource_info,windows,state,key_symbol,   image) Display    *display;i  
 XResourceInfon   *resource_info;C   XWindows   *windows;n   unsigned int   state;   KeySym
   key_symbol;f   Imagef
   **image; { ? #define ApplyTransformsText  "  Applying image transforms...  " = #define DullContrastText  "  Dulling the image contrast...  " C #define GrayImageText  "  Converting the image colors to gray...  " F #define HistogramEqualizeText  "  Equalizing the image histogram...  "H #define HistogramNormalizeText  "  Normalizing the image histogram...  "; #define NegateImageText  "  Negating the image colors...  " 7 #define SegmentImageText  "  Segmenting the image...  " C #define SharpenContrastText  "  Sharpening the image contrast...  "      typedef struct _ImageState   {      unsigned int       width,
       height;r       char       *crop_geometry;n  	     Image 
       *image;i   } ImageState;i     char     geometry[MaxTextLength];     Image=     *loaded_image;  
   static chari     delta[MaxTextLength] = "",     Digits[]="01234567890";n     static KeySym      last_symbol = XK_0;w     static ImageStates7     undo_image = {0, 0, (char *) NULL, (Image *) NULL};m     unsigned int     status;n  (   XCheckRefreshWindows(display,windows);3   if ((key_symbol >= XK_0) && (key_symbol <= XK_9))w     {><       if (!((last_symbol >= XK_0) && (last_symbol <= XK_9)))         *delta='\0';       last_symbol=key_symbol;r"       delta[strlen(delta)+1]='\0';3       delta[strlen(delta)]=Digits[key_symbol-XK_0];e       return((Image *) NULL);M     }    last_symbol=key_symbol;o6   if ((key_symbol == XK_u) || (key_symbol == XK_Undo))     {        /*+         Undo the last image transformation.        */-       if (undo_image.image == (Image *) NULL) 	         {W           XBell(display,0); !           return((Image *) NULL);x	         } ;       windows->image.window_changes.width=undo_image.width;w=       windows->image.window_changes.height=undo_image.height; 8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);<       windows->image.crop_geometry=undo_image.crop_geometry;       DestroyImage(*image);h       *image=undo_image.image;-       undo_image.crop_geometry=(char *) NULL;T&       undo_image.image=(Image *) NULL;        if (windows->image.orphan)         return((Image *) NULL);pD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        return((Image *) NULL);E     }a   if (!(state & Mod5Mask))     switch (key_symbol)a     {        case XK_Up:        case XK_KP_Up:       case XK_Down:        case XK_KP_Down:       case XK_Left:.       case XK_KP_Left:       case XK_Right:       case XK_KP_Right:b       {d          if (!(state & Mod1Mask))           break;       }i       case XK_F3:t       case XK_F5:f       case XK_A:       case XK_less:        case XK_o:       case XK_greater:       case XK_percent:       case XK_t:       case XK_bracketright:        case XK_minus:       case XK_bar:       case XK_slash:       case XK_backslash:       case XK_asterisk:e       case XK_s:       case XK_asciitilde:>       case XK_equal:       case XK_N:       case XK_F7:m       case XK_F8:.       case XK_F9:t       case XK_g:       case XK_F10:       case XK_F11:       case XK_D:       case XK_P:       case XK_S:       case XK_B:       case XK_E:       case XK_M:       case XK_O:       case XK_Z:       case XK_G:       case XK_numbersign:        case XK_R:       case XK_a:       case XK_b:       case XK_x:       case XK_exclam:        case XK_Select:        { 
         /*+           Save image before transformation. 
         */.         XSetCursorState(display,windows,True);.         XCheckRefreshWindows(display,windows);6         undo_image.width=windows->image.ximage->width;8         undo_image.height=windows->image.ximage->height;6         if (undo_image.crop_geometry != (char *) NULL)2           free((char *) undo_image.crop_geometry);>         undo_image.crop_geometry=windows->image.crop_geometry;:         if (windows->image.crop_geometry != (char *) NULL)           { -             undo_image.crop_geometry=(char *) 1               malloc(MaxTextLength*sizeof(char)); :             if (undo_image.crop_geometry != (char *) NULL)5               (void) strcpy(undo_image.crop_geometry,s.                 windows->image.crop_geometry);           } /         if (undo_image.image != (Image *) NULL) )           DestroyImage(undo_image.image);o         (*image)->orphan=True;         undo_image.image=.B           CopyImage(*image,(*image)->columns,(*image)->rows,True);         (*image)->orphan=False; /         XSetCursorState(display,windows,False);          break;       }n       default:         break;     }n   /*     Process user command.    */   loaded_image=(Image *) NULL;C   windows->image.window_changes.width=windows->image.ximage->width;iE   windows->image.window_changes.height=windows->image.ximage->height;)   switch (key_symbol)w   {s     case XK_l:     {u       /*         Load image.        */J       loaded_image=XLoadImage(display,resource_info,windows,False,*image);       break;     }c     case XK_n:     case XK_space:     {m       /*         Display next image.t       */E       XClientMessage(display,windows->image.id,windows->im_protocols, ,         windows->im_next_image,CurrentTime);       break;     }r     case XK_f:     case XK_KP_Prior:r     case XK_BackSpace:     {o       /*         Display former image.i       */E       XClientMessage(display,windows->image.id,windows->im_protocols,o.         windows->im_former_image,CurrentTime);       break;     }      case XK_F2:e     {u       /*         Select image.i       */I       loaded_image=XLoadImage(display,resource_info,windows,True,*image);        break;     }u     case XK_w:     {r       /*         Write image.       */>       status=XWriteImage(display,resource_info,windows,image);       if (status == False)	         {fC           XNoticeWidget(display,windows,"Unable to write X image:",l              (*image)->filename);           break;	         }i       break;     }u     case XK_p:     {        /*         Print image.       */>       status=XPrintImage(display,resource_info,windows,image);       if (status == False)	         {pC           XNoticeWidget(display,windows,"Unable to print X image:",.              (*image)->filename);           break;	         }n       break;     }      case XK_asciicircum:     {.
       char          filename[MaxTextLength];         /*         Delete image file.       */2       (void) sprintf(filename,(*image)->filename);<       XFileBrowserWidget(display,windows,"Delete",filename);       if (*filename == '\0')         break;       status=unlink(filename);       if (status != False)O         XNoticeWidget(display,windows,"Unable to delete image file:",filename);v       break;     }n     case XK_C:     {        ImageInfo          image_info;t         static charo,         geometry[MaxTextLength] = "640x480";         /*         Create canvas.       */P       XDialogWidget(display,windows,"Canvas","Enter canvas geometry:",geometry);       if (*geometry == '\0')         break;        GetImageInfo(&image_info);/       (void) strcpy(image_info.filename,"xc:");o       image_info.size=geometry;e*       loaded_image=ReadImage(&image_info);)       free((char *) image_info.filename);mE       XClientMessage(display,windows->image.id,windows->im_protocols,h,         windows->im_next_image,CurrentTime);       break;     }      case XK_comma:     {        static char #         delay[MaxTextLength] = "5";r         /*)         Display next image after pausing.p       */       resource_info->delay=0;t1       XDialogWidget(display,windows,"Slide Show", 8         "Pause how many seconds between images:",delay);       if (*delay == '\0')          break;'       resource_info->delay=atoi(delay); E       XClientMessage(display,windows->image.id,windows->im_protocols, ,         windows->im_next_image,CurrentTime);       break;     }      case XK_V:     {i       /*         Visual Image directory.        */H       loaded_image=XVisualDirectoryImage(display,resource_info,windows);       break;     }g     case XK_F3:.     {        /*         Cut image.       */=       (void) XCutImage(display,resource_info,windows,*image);c       break;     }n     case XK_F4:/     {        /*         Copy image.+       */>       (void) XCopyImage(display,resource_info,windows,*image);       break;     }t     case XK_F5:w     {)       /*         Paste image.       */?       status=XPasteImage(display,resource_info,windows,*image);n       if (status == False)	         {,B           XNoticeWidget(display,windows,"Unable to paste X image",              (*image)->filename);           break;	         };       break;     }N     case XK_A:     { 
       char&         image_geometry[MaxTextLength];  <       if ((windows->image.crop_geometry == (char *) NULL) &&@           ((*image)->columns == windows->image.ximage->width) &&>           ((*image)->rows == windows->image.ximage->height) &&.           (resource_info->number_colors == 0))         break;       /*'         Apply size transforms to image.        */7       XInfoWidget(display,windows,ApplyTransformsText);n,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       /**         Crop and/or scale displayed image.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height);iH       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         {o6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL; 	         }o       windows->image.x=0;>       windows->image.y=0;_,       if (resource_info->number_colors != 0)	         {_           /*5             Reduce the number of colors in the image.y           */1           if (((*image)->class == DirectClass) ||=B               ((*image)->colors > resource_info->number_colors) ||<               (resource_info->colorspace == GRAYColorspace))>             QuantizeImage(*image,resource_info->number_colors,>               resource_info->tree_depth,resource_info->dither,)               resource_info->colorspace);            SyncImage(*image);	         }eD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }e     case XK_less:      {        /*         Half image size.       */L       windows->image.window_changes.width=windows->image.ximage->width >> 1;N       windows->image.window_changes.height=windows->image.ximage->height >> 1;C       (void) XConfigureImage(display,resource_info,windows,*image);(       break;     }      case XK_o:     {o       /*         Original image size.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;C       (void) XConfigureImage(display,resource_info,windows,*image);E       break;     }S     case XK_greater:     {i       /*         Double the image size.       */L       windows->image.window_changes.width=windows->image.ximage->width << 1;N       windows->image.window_changes.height=windows->image.ximage->height << 1;C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     }i     case XK_percent:     {;       unsigned int         height,          width;         /*         Resize image.        */)       width=windows->image.ximage->width; +       height=windows->image.ximage->height;r4       (void) sprintf(geometry,"%ux%u",width,height);-       XDialogWidget(display,windows,"Resize",n@         "Enter resize geometry (e.g. 640x480, 200%):",geometry);       if (*geometry == '\0')         break;2       ParseImageGeometry(geometry,&width,&height);0       windows->image.window_changes.width=width;2       windows->image.window_changes.height=height;C       (void) XConfigureImage(display,resource_info,windows,*image);p       break;     }      case XK_r:     {        /*2         Restore Image window to its original size.       */8       if ((windows->image.width == (*image)->columns) &&6           (windows->image.height == (*image)->rows) &&:           (windows->image.crop_geometry == (char *) NULL))	         {h           XBell(display,0);            break;	         } <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         { 6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;            windows->image.x=0;n           windows->image.y=0;e	         }uD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);c       break;     }r     case XK_at:      { C       (void) XConfigureImage(display,resource_info,windows,*image);y       break;     }h     case XK_bracketleft:     {t       /*         Crop image.        */>       (void) XCropImage(display,resource_info,windows,*image);       break;     }l     case XK_bracketright:<     {n       /*         Chop image.        */=       status=XChopImage(display,resource_info,windows,image);        if (status == False)	         {.@           XNoticeWidget(display,windows,"Unable to cut X image",              (*image)->filename);           break;	         }_       break;     }+     case XK_bar:     {        /*         Flop image scanlines.l       */=       status=XFlopImage(display,resource_info,windows,image);o       if (status == False)	         { A           XNoticeWidget(display,windows,"Unable to flop X image",t              (*image)->filename);           break;	         }        break;     }n     case XK_minus:     {a       /*         Flip image scanlines.t       */=       status=XFlipImage(display,resource_info,windows,image);t       if (status == False)	         {_A           XNoticeWidget(display,windows,"Unable to flip X image",t              (*image)->filename);           break;	         }        break;     }      case XK_slash:     {        /**         Rotate image 90 degrees clockwise.       */D       status=XRotateImage(display,resource_info,windows,90.0,image);       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",.              (*image)->filename);           break;	         }t       break;     }h     case XK_backslash:     {s       /*2         Rotate image 90 degrees counter-clockwise.       */E       status=XRotateImage(display,resource_info,windows,-90.0,image);s       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",,              (*image)->filename);           break;	         }r       break;     }      case XK_asterisk:e     {o       /*         Rotate image.        */C       status=XRotateImage(display,resource_info,windows,0.0,image);        if (status == False)	         {aC           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }t       break;     }      case XK_s:     {n       /*         Shear image.       */>       status=XShearImage(display,resource_info,windows,image);       if (status == False)	         { B           XNoticeWidget(display,windows,"Unable to shear X image",              (*image)->filename);           break;	         },       break;     },     case XK_t:     {        /*         Trim image.m       */>       status=XTrimImage(display,resource_info,windows,*image);       if (status == False)	         {;A           XNoticeWidget(display,windows,"Unable to trim X image",               (*image)->filename);           break;	         }        break;     }r     case XK_F7:      { 
       char          modulate[MaxTextLength];         static char )         hue_percent[MaxTextLength] = "3";e         /*         Vary the image hue./       */,       XDialogWidget(display,windows,"Apply",:         "Enter percent change in image hue:",hue_percent);       if (*hue_percent == '\0')          break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);)       (void) strcpy(modulate,"0.0,0.0,"); *       (void) strcat(modulate,hue_percent);%       ModulateImage(*image,modulate);d-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);(       break;     }w     case XK_F8:e     { 
       char          modulate[MaxTextLength];         static char 1         saturation_percent[MaxTextLength] = "10";          /*"         Vary the color saturation.       */,       XDialogWidget(display,windows,"Apply",H         "Enter percent change in color saturation:",saturation_percent);&       if (*saturation_percent == '\0')         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);%       (void) strcpy(modulate,"0.0,");w1       (void) strcat(modulate,saturation_percent);.%       ModulateImage(*image,modulate); -       XSetCursorState(display,windows,False);u        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     };     case XK_F9:      {=       static char 0         brightness_percent[MaxTextLength] = "3";         /*"         Vary the color brightness.       */,       XDialogWidget(display,windows,"Apply",H         "Enter percent change in color brightness:",brightness_percent);&       if (*brightness_percent == '\0')         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);/       ModulateImage(*image,brightness_percent); -       XSetCursorState(display,windows,False);;        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }s     case XK_g:     {g       static charc%         gamma[MaxTextLength] = "1.6";)         /*         Gamma correct image.       */H       XDialogWidget(display,windows,"Gamma","Enter gamma value:",gamma);       if (*gamma == '\0')x         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       GammaImage(*image,gamma); -       XSetCursorState(display,windows,False);a        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }p     case XK_F10:     {,       /*#         Sharpen the image contrast.u       */7       XInfoWidget(display,windows,SharpenContrastText);%,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);!       ContrastImage(*image,True);        XDelay(display,2000); E       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_F11:     {        /*          Dull the image contrast.       */4       XInfoWidget(display,windows,DullContrastText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);"       ContrastImage(*image,False);       XDelay(display,2000);tE       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);r       break;     }      case XK_equal:     {i       /*4         Perform histogram equalization on the image.       */9       XInfoWidget(display,windows,HistogramEqualizeText); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       EqualizeImage(*image);       XDelay(display,2000); E       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }i     case XK_N:     {        /*5         Perform histogram normalization on the image.f       */:       XInfoWidget(display,windows,HistogramNormalizeText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       NormalizeImage(*image);i       XDelay(display,2000);tE       XWithdrawWindow(display,windows->info.id,windows->info.screen);p-       XSetCursorState(display,windows,False);l        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);,       break;     },     case XK_asciitilde:g     {e       /*         Negate colors in image.        */3       XInfoWidget(display,windows,NegateImageText);%,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       NegateImage(*image);       XDelay(display,2000); E       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_F12:     {        /*2         Toggle X colormap type: Shared or Private.       */4       if (resource_info->colormap == SharedColormap)	         {%2           resource_info->colormap=PrivateColormap;F           XNoticeWidget(display,windows,"X Colormap Type:","Private");	         }a
       else	         {e1           resource_info->colormap=SharedColormap; E           XNoticeWidget(display,windows,"X Colormap Type:","Shared"); 	         }i       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);        (*image)->orphan=False;o)       if (loaded_image != (Image *) NULL)1G         XClientMessage(display,windows->image.id,windows->im_protocols,a.           windows->im_next_image,CurrentTime);       break;     }v     case XK_D:     {m       /*(         Reduce speckles within an image.       */B       status=XDespeckleImage(display,resource_info,windows,image);       if (status == False)	         {nD           XNoticeWidget(display,windows,"Unable to reduce speckles",              (*image)->filename);           break;	         }o       break;     }      case XK_P:     {e       /*%         Reduce noise within an image.        */>       status=XNoisyImage(display,resource_info,windows,image);       if (status == False)	         {wA           XNoticeWidget(display,windows,"Unable to reduce noise",d              (*image)->filename);           break;	         }d       break;     }X     case XK_S:     {w       /*         Sharpen an image.w       */@       status=XSharpenImage(display,resource_info,windows,image);       if (status == False)	         {cA           XNoticeWidget(display,windows,"Unable to detect edges",t              (*image)->filename);           break;	         }        break;     }c     case XK_B:     {        /*         Blur an image.       */=       status=XBlurImage(display,resource_info,windows,image);i       if (status == False)	         {(?           XNoticeWidget(display,windows,"Unable to blur image",               (*image)->filename);           break;	         };       break;     }f     case XK_E:     {        /*%         Detect edges within an image."       */=       status=XEdgeImage(display,resource_info,windows,image);d       if (status == False)	         {sA           XNoticeWidget(display,windows,"Unable to detect edges",e              (*image)->filename);           break;	         })       break;     }d     case XK_M:     {e       /*         Emboss an image.       */?       status=XEmbossImage(display,resource_info,windows,image);a       if (status == False)	         {sA           XNoticeWidget(display,windows,"Unable to emboss image",m              (*image)->filename);           break;	         }o       break;     }p     case XK_O:     {U       /*         Oil painting an image.       */A       status=XOilPaintImage(display,resource_info,windows,image);p       if (status == False)	         { D           XNoticeWidget(display,windows,"Unable to oil paint image",              (*image)->filename);           break;	         }l       break;     }=     case XK_G:     {,       /*#         Convert image to grayscale.V       */1       XInfoWidget(display,windows,GrayImageText);_,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);G       QuantizeImage(*image,256,8,resource_info->dither,GRAYColorspace);t       SyncImage(*image);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);u-       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);_       break;     }=     case XK_numbersign:i     {G       static char &         colors[MaxTextLength] = "256";         /*         Color reduce the image.        */K       XDialogWidget(display,windows,"Quantize","Maximum number of colors:",n         colors);       if (*colors == '\0')         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);7       QuantizeImage(*image,(unsigned int) atoi(colors),s0         resource_info->tree_depth,(unsigned int)I         (strchr(colors,'!') == (char *) NULL),resource_info->colorspace);t       SyncImage(*image);-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);(       break;     }m     case XK_Z:     {        static chare)         threshold[MaxTextLength] = "1.5";m         /*         Segment an image.f       */P       XDialogWidget(display,windows,"Segment","Smoothing threshold:",threshold);       if (*threshold == '\0')o         break;4       XInfoWidget(display,windows,SegmentImageText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);O       SegmentImage(*image,resource_info->colorspace,False,atof(threshold),1.0);t       SyncImage(*image);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);*-       XSetCursorState(display,windows,False);e        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);l       break;     }      case XK_R:     {i       /*D         Apply an image processing technique to a region of interest.       */<       (void) XROIImage(display,resource_info,windows,image);       break;     }u     case XK_a:     {        /*%         Annotate the image with text.        */C       status=_XAnnotateImage(display,resource_info,windows,*image);d       if (status == False)	         {dE           XNoticeWidget(display,windows,"Unable to annotate X image",f              (*image)->filename);           break;	         }w       break;     }      case XK_d:     {t       /*         Draw image.        */>       status=_XDrawImage(display,resource_info,windows,image);       if (status == False)	         {tH           XNoticeWidget(display,windows,"Unable to draw on the X image",              (*image)->filename);           break;	         }        break;     }L     case XK_b:     {        /*         Border an image.       */?       status=XBorderImage(display,resource_info,windows,image);c       if (status == False)	         {wA           XNoticeWidget(display,windows,"Unable to border image",p              (*image)->filename);           break;	         }w       break;     }o     case XK_x:     {w       /*         Composite image.       */C       status=XCompositeImage(display,resource_info,windows,*image);p       if (status == False)	         {iF           XNoticeWidget(display,windows,"Unable to composite X image",              (*image)->filename);           break;	         }p       break;     }a     case XK_c:     {r       /*         Color edit.;       */B       status=XColorEditImage(display,resource_info,windows,image);       if (status == False)	         {iG           XNoticeWidget(display,windows,"Unable to pixel edit X image",n              (*image)->filename);           break;	         }=       break;     }L     case XK_m:     {*       /*         Matte edit.        */B       status=XMatteEditImage(display,resource_info,windows,image);       if (status == False)	         {%G           XNoticeWidget(display,windows,"Unable to matte edit X image",               (*image)->filename);           break;	         }        break;     }      case XK_exclam:      { 
       char         command[MaxTextLength],           filename[MaxTextLength];  
       FILE         *file;         /*         Edit image comment.        */"       TemporaryFilename(filename);.       if ((*image)->comments != (char *) NULL)	         {            register char              *p;   #           file=fopen(filename,"w"); $           if (file == (FILE *) NULL)
             { K               XNoticeWidget(display,windows,"Unable to edit image comment",%                 filename);               break;
             }a5           for (p=(*image)->comments; *p != '\0'; p++)t'             (void) putc((int) *p,file);s!           (void) putc('\n',file);f           (void) fclose(file);	         } 5       (void) sprintf(command,EditorCommand,filename);,9       if (resource_info->editor_command != (char *) NULL)tG         (void) sprintf(command,resource_info->editor_command,filename); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);$       status=SystemCommand(command);       if (status)eN         XNoticeWidget(display,windows,"Unable to edit image comment",command);
       else	         {a1           (void) sprintf(command,"@%s",filename);o'           CommentImage(*image,command); 	         }e       (void) unlink(filename);-       XSetCursorState(display,windows,False);        break;     }      case XK_i:     {n>       XDisplayImageInfo(display,resource_info,windows,*image);       break;     }      case XK_v:     {D,       XNoticeWidget(display,windows,Version,?         "Copyright 1995 E. I. du Pont de Nemours and Company");_       break;     }r     case XK_h:     case XK_F1:      case XK_Help:n     { :       XTextViewWidget(display,resource_info,windows,False,1         "Help Viewer - Display",ImageMagickHelp);o       break;     }k     case XK_q:     {        /*         Exit program.        */E       XClientMessage(display,windows->image.id,windows->im_protocols,,&         windows->im_exit,CurrentTime);       break;     }"     case XK_Next:      case XK_Prior:     case XK_Home:      case XK_KP_Home:     {m9       XTranslateImage(display,windows,*image,key_symbol);        break;     }W     case XK_Up:      case XK_KP_Up:     case XK_Down:      case XK_KP_Down:     case XK_Left:      case XK_KP_Left:     case XK_Right:     case XK_KP_Right:M     {        if (state & Mod1Mask) 	         { 
           int              quantum;             RectangleInfos             crop_info;             /*.             Trim one pixel from edge of image.           */           quantum=1;           if (*delta != '\0')               if (atoi(delta) > 0)"               quantum=atoi(delta);           crop_info.x=0;           crop_info.y=0;7           crop_info.width=windows->image.ximage->width; 9           crop_info.height=windows->image.ximage->height; @           if ((key_symbol == XK_Up) || (key_symbol == XK_KP_Up))
             { -               if (quantum > crop_info.height) )                 quantum=crop_info.height;l(               crop_info.height-=quantum;
             }tD           if ((key_symbol == XK_Down) || (key_symbol == XK_KP_Down))
             { ;               if (quantum > (crop_info.height-crop_info.y))n5                 quantum=crop_info.height-crop_info.y;E#               crop_info.y+=quantum; (               crop_info.height-=quantum;
             } D           if ((key_symbol == XK_Left) || (key_symbol == XK_KP_Left))
             { ,               if (quantum > crop_info.width)(                 quantum=crop_info.width;'               crop_info.width-=quantum;r
             }cF           if ((key_symbol == XK_Right) || (key_symbol == XK_KP_Right))
             { :               if (quantum > (crop_info.width-crop_info.x))4                 quantum=crop_info.width-crop_info.x;#               crop_info.x+=quantum;d'               crop_info.width-=quantum;E
             } >           XSetCropGeometry(display,windows,&crop_info,*image);>           windows->image.window_changes.width=crop_info.width;@           windows->image.window_changes.height=crop_info.height;E           XSetWindowBackgroundPixmap(display,windows->image.id,None); G           (void) XConfigureImage(display,resource_info,windows,*image);            break;	         } 9       XTranslateImage(display,windows,*image,key_symbol);m       break;     }      case XK_Return:K     case XK_KP_Enter:s     case XK_Select:K       break;     default:     { %       if (!IsModifierKey(key_symbol))i         XBell(display,0);K       break;     }    }    return(loaded_image);r }t   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             % O %                                                                             %gO %   X M a g n i f y I m a g e                                                 %iO %                                                                             %PO %                                                                             %KO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XMagnifyImage magnifies portions of the image as indicatedL %  by the pointer.  The magnified portion is displayed in a separate window. % . %  The format of the XMagnifyImage routine is: %i) %    XMagnifyImage(display,windows,event)  %o+ %  A description of each parameter follows:g %iE %    o display: Specifies a connection to an X server;  returned fromh %      XOpenDisplay. %a< %    o windows: Specifies a pointer to a XWindows structure. %0H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.g %  %  */0 static void XMagnifyImage(display,windows,event) Display    *display;    XWindows   *windows;    XEvent	   *event;  {    char     text[MaxTextLength];     register int     x,     y;     unsigned longt
     state;     /*>     Update magnified image until the mouse button is released.   */C   XDefineCursor(display,windows->image.id,windows->magnify.cursor);x   state=DefaultState;e   x=event->xbutton.x;W   y=event->xbutton.y; (   windows->magnify.x=windows->image.x+x;(   windows->magnify.y=windows->image.y+y;   do   {n     /*F       Map and unmap Info widget as text cursor crosses its boundaries.     */     if (windows->info.mapped)f       {;:         if ((x < (windows->info.x+windows->info.width)) &&9             (y < (windows->info.y+windows->info.height)))gI           XWithdrawWindow(display,windows->info.id,windows->info.screen);t       }e     else8       if ((x > (windows->info.x+windows->info.width)) ||7           (y > (windows->info.y+windows->info.height)))t-         XMapWindow(display,windows->info.id);a     if (windows->info.mapped)(       {f
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",windows->magnify.x,windows->magnify.y);*         XInfoWidget(display,windows,text);       }s     /*       Wait for next event.     */:     XIfEvent(display,event,XScreenEvent,(char *) windows);     switch (event->type)     {n       case ButtonPress:a         break;       case ButtonRelease:r       {L
         /*-           User has finished magnifying image.f
         */         x=event->xbutton.x;d         y=event->xbutton.y;          state|=ExitState;>         break;       }%       case Expose:         break;       case MotionNotify:       {u
         /*/           Discard pending button motion events.)
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));         x=event->xmotion.x;o         y=event->xmotion.y;          break;       }=       default:         break;     }      /*        Check boundary conditions.     */     if (x < 0)
       x=0;     else$       if (x >= windows->image.width)!         x=windows->image.width-1;      if (y < 0)
       y=0;     else$      if (y >= windows->image.height)!        y=windows->image.height-1;n!   } while (!(state & ExitState));I   /*     Display magnified image.   */)   XSetCursorState(display,windows,False);LA   XWithdrawWindow(display,windows->info.id,windows->info.screen);o }U l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %sO %                                                                             %dO %                                                                             % O %   X M a g n i f y W i n d o w C o m m a n d                                 %vO %                                                                             %-O %                                                                             %xO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%b % M %  Function XMagnifyWindowCommand moves the image within an Magnify window by , %  one pixel as specified by the key symbol. % 6 %  The format of the XMagnifyWindowCommand routine is: %i6 %    XMagnifyWindowCommand(display,windows,key_symbol) %t+ %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %o< %    o windows: Specifies a pointer to a XWindows structure. %wM %    o key_symbol: Specifies a KeySym which indicates which side of the imaget %      to trim.( %p %, */= static void XMagnifyWindowCommand(display,windows,key_symbol)( DisplayI   *display;E   XWindows   *windows;-   KeySym
   key_symbol;  {    /*0     User specified a magnify factor or position.   */   switch (key_symbol)e   {m     case XK_q:     {GK       XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);F       break;     }-     case XK_Home:m     case XK_KP_Home:     { 3       windows->magnify.x=windows->image.width >> 1; 4       windows->magnify.y=windows->image.height >> 1;       break;     }W     case XK_Left:x     case XK_KP_Left:     {_!       if (windows->magnify.x > 0)n         windows->magnify.x--;x       break;     }      case XK_Up:e     case XK_KP_Up:     {)!       if (windows->magnify.y > 0)%         windows->magnify.y--;_       break;     }      case XK_Right:     case XK_KP_Right:l     { 8       if (windows->magnify.x < (windows->image.width-1))         windows->magnify.x++;        break;     }      case XK_Down:e     case XK_KP_Down:     {f9       if (windows->magnify.y < (windows->image.height-1))          windows->magnify.y++;        break;     }n     case XK_0:     case XK_1:     case XK_2:     case XK_3:     case XK_4:     case XK_5:     case XK_6:     case XK_7:     case XK_8:     case XK_9:     {t,       windows->magnify.data=key_symbol-XK_0;       break;     }w     case XK_KP_0:      case XK_KP_1:      case XK_KP_2:a     case XK_KP_3:      case XK_KP_4:s     case XK_KP_5:i     case XK_KP_6:e     case XK_KP_7:t     case XK_KP_8:a     case XK_KP_9:i     {U/       windows->magnify.data=key_symbol-XK_KP_0;N       break;     }(     default:       break;   }r%   XMakeMagnifyImage(display,windows);e }n   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %mO %                                                                             %oO %   X M a k e P a n I m a g e                                                 %aO %                                                                             %iO %                                                                             %aO %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %nM %  Function XMakePanImage creates a thumbnail of the image and displays it inh %  the Pan icon window.n %a. %  The format of the XMakePanImage routine is: %g9 %      XMakePanImage(display,resource_info,windows,image)f %d+ %  A description of each parameter follows:I %eE %    o display: Specifies a connection to an X server;  returned froms %      XOpenDisplay. %uK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %v< %    o windows: Specifies a pointer to a XWindows structure. %)F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.i %l %f */> static void XMakePanImage(display,resource_info,windows,image) Displaya   *display;o  
 XResourceInfoo   *resource_info;r   XWindows   *windows;n   Image,	   *image;) {    unsigned int     status;e     /*.     Create and display image for panning icon.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   windows->pan.x=windows->image.x;"   windows->pan.y=windows->image.y;>   status=XMakeImage(display,resource_info,&windows->pan,image,,     windows->pan.width,windows->pan.height);;   status|=XMakePixmap(display,resource_info,&windows->pan);;   if (status == False);     Error("Unable to create Pan icon image",(char *) NULL);aJ   XSetWindowBackgroundPixmap(display,windows->pan.id,windows->pan.pixmap);(   XClearWindow(display,windows->pan.id);%   XDrawPanRectangle(display,windows);i)   XSetCursorState(display,windows,False);n }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %gO %                                                                             %sO %                                                                             %nO %   X M a t t a E d i t I m a g e                                             %rO %                                                                             %cO %                                                                             %CO %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %(C %  Function XMatteEditImage allows the user to interactively change_M %  the Matte channel of an image.  If the image is PseudoClass it is promotedoH %  to DirectClass before the matte information is stored.  The floodfillL %  algorithm is strongly based on a similiar algorithm in "Graphics Gems" by %  Paul Heckbert.o %_0 %  The format of the XMatteEditImage routine is: %b9 %    XMatteEditImage(display,resource_info,windows,image)o %x+ %  A description of each parameter follows:n % E %    o display: Specifies a connection to an X server;  returned fromi %      XOpenDisplay. %tK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %o< %    o windows: Specifies a pointer to a XWindows structure. %lE %    o image: Specifies a pointer to a Image structure; returned from" %      ReadImage.  %s */  + static void MatteFloodfill(image,x,y,matte)  Imagei	   *image;d   int    x,   y;   into   matte; {_   inti
     delta,	     skip,o
     start,     x1,      x2;e     register RunlengthPacket     *pixel;e     register XSegmentc     *p;r     RunlengthPacketi     target;s  
   XSegment     *segment_stack;-     /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return;t'   if ((x < 0) || (x >= image->columns))u     return;i+   target=image->pixels[y*image->columns+x];i-   if (target.index == (unsigned short) matte)i     return;l   /*     Allocate segment stack.e   */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment));g)   if (segment_stack == (XSegment *) NULL)o     {f@       Warning("Unable to floodfill","Memory allocation failed");
       return;d     }*   /*"     Push initial segment on stack.   */   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);_   while (p > segment_stack)s   {g     /*       Pop segment off stack.     */     p--;
     x1=p->x1;=
     x2=p->x2;a     delta=p->y2;     y=p->y1+delta;     /*5       Update matte information in neighboring pixels.o     */     for (x=x1; x >= 0 ; x--)     {e/       pixel=image->pixels+(y*image->columns+x);i'       if ((pixel->red != target.red) ||c+           (pixel->green != target.green) || )           (pixel->blue != target.blue) ||U)           (pixel->index != target.index))i         break;*       pixel->index=(unsigned short) matte;     }:     skip=x >= x1;d     if (!skip)       {f         start=x+1;         if (start < x1)w$           Push(y,start,x1-1,-delta);         x=x1+1;(       }n     do     {)       if (!skip)	         {e*           for ( ; x < image->columns; x++)           {n5             pixel=image->pixels+(y*image->columns+x);=-             if ((pixel->red != target.red) ||d1                 (pixel->green != target.green) ||n/                 (pixel->blue != target.blue) ||I/                 (pixel->index != target.index))i               break;0             pixel->index=(unsigned short) matte;           }t"           Push(y,start,x-1,delta);           if (x > (x2+1))n$             Push(y,x2+1,x-1,-delta);	         }        skip=False;        for (x++; x <= x2 ; x++)       {t1         pixel=image->pixels+(y*image->columns+x);l)         if ((pixel->red == target.red) && -             (pixel->green == target.green) && +             (pixel->blue == target.blue) &&;+             (pixel->index == target.index))m           break;       }        start=x;     } while (x <= x2);   }l   free((char *) segment_stack);  }L  H static unsigned int XMatteEditImage(display,resource_info,windows,image) Displaya   *display;0  
 XResourceInfo)   *resource_info;m   XWindows   *windows;"   Image 
   **image; {( #define MatteEditMethodOp  0 #define MatteEditValueOp  1e #define MatteEditUndoOp  2 #define MatteEditHelpOp  3 #define MatteEditReturnOp  4  
   static chara     *MatteEditMenu[]=h     {y       "Method",e       "Matte Value",
       "Undo",a
       "Help",v       "Return",n       (char *) NULLh     };     char     text[MaxTextLength];     Cursor     cursor;e     intl     id,_     x,
     x_offset,d     y,
     y_offset;l     register int     i;     register RunlengthPacket     *p;e  
   static charo     matte[MaxTextLength] = "0";      static unsigned intn     method = PointMethodOp;|     unsigned int     height,e
     width;     unsigned longr
     state,
     x_factor,r
     y_factor;      XEvent
     event;     /*     Map Command widget.o   */%   windows->command.name="Matte Edit";p   windows->command.data=1;G   (void) XCommandWidget(display,windows,MatteEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,-+     windows->im_update_widget,CurrentTime);i   /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id,wF     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |f     PointerMotionMask);c   state=DefaultState;d   do   {T     if (windows->info.mapped)e       {p
         /*#           Display pointer position.n
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);g1     if (event.xany.window == windows->command.id)k       { 
         /*3           Select a command from the Command widget.n
         */@         id=XCommandWidget(display,windows,MatteEditMenu,&event);         if (id < 0)a           continue;C         switch (id)n	         {r!           case MatteEditMethodOp:i           {              char%               command[MaxTextLength];o               static chari               *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.m             */             method=eP               XMenuWidget(display,windows,MatteEditMenu[id],MethodMenu,command);<             XDefineCursor(display,windows->image.id,cursor);             break;           }i            case MatteEditValueOp:           {s             /*0               Request matte value from the user.             */N             XDialogWidget(display,windows,"Matte","Enter matte value:",matte);<             XDefineCursor(display,windows->image.id,cursor);             break;           }k           case MatteEditUndoOp:e           {bB             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);              break;           }            case MatteEditHelpOp:            {\@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);X             break;           }w!           case MatteEditReturnOp:            {g             /*               Prematurely exit.=             */             state|=EscapeState;h             state|=ExitState;f             break;           }i           default:             break;	         }p8         XDefineCursor(display,windows->image.id,cursor);         continue;n       }g     switch (event.type)_     {w       case ButtonPress:s       {i4         if (event.xbutton.window == windows->pan.id)           {y.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }l
         /*           Update matte data.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }i       case ButtonRelease:-       {r
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image);e*         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);t         break;       }w       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];o           KeySym           key_symbol;d  
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),l/           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol)m	         {v           case XK_Escape:"           case XK_F20:           {-             /*               Prematurely exit.-             */             state|=ExitState;r             break;           }m           case XK_F1:            case XK_Help:_           {i@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);d             break;           }i           default:           {              XBell(display,0);n             break;           }x	         }|         break;       }w       case MotionNotify:       {M
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries.l
         */!         if (windows->info.mapped))           {->             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))cM               XWithdrawWindow(display,windows->info.id,windows->info.screen);c           }B         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))l1             XMapWindow(display,windows->info.id);a         break;       }m       default:         break;     }X     x_offset=x;      y_offset=y;f)     if (state & UpdateConfigurationState)o       {l         int"          x,m          y;*  
         /*8           Matte edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True);w         x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,.             &width,&height);=         x_factor=UpShift(width)/windows->image.ximage->width;.C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x;=?         y_factor=UpShift(height)/windows->image.ximage->height;eC         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y;a:         XPutPixel(windows->image.ximage,x_offset,y_offset,=           windows->image.pixel_info->background_color.pixel);o$         (*image)->class=DirectClass;         if (!(*image)->matte)s           {a             /*$               Initialize matte data.             */             p=(*image)->pixels;s1             for (i=0; i < (*image)->packets; i++)i
             {i               p->index=Opaque;               p++;
             }d!             (*image)->matte=True;.           }e         switch (method)t	         {n           case PointMethodOp:i           default:           {/             /*=               Update matte information using point algorithm.              */)             if (!UncompressImage(*image))d               break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset);i(             p->index=atoi(matte) & 0xff;             break;           }w           case ReplaceMethodOp:(           {e             RunlengthPacketo               target;d               /*?               Update matte information using replace algorithm.t             */             x=0;             p=(*image)->pixels;e1             for (i=0; i < (*image)->packets; i++)k
             {s               x+=(p->length+1);n=               if (x >= (y_offset*(*image)->columns+x_offset))                  break;               p++;
             } '             target=(*image)->pixels[i];a             p=(*image)->pixels;e1             for (i=0; i < (*image)->packets; i++)u
             {i+               if ((p->red == target.red) &&i/                   (p->green == target.green) &&o+                   (p->blue == target.blue))n,                 p->index=atoi(matte) & 0xff;               p++;
             }>/             state&=(~UpdateConfigurationState);o             break;           }_!           case FloodfillMethodOp:s           {>             /*A               Update matte information using floodfill algorithm.r             */)             if (!UncompressImage(*image))                break;H             MatteFloodfill(*image,x_offset,y_offset,atoi(matte) & 0xff);/             state&=(~UpdateConfigurationState);t             break;           }p	         }l       }t!   } while (!(state & ExitState));>O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);-A   XWithdrawWindow(display,windows->info.id,windows->info.screen);e)   XSetCursorState(display,windows,False);U   XFreeCursor(display,cursor);   return(True);T }L t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %eO %                                                                             %iO %                                                                             % O %   X D e s p e c k l e I m a g e                                             %rO %                                                                             %yO %                                                                             %fO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %y= %  Function XNoisyImage reduces the speckles within an image.- %g, %  The format of the XNoisyImage routine is: %T< %    status=XNoisyImage(display,resource_info,windows,image) %r+ %  A description of each parameter follows:B %oC %    o status: Function XNoisyImage return True if the edges withineF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.p %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %i< %    o windows: Specifies a pointer to a XWindows structure. %oF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.m %i %\ */D static unsigned int XNoisyImage(display,resource_info,windows,image) Displays   *display;   
 XResourceInfog   *resource_info;M   XWindows   *windows;>   Imaged
   **image; {n7 #define NoisyImageText  "  Eliminating peak noise...  "v     Imagem     *noisy_image;,     /*     Noisy image.   */.   XInfoWidget(display,windows,NoisyImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);!   noisy_image=NoisyImage(*image);i)   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);i$   if (noisy_image == (Image *) NULL)     return(False);   DestroyImage(*image);r   *image=noisy_image;r   if (windows->image.orphan)     return(True);(   /*     Update image configuration.e   */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);f   return(True);  }i w /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %_O %                                                                             %pO %   X O i l P a i n t I m a g e                                               %-O %                                                                             %nO %                                                                             %fO %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%w %i+ %  Function XOilPaintImage paints an image.  %d- %  The format of the XEmbossImage routine is:> %g? %    status=XOilPaintImage(display,resource_info,windows,image)l %w+ %  A description of each parameter follows:. % F %    o status: Function XOilPaintImage return True if the edges withinF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.  %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.S %e< %    o windows: Specifies a pointer to a XWindows structure. %;F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */G static unsigned int XOilPaintImage(display,resource_info,windows,image)o DisplayX   *display;   
 XResourceInfoS   *resource_info;    XWindows   *windows;    Image 
   **image; { 6 #define OilPaintImageText  "  Oil painting image...  "     Image      *painted_image;t     /*     OilPaint image scanlines._   */1   XInfoWidget(display,windows,OilPaintImageText);f(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   painted_image=OilPaintImage(*image);)   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); &   if (painted_image == (Image *) NULL)     return(False);   DestroyImage(*image);e   *image=painted_image;    if (windows->image.orphan)     return(True);U   /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %wO %                                                                             %tO %                                                                             % O %   X P a n I m a g e                                                         %XO %                                                                             % O %                                                                             %lO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %pH %  Function XPanImage pans the image until the mouse button is released. %M* %  The format of the XPanImage routine is: % % %    XPanImage(display,windows,event)  %t+ %  A description of each parameter follows:u %dE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %V< %    o windows: Specifies a pointer to a XWindows structure. %eH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.e %  */, static void XPanImage(display,windows,event) Displayo   *display;b   XWindows   *windows;r   XEvent	   *event;r {:   char     text[MaxTextLength];     Cursor     cursor;t     unsigned longn
     state;     unsigned long.
     x_factor, 
     y_factor;t     XRectangle
     pan_info;      /*     Define cursor.   */>   if ((windows->image.ximage->width > windows->image.width) &&>       (windows->image.ximage->height > windows->image.height))/     cursor=XCreateFontCursor(display,XC_fleur);.   else<     if (windows->image.ximage->width > windows->image.width)=       cursor=XCreateFontCursor(display,XC_sb_h_double_arrow);c     else@       if (windows->image.ximage->height > windows->image.height)?         cursor=XCreateFontCursor(display,XC_sb_v_double_arrow);t
       else3         cursor=XCreateFontCursor(display,XC_arrow);h0   XDefineCursor(display,windows->pan.id,cursor);   /*B     Pan image as pointer moves until the mouse button is released.   */   x_factor=(unsigned long)=     UpShift(windows->image.ximage->width)/windows->pan.width;    y_factor=(unsigned long)?     UpShift(windows->image.ximage->height)/windows->pan.height;cK   pan_info.width=(unsigned short) (UpShift(windows->image.width)/x_factor); M   pan_info.height=(unsigned short) (UpShift(windows->image.height)/y_factor);X!   state=UpdateConfigurationState;    do   {d     switch (event->type)     {        case ButtonPress:        { 
         /*.           User choose an initial pan location.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;(         state|=UpdateConfigurationState;         break;       })       case ButtonRelease:i       {l
         /*.           User has finished panning the image.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;4         state|=UpdateConfigurationState | ExitState;         break;       }o       case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));$         pan_info.x=event->xmotion.x;$         pan_info.y=event->xmotion.y;(         state|=UpdateConfigurationState;       }(       default:         break;     }*)     if (state & UpdateConfigurationState)s       {o
         /*$           Check boundary conditions.
         */J         pan_info.x=DownShift((pan_info.x-(pan_info.width >> 1))*x_factor);         if (pan_info.x < 0)            pan_info.x=0;          elseO           if ((pan_info.x+windows->image.width) > windows->image.ximage->width) I             pan_info.x=windows->image.ximage->width-windows->image.width; K         pan_info.y=DownShift((pan_info.y-(pan_info.height >> 1))*y_factor);i         if (pan_info.y < 0)            pan_info.y=0;w         else2           if ((pan_info.y+windows->image.height) >-                windows->image.ximage->height)pK             pan_info.y=windows->image.ximage->height-windows->image.height; /         if ((windows->image.x != pan_info.x) || -             (windows->image.y != pan_info.y))t           {E             /*'               Display image pan offset.              */(             windows->image.x=pan_info.x;(             windows->image.y=pan_info.y;E             (void) sprintf(text," %ux%u%+d%+d ",windows->image.width, G               windows->image.height,windows->image.x,windows->image.y); .             XInfoWidget(display,windows,text);             /*#               Refresh Image window.              *//             XDrawPanRectangle(display,windows);uD             XRefreshWindow(display,&windows->image,(XEvent *) NULL);           } +         state&=(~UpdateConfigurationState);7       }      /*       Wait for next event.     */     if (!(state & ExitState)) <       XIfEvent(display,event,XScreenEvent,(char *) windows);!   } while (!(state & ExitState));    /*     Restore cursor.    */=   XDefineCursor(display,windows->pan.id,windows->pan.cursor);    XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);  }3   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%uO %                                                                             %"O %                                                                             %wO %                                                                             % O %   X P a s t e I m a g e                                                     %PO %                                                                             %=O %                                                                             %eO %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0 %xH %  Function XPasteImage pastes an image previously saved with XCopyImageI %  in the X window image at a location the user chooses with the pointer.( %n, %  The format of the XPasteImage routine is: % < %    status=XPasteImage(display,resource_info,windows,image) %m+ %  A description of each parameter follows:  % @ %    o status: Function XPasteImage returns True if the image isI %      pasted.  False is returned is there is a memory shortage or if thew  %      image fails to be pasted. %vE %    o display: Specifies a connection to an X server;  returned fromf %      XOpenDisplay. %=K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */D static unsigned int XPasteImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfoc   *resource_info;b   XWindows   *windows;    Image 	   *image;x {a. #define PasteImageText  "  Pasting image...  " #define PasteModeOperatorsOp  0i #define PasteModeHelpOp  1 #define PasteModeReturnOp  2  
   static chark     *PasteModeMenu[]=      {        "Operator",p
       "Help",o       "Return",t       (char *) NULL      };     char     text[MaxTextLength];     Cursor     cursor;b     Imagei     *paste_image;_     inte     id,      x,     y;     RectangleInfon     highlight_info,n     paste_info;      static unsigned inta"     operator = ReplaceCompositeOp;     unsigned int     height,o
     width;     unsigned long      scale_factor,G
     state;     XEvent
     event;     /*     Copy image.    */#   if (copy_image == (Image *) NULL)_     return(False);   copy_image->orphan=True;N   paste_image=CopyImage(copy_image,copy_image->columns,copy_image->rows,True);   copy_image->orphan=False;k   /*     Map Command widget.p   */    windows->command.name="Paste";   windows->command.data=1;G   (void) XCommandWidget(display,windows,PasteModeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,s+     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */)   XSetCursorState(display,windows,False);m2   XQueryPosition(display,windows->image.id,&x,&y);"   paste_info.x=windows->image.x+x;"   paste_info.y=windows->image.y+y;   paste_info.width=0;    paste_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);e0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      if (windows->info.mapped)l       {.
         /*#           Display pointer position. 
         */B         (void) sprintf(text," %+d%+d ",paste_info.x,paste_info.y);*         XInfoWidget(display,windows,text);       }n     highlight_info=paste_info;3     highlight_info.x=paste_info.x-windows->image.x; 3     highlight_info.y=paste_info.y-windows->image.y;(P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &highlight_info);n     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &highlight_info);i1     if (event.xany.window == windows->command.id)        {e
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,PasteModeMenu,&event);         if (id < 0)i           continue;h         switch (id)>	         {e$           case PasteModeOperatorsOp:           {l             char%               command[MaxTextLength];)               static charr               *OperatorMenu[]=               {                  "over",e                 "in",                  "out",                 "atop",%                 "xor",                 "plus",w                 "minus",                 "add",                 "subtract",i                 "difference",                  "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */C             operator=XMenuWidget(display,windows,PasteModeMenu[id],n&               OperatorMenu,command)+1;             break;           }            case PasteModeHelpOp:            {*@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);             break;           }g!           case PasteModeReturnOp:o           {n             /*               Prematurely exit.i             */             state|=EscapeState;.             state|=ExitState;i             break;           }i           default:             break;	         }          continue;i       }i     switch (event.type)a     {        case ButtonPress:w       {x!         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 4         if (event.xbutton.window == windows->pan.id)           {f.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*=           Paste rectangle is relative to image configuration.e
         */         x=0;         y=0;         width=image->columns;y         height=image->rows; :         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,              &width,&height);A         scale_factor=UpShift(width)/windows->image.ximage->width;dF         paste_info.width=DownShift(paste_image->columns*scale_factor);C         scale_factor=UpShift(height)/windows->image.ximage->height; D         paste_info.height=DownShift(paste_image->rows*scale_factor);8         XDefineCursor(display,windows->image.id,cursor);6         paste_info.x=windows->image.x+event.xbutton.x;6         paste_info.y=windows->image.y+event.xbutton.y;         break;       }w       case ButtonRelease:        {v!         if (resource_info->debug)eD           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);s@         if ((paste_info.width != 0) && (paste_info.height != 0))           {>             /*@               User has selected the location of the paste image.             */:             paste_info.x=windows->image.x+event.xbutton.x;:             paste_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;i           }*         break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;            inte           length;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),d/           &key_symbol,(XComposeStatus *) NULL);w         *(command+length)='\0';.!         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol)-	         {o           case XK_Escape:i           case XK_F20:           {-             /*               Prematurely exit.g             */&             DestroyImage(paste_image);             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:o           case XK_Help:i           {wJ             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {p             XBell(display,0);              break;           } 	         }v         break;       }w       case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            {=>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))nM               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }y         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))w1             XMapWindow(display,windows->info.id);h(         paste_info.x=windows->image.x+x;(         paste_info.y=windows->image.y+y;         break;       }g       default:       {e!         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);a         break;       }>     },!   } while (!(state & ExitState));o@   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);t   XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);a   if (state & EscapeState)     return(True);w   /*5     Image pasting is relative to image configuration.    */   windows->info.mapped=False;o.   XInfoWidget(display,windows,PasteImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;w   height=image->rows;r4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);h;   scale_factor=UpShift(width)/windows->image.ximage->width;i   paste_info.x+=x;4   paste_info.x=DownShift(paste_info.x*scale_factor);<   paste_info.width=DownShift(paste_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    paste_info.y+=y;4   paste_info.y=DownShift(paste_info.y*scale_factor);>   paste_info.height=DownShift(paste_info.height*scale_factor);   /*$     Paste image with X Image window.   */G   CompositeImage(image,operator,paste_image,paste_info.x,paste_info.y);p   DestroyImage(paste_image);)   XSetCursorState(display,windows,False);i   /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image);e>   (void) XConfigureImage(display,resource_info,windows,image);   return(True);s }r E /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             %pO %                                                                             % O %   X P r i n t I m a g e                                                     % O %                                                                             % O %                                                                             %(O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % @ %  Function XPrintImage prints an image to a Postscript printer. % , %  The format of the XPrintImage routine is: % < %    status=XPrintImage(display,resource_info,windows,image) % + %  A description of each parameter follows:v %.? %    o status: Function XPrintImage return True if the image is.J %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. %aD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %zF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.= %' %  */D static unsigned int XPrintImage(display,resource_info,windows,image) Displayl   *display;_  
 XResourceInfo    *resource_info;k   XWindows   *windows;g   Image 
   **image; {i/ #define PrintImageText  "  Printing image...  ",     char     command[MaxTextLength],o     filename[MaxTextLength],     geometry[MaxTextLength];     ImageInfo      *image_info;     into     status;,     /*/     Request Postscript page geometry from user.n   */'   image_info=resource_info->image_info;e*   (void) sprintf(geometry,PSPageGeometry);(   if (image_info->page != (char *) NULL)-     (void) strcpy(geometry,image_info->page);1I   XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",r1     "Select Postscript Page Geometry:",geometry);r   if (*geometry == '\0')     return(True); 0   image_info->page=PostscriptGeometry(geometry);   /*      Request file name from user.   */(   XCheckRefreshWindows(display,windows);   TemporaryFilename(filename);@   (void) sprintf(command,resource_info->print_command,filename);B   XDialogWidget(display,windows,"Print","Print command:",command);   if (*command == '\0')f     return(True);b   /*     Print image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); .   XInfoWidget(display,windows,PrintImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);6   (void) sprintf((*image)->filename,"ps:%s",filename);'   status=WriteImage(image_info,*image);o"   status&=!SystemCommand(command);   (void) unlink(filename);)   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);-M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);o   return(status);v }. p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             % O %                                                                             %oO %   X R O I I m a g e                                                         %kO %                                                                             %rO %                                                                             %tO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XROIImage applies an image processing technique to a region  %  of interest.m %w* %  The format of the XROIImage routine is: % : %    status=XROIImage(display,resource_info,windows,image) %d+ %  A description of each parameter follows:; % > %    o status: Function XROIImage returns True if the image isJ %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.i %aD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */B static unsigned int XROIImage(display,resource_info,windows,image) Displaya   *display;n  
 XResourceInfoo   *resource_info;    XWindows   *windows;p   Imagex
   **image; {  #define ApplyModeMenus  5, #define ApplyModeFileOp  0 #define ApplyModeEditOp  1$ #define ApplyModePixelTransformOp  2" #define ApplyModeColorEnhanceOp  3 #define ApplyModeEffectsOp  4s #define ApplyModeHelpOp  5 #define ApplyModeReturnOp  6 #define ROIModeHelpOp  0 #define ROIModeReturnOp  1  
   static char      *ROIModeMenu[]=s     {n
       "Help",g       "Return",d       (char *) NULL;     },     *ApplyModeMenu[]=      { 
       "File",m
       "Edit",n       "Pixel Transform",       "Color Enhance",       "Effects",
       "Help",        "Return",        (char *) NULL(     },     *FileMenu[]=     {u       "Image Info",        (char *) NULLp     },     *EditMenu[]=     {r
       "Undo",        (char *) NULL.     },     *PixelTransformMenu[]=     { 
       "Flop", 
       "Flip",e       "Rotate Right",        "Rotate Left",       (char *) NULL      },     *ColorEnhanceMenu[]=     {        "Hue...",e       "Saturation...",       "Brightness...",       "Gamma...",        "Spiff",
       "Dull",;       "Equalize",n       "Normalize",       "Negate",r       (char *) NULL      },     *EffectsMenu[]=R     {        "Despeckle",       "Peak Noise",n       "Sharpen...",e       "Blur...",       "Edge Detect",       "Emboss",a       "Oil Painting",        "Segment",       "Grayscale",       "Quantize...",       (char *) NULLt     };  
   static charp     **Menus[ApplyModeMenus]=     {w       FileMenu,>       EditMenu,        PixelTransformMenu,-       ColorEnhanceMenu,        EffectsMenu      };     static KeySym.     ApplyModeKeys[]=     {n       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_h,m
       XK_q     },     FileKeys[]=      {        XK_i,i     },     EditKeys[]=      {        XK_u,      },     PixelTransformKeys[]=p     { 
       XK_bar,o       XK_minus,t       XK_slash,d       XK_backslash,e     },     ColorEnhanceKeys[]=      {        XK_F7,       XK_F8,       XK_F9,       XK_g, 
       XK_F10, 
       XK_F11,o       XK_equal,n       XK_N,p       XK_asciitilden     },     EffectsKeys[]=     {e       XK_D,,       XK_P,        XK_S,_       XK_B,        XK_E,S       XK_M,a       XK_O,n       XK_Z,m       XK_G,l       XK_numbersignw     };     static KeySym      *Keys[ApplyModeMenus]=     {        FileKeys,p       EditKeys,s       PixelTransformKeys,e       ColorEnhanceKeys,m       EffectsKeys,     };     char     command[MaxTextLength],v     text[MaxTextLength];     Cursor     cursor;      int 
     entry,     id,c     x,     y;     KeySym     key_symbol;t     RectangleInfow     highlight_info,r
     roi_info;      unsigned int     height, 
     width;     unsigned longa     scale_factor,r
     state;     XEvent
     event;     /*     Map Command widget.t   */   windows->command.name="ROI";   windows->command.data=0;E   (void) XCommandWidget(display,windows,ROIModeMenu,(XEvent *) NULL);T*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);    roi_info.x=windows->image.x+x;    roi_info.y=windows->image.y+y;   roi_info.width=0;g   roi_info.height=0;-   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |o     PointerMotionMask);p   state=DefaultState;a   do   {p     if (windows->info.mapped)n       { 
         /*#           Display pointer position.n
         */>         (void) sprintf(text," %+d%+d ",roi_info.x,roi_info.y);*         XInfoWidget(display,windows,text);       }c     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);s1     if (event.xany.window == windows->command.id)r       {f
         /*3           Select a command from the Command widget.)
         */>         id=XCommandWidget(display,windows,ROIModeMenu,&event);         if (id < 0)            continue;,         switch (id))	         {            case ROIModeHelpOp:            {i@             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);              break;           }i           case ROIModeReturnOp:k           {x             /*               Prematurely exit.g             */             state|=EscapeState;k             state|=ExitState;              break;           }p           default:             break;	         }*         continue;d       }m     switch (event.type)(     {e       case ButtonPress:*       { 4         if (event.xbutton.window == windows->pan.id)           {n.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {              /*L               Note first corner of region of interest rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);8             roi_info.x=windows->image.x+event.xbutton.x;8             roi_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;              break;           }u         break;       }b       case Expose:         break;       case KeyPress:       {%
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);%             break;           }m           default:           {t             XBell(display,0);f             break;           } 	         }=         break;       }r       case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            {n>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))XM               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))n1             XMapWindow(display,windows->info.id);;&         roi_info.x=windows->image.x+x;&         roi_info.y=windows->image.y+y;         break;       }o       default:         break;     }f!   } while (!(state & ExitState));wO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);x   if (state & EscapeState)     {        /*5         User want to exit without region of interest.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen);."       XFreeCursor(display,cursor);       return(True);      }sB   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {l     /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=roi_info.x;v     y=roi_info.y;      roi_info.width=0;      roi_info.height=0;     state=DefaultState; +     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {t       highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x; 3       highlight_info.y=roi_info.y-windows->image.y;tD       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {,           /*?             Display info and draw region of interest rectangle..           */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id);oL           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);i,           XInfoWidget(display,windows,text);5           XHighlightRegion(display,windows->image.id,l>             windows->image.highlight_context,&highlight_info);	         }_
       else!         if (windows->info.mapped)aI           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);mD       if ((highlight_info.width > 3) && (highlight_info.height > 3))3         XHighlightRegion(display,windows->image.id,.<           windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id)>	         {n           /*5             Select a command from the Command widget.m           */@           id=XCommandWidget(display,windows,ROIModeMenu,&event);           if (id < 0)              continue;            switch (id)            {f             case ROIModeHelpOp:D
             {eL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);rN               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             } !             case ROIModeReturnOp:a
             {-               /*!                 Prematurely exit.M               */!               state|=EscapeState;,               state|=ExitState;                break;
             }              default:               break;           }            continue; 	         }a       switch (event.type)        {C         case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }c6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;           break;	         }          case ButtonRelease:e	         {c           /*?             User has committed to region of interest rectangle.g           */6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;1           XSetCursorState(display,windows,False);a(           windows->command.name="Apply";/           windows->command.data=ApplyModeMenus; O           (void) XCommandWidget(display,windows,ApplyModeMenu,(XEvent *) NULL);            state|=ExitState;l           break;	         }e         case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.            */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 6           roi_info.x=windows->image.x+event.xmotion.x;6           roi_info.y=windows->image.y+event.xmotion.y;	         }          default:           break;       }_1       if ((roi_info.x != x) && (roi_info.y != y))s	         {r           /*&             Check boundary conditions.           */           if (roi_info.x < 0)i             roi_info.x=0;            else:             if (roi_info.x > windows->image.ximage->width)6               roi_info.x=windows->image.ximage->width;           if (roi_info.x < x) 9             roi_info.width=(unsigned int) (x-roi_info.x);p           else
             { ;               roi_info.width=(unsigned int) (roi_info.x-x);e               roi_info.x=x;5
             }            if (roi_info.y < 0)_             roi_info.y=0;            else;             if (roi_info.y > windows->image.ximage->height)a7               roi_info.y=windows->image.ximage->height;            if (roi_info.y < y)]:             roi_info.height=(unsigned int) (y-roi_info.y);           else
             { <               roi_info.height=(unsigned int) (roi_info.y-y);               roi_info.y=y; 
             }4	         } #     } while (!(state & ExitState));,+     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);n     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;r     do     {W       if (windows->info.mapped)n	         {            /*%             Display pointer position.            */@           (void) sprintf(text," %+d%+d ",roi_info.x,roi_info.y);,           XInfoWidget(display,windows,text);	         }        highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x;n3       highlight_info.y=roi_info.y-windows->image.y; F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;            state|=ExitState;            break;	         } $       if (state & UpdateRegionState)	         { H           XSetFunction(display,windows->image.highlight_context,GXcopy);;           if ((key_symbol == XK_i) || (key_symbol == XK_u)) M             (void) XMagickCommand(display,resource_info,windows,0,key_symbol,e               image);e           else
             {                ImageI                 *roi_image;;                 RectangleInfoi                 crop_info;                 /*F                 Region of interest is relative to image configuration.               */!               crop_info=roi_info;t               x=0;               y=0;&               width=(*image)->columns;$               height=(*image)->rows;@               if (windows->image.crop_geometry != (char *) NULL)I                 (void) XParseGeometry(windows->image.crop_geometry,&x,&y,o"                   &width,&height);G               scale_factor=UpShift(width)/windows->image.ximage->width;                crop_info.x+=x;d>               crop_info.x=DownShift(crop_info.x*scale_factor);F               crop_info.width=DownShift(crop_info.width*scale_factor);I               scale_factor=UpShift(height)/windows->image.ximage->height;                crop_info.y+=y;o>               crop_info.y=DownShift(crop_info.y*scale_factor);H               crop_info.height=DownShift(crop_info.height*scale_factor);5               roi_image=CropImage(*image,&crop_info);a.               if (roi_image == (Image *) NULL)                 continue;]               /*K                 Apply image processing technique to the region of interest.                */)               windows->image.orphan=True;yK               (void) XMagickCommand(display,resource_info,windows,Mod5Mask,p'                 key_symbol,&roi_image);eD               (void) XMagickCommand(display,resource_info,windows,0,*                 (KeySym) XK_Select,image);*               windows->image.orphan=False;A               CompositeImage(*image,ReplaceCompositeOp,roi_image,|)                 crop_info.x,crop_info.y); &               DestroyImage(roi_image);
             }e%           windows->info.mapped=False;xH           XConfigureImageColormap(display,resource_info,windows,*image);G           (void) XConfigureImage(display,resource_info,windows,*image); 0           XCheckRefreshWindows(display,windows);,           XInfoWidget(display,windows,text);J           XSetFunction(display,windows->image.highlight_context,GXinvert);&           state&=(~UpdateRegionState);	         } 1       XHighlightRegion(display,windows->image.id,/:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows);t3       if (event.xany.window == windows->command.id)w	         {x           /*5             Select a command from the Command widget.-           */H           XSetFunction(display,windows->image.highlight_context,GXcopy);#           key_symbol=XK_VoidSymbol;dB           id=XCommandWidget(display,windows,ApplyModeMenu,&event);           if (id >= 0)
             {o7               (void) strcpy(command,ApplyModeMenu[id]);f+               key_symbol=ApplyModeKeys[id]; &               if (id < ApplyModeMenus)                 {g                   /*8                     Select a command from a pop-up menu.                   */P                   entry=XMenuWidget(display,windows,ApplyModeMenu[id],Menus[id],                     command);e!                   if (entry >= 0)(                     {d>                       (void) strcpy(command,Menus[id][entry]);1                       key_symbol=Keys[id][entry];e                     }n                 } 
             }fJ           XSetFunction(display,windows->image.highlight_context,GXinvert);5           XHighlightRegion(display,windows->image.id,x>             windows->image.highlight_context,&highlight_info);!           if (key_symbol == XK_h)t
             {yL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               continue; 
             }a!           if (key_symbol == XK_q)e
             {                /*                 Exit.i               */!               state|=EscapeState;f               state|=ExitState;                continue;,
             } *           if (key_symbol != XK_VoidSymbol)%             state|=UpdateRegionState;i           continue;t	         })1       XHighlightRegion(display,windows->image.id,(:         windows->image.highlight_context,&highlight_info);       switch (event.type)>       {e         case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }a8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x;i-           y=windows->image.y+event.xbutton.y;tK           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) &&eI               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))) 
             {i3               roi_info.x=roi_info.x+roi_info.width; 4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             } K           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) &&.<               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             {e3               roi_info.x=roi_info.x+roi_info.width;n.               state|=UpdateConfigurationState;               break;
             }w;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) && ;               (x > (roi_info.x+roi_info.width-RoiDelta)) &&RI               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))) 
             {.4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             } ;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) &&e;               (x > (roi_info.x+roi_info.width-RoiDelta)) && <               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             {e.               state|=UpdateConfigurationState;               break;
             }x	         }t         case ButtonRelease:n           break;         case Expose:	         {d8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                { 1                 event.xexpose.x=highlight_info.x;n1                 event.xexpose.y=highlight_info.y;t9                 event.xexpose.width=highlight_info.width;2;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);_               }i7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0)n0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         {w           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);f/           for (id=0; id < ApplyModeMenus; id++)            {iE             for (entry=0; Menus[id][entry] != (char *) NULL; entry++)i0               if (key_symbol == Keys[id][entry])                 {c+                   state|=UpdateRegionState;)                   break;                 }x*             if (state & UpdateRegionState)               break;           }n(           if (state & UpdateRegionState)             break;           switch (key_symbol)            {t             case XK_Shift_L:             case XK_Shift_R:               break;             case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return: 
             {l               state|=ExitState;                break;
             }              case XK_F1:0             case XK_Help: 
             {lL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);lN               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }_             default:
             {a               XBell(display,0);e               break;
             }s           }i           break;	         }(         case KeyRelease:           break;         case MotionNotify:	         {u           /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));<           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped) 
             {g@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height)))wO                 XWithdrawWindow(display,windows->info.id,windows->info.screen);w
             }-           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height)))w3               XMapWindow(display,windows->info.id);o           break;	         };         default:           break;       }t+       if (state & UpdateConfigurationState)h	         {h(           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState));w!   } while (!(state & ExitState));n@   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);tA   XWithdrawWindow(display,windows->info.id,windows->info.screen);i   if (state & EscapeState)     return(True);h   return(True);w }f i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %.O %                                                                             %iO %                                                                             %iO %   X R o t a t e I m a g e                                                   %iO %                                                                             %*O %                                                                             %gO %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %mG %  Function XRotateImage rotates the X image.  If the degrees parametereL %  if zero, the rotation angle is computed from the slope of a line drawn by %  the user. %r- %  The format of the XRotateImage routine is:I %eE %    status=XRotateImage(display,resource_info,windows,degrees,image)a %i+ %  A description of each parameter follows:t %s@ %    o status: Function XRotateImage return True if the image isJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % D %    o degrees: Specifies the number of degrees to rotate the image. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */G static unsigned int XRotateImage(display,resource_info,windows,degrees,    image) Display    *display;   
 XResourceInfo%   *resource_info;%   XWindows   *windows;%   double
   degrees;   Image 
   **image; { 0 #define RotateImageText  "  Rotating image...  " #define RotateModeColorOp  0  #define RotateModeDirectionOp  1 #define RotateModeHelpOp  2  #define RotateModeReturnOp  3I #define HorizontalRotateOp  0  #define VerticalRotateOp  1i  
   static charX     *RotateModeMenu[]=     {s       "Pixel Color",       "Direction",
       "Help",        "Return",p       (char *) NULLt     };     char     text[MaxTextLength];  
   ColorPacket      background;f     double     normalized_degrees;.     Image/     *rotated_image;n     int(     id,i     x,     y;     register int     i;     static unsigned inti#     direction = HorizontalRotateOp,e     pen_id = 0;      unsigned int     height,e     rotations,     status,n
     width;     if (degrees == 0.0)(     {d       unsigned int         distance;)         unsigned long>         state;         XEvent         event;         XSegment         rotate_info;         /*         Map Command widget.l       */%       windows->command.name="Rotate";U       windows->command.data=2;L       (void) XCommandWidget(display,windows,RotateModeMenu,(XEvent *) NULL);.       XMapRaised(display,windows->command.id);E       XClientMessage(display,windows->image.id,windows->im_protocols,t/         windows->im_update_widget,CurrentTime);.       /*$         Wait for first button press.       */F       XSetFunction(display,windows->image.highlight_context,GXinvert);-       XSelectInput(display,windows->image.id,%B         windows->image.attributes.event_mask | PointerMotionMask);6       XQueryPosition(display,windows->image.id,&x,&y);       rotate_info.x1=x;        rotate_info.y1=y;        rotate_info.x2=x;        rotate_info.y2=y;        state=DefaultState;        do       { 1         XHighlightLine(display,windows->image.id, 9           windows->image.highlight_context,&rotate_info); 
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows); 1         XHighlightLine(display,windows->image.id, 9           windows->image.highlight_context,&rotate_info);%5         if (event.xany.window == windows->command.id)            {o             /*7               Select a command from the Command widget.              */E             id=XCommandWidget(display,windows,RotateModeMenu,&event);              if (id < 0)r               continue; J             XSetFunction(display,windows->image.highlight_context,GXcopy);             switch (id)s
             {s%               case RotateModeColorOp:i               {t                 char,                   color_name[MaxTextLength],.                   *ColorMenu[MaxNumberPens+1];                   intp                   pen_number;o                   /*-                   Initialize menu selections.i                 */1                 for (i=0; i < MaxNumberPens; i++)c;                   ColorMenu[i]=resource_info->pen_color[i];u8                 ColorMenu[MaxNumberPens-1]="Browser...";7                 ColorMenu[MaxNumberPens]=(char *) NULL;c                 /*:                   Select a pen color from the pop-up menu.                 */J                 pen_number=XMenuWidget(display,windows,RotateModeMenu[id],(                   ColorMenu,color_name);4                 if (pen_number == (MaxNumberPens-1))                   {e                     static char 7                       color_name[MaxTextLength]="gray";i                       /*7                       Select a pen color from a dialog.r                     */I                     resource_info->pen_color[MaxNumberPens-1]=color_name;iM                     XColorBrowserWidget(display,windows,"Select",color_name); ,                     if (*color_name == '\0')                       break;                   }a$                 if (pen_number >= 0)                   {s                     /*$                       Set pen color.                     */&                     pen_id=pen_number;O                     (void) strcpy(color_name,resource_info->pen_color[pen_id]); /                     status=XParseColor(display, C                       windows->image.map_info->colormap,color_name, E                       &windows->image.pixel_info->pen_color[pen_id]); $                     if (status == 0)4                       XNoticeWidget(display,windows,C                         "Color is unknown to X server",color_name); I                     XBestPixel(display,windows->image.map_info->colormap, 4                       (XColor *) NULL,(unsigned int)I                       Min(windows->image.visual_info->colormap_size,256),%E                       &windows->image.pixel_info->pen_color[pen_id]);                    }t                 break;               }u)               case RotateModeDirectionOp:i               {d                 char)                   command[MaxTextLength];o                   static char                     *Directions[]=                   {r!                     "horizontal",                      "vertical",b"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */I                 direction=XMenuWidget(display,windows,RotateModeMenu[id],o&                   Directions,command);                 break;               }e$               case RotateModeHelpOp:               {cD                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);                 break;               }d&               case RotateModeReturnOp:               {i                 /*#                   Prematurely exit.                  */#                 state|=EscapeState;S!                 state|=ExitState;;                 break;               };               default:                 break;
             }iL             XSetFunction(display,windows->image.highlight_context,GXinvert);             continue;            }N         switch (event.type)e	         {*           case ButtonPress:e           {d8             if (event.xbutton.window == windows->pan.id)               {n2                 XPanImage(display,windows,&event);2                 XInfoWidget(display,windows,text);                 break;               }eJ             XSetFunction(display,windows->image.highlight_context,GXcopy);             /*               Exit loop.             */+             rotate_info.x1=event.xbutton.x; +             rotate_info.y1=event.xbutton.y;              state|=ExitState;              break;           }            case ButtonRelease:              break;           case Expose:             break;           case KeyPress:           {              char%               command[MaxTextLength];                KeySym               key_symbol;                /**               Respond to a user key press.             */C             (void) XLookupString((XKeyEvent *) &event.xkey,command,%C               sizeof(command),&key_symbol,(XComposeStatus *) NULL);%             switch (key_symbol)a
             {a               case XK_Escape:o               case XK_F20:               {e                 /*#                   Prematurely exit.l                 */#                 state|=EscapeState; !                 state|=ExitState;o                 break;               }i               case XK_F1:                case XK_Help:d               {mN                 XSetFunction(display,windows->image.highlight_context,GXcopy);D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               }                default:               {r!                 XBell(display,0);                  break;               }s
             }o             break;           }            case MotionNotify:           {W             /*4               Discard pending pointer motion events.             */F             while (XCheckMaskEvent(display,PointerMotionMask,&event));+             rotate_info.x1=event.xmotion.x;l+             rotate_info.y1=event.xmotion.y;d           } 	         }s&         rotate_info.x2=rotate_info.x1;&         rotate_info.y2=rotate_info.y1;,         if (direction == HorizontalRotateOp)           rotate_info.x2+=32;s         else           rotate_info.y2-=32;g%       } while (!(state & ExitState));o-       XSelectInput(display,windows->image.id,f.         windows->image.attributes.event_mask);D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);r       if (state & EscapeState)         return(True);c       /*F         Draw line as pointer moves until the mouse button is released.       */       distance=0;gF       XSetFunction(display,windows->image.highlight_context,GXinvert);       state=DefaultState;e       do       {          if (distance > 9)i           {              /*2               Display info and draw rotation line.             */&             if (!windows->info.mapped)3               XMapWindow(display,windows->info.id); (             (void) sprintf(text," %.2f",F               direction == VerticalRotateOp ? degrees-90.0 : degrees);.             XInfoWidget(display,windows,text);5             XHighlightLine(display,windows->image.id, =               windows->image.highlight_context,&rotate_info);            }          else#           if (windows->info.mapped) K             XWithdrawWindow(display,windows->info.id,windows->info.screen); 
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows);          if (distance > 9)%3           XHighlightLine(display,windows->image.id,%;             windows->image.highlight_context,&rotate_info);s         switch (event.type)o	         {            case ButtonPress:a             break;           case ButtonRelease:F           {l             /*2               User has committed to rotation line.             */+             rotate_info.x2=event.xbutton.x; +             rotate_info.y2=event.xbutton.y;              state|=ExitState;a             break;           }            case Expose:             break;           case MotionNotify:           {X             /*3               Discard pending button motion events.o             */E             while (XCheckMaskEvent(display,ButtonMotionMask,&event)); +             rotate_info.x2=event.xmotion.x;o+             rotate_info.y2=event.xmotion.y;u           }            default:             break;	         }e
         /*$           Check boundary conditions.
         */         if (rotate_info.x2 < 0)=           rotate_info.x2=0;o         else4           if (rotate_info.x2 > windows->image.width)0             rotate_info.x2=windows->image.width;         if (rotate_info.y2 < 0)a           rotate_info.y2=0;(         else5           if (rotate_info.y2 > windows->image.height)r1             rotate_info.y2=windows->image.height;l
         /*<           Compute rotation angle from the slope of the line.
         */         degrees=0.0;         distance=>P           ((rotate_info.x2-rotate_info.x1+1)*(rotate_info.x2-rotate_info.x1+1))+P           ((rotate_info.y2-rotate_info.y1+1)*(rotate_info.y2-rotate_info.y1+1));         if (distance > 9) C           degrees=RadiansToDegrees(-atan2((double) (rotate_info.y2-tG             rotate_info.y1),(double) (rotate_info.x2-rotate_info.x1))); %       } while (!(state & ExitState));eD       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);)!       windows->info.mapped=False;i       if (distance <= 9)         return(True);e     } $   if (direction == VerticalRotateOp)     degrees-=90.0;   if (degrees == 0.0)_     return(True);)   /*     Rotate image.    */   normalized_degrees=degrees;%$   while (normalized_degrees < -45.0)     normalized_degrees+=360.0;;   for (rotations=0; normalized_degrees > 45.0; rotations++)e     normalized_degrees-=90.0;     if (normalized_degrees != 0.0)O     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); /   XInfoWidget(display,windows,RotateImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);N   background.red=ColorShift(windows->image.pixel_info->pen_color[pen_id].red);   background.green= C     ColorShift(windows->image.pixel_info->pen_color[pen_id].green); P   background.blue=ColorShift(windows->image.pixel_info->pen_color[pen_id].blue);>   rotated_image=RotateImage(*image,degrees,&background,False);)   XSetCursorState(display,windows,False);fA   XWithdrawWindow(display,windows->info.id,windows->info.screen);a&   if (rotated_image == (Image *) NULL)     return(False);   DestroyImage(*image);t   *image=rotated_image;l4   if (windows->image.crop_geometry != (char *) NULL)     {o       /*         Rotate crop geometry.u       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);        switch (rotations % 4)       {r         default:         case 0:o           break;         case 1:t	         {n           /*             Rotate 90 degrees.           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",C             height,width,(int) (*image)->columns-(int) height-y,x);p           break;	         }s         case 2:e	         {            /*             Rotate 180 degrees.I           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",7             width,height,(int) width-x,(int) height-y);            break;	         }m         case 3: 	         {            /*             Rotate 270 degrees.l           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",?             height,width,y,(int) (*image)->rows-(int) width-x);m           break;	         }t       }w     }"   if (windows->image.orphan)     return(True);     if (normalized_degrees != 0.0)     {        /*         Update image colormap.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {u           /*:             Obtain dimensions of image from crop geometry.           */C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,m             &width,&height);4           windows->image.window_changes.width=width;6           windows->image.window_changes.height=height;	         })D       XConfigureImageColormap(display,resource_info,windows,*image);     }    else9     if (((rotations % 4) == 1) || ((rotations % 4) == 3))(       { J         windows->image.window_changes.width=windows->image.ximage->height;J         windows->image.window_changes.height=windows->image.ximage->width;       }    /*     Update image configuration.    */?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);' })   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             %kO %                                                                             % O %                                                                             %rO %   X S h a r p e n I m a g e                                                 %nO %                                                                             %*O %                                                                             %SO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%I %e, %  Function XSharpenImage sharpens an image. %i. %  The format of the XSharpenImage routine is: %i> %    status=XSharpenImage(display,resource_info,windows,image) %e+ %  A description of each parameter follows:s %mE %    o status: Function XSharpenImage return True if the edges withineF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %nK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %f< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %e %! */F static unsigned int XSharpenImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfox   *resource_info;    XWindows   *windows;p   Image 
   **image; {h3 #define SharpenImageText  "  Sharpening image...  "x  
   static charh#     factor[MaxTextLength] = "60.0";      Image      *sharpened_image;   *   XDialogWidget(display,windows,"Sharpen",9     "Enter the sharpening factor (0.0 - 99.9%):",factor);(   if (*factor == '\0')     return(True);    /*     Sharpen image scanlines.   */0   XInfoWidget(display,windows,SharpenImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);4   sharpened_image=SharpenImage(*image,atof(factor));)   XSetCursorState(display,windows,False);oA   XWithdrawWindow(display,windows->info.id,windows->info.screen);f(   if (sharpened_image == (Image *) NULL)     return(False);   DestroyImage(*image);)   *image=sharpened_image;    if (windows->image.orphan)     return(True);;   /*     Update image configuration.;   */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S h e a r I m a g e                                                     % O %                                                                             % O %                                                                             %%O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %y+ %  Function XShearImage shears the X image.i %o, %  The format of the XShearImage routine is: %C< %    status=XShearImage(display,resource_info,windows,image) %m+ %  A description of each parameter follows:f %o? %    o status: Function XShearImage return True if the image isnJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.i %eD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %nK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %r< %    o windows: Specifies a pointer to a XWindows structure. %tF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.r %  %  */D static unsigned int XShearImage(display,resource_info,windows,image) Displayy   *display;e  
 XResourceInfo    *resource_info;.   XWindows   *windows;e   ImageC
   **image; {r/ #define ShearImageText  "  Shearing image...  "   
   ColorPacketl     border_color;f     floatu     x_shear,     y_shear;     Image      *sheared_image;;  
   static char_'     color_name[MaxTextLength] = "gray",n%     geometry[MaxTextLength] = "10.0";e     XColor
     color;     /*!     Get color of empty triangles.c   */;   XColorBrowserWidget(display,windows,"Select",color_name);r   if (*color_name == '\0')     return(True); J   XDialogWidget(display,windows,"Shear","Enter shear geometry:",geometry);   if (*geometry == '\0')     return(True);n   /*     Shear image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); .   XInfoWidget(display,windows,ShearImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x_shear=0.0;   y_shear=0.0;4   (void) sscanf(geometry,"%fx%f",&x_shear,&y_shear);J   (void) XParseColor(display,windows->image.map_info->colormap,color_name,     &color);)   border_color.red=ColorShift(color.red);L-   border_color.green=ColorShift(color.green); +   border_color.blue=ColorShift(color.blue);    sheared_image=M     ShearImage(*image,(double) x_shear,(double) y_shear,&border_color,False); )   XSetCursorState(display,windows,False);yA   XWithdrawWindow(display,windows->info.id,windows->info.screen); &   if (sheared_image == (Image *) NULL)     return(False);   DestroyImage(*image);0   *image=sheared_image;_8   windows->image.window_changes.width=(*image)->columns;6   windows->image.window_changes.height=(*image)->rows;@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }g r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %nO %                                                                             % O %   X S c r e e n E v e n t                                                   %wO %                                                                             % O %                                                                             % O %                                                                             %uO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%, %aK %  Function XScreenEvent returns True if the certain events on the X server 8 %  queue is associated with the image or Magnify window. %k. %  The format of the XScreenEvent function is: %_' %      XScreenEvent(display,event,data)_ %n+ %  A description of each parameter follows:t % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % < %    o event: Specifies a pointer to a X11 XEvent structure. % 9 %    o data: Specifies a pointer to a XWindows structure.  %e %_ */+ static int XScreenEvent(display,event,data): Displaya   *display;    XEvent	   *event;t   char   *data; {u   register int     x,     y;     register XWindowse
     *windows;      windows=(XWindows *) data;0   if (event->xany.window == windows->command.id)     return(True);a   switch (event->type)   {      case ButtonPress:      {X/       if ((event->xbutton.button == Button3) && ,           (event->xbutton.state & Mod1Mask))	         {            /*+             Convert Alt-Button3 to Button2.X           */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }a8       if (event->xbutton.window == windows->backdrop.id)D         XSetInputFocus(display,event->xbutton.window,RevertToParent,           event->xbutton.time);        return(True);S     }r     case ButtonRelease:e     { 5       if (event->xbutton.window == windows->image.id)o$         if (windows->magnify.mapped)           {              /*%               Update magnified image.              */             x=event->xbutton.x;              y=event->xbutton.y;e             if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1; 2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;c2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);i           }e       return(True);      }I     case ClientMessage:      {        /*.         If client window delete message, exit.       */?       if (event->xclient.message_type != windows->wm_protocols)g         break;>       if (*event->xclient.data.l != windows->wm_delete_window)         break;7       if (event->xclient.window == windows->magnify.id) 	         {dO           XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);i           return(True);h	         }w       break;     }e     case Expose:     {i5       if (event->xexpose.window == windows->image.id)X	         {u8           XRefreshWindow(display,&windows->image,event);           return(True);e	         },3       if (event->xexpose.window == windows->pan.id)e&         if (event->xexpose.count == 0)           { /             XDrawPanRectangle(display,windows);a             return(True);d           }p       break;     }i     case KeyPress:     {t
       char         command[MaxTextLength];          KeySym         key_symbol;a         /*$         Respond to a user key press.       */N       (void) XLookupString((XKeyEvent *) &event->xkey,command,sizeof(command),-         &key_symbol,(XComposeStatus *) NULL);;4       if (event->xkey.window == windows->magnify.id):         XMagnifyWindowCommand(display,windows,key_symbol);       return(True);o     }f     case MapNotify:)     { 4       if (event->xmap.window == windows->magnify.id)	         { -           XMakeMagnifyImage(display,windows);l'           windows->magnify.mapped=True;f           return(True); 	         } 1       if (event->xmap.window == windows->info.id)X	         { $           windows->info.mapped=True;           return(True); 	         };       break;     }_     case MotionNotify:     {r5       if (event->xmotion.window == windows->image.id)r$         if (windows->magnify.mapped)           {a             /*%               Update magnified image.w             */             x=event->xmotion.x;g             y=event->xmotion.y;              if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;.2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1; 2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);n           }        return(True);a     }:     case UnmapNotify:f     { 6       if (event->xunmap.window == windows->magnify.id)	         {g(           windows->magnify.mapped=False;           return(True); 	         }d3       if (event->xunmap.window == windows->info.id),	         { %           windows->info.mapped=False;r           return(True);&	         };       break;     }(     case KeyRelease:     case SelectionNotify:z       return(True);o     default:       break;   };   return(False); }  g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %eO %                                                                             % O %                                                                             %-O %   X S e t C r o p G e o m e t r y                                           %wO %                                                                             %;O %                                                                             %>O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o % H %  Function XSetCropGeometry accepts a cropping geometry relative to theH %  Image window and translates it to a cropping geometry relative to the	 %  image.g % 1 %  The format of the XSetCropGeometry routine is:n %w6 %    XSetCropGeometry(display,windows,crop_info,image) % + %  A description of each parameter follows:/ % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %_< %    o windows: Specifies a pointer to a XWindows structure. %tL %    o crop_info:  A pointer to a RectangleInfo that defines a region of the %      Image window to crop. %c7 %    o image: Specifies a pointer to a Image structure.  %  %* */= static void XSetCropGeometry(display,windows,crop_info,image)  Displaya   *display;    XWindows   *windows;m  
 RectangleInfoe
   *crop_info;    Imagew	   *image;g {r   char     text[MaxTextLength];     int      x,     y;     unsigned int     height,d
     width;     unsigned longw     scale_factor;.     if (windows->info.mapped)r     {_       /*+         Display info on cropping rectangle.        */L       (void) sprintf(text," %ux%u%+d%+d",crop_info->width,crop_info->height,#         crop_info->x,crop_info->y);t(       XInfoWidget(display,windows,text);     }n   /*@     Cropping geometry is relative to any previous crop geometry.   */   x=0;   y=0;   width=image->columns;e   height=image->rows;m4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);;   else     {d       /*&         Allocate crop geometry string.       */O       windows->image.crop_geometry=(char *) malloc(MaxTextLength*sizeof(char));_8       if (windows->image.crop_geometry == (char *) NULL)<         Error("Unable to crop X image",windows->image.name);     }o   /*@     Define the crop geometry string from the cropping rectangle.   */;   scale_factor=UpShift(width)/windows->image.ximage->width;=   if (crop_info->x > 0) ,     x+=DownShift(crop_info->x*scale_factor);1   width=DownShift(crop_info->width*scale_factor);s   if (width == 0)a     width=1;=   scale_factor=UpShift(height)/windows->image.ximage->height;    if (crop_info->y > 0)_,     y+=DownShift(crop_info->y*scale_factor);3   height=DownShift(crop_info->height*scale_factor);e   if (height == 0)
     height=1;gN   (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,x,y); }l r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             %wO %                                                                             %_O %   X T i l e I m a g e                                                       % O %                                                                             %*O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %/E %  Function XTileImage loads or deletes a selected tile from a visualhG %  image directory.  The load or delete command is choosen from a menu.> %g+ %  The format of the XTileImage routine is:y %sF %    tiled_image=XTileImage(display,resource_info,windows,image,event) % + %  A description of each parameter follows:  % @ %    o tiled_image:  XTileImage reads or deletes the tiled imageD %      and returns it.  A null image is returned if an error occurs. %gE %    o display: Specifies a connection to an X server;  returned fromo %      XOpenDisplay. %RK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %gE %    o image: Specifies a pointer to a Image structure; returned fromt %      ReadImage.i %eH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.; %  %  */C static Image *XTileImage(display,resource_info,windows,image,event)r Displayz   *display;   
 XResourceInfos   *resource_info;i   XWindows   *windows;    Imageo	   *image;e   XEvent	   *event;s {& #define LoadVerbOp  0m #define DeleteVerbOp  1r, #define LoadVerbText  "  Loading image...  "     char     command[MaxTextLength],      filename[MaxTextLength];     Image*     *tiled_image;      intw	     tile,n	     verb,.     x,     y;     register chari     *p,a     *q;e     register int     i;  
   static char      *VerbMenu[]=     {-
       "Load",m       "Delete",        (char *) NULL,     };     unsigned int     height,w
     width;     unsigned longw     scale_factor;      /**     Select a command from the pop-up menu.   */A   verb=XMenuWidget(display,windows,"Tile Verb",VerbMenu,command);n   if (verb < 0))     return((Image *) NULL);    /*:     Tile image is relative to montage image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows;:4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;p%   event->xbutton.x+=windows->image.x;m>   event->xbutton.x=DownShift(event->xbutton.x*scale_factor)+x;=   scale_factor=UpShift(height)/windows->image.ximage->height;a%   event->xbutton.y+=windows->image.y;g>   event->xbutton.y=DownShift(event->xbutton.y*scale_factor)+y;   /*L     Determine size and location of each tile in tghe visual image directory.   */   x=0;   y=0;   width=image->columns;d   height=image->rows;(=   (void) XParseGeometry(image->montage,&x,&y,&width,&height);i@   tile=((event->xbutton.y-y)/height)*((image->columns-x)/width)+     (event->xbutton.x-x)/width;    if (tile < 0)n     {a       /*)         Button press is outside any tile.a       */       XBell(display,0);l       return((Image *) NULL);i     }m   /*0     Determine file name from the tile directory.   */   p=image->directory;w*   for (i=tile; (i != 0) && (*p != '\0'); )   {)     if (*p == '\n') 
       i--;     p++;   }    if (*p == '\0')      {_       /*)         Button press is outside any tile.r       */       XBell(display,0);t       return((Image *) NULL);e     }i   q=p;&   while ((*q != '\n') && (*q != '\0'))     q++;!   (void) strncpy(filename,p,q-p);i   filename[q-p]='\0';    /**     Perform command for the selected tile.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   tiled_image=(Image *) NULL;    switch (verb).   {      case DeleteVerbOp:     {(	       into         status,,         x_offset,          y_offset;s         register RunlengthPacket         *p;,         /*         Delete tile image.       */L       status=XConfirmWidget(display,windows,"Really delete tile?",filename);       if (status == False)         break;       status=unlink(filename);       if (status != False)	         {iG           XNoticeWidget(display,windows,"Unable to delete image file:",              filename);           break;	         }m       /*-         Overwrite tile with background color.;       */"       if (!UncompressImage(image))         return((Image *) NULL);h;       x_offset=width*(tile % ((image->columns-x)/width))+x;c:       y_offset=height*(tile/((image->columns-x)/width))+y;        for (y=0; y < height; y++)       {,?         p=image->pixels+((y_offset+y)*image->columns+x_offset); !         for (x=0; x < width; x++)a            *p++=(*image->pixels);       }*9       windows->image.window_changes.width=image->columns;i7       windows->image.window_changes.height=image->rows; C       XConfigureImageColormap(display,resource_info,windows,image);oB       (void) XConfigureImage(display,resource_info,windows,image);       break;     }r     case LoadVerbOp:     {        /*         Load tile image.       */0       XInfoWidget(display,windows,LoadVerbText);,       XCheckRefreshWindows(display,windows);B       (void) strcpy(resource_info->image_info->filename,filename);7       tiled_image=ReadImage(resource_info->image_info);eE       XWithdrawWindow(display,windows->info.id,windows->info.screen);t       break;     }i     default:       break;   }W)   XSetCursorState(display,windows,False);p   return(tiled_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SO %                                                                             % O %                                                                             % O %                                                                             % O %   X T r a n s l a t e I m a g e                                             % O %                                                                             % O %                                                                             %,O %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %aG %  Function XTranslateImage translates the image within an Image windowiM %  by one pixel as specified by the key symbol.  If the image has a `montage'.M %  string the translation is respect to the width and height contained within, %  the string. %(0 %  The format of the XTranslateImage routine is: %u6 %    XTranslateImage(display,windows,image,key_symbol) % + %  A description of each parameter follows:o %nD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %g< %    o windows: Specifies a pointer to a XWindows structure. %eF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.p %eM %    o key_symbol: Specifies a KeySym which indicates which side of the imagec %      to trim.  %  %a */= static void XTranslateImage(display,windows,image,key_symbol)s Displayd   *display;s   XWindows   *windows;i   Imageh	   *image;n   KeySym
   key_symbol;t {i   char     text[MaxTextLength];     inti     x,     y;     unsigned int
     x_offset,g
     y_offset;a     /*)     User specified a pan position offset.f   */    x_offset=windows->image.width;!   y_offset=windows->image.height; &   if (image->montage != (char *) NULL)D     (void) XParseGeometry(image->montage,&x,&y,&x_offset,&y_offset);   switch (key_symbol)    {      case XK_Home:a     case XK_KP_Home:     {a1       windows->image.x=windows->image.width >> 1; 2       windows->image.y=windows->image.height >> 1;       break;     }s     case XK_Left:n     case XK_KP_Left:     {g!       windows->image.x-=x_offset;i       break;     }a     case XK_Next:-     case XK_Up:      case XK_KP_Up:     {u!       windows->image.y-=y_offset;f       break;     }      case XK_Right:     case XK_KP_Right:_     {n!       windows->image.x+=x_offset;p       break;     }      case XK_Prior:     case XK_Down:g     case XK_KP_Down:     { !       windows->image.y+=y_offset;C       break;     }      default:       break;   }r   /*     Check boundary conditions.   */   if (windows->image.x < 0)i     windows->image.x=0;y   elseO     if ((windows->image.x+windows->image.width) > windows->image.ximage->width) I       windows->image.x=windows->image.ximage->width-windows->image.width;p   if (windows->image.y < 0)C     windows->image.y=0;p   else2     if ((windows->image.y+windows->image.height) >'          windows->image.ximage->height))K       windows->image.y=windows->image.ximage->height-windows->image.height;e   /*     Refresh Image window.    */;   (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,t=     windows->image.height,windows->image.x,windows->image.y);n$   XInfoWidget(display,windows,text);(   XCheckRefreshWindows(display,windows);%   XDrawPanRectangle(display,windows);d:   XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);  }C i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %:O %                                                                             %/O %                                                                             %tO %   X T r i m I m a g e                                                       %aO %                                                                             %iO %                                                                             %sO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %u= %  Function XTrimImage trims the edges from the Image window.: % + %  The format of the XTrimImage routine is:m %z; %    status=XTrimImage(display,resource_info,windows,image)d %,+ %  A description of each parameter follows:t %i? %    o status: Function XTrimImage returns True if the image is;J %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.w %oD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %pK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.d %,< %    o windows: Specifies a pointer to a XWindows structure.< %    o windows: Specifies a pointer to a XWindows structure. % 7 %    o image: Specifies a pointer to a Image structure.  %  %  */C static unsigned int XTrimImage(display,resource_info,windows,image)i Displayd   *display;   
 XResourceInfoW   *resource_info;o   XWindows   *windows;i   Image 	   *image;d {l. #define TrimImageText  "  Trimming image...  "     RectangleInfo>     trim_info;     register int     x,     y;     unsigned long      background,e
     pixel;     /*     Trim edges from image.   */(   XSetCursorState(display,windows,True);-   XInfoWidget(display,windows,TrimImageText);n(   XCheckRefreshWindows(display,windows);2   background=XGetPixel(windows->image.ximage,0,0);/   trim_info.width=windows->image.ximage->width; 2   for (x=0; x < windows->image.ximage->width; x++)   { 5     for (y=0; y < windows->image.ximage->height; y++);     { 1       pixel=XGetPixel(windows->image.ximage,x,y);"       if (pixel != background)         break;     } *     if (y < windows->image.ximage->height)       break;   }W   trim_info.x=x;2   if (trim_info.x == windows->image.ximage->width)     {g-       XSetCursorState(display,windows,False);*E       XWithdrawWindow(display,windows->info.id,windows->info.screen);F       return(False);     }e4   for (x=windows->image.ximage->width-1; x > 0; x--)   {s5     for (y=0; y < windows->image.ximage->height; y++)i     {i1       pixel=XGetPixel(windows->image.ximage,x,y);X       if (pixel != background)         break;     }a*     if (y < windows->image.ximage->height)       break;   }c"   trim_info.width=x-trim_info.x+1;1   trim_info.height=windows->image.ximage->height;(3   for (y=0; y < windows->image.ximage->height; y++)    {*4     for (x=0; x < windows->image.ximage->width; x++)     {;1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     }X)     if (x < windows->image.ximage->width)a       break;   }t   trim_info.y=y;5   for (y=windows->image.ximage->height-1; y > 0; y--)    {d4     for (x=0; x < windows->image.ximage->width; x++)     {a1       pixel=XGetPixel(windows->image.ximage,x,y);:       if (pixel != background)         break;     }/)     if (x < windows->image.ximage->width)c       break;   }e#   trim_info.height=y-trim_info.y+1; 2   if ((trim_info.width != windows->image.width) ||2       (trim_info.height != windows->image.height))     {        /*F         Reconfigure Image window as defined by the trimming rectangle.       */9       XSetCropGeometry(display,windows,&trim_info,image);o:       windows->image.window_changes.width=trim_info.width;<       windows->image.window_changes.height=trim_info.height;B       (void) XConfigureImage(display,resource_info,windows,image);     } )   XSetCursorState(display,windows,False); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    return(True);( }p , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %aO %                                                                             % O %                                                                             %eO %   X V i s u a l D i r e c t o r y I m a g e                                 %NO %                                                                             %eO %                                                                             %UO %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XVisualDirectoryImage creates a Visual Image Directory.  % 6 %  The format of the XVisualDirectoryImage routine is: % F %    loaded_image=XVisualDirectoryImage(display,resource_info,windows) %g+ %  A description of each parameter follows:a %iJ %    o loaded_image: Function XVisualDirectoryImage returns a visual imageK %      directory if it can be created successfully.  Otherwise a null imageu %      is returned.C %rD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %oK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.- %a< %    o windows: Specifies a pointer to a XWindows structure. %, %o */B static Image *XVisualDirectoryImage(display,resource_info,windows) Displayn   *display;_  
 XResourceInfo    *resource_info;u   XWindows   *windows;  {t #define ClientName  "montage"tI #define VisualDirectoryText  "  Creating the Visual Image Directory...  "      char     **filelist,i"     image_geometry[MaxTextLength],     *resource_value,     text[MaxTextLength],     window_id[MaxTextLength];      Imaget     *image,i
     **images;      ImageInfos     local_info;w     int      number_files;(     register int     i,     j;  
   static charr"     filename[MaxTextLength] = "*";     XMontageInfo
     vid_info;h     XResourceInfoe     background_resources,      vid_resources;  
   XrmDatabaset     resource_database;     /*      Request file name from user.   */;   XFileBrowserWidget(display,windows,"Directory",filename);i   if (*filename == '\0')     return((Image *) NULL);s   /*     Expand the filename.   */,   filelist=(char **) malloc(sizeof(char *));!   if (filelist == (char **) NULL)x     {]7       Warning("Memory allocation error",(char *) NULL);        return((Image *) NULL);,     },   number_files=1;g   filelist[0]=filename; +   ExpandFilenames(&number_files,&filelist);;   if (number_files == 0)     {w4       Warning("No image files were found",filename);       return((Image *) NULL);s     }s   /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));t    if (images == (Image **) NULL)     {a7       Warning("Memory allocation error",(char *) NULL); &       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);a       free((char *) filelist);       return((Image *) NULL);r     },   /*/     Get any Visual Image Directory X resources.r   */5   resource_database=resource_info->resource_database;e!   vid_resources=(*resource_info);pH   vid_resources.background_color=XGetResourceInstance(resource_database,3     ClientName,"background",DefaultTileBackground);eN   resource_value=XGetResourceClass(resource_database,ClientName,"borderWidth",     DefaultTileBorderwidth);2   vid_resources.border_width=atoi(resource_value);5   vid_resources.font=resource_info->image_info->font;dH   vid_resources.foreground_color=XGetResourceInstance(resource_database,3     ClientName,"foreground",DefaultTileForeground); F   vid_resources.image_geometry=XGetResourceInstance(resource_database,4     ClientName,"imageGeometry",DefaultTileGeometry);C   vid_resources.matte_color=XGetResourceInstance(resource_database, .     ClientName,"mattecolor",DefaultTileMatte);   /*#     Set image background resources.    */%   background_resources=vid_resources; H   background_resources.foreground_color=resource_info->background_color;+   background_resources.window_id=window_id;mK   (void) sprintf(background_resources.window_id,"0x%lx",windows->image.id); 5   background_resources.image_geometry=image_geometry;o   /*/     Read each image and convert them to a tile.    */   j=0;"   for (i=0; i < number_files; i++)   {e*     XSetCursorState(display,windows,True);*     XCheckRefreshWindows(display,windows);,     local_info=(*resource_info->image_info);$     local_info.filename=filelist[i];     *local_info.magick='\0';)     if (local_info.size == (char *) NULL) 3       local_info.size=vid_resources.image_geometry; !     image=ReadImage(&local_info);a      if (filelist[i] != filename)!       free((char *) filelist[i]);t      if (image == (Image *) NULL)       continue;a     image->scene=j;s     LabelImage(image,"%f"); F     TransformImage(&image,(char *) NULL,vid_resources.image_geometry);     /*&       Center tile on the image window.     */A     XDisplayBackgroundImage(display,&background_resources,image); E     (void) sprintf(text,"   Loaded %d of %d: %s   ",i+1,number_files,n       image->filename); &     XInfoWidget(display,windows,text);*     XCheckRefreshWindows(display,windows);     images[j]=image;     j++;   }*   free((char *) filelist);
   if (j == 0)      { 0       Warning("No images were loaded",filename);       free((char *) images);       return((Image *) NULL);e     }t   /*&     Create the Visual Image Directory.   */3   XInfoWidget(display,windows,VisualDirectoryText);r(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   XGetMontageInfo(&vid_info);    vid_info.number_tiles=j;H   image=XMontageImage(display,&vid_resources,&vid_info,filename,images);)   XSetCursorState(display,windows,False);w   free((char *) images);   if (image != (Image *) NULL)C     XClientMessage(display,windows->image.id,windows->im_protocols,-*       windows->im_next_image,CurrentTime);   return(image); }l s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %oO %                                                                             %rO %                                                                             %eO %   X W a r n i n g                                                           %tO %                                                                             %aO %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %_C %  Function XWarning displays a warning message in a Notice widget.a %;) %  The format of the XWarning routine is:  % " %      XWarning(message,qualifier) %s+ %  A description of each parameter follows:e %mG %    o message: Specifies the message to display before terminating the1 %      program.e %n9 %    o qualifier: Specifies any qualifier to the message.w %a %, */' static void XWarning(message,qualifier)H char   *message,;
   *qualifier;a {X   char     text[MaxTextLength];     if (message == (char *) NULL)n     return;l   (void) strcpy(text,message);   (void) strcat(text,":");0   XNoticeWidget(display,windows,text,qualifier); }a X /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             %eO %                                                                             % O %   X W r i t e I m a g e                                                     %;O %                                                                             % O %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%. %t2 %  Function XWriteImage writes an image to a file. %e, %  The format of the XWriteImage routine is: %f< %    status=XWriteImage(display,resource_info,windows,image) % + %  A description of each parameter follows:g % ? %    o status: Function XWriteImage return True if the image isiJ %      written.  False is returned is there is a memory shortage or if the %      image fails to write. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %nK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %kF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.n %  %r */D static unsigned int XWriteImage(display,resource_info,windows,image) Displayi   *display;r  
 XResourceInfo    *resource_info;s   XWindows   *windows;y   Image=
   **image; { . #define WriteImageText  "  Writing image...  "     char     filename[MaxTextLength];     ImageInfop     *image_info;     int      status;r     register chard     *p;      /*      Request file name from user.   */4   p=(*image)->filename+strlen((*image)->filename)-1;D   while ((p > (*image)->filename) && (*(p-1) != *BasenameSeparator))     p--;   (void) strcpy(filename,p);5   if (resource_info->write_filename != (char *) NULL)k:     (void) strcpy(filename,resource_info->write_filename);7   XFileBrowserWidget(display,windows,"Write",filename);)   if (*filename == '\0')     return(True);s'   image_info=resource_info->image_info;o/   (void) strcpy(image_info->filename,filename); ,   SetImageMagick(resource_info->image_info);1   if ((strcmp(image_info->magick,"JPEG") == 0) ||d.       (strcmp(image_info->magick,"JPG") == 0))     { 
       char         quality[MaxTextLength];)         /*'         Request JPEG quality from user.%       */7       (void) sprintf(quality,"%u",image_info->quality); K       XDialogWidget(display,windows,"Write","Enter JPEG quality:",quality);        if (*quality == '\0')          return(True); (       image_info->quality=atoi(quality);     } 0   if ((strcmp(image_info->magick,"EPS") == 0) ||/       (strcmp(image_info->magick,"PS") == 0) || .       (strcmp(image_info->magick,"PS2") == 0))     { 
       char          geometry[MaxTextLength];         /*3         Request Postscript page geometry from user.        */.       (void) sprintf(geometry,PSPageGeometry);,       if (image_info->page != (char *) NULL)1         (void) strcpy(geometry,image_info->page);%M       XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",h5         "Select Postscript Page Geometry:",geometry);        if (*geometry != '\0')6         image_info->page=PostscriptGeometry(geometry);     }:   /*     Write image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image);o.   XInfoWidget(display,windows,WriteImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);-   (void) strcpy((*image)->filename,filename);e'   status=WriteImage(image_info,*image); )   XSetCursorState(display,windows,False);hA   XWithdrawWindow(display,windows->info.id,windows->info.screen); M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);h   return(status);t }g ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %aO %                                                                             %-O %                                                                             % O %    M a i n                                                                  %nO %                                                                             %aO %                                                                             % O %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%x %( %d */ int main(argc,argv). int)   argc;    char	   **argv;- {f+ #define NotInitialized  (unsigned int) (~0)d     char     *option,     *resource_value,     *server_name;      Image      *image,      *next_image;     ImageInfo      image_info;      intr     i,     x;     unsigned int     compression,     first_scene,     *image_marker,     image_number,      last_scene, 
     matte,
     scene;     unsigned longt
     state;     XResourceInfoa     resource_info;  
   XrmDatabasep     resource_database;     /*     Set defaults.;   */   client_name=(*argv);   display=(Display *) NULL;    first_scene=0;F   image_marker=(unsigned int *) malloc((argc+1)*sizeof(unsigned int));,   if (image_marker == (unsigned int *) NULL)@     Error("Unable to display image","Memory allocation failed");   for (i=0; i <= argc; i++)      image_marker[i]=argc;    image_number=0;t   GetImageInfo(&image_info);   matte=NotInitialized;s   last_scene=0;t'   resource_database=(XrmDatabase) NULL;x   server_name=(char *) NULL;   state=DefaultState;a   /*8     Check for server name specified on the command line.   */   ExpandFilenames(&argc,&argv);    for (i=1; i < argc; i++)   {l     /*)       Check command line for server name.=     */     option=argv[i]; M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+')))y-       if (strncmp("display",option+1,3) == 0)&	         {)           /*'             User specified server name.s           */           i++;           if (i == argc)C             Error("Missing server name on -display",(char *) NULL);%           server_name=argv[i];           break;	         }%   }    /*     Open X server connection.    */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)E     Error("Unable to connect to X server",XDisplayName(server_name));    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); O   resource_value=XGetResourceClass(resource_database,client_name,"compression",      "RunlengthEncoded");4   if (Latin1Compare("qencoded",resource_value) == 0)$     compression=QEncodedCompression;   else,     compression=RunlengthEncodedCompression;   image_info.density= M     XGetResourceClass(resource_database,client_name,"density",(char *) NULL);W   resource_value=eH     XGetResourceClass(resource_database,client_name,"interlace","none");*   image_info.interlace=UndefinedInterlace;0   if (Latin1Compare("none",resource_value) == 0)'     image_info.interlace=NoneInterlace;.0   if (Latin1Compare("line",resource_value) == 0)'     image_info.interlace=LineInterlace;S1   if (Latin1Compare("plane",resource_value) == 0) (     image_info.interlace=PlaneInterlace;1   if (image_info.interlace == UndefinedInterlace)y:     Warning("Unrecognized interlace type",resource_value);B   image_info.page=XGetResourceClass(resource_database,client_name,"     "pageGeometry",(char *) NULL);   resource_value= D     XGetResourceClass(resource_database,client_name,"quality","85");*   image_info.quality=atoi(resource_value);N   resource_value=XGetResourceClass(resource_database,client_name,"scene","0");   scene=atoi(resource_value);    resource_value=yG     XGetResourceClass(resource_database,client_name,"verbose","False"); ,   image_info.verbose=IsTrue(resource_value);   /*     Parse command line.d   */7   for (i=1; ((i <= argc) && !(state & ExitState)); i++)    {X     if (i < argc)        option=argv[i];y     else       if (image_number == 0)         option="logo:"; 
       else         break;M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+')))        switch (*(option+1))       {          case 'b': 	         {n2           if (strncmp("backdrop",option+1,5) == 0)
             {i6               resource_info.backdrop=(*option == '-');               break;
             }:8           if ((strncmp("background",option+1,5) == 0) ||.               (strncmp("bg",option+1,2) == 0))
             {e;               resource_info.background_color=(char *) NULL;e!               if (*option == '-')w                 {                    i++;                    if (i == argc)H                     Error("Missing color on -background",(char *) NULL);9                   resource_info.background_color=argv[i];                  }y               break;
             }a.           if (strncmp("blur",option+1,2) == 0)
             {g!               if (*option == '-')%                 {%                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing factor on -blur",(char *) NULL);                  }                break;
             } -           if (strcmp("border",option+1) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing geometry on -border",(char *) NULL);                  }                break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             { 7               resource_info.border_color=(char *) NULL;%!               if (*option == '-')%                 {                    i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL);e5                   resource_info.border_color=argv[i];r                 }s               break;
             }h5           if (strncmp("borderwidth",option+1,7) == 0)o
             {X+               resource_info.border_width=0;.!               if (*option == '-')e                 {1                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing width on -borderwidth",(char *) NULL); ;                   resource_info.border_width=atoi(argv[i]);g                 }i               break;
             }l.           Error("Unrecognized option",option);           break;	         },         case 'c': 	         {t2           if (strncmp("colormap",option+1,6) == 0)
             {o5               resource_info.colormap=PrivateColormap;C!               if (*option == '-');                 {w                   i++;                    if (i == argc)E                     Error("Missing type on -colormap",(char *) NULL);-!                   option=argv[i]; ;                   resource_info.colormap=UndefinedColormap; ;                   if (Latin1Compare("private",option) == 0)a;                     resource_info.colormap=PrivateColormap;n:                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)G                     Error("Invalid colormap type on -colormap",option);                  }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             { ,               resource_info.number_colors=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL); <                   resource_info.number_colors=atoi(argv[i]);                 }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             {%5               resource_info.colorspace=RGBColorspace;%!               if (*option == '-')M                 {s                   i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL);s!                   option=argv[i];t?                   resource_info.colorspace=UndefinedColorspace;r8                   if (Latin1Compare("gray",option) == 0)                     {a>                       resource_info.colorspace=GRAYColorspace;6                       resource_info.number_colors=256;1                       resource_info.tree_depth=8;                      }e8                   if (Latin1Compare("ohta",option) == 0)<                     resource_info.colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0) ;                     resource_info.colorspace=RGBColorspace;s7                   if (Latin1Compare("xyz",option) == 0)t;                     resource_info.colorspace=XYZColorspace;d9                   if (Latin1Compare("ycbcr",option) == 0)t=                     resource_info.colorspace=YCbCrColorspace;n7                   if (Latin1Compare("yiq",option) == 0)p;                     resource_info.colorspace=YIQColorspace;g9                   if (Latin1Compare("ypbpr",option) == 0) =                     resource_info.colorspace=YPbPrColorspace;07                   if (Latin1Compare("yuv",option) == 0)e;                     resource_info.colorspace=YUVColorspace;eF                   if (resource_info.colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);(                 }S               break;
             }n1           if (strncmp("comment",option+1,4) == 0);
             {d!               if (*option == '-')g                 {/                   i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);c                 };               break;
             } 2           if (strncmp("compress",option+1,3) == 0)
             {a(               compression=NoCompression;!               if (*option == '-')                  {x                   i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL);x!                   option=argv[i]; D                   if (Latin1Compare("runlengthencoded",option) == 0)<                     compression=RunlengthEncodedCompression;                   else>                     if (Latin1Compare("qencoded",option) == 0)6                       compression=QEncodedCompression;                     elseL                       Error("Invalid compression type on -compress",option);                 }+               break;
             }f2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')r                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -crop",(char *) NULL);h                 };               break;
             } .           Error("Unrecognized option",option);           break;	         }o         case 'd': 	         {>/           if (strncmp("debug",option+1,3) == 0) 
             {)3               resource_info.debug=(*option == '-');                break;
             }e/           if (strncmp("delay",option+1,3) == 0) 
             {<$               resource_info.delay=0;!               if (*option == '-')                  {p                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing seconds on -delay",(char *) NULL);t4                   resource_info.delay=atoi(argv[i]);                 }2               break;
             } 1           if (strncmp("density",option+1,3) == 0)d
             { /               image_info.density=(char *) NULL; !               if (*option == '-')t                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];p                 }o               break;
             } 3           if (strncmp("despeckle",option+1,3) == 0)              break;1           if (strncmp("display",option+1,3) == 0)t
             {r(               server_name=(char *) NULL;!               if (*option == '-')                  {m                   i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL);a&                   server_name=argv[i];                 }y4               resource_info.server_name=server_name;               break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             {>4               resource_info.dither=(*option == '-');               break;
             }o.           Error("Unrecognized option",option);           break;	         }s         case 'e':c	         {n.           if (strncmp("edge",option+1,2) == 0)             break;1           if (strncmp("enhance",option+1,2) == 0)g             break;2           if (strncmp("equalize",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }          case 'f':o	         { .           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,3) == 0)
             {t/               resource_info.font=(char *) NULL; !               if (*option == '-')s                 {                    i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);-                   resource_info.font=argv[i];                  }                break;
             } 8           if ((strncmp("foreground",option+1,3) == 0) ||.               (strncmp("fg",option+1,2) == 0))            {:              resource_info.foreground_color=(char *) NULL;               if (*option == '-')                {                  i++;l                  if (i == argc),L                    Error("Missing foreground on -foreground",(char *) NULL);8                  resource_info.foreground_color=argv[i];                }               break;            }.           Error("Unrecognized option",option);           break;	         }s         case 'g':r	         { /           if (strncmp("gamma",option+1,2) == 0) 
             { !               if (*option == '-')a                 {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);                  }                break;
             } 2           if (strncmp("geometry",option+1,2) == 0)
             {f9               resource_info.image_geometry=(char *) NULL; !               if (*option == '-')                  {p                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing geometry on -geometry",(char *) NULL);a7                   resource_info.image_geometry=argv[i];                  }                break;
             }=.           Error("Unrecognized option",option);           break;	         }a         case 'h':r	         { .           if (strncmp("help",option+1,2) == 0)
             {                Usage(True);               break;
             }t.           Error("Unrecognized option",option);           break;	         }          case 'i':f	         {t6           if (strncmp("iconGeometry",option+1,5) == 0)
             {p8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')                  {*                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))M                     Error("Missing geometry on -iconGeometry",(char *) NULL); 6                   resource_info.icon_geometry=argv[i];                 }                break;
             }B0           if (strncmp("iconic",option+1,5) == 0)
             {n4               resource_info.iconic=(*option == '-');               break;
             }n3           if (strncmp("interlace",option+1,3) == 0)a
             {v1               image_info.interlace=NoneInterlace;*!               if (*option == '-')a                 {                    i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace;,9                   if (Latin1Compare("plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);                  }e               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'l': 	         {t/           if (strncmp("label",option+1,2) == 0);
             { !               if (*option == '-')                  {p                   i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }d               break;
             }/.           Error("Unrecognized option",option);           break;	         }          case 'm': 	         {v1           if (strncmp("magnify",option+1,3) == 0) 
             {c&               resource_info.magnify=2;!               if (*option == '-')d                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing level on -magnify",(char *) NULL);p6                   resource_info.magnify=atoi(argv[i]);                 }                break;
             }d-           if (strncmp("map",option+1,3) == 0)w
             {w3               resource_info.map_type=(char *) NULL;n!               if (*option == '-')                  {l                   i++;                    if (i == argc)D                     Error("Missing map type on -map",(char *) NULL);1                   resource_info.map_type=argv[i];                  }e               break;
             } ,           if (strcmp("matte",option+1) == 0)
             {_%               matte=(*option == '-');                break;
             }n4           if (strncmp("mattecolor",option+1,6) == 0)
             {e6               resource_info.matte_color=(char *) NULL;!               if (*option == '-')y                 {d                   i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);4                   resource_info.matte_color=argv[i];                 }e               break;
             }i2           if (strncmp("modulate",option+1,3) == 0)
             {i!               if (*option == '-')                  {e                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing value on -modulate",(char *) NULL);                 }                break;
             } 4           if (strncmp("monochrome",option+1,3) == 0)
             { 8               resource_info.monochrome=(*option == '-');+               if (resource_info.monochrome)                  { 0                   resource_info.number_colors=2;-                   resource_info.tree_depth=8; :                   resource_info.colorspace=GRAYColorspace;                 }                break;
             }r.           Error("Unrecognized option",option);           break;	         }f         case 'n':m	         {).           if (strncmp("name",option+1,2) == 0)
             {;/               resource_info.name=(char *) NULL; !               if (*option == '-')P                 {                    i++;                    if (i == argc)A                     Error("Missing name on -name",(char *) NULL);=-                   resource_info.name=argv[i];                  }m               break;
             } 0           if (strncmp("negate",option+1,2) == 0)             break;/           if (strncmp("noise",option+1,3) == 0);             break;3           if (strncmp("normalize",option+1,3) == 0)[             break;.           Error("Unrecognized option",option);           break;	         }          case 'p': 	         {>.           if (strncmp("page",option+1,3) == 0)
             {r,               image_info.page=(char *) NULL;!               if (*option == '-')a                 {                    i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }r               break;
             } -           if (strncmp("pen",option+1,2) == 0)*
             { !               if (*option == '-')o                 {s                   i++;                    if (i == argc)E                     Error("Missing pen color on -pen",(char *) NULL);                  }                break;
             }p.           Error("Unrecognized option",option);           break;	         }d         case 'q':i	         {.           i++;6           if ((i == argc) || !sscanf(argv[i],"%d",&x))?             Error("Missing quality on -quality",(char *) NULL);%,           image_info.quality=atoi(argv[i]);;           break;	         }a         case 'r': 	         { .           if (strncmp("roll",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -roll",(char *) NULL);                  }                break;
             } 0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')                  {f                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing degrees on -rotate",(char *) NULL);                 }m               break;
             }a.           Error("Unrecognized option",option);           break;	         }y         case 's':r	         {d0           if (strncmp("sample",option+1,2) == 0)
             { !               if (*option == '-')                  {e                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing geometry on -sample",(char *) NULL);p                 }n               break;
             } /           if (strncmp("scene",option+1,3) == 0)e
             {a               first_scene=0;               last_scene=0;e!               if (*option == '-').                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene;gJ                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 }n               break;
             }.1           if (strncmp("sharpen",option+1,3) == 0)t
             {r!               if (*option == '-')e                 {s                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing factor on -sharpen",(char *) NULL);                 }g               break;
             }t/           if (strncmp("shear",option+1,3) == 0)(
             {o!               if (*option == '-')                  {i                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))L                     Error("Missing shear geometry on -shear",(char *) NULL);                 }%               break;
             }%7           if (strncmp("shared_memory",option+1,4) == 0) 
             { ?               resource_info.use_shared_memory=(*option == '-');                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -size",(char *) NULL); *                   image_info.size=argv[i];                 }                break;
             }%.           Error("Unrecognized option",option);           break;	         }          case 't':l	         {p3           if (strncmp("text_font",option+1,3) == 0)g
             { 4               resource_info.text_font=(char *) NULL;!               if (*option == '-')n                 {f                   i++;                    if (i == argc)K                     Error("Missing font name on -text_font",(char *) NULL); 2                   resource_info.text_font=argv[i];                 }d               break;
             }o/           if (strncmp("title",option+1,2) == 0)p
             { 0               resource_info.title=(char *) NULL;!               if (*option == '-')                  {e                   i++;                    if (i == argc)C                     Error("Missing title on -title",(char *) NULL);a.                   resource_info.title=argv[i];                 }c               break;
             }d3           if (strncmp("treedepth",option+1,3) == 0)n
             {s)               resource_info.tree_depth=0;i!               if (*option == '-').                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL); 9                   resource_info.tree_depth=atoi(argv[i]);P                 }                break;
             }s.           Error("Unrecognized option",option);           break;	         }f         case 'u':(	         {L0           if (strncmp("update",option+1,2) == 0)
             {d4               resource_info.update=(*option == '-');!               if (*option == '-')u                 {C                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing seconds on -update",(char *) NULL);4                   resource_info.delay=atoi(argv[i]);                 }%               break;
             } 4           if (strncmp("use_pixmap",option+1,2) == 0)
             { 8               resource_info.use_pixmap=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             } 0           if (strncmp("visual",option+1,2) == 0)
             { 6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')%                 {%                   i++;                    if (i == argc)K                     Error("Missing visual class on -visual",(char *) NULL);:4                   resource_info.visual_type=argv[i];                 }h               break;
             }l.           Error("Unrecognized option",option);           break;	         }a         case 'w':o	         {e0           if (strncmp("window",option+1,2) == 0)
             { 4               resource_info.window_id=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     Error("Missing id, name, or 'root' on -window",M%                       (char *) NULL);t2                   resource_info.window_id=argv[i];                 }                break;
             }_/           if (strncmp("write",option+1,2) == 0)w
             {i9               resource_info.write_filename=(char *) NULL;g!               if (*option == '-')e                 {X                   i++;                    if (i == argc)G                     Error("Missing file name on -write",(char *) NULL);t7                   resource_info.write_filename=argv[i];fB                   if (access(resource_info.write_filename,0) == 0)                     {d                       char"                         answer[2];  =                       (void) fprintf(stderr,"Overwrite %s? ",-6                         resource_info.write_filename);B                       (void) fgets(answer,sizeof(answer)-1,stdin);B                       if (!((*answer == 'y') || (*answer == 'Y')))                          exit(1);                     }g                 }>               break;
             }n.           Error("Unrecognized option",option);           break;	         }g         case '?':(	         {a           Usage(True);           break;	         }a         default:	         {(.           Error("Unrecognized option",option);           break;	         }        }o     else<       for (scene=first_scene; scene <= last_scene ; scene++)       { 
         /*L           Option is a file name: begin by reading image from specified file.
         */2         (void) strcpy(image_info.filename,option);&         if (first_scene != last_scene)           {              char&               filename[MaxTextLength];               /*2               Form filename for multi-part images.             */?             (void) sprintf(filename,image_info.filename,scene); :             if (strcmp(filename,image_info.filename) == 0)I               (void) sprintf(filename,"%s.%u",image_info.filename,scene); 8             (void) strcpy(image_info.filename,filename);           } 0         (void) strcpy(image_info.magick,"MIFF");9         image_info.server_name=resource_info.server_name;e+         image_info.font=resource_info.font; /         image_info.dither=resource_info.dither; 7         image_info.monochrome=resource_info.monochrome; /         resource_info.image_info=(&image_info); %         image=ReadImage(&image_info); $         if (image == (Image *) NULL)           if (i < (argc-1))-             continue;a           else
             {>               state|=ExitState;                break;
             }(
         do	         {y&           if (matte != NotInitialized)             image->matte=matte; 2           if (compression != UndefinedCompression)+             image->compression=compression;>           if (scene != 0)n             image->scene=scene;t           /*J             Transmogrify image as defined by the image processing options.           */2           MogrifyImage(&image_info,i,argv,&image);           /*&             Display image to X server.           */7           if (resource_info.window_id != (char *) NULL)y
             {                /*6                 Display image to a specified X window.               */D               XDisplayBackgroundImage(display,&resource_info,image);               state&=ExitState; 
             }            else             do
             {/               Imagen                 *loaded_image;                 /**                 Display image to X server.               */               loaded_image=uN                 XDisplayImage(display,&resource_info,argv,argc,&image,&state);1               if (loaded_image == (Image *) NULL)X                 break;P               while ((loaded_image != (Image *) NULL) && (!(state & ExitState)))               {a;                 if (loaded_image->montage != (char *) NULL)a                   {a                     /*G                       User selected a visual directory image (montage).%                     */(                     DestroyImage(image);'                     image=loaded_image;                      break;                   } ?                 MogrifyImage(&image_info,i,argv,&loaded_image); J                 next_image=XDisplayImage(display,&resource_info,argv,argc,(                   &loaded_image,&state);*                 if (loaded_image != image)-                   DestroyImage(loaded_image); (                 loaded_image=next_image;               } +             } while (!(state & ExitState)); <           if (resource_info.write_filename != (char *) NULL)
             {                /*                 Write image.               */J               (void) strcpy(image->filename,resource_info.write_filename);3               (void) WriteImage(&image_info,image);a
             }e!           if (image_info.verbose)n!             DescribeImage(image);r           /*+             Proceed to next/previous image.f           */'           if (state & FormerImageState)r'             next_image=image->previous;P           else#             next_image=image->next;.+           if (next_image != (Image *) NULL)t             image=next_image;iI         } while ((next_image != (Image *) NULL) && !(state & ExitState));;
         /*           Free image resources. 
         */1         while (image->previous != (Image *) NULL)s            image=image->previous;         DestroyImages(image); (         if (!(state & FormerImageState)))           image_marker[i]=image_number++;          else           {/             /*(               Proceed to previous image.             */!             for (i--; i > 0; i--)f6               if (image_marker[i] == (image_number-2))                 break;"             if (image_number != 0)               image_number--;o           }f         if (state & ExitState)           break;       }t     if (i == (argc-1))<       if ((resource_info.delay != 0) && (image_number != 1))	         {            /*#             Proceed to first image.x           */           i=0;           image_number=0;p	         }_   }    XCloseDisplay(display);    free((char *) image_marker);%   free((char *) image_info.filename);t
   exit(0);   return(False); }R