 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                                   X   X                                     % O %                                    X X                                      % O %                                     X                                       % O %                                    X X                                      % O %                                   X   X                                     % O %                                                                             % O %                    X11 Utility Routines for ImageMagick.                    % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h" #include "widget.h"    /*   State declarations.  */ #define ControlState  0x0001 #define DefaultState  0x0000 #define ExitState  0x0002    /*   Global declarations. */ static unsigned int    xerror_alert = False;    /*   Forward declarations.  */ int *   Latin1Compare _Declare((char *,char *));  
 static int9   IntensityCompare _Declare((const void *,const void *)), :   PopularityCompare _Declare((const void *,const void *)),5   SceneCompare _Declare((const void *,const void *));    static void O   XMakeImageLSBFirst _Declare((XResourceInfo *,XWindowInfo *,Image *, XImage *,      XImage *)), O   XMakeImageMSBFirst _Declare((XResourceInfo *,XWindowInfo *,Image *, XImage *,      XImage *));   
 static Window 6   XWindowByProperty _Declare((Display *,Window,Atom));   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s T r u e                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function IsTrue returns True if the boolean is "true", "on", "yes" or "1".  % ' %  The format of the IsTrue routine is:  %  %      option=IsTrue(boolean)  % + %  A description of each parameter follows:  % G %    o option: either True or False depending on the boolean parameter.  % 9 %    o boolean: Specifies a pointer to a character array.  %  %  */ unsigned int IsTrue(boolean) char   *boolean;  {    if (boolean == (char *) NULL)      return(False);)   if (Latin1Compare(boolean,"true") == 0)      return(True); '   if (Latin1Compare(boolean,"on") == 0)      return(True); (   if (Latin1Compare(boolean,"yes") == 0)     return(True); &   if (Latin1Compare(boolean,"1") == 0)     return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a t i n 1 C o m p a r e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function Latin1Compare compares two null terminated Latin-1 strings, H %  ignoring case differences, and returns an integer greater than, equalF %  to, or less than 0, according to whether first is lexicographicallyD %  greater than, equal to, or less than second.  The two strings are* %  assumed to be encoded using ISO 8859-1. % . %  The format of the Latin1Compare routine is: % " %      Latin1Compare(first,second) % + %  A description of each parameter follows:  % B %    o first: A pointer to the string to convert to Latin1 string. % C %    o second: A pointer to the string to convert to Latin1 string.  %  %  */ int Latin1Compare(first,second)  char	   *first, 
   *second; {    register unsigned char    *p,    *q;     p=(unsigned char *) first;   q=(unsigned char *) second; &   while ((*p != '\0') && (*q != '\0'))   {      register unsigned char       c,       d;       c=(*p);      d=(*q);      if (c != d)        { 
         /*(           Try lowercasing and try again.
         */'         if ((c >= XK_A) && (c <= XK_Z))            c+=(XK_a-XK_A);          else7           if ((c >= XK_Agrave) && (c <= XK_Odiaeresis)) %             c+=(XK_agrave-XK_Agrave);            else6             if ((c >= XK_Ooblique) && (c <= XK_Thorn)))               c+=(XK_oslash-XK_Ooblique); '         if ((d >= XK_A) && (d <= XK_Z))            d+=(XK_a-XK_A);          else7           if ((d >= XK_Agrave) && (d <= XK_Odiaeresis)) %             d+=(XK_agrave-XK_Agrave); 9           else if ((d >= XK_Ooblique) && (d <= XK_Thorn)) '             d+=(XK_oslash-XK_Ooblique);          if (c != d) &           return(((int) c)-((int) d));       }      p++;     q++;   }     return(((int) *p)-((int) *q)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a t i n 1 U p p e r                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function Latin1Upper copies a null terminated string from source toK %  destination (including the null), changing all Latin-1 lowercase letters G %  to uppercase.  The string is assumed to be encoded using ISO 8859-1.  % , %  The format of the Latin1Upper routine is: %  %      Latin1Upper(string) % + %  A description of each parameter follows:  % G %    o string: A pointer to the string to convert to upper-case Latin1.  %  %  */ static void Latin1Upper(string)  char
   *string; {    unsigned char      c;     c=(*string);   while (c != '\0')    { #     if ((c >= XK_a) && (c <= XK_z))        *string=c-(XK_a-XK_A);     else3       if ((c >= XK_agrave) && (c <= XK_odiaeresis)) (         *string=c-(XK_agrave-XK_Agrave);
       else0         if ((c >= XK_oslash) && (c <= XK_thorn)),           *string=c-(XK_oslash-XK_Ooblique);
     string++;      c=(*string);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 9 %  Function XAnnotateImage annotates the image with text.  % / %  The format of the XAnnotateImage routine is:  % M %    status=XAnnotateImage(display,pixel_info,annotate_info,background,image)  % + %  A description of each parameter follows:  % C %    o status: Function XAnnotateImage returns True if the image is I %      successfully annotated with text.  False is returned is there is a  %      memory shortage.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  % H %    o background: Specifies whether the background color is included in5 %      the annotation.  Must be either True or False;  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */N unsigned int XAnnotateImage(display,pixel_info,annotate_info,background,image) Display    *display;   
 XPixelInfo   *pixel_info;  
 XAnnotateInfo    *annotate_info;    unsigned int
   background;    Image 	   *image;  { 
   ColorPacket      background_color;      GC     annotate_context;      Image      *annotate_image;     int      x,     y;     Pixmap     annotate_pixmap;     register int     i;     register RunlengthPacket     *p,      *q;      unsigned int
     depth,     height, 
     matte,
     width;     Window     root_window;     XGCValues      context_values;      XImage     *annotate_ximage;      /*     Initialize annotated image.    */   if (!UncompressImage(image))     return(False);   /*      Initialize annotated pixmap.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); 7   depth=XDefaultDepth(display,XDefaultScreen(display)); I   annotate_pixmap=XCreatePixmap(display,root_window,annotate_info->width, '     annotate_info->height,(int) depth); '   if (annotate_pixmap == (Pixmap) NULL)      return(False);   /*     Initialize graphics info.    */   context_values.background=0;1   context_values.foreground=(unsigned long) (~0); 4   context_values.font=annotate_info->font_info->fid;H   annotate_context=XCreateGC(display,root_window,GCBackground | GCFont |"     GCForeground,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*     Draw text to pixmap.   */>   XDrawImageString(display,annotate_pixmap,annotate_context,0,?     (int) annotate_info->font_info->ascent,annotate_info->text, !     strlen(annotate_info->text)); $   XFreeGC(display,annotate_context);   /*!     Initialize annotated X image.    */M   annotate_ximage=XGetImage(display,annotate_pixmap,0,0,annotate_info->width, -     annotate_info->height,AllPlanes,ZPixmap); )   if (annotate_ximage == (XImage *) NULL)      return(False);'   XFreePixmap(display,annotate_pixmap);    /*     Initialize annotated image.    */3   annotate_image=AllocateImage((ImageInfo *) NULL); '   if (annotate_image == (Image *) NULL)      return(False);/   annotate_image->columns=annotate_info->width; -   annotate_image->rows=annotate_info->height; G   annotate_image->packets=annotate_image->columns*annotate_image->rows; ,   annotate_image->pixels=(RunlengthPacket *)B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));9   if (annotate_image->pixels == (RunlengthPacket *) NULL)      { #       DestroyImage(annotate_image);        return(False);     }    /*(     Transfer annotated X image to image.   */F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);%   q=image->pixels+y*image->columns+x;    background_color.red=q->red;"   background_color.green=q->green;    background_color.blue=q->blue;   background_color.index=0;    annotate_image->matte=True;    p=annotate_image->pixels; *   for (y=0; y < annotate_image->rows; y++)/     for (x=0; x < annotate_image->columns; x++)      { ?       p->index=(unsigned short) XGetPixel(annotate_ximage,x,y);        if (p->index == 0)	         {            /*3             Set this pixel to the background color.            */&           p->red=background_color.red;*           p->green=background_color.green;(           p->blue=background_color.blue;           p->index=Transparent; 	         } 
       else	         {            /*,             Set this pixel to the pen color.           */<           p->red=XDownScale(pixel_info->annotate_color.red);@           p->green=XDownScale(pixel_info->annotate_color.green);>           p->blue=XDownScale(pixel_info->annotate_color.blue);           p->index=Opaque;	         }        p->length=0;
       p++;     } !   XDestroyImage(annotate_ximage);    /*      Determine annotate geometry.   */F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);M   if ((width != annotate_image->columns) || (height != annotate_image->rows))      { 
       char&         image_geometry[MaxTextLength];         /*         Scale image.       */;       (void) sprintf(image_geometry,"%dx%d!",width,height); C       TransformImage(&annotate_image,(char *) NULL,image_geometry);      } $   if (annotate_info->degrees != 0.0)     {        double         normalized_degrees;          Image          *rotated_image;   	       int          rotations;         /*         Rotate image.        */F       rotated_image=RotateImage(annotate_image,annotate_info->degrees,!         &background_color,False); *       if (rotated_image == (Image *) NULL)         return(False);#       DestroyImage(annotate_image); #       annotate_image=rotated_image;        /*9         Annotation is relative to the degree of rotation.        */0       normalized_degrees=annotate_info->degrees;(       while (normalized_degrees < -45.0)"         normalized_degrees+=360.0;?       for (rotations=0; normalized_degrees > 45.0; rotations++) !         normalized_degrees-=90.0;        switch (rotations % 4)       {          default:         case 0:            break;         case 1: 	         {            /*             Rotate 90 degrees.           */*           x-=annotate_image->columns >> 1;*           y+=annotate_image->columns >> 1;           break;	         }          case 2: 	         {            /*             Rotate 180 degrees.            */%           x-=annotate_image->columns;            break;	         }          case 3: 	         {            /*             Rotate 270 degrees.            */*           x-=annotate_image->columns >> 1;A           y-=annotate_image->rows-(annotate_image->columns >> 1);            break;	         }        }      }    /*"     Composite text onto the image.   */   p=annotate_image->pixels; -   for (i=0; i < annotate_image->packets; i++)    {       if (p->index != Transparent)       p->index=Opaque;     p++;   }    matte=image->matte; ;   CompositeImage(image,OverCompositeOp,annotate_image,x,y);    image->matte=matte;    DestroyImage(annotate_image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t F o n t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XBestFont returns the "best" font.  "Best" is defined as a font J %  specified in the X resource database or a font such that the text widthG %  displayed with the font does not exceed the specified maximum width.  % * %  The format of the XBestFont routine is: % 6 %      font=XBestFont(display,resource_info,text_font) % + %  A description of each parameter follows:  % D %    o font: XBestFont returns a pointer to a XFontStruct structure. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % I %    o text_font:  True is font should be mono-spaced (typewriter style).  %  %  */7 XFontStruct *XBestFont(display,resource_info,text_font)  Display    *display;   
 XResourceInfo    *resource_info;    unsigned int   text_font; { 
   static char 
     *Fonts[]=      { 0       "-adobe-helvetica-medium-r-normal-*-14-*",'       "-*-helvetica-medium-r-*-*-14-*", $       "-*-lucida-medium-r-*-*-14-*",
       "8x13", 
       "6x13",        "fixed",       "variable",        (char *) NULL      },     *TextFonts[]=      { )       "-adobe-courier-medium-r-*-*-14-*", (       "-*-fixed-medium-r-normal-*-14-*",#       "-*-fixed-medium-r-*-*-14-*", 
       "8x13", 
       "6x13",        "fixed",       (char *) NULL      };     char     *font_name,      **p;  
   XFontStruct      *font_info;   !   font_info=(XFontStruct *) NULL;     font_name=resource_info->font;   if (text_font)'     font_name=resource_info->text_font; !   if (font_name != (char *) NULL)      {        /*A         Load preferred font specified in the X resource database.        */2       font_info=XLoadQueryFont(display,font_name);,       if (font_info == (XFontStruct *) NULL)1         Warning("Unable to load font",font_name);      }    /*5     Load fonts from list of fonts until one is found.    */
   p=Fonts;   if (text_font)     p=TextFonts;   while (*p != (char *) NULL)    { *     if (font_info != (XFontStruct *) NULL)       break;)     font_info=XLoadQueryFont(display,*p);      p++;   }    return(font_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t I c o n S i z e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XBestIconSize returns the "best" icon size.  "Best" is defined as L %  an icon size that maintains the aspect ratio of the image.  If the windowH %  manager has preferred icon sizes, one of the preferred sizes is used. % . %  The format of the XBestIconSize routine is: % * %      XBestIconSize(display,window,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */( void XBestIconSize(display,window,image) Display    *display;    XWindowInfo 
   *window;   Image 	   *image;  {  #define MaxIconSize  96      int      i,     number_sizes;      unsigned int     height,      icon_height,     icon_width, 
     width;     unsigned long      scale_factor;      Window     root_window;     XIconSize      *icon_size,      *size_list;      /*G     Determine if the window manager has specified preferred icon sizes.    */   window->width=MaxIconSize;   window->height=MaxIconSize;    icon_size=(XIconSize *) NULL;    number_sizes=0; 2   root_window=XRootWindow(display,window->screen);G   if (XGetIconSizes(display,root_window,&size_list,&number_sizes) != 0) @     if ((number_sizes > 0) && (size_list != (XIconSize *) NULL))       icon_size=size_list;&   if (icon_size == (XIconSize *) NULL)     {        /*3         Window manager does not restrict icon size.        */!       icon_size=XAllocIconSize(); *       if (icon_size == (XIconSize *) NULL)	         { P           Warning("Unable to choose best icon size","Memory allocation failed");           return; 	         }        icon_size->min_width=1; '       icon_size->max_width=MaxIconSize;        icon_size->min_height=1;(       icon_size->max_height=MaxIconSize;       icon_size->width_inc=1;        icon_size->height_inc=1;     }    /*$     Determine aspect ratio of image.   */   width=image->columns;    height=image->rows;    if (window->crop_geometry)F     (void) XParseGeometry(window->crop_geometry,&i,&i,&width,&height);   /*C     Look for an icon size that maintains the aspect ratio of image.    */3   scale_factor=UpShift(icon_size->max_width)/width; =   if (scale_factor > (UpShift(icon_size->max_height)/height)) 7     scale_factor=UpShift(icon_size->max_height)/height; "   icon_width=icon_size->min_width;+   while (icon_width < icon_size->max_width)    { 6     if (icon_width >= (DownShift(width*scale_factor)))       break;%     icon_width+=icon_size->width_inc;    } $   icon_height=icon_size->min_height;-   while (icon_height < icon_size->max_height)    { 8     if (icon_height >= (DownShift(height*scale_factor)))       break;'     icon_height+=icon_size->height_inc;    }    XFree((void *) icon_size);   window->width=icon_width;    window->height=icon_height;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t P i x e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XBestPixel returns a pixel from an array of pixels that is closestO %  to the requested color.  If the color array is NULL, the colors are obtained  %  from the X server.  % + %  The format of the XBestPixel routine is:  % D %      pixel=XBestPixel(display,colormap,colors,number_colors,color) % + %  A description of each parameter follows:  % I %    o pixel: XBestPixel returns the pixel value closest to the requested 
 %      color.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o colormap: Specifies the ID of the X server colormap.  % 7 %    o colors: Specifies an array of XColor structures.  % F %    o number_colors: Specifies the number of XColor structures in the %      color definition array. % J %    o color: Specifies the desired RGB value to find in the colors array. %  %  */< void XBestPixel(display,colormap,colors,number_colors,color) Display    *display;    Colormap   colormap;    XColor
   *colors;   unsigned int   number_colors;   XColor	   *color;  {    double     distance_squared,      min_distance;      int 
     distance,      query_server,      status;      register int     i,     j;     /*<     Find closest representation for the requested RGB color.   */-   status=XAllocColor(display,colormap,color);    if (status != 0)     return; )   query_server=colors == (XColor *) NULL;    if (query_server)      {        /*         Read X server colormap.        */=       colors=(XColor *) malloc(number_colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)M         Error("Unable to read X server colormap","Memory allocation failed"); '       for (i=0; i < number_colors; i++) *         colors[i].pixel=(unsigned long) i;       if (number_colors > 256)         number_colors=256;:       XQueryColors(display,colormap,colors,number_colors);     } #   min_distance=3.0*65536.0*65536.0;    color->pixel=colors[0].pixel;    j=0;#   for (i=0; i < number_colors; i++)    { 2     distance=(int) colors[i].red-(int) color->red;8     distance_squared=(unsigned int) (distance*distance);6     distance=(int) colors[i].green-(int) color->green;9     distance_squared+=(unsigned int) (distance*distance); 4     distance=(int) colors[i].blue-(int) color->blue;9     distance_squared+=(unsigned int) (distance*distance); (     if (distance_squared < min_distance)       { &         min_distance=distance_squared;%         color->pixel=colors[i].pixel;          j=i;       }    } 2   (void) XAllocColor(display,colormap,&colors[j]);   if (query_server)      free((char *) colors); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t V i s u a l I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XBestVisualInfo returns visual information for a visual that is 9 %  the "best" the server supports.  "Best" is defined as:  % J %    1. Restrict the visual list to those supported by the default screen. % K %    2. If a visual type is specified, restrict the visual list to those of  %       that type. % I %    3. If a map type is specified, choose the visual that matches the id + %       specified by the Standard Colormap.  % F %    4  From the list of visuals, choose one that can display the mostJ %       simultaneous colors.  If more than one visual can display the sameF %       number of simultaneous colors, one is choosen based on a rank. % 0 %  The format of the XBestVisualInfo routine is: % B %      visual_info=XBestVisualInfo(display,map_info,resource_info) % + %  A description of each parameter follows:  % J %    o visual_info: XBestVisualInfo returns a pointer to a X11 XVisualInfo %      structure.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */< XVisualInfo *XBestVisualInfo(display,map_info,resource_info) Display    *display;    XStandardColormap    *map_info;  
 XResourceInfo    *resource_info;  {  #define MaxStandardColormaps  7 * #define XVisualColormapSize(visual_info) \O   ((visual_info->class == TrueColor) || (visual_info->class == DirectColor) ? \ P     visual_info->red_mask | visual_info->green_mask | visual_info->blue_mask : \     visual_info->colormap_size)      char     *map_type,     *visual_type;      int      number_visuals;      register int     i;     unsigned int     visual_mask;  
   XVisualInfo      *visual_info,      *visual_list,      visual_template;     /*,     Restrict visual search by screen number.   */#   map_type=resource_info->map_type; )   visual_type=resource_info->visual_type;    visual_mask=VisualScreenMask; 1   visual_template.screen=XDefaultScreen(display); #   if (visual_type != (char *) NULL)      {        /*5         Restrict visual search by class or visual id.        */7       if (Latin1Compare("staticgray",visual_type) == 0) 	         { '           visual_mask|=VisualClassMask; +           visual_template.class=StaticGray; 	         } 
       else8         if (Latin1Compare("grayscale",visual_type) == 0)           { )             visual_mask|=VisualClassMask; ,             visual_template.class=GrayScale;           }          else<           if (Latin1Compare("staticcolor",visual_type) == 0)
             { +               visual_mask|=VisualClassMask; 0               visual_template.class=StaticColor;
             }            else>             if (Latin1Compare("pseudocolor",visual_type) == 0)               { -                 visual_mask|=VisualClassMask; 2                 visual_template.class=PseudoColor;               }              else>               if (Latin1Compare("truecolor",visual_type) == 0)                 { /                   visual_mask|=VisualClassMask; 2                   visual_template.class=TrueColor;                 }                elseB                 if (Latin1Compare("directcolor",visual_type) == 0)                   { 1                     visual_mask|=VisualClassMask; 6                     visual_template.class=DirectColor;                   }                  else@                   if (Latin1Compare("default",visual_type) == 0)                     { 0                       visual_mask|=VisualIDMask;C                       visual_template.visualid=XVisualIDFromVisual( I                         XDefaultVisual(display,XDefaultScreen(display)));                      }                    else.                     if (isdigit(*visual_type))                       { 2                         visual_mask|=VisualIDMask;1                         visual_template.visualid= ?                           strtol(visual_type,(char **) NULL,0);                        }                      elseF                       Warning("Invalid visual specifier",visual_type);     }    /*2     Get all visuals that meet our criteria so far.   */   number_visuals=0; B   visual_list=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); .   visual_mask=VisualScreenMask | VisualIDMask;E   if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL))      {        /*<         Failed to get visual;  try using the default visual.       */2       Warning("Unable to get visual",visual_type);       visual_template.visualid= M         XVisualIDFromVisual(XDefaultVisual(display,XDefaultScreen(display))); F       visual_list=XGetVisualInfo(display,visual_mask,&visual_template,         &number_visuals); I       if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL)) %         return((XVisualInfo *) NULL); K       Warning("Using default visual",XVisualClassName(visual_list->class));      } &   resource_info->color_recovery=False;    if (map_type != (char *) NULL)     { 
       Atom         map_property;   
       char          map_name[MaxTextLength];  	       int 
         j,         number_maps,         status;          Window         root_window;         XStandardColormap          *map_list;         /*<         Choose a visual associated with a standard colormap.       */?       root_window=XRootWindow(display,XDefaultScreen(display));        status=0; '       if (strcmp(map_type,"list") != 0) 	         {            /*-             User specified Standard Colormap.            */B           (void) sprintf((char *) map_name,"RGB_%s_MAP",map_type);            Latin1Upper(map_name);C           map_property=XInternAtom(display,(char *) map_name,True); *           if (map_property == (Atom) NULL)>             Error("Unable to get Standard Colormap",map_type);M           status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,              map_property);	         } 
       else	         {            static char              *colormap[]=
             { (               "_HP_RGB_SMOOTH_MAP_LIST",               "RGB_BEST_MAP",                 "RGB_DEFAULT_MAP",               "RGB_GRAY_MAP",                "RGB_RED_MAP",               "RGB_GREEN_MAP",               "RGB_BLUE_MAP",              };             /*3             Choose a standard colormap from a list.            */2           for (i=0; i < MaxStandardColormaps; i++)           { ?             map_property=XInternAtom(display,colormap[i],True); ,             if (map_property == (Atom) NULL)               continue; O             status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,                map_property);             if (status != 0)               break;           } P           resource_info->color_recovery=(i == 0);  /* _HP_RGB_SMOOTH_MAP_LIST */	         }        if (status == 0):         Error("Unable to get Standard Colormap",map_type);       /*E         Search all Standard Colormaps and visuals for ids that match.        */       *map_info=map_list[0]; #ifndef PRE_R4_ICCCMJ       visual_template.visualid=XVisualIDFromVisual(visual_list[0].visual);%       for (i=0; i < number_maps; i++) *         for (j=0; j < number_visuals; j++)%           if (map_list[i].visualid == 9               XVisualIDFromVisual(visual_list[j].visual)) 
             { $               *map_info=map_list[i];'               visual_template.visualid= ;                 XVisualIDFromVisual(visual_list[j].visual);                break;
             } 9       if (map_info->visualid != visual_template.visualid) F         Error("Unable to match visual to Standard Colormap",map_type); #endif0       if (map_info->colormap == (Colormap) NULL)?         Error("Standard Colormap is not initialized",map_type);        XFree((void *) map_list);      }    else     {        static unsigned int          rank[]=            {              StaticGray,              GrayScale,             StaticColor,             DirectColor,             TrueColor,             PseudoColor            };         XVisualInfo          *p;          /*C         Pick one visual that displays the most simultaneous colors.        */       visual_info=visual_list;       p=visual_list;(       for (i=1; i < number_visuals; i++)       {          p++;F         if (XVisualColormapSize(p) > XVisualColormapSize(visual_info))           visual_info=p;         elseI           if (XVisualColormapSize(p) == XVisualColormapSize(visual_info)) :             if (rank[p->class] > rank[visual_info->class])               visual_info=p;       } H       visual_template.visualid=XVisualIDFromVisual(visual_info->visual);     }    XFree((void *) visual_list);   /*7     Retrieve only one visual by its screen & id number.    */B   visual_info=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); E   if ((number_visuals == 0) || (visual_info == (XVisualInfo *) NULL)) !     return((XVisualInfo *) NULL);    return(visual_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h e c k R e f r e s h W i n d o w s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCheckRefreshWindows checks the X server for exposure events forL %  a particular window and updates the area associated withe exposure event. % 5 %  The format of the XCheckRefreshWindows routine is:  % , %      XCheckRefreshWindows(display,windows) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %  %  */* void XCheckRefreshWindows(display,windows) Display    *display;    XWindows   *windows;  {    XEvent
     event;     XDelay(display,SuspendTime);K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) A     (void) XCommandWidget(display,windows,(char **) NULL,&event); I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event)) 3     XRefreshWindow(display,&windows->image,&event); #   XDelay(display,SuspendTime << 1); K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) A     (void) XCommandWidget(display,windows,(char **) NULL,&event); I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event)) 3     XRefreshWindow(display,&windows->image,&event);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t M e s s a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XClientMessage sends a message to a window with XSendEvent.  TheC %  message is initialized with a particular protocol type and atom.  % 0 %  The format of the XClientMessage function is: % @ %      XClientMessage(display,window,protocol,message,timestamp) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  % ) %    o protocol: Specifies an atom value.  % E %    o message: Specifies an atom value which is the message to send.  % 1 %    o timestamp: Specifies a value of type Time.  %  %  */> void XClientMessage(display,window,protocol,message,timestamp) Display    *display;    Window
    window;   Atom   protocol, 
   message;   Time   timestamp; {    XClientMessageEvent      client_event;   "   client_event.type=ClientMessage;   client_event.window=window; %   client_event.message_type=protocol;    client_event.format=32; !   client_event.data.l[0]=message; #   client_event.data.l[1]=timestamp; ?   XSendEvent(display,window,False,0L,(XEvent *) &client_event);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t W i n d o w                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XClientWindow finds a window, at or below the specified window, M %  which has a WM_STATE property.  If such a window is found, it is returned, - %  otherwise the argument window is returned.  % / %  The format of the XClientWindow function is:  % 9 %      client_window=XClientWindow(display,target_window)  % + %  A description of each parameter follows:  % O %    o client_window: XClientWindow returns a window, at or below the specified C %      window, which has a WM_STATE property otherwise the argument ! %      target_window is returned.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o target_window: Specifies the window to find a WM_STATE property.  %  %  */+ Window XClientWindow(display,target_window)  Display    *display;    Window   target_window; {    Atom
     state,	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     number_items;      Window     client_window;  -   state=XInternAtom(display,"WM_STATE",True);    if (state == (Atom) NULL)      return(target_window);   type=(Atom) NULL; D   status=XGetWindowProperty(display,target_window,state,0L,0L,False,E     (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data); 3   if ((status == Success) && (type != (Atom) NULL))      return(target_window);?   client_window=XWindowByProperty(display,target_window,state); %   if (client_window == (Window) NULL)      return(target_window);   return(client_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n s t r a i n W i n d o w P o s i t i o n                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % $ %  Function XConstrainWindowPosition % 9 %  The format of the XConstrainWindowPosition routine is:  % 4 %      XConstrainWindowPosition(display,window_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowInfo structure.  %  %  */2 void XConstrainWindowPosition(display,window_info) Display    *display;    XWindowInfo    *window_info;  {    unsigned int
     limit;  F   limit=XDisplayWidth(display,window_info->screen)-window_info->width;   if (window_info->x < 0)      window_info->x=0;    else     if (window_info->x > limit)        window_info->x=limit; H   limit=XDisplayHeight(display,window_info->screen)-window_info->height;   if (window_info->y < 0)      window_info->y=0;    else     if (window_info->y > limit)        window_info->y=limit;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e l a y                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDelay suspends program execution for the number of milliseconds
 %  specified.  % & %  The format of the Delay routine is: % # %      XDelay(display,milliseconds)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % I %    o milliseconds: Specifies the number of milliseconds to delay before  %      returning.  %  %  */! void XDelay(display,milliseconds)  Display    *display;   
 unsigned long    milliseconds;  {    (void) XFlush(display);    if (milliseconds == 0)     return;  #ifndef vms  #ifdef sysv    {  #include <sys/poll.h>   =     (void) poll((struct pollfd *) NULL,0,(int) milliseconds);    }  #else    {      struct timeval       timer;  #     timer.tv_sec=milliseconds/1000; -     timer.tv_usec=(milliseconds % 1000)*1000; O     (void) select(0,(XFD_SET *) NULL,(XFD_SET *) NULL,(XFD_SET *) NULL,&timer);    }  #endif #else    { 	     float        timer;       timer=milliseconds/1000.0;     lib$wait(&timer);    }  #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e s t r o y W i n d o w C o l o r s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XDestroyWindowColors frees X11 color resources previously saved on= %  a window by XRetainWindowColors or programs like xsetroot.  % 5 %  The format of the XDestroyWindowColors routine is:  % + %      XDestroyWindowColors(display,window)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  %  %  */) void XDestroyWindowColors(display,window)  Display    *display;    Window	   window;  {    Atom
     property, 	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     length;      /*E     If there are previous resources on the root window, destroy them.    */5   property=XInternAtom(display,"_XSETROOT_ID",False);    if (property == (Atom) NULL)     { <       Warning("Unable to create X property","_XSETROOT_ID");
       return;      } ?   status=XGetWindowProperty(display,window,property,0L,1L,True, ?     (Atom) AnyPropertyType,&type,&format,&length,&after,&data);    if (status != Success)     return; M   if ((type == XA_PIXMAP) && (format == 32) && (length == 1) && (after == 0))      { 6       XKillClient(display,(XID) (*((Pixmap *) data)));/       XDeleteProperty(display,window,property);      }    if (type != None)      XFree((void *) data);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y I m a g e I n f o                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XDisplayImageInfo displays information about an X image. % 2 %  The format of the XDisplayImageInfo routine is: % = %      XDisplayImageInfo(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */; void XDisplayImageInfo(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {    char
     *text,     **textlist,      title[MaxTextLength];      int      length;      Image      *p;      unsigned int
     count;     /*@     Display information about the image in the Text View widget.   */   length=11*MaxTextLength;(   if (image->directory != (char *) NULL)%     length+=strlen(image->directory); '   if (image->comments != (char *) NULL) $     length+=strlen(image->comments);,   text=(char *) malloc(length*sizeof(char));   if (text == (char *) NULL)     { D       XNoticeWidget(display,windows,"Unable to display image info:",$         "Memory allocation failed");
       return;      } :   (void) sprintf(title," Image Info: %s",image->filename);*   (void) sprintf(text,"X\n  visual: %s\n",,     XVisualClassName(windows->image.class));K   (void) sprintf(text,"%s  depth: %d\n",text,windows->image.ximage->depth); 5   if (windows->image.visual_info->colormap_size != 0) 7     (void) sprintf(text,"%s  colormap size: %d\n",text, 1       windows->image.visual_info->colormap_size); /   if (resource_info->colormap== SharedColormap) 4     (void) strcat(text,"  colormap type: Shared\n");   else5     (void) strcat(text,"  colormap type: Private\n"); 3   (void) sprintf(text,"%s  geometry: %dx%d\n",text, @     windows->image.ximage->width,windows->image.ximage->height);4   if (windows->image.crop_geometry != (char *) NULL)7     (void) sprintf(text,"%s  crop geometry: %s\n",text, $       windows->image.crop_geometry);-   if (windows->image.pixmap == (Pixmap) NULL) ,     (void) strcat(text,"  type: X Image\n");   else+     (void) strcat(text,"  type: Pixmap\n"); #   if (windows->image.shared_memory) 2     (void) strcat(text,"  shared memory: True\n");   else3     (void) strcat(text,"  shared memory: False\n");    (void) strcat(text,"\n"); D   (void) sprintf(text,"%sImage\n  file: %s\n",text,image->filename);"   if (image->class == DirectClass)1     (void) strcat(text,"  class: DirectClass\n");    else1     (void) strcat(text,"  class: PseudoClass\n"); "   if (image->class == PseudoClass)-     if (image->total_colors <= image->colors) A       (void) sprintf(text,"%s  colors: %u\n",text,image->colors);      elseK       (void) sprintf(text,"%s  colors: %lu=>%u\n",text,image->total_colors,          image->colors); (   if (image->signature != (char *) NULL)E     (void) sprintf(text,"%s  signature: %s\n",text,image->signature);    if (image->matte) *     (void) strcat(text,"  matte: True\n");   else+     (void) strcat(text,"  matte: False\n"); 4   if (image->packets < (image->columns*image->rows))P     (void) sprintf(text,"%s  runlength packets: %u of %u\n",text,image->packets,"       image->columns*image->rows);3   (void) sprintf(text,"%s  geometry: %ux%u\n",text,       image->columns,image->rows);;   (void) sprintf(text,"%s  depth: %u\n",text,image->depth);    if (image->filesize != 0) A     (void) sprintf(text,"%s  bytes: %ld\n",text,image->filesize); =   (void) sprintf(text,"%s  format: %s\n",text,image->magick); 
   p=image;'   while (p->previous != (Image *) NULL)      p=p->previous;3   for (count=1; p->next != (Image *) NULL; count++)      p=p->next;   if (count > 1)I     (void) sprintf(text,"%s  scene: %u of %u\n",text,image->scene,count);    else     if (image->scene != 0)?       (void) sprintf(text,"%s  scene: %u\n",text,image->scene); &   if (image->montage != (char *) NULL)A     (void) sprintf(text,"%s  montage: %s\n",text,image->montage); (   if (image->directory != (char *) NULL)H     (void) sprintf(text,"%s  directory:\n\n%s\n",text,image->directory);$   if (image->label != (char *) NULL)=     (void) sprintf(text,"%s  label: %s\n",text,image->label); '   if (image->comments != (char *) NULL) D     (void) sprintf(text,"%s  comments:\n\n%s",text,image->comments);   textlist=StringToList(text);!   if (textlist != (char **) NULL)      {        register int
         i;  I       XTextViewWidget(display,resource_info,windows,True,title,textlist); 2       for (i=0; textlist[i] != (char *) NULL; i++)#         free((char *) textlist[i]);        free((char *) textlist);     }    free((char *) text); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     X D i t h e r I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XDitherImage dithers the reference image as required by the HPM %  Color Recovery algorithm.  The color values are quantized to 3 bits of red J %  and green, and 2 bits of blue (3/3/2) and can be used as indices into a %  8-bit X standard colormap.  % - %  The format of the XDitherImage routine is:  % ! %      XDitherImage(image,ximage)  % + %  A description of each parameter follows:  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %  %  */& static void XDitherImage(image,ximage) Image 	   *image;    XImage
   *ximage; {    static short int     dither_red[2][16]=     { H       {-16,  4, -1, 11,-14,  6, -3,  9,-15,  5, -2, 10,-13,  7, -4,  8},G       { 15, -5,  0,-12, 13, -7,  2,-10, 14, -6,  1,-11, 12, -8,  3, -9}      },     dither_green[2][16]=     { H       { 11,-15,  7, -3,  8,-14,  4, -2, 10,-16,  6, -4,  9,-13,  5, -1},G       {-12, 14, -8,  2, -9, 13, -5,  1,-11, 15, -7,  3,-10, 12, -6,  0}      },     dither_blue[2][16]=      { H       { -3,  9,-13,  7, -1, 11,-15,  5, -4,  8,-14,  6, -2, 10,-16,  4},G       {  2,-10, 12, -8,  0,-12, 14, -6,  3, -9, 13, -7,  1,-11, 15, -5}      };  
   ColorPacket 
     color;     int 
     value,     y;     register char      *q;      register int     i,     j,     x;     register RunlengthPacket     *p;      unsigned char      *blue_map[2][16],      *green_map[2][16],     *red_map[2][16];     unsigned int     scanline_pad;      register unsigned long
     pixel;     if (!UncompressImage(image))     return;    /*(     Allocate and initialize dither maps.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { H       red_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char));J       green_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char));I       blue_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char)); 6       if ((red_map[i][j] == (unsigned char *) NULL) ||8           (green_map[i][j] == (unsigned char *) NULL) ||5           (blue_map[i][j] == (unsigned char *) NULL)) 	         { G           Warning("Unable to dither image","Memory allocation failed");            return; 	         }      }    /*     Initialize dither tables.    */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)       for (x=0; x < 256; x++)        {          value=x-16;          if (x < 48)            value=x/2+8;          value+=dither_red[i][j];         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB;          red_map[i][j][x]=value;          value=x-16;          if (x < 48)            value=x/2+8;"         value+=dither_green[i][j];         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB; !         green_map[i][j][x]=value;          value=x-32;          if (x < 112)           value=x/2+24; (         value+=(dither_blue[i][j] << 1);         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB;           blue_map[i][j][x]=value;       }    /*     Dither image.    */&   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   i=0;   j=0;   p=image->pixels;   q=ximage->data; !   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { &       color.red=red_map[i][j][p->red];,       color.green=green_map[i][j][p->green];)       color.blue=blue_map[i][j][p->blue]; !       pixel=((color.red & 0xe0) | 5         ((unsigned char) (color.green & 0xe0) >> 3) | 4         ((unsigned char) (color.blue & 0xc0) >> 6));!       *q++=(unsigned char) pixel; 
       p++;
       j++;       if (j == 16)         j=0;     }      q+=scanline_pad;     i++;     if (i == 2) 
       i=0;   }    /*     Free allocated memory.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { %       free((char *) green_map[i][j]); $       free((char *) blue_map[i][j]);#       free((char *) red_map[i][j]);      }  }      /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 1 %  Function XDrawImage draws a line on the image.  % + %  The format of the XDrawImage routine is:  % : %    status=XDrawImage(display,pixel_info,draw_info,image) % + %  A description of each parameter follows:  % ? %    o status: Function XDrawImage returns True if the image is E %      successfully drawd with text.  False is returned is there is a  %      memory shortage.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % ? %    o draw_info: Specifies a pointer to a XDrawInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */; unsigned int XDrawImage(display,pixel_info,draw_info,image)  Display    *display;   
 XPixelInfo   *pixel_info;  	 XDrawInfo 
   *draw_info;    Image 	   *image;  { 
   ColorPacket      background_color;      GC     draw_context;      Image      *draw_image;     int      x,     y;     Pixmap     draw_pixmap;     register int     i;     register RunlengthPacket     *p,      *q;      unsigned int
     depth,     height, 
     matte,
     width;     Window     root_window;     XGCValues      context_values;      XImage     *draw_ximage;      /*     Initialize drawd image.    */   if (!UncompressImage(image))     return(False);   /*     Initialize drawd pixmap.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); 7   depth=XDefaultDepth(display,XDefaultScreen(display)); A   draw_pixmap=XCreatePixmap(display,root_window,draw_info->width, #     draw_info->height,(int) depth); #   if (draw_pixmap == (Pixmap) NULL)      return(False);   /*     Initialize graphics info.    */1   context_values.background=(unsigned long) (~0);    context_values.foreground=0;2   context_values.line_width=draw_info->line_width;J   draw_context=XCreateGC(display,root_window,GCBackground | GCForeground |!     GCLineWidth,&context_values);     if (draw_context == (GC) NULL)     return(False);   /*     Clear pixmap.    */G   XFillRectangle(display,draw_pixmap,draw_context,0,0,draw_info->width,      draw_info->height);    /*     Draw line to pixmap.   */)   XSetBackground(display,draw_context,0); <   XSetForeground(display,draw_context,(unsigned long) (~0));   switch (draw_info->primitive)    {      case LinePrimitive:      default:     { I       XDrawLine(display,draw_pixmap,draw_context,draw_info->line_info.x1, 8         draw_info->line_info.y1,draw_info->line_info.x2,!         draw_info->line_info.y2);        break;     }      case RectanglePrimitive:     { 6       XDrawRectangle(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,J         draw_info->rectangle_info.width,draw_info->rectangle_info.height);       break;     }       case FillRectanglePrimitive:     { 6       XFillRectangle(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,J         draw_info->rectangle_info.width,draw_info->rectangle_info.height);       break;     }    }     XFreeGC(display,draw_context);   /*     Initialize X image.    */A   draw_ximage=XGetImage(display,draw_pixmap,0,0,draw_info->width, )     draw_info->height,AllPlanes,ZPixmap); %   if (draw_ximage == (XImage *) NULL)      return(False);#   XFreePixmap(display,draw_pixmap);    /*     Initialize drawd image.    *//   draw_image=AllocateImage((ImageInfo *) NULL); #   if (draw_image == (Image *) NULL)      return(False);'   draw_image->columns=draw_info->width; %   draw_image->rows=draw_info->height; ;   draw_image->packets=draw_image->columns*draw_image->rows; (   draw_image->pixels=(RunlengthPacket *)B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));5   if (draw_image->pixels == (RunlengthPacket *) NULL)      {        DestroyImage(draw_image);        return(False);     }    /*$     Transfer drawd X image to image.   */B   (void) XParseGeometry(draw_info->geometry,&x,&y,&width,&height);%   q=image->pixels+y*image->columns+x;    background_color.red=q->red;"   background_color.green=q->green;    background_color.blue=q->blue;   background_color.index=0;    draw_image->matte=True;    p=draw_image->pixels; &   for (y=0; y < draw_image->rows; y++)+     for (x=0; x < draw_image->columns; x++)      { ;       p->index=(unsigned short) XGetPixel(draw_ximage,x,y);        if (p->index == 0)	         {            /*3             Set this pixel to the background color.            */&           p->red=background_color.red;*           p->green=background_color.green;(           p->blue=background_color.blue;           p->index=Transparent; 	         } 
       else	         {            /*,             Set this pixel to the pen color.           */<           p->red=XDownScale(pixel_info->annotate_color.red);@           p->green=XDownScale(pixel_info->annotate_color.green);>           p->blue=XDownScale(pixel_info->annotate_color.blue);           p->index=Opaque;	         }        p->length=0;
       p++;     }    XDestroyImage(draw_ximage);    /*     Determine draw geometry.   */B   (void) XParseGeometry(draw_info->geometry,&x,&y,&width,&height);E   if ((width != draw_image->columns) || (height != draw_image->rows))      {        Image          *scaled_image;         /*         Scale image.       */7       scaled_image=ScaleImage(draw_image,width,height); )       if (scaled_image != (Image *) NULL) 	         { #           DestroyImage(draw_image); "           draw_image=scaled_image;	         }      }     if (draw_info->degrees != 0.0)     {        double         normalized_degrees;          Image          *rotated_image;   	       int          rotations;         /*         Rotate image.        */>       rotated_image=RotateImage(draw_image,draw_info->degrees,!         &background_color,False); *       if (rotated_image == (Image *) NULL)         return(False);       DestroyImage(draw_image);        draw_image=rotated_image;        /*9         Annotation is relative to the degree of rotation.        */,       normalized_degrees=draw_info->degrees;(       while (normalized_degrees < -45.0)"         normalized_degrees+=360.0;?       for (rotations=0; normalized_degrees > 45.0; rotations++) !         normalized_degrees-=90.0;        switch (rotations % 4)       {          default:         case 0:            break;         case 1: 	         {            /*             Rotate 90 degrees.           */&           x-=draw_image->columns >> 1;&           y+=draw_image->columns >> 1;           break;	         }          case 2: 	         {            /*             Rotate 180 degrees.            */!           x-=draw_image->columns;            break;	         }          case 3: 	         {            /*             Rotate 270 degrees.            */&           x-=draw_image->columns >> 1;9           y-=draw_image->rows-(draw_image->columns >> 1);            break;	         }        }      }    /*"     Composite text onto the image.   */   p=draw_image->pixels; )   for (i=0; i < draw_image->packets; i++)    {       if (p->index != Transparent)       p->index=Opaque;     p++;   }    matte=image->matte; 7   CompositeImage(image,OverCompositeOp,draw_image,x,y);    image->matte=matte;    DestroyImage(draw_image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E r r o r                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % > %  Function XError ignores BadWindow errors for XQueryTree andM %  XGetWindowAttributes, and ignores BadDrawable errors for XGetGeometry, and M %  ignores BadValue errors for XQueryColor.  It returns False in those cases.  %  Otherwise it returns True.  % ( %  The format of the XError function is: %  %      XError(display,error) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % ( %    o error: Specifies the error event. %  %  */ int XError(display,error)  Display    *display;    XErrorEvent 	   *error;  {    xerror_alert=True;   switch (error->request_code)   {      case X_GetGeometry:      { +       if (error->error_code == BadDrawable)          return(False);       break;     }      case X_GetWindowAttributes:      case X_QueryTree:      { )       if (error->error_code == BadWindow)          return(False);       break;     }      case X_QueryColors:      { (       if (error->error_code == BadValue)         return(False);       break;     }    }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e R e s o u r c e s                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % / %  Function XFreeResources frees X11 resources.  % / %  The format of the XFreeResources routine is:  % H %      XFreeResources(display,visual_info,map_info,pixel_info,font_info,# %        resource_info,window_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % A %    o font_info: Specifies a pointer to a XFontStruct structure.  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  %  %  */F void XFreeResources(display,visual_info,map_info,pixel_info,font_info,   resource_info,window_info) Display    *display;    XVisualInfo    *visual_info;    XStandardColormap    *map_info;  
 XPixelInfo   *pixel_info;   XFontStruct 
   *font_info;   
 XResourceInfo    *resource_info;    XWindowInfo    *window_info;  { *   if (window_info != (XWindowInfo *) NULL)     {        /*         Free X image.        */1       if (window_info->ximage != (XImage *) NULL) +         XDestroyImage(window_info->ximage); +       if (window_info->id != (Window) NULL) 	         {            /*1             Free destroy window and free cursors.            */J           if (window_info->id != XRootWindow(display,visual_info->screen))4             XDestroyWindow(display,window_info->id);9           if (window_info->annotate_context != (GC) NULL) ;             XFreeGC(display,window_info->annotate_context); :           if (window_info->highlight_context != (GC) NULL)<             XFreeGC(display,window_info->highlight_context);7           if (window_info->widget_context != (GC) NULL) 9             XFreeGC(display,window_info->widget_context); 3           XFreeCursor(display,window_info->cursor); 8           XFreeCursor(display,window_info->busy_cursor);	         }      }    /*     Free font.   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info); -   if (map_info != (XStandardColormap *) NULL)      {        /*!         Free X Standard Colormap.        */3       if (resource_info->map_type == (char *) NULL) G         XFreeStandardColormap(display,visual_info,map_info,pixel_info);        XFree((void *) map_info);      }    /*     Free X visual info.    */*   if (visual_info != (XVisualInfo *) NULL)      XFree((void *) visual_info);   XCloseDisplay(display);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e S t a n d a r d C o l o r m a p                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 8 %  Function XFreeStandardColormap frees an X11 colormap. % 6 %  The format of the XFreeStandardColormap routine is: % E %      XFreeStandardColormap(display,visual_info,map_info,pixel_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  %  %  */C void XFreeStandardColormap(display,visual_info,map_info,pixel_info)  Display    *display;    XVisualInfo    *visual_info;    XStandardColormap    *map_info;  
 XPixelInfo   *pixel_info; {    /*     Free colormap.   */   XFlush(display);,   if (map_info->colormap != (Colormap) NULL)L     if (map_info->colormap != XDefaultColormap(display,visual_info->screen))0       XFreeColormap(display,map_info->colormap);     else,       if (pixel_info != (XPixelInfo *) NULL)0         if ((visual_info->class != TrueColor) &&0             (visual_info->class != DirectColor))D           XFreeColors(display,map_info->colormap,pixel_info->pixels,(             (int) pixel_info->colors,0);%   map_info->colormap=(Colormap) NULL; (   if (pixel_info != (XPixelInfo *) NULL)     { 7       if (pixel_info->pixels != (unsigned long *) NULL) *         free((char *) pixel_info->pixels);0       pixel_info->pixels=(unsigned long *) NULL;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t A n n o t a t e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetAnnotateInfo initializes the AnnotateInfo structure. % 0 %  The format of the GetAnnotateInfo routine is: % # %      XGetAnnotateInfo(image_info)  % + %  A description of each parameter follows:  % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  %  %  */$ void XGetAnnotateInfo(annotate_info)
 XAnnotateInfo    *annotate_info;  {    /*"     Initialize annotate structure.   */   annotate_info->x=0;    annotate_info->y=0;    annotate_info->width=0;    annotate_info->height=0;   annotate_info->degrees=0.0; 0   annotate_info->font_info=(XFontStruct *) NULL;$   annotate_info->text=(char *) NULL;    *annotate_info->geometry='\0';1   annotate_info->previous=(XAnnotateInfo *) NULL; -   annotate_info->next=(XAnnotateInfo *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t M a p I n f o                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetMapInfo initializes the XStandardColormap structure. % 2 %  The format of the XStandardColormap routine is: % 1 %      XGetMapInfo(visual_info,colormap,map_info)  % + %  A description of each parameter follows:  % ; %    o colormap: Specifies the ID of the X server colormap.  % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % J %    o map_info: Specifies a pointer to a X11 XStandardColormap structure. %  %  *// void XGetMapInfo(visual_info,colormap,map_info)  XVisualInfo    *visual_info;    Colormap   colormap;    XStandardColormap    *map_info; {    /*     Initialize map info.   */   map_info->colormap=colormap;*   map_info->red_max=visual_info->red_mask;4   map_info->red_mult=map_info->red_max != 0 ? 1 : 0;   if (map_info->red_max != 0) +     while ((map_info->red_max & 0x01) == 0)      {        map_info->red_max>>=1;       map_info->red_mult<<=1;      } .   map_info->green_max=visual_info->green_mask;8   map_info->green_mult=map_info->green_max != 0 ? 1 : 0;   if (map_info->green_max != 0) -     while ((map_info->green_max & 0x01) == 0)      {        map_info->green_max>>=1;       map_info->green_mult<<=1;      } ,   map_info->blue_max=visual_info->blue_mask;6   map_info->blue_mult=map_info->blue_max != 0 ? 1 : 0;   if (map_info->blue_max != 0),     while ((map_info->blue_max & 0x01) == 0)     {        map_info->blue_max>>=1;        map_info->blue_mult<<=1;     }    map_info->base_pixel=0;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t M o n t a g e I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Function XGetMontageInfo initializes the MontageInfo structure. % 0 %  The format of the XGetMontageInfo routine is: % $ %      XGetMontageInfo(montage_info) % + %  A description of each parameter follows:  % D %    o montage_info: Specifies a pointer to a MontageInfo structure. %  %  */" void XGetMontageInfo(montage_info) XMontageInfo   *montage_info; {    montage_info->number_tiles=0;    montage_info->frame=True;    montage_info->shadow=True;+   montage_info->compose=ReplaceCompositeOp;    montage_info->tile="5x4"; &   montage_info->texture=(char *) NULL; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t P i x e l I n f o                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % > %  Function XGetPixelInfo initializes the PixelInfo structure. % . %  The format of the XGetPixelInfo routine is: % F %      XGetPixelInfo(display,visual_info,map_info,resource_info,image, %        pixel_info) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  %  %  */O void XGetPixelInfo(display,visual_info,map_info,resource_info,image,pixel_info)  Display    *display;    XVisualInfo    *visual_info;    XStandardColormap    *map_info;  
 XResourceInfo    *resource_info;    Image 	   *image;   
 XPixelInfo   *pixel_info; { 
   static char      *PenColors[MaxNumberPens]=     {        Pen1Color,       Pen2Color,       Pen3Color,       Pen4Color,       Pen5Color,       Pen6Color,       Pen7Color,       Pen8Color,       Pen9Color,       Pen0Color,     };  
   Colormap
     colormap;      int      status;      register int     i;     unsigned int     packets;     /*     Initialize pixel info.   */   pixel_info->colors=0;    if (image != (Image *) NULL)$     if (image->class == PseudoClass)'       pixel_info->colors=image->colors; K   packets=Max(pixel_info->colors,visual_info->colormap_size)+MaxNumberPens; M   pixel_info->pixels=(unsigned long *) malloc(packets*sizeof(unsigned long)); 3   if (pixel_info->pixels == (unsigned long *) NULL) A     Error("Unable to get pixel info","Memory allocation failed");    /*     Set foreground color.    */   colormap=map_info->colormap;6   (void) XParseColor(display,colormap,ForegroundColor,#     &pixel_info->foreground_color); F   status=XParseColor(display,colormap,resource_info->foreground_color,#     &pixel_info->foreground_color);    if (status == 0)N     Warning("Color is not known to X server",resource_info->foreground_color);%   pixel_info->foreground_color.pixel= =     XStandardPixel(map_info,pixel_info->foreground_color,16); >   pixel_info->foreground_color.flags=DoRed | DoGreen | DoBlue;   /*     Set background color.    */6   (void) XParseColor(display,colormap,BackgroundColor,#     &pixel_info->background_color); F   status=XParseColor(display,colormap,resource_info->background_color,#     &pixel_info->background_color);    if (status == 0)N     Warning("Color is not known to X server",resource_info->background_color);%   pixel_info->background_color.pixel= =     XStandardPixel(map_info,pixel_info->background_color,16); >   pixel_info->background_color.flags=DoRed | DoGreen | DoBlue;   /*     Set border color.    */M   (void) XParseColor(display,colormap,BorderColor,&pixel_info->border_color); B   status=XParseColor(display,colormap,resource_info->border_color,     &pixel_info->border_color);    if (status == 0)J     Warning("Color is not known to X server",resource_info->border_color);!   pixel_info->border_color.pixel= 9     XStandardPixel(map_info,pixel_info->border_color,16); :   pixel_info->border_color.flags=DoRed | DoGreen | DoBlue;   /*     Set matte color.   */7   pixel_info->matte_color=pixel_info->background_color; 2   if (resource_info->matte_color != (char *) NULL)     {        /*J         Matte color is specified as a X resource or command line argument.       */E       status=XParseColor(display,colormap,resource_info->matte_color, "         &pixel_info->matte_color);       if (status == 0)M         Warning("Color is not known to X server",resource_info->matte_color); $       pixel_info->matte_color.pixel=<         XStandardPixel(map_info,pixel_info->matte_color,16);=       pixel_info->matte_color.flags=DoRed | DoGreen | DoBlue;      }    /*     Set highlight color.   */?   pixel_info->highlight_color.red=(pixel_info->matte_color.red* N     HighlightModulate+(unsigned int) (MaxRGB-HighlightModulate)*65535)/MaxRGB;C   pixel_info->highlight_color.green=(pixel_info->matte_color.green* N     HighlightModulate+(unsigned int) (MaxRGB-HighlightModulate)*65535)/MaxRGB;A   pixel_info->highlight_color.blue=(pixel_info->matte_color.blue* N     HighlightModulate+(unsigned int) (MaxRGB-HighlightModulate)*65535)/MaxRGB;$   pixel_info->highlight_color.pixel=<     XStandardPixel(map_info,pixel_info->highlight_color,16);=   pixel_info->highlight_color.flags=DoRed | DoGreen | DoBlue;    /*     Set shadow color.    */-   pixel_info->shadow_color.red=(unsigned int) 8     (pixel_info->matte_color.red*ShadowModulate)/MaxRGB;/   pixel_info->shadow_color.green=(unsigned int) :     (pixel_info->matte_color.green*ShadowModulate)/MaxRGB;.   pixel_info->shadow_color.blue=(unsigned int)9     (pixel_info->matte_color.blue*ShadowModulate)/MaxRGB; !   pixel_info->shadow_color.pixel= 9     XStandardPixel(map_info,pixel_info->shadow_color,16); :   pixel_info->shadow_color.flags=DoRed | DoGreen | DoBlue;   /*     Set depth color.   */,   pixel_info->depth_color.red=(unsigned int)7     (pixel_info->matte_color.red*DepthModulate)/MaxRGB; .   pixel_info->depth_color.green=(unsigned int)9     (pixel_info->matte_color.green*DepthModulate)/MaxRGB; -   pixel_info->depth_color.blue=(unsigned int) 8     (pixel_info->matte_color.blue*DepthModulate)/MaxRGB;    pixel_info->depth_color.pixel=8     XStandardPixel(map_info,pixel_info->depth_color,16);9   pixel_info->depth_color.flags=DoRed | DoGreen | DoBlue;    /*     Set trough color.    */-   pixel_info->trough_color.red=(unsigned int) 8     (pixel_info->matte_color.red*TroughModulate)/MaxRGB;/   pixel_info->trough_color.green=(unsigned int) :     (pixel_info->matte_color.green*TroughModulate)/MaxRGB;.   pixel_info->trough_color.blue=(unsigned int)9     (pixel_info->matte_color.blue*TroughModulate)/MaxRGB; !   pixel_info->trough_color.pixel= 9     XStandardPixel(map_info,pixel_info->trough_color,16); :   pixel_info->trough_color.flags=DoRed | DoGreen | DoBlue;   /*     Set pen color.   */#   for (i=0; i < MaxNumberPens; i++)    { P     (void) XParseColor(display,colormap,PenColors[i],&pixel_info->pen_color[i]);D     status=XParseColor(display,colormap,resource_info->pen_color[i],!       &pixel_info->pen_color[i]);      if (status == 0)L       Warning("Color is not known to X server",resource_info->pen_color[i]);#     pixel_info->pen_color[i].pixel= ;       XStandardPixel(map_info,pixel_info->pen_color[i],16); <     pixel_info->pen_color[i].flags=DoRed | DoGreen | DoBlue;   } :   pixel_info->annotate_color=pixel_info->foreground_color;   if (image != (Image *) NULL)$     if (image->class == PseudoClass)       { 
         /*@           Initialize pixel array for images of type PseudoClass.
         */)         for (i=0; i < image->colors; i++)             pixel_info->pixels[i]=E             XStandardPixel(map_info,image->colormap[i],QuantumDepth); )         for (i=0; i < MaxNumberPens; i++) M           pixel_info->pixels[image->colors+i]=pixel_info->pen_color[i].pixel; *         pixel_info->colors+=MaxNumberPens;       }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e C l a s s                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XGetResourceClass queries the X server for the specified resource F %  name or class.  If the resource name or class is not defined in the4 %  database, the supplied default value is returned. % 2 %  The format of the XGetResourceClass routine is: % M %      value=XGetResourceClass(database,client_name,keyword,resource_default)  % + %  A description of each parameter follows:  % N %    o value: Function XGetResourceClass returns the resource value associatedO %      with the name or class.  If none is found, the supplied default value is  %      returned. % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % M %    o client_name:  Specifies the application name used to retrieve resource ' %      info from the X server database.  % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */F char *XGetResourceClass(database,client_name,keyword,resource_default) XrmDatabase    database;    char   *client_name,    *keyword,    *resource_default; {    char     *resource_type, "     resource_class[MaxTextLength],!     resource_name[MaxTextLength];      int      status;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL)      return(resource_default);    *resource_name='\0';   *resource_class='\0';    if (keyword != (char *) NULL)      {        unsigned char 
         c,
         k;         /*.         Initialize resource keyword and class.       */@       (void) sprintf(resource_name,"%s.%s",client_name,keyword);       c=(*client_name); %       if ((c >= XK_a) && (c <= XK_z))          c-=(XK_a-XK_A); 
       else5         if ((c >= XK_agrave) && (c <= XK_odiaeresis)) #           c-=(XK_agrave-XK_Agrave);          else2           if ((c >= XK_oslash) && (c <= XK_thorn))'             c-=(XK_oslash-XK_Ooblique);        k=(*keyword); %       if ((k >= XK_a) && (k <= XK_z))          k-=(XK_a-XK_A); 
       else5         if ((k >= XK_agrave) && (k <= XK_odiaeresis)) #           k-=(XK_agrave-XK_Agrave);          else2           if ((k >= XK_oslash) && (k <= XK_thorn))'             k-=(XK_oslash-XK_Ooblique); M       (void) sprintf(resource_class,"%c%s.%c%s",c,client_name+1,k,keyword+1);      } M   status=XrmGetResource(database,resource_name,resource_class,&resource_type,      &resource_value);    if (status == False)     return(resource_default);    return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e D a t a b a s e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetResourceDatabase creates a new resource database and %  initializes it. % 5 %  The format of the XGetResourceDatabase routine is:  % 9 %      database=XGetResourceDatabase(display,client_name)  % + %  A description of each parameter follows:  % I %    o database: Function XGetResourceDatabase returns the database after  %      it is initialized.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % M %    o client_name:  Specifies the application name used to retrieve resource ' %      info from the X server database.  %  %  */5 XrmDatabase XGetResourceDatabase(display,client_name)  Display    *display;    char   *client_name;  {    char     filename[MaxTextLength];     register char      *p;      unsigned char      c;  
   XrmDatabase      resource_database,     server_database;     /*!     Initialize resource database.    */   XrmInitialize();+   XGetDefault(display,client_name,"dummy"); ,   resource_database=XrmGetDatabase(display);   /*!     Combine application database.    */#   if (client_name != (char *) NULL)      {        /*         Get basename of client.        */,       p=client_name+(strlen(client_name)-1);.       while ((p > client_name) && (*p != '/'))         p--;       if (*p == '/')         client_name=p+1;     }    c=(*client_name); !   if ((c >= XK_a) && (c <= XK_z))      c-=(XK_a-XK_A);    else1     if ((c >= XK_agrave) && (c <= XK_odiaeresis))        c-=(XK_agrave-XK_Agrave);      else.       if ((c >= XK_oslash) && (c <= XK_thorn))#         c-=(XK_oslash-XK_Ooblique); H   (void) sprintf(filename,"%s%c%s",ApplicationDefaults,c,client_name+1);<   XrmCombineFileDatabase(filename,&resource_database,False);7   if (XResourceManagerString(display) != (char *) NULL)      {        /*          Combine server database.       */L       server_database=XrmGetStringDatabase(XResourceManagerString(display));C       XrmCombineDatabase(server_database,&resource_database,False);      }    /*$     Merge user preferences database.   */D   (void) sprintf(filename,"%s%src",PreferencesDefaults,client_name);   ExpandFilename(filename); <   XrmCombineFileDatabase(filename,&resource_database,False);   return(resource_database); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetResourceInfo initializes the ResourceInfo structure. % 1 %  The format of the XGetResourceInfo routine is:  % D %      XGetResourceInfo(resource_database,client_name,resource_info) % + %  A description of each parameter follows:  % F %    o resource_database: Specifies a resource database; returned from %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */B void XGetResourceInfo(resource_database,client_name,resource_info) XrmDatabase    resource_database;   char   *client_name;   
 XResourceInfo    *resource_info;  {    char     *resource_value;     register char      *p;   #   if (client_name != (char *) NULL)      {        /*         Get basename of client.        */,       p=client_name+(strlen(client_name)-1);.       while ((p > client_name) && (*p != '/'))         p--;       if (*p == '/')         client_name=p+1;     }    /*$     Initialize resource info fields.   */5   resource_info->resource_database=resource_database;    resource_value= H     XGetResourceClass(resource_database,client_name,"backdrop","False");1   resource_info->backdrop=IsTrue(resource_value); I   resource_info->background_color=XGetResourceInstance(resource_database, .     client_name,"background",BackgroundColor);E   resource_info->border_color=XGetResourceInstance(resource_database, +     client_name,"borderColor",BorderColor);    resource_value= G     XGetResourceClass(resource_database,client_name,"borderWidth","2"); 3   resource_info->border_width=atoi(resource_value);    resource_value= I     XGetResourceClass(resource_database,client_name,"colormap","shared"); ,   resource_info->colormap=UndefinedColormap;3   if (Latin1Compare("private",resource_value) == 0) ,     resource_info->colormap=PrivateColormap;2   if (Latin1Compare("shared",resource_value) == 0)+     resource_info->colormap=SharedColormap; 3   if (resource_info->colormap == UndefinedColormap) 9     Warning("Unrecognized colormap type",resource_value); &   resource_info->color_recovery=False;O   resource_value=XGetResourceClass(resource_database,client_name,"colors","0"); 4   resource_info->number_colors=atoi(resource_value);   resource_value= H     XGetResourceClass(resource_database,client_name,"colorspace","rgb");0   resource_info->colorspace=UndefinedColorspace;0   if (Latin1Compare("gray",resource_value) == 0)-     resource_info->colorspace=GRAYColorspace; /   if (Latin1Compare("rgb",resource_value) == 0) ,     resource_info->colorspace=RGBColorspace;0   if (Latin1Compare("ohta",resource_value) == 0)-     resource_info->colorspace=OHTAColorspace; /   if (Latin1Compare("xyz",resource_value) == 0) ,     resource_info->colorspace=XYZColorspace;/   if (Latin1Compare("yiq",resource_value) == 0) ,     resource_info->colorspace=YIQColorspace;/   if (Latin1Compare("yuv",resource_value) == 0) ,     resource_info->colorspace=YUVColorspace;7   if (resource_info->colorspace == UndefinedColorspace) ;     Warning("Unrecognized colorspace type",resource_value);    resource_value= J     XGetResourceClass(resource_database,client_name,"confirmExit","True");5   resource_info->confirm_exit=IsTrue(resource_value);    resource_value= E     XGetResourceClass(resource_database,client_name,"debug","False"); .   resource_info->debug=IsTrue(resource_value);N   resource_value=XGetResourceClass(resource_database,client_name,"delay","0");,   resource_info->delay=atoi(resource_value);   resource_value= E     XGetResourceClass(resource_database,client_name,"dither","True"); /   resource_info->dither=IsTrue(resource_value); P   resource_info->editor_command=XGetResourceClass(resource_database,client_name,#     "editorCommand",EditorCommand);    resource_info->font=J     XGetResourceClass(resource_database,client_name,"font",(char *) NULL);F   resource_info->font=XGetResourceClass(resource_database,client_name,$     "fontList",resource_info->font);   resource_info->font_name[0]=E     XGetResourceClass(resource_database,client_name,"font1","fixed");    resource_info->font_name[1]=H     XGetResourceClass(resource_database,client_name,"font2","variable");   resource_info->font_name[2]=C     XGetResourceClass(resource_database,client_name,"font3","5x8");    resource_info->font_name[3]=D     XGetResourceClass(resource_database,client_name,"font4","6x10");   resource_info->font_name[4]=H     XGetResourceClass(resource_database,client_name,"font5","7x13bold");   resource_info->font_name[5]=H     XGetResourceClass(resource_database,client_name,"font6","8x13bold");   resource_info->font_name[6]=H     XGetResourceClass(resource_database,client_name,"font7","9x15bold");   resource_info->font_name[7]=E     XGetResourceClass(resource_database,client_name,"font8","10x20");    resource_info->font_name[8]=E     XGetResourceClass(resource_database,client_name,"font9","12x24");    resource_info->font_name[9]=E     XGetResourceClass(resource_database,client_name,"font0","fixed"); I   resource_info->foreground_color=XGetResourceInstance(resource_database, .     client_name,"foreground",ForegroundColor);O   resource_info->icon_geometry=XGetResourceClass(resource_database,client_name, "     "iconGeometry",(char *) NULL);   resource_value= G     XGetResourceClass(resource_database,client_name,"gravity","North");    resource_info->gravity=(-1);2   if (Latin1Compare("Forget",resource_value) == 0))     resource_info->gravity=ForgetGravity; 5   if (Latin1Compare("NorthWest",resource_value) == 0) ,     resource_info->gravity=NorthWestGravity;1   if (Latin1Compare("North",resource_value) == 0) (     resource_info->gravity=NorthGravity;5   if (Latin1Compare("NorthEast",resource_value) == 0) ,     resource_info->gravity=NorthEastGravity;0   if (Latin1Compare("West",resource_value) == 0)'     resource_info->gravity=WestGravity; 2   if (Latin1Compare("Center",resource_value) == 0))     resource_info->gravity=CenterGravity; 0   if (Latin1Compare("East",resource_value) == 0)'     resource_info->gravity=EastGravity; 5   if (Latin1Compare("SouthWest",resource_value) == 0) ,     resource_info->gravity=SouthWestGravity;1   if (Latin1Compare("South",resource_value) == 0) (     resource_info->gravity=SouthGravity;5   if (Latin1Compare("SouthEast",resource_value) == 0) ,     resource_info->gravity=SouthEastGravity;2   if (Latin1Compare("Static",resource_value) == 0))     resource_info->gravity=StaticGravity; %   if (resource_info->gravity == (-1))      { :       Warning("Unrecognized gravity type",resource_value);+       resource_info->gravity=CenterGravity;      } ?   (void) getcwd(resource_info->home_directory,MaxTextLength-1);    resource_value= F     XGetResourceClass(resource_database,client_name,"iconic","False");/   resource_info->iconic=IsTrue(resource_value);    resource_value= I     XGetResourceClass(resource_database,client_name,"immutable","False"); 2   resource_info->immutable=IsTrue(resource_value);D   resource_info->image_geometry=XGetResourceClass(resource_database,*     client_name,"geometry",(char *) NULL);P   resource_value=XGetResourceClass(resource_database,client_name,"magnify","3");.   resource_info->magnify=atoi(resource_value);   resource_info->map_type=I     XGetResourceClass(resource_database,client_name,"map",(char *) NULL); D   resource_info->matte_color=XGetResourceInstance(resource_database,,     client_name,"mattecolor",(char *) NULL);   resource_value= J     XGetResourceClass(resource_database,client_name,"monochrome","False");3   resource_info->monochrome=IsTrue(resource_value);    resource_info->name=J     XGetResourceClass(resource_database,client_name,"name",(char *) NULL);N   resource_info->pan_geometry=XGetResourceClass(resource_database,client_name,!     "panGeometry",(char *) NULL);    resource_info->pen_color[0]=D     XGetResourceClass(resource_database,client_name,"pen1","black");   resource_info->pen_color[1]=C     XGetResourceClass(resource_database,client_name,"pen2","blue");    resource_info->pen_color[2]=C     XGetResourceClass(resource_database,client_name,"pen3","cyan");    resource_info->pen_color[3]=D     XGetResourceClass(resource_database,client_name,"pen4","green");   resource_info->pen_color[4]=C     XGetResourceClass(resource_database,client_name,"pen5","gray");    resource_info->pen_color[5]=B     XGetResourceClass(resource_database,client_name,"pen6","red");   resource_info->pen_color[6]=F     XGetResourceClass(resource_database,client_name,"pen7","magenta");   resource_info->pen_color[7]=E     XGetResourceClass(resource_database,client_name,"pen8","yellow");    resource_info->pen_color[8]=D     XGetResourceClass(resource_database,client_name,"pen9","white");   resource_info->pen_color[9]=C     XGetResourceClass(resource_database,client_name,"pen0","gray"); O   resource_info->print_command=XGetResourceClass(resource_database,client_name, !     "printCommand",PrintCommand); P   resource_value=XGetResourceClass(resource_database,client_name,"quantum","1");.   resource_info->quantum=atoi(resource_value);   resource_info->server_name= P     XGetResourceClass(resource_database,client_name,"serverName",(char *) NULL);   resource_value= K     XGetResourceClass(resource_database,client_name,"sharedMemory","True"); :   resource_info->use_shared_memory=IsTrue(resource_value);   resource_info->text_font= J     XGetResourceClass(resource_database,client_name,"font",(char *) NULL);K   resource_info->text_font=XGetResourceClass(resource_database,client_name, )     "textFont",resource_info->text_font);    resource_info->title= K     XGetResourceClass(resource_database,client_name,"title",(char *) NULL);    resource_value= E     XGetResourceClass(resource_database,client_name,"treeDepth","0"); 1   resource_info->tree_depth=atoi(resource_value);    resource_value= F     XGetResourceClass(resource_database,client_name,"update","False");/   resource_info->update=IsTrue(resource_value);    resource_value= I     XGetResourceClass(resource_database,client_name,"usePixmap","False"); 3   resource_info->use_pixmap=IsTrue(resource_value);    resource_info->visual_type= L     XGetResourceClass(resource_database,client_name,"visual",(char *) NULL);   resource_info->window_id= L     XGetResourceClass(resource_database,client_name,"window",(char *) NULL);D   resource_info->write_filename=XGetResourceClass(resource_database,/     client_name,"writeFilename",(char *) NULL);    /*     Handle side-effects.   */    if (resource_info->monochrome)     { %       resource_info->number_colors=2; "       resource_info->tree_depth=8;!       resource_info->dither=True; /       resource_info->colorspace=GRAYColorspace;      } 2   if (resource_info->colorspace == GRAYColorspace)     { '       resource_info->number_colors=256; "       resource_info->tree_depth=8;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n s t a n c e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XGetResourceInstance queries the X server for the specified K %  resource name.  If the resource name is not defined in the database, the & %  supplied default value is returned. % 5 %  The format of the XGetResourceInstance routine is:  % P %      value=XGetResourceInstance(database,client_name,keyword,resource_default) % + %  A description of each parameter follows:  % F %    o value: Function XGetResourceInstance returns the resource valueI %      associated with the name or class.  If none is found, the supplied ! %      default value is returned.  % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */I char *XGetResourceInstance(database,client_name,keyword,resource_default)  XrmDatabase    database;    char   *client_name,    *keyword,    *resource_default; {    char     *resource_type, !     resource_name[MaxTextLength];      int      status;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL)      return(resource_default);    *resource_name='\0';   if (keyword != (char *) NULL) >     (void) sprintf(resource_name,"%s.%s",client_name,keyword);L   status=XrmGetResource(database,resource_name,"ImageMagick",&resource_type,     &resource_value);    if (status == False)     return(resource_default);    return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t S u b w i n d o w                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XGetSubwindow returns the subwindow of a window choosen the , %  user with the pointer and a button press. % . %  The format of the XGetSubwindow routine is: % 2 %      subwindow=XGetSubwindow(display,window,x,y) % + %  A description of each parameter follows:  % N %    o subwindow: Function XGetSubwindow returns NULL if no subwindow is found+ %      otherwise the subwindow is returned.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % / %    o window: Specifies a pointer to a Window.  % G %    o x: the x coordinate of the pointer relative to the origin of the  %      window. % G %    o y: the y coordinate of the pointer relative to the origin of the  %      window. %  %  */( Window XGetSubwindow(display,window,x,y) Display    *display;    Window	   window;    int    x,   y; {    Window     source_window,     target_window;     int      status, 
     x_offset, 
     y_offset;   =   source_window=XRootWindow(display,XDefaultScreen(display));    if (window == (Window) NULL)     return(source_window);   target_window=window; 
   for ( ; ; )    { B     status=XTranslateCoordinates(display,source_window,window,x,y,*       &x_offset,&y_offset,&target_window);     if (status != True)        break;'     if (target_window == (Window) NULL)        break;     source_window=window;      window=target_window;      x=x_offset;      y=y_offset;    } %   if (target_window == (Window) NULL)      target_window=window;    return(target_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w C o l o r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XGetWindowColor returns the color of a pixel interactively choosen %  from the X server.  % 0 %  The format of the XGetWindowColor routine is: % + %      status=XGetWindowColor(display,name)  % + %  A description of each parameter follows:  % M %    o status: Function XGetWindowColor returns True if the color is obtained B %      from the X server.  False is returned if any errors occurs. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % I %    o name: The name of of the color if found in the X Color Database is ) %      returned in this character string.  %  %  */* unsigned int XGetWindowColor(display,name) Display    *display;    char   *name; {    FILE     *database;     int      x,     y;     RectangleInfo      crop_info;     unsigned int     status;      Window
     child,     client_window,     root_window,     target_window;     XColor
     color;     XImage     *ximage;     XWindowAttributes      window_attributes;     /*%     Choose a pixel from the X server.    */2   target_window=XSelectWindow(display,&crop_info);;   root_window=XRootWindow(display,XDefaultScreen(display));    client_window=target_window;#   if (target_window != root_window)      {        unsigned int
         d;         /*         Get client window.       */P       status=XGetGeometry(display,target_window,&root_window,&x,&x,&d,&d,&d,&d);       if (status != 0)	         { =           client_window=XClientWindow(display,target_window); &           target_window=client_window;	         }      }    /*     Verify window is viewable.   */H   status=XGetWindowAttributes(display,target_window,&window_attributes);G   if ((status == False) || (window_attributes.map_state != IsViewable))      return(False);   /*     Get window X image.    */F   XTranslateCoordinates(display,root_window,target_window,crop_info.x,     crop_info.y,&x,&y,&child);D   ximage=XGetImage(display,target_window,x,y,1,1,AllPlanes,ZPixmap);    if (ximage == (XImage *) NULL)     return(False);$   color.pixel=XGetPixel(ximage,0,0);   XDestroyImage(ximage);   /*#     Query X server for pixel color.    */9   XQueryColor(display,window_attributes.colormap,&color); <   (void) sprintf(name,"#%02x%02x%02x",XDownScale(color.red),4     XDownScale(color.green),XDownScale(color.blue));'   database=fopen(RGBColorDatabase,"r");     if (database != (FILE *) NULL)     { 
       char!         colorname[MaxTextLength],          text[MaxTextLength];  	       int 
         blue,          count,         green,         red;         /*1         Match color against the X color database.        */C       while (fgets(text,MaxTextLength-1,database) != (char *) NULL)        { K         count=sscanf(text,"%d %d %d %[^\n]\n",&red,&green,&blue,colorname);          if (count != 4)            continue; -         if ((red == XDownScale(color.red)) && 1             (green == XDownScale(color.green)) && -             (blue == XDownScale(color.blue)))            { *             (void) strcpy(name,colorname);             break;           }        }        (void) fclose(database);     }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function XGetWindowImage reads an image from the target X window and returns M %  it.  XGetWindowImage optionally descends the window hierarchy and overlays . %  the target image with each subwindow image. % 0 %  The format of the XGetWindowImage routine is: % : %      image=XGetWindowImage(display,window,borders,level) % + %  A description of each parameter follows:  % H %    o image: Function XGetWindowImage returns a MIFF image if it can beH %      successfully read from the X window.  A null image is returned if %      any errors occurs.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % = %    o window: Specifies the window to obtain the image from.  % E %    o borders: Specifies whether borders pixels are to be saved with  %      the image.  % E %    o level: Specifies an unsigned integer representing the level of I %      decent in the window hierarchy.  This value must be zero or one on J %      the initial call to XGetWindowImage.  A value of zero returns afterJ %      one call.  A value of one causes the function to descend the windowI %      hierarchy and overlays the target image with each subwindow image.  %  %  */4 Image *XGetWindowImage(display,window,borders,level) Display    *display;    Window	   window;    unsigned int
   borders,   level; {    typedef struct _ColormapList   {      Colormap       colormap;   
     XColor       *colors;       struct _ColormapList       *next;   } ColormapList;      GC     annotate_context;      Image      *image;      int      display_height,      display_width,     number_colors,     status, 
     x_offset, 
     y_offset;      RectangleInfo      crop_info;     register int     i,     x,     y;     register RunlengthPacket     *p;      register unsigned long
     pixel;     static ColormapList +     *colormap_list = (ColormapList *) NULL;      Window
     child,     root_window;     XColor     *colors;     XGCValues      context_values;      XImage     *ximage;     XWindowAttributes      window_attributes;     /*     Verify window is viewable.   */A   status=XGetWindowAttributes(display,window,&window_attributes); G   if ((status == False) || (window_attributes.map_state != IsViewable))      return((Image *) NULL);    /*2     Cropping rectangle is relative to root window.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); K   XTranslateCoordinates(display,window,root_window,0,0,&x_offset,&y_offset,      &child);   crop_info.x=x_offset;    crop_info.y=y_offset; *   crop_info.width=window_attributes.width;,   crop_info.height=window_attributes.height;   if (borders)     {        /*          Include border in image.       */2       crop_info.x-=window_attributes.border_width;2       crop_info.y-=window_attributes.border_width;;       crop_info.width+=window_attributes.border_width << 1; <       crop_info.height+=window_attributes.border_width << 1;     }    /*     Crop to root window.   */   if (crop_info.x < 0)     { 2       if ((crop_info.x+(int) crop_info.width) < 0)         return((Image *) NULL); #       crop_info.width+=crop_info.x;        crop_info.x=0;     }    if (crop_info.y < 0)     { 3       if ((crop_info.y+(int) crop_info.height) < 0)          return((Image *) NULL); $       crop_info.height+=crop_info.y;       crop_info.y=0;     } ?   display_width=XDisplayWidth(display,XDefaultScreen(display)); :   if ((crop_info.x+(int) crop_info.width) > display_width)     { '       if (crop_info.x >= display_width)          return((Image *) NULL); 0       crop_info.width=display_width-crop_info.x;     } A   display_height=XDisplayHeight(display,XDefaultScreen(display)); <   if ((crop_info.y+(int) crop_info.height) > display_height)     { (       if (crop_info.y >= display_height)         return((Image *) NULL); 2       crop_info.height=display_height-crop_info.y;     }    crop_info.x-=x_offset;   crop_info.y-=y_offset;   /*D     Alert user we are about to get an X region by flashing a border.   */I   context_values.background=XBlackPixel(display,XDefaultScreen(display)); I   context_values.foreground=XWhitePixel(display,XDefaultScreen(display)); #   context_values.function=GXinvert;    context_values.plane_mask=:     context_values.background ^ context_values.foreground;1   context_values.subwindow_mode=IncludeInferiors; I   annotate_context=XCreateGC(display,window,GCBackground | GCForeground | @     GCFunction | GCPlaneMask | GCSubwindowMode,&context_values);$   if (annotate_context != (GC) NULL)     { C       XHighlightRegion(display,window,annotate_context,&crop_info); 9       XDelay(display,(unsigned long) (SuspendTime << 2)); C       XHighlightRegion(display,window,annotate_context,&crop_info);      }    /*     Get window X image.    */J   ximage=XGetImage(display,window,crop_info.x,crop_info.y,crop_info.width,(     crop_info.height,AllPlanes,ZPixmap);    if (ximage == (XImage *) NULL)     return((Image *) NULL);    number_colors=0;   colors=(XColor *) NULL; 4   if (window_attributes.colormap != (Colormap) NULL)     {        ColormapList         *p;          /*1         Search colormap list for window colormap.        */:       number_colors=window_attributes.visual->map_entries;B       for (p=colormap_list; p != (ColormapList *) NULL; p=p->next)6         if (p->colormap == window_attributes.colormap)           break;%       if (p == (ColormapList *) NULL) 	         {            /*$             Get the window colormap.           */A           colors=(XColor *) malloc(number_colors*sizeof(XColor)); (           if (colors == (XColor *) NULL)
             { $               XDestroyImage(ximage);%               return((Image *) NULL); 
             } A           if ((window_attributes.visual->class != DirectColor) && =               (window_attributes.visual->class != TrueColor)) -             for (i=0; i < number_colors; i++) 
             {                 colors[i].pixel=i;               colors[i].pad=0;
             }            else
             {                unsigned long                  blue,                  blue_bit,                  green,                 green_bit,                 red,                 red_bit;                 /*0                 DirectColor or TrueColor visual.               */               red=0;               green=0;               blue=0; :               red_bit=window_attributes.visual->red_mask &:                 (~(window_attributes.visual->red_mask)+1);>               green_bit=window_attributes.visual->green_mask &<                 (~(window_attributes.visual->green_mask)+1);<               blue_bit=window_attributes.visual->blue_mask &;                 (~(window_attributes.visual->blue_mask)+1); /               for (i=0; i < number_colors; i++)                { 3                 colors[i].pixel=red | green | blue;                   colors[i].pad=0;                 red+=red_bit; =                 if (red > window_attributes.visual->red_mask)                    red=0;!                 green+=green_bit; A                 if (green > window_attributes.visual->green_mask)                    green=0;                 blue+=blue_bit; ?                 if (blue > window_attributes.visual->blue_mask)                    blue=0;                } 
             } A           XQueryColors(display,window_attributes.colormap,colors,              (int) number_colors);           /*-             Append colormap to colormap list.            */:           p=(ColormapList *) malloc(sizeof(ColormapList));1           p->colormap=window_attributes.colormap;            p->colors=colors;             p->next=colormap_list;           colormap_list=p;	         }        colors=p->colors;      }    /*     Allocate image structure.    */*   image=AllocateImage((ImageInfo *) NULL);   if (image == (Image *) NULL)     {        XDestroyImage(ximage);       return((Image *) NULL);      }    /*#     Convert X image to MIFF format.    */7   if ((window_attributes.visual->class != TrueColor) && 7       (window_attributes.visual->class != DirectColor))      image->class=PseudoClass;    image->columns=ximage->width;    image->rows=ximage->height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)     {        XDestroyImage(ximage);       DestroyImage(image);       return((Image *) NULL);      }    p=image->pixels;   switch (image->class)    {      case DirectClass:      {        register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */2       red_mask=window_attributes.visual->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } 6       green_mask=window_attributes.visual->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } 4       blue_mask=window_attributes.visual->blue_mask;       blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */        if ((number_colors > 0) &&;           (window_attributes.visual->class == DirectColor)) '         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);              p->index=0;              p->length=0;             p++;           } 	         } 
       else'         for (y=0; y < image->rows; y++) ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;F             p->red=XDownScale(((unsigned long) color*65535)/red_mask);6             color=(pixel >> green_shift) & green_mask;J             p->green=XDownScale(((unsigned long) color*65535)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;H             p->blue=XDownScale(((unsigned long) color*65535)/blue_mask);             p->index=0;              p->length=0;             p++;           }        break;     }      case PseudoClass:      {        /*         Create colormap.       */"       image->colors=number_colors;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {             XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { G         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red); K         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green); I         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++) *         for (x=0; x < image->columns; x++)	         { &           pixel=XGetPixel(ximage,x,y);*           p->index=(unsigned short) pixel;           p->length=0;           p++;	         }        SyncImage(image);        break;     }    }    XDestroyImage(ximage);$   if (annotate_context != (GC) NULL)     {        /*<         Alert user we got the X region by flashing a border.       */C       XHighlightRegion(display,window,annotate_context,&crop_info);        XFlush(display);C       XHighlightRegion(display,window,annotate_context,&crop_info); (       XFreeGC(display,annotate_context);     }    if (level != 0)      {        unsigned int         number_children;         Window         *children,         parent;          /*K         Descend the window hierarchy and overlay with each subwindow image.        */F       status=XQueryTree(display,window,&root_window,&parent,&children,         &number_children);5       if ((status == True) && (number_children != 0)) 	         {            Image              *child_image;              /*:             Composite any children in back-to-front order.           */-           for (i=0; i < number_children; i++)            { K             child_image=XGetWindowImage(display,children[i],False,level+1); .             if (child_image != (Image *) NULL)               {                  /*/                   Composite child window image.                  */O                 XTranslateCoordinates(display,children[i],window,0,0,&x_offset, $                   &y_offset,&child);&                 x_offset-=crop_info.x;!                 if (x_offset < 0)                    x_offset=0; &                 y_offset-=crop_info.y;!                 if (y_offset < 0)                    y_offset=0; M                 CompositeImage(image,ReplaceCompositeOp,child_image,x_offset,                    y_offset);*                 DestroyImage(child_image);               }            } #           XFree((void *) children); 	         }      }    if (level <= 1)      {        ColormapList         *next;         /*         Free resources.        */4       while (colormap_list != (ColormapList *) NULL)       { !         next=colormap_list->next; -         free((char *) colormap_list->colors); %         free((char *) colormap_list);          colormap_list=next;        } &       if (image->class == PseudoClass)          CompressColormap(image);     }    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             % O %                                                                             % O %   X G e t W i n d o w I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Function XGetWindowInfo initializes the XWindowInfo structure.  % / %  The format of the XGetWindowInfo routine is:  % H %      XGetWindowInfo(display,visual_info,map_info,pixel_info,font_info, %        resource_info,window) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % A %    o font_info: Specifies a pointer to a XFontStruct structure.  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */F void XGetWindowInfo(display,visual_info,map_info,pixel_info,font_info,   resource_info,window)g Display.   *display;e   XVisualInfom   *visual_info;    XStandardColormap   *map_info;   
 XPixelInfo   *pixel_info;   XFontStruct 
   *font_info;   
 XResourceInfoe   *resource_info;t   XWindowInfol
   *window; {a   /*     Initialize window info.a   */"   if (window->id != (Window) NULL)     { *       XFreeCursor(display,window->cursor);/       XFreeCursor(display,window->busy_cursor);t5       if (window->highlight_stipple != (Pixmap) NULL)a7         XFreePixmap(display,window->highlight_stipple); 2       if (window->shadow_stipple != (Pixmap) NULL)4         XFreePixmap(display,window->shadow_stipple);     }    else     {d       window->id=(Window) NULL;u@       window->x=XDisplayWidth(display,visual_info->screen) >> 1;@       window->y=XDisplayWidth(display,visual_info->screen) >> 1;%       window->ximage=(XImage *) NULL; *       window->matte_image=(XImage *) NULL;#       window->pixmap=(Pixmap) NULL;y)       window->matte_pixmap=(Pixmap) NULL;        window->mapped=False;        window->stasis=False; "       window->shared_memory=False; #ifdef HasSharedMemory"       window->shared_memory=False;+       if (resource_info->use_shared_memory)r:         window->shared_memory=XShmQueryExtension(display);)       window->segment_info[0].shmid=(-1);a)       window->segment_info[1].shmid=(-1);d)       window->segment_info[2].shmid=(-1); )       window->segment_info[3].shmid=(-1);m #endif     }a%   window->screen=visual_info->screen;a8   window->root=XRootWindow(display,visual_info->screen);%   window->visual=visual_info->visual;n#   window->class=visual_info->class;s#   window->depth=visual_info->depth; "   window->visual_info=visual_info;   window->map_info=map_info;    window->pixel_info=pixel_info;   window->font_info=font_info;8   window->cursor=XCreateFontCursor(display,XC_left_ptr);:   window->busy_cursor=XCreateFontCursor(display,XC_watch);   window->name=" ";t!   window->geometry=(char *) NULL;"   window->icon_name=" ";5   window->icon_geometry=resource_info->icon_geometry;f&   window->crop_geometry=(char *) NULL;   window->flags=PSize;   window->width=1;   window->height=1;    window->min_width=1;   window->min_height=1;    window->width_inc=1;   window->height_inc=1;e3   window->border_width=resource_info->border_width;_8   window->annotate_context=pixel_info->annotate_context;:   window->highlight_context=pixel_info->highlight_context;4   window->widget_context=pixel_info->widget_context;'   window->shadow_stipple=(Pixmap) NULL;n*   window->highlight_stipple=(Pixmap) NULL;   window->immutable=False;   window->data=0;eK   window->mask=CWBackingStore | CWBackPixel | CWBackPixmap | CWBitGravity |nK     CWBorderPixel | CWColormap | CWCursor | CWDontPropagate | CWEventMask |%4     CWOverrideRedirect | CWSaveUnder | CWWinGravity;I   window->attributes.background_pixel=pixel_info->background_color.pixel; 5   window->attributes.background_pixmap=(Pixmap) NULL; -   window->attributes.backing_store=NotUseful; /   window->attributes.bit_gravity=ForgetGravity; A   window->attributes.border_pixel=pixel_info->border_color.pixel; 1   window->attributes.colormap=map_info->colormap; +   window->attributes.cursor=window->cursor; 7   window->attributes.do_not_propagate_mask=NoEventMask; ,   window->attributes.event_mask=NoEventMask;-   window->attributes.override_redirect=False; &   window->attributes.save_under=False;2   window->attributes.win_gravity=NorthWestGravity;   window->orphan=False;% }%   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %oO %                                                                             %nO %   X H i g h l i g h t L i n e                                               %oO %                                                                             %pO %                                                                             % O %                                                                             %TO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % H %  Function XHighlightLine puts a border on the X server around a region %  defined by highlight_info.  % / %  The format of the XHighlightLine routine is:  % C %    XHighlightLine(display,window,annotate_context,highlight_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  % ? %    o annotate_context: Specifies a pointer to a GC structure.  % L %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %  %  */C void XHighlightLine(display,window,annotate_context,highlight_info)% Display    *display;t   Window	   window;p   GC   annotate_context;t   XSegment   *highlight_info; {f?   XDrawLine(display,window,annotate_context,highlight_info->x1,e>     highlight_info->y1,highlight_info->x2,highlight_info->y2); }t t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %tO %                                                                             % O %                                                                             %nO %   X H i g h l i g h t R e g i o n                                           %oO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XHighlightRegion puts a border on the X server around a region %  defined by highlight_info.a %_1 %  The format of the XHighlightRegion routine is:& %cE %    XHighlightRegion(display,window,annotate_context,highlight_info)  %e+ %  A description of each parameter follows:  %TD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  %A? %    o annotate_context: Specifies a pointer to a GC structure.r %)L %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %u %( */E void XHighlightRegion(display,window,annotate_context,highlight_info)p Display*   *display;    Window	   window;%   GC   annotate_context;%  
 RectangleInfo%   *highlight_info; { B   if ((highlight_info->width < 4) || (highlight_info->height < 4))     return; C   XDrawRectangle(display,window,annotate_context,highlight_info->x, H     highlight_info->y,highlight_info->width-1,highlight_info->height-1);E   XDrawRectangle(display,window,annotate_context,highlight_info->x+1, J     highlight_info->y+1,highlight_info->width-3,highlight_info->height-3); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %                                                                             %mO %   X M a k e C u r s o r                                                     %eO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %i8 %  Function XMakeCursor creates a crosshairs X11 cursor. %*, %  The format of the XMakeCursor routine is: %>M %      XMakeCursor(display,window,colormap,background_color,foreground_color)> %K+ %  A description of each parameter follows:s %nE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % E %    o window: Specifies the ID of the window for which the cursor is  %      assigned. %%K %    o colormap: Specifies the ID of the colormap from which the background . %      and foreground color will be retrieved. % N %    o background_color: Specifies the color to use for the cursor background. % N %    o foreground_color: Specifies the color to use for the cursor foreground. %  %  */M Cursor XMakeCursor(display,window,colormap,background_color,foreground_color)  Display    *display;    Window	   window;    Colormap   colormap;    char   *background_color,   *foreground_color; {  #define scope_height 17  #define scope_x_hot 8  #define scope_y_hot 8  #define scope_width 17     static unsigned char     scope_bits[] =     {%G       0x80, 0x03, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, G       0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x7f,aG       0xfc, 0x01, 0x01, 0x00, 0x01, 0x7f, 0xfc, 0x01, 0x80, 0x02, 0x00,lG       0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02,a.       0x00, 0x80, 0x02, 0x00, 0x80, 0x03, 0x00     };     static unsigned char     scope_mask_bits[] =c     {lG       0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06,hG       0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xff, 0xfe, 0x01, 0x7f,uG       0xfc, 0x01, 0x03, 0x80, 0x01, 0x7f, 0xfc, 0x01, 0xff, 0xfe, 0x01,tG       0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06,n.       0x00, 0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00     };     Cursor     cursor;b     Pixmap	     mask,u     source;      XColor     background,h     foreground;   N   source=XCreateBitmapFromData(display,window,(char *) scope_bits,scope_width,     scope_height);E   mask=XCreateBitmapFromData(display,window,(char *) scope_mask_bits,c     scope_width,scope_height);;   if ((source == (Pixmap) NULL) || (mask == (Pixmap) NULL))n3     Error("Unable to create pixmap",(char *) NULL); =   XParseColor(display,colormap,background_color,&background);C=   XParseColor(display,colormap,foreground_color,&foreground); I   cursor=XCreatePixmapCursor(display,source,mask,&foreground,&background,      scope_x_hot,scope_y_hot);k   XFreePixmap(display,source);   XFreePixmap(display,mask);   return(cursor);  }i ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             %/O %                                                                             %eO %   X M a k e I m a g e                                                       %oO %                                                                             %(O %                                                                             %hO %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %cL %  Function XMakeImage creates an X11 image.  If the image size differs from2 %  the X11 image size, the image is first resized. %)+ %  The format of the XMakeImage routine is:p %aI %      status=XMakeImage(display,resource_info,window,image,width,height)  %i+ %  A description of each parameter follows:_ %oA %    o status: Function XMakeImage returns True if the X image isoN %      successfully created.  False is returned is there is a memory shortage. %GD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %,K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %e> %    o window: Specifies a pointer to a XWindowInfo structure. %iF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %aF %    o width: Specifies the width in pixels of the rectangular area to %      display.o %eH %    o height: Specifies the height in pixels of the rectangular area to %      display.o %e %a */H unsigned int XMakeImage(display,resource_info,window,image,width,height) Displayg   *display;z  
 XResourceInfoe   *resource_info;e   XWindowInfo=
   *window;   Image 	   *image;    unsigned int   width,	   height;) {    Imageu     *transformed_image;      intf
     depth,     format;m     Pixmap     matte_pixmap;e     XImage     *matte_image,&     *ximage;  4   if ((window->width == 0) || (window->height == 0))     return(False);   if (image == (Image *) NULL)     return(False);   /*'     Apply user transforms to the image.    */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   transformed_image=image;   if (window->crop_geometry)     {;       Image          *cropped_image;d         RectangleInfoa         crop_info;         /*         Crop image.        */L       (void) XParseGeometry(window->crop_geometry,&crop_info.x,&crop_info.y,,         &crop_info.width,&crop_info.height);%       transformed_image->orphan=True; <       cropped_image=CropImage(transformed_image,&crop_info);&       transformed_image->orphan=False;*       if (cropped_image != (Image *) NULL)	         { )           if (transformed_image != image)n,             DestroyImage(transformed_image);*           transformed_image=cropped_image;	         }n     } .   if ((width != transformed_image->columns) ||*       (height != transformed_image->rows))     {        Imaget         *scaled_image;         /*         Scale image.       */%       transformed_image->orphan=True; H       if ((window->pixel_info->colors != 0) || transformed_image->matte)	         {!           /*             Perserve colormap.           */C           scaled_image=SampleImage(transformed_image,width,height); -           if (scaled_image != (Image *) NULL)v
             {a-               if (transformed_image != image)n0                 DestroyImage(transformed_image);-               transformed_image=scaled_image;!
             } 	         }e
       else	         {g           unsigned int             sharpen;  :           sharpen=(transformed_image->columns != width) &&0             (transformed_image->rows != height);@           while ((transformed_image->columns >= (width << 1)) &&<                  (transformed_image->rows >= (height << 1)))           {l             ImageI               *reduced_image;n               /*;               Reduce image with a antialias digital filter.e             */9             reduced_image=ReduceImage(transformed_image);e0             if (reduced_image == (Image *) NULL)               break;+             if (transformed_image != image)d.               DestroyImage(transformed_image);,             transformed_image=reduced_image;           } @           while ((transformed_image->columns <= (width >> 1)) &&<                  (transformed_image->rows <= (height >> 1)))           {              Imaget               *zoomed_image;               /*5               Zoom image with bilinear interpolation.              */6             zoomed_image=ZoomImage(transformed_image);/             if (zoomed_image == (Image *) NULL)s               break;+             if (transformed_image != image) .               DestroyImage(transformed_image);+             transformed_image=zoomed_image;s           } 6           if ((transformed_image->columns != width) ||2               (transformed_image->rows != height))
             {p               /*3                 Scale image with pixel replication.i               */F               scaled_image=ScaleImage(transformed_image,width,height);1               if (scaled_image != (Image *) NULL)                  {i1                   if (transformed_image != image)-4                     DestroyImage(transformed_image);1                   transformed_image=scaled_image;%                 }%
             }%           if (sharpen)
             {                Image !                 *sharpened_image;                  /*                 Sharpen image.               */L               sharpened_image=SharpenImage(transformed_image,SharpenFactor);4               if (sharpened_image != (Image *) NULL)                 { 1                   if (transformed_image != image) 4                     DestroyImage(transformed_image);4                   transformed_image=sharpened_image;                 } 
             } 	         } &       transformed_image->orphan=False;     } #   width=transformed_image->columns;%!   height=transformed_image->rows;%   depth=window->depth;.   if (transformed_image->class == PseudoClass)K     if (IsGrayImage(transformed_image) && (transformed_image->colors == 2))r       depth=1;   /*     Create X image.y   */+   format=(depth == 1) ? XYBitmap : ZPixmap;m #ifdef HasSharedMemory   if (window->shared_memory)     { C       ximage=XShmCreateImage(display,window->visual,depth,format,0,s/         &window->segment_info[2],width,height);fN       window->segment_info[2].shmid=shmget(IPC_PRIVATE,ximage->bytes_per_line*)         ximage->height,IPC_CREAT | 0777);e?       window->shared_memory=window->segment_info[2].shmid >= 0;c        if (window->shared_memory)0         window->segment_info[2].shmaddr=(char *)3           shmat(window->segment_info[2].shmid,0,0);      }F #endif   if (!window->shared_memory)nL     ximage=XCreateImage(display,window->visual,depth,format,0,(char *) NULL,*       width,height,XBitmapPad(display),0);    if (ximage == (XImage *) NULL)     {b       /*!         Unable to create X image.-       */%       if (transformed_image != image)a(         DestroyImage(transformed_image);7       XDefineCursor(display,window->id,window->cursor);a       return(False);     }F   if (resource_info->debug)b     {e)       (void) fprintf(stderr,"XImage:\n");iE       (void) fprintf(stderr,"  width, height: %dx%d\n",ximage->width,"         ximage->height);=       (void) fprintf(stderr,"  format: %d\n",ximage->format);eE       (void) fprintf(stderr,"  byte order: %d\n",ximage->byte_order);tH       (void) fprintf(stderr,"  bitmap unit, bit order, pad: %d %d %d\n",I         ximage->bitmap_unit,ximage->bitmap_bit_order,ximage->bitmap_pad); ;       (void) fprintf(stderr,"  depth: %d\n",ximage->depth);rM       (void) fprintf(stderr,"  bytes per line: %d\n",ximage->bytes_per_line);;M       (void) fprintf(stderr,"  bits per pixel: %d\n",ximage->bits_per_pixel); L       (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",?         ximage->red_mask,ximage->green_mask,ximage->blue_mask);      }    /*      Allocate X image pixel data.   */ #ifdef HasSharedMemory   if (window->shared_memory)     {Q       xerror_alert=False; -       window->segment_info[2].readOnly=False;%3       XShmAttach(display,&window->segment_info[2]);%       XSync(display,False); 7       shmctl(window->segment_info[2].shmid,IPC_RMID,0); 3       ximage->data=window->segment_info[2].shmaddr;        if (xerror_alert) 	         { &           window->shared_memory=False;           xerror_alert=False; 	         }      }  #endif   if (!window->shared_memory) #     if (ximage->format == XYBitmap)        ximage->data=(char *) D         malloc(ximage->bytes_per_line*ximage->height*ximage->depth);     elseJ       ximage->data=(char *) malloc(ximage->bytes_per_line*ximage->height);$   if (ximage->data == (char *) NULL)     {        /*&         Unable to allocate pixel data.       */%       if (transformed_image != image) (         DestroyImage(transformed_image);       XDestroyImage(ximage);7       XDefineCursor(display,window->id,window->cursor);i       return(False);     }w(   if (window->ximage != (XImage *) NULL)     {  #ifdef HasSharedMemory        if (window->shared_memory)	         {i7           XShmDetach(display,&window->segment_info[0]); (           XDestroyImage(window->ximage);1           shmdt(window->segment_info[0].shmaddr); 	         }; #endif!       if (!window->shared_memory) &         XDestroyImage(window->ximage);     }r #ifdef HasSharedMemory2   window->segment_info[0]=window->segment_info[2]; #endif   window->ximage=ximage;   matte_image=(XImage *) NULL;*   if (transformed_image != (Image *) NULL)!     if (transformed_image->matte)        {s
         /*           Create matte image. 
         */E         matte_image=XCreateImage(display,window->visual,1,XYBitmap,0, <           (char *) NULL,width,height,XBitmapPad(display),0);!         if (resource_info->debug)e           {w4             (void) fprintf(stderr,"Matte Image:\n");P             (void) fprintf(stderr,"  width, height: %dx%d\n",matte_image->width,#               matte_image->height);            }=+         if (matte_image != (XImage *) NULL)G           {i             /*.               Allocate matte image pixel data.             */J             matte_image->data=(char *) malloc(matte_image->bytes_per_line*6               matte_image->height*matte_image->depth);3             if (matte_image->data == (char *) NULL)/               {=+                 XDestroyImage(matte_image);I,                 matte_image=(XImage *) NULL;               }s           }i       }r-   if (window->matte_image != (XImage *) NULL) '     XDestroyImage(window->matte_image); "   window->matte_image=matte_image;   window->stasis=False;h   /*5     Convert runlength-encoded pixels to X image data.n   */)   if ((ximage->byte_order == LSBFirst) ||=O       ((ximage->format == XYBitmap) && (ximage->bitmap_bit_order == LSBFirst)))mE     XMakeImageLSBFirst(resource_info,window,transformed_image,ximage,X       matte_image);>   elseE     XMakeImageMSBFirst(resource_info,window,transformed_image,ximage,t       matte_image); $   matte_pixmap=window->matte_pixmap;,   if (window->matte_pixmap != (Pixmap) NULL).     XFreePixmap(display,window->matte_pixmap);%   window->matte_pixmap=(Pixmap) NULL;>-   if (window->matte_image != (XImage *) NULL)i     {;       /*         Create matte pixmap.       */L       window->matte_pixmap=XCreatePixmap(display,window->id,width,height,1);0       if (window->matte_pixmap != (Pixmap) NULL)	         {s           GC             graphics_context;_             XGCValues              context_values;n             /*-             Copy matte image to matte pixmap.o           */&           context_values.background=1;&           context_values.foreground=0;P           graphics_context=XCreateGC(display,window->matte_pixmap,GCBackground |*             GCForeground,&context_values);B           XPutImage(display,window->matte_pixmap,graphics_context,6             window->matte_image,0,0,0,0,width,height);,           XFreeGC(display,graphics_context);	         }      }  #ifdef HasShape +   if (window->matte_pixmap != matte_pixmap) ;     XShapeCombineMask(display,window->id,ShapeBounding,0,0, %       window->matte_pixmap,ShapeSet);  #endif!   if (transformed_image != image) $     DestroyImage(transformed_image);   /*     Restore cursor.    */3   XDefineCursor(display,window->id,window->cursor);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             %aO %                                                                             %aO %                                                                             % O %   X M a k e I m a g e L S B F i r s t                                       % O %                                                                             %rO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%S %iJ %  Function XMakeImageLSBFirst initializes the pixel data of an X11 Image.H %  The X image pixels are copied in least-significant bit and byte firstL %  order.  The server's scanline pad is respected.  Rather than using one orL %  two general cases, many special cases are found here to help speed up the %  image conversion. %m3 %  The format of the XMakeImageLSBFirst routine is:t % H %      XMakeImageLSBFirst(resource_info,window,image,ximage,matte_image) % + %  A description of each parameter follows:  %uK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.d %o> %    o window: Specifies a pointer to a XWindowInfo structure. %lF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %(H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %/M %    o matte_image: Specifies a pointer to a XImage structure;  returned fromo %      XCreateImage. %  */M static void XMakeImageLSBFirst(resource_info,window,image,ximage,matte_image) 
 XResourceInfou   *resource_info;    XWindowInfoi
   *window;   Imageg	   *image;    XImage
   *ximage,   *matte_image;r {l   register int     i,     j,     x;     register RunlengthPacket     *p;      register unsigned char     bit,	     byte,l     *q;]     register unsigned long
     pixel;     unsigned int     scanline_pad;n     unsigned longn     *pixels;     XStandardColormap(     *map_info;  &   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;   p=image->pixels;#   q=(unsigned char *) ximage->data;e   x=0;!   if (ximage->format == XYBitmap)n     {r       register unsigned short          polarity;d         unsigned char          background,[         foreground;=         /*+         Convert image to big-endian bitmap.,       */C       background=(Intensity(window->pixel_info->foreground_color) <%G         Intensity(window->pixel_info->background_color) ? 0x80 : 0x00);%C       foreground=(Intensity(window->pixel_info->background_color) < G         Intensity(window->pixel_info->foreground_color) ? 0x80 : 0x00); M       polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);        bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte>>=1; #           if (p->index == polarity)              byte|=foreground;            else             byte|=background;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0;%
             }%           x++;!           if (x == ximage->width)l
             {r               /*-                 Advance to the next scanline.                */               if (bit != 0)i#                 *q=byte >> (8-bit);s               q+=scanline_pad;               bit=0;               byte=0;o               x=0;
             } 	         }a         p++;       }      }t   else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)        {l         case 2:h	         {a           register unsigned inti             nibble;f             /*2             Convert to 2 bit color-mapped X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           {e)             pixel=pixels[p->index] & 0xf;o2             for (j=0; j <= ((int) p->length); j++)
             {m               switch (nibble)a               {a                 case 0:o                 { +                   *q=(unsigned char) pixel;f                   nibble++;e                   break;                 }                  case 1:y                 {i3                   *q|=(unsigned char) (pixel << 2);                    nibble++;o                   break;                 }X                 case 2:                  {I3                   *q|=(unsigned char) (pixel << 4);                    nibble++;a                   break;                 }                  case 3:                  {C3                   *q|=(unsigned char) (pixel << 6);)                   q++;                   nibble=0;n                   break;                 }f               }u               x++;%               if (x == ximage->width)l                 {e                   x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }              p++;           }f           break;	         }v         case 4: 	         {l           register unsigned int              nibble;e             /*2             Convert to 4 bit color-mapped X image.           */           nibble=0;s,           for (i=0; i < image->packets; i++)           {e)             pixel=pixels[p->index] & 0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {r               switch (nibble)f               {s                 case 0:=                 { +                   *q=(unsigned char) pixel;                    nibble++;t                   break;                 }(                 case 1:,                 { 3                   *q|=(unsigned char) (pixel << 4);k                   q++;                   nibble=0;                    break;                 }o               }r               x++;%               if (x == ximage->width)m                 {k                   x=0;                   nibble=0; "                   q+=scanline_pad;                 }o
             }l             p++;           }            break;	         }u         case 6:a         case 8: 	         {u           /*2             Convert to 8 bit color-mapped X image.           */E           if (resource_info->color_recovery && resource_info->dither) 
             { )               XDitherImage(image,ximage);                break;
             }o,           for (i=0; i < image->packets; i++)           { #             pixel=pixels[p->index];l2             for (j=0; j <= ((int) p->length); j++)
             {|)               *q++=(unsigned char) pixel;u               x++;%               if (x == ximage->width)                  {                    x=0;"                   q+=scanline_pad;                 } 
             }              p++;           }I           break;	         }          default:	         {u           register int             k;             register unsigned intr             bytes_per_pixel;             unsigned char +             channel[sizeof(unsigned long)];a             /*7             Convert to multi-byte color-mapped X image.V           */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;,           for (i=0; i < image->packets; i++)           { #             pixel=pixels[p->index]; /             for (k=0; k < bytes_per_pixel; k++)v
             {c/               channel[k]=(unsigned char) pixel;i               pixel>>=8;
             }/2             for (j=0; j <= ((int) p->length); j++)
             {_1               for (k=0; k < bytes_per_pixel; k++)i                  *q++=channel[k];               x++;%               if (x == ximage->width)V                 {                    x=0;"                   q+=scanline_pad;                 }.
             }              p++;           }"           break;	         }t       }i     else%       switch (ximage->bits_per_pixel)u       {y         case 2:i	         {            register unsigned intd             nibble;i             /*@             Convert to contiguous 2 bit continuous-tone X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           {i;             pixel=XStandardPixel(map_info,*p,QuantumDepth);              pixel&=0xf;l2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)                {                  case 0:;                 { +                   *q=(unsigned char) pixel;                    nibble++;t                   break;                 }                  case 1:                  {a3                   *q|=(unsigned char) (pixel << 2);                    nibble++;p                   break;                 }0                 case 2:t                 { 3                   *q|=(unsigned char) (pixel << 4);S                   nibble++;                    break;                 }e                 case 3:                  {e3                   *q|=(unsigned char) (pixel << 6);l                   q++;                   nibble=0;r                   break;                 }                }o               x++;%               if (x == ximage->width)a                 {l                   x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }r             p++;           }            break;	         }T         case 4: 	         {A           register unsigned intM             nibble;R             /*@             Convert to contiguous 4 bit continuous-tone X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           {m;             pixel=XStandardPixel(map_info,*p,QuantumDepth);a             pixel&=0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {T               switch (nibble)p               {L                 case 0:e                 {t+                   *q=(unsigned char) pixel;l                   nibble++;                    break;                 }                  case 1:                  { 3                   *q|=(unsigned char) (pixel << 4);G                   q++;                   nibble=0;                    break;                 }o               }                x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0;_"                   q+=scanline_pad;                 }i
             }t             p++;           }            break;	         }          case 6:b         case 8: 	         {f           /*@             Convert to contiguous 8 bit continuous-tone X image.           */E           if (resource_info->color_recovery && resource_info->dither)m
             { )               XDitherImage(image,ximage);l               break;
             }a,           for (i=0; i < image->packets; i++)           {t;             pixel=XStandardPixel(map_info,*p,QuantumDepth);S2             for (j=0; j <= ((int) p->length); j++)
             {=)               *q++=(unsigned char) pixel;                x++;%               if (x == ximage->width)                  {                    x=0;"                   q+=scanline_pad;                 } 
             }t             p++;           },           break;	         }          default:	         { M           if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) && L               (map_info->green_max == 255) && (map_info->blue_max == 255) &&O               (map_info->red_mult == 65536) && (map_info->green_mult == 256) && )               (map_info->blue_mult == 1)) 
             {                /*:                 Convert to 32 bit continuous-tone X image.               */0               for (i=0; i < image->packets; i++)               {a6                 for (j=0; j <= ((int) p->length); j++)                 {i*                   *q++=DownScale(p->blue);+                   *q++=DownScale(p->green);u)                   *q++=DownScale(p->red);                    *q++=0;i                 }r                 p++;               } 
             }            elseO             if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) &&(N                 (map_info->green_max == 255) && (map_info->blue_max == 255) &&M                 (map_info->red_mult == 1) && (map_info->green_mult == 256) &&%/                 (map_info->blue_mult == 65536))%               {                  /*<                   Convert to 32 bit continuous-tone X image.                 */2                 for (i=0; i < image->packets; i++)                 { 8                   for (j=0; j <= ((int) p->length); j++)                   { +                     *q++=DownScale(p->red); -                     *q++=DownScale(p->green); ,                     *q++=DownScale(p->blue);                     *q++=0;                    }                    p++;                 }                }              else               {                  register int                   k;  %                 register unsigned int%"                   bytes_per_pixel;                   unsigned charr1                   channel[sizeof(unsigned long)];d                   /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;2                 for (i=0; i < image->packets; i++)                 {oA                   pixel=XStandardPixel(map_info,*p,QuantumDepth); 5                   for (k=0; k < bytes_per_pixel; k++)t                   {d5                     channel[k]=(unsigned char) pixel;s                     pixel>>=8;                   }v8                   for (j=0; j <= ((int) p->length); j++)                   {,7                     for (k=0; k < bytes_per_pixel; k++)W&                       *q++=channel[k];                     x++;+                     if (x == ximage->width)e                       {i                         x=0;(                         q+=scanline_pad;                       }d                   }i                   p++;                 }i               }(           break;	         }L       } %   if (matte_image != (XImage *) NULL)a     {w       /*         Initialize matte image.i       *//       scanline_pad=matte_image->bytes_per_line-%@         ((matte_image->width*matte_image->bits_per_pixel) >> 3);       p=image->pixels;,       q=(unsigned char *) matte_image->data;       bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte>>=1; &           if (p->index == Transparent)             byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;&           if (x == matte_image->width)
             {                /*-                 Advance to the next scanline.%               */               if (bit != 0)%#                 *q=byte >> (8-bit);F               q+=scanline_pad;               bit=0;               byte=0;m               x=0;
             }u	         }l         p++;       }      }r }  t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %lO %                                                                             %pO %                                                                             %pO %   X M a k e I m a g e M S B F i r s t                                       %hO %                                                                             %eO %                                                                             %iO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %pJ %  Function XMakeImageMSBFirst initializes the pixel data of an X11 Image.N %  The X image pixels are copied in most-significant bit and byte first order.M %  The server's scanline pad is also resprected. Rather than using one or twotN %  general cases, many special cases are found here to help speed up the image %  conversion. %%3 %  The format of the XMakeImageMSBFirst routine is:  % H %      XMakeImageMSBFirst(resource_info,window,image,ximage,matte_image) % + %  A description of each parameter follows:  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % > %    o window: Specifies a pointer to a XWindowInfo structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. % M %    o matte_image: Specifies a pointer to a XImage structure;  returned from% %      XCreateImage. %% %% */M static void XMakeImageMSBFirst(resource_info,window,image,ximage,matte_image)e
 XResourceInfoe   *resource_info;h   XWindowInfo 
   *window;   Imagew	   *image;u   XImage
   *ximage,   *matte_image;a {m   register int     i,     j,     x;     register RunlengthPacket     *p;      register unsigned char     bit,	     byte,r     *q;w     register unsigned long
     pixel;     unsigned int     scanline_pad;w     unsigned longu     *pixels;     XStandardColormape     *map_info;  &   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;   p=image->pixels;#   q=(unsigned char *) ximage->data;d   x=0;!   if (ximage->format == XYBitmap)      {y       register unsigned shorti         polarity;_         unsigned chard         background,          foreground;          /*+         Convert image to big-endian bitmap.        */C       background=(Intensity(window->pixel_info->foreground_color) <uG         Intensity(window->pixel_info->background_color) ? 0x01 : 0x00);aC       foreground=(Intensity(window->pixel_info->background_color) <_G         Intensity(window->pixel_info->foreground_color) ? 0x01 : 0x00);tM       polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);e       bit=0;
       byte=0;a(       for (i=0; i < image->packets; i++)       {u.         for (j=0; j <= ((int) p->length); j++)	         {a           byte<<=1;)#           if (p->index == polarity)U             byte|=foreground;;           else             byte|=background;%           bit++;           if (bit == 8)%
             {%               *q++=byte;               bit=0;               byte=0; 
             }            x++;!           if (x == ximage->width) 
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) #                 *q=byte << (8-bit);                q+=scanline_pad;               bit=0;               byte=0;                x=0;
             } 	         }          p++;       }      }    else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)        {          case 2: 	         {%           register unsigned int%             nibble;%             /*2             Convert to 2 bit color-mapped X image.           */           nibble=0;s,           for (i=0; i < image->packets; i++)           {p)             pixel=pixels[p->index] & 0xf;a2             for (j=0; j <= ((int) p->length); j++)
             {t               switch (nibble)                {n                 case 0:o                 { 2                   *q=(unsigned char) (pixel << 6);                   nibble++;i                   break;                 }                  case 1:n                 {d3                   *q|=(unsigned char) (pixel << 4);d                   nibble++;>                   break;                 }w                 case 2:                  {>3                   *q|=(unsigned char) (pixel << 2);l                   nibble++;>                   break;                 }f                 case 3:f                 { ,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;%                   break;                 }%               }                x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }              p++;           }            break;	         }          case 4: 	         {            register unsigned int              nibble;              /*2             Convert to 4 bit color-mapped X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {%               switch (nibble)o               {                  case 0:                  {n2                   *q=(unsigned char) (pixel << 4);                   nibble++;(                   break;                 }o                 case 1:                  {y,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;l                   break;                 }d               }                x++;%               if (x == ximage->width)s                 {                    x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }n             p++;           }i           break;	         }v         case 6:          case 8:(	         {e           /*2             Convert to 8 bit color-mapped X image.           */E           if (resource_info->color_recovery && resource_info->dither) 
             {c)               XDitherImage(image,ximage);S               break;
             }e,           for (i=0; i < image->packets; i++)           {n#             pixel=pixels[p->index]; 2             for (j=0; j <= ((int) p->length); j++)
             {%)               *q++=(unsigned char) pixel;                x++;%               if (x == ximage->width)                  {                    x=0;"                   q+=scanline_pad;                 } 
             }              p++;           }            break;	         }          default:	         {            register int             k;             register unsigned int              bytes_per_pixel;             unsigned char +             channel[sizeof(unsigned long)];              /*2             Convert to 8 bit color-mapped X image.           */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;,           for (i=0; i < image->packets; i++)           {%#             pixel=pixels[p->index];o2             for (k=bytes_per_pixel-1; k >= 0; k--)
             {e/               channel[k]=(unsigned char) pixel;                pixel>>=8;
             } 2             for (j=0; j <= ((int) p->length); j++)
             { 1               for (k=0; k < bytes_per_pixel; k++)                   *q++=channel[k];               x++;%               if (x == ximage->width)                  {i                   x=0;"                   q+=scanline_pad;                 }i
             }              p++;           }w           break;	         }        }      else%       switch (ximage->bits_per_pixel)        {i         case 2:d	         {n           register unsigned intg             nibble;t             /*5             Convert to 4 bit continuous-tone X image.            */           nibble=0;R,           for (i=0; i < image->packets; i++)           { ;             pixel=XStandardPixel(map_info,*p,QuantumDepth);              pixel&=0xf;t2             for (j=0; j <= ((int) p->length); j++)
             {A               switch (nibble)m               {,                 case 0:                  {n2                   *q=(unsigned char) (pixel << 6);                   nibble++;                    break;                 }(                 case 1:                  {p3                   *q|=(unsigned char) (pixel << 4);                    nibble++;                    break;                 }%                 case 2:%                 { 3                   *q|=(unsigned char) (pixel << 2);                    nibble++;                    break;                 }                  case 3:                  { ,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;                    break;                 }                }                x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }              p++;           }%           break;	         }%         case 4:%	         {%           register unsigned int              nibble;p             /*5             Convert to 4 bit continuous-tone X image.a           */           nibble=0;p,           for (i=0; i < image->packets; i++)           {A;             pixel=XStandardPixel(map_info,*p,QuantumDepth);              pixel&=0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {u               switch (nibble)o               {n                 case 0:o                 { 2                   *q=(unsigned char) (pixel << 4);                   nibble++;a                   break;                 }e                 case 1:p                 {y,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;n                   break;                 }                },               x++;%               if (x == ximage->width)                  {g                   x=0;                   nibble=0; "                   q+=scanline_pad;                 }w
             }              p++;           }(           break;	         }N         case 6:=         case 8:e	         {            /*5             Convert to 8 bit continuous-tone X image.m           */E           if (resource_info->color_recovery && resource_info->dither) 
             {t)               XDitherImage(image,ximage);y               break;
             }a,           for (i=0; i < image->packets; i++)           {t;             pixel=XStandardPixel(map_info,*p,QuantumDepth);,2             for (j=0; j <= ((int) p->length); j++)
             { )               *q++=(unsigned char) pixel;t               x++;%               if (x == ximage->width)a                 {z                   x=0;"                   q+=scanline_pad;                 }w
             }_             p++;           }e           break;	         }d         default:	         {(M           if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) &&tL               (map_info->green_max == 255) && (map_info->blue_max == 255) &&O               (map_info->red_mult == 65536) && (map_info->green_mult == 256) &&e)               (map_info->blue_mult == 1)))
             {%               /*:                 Convert to 32 bit continuous-tone X image.               */0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)                 {s                   *q++=0;s)                   *q++=DownScale(p->red);l+                   *q++=DownScale(p->green);F*                   *q++=DownScale(p->blue);                 },                 p++;               }e
             }m           elseO             if ((ximage->bits_per_pixel == 32) && (map_info->red_max == 255) &&)N                 (map_info->green_max == 255) && (map_info->blue_max == 255) &&M                 (map_info->red_mult == 1) && (map_info->green_mult == 256) &&l/                 (map_info->blue_mult == 65536))                {x                 /*<                   Convert to 32 bit continuous-tone X image.                 */2                 for (i=0; i < image->packets; i++)                 {i8                   for (j=0; j <= ((int) p->length); j++)                   {\                     *q++=0;a,                     *q++=DownScale(p->blue);-                     *q++=DownScale(p->green);)+                     *q++=DownScale(p->red);u                   }t                   p++;                 }v               },             else               {                  register int                   k;  %                 register unsigned int "                   bytes_per_pixel;                   unsigned char"1                   channel[sizeof(unsigned long)];                    /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;2                 for (i=0; i < image->packets; i++)                 { A                   pixel=XStandardPixel(map_info,*p,QuantumDepth);)8                   for (k=bytes_per_pixel-1; k >= 0; k--)                   {-5                     channel[k]=(unsigned char) pixel;                      pixel>>=8;                   }d8                   for (j=0; j <= ((int) p->length); j++)                   {x7                     for (k=0; k < bytes_per_pixel; k++))&                       *q++=channel[k];                     x++;+                     if (x == ximage->width)                        {c                         x=0;(                         q+=scanline_pad;                       }*                   }                    p++;                 }e               }e           break;	         }e       })%   if (matte_image != (XImage *) NULL)r     {L       /*         Initialize matte image.        *//       scanline_pad=matte_image->bytes_per_line-e@         ((matte_image->width*matte_image->bits_per_pixel) >> 3);       p=image->pixels;,       q=(unsigned char *) matte_image->data;       bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte<<=1; &           if (p->index == Transparent)             byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;&           if (x == matte_image->width)
             {                /*-                 Advance to the next scanline.%               */               if (bit != 0)a#                 *q=byte << (8-bit);u               q+=scanline_pad;               bit=0;               byte=0;t               x=0;
             } 	         }l         p++;       }s     }n }e n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %rO %                                                                             % O %                                                                             %cO %   X M a k e M a g n i f y I m a g e                                         %iO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%8 %4O %  Function XMakeMagnifyImage magnifies a region of an X image and displays it.1 %12 %  The format of the XMakeMagnifyImage routine is: %[) %      XMakeMagnifyImage(display,windows)1 %1+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %  %  */' void XMakeMagnifyImage(display,windows)e Displayn   *display;    XWindows   *windows;a { 0 #define Swap(x,y) ((x)^=(y), (y)^=(x), (x)^=(y))     register int     x,     y;     register unsigned char     *p,u     *q;o     register unsigned intc     j,     k,     l;  
   static char      text[MaxTextLength];     static unsigned into     previous_magnify=0;      static XWindowInfo     magnify_window;[     unsigned int     height,2     i,     magnify,     scanline_pad,a
     width;     XColor
     color;     XImage     *ximage;     /*     Check boundry conditions.m   */   magnify=1;+   for (i=1; i < windows->magnify.data; i++)u     magnify<<=1;I   while ((magnify*windows->image.ximage->width) < windows->magnify.width)      magnify<<=1;K   while ((magnify*windows->image.ximage->height) < windows->magnify.height)m     magnify<<=1;*   while (magnify > windows->magnify.width)     magnify>>=1;+   while (magnify > windows->magnify.height)      magnify>>=1;"   if (magnify != previous_magnify)     {0       unsigned int         status;a         XTextProperty(         window_name;         /*8         New magnify factor:  update magnify window name.       */
       i=0;!       while ((1 << i) <= magnify)a         i++;<       (void) sprintf(windows->magnify.name,"Magnify %uX",i);N       status=XStringListToTextProperty(&windows->magnify.name,1,&window_name);       if (status != 0)	         { ?           XSetWMName(display,windows->magnify.id,&window_name);R,           XFree((void *) window_name.value);	         }[     }e   previous_magnify=magnify;    ximage=windows->image.ximage;='   width=windows->magnify.ximage->width;j)   height=windows->magnify.ximage->height; .   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0)     x=0;   else,     if (x > (ximage->width-(width/magnify)))$       x=ximage->width-width/magnify;/   y=windows->magnify.y-((height/magnify) >> 1);>   if (y < 0)     y=0;   else.     if (y > (ximage->height-(height/magnify)))&       y=ximage->height-height/magnify;4   q=(unsigned char *) windows->magnify.ximage->data;7   scanline_pad=windows->magnify.ximage->bytes_per_line-o;     ((width*windows->magnify.ximage->bits_per_pixel) >> 3);a!   if (ximage->bits_per_pixel < 8)o     {        register unsigned char         background, 
         byte,          foreground,a         p_bit,         q_bit;         register unsigned intl         plane;         XPixelInfo         *pixel_info;  -       pixel_info=windows->magnify.pixel_info;f'       switch (ximage->bitmap_bit_order)r       {t         case LSBFirst:	         {;           /*)             Magnify little-endian bitmap.h           */           background=0x00;           foreground=0x80;)           if (ximage->format == XYBitmap) 
             {%C               background=(Intensity(pixel_info->foreground_color) <%G                 Intensity(pixel_info->background_color) ? 0x80 : 0x00); C               foreground=(Intensity(pixel_info->background_color) < G                 Intensity(pixel_info->foreground_color) ? 0x80 : 0x00); -               if (windows->magnify.depth > 1) ,                 Swap(background,foreground);
             } +           for (i=0; i < height; i+=magnify)            {              /*+               Propogate pixel magnify rows.              */'             for (j=0; j < magnify; j++) 
             { H               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0; .               for (k=0; k < width; k+=magnify)               {i                 /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++)                  {                    /*-                     Propogate each bit plane.                    */H                   for (plane=0; plane < ximage->bits_per_pixel; plane++)                   {i                     byte>>=1;P5                     if (*p & (0x01 << (p_bit+plane))) '                       byte|=foreground;                      else'                       byte|=background;m                     q_bit++;#                     if (q_bit == 8)i                       { "                         *q++=byte;                          q_bit=0;                         byte=0;e                       }                    }                  }n.                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)r                   {t                     p++;                     p_bit=0;                   }d                 if (q_bit != 0) '                   *q=byte >> (8-q_bit);t                  q+=scanline_pad;               } 
             }a             y++;           }i           break;	         }(         case MSBFirst:         default:	         {            /*&             Magnify big-endian bitmap.           */           background=0x00;           foreground=0x01;)           if (ximage->format == XYBitmap)=
             {iC               background=(Intensity(pixel_info->foreground_color) <tG                 Intensity(pixel_info->background_color) ? 0x01 : 0x00); C               foreground=(Intensity(pixel_info->background_color) <eG                 Intensity(pixel_info->foreground_color) ? 0x01 : 0x00);t-               if (windows->magnify.depth > 1)e,                 Swap(background,foreground);
             }i+           for (i=0; i < height; i+=magnify)t           {)             /*+               Propogate pixel magnify rows.R             */'             for (j=0; j < magnify; j++)w
             {wH               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0; .               for (k=0; k < width; k+=magnify)               {e                 /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++)                  {c                   /*-                     Propogate each bit plane.a                   */H                   for (plane=0; plane < ximage->bits_per_pixel; plane++)                   {,                     byte<<=1;t5                     if (*p & (0x80 >> (p_bit+plane)))v'                       byte|=foreground;d                     else'                       byte|=background;i                     q_bit++;#                     if (q_bit == 8)w                       {g"                         *q++=byte;                          q_bit=0;                         byte=0;/                       }(                   },                 } .                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)L                   {;                     p++;                     p_bit=0;                   }                  if (q_bit != 0)m'                   *q=byte << (8-q_bit);I                  q+=scanline_pad;               }o
             }-             y++;           }a           break;	         }e       }=     }a   else#     switch (ximage->bits_per_pixel)>     {(
       case 6: 
       case 8:(       {i
         /*            Magnify 8 bit X image.
         */)         for (i=0; i < height; i+=magnify) 	         {            /*)             Propogate pixel magnify rows.            */%           for (j=0; j < magnify; j++)            {GF             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {=               /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)+                 *q++=(*p);               p++;
             }              q+=scanline_pad;           }m           y++;	         }d         break;       }        default:       {          register unsigned intl           bytes_per_pixel,           m;  
         /*%           Magnify multi-byte X image..
         */4         bytes_per_pixel=ximage->bits_per_pixel >> 3;)         for (i=0; i < height; i+=magnify) 	         {            /*)             Propogate pixel magnify rows.            */%           for (j=0; j < magnify; j++)>           {rF             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {                /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)r3                 for (m=0; m < bytes_per_pixel; m++)w                    *q++=(*(p+m));!               p+=bytes_per_pixel; 
             }              q+=scanline_pad;           }            y++;	         }          break;       }(     }a   /*#     Copy X image to magnify pixmap.!   */.   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0).     x=(width >> 1)-windows->magnify.x*magnify;   else,     if (x > (ximage->width-(width/magnify)))@       x=(ximage->width-windows->magnify.x)*magnify-(width >> 1);     else
       x=0;/   y=windows->magnify.y-((height/magnify) >> 1);    if (y < 0)/     y=(height >> 1)-windows->magnify.y*magnify;i   else.     if (y > (ximage->height-(height/magnify)))B       y=(ximage->height-windows->magnify.y)*magnify-(height >> 1);     else
       y=0;   if ((x != 0) || (y != 0))i3     XFillRectangle(display,windows->magnify.pixmap, :       windows->magnify.annotate_context,0,0,width,height);N   XPutImage(display,windows->magnify.pixmap,windows->magnify.annotate_context,6     windows->magnify.ximage,0,0,x,y,width-x,height-y);4   if ((magnify > 1) && ((magnify <= (width >> 1)) &&"       (magnify <= (height >> 1))))     {i       RectangleInfo          highlight_info;a         /*         Highlight center pixel.        */3       highlight_info.x=windows->magnify.width >> 1; 4       highlight_info.y=windows->magnify.height >> 1;#       highlight_info.width=magnify; $       highlight_info.height=magnify;5       XDrawRectangle(display,windows->magnify.pixmap,gM         windows->magnify.highlight_context,highlight_info.x,highlight_info.y, 8         highlight_info.width-1,highlight_info.height-1);       if (magnify > 2)7         XDrawRectangle(display,windows->magnify.pixmap, ?           windows->magnify.annotate_context,highlight_info.x+1, M           highlight_info.y+1,highlight_info.width-3,highlight_info.height-3);g     }/   /*     Show center pixel color.   */   color.pixel=K     XGetPixel(windows->image.ximage,windows->magnify.x,windows->magnify.y); @   XQueryColor(display,windows->image.map_info->colormap,&color);"   if (windows->magnify.depth > 12)2     (void) sprintf(text," %+d%+d  (%3u,%3u,%3u) ",B       windows->magnify.x,windows->magnify.y,XDownScale(color.red),6       XDownScale(color.green),XDownScale(color.blue));   else6     (void) sprintf(text," %+d%+d  (%3u,%3u,%3u) %lu ",B       windows->magnify.x,windows->magnify.y,XDownScale(color.red),B       XDownScale(color.green),XDownScale(color.blue),color.pixel);P   height=windows->magnify.font_info->ascent+windows->magnify.font_info->descent;6   x=windows->magnify.font_info->max_bounds.width >> 1;5   y=windows->magnify.font_info->ascent+(height >> 2); 3   XDrawImageString(display,windows->magnify.pixmap, =     windows->magnify.annotate_context,x,y,text,strlen(text)); >   (void) sprintf(text," #%02x%02x%02x ",XDownScale(color.red),4     XDownScale(color.green),XDownScale(color.blue));   y+=height;3   XDrawImageString(display,windows->magnify.pixmap,e=     windows->magnify.annotate_context,x,y,text,strlen(text));r   /*     Refresh magnify window.r   */"   magnify_window=windows->magnify;   magnify_window.x=0;s   magnify_window.y=0;e:   XRefreshWindow(display,&magnify_window,(XEvent *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %pO %                                                                             %dO %                                                                             %aO %   X M a k e P i x m a p                                                     % O %                                                                             %aO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Function XMakePixmap creates an X11 pixmap. %u, %  The format of the XMakePixmap routine is: %%7 %      status=XMakePixmap(display,resource_info,window)  % + %  A description of each parameter follows:  % C %    o status: Function XMakePixmap returns True if the X pixmap is N %      successfully created.  False is returned is there is a memory shortage. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % > %    o window: Specifies a pointer to a XWindowInfo structure. %  %  */6 unsigned int XMakePixmap(display,resource_info,window) Display    *display;   
 XResourceInfo    *resource_info;%   XWindowInfo%
   *window; {%   unsigned int     height,%
     width;  (   if (window->ximage == (XImage *) NULL)     return(False);   /*     Display busy cursor.   */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   /*     Create pixmap.   */&   if (window->pixmap != (Pixmap) NULL)     {t*       XFreePixmap(display,window->pixmap);#       window->pixmap=(Pixmap) NULL;  #ifdef HasSharedMemory        if (window->shared_memory)/         if (window->segment_info[1].shmid >= 0)            { 9             XShmDetach(display,&window->segment_info[1]);p!             XSync(display,False);z3             shmdt(window->segment_info[1].shmaddr); /             window->segment_info[1].shmid=(-1);l           }e #endif     }f   width=window->ximage->width;    height=window->ximage->height; #ifdef HasSharedMemory   if (window->shared_memory)     {o=       window->segment_info[3].shmid=(int) shmget(IPC_PRIVATE,X@         window->ximage->bytes_per_line*height,IPC_CREAT | 0777);-       if (window->segment_info[3].shmid >= 0) 	         {f           xerror_alert=False;s2           window->segment_info[3].shmaddr=(char *)5             shmat(window->segment_info[3].shmid,0,0); 1           window->segment_info[3].readOnly=False; 7           XShmAttach(display,&window->segment_info[3]); =           window->pixmap=XShmCreatePixmap(display,window->id, E             window->segment_info[3].shmaddr,&window->segment_info[3],*(             width,height,window->depth);.           if (window->pixmap != (Pixmap) NULL)<             window->segment_info[1]=window->segment_info[3];           else
             { 5               shmdt(window->segment_info[3].shmaddr);d;               XShmDetach(display,&window->segment_info[3]);l
             }>           XSync(display,False);a;           shmctl(window->segment_info[3].shmid,IPC_RMID,0);i           if (xerror_alert) 
             {(+               window->pixmap=(Pixmap) NULL; !               xerror_alert=False;i
             }c	         }      }  #endif&   if (window->pixmap == (Pixmap) NULL)P     window->pixmap=XCreatePixmap(display,window->id,width,height,window->depth);&   if (window->pixmap == (Pixmap) NULL)     {C       /*"         Unable to allocate pixmap.       */7       XDefineCursor(display,window->id,window->cursor);n       return(False);     }n   /*     Copy X image to pixmap.n   */ #ifdef HasSharedMemory   if (window->shared_memory)P     XShmPutImage(display,window->pixmap,window->annotate_context,window->ximage,!       0,0,0,0,width,height,True);l #endif   if (!window->shared_memory)lM     XPutImage(display,window->pixmap,window->annotate_context,window->ximage,o       0,0,0,0,width,height);   if (resource_info->debug)F     {i)       (void) fprintf(stderr,"Pixmap:\n");)E       (void) fprintf(stderr,"  width, height: %dx%d\n",width,height);%     }%   /*     Restore cursor.    */3   XDefineCursor(display,window->id,window->cursor);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X M a k e S t a n d a r d C o l o r m a p                                 % O %                                                                             %%O %                                                                             %FO %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %iC %  Function XMakeStandardColormap creates an X11 Standard Colormap.  %d6 %  The format of the XMakeStandardColormap routine is: %mE %      XMakeStandardColormap(display,visual_info,resource_info,image,a %        map_info,pixel_info)  % + %  A description of each parameter follows:p %fD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %CG %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure;c$ %      returned from XGetVisualInfo. %oK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.s %IF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % L %    o map_info: If a Standard Colormap type is specified, this structure is8 %      initialized with info from the Standard Colormap. %mA %    o pixel_info: Specifies a pointer to a XPixelInfo structure.n %> %o */  static int IntensityCompare(x,y)
 const void   *x,N   *y;  {    DiversityPacket>
     *color_1,l
     *color_2;       color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }n  ! static int PopularityCompare(x,y)(
 const void   *x,    *y;e {n   DiversityPacket)
     *color_1, 
     *color_2;_      color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;4   return((int) color_2->count-(int) color_1->count); })  L void XMakeStandardColormap(display,visual_info,resource_info,image,map_info,
   pixel_info)% Display%   *display;    XVisualInfo    *visual_info;   
 XResourceInfo    *resource_info;    Image 	   *image;    XStandardColormap    *map_info;  
 XPixelInfo   *pixel_info; { 
   Colormap
     colormap;      int      status;   	   Quantum      gray_value;      register int     i;     unsigned int     number_colors,     retain_colors;     XColor
     color,     *colors,     *p;   /   if (resource_info->map_type != (char *) NULL)      {        /*=         Standard Colormap is already defined (i.e. xstdcmap).        */7       if (pixel_info->pixels != (unsigned long *) NULL)%*         free((char *) pixel_info->pixels);E       XGetPixelInfo(display,visual_info,map_info,resource_info,image,n         pixel_info);)       number_colors=map_info->base_pixel+uM         (map_info->red_max+1)*(map_info->green_max+1)*(map_info->blue_max+1);hJ       if ((map_info->red_max*map_info->green_max*map_info->blue_max) != 0)F         if (resource_info->dither && !resource_info->color_recovery &&?             (number_colors < MaxColormapSize) && !image->matte)n           {r             Imagee               *map_image;f  $             register RunlengthPacket               *p;h               /*<               Improve image appearance with error diffusion.             */8             map_image=AllocateImage((ImageInfo *) NULL);,             if (map_image == (Image *) NULL)I               Error("Unable to dither image","Memory allocation failed");%-             map_image->columns=number_colors;%             map_image->rows=1;B             map_image->packets=map_image->columns*map_image->rows;1             map_image->pixels=(RunlengthPacket *) A               malloc(map_image->packets*sizeof(RunlengthPacket)); >             if (map_image->pixels == (RunlengthPacket *) NULL)I               Error("Unable to dither image","Memory allocation failed");              /*(               Initialize colormap image.             */              p=map_image->pixels;-             for (i=0; i < number_colors; i++) 
             {                p->red=0; )               if (map_info->red_max != 0)                   p->red=(Quantum)F                   (((i/map_info->red_mult)*MaxRGB)/map_info->red_max);               p->green=0;d+               if (map_info->green_max != 0)t@                 p->green=(Quantum) ((((i/map_info->green_mult) %H                   (map_info->green_max+1))*MaxRGB)/map_info->green_max);               p->blue=0;*               if (map_info->blue_max != 0)!                 p->blue=(Quantum)nK                   (((i % map_info->green_mult)*MaxRGB)/map_info->blue_max);                p->index=0;s               p->length=0;               p++;
             }o+             MapImage(image,map_image,True); K             XGetPixelInfo(display,visual_info,map_info,resource_info,image,a               pixel_info);%             image->class=DirectClass;n$             DestroyImage(map_image);           }i       if (resource_info->debug)u	         {-8           (void) fprintf(stderr,"Standard Colormap:\n");M           (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap);;H           (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",F             map_info->red_max,map_info->green_max,map_info->blue_max);I           (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n", I             map_info->red_mult,map_info->green_mult,map_info->blue_mult);<	         } 
       return;l     }vO   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor)) (     if ((image->class == DirectClass) ||5         (image->colors > visual_info->colormap_size))o       {x
         /*9           Image has more colors than the visual supports.0
         */         if (image->matte)%           {%$             register RunlengthPacket               *p;                /*%               Fake matte information.              */B             Warning("This visual does not support an image matte",4               XVisualClassName(visual_info->class));             p=image->pixels;.             for (i=0; i < image->packets; i++)
             { *               if (p->index == Transparent)                 { F                   p->red=XDownScale(pixel_info->background_color.red);J                   p->green=XDownScale(pixel_info->background_color.green);H                   p->blue=XDownScale(pixel_info->background_color.blue);                 }%               p++;
             }%           } F         QuantizeImage(image,(unsigned int) visual_info->colormap_size,:           resource_info->tree_depth,resource_info->dither,%           resource_info->colorspace);A?         image->class=DirectClass;  /* promote to DirectClass */:       }s   /**     Free previous and create new colormap.   */A   XFreeStandardColormap(display,visual_info,map_info,pixel_info); 9   colormap=XDefaultColormap(display,visual_info->screen);eI   if (visual_info->visual != XDefaultVisual(display,visual_info->screen))pN     colormap=XCreateColormap(display,XRootWindow(display,visual_info->screen),=       visual_info->visual,visual_info->class == DirectColor ?%       AllocAll : AllocNone);"   if (colormap == (Colormap) NULL)5     Error("Unable to create colormap",(char *) NULL);    /*1     Initialize the map and pixel info structures.    */-   XGetMapInfo(visual_info,colormap,map_info); M   XGetPixelInfo(display,visual_info,map_info,resource_info,image,pixel_info);    /*B     Allocating colors in server colormap is based on visual class.   */   switch (visual_info->class)    {      case StaticGray:     case StaticColor:      {        /*F         Define Standard Colormap for StaticGray or StaticColor visual.       */"       number_colors=image->colors;J       colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       p=colors;x+       color.flags=DoRed | DoGreen | DoBlue;i,       if (visual_info->class == StaticColor))         for (i=0; i < image->colors; i++) 	         {y5           color.red=XUpScale(image->colormap[i].red); 9           color.green=XUpScale(image->colormap[i].green);o7           color.blue=XUpScale(image->colormap[i].blue);r6           status=XAllocColor(display,colormap,&color);           if (status == 0)
             { >               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color);c
             } ,           pixel_info->pixels[i]=color.pixel;           *p++=color; 	         }a
       else)         for (i=0; i < image->colors; i++)P	         {r=           gray_value=XUpScale(Intensity(image->colormap[i]));p           color.red=gray_value;n!           color.green=gray_value;s            color.blue=gray_value;6           status=XAllocColor(display,colormap,&color);           if (status == 0)
             {n>               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color); 
             } ,           pixel_info->pixels[i]=color.pixel;           *p++=color;,	         }8       break;     }o     case GrayScale:      case PseudoColor:      {m       unsigned int         colormap_type;         /*E         Define Standard Colormap for GrayScale or PseudoColor visual./       */"       number_colors=image->colors;J       colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       /*#         Preallocate our GUI colors.u       */I       (void) XAllocColor(display,colormap,&pixel_info->foreground_color);aI       (void) XAllocColor(display,colormap,&pixel_info->background_color);uE       (void) XAllocColor(display,colormap,&pixel_info->border_color);dD       (void) XAllocColor(display,colormap,&pixel_info->matte_color);H       (void) XAllocColor(display,colormap,&pixel_info->highlight_color);E       (void) XAllocColor(display,colormap,&pixel_info->shadow_color);CD       (void) XAllocColor(display,colormap,&pixel_info->depth_color);E       (void) XAllocColor(display,colormap,&pixel_info->trough_color);n'       for (i=0; i < MaxNumberPens; i++)>G         (void) XAllocColor(display,colormap,&pixel_info->pen_color[i]);d       /*D         Determine if image colors will "fit" into X server colormap.       */,       colormap_type=resource_info->colormap;N       status=XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0,*         pixel_info->pixels,image->colors);       if (status != 0)&         colormap_type=PrivateColormap;*       if (colormap_type == SharedColormap)	         {m           DiversityPacketu             *diversity;n  "           register RunlengthPacket             *q;              unsigned short             index;             /*P             Define Standard colormap for shared GrayScale or PseudoColor visual:           */'           diversity=(DiversityPacket *)r:             malloc(image->colors*sizeof(DiversityPacket));4           if (diversity == (DiversityPacket *) NULL)J             Error("Unable to create colormap","Memory allocation failed");+           for (i=0; i < image->colors; i++)a           {G4             diversity[i].red=image->colormap[i].red;8             diversity[i].green=image->colormap[i].green;6             diversity[i].blue=image->colormap[i].blue;2             diversity[i].index=(unsigned short) i;!             diversity[i].count=0;            }            q=image->pixels;,           for (i=0; i < image->packets; i++)           {m5             diversity[q->index].count+=(q->length+1);C             q++;           }r           /*0             Sort colors by decreasing intensity.           */I           qsort((void *) diversity,image->colors,sizeof(DiversityPacket),_O             (int (*) _Declare((const void *, const void *))) IntensityCompare); D           for (i=0; i < image->colors; i+=Max(image->colors >> 4,2))J             diversity[i].count<<=4;  /* increase this colors popularity *//           diversity[image->colors-1].count<<=4;fI           qsort((void *) diversity,image->colors,sizeof(DiversityPacket),gP             (int (*) _Declare((const void *, const void *))) PopularityCompare);           /*             Allocate colors.           */           p=colors;5/           color.flags=DoRed | DoGreen | DoBlue;=0           if (visual_info->class == PseudoColor)-             for (i=0; i < image->colors; i++)g
             {e'               index=diversity[i].index; =               color.red=XUpScale(image->colormap[index].red);xA               color.green=XUpScale(image->colormap[index].green);d?               color.blue=XUpScale(image->colormap[index].blue);n:               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;4               pixel_info->pixels[index]=color.pixel;               *p++=color;,
             }d           else-             for (i=0; i < image->colors; i++)n
             {*'               index=diversity[i].index;oE               gray_value=XUpScale(Intensity(image->colormap[index]));h#               color.red=gray_value;t%               color.green=gray_value;l$               color.blue=gray_value;:               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;4               pixel_info->pixels[index]=color.pixel;               *p++=color;_
             }i            if (i < image->colors)
             {l               register int                 j;                 XColor                 *server_colors;-                 /*'                 Read X server colormap.h               */&               server_colors=(XColor *)B                 malloc(visual_info->colormap_size*sizeof(XColor));3               if (server_colors == (XColor *) NULL)oN                 Error("Unable to create colormap","Memory allocation failed");<               for (j=0; j < visual_info->colormap_size; j++)9                 server_colors[j].pixel=(unsigned long) j; :               XQueryColors(display,colormap,server_colors,;                 (int) Min(visual_info->colormap_size,256));o               /*?                 Select remaining colors from X server colormap.                */4               if (visual_info->class == PseudoColor).                 for (; i < image->colors; i++)                 {_+                   index=diversity[i].index;xA                   color.red=XUpScale(image->colormap[index].red);oE                   color.green=XUpScale(image->colormap[index].green);rC                   color.blue=XUpScale(image->colormap[index].blue);f<                   XBestPixel(display,colormap,server_colors,F                     (unsigned int) visual_info->colormap_size,&color);8                   pixel_info->pixels[index]=color.pixel;                   *p++=color;S                 }f               else.                 for (; i < image->colors; i++)                 { +                   index=diversity[i].index;_I                   gray_value=XUpScale(Intensity(image->colormap[index])); '                   color.red=gray_value;%)                   color.green=gray_value;%(                   color.blue=gray_value;<                   XBestPixel(display,colormap,server_colors,F                     (unsigned int) visual_info->colormap_size,&color);8                   pixel_info->pixels[index]=color.pixel;                   *p++=color;                  } =               if (image->colors < visual_info->colormap_size)                  {                    /*G                     Fill up colors array-- more choices for pen colors.                    */                    retain_colors=F                     Min(visual_info->colormap_size-image->colors,256);3                   for (i=0; i < retain_colors; i++)%*                     *p++=server_colors[i];/                   number_colors+=retain_colors;d                 } +               free((char *) server_colors);o
             }e#           free((char *) diversity);a           break;	         }f       /*M         Define Standard colormap for private GrayScale or PseudoColor visual.l       */       if (status == 0)	         {A           /*P             Not enough colormap entries in the colormap-- Create a new colormap.           */+           colormap=XCreateColormap(display,.I             XRootWindow(display,visual_info->screen),visual_info->visual,              AllocNone);a*           if (colormap == (Colormap) NULL)=             Error("Unable to create colormap",(char *) NULL);p&           map_info->colormap=colormap;9           if (image->colors < visual_info->colormap_size)o
             {h               /*K                 Retain colors from the default colormap to help lessens thel-                 effects of colormap flashing.d               */N               retain_colors=Min(visual_info->colormap_size-image->colors,256);%               p=colors+image->colors;a/               for (i=0; i < retain_colors; i++)r               { +                 p->pixel=(unsigned long) i;e                 p++;               }m#               XQueryColors(display,t>                 XDefaultColormap(display,visual_info->screen),:                 colors+image->colors,(int) retain_colors);               /*A                 Transfer colors from default to private colormap.                */O               XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0,s2                 pixel_info->pixels,retain_colors);%               p=colors+image->colors;l/               for (i=0; i < retain_colors; i++))               {K/                 p->pixel=pixel_info->pixels[i];v                 p++;               } P               XStoreColors(display,colormap,colors+image->colors,retain_colors);+               number_colors+=retain_colors;i
             }=K           XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0, .             pixel_info->pixels,image->colors);	         }e       /*!         Store the image colormap.        */       p=colors;f+       color.flags=DoRed | DoGreen | DoBlue; ,       if (visual_info->class == PseudoColor))         for (i=0; i < image->colors; i++)e	         {,5           color.red=XUpScale(image->colormap[i].red);r9           color.green=XUpScale(image->colormap[i].green);_7           color.blue=XUpScale(image->colormap[i].blue);a,           color.pixel=pixel_info->pixels[i];           *p++=color;%	         }%
       else)         for (i=0; i < image->colors; i++) 	         { =           gray_value=XUpScale(Intensity(image->colormap[i]));            color.red=gray_value; !           color.green=gray_value;             color.blue=gray_value;,           color.pixel=pixel_info->pixels[i];           *p++=color; 	         } :       XStoreColors(display,colormap,colors,image->colors);       break;     }      case TrueColor:      case DirectColor:      default:     {        unsigned int         linear_colormap;         /*E         Define Standard Colormap for TrueColor or DirectColor visual.        */K       number_colors=(unsigned int) ((map_info->red_max*map_info->red_mult)+%3         (map_info->green_max*map_info->green_mult)+a4         (map_info->blue_max*map_info->blue_mult)+1);/       linear_colormap=(number_colors > 4096) ||bA         (((map_info->red_max+1) == visual_info->colormap_size) &&cC          ((map_info->green_max+1) == visual_info->colormap_size) && A          ((map_info->blue_max+1) == visual_info->colormap_size));f       if (linear_colormap)1         number_colors=visual_info->colormap_size;        /*         Allocate color array.n       */=       colors=(XColor *) malloc(number_colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       /*%         Initialize linear color ramp.r       */       p=colors;h+       color.flags=DoRed | DoGreen | DoBlue;r       if (linear_colormap))         for (i=0; i < number_colors; i++)o	         {s(           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=(unsigned short)tF               (((i % map_info->green_mult)*65535)/map_info->blue_max);!           color.green=color.blue;            color.red=color.blue; 8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color;e	         }r
       else)         for (i=0; i < number_colors; i++) 	         {)'           color.red=(unsigned short) 0; %           if (map_info->red_max != 0)e&             color.red=(unsigned short)A               (((i/map_info->red_mult)*65535)/map_info->red_max);c)           color.green=(unsigned short) 0;K'           if (map_info->green_max != 0)oF             color.green=(unsigned short) ((((i/map_info->green_mult) %C               (map_info->green_max+1))*65535)/map_info->green_max); (           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=(unsigned short) F               (((i % map_info->green_mult)*65535)/map_info->blue_max);8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color;a	         }_0       if ((visual_info->class == DirectColor) &&F           (colormap != XDefaultColormap(display,visual_info->screen)))<         XStoreColors(display,colormap,colors,number_colors);
       else)         for (i=0; i < number_colors; i++)_3           XAllocColor(display,colormap,&colors[i]);        break;     }%   }%O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor))      {        /*8         Set foreground, background, border, etc. pixels.       */7       XBestPixel(display,colormap,colors,number_colors, '         &pixel_info->foreground_color); 7       XBestPixel(display,colormap,colors,number_colors, '         &pixel_info->background_color); /       if (pixel_info->background_color.pixel == -           pixel_info->foreground_color.pixel) 	         {            /*9             Foreground and background colors must differ.            */O           pixel_info->background_color.red=(~pixel_info->foreground_color.red);%-           pixel_info->background_color.green=%2             (~pixel_info->foreground_color.green);,           pixel_info->background_color.blue=1             (~pixel_info->foreground_color.blue); ;           XBestPixel(display,colormap,colors,number_colors,o+             &pixel_info->background_color);m	         }s7       XBestPixel(display,colormap,colors,number_colors,t#         &pixel_info->border_color);r7       XBestPixel(display,colormap,colors,number_colors,i"         &pixel_info->matte_color);7       XBestPixel(display,colormap,colors,number_colors,s&         &pixel_info->highlight_color);7       XBestPixel(display,colormap,colors,number_colors,I#         &pixel_info->shadow_color);o7       XBestPixel(display,colormap,colors,number_colors, "         &pixel_info->depth_color);7       XBestPixel(display,colormap,colors,number_colors,e#         &pixel_info->trough_color);t'       for (i=0; i < MaxNumberPens; i++)*       { 9         XBestPixel(display,colormap,colors,number_colors,r%           &pixel_info->pen_color[i]); K         pixel_info->pixels[image->colors+i]=pixel_info->pen_color[i].pixel;e       }+5       pixel_info->colors=image->colors+MaxNumberPens;      }    free((char *) colors);   if (resource_info->debug)      {e4       (void) fprintf(stderr,"Standard Colormap:\n");I       (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap);uD       (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",B         map_info->red_max,map_info->green_max,map_info->blue_max);E       (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n",eE         map_info->red_mult,map_info->green_mult,map_info->blue_mult);r     }( }o e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %mO %                                                                             %iO %                                                                             %lO %   X M a k e W i n d o w                                                     %lO %                                                                             % O %                                                                             %cO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l % . %  Function XMakeWindow creates an X11 window. %m, %  The format of the XMakeWindow routine is: %cE %      XMakeWindow(display,parent,argv,argc,class_hint,manager_hints,) %        window_info)l %p+ %  A description of each parameter follows:b %eD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %r0 %    o parent: Specifies the parent window_info. %H7 %    o argv: Specifies the application's argument list.  %0/ %    o argc: Specifies the number of arguments.  %fE %    o class_hint: Specifies a pointer to a X11 XClassHint structure.p %=F %    o manager_hints: Specifies a pointer to a X11 XWMHints structure. %rG %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.d %n %o */O void XMakeWindow(display,parent,argv,argc,class_hint,manager_hints,window_info)v Display    *display;e   Window	   parent;s   char	   **argv;i   int,   argc;   
 XClassHint   *class_hint;   XWMHints   *manager_hints;o   XWindowInfo    *window_info;s {e #define MinWindowSize  64,     Atom     atom_list[2];e     intb     gravity,     status;      XSizeHints     *size_hints;     XTextPropertyc     icon_name,     window_name;     /*     Set window_info hints.   */   size_hints=XAllocSizeHints();l(   if (size_hints == (XSizeHints *) NULL)@     Error("Unable to make X window","Memory allocation failed");'   size_hints->flags=window_info->flags;l   size_hints->x=window_info->x;,   size_hints->y=window_info->y;n'   size_hints->width=window_info->width;o)   size_hints->height=window_info->height;n   if (window_info->immutable)i     {n       /*&         Window size cannot be changed.       */.       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;"       size_hints->flags|=PMinSize;"       size_hints->flags|=PMaxSize;     }    else     {s       /*#         Window size can be changed.        */3       size_hints->min_width=window_info->min_width;e5       size_hints->min_height=window_info->min_height;-$       size_hints->flags|=PResizeInc;3       size_hints->width_inc=window_info->width_inc; 5       size_hints->height_inc=window_info->height_inc;o #ifndef PRE_R4_ICCCM#       size_hints->flags|=PBaseSize;i3       size_hints->base_width=size_hints->width_inc;t5       size_hints->base_height=size_hints->height_inc;- #endif     }    gravity=NorthWestGravity;e-   if (window_info->geometry != (char *) NULL)o     {f
       char(         default_geometry[MaxTextLength],          geometry[MaxTextLength];  	       inti         flags;         register chars         *p;t         /*          User specified geometry.       */@       (void) sprintf(default_geometry,"%dx%d",size_hints->width,         size_hints->height);4       (void) strcpy(geometry,window_info->geometry);       p=geometry;a!       while ((int) strlen(p) > 0)"       { (         if (!isspace(*p) && (*p != '%'))           p++;         else           (void) strcpy(p,p+1);e       }fN       flags=XWMGeometry(display,window_info->screen,geometry,default_geometry,K         window_info->border_width,size_hints,&size_hints->x,&size_hints->y,l9         &size_hints->width,&size_hints->height,&gravity); 8       if ((flags & WidthValue) && (flags & HeightValue))"         size_hints->flags|=USSize;/       if ((flags & XValue) && (flags & YValue))0	         {o(           size_hints->flags|=USPosition;'           window_info->x=size_hints->x; '           window_info->y=size_hints->y;y	         }a     }p #ifndef PRE_R4_ICCCM"   size_hints->win_gravity=gravity;!   size_hints->flags|=PWinGravity;o #endif'   if (window_info->id == (Window) NULL)iO     window_info->id=XCreateWindow(display,parent,window_info->x,window_info->y, G       window_info->width,window_info->height,window_info->border_width,hK       window_info->depth,InputOutput,window_info->visual,window_info->mask,i        &window_info->attributes);   else     {        unsigned int
         mask;v         XEvent         sans_event;s         XWindowChanges         window_changes;a         /*;         Window already exists;  change relevant attributes.n       */H       XChangeWindowAttributes(display,window_info->id,window_info->mask,"         &window_info->attributes);       mask=ConfigureNotify;aO       while (XCheckTypedWindowEvent(display,window_info->id,mask,&sans_event));e&       window_changes.x=window_info->x;&       window_changes.y=window_info->y;.       window_changes.width=window_info->width;0       window_changes.height=window_info->height;       mask=CWWidth | CWHeight;*       if (window_info->flags & USPosition)         mask|=CWX | CWY;L       XReconfigureWMWindow(display,window_info->id,window_info->screen,mask,         &window_changes);a     }c'   if (window_info->id == (Window) NULL)f7     Error("Unable to create window",window_info->name);pF   status=XStringListToTextProperty(&window_info->name,1,&window_name);   if (status == 0)>     Error("Unable to create text property",window_info->name);I   status=XStringListToTextProperty(&window_info->icon_name,1,&icon_name);e   if (status == 0)C     Error("Unable to create text property",window_info->icon_name);s2   if (window_info->icon_geometry != (char *) NULL)     {o	       inte         flags,         gravity,         height,          width;         /*%         User specified icon geometry.l       */$       size_hints->flags|=USPosition;O       flags=XWMGeometry(display,window_info->screen,window_info->icon_geometry,m:         (char *) NULL,0,size_hints,&manager_hints->icon_x,8         &manager_hints->icon_y,&width,&height,&gravity);/       if ((flags & XValue) && (flags & YValue))r/         manager_hints->flags|=IconPositionHint;n     } M   XSetWMProperties(display,window_info->id,&window_name,&icon_name,argv,argc,m)     size_hints,manager_hints,class_hint);l$   XFree((void *) window_name.value);"   XFree((void *) icon_name.value);=   atom_list[0]=XInternAtom(display,"WM_DELETE_WINDOW",False);r:   atom_list[1]=XInternAtom(display,"WM_TAKE_FOCUS",False);7   XSetWMProtocols(display,window_info->id,atom_list,2);t   XFree((void *) size_hints);o }e f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             %tO %                                                                             %oO %                                                                             %sO %   X M o n t a g e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" %rH %  Function XMontageImage creates a composite image by combining several %  separate images.  % . %  The format of the XMontageImage routine is: %fH %      XMontageImage(display,resource_info,montage_info,filename,images) %a+ %  A description of each parameter follows:_ %oE %    o display: Specifies a connection to an X server;  returned frome %      XOpenDisplay. %tK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.b %,D %    o montage_info: Specifies a pointer to a MontageInfo structure. %_9 %    o filename: Specifies the name of the montage image.e %tB %    o image: Specifies a pointer to an array of Image structures. %s %c */   static int SceneCompare(x,y)
 const void   *x,e   *y;d {b   Imaget     **image_1,     **image_2;     image_1=(Image **) x;s   image_2=(Image **) y; :   return((int) (*image_1)->scene-(int) (*image_2)->scene); }t  H Image *XMontageImage(display,resource_info,montage_info,filename,images) Displayo   *display;o  
 XResourceInfoe   *resource_info;h   XMontageInfo   *montage_info;   char   *filename;   Imagee   **images;s { 
   ColorPacket,     background_color,)     border_color,      highlight_color,     matte_color,     shadow_color;)     Image      *image,i     *montage_image;      inte     x,
     x_offset,=     y,
     y_offset;-     register char      *q;e     register int     i;     register RunlengthPacket     *p;c     RectangleInfol     label_info,      tile_info;     unsigned int     border_width,r     bevel_width,
     count,     labels,      max_width,     number_images,     number_tiles,%	     tile,%     tiles_per_column,      tiles_per_row;     XAnnotateInfo      annotate_info;     XColor
     color;  
   XFontStruct      *font_info;      XPixelInfo     pixel_info;      /**     Sort images by increasing tile number.   */*   number_tiles=montage_info->number_tiles;/   labels=resource_info->title != (char *) NULL; 
   count=0;+   for (tile=0; tile < number_tiles; tile++)    {      count+=images[tile]->scene; 3     labels|=(images[tile]->label != (char *) NULL);    }    if (count != 0) 7     qsort((void *) images,number_tiles,sizeof(Image *), E       (int (*) _Declare((const void *, const void *))) SceneCompare);%   /*'     Determine tiles per row and column.    */   tiles_per_row=1;   tiles_per_column=1; 9   while ((tiles_per_row*tiles_per_column) < number_tiles)d   {d     tiles_per_row++;     tiles_per_column++;u   }r*   if (montage_info->tile != (char *) NULL)     {a2       tiles_per_column=montage_info->number_tiles;P       XParseGeometry(montage_info->tile,&x,&y,&tiles_per_row,&tiles_per_column);     }r   /*     Determine tile sizes.c   */+   border_width=resource_info->border_width;e   bevel_width=0;   if (montage_info->frame)     {i(       bevel_width=(border_width >> 2)+1;%       border_width+=bevel_width << 1;S     }s*   tile_info.x=resource_info->border_width;*   tile_info.y=resource_info->border_width;5   if (resource_info->image_geometry != (char *) NULL)      {sM       XParseGeometry(resource_info->image_geometry,&tile_info.x,&tile_info.y,r,         &tile_info.width,&tile_info.height);       if (tile_info.x < 0)         tile_info.x=0;       if (tile_info.y < 0)         tile_info.y=0;     }d%   tile_info.width=images[0]->columns;e#   tile_info.height=images[0]->rows;,9   for (tile=1; tile < montage_info->number_tiles; tile++)c   {_0     if (images[tile]->columns > tile_info.width),       tile_info.width=images[tile]->columns;.     if (images[tile]->rows > tile_info.height)*       tile_info.height=images[tile]->rows;   }    /*     Initialize tile colors.s   */E   (void) XQueryColorDatabase(resource_info->background_color,&color); -   background_color.red=XDownScale(color.red);a1   background_color.green=XDownScale(color.green);u/   background_color.blue=XDownScale(color.blue);u   background_color.index=0; E   (void) XQueryColorDatabase(resource_info->foreground_color,&color); "   pixel_info.annotate_color=color;A   (void) XQueryColorDatabase(resource_info->border_color,&color); )   border_color.red=XDownScale(color.red); -   border_color.green=XDownScale(color.green); +   border_color.blue=XDownScale(color.blue);    border_color.index=0; @   (void) XQueryColorDatabase(resource_info->matte_color,&color);(   matte_color.red=XDownScale(color.red);,   matte_color.green=XDownScale(color.green);*   matte_color.blue=XDownScale(color.blue);   matte_color.index=0;?   highlight_color.red=(XDownScale(color.red)*HighlightModulate+ =     (unsigned int) (MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB; C   highlight_color.green=(XDownScale(color.green)*HighlightModulate+%=     (unsigned int) (MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB; A   highlight_color.blue=(XDownScale(color.blue)*HighlightModulate+ =     (unsigned int) (MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB;f   highlight_color.index=0;@   (void) XQueryColorDatabase(resource_info->matte_color,&color);!   shadow_color.red=(unsigned int)m2     (XDownScale(color.red)*ShadowModulate)/MaxRGB;#   shadow_color.green=(unsigned int) 4     (XDownScale(color.green)*ShadowModulate)/MaxRGB;"   shadow_color.blue=(unsigned int)3     (XDownScale(color.blue)*ShadowModulate)/MaxRGB;n   shadow_color.index=0;o#   XGetAnnotateInfo(&annotate_info); "   if (display == (Display *) NULL)     labels=False;t   else     {        /*         Initialize font info.        */7       font_info=XBestFont(display,resource_info,False);nE       annotate_info.text=(char *) malloc(MaxTextLength*sizeof(char)); 0       if ((font_info == (XFontStruct *) NULL) ||0           (annotate_info.text == (char *) NULL))	         { I           Warning("Unable to montage images","Memory allocation failed");W!           return((Image *) NULL);y	         }((       annotate_info.font_info=font_info;@       annotate_info.height=font_info->ascent+font_info->descent;     }r   /*     Allocate image structure.d   */2   montage_image=AllocateImage((ImageInfo *) NULL);&   if (montage_image == (Image *) NULL)     {fE       Warning("Unable to montage images","Memory allocation failed");d       return((Image *) NULL);      }=   montage_image->scene=1;    number_images=F     (montage_info->number_tiles-1)/(tiles_per_row*tiles_per_column)+1;#   for (i=0; i < number_images; i++)%   {%     /*!       Initialize Image structure.%     */4     (void) strcpy(montage_image->filename,filename);     montage_image->columns= C       (tile_info.width+(tile_info.x+border_width)*2)*tiles_per_row; P     number_tiles=Min(montage_info->number_tiles,tiles_per_row*tiles_per_column);G     montage_image->rows=(tile_info.height+(tile_info.y+border_width)*2+ -       (labels ? annotate_info.height+4 : 0))* J       (number_tiles/tiles_per_row+ ((number_tiles % tiles_per_row) != 0));.     if (resource_info->title != (char *) NULL)N       montage_image->rows+=((annotate_info.height+4) << 1)+(tile_info.y << 1);G     montage_image->montage=(char *) malloc(MaxTextLength*sizeof(char));%     count=1;-     for (tile=0; tile < number_tiles; tile++) .       count+=strlen(images[tile]->filename)+1;A     montage_image->directory=(char *) malloc(count*sizeof(char));rF     montage_image->packets=montage_image->columns*montage_image->rows;-     montage_image->pixels=(RunlengthPacket *) L       malloc((unsigned int) montage_image->packets*sizeof(RunlengthPacket));4     if ((montage_image->montage == (char *) NULL) ||6         (montage_image->directory == (char *) NULL) ||<         (montage_image->pixels == (RunlengthPacket *) NULL))       {:G         Warning("Unable to montage images","Memory allocation failed");t%         DestroyImages(montage_image);          return((Image *) NULL);r       }n     /*       Set montage geometry.      */     x_offset=0;      y_offset=0;n.     if (resource_info->title != (char *) NULL)C       y_offset+=((annotate_info.height+4) << 1)+(tile_info.y << 1);l#     *montage_image->directory='\0';a8     (void) sprintf(montage_image->montage,"%dx%d%+d%+d",;       (int) (tile_info.width+(tile_info.x+border_width)*2), ;       (int) (tile_info.height+(tile_info.y+border_width)*2+=-       (labels ? annotate_info.height+4 : 0)),o       x_offset,y_offset);u     /*3       Initialize montage image to background color.a     */     p=montage_image->pixels;.     for (x=0; x < montage_image->packets; x++)     { "       p->red=background_color.red;&       p->green=background_color.green;$       p->blue=background_color.blue;       p->index=0;        p->length=0;
       p++;     }n/     if (montage_info->texture != (char *) NULL)t       {l
         Image            *texture_image;            ImageInfoa           texture_info;W  $         GetImageInfo(&texture_info);C         (void) strcpy(texture_info.filename,montage_info->texture);_/         texture_image=ReadImage(&texture_info); ,         if (texture_image != (Image *) NULL)           {p             /*5               Tile texture onto the image background.d             */F             for (y=0; y < montage_image->rows; y+=texture_image->rows)N               for (x=0; x < montage_image->columns; x+=texture_image->columns)N                 CompositeImage(montage_image,ReplaceCompositeOp,texture_image,                   x,y);t(             DestroyImage(texture_image);           }x       },.     if (resource_info->title != (char *) NULL)       {S
         /*,           Copy title to the composite image.
         */?         (void) strcpy(annotate_info.text,resource_info->title);a         annotate_info.width=N           XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));)         max_width=montage_image->columns; D         if (((annotate_info.width+tile_info.x*2) << 1) >= max_width)           {a             /**               Label is too wide-- shorten.             */<             q=annotate_info.text+strlen(annotate_info.text);             do
             {                *--q='\0';7               if ((int) strlen(annotate_info.text) > 2)e)                 (void) strcpy(q-2,"...");oJ               annotate_info.width=XTextWidth(font_info,annotate_info.text,,                 strlen(annotate_info.text));P             } while ((2*(annotate_info.width+(tile_info.x << 1))) >= max_width);           }%6         label_info.width=(annotate_info.width << 1)-1;8         label_info.height=(annotate_info.height << 1)-1;E         label_info.x=tile_info.x+(int) (montage_image->columns >> 1)- $           (int) annotate_info.width;#         label_info.y=tile_info.y+4; <         (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",H           label_info.width,label_info.height,label_info.x,label_info.y);F         (void) XAnnotateImage(display,&pixel_info,&annotate_info,True,           montage_image);        }      /*.       Copy tile images to the composite image.     */     x_offset=tile_info.x;      y_offset=tile_info.y;%.     if (resource_info->title != (char *) NULL)C       y_offset+=((annotate_info.height+4) << 1)+(tile_info.y << 1);n#     *montage_image->directory='\0';e-     for (tile=0; tile < number_tiles; tile++)e     {        /*.         Copy this tile to the composite image.       */       image=images[tile];a>       (void) strcat(montage_image->directory,image->filename);3       (void) strcat(montage_image->directory,"\n");p       if (border_width != 0)	         {            Imagen             *bordered_image;             RectangleInfo              border_info;             /**             Put a border around the image.           */)           border_info.width=border_width;n*           border_info.height=border_width;"           if (montage_info->frame)
             {tH               border_info.width=(tile_info.width-image->columns+1) >> 1;G               border_info.height=(tile_info.height-image->rows+1) >> 1;n
             }eG           bordered_image=BorderImage(image,&border_info,&border_color);s/           if (bordered_image != (Image *) NULL)l
             {n"               DestroyImage(image);#               image=bordered_image;e
             }c	         }c       /*9         Gravitate image as specified by the tile gravity.a       */%       switch (resource_info->gravity)o       {s         case NorthWestGravity:	         {s           x=0;           y=0;           break;	         }e         case NorthGravity:	         {tH           x=((tile_info.width+(border_width << 1))-image->columns) >> 1;           y=0;           break;	         }o         case NorthEastGravity:	         { A           x=(tile_info.width+(border_width << 1))-image->columns;a           y=0;           break;	         }          case WestGravity: 	         {n           x=0;F           y=((tile_info.height+(border_width << 1))-image->rows) >> 1;           break;	         }t         case ForgetGravity:          case StaticGravity:          case CenterGravity:t         default:	         {hH           x=((tile_info.width+(border_width << 1))-image->columns) >> 1;F           y=((tile_info.height+(border_width << 1))-image->rows) >> 1;           break;	         }e         case EastGravity: 	         {sA           x=(tile_info.width+(border_width << 1))-image->columns;sF           y=((tile_info.height+(border_width << 1))-image->rows) >> 1;           break;	         }          case SouthWestGravity:	         {w           x=0;?           y=(tile_info.height+(border_width << 1))-image->rows;a           break;	         }d         case SouthGravity:	         { H           x=((tile_info.width+(border_width << 1))-image->columns) >> 1;?           y=(tile_info.height+(border_width << 1))-image->rows;t           break;	         }r         case SouthEastGravity:	         {rA           x=(tile_info.width+(border_width << 1))-image->columns;i?           y=(tile_info.height+(border_width << 1))-image->rows;r           break;	         }t       }_4       if (montage_info->frame && (bevel_width != 0))	         {d           FrameInfo*             frame_info;.             Imagei             *framed_image;             /*6             Put an ornamental border around this tile.           */-           frame_info.matte_color=matte_color;=5           frame_info.highlight_color=highlight_color;c/           frame_info.shadow_color=shadow_color; ?           frame_info.width=tile_info.width+(border_width << 1); A           frame_info.height=tile_info.height+(border_width << 1);D           if (labels) 6             frame_info.height+=annotate_info.height+4;2           frame_info.x=(x > 0 ? x : border_width);2           frame_info.y=(y > 0 ? y : border_width);-           frame_info.inner_bevel=bevel_width;i-           frame_info.outer_bevel=bevel_width;e5           framed_image=FrameImage(image,&frame_info);h-           if (framed_image != (Image *) NULL)f
             {h"               DestroyImage(image);!               image=framed_image;y
             }f           x=0;           y=0;	         }r       /*3         Composite background image with tile image.a       */?       CompositeImage(montage_image,montage_info->compose,image,i         x_offset+x,y_offset+y);y       if (montage_info->shadow)=	         {(           ColorPacketd             shadow_color,s             trough_color;t             register int             columns,             rows;u             /*6             Put a shadow under the tile to show depth.           */M           (void) XQueryColorDatabase(resource_info->background_color,&color);a)           shadow_color.red=(unsigned int) :             (XDownScale(color.red)*ShadowModulate)/MaxRGB;+           shadow_color.green=(unsigned int)p<             (XDownScale(color.green)*ShadowModulate)/MaxRGB;*           shadow_color.blue=(unsigned int);             (XDownScale(color.blue)*ShadowModulate)/MaxRGB;wM           (void) XQueryColorDatabase(resource_info->background_color,&color);p)           trough_color.red=(unsigned int)s:             (XDownScale(color.red)*TroughModulate)/MaxRGB;+           trough_color.green=(unsigned int)(<             (XDownScale(color.green)*TroughModulate)/MaxRGB;*           trough_color.blue=(unsigned int);             (XDownScale(color.blue)*TroughModulate)/MaxRGB;o2           for (rows=0; rows < image->rows; rows++)           {>O             p=montage_image->pixels+montage_image->columns*(y_offset+y+rows+4)+ (               x_offset+x+image->columns;D             for (columns=0; columns < Min(tile_info.x,4); columns++)
             { ,               if (((columns+rows) % 2) == 0)                 { *                   p->red=shadow_color.red;.                   p->green=shadow_color.green;,                   p->blue=shadow_color.blue;                 }e               else                 {)*                   p->red=trough_color.red;.                   p->green=trough_color.green;,                   p->blue=trough_color.blue;                 }                p++;
             }i           } 9           for (rows=0; rows < Min(tile_info.y,4); rows++)o           { ;             p=montage_image->pixels+montage_image->columns* 9               (y_offset+y+image->rows+rows)+x_offset+x+4;e@             for (columns=0; columns < image->columns; columns++)
             { ,               if (((columns+rows) % 2) == 0)                 {e*                   p->red=shadow_color.red;.                   p->green=shadow_color.green;,                   p->blue=shadow_color.blue;                 }.               else                 {w*                   p->red=trough_color.red;.                   p->green=trough_color.green;,                   p->blue=trough_color.blue;                 }s               p++;
             }o           }v	         }_K       if ((display != (Display *) NULL) && (image->label != (char *) NULL)) 	         {i           /*3             Copy tile label to the composite image.o           */9           (void) strcpy(annotate_info.text,image->label);            annotate_info.width=P             XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));I           max_width=tile_info.width+(resource_info->border_width << 1)-8;t/           if (annotate_info.width >= max_width)r
             {                /*,                 Label is too wide-- shorten.               */>               q=annotate_info.text+strlen(annotate_info.text);               do               {l                 *--q='\0';9                 if ((int) strlen(annotate_info.text) > 2) +                   (void) strcpy(q-2,"..."); L                 annotate_info.width=XTextWidth(font_info,annotate_info.text,.                   strlen(annotate_info.text));9               } while (annotate_info.width >= max_width);l
             } /           label_info.width=annotate_info.width;o1           label_info.height=annotate_info.height; M           label_info.x=x_offset+((tile_info.width+(border_width << 1)) >> 1)-)'             (annotate_info.width >> 1);             label_info.y=y_offset;#           if (!montage_info->frame) 6             label_info.y+=y+tile_info.y+image->rows+2;           elseM             label_info.y+=tile_info.height+(border_width << 1)-bevel_width-2;e>           (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",J             label_info.width,label_info.height,label_info.x,label_info.y);C           (void) XAnnotateImage(display,&pixel_info,&annotate_info,(?             (unsigned int) !montage_info->frame,montage_image);L	         }        DestroyImage(image);*       if (((tile+1) % tiles_per_row) != 0)?         x_offset+=tile_info.width+(tile_info.x+border_width)*2;a
       else	         {r           x_offset=tile_info.x;rB           y_offset+=tile_info.height+(tile_info.y+border_width)*2+2             (labels ? annotate_info.height+4 : 0);	         }k     }      if (i < (number_images-1))       { 
         /*(           Allocate next image structure.
         */%         CompressImage(montage_image);e>         montage_image->next=AllocateImage((ImageInfo *) NULL);2         if (montage_image->next == (Image *) NULL)           {>)             DestroyImages(montage_image); #             return((Image *) NULL);g           } >         (void) strcpy(montage_image->next->filename,filename);6         montage_image->next->file=montage_image->file;:         montage_image->next->scene=montage_image->scene+1;4         montage_image->next->previous=montage_image;*         montage_image=montage_image->next;         images+=number_tiles; 1         montage_info->number_tiles-=number_tiles;s       }    }    CompressImage(montage_image);0$   free((char *) annotate_info.text);"   if (display != (Display *) NULL)!     XFreeFont(display,font_info); 3   while (montage_image->previous != (Image *) NULL)+*     montage_image=montage_image->previous;   return(montage_image); }n = /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %nO %                                                                             %;O %                                                                             % O %   X Q u e r y C o l o r D a t a b a s e                                     % O %                                                                             % O %                                                                             %pO %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XQueryColorDatabase looks up a RGB values for a color given in the %  target string.e %i4 %  The format of the XQueryColorDatabase routine is: %e- %    status=XQueryColorDatabase(target,color)- %d+ %  A description of each parameter follows:  %;K %    o status:  Function XQueryColorDatabase returns True if the RGB values*C %      of the target color is defined, otherwise False is returned.r % E %    o target: Specifies the color to lookup in the X color database.P %eL %    o color: A pointer to an XColor structure.  The RGB value of the target' %      color is returned as this value.o %a %i */. unsigned int XQueryColorDatabase(target,color) char
   *target;   XColor	   *color;i {    typedef struct _XColorList   {[     char       *name;       unsigned char)
       red,       green,       blue;i   } XColorList;c     static XColorList      colorlist[] =r     {o!       "AliceBlue", 240, 248, 255,[$       "AntiqueWhite", 250, 235, 215,%       "AntiqueWhite1", 255, 239, 219,s%       "AntiqueWhite2", 238, 223, 204,-%       "AntiqueWhite3", 205, 192, 176,g%       "AntiqueWhite4", 139, 131, 120, &       "BlanchedAlmond", 255, 235, 205,!       "BlueViolet", 138, 43, 226,         "CadetBlue", 95, 158, 160,"       "CadetBlue1", 152, 245, 255,"       "CadetBlue2", 142, 229, 238,"       "CadetBlue3", 122, 197, 205,!       "CadetBlue4", 83, 134, 139, &       "CornflowerBlue", 100, 149, 237,       "Crimson", 220, 20, 60,        "DarkBlue", 0, 0, 139,       "DarkCyan", 0, 139, 139,$       "DarkGoldenrod", 184, 134, 11,%       "DarkGoldenrod1", 255, 185, 15,,%       "DarkGoldenrod2", 238, 173, 14,F%       "DarkGoldenrod3", 205, 149, 12, $       "DarkGoldenrod4", 139, 101, 8,        "DarkGray", 169, 169, 169,       "DarkGreen", 0, 100, 0,i        "DarkGrey", 169, 169, 169,!       "DarkKhaki", 189, 183, 107,a!       "DarkMagenta", 139, 0, 139,w$       "DarkOliveGreen", 85, 107, 47,'       "DarkOliveGreen1", 202, 255, 112,,'       "DarkOliveGreen2", 188, 238, 104, &       "DarkOliveGreen3", 162, 205, 90,&       "DarkOliveGreen4", 110, 139, 61,        "DarkOrange", 255, 140, 0,!       "DarkOrange1", 255, 127, 0, !       "DarkOrange2", 238, 118, 0,.!       "DarkOrange3", 205, 102, 0,         "DarkOrange4", 139, 69, 0,!       "DarkOrchid", 153, 50, 204,t"       "DarkOrchid1", 191, 62, 255,"       "DarkOrchid2", 178, 58, 238,"       "DarkOrchid3", 154, 50, 205,"       "DarkOrchid4", 104, 34, 139,       "DarkRed", 139, 0, 0,d"       "DarkSalmon", 233, 150, 122,$       "DarkSeaGreen", 143, 188, 143,%       "DarkSeaGreen1", 193, 255, 193, %       "DarkSeaGreen2", 180, 238, 180, %       "DarkSeaGreen3", 155, 205, 155, %       "DarkSeaGreen4", 105, 139, 105, #       "DarkSlateBlue", 72, 61, 139, "       "DarkSlateGray", 47, 79, 79,&       "DarkSlateGray1", 151, 255, 255,&       "DarkSlateGray2", 141, 238, 238,&       "DarkSlateGray3", 121, 205, 205,%       "DarkSlateGray4", 82, 139, 139,_"       "DarkSlateGrey", 47, 79, 79,#       "DarkTurquoise", 0, 206, 209,         "DarkViolet", 148, 0, 211,       "DeepPink", 255, 20, 147,         "DeepPink1", 255, 20, 147,        "DeepPink2", 238, 18, 137,        "DeepPink3", 205, 16, 118,       "DeepPink4", 139, 10, 80,_!       "DeepSkyBlue", 0, 191, 255, "       "DeepSkyBlue1", 0, 191, 255,"       "DeepSkyBlue2", 0, 178, 238,"       "DeepSkyBlue3", 0, 154, 205,"       "DeepSkyBlue4", 0, 104, 139,       "DimGray", 105, 105, 105,f       "DimGrey", 105, 105, 105, !       "DodgerBlue", 30, 144, 255, "       "DodgerBlue1", 30, 144, 255,"       "DodgerBlue2", 28, 134, 238,"       "DodgerBlue3", 24, 116, 205,!       "DodgerBlue4", 16, 78, 139, #       "FloralWhite", 255, 250, 240, !       "ForestGreen", 34, 139, 34, "       "GhostWhite", 248, 248, 255,"       "GreenYellow", 173, 255, 47,       "HotPink", 255, 105, 180,         "HotPink1", 255, 110, 180,        "HotPink2", 238, 106, 167,       "HotPink3", 205, 96, 144,        "HotPink4", 139, 58, 98,       "IndianRed", 205, 92, 92, "       "IndianRed1", 255, 106, 106,        "IndianRed2", 238, 99, 99,        "IndianRed3", 205, 85, 85,        "IndianRed4", 139, 58, 58,       "Indigo", 75, 0, 130,        "Indigo2", 33, 136, 104,%       "LavenderBlush", 255, 240, 245,%&       "LavenderBlush1", 255, 240, 245,&       "LavenderBlush2", 238, 224, 229,&       "LavenderBlush3", 205, 193, 197,&       "LavenderBlush4", 139, 131, 134,       "LawnGreen", 124, 252, 0,i$       "LemonChiffon", 255, 250, 205,%       "LemonChiffon1", 255, 250, 205,o%       "LemonChiffon2", 238, 233, 191,t%       "LemonChiffon3", 205, 201, 165,f%       "LemonChiffon4", 139, 137, 112,e!       "LightBlue", 173, 216, 230, "       "LightBlue1", 191, 239, 255,"       "LightBlue2", 178, 223, 238,"       "LightBlue3", 154, 192, 205,"       "LightBlue4", 104, 131, 139,"       "LightCoral", 240, 128, 128,!       "LightCyan", 224, 255, 255,t"       "LightCyan1", 224, 255, 255,"       "LightCyan2", 209, 238, 238,"       "LightCyan3", 180, 205, 205,"       "LightCyan4", 122, 139, 139,&       "LightGoldenrod", 238, 221, 130,'       "LightGoldenrod1", 255, 236, 139,e'       "LightGoldenrod2", 238, 220, 130,n'       "LightGoldenrod3", 205, 190, 112,l&       "LightGoldenrod4", 139, 129, 76,,       "LightGoldenrodYellow", 250, 250, 210,!       "LightGray", 211, 211, 211, "       "LightGreen", 144, 238, 144,!       "LightGrey", 211, 211, 211,n!       "LightPink", 255, 182, 193,_"       "LightPink1", 255, 174, 185,"       "LightPink2", 238, 162, 173,"       "LightPink3", 205, 140, 149,!       "LightPink4", 139, 95, 101,(#       "LightSalmon", 255, 160, 122,C$       "LightSalmon1", 255, 160, 122,$       "LightSalmon2", 238, 149, 114,#       "LightSalmon3", 205, 129, 98,("       "LightSalmon4", 139, 87, 66,$       "LightSeaGreen", 32, 178, 170,$       "LightSkyBlue", 135, 206, 250,%       "LightSkyBlue1", 176, 226, 255, %       "LightSkyBlue2", 164, 211, 238,w%       "LightSkyBlue3", 141, 182, 205,($       "LightSkyBlue4", 96, 123, 139,&       "LightSlateBlue", 132, 112, 255,&       "LightSlateGray", 119, 136, 153,&       "LightSlateGrey", 119, 136, 153,&       "LightSteelBlue", 176, 196, 222,'       "LightSteelBlue1", 202, 225, 255,a'       "LightSteelBlue2", 188, 210, 238,>'       "LightSteelBlue3", 162, 181, 205,e'       "LightSteelBlue4", 110, 123, 139,i#       "LightYellow", 255, 255, 224,h$       "LightYellow1", 255, 255, 224,$       "LightYellow2", 238, 238, 209,$       "LightYellow3", 205, 205, 180,$       "LightYellow4", 139, 139, 122,       "LimeGreen", 50, 205, 50,e(       "MediumAquamarine", 102, 205, 170,       "MediumBlue", 0, 0, 205,#       "MediumOrchid", 186, 85, 211,)%       "MediumOrchid1", 224, 102, 255,s$       "MediumOrchid2", 209, 95, 238,$       "MediumOrchid3", 180, 82, 205,$       "MediumOrchid4", 122, 55, 139,$       "MediumPurple", 147, 112, 219,%       "MediumPurple1", 171, 130, 255, %       "MediumPurple2", 159, 121, 238, %       "MediumPurple3", 137, 104, 205,i#       "MediumPurple4", 93, 71, 139,i%       "MediumSeaGreen", 60, 179, 113,e'       "MediumSlateBlue", 123, 104, 238,w'       "MediumSpringGreen", 0, 250, 154,C&       "MediumTurquoise", 72, 209, 204,&       "MediumVioletRed", 199, 21, 133,"       "MidnightBlue", 25, 25, 112,!       "MintCream", 245, 255, 250, !       "MistyRose", 255, 228, 225,;"       "MistyRose1", 255, 228, 225,"       "MistyRose2", 238, 213, 210,"       "MistyRose3", 205, 183, 181,"       "MistyRose4", 139, 125, 123,#       "NavajoWhite", 255, 222, 173,d$       "NavajoWhite1", 255, 222, 173,$       "NavajoWhite2", 238, 207, 161,$       "NavajoWhite3", 205, 179, 139,#       "NavajoWhite4", 139, 121, 94,t       "NavyBlue", 0, 0, 128,       "OldLace", 253, 245, 230,i        "OliveDrab", 107, 142, 35,!       "OliveDrab1", 192, 255, 62,x!       "OliveDrab2", 179, 238, 58,s!       "OliveDrab3", 154, 205, 50,a!       "OliveDrab4", 105, 139, 34,W       "OrangeRed", 255, 69, 0,       "OrangeRed1", 255, 69, 0,C       "OrangeRed2", 238, 64, 0,M       "OrangeRed3", 205, 55, 0,C       "OrangeRed4", 139, 37, 0,d%       "PaleGoldenrod", 238, 232, 170,n!       "PaleGreen", 152, 251, 152,d"       "PaleGreen1", 154, 255, 154,"       "PaleGreen2", 144, 238, 144,"       "PaleGreen3", 124, 205, 124,        "PaleGreen4", 84, 139, 84,%       "PaleTurquoise", 175, 238, 238,=&       "PaleTurquoise1", 187, 255, 255,&       "PaleTurquoise2", 174, 238, 238,&       "PaleTurquoise3", 150, 205, 205,&       "PaleTurquoise4", 102, 139, 139,%       "PaleVioletRed", 219, 112, 147,>&       "PaleVioletRed1", 255, 130, 171,&       "PaleVioletRed2", 238, 121, 159,&       "PaleVioletRed3", 205, 104, 137,$       "PaleVioletRed4", 139, 71, 93,"       "PapayaWhip", 255, 239, 213,!       "PeachPuff", 255, 218, 185,%"       "PeachPuff1", 255, 218, 185,"       "PeachPuff2", 238, 203, 173,"       "PeachPuff3", 205, 175, 149,"       "PeachPuff4", 139, 119, 101,"       "PowderBlue", 176, 224, 230,!       "RosyBrown", 188, 143, 143, "       "RosyBrown1", 255, 193, 193,"       "RosyBrown2", 238, 180, 180,"       "RosyBrown3", 205, 155, 155,"       "RosyBrown4", 139, 105, 105,        "RoyalBlue", 65, 105, 225,!       "RoyalBlue1", 72, 118, 255, !       "RoyalBlue2", 67, 110, 238,         "RoyalBlue3", 58, 95, 205,        "RoyalBlue4", 39, 64, 139,!       "SaddleBrown", 139, 69, 19, !       "SandyBrown", 244, 164, 96,        "SeaGreen", 46, 139, 87,        "SeaGreen1", 84, 255, 159,        "SeaGreen2", 78, 238, 148,        "SeaGreen3", 67, 205, 128,       "SeaGreen4", 46, 139, 87,        "SkyBlue", 135, 206, 235,n        "SkyBlue1", 135, 206, 255,        "SkyBlue2", 126, 192, 238,        "SkyBlue3", 108, 166, 205,       "SkyBlue4", 74, 112, 139,i        "SlateBlue", 106, 90, 205,"       "SlateBlue1", 131, 111, 255,"       "SlateBlue2", 122, 103, 238,!       "SlateBlue3", 105, 89, 205,         "SlateBlue4", 71, 60, 139,!       "SlateGray", 112, 128, 144,w"       "SlateGray1", 198, 226, 255,"       "SlateGray2", 185, 211, 238,"       "SlateGray3", 159, 182, 205,"       "SlateGray4", 108, 123, 139,!       "SlateGrey", 112, 128, 144,n!       "SpringGreen", 0, 255, 127,e"       "SpringGreen1", 0, 255, 127,"       "SpringGreen2", 0, 238, 118,"       "SpringGreen3", 0, 205, 102,!       "SpringGreen4", 0, 139, 69,         "SteelBlue", 70, 130, 180,!       "SteelBlue1", 99, 184, 255,(!       "SteelBlue2", 92, 172, 238,h!       "SteelBlue3", 79, 148, 205,o!       "SteelBlue4", 54, 100, 139,n        "VioletRed", 208, 32, 144,!       "VioletRed1", 255, 62, 150,%!       "VioletRed2", 238, 58, 140, !       "VioletRed3", 205, 50, 120,         "VioletRed4", 139, 34, 82,"       "WhiteSmoke", 245, 245, 245,"       "YellowGreen", 154, 205, 50,"       "alice blue", 240, 248, 255,%       "antique white", 250, 235, 215, "       "aquamarine", 127, 255, 212,#       "aquamarine1", 127, 255, 212, #       "aquamarine2", 118, 238, 198, #       "aquamarine3", 102, 205, 170, "       "aquamarine4", 69, 139, 116,       "azure", 240, 255, 255,        "azure1", 240, 255, 255,       "azure2", 224, 238, 238,       "azure3", 193, 205, 205,       "azure4", 131, 139, 139,       "beige", 245, 245, 220,%       "bisque", 255, 228, 196,       "bisque1", 255, 228, 196,F       "bisque2", 238, 213, 183,o       "bisque3", 205, 183, 158,i       "bisque4", 139, 125, 107,a       "black", 0, 0, 0,e'       "blanched almond", 255, 235, 205,X       "blue", 0, 0, 255,"       "blue violet", 138, 43, 226,       "blue1", 0, 0, 255,        "blue2", 0, 0, 238,T       "blue3", 0, 0, 205,        "blue4", 0, 0, 139,;       "brown", 165, 42, 42,i       "brown1", 255, 64, 64,       "brown2", 238, 59, 59,       "brown3", 205, 51, 51,       "brown4", 139, 35, 35,!       "burlywood", 222, 184, 135,g"       "burlywood1", 255, 211, 155,"       "burlywood2", 238, 197, 145,"       "burlywood3", 205, 170, 125,!       "burlywood4", 139, 115, 85,d!       "cadet blue", 95, 158, 160,n        "chartreuse", 127, 255, 0,!       "chartreuse1", 127, 255, 0,i!       "chartreuse2", 118, 238, 0, !       "chartreuse3", 102, 205, 0,;        "chartreuse4", 69, 139, 0,        "chocolate", 210, 105, 30,!       "chocolate1", 255, 127, 36,e!       "chocolate2", 238, 118, 33,g!       "chocolate3", 205, 102, 29,o        "chocolate4", 139, 69, 19,       "coral", 255, 127, 80,       "coral1", 255, 114, 86,e       "coral2", 238, 106, 80,        "coral3", 205, 91, 69,       "coral4", 139, 62, 47,'       "cornflower blue", 100, 149, 237,%        "cornsilk", 255, 248, 220,!       "cornsilk1", 255, 248, 220, !       "cornsilk2", 238, 232, 205, !       "cornsilk3", 205, 200, 177, !       "cornsilk4", 139, 136, 120,        "cyan", 0, 255, 255,       "cyan1", 0, 255, 255,        "cyan2", 0, 238, 238,        "cyan3", 0, 205, 205,        "cyan4", 0, 139, 139,        "dark blue", 0, 0, 139,        "dark cyan", 0, 139, 139, %       "dark goldenrod", 184, 134, 11, !       "dark gray", 169, 169, 169,        "dark green", 0, 100, 0,!       "dark grey", 169, 169, 169, "       "dark khaki", 189, 183, 107,"       "dark magenta", 139, 0, 139,&       "dark olive green", 85, 107, 47,!       "dark orange", 255, 140, 0,%"       "dark orchid", 153, 50, 204,       "dark red", 139, 0, 0,#       "dark salmon", 233, 150, 122,*&       "dark sea green", 143, 188, 143,%       "dark slate blue", 72, 61, 139,w$       "dark slate gray", 47, 79, 79,$       "dark slate grey", 47, 79, 79,$       "dark turquoise", 0, 206, 209,!       "dark violet", 148, 0, 211,n        "deep pink", 255, 20, 147,#       "deep sky blue", 0, 191, 255,e        "dim gray", 105, 105, 105,        "dim grey", 105, 105, 105,"       "dodger blue", 30, 144, 255,       "firebrick", 178, 34, 34,t        "firebrick1", 255, 48, 48,        "firebrick2", 238, 44, 44,        "firebrick3", 205, 38, 38,        "firebrick4", 139, 26, 26,$       "floral white", 255, 250, 240,"       "forest green", 34, 139, 34,!       "gainsboro", 220, 220, 220,u#       "ghost white", 248, 248, 255,m       "gold", 255, 215, 0,       "gold1", 255, 215, 0,l       "gold2", 238, 201, 0,        "gold3", 205, 173, 0,r       "gold4", 139, 117, 0,r        "goldenrod", 218, 165, 32,!       "goldenrod1", 255, 193, 37, !       "goldenrod2", 238, 180, 34,p!       "goldenrod3", 205, 155, 29,r!       "goldenrod4", 139, 105, 20,        "gray", 190, 190, 190,       "gray0", 0, 0, 0,x       "gray1", 3, 3, 3,x       "gray10", 26, 26, 26,x       "gray100", 255, 255, 255,        "gray11", 28, 28, 28,1       "gray12", 31, 31, 31,2       "gray13", 33, 33, 33,x       "gray14", 36, 36, 36,x       "gray15", 38, 38, 38,        "gray16", 41, 41, 41,        "gray17", 43, 43, 43,c       "gray18", 46, 46, 46,k       "gray19", 48, 48, 48,0       "gray2", 5, 5, 5,        "gray20", 51, 51, 51,        "gray21", 54, 54, 54,6       "gray22", 56, 56, 56,f       "gray23", 59, 59, 59,x       "gray24", 61, 61, 61,x       "gray25", 64, 64, 64,x       "gray26", 66, 66, 66,        "gray27", 69, 69, 69,        "gray28", 71, 71, 71,0       "gray29", 74, 74, 74,7       "gray3", 8, 8, 8,r       "gray30", 77, 77, 77,        "gray31", 79, 79, 79,C       "gray32", 82, 82, 82,o       "gray33", 84, 84, 84,e       "gray34", 87, 87, 87,,       "gray35", 89, 89, 89,t       "gray36", 92, 92, 92,k       "gray37", 94, 94, 94,y       "gray38", 97, 97, 97,i       "gray39", 99, 99, 99,e       "gray4", 10, 10, 10,       "gray40", 102, 102, 102,       "gray41", 105, 105, 105,       "gray42", 107, 107, 107,       "gray43", 110, 110, 110,       "gray44", 112, 112, 112,       "gray45", 115, 115, 115,       "gray46", 117, 117, 117,       "gray47", 120, 120, 120,       "gray48", 122, 122, 122,       "gray49", 125, 125, 125,       "gray5", 13, 13, 13,       "gray50", 127, 127, 127,       "gray51", 130, 130, 130,       "gray52", 133, 133, 133,       "gray53", 135, 135, 135,       "gray54", 138, 138, 138,       "gray55", 140, 140, 140,       "gray56", 143, 143, 143,       "gray57", 145, 145, 145,       "gray58", 148, 148, 148,       "gray59", 150, 150, 150,       "gray6", 15, 15, 15,       "gray60", 153, 153, 153,       "gray61", 156, 156, 156,       "gray62", 158, 158, 158,       "gray63", 161, 161, 161,       "gray64", 163, 163, 163,       "gray65", 166, 166, 166,       "gray66", 168, 168, 168,       "gray67", 171, 171, 171,       "gray68", 173, 173, 173,       "gray69", 176, 176, 176,       "gray7", 18, 18, 18,       "gray70", 179, 179, 179,       "gray71", 181, 181, 181,       "gray72", 184, 184, 184,       "gray73", 186, 186, 186,       "gray74", 189, 189, 189,       "gray75", 191, 191, 191,       "gray76", 194, 194, 194,       "gray77", 196, 196, 196,       "gray78", 199, 199, 199,       "gray79", 201, 201, 201,       "gray8", 20, 20, 20,       "gray80", 204, 204, 204,       "gray81", 207, 207, 207,       "gray82", 209, 209, 209,       "gray83", 212, 212, 212,       "gray84", 214, 214, 214,       "gray85", 217, 217, 217,       "gray86", 219, 219, 219,       "gray87", 222, 222, 222,       "gray88", 224, 224, 224,       "gray89", 227, 227, 227,       "gray9", 23, 23, 23,       "gray90", 229, 229, 229,       "gray91", 232, 232, 232,       "gray92", 235, 235, 235,       "gray93", 237, 237, 237,       "gray94", 240, 240, 240,       "gray95", 242, 242, 242,       "gray96", 245, 245, 245,       "gray97", 247, 247, 247,       "gray98", 250, 250, 250,       "gray99", 252, 252, 252,       "green", 0, 255, 0,e#       "green yellow", 173, 255, 47,c       "green1", 0, 255, 0,       "green2", 0, 238, 0,       "green3", 0, 205, 0,       "green4", 0, 139, 0,       "grey", 190, 190, 190,       "grey0", 0, 0, 0,r       "grey1", 3, 3, 3,I       "grey10", 26, 26, 26,        "grey100", 255, 255, 255,,       "grey11", 28, 28, 28,        "grey12", 31, 31, 31,n       "grey13", 33, 33, 33,        "grey14", 36, 36, 36,e       "grey15", 38, 38, 38,e       "grey16", 41, 41, 41,n       "grey17", 43, 43, 43,h       "grey18", 46, 46, 46,e       "grey19", 48, 48, 48,N       "grey2", 5, 5, 5,        "grey20", 51, 51, 51,m       "grey21", 54, 54, 54,f       "grey22", 56, 56, 56,w       "grey23", 59, 59, 59,h       "grey24", 61, 61, 61,g       "grey25", 64, 64, 64,g       "grey26", 66, 66, 66,        "grey27", 69, 69, 69,        "grey28", 71, 71, 71,        "grey29", 74, 74, 74,        "grey3", 8, 8, 8,        "grey30", 77, 77, 77,i       "grey31", 79, 79, 79,o       "grey32", 82, 82, 82,o       "grey33", 84, 84, 84,t       "grey34", 87, 87, 87,o       "grey35", 89, 89, 89,m       "grey36", 92, 92, 92,g       "grey37", 94, 94, 94,r       "grey38", 97, 97, 97,        "grey39", 99, 99, 99,        "grey4", 10, 10, 10,       "grey40", 102, 102, 102,       "grey41", 105, 105, 105,       "grey42", 107, 107, 107,       "grey43", 110, 110, 110,       "grey44", 112, 112, 112,       "grey45", 115, 115, 115,       "grey46", 117, 117, 117,       "grey47", 120, 120, 120,       "grey48", 122, 122, 122,       "grey49", 125, 125, 125,       "grey5", 13, 13, 13,       "grey50", 127, 127, 127,       "grey51", 130, 130, 130,       "grey52", 133, 133, 133,       "grey53", 135, 135, 135,       "grey54", 138, 138, 138,       "grey55", 140, 140, 140,       "grey56", 143, 143, 143,       "grey57", 145, 145, 145,       "grey58", 148, 148, 148,       "grey59", 150, 150, 150,       "grey6", 15, 15, 15,       "grey60", 153, 153, 153,       "grey61", 156, 156, 156,       "grey62", 158, 158, 158,       "grey63", 161, 161, 161,       "grey64", 163, 163, 163,       "grey65", 166, 166, 166,       "grey66", 168, 168, 168,       "grey67", 171, 171, 171,       "grey68", 173, 173, 173,       "grey69", 176, 176, 176,       "grey7", 18, 18, 18,       "grey70", 179, 179, 179,       "grey71", 181, 181, 181,       "grey72", 184, 184, 184,       "grey73", 186, 186, 186,       "grey74", 189, 189, 189,       "grey75", 191, 191, 191,       "grey76", 194, 194, 194,       "grey77", 196, 196, 196,       "grey78", 199, 199, 199,       "grey79", 201, 201, 201,       "grey8", 20, 20, 20,       "grey80", 204, 204, 204,       "grey81", 207, 207, 207,       "grey82", 209, 209, 209,       "grey83", 212, 212, 212,       "grey84", 214, 214, 214,       "grey85", 217, 217, 217,       "grey86", 219, 219, 219,       "grey87", 222, 222, 222,       "grey88", 224, 224, 224,       "grey89", 227, 227, 227,       "grey9", 23, 23, 23,       "grey90", 229, 229, 229,       "grey91", 232, 232, 232,       "grey92", 235, 235, 235,       "grey93", 237, 237, 237,       "grey94", 240, 240, 240,       "grey95", 242, 242, 242,       "grey96", 245, 245, 245,       "grey97", 247, 247, 247,       "grey98", 250, 250, 250,       "grey99", 252, 252, 252,        "honeydew", 240, 255, 240,!       "honeydew1", 240, 255, 240,s!       "honeydew2", 224, 238, 224,s!       "honeydew3", 193, 205, 193, !       "honeydew4", 131, 139, 131,o        "hot pink", 255, 105, 180,        "indian red", 205, 92, 92,       "ivory", 255, 255, 240,n       "ivory1", 255, 255, 240,       "ivory2", 238, 238, 224,       "ivory3", 205, 205, 193,       "ivory4", 139, 139, 131,       "khaki", 240, 230, 140,        "khaki1", 255, 246, 143,       "khaki2", 238, 230, 133,       "khaki3", 205, 198, 115,       "khaki4", 139, 134, 78,         "lavender", 230, 230, 250,&       "lavender blush", 255, 240, 245,        "lawn green", 124, 252, 0,%       "lemon chiffon", 255, 250, 205, "       "light blue", 173, 216, 230,#       "light coral", 240, 128, 128, "       "light cyan", 224, 255, 255,'       "light goldenrod", 238, 221, 130,e.       "light goldenrod yellow", 250, 250, 210,"       "light gray", 211, 211, 211,#       "light green", 144, 238, 144,r"       "light grey", 211, 211, 211,"       "light pink", 255, 182, 193,$       "light salmon", 255, 160, 122,&       "light sea green", 32, 178, 170,&       "light sky blue", 135, 206, 250,(       "light slate blue", 132, 112, 255,(       "light slate gray", 119, 136, 153,(       "light slate grey", 119, 136, 153,(       "light steel blue", 176, 196, 222,$       "light yellow", 255, 255, 224,        "lime green", 50, 205, 50,       "linen", 250, 240, 230,=       "magenta", 255, 0, 255,        "magenta1", 255, 0, 255,       "magenta2", 238, 0, 238,       "magenta3", 205, 0, 205,       "magenta4", 139, 0, 139,       "maroon", 176, 48, 96,       "maroon1", 255, 52, 179,       "maroon2", 238, 48, 167,       "maroon3", 205, 41, 144,       "maroon4", 139, 28, 98,A)       "medium aquamarine", 102, 205, 170,>       "medium blue", 0, 0, 205, $       "medium orchid", 186, 85, 211,%       "medium purple", 147, 112, 219,>'       "medium sea green", 60, 179, 113,n)       "medium slate blue", 123, 104, 238,d)       "medium spring green", 0, 250, 154,e'       "medium turquoise", 72, 209, 204, (       "medium violet red", 199, 21, 133,#       "midnight blue", 25, 25, 112, "       "mint cream", 245, 255, 250,"       "misty rose", 255, 228, 225,        "moccasin", 255, 228, 181,$       "navajo white", 255, 222, 173,       "navy", 0, 0, 128,       "navy blue", 0, 0, 128,s        "old lace", 253, 245, 230,!       "olive drab", 107, 142, 35,)       "orange", 255, 165, 0,       "orange red", 255, 69, 0,        "orange1", 255, 165, 0,d       "orange2", 238, 154, 0,)       "orange3", 205, 133, 0,t       "orange4", 139, 90, 0,       "orchid", 218, 112, 214,       "orchid1", 255, 131, 250,\       "orchid2", 238, 122, 233,)       "orchid3", 205, 105, 201,\       "orchid4", 139, 71, 137,&       "pale goldenrod", 238, 232, 170,"       "pale green", 152, 251, 152,&       "pale turquoise", 175, 238, 238,'       "pale violet red", 219, 112, 147,f#       "papaya whip", 255, 239, 213,>"       "peach puff", 255, 218, 185,       "peru", 205, 133, 63,m       "pink", 255, 192, 203,       "pink1", 255, 181, 197,e       "pink2", 238, 169, 184,_       "pink3", 205, 145, 158,s       "pink4", 139, 99, 108,       "plum", 221, 160, 221,       "plum1", 255, 187, 255,e       "plum2", 238, 174, 238,        "plum3", 205, 150, 205,e       "plum4", 139, 102, 139,h#       "powder blue", 176, 224, 230,r       "purple", 160, 32, 240,F       "purple1", 155, 48, 255,       "purple2", 145, 44, 238,       "purple3", 125, 38, 205,       "purple4", 85, 26, 139,a       "red", 255, 0, 0,w       "red1", 255, 0, 0,       "red2", 238, 0, 0,       "red3", 205, 0, 0,       "red4", 139, 0, 0,"       "rosy brown", 188, 143, 143,!       "royal blue", 65, 105, 225, "       "saddle brown", 139, 69, 19,       "salmon", 250, 128, 114,       "salmon1", 255, 140, 105,i       "salmon2", 238, 130, 98,       "salmon3", 205, 112, 84,       "salmon4", 139, 76, 57,*"       "sandy brown", 244, 164, 96,       "sea green", 46, 139, 87,         "seashell", 255, 245, 238,!       "seashell1", 255, 245, 238, !       "seashell2", 238, 229, 222, !       "seashell3", 205, 197, 191,.!       "seashell4", 139, 134, 130,m       "sienna", 160, 82, 45,       "sienna1", 255, 130, 71,       "sienna2", 238, 121, 66,       "sienna3", 205, 104, 57,       "sienna4", 139, 71, 38,n        "sky blue", 135, 206, 235,!       "slate blue", 106, 90, 205,i"       "slate gray", 112, 128, 144,"       "slate grey", 112, 128, 144,       "snow", 255, 250, 250,       "snow1", 255, 250, 250,        "snow2", 238, 233, 233,;       "snow3", 205, 201, 201,n       "snow4", 139, 137, 137,;"       "spring green", 0, 255, 127,!       "steel blue", 70, 130, 180,d       "tan", 210, 180, 140,H       "tan1", 255, 165, 79,m       "tan2", 238, 154, 73,n       "tan3", 205, 133, 63,a       "tan4", 139, 90, 43,       "thistle", 216, 191, 216,_        "thistle1", 255, 225, 255,        "thistle2", 238, 210, 238,        "thistle3", 205, 181, 205,        "thistle4", 139, 123, 139,       "tomato", 255, 99, 71,       "tomato1", 255, 99, 71,        "tomato2", 238, 92, 66,,       "tomato3", 205, 79, 57,        "tomato4", 139, 54, 38,g        "turquoise", 64, 224, 208,        "turquoise1", 0, 245, 255,        "turquoise2", 0, 229, 238,        "turquoise3", 0, 197, 205,        "turquoise4", 0, 134, 139,       "violet", 238, 130, 238,!       "violet red", 208, 32, 144,a       "wheat", 245, 222, 179,        "wheat1", 255, 231, 186,       "wheat2", 238, 216, 174,       "wheat3", 205, 186, 150,       "wheat4", 139, 126, 102,       "white", 255, 255, 255, #       "white smoke", 245, 245, 245,-       "yellow", 255, 255, 0,#       "yellow green", 154, 205, 50,        "yellow1", 255, 255, 0,D       "yellow2", 238, 238, 0,        "yellow3", 205, 205, 0,        "yellow4", 139, 139, 0,        (char *) NULL, 0, 0, 0     };     char     colorname[MaxTextLength],y     text[MaxTextLength];  
   Colormap
     colormap;t  	   Displayi
     *display;l     FILE     *database;     intn	     blue,s
     count,
     green,     red,     status;r     register XColorList      *p;e     /*"     Initialize color return value.   */   color->red=0;    color->green=0;r   color->blue=0;(   color->flags=DoRed | DoGreen | DoBlue;   if (target == (char *) NULL)     target=BackgroundColor;n   if (*target == '#')i     { 
       char
         c;         register int
         i,
         n;         /*          Parse RGB specification.       */       target++;_       n=strlen(target);_8       if ((n != 3) && (n != 6) && (n != 9) && (n != 12))         return(False);       n/=3;        green=0;
       blue=0;/       do       {t         red=green;         green=blue;,         blue=0;           for (i=n-1; i >= 0; i--)	         {L           c=(*target++);           blue<<=4;i'           if ((c >= '0') && (c <= '9'))              blue|=c-'0';           else)             if ((c >= 'A') && (c <= 'F'))p               blue|=c-('A'-10);x             else+               if ((c >= 'a') && (c <= 'f')) !                 blue|=c-('a'-10);C               else                 return(False);
          }        } while (*target != '\0');       n<<=2;
       n=16-n;a       color->red=red << n;       color->green=green << n;       color->blue=blue << n;       return(True);,     }s'   database=fopen(RGBColorDatabase,"r");s    if (database != (FILE *) NULL)     {t       /*1         Match color against the X color database.n       */C       while (fgets(text,MaxTextLength-1,database) != (char *) NULL)m       {aK         count=sscanf(text,"%d %d %d %[^\n]\n",&red,&green,&blue,colorname);          if (count != 4)i           continue;o1         if (Latin1Compare(colorname,target) == 0)%           {%              color->red=red << 8;$             color->green=green << 8;"             color->blue=blue << 8;             return(True);            }        }        (void) fclose(database);     }    /*'     Search our internal color database.    */2   for (p=colorlist; p->name != (char *) NULL; p++)+     if (Latin1Compare(p->name,target) == 0)        {          color->red=p->red << 8; #         color->green=p->green << 8; !         color->blue=p->blue << 8;          return(True);        }    /*-     Let the X server define the color for us.    */&   display=XOpenDisplay((char *) NULL);"   if (display == (Display *) NULL)     {%7       Warning("Color is not known to X server",target);S       return(False);     }S=   colormap=XDefaultColormap(display,XDefaultScreen(display));a4   status=XParseColor(display,colormap,target,color);   if (status == False)5     Warning("Color is not known to X server",target);n   XCloseDisplay(display);    return(status != 0); }d r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %,O %                                                                             %cO %                                                                             %:O %   X Q u e r y P o s i t i o n                                               %oO %                                                                             %:O %                                                                             % O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %mL %  Function XQueryPosition gets the pointer coodinates relative to a window. %w/ %  The format of the XQueryPosition routine is:, % ' %    XQueryPosition(display,window,x,y), % + %  A description of each parameter follows:  %pE %    o display: Specifies a connection to an X server;  returned fromi %      XOpenDisplay. %i/ %    o window: Specifies a pointer to a Window.n %nN %    o x: Return the x coordinate of the pointer relative to the origin of the %      window. %lN %    o y: Return the y coordinate of the pointer relative to the origin of the %      window. %n %- */' void XQueryPosition(display,window,x,y)= Display    *display;e   Window	   window;f   inte   *x,t   *y;i {p   int      x_root,i     y_root;      unsigned int	     mask;      Window     root_window;  P   (void) XQueryPointer(display,window,&root_window,&root_window,&x_root,&y_root,     x,y,&mask);/ }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %iO %                                                                             %eO %                                                                             %tO %   X R e f r e s h W i n d o w                                               %mO %                                                                             % O %                                                                             %yO %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %i< %  Function XRefreshWindow refreshes an image in a X window. % / %  The format of the XRefreshWindow routine is:  % + %      XRefreshWindow(display,window,event)x %c+ %  A description of each parameter follows:( % E %    o display: Specifies a connection to an X server;  returned from_ %      XOpenDisplay. %;> %    o window: Specifies a pointer to a XWindowInfo structure. % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.s %r %x */) void XRefreshWindow(display,window,event)  Displaye   *display;e   XWindowInfo 
   *window;   XEvent	   *event;  {    intv     x,     y;     unsigned int     height,/
     width;     if (event != (XEvent *) NULL)      {p       /*-         Determine geometry from expose event.n       */       x=event->xexpose.x;        y=event->xexpose.y; !       width=event->xexpose.width;h#       height=event->xexpose.height;      }    else     {        XEvent         sans_event;(         /*A         Refresh entire window; discard outstanding expose events.        */
       x=0;
       y=0;       width=window->width;       height=window->height;L       while (XCheckTypedWindowEvent(display,window->id,Expose,&sans_event));     }    /*     Check boundary conditions.   */4   if ((window->ximage->width-(x+window->x)) < width).     width=window->ximage->width-(x+window->x);6   if ((window->ximage->height-(y+window->y)) < height)0     height=window->ximage->height-(y+window->y);   /*     Refresh image.   */F   XSetClipMask(display,window->annotate_context,window->matte_pixmap);&   if (window->pixmap != (Pixmap) NULL)     {        if (window->depth > 1)M         XCopyArea(display,window->pixmap,window->id,window->annotate_context,;4           x+window->x,y+window->y,width,height,x,y);
       elseO         XCopyPlane(display,window->pixmap,window->id,window->highlight_context,r7           x+window->x,y+window->y,width,height,x,y,1L);      }r   else     {  #ifdef HasSharedMemory        if (window->shared_memory)	         {lC           XShmPutImage(display,window->id,window->annotate_context, J             window->ximage,x+window->x,y+window->y,x,y,width,height,True);           XSync(display,False);0	         }t #endif!       if (!window->shared_memory) M         XPutImage(display,window->id,window->annotate_context,window->ximage, 4           x+window->x,y+window->y,x,y,width,height);     } 6   XSetClipMask(display,window->annotate_context,None); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             % O %                                                                             % O %   X R e t a i n W i n d o w C o l o r s                                     % O %                                                                             % O %                                                                             %bO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %)K %  Function XRetainWindowColors sets X11 color resources on a window.  ThiseI %  perserves the colors associated with an image displayed on the window.o %j4 %  The format of the XRetainWindowColors routine is: % * %      XRetainWindowColors(display,window) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % > %    o window: Specifies a pointer to a XWindowInfo structure. %  %  */( void XRetainWindowColors(display,window) Displayr   *display;    Window	   window;e {t   Atom
     property;      Pixmap     pixmap;      /*     Put property on the window.n   */5   property=XInternAtom(display,"_XSETROOT_ID",False);v   if (property == (Atom) NULL)     {V<       Warning("Unable to create X property","_XSETROOT_ID");
       return;      } -   pixmap=XCreatePixmap(display,window,1,1,1);    if (pixmap == (Pixmap) NULL)     { 9       Warning("Unable to create X pixmap",(char *) NULL);c
       return;      }[G   XChangeProperty(display,window,property,XA_PIXMAP,32,PropModeReplace, !     (unsigned char *) &pixmap,1);n-   XSetCloseDownMode(display,RetainPermanent);k }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %;O %                                                                             %iO %   X S e l e c t W i n d o w                                                 %rO %                                                                             %iO %                                                                             % O %                                                                             %xO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %(O %  Function XSelectWindow allows a user to select a window using the mouse.  If H %  the mouse moves, a cropping rectangle is drawn and the extents of the4 %  rectangle is returned in the crop_info structure. % / %  The format of the XSelectWindow function is:  % 5 %      target_window=XSelectWindow(display,crop_info)q %u+ %  A description of each parameter follows:  %i3 %    o window: XSelectWindow returns the window id.0 % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o crop_info: Specifies a pointer to a RectangleInfo structure.  It 6 %      contains the extents of any cropping rectangle. %  %= */' Window XSelectWindow(display,crop_info)  Display    *display;   
 RectangleInfo 
   *crop_info;  {a) #define MinimumCropArea  (unsigned int) 9      Cursor     target_cursor;     GC     annotate_context;      int      presses,     status, 
     x_offset, 
     y_offset;      Window     root_window,     target_window;     XEvent
     event;     XGCValues      context_values;      /*     Initialize graphic context.    */;   root_window=XRootWindow(display,XDefaultScreen(display)); I   context_values.background=XBlackPixel(display,XDefaultScreen(display));.I   context_values.foreground=XWhitePixel(display,XDefaultScreen(display));s#   context_values.function=GXinvert;e   context_values.plane_mask=:     context_values.background ^ context_values.foreground;1   context_values.subwindow_mode=IncludeInferiors; N   annotate_context=XCreateGC(display,root_window,GCBackground | GCForeground |@     GCFunction | GCPlaneMask | GCSubwindowMode,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*)     Grab the pointer using target cursor.    */0   target_cursor=XMakeCursor(display,root_window,G     XDefaultColormap(display,XDefaultScreen(display)),"white","black"); >   status=XGrabPointer(display,root_window,False,(unsigned int)J     (ButtonPressMask | ButtonReleaseMask | ButtonMotionMask),GrabModeSync,9     GrabModeAsync,root_window,target_cursor,CurrentTime);    if (status != GrabSuccess)4     Error("Unable to grab the mouse",(char *) NULL);   /*     Select a window.   */   crop_info->width=0;    crop_info->height=0;   presses=0;   target_window=(Window) NULL;
   x_offset=0;o
   y_offset=0;.   do   { @     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x, =         crop_info->y,crop_info->width-1,crop_info->height-1);-     /*       Allow another event.     */2     XAllowEvents(display,SyncPointer,CurrentTime);J     XWindowEvent(display,root_window,ButtonPressMask | ButtonReleaseMask |       ButtonMotionMask,&event); @     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x, =         crop_info->y,crop_info->width-1,crop_info->height-1);,     switch (event.type)      {        case ButtonPress:        { D         target_window=XGetSubwindow(display,event.xbutton.subwindow,+           event.xbutton.x,event.xbutton.y);&+         if (target_window == (Window) NULL) $           target_window=root_window;&         x_offset=event.xbutton.x_root;&         y_offset=event.xbutton.y_root;         crop_info->x=x_offset;         crop_info->y=y_offset;         crop_info->width=0;          crop_info->height=0;         presses++;         break;       }        case ButtonRelease:j       {(         presses--;         break;       }        case MotionNotify:       {l
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));r%         crop_info->x=event.xmotion.x; %         crop_info->y=event.xmotion.y; 
         /*$           Check boundary conditions.
         */$         if (crop_info->x < x_offset)B           crop_info->width=(unsigned int) (x_offset-crop_info->x);         else           {1D             crop_info->width=(unsigned int) (crop_info->x-x_offset);"             crop_info->x=x_offset;           } $         if (crop_info->y < y_offset)C           crop_info->height=(unsigned int) (y_offset-crop_info->y);o         else           { E             crop_info->height=(unsigned int) (crop_info->y-y_offset);n"             crop_info->y=y_offset;           }        }D       default:         break;     }    }D<   while ((target_window == (Window) NULL) || (presses > 0));&   XUngrabPointer(display,CurrentTime);%   XFreeCursor(display,target_cursor);;$   XFreeGC(display,annotate_context);=   if ((crop_info->width*crop_info->height) < MinimumCropArea)i     {        crop_info->width=0;        crop_info->height=0;     } :   if ((crop_info->width != 0) && (crop_info->height != 0))     target_window=root_window;   return(target_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t C u r s o r S t a t e                                             %nO %                                                                             % O %                                                                             % O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XSetCursorState sets the  cursor state to busy, otherwise the+% %  cursor are reset to their default.d % 1 %  The format of the XXSetCursorState routine is:  % - %      XSetCursorState(display,windows,state)  % + %  A description of each parameter follows:  %LE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %>< %    o windows: Specifies a pointer to a XWindows structure. %pF %    o state: An unsigned integer greater than 0 sets the cursor state@ %      to busy, otherwise the cursor are reset to their default. %g %p */+ void XSetCursorState(display,windows,state)i Displayn   *display;    XWindows   *windows;>   unsigned int   state; {=   if (state)     { J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);F       XDefineCursor(display,windows->pan.id,windows->pan.busy_cursor);N       XDefineCursor(display,windows->magnify.id,windows->magnify.busy_cursor);N       XDefineCursor(display,windows->command.id,windows->command.busy_cursor);     }    else     { E       XDefineCursor(display,windows->image.id,windows->image.cursor); A       XDefineCursor(display,windows->pan.id,windows->pan.cursor); I       XDefineCursor(display,windows->magnify.id,windows->magnify.cursor);rI       XDefineCursor(display,windows->command.id,windows->command.cursor);%H       XDefineCursor(display,windows->command.id,windows->widget.cursor);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X V i s u a l C l a s s N a m e                                           % O %                                                                             % O %                                                                             %%O %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % I %  Function XVisualClassName returns the visual class name as a characterw
 %  string. %c1 %  The format of the XVisualClassName routine is:e %p* %      visual_type=XVisualClassName(class) %f+ %  A description of each parameter follows:  %XL %    o visual_type: XVisualClassName returns the visual class as a character %      string. %r) %    o class: Specifies the visual class.  %c %e */ char *XVisualClassName(class)s intu   class; {    switch (class)   {p*     case StaticGray: return("StaticGray");(     case GrayScale: return("GrayScale");,     case StaticColor: return("StaticColor");,     case PseudoColor: return("PseudoColor");(     case TrueColor: return("TrueColor");,     case DirectColor: return("DirectColor");   }n!   return("unknown visual class");d }o   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,O %                                                                             % O %                                                                             %iO %                                                                             %iO %   X W i n d o w B y I D                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eN %  Function XWindowByID locates a child window with a given ID.  If not windowK %  with the given name is found, 0 is returned.   Only the window specified # %  and its subwindows are searched.  % - %  The format of the XWindowByID function is:/ % + %      child=XWindowByID(display,window,id)> %e+ %  A description of each parameter follows:i %_? %    o child: XWindowByID returns the window with the specifieds; %      id.  If no windows are found, XWindowByID returns 0.t %iL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %t4 %    o id: Specifies the id of the window to locate. %a %  */* Window XWindowByID(display,root_window,id) Display    *display;=   Window   root_window;  
 unsigned long    id;e {1   RectangleInfo(     rectangle_info;U     register int     i;     unsigned int     number_children;     Window
     child,     *children,     window;=     if (id == 0)3     return(XSelectWindow(display,&rectangle_info));    if (root_window == id)     return(id); P   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL; %   for (i=0; i < number_children; i++)    {      /*+       Search each child and their children.l     *//     window=XWindowByID(display,children[i],id);       if (window != (Window) NULL)       break;   } "   if (children != (Window *) NULL)     XFree((void *) children);!   return(window);( }a > /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %pO %                                                                             %pO %                                                                             % O %   X W i n d o w B y N a m e                                                 %iO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%> % J %  Function XWindowByName locates a window with a given name on a display.I %  If no window with the given name is found, 0 is returned. If more than K %  one window has the given name, the first one is returned.  Only root and  %  its children are searched.  % / %  The format of the XWindowByName function is:  % 5 %      window=XWindowByName(display,root_window,name)  % + %  A description of each parameter follows:  % 3 %    o window: XWindowByName returns the window id.d % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %n8 %    o root_window: Specifies the id of the root window. % 8 %    o name: Specifies the name of the window to locate. %  %  */. Window XWindowByName(display,root_window,name) Display    *display;    Window   root_window;   char   *name; {    register int     i;     unsigned int     number_children;     Window     *children,
     child,     window;i     XTextProperty]     window_name;  8   if (XGetWMName(display,root_window,&window_name) != 0)5     if (strcmp((char *) window_name.value,name) == 0)        return(root_window);P   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL; %   for (i=0; i < number_children; i++)    {      /*+       Search each child and their children.      */3     window=XWindowByName(display,children[i],name);       if (window != (Window) NULL)       break;   } "   if (children != (Window *) NULL)     XFree((void *) children);    return(window);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %vO %                                                                             %rO %                                                                             %rO %   X W i n d o w B y P r o p e r y                                           %iO %                                                                             %gO %                                                                             % O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XWindowByProperty locates a child window with a given property. J %  If no window with the given name is found, 0 is returned.  If more thanJ %  one window has the given property, the first one is returned.  Only the4 %  window specified and its subwindows are searched. % 3 %  The format of the XWindowByProperty function is:  % 7 %      child=XWindowByProperty(display,window,property)  % + %  A description of each parameter follows:  % H %    o child: XWindowByProperty returns the window id with the specifiedG %      property.  If no windows are found, XWindowByProperty returns 0.> %eL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %i@ %    o property: Specifies the property of the window to locate. %  %  */8 static Window XWindowByProperty(display,window,property) Displayo   *display;y   Window	   window;    Atom   property;c {n   Atom	     type;      int      format,f     status;-     unsigned char 
     *data;     unsigned int     i,     number_children;     unsigned long 
     after,     number_items;      Window
     child,     *children,     parent, 	     root;   M   status=XQueryTree(display,window,&root,&parent,&children,&number_children);    if (status == 0)     return((Window) NULL);   type=(Atom) NULL;    child=(Window) NULL;C   for (i=0; (i < number_children) && (child == (Window) NULL); i++)b   {RG     status=XGetWindowProperty(display,children[i],property,0L,0L,False, G       (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data);t     if (data != NULL)        XFree((void *) data); 5     if ((status == Success) && (type != (Atom) NULL))        child=children[i];   }0C   for (i=0; (i < number_children) && (child == (Window) NULL); i++)<:     child=XWindowByProperty(display,children[i],property);"   if (children != (Window *) NULL)     XFree((void *) children);    return(child); }=