 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                  W   W  IIIII  DDDD    GGGG  EEEEE  TTTTT                   % O %                  W   W    I    D   D  G      E        T                     % O %                  W W W    I    D   D  G  GG  EEE      T                     % O %                  WW WW    I    D   D  G   G  E        T                     % O %                  W   W  IIIII  DDDD    GGGG  EEEEE    T                     % O %                                                                             % O %                X11 User Interface Routines for ImageMagick.                 % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                              September 1993                                 % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "utility.h" #include "X.h" #include "widget.h"  #include "PreRvIcccm.h"    /*   Define declarations. */, #define AreaIsActive(matte_info,position)  \>   ((position.y >= (matte_info.y-matte_info.bevel_width)) &&  \J    (position.y < (matte_info.y+matte_info.height+matte_info.bevel_width)))- #define MatteIsActive(matte_info,position)  \ =   ((position.x >= (matte_info.x-matte_info.bevel_width)) && \ >    (position.y >= (matte_info.y-matte_info.bevel_width)) &&  \N    (position.x < (matte_info.x+matte_info.width+matte_info.bevel_width)) &&  \J    (position.y < (matte_info.y+matte_info.height+matte_info.bevel_width)))/ #define WindowIsActive(window_info,position)  \ /   ((position.x >= 0) && (position.y >= 0) &&  \ I    (position.x < window_info.width) && (position.y < window_info.height))  /*   State declarations.  */ #define ControlState  0x0001 #define DefaultState  0x0000 #define ExitState  0x0002 # #define InactiveWidgetState  0x0004 6 #define MaxTextWidth  (80*XTextWidth(font_info,"_",1))6 #define MinTextWidth  (26*XTextWidth(font_info,"_",1)): #define QuantumMargin  Max(font_info->max_bounds.width,12)! #define RedrawActionState  0x0008  #define RedrawListState  0x0010 ! #define RedrawWidgetState  0x0020 ( #define UpdateConfigurationState  0x0040 #define UpdateListState  0x0080    /*   Variable declarations. */ static XWidgetInfoM   submenu_info = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }, L   toggle_info = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL };   /*   Forward declarations.  */
 static int4   FontCompare _Declare((const void *,const void *)),6   XScreenEvent _Declare((Display *,XEvent *, char *));   static void ?   XDrawMatte _Declare((Display *,XWindowInfo *,XWidgetInfo *)), B   XSetBevelColor _Declare((Display *,XWindowInfo *,unsigned int)),B   XSetMatteColor _Declare((Display *,XWindowInfo *,unsigned int)),A   XSetTextColor _Declare((Display *,XWindowInfo *,unsigned int));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawBevel "sets off" an area with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % , %  The format of the XDrawBevel function is: % 1 %      XDrawBevel(display,window_info,bevel_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o bevel_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the bevel.  %  %  */6 static void XDrawBevel(display,window_info,bevel_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *bevel_info; {    int      x1,      x2,      y1,      y2;      unsigned int     bevel_width;     XPoint     points[6];     /*'     Draw upper and left beveled border.    */   x1=bevel_info->x; &   y1=bevel_info->y+bevel_info->height;%   x2=bevel_info->x+bevel_info->width;    y2=bevel_info->y; &   bevel_width=bevel_info->bevel_width;   points[0].x=x1;    points[0].y=y1;    points[1].x=x1;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x1-bevel_width;    points[4].y=y2-bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; 9   XSetBevelColor(display,window_info,bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin);    /*(     Draw lower and right beveled border.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y1;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x2+bevel_width;    points[4].y=y1+bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; I   XSetBevelColor(display,window_info,(unsigned int) !bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d B u t t o n                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XDrawBeveledButton draws a button with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawBeveledButton function is: % : %      XDrawBeveledButton(display,window_info,button_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o button_info: Specifies a pointer to a XWidgetInfo structure.  It * %      contains the extents of the button. %  %  */? static void XDrawBeveledButton(display,window_info,button_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *button_info;  {    int      x,     y;     unsigned int
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Draw matte.    */.   XDrawBevel(display,window_info,button_info);:   XSetMatteColor(display,window_info,button_info->raised);E   XFillRectangle(display,window_info->id,window_info->widget_context, J     button_info->x,button_info->y,button_info->width,button_info->height);.   x=button_info->x-button_info->bevel_width-1;.   y=button_info->y-button_info->bevel_width-1;5   XSetForeground(display,window_info->widget_context, 1     window_info->pixel_info->trough_color.pixel); 7   if (button_info->raised || (window_info->depth == 1)) K     XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, O       button_info->width+(button_info->bevel_width << 1)+1,button_info->height+ )       (button_info->bevel_width << 1)+1); )   if (button_info->text == (char *) NULL)      return;    /*     Set cropping region.   */%   crop_info.width=button_info->width; '   crop_info.height=button_info->height;    crop_info.x=button_info->x;    crop_info.y=button_info->y;    /*     Draw text.   */#   font_info=window_info->font_info; J   width=XTextWidth(font_info,button_info->text,strlen(button_info->text));(   x=button_info->x+(QuantumMargin >> 1);   if (button_info->center)<     x=button_info->x+(button_info->width >> 1)-(width >> 1);)   y=button_info->y+((button_info->height- 2     (font_info->ascent+font_info->descent)) >> 1)+#     window_info->font_info->ascent; 1   if (button_info->width == (QuantumMargin >> 1))      {        /*7         Option button-- write label to right of button.        */.       XSetTextColor(display,window_info,True);C       x=button_info->x+button_info->width+button_info->bevel_width+          (QuantumMargin >> 1); J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         button_info->text,strlen(button_info->text)); 
       return;      } J   XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,     Unsorted);9   XSetTextColor(display,window_info,button_info->raised); F   XDrawString(display,window_info->id,window_info->widget_context,x,y,1     button_info->text,strlen(button_info->text)); 9   XSetClipMask(display,window_info->widget_context,None);    if (!button_info->raised) %     XDelay(display,SuspendTime << 2);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d M a t t e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawBeveledMatte draws a matte with a shadowed upper and K %  left bevel and a highlighted lower and right bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawBeveledMatte function is:  % 8 %      XDrawBeveledMatte(display,window_info,matte_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */= static void XDrawBeveledMatte(display,window_info,matte_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *matte_info; {    /*     Draw matte.    */-   XDrawBevel(display,window_info,matte_info); -   XDrawMatte(display,window_info,matte_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawMatte fills a rectangular area with the matte color.  % , %  The format of the XDrawMatte function is: % 1 %      XDrawMatte(display,window_info,matte_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */6 static void XDrawMatte(display,window_info,matte_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *matte_info; {    /*     Draw matte.    */7   if (!matte_info->trough || (window_info->depth == 1)) J     XFillRectangle(display,window_info->id,window_info->highlight_context,H       matte_info->x,matte_info->y,matte_info->width,matte_info->height);   else     { 9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->trough_color.pixel); I       XFillRectangle(display,window_info->id,window_info->widget_context, J         matte_info->x,matte_info->y,matte_info->width,matte_info->height);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e T e x t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDrawMatteText draws a matte with text.  If the text exceeds theG %  extents of the text, a portion of the text relative to the cursor is 
 %  displayed.  % 0 %  The format of the XDrawMatteText function is: % 4 %      XDrawMatteText(display,window_info,text_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. %  %  */9 static void XDrawMatteText(display,window_info,text_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo 
   *text_info;  {    char
     *text;     int      x,     y;     register int     i;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   */,   XSetMatteColor(display,window_info,False);E   XFillRectangle(display,window_info->id,window_info->widget_context, B     text_info->x,text_info->y,text_info->width,text_info->height);'   if (text_info->text == (char *) NULL)      return; :   XSetTextColor(display,window_info,text_info->highlight);#   font_info=window_info->font_info; &   x=text_info->x+(QuantumMargin >> 2);<   y=text_info->y+font_info->ascent+(text_info->height >> 2);.   width=text_info->width-(QuantumMargin >> 1);.   height=font_info->ascent+font_info->descent;   if (*text_info->text == '\0')      {        /*#         No text-- just draw cursor.        */L       XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,         x,y-height+3);
       return;      }    /*     Set cropping region.   */#   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*,     Determine beginning of the visible text.   */,   if (text_info->cursor < text_info->marker)(     text_info->marker=text_info->cursor;   else     {        text=text_info->marker; D       if (XTextWidth(font_info,text,text_info->cursor-text) > width)	         {            text=text_info->text; 0           for (i=0; i < (int) strlen(text); i++)O             if (XTextWidth(font_info,text+i,text_info->cursor-text-i) <= width)                break;#           text_info->marker=text+i; 	         }      }    /*     Draw text and cursor.    */   if (!text_info->highlight)     { N       XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,         Unsorted);J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         text_info->marker,strlen(text_info->marker)); =       XSetClipMask(display,window_info->widget_context,None);      }    else     { N       XSetClipRectangles(display,window_info->annotate_context,0,0,&crop_info,         1,Unsorted);N       width=XTextWidth(font_info,text_info->marker,strlen(text_info->marker));M       XFillRectangle(display,window_info->id,window_info->annotate_context,x, *         y-font_info->ascent,width,height);?       XSetClipMask(display,window_info->annotate_context,None); O       XSetClipRectangles(display,window_info->highlight_context,0,0,&crop_info,          1,Unsorted);M       XDrawString(display,window_info->id,window_info->highlight_context,x,y, 5         text_info->marker,strlen(text_info->marker)); @       XSetClipMask(display,window_info->highlight_context,None);     }    x+= P     XTextWidth(font_info,text_info->marker,text_info->cursor-text_info->marker);H   XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,     x,y-height+3); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e E a s t                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawTriangleEast draws a triangle with a highlighted leftC %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawTriangleEast function is:  % ; %      XDrawTriangleEast(display,window_info,triangle_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */@ static void XDrawTriangleEast(display,window_info,triangle_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;+   x2=triangle_info->x+triangle_info->width; 3   y2=triangle_info->y+(triangle_info->height >> 1);    x3=triangle_info->x;,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw bottom bevel.   */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3-bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2+bevel_width;    points[3].y=y2; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw Left bevel.   */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width+1;    points[2].y=y1-bevel_width;    points[3].x=x3-bevel_width+1;    points[3].y=y3+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2+bevel_width;    points[2].y=y2;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e N o r t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XDrawTriangleNorth draws a triangle with a highlighted left C %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawTriangleNorth function is: % < %      XDrawTriangleNorth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */A static void XDrawTriangleNorth(display,window_info,triangle_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;,   y1=triangle_info->y+triangle_info->height;2   x2=triangle_info->x+(triangle_info->width >> 1);   y2=triangle_info->y;+   x3=triangle_info->x+triangle_info->width; ,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2-bevel_width-2;    points[3].x=x1-bevel_width-1;    points[3].y=y1+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3+bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2;    points[3].y=y2-bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw lower bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1+bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3+bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e S o u t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XDrawTriangleSouth draws a border with a highlighted left and H %  right bevel and a shadowed lower bevel.  The highlighted and shadowed %  bevels create a 3-D effect. % 4 %  The format of the XDrawTriangleSouth function is: % < %      XDrawTriangleSouth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */A static void XDrawTriangleSouth(display,window_info,triangle_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;2   x2=triangle_info->x+(triangle_info->width >> 1);,   y2=triangle_info->y+triangle_info->height;+   x3=triangle_info->x+triangle_info->width;    y3=triangle_info->y;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1-bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3+1;    points[1].y=y3-bevel_width;    points[2].x=x3+bevel_width;    points[2].y=y3-bevel_width;    points[3].x=x2;    points[3].y=y2+bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2+bevel_width;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w W i d g e t T e x t                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XDrawWidgetText first clears the widget and draws a text string G %  justifed left (or center) in the x-direction and centered within the  %  y-direction.  % 1 %  The format of the XDrawWidgetText function is:  % 5 %      XDrawWidgetText(display,window_info,text_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowText structure.  % ? %    o text_info: Specifies a pointer to XWidgetInfo structure.  %  %  */: static void XDrawWidgetText(display,window_info,text_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo 
   *text_info;  {    GC     widget_context;      int      x,     y;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   *//   widget_context=window_info->annotate_context;    if (text_info->raised)A     XClearArea(display,window_info->id,text_info->x,text_info->y, 0       text_info->width,text_info->height,False);   else     { I       XFillRectangle(display,window_info->id,widget_context,text_info->x, 9         text_info->y,text_info->width,text_info->height); 4       widget_context=window_info->highlight_context;     } '   if (text_info->text == (char *) NULL)      return;    if (*text_info->text == '\0')      return;    /*     Set cropping region.   */#   font_info=window_info->font_info; #   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*     Draw text.   */F   width=XTextWidth(font_info,text_info->text,strlen(text_info->text));&   x=text_info->x+(QuantumMargin >> 1);   if (text_info->center)8     x=text_info->x+(text_info->width >> 1)-(width >> 1);/   if (width > (text_info->width-QuantumMargin)) .     x+=(text_info->width-QuantumMargin-width);.   height=font_info->ascent+font_info->descent;E   y=text_info->y+((text_info->height-height) >> 1)+font_info->ascent; G   XSetClipRectangles(display,widget_context,0,0,&crop_info,1,Unsorted); 9   XDrawString(display,window_info->id,widget_context,x,y, -     text_info->text,strlen(text_info->text)); ,   XSetClipMask(display,widget_context,None);   if (x < text_info->x) D     XDrawLine(display,window_info->id,window_info->annotate_context,O       text_info->x,text_info->y,text_info->x,text_info->y+text_info->height-1);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E d i t T e x t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XEditText edits a text string as indicated by the key symbol.  % + %  The format of the XEditText function is:  % 9 %      XEditText(display,text_info,key_symbol,text,state)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. % H %    o key_symbol:  A X11 KeySym that indicates what editing function to %      perform to the text.  % 8 %    o text: A character string to insert into the text. % J %    o state:  An unsigned long that indicates whether the key symbol is a  %      control character or not. %  %  */> static void XEditText(display,text_info,key_symbol,text,state) Display    *display;    XWidgetInfo 
   *text_info;    KeySym
   key_symbol;    char   *text;  
 unsigned long    state; {    switch (key_symbol)    {      case XK_BackSpace:     case XK_Delete:      {        /*         Erase one character.       *//       if (text_info->cursor != text_info->text) 	         {            text_info->cursor--;?           (void) strcpy(text_info->cursor,text_info->cursor+1); %           text_info->highlight=False;            break;	         }      }      case XK_Left:      case XK_KP_Left:     {        /*&         Move cursor one position left.       *//       if (text_info->cursor == text_info->text)          break;       text_info->cursor--;       break;     }      case XK_Right:     case XK_KP_Right:      {        /*'         Move cursor one position right.        */I       if (text_info->cursor == (text_info->text+strlen(text_info->text)))          break;       text_info->cursor++;       break;     }      default:     {        register char          *p,          *q;          register int
         i;         if (state & ControlState)          break;       if (*text == '\0')         break;=       if (((int) strlen(text_info->text)+1) >= MaxTextLength)          XBell(display,0); 
       else	         {            /**             Insert a string into the text.           */#           if (text_info->highlight) 
             {                /*.                 Erase the entire line of text.               */$               *text_info->text='\0';0               text_info->cursor=text_info->text;0               text_info->marker=text_info->text;)               text_info->highlight=False; 
             } A           q=text_info->text+strlen(text_info->text)+strlen(text); >           for (i=0; i <= (int) strlen(text_info->cursor); i++)           { #             *q=(*(q-strlen(text)));              q--;           }            p=text; 0           for (i=0; i < (int) strlen(text); i++)(             *text_info->cursor++=(*p++);	         }        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i d g e t I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Function XGetWidgetInfo initializes the XWidgetInfo structure.  % 0 %  The format of the XGetWidgetInfo function is: % ' %      XGetWidgetInfo(text,widget_info)  % + %  A description of each parameter follows:  % ? %    o text: A string of characters associated with the widget.  % G %    o widget_info: Specifies a pointer to a X11 XWidgetInfo structure.  %  %  */, static void XGetWidgetInfo(text,widget_info) char   *text;   XWidgetInfo    *widget_info;  {    /*     Initialize widget info.    */    widget_info->id=(~0);    widget_info->bevel_width=3;    widget_info->width=1;    widget_info->height=1;     widget_info->x=0;    widget_info->y=0;    widget_info->min_y=0;    widget_info->max_y=0;    widget_info->raised=True;    widget_info->active=False;     widget_info->center=True;    widget_info->trough=False;      widget_info->highlight=False;    widget_info->text=text;    widget_info->cursor=text;    if (text != (char *) NULL) '      widget_info->cursor+=strlen(text);     widget_info->marker=text; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t W i d g e t                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XHighlightWidget draws a highlighted border around a window. % 2 %  The format of the XHighlightWidget function is: % 0 %      XHighlightWidget(display,window_info,x,y) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o x: Specifies an integer representing the rectangle offset in the  %      x-direction.  % G %    o y: Specifies an integer representing the rectangle offset in the  %      y-direction.  %  %  */5 static void XHighlightWidget(display,window_info,x,y)  Display    *display;    XWindowInfo    *window_info;    int    x,   y; {    /*+     Draw the widget highlighting rectangle.    */+   XSetBevelColor(display,window_info,True); I   XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, >     window_info->width-(x << 1),window_info->height-(y << 1));M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, B     window_info->width-(x << 1)+1,window_info->height-(y << 1)+1);,   XSetBevelColor(display,window_info,False);M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, >     window_info->width-(x << 1),window_info->height-(y << 1));?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S c r e e n E v e n t                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XScreenEvent returns True if the any event on the X server queue( %  is associated with the widget window. % . %  The format of the XScreenEvent function is: % ' %      XScreenEvent(display,event,data)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % < %    o event: Specifies a pointer to a X11 XEvent structure. % 9 %    o data: Specifies a pointer to a XWindows structure.  %  %  */+ static int XScreenEvent(display,event,data)  Display    *display;    XEvent	   *event;    char   *data; { 
   XWindows
     *windows;      windows=(XWindows *) data;.   if (event->xany.window == windows->popup.id)     { #       if (event->type == MapNotify) #         windows->popup.mapped=True; %       if (event->type == UnmapNotify) $         windows->popup.mapped=False;       return(True);      } /   if (event->xany.window == windows->widget.id)      { #       if (event->type == MapNotify) $         windows->widget.mapped=True;%       if (event->type == UnmapNotify) %         windows->widget.mapped=False;        return(True);      }    switch (event->type)   {      case ButtonPress:      { /       if ((event->xbutton.button == Button3) && ,           (event->xbutton.state & Mod1Mask))	         {            /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }        return(True);      }      case Expose:     { 5       if (event->xexpose.window == windows->image.id) 	         { 8           XRefreshWindow(display,&windows->image,event);           break;	         } 7       if (event->xexpose.window == windows->magnify.id) &         if (event->xexpose.count == 0)&           if (windows->magnify.mapped)
             { 1               XMakeMagnifyImage(display,windows);                break;
             }         if (event->type == Expose)	         { F           (void) XCommandWidget(display,windows,(char **) NULL,event);           break;	         }        break;     }      case FocusOut:     {        /*,         Set input focus for backdrop window.       */4       if (event->xfocus.window == windows->image.id)K         XSetInputFocus(display,windows->image.id,RevertToNone,CurrentTime);        return(True);      }      case ButtonRelease:      case KeyPress:     case KeyRelease:     case MotionNotify:     case SelectionNotify:        return(True);      default:       break;   }    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t B e v e l C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XSetBevelColor sets the graphic context for drawing a beveled 
 %  border. % 0 %  The format of the XSetBevelColor function is: % 1 %      XSetBevelColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */6 static void XSetBevelColor(display,window_info,raised) Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        Pixmap         stipple;         /*         Monochrome window.       */9       XSetBackground(display,window_info->widget_context, 2         XBlackPixel(display,window_info->screen));9       XSetForeground(display,window_info->widget_context, 2         XWhitePixel(display,window_info->screen));L       XSetFillStyle(display,window_info->widget_context,FillOpaqueStippled);-       stipple=window_info->highlight_stipple;        if (!raised),         stipple=window_info->shadow_stipple;?       XSetStipple(display,window_info->widget_context,stipple);      }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 8         window_info->pixel_info->highlight_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->shadow_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t M a t t e C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XSetMatteColor sets the graphic context for drawing the matte. % 0 %  The format of the XSetMatteColor function is: % 1 %      XSetMatteColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o raised: A value other than zero indicates the matte is active.  %  %  */6 static void XSetMatteColor(display,window_info,raised) Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));     }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->matte_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->depth_color.pixel); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t T e x t C o l o r                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XSetTextColor sets the graphic context for drawing text on a	 %  matte.  % / %  The format of the XSetTextColor function is:  % 0 %      XSetTextColor(display,window_info,raised) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */5 static void XSetTextColor(display,window_info,raised)  Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    int      foreground, 
     matte;     if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       return;      } N   foreground=XDownScale(Intensity(window_info->pixel_info->foreground_color));D   matte=XDownScale(Intensity(window_info->pixel_info->matte_color));6   if (AbsoluteValue(foreground-matte) > (MaxRGB >> 3))7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->foreground_color.pixel);    else7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->background_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r B r o w s e r W i d g e t                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XColorBrowserWidget displays a Color Browser widget with a colorM %  query to the user.  The user keys a reply and presses the Action or Cancel O %  button to exit.  The typed text is returned as the reply function parameter.  % 4 %  The format of the XColorBrowserWidget routine is: % 6 %    XColorBrowserWidget(display,windows,action,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.  %  %  */6 void XColorBrowserWidget(display,windows,action,reply) Display    *display;    XWindows   *windows;    char
   *action,	   *reply;  { " #define CancelButtonText  "Cancel" #define ColornameText  "Name:"$ #define ColorPatternText  "Pattern:" #define GrabButtonText  "Grab"  #define ResetButtonText  "Reset"     char     **colorlist,%     primary_selection[MaxTextLength], !     reset_pattern[MaxTextLength],      text[MaxTextLength];     int      colors,      status,      x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextLength] = "*";     unsigned int     height,      text_width,      visible_colors, 
     width;     unsigned long 
     delay,
     state;     XColor
     color;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     grab_info,     list_info,     mode_info,     north_info,      reply_info,      reset_info,      scroll_info,     selection_info,      slider_info,     south_info,      text_info;     XWindowChanges     window_changes;      /*/     Get color list and sort in ascending order.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);#   (void) strcpy(reset_pattern,"*"); -   colorlist=ListColors(glob_pattern,&colors); "   if (colorlist == (char **) NULL)     {        /*.         Pattern failed, obtain all the colors.       */&       (void) strcpy(glob_pattern,"*");1       colorlist=ListColors(glob_pattern,&colors); &       if (colorlist == (char **) NULL)	         { I           XNoticeWidget(display,windows,"Unable to obtain colors names:",              glob_pattern);J           XDialogWidget(display,windows,action,"Enter color name:",reply);           return; 	         }      }    /*.     Determine Color Browser widget attributes.   */&   font_info=windows->widget.font_info;   text_width=0;    for (i=0; i < colors; i++)M     if (XTextWidth(font_info,colorlist[i],strlen(colorlist[i])) > text_width) I       text_width=XTextWidth(font_info,colorlist[i],strlen(colorlist[i])); 4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText));J   if (XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText));   width+=QuantumMargin; N   if (XTextWidth(font_info,ColorPatternText,strlen(ColorPatternText)) > width)J     width=XTextWidth(font_info,ColorPatternText,strlen(ColorPatternText));H   if (XTextWidth(font_info,ColornameText,strlen(ColornameText)) > width)D     width=XTextWidth(font_info,ColornameText,strlen(ColornameText));.   height=font_info->ascent+font_info->descent;   /*"     Position Color Browser widget.   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin; ?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Color Browser widget.    */B   (void) strcpy(windows->widget.name,"Browse and Select a Color");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_colors=0;    delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          int 
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; N         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; L         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;2         XGetWidgetInfo(GrabButtonText,&grab_info);         grab_info.width=width;)         grab_info.height=(3*height) >> 1; "         grab_info.x=QuantumMargin;4         grab_info.y=((5*QuantumMargin) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width; *         reset_info.height=(3*height) >> 1;#         reset_info.x=QuantumMargin; @         reset_info.y=grab_info.y+grab_info.height+QuantumMargin;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; N         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);C         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*&           Initialize mode information.
         */1         XGetWidgetInfo((char *) NULL,&mode_info);          mode_info.active=True;          mode_info.bevel_width=0;A         mode_info.width=action_info.x-reply_info.x-QuantumMargin; ,         mode_info.height=action_info.height;!         mode_info.x=reply_info.x; "         mode_info.y=action_info.y;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height; I         scroll_info.height=reply_info.y-grab_info.y-(QuantumMargin >> 1); H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=grab_info.y-reply_info.bevel_width; !         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True; 8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_colors= A           (scroll_info.height-(height >> 3)-4)/((9*height) >> 3); $         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)$           for (i=0; i < colors; i++)0             if (strcmp(colorlist[i],reply) == 0)               list_info.id=i; 
         /*&           Initialize text information.
         */         *text='\0'; (         XGetWidgetInfo(text,&text_info);)         text_info.width=reply_info.width;           text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*&           Redraw Color Browser window.
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,9           x,y,ColorPatternText,strlen(ColorPatternText)); 9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledButton(display,&windows->widget,&grab_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info); ?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);          x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,ColornameText,strlen(ColornameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);          selection_info.id=(~0); !         state|=RedrawActionState;          state|=RedrawListState; $         state&=(~RedrawWidgetState);       }       if (state & UpdateListState)       {          char           **checklist;           int            number_colors;  F         status=XParseColor(display,windows->widget.map_info->colormap,           glob_pattern,&color);          if (status != 0)           {              /*2               Reply is a single color name-- exit.             */.             (void) strcpy(reply,glob_pattern);6             (void) strcpy(glob_pattern,reset_pattern);%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 
         /*           Update color list.
         */:         checklist=ListColors(glob_pattern,&number_colors);         if (number_colors == 0)            { 6             (void) strcpy(glob_pattern,reset_pattern);             XBell(display,0);            }          else           { &             for (i=0; i < colors; i++)*               free((char *) colorlist[i]);,             if (colorlist != (char **) NULL)'               free((char *) colorlist);               colorlist=checklist;!             colors=number_colors;            } 
         /*-           Sort color list in ascending order. 
         */         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;$         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*$           Redraw color name & reply.
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); "         state&=(~UpdateListState);       }       if (state & RedrawListState)       { 
         /*+           Determine slider id and position. 
         */<         if (slider_info.id >= (int) (colors-visible_colors))/           slider_info.id=colors-visible_colors; ?         if ((slider_info.id < 0) || (colors <= visible_colors))            slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (colors > 0)            slider_info.y+= J             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/colors;0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; .             for (i=0; i < visible_colors; i++)
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;.               if ((slider_info.id+i) < colors)@                 selection_info.text=colorlist[slider_info.id+i];H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       } "     if (state & RedrawActionState)       {          static char #           colorname[MaxTextLength];   
         /*7           Display the selected color in a drawing area. 
         */6         color=windows->widget.pixel_info->matte_color;F         (void) XParseColor(display,windows->widget.map_info->colormap,D           reply_info.text,&windows->widget.pixel_info->matte_color);N         XBestPixel(display,windows->widget.map_info->colormap,(XColor *) NULL,D           (unsigned int) windows->widget.visual_info->colormap_size,4           &windows->widget.pixel_info->matte_color);!         mode_info.text=colorname; 6         (void) sprintf(mode_info.text,"#%02x%02x%02x",B           XDownScale(windows->widget.pixel_info->matte_color.red),D           XDownScale(windows->widget.pixel_info->matte_color.green),D           XDownScale(windows->widget.pixel_info->matte_color.blue));@         XDrawBeveledButton(display,&windows->widget,&mode_info);6         windows->widget.pixel_info->matte_color=color;$         state&=(~RedrawActionState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState; 
             }          if (!south_info.raised) &           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */               slider_info.id++; %               state|=RedrawListState; 
             } (         if (event.type != ButtonRelease)           continue;        }      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.              */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;                break;
             } 4         if (MatteIsActive(south_info,event.xbutton))&           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)1               slider_info.id-=(visible_colors-1);              else1               slider_info.id+=(visible_colors-1); #             state|=RedrawListState;              break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= colors)                break;9             (void) strcpy(reply_info.text,colorlist[id]); '             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState; #             if (id == list_info.id)                { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;                } #             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;              break;           } 3         if (MatteIsActive(grab_info,event.xbutton))            {              /*'               User pressed Grab button.              */#             grab_info.raised=False; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } 4         if (MatteIsActive(reset_info,event.xbutton))           {              /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } 3         if (MatteIsActive(mode_info,event.xbutton))            {              /*'               User pressed mode button.              */:             (void) strcpy(reply_info.text,mode_info.text);=             (void) strcpy(primary_selection,reply_info.text); E             XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, "               event.xbutton.time);J             reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==!               windows->widget.id; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);              break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed action button.              */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {              /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);            }          if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);            }          if (slider_info.active)            {              /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }          if (!grab_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(grab_info,event.xbutton))                  {                    /*9                     Select a pen color from the X server.                    */B                   (void) XGetWindowColor(display,reply_info.text);4                   reply_info.marker=reply_info.text;L                   reply_info.cursor=reply_info.text+strlen(reply_info.text);G                   XDrawMatteText(display,&windows->widget,&reply_info); +                   state|=RedrawActionState;                  } "             grab_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&grab_info);           }          if (!reset_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) :               if (MatteIsActive(reset_info,event.xbutton))                 { <                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;                  } #             reset_info.raised=True; E             XDrawBeveledButton(display,&windows->widget,&reset_info);            }           if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);                  else#                   state|=ExitState; $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;         break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            { "             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static int           length;            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))            {              /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }                case XK_Down:                case XK_KP_Down:               { !                 slider_info.id++;                  break;               }                case XK_Prior:               case XK_KP_Prior:                { /                 slider_info.id-=visible_colors;                  break;               }                case XK_Next:                case XK_KP_Next:               { /                 slider_info.id+=visible_colors;                  break;               }                case XK_End:               case XK_KP_End:                { &                 slider_info.id=colors;                 break;               } 
             } #             state|=RedrawListState;              break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*-               Read new color or glob patterm.              */)             if (*reply_info.text == '\0')                break;8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;              break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info); F         status=XParseColor(display,windows->widget.map_info->colormap,"           reply_info.text,&color);         if (status != 0)#           state|=RedrawActionState;          break;       }        case KeyRelease:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) J               slider_info.id=(colors*(slider_info.y-slider_info.min_y+1))/8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;G         if (grab_info.raised == MatteIsActive(grab_info,event.xmotion))            {              /*)               Grab button status changed.              *//             grab_info.raised=!grab_info.raised; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } I         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))            {              /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised; E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case SelectionNotify:        {          Atom           type;            int            format,            status;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); A             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState;            }          XFree((void *) data);          break;       }        case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free color list.   */   for (i=0; i < colors; i++)      free((char *) colorlist[i]);"   if (colorlist != (char **) NULL)     free((char *) colorlist);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m m a n d W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCommandWidget maps a menu and returns the command pointed to by( %  the user when the button is released. % / %  The format of the XCommandWidget routine is:  % F %    selection_number=XCommandWidget(display,windows,selections,event) % + %  A description of each parameter follows:  % G %    o selection_number: Specifies the number of the selection that the  %      user choose.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % K %    o selections: Specifies a pointer to one or more strings that comprise  %      the choices in the menu.  % < %    o event: Specifies a pointer to a X11 XEvent structure. %  %  */4 int XCommandWidget(display,windows,selections,event) Display    *display;    XWindows   *windows;    char   **selections;    XEvent	   *event;  {  #define tile_width 112 #define tile_height 70  #   static unsigned char tile_bits[]=    { K     0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x1e, 0x38, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x1e, 0xbc, 0x9f, 0x03, 0x00, 0x3e, 0x00, 0xc0, K     0x1f, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x0f, 0x80, 0x3f, K     0x00, 0xf0, 0x1f, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x1f, K     0xe0, 0x3f, 0x00, 0xfc, 0x1f, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, K     0xff, 0x1f, 0xf0, 0x3f, 0x00, 0xfe, 0x1f, 0xf8, 0x0f, 0x00, 0x00, 0x00, K     0x1e, 0xfc, 0xfc, 0x3f, 0xf8, 0x3f, 0x00, 0xff, 0x1e, 0xfc, 0x0f, 0x00, K     0x00, 0x00, 0x1e, 0x7c, 0xfc, 0x3e, 0xf8, 0x3c, 0x80, 0x1f, 0x1e, 0x7c, K     0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, 0xc0, 0x0f, K     0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, K     0xc0, 0x07, 0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, K     0x7c, 0x7c, 0xc0, 0x0f, 0x1e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x78, K     0x78, 0x3c, 0xfc, 0x7c, 0x80, 0x7f, 0x1e, 0x7c, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0xf8, 0x78, 0x7c, 0xf8, 0xff, 0x00, 0xff, 0x1f, 0xf8, 0xff, 0x00, K     0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xfe, 0x1f, 0xf8, K     0xff, 0x00, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xf8, K     0x1f, 0xf0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xc0, 0xef, K     0x07, 0xe0, 0x1f, 0xc0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0x70, 0x40, 0x78, K     0x00, 0xc7, 0x07, 0x00, 0x1e, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x1e, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, K     0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x02, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x60, 0x00, 0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0x9f, 0x7f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0xdf, K     0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x78, 0x00, K     0xe0, 0xdf, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x0c, K     0x78, 0x30, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, K     0x00, 0x0f, 0xf8, 0x70, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x1f, 0x00, 0xe0, K     0x0f, 0x1e, 0x80, 0x0f, 0xf8, 0x78, 0xf0, 0xfd, 0xf9, 0x00, 0xc0, 0x1f, K     0x00, 0xf8, 0x0f, 0x00, 0xe0, 0x1f, 0xf8, 0x7c, 0xf0, 0xfc, 0xf9, 0x00, K     0xf0, 0x1f, 0x00, 0xfe, 0x0f, 0x00, 0xf0, 0x07, 0xf8, 0x3e, 0xf8, 0xfc, K     0xf0, 0x01, 0xf8, 0x1f, 0x00, 0xff, 0x0f, 0x1e, 0xf0, 0x03, 0xf8, 0x3f, K     0xf8, 0xf8, 0xf0, 0x01, 0xfc, 0x1f, 0x80, 0x7f, 0x0f, 0x1e, 0xf8, 0x00, K     0xf8, 0x1f, 0x78, 0x18, 0xf0, 0x01, 0x7c, 0x1e, 0xc0, 0x0f, 0x0f, 0x1e, K     0x7c, 0x00, 0xf0, 0x0f, 0x78, 0x00, 0xf0, 0x01, 0x3e, 0x1e, 0xe0, 0x07, K     0x0f, 0x1e, 0x7c, 0x00, 0xf0, 0x07, 0x7c, 0x00, 0xe0, 0x01, 0x3e, 0x1e, K     0xe0, 0x03, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x0f, 0x7c, 0x00, 0xe0, 0x03, K     0x3e, 0x3e, 0xe0, 0x07, 0x0f, 0x1e, 0x1e, 0x00, 0xf0, 0x1f, 0x3c, 0x00, K     0xe0, 0x03, 0x7e, 0x3e, 0xc0, 0x3f, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x1f, K     0x3e, 0x00, 0xe0, 0x03, 0xfc, 0x7f, 0x80, 0xff, 0x0f, 0x1e, 0xfc, 0x00, K     0xf0, 0x3e, 0x3e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xff, 0x0f, 0x1e, K     0xfc, 0x07, 0xf0, 0x7c, 0x1e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xfc, K     0x0f, 0x1e, 0xf8, 0x1f, 0xf0, 0xf8, 0x1e, 0x00, 0xc0, 0x03, 0xe0, 0xf7, K     0x03, 0xf0, 0x0f, 0x1e, 0xe0, 0x3f, 0xf0, 0x78, 0x1c, 0x00, 0x80, 0x03, K     0x80, 0xe3, 0x03, 0x00, 0x0f, 0x1e, 0xc0, 0x3f, 0xf0, 0x30, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0e, 0x00, 0x3e, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x10, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, K     0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 2     0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   };     int      id,      y;     register int     i;     static unsigned int      number_selections;     static XWidgetInfo+     *selection_info = (XWidgetInfo *) NULL;      unsigned int     height;      unsigned long 
     state;  
   XFontStruct      *font_info;   '   font_info=windows->command.font_info; .   height=font_info->ascent+font_info->descent;   state=DefaultState;    if (event == (XEvent *) NULL)      {        unsigned int         width;         XTextProperty          window_name;         XWindowChanges         window_changes;          /*,         Determine command window attributes.       */       windows->command.width=0; 4       for (i=0; selections[i] != (char *) NULL; i++)       { H         width=XTextWidth(font_info,selections[i],strlen(selections[i]));+         if (width > windows->command.width) '           windows->command.width=width;        }        number_selections=i;1       windows->command.width+=3*QuantumMargin+10; A       if (windows->command.width < (tile_width+QuantumMargin+10)) ;         windows->command.width=tile_width+QuantumMargin+10;        windows->command.height=@         number_selections*(((3*height) >> 1)+10)+tile_height+20;8       windows->command.min_width=windows->command.width;:       windows->command.min_height=windows->command.height;:       XConstrainWindowPosition(display,&windows->command);/       if (windows->command.id != (Window) NULL) 	         { 
           int              status;              /*'             Reconfigure command window.            */D           status=XStringListToTextProperty(&windows->command.name,1,             &window_name);           if (status != 0)
             { C               XSetWMName(display,windows->command.id,&window_name); 0               XFree((void *) window_name.value);
             } 6           window_changes.width=windows->command.width;8           window_changes.height=windows->command.height;;           XReconfigureWMWindow(display,windows->command.id, H             windows->command.screen,CWWidth | CWHeight,&window_changes);	         }        /*'         Allocate selection info memory.        */1       if (selection_info != (XWidgetInfo *) NULL) &         free((char *) selection_info);$       selection_info=(XWidgetInfo *)6         malloc(number_selections*sizeof(XWidgetInfo));1       if (selection_info == (XWidgetInfo *) NULL) L         Error("Unable to create Command Widget","Memory allocation failed");&       state|=UpdateConfigurationState;     }    /*     Wait for next event.   */
   id=(-1);   if (event != (XEvent *) NULL)      switch (event->type)     {        case ButtonPress:        { -         for (i=0; i < number_selections; i++) 	         { ?           if (!MatteIsActive(selection_info[i],event->xbutton))              continue; )           if (i >= windows->command.data) 
             { -               selection_info[i].raised=False; O               XDrawBeveledButton(display,&windows->command,&selection_info[i]);                break;
             } )           submenu_info=selection_info[i]; #           submenu_info.active=True;            toggle_info.y=P             submenu_info.y+(submenu_info.height >> 1)-(toggle_info.height >> 1);           id=i; N           XCheckWindowEvent(display,windows->widget.id,LeaveWindowMask,event);           break;	         }          break;       }        case ButtonRelease:        { -         for (i=0; i < number_selections; i++) 	         { ?           if (!MatteIsActive(selection_info[i],event->xbutton))              continue;            id=i; *           if (id >= windows->command.data)
             { -               selection_info[id].raised=True; P               XDrawBeveledButton(display,&windows->command,&selection_info[id]);               break;
             }            break;	         }          break;       }        case ClientMessage:        { 
         /*C           If client window delete message, withdraw command widget. 
         */A         if (event->xclient.message_type != windows->wm_protocols)            break;@         if (*event->xclient.data.l != windows->wm_delete_window)           break;M         XWithdrawWindow(display,windows->command.id,windows->command.screen);          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */<         if (event->xconfigure.window != windows->command.id)           break;.         if (event->xconfigure.send_event != 0)           { 3             windows->command.x=event->xconfigure.x; 3             windows->command.y=event->xconfigure.y;            } B         if ((event->xconfigure.width == windows->command.width) &&B             (event->xconfigure.height == windows->command.height))           break;         windows->command.width= B           Max(event->xconfigure.width,windows->command.min_width);          windows->command.height=D           Max(event->xconfigure.height,windows->command.min_height);(         state|=UpdateConfigurationState;         break;       }        case Expose:       { 9         if (event->xexpose.window != windows->command.id)            break;&         if (event->xexpose.count != 0)           break;!         state|=RedrawWidgetState;          break;       }        case MotionNotify:       { 
         /*6           Return the ID of the highlighted menu entry.
         */         for ( ; ; ) 	         { /           for (i=0; i < number_selections; i++)            { +             if (i >= windows->command.data)                { /                 if (selection_info[i].raised == D                     MatteIsActive(selection_info[i],event->xmotion))                   {                      /*,                       Button status changed.                     */G                     selection_info[i].raised=!selection_info[i].raised; A                     XDrawBeveledButton(display,&windows->command, *                       &selection_info[i]);                   }                  continue;                } A             if (!MatteIsActive(selection_info[i],event->xmotion))                continue; +             submenu_info=selection_info[i]; %             submenu_info.active=True; $             toggle_info.raised=True;D             toggle_info.y=submenu_info.y+(submenu_info.height >> 1)-(               (toggle_info.height >> 1);F             XDrawTriangleEast(display,&windows->command,&toggle_info);             id=i;            } &           XDelay(display,SuspendTime);?           if (!XCheckMaskEvent(display,ButtonMotionMask,event))              break;B           while (XCheckMaskEvent(display,ButtonMotionMask,event));#           toggle_info.raised=False; D           XDrawTriangleEast(display,&windows->command,&toggle_info);	         }          break;       }        case MapNotify:        { %         windows->command.mapped=True;          break;       }        case UnmapNotify:        { &         windows->command.mapped=False;         break;       }        default:         break;     } '   if (state & UpdateConfigurationState)      {        /*&         Initialize button information.       */       y=tile_height+20; +       for (i=0; i < number_selections; i++)        { 9         XGetWidgetInfo(selections[i],&selection_info[i]); '         selection_info[i].center=False; (         selection_info[i].bevel_width--;1         selection_info[i].height=(3*height) >> 1; 3         selection_info[i].x=(QuantumMargin >> 1)+4;           selection_info[i].width=<           windows->command.width-(selection_info[i].x << 1);         selection_info[i].y=y;K         y+=selection_info[i].height+(selection_info[i].bevel_width << 1)+6;        } 1       XGetWidgetInfo((char *) NULL,&toggle_info);         toggle_info.bevel_width--;I       toggle_info.width=((5*height) >> 3)-(toggle_info.bevel_width << 1); +       toggle_info.height=toggle_info.width; @       toggle_info.x=selection_info[0].x+selection_info[0].width-/         toggle_info.width-(QuantumMargin >> 1); "       if (windows->command.mapped)2         XClearWindow(display,windows->command.id);     }     if (state & RedrawWidgetState)     {        Pixmap         tile_pixmap;         /*         Draw command buttons.        */J       tile_pixmap=XCreatePixmapFromBitmapData(display,windows->command.id,;         (char *) tile_bits,tile_width,tile_height,1L,0L,1); '       if (tile_pixmap != (Pixmap) NULL) 	         { =           XCopyPlane(display,tile_pixmap,windows->command.id, I             windows->command.annotate_context,0,0,tile_width,tile_height, <             (windows->command.width-tile_width) >> 1,10,1L);+           XFreePixmap(display,tile_pixmap); 	         } +       for (i=0; i < number_selections; i++)        { I         XDrawBeveledButton(display,&windows->command,&selection_info[i]); '         if (i >= windows->command.data)            continue; #         toggle_info.raised=i == id; *         toggle_info.y=selection_info[i].y+D           (selection_info[i].height >> 1)-(toggle_info.height >> 1);B         XDrawTriangleEast(display,&windows->command,&toggle_info);       } L       XHighlightWidget(display,&windows->command,BorderOffset,BorderOffset);     } 
   return(id);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i r m W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function XConfirmWidget displays a Confirm widget with a notice to the user. G %  The function returns True if the user presses Yes otherwise False is  %  returned. % / %  The format of the XConfirmWidget routine is:  % = %    status=XConfirmWidget(display,windows,message,qualifier)  % + %  A description of each parameter follows:  % L %    o status:  Function XConfirmWidget returns True if the user presses Yes# %      otherwise False is returned.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */> unsigned int XConfirmWidget(display,windows,message,qualifier) Display    *display;    XWindows   *windows;    char   *message, 
   *qualifier;  { " #define CancelButtonText  "Cancel" #define YesButtonText  "Yes"     int      status,      x,     y;     unsigned int     confirm,     height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      cancel_info,
     yes_info;      XWindowChanges     window_changes;      /*(     Determine Confirm widget attributes.   */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;H   width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));H   if (XTextWidth(font_info,YesButtonText,strlen(YesButtonText)) > width)D     width=XTextWidth(font_info,YesButtonText,strlen(YesButtonText));   width<<=1;!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Confirm widget.   */.   windows->widget.width=width+7*QuantumMargin;7   windows->widget.min_width=width+(QuantumMargin << 2); 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height; &   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1); 8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Confirm widget.    */0   (void) strcpy(windows->widget.name,"Confirm");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */   confirm=False;!   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*+           Initialize No button information. 
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);(         cancel_info.width=QuantumMargin+J           XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));+         cancel_info.height=(3*height) >> 1; L         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin;G         cancel_info.y=windows->widget.height-(cancel_info.height << 1);          yes_info=cancel_info; $         yes_info.text=YesButtonText;!         yes_info.x=QuantumMargin; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*            Redraw Confirm widget.
         */<         width=XTextWidth(font_info,message,strlen(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,'           x,y,message,strlen(message)); '         if (qualifier != (char *) NULL)            {              char&               question[MaxTextLength];  .             (void) strcpy(question,qualifier);(             (void) strcat(question,"?");B             width=XTextWidth(font_info,question,strlen(question));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id, N               windows->widget.annotate_context,x,y,question,strlen(question));           } B         XDrawBeveledButton(display,&windows->widget,&cancel_info);?         XDrawBeveledButton(display,&windows->widget,&yes_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*%               User pressed No button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 2         if (MatteIsActive(yes_info,event.xbutton))           {              /*&               User pressed Yes button.             */"             yes_info.raised=False;C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;          if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton)) !                 state|=ExitState; $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          if (!yes_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) 8               if (MatteIsActive(yes_info,event.xbutton))                 {                    confirm=True; #                   state|=ExitState;                  } !             yes_info.raised=True; C             XDrawBeveledButton(display,&windows->widget,&yes_info);            }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {              state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { %             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             state|=ExitState;              break;           }          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*'               No button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } E         if (yes_info.raised == MatteIsActive(yes_info,event.xmotion))            {              /*(               Yes button status changed.             */-             yes_info.raised=!yes_info.raised; C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   return(confirm); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i a l o g W i d g e t                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDialogWidget displays a Dialog widget with a query to the user.J %  The user keys a reply and presses the Ok or Cancel button to exit.  The: %  typed text is returned as the reply function parameter. % . %  The format of the XDialogWidget routine is: % 6 %    XDialogWidget(display,windows,action,query,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % F %    o query: Specifies a pointer to the query to present to the user. % G %    o reply: The response from the user is returned in this parameter.  %  %  */6 void XDialogWidget(display,windows,action,query,reply) Display    *display;    XWindows   *windows;    char
   *action,	   *query, 	   *reply;  { " #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextLength];      int      status,      x,     y;     register int     i;     unsigned int     anomaly,     height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     reply_info,      special_info,      text_info;     XWindowChanges     window_changes;      /*'     Determine Dialog widget attributes.    */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));    width+=(3*QuantumMargin) >> 1;.   height=font_info->ascent+font_info->descent;   /*     Position Dialog widget.    */   windows->widget.width=K     Max(2*width,XTextWidth(font_info,query,strlen(query)))+6*QuantumMargin;    windows->widget.min_width=9     width+25*XTextWidth(font_info,"#",1)+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;7   windows->widget.height=7*height+(QuantumMargin << 1); 4   windows->widget.min_height=windows->widget.height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Dialog widget.   *//   (void) strcpy(windows->widget.name,"Dialog"); I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   *//   anomaly=(strcmp(action,"Background") == 0) || %     (strcmp(action,"Quantize") == 0); !   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;          cancel_info.x=K           windows->widget.width-cancel_info.width-((3*QuantumMargin) >> 1);          cancel_info.y=M           windows->widget.height-cancel_info.height-((3*QuantumMargin) >> 1); ,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; E         action_info.x=cancel_info.x-(cancel_info.width+QuantumMargin+ *           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; A         reply_info.width=windows->widget.width-(3*QuantumMargin); &         reply_info.height=height << 1;,         reply_info.x=(3*QuantumMargin) >> 1;C         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*(           Initialize option information.
         *//         XGetWidgetInfo("Dither",&special_info); "         special_info.raised=False;#         special_info.bevel_width--; .         special_info.width=QuantumMargin >> 1;/         special_info.height=QuantumMargin >> 1; $         special_info.x=reply_info.x;L         special_info.y=action_info.y+action_info.height-special_info.height;-         if (strcmp(action,"Background") == 0) '           special_info.text="Backdrop"; 
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info); )         text_info.width=reply_info.width;           text_info.height=height;6         text_info.x=reply_info.x-(QuantumMargin >> 1);"         text_info.y=QuantumMargin;         text_info.center=False; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*           Redraw Dialog widget. 
         */=         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);          if (anomaly)E           XDrawBeveledButton(display,&windows->widget,&special_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        {          if (anomaly)8           if (MatteIsActive(special_info,event.xbutton))
             {                /*-                 Option button status changed.                */7               special_info.raised=!special_info.raised; I               XDrawBeveledButton(display,&windows->widget,&special_info);                break;
             } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed Action button.              */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;          if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton)) !                 state|=ExitState; $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {%"             *reply_info.text='\0';             state|=ExitState;%             break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        {D9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {f7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static int           length;            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);m         *(command+length)='\0'; E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { %             action_info.raised=False;yF             XDrawBeveledButton(display,&windows->widget,&action_info);             state|=ExitState;w             break;           }i'         if (key_symbol == XK_Control_L)r           {s              state|=ControlState;             break;           } !         if (state & ControlState)s           switch (key_symbol)a           {              case XK_u:             case XK_U:
             {d               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;u               break;
             }i             default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }r       case KeyRelease:       {s         static chara!           command[MaxTextLength];i           static KeySyme           key_symbol;.  4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),t/           &key_symbol,(XComposeStatus *) NULL);i'         if (key_symbol == XK_Control_L)c!           state&=(~ControlState);          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)%           break;#         state|=InactiveWidgetState;%         break;       }        case MotionNotify:       {i
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));e(         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))i           {t             /*+               Action button status changed.              */3             action_info.raised=!action_info.raised;.F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }iK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))o           {a             /*+               Cancel button status changed.n             */3             cancel_info.raised=!cancel_info.raised;pF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False;t=         XDrawMatteText(display,&windows->widget,&reply_info);x         break;       }n       case SelectionNotify:x       {2         Atom           type;            intM           format,o           status;1           unsigned chart           *data;           unsigned long1           after,           length;   
         /*1           Obtain response from primary selection.t
         */5         if (event.xselection.property == (Atom) None)o           break;E         status=XGetWindowProperty(display,event.xselection.requestor,eJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||t             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);r         else           {w             /*5               Insert primary selection in reply text.o             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,%               state);%A             XDrawMatteText(display,&windows->widget,&reply_info);            }          XFree((void *) data);          break;       }        case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));%$         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }_       default:         break;     }d!   } while (!(state & ExitState));l)   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   if (anomaly)     if (special_info.raised)       if (*reply != '\0') F         (void) strcat(reply,"!");  /* do not dither when quantizing */ }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %lO %                                                                             %eO %                                                                             %nO %   X F i l e B r o w s e r W i d g e t                                       %sO %                                                                             %dO %                                                                             %.O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %eO %  Function XFileBrowserWidget displays a File Browser widget with a file querynN %  to the user.  The user keys a reply and presses the Action or Cancel buttonH %  to exit.  The typed text is returned as the reply function parameter. %.3 %  The format of the XFileBrowserWidget routine is:  %n5 %    XFileBrowserWidget(display,windows,action,reply)  % + %  A description of each parameter follows:r %sE %    o display: Specifies a connection to an X server;  returned fromd %      XOpenDisplay. %n; %    o window: Specifies a pointer to a XWindows structure.i % @ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.% %% %% */5 void XFileBrowserWidget(display,windows,action,reply)  Display    *display;    XWindows   *windows;    char
   *action,	   *reply;  { " #define CancelButtonText  "Cancel"# #define DirectoryText  "Directory:" " #define FilenameText  "File name:" #define GrabButtonText  "Grab"" #define FormatButtonText  "Format" #define HomeButtonText  "Home" #define UpButtonText  "Up"  
   static char      *ImageOutputFormats[]=     {        "avs",       "bie",       "bmp",
       "cmyk",        "eps",
       "epsf", 
       "epsi",        "fax",
       "fits",        "gif",       "gif87",
       "gray",%       "g3",%       "hdf",       "histogram",
       "jbig", 
       "jpeg",t       "jpg",       "map",       "matte",
       "miff",e       "mpg",       "mtv",       "pbm",       "pcx",       "pdf",       "pgm",
       "pict",t       "png",       "ppm",       "pnm",       "ps",n       "ps2",       "ras",       "rgb",       "rle",       "sgi",       "sun",       "tga",
       "tiff",o       "vid",
       "viff",c
       "x",       "xbm",       "xpm",       "xv",r       "xwd",       "yuv",
       "yuv3",_       (char *) NULLn     };     char     **filelist, "     home_directory[MaxTextLength],%     primary_selection[MaxTextLength],I     text[MaxTextLength],%     working_directory[MaxTextLength];c     inta
     files,     status,n     x,     y;     register int     i;  
   static charf&     glob_pattern[MaxTextLength] = "*",#     format[MaxTextLength] = "miff";      unsigned int     anomaly,     height,S     text_width,_     visible_files,
     width;     unsigned long 
     delay,
     state;     XEvent
     event;  
   XFontStruct;     *font_info;r     XTextPropertyo     window_name;  
   XWidgetInfoa     action_info,     cancel_info,     expose_info,     special_info,f     list_info,     home_info,     north_info,o     reply_info,u     scroll_info,     selection_info,;     slider_info,     south_info,e     text_info,     up_info;     XWindowChanges     window_changes;      /*)     Read filelist from current directory.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);0   (void) getcwd(home_directory,MaxTextLength-1);2   (void) strcpy(working_directory,home_directory);<   filelist=ListFiles(working_directory,glob_pattern,&files);!   if (filelist == (char **) NULL)h     {U       /*         Directory read failed.       */@       XNoticeWidget(display,windows,"Unable to read directory:",         working_directory);iD       XDialogWidget(display,windows,action,"Enter filename:",reply);
       return;      }f   /*-     Determine File Browser widget attributes.n   */&   font_info=windows->widget.font_info;   text_width=0;f   for (i=0; i < files; i++) K     if (XTextWidth(font_info,filelist[i],strlen(filelist[i])) > text_width)tG       text_width=XTextWidth(font_info,filelist[i],strlen(filelist[i]));e4   width=XTextWidth(font_info,action,strlen(action));J   if (XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText));N   if (XTextWidth(font_info,FormatButtonText,strlen(FormatButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));J   if (XTextWidth(font_info,HomeButtonText,strlen(HomeButtonText)) > width)F     width=XTextWidth(font_info,HomeButtonText,strlen(HomeButtonText));F   if (XTextWidth(font_info,UpButtonText,strlen(UpButtonText)) > width)B     width=XTextWidth(font_info,UpButtonText,strlen(UpButtonText));   width+=QuantumMargin;oH   if (XTextWidth(font_info,DirectoryText,strlen(DirectoryText)) > width)D     width=XTextWidth(font_info,DirectoryText,strlen(DirectoryText));F   if (XTextWidth(font_info,FilenameText,strlen(FilenameText)) > width)B     width=XTextWidth(font_info,FilenameText,strlen(FilenameText));.   height=font_info->ascent+font_info->descent;   /*!     Position File Browser widget.    */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin; ?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2);s4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);e   /*     Map File Browser widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a File");fI   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);.   if (status != 0)     {p:       XSetWMName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }f-   window_changes.width=windows->widget.width;f/   window_changes.height=windows->widget.height;d%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);f   windows->widget.mapped=False;%   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_files=0;L   anomaly=(strcmp(action,"Composite") == 0) || (strcmp(action,"Load") == 0);   delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          int 
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; N         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1;oL         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;5         XGetWidgetInfo(GrabButtonText,&special_info); !         special_info.width=width;r,         special_info.height=(3*height) >> 1;M         special_info.x=action_info.x-(action_info.width+(QuantumMargin >> 1)+o+           (special_info.bevel_width << 1)); %         special_info.y=action_info.y;e         if (!anomaly)            {              register charm               *p;|  /             special_info.text=FormatButtonText;s$             p=reply+strlen(reply)-1;2             while ((p > reply) && (*(p-1) != '.'))               p--;/             if ((p > reply) && (*(p-1) == '.'))r&               (void) strcpy(format,p);           }i.         XGetWidgetInfo(UpButtonText,&up_info);         up_info.width=width;'         up_info.height=(3*height) >> 1;           up_info.x=QuantumMargin;2         up_info.y=((5*QuantumMargin) >> 1)+height;2         XGetWidgetInfo(HomeButtonText,&home_info);         home_info.width=width;)         home_info.height=(3*height) >> 1; "         home_info.x=QuantumMargin;;         home_info.y=up_info.y+up_info.height+QuantumMargin; 
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; N         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);C         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;tG         scroll_info.height=reply_info.y-up_info.y-(QuantumMargin >> 1);sH         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);7         scroll_info.y=up_info.y-reply_info.bevel_width;d!         scroll_info.raised=False;s          scroll_info.trough=True;         north_info=scroll_info;e         north_info.raised=True;p8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2;gP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=yJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;M         visible_files=(scroll_info.height-(height >> 3)-4)/((9*height) >> 3);g"         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);w         list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)#           for (i=0; i < files; i++)o/             if (strcmp(filelist[i],reply) == 0)t               list_info.id=i; 
         /*&           Initialize text information.
         */         *text='\0';-(         XGetWidgetInfo(text,&text_info);)         text_info.width=reply_info.width;           text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1);e"         text_info.y=QuantumMargin;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width;i.         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;e+         state&=(~UpdateConfigurationState);l       }n"     if (state & RedrawWidgetState)       {n
         /*%           Redraw File Browser window. 
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,DirectoryText,strlen(DirectoryText));oA         (void) sprintf(text_info.text,"%s%s%s",working_directory, +           DirectorySeparator,glob_pattern);n=         XDrawWidgetText(display,&windows->widget,&text_info);h>         XDrawBeveledButton(display,&windows->widget,&up_info);@         XDrawBeveledButton(display,&windows->widget,&home_info);?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info);rB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);%         x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FilenameText,strlen(FilenameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); C         XDrawBeveledButton(display,&windows->widget,&special_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);%         selection_info.id=(~0);%         state|=RedrawListState;%$         state&=(~RedrawWidgetState);       }       if (state & UpdateListState)       {l         char           **checklist;           inte           number_files;s  
         /*           Update file list.f
         */J         checklist=ListFiles(working_directory,glob_pattern,&number_files);(         if (checklist == (char **) NULL)           {f             /*(               Reply is a filename, exit.             */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }p!         for (i=0; i < files; i++)s%           free((char *) filelist[i]);e'         if (filelist != (char **) NULL)v"           free((char *) filelist);         filelist=checklist;          files=number_files; 
         /*           Update file list.i
         */'         if (filelist == (char **) NULL)            {              /*(               Reply is a filename, exit.             */%             action_info.raised=False;.F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }2         slider_info.height=nJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0;;(         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState;s
         /*(           Redraw directory name & reply.
         */%         if (!IsGlob(reply_info.text))l           {o"             *reply_info.text='\0';.             reply_info.cursor=reply_info.text;           }tA         (void) sprintf(text_info.text,"%s%s%s",working_directory,w+           DirectorySeparator,glob_pattern);p=         XDrawWidgetText(display,&windows->widget,&text_info);n=         XDrawMatteText(display,&windows->widget,&reply_info);1A         XDrawBeveledMatte(display,&windows->widget,&scroll_info);wA         XDrawTriangleNorth(display,&windows->widget,&north_info);dB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);pM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);o"         state&=(~UpdateListState);       }1      if (state & RedrawListState)       {=
         /*+           Determine slider id and position.v
         */:         if (slider_info.id >= (int) (files-visible_files))-           slider_info.id=files-visible_files;,=         if ((slider_info.id < 0) || (files <= visible_files))w           slider_info.id=0;i(         slider_info.y=slider_info.min_y;         if (files > 0)           slider_info.y+=%I             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/files; 0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; -             for (i=0; i < visible_files; i++) 
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < files) ?                 selection_info.text=filelist[slider_info.id+i];%H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }e             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height-y,                   slider_info.bevel_width-1;               }              else               {n?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+c,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           }."         state&=(~RedrawListState);       }_     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)n=       XIfEvent(display,&event,XScreenEvent,(char *) windows);3     else       {r
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)a!           if (slider_info.id > 0)o
             {o               /*                 Move slider up.M               */               slider_info.id--;o%               state|=RedrawListState;o
             }          if (!south_info.raised)=%           if (slider_info.id < files) 
             {1               /*!                 Move slider down.S               */               slider_info.id++;s%               state|=RedrawListState;o
             }o(         if (event.type != ButtonRelease)           continue;*       }w     switch (event.type)o     {.       case ButtonPress:        {s5         if (MatteIsActive(slider_info,event.xbutton))w           {n             /*               Track slider.              */$             slider_info.active=True;             break;           }i4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)p
             {o               /*                 Move slider up.l               */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;2               break;
             }34         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < files)_
             {n               /*!                 Move slider down.t               */&               south_info.raised=False;               slider_info.id++;%%               state|=RedrawListState;%               break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_files-1);             else0               slider_info.id+=(visible_files-1);#             state|=RedrawListState;              break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;                /*&               User pressed file matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= files)               break;8             (void) strcpy(reply_info.text,filelist[id]);'             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);l#             if (id == list_info.id)y               {rA                 (void) strcpy(working_directory,reply_info.text); '                 state|=UpdateListState;                }l#             selection_info.id=(~0);g             list_info.id=id;#             state|=RedrawListState;.             break;           }i1         if (MatteIsActive(up_info,event.xbutton))p           {l             /*%               User pressed Up button.              */!             up_info.raised=False; B             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           };3         if (MatteIsActive(home_info,event.xbutton))l           {              /*'               User pressed Home button.o             */#             home_info.raised=False;hD             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           }f6         if (MatteIsActive(special_info,event.xbutton))           {.             /**               User pressed Special button.             */&             special_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&special_info);c             if (!anomaly)e               {)                 /*/                   Let user select image format..                 */9                 XDefineCursor(display,windows->widget.id, /                   windows->widget.busy_cursor);bC                 XListBrowserWidget(display,windows,&windows->popup,yJ                   ImageOutputFormats,"Select","Select image format type:",                   format);6                 XSetCursorState(display,windows,True);9                 XDefineCursor(display,windows->widget.id,2*                   windows->widget.cursor);:                 AppendImageFormat(format,reply_info.text);J                 reply_info.cursor=reply_info.text+strlen(reply_info.text);E                 XDrawMatteText(display,&windows->widget,&reply_info); )                 special_info.raised=True;oK                 XDrawBeveledButton(display,&windows->widget,&special_info);r               }              break;           }05         if (MatteIsActive(action_info,event.xbutton))n           {              /*)               User pressed action button.h             */%             action_info.raised=False;sF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }e5         if (MatteIsActive(cancel_info,event.xbutton))l           {,             /*)               User pressed Cancel button.%             */%             cancel_info.raised=False;%F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;t             else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);dI                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,n&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;n               }oA             XDrawMatteText(display,&windows->widget,&reply_info);e*             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);n         break;       }        case ButtonRelease:a       {t$         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {a             /*&               User released up button.             */#             delay=SuspendTime << 2;e#             north_info.raised=True;yE             XDrawTriangleNorth(display,&windows->widget,&north_info);x           },         if (!south_info.raised)t           {o             /*(               User released down button.             */#             delay=SuspendTime << 2;e#             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);p           }e         if (slider_info.active)g           {>             /*#               Stop tracking slider.=             */%             slider_info.active=False;x             break;           }s         if (!up_info.raised)           {(;             if (event.xbutton.window == windows->widget.id)f7               if (MatteIsActive(up_info,event.xbutton))                  {u8                   (void) strcpy(working_directory,"..");)                   state|=UpdateListState;>                 }i              up_info.raised=True;B             XDrawBeveledButton(display,&windows->widget,&up_info);           }_         if (!home_info.raised)           {d;             if (event.xbutton.window == windows->widget.id)t9               if (MatteIsActive(home_info,event.xbutton))o                 {tB                   (void) strcpy(working_directory,home_directory);)                   state|=UpdateListState;>                 }_"             home_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&home_info);           }%!         if (!special_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) <               if (MatteIsActive(special_info,event.xbutton))                 { 6                   (void) strcpy(reply_info.text,"x:");#                   state|=ExitState;                  } %             special_info.raised=True; G             XDrawBeveledButton(display,&windows->widget,&special_info);            }           if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton))%-                 if (*reply_info.text == '\0')%#                   XBell(display,0);                  else#                   state|=ExitState;f$             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }o          if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))a                 {u(                   *reply_info.text='\0';#                   state|=ExitState;1                 }a$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          break;       }n       case ClientMessage:h       {y
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {dG             XSetInputFocus(display,event.xclient.window,RevertToParent,:'               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id),           {r"             *reply_info.text='\0';             state|=ExitState;              break;           }e         break;       }:       case ConfigureNotify:o       { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        {r9         if (event.xcrossing.window != windows->widget.id)t           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {t7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)h           break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {=         static char !           command[MaxTextLength];f           static int           length;g           static KeySym            key_symbol;-  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0';;1         if (AreaIsActive(scroll_info,event.xkey))*           {%             /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }                case XK_Down:                case XK_KP_Down:               { !                 slider_info.id++;                  break;               }                case XK_Prior:               case XK_KP_Prior:                {%.                 slider_info.id-=visible_files;                 break;               }t               case XK_Next:n               case XK_KP_Next:               {e.                 slider_info.id+=visible_files;                 break;               }                case XK_End:               case XK_KP_End:a               {w%                 slider_info.id=files;o                 break;               }o
             } #             state|=RedrawListState;t             break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {d             /*1               Read new directory or glob patterm.>             */)             if (*reply_info.text == '\0')                break;(             if (IsGlob(reply_info.text)):               (void) strcpy(glob_pattern,reply_info.text);             else               {TA                 (void) strcpy(working_directory,reply_info.text);s.                 if (*working_directory == '~')4                   ExpandFilename(working_directory);               }=#             state|=UpdateListState;r             break;           }%'         if (key_symbol == XK_Control_L)%           {%              state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);s         break;       }u       case KeyRelease:       {f         static char !           command[MaxTextLength];W           static KeySym,           key_symbol;i  4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);n'         if (key_symbol == XK_Control_L) !           state&=(~ControlState);r         break;       }        case LeaveNotify:d       { 9         if (event.xcrossing.window != windows->widget.id)n           break;#         state|=InactiveWidgetState;n         break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events.o
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));n         if (slider_info.active)h           {d             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;o3             if (slider_info.y != slider_info.min_y)%I               slider_info.id=(files*(slider_info.y-slider_info.min_y+1))/ 8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;C         if (up_info.raised == MatteIsActive(up_info,event.xmotion))            {              /*'               Up button status changed.              */+             up_info.raised=!up_info.raised; B             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           } G         if (home_info.raised == MatteIsActive(home_info,event.xmotion))%           {%             /*)               Home button status changed.              *//             home_info.raised=!home_info.raised;eD             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           }:M         if (special_info.raised == MatteIsActive(special_info,event.xmotion))r           {s             /*)               Grab button status changed.s             */5             special_info.raised=!special_info.raised;fG             XDrawBeveledButton(display,&windows->widget,&special_info);i             break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised;pF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }nK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))T           {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised;uF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }t       case SelectionClear:       { #         reply_info.highlight=False;n=         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case SelectionNotify:n       {o         Atom           type;v           intt           format,            status;s           unsigned char            *data;           unsigned longe           after,           length;x  
         /*1           Obtain response from primary selection.h
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor,uJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||)             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.f             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); A             XDrawMatteText(display,&windows->widget,&reply_info);:           }t         XFree((void *) data);o         break;       })       case SelectionRequest:       {          XSelectionEvent*           notify;%           XSelectionRequestEvent           *request;%  "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }        default:         break;     }o!   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False);eE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);e(   XCheckRefreshWindows(display,windows);   /*     Free file list.t   */   for (i=0; i < files; i++)e     free((char *) filelist[i]);e!   if (filelist != (char **) NULL)      free((char *) filelist);   if (*reply == '~')     ExpandFilename(reply); }l   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             %oO %                                                                             % O %                                                                             %wO %   X F o n t B r o w s e r W i d g e t                                       % O %                                                                             % O %                                                                             %iO %                                                                             %,O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_ %oO %  Function XFontBrowserWidget displays a Font Browser widget with a font query N %  to the user.  The user keys a reply and presses the Action or Cancel buttonH %  to exit.  The typed text is returned as the reply function parameter. %%3 %  The format of the XFontBrowserWidget routine is:% % 5 %    XFontBrowserWidget(display,windows,action,reply)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.  %  %  */ static int FontCompare(x,y) 
 const void   *x,    *y;  {    register char      *p,      *q;      p=(char *) *((char **) x);   q=(char *) *((char **) y);4   while ((*p != '\0') && (*q != '\0') && (*p == *q))   {%     p++;     q++;   }a   return(*p-(*q)); }i  5 void XFontBrowserWidget(display,windows,action,reply)e Displaye   *display;n   XWindows   *windows;e   char
   *action,	   *reply;d {  #define BackButtonText  "Back"" #define CancelButtonText  "Cancel" #define FontnameText  "Name:"s# #define FontPatternText  "Pattern:"   #define ResetButtonText  "Reset"     char      back_pattern[MaxTextLength],     **fontlist,      **listhead,A%     primary_selection[MaxTextLength],t!     reset_pattern[MaxTextLength],v     text[MaxTextLength];     intn
     fonts,     status,d     x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextLength] = "*";     unsigned int     height,      text_width,o     visible_fonts,
     width;     unsigned longr
     delay,
     state;     XEvent
     event;  
   XFontStruct(     *font_info;f     XTextProperty      window_name;  
   XWidgetInfoy     action_info,     back_info,     cancel_info,     expose_info,     list_info,     mode_info,     north_info,      reply_info,u     reset_info,_     scroll_info,     selection_info,i     slider_info,     south_info,;     text_info;     XWindowChanges     window_changes;g     /*.     Get font list and sort in ascending order.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);+   (void) strcpy(back_pattern,glob_pattern); #   (void) strcpy(reset_pattern,"*"); 9   fontlist=XListFonts(display,glob_pattern,32767,&fonts);    if (fonts == 0)      {        /*-         Pattern failed, obtain all the fonts.        */D       XNoticeWidget(display,windows,"Unable to obtain fonts names:",         glob_pattern);&       (void) strcpy(glob_pattern,"*");=       fontlist=XListFonts(display,glob_pattern,32767,&fonts); %       if (fontlist == (char **) NULL) 	         { H           XNoticeWidget(display,windows,"Unable to obtain fonts names:",             glob_pattern);           return;%	         }%     }%   /*&     Sort font list in ascending order.   */   listhead=fontlist;3   fontlist=(char **) malloc(fonts*sizeof(char **)); !   if (fontlist == (char **) NULL)C     {n<       XNoticeWidget(display,windows,"Unable to view fonts:",$         "Memory allocation failed");
       return;      }    for (i=0; i < fonts; i++)e     fontlist[i]=listhead[i];0   qsort((void *) fontlist,fonts,sizeof(char **),B     (int (*) _Declare((const void *, const void *))) FontCompare);   /*-     Determine Font Browser widget attributes.c   */&   font_info=windows->widget.font_info;   text_width=0;"   for (i=0; i < fonts; i++)tK     if (XTextWidth(font_info,fontlist[i],strlen(fontlist[i])) > text_width) G       text_width=XTextWidth(font_info,fontlist[i],strlen(fontlist[i])); 4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText));J   if (XTextWidth(font_info,BackButtonText,strlen(BackButtonText)) > width)F     width=XTextWidth(font_info,BackButtonText,strlen(BackButtonText));   width+=QuantumMargin;_L   if (XTextWidth(font_info,FontPatternText,strlen(FontPatternText)) > width)H     width=XTextWidth(font_info,FontPatternText,strlen(FontPatternText));F   if (XTextWidth(font_info,FontnameText,strlen(FontnameText)) > width)B     width=XTextWidth(font_info,FontnameText,strlen(FontnameText));.   height=font_info->ascent+font_info->descent;   /*!     Position Font Browser widget.%   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin; ?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((85*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((27*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2);%4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Font Browser widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a Font");iI   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);e   if (status != 0)     {r:       XSetWMName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }p-   window_changes.width=windows->widget.width;e/   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x;S%   window_changes.y=windows->widget.y;uI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);o   windows->widget.mapped=False;a   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_fonts=0;   delay=SuspendTime << 2;e!   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)t       {x         int 
           id;[  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; N         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; L         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;2         XGetWidgetInfo(BackButtonText,&back_info);         back_info.width=width;)         back_info.height=(3*height) >> 1;n"         back_info.x=QuantumMargin;4         back_info.y=((5*QuantumMargin) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width;a*         reset_info.height=(3*height) >> 1;#         reset_info.x=QuantumMargin;a@         reset_info.y=back_info.y+back_info.height+QuantumMargin;
         /*'           Initialize reply information._
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;tN         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);K         reply_info.y=action_info.y-(action_info.height << 1)-QuantumMargin;w
         /*&           Initialize mode information.
         */)         XGetWidgetInfo(reply,&mode_info);,          mode_info.bevel_width=0;A         mode_info.width=action_info.x-reply_info.x-QuantumMargin;l1         mode_info.height=action_info.height << 1;l!         mode_info.x=reply_info.x;_M         mode_info.y=action_info.y-action_info.height+action_info.bevel_width;f
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);)"         scroll_info.bevel_width--;!         scroll_info.width=height;BI         scroll_info.height=reply_info.y-back_info.y-(QuantumMargin >> 1);xH         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=back_info.y-reply_info.bevel_width;_!         scroll_info.raised=False;a          scroll_info.trough=True;         north_info=scroll_info;x         north_info.raised=True;f8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;r-         north_info.x+=north_info.bevel_width;_-         north_info.y+=north_info.bevel_width;i         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;t         slider_info.id=id;         slider_info.width-=2;iP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=(J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_fonts=A           (scroll_info.height-(height >> 3)-4)/((9*height) >> 3);y"         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);_         list_info.raised=False;a          list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;d"         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)#           for (i=0; i < fonts; i++)p/             if (strcmp(fontlist[i],reply) == 0)w               list_info.id=i; 
         /*&           Initialize text information.
         */         *text='\0';g(         XGetWidgetInfo(text,&text_info);)         text_info.width=reply_info.width;i          text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;-+         state&=(~UpdateConfigurationState);a       }."     if (state & RedrawWidgetState)       {u
         /*%           Redraw Font Browser window._
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent;cP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,7           x,y,FontPatternText,strlen(FontPatternText)); 9         (void) sprintf(text_info.text,"%s",glob_pattern);i=         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledButton(display,&windows->widget,&back_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info);_?         XDrawBeveledMatte(display,&windows->widget,&list_info);hA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);eA         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);          x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FontnameText,strlen(FontnameText));r@         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);f         selection_info.id=(~0);i!         state|=RedrawActionState;          state|=RedrawListState;t$         state&=(~RedrawWidgetState);       }*      if (state & UpdateListState)       {.         char           **checklist;           int            number_fonts;r  
         /*           Update font list.)
         */G         checklist=XListFonts(display,glob_pattern,32767,&number_fonts); (         if (checklist == (char **) NULL)           { >             if ((strchr(glob_pattern,'*') == (char *) NULL) &&<                 (strchr(glob_pattern,'?') == (char *) NULL))               {o                 /*3                   Might be a scaleable font-- exit.=                 */2                 (void) strcpy(reply,glob_pattern);9                 (void) strcpy(glob_pattern,back_pattern);_)                 action_info.raised=False;lJ                 XDrawBeveledButton(display,&windows->widget,&action_info);                 break;               } 5             (void) strcpy(glob_pattern,back_pattern);              XBell(display,0);            }r         else            if (number_fonts == 1)
             {t               /*3                 Reply is a single font name-- exit.                */0               (void) strcpy(reply,checklist[0]);7               (void) strcpy(glob_pattern,back_pattern);h(               XFreeFontNames(checklist);'               action_info.raised=False; H               XDrawBeveledButton(display,&windows->widget,&action_info);               break;
             }s           else
             { '               XFreeFontNames(listhead);d&               free((char *) fontlist);!               fontlist=checklist;l!               fonts=number_fonts;f
             } 
         /*,           Sort font list in ascending order.
         */         listhead=fontlist;9         fontlist=(char **) malloc(fonts*sizeof(char **)); '         if (fontlist == (char **) NULL)t           {iB             XNoticeWidget(display,windows,"Unable to view fonts:",*               "Memory allocation failed");             return;            }=!         for (i=0; i < fonts; i++)="           fontlist[i]=listhead[i];6         qsort((void *) fontlist,fonts,sizeof(char **),H           (int (*) _Declare((const void *, const void *))) FontCompare);         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0;c(         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);n         list_info.id=(~0);         state|=RedrawListState; 
         /*#           Redraw font name & reply. 
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern);*=         XDrawWidgetText(display,&windows->widget,&text_info);==         XDrawMatteText(display,&windows->widget,&reply_info);)A         XDrawBeveledMatte(display,&windows->widget,&scroll_info);dA         XDrawTriangleNorth(display,&windows->widget,&north_info);nB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);>M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);_"         state&=(~UpdateListState);       }i      if (state & RedrawListState)       {B
         /*+           Determine slider id and position. 
         */:         if (slider_info.id >= (int) (fonts-visible_fonts))-           slider_info.id=fonts-visible_fonts;h=         if ((slider_info.id < 0) || (fonts <= visible_fonts))s           slider_info.id=0;i(         slider_info.y=slider_info.min_y;         if (fonts > 0)           slider_info.y+=_I             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/fonts;S0         if (slider_info.id != selection_info.id)           {x             /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; -             for (i=0; i < visible_fonts; i++)e
             {;G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < fonts)o?                 selection_info.text=fontlist[slider_info.id+i];dH               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {t?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               {t?                 expose_info.height=expose_info.y-slider_info.y;D?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               }sE             XDrawTriangleNorth(display,&windows->widget,&north_info);s>             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           };"         state&=(~RedrawListState);       })"     if (state & RedrawActionState)       {          XFontStructh           *font_info,o           *save_info;   
         /*6           Display the selected font in a drawing area.
         */,         save_info=windows->widget.font_info;:         font_info=XLoadQueryFont(display,reply_info.text);.         if (font_info != (XFontStruct *) NULL)           {.1             windows->widget.font_info=font_info;; L             XSetFont(display,windows->widget.widget_context,font_info->fid);           }_@         XDrawBeveledButton(display,&windows->widget,&mode_info);,         windows->widget.font_info=save_info;.         if (font_info != (XFontStruct *) NULL)           {(<             XSetFont(display,windows->widget.widget_context,.               windows->widget.font_info->fid);)             XFreeFont(display,font_info);c           }nM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);D=         XDrawMatteText(display,&windows->widget,&reply_info);D$         state&=(~RedrawActionState);       }f     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)l=       XIfEvent(display,&event,XScreenEvent,(char *) windows);v     else       {&
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--;o%               state|=RedrawListState;i
             }          if (!south_info.raised)|%           if (slider_info.id < fonts) 
             {d               /*!                 Move slider down.                */               slider_info.id++; %               state|=RedrawListState;_
             }i(         if (event.type != ButtonRelease)           continue;)       }      switch (event.type)      {        case ButtonPress:i       { 5         if (MatteIsActive(slider_info,event.xbutton))i           {              /*               Track slider.>             */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)t
             {L               /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--;T%               state|=RedrawListState;_               break;
             }y4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < fonts) 
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;f               break;
             }i5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_fonts-1);             else0               slider_info.id+=(visible_fonts-1);#             state|=RedrawListState;f             break;           }l3         if (MatteIsActive(list_info,event.xbutton))B           {d             unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= fonts)               break;8             (void) strcpy(reply_info.text,fontlist[id]);'             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);x%             state|=RedrawActionState;x#             if (id == list_info.id)c               {)<                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;t               }e#             selection_info.id=(~0);r             list_info.id=id;#             state|=RedrawListState;              break;           }p3         if (MatteIsActive(back_info,event.xbutton))n           {p             /*'               User pressed Back button.o             */#             back_info.raised=False;DD             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           }=4         if (MatteIsActive(reset_info,event.xbutton))           {              /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           }s5         if (MatteIsActive(action_info,event.xbutton))            {=             /*)               User pressed action button.v             */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {t             /*)               User pressed Cancel button.f             */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }i5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time.               click_time;B               /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);*I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,_&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;c               }bA             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,R1           windows->widget.id,event.xbutton.time);          break;       }(       case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)e           {t             /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);e           },         if (!south_info.raised)l           {g             /*(               User released down button.             */#             delay=SuspendTime << 2;n#             south_info.raised=True;ME             XDrawTriangleSouth(display,&windows->widget,&south_info);d           }e         if (slider_info.active)f           {              /*#               Stop tracking slider.n             */%             slider_info.active=False;a             break;           }          if (!back_info.raised)           {i;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(back_info,event.xbutton))v                 { ;                   (void) strcpy(glob_pattern,back_pattern);t)                   state|=UpdateListState;.                 } "             back_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&back_info);           }A         if (!reset_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) :               if (MatteIsActive(reset_info,event.xbutton))                 {n;                   (void) strcpy(back_pattern,glob_pattern); <                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;                  }m#             reset_info.raised=True; E             XDrawBeveledButton(display,&windows->widget,&reset_info);s           }_          if (!action_info.raised)           {e;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton))X-                 if (*reply_info.text == '\0') #                   XBell(display,0);                  else#                   state|=ExitState;n$             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           {I;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  {i(                   *reply_info.text='\0';#                   state|=ExitState;,                 } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {.G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           }o?         if (*event.xclient.data.l != windows->wm_delete_window)e           break;7         if (event.xclient.window == windows->widget.id)e           {e"             *reply_info.text='\0';             state|=ExitState;i             break;           }          break;       }o       case ConfigureNotify:        {f
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:&       {w9         if (event.xcrossing.window != windows->widget.id)t           break;&         state&=(~InactiveWidgetState);         break;       }t       case Expose:       {n7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }i       case KeyPress:       {          static charf!           command[MaxTextLength];            static int           length;o           static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),a/           &key_symbol,(XComposeStatus *) NULL);a         *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))S           {&             /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:l               case XK_KP_Home:               {c!                 slider_info.id=0;                  break;               })               case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;r                 break;               }                case XK_Down:                case XK_KP_Down:               {v!                 slider_info.id++;                  break;               }r               case XK_Prior:               case XK_KP_Prior:o               { .                 slider_info.id-=visible_fonts;                 break;               }a               case XK_Next:w               case XK_KP_Next:               {d.                 slider_info.id+=visible_fonts;                 break;               }a               case XK_End:               case XK_KP_End:                {f%                 slider_info.id=fonts;                  break;               }d
             } #             state|=RedrawListState;e             break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*,               Read new font or glob patterm.             */)             if (*reply_info.text == '\0')s               break;5             (void) strcpy(back_pattern,glob_pattern);r8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;              break;           }v'         if (key_symbol == XK_Control_L)y           {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)d           {              case XK_u:             case XK_U:
             {;               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           }a@         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }a       case KeyRelease:       {s         static char !           command[MaxTextLength];d           static KeySym            key_symbol;n  4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L)x!           state&=(~ControlState);_         break;       };       case LeaveNotify:n       {=9         if (event.xcrossing.window != windows->widget.id)f           break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       {C
         /*/           Discard pending button motion events.e
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));i         if (slider_info.active)            {x             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;t3             if (slider_info.y != slider_info.min_y)dI               slider_info.id=(fonts*(slider_info.y-slider_info.min_y+1))/e8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;d             break;           } (         if (state & InactiveWidgetState)           break;G         if (back_info.raised == MatteIsActive(back_info,event.xmotion))            {r             /*)               Back button status changed.T             *//             back_info.raised=!back_info.raised; D             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           } I         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))            {X             /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised;oE             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {e             /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }o       case SelectionClear:       { #         reply_info.highlight=False;t=         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }i       case SelectionNotify:        {          Atom           type;a           int            format,P           status;            unsigned chard           *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)e           break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||a             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {o             /*5               Insert primary selection in reply text.e             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state);yA             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState;n           }          XFree((void *) data);F         break;       }a       case SelectionRequest:       {:         XSelectionEvent            notify;            XSelectionRequestEvent           *request;;  
         /*#           Set XA_PRIMARY selection.r
         */-         request=(&(event.xselectionrequest));iN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));c$         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }        default:         break;     }d!   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free font list.l   */   XFreeFontNames(listhead);t   free((char *) fontlist); }( d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %fO %                                                                             %rO %                                                                             %dO %   X I n f o W i d g e t                                                     % O %                                                                             % O %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t % L %  Function XInfoWidget displays text in the Info widget.  The purpose is toH %  inform the user that what activity is currently being performed (e.g.. %  reading an image, rotating an image, etc.). %., %  The format of the XInfoWidget routine is: %l* %    XInfoWidget(display,windows,activity) % + %  A description of each parameter follows:( %eE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  %eK %    o activity: This character string reflects the current activity and is&$ %      displayed in the Info widget. %  %r */* void XInfoWidget(display,windows,activity) Displayt   *display;i   XWindows   *windows;    char   *activity; {    unsigned int     height,o     margin,g
     width;  
   XFontStruct      *font_info;a  
   XWidgetInfo.     monitor_info;      XWindowChanges     window_changes;d     /*     Map Info widget.   */$   font_info=windows->info.font_info;   width=O     XTextWidth(font_info,activity,strlen(activity))+((3*QuantumMargin) >> 1)+2; =   height=((6*(font_info->ascent+font_info->descent)) >> 2)+2; I   if ((windows->info.width != width) || (windows->info.height != height))t     {l       /*9         Size Info widget to accomodate the activity text.        */        windows->info.width=width;"       windows->info.height=height;!       window_changes.width=width;M#       window_changes.height=height;pI       XReconfigureWMWindow(display,windows->info.id,windows->info.screen, ,         CWWidth | CWHeight,&window_changes);     }    if (!windows->info.mapped))     XMapWindow(display,windows->info.id);d   /*&     Initialize Info matte information.   */.   height=font_info->ascent+font_info->descent;)   XGetWidgetInfo(activity,&monitor_info);    monitor_info.bevel_width--;nI   margin=monitor_info.bevel_width+((windows->info.height-height) >> 1)-2;e   monitor_info.raised=False;   monitor_info.x=margin;   monitor_info.y=margin;7   monitor_info.width=windows->info.width-(margin << 1);t9   monitor_info.height=windows->info.height-(margin << 1);S   /*     Draw Info widget.    */:   XDrawBeveledMatte(display,&windows->info,&monitor_info);   monitor_info.raised=True;a8   XDrawWidgetText(display,&windows->info,&monitor_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %fO %                                                                             %tO %                                                                             %aO %   X L i s t B r o w s e r W i d g e t                                       % O %                                                                             % O %                                                                             %.O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u %-M %  Function XListBrowserWidget displays a List Browser widget with a query topN %  the user.  The user keys a reply or select a reply from the list.  Finally,K %  the user presses the Action or Cancel button to exit.  The typed text ise, %  returned as the reply function parameter. % 3 %  The format of the XListBrowserWidget routine is:i %sL %    XListBrowserWidget(display,windows,window_info,list,action,query,reply) %i+ %  A description of each parameter follows:p %eE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %=; %    o window: Specifies a pointer to a XWindows structure.y %qF %    o list: Specifies a pointer to an array of strings.  The user can; %      select from these strings as a possible reply value.a %&@ %    o action: Specifies a pointer to the action of this widget. %aF %    o query: Specifies a pointer to the query to present to the user. %sG %    o reply: The response from the user is returned in this parameter.  %  %o */L void XListBrowserWidget(display,windows,window_info,list,action,query,reply) Displayh   *display;s   XWindows   *windows;%   XWindowInfo%   *window_info;%   char	   **list,%
   *action,	   *query, 	   *reply;  { " #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextLength];      int      entries,     status,      x,     y;     register int     i;     unsigned int     height,      text_width,      visible_entries,
     width;     unsigned long 
     delay,
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     list_info,     north_info,      reply_info,      scroll_info,     selection_info,%     slider_info,     south_info,%     text_info;     XWindowChanges     window_changes;o     /*,     Count the number of entries in the list.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   if (list == (char **) NULL)l     {nH       XNoticeWidget(display,windows,"No text to browse:",(char *) NULL);
       return;m     }l   for (entries=0; ; entries++)'     if (list[entries] == (char *) NULL)n       break;   /*-     Determine Font Browser widget attributes.o   */#   font_info=window_info->font_info; 7   text_width=XTextWidth(font_info,query,strlen(query));r   for (i=0; i < entries; i++) C     if (XTextWidth(font_info,list[i],strlen(list[i])) > text_width)m?       text_width=XTextWidth(font_info,list[i],strlen(list[i]));f4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));   width+=QuantumMargin;d.   height=font_info->ascent+font_info->descent;   /*!     Position Font Browser widget.    */K   window_info->width=Min(text_width,MaxTextWidth)+((9*QuantumMargin) >> 1); 6   window_info->min_width=MinTextWidth+4*QuantumMargin;2   if (window_info->width < window_info->min_width).     window_info->width=window_info->min_width;E   window_info->height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4; I   window_info->min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;04   if (window_info->height < window_info->min_height)0     window_info->height=window_info->min_height;2   XQueryPosition(display,window_info->root,&x,&y);1   window_info->x=x-((3*window_info->width) >> 2);x.   window_info->y=y-(window_info->height >> 1);0   XConstrainWindowPosition(display,window_info);   /*     Map Font Browser widget.   */,   (void) strcpy(window_info->name,"Browse");F   status=XStringListToTextProperty(&window_info->name,1,&window_name);   if (status != 0)     { 7       XSetWMName(display,window_info->id,&window_name);c(       XFree((void *) window_name.value);     } *   window_changes.width=window_info->width;,   window_changes.height=window_info->height;"   window_changes.x=window_info->x;"   window_changes.y=window_info->y;L   XReconfigureWMWindow(display,window_info->id,window_info->screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);&   XMapRaised(display,window_info->id);   window_info->mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);x,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_entries=0;   delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)x       {          intx
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; K         cancel_info.x=window_info->width-cancel_info.width-QuantumMargin-2; K         cancel_info.y=window_info->height-cancel_info.height-QuantumMargin; ,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; L         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information.f
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;0E         reply_info.width=window_info->width-((4*QuantumMargin) >> 1);0&         reply_info.height=height << 1;#         reply_info.x=QuantumMargin;0C         reply_info.y=action_info.y-reply_info.height-QuantumMargin;x
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);x"         scroll_info.bevel_width--;!         scroll_info.width=height; H         scroll_info.height=reply_info.y-((6*QuantumMargin) >> 1)-height;H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);M         scroll_info.y=((5*QuantumMargin) >> 1)+height-reply_info.bevel_width;x!         scroll_info.raised=False;x          scroll_info.trough=True;         north_info=scroll_info;f         north_info.raised=True;x8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_entries=A           (scroll_info.height-(height >> 3)-4)/((9*height) >> 3);x&         if (entries > visible_entries)J           slider_info.height=(visible_entries*slider_info.height)/entries;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);0         list_info.raised=False;x          list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;!         if (!window_info->mapped) %           for (i=0; i < entries; i++)f+             if (strcmp(list[i],reply) == 0)x               list_info.id=i;f
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info); )         text_info.width=reply_info.width;           text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information.0
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width;x.         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);0       }x"     if (state & RedrawWidgetState)       { 
         /*%           Redraw List Browser window. 
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent;08         XDrawWidgetText(display,window_info,&text_info);:         XDrawBeveledMatte(display,window_info,&list_info);<         XDrawBeveledMatte(display,window_info,&scroll_info);<         XDrawTriangleNorth(display,window_info,&north_info);=         XDrawBeveledButton(display,window_info,&slider_info);0<         XDrawTriangleSouth(display,window_info,&south_info);         x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent;x;         XDrawBeveledMatte(display,window_info,&reply_info); 8         XDrawMatteText(display,window_info,&reply_info);=         XDrawBeveledButton(display,window_info,&action_info);U=         XDrawBeveledButton(display,window_info,&cancel_info);tH         XHighlightWidget(display,window_info,BorderOffset,BorderOffset);         selection_info.id=(~0);s!         state|=RedrawActionState;e         state|=RedrawListState;e$         state&=(~RedrawWidgetState);       }       if (state & RedrawListState)       {i
         /*+           Determine slider id and position.s
         */>         if (slider_info.id >= (int) (entries-visible_entries))1           slider_info.id=entries-visible_entries;tA         if ((slider_info.id < 0) || (entries <= visible_entries))f           slider_info.id=0;((         slider_info.y=slider_info.min_y;         if (entries > 0)           slider_info.y+=hK             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/entries;=0         if (slider_info.id != selection_info.id)           {w             /*/               Redraw scroll bar and file names.t             */-             selection_info.id=slider_info.id;u9             selection_info.y=list_info.y+(height >> 3)+2; /             for (i=0; i < visible_entries; i++)t
             {wG               selection_info.raised=(slider_info.id+i) != list_info.id;i0               selection_info.text=(char *) NULL;/               if ((slider_info.id+i) < entries) ;                 selection_info.text=list[slider_info.id+i]; C               XDrawWidgetText(display,window_info,&selection_info);i<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {(?                 expose_info.height=slider_info.y-expose_info.y;a?                 expose_info.y=slider_info.y-expose_info.height-h,                   slider_info.bevel_width-1;               }l             else               { ?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } @             XDrawTriangleNorth(display,window_info,&north_info);9             XDrawMatte(display,window_info,&expose_info);;A             XDrawBeveledButton(display,window_info,&slider_info);(@             XDrawTriangleSouth(display,window_info,&south_info);(             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       }(     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       {e
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)e!           if (slider_info.id > 0)r
             {                /*                 Move slider up.                */               slider_info.id--;e%               state|=RedrawListState;u
             }h         if (!south_info.raised);'           if (slider_info.id < entries)w
             {i               /*!                 Move slider down.r               */               slider_info.id++;a%               state|=RedrawListState;o
             }b(         if (event.type != ButtonRelease)           continue;s       }i     switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.              */$             slider_info.active=True;             break;           }r4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)C
             {                /*                 Move slider up.l               */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;r               break;
             }a4         if (MatteIsActive(south_info,event.xbutton))'           if (slider_info.id < entries)m
             {-               /*!                 Move slider down.a               */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;w               break;
             }r5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)2               slider_info.id-=(visible_entries-1);             else2               slider_info.id+=(visible_entries-1);#             state|=RedrawListState;a             break;           }h3         if (MatteIsActive(list_info,event.xbutton))m           {h             unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= entries)               break;4             (void) strcpy(reply_info.text,list[id]);'             reply_info.highlight=False;r.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);<             XDrawMatteText(display,window_info,&reply_info);#             selection_info.id=(~0); #             if (id == list_info.id)s               { )                 action_info.raised=False;tE                 XDrawBeveledButton(display,window_info,&action_info);o!                 state|=ExitState;                }              list_info.id=id;#             state|=RedrawListState;              break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed action button.              */%             action_info.raised=False; A             XDrawBeveledButton(display,window_info,&action_info);M             break;           }e5         if (MatteIsActive(cancel_info,event.xbutton))u           {l             /*)               User pressed Cancel button.              */%             cancel_info.raised=False;iA             XDrawBeveledButton(display,window_info,&cancel_info);g             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))n           break;,         if (event.xbutton.button != Button2)           {;             static Times               click_time;M               /*;               Move text cursor to position of button press.o             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;;             else               {g                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); F                 XSetSelectionOwner(display,XA_PRIMARY,window_info->id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) =="                   window_info->id;               }4<             XDrawMatteText(display,window_info,&reply_info);*             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, .           window_info->id,event.xbutton.time);         break;       }>       case ButtonRelease:h       { !         if (!window_info->mapped)o           break;         if (!north_info.raised)e           {0             /*&               User released up button.             */#             delay=SuspendTime << 2;r#             north_info.raised=True; @             XDrawTriangleNorth(display,window_info,&north_info);           }x         if (!south_info.raised)m           {              /*(               User released down button.             */#             delay=SuspendTime << 2;i#             south_info.raised=True; @             XDrawTriangleSouth(display,window_info,&south_info);           }l         if (slider_info.active)d           {              /*#               Stop tracking slider.l             */%             slider_info.active=False;d             break;           }P          if (!action_info.raised)           { 8             if (event.xbutton.window == window_info->id);               if (MatteIsActive(action_info,event.xbutton))i-                 if (*reply_info.text == '\0') #                   XBell(display,0);i                 else#                   state|=ExitState;i$             action_info.raised=True;A             XDrawBeveledButton(display,window_info,&action_info);p           }>          if (!cancel_info.raised)           {g8             if (event.xbutton.window == window_info->id);               if (MatteIsActive(cancel_info,event.xbutton))%                 {%(                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;A             XDrawBeveledButton(display,window_info,&cancel_info);            } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;         break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent,%'               event.xclient.data.l[1]);n             break;           }o?         if (*event.xclient.data.l != windows->wm_delete_window)            break;4         if (event.xclient.window == window_info->id)           {t"             *reply_info.text='\0';             state|=ExitState;l             break;           }          break;       }h       case ConfigureNotify:        {:
         /*&           Update widget configuration.
         */7         if (event.xconfigure.window != window_info->id)            break;=         if ((event.xconfigure.width == window_info->width) && =             (event.xconfigure.height == window_info->height))            break;         window_info->width=l=           Max(event.xconfigure.width,window_info->min_width);i         window_info->height=?           Max(event.xconfigure.height,window_info->min_height);i(         state|=UpdateConfigurationState;         break;       }n       case EnterNotify:e       {a6         if (event.xcrossing.window != window_info->id)           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 4         if (event.xexpose.window != window_info->id)           break;%         if (event.xexpose.count != 0)o           break;!         state|=RedrawWidgetState;l         break;       }        case KeyPress:       {a         static chare!           command[MaxTextLength];            static int           length;o           static KeySym-           key_symbol;i  1         if (event.xkey.window != window_info->id)e           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),i/           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0';r1         if (AreaIsActive(scroll_info,event.xkey))h           {a             /*               Move slider.             */             switch (key_symbol)q
             {(               case XK_Home:i               case XK_KP_Home:               {e!                 slider_info.id=0;o                 break;               }n               case XK_Up:w               case XK_KP_Up:               {w!                 slider_info.id--;a                 break;               }                case XK_Down:                case XK_KP_Down:               {t!                 slider_info.id++;g                 break;               }h               case XK_Prior:               case XK_KP_Prior:                {e0                 slider_info.id-=visible_entries;                 break;               }                case XK_Next:o               case XK_KP_Next:               {(0                 slider_info.id+=visible_entries;                 break;               }                case XK_End:               case XK_KP_End:-               {f'                 slider_info.id=entries;y                 break;               } 
             } #             state|=RedrawListState;w             break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))h           {g             /*               Read new entry.d             */)             if (*reply_info.text == '\0')d               break;%             action_info.raised=False;lA             XDrawBeveledButton(display,window_info,&action_info);g             state|=ExitState;;             break;           }i'         if (key_symbol == XK_Control_L)e           {               state|=ControlState;             break;           }r!         if (state & ControlState)p           switch (key_symbol)            {              case XK_u:             case XK_U:
             {n               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }.             default:               break;           }f@         XEditText(display,&reply_info,key_symbol,command,state);8         XDrawMatteText(display,window_info,&reply_info);         break;       }t       case KeyRelease:       {t         static char !           command[MaxTextLength];i           static KeySym            key_symbol;w  1         if (event.xkey.window != window_info->id)h           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),n/           &key_symbol,(XComposeStatus *) NULL);t'         if (key_symbol == XK_Control_L)n!           state&=(~ControlState);          break;       }        case LeaveNotify:        { 6         if (event.xcrossing.window != window_info->id)           break;#         state|=InactiveWidgetState;i         break;       }t       case MotionNotify:       {l
         /*/           Discard pending button motion events.i
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));d         if (slider_info.active)w           {e             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y)aK               slider_info.id=(entries*(slider_info.y-slider_info.min_y+1))/o8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))_           {u             /*+               Action button status changed.s             */3             action_info.raised=!action_info.raised; A             XDrawBeveledButton(display,window_info,&action_info);              break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))w           {t             /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised;.A             XDrawBeveledButton(display,window_info,&cancel_info);              break;           }          break;       }.       case SelectionClear:       {d#         reply_info.highlight=False;e8         XDrawMatteText(display,window_info,&reply_info);         break;       }f       case SelectionNotify:d       {e         Atom           type;I           into           format,            status;            unsigned charr           *data;           unsigned long            after,           length;n  
         /*1           Obtain response from primary selection.-
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor,iJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {t             /*5               Insert primary selection in reply text..             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); <             XDrawMatteText(display,window_info,&reply_info);%             state|=RedrawActionState;            }.         XFree((void *) data);i         break;       };       case SelectionRequest:       {=         XSelectionEvent&           notify;t           XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));.N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));d$         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState));g)   XSetCursorState(display,windows,False);o?   XWithdrawWindow(display,window_info->id,window_info->screen); (   XCheckRefreshWindows(display,windows); }l   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %aO %                                                                             %eO %                                                                             % O %   X M e n u W i d g e t                                                     % O %                                                                             %tO %                                                                             %,O %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XMenuWidget maps a menu and returns the command pointed to by the $ %  user when the button is released. % , %  The format of the XMenuWidget routine is: %-H %    selection_number=XMenuWidget(display,windows,title,selections,item) %o+ %  A description of each parameter follows:o % G %    o selection_number: Specifies the number of the selection that the  %      user choose.  % E %    o display: Specifies a connection to an X server;  returned froms %      XOpenDisplay. %s; %    o window: Specifies a pointer to a XWindows structure.  % N %    o title: Specifies a character string that describes the menu selections. %SK %    o selections: Specifies a pointer to one or more strings that comprised %      the choices in the menu.  %CJ %    o item: Specifies a character array.  The item selected from the menu %      is returned here. %% %% */6 int XMenuWidget(display,windows,title,selections,item) Display    *display;    XWindows   *windows;    char	   *title,    **selections;    char   *item; {    Cursor     cursor;      int      id,      x,     y;     unsigned int     height,      number_selections,     title_height,      top_offset, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XSetWindowAttributes     window_attributes;  
   XWidgetInfo      highlight_info,      menu_info,     selection_info;      XWindowChanges     window_changes;      /*%     Determine Menu widget attributes.%   */&   font_info=windows->widget.font_info;.   windows->widget.width=!submenu_info.active ?2     XTextWidth(font_info,title,strlen(title)) : 0;3   for (id=0; selections[id] != (char *) NULL; id++)x   {TF     width=XTextWidth(font_info,selections[id],strlen(selections[id]));&     if (width > windows->widget.width)"       windows->widget.width=width;   }s   number_selections=id; +   XGetWidgetInfo((char *) NULL,&menu_info); %   title_height=!submenu_info.active ?i:     (3*(font_info->descent+font_info->ascent) >> 1)+5 : 2;2   width=XTextWidth(font_info,title,strlen(title));9   height=(3*(font_info->ascent+font_info->descent)) >> 1;c   /*     Position Menu widget.q   */D   windows->widget.width+=QuantumMargin+(menu_info.bevel_width << 1);2   top_offset=title_height+menu_info.bevel_width-1;?   windows->widget.height=top_offset+number_selections*height+4;o2   windows->widget.min_width=windows->widget.width;4   windows->widget.min_height=windows->widget.height;5   XQueryPosition(display,windows->widget.root,&x,&y); +   windows->widget.x=x-(QuantumMargin >> 1);    if (submenu_info.active)     {        windows->widget.x=@         windows->command.x+windows->command.width-QuantumMargin;       toggle_info.raised=True;@       XDrawTriangleEast(display,&windows->command,&toggle_info);     }iI   windows->widget.y=!submenu_info.active ? y-((3*title_height) >> 2) : y;_   if (submenu_info.active)8     windows->widget.y=windows->command.y+submenu_info.y;5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Menu widget.   */+   window_attributes.override_redirect=True;;H   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);-   window_changes.width=windows->widget.width;T/   window_changes.height=windows->widget.height;B%   window_changes.x=windows->widget.x;)%   window_changes.y=windows->widget.y;_I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,.4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);w   windows->widget.mapped=False;e   /*     Respond to X events.   */   selection_info.height=height; 1   cursor=XCreateFontCursor(display,XC_right_ptr);i2   XDefineCursor(display,windows->image.id,cursor);4   XDefineCursor(display,windows->command.id,cursor);3   XDefineCursor(display,windows->widget.id,cursor);w!   state=UpdateConfigurationState;h   do   { )     if (state & UpdateConfigurationState)h       { 
         /*+           Initialize selection information.i
         */1         XGetWidgetInfo((char *) NULL,&menu_info);d          menu_info.bevel_width--;M         menu_info.width=windows->widget.width-((menu_info.bevel_width) << 1);lO         menu_info.height=windows->widget.height-((menu_info.bevel_width) << 1);i*         menu_info.x=menu_info.bevel_width;*         menu_info.y=menu_info.bevel_width;6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=menu_info.width;s%         selection_info.height=height;h%         selection_info.x=menu_info.x;a&         highlight_info=selection_info;%         highlight_info.bevel_width--;u@         highlight_info.width-=(highlight_info.bevel_width << 1);A         highlight_info.height-=(highlight_info.bevel_width << 1);s5         highlight_info.x+=highlight_info.bevel_width;l+         state&=(~UpdateConfigurationState);        }s"     if (state & RedrawWidgetState)       {r
         /*           Redraw Menu widget.a
         */!         if (!submenu_info.active)a           {e             y=title_height; ;             XSetBevelColor(display,&windows->widget,False); P             XDrawLine(display,windows->widget.id,windows->widget.widget_context,C               selection_info.x,y-1,(int) selection_info.width,y-1);f:             XSetBevelColor(display,&windows->widget,True);P             XDrawLine(display,windows->widget.id,windows->widget.widget_context,?               selection_info.x,y,(int) selection_info.width,y);(L             XSetFillStyle(display,windows->widget.widget_context,FillSolid);           }.
         /*           Draw menu selections.e
         */#         selection_info.center=True;-/         selection_info.y=menu_info.bevel_width;t"         selection_info.text=title;!         if (!submenu_info.active) D           XDrawWidgetText(display,&windows->widget,&selection_info);$         selection_info.center=False;$         selection_info.y=top_offset;0         for (id=0; id < number_selections; id++)	         {s-           selection_info.text=selections[id];lD           XDrawWidgetText(display,&windows->widget,&selection_info);G           highlight_info.y=selection_info.y+highlight_info.bevel_width; &           if (id == selection_info.id)A             XDrawBevel(display,&windows->widget,&highlight_info);i8           selection_info.y+=(int) selection_info.height;	         }l8         XDrawBevel(display,&windows->widget,&menu_info);$         state&=(~RedrawWidgetState);       }1     if (number_selections > 2)       { 
         /*           Redraw Menu line.o
         */A         y=top_offset+selection_info.height*(number_selections-1);07         XSetBevelColor(display,&windows->widget,False); L         XDrawLine(display,windows->widget.id,windows->widget.widget_context,?           selection_info.x,y-1,(int) selection_info.width,y-1); 6         XSetBevelColor(display,&windows->widget,True);L         XDrawLine(display,windows->widget.id,windows->widget.widget_context,;           selection_info.x,y,(int) selection_info.width,y);tH         XSetFillStyle(display,windows->widget.widget_context,FillSolid);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)a     {o       case ButtonPress:        {D
         /*/           Discard pending button motion events. 
         */7         if (event.xbutton.window != windows->widget.id)s           {              /*               Exit menu.             */*             XPutBackEvent(display,&event);             *item='\0';e             state|=ExitState;g             break;           }r&         state&=(~InactiveWidgetState);D         id=(event.xbutton.y-top_offset)/(int) selection_info.height;         selection_info.id=id;n2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection.n
         */=         selection_info.y=top_offset+id*selection_info.height; +         selection_info.text=selections[id];nB         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width;l=         XDrawBevel(display,&windows->widget,&highlight_info);          break;       }a       case ButtonRelease:n       {)$         if (!windows->widget.mapped)           break;
         /*           Exit menu.
         */7         if (event.xbutton.window != windows->widget.id)u(           XPutBackEvent(display,&event);/         XSetCursorState(display,windows,False);(         *item='\0';i         state|=ExitState;          break;       }        case ConfigureNotify:e       { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=pB           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }_       case EnterNotify:        {f9         if (event.xcrossing.window != windows->widget.id)            break;'         if (event.xcrossing.state == 0)e           break;&         state&=(~InactiveWidgetState);H         id=((event.xcrossing.y-top_offset)/(int) selection_info.height);P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           {.             /*)               Unhighlight last selection._             */(             if (id == selection_info.id)               break;             selection_info.y= A               top_offset+selection_info.id*selection_info.height;g>             selection_info.text=selections[selection_info.id];F             XDrawWidgetText(display,&windows->widget,&selection_info);           }w2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection. 
         */         selection_info.id=id; L         selection_info.y=top_offset+selection_info.id*selection_info.height;:         selection_info.text=selections[selection_info.id];B         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width; =         XDrawBevel(display,&windows->widget,&highlight_info);.         break;       }a       case Expose:       {.7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)n           break;!         state|=RedrawWidgetState;          break;       }o       case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          id=selection_info.id; 2         if ((id < 0) || (id >= number_selections))           break;
         /*%           Unhighlight last selection. 
         */=         selection_info.y=top_offset+id*selection_info.height;          selection_info.id=(~0); +         selection_info.text=selections[id]; B         XDrawWidgetText(display,&windows->widget,&selection_info);         break;       }.       case MotionNotify:       {l
         /*/           Discard pending button motion events.n
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));l          if (submenu_info.active):           if (event.xmotion.window == windows->command.id)/             if (!(state & InactiveWidgetState))w               {_?                 if (!MatteIsActive(submenu_info,event.xmotion))i                   { +                     selection_info.id=(-1);;                     *item='\0'; %                     state|=ExitState;                      break;                   }                }              elseA               if (WindowIsActive(windows->command,event.xmotion))w                 {i)                   selection_info.id=(-1);e                   *item='\0';>#                   state|=ExitState;x                   break;                 } 7         if (event.xmotion.window != windows->widget.id)            break;(         if (state & InactiveWidgetState)           break;D         id=(event.xmotion.y-top_offset)/(int) selection_info.height;P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           {r             /*)               Unhighlight last selection.i             */(             if (id == selection_info.id)               break;             selection_info.y=aA               top_offset+selection_info.id*selection_info.height;w>             selection_info.text=selections[selection_info.id];F             XDrawWidgetText(display,&windows->widget,&selection_info);           }          selection_info.id=id; 2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection.y
         */=         selection_info.y=top_offset+id*selection_info.height;i+         selection_info.text=selections[id]; B         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width;k=         XDrawBevel(display,&windows->widget,&highlight_info);=         break;       }s       default:         break;     }K!   } while (!(state & ExitState));    XFreeCursor(display,cursor);,   window_attributes.override_redirect=False;H   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);r   if (submenu_info.active)     {         submenu_info.active=False;       toggle_info.raised=False;y@       XDrawTriangleEast(display,&windows->command,&toggle_info);     } J   if ((selection_info.id < 0) || (selection_info.id >= number_selections))     return(~0);/4   (void) strcpy(item,selections[selection_info.id]);   return(selection_info.id); };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %rO %                                                                             %eO %                                                                             %;O %   X N o t i c e W i d g e t                                                 %mO %                                                                             % O %                                                                             % O %                                                                             %yO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a % M %  Function XNoticeWidget displays a Notice widget with a notice to the user.lC %  The function returns when the user presses the "Dismiss" button.  % . %  The format of the XNoticeWidget routine is: %.5 %    XNoticeWidget(display,windows,message,qualifier)a %%+ %  A description of each parameter follows:N %fE %    o display: Specifies a connection to an X server;  returned froms %      XOpenDisplay. %h; %    o window: Specifies a pointer to a XWindows structure.  % G %    o message: Specifies the message to display before terminating thef %      program.I %t9 %    o qualifier: Specifies any qualifier to the message.  %  %  */5 void XNoticeWidget(display,windows,message,qualifier)  Display    *display;a   XWindows   *windows;.   char   *message,v
   *qualifier;l {&$ #define DismissButtonText  "Dismiss" #define Timeout  8     int      status,c     x,     y;     time_t
     timer;     unsigned int     height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;f     XTextPropertyf     window_name;  
   XWidgetInfod     dismiss_info;d     XWindowChanges     window_changes;r     /*'     Determine Notice widget attributes.    */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;J   width=XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));   if (message != (char *) NULL) >     if (XTextWidth(font_info,message,strlen(message)) > width):       width=XTextWidth(font_info,message,strlen(message));!   if (qualifier != (char *) NULL)1B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Notice widget.P   */.   windows->widget.width=width+4*QuantumMargin;0   windows->widget.min_width=width+QuantumMargin;8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height; &   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1);08   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Notice widget.   *//   (void) strcpy(windows->widget.name,"Notice");eI   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status == 0)     {n:       XSetWMName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }.-   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height;e%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y;rI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,e4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);y   windows->widget.mapped=False;o   XBell(display,0);>   /*     Respond to X events.   */&   timer=time((time_t *) NULL)+Timeout;!   state=UpdateConfigurationState;i(   XSetCursorState(display,windows,True);   do   {s&     if (time((time_t *) NULL) > timer)       break;)     if (state & UpdateConfigurationState)        { 
         /*0           Initialize Dismiss button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);)         dismiss_info.width=QuantumMargin+ L           XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));,         dismiss_info.height=(3*height) >> 1;N         dismiss_info.x=(windows->widget.width >> 1)-(dismiss_info.width >> 1);I         dismiss_info.y=windows->widget.height-(dismiss_info.height << 1);y+         state&=(~UpdateConfigurationState);        }t"     if (state & RedrawWidgetState)       {%
         /*           Redraw Notice widget.%
         */<         width=XTextWidth(font_info,message,strlen(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,'           x,y,message,strlen(message)); '         if (qualifier != (char *) NULL)            { D             width=XTextWidth(font_info,qualifier,strlen(qualifier));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id, P               windows->widget.annotate_context,x,y,qualifier,strlen(qualifier));           }%C         XDrawBeveledButton(display,&windows->widget,&dismiss_info);eM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);p$         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */E     if (!XCheckIfEvent(display,&event,XScreenEvent,(char *) windows))s       { 
         /*$           Do not block if delay > 0.
         */)         XDelay(display,SuspendTime << 2);s         continue;p       }      switch (event.type);     {n       case ButtonPress:p       { 6         if (MatteIsActive(dismiss_info,event.xbutton))           {              /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);w             break;           }s         break;       }n       case ButtonRelease:        { $         if (!windows->widget.mapped)           break;!         if (!dismiss_info.raised)e           {l;             if (event.xbutton.window == windows->widget.id)n<               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState; %             dismiss_info.raised=True;aG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);s           }e         break;       }        case ClientMessage:        {7
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           },?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id),           {,             state|=ExitState;)             break;           }i         break;       }o       case ConfigureNotify:r       {o
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }o       case EnterNotify:o       {i9         if (event.xcrossing.window != windows->widget.id)u           break;&         state&=(~InactiveWidgetState);         break;       }e       case Expose:       {W7         if (event.xexpose.window != windows->widget.id)l           break;%         if (event.xexpose.count != 0)p           break;!         state|=RedrawWidgetState;n         break;       }o       case KeyPress:       {          static charn!           command[MaxTextLength];e           static KeySymr           key_symbol;l  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),i/           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))s           {o&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);f             state|=ExitState;              break;           }X         break;       }i       case LeaveNotify:)       {t9         if (event.xcrossing.window != windows->widget.id)W           break;#         state|=InactiveWidgetState;          break;       }d       case MotionNotify:       {G
         /*/           Discard pending button motion events.,
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));x(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))C           {x             /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;nG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);B             break;           }          break;       }d       default:         break;     }o!   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False);rE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);e(   XCheckRefreshWindows(display,windows); }f _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             % O %                                                                             %eO %                                                                             %xO %   X P r e f e r e n c e s W i d g e t                                       %)O %                                                                             %(O %                                                                             %*O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Q %yI %  Function XPreferencesWidget displays a Preferences widget with programiJ %  preferences.  If the user presses the Apply button, the preferences are? %  stored in a configuration file in the users' home directory.  % 3 %  The format of the XPreferencesWidget routine is:i %w6 %    XPreferencesWidget(display,resource_info,windows) %i+ %  A description of each parameter follows:& %dE %    o display: Specifies a connection to an X server;  returned froms %      XOpenDisplay. %;K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.n %s; %    o window: Specifies a pointer to a XWindows structure.g %d %  */> unsigned int XPreferencesWidget(display,resource_info,windows) Display    *display;e  
 XResourceInfow   *resource_info;i   XWindows   *windows;  {W  #define ApplyButtonText  "Apply"" #define CancelButtonText  "Cancel" #define NumberPreferences  5  
   static charF     *Preferences[] =     {X       "backdrop",G       "confirm exit",U       "dither",        "shared colormap",       "use pixmap",      };     char     filename[MaxTextLength],     specifier[MaxTextLength],r     *value;o     int      status,c     x,     y;     register int     i;     unsigned int     height,g     text_width, 
     width;     unsigned longe
     state;     XEvent
     event;  
   XFontStruct      *font_info;   
   XrmDatabaset     preferences_database;      XTextProperty      window_name;  
   XWidgetInfon     apply_info,      cancel_info,(     preferences_info[NumberPreferences];     XWindowChanges     window_changes;w     /*,     Determine Preferences widget attributes.   */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;   text_width=0;o'   for (i=0; i < NumberPreferences; i++)tQ     if (XTextWidth(font_info,Preferences[i],strlen(Preferences[i])) > text_width)lM       text_width=XTextWidth(font_info,Preferences[i],strlen(Preferences[i]));wF   width=XTextWidth(font_info,ApplyButtonText,strlen(ApplyButtonText));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));   width+=QuantumMargin;m0   height=(font_info->ascent+font_info->descent);   /*      Position Preferences widget.   */C   windows->widget.width=Max(width << 1,text_width)+3*QuantumMargin;m7   windows->widget.min_width=(width << 1)+QuantumMargin;m8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height=f=     4*height+NumberPreferences*(height+(QuantumMargin >> 1));(   windows->widget.min_height= =     4*height+NumberPreferences*(height+(QuantumMargin >> 1));=:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y);x3   windows->widget.x=x-(windows->widget.width >> 1); 8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);e   /*     Map Preferences widget.    */4   (void) strcpy(windows->widget.name,"Preferences");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }e-   window_changes.width=windows->widget.width;M/   window_changes.height=windows->widget.height;r%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y;mI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);r   windows->widget.mapped=False;g   /*     Respond to X events.   */!   state=UpdateConfigurationState;n(   XSetCursorState(display,windows,True);   do   {o)     if (state & UpdateConfigurationState)F       { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;1N         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;4         XGetWidgetInfo(ApplyButtonText,&apply_info);         apply_info.width=width; *         apply_info.height=(3*height) >> 1;K         apply_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+ )           (apply_info.bevel_width << 1));.#         apply_info.y=cancel_info.y;          y=height;e-         for (i=0; i < NumberPreferences; i++) 	         {i>           XGetWidgetInfo(Preferences[i],&preferences_info[i]);,           preferences_info[i].bevel_width--;7           preferences_info[i].width=QuantumMargin >> 1;i8           preferences_info[i].height=QuantumMargin >> 1;.           preferences_info[i].x=QuantumMargin;"           preferences_info[i].y=y;)           y+=height+(QuantumMargin >> 1); 	         }f<         preferences_info[0].raised=!resource_info->backdrop;@         preferences_info[1].raised=!resource_info->confirm_exit;:         preferences_info[2].raised=!resource_info->dither;M         preferences_info[3].raised=resource_info->colormap != SharedColormap;i>         preferences_info[4].raised=!resource_info->use_pixmap;+         state&=(~UpdateConfigurationState);f       }_"     if (state & RedrawWidgetState)       {f
         /*$           Redraw Preferences widget.
         */A         XDrawBeveledButton(display,&windows->widget,&apply_info);tB         XDrawBeveledButton(display,&windows->widget,&cancel_info);-         for (i=0; i < NumberPreferences; i++)tL           XDrawBeveledButton(display,&windows->widget,&preferences_info[i]);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);f$         state&=(~RedrawWidgetState);       }e     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)t     {s       case ButtonPress:        { 4         if (MatteIsActive(apply_info,event.xbutton))           {e             /*(               User pressed Apply button.             */$             apply_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&apply_info);t             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))*           {e             /*)               User pressed Cancel button.r             */%             cancel_info.raised=False;>F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           },-         for (i=0; i < NumberPreferences; i++)e?           if (MatteIsActive(preferences_info[i],event.xbutton))r
             {                /*2                 User pressed a Preferences button.               */E               preferences_info[i].raised=!preferences_info[i].raised;_P               XDrawBeveledButton(display,&windows->widget,&preferences_info[i]);               break;
             }i         break;       }        case ButtonRelease:,       {>$         if (!windows->widget.mapped)           break;         if (!apply_info.raised)r           {a;             if (event.xbutton.window == windows->widget.id) :               if (MatteIsActive(apply_info,event.xbutton))!                 state|=ExitState; #             apply_info.raised=True;iE             XDrawBeveledButton(display,&windows->widget,&apply_info);d$             apply_info.raised=False;           }           if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton)) !                 state|=ExitState;&$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }u         break;       }d       case ClientMessage:        {t
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {rG             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           }e?         if (*event.xclient.data.l != windows->wm_delete_window)c           break;7         if (event.xclient.window == windows->widget.id)            {,             state|=ExitState;              break;           }          break;       }t       case ConfigureNotify:a       {o
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        {r9         if (event.xcrossing.window != windows->widget.id)m           break;&         state&=(~InactiveWidgetState);         break;       }r       case Expose:       {l7         if (event.xexpose.window != windows->widget.id)_           break;%         if (event.xexpose.count != 0)e           break;!         state|=RedrawWidgetState;r         break;       };       case KeyPress:       {i         static chart!           command[MaxTextLength];f           static KeySym|           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);dE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))W           {p$             apply_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&apply_info);D             state|=ExitState;s             break;           }          break;       }y       case LeaveNotify:i       { 9         if (event.xcrossing.window != windows->widget.id)n           break;#         state|=InactiveWidgetState;e         break;       }        case MotionNotify:       {w
         /*/           Discard pending button motion events.s
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;I         if (apply_info.raised == MatteIsActive(apply_info,event.xmotion)).           {b             /**               Apply button status changed.             */1             apply_info.raised=!apply_info.raised;=E             XDrawBeveledButton(display,&windows->widget,&apply_info);              break;           }rK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))t           {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised;rF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }_         break;       }        default:         break;     }=!   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False);)E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   if (apply_info.raised)     return(False);   /*;     Save user preferences to the client configuration file.=   */0   preferences_database=XrmGetStringDatabase("");6   resource_info->backdrop=!preferences_info[0].raised;6   (void) sprintf(specifier,"%s.backdrop",client_name);3   value=resource_info->backdrop ? "True" : "False";y>   XrmPutStringResource(&preferences_database,specifier,value);:   resource_info->confirm_exit=!preferences_info[1].raised;9   (void) sprintf(specifier,"%s.confirmExit",client_name); 7   value=resource_info->confirm_exit ? "True" : "False";n>   XrmPutStringResource(&preferences_database,specifier,value);4   resource_info->dither=!preferences_info[2].raised;4   (void) sprintf(specifier,"%s.dither",client_name);1   value=resource_info->dither ? "True" : "False";D>   XrmPutStringResource(&preferences_database,specifier,value);)   resource_info->colormap=SharedColormap;s!   if (preferences_info[3].raised)n,     resource_info->colormap=PrivateColormap;6   (void) sprintf(specifier,"%s.colormap",client_name);I   value=resource_info->colormap == SharedColormap ? "Shared" : "Private";x>   XrmPutStringResource(&preferences_database,specifier,value);8   resource_info->use_pixmap=!preferences_info[4].raised;7   (void) sprintf(specifier,"%s.usePixmap",client_name); 5   value=resource_info->use_pixmap ? "True" : "False"; >   XrmPutStringResource(&preferences_database,specifier,value);D   (void) sprintf(filename,"%s%src",PreferencesDefaults,client_name);   ExpandFilename(filename); 4   XrmPutFileDatabase(preferences_database,filename);   return(True);  }  o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %oO %                                                                             % O %   X T e x t V i e w W i d g e t                                             %sO %                                                                             %BO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%I %t@ %  Function XTextViewWidget displays text in a Text View widget. % 0 %  The format of the XTextViewWidget routine is: %sG %    XTextViewWidget(display,resource_info,windows,mono,title,textlist)  % + %  A description of each parameter follows:| %dE %    o display: Specifies a connection to an X server;  returned fromI %      XOpenDisplay. %xK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %*; %    o window: Specifies a pointer to a XWindows structure.  % 8 %    o mono:  Use mono-spaced font when displaying text. %%I %    o title: This character string is displayed at the top of the widget  %      window. %tK %    o textlist: This string list is displayed within the Text View widget.  %  %o */G void XTextViewWidget(display,resource_info,windows,mono,title,textlist)  Display    *display;f  
 XResourceInfol   *resource_info;    XWindows   *windows;r   unsigned int   mono;1   char	   *title,t
   **textlist;a { $ #define DismissButtonText  "Dismiss"     char%     primary_selection[MaxTextLength];      int      status,      x,     y;     register int     i;     unsigned int     height,r
     lines,     text_width,      visible_lines,
     width;     unsigned longn
     delay,
     state;     XEvent
     event;  
   XFontStructh     *font_info,      *text_info;)     XTextPropertya     window_name;  
   XWidgetInfo_     dismiss_info,i     expose_info,     list_info,     north_info,      scroll_info,     selection_info,x     slider_info,     south_info;e     XWindowChanges     window_changes;      /*'     Convert text string to a text list.,   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);!   if (textlist == (char **) NULL)_     {xF       XNoticeWidget(display,windows,"No text to view:",(char *) NULL);
       return;_     }=   /**     Determine Text View widget attributes.   */&   font_info=windows->widget.font_info;!   text_info=(XFontStruct *) NULL;t   if (mono)v4     text_info=XBestFont(display,resource_info,True);(   if (text_info == (XFontStruct *) NULL)(     text_info=windows->widget.font_info;   text_width=0;B.   for (i=0; textlist[i] != (char *) NULL; i++)K     if (XTextWidth(text_info,textlist[i],strlen(textlist[i])) > text_width).G       text_width=XTextWidth(text_info,textlist[i],strlen(textlist[i])); 
   lines=i;J   width=XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));   width+=QuantumMargin;w.   height=text_info->ascent+text_info->descent;   /*     Position Text View widget.   */E   windows->widget.width=Min(text_width,MaxTextWidth)+5*QuantumMargin;s9   windows->widget.min_width=MinTextWidth+4*QuantumMargin;o8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height= L     Min(Max(lines,3),24)*height+((13*height) >> 1)+((9*QuantumMargin) >> 1);   windows->widget.min_height=C9     3*height+((13*height) >> 1)+((9*QuantumMargin) >> 1);w:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2);t4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);w   /*     Map Text View widget.    */,   (void) strcpy(windows->widget.name,title);I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     {s:       XSetWMName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }d-   window_changes.width=windows->widget.width;r/   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x;f%   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);_   windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_lines=0;   delay=SuspendTime << 2;d.   height=font_info->ascent+font_info->descent;!   state=UpdateConfigurationState;f   do   {c)     if (state & UpdateConfigurationState)        {          intn
           id;n  
         /*(           Initialize button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);!         dismiss_info.width=width; ,         dismiss_info.height=(3*height) >> 1;P         dismiss_info.x=windows->widget.width-dismiss_info.width-QuantumMargin-2;P         dismiss_info.y=windows->widget.height-dismiss_info.height-QuantumMargin;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);("         scroll_info.bevel_width--;!         scroll_info.width=height; C         scroll_info.height=dismiss_info.y-((5*QuantumMargin) >> 1); L         scroll_info.x=windows->widget.width-QuantumMargin-scroll_info.width;-         scroll_info.y=(3*QuantumMargin) >> 1;)!         scroll_info.raised=False;n          scroll_info.trough=True;         north_info=scroll_info;.         north_info.raised=True;e8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width;y-         north_info.y+=north_info.bevel_width;l         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;;         visible_lines=(scroll_info.height-(height >> 3)-4)/e<           ((9*(text_info->ascent+text_info->descent)) >> 3);"         if (lines > visible_lines)F           slider_info.height=(visible_lines*slider_info.height)/lines;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;)          list_info.bevel_width--;?         list_info.width=scroll_info.x-((3*QuantumMargin) >> 1);t,         list_info.height=scroll_info.height;"         list_info.x=QuantumMargin;"         list_info.y=scroll_info.y;
         /*+           Initialize selection information.i
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; N         selection_info.height=(9*(text_info->ascent+text_info->descent)) >> 3;%         selection_info.x=list_info.x;.+         state&=(~UpdateConfigurationState);        })"     if (state & RedrawWidgetState)       { 
         /*"           Redraw Text View window.
         */?         XDrawBeveledMatte(display,&windows->widget,&list_info);tA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);(A         XDrawTriangleNorth(display,&windows->widget,&north_info);.B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);iC         XDrawBeveledButton(display,&windows->widget,&dismiss_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);B         selection_info.id=(~0);d         state|=RedrawListState; $         state&=(~RedrawWidgetState);       }       if (state & RedrawListState)       {i
         /*+           Determine slider id and position.n
         */:         if (slider_info.id >= (int) (lines-visible_lines))-           slider_info.id=lines-visible_lines; =         if ((slider_info.id < 0) || (lines <= visible_lines))c           slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (lines != 0)            slider_info.y+=nI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/lines;d0         if (slider_info.id != selection_info.id)           {v             /*/               Redraw scroll bar and file names..             */0             windows->widget.font_info=text_info;N             XSetFont(display,windows->widget.annotate_context,text_info->fid);O             XSetFont(display,windows->widget.highlight_context,text_info->fid);a-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; -             for (i=0; i < visible_lines; i++)w
             { G               selection_info.raised=(slider_info.id+i) != list_info.id;u0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < lines) ?                 selection_info.text=textlist[slider_info.id+i]; H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             } 0             windows->widget.font_info=font_info;N             XSetFont(display,windows->widget.annotate_context,font_info->fid);O             XSetFont(display,windows->widget.highlight_context,font_info->fid);              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {o?                 expose_info.height=slider_info.y-expose_info.y;o?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }h             else               { ?                 expose_info.height=expose_info.y-slider_info.y;,?                 expose_info.y=slider_info.y+slider_info.height+t,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info);.(             expose_info.y=slider_info.y;           }d"         state&=(~RedrawListState);       }a     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)t=       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)X!           if (slider_info.id > 0)(
             {=               /*                 Move slider up.x               */               slider_info.id--; %               state|=RedrawListState; 
             }y         if (!south_info.raised) %           if (slider_info.id < lines)X
             {                /*!                 Move slider down.                */               slider_info.id++; %               state|=RedrawListState;U
             } (         if (event.type != ButtonRelease)           continue;;       }      switch (event.type)a     {o       case ButtonPress:X       {:5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.e             */$             slider_info.active=True;             break;           }i4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)e
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;E               break;
             } 4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < lines) 
             {L               /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++;*%               state|=RedrawListState;l               break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton));           {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_lines-1);             else0               slider_info.id+=(visible_lines-1);#             state|=RedrawListState;d             break;           } 6         if (MatteIsActive(dismiss_info,event.xbutton))           {;             /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);t             break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;l               static Time                click_time;f               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= lines)               break;#             if (id != list_info.id)r               {b                  list_info.id=id;.                 click_time=event.xbutton.time;                 break;               }y             list_info.id=id;?             if (event.xbutton.time >= (click_time+DoubleClick))K               { .                 click_time=event.xbutton.time;                 break;               } *             click_time=event.xbutton.time;             /*4               Become the XA_PRIMARY selection owner.             */D             (void) strcpy(primary_selection,textlist[list_info.id]);E             XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,r"               event.xbutton.time);M             if (XGetSelectionOwner(display,XA_PRIMARY) != windows->widget.id)e               break;#             selection_info.id=(~0);e             list_info.id=id;#             state|=RedrawListState;              break;           }n         break;       }        case ButtonRelease:X       {E$         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {*             /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True;lE             XDrawTriangleNorth(display,&windows->widget,&north_info);            }l         if (!south_info.raised)            {(             /*(               User released down button.             */#             delay=SuspendTime << 2;0#             south_info.raised=True;sE             XDrawTriangleSouth(display,&windows->widget,&south_info);s           }n         if (slider_info.active)_           {i             /*#               Stop tracking slider.e             */%             slider_info.active=False;              break;           } !         if (!dismiss_info.raised)=           {v;             if (event.xbutton.window == windows->widget.id) <               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState; %             dismiss_info.raised=True;yG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);f           }a         break;       }e       case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent,r'               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)s           break;7         if (event.xclient.window == windows->widget.id))           {              state|=ExitState;              break;           }A         break;       }m       case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=!B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:a       {i9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {y7         if (event.xexpose.window != windows->widget.id)n           break;%         if (event.xexpose.count != 0)i           break;!         state|=RedrawWidgetState;e         break;       }        case KeyPress:       {          static char !           command[MaxTextLength];/           static int           length;=           static KeySym            key_symbol;X  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),)/           &key_symbol,(XComposeStatus *) NULL);)         *(command+length)='\0';sE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))a           { &             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              state|=ExitState;              break;           }y1         if (AreaIsActive(scroll_info,event.xkey))            {              /*               Move slider.             */             switch (key_symbol)e
             {)               case XK_Home:                case XK_KP_Home:               {S!                 slider_info.id=0;                  break;               }                case XK_Up:(               case XK_KP_Up:               { !                 slider_info.id--;o                 break;               }x               case XK_Down:                case XK_KP_Down:               {o!                 slider_info.id++;u                 break;               }h               case XK_Prior:               case XK_KP_Prior:                {t.                 slider_info.id-=visible_lines;                 break;               }r               case XK_Next:o               case XK_KP_Next:               {y.                 slider_info.id+=visible_lines;                 break;               }t               case XK_End:               case XK_KP_End:                { %                 slider_info.id=lines;                  break;               }r
             }o#             state|=RedrawListState;i             break;           }          break;       }        case KeyRelease:         break;       case LeaveNotify:,       { 9         if (event.xcrossing.window != windows->widget.id)t           break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));r         if (slider_info.active)%           {%             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(lines*(slider_info.y-slider_info.min_y+1))/ 8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;%             break;           }%(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))            {s             /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;eG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);e             break;           }          break;       }a       case SelectionClear:       {s         list_info.id=(~0);         selection_info.id=(~0);          state|=RedrawListState;w         break;       }r       case SelectionRequest:       {a         XSelectionEventr           notify;h           XSelectionRequestEvent           *request;r  !         if (list_info.id == (~0))            break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));*N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));i$         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState));e-   if (text_info != windows->widget.font_info) !     XFreeFont(display,text_info);t)   XSetCursorState(display,windows,False);(E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);f(   XCheckRefreshWindows(display,windows); }c