 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                       IIIII  M   M   AAA   GGGG  EEEEE                      % O %                         I    MM MM  A   A G      E                          % O %                         I    M M M  AAAAA G  GG  EEE                        % O %                         I    M   M  A   A G   G  E                          % O %                       IIIII  M   M  A   A  GGGG  EEEEE                      % O %                                                                             % O %                                                                             % O %                          ImageMagick Image Routines                         % O %                                                                             % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h"   /*   Forward declarations.  */
 static int9   IntensityCompare _Declare((const void *,const void *)), 5   NoisyCompare _Declare((const void *,const void *));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A l l o c a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function AllocateImage allocates an Image structure and initializes each  %  field to a default value. % . %  The format of the AllocateImage routine is: % 0 %      allocated_image=AllocateImage(image_info) % + %  A description of each parameter follows:  % L %    o allocated_image: Function AllocateImage returns a pointer to an imageL %      structure initialized to default values.  A null image is returned if" %      there is a memory shortage. % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %  %  */  Image *AllocateImage(image_info)	 ImageInfo    *image_info; {    Image      *allocated_image;      /*     Allocate image structure.    */2   allocated_image=(Image *) malloc(sizeof(Image));(   if (allocated_image == (Image *) NULL)     { E       Warning("Unable to allocate image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize Image structure.    */&   allocated_image->file=(FILE *) NULL;    allocated_image->status=False;#   allocated_image->temporary=False; "   *allocated_image->filename='\0';   allocated_image->filesize=0;   allocated_image->pipe=False;0   (void) strcpy(allocated_image->magick,"MIFF");*   allocated_image->comments=(char *) NULL;'   allocated_image->label=(char *) NULL; &   allocated_image->text=(char *) NULL;"   allocated_image->id=UndefinedId;%   allocated_image->class=DirectClass;    allocated_image->matte=False; ;   allocated_image->compression=RunlengthEncodedCompression;    allocated_image->columns=0;    allocated_image->rows=0;&   allocated_image->depth=QuantumDepth;   allocated_image->scene=0; 2   allocated_image->units=2;  /* pixels per inch */%   allocated_image->x_resolution=72.0; %   allocated_image->y_resolution=72.0; )   allocated_image->montage=(char *) NULL; +   allocated_image->directory=(char *) NULL; 1   allocated_image->colormap=(ColorPacket *) NULL;    allocated_image->colors=0;    allocated_image->colorspace=0;0   allocated_image->normalized_maximum_error=0.0;-   allocated_image->normalized_mean_error=0.0; *   allocated_image->mean_error_per_pixel=0;"   allocated_image->total_colors=0;+   allocated_image->signature=(char *) NULL; 3   allocated_image->pixels=(RunlengthPacket *) NULL; 3   allocated_image->packet=(RunlengthPacket *) NULL;    allocated_image->packets=0; !   allocated_image->packet_size=0; 8   allocated_image->packed_pixels=(unsigned char *) NULL;)   *allocated_image->magick_filename='\0'; $   allocated_image->magick_columns=0;!   allocated_image->magick_rows=0; 5   allocated_image->magick_time=time((time_t *) NULL);     allocated_image->orphan=False;+   allocated_image->previous=(Image *) NULL; '   allocated_image->next=(Image *) NULL; '   if (image_info != (ImageInfo *) NULL)      { D       (void) strcpy(allocated_image->filename,image_info->filename);@       (void) strcpy(allocated_image->magick,image_info->magick);     }    return(allocated_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A n n o t a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function AnnotateImage annotates an image with test.  Optionally the K %  annotation can include the image filename, type, width, height, or scene I %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  % " %  produces an image annotation of %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % . %  The format of the AnnotateImage routine is: % 4 %      AnnotateImage(image,font,color,geometry,text) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % H %    o font: The address of a character string containing the text font. % J %    o color: The address of a character string containing the text color. % F %    o geometry: The address of a character string containing the text %      position. % J %    o text: The address of a character string containing the text format. %  %  */2 void AnnotateImage(image,font,color,geometry,text) Image 	   *image;    char   *font,	   *color,    *geometry,   *text; { 	   Display 
     *display;      int      status;      register char      *p,      *q;      unsigned int     indirection,     length;      XAnnotateInfo      annotate_info;  
   XFontStruct      *font_info;      XPixelInfo     pixel_info;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      if (text == (char *) NULL)     return;    indirection=(*text == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*         Read text from a file.       */&       file=(FILE *) fopen(text+1,"r");        if (file == (FILE *) NULL)	         { 5           Warning("Unable to read text file",text+1);            return; 	         }        length=MaxTextLength; #       text=(char *) malloc(length); /       for (q=text ; text != (char *) NULL; q++)        {          c=fgetc(file);         if (c == EOF)            break;!         if ((q-text+1) >= length)            {              *q='\0';             length<<=1; 8             text=(char *) realloc((char *) text,length);&             if (text == (char *) NULL)               break;              q=text+strlen(text);           }          *q=(unsigned char) c;        }        (void) fclose(file);        if (text == (char *) NULL)	         { I           Warning("Unable to annotate image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*'     Allocate and initialize image text.    */	   p=text; $   length=strlen(text)+MaxTextLength;&   image->text=(char *) malloc(length);8   for (q=image->text; image->text != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;0     if ((q-image->text+MaxTextLength) >= length)       {          length<<=1; B         image->text=(char *) realloc((char *) image->text,length);)         if (image->text == (char *) NULL)            break;*         q=image->text+strlen(image->text);       }      /*,       Process formatting characters in text.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);*         q=image->text+strlen(image->text);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);*         q=image->text+strlen(image->text);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); *         q=image->text+strlen(image->text);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } #   if (image->text == (char *) NULL)      { E       Warning("Unable to annotate image","Memory allocation failed"); 
       return;      }    *q++='\0';   *q++='\0';   if (indirection)     free((char *) text);   /*     Open X server connection.    */&   display=XOpenDisplay((char *) NULL);"   if (display == (Display *) NULL)     { K       Warning("Unable to connect to X server",XDisplayName((char *) NULL));        free(image->text);        image->text=(char *) NULL;
       return;      }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); )   resource_info.colormap=PrivateColormap;    /*     Initialize annotate info.    */#   XGetAnnotateInfo(&annotate_info);     if (geometry != (char *) NULL)     { 	       int          flags;         /*         Get position of text.        */F       flags=XParseGeometry(geometry,&annotate_info.x,&annotate_info.y,4         &annotate_info.width,&annotate_info.height);#       if ((flags & XNegative) != 0) (         annotate_info.x+=image->columns;#       if ((flags & YNegative) != 0) %         annotate_info.y+=image->rows;      } $   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    else     {        /*         Initialize visual info.        */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL;        /*         Initialize font info.        */        if (font != (char *) NULL)          resource_info.font=font;8       font_info=XBestFont(display,&resource_info,False);,       if (font_info == (XFontStruct *) NULL):         Warning("Unable to load font",resource_info.font);(       annotate_info.font_info=font_info;@       annotate_info.height=font_info->ascent+font_info->descent;     } 1   if ((map_info == (XStandardColormap *) NULL) || .       (visual_info == (XVisualInfo *) NULL) ||*       (font_info == (XFontStruct *) NULL))     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL);        DestroyImage(image);
       return;      }    /*!     Initialize Standard Colormap.    */H   XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),     map_info);   if (color != (char *) NULL) )     resource_info.foreground_color=color; K   XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,      &pixel_info); F   pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);   pixel_info.annotate_index=1;   /*     Annotate the text image.   */&   for (p=image->text; *p != '\0'; p++)   { P     if ((annotate_info.x >= image->columns) || (annotate_info.y >= image->rows))       break;     annotate_info.text=p;      for (p++; *p != '\0'; p++)       if (*p == '\n')          break;$     if ((p-annotate_info.text) == 1)       { .         annotate_info.y+=annotate_info.height;         continue;        }      *p='\0';     annotate_info.width=J       XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));L     (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",annotate_info.width,<       annotate_info.height,annotate_info.x,annotate_info.y);J     status=XAnnotateImage(display,&pixel_info,&annotate_info,False,image);     if (status == 0)       { F         Warning("Unable to annotate image","Memory allocation error");         break;       } *     annotate_info.y+=annotate_info.height;   }    /*     Free resources.    */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,3     font_info,&resource_info,(XWindowInfo *) NULL);    free(image->text);   image->text=(char *) NULL; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     B l u r I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BlurImage creates a new image that is a copy of an existing J %  one with the pixels blurred.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % F %  BlurImage convolves the pixel neighborhood with this blurring mask: % 
 %     1  2  1 
 %     2  W  2 
 %     1  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the BlurImage routine is: % , %      blurred_image=BlurImage(image,factor) % + %  A description of each parameter follows:  % G %    o blurred_image: Function BlurImage returns a pointer to the image J %      after it is blurred.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */ Image *BlurImage(image,factor) Image 	   *image;    double	   factor;  {  #define Blur(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;     Image      *blurred_image;   
   long int     total_blue,      total_green,     total_red,     weight;      register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     { C       Warning("Unable to blur image","image size must exceed 3x3");        return((Image *) NULL);      }    /*(     Initialize blurred image attributes.   */B   blurred_image=CopyImage(image,image->columns,image->rows,False);&   if (blurred_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } #   blurred_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");"       DestroyImage(blurred_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=blurred_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */*   weight=(long int) ((100.0-factor)/2-13);   quantum=Max(weight+12,1); %   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        s=s0; !       Blur(1);  Blur(2); Blur(1);        s=s1; %       Blur(2); Blur(weight); Blur(2);        s=s2; !       Blur(1);  Blur(2); Blur(1); <       q->red=(Quantum) ((total_red+(quantum >> 1))/quantum);@       q->green=(Quantum) ((total_green+(quantum >> 1))/quantum);>       q->blue=(Quantum) ((total_blue+(quantum >> 1))/quantum);       q->index=s1->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;   }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   return(blurred_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   B o r d e r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BorderImage takes an image and puts a border around it of a I %  particular color.  It allocates the memory necessary for the new Image H %  structure and returns a pointer to the new image.  Set the border and5 %  highlight to the same color to get a solid border.  % , %  The format of the BorderImage routine is: % A %      bordered_image=BorderImage(image,border_info,border_color)  % + %  A description of each parameter follows:  % M %    o bordered_image: Function BorderImage returns a pointer to the bordered H %      image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % I %    o border_info: Specifies a pointer to a XRectangle which defines the  %      border region.  % G %    o border_color: A pointer to a ColorPacket which contains the red, 6 %      green, and blue components of the border color. %  %  */2 Image *BorderImage(image,border_info,border_color) Image 	   *image;   
 RectangleInfo    *border_info;    ColorPacket    *border_color; {    Image      *bordered_image;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      border;      /*)     Initialize bordered image attributes.    */J   bordered_image=CopyImage(image,image->columns+(border_info->width << 1),2     image->rows+(border_info->height << 1),False);'   if (bordered_image == (Image *) NULL)      { C       Warning("Unable to border image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize border color.   */   border.red=border_color->red; #   border.green=border_color->green; !   border.blue=border_color->blue; #   border.index=border_color->index;    border.length=0;   /*(     Copy image and put border around it.   */   q=bordered_image->pixels; )   for (y=0; y < border_info->height; y++) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)    {      /*,       Initialize scanline with border color.     */*     for (x=0; x < border_info->width; x++)       *q++=border;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     }      x=0;K     while (x < (bordered_image->columns-image->columns-border_info->width))      {        *q++=border;
       x++;     }    } O   for (y=(bordered_image->rows-image->rows-border_info->height-1); y >= 0; y--) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   return(bordered_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C u t I m a g e                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ChopImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure and& %  returns a pointer to the new image. % * %  The format of the ChopImage routine is: % , %      chop_image=ChopImage(image,chop_info) % + %  A description of each parameter follows:  % C %    o chop_image: Function ChopImage returns a pointer to the chop J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o chop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */! Image *ChopImage(image,chop_info)  Image 	   *image;   
 RectangleInfo 
   *chop_info;  {    Image      *chopped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check chop geometry.   */4   if (((chop_info->x+(int) chop_info->width) < 0) ||5       ((chop_info->y+(int) chop_info->height) < 0) || .       (chop_info->x > (int) image->columns) ||)       (chop_info->y > (int) image->rows))      { H       Warning("Unable to chop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((chop_info->x+(int) chop_info->width) > (int) image->columns) H     chop_info->width=(unsigned int) ((int) image->columns-chop_info->x);A   if ((chop_info->y+(int) chop_info->height) > (int) image->rows) F     chop_info->height=(unsigned int) ((int) image->rows-chop_info->y);   if (chop_info->x < 0)      { 7       chop_info->width-=(unsigned int) (-chop_info->x);        chop_info->x=0;      }    if (chop_info->y < 0)      { 8       chop_info->height-=(unsigned int) (-chop_info->y);       chop_info->y=0;      }    /*%     Initialize chop image attributes.    */@   chopped_image=CopyImage(image,image->columns-chop_info->width,)     image->rows-chop_info->height,False); &   if (chopped_image == (Image *) NULL)     { A       Warning("Unable to chop image","Memory allocation failed");        return((Image *) NULL);      }    /*     Extract chop image.    */   p=image->pixels;   image->runlength=p->length+1;    q=chopped_image->pixels;"   for (y=0; y < chop_info->y; y++)&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      }    /*%     Skip pixels up to the chop image.    */8   for (x=0; x < (chop_info->height*image->columns); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract chop image.    */D   for (y=0; y < (image->rows-(chop_info->y+chop_info->height)); y++)&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      }    return(chopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o s e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CloseImage closes a file associated with the image.  If the H %  filename prefix is '|', the file is a pipe and is closed with pclose. % + %  The format of the CloseImage routine is:  %  %      CloseImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CloseImage(image) Image 	   *image;  {    /*     Close image file.    */   if (image == (Image *) NULL)     return; #   if (image->file == (FILE *) NULL)      return; $   image->status=ferror(image->file);   if (image->pipe)     (void) pclose(image->file);    else:     if ((image->file != stdin) && (image->file != stdout))!       (void) fclose(image->file);    do   {      image->file=(FILE *) NULL;     image=image->next;   } "   while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m m e n t I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CommentImage initializes an image comment.  Optionally theH %  comment can include the image filename, type, width, height, or sceneI %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  %  %  produces an image comment of  %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % - %  The format of the CommentImage routine is:  % # %      CommentImage(image,comments)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % I %    o comments: The address of a character string containing the comment  %      format. %  %  */! void CommentImage(image,comments)  Image 	   *image;    char   *comments; {    register char      *p,      *q;      unsigned int     indirection,     length;   '   if (image->comments != (char *) NULL) #     free((char *) image->comments);     image->comments=(char *) NULL;    if (comments == (char *) NULL)     return; !   indirection=(*comments == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*"         Read comments from a file.       */*       file=(FILE *) fopen(comments+1,"r");        if (file == (FILE *) NULL)	         { =           Warning("Unable to read comments file",comments+1);            return; 	         }        length=MaxTextLength; '       comments=(char *) malloc(length); 7       for (q=comments ; comments != (char *) NULL; q++)        {          c=fgetc(file);         if (c == EOF)            break;%         if ((q-comments+1) >= length)            {              *q='\0';             length<<=1; @             comments=(char *) realloc((char *) comments,length);*             if (comments == (char *) NULL)               break;(             q=comments+strlen(comments);           }          *q=(unsigned char) c;        }        (void) fclose(file);$       if (comments == (char *) NULL)	         { I           Warning("Unable to comments image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*+     Allocate and initialize image comments.    */
   p=comments; (   length=strlen(comments)+MaxTextLength;*   image->comments=(char *) malloc(length);@   for (q=image->comments; image->comments != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;4     if ((q-image->comments+MaxTextLength) >= length)       {          length<<=1; J         image->comments=(char *) realloc((char *) image->comments,length);-         if (image->comments == (char *) NULL)            break;2         q=image->comments+strlen(image->comments);       }      /*0       Process formatting characters in comments.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);2         q=image->comments+strlen(image->comments);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);2         q=image->comments+strlen(image->comments);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); 2         q=image->comments+strlen(image->comments);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } '   if (image->comments == (char *) NULL)      { D       Warning("Unable to comment image","Memory allocation failed");
       return;      } 
   *q='\0';   if (indirection)     free((char *) comments); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s C o l o r m a p                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressColormap compresses an image colormap removing any %  unused color entries. % 1 %  The format of the CompressColormap routine is:  %  %      CompressColormap(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CompressColormap(image) Image 	   *image;  { 
   ColorPacket      *colormap;     int      number_colors;     register int     i;     register RunlengthPacket     *p;      register unsigned short 
     index;     /*,     Determine if colormap can be compressed.   */"   if (image->class != PseudoClass)     return;    number_colors=image->colors;#   for (i=0; i < image->colors; i++) #     image->colormap[i].flags=False;    image->colors=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { )     if (!image->colormap[p->index].flags)        { 6         image->colormap[p->index].index=image->colors;-         image->colormap[p->index].flags=True;          image->colors++;       }      p++;   } %   if (image->colors == number_colors) $     return;  /* no unused entries */   /*     Compress colormap.   */E   colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket)); '   if (colormap == (ColorPacket *) NULL)      { H       Warning("Unable to compress colormap","Memory allocation failed");"       image->colors=number_colors;
       return;      } #   for (i=0; i < number_colors; i++) !     if (image->colormap[i].flags)        { '         index=image->colormap[i].index; 3         colormap[index].red=image->colormap[i].red; 7         colormap[index].green=image->colormap[i].green; 5         colormap[index].blue=image->colormap[i].blue;        }    /*     Remap pixels.    */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { -     p->index=image->colormap[p->index].index;      p++;   } !   free((char *) image->colormap);    image->colormap=colormap;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressImage compresses an image to the minimum number of %  runlength-encoded packets.  % . %  The format of the CompressImage routine is: %  %      CompressImage(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CompressImage(image)  Image 	   *image;  {    register int     i;     register RunlengthPacket     *p,      *q;      /*     Compress image.    */   if (image == (Image *) NULL)     return;    p=image->pixels;   image->runlength=p->length+1;    image->packets=0;    q=image->pixels;   q->length=MaxRunlength;    if (image->matte) 4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      }    else4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && C           (p->blue == q->blue) && ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    /*H     Runlength-encode only if it takes up less space than no compression.   */8   if (image->compression == RunlengthEncodedCompression)$     if (image->class == DirectClass)       { D         if (image->packets >= ((image->columns*image->rows*3) >> 2))+           image->compression=NoCompression;        }      else@       if (image->packets >= ((image->columns*image->rows) >> 1)))         image->compression=NoCompression;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p o s i t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CompositeImage returns the second image composited onto the " %  first at the specified offsets. % / %  The format of the CompositeImage routine is:  % F %      CompositeImage(image,compose,composite_image,x_offset,y_offset) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 6 %    o compose: Specifies an image composite operator. % A %    o composite_image: The address of a structure of type Image.  % N %    o x_offset: An integer that specifies the column offset of the composited
 %      image.  % K %    o y_offset: An integer that specifies the row offset of the composited 
 %      image.  %  %  */D void CompositeImage(image,compose,composite_image,x_offset,y_offset) Image 	   *image;    unsigned int
   compose;   Image    *composite_image;    int    x_offset,    y_offset;  {    int 	     blue, 
     green,     red;     register int     i,
     index,     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check composite geometry.    */.   if (((x_offset+(int) image->columns) < 0) ||+       ((y_offset+(int) image->rows) < 0) || J       (x_offset > (int) image->columns) || (y_offset > (int) image->rows))     { M       Warning("Unable to composite image","geometry does not contain image"); 
       return;      }    /*     Image must be uncompressed.    */   if (!UncompressImage(image))     return; $   if (compose == ReplaceCompositeOp)     {        /*9         Promote image to DirectClass if colormaps differ.        */&       if (image->class == PseudoClass)2         if (composite_image->class == DirectClass)#           image->class=DirectClass;          else           { 2             if (image->signature == (char *) NULL)'               ColormapSignature(image); <             if (composite_image->signature == (char *) NULL)1               ColormapSignature(composite_image); I             if (strcmp(image->signature,composite_image->signature) != 0) '               image->class=DirectClass;            } 2       if (image->matte && !composite_image->matte)	         { $           p=composite_image->pixels;6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;             p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      }    else     {        /*$         Initialize image matte data.       */       if (!image->matte)	         {            q=image->pixels;           red=q->red;            green=q->green;            blue=q->blue; ,           for (i=0; i < image->packets; i++)           {              q->index=Opaque;             q++;           } #           image->class=DirectClass;            image->matte=True;	         } "       if (!composite_image->matte)	         { $           p=composite_image->pixels;           red=p->red;            green=p->green;            blue=p->blue; 6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;L             if ((p->red == red) && (p->green == green) && (p->blue == blue))#               p->index=Transparent;              p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      }    /*      Initialize composited image.   */   p=composite_image->pixels;)   composite_image->runlength=p->length+1; +   for (y=0; y < composite_image->rows; y++)    { <     if (((y_offset+y) < 0) || ((y_offset+y) >= image->rows))       continue; 9     q=image->pixels+(y_offset+y)*image->columns+x_offset; 0     for (x=0; x < composite_image->columns; x++)     { *       if (composite_image->runlength != 0)%         composite_image->runlength--; 
       else	         {            p++;/           composite_image->runlength=p->length; 	         } A       if (((x_offset+x) < 0) || ((x_offset+x) >= image->columns)) 	         {            q++;           continue; 	         }        switch (compose)       {          case OverCompositeOp:          default:	         { &           if (p->index == Transparent)
             {                red=q->red;                green=q->green;                blue=q->blue;                index=q->index; 
             }            else#             if (p->index == Opaque)                {                  red=p->red;                  green=p->green;                  blue=p->blue;                  index=p->index;                }              else               { J                 red=(int) (p->red*Opaque+q->red*(Opaque-p->index))/Opaque;P                 green=(int) (p->green*Opaque+q->green*(Opaque-p->index))/Opaque;M                 blue=(int) (p->blue*Opaque+q->blue*(Opaque-p->index))/Opaque; P                 index=(int) (p->index*Opaque+q->index*(Opaque-p->index))/Opaque;               }            break;	         }          case InCompositeOp: 	         { -           red=(int) (p->red*q->index)/Opaque; 1           green=(int) (p->green*q->index)/Opaque; /           blue=(int) (p->blue*q->index)/Opaque; 1           index=(int) (p->index*q->index)/Opaque;            break;	         }          case OutCompositeOp:	         { 6           red=(int) (p->red*(Opaque-q->index))/Opaque;:           green=(int) (p->green*(Opaque-q->index))/Opaque;8           blue=(int) (p->blue*(Opaque-q->index))/Opaque;:           index=(int) (p->index*(Opaque-q->index))/Opaque;           break;	         }          case AtopCompositeOp: 	         { F           red=(int) (p->red*q->index+q->red*(Opaque-p->index))/Opaque;L           green=(int) (p->green*q->index+q->green*(Opaque-p->index))/Opaque;I           blue=(int) (p->blue*q->index+q->blue*(Opaque-p->index))/Opaque; L           index=(int) (p->index*q->index+q->index*(Opaque-p->index))/Opaque;           break;	         }          case XorCompositeOp:	         { O           red=(int) (p->red*(Opaque-q->index)+q->red*(Opaque-p->index))/Opaque; N           green=(int) (p->green*(Opaque-q->index)+q->green*(Opaque-p->index))/             Opaque; K           blue=(int) (p->blue*(Opaque-q->index)+q->blue*(Opaque-p->index))/              Opaque; N           index=(int) (p->index*(Opaque-q->index)+q->index*(Opaque-p->index))/             Opaque;            break;	         }          case PlusCompositeOp: 	         { (           red=(int) p->red+(int) q->red;.           green=(int) p->green+(int) q->green;+           blue=(int) p->blue+(int) q->blue; .           index=(int) p->index+(int) q->index;           break;	         }          case MinusCompositeOp:	         { (           red=(int) p->red-(int) q->red;.           green=(int) p->green-(int) q->green;+           blue=(int) p->blue-(int) q->blue;            index=Opaque;            break;	         }          case AddCompositeOp:	         { (           red=(int) p->red+(int) q->red;           if (red > Opaque)              red-=(Opaque+1);.           green=(int) p->green+(int) q->green;           if (green > Opaque)              green-=(Opaque+1);+           blue=(int) p->blue+(int) q->blue;            if (blue > Opaque)             blue-=(Opaque+1); .           index=(int) p->index+(int) q->index;           if (index > Opaque)              index-=(Opaque+1);           break;	         } !         case SubtractCompositeOp: 	         { (           red=(int) p->red-(int) q->red;           if (red < 0)             red+=(Opaque+1);.           green=(int) p->green-(int) q->green;           if (green < 0)             green+=(Opaque+1);+           blue=(int) p->blue-(int) q->blue;            if (blue < 0)              blue+=(Opaque+1); .           index=(int) p->index-(int) q->index;           if (index < 0)             index+=(Opaque+1);           break;	         } #         case DifferenceCompositeOp: 	         { 7           red=AbsoluteValue((int) p->red-(int) q->red); =           green=AbsoluteValue((int) p->green-(int) q->green); :           blue=AbsoluteValue((int) p->blue-(int) q->blue);=           index=AbsoluteValue((int) p->index-(int) q->index);            break;	         }           case ReplaceCompositeOp:	         {            red=p->red;            green=p->green;            blue=p->blue;            index=p->index;            break;	         }          case BlendCompositeOp:	         { =           red=(int) (p->red*p->index+q->red*q->index)/Opaque; C           green=(int) (p->green*p->index+q->green*q->index)/Opaque; @           blue=(int) (p->blue*p->index+q->blue*q->index)/Opaque;           index=Opaque;            break;	         }        }        if (red > MaxRGB)          q->red=MaxRGB;
       else         if (red < 0)           q->red=0;          else           q->red=red;        if (green > MaxRGB)          q->green=MaxRGB;
       else         if (green < 0)           q->green=0;          else           q->green=green;        if (blue > MaxRGB)         q->blue=MaxRGB; 
       else         if (blue < 0)            q->blue=0;         else           q->blue=blue;        if (index > Opaque)          q->index=Opaque;
       else          if (index < Transparent)           q->index=Transparent;          else           q->index=index;        q->length=0;
       q++;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C o n t r a s t I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ContrastImage enhances the intensity differences between the, %  lighter and darker elements of the image. % . %  The format of the ContrastImage routine is: % # %      ContrastImage(image,sharpen)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % C %    o sharpen: If True, the intensity is increased otherwise it is  %      decreased.  %  %  */  ) static void Contrast(sign,red,green,blue)  int    sign;    Quantum    *red, 	   *green,    *blue; {    double     brightness,      hue,     minimum,     saturation, 
     theta;     register double      b,     g,     r;     /*"     Convert RGB to HSV colorspace.   */
   hue=(-1.0);    saturation=0.0; $   r=(double) (*red)/(double) MaxRGB;&   g=(double) (*green)/(double) MaxRGB;%   b=(double) (*blue)/(double) MaxRGB; 
   if (r >= g)      {        if (r >= b)          brightness=r; 
       else         brightness=b;      }    else     if (g >= b)        brightness=g;      else       brightness=b; 
   if (r <= g)      {        if (r <= b)          minimum=r;
       else         minimum=b;     }    else     if (g <= b)        minimum=g;     else       minimum=b;   if (brightness != 0.0)/     saturation=(brightness-minimum)/brightness;    if (saturation != 0.0)     {        if (r == brightness)'         hue=(g-b)/(brightness-minimum); 
       else         if (g == brightness)-           hue=2.0+(b-r)/(brightness-minimum);          else           if (b == brightness)/             hue=4.0+(r-g)/(brightness-minimum);        hue=hue*60.0;        if (hue < 0.0)         hue+=360.0;      }    /*K     Enhance contrast: dark color become darker, light color become lighter.    */   theta=(brightness-0.5)*M_PI;?   brightness+=(((((sin(theta)+1.0))*0.5)-brightness)*sign)*0.5;    if (brightness > 1.0)      brightness=1.0;    else     if (brightness < 0)        brightness=0.0;    /*     Convert HSV to RGB   */   r=brightness;    g=brightness;    b=brightness; +   if ((hue != -1.0) && (saturation != 0.0))      {        double
         f,
         j,
         k,
         l,
         v;  	       int 
         i;         if (hue == 360.0)          hue=0.0;       hue=hue/60.0;        i=floor(hue);        if (i < 0)         i=0;       f=hue-i;$       j=brightness*(1.0-saturation);(       k=brightness*(1.0-(saturation*f));.       l=brightness*(1.0-(saturation*(1.0-f)));       v=brightness;        switch (i)       { )         case 0:  r=v;  g=l;  b=j;  break; )         case 1:  r=k;  g=v;  b=j;  break; )         case 2:  r=j;  g=v;  b=l;  break; )         case 3:  r=j;  g=k;  b=v;  break; )         case 4:  r=l;  g=j;  b=v;  break; )         case 5:  r=v;  g=j;  b=k;  break;        }      } 0   *red=(Quantum) floor((r*(double) MaxRGB)+0.5);2   *green=(Quantum) floor((g*(double) MaxRGB)+0.5);1   *blue=(Quantum) floor((b*(double) MaxRGB)+0.5);  }   ! void ContrastImage(image,sharpen)  Image 	   *image;    unsigned int
   sharpen; {    int 	     sign;      register int     i;     register RunlengthPacket     *p;      sign=sharpen ? 1 : -1;   switch (image->class)    {      case DirectClass:      {        /*+         Contrast enhance DirectClass image.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { 2         Contrast(sign,&p->red,&p->green,&p->blue);         p++;       }        break;     }      case PseudoClass:      {        /*+         Contrast enhance PseudoClass image.        */'       for (i=0; i < image->colors; i++) H         Contrast(sign,&image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o p y I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function CopyImage returns a copy of all fields of the input image.  The B %  the pixel memory is allocated but the pixel data is not copied. % * %  The format of the CopyImage routine is: % ; %      copy_image=CopyImage(image,columns,rows,copy_pixels)  % + %  A description of each parameter follows:  % J %    o copy_image: Function CopyImage returns a pointer to the image afterH %      copying.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the copied 
 %      image.  % G %    o rows: An integer that specifies the number of rows in the copied 
 %      image.  % H %    o copy_pixels: Specifies whether the pixel data is copied.  Must be %      either True or False; %  %  */0 Image *CopyImage(image,columns,rows,copy_pixels) Image 	   *image;    unsigned int
   columns,   rows,    copy_pixels; {    Image      *copy_image;     register int     i;     /*     Allocate image structure.    */-   copy_image=(Image *) malloc(sizeof(Image)); #   if (copy_image == (Image *) NULL)      return((Image *) NULL);    *copy_image=(*image); '   if (image->comments != (char *) NULL)      {        /*-         Allocate and copy the image comments.        */#       copy_image->comments=(char *) 9         malloc((unsigned int) strlen(image->comments)+1); 0       if (copy_image->comments == (char *) NULL)         return((Image *) NULL); :       (void) strcpy(copy_image->comments,image->comments);     } $   if (image->label != (char *) NULL)     {        /**         Allocate and copy the image label.       */O       copy_image->label=(char *) malloc((unsigned int) strlen(image->label)+1); -       if (copy_image->label == (char *) NULL)          return((Image *) NULL); 4       (void) strcpy(copy_image->label,image->label);     }    copy_image->columns=columns;   copy_image->rows=rows;$   copy_image->montage=(char *) NULL;&   copy_image->directory=(char *) NULL;.   if (image->colormap != (ColorPacket *) NULL)     {        /*-         Allocate and copy the image colormap.        */*       copy_image->colormap=(ColorPacket *)2         malloc(image->colors*sizeof(ColorPacket));7       if (copy_image->colormap == (ColorPacket *) NULL)          return((Image *) NULL); '       for (i=0; i < image->colors; i++) 3         copy_image->colormap[i]=image->colormap[i];      } (   if (image->signature != (char *) NULL)     {        /*.         Allocate and copy the image signature.       */$       copy_image->signature=(char *):         malloc((unsigned int) strlen(image->signature)+1);1       if (copy_image->signature == (char *) NULL)          return((Image *) NULL); <       (void) strcpy(copy_image->signature,image->signature);     }    /*     Allocate the image pixels.   */   if (copy_pixels)*     copy_image->pixels=(RunlengthPacket *)D       malloc((unsigned int) image->packets*sizeof(RunlengthPacket));   else     { ?       copy_image->packets=copy_image->columns*copy_image->rows; ,       copy_image->pixels=(RunlengthPacket *)K         malloc((unsigned int) copy_image->packets*sizeof(RunlengthPacket));      } 5   if (copy_image->pixels == (RunlengthPacket *) NULL)      return((Image *) NULL);    if (copy_pixels)     {        register RunlengthPacket         *p,          *q;          /*         Copy the image pixels.       */       p=image->pixels;       q=copy_image->pixels; (       for (i=0; i < image->packets; i++)       {          *q=(*p);         p++;         q++;       }      }    if (image->orphan)     { %       copy_image->file=(FILE *) NULL; *       copy_image->previous=(Image *) NULL;&       copy_image->next=(Image *) NULL;     }    else     {        /*#         Link image into image list.        */1       if (copy_image->previous != (Image *) NULL) .         copy_image->previous->next=copy_image;-       if (copy_image->next != (Image *) NULL) .         copy_image->next->previous=copy_image;     }    copy_image->orphan=False;    return(copy_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C r o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function CropImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure andM %  returns a pointer to the new image.  This routine is optimized to perserve K %  the runlength encoding.  That is, the cropped image will always use less  %  memory than the original. % * %  The format of the CropImage routine is: % / %      cropped_image=CropImage(image,crop_info)  % + %  A description of each parameter follows:  % I %    o cropped_image: Function CropImage returns a pointer to the cropped J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o crop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */! Image *CropImage(image,crop_info)  Image 	   *image;   
 RectangleInfo 
   *crop_info;  {    Image      *cropped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check crop geometry.   */4   if (((crop_info->x+(int) crop_info->width) < 0) ||5       ((crop_info->y+(int) crop_info->height) < 0) || .       (crop_info->x > (int) image->columns) ||)       (crop_info->y > (int) image->rows))      { H       Warning("Unable to crop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((crop_info->x+(int) crop_info->width) > (int) image->columns) H     crop_info->width=(unsigned int) ((int) image->columns-crop_info->x);A   if ((crop_info->y+(int) crop_info->height) > (int) image->rows) F     crop_info->height=(unsigned int) ((int) image->rows-crop_info->y);   if (crop_info->x < 0)      { 7       crop_info->width-=(unsigned int) (-crop_info->x);        crop_info->x=0;      }    if (crop_info->y < 0)      { 8       crop_info->height-=(unsigned int) (-crop_info->y);       crop_info->y=0;      } :   if ((crop_info->width == 0) && (crop_info->height == 0))     {        register int
         i;         RunlengthPacket          corners[4];          /*1         Set bounding box to the image dimensions.        */       crop_info->width=0;        crop_info->height=0;"       crop_info->x=image->columns;       crop_info->y=image->rows;        p=image->pixels;#       image->runlength=p->length+1;        corners[0]=(*p);7       for (i=1; i <= (image->rows*image->columns); i++)        { "         if (image->runlength != 0)           image->runlength--;          else           {              p++;'             image->runlength=p->length;            }           if (i == image->columns)           corners[1]=(*p);?         if (i == (image->rows*image->columns-image->columns+1))            corners[2]=(*p);.         if (i == (image->rows*image->columns))           corners[3]=(*p);       }        p=image->pixels;#       image->runlength=p->length+1; %       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { $           if (image->runlength != 0)             image->runlength--;            else
             {                p++;)               image->runlength=p->length; 
             } +           if ((p->red != corners[0].red) || /               (p->green != corners[0].green) || +               (p->blue != corners[0].blue)) !             if (x < crop_info->x)                crop_info->x=x; +           if ((p->red != corners[1].red) || /               (p->green != corners[1].green) || +               (p->blue != corners[1].blue)) %             if (x > crop_info->width) !               crop_info->width=x; +           if ((p->red != corners[2].red) || /               (p->green != corners[2].green) || +               (p->blue != corners[2].blue)) !             if (y < crop_info->y)                crop_info->y=y; +           if ((p->red != corners[3].red) || /               (p->green != corners[3].green) || +               (p->blue != corners[3].blue)) &             if (y > crop_info->height)"               crop_info->height=y;	         }        } '       crop_info->width-=crop_info->x-1; (       crop_info->height-=crop_info->y-1;     } :   if ((crop_info->width == 0) || (crop_info->height == 0))     { E       Warning("Unable to crop image","geometry dimensions are zero");        return((Image *) NULL);      }    /*(     Initialize cropped image attributes.   */I   cropped_image=CopyImage(image,crop_info->width,crop_info->height,True); &   if (cropped_image == (Image *) NULL)     { A       Warning("Unable to crop image","Memory allocation failed");        return((Image *) NULL);      }    /*(     Skip pixels up to the cropped image.   */   p=image->pixels;   image->runlength=p->length+1; @   for (x=0; x < (crop_info->y*image->columns+crop_info->x); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract cropped image.   */   cropped_image->packets=0;    q=cropped_image->pixels;   q->red=0; 
   q->green=0;    q->blue=0;
   q->index=0;    q->length=MaxRunlength; -   for (y=0; y < (cropped_image->rows-1); y++)    {      /*       Transfer scanline.     */.     for (x=0; x < cropped_image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { *           if (cropped_image->packets != 0)             q++;#           cropped_image->packets++;            *q=(*p);           q->length=0;	         }      }      /*       Skip to next scanline.     */?     for (x=0; x < (image->columns-cropped_image->columns); x++)         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }    }    /*     Transfer last scanline.    */,   for (x=0; x < cropped_image->columns; x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        } 7     if ((p->red == q->red) && (p->green == q->green) && 9         (p->blue == q->blue) && (p->index == q->index) && )         ((int) q->length < MaxRunlength))        q->length++;     else       { (         if (cropped_image->packets != 0)           q++;!         cropped_image->packets++;          *q=(*p);         q->length=0;       }    } <   cropped_image->pixels=(RunlengthPacket *) realloc((char *)J     cropped_image->pixels,cropped_image->packets*sizeof(RunlengthPacket));   return(cropped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s c r i b e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DescribeImage describes an image by printing its attributes to
 %  stderr. % . %  The format of the DescribeImage routine is: %  %      DescribeImage(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DescribeImage(image)  Image 	   *image;  {    /**     Display detailed info about the image.   */&   if (*image->magick_filename != '\0')<     if (strcmp(image->magick_filename,image->filename) != 0);       (void) fprintf(stderr,"%s=>",image->magick_filename); P    if ((image->previous == (Image *) NULL) && (image->next == (Image *) NULL) &&        (image->scene == 0)) 1     (void) fprintf(stderr,"%s ",image->filename);    elseB     (void) fprintf(stderr,"%s[%u] ",image->filename,image->scene);@   if ((image->magick_columns != 0) || (image->magick_rows != 0))4     if ((image->magick_columns != image->columns) ||,         (image->magick_rows != image->rows))P       (void) fprintf(stderr,"%ux%u=>",image->magick_columns,image->magick_rows);=   (void) fprintf(stderr,"%ux%u ",image->columns,image->rows); "   if (image->class == DirectClass)     { ,       (void) fprintf(stderr,"DirectClass ");#       if (image->total_colors != 0) ;         (void) fprintf(stderr,"%luc ",image->total_colors);      }    else-     if (image->total_colors <= image->colors) >       (void) fprintf(stderr,"PseudoClass %uc ",image->colors);     else       { J         (void) fprintf(stderr,"PseudoClass %lu=>%uc ",image->total_colors,           image->colors); K         (void) fprintf(stderr,"%u/%.6f/%.6fe ",image->mean_error_per_pixel, H           image->normalized_mean_error,image->normalized_maximum_error);       }    if (image->filesize != 0) 3     (void) fprintf(stderr,"%lub ",image->filesize); H   (void) fprintf(stderr,"%s %lds\n",image->magick,time((time_t *) NULL)-     image->magick_time+1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     D e s p e c k l e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function DespeckleImage creates a new image that is a copy of an existingH %  one with the speckle noise reduced.  It uses the eight hull algorithmO %  described in Applied Optics, Vol. 24, No. 10, 15 May 1985, "Geometric filter L %  for Speckle Reduction", by Thomas R Crimmins.  Each pixel in the image isN %  replaced by one of its eight of its surrounding pixels using a polarity andM %  negative hull function.  DespeckleImage allocates the memory necessary for B %  the new Image structure and returns a pointer to the new image. % / %  The format of the DespeckleImage routine is:  % - %      despeckled_image=DespeckleImage(image)  % + %  A description of each parameter follows:  % O %    o despeckled_image: Function DespeckleImage returns a pointer to the image M %      after it is despeckled.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  = static void Hull(x_offset,y_offset,polarity,columns,rows,f,g)  int    x_offset,    y_offset,    polarity;    unsigned int
   columns,   rows;    Quantum    *f,    *g;  {    int      y;     register int     x;     register Quantum     *p,      *q,      *r,      *s;   	   Quantum      v;     p=f+(columns+2);   q=g+(columns+2);,   r=p+(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*p);          if (*r > v)            v++;
         *q=v;          p++;         q++;         r++;       }      else!       for (x=0; x < columns; x++)        {          v=(*p); !         if (v > (Quantum) (*r+1))            v--;
         *q=v;          p++;         q++;         r++;       }      p++;     q++;     r++;   }    p=f+(columns+2);   q=g+(columns+2);,   r=q+(y_offset*((int) columns+2)+x_offset);,   s=q-(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     s++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) > v) && (*r > v))            v++;
         *p=v;          p++;         q++;         r++;         s++;       }      else!       for (x=0; x < columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) < v) && (*r < v))            v--;
         *p=v;          p++;         q++;         r++;         s++;       }      p++;     q++;     r++;     s++;   }  }    Image *DespeckleImage(image) Image 	   *image;  {    Image      *despeckled_image;     int      x;  	   Quantum      *blue_channel,     *buffer,     *green_channel,      *matte_channel,      *red_channel;      register int     i,     j;     register RunlengthPacket     *p,      *q;      static int     X[4]= {0, 1, 1,-1},      Y[4]= {1, 0, 1, 1};      unsigned int     packets;     /*     Allocate despeckled image.   */E   despeckled_image=CopyImage(image,image->columns,image->rows,False); )   if (despeckled_image == (Image *) NULL)      { F       Warning("Unable to despeckle image","Memory allocation failed");       return((Image *) NULL);      } &   despeckled_image->class=DirectClass;   /*     Allocate image buffers.    */-   packets=(image->columns+2)*(image->rows+2); :   red_channel=(Quantum *) malloc(packets*sizeof(Quantum));<   green_channel=(Quantum *) malloc(packets*sizeof(Quantum));;   blue_channel=(Quantum *) malloc(packets*sizeof(Quantum)); <   matte_channel=(Quantum *) malloc(packets*sizeof(Quantum));5   buffer=(Quantum *) malloc(packets*sizeof(Quantum)); *   if ((red_channel == (Quantum *) NULL) ||,       (green_channel == (Quantum *) NULL) ||+       (blue_channel == (Quantum *) NULL) || ,       (matte_channel == (Quantum *) NULL) ||>       (buffer == (Quantum *) NULL) || !UncompressImage(image))     { F       Warning("Unable to despeckle image","Memory allocation failed");%       DestroyImage(despeckled_image);        return((Image *) NULL);      }    /*     Zero image buffers.    */   for (i=0; i < packets; i++)    {      red_channel[i]=0;      green_channel[i]=0;      blue_channel[i]=0;     matte_channel[i]=0;      buffer[i]=0;   }    /*0     Copy image pixels to color component buffers   */   x=image->columns+2;    p=image->pixels;!   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        red_channel[x]=p->red;        green_channel[x]=p->green;       blue_channel[x]=p->blue;        matte_channel[x]=p->index;
       x++;
       p++;     }      x++;   }    /*"     Reduce speckle in red channel.   */   for (i=0; i < 4; i++)    { D     Hull(X[i],Y[i],1,image->columns,image->rows,red_channel,buffer);F     Hull(-X[i],-Y[i],1,image->columns,image->rows,red_channel,buffer);G     Hull(-X[i],-Y[i],-1,image->columns,image->rows,red_channel,buffer); E     Hull(X[i],Y[i],-1,image->columns,image->rows,red_channel,buffer);    }    /*$     Reduce speckle in green channel.   */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { F     Hull(X[i],Y[i],1,image->columns,image->rows,green_channel,buffer);H     Hull(-X[i],-Y[i],1,image->columns,image->rows,green_channel,buffer);I     Hull(-X[i],-Y[i],-1,image->columns,image->rows,green_channel,buffer); G     Hull(X[i],Y[i],-1,image->columns,image->rows,green_channel,buffer);    }    /*#     Reduce speckle in blue channel.    */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { E     Hull(X[i],Y[i],1,image->columns,image->rows,blue_channel,buffer); G     Hull(-X[i],-Y[i],1,image->columns,image->rows,blue_channel,buffer); H     Hull(-X[i],-Y[i],-1,image->columns,image->rows,blue_channel,buffer);F     Hull(X[i],Y[i],-1,image->columns,image->rows,blue_channel,buffer);   }    /*5     Copy color component buffers to despeckled image.    */   x=image->columns+2;    q=despeckled_image->pixels; !   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        q->red=red_channel[x];        q->green=green_channel[x];       q->blue=blue_channel[x];        q->index=matte_channel[x];       q->length=0;
       q++;
       x++;     }      x++;   }    /*     Free memory.   */   free((char *) buffer);   free((char *) blue_channel);   free((char *) green_channel);    free((char *) red_channel);    return(despeckled_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function DestroyImage deallocates memory associated with an image.  % - %  The format of the DestroyImage routine is:  %  %      DestroyImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DestroyImage(image) Image 	   *image;  {    if (image == (Image *) NULL)     return;    /*     Close image.   */   CloseImage(image);   /*"     Deallocate the image comments.   */'   if (image->comments != (char *) NULL) #     free((char *) image->comments);    /*     Deallocate the image label.    */$   if (image->label != (char *) NULL)      free((char *) image->label);   /*+     Deallocate the image montage directory.    */&   if (image->montage != (char *) NULL)"     free((char *) image->montage);(   if (image->directory != (char *) NULL)$     free((char *) image->directory);   /*"     Deallocate the image colormap.   */.   if (image->colormap != (ColorPacket *) NULL)#     free((char *) image->colormap);    /*#     Deallocate the image signature.    */(   if (image->signature != (char *) NULL)$     free((char *) image->signature);   /*      Deallocate the image pixels.   */0   if (image->pixels != (RunlengthPacket *) NULL)!     free((char *) image->pixels); 5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);   /*#     Deallocate the image structure.    */   free((char *) image);    image=(Image *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DestroyImages deallocates memory associated with a linked list
 %  of images.  % . %  The format of the DestroyImages routine is: %  %      DestroyImages(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DestroyImages(image)  Image 	   *image;  {    Image      *next_image;     if (image == (Image *) NULL)     return;    /*)     Proceed to the top of the image list.    */+   while (image->previous != (Image *) NULL)      image=image->previous;   do   {      /*       Destroy this image.      */     next_image=image->next;      DestroyImage(image);     image=next_image; $   } while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E m b o s s I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function EmbossImage creates a new image that is a copy of an existing L %  one with the edge highlighted.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % N %  EmbossImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1 -2  0 
 %    -2  0  2 
 %     0  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % , %  The format of the EmbossImage routine is: % ( %      embossed_image=EmbossImage(image) % + %  A description of each parameter follows:  % J %    o embossed_image: Function EmbossImage returns a pointer to the imageK %      after it is embossed.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ Image *EmbossImage(image)  Image 	   *image;  {  #define Emboss(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;     Image      *embossed_image;  
   long int     total_blue,      total_green,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to emboss image","image size must exceed 3x3");        return((Image *) NULL);      }    /*)     Initialize embossed image attributes.    */C   embossed_image=CopyImage(image,image->columns,image->rows,False); '   if (embossed_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   embossed_image->class=DirectClass;   /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(embossed_image);        return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=embossed_image->pixels; $   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */%   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0; 
       s=s1+1;        s=s0; )       Emboss(-1); Emboss(-2); Emboss( 0);        s=s1; )       Emboss(-2); Emboss( 0); Emboss( 2);        s=s2; )       Emboss( 0); Emboss( 2); Emboss( 1); !       total_red+=(MaxRGB+1) >> 1;        if (total_red < 0)         total_red=0;
       else         if (total_red > MaxRGB)            total_red=MaxRGB; #       total_green+=(MaxRGB+1) >> 1;        if (total_green < 0)         total_green=0;
       else!         if (total_green > MaxRGB)            total_green=MaxRGB; "       total_blue+=(MaxRGB+1) >> 1;       if (total_blue < 0)          total_blue=0; 
       else          if (total_blue > MaxRGB)           total_blue=MaxRGB;!       q->red=(Quantum) total_red; %       q->green=(Quantum) total_green; #       q->blue=(Quantum) total_blue;        q->index=s1->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;   }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*-     Convert image to Grayscale and normalize.    */$   embossed_image->class=DirectClass;%   (void) IsGrayImage(embossed_image); !   NormalizeImage(embossed_image);    return(embossed_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E d g e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function EdgeImage creates a new image that is a copy of an existing M %  one with the edges highlighted.  It allocates the memory necessary for the > %  new Image structure and returns a pointer to the new image. % L %  EdgeImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1 -2  0 
 %    -2  0  2 
 %     0  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the EdgeImage routine is: % # %      edged_image=EdgeImage(image)  % + %  A description of each parameter follows:  % E %    o edged_image: Function EdgeImage returns a pointer to the image H %      after it is edged.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ Image *EdgeImage(image)  Image 	   *image;  {  #define Edge(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;     Image      *edged_image;   
   long int     total_blue,      total_green,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to detect edges","image size must exceed 3x3");        return((Image *) NULL);      }    /*&     Initialize edged image attributes.   */@   edged_image=CopyImage(image,image->columns,image->rows,False);$   if (edged_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } !   edged_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");        DestroyImage(edged_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=edged_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */%   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0; 
       s=s1+1;        s=s0; #       Edge(-1); Edge(-2); Edge( 0);        s=s1; #       Edge(-2); Edge( 0); Edge( 2);        s=s2; #       Edge( 0); Edge( 2); Edge( 1);        if (total_red < 0)         total_red=(-total_red);        if (total_red > MaxRGB)          total_red=MaxRGB;        if (total_green < 0)#         total_green=(-total_green);        if (total_green > MaxRGB)          total_green=MaxRGB;        if (total_blue < 0) !         total_blue=(-total_blue);        if (total_blue > MaxRGB)         total_blue=MaxRGB;!       q->red=(Quantum) total_red; %       q->green=(Quantum) total_green; #       q->blue=(Quantum) total_blue;        q->index=s1->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;   }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*     Normalize image.   */   NormalizeImage(edged_image);   return(edged_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E n h a n c e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EnhanceImage creates a new image that is a copy of an existingM %  one with the noise reduced.  It allocates the memory necessary for the new : %  Image structure and returns a pointer to the new image. % K %  EnhanceImage does a weighted average of pixels in a 5x5 cell around each L %  target pixel.  Only pixels in the 5x5 cell that are within a RGB distance. %  threshold of the target pixel are averaged. % G %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % - %  The format of the EnhanceImage routine is:  % ) %      enhanced_image=EnhanceImage(image)  % + %  A description of each parameter follows:  % K %    o enhanced_image: Function EnhanceImage returns a pointer to the image K %      after it is enhanced.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ Image *EnhanceImage(image) Image 	   *image;  {  #define Enhance(weight) \ $   distance=(int) s->red-(int) red; \'   distance_squared=squares[distance]; \ (   distance=(int) s->green-(int) green; \(   distance_squared+=squares[distance]; \&   distance=(int) s->blue-(int) blue; \(   distance_squared+=squares[distance]; \%   if (distance_squared < Threshold) \      { \ %       total_red+=(weight)*(s->red); \ )       total_green+=(weight)*(s->green); \ '       total_blue+=(weight)*(s->blue); \        total_weight+=(weight); \      } \    s++; #define Threshold  2500      double     distance_squared;      Image      *enhanced_image;     int 
     distance,      i;  	   Quantum 	     blue, 
     green,     red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2,     *s3,     *s4;     register unsigned int 
     *squares;      RunlengthPacket      *scanline;     unsigned int     x,     y;     unsigned long      total_blue,      total_green,     total_red,     total_weight;   0   if ((image->columns < 5) || (image->rows < 5))     { F       Warning("Unable to enhance image","image size must exceed 4x4");       return((Image *) NULL);      }    /*)     Initialize enhanced image attributes.    */C   enhanced_image=CopyImage(image,image->columns,image->rows,False); '   if (enhanced_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   enhanced_image->class=DirectClass;   /*6     Allocate scan line buffer for 5 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(5*image->columns*sizeof(RunlengthPacket));J   squares=(unsigned int *) malloc((MaxRGB+MaxRGB+1)*sizeof(unsigned int));/   if ((scanline == (RunlengthPacket *) NULL) || )       (squares == (unsigned int *) NULL))      { D       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(enhanced_image);        return((Image *) NULL);      }    squares+=MaxRGB;%   for (i=(-MaxRGB); i <= MaxRGB; i++)      squares[i]=i*i;    /*'     Read the first 4 rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; (   for (x=0; x < (image->columns*4); x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*$     Dump first 2 scanlines of image.   */   q=enhanced_image->pixels; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    /*     Enhance each row.    */%   for (y=2; y < (image->rows-2); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-2) % 5); +     s1=scanline+image->columns*((y-1) % 5); '     s2=scanline+image->columns*(y % 5); +     s3=scanline+image->columns*((y+1) % 5); +     s4=scanline+image->columns*((y+2) % 5);      /*       Read another scan line.      */	     s=s4; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*.       Transfer first 2 pixels of the scanline.     */	     s=s2;      for (x=0; x < 2; x++)      {        *q=(*s);       q->length=0;
       q++;
       s++;     } *     for (x=2; x < (image->columns-2); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        total_weight=0; 
       s=s2+2;        red=s->red;        green=s->green;        blue=s->blue;        s=s0; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5);        s=s1; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=s2; F       Enhance(10); Enhance(40); Enhance(80); Enhance(40); Enhance(10);       s=s3; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=s4; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5); H       q->red=(Quantum) ((total_red+(total_weight >> 1)-1)/total_weight);M       q->green= (Quantum) ((total_green+(total_weight >> 1)-1)/total_weight); J       q->blue=(Quantum) ((total_blue+(total_weight >> 1)-1)/total_weight);       q->index=s2->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;        s3++;        s4++;      }      /*-       Transfer last 2 pixels of the scanline.      */	     s=s2;      for (x=0; x < 2; x++)      {        *q=(*s);       q->length=0;
       q++;
       s++;     }    }    /*$     Dump last 2 scanlines of pixels.   */$   s=scanline+image->columns*(y % 5);+   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    squares-=MaxRGB;   free((char *) squares);    free((char *) scanline);   return(enhanced_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E q u a l i z e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EqualizeImage performs histogram equalization on the reference	 %  image.  % . %  The format of the EqualizeImage routine is: %  %      EqualizeImage(image)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ void EqualizeImage(image)  Image 	   *image;  { 	   Quantum      *equalize_map;     register int     i,     j;     register RunlengthPacket     *p;      unsigned int	     high,      *histogram,      low,	     *map;      /*-     Allocate and initialize histogram arrays.    */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); ?   map=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); >   equalize_map=(Quantum *) malloc((MaxRGB+1)*sizeof(Quantum));O   if ((histogram == (unsigned int *) NULL) || (map == (unsigned int *) NULL) || )       (equalize_map == (Quantum *) NULL))      { E       Warning("Unable to equalize image","Memory allocation failed"); 
       return;      }    /*     Form histogram.    */   for (i=0; i <= MaxRGB; i++)      histogram[i]=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)   { ,     histogram[Intensity(*p)]+=(p->length+1);     p++;   }    /*8     Integrate the histogram to get the equalization map.   */   j=0;   for (i=0; i <= MaxRGB; i++)    {      j+=histogram[i];
     map[i]=j;    }    free((char *) histogram);    if (map[MaxRGB] == 0)      { "       free((char *) equalize_map);       free((char *) map); 
       return;      }    /*
     Equalize.    */
   low=map[0];    high=map[MaxRGB];    for (i=0; i <= MaxRGB; i++)      equalize_map[i]=(Quantum) 9       ((((double) (map[i]-low))*MaxRGB)/Max(high-low,1));    free((char *) map);    /*     Stretch the histogram.   */   switch (image->class)    {      case DirectClass:      {        /*%         Equalize DirectClass packets.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { $         p->red=equalize_map[p->red];(         p->green=equalize_map[p->green];&         p->blue=equalize_map[p->blue];         p++;       }        break;     }      case PseudoClass:      {        /*%         Equalize PseudoClass packets.        */'       for (i=0; i < image->colors; i++)        { D         image->colormap[i].red=equalize_map[image->colormap[i].red];H         image->colormap[i].green=equalize_map[image->colormap[i].green];F         image->colormap[i].blue=equalize_map[image->colormap[i].blue];       }        SyncImage(image);        break;     }    }    free((char *) equalize_map); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F l i p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function FlipImage creates a new image that reflects each scanline in theI %  vertical direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % * %  The format of the FlipImage routine is: % % %      flipped_image=FlipImage(image)  % + %  A description of each parameter follows:  % G %    o flipped_image: Function FlipImage returns a pointer to the image G %      after reflecting.  A null image is returned if there is a memory  %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *FlipImage(image)  Image 	   *image;  {    Image      *flipped_image;      register RunlengthPacket     *p,      *q,      *s;      register unsigned int      x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flipped image attributes.   */B   flipped_image=CopyImage(image,image->columns,image->rows,False);&   if (flipped_image == (Image *) NULL)     { A       Warning("Unable to flip image","Memory allocation failed");        return((Image *) NULL);      }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flipped_image);       return((Image *) NULL);      }    /*     Flip each row.   */   p=image->pixels;   image->runlength=p->length+1; 3   q=flipped_image->pixels+flipped_image->packets-1; )   for (y=0; y < flipped_image->rows; y++)    {      /*       Read a scan line.      */     s=scanline; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*       Flip each column.      */     s=scanline+image->columns;.     for (x=0; x < flipped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q--;     }    }    free((char *) scanline);   return(flipped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F l o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function FlopImage creates a new image that reflects each scanline in theK %  horizontal direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % * %  The format of the FlopImage routine is: % % %      flopped_image=FlopImage(image)  % + %  A description of each parameter follows:  % G %    o flopped_image: Function FlopImage returns a pointer to the image G %      after reflecting.  A null image is returned if there is a memory  %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *FlopImage(image)  Image 	   *image;  {    Image      *flopped_image;      register RunlengthPacket     *p,      *q,      *s;      register unsigned int      x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flopped image attributes.   */B   flopped_image=CopyImage(image,image->columns,image->rows,False);&   if (flopped_image == (Image *) NULL)     { D       Warning("Unable to reflect image","Memory allocation failed");       return((Image *) NULL);      }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flopped_image);       return((Image *) NULL);      }    /*     Flop each row.   */   p=image->pixels;   image->runlength=p->length+1;    q=flopped_image->pixels;)   for (y=0; y < flopped_image->rows; y++)    {      /*       Read a scan line.      */     s=scanline; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*       Flop each column.      */     s=scanline+image->columns;.     for (x=0; x < flopped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q++;     }    }    free((char *) scanline);   return(flopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F r a m e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function FrameImage takes an image and puts a frame around it of a I %  particular color.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % + %  The format of the FrameImage routine is:  % 0 %      framed_image=FrameImage(image,frame_info) % + %  A description of each parameter follows:  % H %    o framed_image: Function FrameImage returns a pointer to the framedH %      image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % E %    o frame_info: Specifies a pointer to a FrameInfo structure which ! %      defines the framed region.  %  %  */# Image *FrameImage(image,frame_info)  Image 	   *image;   	 FrameInfo    *frame_info; {    Image      *framed_image;     int      height, 
     width;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      highlight,
     matte,     shadow;      unsigned int     bevel_width;     /*     Check frame geometry.    */E   if ((frame_info->outer_bevel < 0) || (frame_info->inner_bevel < 0))      { A       Warning("Unable to frame image","bevel width is negative");        return((Image *) NULL);      } >   bevel_width=frame_info->outer_bevel+frame_info->inner_bevel;:   width=(int) frame_info->width-frame_info->x-bevel_width;<   height=(int) frame_info->height-frame_info->y-bevel_width;9   if ((width < image->columns) || (height < image->rows))      { G       Warning("Unable to frame image","frame is less than image size");        return((Image *) NULL);      }    /*'     Initialize framed image attributes.    */K   framed_image=CopyImage(image,frame_info->width,frame_info->height,False); %   if (framed_image == (Image *) NULL)      { B       Warning("Unable to frame image","Memory allocation failed");       return((Image *) NULL);      }    image->class=DirectClass; (   matte.red=frame_info->matte_color.red;,   matte.green=frame_info->matte_color.green;*   matte.blue=frame_info->matte_color.blue;   matte.index=Opaque;    matte.length=0; 0   highlight.red=frame_info->highlight_color.red;4   highlight.green=frame_info->highlight_color.green;2   highlight.blue=frame_info->highlight_color.blue;   highlight.index=Opaque;    highlight.length=0; *   shadow.red=frame_info->shadow_color.red;.   shadow.green=frame_info->shadow_color.green;,   shadow.blue=frame_info->shadow_color.blue;   shadow.index=Opaque;   shadow.length=0;   /*.     Put an ornamental border around the image.   */   q=framed_image->pixels; -   for (y=0; y < frame_info->outer_bevel; y++)    { 1     for (x=0; x < (framed_image->columns-y); x++)        *q++=highlight; +     for ( ; x < framed_image->columns; x++)        *q++=shadow;   } 1   for (y=0; y < (frame_info->y-bevel_width); y++)    { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; N     for (x=0; x < (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } -   for (y=0; y < frame_info->inner_bevel; y++)    { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 3     for (x=0; x < (frame_info->x-bevel_width); x++)        *q++=matte; I     for (x=0; x < (image->columns+(frame_info->inner_bevel << 1)-y); x++)        *q++=shadow;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++)        *q++=highlight; E     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   }    p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)    {      /*,       Initialize scanline with border color.     *//     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 3     for (x=0; x < (frame_info->x-bevel_width); x++)        *q++=matte; /     for (x=0; x < frame_info->inner_bevel; x++)        *q++=shadow;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     } /     for (x=0; x < frame_info->inner_bevel; x++)        *q++=highlight; E     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } 0   for (y=frame_info->inner_bevel-1; y >= 0; y--)   { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 3     for (x=0; x < (frame_info->x-bevel_width); x++)        *q++=matte;      for (x=0; x < y; x++)        *q++=shadow;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++)        *q++=highlight; E     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } B   height=frame_info->height-frame_info->y-image->rows-bevel_width;   for (y=0; y < height; y++)   { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; N     for (x=0; x < (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } 0   for (y=frame_info->outer_bevel-1; y >= 0; y--)   {      for (x=0; x < y; x++)        *q++=highlight; +     for ( ; x < framed_image->columns; x++)        *q++=shadow;   }    return(framed_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     G a m m a I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function GammaImage converts the reference image to gamma corrected colors. % + %  The format of the GammaImage routine is:  %  %      GammaImage(image,gamma) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % J %    o gamma: A character string indicating the level of gamma correction. %  %  */ void GammaImage(image,gamma) Image 	   *image;    char	   *gamma;  { 
   ColorPacket      *gamma_map;      double     blue_gamma,      green_gamma,     red_gamma;     int 
     count;     register int     i;     register RunlengthPacket     *p;      /*'     Allocate and initialize gamma maps.    */C   gamma_map=(ColorPacket *) malloc((MaxRGB+1)*sizeof(ColorPacket)); (   if (gamma_map == (ColorPacket *) NULL)     { B       Warning("Unable to gamma image","Memory allocation failed");
       return;      }    for (i=0; i <= MaxRGB; i++)    {      gamma_map[i].red=0;      gamma_map[i].green=0;      gamma_map[i].blue=0;   }    /*     Initialize gamma table.    */   red_gamma=1.0;   green_gamma=1.0;   blue_gamma=1.0; H   count=sscanf(gamma,"%lf,%lf,%lf",&red_gamma,&green_gamma,&blue_gamma);   if (count == 1)      {        green_gamma=red_gamma;       blue_gamma=red_gamma;      }    for (i=0; i <= MaxRGB; i++)    {      if (red_gamma != 0.0)         gamma_map[i].red=(Quantum)<         ((pow((double) i/MaxRGB,1.0/red_gamma)*MaxRGB)+0.5);     if (green_gamma != 0.0) "       gamma_map[i].green=(Quantum)>         ((pow((double) i/MaxRGB,1.0/green_gamma)*MaxRGB)+0.5);     if (blue_gamma != 0.0)!       gamma_map[i].blue=(Quantum) =         ((pow((double) i/MaxRGB,1.0/blue_gamma)*MaxRGB)+0.5);    }    switch (image->class)    {      case DirectClass:      {        /*(         Gamma-correct DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { %         p->red=gamma_map[p->red].red; +         p->green=gamma_map[p->green].green; (         p->blue=gamma_map[p->blue].blue;         p++;       }        break;     }      case PseudoClass:      {        /*(         Gamma-correct PseudoClass image.       */'       for (i=0; i < image->colors; i++)        { E         image->colormap[i].red=gamma_map[image->colormap[i].red].red; J         image->colormap[i].green=gamma_map[image->colormap[i].green].blue;I         image->colormap[i].blue=gamma_map[image->colormap[i].blue].green;        }        SyncImage(image);        break;     }    }    free((char *) gamma_map);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t I m a g e I n f o                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function GetImageInfo initializes the ImageInfo structure.  % - %  The format of the GetImageInfo routine is:  %  %      GetImageInfo(image_info)  % + %  A description of each parameter follows:  % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %  %  */ void GetImageInfo(image_info) 	 ImageInfo    *image_info; {    *image_info->magick='\0'; 6   image_info->filename=(char *) malloc(MaxTextLength);,   if (image_info->filename == (char *) NULL)A     Error("Unable to get image info","Memory allocation failed");    *image_info->filename='\0';    image_info->assert=False;    image_info->subimage=0;    image_info->subrange=0; (   image_info->server_name=(char *) NULL;!   image_info->font=(char *) NULL; !   image_info->size=(char *) NULL; $   image_info->density=(char *) NULL;!   image_info->page=(char *) NULL;    image_info->dither=True;&   image_info->interlace=NoneInterlace;   image_info->monochrome=False;    image_info->quality=75;    image_info->verbose=False;'   image_info->undercolor=(char *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     I s G r a y I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function IsGrayImage returns True if the image is grayscale otherwiseO %  False is returned.  If the image is DirectClass and grayscale, it is demoted  %  to PseudoClass. % , %  The format of the IsGrayImage routine is: %   %      status=IsGrayImage(image) % + %  A description of each parameter follows:  % J %    o status: Function IsGrayImage returns True if the image is grayscale# %      otherwise False is returned.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ unsigned int IsGrayImage(image)  Image 	   *image;  {    register int     i;     unsigned int     grayscale;     /*$     Determine if image is grayscale.   */   grayscale=True;    switch (image->class)    {      case DirectClass:      {        register RunlengthPacket         *p;          if (image->matte)          return(False);       p=image->pixels;(       for (i=0; i < image->packets; i++)       { :         if ((p->red != p->green) || (p->green != p->blue))           {              grayscale=False;             break;           }          p++;       }        if (grayscale)	         { H           QuantizeImage(image,1 << QuantumDepth,8,False,GRAYColorspace);           SyncImage(image); 	         }        break;     }      case PseudoClass:      { '       for (i=0; i < image->colors; i++) C         if ((image->colormap[i].red != image->colormap[i].green) || B             (image->colormap[i].green != image->colormap[i].blue))           {              grayscale=False;             break;           }        break;     }    }    return(grayscale); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a b e l I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function LabelImage initializes an image label.  Optionally the labelJ %  can include the image filename, type, width, height, or scene number byF %  embedding special format characters.  Embed %f for filename, %m forD %  magick, %w for width, %h for height, or %s for scene number.  For %  example,  %  %     %f  %wx%h  %  %  produces an image label of  %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % + %  The format of the LabelImage routine is:  %  %      LabelImage(image,label) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % L %    o label: The address of a character string containing the label format. %  %  */ void LabelImage(image,label) Image 	   *image;    char	   *label;  {    register char      *p,      *q;      unsigned int     indirection,     length;   $   if (image->label != (char *) NULL)      free((char *) image->label);   image->label=(char *) NULL;    if (label == (char *) NULL)      return;    indirection=(*label == '@');   if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*         Read label from a file.        */'       file=(FILE *) fopen(label+1,"r");         if (file == (FILE *) NULL)	         { 7           Warning("Unable to read label file",label+1);            return; 	         }        length=MaxTextLength; $       label=(char *) malloc(length);1       for (q=label ; label != (char *) NULL; q++)        {          c=fgetc(file);         if (c == EOF)            break;"         if ((q-label+1) >= length)           {              *q='\0';             length<<=1; :             label=(char *) realloc((char *) label,length);'             if (label == (char *) NULL)                break;"             q=label+strlen(label);           }          *q=(unsigned char) c;        }        (void) fclose(file);!       if (label == (char *) NULL) 	         { F           Warning("Unable to label image","Memory allocation failed");           return; 	         }        *q='\0';     }    /*(     Allocate and initialize image label.   */
   p=label;%   length=strlen(label)+MaxTextLength; '   image->label=(char *) malloc(length); :   for (q=image->label; image->label != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;1     if ((q-image->label+MaxTextLength) >= length)        {          length<<=1; D         image->label=(char *) realloc((char *) image->label,length);*         if (image->label == (char *) NULL)           break;,         q=image->label+strlen(image->label);       }      /*-       Process formatting characters in label.      */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);,         q=image->label+strlen(image->label);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);,         q=image->label+strlen(image->label);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); ,         q=image->label+strlen(image->label);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } $   if (image->label == (char *) NULL)     { B       Warning("Unable to label image","Memory allocation failed");
       return;      } 
   *q='\0';   if (indirection)     free((char *) label);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     M o d u l a t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ModulateImage modulates the hue, saturation, and brightness of an 	 %  image.  % . %  The format of the ModulateImage routine is: % $ %      ModulateImage(image,modulate) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.% %%I %    o modulate: A character string indicating the percent change in hue, " %      saturation, and brightness. %  %  %  */  K static void Modulate(percent_hue,percent_saturation,percent_brightness,red, 
   green,blue)  double   percent_hue,   percent_saturation,    percent_brightness;    QuantumM   *red,A	   *green,E   *blue; {    double     brightness,      hue,     minimum,     saturation;      register double      b,     g,     r;     /*"     Convert RGB to HSV colorspace.   */
   hue=(-1.0);    saturation=0.0; $   r=(double) (*red)/(double) MaxRGB;&   g=(double) (*green)/(double) MaxRGB;%   b=(double) (*blue)/(double) MaxRGB; 
   if (r >= g)      {        if (r >= b)          brightness=r; 
       else         brightness=b;      }    else     if (g >= b)        brightness=g;      else       brightness=b; 
   if (r <= g)      {a       if (r <= b)i         minimum=r;
       else         minimum=b;     }    else     if (g <= b)        minimum=g;     else       minimum=b;   if (brightness != 0.0)/     saturation=(brightness-minimum)/brightness;    if (saturation != 0.0)     {        if (r == brightness)'         hue=(g-b)/(brightness-minimum);o
       else         if (g == brightness)-           hue=2.0+(b-r)/(brightness-minimum);i         else           if (b == brightness)/             hue=4.0+(r-g)/(brightness-minimum);        hue=hue*60.0;        if (hue < 0.0)         hue+=360.0;      }    /*>     Increase or decrease color brightness, saturation, or hue.   */'   brightness+=percent_brightness/100.0;    if (brightness < 0.0)P     brightness=0.0;m   else     if (brightness > 1.0)        brightness=1.0; '   saturation+=percent_saturation/100.0;    if (saturation < 0.0)      saturation=0.0;    else     if (saturation > 1.0)a       saturation=1.0;n   if (hue != -1.0)     {e#       hue+=360.0*percent_hue/100.0;        if (hue < 0.0)         hue+=360.0;c
       else         if (hue > 360.0)           hue-=360.0;t     }    /*     Convert HSV to RGB   */   r=brightness;    g=brightness;e   b=brightness; +   if ((hue != -1.0) && (saturation != 0.0))      {m       double
         f,
         j,
         k,
         l,
         v;  	       int 
         i;         if (hue == 360.0)e         hue=0.0;       hue=hue/60.0;.       i=floor(hue);m       if (i < 0)         i=0;       f=hue-i;$       j=brightness*(1.0-saturation);(       k=brightness*(1.0-(saturation*f));.       l=brightness*(1.0-(saturation*(1.0-f)));       v=brightness;        switch (i)       { )         case 0:  r=v;  g=l;  b=j;  break; )         case 1:  r=k;  g=v;  b=j;  break;e)         case 2:  r=j;  g=v;  b=l;  break;w)         case 3:  r=j;  g=k;  b=v;  break;i)         case 4:  r=l;  g=j;  b=v;  break;y)         case 5:  r=v;  g=j;  b=k;  break;        }P     }N0   *red=(Quantum) floor((r*(double) MaxRGB)+0.5);2   *green=(Quantum) floor((g*(double) MaxRGB)+0.5);1   *blue=(Quantum) floor((b*(double) MaxRGB)+0.5);  }u  " void ModulateImage(image,modulate) Imagea	   *image;n   char   *modulate; {r   double     percent_brightness,      percent_hue,     percent_saturation;r     register int     i;     register RunlengthPacket     *p;      /*     Initialize gamma table.    */   percent_hue=0.0;   percent_brightness=0.0;%   percent_saturation=0.0;%O   (void) sscanf(modulate,"%lf,%lf,%lf",&percent_brightness,&percent_saturation,i     &percent_hue);   switch (image->class)s   {      case DirectClass:i     {"       /*3         Modulate the color for a DirectClass image.s       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {iC         Modulate(percent_hue,percent_saturation,percent_brightness,%&           &p->red,&p->green,&p->blue);         p++;       }        break;     }      case PseudoClass:      {        /*3         Modulate the color for a PseudoClass image.        */'       for (i=0; i < image->colors; i++) C         Modulate(percent_hue,percent_saturation,percent_brightness, <           &image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             %lO %     M o g r i f y I m a g e                                                 %aO %                                                                             %tO %                                                                             %sO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function MogrifyImage applies image processing options to an image as& %  prescribed by command line options. %g- %  The format of the MogrifyImage routine is:a %i/ %      MogrifyImage(image_info,argc,argv,image)* % + %  A description of each parameter follows:e %m@ %    o image_info: Specifies a pointer to a ImageInfo structure. % G %    o argc: Specifies a pointer to an integer describing the number oft' %      elements in the argument vector.L % L %    o argv: Specifies a pointer to a text array containing the command line %      arguments.  %oF %    o image: The address of a structure of type Image;  returned from %      ReadImage.a %' %; */- void MogrifyImage(image_info,argc,argv,image)-	 ImageInfo;   *image_info;   inta   argc;-   char	   **argv;    Image_
   **image; {=
   ColorPacket      border_color,l     matte_color;     char
     *font,     *geometry,     *option,	     *pen;i     inte
     flags,     x,     y;     register int     i;     unsigned int     colorspace,e     number_colors,     tree_depth;C     XColor
     color;     if (*image == (Image *) NULL)m     return;    /*!     Initialize routine variables.    */1   (void) XQueryColorDatabase(BorderColor,&color);/)   border_color.red=XDownScale(color.red);r-   border_color.green=XDownScale(color.green);o+   border_color.blue=XDownScale(color.blue);    border_color.index=0;-   font=(char *) NULL;L   geometry=(char *) NULL;r0   (void) XQueryColorDatabase(MatteColor,&color);(   matte_color.red=XDownScale(color.red);,   matte_color.green=XDownScale(color.green);*   matte_color.blue=XDownScale(color.blue);   number_colors=0;   pen=(char *) NULL;   tree_depth=0;a   colorspace=RGBColorspace;    if (image_info->monochrome)r     {L       number_colors=2;       tree_depth=8;t        colorspace=GRAYColorspace;     }n   /*     Transmogrify the image._   */   for (i=1; i < argc; i++)   {p     option=argv[i];oN     if (((int) strlen(option) <= 1) || ((*option != '-') && (*option != '+')))       continue; ,     if (strncmp("annotate",option+1,2) == 0)8       AnnotateImage(*image,font,pen,geometry,argv[++i]);'     if (strncmp("-blur",option,3) == 0)-       {a         double           factor;I  
         Image            *blurred_image;e  
         /*           Blur an image.
         */         factor=atof(argv[++i]);o/         blurred_image=BlurImage(*image,factor); ,         if (blurred_image != (Image *) NULL)           {;!             DestroyImage(*image);;!             *image=blurred_image;%           }%       }%&     if (strcmp("-border",option) == 0)       { 
         Image            *bordered_image;           RectangleInfo            border_info;  
         /*6           Surround image with a border of solid color.
         */         border_info.width=0;         border_info.height=0; E         flags=XParseGeometry(argv[++i],&border_info.x,&border_info.y, 2           &border_info.width,&border_info.height);'         if ((flags & HeightValue) == 0) /           border_info.height=border_info.width; F         bordered_image=BorderImage(*image,&border_info,&border_color);-         if (bordered_image != (Image *) NULL)%           {%!             DestroyImage(*image);%.             bordered_image->class=DirectClass;"             *image=bordered_image;           }        }o.     if (strncmp("-bordercolor",option,8) == 0)       {          XColor           target_color;r  
         /*3           Determine RGB values of the border color.w
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);6         border_color.red=XDownScale(target_color.red);:         border_color.green=XDownScale(target_color.green);8         border_color.blue=XDownScale(target_color.blue);       } *     if (strncmp("colors",option+1,7) == 0)$       number_colors=atoi(argv[++i]);-     if (strncmp("-colorspace",option,8) == 0)        {m         i++;         option=argv[i];d.         if (Latin1Compare("gray",option) == 0)           {d&             colorspace=GRAYColorspace;#             if (number_colors == 0)d                number_colors=256;             tree_depth=8;            }:.         if (Latin1Compare("ohta",option) == 0)$           colorspace=OHTAColorspace;-         if (Latin1Compare("rgb",option) == 0)n#           colorspace=RGBColorspace;A-         if (Latin1Compare("xyz",option) == 0)m#           colorspace=XYZColorspace; /         if (Latin1Compare("ycbcr",option) == 0) %           colorspace=YCbCrColorspace; -         if (Latin1Compare("yiq",option) == 0)i#           colorspace=YIQColorspace;h/         if (Latin1Compare("ypbpr",option) == 0)F%           colorspace=YPbPrColorspace;l-         if (Latin1Compare("yuv",option) == 0) #           colorspace=YUVColorspace;        }d+     if (strncmp("comment",option+1,4) == 0)f       if (*option == '-')v'         CommentImage(*image,argv[++i]);L
       else+         CommentImage(*image,(char *) NULL);n,     if (strncmp("compress",option+1,3) == 0)       { ,         (*image)->compression=NoCompression;         if (*option == '-')            {*             i++;?             if (Latin1Compare("runlengthencoded",argv[i]) == 0)n@               (*image)->compression=RunlengthEncodedCompression;             else9               if (Latin1Compare("qencoded",argv[i]) == 0) :                 (*image)->compression=QEncodedCompression;           }i       } ,     if (strncmp("contrast",option+1,3) == 0)<       ContrastImage(*image,(unsigned int) (*option == '-'));+     if ((strncmp("-crop",option,3) == 0) ||()         (strncmp("-clip",option,3) == 0)) 4       TransformImage(image,argv[++i],(char *) NULL);,     if (strncmp("-despeckle",option,4) == 0)       { 
         Imaged           *despeckled_image;  
         /*.           Reduce the speckles within an image.
         */0         despeckled_image=DespeckleImage(*image);/         if (despeckled_image != (Image *) NULL)            {;!             DestroyImage(*image);i$             *image=despeckled_image;           }r       }+'     if (strncmp("-edge",option,3) == 0)l       {h
         Imagea           *edged_image;(  
         /*$           Detect edges in the image.
         */&         edged_image=EdgeImage(*image);*         if (edged_image != (Image *) NULL)           { !             DestroyImage(*image);h             *image=edged_image;            }t       }h)     if (strncmp("-emboss",option,3) == 0)m       {+
         Imagee           *embossed_image;  
         /*           Emboss image..
         */+         embossed_image=EmbossImage(*image); -         if (embossed_image != (Image *) NULL)o           { !             DestroyImage(*image); "             *image=embossed_image;           }        } *     if (strncmp("-enhance",option,3) == 0)       { 
         Imager           *enhanced_image;  
         /*           Enhance image.
         */,         enhanced_image=EnhanceImage(*image);-         if (enhanced_image != (Image *) NULL)(           {l!             DestroyImage(*image); "             *image=enhanced_image;           }s       } +     if (strncmp("-equalize",option,3) == 0)        EqualizeImage(*image);'     if (strncmp("-flip",option,4) == 0)=       {x
         Image>           *flipped_image;   
         /*           Flip image scanlines.)
         */(         flipped_image=FlipImage(*image);,         if (flipped_image != (Image *) NULL)           { !             DestroyImage(*image);m!             *image=flipped_image;+           }>       } '     if (strncmp("-flop",option,4) == 0)        { 
         Images           *flopped_image;_  
         /*           Flop image scanlines.>
         */(         flopped_image=FlopImage(*image);,         if (flopped_image != (Image *) NULL)           {;!             DestroyImage(*image);g!             *image=flopped_image;            }(       }o'     if (strncmp("-font",option,3) == 0)d       font=argv[++i]; %     if (strcmp("-frame",option) == 0)(       {o
         Imageh           *framed_image;           FrameInfon           frame_info;e  
         /*3           Surround image with an ornamental border. 
         */         frame_info.width=0;e         frame_info.height=0;?         flags=XParseGeometry(argv[++i],&frame_info.outer_bevel,;H           &frame_info.inner_bevel,&frame_info.width,&frame_info.height);'         if ((flags & HeightValue) == 0) -           frame_info.height=frame_info.width; "         if ((flags & XValue) == 0);           frame_info.outer_bevel=(frame_info.width >> 2)+1;a"         if ((flags & YValue) == 0)8           frame_info.inner_bevel=frame_info.outer_bevel;&         frame_info.x=frame_info.width;'         frame_info.y=frame_info.height;tC         frame_info.width=(*image)->columns+(frame_info.width << 1); B         frame_info.height=(*image)->rows+(frame_info.height << 1);+         frame_info.matte_color=matte_color; J         frame_info.highlight_color.red=(matte_color.red*HighlightModulate+B           (unsigned int) (MaxRGB-HighlightModulate)*65535)/MaxRGB;N         frame_info.highlight_color.green=(matte_color.green*HighlightModulate+B           (unsigned int) (MaxRGB-HighlightModulate)*65535)/MaxRGB;L         frame_info.highlight_color.blue=(matte_color.blue*HighlightModulate+B           (unsigned int) (MaxRGB-HighlightModulate)*65535)/MaxRGB;$         frame_info.shadow_color.red=A           (unsigned int) (matte_color.red*ShadowModulate)/MaxRGB;i&         frame_info.shadow_color.green=C           (unsigned int) (matte_color.green*ShadowModulate)/MaxRGB;n%         frame_info.shadow_color.blue=iB           (unsigned int) (matte_color.blue*ShadowModulate)/MaxRGB;4         framed_image=FrameImage(*image,&frame_info);+         if (framed_image != (Image *) NULL)            {s!             DestroyImage(*image);;,             framed_image->class=DirectClass;              *image=framed_image;           }e       }t(     if (strncmp("-gamma",option,3) == 0)#       GammaImage(*image,argv[++i]);n+     if (strncmp("-geometry",option,4) == 0)(       {          geometry=argv[++i];)5         TransformImage(image,(char *) NULL,geometry);        }_-     if (strncmp("interlace",option+1,3) == 0)F       {c,         image_info->interlace=NoneInterlace;         if (*option == '-')s           {W             option=argv[++i];t2             if (Latin1Compare("none",option) == 0)2               image_info->interlace=NoneInterlace;2             if (Latin1Compare("line",option) == 0)2               image_info->interlace=LineInterlace;3             if (Latin1Compare("plane",option) == 0)t3               image_info->interlace=PlaneInterlace;,           }L       }p)     if (strncmp("label",option+1,2) == 0)=       if (*option == '-')n%         LabelImage(*image,argv[++i]);e
       else)         LabelImage(*image,(char *) NULL);p&     if (strcmp("matte",option+1) == 0)'       (*image)->matte=(*option == '-'); -     if (strncmp("-mattecolor",option,7) == 0)a       {n         XColor           target_color;   
         /*3           Determine RGB values of the border color.t
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);5         matte_color.red=XDownScale(target_color.red);n9         matte_color.green=XDownScale(target_color.green);o7         matte_color.blue=XDownScale(target_color.blue);n       }o+     if (strncmp("-modulate",option,4) == 0) &       ModulateImage(*image,argv[++i]);)     if (strncmp("-negate",option,4) == 0)m       NegateImage(*image);(     if (strncmp("-noise",option,4) == 0)       { 
         Imagea           *noisy_image;   
         /*            Reduce noise in image.
         */'         noisy_image=NoisyImage(*image);h*         if (noisy_image != (Image *) NULL)           {c!             DestroyImage(*image);i             *image=noisy_image;r           }(       }f,     if (strncmp("-normalize",option,4) == 0)       NormalizeImage(*image); )     if (strncmp("-opaque",option,3) == 0)%(       OpaqueImage(*image,argv[++i],pen);(     if (strncmp("-paint",option,4) == 0)       { 
         Image            *painted_image;   
         /*           Oil paint image.
         */,         painted_image=OilPaintImage(*image);,         if (painted_image != (Image *) NULL)           { !             DestroyImage(*image); !             *image=painted_image;            }        } &     if (strncmp("-pen",option,3) == 0)       pen=argv[++i];)     if (strncmp("raise",option+1,2) == 0) A       RaiseImage(*image,*option == '-' ? 1 : -1,atoi(argv[++i]));%'     if (strncmp("-roll",option,4) == 0)        {F
         Imageg           *rolled_image;           unsigned int           height,            width;  
         /*           Roll image.t
         */         x=0;         y=0;=         flags=XParseGeometry(argv[++i],&x,&y,&width,&height);l+         rolled_image=RollImage(*image,x,y); +         if (rolled_image != (Image *) NULL)            {a!             DestroyImage(*image);               *image=rolled_image;           }b       }f)     if (strncmp("-rotate",option,4) == 0)o       {          double           degrees;  
         Imager           *rotated_image;r  
         /*           Rotate image. 
         */          degrees=atof(argv[++i]);F         rotated_image=RotateImage(*image,degrees,&border_color,False);,         if (rotated_image != (Image *) NULL)           {f!             DestroyImage(*image);.!             *image=rotated_image;a           }        }e)     if (strncmp("-sample",option,3) == 0)        {o
         Imagea           *sampled_image;w           unsigned int           height,f           width;  
         /*.           Sample image with pixel replication.
         */          width=(*image)->columns;         height=(*image)->rows;5         ParseImageGeometry(argv[++i],&width,&height);e7         sampled_image=SampleImage(*image,width,height);;,         if (sampled_image != (Image *) NULL)           {_!             DestroyImage(*image);_!             *image=sampled_image;n           }        } )     if (strncmp("scene",option+1,3) == 0) &       (*image)->scene=atoi(argv[++i]);*     if (strncmp("-sharpen",option,4) == 0)       {s         double           factor;n  
         Image            *sharpened_image;i  
         /*           Sharpen an image.a
         */         factor=atof(argv[++i]);34         sharpened_image=SharpenImage(*image,factor);.         if (sharpened_image != (Image *) NULL)           {=!             DestroyImage(*image);e#             *image=sharpened_image;=           }L       } (     if (strncmp("-shear",option,4) == 0)       {l
         float"           x_shear,           y_shear;  
         Imageg           *sheared_image;*  
         /*           Shear image.
         */         x_shear=0.0;         y_shear=0.0;;         (void) sscanf(argv[++i],"%fx%f",&x_shear,&y_shear);n9         sheared_image=ShearImage(*image,(double) x_shear,U0           (double) y_shear,&border_color,False);,         if (sheared_image != (Image *) NULL)           { !             DestroyImage(*image);t-             sheared_image->class=DirectClass;g!             *image=sheared_image;e           }=       } /     if (strncmp("-transparency",option,4) == 0) )       TransparentImage(*image,argv[++i]);m,     if (strncmp("-treedepth",option,4) == 0)!       tree_depth=atoi(argv[++i]);>   }h   if (number_colors != 0)      {;       /*1         Reduce the number of colors in the image.k       */-       if (((*image)->class == DirectClass) ||kO           ((*image)->colors > number_colors) || (colorspace == GRAYColorspace)) I         QuantizeImage(*image,number_colors,tree_depth,image_info->dither,            colorspace);       /*#         Measure quantization error./       */       if (image_info->verbose)"         QuantizationError(*image);       SyncImage(*image);     }+>   if ((*image)->packets == ((*image)->columns*(*image)->rows))     CompressImage(*image); }l s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             % O %                                                                             % O %     N e g a t e I m a g e                                                   %-O %                                                                             % O %                                                                             % O %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % B %  Function NegateImage negates the colors in the reference image. % , %  The format of the NegateImage routine is: %B %      NegateImage(image)  %=+ %  A description of each parameter follows:  %-F %    o image: The address of a structure of type Image;  returned from %      ReadImage.n %u %u */ void NegateImage(image)b Imagea	   *image;a {l   register int     i;     register RunlengthPacket     *p;      switch (image->class)    {0     case DirectClass:      {        /*#         Negate DirectClass packets.t       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {c         p->red=(~p->red);          p->green=(~p->green);+         p->blue=(~p->blue);i         p++;       }        break;     }e     case PseudoClass:a     {        /*#         Negate PseudoClass packets.%       */'       for (i=0; i < image->colors; i++)        { 9         image->colormap[i].red=(~image->colormap[i].red); =         image->colormap[i].green=(~image->colormap[i].green); ;         image->colormap[i].blue=(~image->colormap[i].blue);        }        SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     N o i s y I m a g e                                                     %%O %                                                                             % O %                                                                             %eO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r % H %  Function NoisyImage creates a new image that is a copy of an existingG %  one with the noise reduced with a noise peak elimination filter.  ItaK %  allocates the memory necessary for the new Image structure and returns an %  pointer to the new image. % K %  The principal function of noise peak elimination filter is to smooth the F %  objects within an image without losing edge information and withoutJ %  creating undesired structures.  The central idea of the algorithm is toI %  replace a pixel with its next neighbor in value within a 3 x 3 window,sI %  if this pixel has been found to be noise.  A pixel is defined as noise E %  if and only if this pixel is a maximum or minimum within the 3 x 3e
 %  window. %I+ %  The format of the NoisyImage routine is:r %_$ %      noisy_image=NoisyImage(image) %;+ %  A description of each parameter follows:t %RL %    o noisy_image: Function NoisyImage returns a pointer to the image afterK %      the noise is reduced.  A null image is returned if there is a memorye %      shortage. %+F %    o image: The address of a structure of type Image;  returned from %      ReadImage.r %i %e */ static int NoisyCompare(x,y)
 const void   *x,o   *y;  {g
   ColorPacketc
     *color_1, 
     *color_2;(     color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_1)-(int) Intensity(*color_2)); }-   Image *NoisyImage(image) Imager	   *image;  {d   Imageb     *noisy_image;      intr     i;     register RunlengthPacket     *p,      *q,.     *s,      *s0,     *s1,     *s2;     register unsigned inth     x;     RunlengthPacket 
     pixel,     *scanline,     window[9];     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     {-I       Warning("Unable to reduce noise","the image size must exceed 2x2");        return((Image *) NULL);i     }d   /*&     Initialize noisy image attributes.   */@   noisy_image=CopyImage(image,image->columns,image->rows,False);$   if (noisy_image == (Image *) NULL)     {mC       Warning("Unable to reduce noise","Memory allocation failed");        return((Image *) NULL);      }    /*5     Allocate scanline buffer for 3 rows of the image.    */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      {oC       Warning("Unable to reduce noise","Memory allocation failed");;        DestroyImage(noisy_image);       return((Image *) NULL);q     }e   /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1;%
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*!     Dump first scanline of image.    */   q=noisy_image->pixels;
   s=scanline; $   for (x=0; x < image->columns; x++)   {      *q=(*s);     q->length=0;     q++;     s++;   }    /*     Reduce noise in each row.    */%   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3);%'     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);g     /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {e        if (image->runlength != 0)         image->runlength--; 
       else	         {e           p++;%           image->runlength=p->length; 	         }s       *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */	     s=s1;      *q=(*s);     q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {m       /*3         Sort window pixels by increasing intensity.a       */       s=s0;e       window[0]=(*s++);        window[1]=(*s++);R       window[2]=(*s++);s       s=s1;r       window[3]=(*s++);p       window[4]=(*s++);o       window[5]=(*s++);        s=s2;a       window[6]=(*s++);        window[7]=(*s++);        window[8]=(*s++);        pixel=window[4];6       qsort((void *) window,9,sizeof(RunlengthPacket),G         (int (*) _Declare((const void *, const void *))) NoisyCompare);_3       if (Intensity(pixel) == Intensity(window[0]))_	         {t           /*H             Pixel is minimum noise; replace with next neighbor in value.           */           for (i=1; i < 8; i++)o=             if (Intensity(window[i]) != Intensity(window[0]))(               break;           pixel=window[i];	         }-
       else5         if (Intensity(pixel) == Intensity(window[8]))t           {e             /*J               Pixel is maximum noise; replace with next neighbor in value.             */!             for (i=7; i > 0; i--)-?               if (Intensity(window[i]) != Intensity(window[8]))p                 break;             pixel=window[i];           }0       *q=pixel;(       q->length=0;
       q++;       s0++;h       s1++;n       s2++;p     }y     /**       Transfer last pixel of the scanline.     */	     s=s1;r     *q=(*s);     q->length=0;     q++;   },   /*!     Dump last scanline of pixels.g   */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {      *q=(*s);     q->length=0;     q++;     s++;   }d   free((char *) scanline);   return(noisy_image); }  r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %cO %                                                                             %-O %     N o r m a l i z e I m a g e                                             % O %                                                                             %hO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %gG %  Function NormalizeImage normalizes the pixel values to span the fullgD %  range of color values.  This is a contrast enhancement technique. %0/ %  The format of the NormalizeImage routine is:t %  %      NormalizeImage(image) %l+ %  A description of each parameter follows:h % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.r %e %h */ void NormalizeImage(image) Image<	   *image;> {|   int      histogram[MaxRGB+1],     threshold_intensity;  	   Quantum;     gray_value,n     normalize_map[MaxRGB+1];     register int     i,     intensity;     register RunlengthPacket     *p;%     unsigned int	     high,%     low;     /*     Form histogram.    */   for (i=0; i <= MaxRGB; i++)      histogram[i]=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)   {      gray_value=Intensity(*p); '     histogram[gray_value]+=p->length+1;      p++;   }    /*C     Find the histogram boundaries by locating the 1 percent levels.    */7   threshold_intensity=(image->columns*image->rows)/100;    intensity=0;"   for (low=0; low < MaxRGB; low++)   {      intensity+=histogram[low];(     if (intensity > threshold_intensity)       break;   }    intensity=0;&   for (high=MaxRGB; high != 0; high--)   {%     intensity+=histogram[high];%(     if (intensity > threshold_intensity)       break;   }e   if (low == high)     {i       /*K         Unreasonable contrast;  use zero threshold to determine boundaries.h       */       threshold_intensity=0;       intensity=0;&       for (low=0; low < MaxRGB; low++)       {n"         intensity+=histogram[low];,         if (intensity > threshold_intensity)           break;       }C       intensity=0;*       for (high=MaxRGB; high != 0; high--)       { #         intensity+=histogram[high]; ,         if (intensity > threshold_intensity)           break;       }s       if (low == high)&         return;  /* zero span bound */     }-   /*A     Stretch the histogram to create the normalized image mapping.t   */   for (i=0; i <= MaxRGB; i++)      if (i < (int) low)       normalize_map[i]=0;m     else       if (i > (int) high)e"         normalize_map[i]=MaxRGB-1;
       else7         normalize_map[i]=(MaxRGB-1)*(i-low)/(high-low);%   /*     Normalize the image.   */   switch (image->class)    {      case DirectClass:      {        /*$         Normalize DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { %         p->red=normalize_map[p->red]; )         p->green=normalize_map[p->green]; '         p->blue=normalize_map[p->blue];          p++;       }        break;     }      case PseudoClass:      {        /*$         Normalize PseudoClass image.       */'       for (i=0; i < image->colors; i++)        { E         image->colormap[i].red=normalize_map[image->colormap[i].red];%I         image->colormap[i].green=normalize_map[image->colormap[i].green];iG         image->colormap[i].blue=normalize_map[image->colormap[i].blue];a       }m       SyncImage(image);r       break;     }e   }i }s i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %fO %                                                                             % O %     O p a g u e I m a g e                                                   % O %                                                                             %nO %                                                                             %rO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %,N %  Function OpaqueImage changes the color of an opaque pixel to the pen color. % , %  The format of the OpaqueImage routine is: % 0 %      OpaqueImage(image,opaque_color,pen_color) % + %  A description of each parameter follows:g %cF %    o image: The address of a structure of type Image;  returned from %      ReadImage.m %s %    o opaque_color,F %      pen_color: A character string that contain an X11 color string. %  %  */. void OpaqueImage(image,opaque_color,pen_color) Imagee	   *image;o   char   *opaque_color,
   *pen_color;F {  #define DeltaX  16  	   Quantuma	     blue,l
     green,     red;     register int     i;     register RunlengthPacket     *p;x     unsigned int     status;h     XColor     target_color;o     /*-     Determine RGB values of the opaque color.    */9   status=XQueryColorDatabase(opaque_color,&target_color);a   if (status == False)     return;g#   red=XDownScale(target_color.red);0'   green=XDownScale(target_color.green); %   blue=XDownScale(target_color.blue);e6   status=XQueryColorDatabase(pen_color,&target_color);   if (status == False)     return;=   /*     Make image color opaque.   */   p=image->pixels;   switch (image->class)    {i     case DirectClass:      {m       /*&         Make DirectClass image opaque.       */(       for (i=0; i < image->packets; i++)       { 2         if (((int) p->red < (int) (red+DeltaX)) &&2             ((int) p->red > (int) (red-DeltaX)) &&6             ((int) p->green < (int) (green+DeltaX)) &&6             ((int) p->green > (int) (green-DeltaX)) &&4             ((int) p->blue < (int) (blue+DeltaX)) &&2             ((int) p->blue > (int) (blue-DeltaX)))           {;0             p->red=XDownScale(target_color.red);4             p->green=XDownScale(target_color.green);2             p->blue=XDownScale(target_color.blue);           }          p++;       }=       break;     }      case PseudoClass:=     {c       double         distance_squared,          min_distance;   	       inta         distance;.         register int         index;         /*         Find closest color.;       */-       min_distance=3.0*(MaxRGB+1)*(MaxRGB+1);!       index=0;'       for (i=0; i < image->colors; i++)        { 8         distance=(int) red-(int) image->colormap[i].red;<         distance_squared=(unsigned int) (distance*distance);<         distance=(int) green-(int) image->colormap[i].green;=         distance_squared+=(unsigned int) (distance*distance); :         distance=(int) blue-(int) image->colormap[i].blue;=         distance_squared+=(unsigned int) (distance*distance); ,         if (distance_squared < min_distance)           {v*             min_distance=distance_squared;             index=i;           }e       }s       /*&         Make PseudoClass image opaque.       */>       image->colormap[index].red=XDownScale(target_color.red);B       image->colormap[index].green=XDownScale(target_color.green);@       image->colormap[index].blue=XDownScale(target_color.blue);       break;     }m   }; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             %aO %                                                                             % O %                                                                             % O %   O p e n I m a g e                                                         % O %                                                                             % O %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function OpenImage open a file associated with the image.  A file name ofK %  '-' sets the file to stdin for type 'r' and stdout for type 'w'.  If the K %  filename suffix is '.gz' or '.Z', the image is decompressed for type 'r' K %  and compressed for type 'w'.  If the filename prefix is '|', it is piped  %  to or from a system command.  % * %  The format of the OpenImage routine is: %  %      OpenImage(image,type) %%+ %  A description of each parameter follows:% %%7 %    o image: The address of a structure of type Image.e %n. %    o type: 'r' for reading; 'w' for writing. %e */ void OpenImage(image,type) Imagel	   *image;n   char   *type; {m   char     filename[MaxTextLength];  *   (void) strcpy(filename,image->filename);   if (*filename != '|')r'     if (((int) strlen(filename) > 3) &&C9         (strcmp(filename+strlen(filename)-3,".gz") == 0))e       {c
         /*E           Uncompress/compress image file with GNU compress utilities.e
         */         if (*type == 'r')gF           (void) sprintf(filename,"|gunzip -f -c %s",image->filename);         elseF           (void) sprintf(filename,"|gzip -f -c > %s",image->filename);       }      else)       if (((int) strlen(filename) > 2) &&a:           (strcmp(filename+strlen(filename)-2,".Z") == 0))	         {            /*H             Uncompress/compress image file with UNIX compress utilities.           */           if (*type == 'r')-I             (void) sprintf(filename,"|uncompress -c %s",image->filename);l           elseI             (void) sprintf(filename,"|compress -c > %s",image->filename);o	         }r   /*     Open image file.   */   image->pipe=False;    if (strcmp(filename,"-") == 0)0     image->file=(*type == 'r') ? stdin : stdout;   else     if (*filename != '|')n       {l         if (*type == 'w')m4           if ((image->previous != (Image *) NULL) ||.               (image->next != (Image *) NULL))
             {i               /*4                 Form filename for multi-part images.               */D               (void) sprintf(filename,image->filename,image->scene);8               if (strcmp(filename,image->filename) == 0)N                 (void) sprintf(filename,"%s.%u",image->filename,image->scene);0               if (image->next != (Image *) NULL)A                 (void) strcpy(image->next->magick,image->magick); 6               (void) strcpy(image->filename,filename);
             }o2         image->file=(FILE *) fopen(filename,type);)         if (image->file != (FILE *) NULL)%           { +             (void) fseek(image->file,0L,2); /             image->filesize=ftell(image->file); +             (void) fseek(image->file,0L,0);            }        }      else       { 
         /*1           Pipe image to or from a system command. 
         */         if (*type == 'w') )           (void) signal(SIGPIPE,SIG_IGN); 4         image->file=(FILE *) popen(filename+1,type);         image->pipe=True;        }    image->status=False;   if (*type == 'r')      { !       image->next=(Image *) NULL; %       image->previous=(Image *) NULL;      }  }  % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%FO %                                                                             %eO %                                                                             %CO %                                                                             %oO %   P a r s e I m a g e G e o m e t r y                                       %eO %                                                                             %aO %                                                                             %gO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %eM %  Function ParseImageGeometry parse a geometry specification and returns theg %  width and height values.m %-3 %  The format of the ParseImageGeometry routine is:; % 6 %      ParseImageGeometry(image_geometry,width,height) %(+ %  A description of each parameter follows:& % N %    o image_geometry:  Specifies a character string representing the geometry %      specification.) % L %    o width:  A pointer to an unsigned integer.  The width as determined by3 %      the geometry specification is returned here.  % N %    o height:  A pointer to an unsigned integer.  The height as determined by3 %      the geometry specification is returned here.  %( %g */4 void ParseImageGeometry(image_geometry,width,height) char   *image_geometry;   unsigned int	   *width,e
   *height; {    char     geometry[MaxTextLength];     intp
     flags,     x,     y;     register char      *p;&     unsigned int     aspect_ratio,      former_height,     former_width,      greater,	     less,-     percentage;      unsigned long      scale_factor;s  &   if (image_geometry == (char *) NULL)     return;    /*J     Remove whitespaces and % and ! characters from geometry specification.   */)   (void) strcpy(geometry,image_geometry);    aspect_ratio=True;   greater=False;
   less=False;    percentage=False; 
   p=geometry;g   while ((int) strlen(p) > 0)d   {p     if (isspace(*p))       (void) strcpy(p,p+1);      else       switch (*p)e       {m         case '%':>	         {2           percentage=True;           (void) strcpy(p,p+1);            break;	         }e         case '!':m	         {o           aspect_ratio=False;r           (void) strcpy(p,p+1);*           break;	         }%         case '<':%	         {%           less=True;           (void) strcpy(p,p+1);            break;	         }          case '>': 	         {            greater=True;            (void) strcpy(p,p+1);            break;	         }          default:           p++;       }    }    /*(     Parse geometry using XParseGeometry.   */   former_width=(*width);   former_height=(*height);4   flags=XParseGeometry(geometry,&x,&y,width,height);@   if (((flags & WidthValue) != 0) && (flags & HeightValue) == 0)     *height=(*width);    if (percentage)      {        /*3         Geometry is a percentage of the image size.%       */)       *width=(former_width*(*width))/100;%,       *height=(former_height*(*height))/100;       former_width=(*width);       former_height=(*height);     }    if (aspect_ratio)      {e       /**         Respect aspect ratio of the image.       */0       scale_factor=UpShift(*width)/former_width;:       if (scale_factor > (UpShift(*height)/former_height))4         scale_factor=UpShift(*height)/former_height;2       *width=DownShift(former_width*scale_factor);4       *height=DownShift(former_height*scale_factor);     }c   if (greater)=     if ((former_width < *width) && (former_height < *height))        {          *width=former_width;         *height=former_height;       }e   if (less)w=     if ((former_width > *width) && (former_height > *height))m       {g         *width=former_width;         *height=former_height;       }  }n n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             % O %     O i l P a i n t I m a g e                                               % O %                                                                             %mO %                                                                             %eO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %(K %  Function OilPaintImage creates a new image that is a copy of an existingrN %  one with each pixel component replaced with the color of greatest number in %  a 5x5 neighborhood. %g. %  The format of the OilPaintImage routine is: %r) %      painted_image=OilPaintImage(image)  % + %  A description of each parameter follows:  % K %    o painted_image: Function OilPaintImage returns a pointer to the imageeL %      after it is `painted'.  A null image is returned if there is a memory %      shortage. %eF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ Image *OilPaintImage(image)m Imagei	   *image;) {    Image      *painted_image;_     intx
     count;     register int     i,     j;     register RunlengthPacket     *p,      *q,x     *s,      *s0,     *s1,     *s2,     *s3,     *s4;     register unsigned int      x;     RunlengthPacketm
     pixel,     *scanline,     window[25];      unsigned int     *histogram,e     y;  0   if ((image->columns < 5) || (image->rows < 5))     { F       Warning("Unable to oil paint","the image size must exceed 4x4");       return((Image *) NULL);      }o   /*(     Initialize painted image attributes.   */B   painted_image=CopyImage(image,image->columns,image->rows,False);&   if (painted_image == (Image *) NULL)     {e@       Warning("Unable to oil paint","Memory allocation failed");       return((Image *) NULL);p     } #   painted_image->class=DirectClass;e   /*$     Allocate histogram and scanline.   */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); P   scanline=(RunlengthPacket *) malloc(5*image->columns*sizeof(RunlengthPacket));-   if ((histogram == (unsigned int *) NULL) ||t-       (scanline == (RunlengthPacket *) NULL))o     {_@       Warning("Unable to oil paint","Memory allocation failed");"       DestroyImage(painted_image);       return((Image *) NULL);      }p   /**     Preload the first 4 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline;(+   for (x=0; x < (image->columns << 2); x++)>   {)     if (image->runlength != 0)       image->runlength--;>     else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }g   /*!     Dump first scanline of image.g   */   q=painted_image->pixels;
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }i   /*      Paint each row of the image.   */%   for (y=2; y < (image->rows-2); y++)    {h     /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-2) % 5);x+     s1=scanline+image->columns*((y-1) % 5); '     s2=scanline+image->columns*(y % 5);e+     s3=scanline+image->columns*((y+1) % 5); +     s4=scanline+image->columns*((y+2) % 5);      /*       Read another scan line.q     */	     s=s4; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }a     /*+       Transfer first pixel of the scanline.p     */	     s=s2;r     *q=(*s++);     q->length=0;     q++;     *q=(*s++);     q->length=0;     q++;*     for (x=2; x < (image->columns-2); x++)     {        /*.         Note each pixel in a 5x5 neighborhood.       */       s=s0;        window[0]=(*s++);        window[1]=(*s++);        window[2]=(*s++);i       window[3]=(*s++);q       window[4]=(*s++);t       s=s1;-       window[5]=(*s++);        window[6]=(*s++);i       window[7]=(*s++);        window[8]=(*s++);i       window[9]=(*s++);        s=s2;        window[10]=(*s++);       window[11]=(*s++);       window[12]=(*s++);       window[13]=(*s++);       window[14]=(*s++);       s=s3;-       window[15]=(*s++);       window[16]=(*s++);       window[17]=(*s++);       window[18]=(*s++);       window[19]=(*s++);       s=s4;        window[20]=(*s++);       window[21]=(*s++);       window[22]=(*s++);       window[23]=(*s++);       window[24]=(*s++);       /*&         Determine most frequent color.       */       count=0;$       for (i=0; i < (MaxRGB+1); i++)         histogram[i]=0;q       for (i=0; i < 25; i++)       {=%          j=Intensity(window[i]) >> 2;u          histogram[j]++;          j=histogram[j];          if (j > count)O            {              pixel=window[i];O              count=j;(            }       }e       *q=pixel;e       q->length=0;
       q++;       s0++;(       s1++;e       s2++;        s3++;        s4++;e     }(     /**       Transfer last pixel of the scanline.     */	     s=s2;q     *q=(*s++);     q->length=0;     q++;     *q=(*s++);     q->length=0;     q++;   }    /*!     Dump last scanline of pixels.    */$   s=scanline+image->columns*(y % 5);+   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }n   free((char *) histogram);    free((char *) scanline);   return(painted_image); }r ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             %)O %                                                                             % O %                                                                             %;O %   R a i s e I m a g e                                                       %tO %                                                                             %pO %                                                                             %uO %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % K %  Function RaiseImage lightens and darkens the edges of an image to give a  %  3-D raised or lower effect. %(+ %  The format of the RaiseImage routine is:  % + %      RaiseImage(image,raised,bevel_width)  %f+ %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.l %<L %    o raised: A value other than zero causes the image to have a 3-D raised1 %      effect, otherwise it has a lowered effect.+ %pN %    o bevel_width: This unsigned integer defines the width of the 3-D effect. %  %  */) void RaiseImage(image,raised,bevel_width)) Image)	   *image;    int=	   raised;u   unsigned int   bevel_width; { # #define HighlightLeft  UpScale(160)>" #define HighlightTop  UpScale(180)! #define ShadowRight  UpScale(180))" #define ShadowBottom  UpScale(160)  	   Quantum      foreground,p     background;      register int     x,     y;     register RunlengthPacket     *p;>  .   if ((image->columns < (bevel_width << 1)) &&)       (image->rows < (bevel_width << 1)))O     { L       Warning("Unable to raise image","image size must exceed bevel width");
       return;      }e   if (!UncompressImage(image))     return;    foreground=MaxRGB;   background=0;e   if (!raised)     {        foreground=0;        background=MaxRGB;     }    image->class=DirectClass;    p=image->pixels;!   for (y=0; y < bevel_width; y++)    {      for (x=0; x < y; x++)      {        p->red=(unsigned int)fH         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int) J         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;u
       p++;     }(1     for (x=0; x < (image->columns-(y << 1)); x++)l     {        p->red=(unsigned int) F         (p->red*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB;       p->green=(unsigned int)+H         (p->green*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB;       p->blue=(unsigned int)G         (p->blue*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB; 
       p++;     }      for (x=0; x < y; x++)      {        p->red=(unsigned int) D         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int) F         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB; 
       p++;     }    } 6   for (y=0; y < (image->rows-(bevel_width << 1)); y++)   {%#     for (x=0; x < bevel_width; x++)%     {%       p->red=(unsigned int)oH         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int) J         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;r
       p++;     }e;     for (x=0; x < (image->columns-(bevel_width << 1)); x++)T
       p++;#     for (x=0; x < bevel_width; x++)      {d       p->red=(unsigned int)tD         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int) F         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB; 
       p++;     }    }a!   for (y=0; y < bevel_width; y++)/   {l'     for (x=0; x < (bevel_width-y); x++))     {;       p->red=(unsigned int)eH         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int)tJ         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB; 
       p++;     } ?     for (x=0; x < (image->columns-((bevel_width-y) << 1)); x++)u     {        p->red=(unsigned int)aF         (p->red*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;       p->green=(unsigned int))H         (p->green*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;       p->blue=(unsigned int)G         (p->blue*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;)
       p++;     }.'     for (x=0; x < (bevel_width-y); x++)=     {0       p->red=(unsigned int) D         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int)gF         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;f
       p++;     }    } 	   return;0 }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e d u c e I m a g e                                                     %nO %                                                                             %*O %                                                                             %vO %                                                                             %2O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eM %  Function ReduceImage creates a new image that is a integral size less than H %  an existing one.  It allocates the memory necessary for the new Image4 %  structure and returns a pointer to the new image. %mO %  ReduceImage scans the reference image to create a reduced image by computinggL %  the weighted average of a 4x4 cell centered at each reference pixel.  TheJ %  target pixel requires two columns and two rows of the reference pixels.7 %  Therefore the reduced image columns and rows become:a %  %    number_columns/2  %    number_rows/2 %rG %  Weights assume that the importance of neighboring pixels is negatelymF %  proportional to the square of their distance from the target pixel. %lL %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.- %l, %  The format of the ReduceImage routine is: %p' %      reduced_image=ReduceImage(image)  % + %  A description of each parameter follows:m %)I %    o reduced_image: Function ReduceImage returns a pointer to the image%G %      after reducing.  A null image is returned if there is a a memory = %      shortage or if the image size is less than IconSize*2.  % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *ReduceImage(image)  Image 	   *image;  {  #define Reduce(weight) \!   total_red+=(weight)*(s->red); \ %   total_green+=(weight)*(s->green); \ #   total_blue+=(weight)*(s->blue); \ %   total_matte+=(weight)*(s->index); \    s++;     Image      *reduced_image;      register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2,     *s3;     register unsigned int      x;     RunlengthPacket%     *scanline;     unsigned int     y;     unsigned int	     blue,n
     green,     packets,     red;     unsigned longu     total_matte,     total_blue,      total_green,     total_red;     unsigned short
     index;  0   if ((image->columns < 4) || (image->rows < 4))     {gE       Warning("Unable to reduce image","image size must exceed 3x3");t       return((Image *) NULL);m     }n   /*(     Initialize reduced image attributes.   */%   packets=Max(image->packets >> 2,1);e1   reduced_image=CopyImage(image,packets,1,False); &   if (reduced_image == (Image *) NULL)     { C       Warning("Unable to reduce image","Memory allocation failed");e       return((Image *) NULL);      }w#   reduced_image->class=DirectClass;e-   reduced_image->columns=image->columns >> 1; '   reduced_image->rows=image->rows >> 1;i   reduced_image->packets=0;    /*F     Allocate image buffer and scanline buffer for 4 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(4*(image->columns+1)*sizeof(RunlengthPacket));g+   if (scanline == (RunlengthPacket *) NULL);     {*C       Warning("Unable to reduce image","Memory allocation failed");("       DestroyImage(reduced_image);       return((Image *) NULL);(     })   /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1;a,   for (x=0; x < (4*(image->columns+1)); x++)     scanline[x]=(*p);s
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)n   {)     if (image->runlength != 0)       image->runlength--;      else       {N         p++;#         image->runlength=p->length;a       }n     *s=(*p);     s++;   }b   /*     Reduce each row.   */   p=image->pixels;   image->runlength=p->length+1;    q=reduced_image->pixels;   q->red=0;l
   q->green=0;n   q->blue=0;
   q->index=0;    q->length=MaxRunlength; &   for (y=0; y < (image->rows-1); y+=2)   {N     /*)       Initialize sliding window pointers.-     */+     s0=scanline+image->columns*((y+0) % 4);o+     s1=scanline+image->columns*((y+1) % 4);c+     s2=scanline+image->columns*((y+2) % 4);)+     s3=scanline+image->columns*((y+3) % 4);      /*       Read another scan line.o     */	     s=s2;m&     for (x=0; x < image->columns; x++)     {o        if (image->runlength != 0)         image->runlength--;P
       else	         {y           p++;%           image->runlength=p->length;u	         })       *s=(*p);
       s++;     }-     /*       Read another scan line.o     */	     s=s3;r&     for (x=0; x < image->columns; x++)     {a        if (image->runlength != 0)         image->runlength--;g
       else	         {            p++;%           image->runlength=p->length;n	         }        *s=(*p);
       s++;     } +     for (x=0; x < (image->columns-1); x+=2)      {        /*B         Compute weighted average of target pixel color components.  I         These particular coefficients total to 128.  Use 128/2-1 or 63 tol!         insure correct round off.t       */       total_red=0;       total_green=0;       total_blue=0;c       total_matte=0;       s=s0;i3       Reduce(3); Reduce(7);  Reduce(7);  Reduce(3);        s=s1;a3       Reduce(7); Reduce(15); Reduce(15); Reduce(7);n       s=s2;i3       Reduce(7); Reduce(15); Reduce(15); Reduce(7);f       s=s3;>3       Reduce(3); Reduce(7);  Reduce(7);  Reduce(3);g       s0+=2;       s1+=2;       s2+=2;       s3+=2;*       red=(Quantum) ((total_red+63) >> 7);.       green=(Quantum) ((total_green+63) >> 7);,       blue=(Quantum) ((total_blue+63) >> 7);5       index=(unsigned short) ((total_matte+63) >> 7);)H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         {;*           if (reduced_image->packets != 0)             q++;#           reduced_image->packets++; 0           if (reduced_image->packets == packets)
             {*               packets<<=1;H               reduced_image->pixels=(RunlengthPacket *) realloc((char *)G                 reduced_image->pixels,packets*sizeof(RunlengthPacket));>D               if (reduced_image->pixels == (RunlengthPacket *) NULL)                 {%O                   Warning("Unable to reduce image","Memory allocation failed"); .                   DestroyImage(reduced_image);)                   return((Image *) NULL);                  } ?               q=reduced_image->pixels+reduced_image->packets-1; 
             }            q->red=red;            q->green=green;            q->blue=blue;            q->index=index;            q->length=0;	         }      }    } <   reduced_image->pixels=(RunlengthPacket *) realloc((char *)J     reduced_image->pixels,reduced_image->packets*sizeof(RunlengthPacket));   free((char *) scanline);   return(reduced_image); }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %aO %                                                                             % O %     R G B T r a n s f o r m I m a g e                                       %.O %                                                                             % O %                                                                             %eO %                                                                             %cO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %nF %  Function RGBTransformImage converts the reference image from RGB toM %  an alternate colorspace.  The transformation matrices are not the standard L %  ones: the weights are rescaled to normalized the range of the transformed %  values to be [0..MaxRGB]. %t2 %  The format of the RGBTransformImage routine is: %c* %      RGBTransformImage(image,colorspace) % + %  A description of each parameter follows:i %eF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o colorspace: An unsigned integer value that indicates which colorspace %      to transform the image. %c %_ */( void RGBTransformImage(image,colorspace) Imagem	   *image;s   unsigned int
   colorspace;t {m #define X 0  #define Y (MaxRGB+1) #define Z (MaxRGB+1)*2     long     tx,o     ty,g     tz,      *x,(     *y,N     *z;   	   Quantumc     *range_table;r     register int	     blue,-
     green,     i,     red;     register Quantum     *range_limit;r     register RunlengthPacket     *p;   "   if (colorspace == RGBColorspace)     return;i   /*     Allocate the tables.   *//   x=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); /   y=(long *) malloc(3*(MaxRGB+1)*sizeof(long));c/   z=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); ?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum));d5   if ((x == (long *) NULL) || (y == (long *) NULL) || @       (z == (long *) NULL) || (range_table == (Quantum *) NULL))     { L       Warning("Unable to transform color space","Memory allocation failed");
       return;      }n   /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)    {i     range_table[i]=0;r*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;    } %   range_limit=range_table+(MaxRGB+1);o   tx=0;(   ty=0;    tz=0;1   switch (colorspace)g   {l     case GRAYColorspace:     {f       /*         Initialize GRAY tables:r  +           G = 0.29900*R+0.58600*G+0.11400*B        */!       for (i=0; i <= MaxRGB; i++)e       { $         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.29900)*i;$         y[i+Y]=UpShifted(0.58600)*i;$         z[i+Y]=UpShifted(0.11400)*i;$         x[i+Z]=UpShifted(0.29900)*i;$         y[i+Z]=UpShifted(0.58600)*i;$         z[i+Z]=UpShifted(0.11400)*i;       }+       break;     }      case OHTAColorspace:     {)       /*         Initialize OHTA tables:h  ,           I1 = 0.33333*R+0.33334*G+0.33333*B,           I2 = 0.50000*R+0.00000*G-0.50000*B,           I3 =-0.25000*R+0.50000*G-0.25000*B  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0>         through MaxRGB.)       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        {f$         x[i+X]=UpShifted(0.33333)*i;$         y[i+X]=UpShifted(0.33334)*i;$         z[i+X]=UpShifted(0.33333)*i;$         x[i+Y]=UpShifted(0.50000)*i;         y[i+Y]=0; '         z[i+Y]=(-UpShifted(0.50000))*i; '         x[i+Z]=(-UpShifted(0.25000))*i; $         y[i+Z]=UpShifted(0.50000)*i;'         z[i+Z]=(-UpShifted(0.25000))*i;[       }        break;     }      case XYZColorspace:      {p       /*"         Initialize CIE XYZ tables:  .           X = 0.412453*X+0.357580*Y+0.180423*Z.           Y = 0.212671*X+0.715160*Y+0.072169*Z.           Z = 0.019334*X+0.119193*Y+0.950227*Z       */!       for (i=0; i <= MaxRGB; i++)        { %         x[i+X]=UpShifted(0.412453)*i;-%         y[i+X]=UpShifted(0.357580)*i;n%         z[i+X]=UpShifted(0.180423)*i;t%         x[i+Y]=UpShifted(0.212671)*i; %         y[i+Y]=UpShifted(0.715160)*i;g%         z[i+Y]=UpShifted(0.072169)*i; %         x[i+Z]=UpShifted(0.019334)*i; %         y[i+Z]=UpShifted(0.119193)*i;u%         z[i+Z]=UpShifted(0.950227)*i;m       }i       break;     }>     case YCbCrColorspace:e     {        /*          Initialize YCbCr tables:  /           Y =  0.299000*R+0.586000*G+0.114000*B /           Cb= -0.172586*R-0.338828*G+0.511414*B /           Cr=  0.511414*R-0.428246*G-0.083168*Bm  K         Cb and Cr, normally -0.5 through 0.5, are normalized to the range 0m         through MaxRGB.)       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)e       {e%         x[i+X]=UpShifted(0.299000)*i;p%         y[i+X]=UpShifted(0.586000)*i;e%         z[i+X]=UpShifted(0.114000)*i;-(         x[i+Y]=(-UpShifted(0.172586))*i;(         y[i+Y]=(-UpShifted(0.338828))*i;%         z[i+Y]=UpShifted(0.511414)*i;;%         x[i+Z]=UpShifted(0.511414)*i;a(         y[i+Z]=(-UpShifted(0.428246))*i;(         z[i+Z]=(-UpShifted(0.083168))*i;       }e       break;     }m     case YCCColorspace:      {        /*         Initialize YCC tables:  +           Y = 0.29900*R+0.58600*G+0.11400*Bp+           C1=-0.29900*R-0.58600*G+0.88600*B +           C2= 0.70100*R-0.58600*G+0.11400*B   B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */0       ty=UpShifted((unsigned int) UpScale(156));0       tz=UpShifted((unsigned int) UpScale(137));!       for (i=0; i <= MaxRGB; i++)        {p$         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;'         x[i+Y]=(-UpShifted(0.29900))*i;+'         y[i+Y]=(-UpShifted(0.58600))*i; $         z[i+Y]=UpShifted(0.88600)*i;$         x[i+Z]=UpShifted(0.70100)*i;'         y[i+Z]=(-UpShifted(0.58600))*i; '         z[i+Z]=(-UpShifted(0.11400))*i;        }o       break;     }m     case YIQColorspace:      {(       /*         Initialize YIQ tables:  +           Y = 0.29900*R+0.58600*G+0.11400*B +           I = 0.50000*R-0.23000*G-0.27000*B +           Q = 0.20200*R-0.50000*G+0.29800*Br  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.l       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)e       {p$         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.50000)*i;'         y[i+Y]=(-UpShifted(0.23000))*i;t'         z[i+Y]=(-UpShifted(0.27000))*i; $         x[i+Z]=UpShifted(0.20200)*i;'         y[i+Z]=(-UpShifted(0.50000))*i;%$         z[i+Z]=UpShifted(0.29800)*i;       }        break;     }      case YPbPrColorspace:      {        /*          Initialize YPbPr tables:  /           Y =  0.299000*R+0.587000*G+0.114000*B /           Pb= -0.168736*R-0.331264*G+0.500000*B /           Pr=  0.500000*R-0.418688*G-0.081312*B   K         Pb and Pr, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        { %         x[i+X]=UpShifted(0.299000)*i; %         y[i+X]=UpShifted(0.587000)*i;%%         z[i+X]=UpShifted(0.114000)*i;%(         x[i+Y]=(-UpShifted(0.168736))*i;(         y[i+Y]=(-UpShifted(0.331264))*i;%         z[i+Y]=UpShifted(0.500000)*i;D%         x[i+Z]=UpShifted(0.500000)*i;s(         y[i+Z]=(-UpShifted(0.418688))*i;(         z[i+Z]=(-UpShifted(0.081312))*i;       }d       break;     }o     case YUVColorspace:/     default:     {i       /*         Initialize YUV tables:  ,           Y =  0.29900*R+0.58600*G+0.11400*B,           U = -0.14740*R-0.28950*G+0.43690*B,           V =  0.61500*R-0.51500*G-0.10000*B  I         U and V, normally -0.5 through 0.5, are normalized to the range 0(D         through MaxRGB.  Note that U = 0.493*(B-Y), V = 0.877*(R-Y).       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)%       {m$         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;'         x[i+Y]=(-UpShifted(0.14740))*i; '         y[i+Y]=(-UpShifted(0.28950))*i; $         z[i+Y]=UpShifted(0.43690)*i;$         x[i+Z]=UpShifted(0.61500)*i;'         y[i+Z]=(-UpShifted(0.51500))*i;e'         z[i+Z]=(-UpShifted(0.10000))*i;a       }e       break;     }    }i   /*     Convert from RGB.s   */   switch (image->class)l   {=     case DirectClass:r     {d       /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {e         red=p->red;>         green=p->green;          blue=p->blue;nH         p->red=range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)];J         p->green=range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];I         p->blue=range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];m         p++;       }f       break;     }0     case PseudoClass:s     {%       /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)-       {g#         red=image->colormap[i].red;%'         green=image->colormap[i].green;%%         blue=image->colormap[i].blue;          image->colormap[i].red= C           range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)]; !         image->colormap[i].green= C           range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];           image->colormap[i].blue=C           range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];        }        SyncImage(image);        break;     }    }    /*     Free allocated memory.   */   free((char *) range_table);    free((char *) z);    free((char *) y);%   free((char *) x);% }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %tO %                                                                             %1O %                                                                             % O %   R o l l I m a g e                                                         %xO %                                                                             %eO %                                                                             %eO %                                                                             %kO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function RollImage rolls an image vertically and horizontally.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % * %  The format of the RollImage routine is: %y1 %      rolled_image=RollImage(image,columns,rows)  %/+ %  A description of each parameter follows:t %oL %    o rolled_image: Function RollImage returns a pointer to the image afterH %      rolling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % H %    o x_offset: An integer that specifies the number of columns to roll# %      in the horizontal direction.l %sL %    o y_offset: An integer that specifies the number of rows to roll in the %      veritical direction.  %o %x */) Image *RollImage(image,x_offset,y_offset)) Image 	   *image;>   int    x_offset,    y_offset;  {    Image;     *rolled_image;     register RunlengthPacket     *p,      *q;      register unsigned int      packets,     x;     unsigned int     y;     /*'     Initialize rolled image attributes.    */A   rolled_image=CopyImage(image,image->columns,image->rows,False); %   if (rolled_image == (Image *) NULL)      {yA       Warning("Unable to roll image","Memory allocation failed");s       return((Image *) NULL);      }+   /*     Roll image.    */   p=image->pixels;   image->runlength=p->length+1; %   packets=image->columns*image->rows; !   for (y=0; y < image->rows; y++))   {1     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--;u
       else	         {            p++;%           image->runlength=p->length;*	         } D       q=rolled_image->pixels+(y_offset+y)*image->columns+x+x_offset;#       if (q < rolled_image->pixels)          q+=packets; 
       else0         if (q >= (rolled_image->pixels+packets))           q-=packets;        *q=(*p);       q->length=0;     }u   }    return(rolled_image);  }f , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %iO %   S a m p l e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %mG %  Function SampleImage creates a new image that is a scaled size of anaH %  existing one using pixel sampling.  It allocates the memory necessaryF %  for the new Image structure and returns a pointer to the new image. %(, %  The format of the SampleImage routine is: %n4 %      sampled_image=SampleImage(image,columns,rows) %(+ %  A description of each parameter follows:  %aO %    o sampled_image: Function SampleImage returns a pointer to the image after H %      scaling.  A null image is returned if there is a memory shortage. %;7 %    o image: The address of a structure of type Image.m % N %    o columns: An integer that specifies the number of columns in the sampled
 %      image.  % H %    o rows: An integer that specifies the number of rows in the sampled
 %      image.] %  %  */& Image *SampleImage(image,columns,rows) Imageo	   *image;o   unsigned int
   columns,   rows;s {    Imageg     *sampled_image;0     intg     y;     register RunlengthPacket     *p,      *q,c     *s;+     register int     x;     RunlengthPacket      *scanline;     unsigned int     *x_offset,     *y_offset;     unsigned long>     scale_factor;   $   if ((columns == 0) || (rows == 0))     {eD       Warning("Unable to sample image","image dimensions are zero");       return((Image *) NULL);n     }-   /*(     Initialize sampled image attributes.   */4   sampled_image=CopyImage(image,columns,rows,False);&   if (sampled_image == (Image *) NULL)     {cC       Warning("Unable to sample image","Memory allocation failed");d       return((Image *) NULL);      }u   /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));P   x_offset=(unsigned int *) malloc(sampled_image->columns*sizeof(unsigned int));M   y_offset=(unsigned int *) malloc(sampled_image->rows*sizeof(unsigned int));o/   if ((scanline == (RunlengthPacket *) NULL) ||,,       (x_offset == (unsigned int *) NULL) ||*       (y_offset == (unsigned int *) NULL))     {lC       Warning("Unable to sample image","Memory allocation failed");0"       DestroyImage(sampled_image);       return((Image *) NULL);w     }c   /*$     Initialize column pixel offsets.   */@   scale_factor=UpShift(image->columns-1)/sampled_image->columns;   columns=0;,   for (x=0; x < sampled_image->columns; x++)   {[<     x_offset[x]=DownShift((x+1)*scale_factor)-(int) columns;     columns+=x_offset[x];e   }f   /*!     Initialize row pixel offsets.g   */:   scale_factor=UpShift(image->rows-1)/sampled_image->rows;	   rows=0;j)   for (y=0; y < sampled_image->rows; y++)g   {l9     y_offset[y]=DownShift((y+1)*scale_factor)-(int) rows;g     rows+=y_offset[y];   } $   y_offset[sampled_image->rows-1]=0;   /*     Preload first scanline.t   */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline;.$   for (x=0; x < image->columns; x++)   {h     if (image->runlength != 0)       image->runlength--;r     else       {n         p++;#         image->runlength=p->length;%       }%     *s=(*p);     s->length=0;     s++;   }%   /*     Sample each row.   */   q=sampled_image->pixels;)   for (y=0; y < sampled_image->rows; y++)    {      /*       Sample each column.      */     s=scanline; .     for (x=0; x < sampled_image->columns; x++)     {        *q=(*s);
       q++;       s+=x_offset[x];      }      if (y_offset[y] != 0)        { 
         /*           Skip a scan line. 
         */         if (y_offset[y] > 1)>           for (x=0; x < (image->columns*(y_offset[y]-1)); x++)&             if (image->runlength != 0)!               image->runlength--;              else               {                  p++;+                 image->runlength=p->length;%               }%
         /*           Read a scan line.t
         */         s=scanline;e*         for (x=0; x < image->columns; x++)	         { $           if (image->runlength != 0)             image->runlength--;f           else
             {                p++;)               image->runlength=p->length;y
             }m           *s=(*p);           s->length=0;           s++;	         }*       }s   }g   free((char *) scanline);   free((char *) x_offset);   free((char *) y_offset);   return(sampled_image); }  L /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/O %                                                                             % O %                                                                             %)O %                                                                             %LO %   S c a l e I m a g e                                                       %.O %                                                                             %cO %                                                                             %uO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %hF %  Function ScaleImage creates a new image that is a scaled size of anE %  existing one.  It allocates the memory necessary for the new ImagetI %  structure and returns a pointer to the new image.  To scale a scanlineLK %  from x pixels to y pixels, each new pixel represents x/y old pixels.  To%L %  read x/y pixels, read (x/y rounded up) pixels but only count the requiredH %  fraction of the last old pixel read in your new pixel.  The remainder: %  of the old pixel will be counted in the next new pixel. % K %  The scaling algorithm was suggested by rjohnson@shell.com and is adapted 0 %  from pnmscale(1) of PBMPLUS by Jef Poskanzer. % + %  The format of the ScaleImage routine is:  % 2 %      scaled_image=ScaleImage(image,columns,rows) % + %  A description of each parameter follows:  % M %    o scaled_image: Function ScaleImage returns a pointer to the image after H %      scaling.  A null image is returned if there is a memory shortage. %%7 %    o image: The address of a structure of type Image.e %yM %    o columns: An integer that specifies the number of columns in the scaledy
 %      image.i % G %    o rows: An integer that specifies the number of rows in the scaledf
 %      image.  %o %a */% Image *ScaleImage(image,columns,rows)e Image 	   *image;d   unsigned int
   columns,   rows;a {    typedef struct ScaledPacket;   {      long
       red,       green,       blue,        index;   } ScaledPacket;g     Image      *scaled_image;     int!
     next_row,L     number_rows;     long     x_scale,     x_span;      register RunlengthPacket     *p,t     *q;a     register ScaledPackete     *s,      *t;=     register unsigned inta     x;     ScaledPacket     *scaled_scanline,%     *scanline,     *y_vector,     *x_vector;     unsigned int     packets,     y;     unsigned long 	     blue, 
     green,
     index,     red,     scale_factor;   $   if ((columns == 0) || (rows == 0))     { C       Warning("Unable to scale image","image dimensions are zero");        return((Image *) NULL);      }    /*'     Initialize scaled image attributes.    */B   scale_factor=UpShift(columns*rows)/(image->columns*image->rows);8   packets=Max(DownShift(image->packets*scale_factor),1);0   scaled_image=CopyImage(image,packets,1,False);%   if (scaled_image == (Image *) NULL)%     {%B       Warning("Unable to scale image","Memory allocation failed");       return((Image *) NULL);n     }n"   scaled_image->class=DirectClass;    scaled_image->columns=columns;   scaled_image->rows=rows;   scaled_image->packets=0;   /*     Allocate memory.   */H   x_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));   scanline=x_vector;(   if (scaled_image->rows != image->rows)J     scanline=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));"   scaled_scanline=(ScaledPacket *)7     malloc(scaled_image->columns*sizeof(ScaledPacket)); H   y_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));,   if ((x_vector == (ScaledPacket *) NULL) ||,       (scanline == (ScaledPacket *) NULL) ||3       (scaled_scanline == (ScaledPacket *) NULL) || *       (y_vector == (ScaledPacket *) NULL))     {nB       Warning("Unable to scale image","Memory allocation failed");!       DestroyImage(scaled_image);        return((Image *) NULL);e     }    /*     Scale image.   */   number_rows=0;   next_row=True;2   x_scale=UpShift(scaled_image->rows)/image->rows;   x_span=UpShift(1);$   for (x=0; x < image->columns; x++)   {l     y_vector[x].red=0;     y_vector[x].green=0;     y_vector[x].blue=0;      y_vector[x].index=0;   }    p=image->pixels;   image->runlength=p->length+1;g   q=scaled_image->pixels;    q->red=0; 
   q->green=0;,   q->blue=0;
   q->index=0;g   q->length=MaxRunlength;n(   for (y=0; y < scaled_image->rows; y++)   {n*     if (scaled_image->rows == image->rows)(       for (x=0; x < image->columns; x++)       { 
         /*           Read a new scanline.
         */"         if (image->runlength != 0)           image->runlength--;i         else           {s             p++;'             image->runlength=p->length;m           }s         x_vector[x].red=p->red;a#         x_vector[x].green=p->green;U!         x_vector[x].blue=p->blue;o#         x_vector[x].index=p->index;        }      else       {d
         /*           Scale Y direction.
         */          while (x_scale < x_span)	         {c6           if (next_row && (number_rows < image->rows))
             {e               /*$                 Read a new scanline.               */0               for (x=0; x < image->columns; x++)               {o*                 if (image->runlength != 0)%                   image->runlength--;e                 else                   {m                     p++;/                     image->runlength=p->length;                    }<'                 x_vector[x].red=p->red;h+                 x_vector[x].green=p->green; )                 x_vector[x].blue=p->blue;e+                 x_vector[x].index=p->index;                }                number_rows++;
             }a,           for (x=0; x < image->columns; x++)           {k5             y_vector[x].red+=x_scale*x_vector[x].red;a9             y_vector[x].green+=x_scale*x_vector[x].green;o7             y_vector[x].blue+=x_scale*x_vector[x].blue;_9             y_vector[x].index+=x_scale*x_vector[x].index;            }            x_span-=x_scale;:           x_scale=UpShift(scaled_image->rows)/image->rows;           next_row=True;	         }y4         if (next_row && (number_rows < image->rows))           {n             /*"               Read a new scanline.             */.             for (x=0; x < image->columns; x++)
             { (               if (image->runlength != 0)#                 image->runlength--;l               else                 {                    p++;-                   image->runlength=p->length;                  } %               x_vector[x].red=p->red; )               x_vector[x].green=p->green;;'               x_vector[x].blue=p->blue;+)               x_vector[x].index=p->index;t
             }a             number_rows++;             next_row=False;;           }_         s=scanline;_*         for (x=0; x < image->columns; x++)	         {)@           red=DownShift(y_vector[x].red+x_span*x_vector[x].red);F           green=DownShift(y_vector[x].green+x_span*x_vector[x].green);C           blue=DownShift(y_vector[x].blue+x_span*x_vector[x].blue); F           index=DownShift(y_vector[x].index+x_span*x_vector[x].index);-           s->red=red > MaxRGB ? MaxRGB : red;R3           s->green=green > MaxRGB ? MaxRGB : green;a0           s->blue=blue > MaxRGB ? MaxRGB : blue;E           s->index=index > MaxColormapSize ? MaxColormapSize : index;>           s++;           y_vector[x].red=0;           y_vector[x].green=0;           y_vector[x].blue=0;            y_vector[x].index=0;	         }u         x_scale-=x_span;         if (x_scale == 0)            {u<             x_scale=UpShift(scaled_image->rows)/image->rows;             next_row=True;           }          x_span=UpShift(1);       }*0     if (scaled_image->columns == image->columns)       {q
         /*,           Transfer scanline to scaled image.
         */         s=scanline;x1         for (x=0; x < scaled_image->columns; x++)n	         { =           if ((s->red == q->red) && (s->green == q->green) &&g?               (s->blue == q->blue) && (s->index == q->index) &&e/               ((int) q->length < MaxRunlength))              q->length++;           else
             {g-               if (scaled_image->packets != 0)%                 q++;&               scaled_image->packets++;3               if (scaled_image->packets == packets)                  {                    packets<<=1;K                   scaled_image->pixels=(RunlengthPacket *) realloc((char *) J                     scaled_image->pixels,packets*sizeof(RunlengthPacket));G                   if (scaled_image->pixels == (RunlengthPacket *) NULL)                      { 6                       Warning("Unable to scale image",4                         "Memory allocation failed");1                       DestroyImage(scaled_image);%-                       return((Image *) NULL);                      }rA                   q=scaled_image->pixels+scaled_image->packets-1;d                 }t               q->red=s->red;                q->green=s->green;               q->blue=s->blue;                q->index=s->index;               q->length=0;
             }t           s++;	         }2       }      else       {          int            next_column;           long int           y_scale,           y_span;h  
         /*           Scale X direction.
         */         red=0;         green=0;         blue=0;          next_column=False;         y_span=UpShift(1);         s=scanline;          t=scaled_scanline;*         for (x=0; x < image->columns; x++)	         {a@           y_scale=UpShift(scaled_image->columns)/image->columns;#           while (y_scale >= y_span)e           {s             if (next_column)               {r                 red=0;                 green=0;                 blue=0;                  index=0;                 t++;               }\-             red=DownShift(red+y_span*s->red);o3             green=DownShift(green+y_span*s->green);e0             blue=DownShift(blue+y_span*s->blue);3             index=DownShift(index+y_span*s->index); /             t->red=red > MaxRGB ? MaxRGB : red;n5             t->green=green > MaxRGB ? MaxRGB : green; 2             t->blue=blue > MaxRGB ? MaxRGB : blue;G             t->index=index > MaxColormapSize ? MaxColormapSize : index;n             y_scale-=y_span;             y_span=UpShift(1);             next_column=True;a           }          if (y_scale > 0)           {              if (next_column)               {                  red=0;                 green=0;                 blue=0;m                 index=0;"                 next_column=False;                 t++;               }               red+=y_scale*s->red;$             green+=y_scale*s->green;"             blue+=y_scale*s->blue;$             index+=y_scale*s->index;             y_span-=y_scale;           }/         s++;       }P       if (y_span > 0)-	         {z           s--;           red+=y_span*s->red;e!           green+=y_span*s->green;            blue+=y_span*s->blue;,!           index+=y_span*s->index; 	         }e       if (!next_column)u	         {)           red=DownShift(red);d!           green=DownShift(green);            blue=DownShift(blue);-!           index=DownShift(index);i-           t->red=red > MaxRGB ? MaxRGB : red;+3           t->green=green > MaxRGB ? MaxRGB : green;-0           t->blue=blue > MaxRGB ? MaxRGB : blue;3           t->index=index > MaxRGB ? MaxRGB : index;s	         }        /**         Transfer scanline to scaled image.       */       t=scaled_scanline;/       for (x=0; x < scaled_image->columns; x++)u       {a;         if ((t->red == q->red) && (t->green == q->green) &&d=             (t->blue == q->blue) && (t->index == q->index) && -             ((int) q->length < MaxRunlength))            q->length++;         else           {e+             if (scaled_image->packets != 0)i               q++;$             scaled_image->packets++;1             if (scaled_image->packets == packets)l               {                  packets<<=1;I                 scaled_image->pixels=(RunlengthPacket *) realloc((char *) H                   scaled_image->pixels,packets*sizeof(RunlengthPacket));E                 if (scaled_image->pixels == (RunlengthPacket *) NULL)+                   {rP                     Warning("Unable to scale image","Memory allocation failed");/                     DestroyImage(scaled_image); +                     return((Image *) NULL);x                   }n?                 q=scaled_image->pixels+scaled_image->packets-1;                }r             q->red=t->red;             q->green=t->green;             q->blue=t->blue;             q->index=t->index;             q->length=0;           }          t++;       }      })   }e;   scaled_image->pixels=(RunlengthPacket *) realloc((char *) H     scaled_image->pixels,scaled_image->packets*sizeof(RunlengthPacket));   /*     Free allocated memory.   */   free((char *) y_vector);!   free((char *) scaled_scanline);e   if (scanline != x_vector)      free((char *) scanline);   free((char *) x_vector);   return(scaled_image);l }( t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             %tO %                                                                             % O %                                                                             %fO %   S e t I m a g e M a g i c k                                               %lO %                                                                             %qO %                                                                             %zO %                                                                             %*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function SetImageMagick initializes the `magick' field of the ImageInfoI %  structure.  It is set to a type of image format based on the prefix or I %  suffix of the filename.  For example, `ps:image' returns PS indicating H %  a Postscript image.  JPEG is returned for this filename: `image.jpg'.M %  The filename prefix has precedance over the suffix.  Use an optional index L %  enclosed in brackets after a file name to specify a desired subimage of aE %  multi-resolution image format like Photo CD (e.g. img0001.pcd[4]).% %%/ %  The format of the SetImageMagick routine is:o %n! %      SetImageMagick(image_info)  %a+ %  A description of each parameter follows:e %e@ %    o image_info: Specifies a pointer to a ImageInfo structure. %e %d */ void SetImageMagick(image_info) 	 ImageInfon   *image_info; {h
   static charp     *ImageFormats[]=     {c       "AVS",       "BIE",       "BMP",
       "CMYK",e       "EPS",
       "EPSF",r
       "EPSI",a       "FAX",
       "FITS",        "FTP",       "GIF",       "GIF87",       "GOPHER",s
       "GRAY",p       "G3",o       "HDF",       "HISTOGRAM",
       "HTTP",e
       "JBIG",s
       "JPEG",s       "JPG",
       "LOGO",t       "MAP",       "MATTE",
       "MIFF",,       "MPG",
       "MPEG",s       "MTV",
       "NULL",f       "PBM",       "PCD",       "PCX",       "PDF",       "PGM",
       "PICT",e       "PM",c       "PNG",       "PPM",       "PNM",       "PS",f       "PS2",       "RAD",       "RAS",       "RGB",
       "RGBA",i       "RLE",       "SGI",       "SUN",       "TGA",
       "TEXT",n       "TIF",
       "TIFF", 
       "TILE",        "VICAR",       "VID",
       "VIFF", 
       "X",       "XBM",       "XC",I       "XPM",       "XV",E       "XWD",       "YUV",
       "YUV3",        (char *) NULL,     };     char     c,     magick[MaxTextLength];     register chars     *p,      *q;n     register int     i;     /*(     Look for 'image.format' in filename.   */   *magick='\0';e8   p=image_info->filename+strlen(image_info->filename)-1;   if (*p == ']')     {T       /*F         Look for sub-image enclosed in brackets (e.g. img0001.pcd[4]).       */0       for (q=p-1; q > image_info->filename; q--)(         if (!isdigit(*q) && (*q != '-'))           break;       if (*q == '[')	         {b           p=q++;'           image_info->subimage=atoi(q);;'           image_info->subrange=atoi(q);uO           (void) sscanf(q,"%u-%u",&image_info->subimage,&image_info->subrange); 7           image_info->subrange-=image_info->subimage-1;,           *p='\0';	         }e     } 3   while ((*p != '.') && (p > image_info->filename))      p--;6   if ((strcmp(p,".gz") == 0) || (strcmp(p,".Z") == 0))     do     {_
       p--;8     } while ((*p != '.') && (p > image_info->filename));2   if ((*p == '.') && (strlen(p) < sizeof(magick)))     {e       /*$         User specified image format.       */        (void) strcpy(magick,p+1);%       for (q=magick; *q != '\0'; q++)s       {          if (*q == '.')           {e             *q='\0';             break;           }          c=(*q); %         if (isascii(c) && islower(c))e           *q=toupper(c);       };6       for (i=0; ImageFormats[i] != (char *) NULL; i++)0         if (strcmp(magick,ImageFormats[i]) == 0)           {              /*(               SGI and RGB are ambiguous.             */=             if ((strncmp(image_info->magick,"SGI",3) != 0) ||m5                 (strcmp(ImageFormats[i],"RGB") != 0))s7               (void) strcpy(image_info->magick,magick);=             break;           }      }    /*1     Look for explicit 'format:image' in filename.e   */   image_info->assert=False;m   p=image_info->filename; %   while ((*p != ':') && (*p != '\0'))      p++;A   if ((*p == ':') && ((p-image_info->filename) < sizeof(magick)))t     {t       /*$         User specified image format.       */I       (void) strncpy(magick,image_info->filename,p-image_info->filename);)*       magick[p-image_info->filename]='\0';%       for (q=magick; *q != '\0'; q++)        {          c=(*q); %         if (isascii(c) && islower(c))            *q=toupper(c);       } 6       for (i=0; ImageFormats[i] != (char *) NULL; i++)0         if (strcmp(magick,ImageFormats[i]) == 0)           {o             /*,               Strip off image format prefix.             */             p++;2             (void) strcpy(image_info->filename,p);5             (void) strcpy(image_info->magick,magick);o$             image_info->assert=True;             break;           }      }l }+ g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             % O %                                                                             %mO %     S h a r p e n I m a g e                                                 % O %                                                                             % O %                                                                             %lO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eJ %  Function SharpenImage creates a new image that is a copy of an existingL %  one with the pixels sharpened.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % K %  SharpenImage convolves the pixel neighborhood with this sharpening mask:  % 
 %    -1 -2 -1E
 %    -2  W -2a
 %    -1 -2 -1e %;L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.n %c- %  The format of the SharpenImage routine is:e %)1 %      sharpened_image=SharpenImage(image,factor)4 % + %  A description of each parameter follows:E %nL %    o sharpened_image: Function SharpenImage returns a pointer to the imageL %      after it is sharpened.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.- %dL %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */! Image *SharpenImage(image,factor)e Image 	   *image;2   double	   factor;  {x #define Sharpen(weight) \;'   total_red+=(weight)*(int) (s->red); \++   total_green+=(weight)*(int) (s->green); \i)   total_blue+=(weight)*(int) (s->blue); \o+   total_index+=(weight)*(int) (s->index); \n   s++;     Image      *sharpened_image;l  
   long int     total_blue,      total_green,     total_index,     total_red,     weight;*     register RunlengthPacket     *p,      *q,      *s,%     *s0,     *s1,     *s2;     register unsigned int%     x;     RunlengthPacket      *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     { F       Warning("Unable to sharpen image","image size must exceed 3x3");       return((Image *) NULL);      }    /**     Initialize sharpened image attributes.   */D   sharpened_image=CopyImage(image,image->columns,image->rows,False);(   if (sharpened_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);%     }%%   sharpened_image->class=DirectClass;%   /*6     Allocate scan line buffer for 3 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(3*(image->columns+1)*sizeof(RunlengthPacket)); +   if (scanline == (RunlengthPacket *) NULL)n     {hD       Warning("Unable to enhance image","Memory allocation failed");$       DestroyImage(sharpened_image);       return((Image *) NULL);l     }e   /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1;t,   for (x=0; x < (3*(image->columns+1)); x++)     scanline[x]=(*p);o
   s=scanline;,+   for (x=0; x < (image->columns << 1); x++)l   {i     if (image->runlength != 0)       image->runlength--;(     else       {n         p++;#         image->runlength=p->length;G       }o     *s=(*p);     s++;   }e   /*!     Dump first scanline of image.(   */   q=sharpened_image->pixels;
   s=scanline;L$   for (x=0; x < image->columns; x++)   {      *q=(*s);     q->index=0;)     q->length=0;     q++;     s++;   }e   /*     Convolve each row.   */*   weight=(long int) ((100.0-factor)/2+13);   quantum=Max(weight-12,1); %   for (y=1; y < (image->rows-1); y++)[   {      /*)       Initialize sliding window pointers.s     */+     s0=scanline+image->columns*((y-1) % 3);h'     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.+     */	     s=s2;s&     for (x=0; x < image->columns; x++)     {*        if (image->runlength != 0)         image->runlength--;h
       else	         {            p++;%           image->runlength=p->length; 	         }e       *s=(*p);
       s++;     }p     /*+       Transfer first pixel of the scanline.i     */
     *q=(*s1);      q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;s       total_index=0;       s=s0;;,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       s=s1; 0       Sharpen(-2); Sharpen(weight); Sharpen(-2);       s=s2;-,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       if (total_red < 0)         q->red=0; 
       else)         if (total_red > (MaxRGB*quantum))q           q->red=MaxRGB;         else@           q->red=(Quantum) ((total_red+(quantum >> 1))/quantum);       if (total_green < 0)         q->green=0;r
       else+         if (total_green > (MaxRGB*quantum))-           q->green=MaxRGB;         elseD           q->green=(Quantum) ((total_green+(quantum >> 1))/quantum);       if (total_blue < 0)a         q->blue=0;
       else*         if (total_blue > (MaxRGB*quantum))           q->blue=MaxRGB;%         elseB           q->blue=(Quantum) ((total_blue+(quantum >> 1))/quantum);       if (total_index < 0)         q->index=0; 
       else+         if (total_index > (MaxRGB*quantum))            q->index=MaxRGB;         elseK           q->index=(unsigned short) ((total_index+(quantum >> 1))/quantum);        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */	     s1++; 
     *q=(*s1);      q->length=0;     q++;   }    /*!     Dump last scanline of pixels.    */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {%     *q=(*s);     q->length=0;     q++;     s++;   }    free((char *) scanline);   return(sharpened_image); }s l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %FO %                                                                             %pO %                                                                             %tO %   S o r t C o l o r m a p B y I n t e n t s i t y                           %iO %                                                                             %uO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %lM %  Function SortColormapByIntensity sorts the colormap of a PseudoClass imageo! %  by decreasing color intensity.> %s8 %  The format of the SortColormapByIntensity routine is: % % %      SortColormapByIntensity(image)y %l+ %  A description of each parameter follows:L % - %    o image: A pointer to a Image structure.n %o %n */  static int IntensityCompare(x,y)
 const void   *x,l   *y;g {c
   ColorPacketu
     *color_1,;
     *color_2;e     color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }f  # void SortColormapByIntensity(image)N Image 	   *image;* {    register int     i;     register RunlengthPacket     *p;p     register unsigned shortg
     index;     unsigned short     *pixels;  "   if (image->class != PseudoClass)     return;    /*&     Allocate memory for pixel indexes.   */I   pixels=(unsigned short *) malloc(image->colors*sizeof(unsigned short)); (   if (pixels == (unsigned short *) NULL)     { D       Warning("Unable to sort colormap","Memory allocation failed");
       return;(     }    /*,     Assign index values to colormap entries.   */#   for (i=0; i < image->colors; i++) 0     image->colormap[i].index=(unsigned short) i;   /*7     Sort image colormap by decreasing color popularity.    */I   qsort((void *) image->colormap,(int) image->colors,sizeof(ColorPacket),%G     (int (*) _Declare((const void *, const void *))) IntensityCompare);%   /*;     Update image colormap indexes to sorted colormap order.    */#   for (i=0; i < image->colors; i++) 8     pixels[image->colormap[i].index]=(unsigned short) i;   p=image->pixels;$   for (i=0; i < image->packets; i++)   {      index=pixels[p->index]; &     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p->index=index;      p++;   }    free((char *) pixels); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             %rO %                                                                             %eO %   S t e r e o I m a g e                                                     % O %                                                                             %iO %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function StereoImage combines two images and produces a single image thatI %  is the composite of a left and right image of a stereo pair.  The leftgH %  image is converted to grayscale and written to the red channel of theN %  stereo image.  The right image is converted to grayscale and written to theL %  blue channel of the stereo image.  View the composite image with red-blue% %  glasses to create a stereo effect.m % , %  The format of the StereoImage routine is: %t7 %      stereo_image=StereoImage(left_image,right_image)  %N+ %  A description of each parameter follows:b %eI %    o stereo_image: Function StereoImage returns a pointer to the stereomF %      image.  A null image is returned if there is a memory shortage. %*< %    o left_image: The address of a structure of type Image. % = %    o right_image: The address of a structure of type Image.  %u %( */* Image *StereoImage(left_image,right_image) Image/   *left_image,   *right_image;n {g   Imageg     *stereo_image;     register int     i;     register RunlengthPacket     *p,      *q,      *r;a  6   if ((left_image->columns != right_image->columns) ||.       (left_image->rows != right_image->rows))     {h.       Warning("Unable to create stereo image",-         "left and right image sizes differ");r       return((Image *) NULL);      }    /*'     Initialize stereo image attributes.p   */P   stereo_image=CopyImage(left_image,left_image->columns,left_image->rows,False);%   if (stereo_image == (Image *) NULL)      {sJ       Warning("Unable to create stereo image","Memory allocation failed");       return((Image *) NULL);      } "   stereo_image->class=DirectClass;   /*C     Copy left image to red channel and right image to blue channel.    */7   QuantizeImage(left_image,256,8,False,GRAYColorspace);    SyncImage(left_image);   p=left_image->pixels; $   left_image->runlength=p->length+1;8   QuantizeImage(right_image,256,8,False,GRAYColorspace);   SyncImage(right_image);    q=right_image->pixels;%   right_image->runlength=q->length+1;    r=stereo_image->pixels; @   for (i=0; i < (stereo_image->columns*stereo_image->rows); i++)   { #     if (left_image->runlength != 0)        left_image->runlength--;     else       {          p++;(         left_image->runlength=p->length;       }%$     if (right_image->runlength != 0)       right_image->runlength--;F     else       {t         q++;)         right_image->runlength=q->length;u       }.+     r->red=(unsigned int) (p->red*12) >> 4;e     r->green=0;c     r->blue=q->blue;     r->index=0;m     r->length=0;     r++;   }a   return(stereo_image);  }  f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %dO %                                                                             % O %                                                                             %eO %   S y n c I m a g e                                                         %nO %                                                                             %IO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %nN %  Function SyncImage initializes the red, green, and blue intensities of each* %  pixel as defined by the colormap index. %e* %  The format of the SyncImage routine is: %a %      SyncImage(image)  %a+ %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.e %; %  */ void SyncImage(image)t Image_	   *image;e {i   register int     i;     register RunlengthPacket     *p;t     register unsigned shortu
     index;     p=image->pixels;#   for (i=0; i < image->colors; i++)e   {e     image->colormap[i].index=0;)     image->colormap[i].flags=0;    } $   for (i=0; i < image->packets; i++)   {b     index=p->index;d&     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p++;   }o }a i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %_O %                                                                             %eO %                                                                             % O %   T r a n s f o r m I m a g e                                               %-O %                                                                             %dO %                                                                             %eO %                                                                             %wO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d %aL %  Function TransformImage creates a new image that is a transformed size ofE %  of existing one as specified by the crop and image geometries.  ItoK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %yH %  If a crop geometry is specified a subregion of the image is obtained.M %  If the specified image size, as defined by the image and scale geometries,<J %  is smaller than the actual image size, the image is first reduced to anN %  integral of the specified image size with an antialias digital filter.  TheD %  image is then scaled to the exact specified image size with pixelM %  replication.  If the specified image size is greater than the actual imageeJ %  size, the image is first enlarged to an integral of the specified imageK %  size with bilinear interpolation.  The image is then scaled to the exactv/ %  specified image size with pixel replication.t %r/ %  The format of the TransformImage routine is:l %d9 %      TransformImage(image,crop_geometry,image_geometry)  %o+ %  A description of each parameter follows:  % J %    o image: The address of an address of a structure of type Image.  The7 %      transformed image is returned as this parameter.t %iD %    o crop_geometry: Specifies a pointer to a crop geometry string.6 %      This geometry defines a subregion of the image. % F %    o image_geometry: Specifies a pointer to a image geometry string.K %      The specified width and height of this geometry string are absolute.r %a %n */7 void TransformImage(image,crop_geometry,image_geometry)  Image(
   **image;   char   *crop_geometry,r   *image_geometry; {e   Image      *transformed_image;      int-
     flags;     unsigned int     height,q     sharpen,
     width;     transformed_image=(*image);0%   if (crop_geometry != (char *) NULL)      {+       Image          *cropped_image;t         RectangleInfoc         crop_info;         /*,         Crop image to a user specified size.       */       crop_info.x=0;       crop_info.y=0;       flags=O         XParseGeometry(crop_geometry,&crop_info.x,&crop_info.y,&width,&height);m$       if ((flags & WidthValue) == 0)L         width=(unsigned int) ((int) transformed_image->columns-crop_info.x);%       if ((flags & HeightValue) == 0) J         height=(unsigned int) ((int) transformed_image->rows-crop_info.y);#       if ((flags & XNegative) != 0) 6         crop_info.x+=transformed_image->columns-width;#       if ((flags & YNegative) != 0)t4         crop_info.y+=transformed_image->rows-height;5       if (strchr(crop_geometry,'%') != (char *) NULL)e	         {i           /*4             Crop geometry is relative to image size.           */;           ParseImageGeometry(crop_geometry,&width,&height); 1           if (width > transformed_image->columns)c-             width=transformed_image->columns; /           if (height > transformed_image->rows)u+             height=transformed_image->rows; !           crop_info.x=width >> 1; "           crop_info.y=height >> 1;1           width=transformed_image->columns-width;r0           height=transformed_image->rows-height;	         }n       crop_info.width=width;       crop_info.height=height;<       cropped_image=CropImage(transformed_image,&crop_info);*       if (cropped_image != (Image *) NULL)	         { *           DestroyImage(transformed_image);*           transformed_image=cropped_image;	         }      }    /*)     Scale image to a user specified size.    */#   width=transformed_image->columns; !   height=transformed_image->rows; 4   ParseImageGeometry(image_geometry,&width,&height);2   sharpen=(transformed_image->columns != width) ||(     (transformed_image->rows != height);8   while ((transformed_image->columns >= (width << 1)) &&4          (transformed_image->rows >= (height << 1)))   { 	     Imagen       *reduced_image;t       /*3       Reduce image with a antialias digital filter.r     */1     reduced_image=ReduceImage(transformed_image);m(     if (reduced_image == (Image *) NULL)       break;$     DestroyImage(transformed_image);$     transformed_image=reduced_image;   } 8   while ((transformed_image->columns <= (width >> 1)) &&4          (transformed_image->rows <= (height >> 1)))   {G	     Imagem       *zoomed_image;       /*-       Zoom image with bilinear interpolation.m     */.     zoomed_image=ZoomImage(transformed_image);'     if (zoomed_image == (Image *) NULL)        break;$     DestroyImage(transformed_image);#     transformed_image=zoomed_image;i   }l.   if ((transformed_image->columns != width) ||*       (transformed_image->rows != height))     {(       Image(         *scaled_image;         /*+         Scale image with pixel replication.a       */>       scaled_image=ScaleImage(transformed_image,width,height);)       if (scaled_image != (Image *) NULL)[	         { *           DestroyImage(transformed_image);)           transformed_image=scaled_image;=	         }e     }=   if (sharpen)L     if ((transformed_image->columns >= 3) && (transformed_image->rows >= 3))       {f
         Image            *sharpened_image;_  
         /*           Sharpen image.
         */F         sharpened_image=SharpenImage(transformed_image,SharpenFactor);.         if (sharpened_image != (Image *) NULL)           {_,             DestroyImage(transformed_image);.             transformed_image=sharpened_image;           }l       }G#   if (transformed_image->packets == ;       (transformed_image->columns*transformed_image->rows)) %     CompressImage(transformed_image);g   *image=transformed_image;  }t ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %pO %                                                                             %gO %     T r a n s f o r m R G B I m a g e                                       %;O %                                                                             % O %                                                                             %iO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function TransformRGBImage converts the reference image from an alternateK %  colorspace.  The transformation matrices are not the standard ones:  themL %  weights are rescaled to normalized the range of the transformed values to %  be [0..MaxRGB]. % 2 %  The format of the TransformRGBImage routine is: % * %      TransformRGBImage(image,colorspace) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % J %    o colorspace: An unsigned integer value that indicates the colorspaceD %      the image is currently in.  On return the image is in the RGB %      color space.  %  %  */( void TransformRGBImage(image,colorspace) Image 	   *image;    unsigned int
   colorspace;  {  #define R 0  #define G (MaxRGB+1) #define B (MaxRGB+1)*2     static QuantumJ     PCDMap[348] =  /* Photo CD information beyond 100% white, Gamma 2.2 */     {iK         0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  11,  12,  13,  14,nK        15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,rK        29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,tK        43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  55,fK        56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  66,  67,  68,MK        69,  70,  71,  72,  73,  74,  75,  76,  76,  77,  78,  79,  80,  81,lK        82,  83,  84,  84,  85,  86,  87,  88,  89,  90,  91,  92,  92,  93,\K        94,  95,  96,  97,  98,  99,  99, 100, 101, 102, 103, 104, 105, 106,>K       106, 107, 108, 109, 110, 111, 112, 113, 114, 114, 115, 116, 117, 118,hK       119, 120, 121, 122, 122, 123, 124, 125, 126, 127, 128, 129, 129, 130, K       131, 132, 133, 134, 135, 136, 136, 137, 138, 139, 140, 141, 142, 142,mK       143, 144, 145, 146, 147, 148, 148, 149, 150, 151, 152, 153, 153, 154,_K       155, 156, 157, 158, 158, 159, 160, 161, 162, 163, 164, 165, 165, 166,hK       167, 168, 169, 170, 171, 172, 173, 173, 174, 175, 176, 177, 178, 178,%K       179, 180, 181, 182, 182, 183, 184, 185, 186, 186, 187, 188, 189, 190, K       191, 192, 193, 194, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, K       204, 205, 205, 206, 207, 208, 209, 210, 210, 211, 212, 213, 214, 215, K       216, 216, 217, 218, 219, 220, 221, 221, 222, 223, 224, 225, 225, 226, K       227, 228, 228, 229, 230, 230, 231, 232, 233, 233, 234, 235, 235, 236, K       237, 237, 238, 239, 239, 240, 241, 241, 242, 242, 243, 243, 244, 244, K       245, 245, 245, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249,%K       250, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252,rK       253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254,dK       254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,s@       254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255     };     long
     *blue,     *green,i	     *red;p  	   Quantumo     *range_table;a     register int     i,     x,     y,     z;     register Quantum     *range_limit;      register RunlengthPacket     *p;s  F   if ((colorspace == RGBColorspace) || (colorspace == GRAYColorspace))     return;d   /*     Allocate the tables.   */1   red=(long *) malloc(3*(MaxRGB+1)*sizeof(long));t3   green=(long *) malloc(3*(MaxRGB+1)*sizeof(long));r2   blue=(long *) malloc(3*(MaxRGB+1)*sizeof(long));?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum));n;   if ((red == (long *) NULL) || (green == (long *) NULL) || C       (blue == (long *) NULL) || (range_table == (Quantum *) NULL))p     { L       Warning("Unable to transform color space","Memory allocation failed");
       return;      }    /*     Initialize tables.   */   for (i=0; i <= MaxRGB; i++)    {      range_table[i]=0; *     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;    } %   range_limit=range_table+(MaxRGB+1);    switch (colorspace)a   {e     case OHTAColorspace:     {0       /*         Initialize OHTA tables:a  &           R = I1+1.00000*I2-0.66668*I3&           G = I1+0.00000*I2+1.33333*I3&           B = I1-1.00000*I2-0.66668*I3  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)%       {%&         red[i+R]=UpShifted(1.00000)*i;;         green[i+R]=UpShifted(1.0000*0.5)*((i << 1)-MaxRGB); >         blue[i+R]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);&         red[i+G]=UpShifted(1.00000)*i;         green[i+G]=0; ;         blue[i+G]=UpShifted(1.33333*0.5)*((i << 1)-MaxRGB); &         red[i+B]=UpShifted(1.00000)*i;?         green[i+B]=(-UpShifted(1.00000*0.5))*((i << 1)-MaxRGB); >         blue[i+B]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);       }        break;     }      case XYZColorspace:      {        /*"         Initialize CIE XYZ tables:  /           R =  3.240479*R-1.537150*G-0.498535*B /           G = -0.969256*R+1.875992*G+0.041556*B%/           B =  0.055648*R-0.204043*G+1.057311*Bt       */!       for (i=0; i <= MaxRGB; i++)p       {t'         red[i+R]=UpShifted(3.240479)*i;m,         green[i+R]=(-UpShifted(1.537150))*i;+         blue[i+R]=(-UpShifted(0.498535))*i;%*         red[i+G]=(-UpShifted(0.969256))*i;)         green[i+G]=UpShifted(1.875992)*i; (         blue[i+G]=UpShifted(0.041556)*i;'         red[i+B]=UpShifted(0.055648)*i; ,         green[i+B]=(-UpShifted(0.204043))*i;(         blue[i+B]=UpShifted(1.057311)*i;       }        break;     }a     case YCbCrColorspace:      {        /*          Initialize YCbCr tables:  '           R = Y            +1.370707*Cr '           G = Y-0.336453*Cb-0.698195*Cro           B = Y+1.732445*Cbb  O         Cb and Cr, normally -0.5 through 0.5, must be normalized to the range 0d         through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)        {c'         red[i+R]=UpShifted(1.000000)*i;t         green[i+R]=0; <         blue[i+R]=UpShifted(1.370707*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i;r@         green[i+G]=(-UpShifted(0.336453*0.5))*((i << 1)-MaxRGB);?         blue[i+G]=(-UpShifted(0.698195*0.5))*((i << 1)-MaxRGB); '         red[i+B]=UpShifted(1.000000)*i; =         green[i+B]=UpShifted(1.732445*0.5)*((i << 1)-MaxRGB);e         blue[i+B]=0;       }        break;     }L     case YCCColorspace:      {        /*         Initialize YCC tables:  '           R = Y            +1.340762*C2 '           G = Y-0.317038*C1-0.682243*C2            B = Y+1.632639*C1   B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */!       for (i=0; i <= MaxRGB; i++);       { %         red[i+R]=UpShifted(1.3584)*i;          green[i+R]=0; 5         blue[i+R]=UpShifted(1.8215)*(i-UpScale(137));a%         red[i+G]=UpShifted(1.3584)*i; ?         green[i+G]=(-UpShifted(0.194*2.2179))*(i-UpScale(156)); >         blue[i+G]=(-UpShifted(0.509*1.8215))*(i-UpScale(137));%         red[i+B]=UpShifted(1.3584)*i;e6         green[i+B]=UpShifted(2.2179)*(i-UpScale(156));         blue[i+B]=0;J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       }q$       for ( ; i < UpScale(348); i++)J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       break;     }l     case YIQColorspace:      {        /*         Initialize YIQ tables:  +           R = 0.97087*Y+1.17782*I+0.59800*Q\+           G = 0.97087*Y-0.28626*I-0.72851*Qa+           B = 0.97087*Y-1.27870*I+1.72801*Qe  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.=       */!       for (i=0; i <= MaxRGB; i++)=       {b&         red[i+R]=UpShifted(0.97087)*i;<         green[i+R]=UpShifted(1.17782*0.5)*((i << 1)-MaxRGB);;         blue[i+R]=UpShifted(0.59800*0.5)*((i << 1)-MaxRGB);+&         red[i+G]=UpShifted(0.97087)*i;?         green[i+G]=(-UpShifted(0.28626*0.5))*((i << 1)-MaxRGB); >         blue[i+G]=(-UpShifted(0.72851*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(0.97087)*i;?         green[i+B]=(-UpShifted(1.27870*0.5))*((i << 1)-MaxRGB);s;         blue[i+B]=UpShifted(1.72801*0.5)*((i << 1)-MaxRGB);n       }n       break;     }      case YPbPrColorspace:f     {)       /*          Initialize YPbPr tables:  '           R = Y            +1.402000*C2)'           G = Y-0.344136*C1+0.714136*C2'           B = Y+1.772000*C1)  O         Pb and Pr, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)r       {g'         red[i+R]=UpShifted(1.000000)*i;g         green[i+R]=0; <         blue[i+R]=UpShifted(1.402000*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i;b@         green[i+G]=(-UpShifted(0.344136*0.5))*((i << 1)-MaxRGB);<         blue[i+G]=UpShifted(0.714136*0.5)*((i << 1)-MaxRGB);'         red[i+B]=UpShifted(1.000000)*i;g=         green[i+B]=UpShifted(1.772000*0.5)*((i << 1)-MaxRGB);          blue[i+B]=0;       }+       break;     };     case YUVColorspace:      default:     {        /*         Initialize YUV tables:  #           R = Y          +1.13980*Vf#           G = Y-0.39380*U-0.58050*Vq           B = Y+2.02790*U   M         U and V, normally -0.5 through 0.5, must be normalized to the range 0%         through MaxRGB.%       */!       for (i=0; i <= MaxRGB; i++)        { &         red[i+R]=UpShifted(1.00000)*i;         green[i+R]=0; ;         blue[i+R]=UpShifted(1.13980*0.5)*((i << 1)-MaxRGB); &         red[i+G]=UpShifted(1.00000)*i;?         green[i+G]=(-UpShifted(0.39380*0.5))*((i << 1)-MaxRGB); >         blue[i+G]=(-UpShifted(0.58050*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(1.00000)*i;<         green[i+B]=UpShifted(2.02790*0.5)*((i << 1)-MaxRGB);         blue[i+B]=0;       }        break;     }%   }%   /*     Convert to RGB.%   */   switch (image->class)%   {%     case DirectClass:      {e       /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          x=p->red;a         y=p->green;A         z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];yG         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];aF         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;       }        break;     }      case PseudoClass:r     {t       /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)        {_!         x=image->colormap[i].red; #         y=image->colormap[i].green; "         z=image->colormap[i].blue;         image->colormap[i].red=r@           range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];!         image->colormap[i].green= @           range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];          image->colormap[i].blue=@           range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];       }b       p=image->pixels;(       for (i=0; i < image->packets; i++)       {l         x=p->red;          y=p->green;          z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];uG         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])]; F         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;       }s       break;     }    }f   /*     Free allocated memory.   */   free((char *) range_table);g   free((char *) blue);   free((char *) green);f   free((char *) red);  }  u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %nO %     T r a n s p a r e n t I m a g e                                         %rO %                                                                             % O %                                                                             %0O %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u % F %  Function TransparentImage creates a matte image associated with theF %  image.  All pixel locations are initially set to opaque.  Any pixel; %  that matches the specified color are set to transparent.0 %&1 %  The format of the TransparentImage routine is:  %,$ %      TransparentImage(image,color) % + %  A description of each parameter follows:( % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % B %    o color: A character string that contain an X11 color string. %= %g */" void TransparentImage(image,color) Images	   *image;r   char	   *color;  {  #define DeltaX  16     register int     i;  	   Quantum 	     blue, 
     green,     red;     register RunlengthPacket     *p;      unsigned int     status;      XColor     target_color;      /*2     Determine RGB values of the transparent color.   */2   status=XQueryColorDatabase(color,&target_color);   if (status == False)     return;d#   red=XDownScale(target_color.red);u'   green=XDownScale(target_color.green);u%   blue=XDownScale(target_color.blue);.   /*!     Make image color transparent.l   */   p=image->pixels;   switch (image->class)    {b     case DirectClass:e     {        /*+         Make DirectClass image transparent.i       */       if (!image->matte)	         {p           /*-             Initialize image matte to opaque.=           */,           for (i=0; i < image->packets; i++)           {c             p->index=Opaque;             p++;           }a           image->matte=True;           p=image->pixels;	         }D(       for (i=0; i < image->packets; i++)       {e2         if (((int) p->red < (int) (red+DeltaX)) &&2             ((int) p->red > (int) (red-DeltaX)) &&6             ((int) p->green < (int) (green+DeltaX)) &&6             ((int) p->green > (int) (green-DeltaX)) &&4             ((int) p->blue < (int) (blue+DeltaX)) &&2             ((int) p->blue > (int) (blue-DeltaX)))           p->index=Transparent;d         p++;       }/       break;     }      case PseudoClass:      {o       double         distance_squared,c         min_distance;   	       into         distance;e         register int         index;         /*         Find closest color.g       */-       min_distance=3.0*(MaxRGB+1)*(MaxRGB+1);%       index=0;'       for (i=0; i < image->colors; i++)%       { 8         distance=(int) red-(int) image->colormap[i].red;<         distance_squared=(unsigned int) (distance*distance);<         distance=(int) green-(int) image->colormap[i].green;=         distance_squared+=(unsigned int) (distance*distance);a:         distance=(int) blue-(int) image->colormap[i].blue;=         distance_squared+=(unsigned int) (distance*distance); ,         if (distance_squared < min_distance)           { *             min_distance=distance_squared;             index=i;           }%       }%       /*+         Make PseudoClass image transparent.        */       image->class=DirectClass;p       image->matte=True;(       for (i=0; i < image->packets; i++)       {          if (p->index == index)           p->index=Transparent;y         else           p->index=Opaque;         p++;       }p       break;     }m   }  }i e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %tO %                                                                             % O %                                                                             %aO %   U n C o m p r e s s I m a g e                                             %aO %                                                                             % O %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function UncompressImage uncompresses runlength-encoded pixels packets to! %  a rectangular array of pixels.  % 0 %  The format of the UncompressImage routine is: %C$ %      status=UncompressImage(image) %d+ %  A description of each parameter follows:r %lD %    o status: Function UncompressImage returns True if the image is$ %      uncompressed otherwise False. %o7 %    o image: The address of a structure of type Image.X %r %l */# unsigned int UncompressImage(image)o Image=	   *image;c {r   register int     i,     j,     length;g     register RunlengthPacket     *p,o     *q;;     RunlengthPacket      *uncompressed_pixels;e  5   if (image->packets == (image->columns*image->rows))o     return(True);    /*)     Uncompress runlength-encoded packets.    */I   uncompressed_pixels=(RunlengthPacket *) realloc((char *) image->pixels,/8     image->columns*image->rows*sizeof(RunlengthPacket));6   if (uncompressed_pixels == (RunlengthPacket *) NULL)     return(False);$   image->pixels=uncompressed_pixels;#   p=image->pixels+image->packets-1;n5   q=uncompressed_pixels+image->columns*image->rows-1;f$   for (i=0; i < image->packets; i++)   {a     length=p->length;      for (j=0; j <= length; j++)      {        *q=(*p);       q->length=0;
       q--;     }.     p--;   } ,   image->packets=image->columns*image->rows;   return(True);( }a f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %eO %                                                                             % O %   Z o o m I m a g e                                                         %iO %                                                                             %oO %                                                                             % O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function ZoomImage creates a new image that is a integral size greateroM %  than an existing one.  It allocates the memory necessary for the new Imagei4 %  structure and returns a pointer to the new image. %nK %  ZoomImage scans the reference image to create a zoomed image by bilineart< %  interpolation.  The zoomed image columns and rows become: %d %    number_columns << 1 %    number_rows << 1r %a* %  The format of the ZoomImage routine is: %c$ %      zoomed_image=ZoomImage(image) % + %  A description of each parameter follows:l %gL %    o zoomed_image: Function ZoomImage returns a pointer to the image afterJ %      zooming.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *ZoomImage(image)d Image 	   *image;1 {p   Image"     *zoomed_image;     int      y;     register int     x;     register RunlengthPacket     *p,0     *q,      *r;u     /*'     Initialize zoomed image attributes.    */K   zoomed_image=CopyImage(image,image->columns << 1,image->rows << 1,False);C%   if (zoomed_image == (Image *) NULL)r     {iA       Warning("Unable to zoom image","Memory allocation failed");1       return((Image *) NULL);      } "   zoomed_image->class=DirectClass;   /*!     Initialize zoom image pixels.    */   p=image->pixels;   image->runlength=p->length+1;o   q=zoomed_image->pixels; !   for (y=0; y < image->rows; y++)h   { &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--;(
       else	         {            p++;%           image->runlength=p->length;t	         }e       *q=(*p);       q->length=0;
       q++;     }      q+=image->columns;   }+   /*     Zoom each row.   */!   for (y=0; y < image->rows; y++)    {(C     p=zoomed_image->pixels+(image->rows-1-y)*zoomed_image->columns+p       (image->columns-1); J     q=zoomed_image->pixels+((image->rows-1-y) << 1)*zoomed_image->columns+        ((image->columns-1) << 1);     *q=(*p);     *(q+1)=(*(p));&     for (x=1; x < image->columns; x++)     { 
       p--;       q-=2;        *q=(*p);<       (q+1)->red=(((int) p->red)+((int) (p+1)->red)+1) >> 1;B       (q+1)->green=(((int) p->green)+((int) (p+1)->green)+1) >> 1;?       (q+1)->blue=(((int) p->blue)+((int) (p+1)->blue)+1) >> 1;iB       (q+1)->index=(((int) p->index)+((int) (p+1)->index)+1) >> 1;       (q+1)->length=0;     }"   }o%   for (y=0; y < (image->rows-1); y++)e   {[:     p=zoomed_image->pixels+(y << 1)*zoomed_image->columns;     q=p+zoomed_image->columns;     r=q+zoomed_image->columns;*     for (x=0; x < (image->columns-1); x++)     {a4       q->red=(((int) p->red)+((int) r->red)+1) >> 1;:       q->green=(((int) p->green)+((int) r->green)+1) >> 1;7       q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1; :       q->index=(((int) p->index)+((int) r->index)+1) >> 1;       q->length=0;C       (q+1)->red=(((int) p->red)+((int) (p+2)->red)+((int) r->red)+a#         ((int) (r+2)->red)+2) >> 2;eK       (q+1)->green=(((int) p->green)+((int) (p+2)->green)+((int) r->green)+ %         ((int) (r+2)->green)+2) >> 2; G       (q+1)->blue=(((int) p->blue)+((int) (p+2)->blue)+((int) r->blue)+i$         ((int) (r+2)->blue)+2) >> 2;K       (q+1)->index=(((int) p->index)+((int) (p+2)->index)+((int) r->index)+b%         ((int) (r+2)->index)+2) >> 2;m       (q+1)->length=0;       q+=2;o       p+=2;b       r+=2;g     } 2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;t8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;e8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;   }=A   p=zoomed_image->pixels+(2*image->rows-2)*zoomed_image->columns;4A   q=zoomed_image->pixels+(2*image->rows-1)*zoomed_image->columns; $   for (x=0; x < image->columns; x++)   {      *q++=(*p++);     *q++=(*p++);   }g   return(zoomed_image);l }e