 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                   E      NN  N  C      O   O  D   D  E                      % O %                   EEE    N N N  C      O   O  D   D  EEE                    % O %                   E      N  NN  C      O   O  D   D  E                      % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Write Image Formats                  % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h" #include "XWDFile.h"   /*   Define declarations. */& #define PrematureExit(message,image) \ { \ %   Warning(message,image->filename); \    return(False); \ }    /*   Forward declarations.  */ static unsigned int 1   WriteMIFFImage _Declare((ImageInfo *,Image *));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e A V S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteAVSImage writes an image to a file in AVS X image format. % . %  The format of the WriteAVSImage routine is: % - %      status=WriteAVSImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteAVSImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteAVSImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*"     Initialize raster file header.   */"   avs_header.width=image->columns;    avs_header.height=image->rows;F   (void) fwrite((char *) &avs_header,sizeof(AVSHeader),1,image->file);   p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)     { A       (void) fputc(image->matte ? p->index : Opaque,image->file); 2       (void) fputc(DownScale(p->red),image->file);4       (void) fputc(DownScale(p->green),image->file);3       (void) fputc(DownScale(p->blue),image->file);      }      p++;   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e B M P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WriteBMPImage writes an image in Microsoft Windows bitmap encoded  %  image format. % . %  The format of the WriteBMPImage routine is: % - %      status=WriteBMPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteBMPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteBMPImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *bmp_data,     *bmp_pixels;     unsigned int     bytes_per_line;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*&     Initialize BMP raster file header.   */   bmp_header.file_size=14+40;    bmp_header.offset_bits=14+40;    if (!IsPseudoClass(image))     {        /*         Full color BMP raster.       */       bmp_header.bit_count=24;!       bmp_header.number_colors=0;      }    else     {        /*         Colormapped BMP raster.        */       bmp_header.bit_count=8; 5       if (IsGrayImage(image) && (image->colors == 2))          bmp_header.bit_count=1; :       bmp_header.file_size+=4*(1 << bmp_header.bit_count);<       bmp_header.offset_bits+=4*(1 << bmp_header.bit_count);9       bmp_header.number_colors=1 << bmp_header.bit_count;      }    bmp_header.reserved[0]=0;    bmp_header.reserved[1]=0;    bmp_header.size=40; "   bmp_header.width=image->columns;    bmp_header.height=image->rows;   bmp_header.planes=1;   bmp_header.compression=0; A   bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; 3   bmp_header.image_size=bytes_per_line*image->rows; .   bmp_header.file_size+=bmp_header.image_size;   bmp_header.x_pixels=75*39;   bmp_header.y_pixels=75*39;7   bmp_header.colors_important=bmp_header.number_colors;    /*&     Convert MIFF to BMP raster pixels.   */   bmp_pixels=(unsigned char *)8     malloc(bmp_header.image_size*sizeof(unsigned char));+   if (bmp_pixels == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    p=image->pixels;   x=0;   y=image->rows-1;   switch (bmp_header.bit_count)    {      case 1:      {        register unsigned char         bit,
         byte,          polarity;          /*<         Convert PseudoClass image to a BMP monochrome image.       */       polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[1]) > Intensity(image->colormap[0]);        bit=0;
       byte=0; $       q=bmp_pixels+y*bytes_per_line;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) %                 *q++=byte << (8-bit);                bit=0;               byte=0;                x=0;               y--;,               q=bmp_pixels+y*bytes_per_line;            }	         }          p++;       }        break;     }      case 8:      {        /*0         Convert PseudoClass packet to BMP pixel.       */<       if (image->compression == RunlengthEncodedCompression)         CompressImage(image); <       if (image->compression == RunlengthEncodedCompression)&         bytes_per_line=image->columns;$       q=bmp_pixels+y*bytes_per_line;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            *q++=p->index;           x++;"           if (x == image->columns)
             {                x=0;               y--;,               q=bmp_pixels+y*bytes_per_line;
             } 	         }          p++;       }        break;     }      case 24:     {        /*4         Convert DirectClass packet to BMP RGB pixel.       */$       q=bmp_pixels+y*bytes_per_line;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { "           *q++=DownScale(p->blue);#           *q++=DownScale(p->green); !           *q++=DownScale(p->red);            x++;"           if (x == image->columns)
             {                x=0;               y--;,               q=bmp_pixels+y*bytes_per_line;
             } 	         }          p++;       }        break;     }    }     if (bmp_header.bit_count == 8):     if (image->compression == RunlengthEncodedCompression)       {          unsigned int           packets;  
         /*3           Convert run-length encoded raster pixels. 
         */>         packets=(bytes_per_line*(bmp_header.height+2)+1) << 1;I         bmp_data=(unsigned char *) malloc(packets*sizeof(unsigned char)); 1         if (bmp_pixels == (unsigned char *) NULL)            { =             Warning("Memory allocation error",(char *) NULL); &             free((char *) bmp_pixels);             return(False);           }          bmp_header.image_size=I           BMPEncodeImage(bmp_pixels,bmp_data,image->columns,image->rows); "         free((char *) bmp_pixels);         bmp_pixels=bmp_data;!         bmp_header.compression=1;        }    /*     Write BMP header.    */&   (void) fwrite("BM",1,2,image->file);6   LSBFirstWriteLong(bmp_header.file_size,image->file);9   LSBFirstWriteShort(bmp_header.reserved[0],image->file); 9   LSBFirstWriteShort(bmp_header.reserved[1],image->file); 8   LSBFirstWriteLong(bmp_header.offset_bits,image->file);1   LSBFirstWriteLong(bmp_header.size,image->file); 2   LSBFirstWriteLong(bmp_header.width,image->file);3   LSBFirstWriteLong(bmp_header.height,image->file); 4   LSBFirstWriteShort(bmp_header.planes,image->file);7   LSBFirstWriteShort(bmp_header.bit_count,image->file); 8   LSBFirstWriteLong(bmp_header.compression,image->file);7   LSBFirstWriteLong(bmp_header.image_size,image->file); 5   LSBFirstWriteLong(bmp_header.x_pixels,image->file); 5   LSBFirstWriteLong(bmp_header.y_pixels,image->file); :   LSBFirstWriteLong(bmp_header.number_colors,image->file);=   LSBFirstWriteLong(bmp_header.colors_important,image->file); "   if (image->class == PseudoClass)     {        unsigned char          *bmp_colormap;         /*         Dump colormap to file.       */$       bmp_colormap=(unsigned char *)D         malloc(4*(1 << bmp_header.bit_count)*sizeof(unsigned char));1       if (bmp_colormap == (unsigned char *) NULL) 9         PrematureExit("Unable to allocate memory",image);        q=bmp_colormap; '       for (i=0; i < image->colors; i++)        { 0         *q++=DownScale(image->colormap[i].blue);1         *q++=DownScale(image->colormap[i].green); /         *q++=DownScale(image->colormap[i].red);          q++;       } F       (void) fwrite((char *) bmp_colormap,4,1 << bmp_header.bit_count,         image->file); "       free((char *) bmp_colormap);     } O   (void) fwrite((char *) bmp_pixels,1,(int) bmp_header.image_size,image->file);    free((char *) bmp_pixels);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e C M Y K I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function WriteCMYKImage writes an image to a file in cyan, magenta,' %  yellow, and black rasterfile format.  % / %  The format of the WriteCMYKImage routine is:  % . %      status=WriteCMYKImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteCMYKImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteCMYKImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    float      black_generation,      undercolor;      int 
     black,	     cyan,      magenta,     yellow;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*'     Convert MIFF to CMYK raster pixels.    */   undercolor=1.0;    black_generation=1.0; .   if (image_info->undercolor != (char *) NULL)     { ?       (void) sscanf(image_info->undercolor,"%fx%f",&undercolor,          &black_generation); "       if (black_generation == 1.0)$         black_generation=undercolor;     }     switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; E           (void) fputc(DownScale(cyan-undercolor*black),image->file); H           (void) fputc(DownScale(magenta-undercolor*black),image->file);G           (void) fputc(DownScale(yellow-undercolor*black),image->file); F           (void) fputc(DownScale(black_generation*black),image->file);	         }          p++;       }        break;     }      case LineInterlace:      {        register int
         x,
         y;         /*?         Line interlacing:  CCC...MMM...YYY...CCC...MMM...YYY...        */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)        { +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; E           (void) fputc(DownScale(cyan-undercolor*black),image->file);            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; H           (void) fputc(DownScale(magenta-undercolor*black),image->file);           p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; G           (void) fputc(DownScale(yellow-undercolor*black),image->file);            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; F           (void) fputc(DownScale(black_generation*black),image->file);           p++;	         }        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; E           (void) fputc(DownScale(cyan-undercolor*black),image->file); 	         }          p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; H           (void) fputc(DownScale(magenta-undercolor*black),image->file);	         }          p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {             cyan=MaxRGB-p->red;#            magenta=MaxRGB-p->green; !            yellow=MaxRGB-p->blue;             black=cyan;            if (magenta < black)               black=magenta;             if (yellow < black)              black=yellow;G           (void) fputc(DownScale(yellow-undercolor*black),image->file); 	         }          p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; F           (void) fputc(DownScale(black_generation*black),image->file);	         }          p++;       }        break;     }    }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F A X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Procedure WriteFAXImage writes an image to a file in 1 dimensional Huffman  %  encoded format. % . %  The format of the WriteFAXImage routine is: % - %      status=WriteFAXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteFAXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteFAXImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Convert MIFF to monochrome.    */=   QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);    SyncImage(image); #   status=HuffmanEncodeImage(image);    CloseImage(image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F I T S I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteFITSImage writes a Flexible Image Transport System image to a+ %  file as gray scale intensities [0..255].  % / %  The format of the WriteFITSImage routine is:  % . %      status=WriteFITSImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteFITSImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteFITSImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    char     buffer[81],      *fits_header;      register int     i,     j;     register RunlengthPacket     *p;        /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate image header.   */:   fits_header=(char *) malloc(2880*sizeof(unsigned char));#   if (fits_header == (char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Initialize image header.   */   for (i=0; i < 2880; i++)     fits_header[i]=' '; 9   (void) strcpy(buffer,"SIMPLE  =                    T"); 6   (void) strncpy(fits_header+0,buffer,strlen(buffer));9   (void) strcpy(buffer,"BITPIX  =                    8"); 7   (void) strncpy(fits_header+80,buffer,strlen(buffer)); 9   (void) strcpy(buffer,"NAXIS   =                    2"); 8   (void) strncpy(fits_header+160,buffer,strlen(buffer));C   (void) sprintf(buffer,"NAXIS1  =           %10u",image->columns); 8   (void) strncpy(fits_header+240,buffer,strlen(buffer));@   (void) sprintf(buffer,"NAXIS2  =           %10u",image->rows);8   (void) strncpy(fits_header+320,buffer,strlen(buffer));:   (void) strcpy(buffer,"HISTORY Created by ImageMagick.");8   (void) strncpy(fits_header+400,buffer,strlen(buffer));   (void) strcpy(buffer,"END");8   (void) strncpy(fits_header+480,buffer,strlen(buffer));9   (void) fwrite((char *) fits_header,1,2880,image->file);    free((char *) fits_header);    /*2     Convert image to fits scale PseudoColor class.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)9       (void) fputc(DownScale(Intensity(*p)),image->file);      p++;   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G I F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteGIFImage writes an image to a file in the Compuserve Graphics %  image format. % . %  The format of the WriteGIFImage routine is: % - %      status=WriteGIFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteGIFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteGIFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     x;     register RunlengthPacket     *p;      unsigned char      bits_per_pixel,      c,     *matte_image;      unsigned int     colors,      status;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); 
   colors=256; %   matte_image=(unsigned char *) NULL;    if (image->matte)      {        /*,         Allocate and initialize matte image.       */"       if (!UncompressImage(image))         return(False);       p=image->pixels;#       matte_image=(unsigned char *) A         malloc(image->columns*image->rows*sizeof(unsigned char)); 0       if (matte_image == (unsigned char *) NULL)8         PrematureExit("Unable to allocate memory",image)
       else8         for (x=0; x < (image->columns*image->rows); x++)	         { ;           matte_image[x]=(unsigned char) (p->index & 0xff);            p++;	         }        colors--;      } @   if ((image->class == DirectClass) || (image->colors > colors))     {        /**         Demote DirectClass to PseudoClass.       */E       QuantizeImage(image,colors,8,image_info->dither,RGBColorspace);        SyncImage(image); "       if (!UncompressImage(image))         return(False);     }    colors=image->colors; ,   if (matte_image != (unsigned char *) NULL)     {        CompressColormap(image);       colors++;      } >   for (bits_per_pixel=1; bits_per_pixel < 8; bits_per_pixel++)(     if ((1 << bits_per_pixel) >= colors)       break;   /*     Write GIF header.    */0   if ((matte_image == (unsigned char *) NULL) &&)       (image->comments == (char *) NULL)) ,     (void) fwrite("GIF87a",1,6,image->file);   else+     if (strcmp(image->magick,"GIF87") == 0) .       (void) fwrite("GIF87a",1,6,image->file);     else.       (void) fwrite("GIF89a",1,6,image->file);1   LSBFirstWriteShort(image->columns,image->file); .   LSBFirstWriteShort(image->rows,image->file);    c=0x80;  /* global colormap */(   c|=(8-1) << 4;  /* color resolution */8   c|=(bits_per_pixel-1);   /* size of global colormap */%   (void) fputc((char) c,image->file); 8   (void) fputc(0x0,image->file);  /* background color */0   (void) fputc(0x0,image->file);  /* reserved */   /*     Write colormap.    */#   for (i=0; i < image->colors; i++)    { @     (void) fputc(DownScale(image->colormap[i].red),image->file);B     (void) fputc(DownScale(image->colormap[i].green),image->file);A     (void) fputc(DownScale(image->colormap[i].blue),image->file);    } ,   if (matte_image != (unsigned char *) NULL)     {        /*)         Write color of transparent pixel.        */       p=image->pixels;6       for (x=0; x < (image->columns*image->rows); x++)       { *         if (matte_image[x] == Transparent)           break;         p++;       } I       (void) fputc(DownScale(image->colormap[p->index].red),image->file); K       (void) fputc(DownScale(image->colormap[p->index].green),image->file); J       (void) fputc(DownScale(image->colormap[p->index].blue),image->file);
       i++;     } /   for ( ; i < (int) (1 << bits_per_pixel); i++)    { "     (void) fputc(0x0,image->file);"     (void) fputc(0x0,image->file);"     (void) fputc(0x0,image->file);   } )   if (strcmp(image->magick,"GIF87") != 0)      { +       if (image->comments != (char *) NULL) 	         {            register char              *p;              register unsigned int              count;             /**             Write comment extension block.           */)           (void) fputc(0x21,image->file); )           (void) fputc(0xfe,image->file);            p=image->comments;%           while ((int) strlen(p) > 0)            { +             count=Min((int) strlen(p),255); ,             (void) fputc(count,image->file);%             for (i=0; i < count; i++) -               (void) fputc(*p++,image->file);            } (           (void) fputc(0x0,image->file);	         } 0       if (matte_image != (unsigned char *) NULL)	         {            /*<             Write out extension for transparent color index.           */)           (void) fputc(0x21,image->file); )           (void) fputc(0xf9,image->file); (           (void) fputc(0x4,image->file);(           (void) fputc(0x1,image->file);(           (void) fputc(0x0,image->file);(           (void) fputc(0x0,image->file);9           (void) fputc((char) image->colors,image->file); (           (void) fputc(0x0,image->file);           /*B             Set transparent pixels to the transparent color index.           */           p=image->pixels;:           for (x=0; x < (image->columns*image->rows); x++)           { .             if (matte_image[x] == Transparent)%               p->index=image->colors;              p++;           } %           free((char *) matte_image); 	         }      } 7   (void) fputc(',',image->file);  /* image separator */    /*     Write the image header.    */$   LSBFirstWriteShort(0,image->file);$   LSBFirstWriteShort(0,image->file);1   LSBFirstWriteShort(image->columns,image->file); .   LSBFirstWriteShort(image->rows,image->file);	   c=0x00; -   if (image_info->interlace != NoneInterlace) ,     c|=0x40;  /* pixel data is interlaced */%   (void) fputc((char) c,image->file);    c=Max(bits_per_pixel,2);%   (void) fputc((char) c,image->file); -   if (image_info->interlace == NoneInterlace) 9     status=LZWEncodeImage(image,Max(bits_per_pixel,2)+1);    else     {        Image          *interlaced_image;  	       int 
         pass, 
         y;         register RunlengthPacket         *q;          static int+         interlace_rate[4] = { 8, 8, 4, 2 }, ,         interlace_start[4] = { 0, 4, 2, 1 };         /*         Interlace image.       */"       if (!UncompressImage(image))         return(False);       image->orphan=True; I       interlaced_image=CopyImage(image,image->columns,image->rows,False);        image->orphan=False;-       if (interlaced_image == (Image *) NULL) 9         PrematureExit("Unable to allocate memory",image);        p=image->pixels;!       q=interlaced_image->pixels; $       for (pass=0; pass < 4; pass++)       {           y=interlace_start[pass];         while (y < image->rows) 	         { -           p=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              *q=(*p);             p++;             q++;           } "           y+=interlace_rate[pass];	         }        } )       interlaced_image->file=image->file; F       status=LZWEncodeImage(interlaced_image,Max(bits_per_pixel,2)+1);+       interlaced_image->file=(FILE *) NULL; %       DestroyImage(interlaced_image);      }    if (status == False)5     PrematureExit("Unable to allocate memory",image);     (void) fputc(0x0,image->file);1   (void) fputc(';',image->file); /* terminator */    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G R A Y I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteGRAYImage writes an image to a file as gray scale intensity %  values [0..255].  % / %  The format of the WriteGRAYImage routine is:  % . %      status=WriteGRAYImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteGRAYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteGRAYImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*2     Convert image to gray scale PseudoColor class.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)9       (void) fputc(DownScale(Intensity(*p)),image->file);      p++;   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H D F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHDFImage writes an image in the Hierarchial Data Format image
 %  format. % . %  The format of the WriteHDFImage routine is: % - %      status=WriteHDFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteHDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */
 #ifdef HasHDF 3 static unsigned int WriteHDFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {  #include "hdf.h"     int      status;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int     packet_size;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);   /*"     Initialize raster file header.   */   packet_size=1;"   if (image->class == DirectClass)     packet_size=3;   hdf_pixels=(unsigned char *)I     malloc(packet_size*image->columns*image->rows*sizeof(unsigned char)); +   if (hdf_pixels == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    p=image->pixels;   if (!IsPseudoClass(image))     {        /*1         Convert DirectClass packet to HDF pixels.        */       q=hdf_pixels; $       switch (image_info->interlace)       {          case NoneInterlace:          default:	         {            /*2             No interlacing:  RGBRGBRGBRGBRGBRGB...           */,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             { %               *q++=DownScale(p->red); '               *q++=DownScale(p->green); &               *q++=DownScale(p->blue);
             }              p++;           }            break;	         }          case LineInterlace: 	         {            register int             x,             y;             /*C             Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...            */&           if (!UncompressImage(image))             return(False);)           for (y=0; y < image->rows; y++)            { /             p=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             { %               *q++=DownScale(p->red);                p++;
             } /             p=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             { '               *q++=DownScale(p->green);                p++;
             } /             p=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             { &               *q++=DownScale(p->blue);               p++;
             }            }            break;	         }          case PlaneInterlace:	         {            /*;             Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...            */,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)%               *q++=DownScale(p->red);              p++;           }            p=image->pixels;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)'               *q++=DownScale(p->green);              p++;           }            p=image->pixels;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)&               *q++=DownScale(p->blue);             p++;           }            break;	         }        } )       DF24setil(image_info->interlace-1); M       status=DF24putimage(image->filename,(void *) hdf_pixels,image->columns,          image->rows);        reference=DF24lastref();     }    else     {        /*1         Convert PseudoClass packet to HDF pixels.        */       q=hdf_pixels;        if (IsGrayImage(image)) *         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)#             *q++=DownScale(p->red);            p++;	         } 
       else	         {            unsigned char              *hdf_palette;   J           hdf_palette=(unsigned char *) malloc(768*sizeof(unsigned char));4           if (hdf_palette == (unsigned char *) NULL)=             PrematureExit("Unable to allocate memory",image);            q=hdf_palette;+           for (i=0; i < image->colors; i++)            { 3             *q++=DownScale(image->colormap[i].red); 5             *q++=DownScale(image->colormap[i].green); 4             *q++=DownScale(image->colormap[i].blue);           } -           (void) DFR8setpalette(hdf_palette);            free(hdf_palette);           q=hdf_pixels; ,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)               *q++=p->index;             p++;           } 	         } M       status=DFR8putimage(image->filename,(void *) hdf_pixels,image->columns, B         image->rows,image->compression == NoCompression ? 0 : 11);       reference=DFR8lastref();     } $   if (image->label != (char *) NULL)J     (void) DFANputlabel(image->filename,DFTAG_RIG,reference,image->label);'   if (image->comments != (char *) NULL) K     (void) DFANputdesc(image->filename,DFTAG_RIG,reference,image->comments, !       strlen(image->comments)+1);    free(hdf_pixels);    return(status != -1);  }  #else 3 static unsigned int WriteHDFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   :   Warning("HDF library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H I S T O G R A M I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHISTOGRAMImage writes an image to a file in HISTOGRAM format.O %  The image shows a histogram of the color (or gray) values in the image.  The O %  image consists of three overlaid histograms:  a red one for the red channel, O %  a green one for the green channel, and a blue one for the blue channel.  The O %  image comment contains a list of unique pixel values and the number of times  %  each occurs in the image. % > %  This routine is strongly based on a similiar one written byI %  muquit@warm.semcor.com which in turn is based on ppmhistmap of netpbm.  % 4 %  The format of the WriteHISTOGRAMImage routine is: % 3 %      status=WriteHISTOGRAMImage(image_info,image)  % + %  A description of each parameter follows.  % P %    o status: Function WriteHISTOGRAMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */9 static unsigned int WriteHISTOGRAMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  { # #define HistogramDensity  "256x200"      char     filename[MaxTextLength];     double
     scale;     FILE
     *file;     Image      *histogram_image;      int 
     *blue,     *green,      maximum,	     *red,      sans_offset;     register RunlengthPacket     *p,      *q;      register int     i,     j;     unsigned int     height,      status, 
     width;     /*     Allocate histogram image.    */C   (void) XParseGeometry(HistogramDensity,&sans_offset,&sans_offset,      &width,&height);+   if (image_info->density != (char *) NULL) H     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,       &width,&height);   image->orphan=True; 6   histogram_image=CopyImage(image,width,height,False);   image->orphan=False;(   if (histogram_image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image); %   histogram_image->class=DirectClass;    /*$     Allocate histogram count arrays.   */<   red=(int *) malloc (histogram_image->columns*sizeof(int));>   green=(int *) malloc (histogram_image->columns*sizeof(int));=   blue=(int *) malloc (histogram_image->columns*sizeof(int)); 9   if ((red == (int *) NULL) || (green == (int *) NULL) ||        (blue == (int *) NULL))      { $       DestroyImage(histogram_image);7       PrematureExit("Unable to allocate memory",image);      }    /*&     Initialize histogram count arrays.   */.   for (i=0; i < histogram_image->columns; i++)   { 
     red[i]=0;      green[i]=0;      blue[i]=0;   }    p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     red[DownScale(p->red)]+=(p->length+1);.     green[DownScale(p->green)]+=(p->length+1);,     blue[DownScale(p->blue)]+=(p->length+1);     p++;   }    maximum=0;.   for (i=0; i < histogram_image->columns; i++)   {      if (maximum < red[i])        maximum=red[i];      if (maximum < green[i])        maximum=green[i];      if (maximum < blue[i])       maximum=blue[i];   } .   for (i=0; i < histogram_image->columns; i++)   {      if (red[i] > maximum)        red[i]=maximum;      if (green[i] > maximum)        green[i]=maximum;      if (blue[i] > maximum)       blue[i]=maximum;   }    /*     Initialize histogram image.    */   q=histogram_image->pixels;.   for (i=0; i < histogram_image->packets; i++)   { 
     q->red=0;      q->green=0;      q->blue=0;     q->index=0;      q->length=0;     q++;   } /   scale=(double) histogram_image->rows/maximum;    q=histogram_image->pixels;-   for(i=0; i < histogram_image->columns; i++)    { 1     j=histogram_image->rows-(int) (scale*red[i]); %     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->red=MaxRGB;
       j++;     } 3     j=histogram_image->rows-(int) (scale*green[i]); %     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->green=MaxRGB;
       j++;     } 2     j=histogram_image->rows-(int) (scale*blue[i]);%     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->blue=MaxRGB; 
       j++;     }    }    free ((char *) blue);    free ((char *) green);   free ((char *) red);   TemporaryFilename(filename);   file=fopen(filename,"w");    if (file != (FILE *) NULL)     { 
       char         command[MaxTextLength];          /*,         Add a histogram as an image comment.       */2       (void) fprintf(file,"%s\n",image->comments);       NumberColors(image,file);        (void) fclose(file);-       (void) sprintf(command,"@%s",filename); ,       CommentImage(histogram_image,command);       (void) unlink(filename);     }    /*"     Write HISTOGRAM image as MIFF.   */4   status=WriteMIFFImage(image_info,histogram_image);    DestroyImage(histogram_image);   return(status);  }    #ifdef HasJBIG #include "jbig.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e J B I G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteJBIGImage writes an image in the JBIG encoded image format. % / %  The format of the WriteJBIGImage routine is:  % . %      status=WriteJBIGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteJBIGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  " void JBIGEncode(start,length,file)
 unsigned char 
    *start;   size_t	   length;    void	    *file;  { .   (void) fwrite(start,length,1,(FILE *) file);	   return;  }   4 static unsigned int WriteJBIGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    int      sans_offset;     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     bit,     *q;      struct jbg_enc_state     jbig_info;     unsigned char      *pixels,
     polarity;      unsigned int	     byte,      number_packets,      x,     x_resolution,      y_resolution;      /*     Open image file.   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate pixel data.   */7   number_packets=((image->columns+7) >> 3)*image->rows; H   pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));'   if (pixels == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*1     Convert Runlength encoded pixels to a bitmap.    */=   QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);    SyncImage(image); 
   polarity=0;    if (image->colors == 2) K     polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);    bit=0;	   byte=0;    x=0;   p=image->pixels;   q=pixels; $   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)     {        byte<<=1;        if (p->index == polarity)          byte|=0x01;        bit++;       if (bit == 8) 	         {            *q++=byte;           bit=0;           byte=0; 	         } 
       x++;       if (x == image->columns)	         {            /*)             Advance to the next scanline.            */           if (bit != 0) !             *q++=byte << (8-bit);            bit=0;           byte=0;            x=0;        }     }      p++;   }    /*#     Initialize JBIG info structure.    */?   jbg_enc_init(&jbig_info,image->columns,image->rows,1,&pixels, D     (void (*) _Declare((unsigned char *,size_t,void *))) JBIGEncode,     image->file);    x_resolution=640;    y_resolution=480; F   (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,!     &x_resolution,&y_resolution);     if (image_info->subimage != 0)4     jbg_enc_layers(&jbig_info,image_info->subimage);   else9     jbg_enc_lrlmax(&jbig_info,x_resolution,y_resolution); #   jbg_enc_lrange(&jbig_info,-1,-1); J   jbg_enc_options(&jbig_info,JBG_ILEAVE | JBG_SMID,JBG_TPDON | JBG_TPBON |     JBG_DPON,-1,-1,-1);    /*     Write JBIG image.    */   jbg_enc_out(&jbig_info);   jbg_enc_free(&jbig_info);    free((char *) pixels);   CloseImage(image);   return(True);  }  #else 4 static unsigned int WriteJBIGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   ;   Warning("JBIG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   #ifdef HasJPEG #include "jpeglib.h" #include "jerror.h"    static Image	   *image;  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  W r i t e J P E G I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WriteJPEGImage writes a JPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % / %  The format of the WriteJPEGImage routine is:  % . %      status=WriteJPEGImage(image_info,image) % + %  A description of each parameter follows:  % L %    o status:  Function WriteJPEGImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 3 %    o jpeg_image:  A pointer to a Image structure.  %  %  */  ( static void EmitMessage(jpeg_info,level) j_common_ptr   jpeg_info;   int    level; {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { H       if (jpeg_error->num_warnings == 0 || jpeg_error->trace_level >= 3)2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }   4 static unsigned int WriteJPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  { 	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];     register int     i,     j,     x;     register JSAMPLE     *q;      register RunlengthPacket     *p;      struct jpeg_compress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     packets;     /*     Open image file.   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize JPEG parameters.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;#   jpeg_create_compress(&jpeg_info); *   jpeg_stdio_dest(&jpeg_info,image->file);'   jpeg_info.image_width=image->columns; %   jpeg_info.image_height=image->rows;    jpeg_info.input_components=3; #   jpeg_info.in_color_space=JCS_RGB;    if (IsGrayImage(image))      { #       jpeg_info.input_components=1; -       jpeg_info.in_color_space=JCS_GRAYSCALE;      }     jpeg_set_defaults(&jpeg_info);8   jpeg_set_quality(&jpeg_info,image_info->quality,True);!   jpeg_info.optimize_coding=True;  #ifdef DCT_FLOAT_SUPPORTED"   jpeg_info.dct_method=JDCT_FLOAT; #endif'   jpeg_start_compress(&jpeg_info,True); '   if (image->comments != (char *) NULL) :     for (i=0; i < (int) strlen(image->comments); i+=65533)P       jpeg_write_marker(&jpeg_info,JPEG_COM,(unsigned char *) image->comments+i,C         (unsigned int) Min((int) strlen(image->comments+i),65533));    /*'     Convert MIFF to JPEG raster pixels.    */4   packets=jpeg_info.input_components*image->columns;:   jpeg_pixels=(JSAMPLE *) malloc(packets*sizeof(JSAMPLE));&   if (jpeg_pixels == (JSAMPLE *) NULL)5     PrematureExit("Unable to allocate memory",image);    p=image->pixels;   q=jpeg_pixels;   x=0;%   scanline[0]=(JSAMPROW) jpeg_pixels; ;   if ((jpeg_info.data_precision > 8) && (QuantumDepth > 8))      { 4       if (jpeg_info.in_color_space == JCS_GRAYSCALE)*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { 0             *q++=(JSAMPLE) (Intensity(*p) >> 4);             x++;$             if (x == image->columns)               { C                 (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                  q=jpeg_pixels;                 x=0;               }            }            p++;	         } 
       else*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { )             *q++=(JSAMPLE) (p->red >> 4); +             *q++=(JSAMPLE) (p->green >> 4); *             *q++=(JSAMPLE) (p->blue >> 4);             x++;$             if (x == image->columns)               { C                 (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                  q=jpeg_pixels;                 x=0;               }            }            p++;	         }      }    else2     if (jpeg_info.in_color_space == JCS_GRAYSCALE)(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { 2           *q++=(JSAMPLE) DownScale(Intensity(*p));           x++;"           if (x == image->columns)
             { A               (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                q=jpeg_pixels;               x=0;
             } 	         }          p++;       }      else(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { +           *q++=(JSAMPLE) DownScale(p->red); -           *q++=(JSAMPLE) DownScale(p->green); ,           *q++=(JSAMPLE) DownScale(p->blue);           x++;"           if (x == image->columns)
             { A               (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                q=jpeg_pixels;               x=0;
             } 	         }          p++;       } #   jpeg_finish_compress(&jpeg_info);    /*     Free memory.   */$   jpeg_destroy_compress(&jpeg_info);   free((char *) jpeg_pixels);    CloseImage(image);   return(True);  }  #else 4 static unsigned int WriteJPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   ;   Warning("JPEG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e L O G O I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteLOGOImage writes an image in the LOGO encoded image format. % / %  The format of the WriteLOGOImage routine is:  % . %      status=WriteLOGOImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteLOGOImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteLOGOImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   6   Warning("Cannot write LOGO images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMAPImage writes an image to a file as red, green, and blue 3 %  colormap bytes followed by the colormap indexes.  % . %  The format of the WriteMAPImage routine is: % - %      status=WriteMAPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMAPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteMAPImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i;     register unsigned char     *q;      unsigned char      *colormap;     unsigned int     packet_size;     unsigned short
     value;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate colormap.   */"   if (image->class == DirectClass)     {        /**         Demote DirectClass to PseudoClass.       */N       QuantizeImage(image,MaxColormapSize,8,image_info->dither,RGBColorspace);       SyncImage(image);      } $   packet_size=3*(image->depth >> 3);   colormap=(unsigned char *)<     malloc(packet_size*image->colors*sizeof(unsigned char));)   if (colormap == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Write colormap to file.    */
   q=colormap; #   for (i=0; i < image->colors; i++)    { +     WriteQuantum(image->colormap[i].red,q); -     WriteQuantum(image->colormap[i].green,q); ,     WriteQuantum(image->colormap[i].blue,q);   } D   (void) fwrite((char *) colormap,1,(int) image->colors*packet_size,     image->file);    free((char *) colormap);   /*     Write image pixels to file.    */#   image->compression=NoCompression; %   (void) RunlengthEncodeImage(image); G   (void) fwrite((char *) image->packed_pixels,(int) image->packet_size, &     (int) image->packets,image->file);&   free((char *) image->packed_pixels);.   image->packed_pixels=(unsigned char *) NULL;   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A T T E I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WriteMATTEImage writes an mage of matte bytes to a file.  ItC %  consists of data from the matte component of the image [0..255].  % 0 %  The format of the WriteMATTEImage routine is: % / %      status=WriteMATTEImage(image_info,image)  % + %  A description of each parameter follows.  % L %    o status: Function WriteMATTEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */5 static unsigned int WriteMATTEImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      if (!image->matte)?     PrematureExit("Image does not have a matte channel",image);    /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate matte pixels.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)4       (void) fputc(DownScale(p->index),image->file);     p++;   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M I F F I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 5 %  Function WriteMIFFImage writes an image to a file.  % / %  The format of the WriteMIFFImage routine is:  % . %      status=WriteMIFFImage(image_info,image) % + %  A description of each parameter follows:  % K %    o status: Function WriteMIFFImage return True if the image is written. K %      False is returned if there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % - %    o image: A pointer to a Image structure.  %  %  */4 static unsigned int WriteMIFFImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i;     unsigned long      packets;  E   if ((image->class != DirectClass) && (image->class != PseudoClass)) /     PrematureExit("Unknown image class",image); <   if ((image->compression != RunlengthEncodedCompression) &&4       (image->compression != QEncodedCompression) &&,       (image->compression != NoCompression))5     PrematureExit("Unknown image compression",image);    /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); &   (void) strcpy(image->magick,"MIFF");   /*     Pack image pixels.   */J   if (IsPseudoClass(image) && (image->compression == QEncodedCompression))     image->class=DirectClass; %   (void) RunlengthEncodeImage(image);    packets=image->packets; 0   if (image->compression == QEncodedCompression)     {        unsigned char          *compressed_pixels;          /*.         Compress image pixels with Q encoding.       */)       compressed_pixels=(unsigned char *) P         malloc((unsigned int) packets*image->packet_size*sizeof(unsigned char));6       if (compressed_pixels == (unsigned char *) NULL)9         PrematureExit("Unable to allocate memory",image); B       packets=QEncodeImage(image->packed_pixels,compressed_pixels,=         image->columns*(int) image->packet_size,image->rows); *       free((char *) image->packed_pixels);-       image->packed_pixels=compressed_pixels;        image->packet_size=1;      } "   if (image->class == PseudoClass)     ColormapSignature(image);    /*     Write header to file.    */1   (void) fprintf(image->file,"id=ImageMagick\n"); "   if (image->class == PseudoClass)N     (void) fprintf(image->file,"class=PseudoClass  colors=%u  signature=%s\n",&       image->colors,image->signature);   else     if (image->matte) D       (void) fprintf(image->file,"class=DirectClass  matte=True\n");     else8       (void) fprintf(image->file,"class=DirectClass\n");8   if (image->compression == RunlengthEncodedCompression)M     (void) fprintf(image->file,"compression=RunlengthEncoded  packets=%lu\n",        packets);    else2     if (image->compression == QEncodedCompression)P       (void) fprintf(image->file,"compression=QEncoded  packets=%lu\n",packets);N   (void) fprintf(image->file,"columns=%u  rows=%u  depth=%u\n",image->columns,     image->rows,image->depth);   if (image->scene != 0):     (void) fprintf(image->file,"scene=%u\n",image->scene);&   if (image->montage != (char *) NULL)>     (void) fprintf(image->file,"montage=%s\n",image->montage);'   if (image->comments != (char *) NULL) =     (void) fprintf(image->file,"{\n%s\n}\n",image->comments); (   (void) fprintf(image->file,"\f\n:\n");&   if (image->montage != (char *) NULL)     {        /*%         Write montage tile directory.        */,       if (image->directory != (char *) NULL):         (void) fprintf(image->file,"%s",image->directory);%       (void) fputc('\0',image->file);      } "   if (image->class == PseudoClass)     {        register unsigned char         *q;          unsigned char          *colormap;         unsigned int         packet_size;         unsigned short         value;         /*         Allocate colormap.       */(       packet_size=3*(image->depth >> 3);        colormap=(unsigned char *)@         malloc(packet_size*image->colors*sizeof(unsigned char));-       if (colormap == (unsigned char *) NULL) 9         PrematureExit("Unable to allocate memory",image);        q=colormap; '       for (i=0; i < image->colors; i++)        { /         WriteQuantum(image->colormap[i].red,q); 1         WriteQuantum(image->colormap[i].green,q); 0         WriteQuantum(image->colormap[i].blue,q);       }        /*         Write colormap to file.        */H       (void) fwrite((char *) colormap,1,(int) image->colors*packet_size,         image->file);        free((char *) colormap);     }    /*     Write image pixels to file.    */G   (void) fwrite((char *) image->packed_pixels,(int) image->packet_size,      (int) packets,image->file); &   free((char *) image->packed_pixels);.   image->packed_pixels=(unsigned char *) NULL;   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M P E G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteMPEGImage writes an image in the MPEG encoded image format. % / %  The format of the WriteMPEGImage routine is:  % . %      status=WriteMPEGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteMPEGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteMPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   6   Warning("Cannot write MPEG images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M T V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMTVImage writes an image to a file in red, green, and blue  %  MTV rasterfile format.  % . %  The format of the WriteMTVImage routine is: % - %      status=WriteMTVImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMTVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteMTVImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*&     Convert MIFF to MTV raster pixels.   */C   (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);    p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     { 2       (void) fputc(DownScale(p->red),image->file);4       (void) fputc(DownScale(p->green),image->file);3       (void) fputc(DownScale(p->blue),image->file);      }      p++;   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C D I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WritePCDImage writes an image in the Photo CD encoded image 
 %  format. % . %  The format of the WritePCDImage routine is: % - %      status=WritePCDImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePCDImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   5   Warning("Cannot write PCD images",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WritePCXImage writes an image in the ZSoft IBM PC Paintbrush file 
 %  format. % . %  The format of the WritePCXImage routine is: % - %      status=WritePCXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePCXImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _PCXHeader    {      unsigned char        identifier,        version,       encoding,        bits_per_pixel;   
     short int        left, 
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int        bytes_per_line,        palette_info;        unsigned char        colormap_signature;    } PCXHeader;     PCXHeader      pcx_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char 
     count,     packet,      *pcx_colormap,     *pcx_pixels,
     previous;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*&     Initialize PCX raster file header.   */=   if ((image->class == DirectClass) || (image->colors > 256))      {        /**         Demote DirectClass to PseudoClass.       */B       QuantizeImage(image,256,8,image_info->dither,RGBColorspace);       SyncImage(image);      }    pcx_header.identifier=0x0a;    pcx_header.version=5;    pcx_header.encoding=1;   pcx_header.bits_per_pixel=8;1   if (IsGrayImage(image) && (image->colors == 2))       pcx_header.bits_per_pixel=1;   pcx_header.left=0;   pcx_header.top=0; $   pcx_header.right=image->columns-1;"   pcx_header.bottom=image->rows-1;2   pcx_header.horizontal_resolution=image->columns;-   pcx_header.vertical_resolution=image->rows;    pcx_header.reserved=0;   pcx_header.planes=1;K   pcx_header.bytes_per_line=(image->columns*pcx_header.bits_per_pixel+7)/8;    pcx_header.palette_info=1;%   pcx_header.colormap_signature=0x0c;    /*     Write PCX header.    */8   (void) fwrite(&pcx_header.identifier,1,1,image->file);5   (void) fwrite(&pcx_header.version,1,1,image->file); 6   (void) fwrite(&pcx_header.encoding,1,1,image->file);<   (void) fwrite(&pcx_header.bits_per_pixel,1,1,image->file);A   LSBFirstWriteShort((unsigned int) pcx_header.left,image->file); @   LSBFirstWriteShort((unsigned int) pcx_header.top,image->file);B   LSBFirstWriteShort((unsigned int) pcx_header.right,image->file);C   LSBFirstWriteShort((unsigned int) pcx_header.bottom,image->file); E   LSBFirstWriteShort((unsigned int) pcx_header.horizontal_resolution,      image->file); P   LSBFirstWriteShort((unsigned int) pcx_header.vertical_resolution,image->file);   /*     Dump colormap to file.   */E   pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); -   if (pcx_colormap == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    q=pcx_colormap; #   for (i=0; i < image->colors; i++)    { +     *q++=DownScale(image->colormap[i].red); -     *q++=DownScale(image->colormap[i].green); ,     *q++=DownScale(image->colormap[i].blue);   } 8   (void) fwrite((char *) pcx_colormap,3,16,image->file);6   (void) fwrite(&pcx_header.reserved,1,1,image->file);4   (void) fwrite(&pcx_header.planes,1,1,image->file);K   LSBFirstWriteShort((unsigned int) pcx_header.bytes_per_line,image->file); I   LSBFirstWriteShort((unsigned int) pcx_header.palette_info,image->file);    for (i=0; i < 58; i++)(     (void) fwrite("\0",1,1,image->file);   /*&     Convert MIFF to PCX raster pixels.   */   pcx_pixels=(unsigned char *)H     malloc(pcx_header.bytes_per_line*image->rows*sizeof(unsigned char));+   if (pcx_pixels == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    x=0;   y=0;   p=image->pixels;   q=pcx_pixels; $   if (pcx_header.bits_per_pixel > 1)&     for (i=0; i < image->packets; i++)     { *       for (j=0; j <= (int) p->length; j++)       {          *q++=p->index;         x++;          if (x == image->columns)           {              x=0;             y++;5             q=pcx_pixels+y*pcx_header.bytes_per_line;            }        } 
       p++;     }    else     {        register unsigned char         bit,
         byte,          polarity;          /*<         Convert PseudoClass image to a PCX monochrome image.       */       polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);        bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) %                 *q++=byte << (8-bit);                bit=0;               byte=0;                x=0;               y++;7               q=pcx_pixels+y*pcx_header.bytes_per_line;             }	         }          p++;       }      }    /*!     Runlength-encoded PCX pixels.    */!   for (y=0; y < image->rows; y++)    { -     q=pcx_pixels+y*pcx_header.bytes_per_line;      previous=(*q++);     count=1;5     for (x=0; x < (pcx_header.bytes_per_line-1); x++)      {        packet=(*q++);/       if ((packet == previous) && (count < 63)) 	         {            count++;           continue; 	         } 5       if ((count > 1) || ((previous & 0xc0) == 0xc0)) 	         {            count|=0xc0;0           (void) fwrite(&count,1,1,image->file);	         } /       (void) fwrite(&previous,1,1,image->file);        previous=packet;       count=1;     } 3     if ((count > 1) || ((previous & 0xc0) == 0xc0))        {          count|=0xc0;.         (void) fwrite(&count,1,1,image->file);       } -     (void) fwrite(&previous,1,1,image->file);    } @   (void) fwrite(&pcx_header.colormap_signature,1,1,image->file);9   (void) fwrite((char *) pcx_colormap,3,256,image->file);    free((char *) pcx_pixels);   free((char *) pcx_colormap);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P D F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WritePDFImage writes an image in the Portable Document image
 %  format. % . %  The format of the WritePDFImage routine is: % - %      status=WritePDFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePDFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  { + #define DefaultThumbnailGeometry  "106x106"      char     date[MaxTextLength];     int      delta_x,     delta_y,
     flags,     sans_offset,     x,
     xref[15],      y;     Image      encode_image,      *tile_image;     register RunlengthPacket     *p;      register unsigned char     *q;      register int     i,     j;     time_t
     timer;     unsigned char      *pixels;     unsigned int     dx_resolution,     dy_resolution,     height,      length,      number_objects,      number_packets,      page_height,     page_width,      text_size,     x_resolution,      y_resolution, 
     width;     /*     Open output image file.    */   OpenImage(image,"w"); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); -   if ((image->file == stdout) || image->pipe)      {        /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);        image->temporary=True;       OpenImage(image,"w"); '       if (image->file == (FILE *) NULL) 3         PrematureExit("Unable to open file",image);      }    /*+     Scale image to size of Postscript page.    */3   text_size=image->label == (char *) NULL ? 0 : 36;    x=0;   y=0;   width=image->columns;    height=image->rows;    /*+     Center image on Portable Document page.    */G   (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height); H   flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);(   if (((page_width-(x << 1)) < width) ||2       ((page_height-(y << 1)-text_size) < height))     {        unsigned long          scale_factor;          /*7         Scale image relative to Portable Document page.        */6       scale_factor=UpShift(page_width-(x << 1))/width;J       if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))D         scale_factor=UpShift(page_height-(y << 1)-text_size)/height;*       width=DownShift(width*scale_factor);,       height=DownShift(height*scale_factor);     }    if ((flags & XValue) == 0)     {        /*(         Center image in the X direction.       */*       delta_x=page_width-(width+(x << 1));       if (delta_x >= 0)          x=(delta_x >> 1)+x;      }    if ((flags & YValue) == 0)     {        /*(         Center image in the X direction.       */6       delta_y=page_height-(height+(y << 1))-text_size;       if (delta_y >= 0)          y=(delta_y >> 1)+y;      }    /*$     Scale relative to dots-per-inch.   */D   (void) XParseGeometry(PSDensityGeometry,&sans_offset,&sans_offset,#     &dx_resolution,&dy_resolution);    x_resolution=dx_resolution;    y_resolution=dy_resolution; F   (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,!     &x_resolution,&y_resolution); +   width=(width*dx_resolution)/x_resolution; -   height=(height*dy_resolution)/y_resolution;    /*     Write Info object.   */-   (void) fprintf(image->file,"%%PDF-1.1 \n");    xref[0]=ftell(image->file); *   (void) fprintf(image->file,"1 0 obj\n");%   (void) fprintf(image->file,"<<\n");    timer=time((time_t *) NULL);   (void) localtime(&timer); $   (void) strcpy(date,ctime(&timer));   date[strlen(date)-1]='\0';:   (void) fprintf(image->file,"/CreationDate (%s)\n",date);8   (void) fprintf(image->file,"/Producer ImageMagick\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Catalog object.    */   xref[1]=ftell(image->file); *   (void) fprintf(image->file,"2 0 obj\n");%   (void) fprintf(image->file,"<<\n"); 1   (void) fprintf(image->file,"/Type /Catalog\n"); /   (void) fprintf(image->file,"/Pages 3 0 R\n"); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Pages object.    */   xref[2]=ftell(image->file); *   (void) fprintf(image->file,"3 0 obj\n");%   (void) fprintf(image->file,"<<\n"); /   (void) fprintf(image->file,"/Type /Pages\n"); +   (void) fprintf(image->file,"/Count 1\n"); 2   (void) fprintf(image->file,"/Kids [ 4 0 R ]\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Page object.   */   xref[3]=ftell(image->file); *   (void) fprintf(image->file,"4 0 obj\n");%   (void) fprintf(image->file,"<<\n"); .   (void) fprintf(image->file,"/Type /Page\n");0   (void) fprintf(image->file,"/Parent 3 0 R\n");0   (void) fprintf(image->file,"/Resources <<\n");8   (void) fprintf(image->file,"/Font << /F0 8 0 R >>\n");<   (void) fprintf(image->file,"/XObject << /Im0 9 0 R >>\n");4   (void) fprintf(image->file,"/ProcSet 7 0 R >>\n");9   (void) fprintf(image->file,"/MediaBox [ 0 0 %d %d ]\n",      page_width,page_height);2   (void) fprintf(image->file,"/Contents 5 0 R\n");0   (void) fprintf(image->file,"/Thumb 12 0 R\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Contents object.   */   xref[4]=ftell(image->file); *   (void) fprintf(image->file,"5 0 obj\n");%   (void) fprintf(image->file,"<<\n"); 0   (void) fprintf(image->file,"/Length 6 0 R\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"stream\n");    length=ftell(image->file);$   (void) fprintf(image->file,"q\n");%   (void) fprintf(image->file,"BT\n"); ,   (void) fprintf(image->file,"/F0 24 Tf\n");M   (void) fprintf(image->file,"%d %d Td\n",x >> 1,y+(int) height+(y >> 1)+12); $   if (image->label == (char *) NULL)*     (void) fprintf(image->file,"() Tj\n");   else9     (void) fprintf(image->file,"(%s) Tj\n",image->label); %   (void) fprintf(image->file,"ET\n"); B   (void) fprintf(image->file,"%d 0 0 %d %d %d cm\n",x+(int) width,"     y+(int) height,x >> 1,y >> 1);*   (void) fprintf(image->file,"/Im0 Do\n");$   (void) fprintf(image->file,"Q\n");#   length=ftell(image->file)-length; ,   (void) fprintf(image->file,"endstream\n");)   (void) fprintf(image->file,"endobj\n");    /*     Write Length object.   */   xref[5]=ftell(image->file); *   (void) fprintf(image->file,"6 0 obj\n");,   (void) fprintf(image->file,"%d\n",length);)   (void) fprintf(image->file,"endobj\n");    /*     Write Procset object.    */   xref[6]=ftell(image->file); *   (void) fprintf(image->file,"7 0 obj\n");   if (!IsPseudoClass(image))7     (void) fprintf(image->file,"[ /PDF /Text /ImageC");    else3     if (IsGrayImage(image) && (image->colors == 2)) 9       (void) fprintf(image->file,"[ /PDF /Text /ImageB");      else9       (void) fprintf(image->file,"[ /PDF /Text /ImageI"); %   (void) fprintf(image->file," ]\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Font object.   */   xref[7]=ftell(image->file); *   (void) fprintf(image->file,"8 0 obj\n");%   (void) fprintf(image->file,"<<\n"); .   (void) fprintf(image->file,"/Type /Font\n");2   (void) fprintf(image->file,"/Subtype /Type1\n");,   (void) fprintf(image->file,"/Name /F0\n");7   (void) fprintf(image->file,"/BaseFont /Helvetica\n"); >   (void) fprintf(image->file,"/Encoding /MacRomanEncoding\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write XObject object.    */   xref[8]=ftell(image->file); *   (void) fprintf(image->file,"9 0 obj\n");%   (void) fprintf(image->file,"<<\n"); 1   (void) fprintf(image->file,"/Type /XObject\n"); 2   (void) fprintf(image->file,"/Subtype /Image\n");-   (void) fprintf(image->file,"/Name /Im0\n"); *   if (image->compression == NoCompression);     (void) fprintf(image->file,"/Filter /ASCII85Decode\n");    elseJ     (void) fprintf(image->file,"/Filter [ /ASCII85Decode /LZWDecode ]\n");;   (void) fprintf(image->file,"/Width %u\n",image->columns); 9   (void) fprintf(image->file,"/Height %u\n",image->rows); 5   (void) fprintf(image->file,"/ColorSpace 11 0 R\n"); 6   (void) fprintf(image->file,"/BitsPerComponent %d\n",8     IsGrayImage(image) && (image->colors == 2) ? 1 : 8);1   (void) fprintf(image->file,"/Length 10 0 R\n"); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"stream\n");    length=ftell(image->file);   p=image->pixels;   if (!IsPseudoClass(image))     switch (image->compression)      { '       case RunlengthEncodedCompression:        default:       { 
         /*           Allocate pixel array. 
         */4         number_packets=3*image->columns*image->rows;N         pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));-         if (pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); 
         /*"           Dump LZW encoded pixels.
         */         q=pixels; *         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { :             if (image->matte && (p->index == Transparent))               { '                 *q++=DownScale(MaxRGB); '                 *q++=DownScale(MaxRGB); '                 *q++=DownScale(MaxRGB);                }              else               { '                 *q++=DownScale(p->red); )                 *q++=DownScale(p->green); (                 *q++=DownScale(p->blue);               }            }            p++;	         } B         (void) LZWEncodeFilter(image->file,pixels,number_packets);         free((char *) pixels);         break;       }        case NoCompression:        { 
         /*0           Dump uncompressed DirectColor packets.
         */         Ascii85Initialize();*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           { :             if (image->matte && (p->index == Transparent))               { =                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file);                }              else               { =                 Ascii85Encode(DownScale(p->red),image->file); ?                 Ascii85Encode(DownScale(p->green),image->file); >                 Ascii85Encode(DownScale(p->blue),image->file);               }            }            p++;	         } "         Ascii85Flush(image->file);         break;       }      }    else3     if (IsGrayImage(image) && (image->colors == 2))        {          register unsigned char           bit,           byte,            polarity;   O         polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);          bit=0;         byte=0;          x=0;#         switch (image->compression) 	         { +           case RunlengthEncodedCompression:            default:           {              /*#               Allocate pixel array.              */A             number_packets=((image->columns+7) >> 3)*image->rows; $             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char)); 1             if (pixels == (unsigned char *) NULL) ?               PrematureExit("Unable to allocate memory",image);              /*&               Dump LZW encoded pixels.             */             q=pixels; .             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;                  bit++;                 if (bit == 8)                    {                      *q++=byte;                     bit=0;                     byte=0;                    }                  x++;(                 if (x == image->columns)                   {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) +                       *q++=byte << (8-bit);                      bit=0;                     byte=0;                      x=0;                     y++;                  }               }                p++;
             } F             (void) LZWEncodeFilter(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }            case NoCompression:            {              /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();.             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;                  bit++;                 if (bit == 8)                    { 4                     Ascii85Encode(byte,image->file);                     bit=0;                     byte=0;                    }                  x++;(                 if (x == image->columns)                   {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) A                       Ascii85Encode(byte << (8-bit),image->file);                      bit=0;                     byte=0;                      x=0;                     y++;                  }               }                p++;
             } &             Ascii85Flush(image->file);             break;           } 	         }        }      else       { 
         /*-           Dump number of colors and colormap. 
         */#         switch (image->compression) 	         { +           case RunlengthEncodedCompression:            default:           {              /*#               Allocate pixel array.              */6             number_packets=image->columns*image->rows;$             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char)); 1             if (pixels == (unsigned char *) NULL) ?               PrematureExit("Unable to allocate memory",image);              /*&               Dump LZW encoded pixels.             */             q=pixels; .             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++).                 *q++=(unsigned char) p->index;               p++;
             } F             (void) LZWEncodeFilter(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }            case NoCompression:            {              /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)D                 Ascii85Encode((unsigned char) p->index,image->file);               p++;
             } &             Ascii85Flush(image->file);             break;           } 	         }        } #   length=ftell(image->file)-length; .   (void) fprintf(image->file,"\nendstream\n");)   (void) fprintf(image->file,"endobj\n");    /*     Write Length object.   */   xref[9]=ftell(image->file); +   (void) fprintf(image->file,"10 0 obj\n"); ,   (void) fprintf(image->file,"%d\n",length);)   (void) fprintf(image->file,"endobj\n");    /*     Write Colorspace object.   */   xref[10]=ftell(image->file);+   (void) fprintf(image->file,"11 0 obj\n");    if (!IsPseudoClass(image))/     (void) fprintf(image->file,"/DeviceRGB\n");    else3     if (IsGrayImage(image) && (image->colors == 2)) 2       (void) fprintf(image->file,"/DeviceGray\n");     elseG       (void) fprintf(image->file,"[ /Indexed /DeviceRGB %d 14 0 R ]\n",          image->colors-1); )   (void) fprintf(image->file,"endobj\n");    /*     Write Thumb object.    */   image->orphan=True; >   ParseImageGeometry(DefaultThumbnailGeometry,&width,&height);"   if (image->class == PseudoClass)/     tile_image=SampleImage(image,width,height);    else.     tile_image=ScaleImage(image,width,height);   image->orphan=False;#   if (tile_image == (Image *) NULL) 5     PrematureExit("Unable to allocate memory",image);    xref[11]=ftell(image->file);+   (void) fprintf(image->file,"12 0 obj\n"); %   (void) fprintf(image->file,"<<\n"); *   if (image->compression == NoCompression);     (void) fprintf(image->file,"/Filter /ASCII85Decode\n");    elseJ     (void) fprintf(image->file,"/Filter [ /ASCII85Decode /LZWDecode ]\n");@   (void) fprintf(image->file,"/Width %u\n",tile_image->columns);>   (void) fprintf(image->file,"/Height %u\n",tile_image->rows);5   (void) fprintf(image->file,"/ColorSpace 11 0 R\n"); 6   (void) fprintf(image->file,"/BitsPerComponent %d\n",B     IsGrayImage(tile_image) && (tile_image->colors == 2) ? 1 : 8);1   (void) fprintf(image->file,"/Length 13 0 R\n"); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"stream\n");    length=ftell(image->file);   p=tile_image->pixels; !   if (!IsPseudoClass(tile_image)) $     switch (tile_image->compression)     { '       case RunlengthEncodedCompression:        default:       { 
         /*           Allocate pixel array. 
         */>         number_packets=3*tile_image->columns*tile_image->rows;N         pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));-         if (pixels == (unsigned char *) NULL)            { %             DestroyImage(tile_image); =             PrematureExit("Unable to allocate memory",image);            } 
         /*"           Dump LZW encoded pixels.
         */         q=pixels; /         for (i=0; i < tile_image->packets; i++) 	         { .           for (j=0; j <= (int) p->length; j++)           { ?             if (tile_image->matte && (p->index == Transparent))                { '                 *q++=DownScale(MaxRGB); '                 *q++=DownScale(MaxRGB); '                 *q++=DownScale(MaxRGB);                }              else               { '                 *q++=DownScale(p->red); )                 *q++=DownScale(p->green); (                 *q++=DownScale(p->blue);               }            }            p++;	         } B         (void) LZWEncodeFilter(image->file,pixels,number_packets);         free((char *) pixels);         break;       }        case NoCompression:        { 
         /*0           Dump uncompressed DirectColor packets.
         */         Ascii85Initialize();/         for (i=0; i < tile_image->packets; i++) 	         { 0           for (j=0; j <= ((int) p->length); j++)           { ?             if (tile_image->matte && (p->index == Transparent))                { =                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file);                }              else               { =                 Ascii85Encode(DownScale(p->red),image->file); ?                 Ascii85Encode(DownScale(p->green),image->file); >                 Ascii85Encode(DownScale(p->blue),image->file);               }            }            p++;	         } "         Ascii85Flush(image->file);         break;       }      }    else=     if (IsGrayImage(tile_image) && (tile_image->colors == 2))        {          register unsigned char           bit,           byte,            polarity;   5         polarity=Intensity(tile_image->colormap[0]) < -           Intensity(tile_image->colormap[1]);          bit=0;         byte=0;          x=0;(         switch (tile_image->compression)	         { +           case RunlengthEncodedCompression:            default:           {              /*#               Allocate pixel array.              */K             number_packets=((tile_image->columns+7) >> 3)*tile_image->rows; $             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char)); 1             if (pixels == (unsigned char *) NULL)                { )                 DestroyImage(tile_image); A                 PrematureExit("Unable to allocate memory",image);                }              /*&               Dump LZW encoded pixels.             */             q=pixels; 3             for (i=0; i < tile_image->packets; i++) 
             { 2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;                  bit++;                 if (bit == 8)                    {                      *q++=byte;                     bit=0;                     byte=0;                    }                  x++;-                 if (x == tile_image->columns)                    {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) +                       *q++=byte << (8-bit);                      bit=0;                     byte=0;                      x=0;                     y++;                  }               }                p++;
             } F             (void) LZWEncodeFilter(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }            case NoCompression:            {              /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();3             for (i=0; i < tile_image->packets; i++) 
             { 2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;                  bit++;                 if (bit == 8)                    { 4                     Ascii85Encode(byte,image->file);                     bit=0;                     byte=0;                    }                  x++;-                 if (x == tile_image->columns)                    {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) A                       Ascii85Encode(byte << (8-bit),image->file);                      bit=0;                     byte=0;                      x=0;                     y++;                  }               }                p++;
             } &             Ascii85Flush(image->file);             break;           } 	         }        }      else       { 
         /*-           Dump number of colors and colormap. 
         */(         switch (tile_image->compression)	         { +           case RunlengthEncodedCompression:            default:           {              /*#               Allocate pixel array.              */@             number_packets=tile_image->columns*tile_image->rows;$             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char)); 1             if (pixels == (unsigned char *) NULL)                { )                 DestroyImage(tile_image); A                 PrematureExit("Unable to allocate memory",image);                }              /*&               Dump LZW encoded pixels.             */             q=pixels; 3             for (i=0; i < tile_image->packets; i++) 
             { 2               for (j=0; j <= (int) p->length; j++).                 *q++=(unsigned char) p->index;               p++;
             } F             (void) LZWEncodeFilter(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }            case NoCompression:            {              /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();3             for (i=0; i < tile_image->packets; i++) 
             { 4               for (j=0; j <= ((int) p->length); j++)D                 Ascii85Encode((unsigned char) p->index,image->file);               p++;
             } &             Ascii85Flush(image->file);             break;           } 	         }        }    DestroyImage(tile_image); #   length=ftell(image->file)-length; .   (void) fprintf(image->file,"\nendstream\n");)   (void) fprintf(image->file,"endobj\n");    /*     Write Length object.   */   xref[12]=ftell(image->file);+   (void) fprintf(image->file,"13 0 obj\n"); ,   (void) fprintf(image->file,"%d\n",length);)   (void) fprintf(image->file,"endobj\n");    number_objects=13;"   if (image->class == PseudoClass)4     if (!IsGrayImage(image) || (image->colors != 2))       { 
         /*            Write Colormap object.
         */         number_objects+=2;$         xref[13]=ftell(image->file);1         (void) fprintf(image->file,"14 0 obj\n"); +         (void) fprintf(image->file,"<<\n"); @         (void) fprintf(image->file,"/Filter /ASCII85Decode \n");7         (void) fprintf(image->file,"/Length 15 0 R\n"); +         (void) fprintf(image->file,">>\n"); /         (void) fprintf(image->file,"stream\n"); "         length=ftell(image->file);         Ascii85Initialize();)         for (i=0; i < image->colors; i++) 	         { G           Ascii85Encode(DownScale(image->colormap[i].red),image->file); I           Ascii85Encode(DownScale(image->colormap[i].green),image->file); H           Ascii85Encode(DownScale(image->colormap[i].blue),image->file);	         } "         Ascii85Flush(image->file);)         length=ftell(image->file)-length; 4         (void) fprintf(image->file,"\nendstream\n");/         (void) fprintf(image->file,"endobj\n"); 
         /*           Write Length object.
         */$         xref[14]=ftell(image->file);1         (void) fprintf(image->file,"15 0 obj\n"); 2         (void) fprintf(image->file,"%d\n",length);/         (void) fprintf(image->file,"endobj\n");        }    /*     Write Xref object.   */'   length=ftell(image->file)-xref[0]+10; '   (void) fprintf(image->file,"xref\n"); 8   (void) fprintf(image->file,"0 %d\n",number_objects+1);6   (void) fprintf(image->file,"0000000000 65535 f \n");$   for (i=0; i < number_objects; i++);     (void) fprintf(image->file,"%010d 00000 n \n",xref[i]); *   (void) fprintf(image->file,"trailer\n");%   (void) fprintf(image->file,"<<\n"); <   (void) fprintf(image->file,"/Size %d\n",number_objects+1);.   (void) fprintf(image->file,"/Info 1 0 R\n");.   (void) fprintf(image->file,"/Root 2 0 R\n");%   (void) fprintf(image->file,">>\n"); ,   (void) fprintf(image->file,"startxref\n");,   (void) fprintf(image->file,"%d\n",length);*   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   if (image->temporary)      { 
       FILE         *file;  	       int 
         c;         /*7         Copy temporary file to standard output or pipe.        */'       file=fopen(image->filename,"rb");         if (file == (FILE *) NULL)3         PrematureExit("Unable to open file",image);        c=fgetc(file);       while (c != EOF)       { )         (void) putc(c,encode_image.file);          c=fgetc(file);       }        (void) fclose(file);%       (void) unlink(image->filename);         CloseImage(&encode_image);     }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P I C T I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WritePICTImage writes an image to a file in the Apple Macintosh  %  QuickDraw/PICT image format.  % / %  The format of the WritePICTImage routine is:  % . %      status=WritePICTImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WritePICTImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WritePICTImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {  #define MaxCount  128  #define PictCropRegionOp  0x01  #define PictEndOfPictureOp  0xff #define PictHeaderOp  0x0C00 #define PictHeaderSize  512  #define PictPixmapOp  0x9A #define PictPackbitsOp  0x98 #define PictVersion  0x11      typedef struct _PICTRectangle    {      unsigned short
       top,       left, 
       bottom,        right;   } PICTRectangle;     typedef struct _PICTPixmap   {      unsigned short       base_address,        row_bytes;       PICTRectangle 
       bounds;        unsigned short       version,       pack_type;       unsigned long        pack_size,       horizontal_resolution,       vertical_resolution;       unsigned short       pixel_type,        pixel_size,        component_count,       component_size;        unsigned short       plane_bytes,       table,       reserved;    } PICTPixmap;      int 
     count;     PICTPixmap     pixmap;      PICTRectangle      crop_rectangle,      destination_rectangle,     frame_rectangle,     size_rectangle,      source_rectangle;      register int     i,     j,     x;     register RunlengthPacket     *p;      unsigned char      *buffer,     *packed_scanline,      *scanline;     unsigned int     bytes_per_line;      unsigned short     transfer_mode;     unsigned long      horizontal_resolution,     vertical_resolution;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate memory.   */    bytes_per_line=image->columns;"   if (image->class == DirectClass)     bytes_per_line*=3;H   buffer=(unsigned char *) malloc(PictHeaderSize*sizeof(unsigned char));#   packed_scanline=(unsigned char *) M     malloc((bytes_per_line+bytes_per_line/MaxCount+1)*sizeof(unsigned char)); J   scanline=(unsigned char *) malloc(bytes_per_line*sizeof(unsigned char));+   if ((buffer == (unsigned char *) NULL) || 4       (packed_scanline == (unsigned char *) NULL) ||+       (scanline == (unsigned char *) NULL)) 5     PrematureExit("Unable to allocate memory",image);    /*     Initialize image info.   */   size_rectangle.top=0;    size_rectangle.left=0;#   size_rectangle.right=image->rows; '   size_rectangle.bottom=image->columns; !   frame_rectangle=size_rectangle;     crop_rectangle=size_rectangle;"   source_rectangle=size_rectangle;'   destination_rectangle=size_rectangle; #   horizontal_resolution=0x00480000; !   vertical_resolution=0x00480000;    pixmap.base_address=0xff;    pixmap.row_bytes= D     ((image->class == DirectClass ? 4 : 1)*image->columns) | 0x8000;   pixmap.version=0;    pixmap.bounds.top=0;   pixmap.bounds.left=0; "   pixmap.bounds.right=image->rows;&   pixmap.bounds.bottom=image->columns;=   pixmap.pack_type=(image->class == DirectClass ? 0x4 : 0x0);    pixmap.pack_size=0; 5   pixmap.horizontal_resolution=horizontal_resolution; 1   pixmap.vertical_resolution=vertical_resolution; ;   pixmap.pixel_type=(image->class == DirectClass ? 16 : 0); ;   pixmap.pixel_size=(image->class == DirectClass ? 32 : 8); ?   pixmap.component_count=(image->class == DirectClass ? 3 : 1);    pixmap.component_size=8;   pixmap.plane_bytes=0;    pixmap.table=0;    pixmap.reserved=0;9   transfer_mode=(image->class == DirectClass ? 0x40 : 0);    /*H     Write header, header size, size bounding box, version, and reserved.   */$   for (i=0; i < PictHeaderSize; i++)     buffer[i]=0;>   (void) fwrite((char *) buffer,1,PictHeaderSize,image->file);$   MSBFirstWriteShort(0,image->file);5   MSBFirstWriteShort(size_rectangle.top,image->file); 6   MSBFirstWriteShort(size_rectangle.left,image->file);7   MSBFirstWriteShort(size_rectangle.right,image->file); 8   MSBFirstWriteShort(size_rectangle.bottom,image->file);.   MSBFirstWriteShort(PictVersion,image->file);)   MSBFirstWriteShort(0x02FF,image->file); /   MSBFirstWriteShort(PictHeaderOp,image->file);    /*N     Write full size of the file, resolution, frame bounding box, and reserved.   */-   MSBFirstWriteLong(0xFFFE0000L,image->file); 7   MSBFirstWriteLong(horizontal_resolution,image->file); 5   MSBFirstWriteLong(vertical_resolution,image->file); 6   MSBFirstWriteShort(frame_rectangle.top,image->file);7   MSBFirstWriteShort(frame_rectangle.left,image->file); 8   MSBFirstWriteShort(frame_rectangle.right,image->file);9   MSBFirstWriteShort(frame_rectangle.bottom,image->file); $   MSBFirstWriteLong(0L,image->file);   /*3     Write crop region opcode and crop bounding box.    */3   MSBFirstWriteShort(PictCropRegionOp,image->file); &   MSBFirstWriteShort(0xA,image->file);5   MSBFirstWriteShort(crop_rectangle.top,image->file); 6   MSBFirstWriteShort(crop_rectangle.left,image->file);7   MSBFirstWriteShort(crop_rectangle.right,image->file); 8   MSBFirstWriteShort(crop_rectangle.bottom,image->file);   /*K     Write picture opcode, row bytes, and picture bounding box, and version.    */"   if (image->class == PseudoClass)3     MSBFirstWriteShort(PictPackbitsOp,image->file);    else     { 3       MSBFirstWriteShort(PictPixmapOp,image->file); I       MSBFirstWriteLong((unsigned long) pixmap.base_address,image->file);      } <   MSBFirstWriteShort(pixmap.row_bytes | 0x8000,image->file);4   MSBFirstWriteShort(pixmap.bounds.top,image->file);5   MSBFirstWriteShort(pixmap.bounds.left,image->file); 6   MSBFirstWriteShort(pixmap.bounds.right,image->file);7   MSBFirstWriteShort(pixmap.bounds.bottom,image->file); 1   MSBFirstWriteShort(pixmap.version,image->file);    /*G     Write pack type, pack size, resolution, pixel type, and pixel size.    */3   MSBFirstWriteShort(pixmap.pack_type,image->file); 2   MSBFirstWriteLong(pixmap.pack_size,image->file);>   MSBFirstWriteLong(pixmap.horizontal_resolution,image->file);<   MSBFirstWriteLong(pixmap.vertical_resolution,image->file);4   MSBFirstWriteShort(pixmap.pixel_type,image->file);4   MSBFirstWriteShort(pixmap.pixel_size,image->file);   /*G     Write component count, size, plane bytes, table size, and reserved.    */9   MSBFirstWriteShort(pixmap.component_count,image->file); 8   MSBFirstWriteShort(pixmap.component_size,image->file);D   MSBFirstWriteLong((unsigned long) pixmap.plane_bytes,image->file);>   MSBFirstWriteLong((unsigned long) pixmap.table,image->file);A   MSBFirstWriteLong((unsigned long) pixmap.reserved,image->file); "   if (image->class == PseudoClass)     {        unsigned short         red,         green,
         blue;          /*         Write image colormap.        */:       MSBFirstWriteLong(0L,image->file);  /* color seed */<       MSBFirstWriteShort(0L,image->file);  /* color flags */I       MSBFirstWriteShort((unsigned short) (image->colors-1),image->file); '       for (i=0; i < image->colors; i++)        { A         red=(image->colormap[i].red*65535)/(unsigned int) MaxRGB; E         green=(image->colormap[i].green*65535)/(unsigned int) MaxRGB; C         blue=(image->colormap[i].blue*65535)/(unsigned int) MaxRGB; 9         MSBFirstWriteShort((unsigned int) i,image->file); ,         MSBFirstWriteShort(red,image->file);.         MSBFirstWriteShort(green,image->file);-         MSBFirstWriteShort(blue,image->file);        }      }    /*+     Write source and destination rectangle.    */7   MSBFirstWriteShort(source_rectangle.top,image->file); 8   MSBFirstWriteShort(source_rectangle.left,image->file);9   MSBFirstWriteShort(source_rectangle.right,image->file); :   MSBFirstWriteShort(source_rectangle.bottom,image->file);<   MSBFirstWriteShort(destination_rectangle.top,image->file);=   MSBFirstWriteShort(destination_rectangle.left,image->file); >   MSBFirstWriteShort(destination_rectangle.right,image->file);?   MSBFirstWriteShort(destination_rectangle.bottom,image->file); 0   MSBFirstWriteShort(transfer_mode,image->file);   /*     Write picture data.    */
   count=0;   x=0;   p=image->pixels;"   if (image->class == PseudoClass)     {        register unsigned char         *index;          index=scanline; (       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { ,           *index++=(unsigned char) p->index;           x++;"           if (x == image->columns)
             { I               count+=PackbitsEncodeImage(image,scanline,packed_scanline);                index=scanline;                x=0;
             } 	         }          p++;       }      }    else     {        register unsigned char         *blue,
         *red,          *green;          red=scanline; $       green=scanline+image->columns;*       blue=scanline+(image->columns << 1);(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { #           *red++=DownScale(p->red); '           *green++=DownScale(p->green); %           *blue++=DownScale(p->blue);            x++;"           if (x == image->columns)
             {                red=scanline; ,               green=scanline+image->columns;2               blue=scanline+(image->columns << 1);D               count+=PackbitsEncodeImage(image,red,packed_scanline);               x=0;
             } 	         }          p++;       }      }    if (count & 0x1)#     (void) fputc('\0',image->file); 5   MSBFirstWriteShort(PictEndOfPictureOp,image->file);    free((char *) scanline);!   free((char *) packed_scanline);    free((char *) buffer);   CloseImage(image);   return(True);  }   
 #ifdef HasPNG  #include "png.h" /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P N G I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WritePNGImage writes an image in the Portable Network Graphics %  encoded image format. % . %  The format of the WritePNGImage routine is: % - %      status=WritePNGImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePNGImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePNGImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    int      length;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;   
   png_info     *ping_info;      png_struct
     *ping;     unsigned char      *png_pixels,     **scanlines;     unsigned int     bytes_per_line,      x,     y;     unsigned short
     value;     /*     Open image file.   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate the PNG structures    */1   ping=(png_struct *) malloc(sizeof(png_struct)); 2   ping_info=(png_info *) malloc(sizeof(png_info));H   if ((ping == (png_struct *) NULL) || (ping_info == (png_info *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Prepare PNG for writing.   */   png_info_init(ping_info);    png_write_init(ping);     png_init_io(ping,image->file);"   ping_info->width=image->columns;    ping_info->height=image->rows;   ping_info->bit_depth=8; <   if ((image->class == DirectClass) && (image->depth == 16))     ping_info->bit_depth=16;+   ping_info->color_type=PNG_COLOR_TYPE_RGB;    if (image->matte) 3     ping_info->color_type=PNG_COLOR_TYPE_RGB_ALPHA; $   ping_info->bit_depth=image->depth;   ping_info->num_palette=0;    if (IsGrayImage(image)) .     ping_info->color_type=PNG_COLOR_TYPE_GRAY;   else@     if ((image->class == PseudoClass) && (image->colors <= 256))       { 
         /*           Set image palette.
         */5         ping_info->color_type=PNG_COLOR_TYPE_PALETTE; -         ping_info->num_palette=image->colors; (         ping_info->valid|=PNG_INFO_PLTE;(         ping_info->palette=(png_color *)3           malloc(image->columns*sizeof(png_color)); 5         if (ping_info->palette == (png_color *) NULL) ;           PrematureExit("Unable to allocate memory",image); )         for (i=0; i < image->colors; i++) 	         { F           ping_info->palette[i].red=DownScale(image->colormap[i].red);J           ping_info->palette[i].green=DownScale(image->colormap[i].green);H           ping_info->palette[i].blue=DownScale(image->colormap[i].blue);	         }          ping_info->bit_depth=1; ;         while ((1 << ping_info->bit_depth) < image->colors) #           ping_info->bit_depth<<=1;        } C   ping_info->interlace_type=image_info->interlace != NoneInterlace; !   png_write_info(ping,ping_info);    png_set_packing(ping);   /*     Allocate memory.   */   bytes_per_line= I     Max((int) ping_info->bit_depth >> 3,1)*ping->channels*image->columns;    png_pixels=(unsigned char *)=     malloc(bytes_per_line*image->rows*sizeof(unsigned char)); K   scanlines=(unsigned char **) malloc(image->rows*sizeof(unsigned char *)); /   if ((png_pixels == (unsigned char *) NULL) || -       (scanlines == (unsigned char **) NULL)) 5     PrematureExit("Unable to allocate memory",image);    /*     Initialize image scanlines.    */!   for (i=0; i < image->rows; i++) /     scanlines[i]=png_pixels+(bytes_per_line*i);    x=0;   y=0;   p=image->pixels;   q=scanlines[y];    if (IsGrayImage(image)) &     for (i=0; i < image->packets; i++)     { ,       for (j=0; j <= ((int) p->length); j++)       { &         WriteQuantum(Intensity(*p),q);         x++;          if (x == image->columns)           {              x=0;             y++;             q=scanlines[y];            }        } 
       p++;     }    else?     if ((image->class == DirectClass) || (image->colors > 256)) (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         { !           WriteQuantum(p->red,q); #           WriteQuantum(p->green,q); "           WriteQuantum(p->blue,q);           if (image->matte) %             WriteQuantum(p->index,q);            x++;"           if (x == image->columns)
             {                x=0;               y++;               q=scanlines[y]; 
             } 	         }          p++;       }      else(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {%           *q++=p->index;           x++;"           if (x == image->columns)
             {                x=0;               y++;               q=scanlines[y]; 
             } 	         }          p++;       }    /*     Write image scanlines.   */"   png_write_image(ping,scanlines);'   if (image->comments != (char *) NULL)      {E       /*         Write image comment.       */%       length=strlen(image->comments); !       if (length < MaxTextLength) E         (void) png_write_tEXt(ping,"Comment",image->comments,length); 
       elseG         (void) png_write_zTXt(ping,"Comment",image->comments,length,0);      }     png_write_end(ping,ping_info);   /*     Free memory.   */   png_write_destroy(ping);   if (ping->palette)     free(ping->palette);
   free(ping);    free(ping_info);   CloseImage(image);   return(True);  }  #else 3 static unsigned int WritePNGImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   :   Warning("PNG library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %1O %                                                                             % O %                                                                             % O %   W r i t e P N M I m a g e                                                 %uO %                                                                             % O %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t % J %  Procedure WritePNMImage writes an image to a file in the PNM rasterfile
 %  format. %i. %  The format of the WritePNMImage routine is: %t- %      status=WritePNMImage(image_info,image)u % + %  A description of each parameter follows.n %rJ %    o status: Function WritePNMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image fileN %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.n %u. %    o image:  A pointer to a Image structure. %p %s */3 static unsigned int WritePNMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {  #define MaxRawValue  255     register int     i,     j;     register RunlengthPacket     *p;a     unsigned chars     format;u     /*     Open output image file.n   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)N/     PrematureExit("Unable to open file",image);p   /*-     Promote/Demote image based on image type.    */'   if (strcmp(image->magick,"PPM") == 0)s     image->class=DirectClass;h   else)     if (strcmp(image->magick,"PGM") == 0)r.       RGBTransformImage(image,GRAYColorspace);     else+       if (strcmp(image->magick,"PBM") == 0)s	         { E           QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);            SyncImage(image);%	         }%   /*     Write PNM file header.   */   if (!IsPseudoClass(image))     {h       /*         Full color PNM image.a       */       format='6';m       if (MaxRGB > MaxRawValue)          format='3';s     }    else     {k       /*         Colormapped PNM image.       */       format='6';        if (MaxRGB > MaxRawValue).         format='3';dC       if (IsGrayImage(image) && (strcmp(image->magick,"PPM") != 0))n	         {,           /*              Grayscale PNM image.           */           format='5';t#           if (MaxRGB > MaxRawValue)_             format='2';e/           if (strcmp(image->magick,"PGM") != 0)%#             if (image->colors == 2)%               format='4'; 	         }      } -   (void) fprintf(image->file,"P%c\n",format); '   if (image->comments != (char *) NULL)      {        register char          *p;          /*         Write comments to file.        */'       (void) fprintf(image->file,"# "); .       for (p=image->comments; *p != '\0'; p++)       { %         (void) fputc(*p,image->file);          if (*p == '\n') +           (void) fprintf(image->file,"# ");        } %       (void) fputc('\n',image->file);      } C   (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);    /*&     Convert MIFF to PNM raster pixels.   */   p=image->pixels;   switch (format)    {n
     case '2':m     {t       register int
         x;         /*%         Convert image to a PGM image.e       */0       (void) fprintf(image->file,"%d\n",MaxRGB);
       x=0;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {i4           (void) fprintf(image->file,"%5d ",p->red);           x++;           if (x == 12)
             {t/               (void) fprintf(image->file,"\n");                x=0;
             }o	         }p         p++;       }t       break;     }t
     case '3':      {S       register int
         x;         /*%         Convert image to a PNM image.y       */0       (void) fprintf(image->file,"%d\n",MaxRGB);
       x=0;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {tM           (void) fprintf(image->file,"%5d %5d %5d ",p->red,p->green,p->blue);;           x++;           if (x == 4) 
             {i/               (void) fprintf(image->file,"\n");a               x=0;
             }v	         }d         p++;       }v       break;     }-
     case '4':)     {(       register unsigned char         bit,
         byte,=         polarity;o         unsigned int
         x;         /*%         Convert image to a PBM image.        */       polarity=0;>       if (image->colors == 2)-O         polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);D       bit=0;
       byte=0;e
       x=0;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1;%#           if (p->index == polarity)%             byte|=0x01;%           bit++;           if (bit == 8) 
             { -               (void) fputc(byte,image->file);                bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) :                 (void) fputc(byte << (8-bit),image->file);               bit=0;               byte=0;                x=0;            }	         }          p++;       }        break;     } 
     case '5':      {        /*%         Convert image to a PGM image.%       */;       (void) fprintf(image->file,"%d\n",DownScale(MaxRGB));r(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)6           (void) fputc(DownScale(p->red),image->file);         p++;       }        break;     }h
     case '6':o     {        /*%         Convert image to a PNM image.u       */;       (void) fprintf(image->file,"%d\n",DownScale(MaxRGB));r(       for (i=0; i < image->packets; i++)       {r.         for (j=0; j <= ((int) p->length); j++)	         {e6           (void) fputc(DownScale(p->red),image->file);8           (void) fputc(DownScale(p->green),image->file);7           (void) fputc(DownScale(p->blue),image->file); 	         }          p++;       }_       break;     }    }n   CloseImage(image);   return(True);n }s t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             % O %                                                                             %MO %   W r i t e P S I m a g e                                                   % O %                                                                             %iO %                                                                             %eO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WritePSImage translates an image to encapsulated Postscript0H %  Level I for printing.  If the supplied geometry is null, the image isJ %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.e %o- %  The format of the WritePSImage routine is:  % , %      status=WritePSImage(image_info,image) %d+ %  A description of each parameter follows:) % I %    o status: Function WritePSImage return True if the image is printed.fI %      False is returned if the image file cannot be opened for printing.1 % A %    o image_info: Specifies a pointer to an ImageInfo structure.d %bF %    o image: The address of a structure of type Image;  returned from %      ReadImage.r %z %0 */2 static unsigned int WritePSImage(image_info,image)	 ImageInfor   *image_info;   Image=	   *image;e {r
   static char      *Postscript[]=     {>       "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on",rG       "% Postscript viewers or printers that support color, otherwise",e(       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",        "/byte 1 string def",p#       "/color_packet 3 string def",c       "/pixels 768 string def",g	       "",o       "/DirectClassPacket",_
       "{",       "  %",&       "  % Get a DirectClass packet.",       "  %",       "  % Parameters:",       "  %   red.",g       "  %   green.",m       "  %   blue.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",9       "  currentfile color_packet readhexstring pop pop",g       "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",l       "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",m0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse",l"       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",)       "  } for",-       "  pixels 0 number_pixels getinterval",a       "} bind def",y	       "",        "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",'       "  systemdict /colorimage known",        "  {",       "    columns rows 8",)       "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",5       "    { DirectClassPacket } false 3 colorimage",        "  }",       "  {",       "    %",=       "    % No colorimage operator;  convert to grayscale.",;       "    %",       "    columns rows 8",;       "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",,       "    { GrayDirectClassPacket } image",       "  } ifelse",        "} bind def",-	       "",n       "/GrayDirectClassPacket", 
       "{",       "  %",=       "  % Get a DirectClass packet;  convert to grayscale.",o       "  %",       "  % Parameters:",       "  %   red",       "  %   green",       "  %   blue",mK       "  %   length: number of pixels minus one of this color (optional).",        "  %",9       "  currentfile color_packet readhexstring pop pop",a'       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add",m+       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",g*       "    /number_pixels exch 1 add def",       "  } ifelse",h"       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",f       "} bind def",)	       "",        "/GrayPseudoClassPacket", 
       "{",       "  %",=       "  % Get a PseudoClass packet;  convert to grayscale.",        "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",n       "  %",3       "  currentfile byte readhexstring pop 0 get",g!       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",'       "  color_packet 0 get 0.299 mul",)+       "  color_packet 1 get 0.587 mul add", +       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",I*       "    /number_pixels exch 1 add def",       "  } ifelse",r"       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval","       "} bind def", 	       "",t       "/PseudoClassPacket",a
       "{",       "  %",&       "  % Get a PseudoClass packet.",       "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",-       "  %",3       "  currentfile byte readhexstring pop 0 get",F!       "  /offset exch 3 mul def",g:       "  /color_packet colormap offset 3 getinterval def",       "  compression 0 gt",p       "  {",!       "    /number_pixels 3 def",L       "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",,0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse", "       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",i       "  } for",-       "  pixels 0 number_pixels getinterval",g       "} bind def",g	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",r       "  %",       "  % Parameters:",3       "  %   class: 0-PseudoClass or 1-Grayscale.",e       "  %",*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",       "  class 0 gt",a       "  {",&       "    /grays columns string def",       "    columns rows 8",;       "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",:       "    { currentfile grays readhexstring pop } image",       "  }",       "  {",       "    %",       "    % Parameters:",:       "    %   colors: number of colors in the colormap.",:       "    %   colormap: red, green, blue color packets.",       "    %",,       "    currentfile buffer readline pop",+       "    token pop /colors exch def pop",s%       "    /colors colors 3 mul def", (       "    /colormap colors string def",7       "    currentfile colormap readhexstring pop pop", )       "    systemdict /colorimage known",        "    {",       "      columns rows 8",        "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",7       "      { PseudoClassPacket } false 3 colorimage",        "    }",       "    {",       "      %",?       "      % No colorimage operator;  convert to grayscale.",        "      %",       "      columns rows 8",        "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",.       "      { GrayPseudoClassPacket } image",       "    } ifelse",%       "  } ifelse",%       "} bind def",%	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters:",!       "  %   x & y translation.",s       "  %   x & y scale.",f       "  %   image label.",n$       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.",mM       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.",t!       "  %   hex color packets.",t       "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",@       "  /NewCenturySchlbk-Roman findfont 24 scalefont setfont",*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",e       (char *) NULL      };     char     *label,      **q;     intm     length,e     sans_offset,     x,     y;     register RunlengthPacket     *p;      register int     i,     j;     time_t
     timer;     unsigned int     dx_resolution,     dy_resolution,     height,      text_size,     x_resolution,t     y_resolution, 
     width;     /*     Open output image file.    */   OpenImage(image,"w"); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*+     Scale image to size of Postscript page.b   */3   text_size=image->label == (char *) NULL ? 0 : 36;D   x=0;   y=0;   width=image->columns;l   height=image->rows;f&   if (strcmp(image->magick,"PS") == 0)     {>	       int          delta_x,         delta_y,         flags;         unsigned int         page_height,         page_width;o         /*(         Center image on Postscript page.       */K       (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);        flags=0;,       if (image_info->page != (char *) NULL)N         flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);,       if (((page_width-(x << 1)) < width) ||6           ((page_height-(y << 1)-text_size) < height))	         {n           unsigned long              scale_factor;              /*4             Scale image relative to Postscript page.           */:           scale_factor=UpShift(page_width-(x << 1))/width;N           if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))H             scale_factor=UpShift(page_height-(y << 1)-text_size)/height;.           width=DownShift(width*scale_factor);0           height=DownShift(height*scale_factor);	         }         if ((flags & XValue) == 0)	         {            /*,             Center image in the X direction.           */.           delta_x=page_width-(width+(x << 1));           if (delta_x >= 0)              x=(delta_x >> 1)+x;;	         }         if ((flags & YValue) == 0)	         {w           /*,             Center image in the X direction.           */:           delta_y=page_height-(height+(y << 1))-text_size;           if (delta_y >= 0)              y=(delta_y >> 1)+y; 	         }      }    /*$     Scale relative to dots-per-inch.   */D   (void) XParseGeometry(PSDensityGeometry,&sans_offset,&sans_offset,#     &dx_resolution,&dy_resolution);    x_resolution=dx_resolution;(   y_resolution=dy_resolution;l+   if (image_info->density != (char *) NULL)eH     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,#       &x_resolution,&y_resolution);)+   width=(width*dx_resolution)/x_resolution;)-   height=(height*dy_resolution)/y_resolution;    /*     Output Postscript header.    */&   if (strcmp(image->magick,"PS") == 0)4     (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");   else=     (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n"); @   (void) fprintf(image->file,"%%%%Title: %s\n",image->filename);;   (void) fprintf(image->file,"%%%%Creator: ImageMagick\n");    timer=time((time_t *) NULL);   (void) localtime(&timer);nC   (void) fprintf(image->file,"%%%%CreationDate: %s",ctime(&timer)); P   (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",x,y,x+(int) width,     y+(int) height+text_size);&   if (strcmp(image->magick,"PS") == 0)     { @       (void) fprintf(image->file,"%%%%Orientation: Portrait\n");<       (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");     } P   (void) fprintf(image->file,"%%%%Pages: %d\n",strcmp(image->magick,"PS") == 0);2   (void) fprintf(image->file,"%%%%EndComments\n");(   if (strcmp(image->magick,"EPSI") == 0)     {        Imageg         *preview_image;0         register unsigned char         bit,
         byte,(         polarity;+         unsigned int         count;         /*-         Initialize bordered image attributes.l       */       image->orphan=True;yE       preview_image=CopyImage(image,image->columns,image->rows,True);        image->orphan=False;*       if (preview_image == (Image *) NULL)9         PrematureExit("Unable to allocate memory",image);        /*&         Convert MIFF to bitmap pixels.       */I       QuantizeImage(preview_image,2,8,image_info->dither,GRAYColorspace);t       polarity=0;        if (image->colors == 2)RO         polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);e       bit=0;
       byte=0;        count=0;
       x=0;       p=preview_image->pixels;G       (void) fprintf(image->file,"%%%%BeginPreview: %u %u %u %u\n%%  ",vD         preview_image->columns,preview_image->rows,(unsigned int) 1,G         (((preview_image->columns+7) >> 3)*preview_image->rows+35)/36);m0       for (i=0; i < preview_image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte<<=1;a#           if (p->index == polarity)G             byte|=0x01;c           bit++;           if (bit == 8) 
             {=               /*6                 Write a bitmap byte to the image file.               */=               (void) fprintf(image->file,"%02x",byte & 0xff);                count++;               if (count == 36)                 {e7                   (void) fprintf(image->file,"\n%%  ");%                   count=0;                 };               bit=0;               byte=0; 
             }            x++;*           if (x == preview_image->columns)
             {                if (bit != 0)                  {                    /*:                     Write a bitmap byte to the image file.                   */!                   byte<<=(8-bit); A                   (void) fprintf(image->file,"%02x",byte & 0xff);                    count++;"                   if (count == 36)                     { ;                       (void) fprintf(image->file,"\n%%  ");                        count=0;                     };                   bit=0;                   byte=0;                  };               x=0;
             }i           }s           p++;	         }f9         (void) fprintf(image->file,"\n%%%%EndPreview\n"); $         DestroyImage(preview_image);       }e   /*     Output Postscript commands.t   */   for (q=Postscript; *q; q++)t*     (void) fprintf(image->file,"%s\n",*q);&   if (strcmp(image->magick,"PS") == 0)/     (void) fprintf(image->file,"  showpage\n"); -   (void) fprintf(image->file,"} bind def\n");S0   (void) fprintf(image->file,"%%%%EndProlog\n");1   (void) fprintf(image->file,"%%%%Page:  1 1\n"); &   if (strcmp(image->magick,"PS") != 0)3     (void) fprintf(image->file,"userdict begin\n"); 1   (void) fprintf(image->file,"%%%%BeginData:\n"); /   (void) fprintf(image->file,"DisplayImage\n");p   /*     Output image data.   */8   if (image->compression == RunlengthEncodedCompression)     CompressImage(image);o   label=image->label;e   if (label == (char *) NULL),     label=" ";   p=image->pixels;   switch (image->class)    {t     case DirectClass:(     { P       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression); !       switch (image->compression)        { )         case RunlengthEncodedCompression:          default:	         {            /*7             Dump runlength-encoded DirectColor packets.            */           x=0;,           for (i=0; i < image->packets; i++)           { <             for (length=p->length; length >= 0; length-=256)
             {                x++;<               if (image->matte && (p->index == Transparent))J                 (void) fprintf(image->file,"ffffff%02x",Min(length,0xff));               elseP                 (void) fprintf(image->file,"%02x%02x%02x%02x",DownScale(p->red),K                   DownScale(p->green),DownScale(p->blue),Min(length,0xff));.               if (x == 9)f                 {                    x=0;3                   (void) fprintf(image->file,"\n");s                 }r
             }              p++;           }r           break;	         }h         case NoCompression:F	         {u           /*2             Dump uncompressed DirectColor packets.           */           x=0;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {c               x++;<               if (image->matte && (p->index == Transparent))5                 (void) fprintf(image->file,"ffffff");_               elseL                 (void) fprintf(image->file,"%02x%02x%02x",DownScale(p->red),:                   DownScale(p->green),DownScale(p->blue));               if (x == 12)                 {r                   x=0;3                   (void) fprintf(image->file,"\n");                  } 
             }s             p++;           }i           break;	         }        }t       break;     }l     case PseudoClass:      {        unsigned int         grayscale;  P       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression);)L       grayscale=IsGrayImage(image) && (image->compression == NoCompression);3       (void) fprintf(image->file,"%d\n",grayscale);s       if (!grayscale)b	         {n           /*/             Dump number of colors and colormap.i           */;           (void) fprintf(image->file,"%u\n",image->colors); +           for (i=0; i < image->colors; i++)%8             (void) fprintf(image->file,"%02x%02x%02x\n",0               DownScale(image->colormap[i].red),2               DownScale(image->colormap[i].green),2               DownScale(image->colormap[i].blue));	         }"!       switch (image->compression)0       {t)         case RunlengthEncodedCompression:t         default:	         {            /*7             Dump runlength-encoded PseudoColor packets.            */           x=0;,           for (i=0; i < image->packets; i++)           { <             for (length=p->length; length >= 0; length-=256)
             {n               x++;O               (void) fprintf(image->file,"%02x%02x",p->index,Min(length,0xff));%               if (x == 18)                 {%                   x=0;3                   (void) fprintf(image->file,"\n");                  } 
             }              p++;           }            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed PseudoColor packets.           */           x=0;           if (grayscale).             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               {                  x++;:                 (void) fprintf(image->file,"%02x",p->red);                 if (x == 36)                   {%                     x=0;5                     (void) fprintf(image->file,"\n");n                   }r               }a               p++;
             }            else.             for (i=0; i < image->packets; i++)
             {s4               for (j=0; j <= ((int) p->length); j++)               {r                 x++;<                 (void) fprintf(image->file,"%02x",p->index);                 if (x == 36)                   {a                     x=0;5                     (void) fprintf(image->file,"\n");i                   }t               }o               p++;
             }p           break;	         }        }/     }c   }g#   (void) fprintf(image->file,"\n");e.   (void) fprintf(image->file,"%%%%EndData\n");&   if (strcmp(image->magick,"PS") != 0)(     (void) fprintf(image->file,"end\n");2   (void) fprintf(image->file,"%%%%PageTrailer\n");.   (void) fprintf(image->file,"%%%%Trailer\n");*   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);; }  ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             % O %                                                                             %mO %                                                                             %mO %   W r i t e P S 2 I m a g e                                                 % O %                                                                             %(O %                                                                             %uO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %lH %  Function WritePS2Image translates an image to encapsulated PostscriptI %  Level II for printing.  If the supplied geometry is null, the image isoJ %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.  % . %  The format of the WritePS2Image routine is: % - %      status=WritePS2Image(image_info,image)  % + %  A description of each parameter follows:s % J %    o status: Function WritePS2Image return True if the image is printed.I %      False is returned if the image file cannot be opened for printing.e %rA %    o image_info: Specifies a pointer to an ImageInfo structure.i %eF %    o image: The address of a structure of type Image;  returned from %      ReadImage.f %t %p */3 static unsigned int WritePS2Image(image_info,image)7	 ImageInfoe   *image_info;   Image 	   *image;t {G
   static chare     *Postscript[]=     {o       "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on",rG       "% Postscript viewers or printers that support color, otherwise",;(       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",c	       "",>       "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",#       "  /DeviceRGB setcolorspace",+
       "  <<",v       "    /ImageType 1",>       "    /Interpolate true",       "    /Width columns",a       "    /Height rows",e        "    /BitsPerComponent 8","       "    /Decode [0 1 0 1 0 1]",7       "    /ImageMatrix [columns 0 0 rows neg 0 rows]",)       "    compression 0 gt",t       "    {",<       "      /DataSource currentfile /ASCII85Decode filter",       "    }",       "    {",N       "      /DataSource currentfile /ASCII85Decode filter /LZWDecode filter",       "    } ifelse",        "  >> image",c       "} bind def",o	       "",e       "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",)       "  %",       "  % Parameters:",8       "  %   colors: number of colors in the colormap.",       "  %",*       "  currentfile buffer readline pop",)       "  token pop /colors exch def pop",i       "  colors 0 eq",       "  {",       "    %","       "    % Image is grayscale.",       "    %",&       "    /DeviceGray setcolorspace",       "    <<",L       "      /ImageType 1",i        "      /Interpolate true",       "      /Width columns",        "      /Height rows", "       "      /BitsPerComponent 1",       "      /Decode [0 1]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",f       "      compression 0 gt",        "      {",>       "        /DataSource currentfile /ASCII85Decode filter",       "      }",       "      {",P       "        /DataSource currentfile /ASCII85Decode filter /LZWDecode filter",       "      } ifelse",i       "    >> image",l       "  }",       "  {",       "    %",       "    % Parameters:",:       "    %   colormap: red, green, blue color packets.",       "    %",.       "    /colormap colors 3 mul string def",7       "    currentfile colormap readhexstring pop pop",,H       "    [ /Indexed /DeviceRGB colors 1 sub colormap ] setcolorspace",       "    <<",e       "      /ImageType 1",u        "      /Interpolate true",       "      /Width columns",        "      /Height rows",e"       "      /BitsPerComponent 8",       "      /Decode [0 255]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",        "      compression 0 gt",t       "      {",>       "        /DataSource currentfile /ASCII85Decode filter",       "      }",       "      {",P       "        /DataSource currentfile /ASCII85Decode filter /LZWDecode filter",       "      } ifelse",>       "    >> image",+       "  } ifelse",        "} bind def",a	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters:",!       "  %   x & y translation.",i       "  %   x & y scale.",S       "  %   image label.",l$       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.", M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.",c!       "  %   hex color packets.",i       "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",@       "  /NewCenturySchlbk-Roman findfont 24 scalefont setfont",*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop",e*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",s       "  showpage",        "} bind def",a       "%%EndProlog",       "%%Page:  1 1", 
       NULL     };     char     *label,o     **q;     int      delta_x,     delta_y,
     flags,     sans_offset,     x,     y;     register RunlengthPacket     *p;      register int     i,     j;     time_t
     timer;     unsigned charl     *pixels;     unsigned int     dx_resolution,     dy_resolution,     height,_     number_packets,      page_height,     page_width,U     text_size,     x_resolution,_     y_resolution, 
     width;     /*     Open output image file.o   */   OpenImage(image,"w");v#   if (image->file == (FILE *) NULL))/     PrematureExit("Unable to open file",image);s   /*+     Scale image to size of Postscript page.%   */3   text_size=image->label == (char *) NULL ? 0 : 36;%   x=0;   y=0;   width=image->columns;    height=image->rows;    /*$     Center image on Postscript page.   */G   (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height); 
   flags=0;(   if (image_info->page != (char *) NULL)J     flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);(   if (((page_width-(x << 1)) < width) ||2       ((page_height-(y << 1)-text_size) < height))     {        unsigned long          scale_factor;          /*0         Scale image relative to Postscript page.       */6       scale_factor=UpShift(page_width-(x << 1))/width;J       if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))D         scale_factor=UpShift(page_height-(y << 1)-text_size)/height;*       width=DownShift(width*scale_factor);,       height=DownShift(height*scale_factor);     }    if ((flags & XValue) == 0)     {g       /*(         Center image in the X direction.       */*       delta_x=page_width-(width+(x << 1));       if (delta_x >= 0)n         x=(delta_x >> 1)+x;i     }    if ((flags & YValue) == 0)     {f       /*(         Center image in the X direction.       */6       delta_y=page_height-(height+(y << 1))-text_size;       if (delta_y >= 0)t         y=(delta_y >> 1)+y;u     }    /*$     Scale relative to dots-per-inch.   */D   (void) XParseGeometry(PSDensityGeometry,&sans_offset,&sans_offset,#     &dx_resolution,&dy_resolution);    x_resolution=dx_resolution;m   y_resolution=dy_resolution;m+   if (image_info->density != (char *) NULL)LH     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,#       &x_resolution,&y_resolution); +   width=(width*dx_resolution)/x_resolution;g-   height=(height*dy_resolution)/y_resolution;t   /*     Output Postscript header.c   */&   if (strcmp(image->magick,"PS") == 0)4     (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");   else=     (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n");%@   (void) fprintf(image->file,"%%%%Title: %s\n",image->filename);;   (void) fprintf(image->file,"%%%%Creator: ImageMagick\n");    timer=time((time_t *) NULL);   (void) localtime(&timer); C   (void) fprintf(image->file,"%%%%CreationDate: %s",ctime(&timer)); P   (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",x,y,x+(int) width,     y+(int) height+text_size);&   if (strcmp(image->magick,"PS") == 0)     { @       (void) fprintf(image->file,"%%%%Orientation: Portrait\n");<       (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");     } P   (void) fprintf(image->file,"%%%%Pages: %d\n",strcmp(image->magick,"PS") == 0);2   (void) fprintf(image->file,"%%%%EndComments\n");   /*     Output Postscript commands.e   */   for (q=Postscript; *q; q++).*     (void) fprintf(image->file,"%s\n",*q);&   if (strcmp(image->magick,"PS") != 0)3     (void) fprintf(image->file,"userdict begin\n");r1   (void) fprintf(image->file,"%%%%BeginData:\n");H/   (void) fprintf(image->file,"DisplayImage\n");    /*     Output image data.   */   label=image->label;e   if (label == (char *) NULL)r     label=" ";P   (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",x,y,N     width,height,label,image->columns,image->rows,image->class == PseudoClass,)     image->compression == NoCompression);    p=image->pixels;   if (!IsPseudoClass(image))     switch (image->compression)      {e'       case RunlengthEncodedCompression:R       default:       {          register unsigned char
           *q;6  
         /*           Allocate pixel array.p
         */4         number_packets=3*image->columns*image->rows;N         pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));-         if (pixels == (unsigned char *) NULL)m;           PrematureExit("Unable to allocate memory",image);e
         /*"           Dump LZW encoded pixels.
         */         q=pixels;t*         for (i=0; i < image->packets; i++)	         {c.           for (j=0; j <= (int) p->length; j++)           { :             if (image->matte && (p->index == Transparent))               {l'                 *q++=DownScale(MaxRGB);;'                 *q++=DownScale(MaxRGB); '                 *q++=DownScale(MaxRGB);t               }              else               { '                 *q++=DownScale(p->red); )                 *q++=DownScale(p->green);a(                 *q++=DownScale(p->blue);               }            }R           p++;	         } B         (void) LZWEncodeFilter(image->file,pixels,number_packets);         free((char *) pixels);         break;       }        case NoCompression:p       { 
         /*0           Dump uncompressed DirectColor packets.
         */         Ascii85Initialize();*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {t:             if (image->matte && (p->index == Transparent))               {g=                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file);                }+             else               {o=                 Ascii85Encode(DownScale(p->red),image->file); ?                 Ascii85Encode(DownScale(p->green),image->file); >                 Ascii85Encode(DownScale(p->blue),image->file);               }l           }            p++;	         } "         Ascii85Flush(image->file);         break;       }      }    else3     if (IsGrayImage(image) && (image->colors == 2))x       {m         register unsigned char           bit,           byte,p           polarity;   O         polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);a         bit=0;         byte=0;          x=0;*         (void) fprintf(image->file,"0\n");#         switch (image->compression) 	         {m+           case RunlengthEncodedCompression:            default:           { "             register unsigned char               *q;                /*#               Allocate pixel array.              */A             number_packets=((image->columns+7) >> 3)*image->rows;i$             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char)); 1             if (pixels == (unsigned char *) NULL)g?               PrematureExit("Unable to allocate memory",image);              /*&               Dump LZW encoded pixels.             */             q=pixels; .             for (i=0; i < image->packets; i++)
             {n2               for (j=0; j <= (int) p->length; j++)               {p                 byte<<=1; )                 if (p->index == polarity)t                   byte|=0x01;                  bit++;                 if (bit == 8)e                   {                      *q++=byte;                     bit=0;                     byte=0;)                   }                  x++;(                 if (x == image->columns)                   {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0)*+                       *q++=byte << (8-bit);                      bit=0;                     byte=0;                      x=0;                     y++;                  }               }o               p++;
             } F             (void) LZWEncodeFilter(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }w           case NoCompression:;           {              /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();.             for (i=0; i < image->packets; i++)
             {j2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)l                   byte|=0x01;-                 bit++;                 if (bit == 8)o                   {;4                     Ascii85Encode(byte,image->file);                     bit=0;                     byte=0;f                   }e                 x++;(                 if (x == image->columns)                   {c                     /*3                       Advance to the next scanline.o                     */!                     if (bit != 0) A                       Ascii85Encode(byte << (8-bit),image->file);                      bit=0;                     byte=0;n                     x=0;                     y++;                  }               }                p++;
             }a&             Ascii85Flush(image->file);             break;           }%	         }%       }%     else       {%
         /*-           Dump number of colors and colormap. 
         */9         (void) fprintf(image->file,"%u\n",image->colors); )         for (i=0; i < image->colors; i++) 6           (void) fprintf(image->file,"%02x%02x%02x\n",.             DownScale(image->colormap[i].red),0             DownScale(image->colormap[i].green),0             DownScale(image->colormap[i].blue));#         switch (image->compression) 	         { +           case RunlengthEncodedCompression:            default:           { "             register unsigned char               *q;                /*#               Allocate pixel array.%             */6             number_packets=image->columns*image->rows;$             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char));o1             if (pixels == (unsigned char *) NULL)n?               PrematureExit("Unable to allocate memory",image);l             /*&               Dump LZW encoded pixels.             */             q=pixels;c.             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++).                 *q++=(unsigned char) p->index;               p++;
             }cF             (void) LZWEncodeFilter(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }(           case NoCompression:s           {a             /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();.             for (i=0; i < image->packets; i++)
             {l4               for (j=0; j <= ((int) p->length); j++)D                 Ascii85Encode((unsigned char) p->index,image->file);               p++;
             } &             Ascii85Flush(image->file);             break;           } 	         }i       }m#   (void) fprintf(image->file,"\n");a.   (void) fprintf(image->file,"%%%%EndData\n");&   if (strcmp(image->magick,"PS") != 0)(     (void) fprintf(image->file,"end\n");2   (void) fprintf(image->file,"%%%%PageTrailer\n");.   (void) fprintf(image->file,"%%%%Trailer\n");*   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);n }n i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %dO %                                                                             %eO %                                                                             %gO %   W r i t e R A D I A N C E I m a g e                                       %-O %                                                                             %lO %                                                                             % O %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % L %  Function WriteRADIANCEImage writes an image in the RADIANCE encoded image
 %  format. %(3 %  The format of the WriteRADIANCEImage routine is:L % 2 %      status=WriteRADIANCEImage(image_info,image) %r+ %  A description of each parameter follows.) % O %    o status: Function WriteRADIANCEImage return True if the image is written.gK %      False is returned is there is a memory shortage or if the image file= %      fails to write. %;A %    o image_info: Specifies a pointer to an ImageInfo structure.r %]. %    o image:  A pointer to a Image structure. %p %e */8 static unsigned int WriteRADIANCEImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;_ {g   unsigned int     status;f  :   Warning("Cannot write RADIANCE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);i }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             % O %                                                                             %*O %                                                                             %0O %   W r i t e R G B I m a g e                                                 % O %                                                                             %hO %                                                                             %oO %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %jF %  Function WriteRGBImage writes an image to a file in red, green, and %  blue rasterfile format. %i. %  The format of the WriteRGBImage routine is: %a- %      status=WriteRGBImage(image_info,image)x %++ %  A description of each parameter follows.e %MJ %    o status: Function WriteRGBImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filep %      fails to write. %oA %    o image_info: Specifies a pointer to an ImageInfo structure.e %c. %    o image:  A pointer to a Image structure. %c %  */3 static unsigned int WriteRGBImage(image_info,image)l	 ImageInfo    *image_info;   ImageN	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;i     /*     Open output image file./   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)o/     PrematureExit("Unable to open file",image);    /*&     Convert MIFF to RGB raster pixels.   */,   if (strcmp(image_info->magick,"RGB") == 0)     image->matte=False;     switch (image_info->interlace)   {s     case NoneInterlace:i     default:     {o       /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {%.         for (j=0; j <= ((int) p->length); j++)	         { 6           (void) fputc(DownScale(p->red),image->file);8           (void) fputc(DownScale(p->green),image->file);7           (void) fputc(DownScale(p->blue),image->file);            if (image->matte) /             (void) fputc(p->index,image->file); 	         }          p++;       }        break;     }      case LineInterlace:      {        register int
         x,
         y;         /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...        */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)        {%+         p=image->pixels+(y*image->columns);%*         for (x=0; x < image->columns; x++)	         {e6           (void) fputc(DownScale(p->red),image->file);           p++;	         }B+         p=image->pixels+(y*image->columns);J*         for (x=0; x < image->columns; x++)	         {h8           (void) fputc(DownScale(p->green),image->file);           p++;	         }m+         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         { 7           (void) fputc(DownScale(p->blue),image->file);t           p++;	         }e+         p=image->pixels+(y*image->columns);t         if (image->matte)d,           for (x=0; x < image->columns; x++)           { /             (void) fputc(p->index,image->file);v             p++;           }E       };       break;     }t     case PlaneInterlace:     {i       /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {h.         for (j=0; j <= ((int) p->length); j++)6           (void) fputc(DownScale(p->red),image->file);         p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       {e.         for (j=0; j <= ((int) p->length); j++)8           (void) fputc(DownScale(p->green),image->file);         p++;       }f       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)7           (void) fputc(DownScale(p->blue),image->file);n         p++;       }u       p=image->pixels;       if (image->matte)s*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)/             (void) fputc(p->index,image->file);n           p++;	         }n       break;     }p   }    CloseImage(image);   return(True);  }f m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e R L E I m a g e                                                 %=O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %iN %  Function WriteRLEImage writes an image in the Utah Run length encoded image
 %  format. % . %  The format of the WriteRLEImage routine is: %i- %      status=WriteRLEImage(image_info,image)o %i+ %  A description of each parameter follows.s %oJ %    o status: Function WriteRLEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file, %      fails to write. %lA %    o image_info: Specifies a pointer to an ImageInfo structure.b %n. %    o image:  A pointer to a Image structure. %i %n */3 static unsigned int WriteRLEImage(image_info,image)_	 ImageInfo-   *image_info;   ImageG	   *image;  {    char     command[MaxTextLength];_     Imagei     *flipped_image;*     ImageInfol
     rle_info;;     unsigned int     packet_size,     status;n     /*     Flip image.f   */   image->orphan=True;e!   flipped_image=FlipImage(image);    image->orphan=False;&   if (flipped_image == (Image *) NULL)0     PrematureExit("Unable to flip image",image);   rle_info=(*image_info);u#   rle_info.interlace=NoneInterlace;H-   TemporaryFilename(flipped_image->filename);h0   status=WriteRGBImage(&rle_info,flipped_image);
   if (status)%     {%       packet_size=3;       if (image->matte)          packet_size=4;E       (void) sprintf(command,"rawtorle -w %d -h %d -n %d -o %s %s\n", D         image->columns,image->rows,packet_size,image_info->filename,!         flipped_image->filename); $       status=SystemCommand(command);-       (void) unlink(flipped_image->filename); .       if (access(image_info->filename,0) != 0)2         Warning("RLE translation failed",command);     }    DestroyImage(flipped_image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             %lO %                                                                             %tO %   W r i t e S G I I m a g e                                                 %PO %                                                                             %AO %                                                                             %mO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteSGIImage writes an image in SGI RGB encoded image format. %e. %  The format of the WriteSGIImage routine is: % - %      status=WriteSGIImage(image_info,image)  %o+ %  A description of each parameter follows.  %hJ %    o status: Function WriteSGIImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filef %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.t %e. %    o image:  A pointer to a Image structure. %e %i */  * static int SGIEncode(pixels,count,packets)
 unsigned char 
   *pixels;   intc   count;  
 unsigned chara   *packets;) {s   shorte     runlength;     unsigned char      *limit,I
     *mark,     *p,)     *q;f     p=pixels;f   limit=p+count*4;   q=packets;   while (p < limit)e   {      mark=p; 	     p+=8;eA     while ((p < limit) && ((*(p-8) != *(p-4)) || (*(p-4) != *p)))E       p+=4; 	     p-=8;R     count=((p-mark) >> 2);     while (count)e     {c*       runlength=count > 126 ? 126 : count;       count-=runlength;        *q++=0x80 | runlength;)       for ( ; runlength > 0; runlength--)g       {w         *q++=(*mark);          mark+=4;       }m     }i     mark=p;o	     p+=4;m(     while ((p < limit) && (*p == *mark))       p+=4;      count=((p-mark) >> 2);     while (count)p     {.*       runlength=count > 126 ? 126 : count;       count-=runlength;        *q++=runlength;_       *q++=(*mark);      }f   }g	   *q++=0;g   return(q-packets); }.  3 static unsigned int WriteSGIImage(image_info,image)s	 ImageInfog   *image_info;   ImageR	   *image;( {r   typedef struct _SGIHeader    {g     unsigned short       magic;       unsigned chara       storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,t       depth;       unsigned longn       minimum_value,       maximum_value;       unsigned char_       filler[492];   } SGIHeader;     SGIHeaderu     iris_header;     register int     i,     j,     x,     y,     z;     register RunlengthPacket     *p;p     register unsigned char     *q;u     unsigned charg     *iris_pixels, 
     *packets;n     /*     Open output image file.)   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)a/     PrematureExit("Unable to open file",image);    /*&     Initialize SGI raster file header.   */   iris_header.magic=0x01DA;(*   if (image->compression == NoCompression)     iris_header.storage=0x00;    else     iris_header.storage=0x01;=:   iris_header.bytes_per_pixel=1;  /* one byte per pixel */   iris_header.dimension=3;%   iris_header.columns=image->columns;g   iris_header.rows=image->rows;C)   iris_header.depth=image->matte ? 4 : 3;    if (IsGrayImage(image))      {0       iris_header.dimension=2;       iris_header.depth=1;     }L   iris_header.minimum_value=0;#   iris_header.maximum_value=MaxRGB;e0   for (i=0; i < sizeof(iris_header.filler); i++)     iris_header.filler[i]=0;   /*     Write SGI header.    */4   MSBFirstWriteShort(iris_header.magic,image->file);0   (void) fputc(iris_header.storage,image->file);8   (void) fputc(iris_header.bytes_per_pixel,image->file);8   MSBFirstWriteShort(iris_header.dimension,image->file);6   MSBFirstWriteShort(iris_header.columns,image->file);3   MSBFirstWriteShort(iris_header.rows,image->file); 4   MSBFirstWriteShort(iris_header.depth,image->file);;   MSBFirstWriteLong(iris_header.minimum_value,image->file); ;   MSBFirstWriteLong(iris_header.maximum_value,image->file); M   (void) fwrite(iris_header.filler,1,sizeof(iris_header.filler),image->file);    /*     Allocate SGI pixels.   */   iris_pixels=(unsigned char *)l?     malloc(4*image->columns*image->rows*sizeof(unsigned char));+,   if (iris_pixels == (unsigned char *) NULL)5     PrematureExit("Unable to allocate memory",image);S   /*A     Convert runlength-encoded packets to uncompressed SGI pixels.    */   x=0;   y=0;   p=image->pixels;=   q=iris_pixels+(iris_header.rows-1)*(iris_header.columns*4);p$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {        *q++=DownScale(p->red);+       *q++=DownScale(p->green);        *q++=DownScale(p->blue);$       *q++=(unsigned char) p->index;
       x++;       if (x == image->columns)	         {e           y++;I           q=iris_pixels+((iris_header.rows-1)-y)*(iris_header.columns*4);e           x=0;	         }      }      p++;   }e*   if (image->compression == NoCompression)     {        unsigned char          *scanline;         /*&         Write uncompressed SGI pixels.       */        scanline=(unsigned char *):         malloc(iris_header.columns*sizeof(unsigned char));-       if (scanline == (unsigned char *) NULL)i9         PrematureExit("Unable to allocate memory",image);r1       for (z=0; z < (int) iris_header.depth; z++)e       {          q=iris_pixels+z;2         for (y=0; y < (int) iris_header.rows; y++)	         {a7           for (x=0; x < (int) iris_header.columns; x++)_           {              scanline[x]=(*q);              q+=4;%           }%K           (void) fwrite(scanline,sizeof(unsigned char),iris_header.columns,              image->file); 	         }        }        free(scanline);      }    else     {        unsigned long          length,          number_packets,          offset,          *offsets,          *runlength;          /*D         Convert SGI uncompressed pixels to runlength-encoded pixels.       */       offsets=(unsigned long *) I         malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); I       packets=(unsigned char *) malloc(4*((iris_header.columns << 1)+10)* +         image->rows*sizeof(unsigned char)); !       runlength=(unsigned long *)%I         malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));I0       if ((offsets == (unsigned long *) NULL) ||0           (packets == (unsigned char *) NULL) ||0           (runlength == (unsigned long *) NULL))9         PrematureExit("Unable to allocate memory",image); ?       offset=512+4*((iris_header.rows*iris_header.depth) << 1);m       number_packets=0;F       q=iris_pixels;0       for (y=0; y < (int) iris_header.rows; y++)       {s3         for (z=0; z < (int) iris_header.depth; z++)r	         {e           length= L             SGIEncode(q+z,(int) iris_header.columns,packets+number_packets);!           number_packets+=length;)/           offsets[y+z*iris_header.rows]=offset; 1           runlength[y+z*iris_header.rows]=length;n           offset+=length;e	         };#         q+=(iris_header.columns*4);i       }        /*L         Write out line start and length tables and runlength-encoded pixels.       */D       for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)2         MSBFirstWriteLong(offsets[i],image->file);D       for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)4         MSBFirstWriteLong(runlength[i],image->file);N       (void) fwrite(packets,sizeof(unsigned char),number_packets,image->file);       /*         Free memory.       */       free(runlength);       free(packets);       free(offsets);     }    free(iris_pixels);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             %tO %                                                                             % O %                                                                             %rO %   W r i t e S U N I m a g e                                                 %iO %                                                                             %TO %                                                                             %aO %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %tG %  Function WriteSUNImage writes an image in the SUN rasterfile format.m %I. %  The format of the WriteSUNImage routine is: %e- %      status=WriteSUNImage(image_info,image)  % + %  A description of each parameter follows.  %iJ %    o status: Function WriteSUNImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image fileI %      fails to write. %EA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %* %  */3 static unsigned int WriteSUNImage(image_info,image) 	 ImageInfog   *image_info;   Image,	   *image;> {h #define RMT_EQUAL_RGB  1 #define RMT_NONE  0  #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_FORMAT_RGB  3     typedef struct _SUNHeadere   {o     unsigned longc       magic,       width,
       height,        depth,
       length,a       type,t       maptype,       maplength;   } SUNHeader;     register int     i,     j,     x;     register RunlengthPacket     *p;Q     SUNHeadero     sun_header;      /*     Open output image file..   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)i/     PrematureExit("Unable to open file",image);*   /*&     Initialize SUN raster file header.   */   sun_header.magic=0x59a66a95;"   sun_header.width=image->columns;    sun_header.height=image->rows;N   sun_header.type=(image->class == DirectClass ? RT_FORMAT_RGB : RT_STANDARD);   sun_header.maptype=RMT_NONE;   sun_header.maplength=0;i   if (!IsPseudoClass(image))     {i       /*         Full color SUN raster.       */0       sun_header.depth=(image->matte ? 32 : 24);J       sun_header.length=image->columns*image->rows*(image->matte ? 4 : 3);>       sun_header.length+=image->columns % 2 ? image->rows : 0;     }    else3     if (IsGrayImage(image) && (image->colors == 2))        { 
         /*            Monochrome SUN raster.
         */         sun_header.depth=1; @         sun_header.length=((image->columns+7) >> 3)*image->rows;N         sun_header.length+=((image->columns/8)+(image->columns % 8 ? 1 : 0)) %           2 ? image->rows : 0;       }      else       { 
         /*!           Colormapped SUN raster. 
         */         sun_header.depth=8; 5         sun_header.length=image->columns*image->rows; @         sun_header.length+=image->columns % 2 ? image->rows : 0;)         sun_header.maptype=RMT_EQUAL_RGB;m-         sun_header.maplength=image->colors*3;t       }i   /*     Write SUN header.m   */2   MSBFirstWriteLong(sun_header.magic,image->file);2   MSBFirstWriteLong(sun_header.width,image->file);3   MSBFirstWriteLong(sun_header.height,image->file); 2   MSBFirstWriteLong(sun_header.depth,image->file);3   MSBFirstWriteLong(sun_header.length,image->file);.1   MSBFirstWriteLong(sun_header.type,image->file);r4   MSBFirstWriteLong(sun_header.maptype,image->file);6   MSBFirstWriteLong(sun_header.maplength,image->file);   /*&     Convert MIFF to SUN raster pixels.   */   p=image->pixels;   x=0;   if (!IsPseudoClass(image))     {g       /*4         Convert DirectClass packet to SUN RGB pixel.       */(       for (i=0; i < image->packets; i++)       {a,         for (j=0; j <= (int) p->length; j++)	         {(           if (image->matte)c/             (void) fputc(p->index,image->file);e6           (void) fputc(DownScale(p->red),image->file);8           (void) fputc(DownScale(p->green),image->file);7           (void) fputc(DownScale(p->blue),image->file);g           x++;"           if (x == image->columns)
             {0,               if ((image->columns % 2) != 0)?                 (void) fputc(0,image->file); /* pad scanline */a               x=0;
             } 	         }%         p++;       }%     }%   else3     if (IsGrayImage(image) && (image->colors == 2))        {          register unsigned char           bit,           byte,            polarity;   
         /*>           Convert PseudoClass image to a SUN monochrome image.
         */O         polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);          bit=0;         byte=0; *         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {              byte<<=1; %             if (p->index == polarity)                byte|=0x01;              bit++;             if (bit == 8)%               {%/                 (void) fputc(byte,image->file);%                 bit=0;                 byte=0;i               }              x++;$             if (x == image->columns)               {r                 /*/                   Advance to the next scanline.r                 */                 if (bit != 0)a<                   (void) fputc(byte << (8-bit),image->file);)                 if ((((image->columns/8)+e<                     (image->columns % 8 ? 1 : 0)) % 2) != 0)B                   (void) fputc(0,image->file);  /* pad scanline */                 bit=0;                 byte=0;c                 x=0;              }           }g           p++;	         }m       }i     else       {t
         /*            Dump colormap to file.
         */)         for (i=0; i < image->colors; i++)aF           (void) fputc(DownScale(image->colormap[i].red),image->file);)         for (i=0; i < image->colors; i++)eH           (void) fputc(DownScale(image->colormap[i].green),image->file);)         for (i=0; i < image->colors; i++) G           (void) fputc(DownScale(image->colormap[i].blue),image->file);t
         /*>           Convert PseudoClass packet to SUN colormapped pixel.
         */*         for (i=0; i < image->packets; i++)	         {i.           for (j=0; j <= (int) p->length; j++)           {./             (void) fputc(p->index,image->file);p             x++;$             if (x == image->columns)               {).                 if ((image->columns % 2) != 0)B                   (void) fputc(0,image->file);  /* pad scanline */                 x=0;               }s           }            p++;	         }s       }x   CloseImage(image);   return(True);o }e d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             % O %                                                                             %aO %                                                                             %aO %   W r i t e T A R G A I m a g e                                             %-O %                                                                             %mO %                                                                             %rO %                                                                             %-O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%= % M %  Function WriteTARGAImage writes a image in the Truevision Targa rasterfile-
 %  format. % 0 %  The format of the WriteTARGAImage routine is: %T/ %      status=WriteTARGAImage(image_info,image)i %"+ %  A description of each parameter follows.i %=L %    o status: Function WriteTARGAImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filem %      fails to write. %sA %    o image_info: Specifies a pointer to an ImageInfo structure.t %l. %    o image:  A pointer to a Image structure. %n %u */5 static unsigned int WriteTARGAImage(image_info,image)g	 ImageInfo    *image_info;   Image 	   *image;f {n #define TargaColormap 1n #define TargaRGB 2 #define TargaMonochrome 3  #define TargaRLEColormap  9i #define TargaRLERGB  10, #define TargaRLEMonochrome  11     typedef struct _TargaHeaderv   {f     unsigned char"       id_length,       colormap_type,       image_type;e       unsigned short       colormap_index,)       colormap_length;       unsigned charg       colormap_size;       unsigned short       x_origin,c       y_origin,        width,
       height;e       unsigned chary       pixel_size,u       attributes;)   } TargaHeader;     Images     *flopped_image;      int 
     count,     runlength;     register int     i,     j;     register RunlengthPacket     *p;t     register unsigned char     *q,n     *r;   
   TargaHeader      targa_header;l     unsigned char      *targa_pixels;     /*     Open output image file.o   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)z/     PrematureExit("Unable to open file",image);g   /*     Flop image.    */   image->orphan=True;a!   flopped_image=FlopImage(image);o   image->orphan=False;&   if (flopped_image == (Image *) NULL)0     PrematureExit("Unable to flop image",image);@   if (flopped_image->compression == RunlengthEncodedCompression)!     CompressImage(flopped_image);    /*(     Initialize TARGA raster file header.   */   targa_header.id_length=0;c/   if (flopped_image->comments != (char *) NULL),J     targa_header.id_length=Min((int) strlen(flopped_image->comments),255);   targa_header.colormap_type=0;/    targa_header.colormap_index=0;!   targa_header.colormap_length=0;i   targa_header.colormap_size=0;l   targa_header.x_origin=0;   targa_header.y_origin=0;,   targa_header.width=flopped_image->columns;*   targa_header.height=flopped_image->rows;   targa_header.pixel_size=8;   targa_header.attributes=0;$   if (!IsPseudoClass(flopped_image))     {        /*          Full color TARGA raster.       */'       targa_header.image_type=TargaRGB; D       if (flopped_image->compression == RunlengthEncodedCompression),         targa_header.image_type=TargaRLERGB;=       targa_header.pixel_size=flopped_image->matte ? 32 : 24;      }    else     {        /*!         Colormapped TARGA raster.        */,       targa_header.image_type=TargaColormap;D       if (flopped_image->compression == RunlengthEncodedCompression)1         targa_header.image_type=TargaRLEColormap; F       if (!IsGrayImage(flopped_image) || (flopped_image->colors != 2))	         {%'           targa_header.colormap_type=1;r(           targa_header.colormap_index=0;=           targa_header.colormap_length=flopped_image->colors;o(           targa_header.colormap_size=24;	         }f
       else	         {r           /*$             Monochrome TARGA raster.           */2           targa_header.image_type=TargaMonochrome;H           if (flopped_image->compression == RunlengthEncodedCompression)7             targa_header.image_type=TargaRLEMonochrome;i	         }r     }I   /*     Write TARGA header.o   */:   (void) fputc((char) targa_header.id_length,image->file);>   (void) fputc((char) targa_header.colormap_type,image->file);;   (void) fputc((char) targa_header.image_type,image->file); >   LSBFirstWriteShort(targa_header.colormap_index,image->file);?   LSBFirstWriteShort(targa_header.colormap_length,image->file); >   (void) fputc((char) targa_header.colormap_size,image->file);8   LSBFirstWriteShort(targa_header.x_origin,image->file);8   LSBFirstWriteShort(targa_header.y_origin,image->file);5   LSBFirstWriteShort(targa_header.width,image->file); 6   LSBFirstWriteShort(targa_header.height,image->file);;   (void) fputc((char) targa_header.pixel_size,image->file); ;   (void) fputc((char) targa_header.attributes,image->file); "   if (targa_header.id_length != 0)L     (void) fwrite((char *) flopped_image->comments,1,targa_header.id_length,       image->file);    /*(     Convert MIFF to TARGA raster pixels.   */   count=(unsigned int)J     (targa_header.pixel_size*targa_header.width*targa_header.height) >> 3;@   if (flopped_image->compression == RunlengthEncodedCompression)     count+=(count/128)+1;nE   targa_pixels=(unsigned char *) malloc(count*sizeof(unsigned char));f-   if (targa_pixels == (unsigned char *) NULL)u=     PrematureExit("Unable to allocate memory",flopped_image);h5   p=flopped_image->pixels+(flopped_image->packets-1);M   q=targa_pixels; $   if (!IsPseudoClass(flopped_image))     {u       /*6         Convert DirectClass packet to TARGA RGB pixel.       */D       if (flopped_image->compression != RunlengthEncodedCompression)2         for (i=0; i < flopped_image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { $             *q++=DownScale(p->blue);%             *q++=DownScale(p->green); #             *q++=DownScale(p->red); %             if (flopped_image->matte)                *q++=p->index;           }f           p--;	         }U
       else2         for (i=0; i < flopped_image->packets; i++)	         {I            runlength=p->length+1;           if (runlength > 128)
             {u               *q++=0xff;&               *q++=DownScale(p->blue);'               *q++=DownScale(p->green);t%               *q++=DownScale(p->red);)'               if (flopped_image->matte)                  *q++=p->index;               runlength-=128;)
             }e           r=q;"           *q++=0x80+(runlength-1);"           *q++=DownScale(p->blue);#           *q++=DownScale(p->green);%!           *q++=DownScale(p->red);%#           if (flopped_image->matte)              *q++=p->index;           if (runlength != 1)              p--;           else
             { 6               for ( ; i < flopped_image->packets; i++)               {                  p--;;                 if ((p->length != 0) || (runlength == 128))                    break;(                 *q++=DownScale(p->blue);)                 *q++=DownScale(p->green); '                 *q++=DownScale(p->red); )                 if (flopped_image->matte)                     *q++=p->index;                 runlength++;               }                *r=runlength-1;%
             }%	         }%     }%   elseD     if (!IsGrayImage(flopped_image) || (flopped_image->colors != 2))       {n         unsigned char.           *targa_colormap;  
         /*>           Dump colormap to file (blue, green, red byte order).
         */          if (image->colors > 256)N           QuantizeImage(flopped_image,256,8,image_info->dither,RGBColorspace);(         targa_colormap=(unsigned char *)G           malloc(3*targa_header.colormap_length*sizeof(unsigned char));o5         if (targa_colormap == (unsigned char *) NULL)uC           PrematureExit("Unable to allocate memory",flopped_image);          q=targa_colormap;D1         for (i=0; i < flopped_image->colors; i++);	         { :           *q++=DownScale(flopped_image->colormap[i].blue);;           *q++=DownScale(flopped_image->colormap[i].green);F9           *q++=DownScale(flopped_image->colormap[i].red);%	         }%0         (void) fwrite((char *) targa_colormap,1,<           (int) 3*targa_header.colormap_length,image->file);&         free((char *) targa_colormap);
         /*@           Convert PseudoClass packet to TARGA colormapped pixel.
         */         q=targa_pixels; F         if (flopped_image->compression != RunlengthEncodedCompression)4           for (i=0; i < flopped_image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)               *q++=p->index;             p--;           }          else4           for (i=0; i < flopped_image->packets; i++)           { "             runlength=p->length+1;              if (runlength > 128)               {%                 *q++=0xff;                 *q++=p->index;                 runlength-=128;I               }f             r=q;$             *q++=0x80+(runlength-1);             *q++=p->index;             if (runlength != 1)e               p--;             else               { 8                 for ( ; i < flopped_image->packets; i++)                 {                    p--;=                   if ((p->length != 0) || (runlength == 128))i                     break;                    *q++=p->index;                   runlength++;                 }r                 *r=runlength-1;/               }            }m       }_     else       {I         unsigned int           polarity;   
         /*P           Convert PseudoClass flopped_image to a TARGA monochrome flopped_image.
         */         polarity=0;p'         if (flopped_image->colors == 2) :           polarity=Intensity(flopped_image->colormap[0]) >2             Intensity(flopped_image->colormap[1]);F         if (flopped_image->compression != RunlengthEncodedCompression)4           for (i=0; i < flopped_image->packets; i++)           {m0             for (j=0; j <= (int) p->length; j++)@               *q++=p->index == polarity ? 0 : DownScale(MaxRGB);             p--;           }          else4           for (i=0; i < flopped_image->packets; i++)           { "             runlength=p->length+1;              if (runlength > 128)               {                  *q++=0xff;B                 *q++=p->index == polarity ? 0 : DownScale(MaxRGB);                 runlength-=128;)               }t             r=q;$             *q++=0x80+(runlength-1);>             *q++=p->index == polarity ? 0 : DownScale(MaxRGB);             if (runlength != 1)u               p--;             else               {g8                 for ( ; i < flopped_image->packets; i++)                 {r                   p--;=                   if ((p->length != 0) || (runlength == 128))t                     break;D                   *q++=p->index == polarity ? 0 : DownScale(MaxRGB);                   runlength++;                 }c                 *r=runlength-1;                }o           }-       }_L   (void) fwrite((char *) targa_pixels,1,(int) (q-targa_pixels),image->file);   DestroyImage(flopped_image);   free((char *) targa_pixels);   CloseImage(image);   return(True);o }n c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %dO %                                                                             % O %                                                                             %aO %   W r i t e T E X T I m a g e                                               %dO %                                                                             %>O %                                                                             %FO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %rC %  Function WriteTEXTImage writes an image in the TEXT image forma.  %*/ %  The format of the WriteTEXTImage routine is:p %n. %      status=WriteTEXTImage(image_info,image) % + %  A description of each parameter follows.L % K %    o status: Function WriteTEXTImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image filei %      fails to write. %eA %    o image_info: Specifies a pointer to an ImageInfo structure.. %e. %    o image:  A pointer to a Image structure. %6 %a */4 static unsigned int WriteTEXTImage(image_info,image)	 ImageInfo    *image_info;   Image.	   *image;i {e   unsigned int     status;t  6   Warning("Cannot write TEXT images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);g }f ) #ifdef HasTIFF #ifndef va_start, #if defined(__STDC__) && !defined(NOSTDHDRS) #include <stdarg.h>  #elsep #include <varargs.h> #endif #endif #include "tiffio.h"x /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %;O %                                                                             % O %                                                                             %>O %   W r i t e T I F F I m a g e                                               %aO %                                                                             %_O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %.K %  Function WriteTIFFImage writes an image in the Tagged image file format.i %I/ %  The format of the WriteTIFFImage routine is:o %m. %      status=WriteTIFFImage(image_info,image) %i+ %  A description of each parameter follows:  %oL %    o status:  Function WriteTIFFImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %o %n */4 static unsigned int WriteTIFFImage(image_info,image)	 ImageInfon   *image_info;   Image 	   *image;  {  #ifndef TIFFDefaultStripSizeM #define TIFFDefaultStripSize(tiff,request)  ((8*1024)/TIFFScanlineSize(tiff))  #endif     Image      encode_image;      int 
     flags,     sans_offset;     register RunlengthPacket     *p;      register int     i,     j,     x,     y;     register unsigned char     *q;      TIFF
     *tiff;     uint16     compression,     photometric;     unsigned charr     *scanline;     unsigned int     x_resolution,h     y_resolution;e     unsigned short
     value;     /*     Open TIFF file.=   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);|.   if ((image->file != stdout) && !image->pipe)#     (void) unlink(image->filename);f   else     {1       /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);p       image->temporary=True;     }    CloseImage(image);&   tiff=TIFFOpen(image->filename,"wb");   if (tiff == (TIFF *) NULL)     return(False);   /*     Initialize TIFF fields.t   */:   TIFFSetField(tiff,TIFFTAG_DOCUMENTNAME,image->filename);4   TIFFSetField(tiff,TIFFTAG_SOFTWARE,"ImageMagick");'   if (image->comments != (char *) NULL)_@     TIFFSetField(tiff,TIFFTAG_IMAGEDESCRIPTION,image->comments);-   TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,8);%   if (image->depth == 16)%0     TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,16);   if (!IsPseudoClass(image))     {        /*         Full color TIFF raster.        */"       photometric=PHOTOMETRIC_RGB;H       TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,(image->matte ? 4 : 3));       if (image->matte) 	         {            uint16             extra_samples,             sample_info[1];              /*%             TIFF has a matte channel.            */           extra_samples=1;0           sample_info[0]=EXTRASAMPLE_ASSOCALPHA;M           TIFFSetField(tiff,TIFFTAG_EXTRASAMPLES,extra_samples,&sample_info);%	         }%     }%   else     {%       /*          Colormapped TIFF raster.       */&       photometric=PHOTOMETRIC_PALETTE;3       TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,1);i       if (IsGrayImage(image)) 	         {r           /*"             Grayscale TIFF raster.           */-           photometric=PHOTOMETRIC_MINISBLACK;r!           if (image->colors == 2)e7             TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,1);r	         }o     }e5   TIFFSetField(tiff,TIFFTAG_PHOTOMETRIC,photometric);i>   TIFFSetField(tiff,TIFFTAG_IMAGELENGTH,(uint32) image->rows);@   TIFFSetField(tiff,TIFFTAG_IMAGEWIDTH,(uint32) image->columns);9   TIFFSetField(tiff,TIFFTAG_FILLORDER,FILLORDER_MSB2LSB);a=   TIFFSetField(tiff,TIFFTAG_ORIENTATION,ORIENTATION_TOPLEFT);m>   TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_CONTIG);B   TIFFSetField(tiff,TIFFTAG_RESOLUTIONUNIT,(uint16) image->units);
   flags=0;+   if (image_info->density != (char *) NULL) G     flags=XParseGeometry(image_info->density,&sans_offset,&sans_offset,e#       &x_resolution,&y_resolution);    if (flags & WidthValue) %     image->x_resolution=x_resolution;l   if (flags & HeightValue)%     image->y_resolution=y_resolution;e=   TIFFSetField(tiff,TIFFTAG_XRESOLUTION,image->x_resolution); =   TIFFSetField(tiff,TIFFTAG_YRESOLUTION,image->y_resolution);o   compression=COMPRESSION_LZW;   if (!image->matte)3     if (IsGrayImage(image) && (image->colors == 2)))(       compression=COMPRESSION_CCITTFAX4;*   if (image->compression == NoCompression)!     compression=COMPRESSION_NONE; 5   TIFFSetField(tiff,TIFFTAG_COMPRESSION,compression);a)   TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP, .     TIFFDefaultStripSize(tiff,(uint32) (-1)));<   scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff));)   if (scanline == (unsigned char *) NULL)-5     PrematureExit("Unable to allocate memory",image);    p=image->pixels;
   q=scanline;*   x=0;   y=0;%   if (photometric == PHOTOMETRIC_RGB) &     for (i=0; i < image->packets; i++)     {6*       for (j=0; j <= (int) p->length; j++)       {t
         /*B           Convert DirectClass packets to contiguous RGB scanlines.
         */         WriteQuantum(p->red,q);w!         WriteQuantum(p->green,q);e          WriteQuantum(p->blue,q);         if (image->matte) #           WriteQuantum(p->index,q);|         x++;          if (x == image->columns)           { B             if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)               break;             q=scanline;              x=0;             y++;           }x       }i
       p++;     }l   else+     if (photometric == PHOTOMETRIC_PALETTE)e       {          unsigned short           *blue,           *green,i           *red;=  
         /*!           Allocate TIFF colormap.S
         */M         blue=(unsigned short *) malloc(image->colors*sizeof(unsigned short)); N         green=(unsigned short *) malloc(image->colors*sizeof(unsigned short));L         red=(unsigned short *) malloc(image->colors*sizeof(unsigned short));0         if ((blue == (unsigned short *) NULL) ||1             (green == (unsigned short *) NULL) ||e-             (red == (unsigned short *) NULL)) ;           PrematureExit("Unable to allocate memory",image); 
         /*#           Initialize TIFF colormap./
         */)         for (i=0; i < image->colors; i++)t	         {e!           red[i]=(unsigned short)oC             ((image->colormap[i].red*65535)/(unsigned int) MaxRGB); #           green[i]=(unsigned short)eE             ((image->colormap[i].green*65535)/(unsigned int) MaxRGB); "           blue[i]=(unsigned short)D             ((image->colormap[i].blue*65535)/(unsigned int) MaxRGB);	         }c;         TIFFSetField(tiff,TIFFTAG_COLORMAP,red,green,blue);r
         /*O           Convert PseudoClass packets to contiguous colormap indexed scanlines.e
         */*         for (i=0; i < image->packets; i++)	         {e.           for (j=0; j <= (int) p->length; j++)           {e%             WriteQuantum(p->index,q);e             x++;$             if (x == image->columns)               {uF                 if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                   break;                 q=scanline;o                 x=0;                 y++;               }r           }i           p++;	         }f         free((char *) red);          free((char *) green);T         free((char *) blue);       }a     else       if (image->colors > 2)*         for (i=0; i < image->packets; i++)	         {i.           for (j=0; j <= (int) p->length; j++)           {f             /*L               Convert PseudoClass packets to contiguous grayscale scanlines.             */*             WriteQuantum(Intensity(*p),q);             x++;$             if (x == image->columns)               {eF                 if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                   break;                 q=scanline;t                 x=0;                 y++;               })           }e           p++;	         }i
       else	         {"            register unsigned char             bit,             byte,n             polarity;              /*K             Convert PseudoClass packets to contiguous monochrome scanlines.F           */           polarity=0;r!           if (image->colors == 2)9             polarity=fL               Intensity(image->colormap[0]) < Intensity(image->colormap[1]);           bit=0;           byte=0;d           x=0;,           for (i=0; i < image->packets; i++)           {i0             for (j=0; j <= (int) p->length; j++)
             {e               byte<<=1;)'               if (p->index == polarity)                  byte|=0x01;                bit++;               if (bit == 8)f                 {b                   *q++=byte;                   bit=0;                   byte=0;t                 }i               x++;&               if (x == image->columns)                 {                    /*1                     Advance to the next scanline.)                   */                   if (bit != 0)>)                     *q++=byte << (8-bit);eH                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;\                   bit=0;                   byte=0;\                   x=0;                   y++;                }
             }e             p++;           }+	         },   free((char *) scanline);   (void) TIFFFlushData(tiff);e"   if (image_info->verbose == True)*     TIFFPrintDirectory(tiff,stderr,False);   (void) TIFFClose(tiff);f   if (image->temporary)r     {;
       FILE         *file;  	       int)
         c;         /*7         Copy temporary file to standard output or pipe.)       */'       file=fopen(image->filename,"rb");f        if (file == (FILE *) NULL)3         PrematureExit("Unable to open file",image);t       c=fgetc(file);       while (c != EOF)       { )         (void) putc(c,encode_image.file);;         c=fgetc(file);       }        (void) fclose(file);%       (void) unlink(image->filename);         CloseImage(&encode_image);     }=   return(True);i }f #elsei4 static unsigned int WriteTIFFImage(image_info,image)	 ImageInfon   *image_info;   Imagee	   *image;) {    unsigned int     status;"  ;   Warning("TIFF library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);i }f #endif e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%>O %                                                                             %iO %                                                                             %HO %                                                                             % O %   W r i t e T I L E I m a g e                                               % O %                                                                             %fO %                                                                             %)O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %nL %  Function WriteTILEImage writes an image in the TILE encoded image format. % / %  The format of the WriteTILEImage routine is:  %C. %      status=WriteTILEImage(image_info,image) %e+ %  A description of each parameter follows.i %fK %    o status: Function WriteTILEImage return True if the image is written.eK %      False is returned is there is a memory shortage or if the image filed %      fails to write. %)A %    o image_info: Specifies a pointer to an ImageInfo structure.L %t. %    o image:  A pointer to a Image structure. %) %  */4 static unsigned int WriteTILEImage(image_info,image)	 ImageInfoe   *image_info;   Image 	   *image;d {a   unsigned int     status;-  6   Warning("Cannot write TILE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);e }x a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %iO %                                                                             %oO %                                                                             % O %   W r i t e V I C A R I m a g e                                             % O %                                                                             %pO %                                                                             %)O %                                                                             %GO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%D %SK %  Function WriteVICARImage writes an image in the VICAR rasterfile format.qN %  Vicar files contain a text header, followed by one or more planes of binaryM %  grayscale image data.  Vicar files are designed to allow many planes to be K %  stacked together to form image cubes.  This routine only writes a single  %  grayscale plane.  % 6 %  Function WriteVICARImage was written contributed by %  gorelick@esther.la.asu.edu. % 0 %  The format of the WriteVICARImage routine is: % / %      status=WriteVICARImage(image_info,image)  % + %  A description of each parameter follows.n % L %    o status: Function WriteVICARImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filef %      fails to write. %iA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %c %( */5 static unsigned int WriteVICARImage(image_info,image)c	 ImageInfol   *image_info;   Image 	   *image;  {    char     header[MaxTextLength],     label[16];     int      label_size;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)e/     PrematureExit("Unable to open file",image);y   /*     Make a header.   */K   (void) sprintf(header,"LBLSIZE=            FORMAT='BYTE'  TYPE='IMAGE'"); H   (void) sprintf(header+strlen(header),"  BUFSIZE=20000  DIM=2  EOL=0");'   (void) sprintf(header+strlen(header),RM     "  RECSIZE=%d  ORG='BSQ'  NL=%u  NS=%u  NB=1",image->columns,image->rows,      image->columns);'   (void) sprintf(header+strlen(header), .     "  N1=0  N2=0  N3=0  N4=0  NBB=0  NLB=0");?   (void) sprintf(header+strlen(header),"  TASK='ImageMagick'");l   /*"     Compute the size of the label.   */M   label_size=(strlen(header)+image->columns-1)/image->columns*image->columns;a(   (void) sprintf(label,"%d",label_size);*   for (i=0 ; i < (int) strlen(label); i++)     header[i+8]=label[i];    /*>     Print the header and enough spaces to pad to label size.     */8   (void) fprintf(image->file, "%-*s",label_size,header);   /*(     Convert MIFF to VICAR raster pixels.   */*   RGBTransformImage(image,GRAYColorspace);   p=image->pixels;$   for (i=0; i < image->packets; i++)   {f*     for (j=0; j <= ((int) p->length); j++)'       (void) fputc(p->red,image->file);      p++;   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %bO %                                                                             % O %   W r i t e V I F F I m a g e                                               % O %                                                                             %iO %                                                                             %;O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %IN %  Function WriteVIFFImage writes an image to a file in the VIFF image format. % / %  The format of the WriteVIFFImage routine is:  % . %      status=WriteVIFFImage(image_info,image) % + %  A description of each parameter follows.  %yK %    o status: Function WriteVIFFImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteVIFFImage(image_info,image)	 ImageInfoi   *image_info;   Image 	   *image;  {  #define VFF_CM_genericRGB  15  #define VFF_CM_NONE  0 #define VFF_DEP_IEEEORDER  0x2 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1y #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1e     typedef struct _ViffHeader   {      char       identifier,        file_type,       release,       version,       machine_dependency,        reserve[3],        comment[512];s       unsigned long        rows,R       columns,       subrows;       long       x_offset,        y_offset;        unsigned int       x_pixel_size,        y_pixel_size;        unsigned longe       location_type,       location_dimension,n       number_of_images,        number_data_bands,       data_storage_type,       data_encode_scheme,g       map_scheme,        map_storage_type,i       map_rows,c       map_columns,       map_subrows,       map_enable,W       maps_per_cycle,        color_space_model;   } ViffHeader;      register int     i,     j;     register RunlengthPacket     *p;j     register unsigned char     *q;      unsigned chari     buffer[8],     *viff_pixels;      unsigned long      packets;     ViffHeader     viff_header;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)a/     PrematureExit("Unable to open file",image);    /*$     Initialize VIFF image structure.   */   viff_header.identifier=0xab;   viff_header.file_type=1;   viff_header.release=1;   viff_header.version=3;M   viff_header.machine_dependency=VFF_DEP_IEEEORDER;  /* IEEE byte ordering */i   *viff_header.comment='\0';'   if (image->comments != (char *) NULL)      { 9       (void) strncpy(viff_header.comment,image->comments,r0         Min((int) strlen(image->comments),511));G       viff_header.comment[Min((int) strlen(image->comments),511)]='\0';"     }v"   viff_header.rows=image->columns;"   viff_header.columns=image->rows;   viff_header.subrows=0;   viff_header.x_offset=(~0);   viff_header.y_offset=(~0);   viff_header.x_pixel_size=0;n   viff_header.y_pixel_size=0;a-   viff_header.location_type=VFF_LOC_IMPLICIT;a#   viff_header.location_dimension=0;a!   viff_header.number_of_images=1;>-   viff_header.data_encode_scheme=VFF_DES_RAW;e%   viff_header.map_scheme=VFF_MS_NONE;v/   viff_header.map_storage_type=VFF_MAPTYP_NONE;&   viff_header.map_rows=0;    viff_header.map_columns=0;   viff_header.map_subrows=0;.   viff_header.map_enable=1;  /* no colormap */   viff_header.maps_per_cycle=0;    if (!IsPseudoClass(image))     {i       /*         Full color VIFF raster.h       */9       viff_header.number_data_bands=image->matte ? 4 : 3;u6       viff_header.color_space_model=VFF_CM_genericRGB;3       viff_header.data_storage_type=VFF_TYP_1_BYTE;dG       packets=image->columns*image->rows*viff_header.number_data_bands;m     }p   else     {f&       viff_header.number_data_bands=1;0       viff_header.color_space_model=VFF_CM_NONE;3       viff_header.data_storage_type=VFF_TYP_1_BYTE;e)       packets=image->columns*image->rows;a       if (!IsGrayImage(image))	         {n           /*$             Colormapped VIFF raster.           */3           viff_header.map_scheme=VFF_MS_ONEPERBAND;e9           viff_header.map_storage_type=VFF_MAPTYP_1_BYTE;n!           viff_header.map_rows=3;m0           viff_header.map_columns=image->colors;	         }i
       else         if (image->colors == 2)e           {              /*%               Monochrome VIFF raster.p             */6             viff_header.data_storage_type=VFF_TYP_BIT;:             packets=((image->columns+7) >> 3)*image->rows;           }r     }a   /*0     Write VIFF image header (pad to 1024 bytes).   */#   buffer[0]=viff_header.identifier;i"   buffer[1]=viff_header.file_type;    buffer[2]=viff_header.release;    buffer[3]=viff_header.version;+   buffer[4]=viff_header.machine_dependency; #   buffer[5]=viff_header.reserve[0]; #   buffer[6]=viff_header.reserve[1];/#   buffer[7]=viff_header.reserve[2];-1   (void) fwrite((char *) buffer,1,8,image->file);d@   (void) fwrite((char *) viff_header.comment,1,512,image->file);2   MSBFirstWriteLong(viff_header.rows,image->file);5   MSBFirstWriteLong(viff_header.columns,image->file);m5   MSBFirstWriteLong(viff_header.subrows,image->file); F   MSBFirstWriteLong((unsigned long) viff_header.x_offset,image->file);F   MSBFirstWriteLong((unsigned long) viff_header.y_offset,image->file);J   MSBFirstWriteLong((unsigned long) viff_header.x_pixel_size,image->file);J   MSBFirstWriteLong((unsigned long) viff_header.y_pixel_size,image->file);;   MSBFirstWriteLong(viff_header.location_type,image->file);D@   MSBFirstWriteLong(viff_header.location_dimension,image->file);>   MSBFirstWriteLong(viff_header.number_of_images,image->file);?   MSBFirstWriteLong(viff_header.number_data_bands,image->file);e?   MSBFirstWriteLong(viff_header.data_storage_type,image->file); @   MSBFirstWriteLong(viff_header.data_encode_scheme,image->file);8   MSBFirstWriteLong(viff_header.map_scheme,image->file);>   MSBFirstWriteLong(viff_header.map_storage_type,image->file);6   MSBFirstWriteLong(viff_header.map_rows,image->file);9   MSBFirstWriteLong(viff_header.map_columns,image->file);z9   MSBFirstWriteLong(viff_header.map_subrows,image->file); 8   MSBFirstWriteLong(viff_header.map_enable,image->file);<   MSBFirstWriteLong(viff_header.maps_per_cycle,image->file);?   MSBFirstWriteLong(viff_header.color_space_model,image->file);(   for (i=0; i < 420; i++)l#     (void) fputc('\0',image->file);o   /*'     Convert MIFF to VIFF raster pixels.    */F   viff_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char));,   if (viff_pixels == (unsigned char *) NULL)5     PrematureExit("Unable to allocate memory",image);    p=image->pixels;   q=viff_pixels;   if (!IsPseudoClass(image))     {E       unsigned longu         offset;          /*5         Convert DirectClass packet to VIFF RGB pixel.        */(       offset=image->columns*image->rows;(       for (i=0; i < image->packets; i++)       {&,         for (j=0; j <= (int) p->length; j++)	         {u           *q=DownScale(p->red); *           *(q+offset)=DownScale(p->green);+           *(q+offset*2)=DownScale(p->blue);            if (image->matte)i3             *(q+offset*3)=(unsigned char) p->index;            q++;	         }t         p++;       }s     }    else     if (!IsGrayImage(image))       {s         unsigned charl           *viff_colormap;   
         /*            Dump colormap to file.
         */'         viff_colormap=(unsigned char *)c8           malloc(image->colors*3*sizeof(unsigned char));4         if (viff_colormap == (unsigned char *) NULL);           PrematureExit("Unable to allocate memory",image);h         q=viff_colormap;)         for (i=0; i < image->colors; i++)g1           *q++=DownScale(image->colormap[i].red);c)         for (i=0; i < image->colors; i++) 3           *q++=DownScale(image->colormap[i].green); )         for (i=0; i < image->colors; i++) 2           *q++=DownScale(image->colormap[i].blue);E         (void) fwrite((char *) viff_colormap,1,(int) image->colors*3,            image->file); %         free((char *) viff_colormap);x
         /*@           Convert PseudoClass packet to VIFF colormapped pixels.
         */         q=viff_pixels;*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)             *q++=p->index;           p++;	         }        }=     else       if (image->colors == 2) 	         {             register unsigned char             bit,             byte,              polarity;              register int             x;             /*A             Convert PseudoClass image to a VIFF monochrome image.            */           polarity=;J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);           x=0;           bit=0;           byte=0;e,           for (i=0; i < image->packets; i++)           {e0             for (j=0; j <= (int) p->length; j++)
             {a               byte>>=1; '               if (p->index == polarity)p                 byte|=0x80;k               bit++;               if (bit == 8)(                 {                    *q++=byte;                   bit=0;                   byte=0;(                 })               x++;&               if (x == image->columns)                 {                    /*1                     Advance to the next scanline.                    */                   if (bit != 0) )                     *q++=byte >> (8-bit);;                   bit=0;                   byte=0;e                   x=0;                }
             }              p++;           }l	         } 
       else	         {            /*?             Convert PseudoClass packet to VIFF grayscale pixel.            */,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)               *q++=p->red;             p++;           } 	         } B   (void) fwrite((char *) viff_pixels,1,(int) packets,image->file);   free((char *) viff_pixels);    CloseImage(image);   return(True);> }e   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*O %                                                                             %eO %                                                                             % O %                                                                             %yO %   W r i t e X I m a g e                                                     %wO %                                                                             %eO %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 7 %  Function WriteXImage writes an image to an X server.= %e, %  The format of the WriteXImage routine is: %t+ %      status=WriteXImage(image_info,image)j % + %  A description of each parameter follows.q %(L %    o status: Function WriteXImage return True if the image is displayed onK %      the X server.  False is returned is there is a memory shortage or ifr% %      the image file fails to write.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */1 static unsigned int WriteXImage(image_info,image)o	 ImageInfo    *image_info;   Image 	   *image;  {    Atom     wm_delete_window,(     wm_protocols;+     char     name[MaxTextLength];  	   Display 
     *display;>     register char      *p;      unsigned int     status;8     XGCValuesi     context_values;a     XResourceInfo      resource_info;  
   XrmDatabasel     resource_database;     XEvent
     event;     XPixelInfo     pixel_info;n     XStandardColormap)     *map_info;  
   XVisualInfo      *visual_info;e  
   XWindowInfo/     window_info;     /*     Open X server connection.>   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {n.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return(False);     }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);o   /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);A   /*     Allocate standard colormap.n   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    else     {i       /*         Initialize visual info.l       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info);d.       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;>/       pixel_info.pixels=(unsigned long *) NULL;i     }    /*     Initialize atoms.e   */1   if ((map_info == (XStandardColormap *) NULL) ||a,       (visual_info == (XVisualInfo *) NULL))     {)F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }h   /*!     Initialize Standard Colormap.n   */J   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info);    /*%     Initialize window info structure.i   */   window_info.id=(Window) NULL;oO   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info);f   window_info.name=name;.   p=image->filename+strlen(image->filename)-1;A   while ((p > image->filename) && (*(p-1) != *BasenameSeparator)))     p--;H   (void) sprintf(window_info.name,"ImageMagick: %s[%u]",p,image->scene);   if (image->scene == 0)9     (void) sprintf(window_info.name,"ImageMagick: %s",p);a#   window_info.width=image->columns;i!   window_info.height=image->rows;)C   window_info.attributes.event_mask=ButtonPressMask | ExposureMask;%P   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);   window_info.x=0;   window_info.y=0;"   window_info.shared_memory=False;   /*     Graphic context.   */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL)s<     Error("Unable to create graphic context",(char *) NULL);;   window_info.annotate_context=pixel_info.annotate_context;%>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;N   pixel_info.highlight_context=XCreateGC(display,window_info.id,GCBackground |"     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);=   window_info.highlight_context=pixel_info.highlight_context; &   pixel_info.widget_context=(GC) NULL;'   window_info.widget_context=(GC) NULL;    /*     Initialize X image.    */M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,%     image->rows);%   if (status == False)     {%>       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);4       PrematureExit("Unable to make X image",image);     }s   free((char *) image->pixels);m)   image->pixels=(RunlengthPacket *) NULL;r:   (void) XMakePixmap(display,&resource_info,&window_info);!   free(window_info.ximage->data); )   window_info.ximage->data=(char *) NULL;    /*4     Display image and wait for button press to exit.   */9   wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False); A   wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);t%   XMapWindow(display,window_info.id);i
   for ( ; ; )g   {      XNextEvent(display,&event);a"     if (event.type == ButtonPress)       break;$     if (event.type == ClientMessage)5       if (event.xclient.message_type == wm_protocols)e6         if (*event.xclient.data.l == wm_delete_window)5           if (event.xclient.window == window_info.id)e             break;     if (event.type == Expose) 2       XRefreshWindow(display,&window_info,&event);   } =   XWithdrawWindow(display,window_info.id,window_info.screen);i   /*     Free X resources.s   */O   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info);n   return(True);  }a s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             % O %                                                                             %nO %   W r i t e X B M I m a g e                                                 % O %                                                                             %;O %                                                                             %pO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eL %  Procedure WriteXBMImage writes an image to a file in the X bitmap format. %,. %  The format of the WriteXBMImage routine is: %r- %      status=WriteXBMImage(image_info,image)* % + %  A description of each parameter follows.a %>J %    o status: Function WriteXBMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image files %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.e %h. %    o image:  A pointer to a Image structure. %e %i */3 static unsigned int WriteXBMImage(image_info,image)a	 ImageInfo|   *image_info;   Imagee	   *image;e {h   char     name[MaxTextLength];     register int     i,     j,     x;     register charc     *q;y     register RunlengthPacket     *p;i     register unsigned char     bit,	     byte,a
     polarity;      unsigned int
     count;     /*     Open output image file.c   */   OpenImage(image,"w");e#   if (image->file == (FILE *) NULL)e/     PrematureExit("Unable to open file",image);e   /*     Write X bitmap header.   */&   (void) strcpy(name,image->filename);	   q=name;l%   while ((*q != '.') && (*q != '\0'))s     q++;   if (*q == '.')     *q='\0';J   (void) fprintf(image->file,"#define %s_width %u\n",name,image->columns);H   (void) fprintf(image->file,"#define %s_height %u\n",name,image->rows);A   (void) fprintf(image->file,"static char %s_bits[] = {\n",name);p"   (void) fprintf(image->file," ");   /*$     Convert MIFF to X bitmap pixels.   */=   QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);a   SyncImage(image);_
   polarity=0;    if (image->colors == 2)lK     polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);a   bit=0;	   byte=0;m
   count=0;   x=0;   p=image->pixels;"   (void) fprintf(image->file," ");$   for (i=0; i < image->packets; i++)   {m*     for (j=0; j <= ((int) p->length); j++)     {=       byte>>=1;D       if (p->index == polarity)          byte|=0x80;r       bit++;       if (bit == 8)a	         {.           /*2             Write a bitmap byte to the image file.           */=           (void) fprintf(image->file,"0x%02x, ",byte & 0xff);S           count++;           if (count == 12)
             {m1               (void) fprintf(image->file,"\n  ");e               count=0;             };           bit=0;           byte=0; 	         }t
       x++;       if (x == image->columns)	         {r           if (bit != 0)e
             {F               /*6                 Write a bitmap byte to the image file.               */               byte>>=(8-bit);lA               (void) fprintf(image->file,"0x%02x, ",byte & 0xff);r               count++;               if (count == 12)                 {o5                   (void) fprintf(image->file,"\n  ");o                   count=0;                 };               bit=0;               byte=0;t             };           x=0;	         }F     }t     p++;   }c%   (void) fprintf(image->file,"};\n");r   CloseImage(image);   return(True);f })   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %tO %                                                                             %)O %                                                                             %cO %   W r i t e X C I m a g e                                                   %aO %                                                                             %aO %                                                                             %cO %                                                                             %,O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %lH %  Function WriteXCImage writes an image in the X constant image format. % - %  The format of the WriteXCImage routine is:e % , %      status=WriteXCImage(image_info,image) %l+ %  A description of each parameter follows.t %aI %    o status: Function WriteXCImage return True if the image is written.FK %      False is returned is there is a memory shortage or if the image file  %      fails to write. %eA %    o image_info: Specifies a pointer to an ImageInfo structure.g %f. %    o image:  A pointer to a Image structure. %> %e */2 static unsigned int WriteXCImage(image_info,image)	 ImageInfo    *image_info;   Imagep	   *image;e {u   unsigned int     status;t  4   Warning("Cannot write XC images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);n }  n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %iO %                                                                             %FO %                                                                             %sO %   W r i t e X P M I m a g e                                                 % O %                                                                             % O %                                                                             %iO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Procedure WriteXPMImage writes an image to a file in the X pixmap format. %*. %  The format of the WriteXPMImage routine is: %e- %      status=WriteXPMImage(image_info,image)B % + %  A description of each parameter follows.( %iJ %    o status: Function WriteXPMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image fileg %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %t. %    o image:  A pointer to a Image structure. %r %r */
 #ifdef HasXPMt #include "xpm.h"3 static unsigned int WriteXPMImage(image_info,image)a	 ImageInfo    *image_info;   Imagec	   *image;. {h   char     *xpm_buffer;  	   Displays
     *display;.     inta     status;      register chard     *p;n     XResourceInfoe     resource_info;  
   XrmDatabasea     resource_database;     XImage     *matte_image;t     XPixelInfo     pixel_info;e     XpmAttributest     xpm_attributes;n     XStandardColormap-     *map_info;  
   XVisualInfoa     *visual_info;i  
   XWindowInfor     window_info;     /*     Open output image file.-   */   OpenImage(image,"w"); #   if (image->file == (FILE *) NULL)u/     PrematureExit("Unable to open file",image);n   /*     Open X server connection.c   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {(.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return(False);     }d   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); )   resource_info.colormap=PrivateColormap;    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)+M     Warning("Unable to create standard colormap","Memory allocation failed");a   else     {        /*         Initialize visual info.        */C       visual_info=XBestVisualInfo(display,map_info,&resource_info);e.       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;r/       pixel_info.pixels=(unsigned long *) NULL;      } 1   if ((map_info == (XStandardColormap *) NULL) ||o,       (visual_info == (XVisualInfo *) NULL))     {SF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }H   matte_image=(XImage *) NULL;   if (image->matte)%     {%       /*         Create X shape image.%       */H       matte_image=XCreateImage(display,visual_info->visual,1,XYBitmap,0,H         (char *) NULL,image->columns,image->rows,XBitmapPad(display),0);)       if (matte_image == (XImage *) NULL) >         Warning("Unable to create matte image",(char *) NULL);
       else	         {            /*(             Allocate X shape image data.           */$           matte_image->data=(char *)D             malloc(matte_image->bytes_per_line*matte_image->height);1           if (matte_image->data == (char *) NULL) O             Warning("Unable to create matte image","Memory allocation failed");%           else
             {%               int%                 x,                 y;                 register int                 i,                 j;  &               register RunlengthPacket                 *p;                  /*)                 Initialize X shape image.i               */               x=0;               y=0;               p=image->pixels;0               for (i=0; i < image->packets; i++)               { 4                 for (j=0; j <= (int) p->length; j++)                 {iM                   XPutPixel(matte_image,x,y,p->index == Transparent ? 0 : 1);t                   x++;*                   if (x == image->columns)                     {                        x=0;                       y++;                     }                  },                 p++;               } 
             }e	         }g     }r   /*!     Initialize Standard Colormap.    */=   if ((image->class == DirectClass) || (image->colors > 256))      {n       /**         Demote DirectClass to PseudoClass.       */B       QuantizeImage(image,256,8,image_info->dither,RGBColorspace);       SyncImage(image);      }mJ   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info);a(   pixel_info.annotate_context=(GC) NULL;)   pixel_info.highlight_context=(GC) NULL;i&   pixel_info.widget_context=(GC) NULL;   /*%     Initialize window info structure.|   */   window_info.id=(Window) NULL; O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,t!     &resource_info,&window_info);f.   p=image->filename+strlen(image->filename)-1;2   while ((p > image->filename) && (*(p-1) != '/'))     p--;   window_info.name=p;;#   window_info.width=image->columns;i!   window_info.height=image->rows;gP   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);"   window_info.shared_memory=False;   /*     Initialize X image.    */M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,N     image->rows);    if (status == False)     {=>       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);4       PrematureExit("Unable to make X image",image);     }p   /*     Intialize XPM attributes.i   */H   xpm_attributes.valuemask=XpmColormap | XpmDepth | XpmSize | XpmVisual;,   xpm_attributes.visual=visual_info->visual;*   xpm_attributes.depth=visual_info->depth;-   xpm_attributes.colormap=map_info->colormap;l&   xpm_attributes.width=image->columns;$   xpm_attributes.height=image->rows;I   status=XpmCreateBufferFromImage(display,&xpm_buffer,window_info.ximage, !     matte_image,&xpm_attributes);=   /*     Free X resources.g   */%   if (matte_image != (XImage *) NULL)D     XDestroyImage(matte_image);;%   XpmFreeAttributes(&xpm_attributes);pO   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,i!     &resource_info,&window_info);    if (status != XpmSuccess)m1     PrematureExit("Unable to write image",image);_   /*     Write XPM image.   */F   (void) fwrite((char *) xpm_buffer,1,strlen(xpm_buffer),image->file);   free((char *) xpm_buffer);   CloseImage(image);   return(True);s }  #elsei3 static unsigned int WriteXPMImage(image_info,image)g	 ImageInfoe   *image_info;   Imagec	   *image;s {e   unsigned int     status;*  :   Warning("XPM library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %)O %                                                                             %gO %                                                                             % O %   W r i t e Y U V I m a g e                                                 % O %                                                                             %;O %                                                                             %eO %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+ % F %  Function WriteYUVImage writes an image to a file in the digital YUV %  (CCIR 601 4:1:1) format.Q %t. %  The format of the WriteYUVImage routine is: % - %      status=WriteYUVImage(image_info,image); % + %  A description of each parameter follows.  % J %    o status: Function WriteYUVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %= %a */3 static unsigned int WriteYUVImage(image_info,image) 	 ImageInfo    *image_info;   Image[	   *image;  {    Image      *reduced_image;      register int     i,     j;     register RunlengthPacket     *p;s     /*     Open output image file.(   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize Y channel.    */+   RGBTransformImage(image,YCbCrColorspace);m   p=image->pixels;$   for (i=0; i < image->packets; i++)   {"(     for (j=0; j <= (int) p->length; j++)2       (void) fputc(DownScale(p->red),image->file);     p++;   }    /*     Scale image.   */   image->orphan=True; #   reduced_image=ReduceImage(image);    image->orphan=False;&   if (reduced_image == (Image *) NULL)1     PrematureExit("Unable to scale image",image);o   /*     Initialize U channel.f   */   p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   {i(     for (j=0; j <= (int) p->length; j++)4       (void) fputc(DownScale(p->green),image->file);     p++;   }    /*     Initialize V channel.%   */   p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)3       (void) fputc(DownScale(p->blue),image->file);      p++;   }    DestroyImage(reduced_image);+   TransformRGBImage(image,YCbCrColorspace);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   W r i t e Y U V 3 I m a g e                                               % O %                                                                             %rO %                                                                             %PO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %lG %  Function WriteYUV3Image writes an image to a file in the digital YUV M %  (CCIR 601 4:1:1) format.  This function differs from WriteYUVImage in thatrK %  it write the Y, U, and V planes to separate files (image.Y, image.U, andt %  image.V). %r/ %  The format of the WriteYUV3Image routine is:a %i. %      status=WriteYUV3Image(image_info,image) % + %  A description of each parameter follows.e %tK %    o status: Function WriteYUV3Image return True if the image is written.pK %      False is returned is there is a memory shortage or if the image file( %      fails to write. %rA %    o image_info: Specifies a pointer to an ImageInfo structure.e %s. %    o image:  A pointer to a Image structure. %k %P */4 static unsigned int WriteYUV3Image(image_info,image)	 ImageInfoa   *image_info;   Image 	   *image;a {o   char     filename[MaxTextLength];     Imagef     *reduced_image;k     register int     i,     j;     register RunlengthPacket     *p;>     /*     Open output image file.y   */*   (void) strcpy(filename,image->filename);'   if (strcmp(image->filename,"-") != 0)i(     (void) strcat(image->filename,".Y");   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)>/     PrematureExit("Unable to open file",image);l   /*     Write Y channel.   */+   RGBTransformImage(image,YCbCrColorspace);'   p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)2       (void) fputc(DownScale(p->red),image->file);     p++;   }c   CloseImage(image);   /*     Scale image.   */   image->orphan=True;>#   reduced_image=ReduceImage(image);'   image->orphan=False;&   if (reduced_image == (Image *) NULL)2     PrematureExit("Unable to reduce image",image);   /*     Write U channel.   */2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0)r0     (void) strcat(reduced_image->filename,".U");    OpenImage(reduced_image,"wb");+   if (reduced_image->file == (FILE *) NULL)      {e"       DestroyImage(reduced_image);9       PrematureExit("Unable to open file",reduced_image);=     }    p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   {n(     for (j=0; j <= (int) p->length; j++)<       (void) fputc(DownScale(p->green),reduced_image->file);     p++;   }t   CloseImage(reduced_image);   /*     Write V channel.   */2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0)o0     (void) strcat(reduced_image->filename,".V");    OpenImage(reduced_image,"wb");+   if (reduced_image->file == (FILE *) NULL)      { "       DestroyImage(reduced_image);9       PrematureExit("Unable to open file",reduced_image);i     }    p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++);       (void) fputc(DownScale(p->blue),reduced_image->file);      p++;   }a   CloseImage(reduced_image);   DestroyImage(reduced_image);+   TransformRGBImage(image,YCbCrColorspace);P+   (void) sprintf(image->filename,filename);a   return(True);a }B   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             %5O %                                                                             % O %                                                                             % O %   W r i t e X W D I m a g e                                                 %'O %                                                                             % O %                                                                             %oO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %iD %  Function WriteXWDImage writes an image to a file in X window dump %  rasterfile format.  % . %  The format of the WriteXWDImage routine is: % - %      status=WriteXWDImage(image_info,image)i %%+ %  A description of each parameter follows.  % J %    o status: Function WriteXWDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %=A %    o image_info: Specifies a pointer to an ImageInfo structure.  %a. %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteXWDImage(image_info,image)(	 ImageInfoe   *image_info;   Imagei	   *image;  {    inte     x;     register int     i,     j,     k;     register RunlengthPacket     *p;      unsigned int     bits_per_pixel,*     bytes_per_line,g     scanline_pad;      unsigned longi     lsb_first;     XWDFileHeaderc     xwd_header;      /*     Open output image file.)   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize XWD file header.h   */@   xwd_header.header_size=sz_XWDheader+strlen(image->filename)+1;;   xwd_header.file_version=(unsigned long) XWD_FILE_VERSION;l3   xwd_header.pixmap_format=(unsigned long) ZPixmap;))   xwd_header.pixmap_depth=(unsigned long)-+     (image->class == DirectClass ? 24 : 8);f9   xwd_header.pixmap_width=(unsigned long) image->columns;c7   xwd_header.pixmap_height=(unsigned long) image->rows;c'   xwd_header.xoffset=(unsigned long) 0; 1   xwd_header.byte_order=(unsigned long) MSBFirst; P   xwd_header.bitmap_unit=(unsigned long) (image->class == DirectClass ? 32 : 8);7   xwd_header.bitmap_bit_order=(unsigned long) MSBFirst; O   xwd_header.bitmap_pad=(unsigned long) (image->class == DirectClass ? 32 : 8); 8   bits_per_pixel=(image->class == DirectClass ? 24 : 8);;   xwd_header.bits_per_pixel=(unsigned long) bits_per_pixel; ?   bytes_per_line=(unsigned long) ((((xwd_header.bits_per_pixel* :     xwd_header.pixmap_width)+((xwd_header.bitmap_pad)-1))/=     (xwd_header.bitmap_pad))*((xwd_header.bitmap_pad) >> 3)); ;   xwd_header.bytes_per_line=(unsigned long) bytes_per_line; )   xwd_header.visual_class=(unsigned long) >     (image->class == DirectClass ? DirectColor : PseudoColor);%   xwd_header.red_mask=(unsigned long)%1     (image->class == DirectClass ? 0xff0000 : 0); '   xwd_header.green_mask=(unsigned long) /     (image->class == DirectClass ? 0xff00 : 0);fP   xwd_header.blue_mask=(unsigned long) (image->class == DirectClass ? 0xff : 0);)   xwd_header.bits_per_rgb=(unsigned long)s+     (image->class == DirectClass ? 24 : 8);o-   xwd_header.colormap_entries=(unsigned long) 8     (image->class == DirectClass ? 256 : image->colors);G   xwd_header.ncolors=(image->class == DirectClass ? 0 : image->colors);r9   xwd_header.window_width=(unsigned long) image->columns;l7   xwd_header.window_height=(unsigned long) image->rows;n   xwd_header.window_x=0;   xwd_header.window_y=0;/   xwd_header.window_bdrwidth=(unsigned long) 0;    /*     Write XWD header.e   */   lsb_first=1;   if (*(char *) &lsb_first) ?     MSBFirstOrderLong((char *) &xwd_header,sizeof(xwd_header));rA   (void) fwrite((char *) &xwd_header,sz_XWDheader,1,image->file);sE   (void) fwrite((char *) image->filename,1,strlen(image->filename)+1,y     image->file);e"   if (image->class == PseudoClass)     {%       XColor         *colors;         XWDColor         color;         /*         Dump colormap to file.       */=       colors=(XColor *) malloc(image->colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)9         PrematureExit("Unable to allocate memory",image);t'       for (i=0; i < image->colors; i++)        {%         colors[i].pixel=i;7         colors[i].red=XUpScale(image->colormap[i].red);d;         colors[i].green=XUpScale(image->colormap[i].green);%9         colors[i].blue=XUpScale(image->colormap[i].blue);a1         colors[i].flags=DoRed | DoGreen | DoBlue;c         colors[i].pad=0;!         if (*(char *) &lsb_first)            { F             MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(long));H             MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(short));           }l       } '       for (i=0; i < image->colors; i++)i       {b$         color.pixel=colors[i].pixel;          color.red=colors[i].red;$         color.green=colors[i].green;"         color.blue=colors[i].blue;$         color.flags=colors[i].flags;A         (void) fwrite((char *) &color,sz_XWDColor,1,image->file);C       }e       free((char *) colors);     }c   /*&     Convert MIFF to XWD raster pixels.   */   scanline_pad=(unsigned int) <     (bytes_per_line-((image->columns*bits_per_pixel) >> 3));   x=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     { &       if (image->class == PseudoClass)+         (void) fputc(p->index,image->file);m
       else	         { 6           (void) fputc(DownScale(p->red),image->file);8           (void) fputc(DownScale(p->green),image->file);7           (void) fputc(DownScale(p->blue),image->file); 	         } 
       x++;       if (x == image->columns)	         {%*           for (k=0; k < scanline_pad; k++)(             (void) fputc(0,image->file);           x=0;	         }      }r     p++;   }%   CloseImage(image);   return(True);  }% l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %.O %                                                                             % O %                                                                             %cO %   W r i t e I m a g e                                                       %,O %                                                                             % O %                                                                             %sO %                                                                             %,O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function WriteImage writes an image to a file.  You can specify aJ %  particular image format by prefixing the file with the image type and aI %  colon (i.e. ps:image) or specify the image type as the filename suffix  %  (i.e. image.ps).x % + %  The format of the WriteImage routine is:  %%* %      status=WriteImage(image_info,image) % + %  A description of each parameter follows:  % G %    o status: Function WriteImage return True if the image is written.cK %      False is returned is there is a memory shortage or if the image file  %      fails to write. %uA %    o image_info: Specifies a pointer to an ImageInfo structure.  %m- %    o image: A pointer to a Image structure.b %p %l */) unsigned int WriteImage(image_info,image) 	 ImageInfoi   *image_info;   Image 	   *image;  {    unsigned int     status;d     /*6     Call appropriate image writer based on image type.   */6   (void) strcpy(image_info->filename,image->filename);2   (void) strcpy(image_info->magick,image->magick);   SetImageMagick(image_info); 6   (void) strcpy(image->filename,image_info->filename);2   (void) strcpy(image->magick,image_info->magick);   switch (*image_info->magick)   {,
     case 'A':i     {n-       status=WriteAVSImage(image_info,image);n       break;     } 
     case 'B':o     {o0       if (strcmp(image_info->magick,"BIE") == 0)0         status=WriteJBIGImage(image_info,image);
       else/         status=WriteBMPImage(image_info,image);e       break;     }c
     case 'C':"     { .       status=WriteCMYKImage(image_info,image);       break;     }{
     case 'E':c     {i,       status=WritePSImage(image_info,image);       break;     }1
     case 'F':,     { 0       if (strcmp(image_info->magick,"FAX") == 0)/         status=WriteFAXImage(image_info,image);e
       else0         status=WriteFITSImage(image_info,image);       break;     } 
     case 'G':e     { 0       if (strcmp(image_info->magick,"GIF") == 0)/         status=WriteGIFImage(image_info,image);a
       else4         if (strcmp(image_info->magick,"GIF87") == 0)1           status=WriteGIFImage(image_info,image);          else5           if (strcmp(image_info->magick,"GRAY") == 0)x4             status=WriteGRAYImage(image_info,image);           else3             status=WriteFAXImage(image_info,image);        break;     } 
     case 'H':0     { 0       if (strcmp(image_info->magick,"HDF") == 0)/         status=WriteHDFImage(image_info,image);e
       else5         status=WriteHISTOGRAMImage(image_info,image);t       break;     } 
     case 'J':      {r1       if (strcmp(image_info->magick,"JBIG") == 0) 0         status=WriteJBIGImage(image_info,image);
       else0         status=WriteJPEGImage(image_info,image);       break;     }"
     case 'L':/     {c.       status=WriteLOGOImage(image_info,image);       break;     } 
     case 'M':c     { 0       if (strcmp(image_info->magick,"MAP") == 0)/         status=WriteMAPImage(image_info,image);c
       else4         if (strcmp(image_info->magick,"MATTE") == 0)3           status=WriteMATTEImage(image_info,image);          else5           if (strcmp(image_info->magick,"MIFF") == 0),4             status=WriteMIFFImage(image_info,image);           else;             if ((strcmp(image_info->magick,"MPEG") == 0) || 8                 (strcmp(image_info->magick,"MPG") == 0))6               status=WriteMPEGImage(image_info,image);             else5               status=WriteMTVImage(image_info,image);"       break;     }"
     case 'N':n       break;
     case 'P':/     {I0       if (strcmp(image_info->magick,"PCD") == 0)/         status=WritePCDImage(image_info,image); 
       else2         if (strcmp(image_info->magick,"PCX") == 0)1           status=WritePCXImage(image_info,image);e         else4           if (strcmp(image_info->magick,"PDF") == 0)3             status=WritePDFImage(image_info,image);m           else7             if (strcmp(image_info->magick,"PICT") == 0)%6               status=WritePICTImage(image_info,image);             else7               if (strcmp(image_info->magick,"PM") == 0)f7                 status=WriteXPMImage(image_info,image);a               else:                 if (strcmp(image_info->magick,"PNG") == 0)9                   status=WritePNGImage(image_info,image);C                 else;                   if (strcmp(image_info->magick,"PS") == 0)d:                     status=WritePSImage(image_info,image);                   else>                     if (strcmp(image_info->magick,"PS2") == 0)=                       status=WritePS2Image(image_info,image);                      else=                       status=WritePNMImage(image_info,image);c       break;     }d
     case 'R':      {k0       if (strcmp(image_info->magick,"RAD") == 0)4         status=WriteRADIANCEImage(image_info,image);
       else2         if (strcmp(image_info->magick,"RAS") == 0)1           status=WriteSUNImage(image_info,image);          else8           if ((strcmp(image_info->magick,"RGB") == 0) ||7               (strcmp(image_info->magick,"RGBA") == 0)) 3             status=WriteRGBImage(image_info,image);o           else3             status=WriteRLEImage(image_info,image);n       break;     }*
     case 'S':u     { 0       if (strcmp(image_info->magick,"SGI") == 0)/         status=WriteSGIImage(image_info,image);a
       else/         status=WriteSUNImage(image_info,image);P       break;     }/
     case 'T':m     {b1       if (strcmp(image_info->magick,"TEXT") == 0)i0         status=WriteTEXTImage(image_info,image);
       else2         if (strcmp(image_info->magick,"TGA") == 0)3           status=WriteTARGAImage(image_info,image);n         else8           if ((strcmp(image_info->magick,"TIF") == 0) ||7               (strcmp(image_info->magick,"TIFF") == 0))i4             status=WriteTIFFImage(image_info,image);           else4             status=WriteTILEImage(image_info,image);       break;     }P
     case 'V':a     {-2       if (strcmp(image_info->magick,"VICAR") == 0)1         status=WriteVICARImage(image_info,image);h
       else2         if (strcmp(image_info->magick,"VID") == 0)2           status=WriteMIFFImage(image_info,image);         else2           status=WriteVIFFImage(image_info,image);       break;     }_
     case 'X':p     {t.       if (strcmp(image_info->magick,"X") == 0)-         status=WriteXImage(image_info,image);t
       else2         if (strcmp(image_info->magick,"XBM") == 0)1           status=WriteXBMImage(image_info,image);_         else3           if (strcmp(image_info->magick,"XC") == 0) 2             status=WriteXCImage(image_info,image);           else6             if (strcmp(image_info->magick,"XPM") == 0)5               status=WriteXPMImage(image_info,image);              else7               if (strcmp(image_info->magick,"XV") == 0)f8                 status=WriteVIFFImage(image_info,image);               else7                 status=WriteXWDImage(image_info,image);h       break;     })
     case 'Y':      { 0       if (strcmp(image_info->magick,"YUV") == 0)/         status=WriteYUVImage(image_info,image);t
       else0         status=WriteYUV3Image(image_info,image);       break;     }s     default:.       status=WriteMIFFImage(image_info,image);   }e   if (image->status)     {_G       Warning("An error has occurred writing to file",image->filename);a       return(False);     }t   return(status);s }f