 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                   D   D  E      C      O   O  D   D  E                      % O %                   D   D  EEE    C      O   O  D   D  EEE                    % O %                   D   D  E      C      O   O  D   D  E                      % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Read Image Formats                   % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h" #include "XWDFile.h"   /*   Define declarations. */& #define PrematureExit(message,image) \ { \ %   Warning(message,image->filename); \    DestroyImages(image); \    return((Image *) NULL); \  }    /*   Forward declarations.  */ Image %   *ReadImage _Declare((ImageInfo *));    static Image)   *ReadMIFFImage _Declare((ImageInfo *)), (   *ReadPNMImage _Declare((ImageInfo *)),'   *ReadXCImage _Declare((ImageInfo *));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d A V S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadAVSImage reads a AVS X image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadAVSImage routine is:  % % %      image=ReadAVSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadAVSImage returns a pointer to the image after N %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadAVSImage(image_info)	 ImageInfo    *image_info; {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      Image      *image;   	   Quantum 	     blue, 
     green,     red;     register int     i;     register RunlengthPacket     *q;      unsigned int     packets,     status;      unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read AVS image.    */J   status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),     image->file);    if (status == False)0     PrematureExit("Not a AVS image file",image);   do   {      /*!       Initialize image structure.      */     image->matte=True;$     image->columns=avs_header.width;"     image->rows=avs_header.height;     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert AVS raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength; 4     for (i=0; i < (image->columns*image->rows); i++)     { &       index=Opaque-fgetc(image->file);&       red=UpScale(fgetc(image->file));(       green=UpScale(fgetc(image->file));'       blue=UpScale(fgetc(image->file)); H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;/               image->pixels=(RunlengthPacket *) P                 realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));<               if (image->pixels == (RunlengthPacket *) NULL)A                 PrematureExit("Unable to allocate memory",image); /               q=image->pixels+image->packets-1; 
             }            q->red=red;            q->green=green;            q->blue=blue;            q->index=index;            q->length=0;	         }      } %     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); L     status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),       image->file);      if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d B M P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadBMPImage reads a Microsoft Windows bitmap image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadBMPImage routine is:  % % %      image=ReadBMPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadBMPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadBMPImage(image_info)	 ImageInfo    *image_info; {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *bmp_data,     *bmp_pixels,     magick[12];      unsigned int     bytes_per_line,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a BMP file.   */3   status=ReadData((char *) magick,1,2,image->file);    do   {      /*       Verify BMP identifier.     */D     if ((status == False) || (strncmp((char *) magick,"BM",2) != 0))2       PrematureExit("Not a BMP image file",image);7     bmp_header.file_size=LSBFirstReadLong(image->file); :     bmp_header.reserved[0]=LSBFirstReadShort(image->file);:     bmp_header.reserved[1]=LSBFirstReadShort(image->file);9     bmp_header.offset_bits=LSBFirstReadLong(image->file); 2     bmp_header.size=LSBFirstReadLong(image->file);     if (bmp_header.size == 12)       { 
         /*           OS/2 BMP image file.
         */H         bmp_header.width=(unsigned long) LSBFirstReadShort(image->file);I         bmp_header.height=(unsigned long) LSBFirstReadShort(image->file); 9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);#         bmp_header.number_colors=0; !         bmp_header.compression=0;           bmp_header.image_size=0;       }      else       { 
         /*+           Microsoft Windows BMP image file. 
         */7         bmp_header.width=LSBFirstReadLong(image->file); 8         bmp_header.height=LSBFirstReadLong(image->file);9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);=         bmp_header.compression=LSBFirstReadLong(image->file); <         bmp_header.image_size=LSBFirstReadLong(image->file);:         bmp_header.x_pixels=LSBFirstReadLong(image->file);:         bmp_header.y_pixels=LSBFirstReadLong(image->file);?         bmp_header.number_colors=LSBFirstReadLong(image->file); B         bmp_header.colors_important=LSBFirstReadLong(image->file);6         for (i=0; i < ((int) bmp_header.size-40); i++)$           (void) fgetc(image->file);       } "     if (bmp_header.bit_count < 24)       {          unsigned char            *bmp_colormap;           unsigned int           packet_size;  
         /*#           Read BMP raster colormap. 
         */!         image->class=PseudoClass; 0         image->colors=1 << bmp_header.bit_count;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         bmp_colormap=(unsigned char *)8           malloc(4*image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (bmp_colormap == (unsigned char *) NULL)) ;           PrematureExit("Unable to allocate memory",image);          packet_size=4;"         if (bmp_header.size == 12)           packet_size=3;H         (void) ReadData((char *) bmp_colormap,packet_size,image->colors,           image->file);          p=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { 0           image->colormap[i].blue=UpScale(*p++);1           image->colormap[i].green=UpScale(*p++); /           image->colormap[i].red=UpScale(*p++); $           if (bmp_header.size != 12)             p++;	         } $         free((char *) bmp_colormap);       }      /*       Read image data.     */#     if (bmp_header.image_size == 0)        bmp_header.image_size=L         ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;     bmp_data=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));+     if (bmp_data == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image); M     status=ReadData((char *) bmp_data,1,(unsigned int) bmp_header.image_size,        image->file);      if (status == False)7       PrematureExit("Unable to read image data",image);      bmp_pixels=bmp_data;$     if (bmp_header.compression != 0)       {          unsigned int           packets;  
         /*3           Convert run-length encoded raster pixels. 
         */         packets=N           ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;(         if (bmp_header.compression == 2)           packets<<=1;K         bmp_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); 1         if (bmp_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); 2         (void) BMPDecodeImage(bmp_data,bmp_pixels,P           (unsigned int) bmp_header.compression,(unsigned int) bmp_header.width,,           (unsigned int) bmp_header.height);(         if (bmp_header.compression == 2)#           bmp_header.bit_count<<=1;           free((char *) bmp_data);       }      /*!       Initialize image structure.      */$     image->columns=bmp_header.width;"     image->rows=bmp_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert BMP raster image to runlength-encoded packets.     */C     bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; !     switch (bmp_header.bit_count)      { 
       case 1:        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-7); x+=8)            { '             for (bit=0; bit < 8; bit++) 
             { <               q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);               q->length=0;               q++;
             }              p++;           } (           if ((image->columns % 8) != 0)
             { <               for (bit=0; bit < (image->columns % 8); bit++)               { >                 q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);                 q->length=0;                 q++;               }                p++;
             } 	         }          SyncImage(image);          break;       } 
       case 4:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-1); x+=2)            { %             q->index=(*p >> 4) & 0xf;              q->length=0;             q++;              q->index=(*p) & 0xf;             q->length=0;             p++;             q++;           } (           if ((image->columns % 2) != 0)
             { '               q->index=(*p >> 4) & 0xf;                q->length=0;               q++;               p++;
             } 	         }          SyncImage(image);           CompressColormap(image);         break;       } 
       case 8:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */(         if (bmp_header.compression == 1)(           bytes_per_line=image->columns;*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } 	         }          SyncImage(image);           CompressColormap(image);         break;       }        case 24:       { 
         /*J           Convert DirectColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           { B             q->index=(unsigned short) (image->matte ? (*p++) : 0);"             q->blue=UpScale(*p++);#             q->green=UpScale(*p++); !             q->red=UpScale(*p++);              q->length=0;             q++;           } 	         }          break;       }        default:4         PrematureExit("Not a BMP image file",image);     }      free((char *) bmp_pixels);     CompressImage(image);      /*       Proceed to next image.     */5     status=ReadData((char *) magick,1,2,image->file); C     if ((status == True) && (strncmp((char *) magick,"BM",2) == 0))        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } G   } while ((status == True) && (strncmp((char *) magick,"BM",2) == 0)); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d C M Y K I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ReadCMYKImage reads an image of raw cyan, magenta, yellow, andM %  black bytes and returns it.  It allocates the memory necessary for the new : %  Image structure and returns a pointer to the new image. % . %  The format of the ReadCMYKImage routine is: % & %      image=ReadCMYKImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadCMYKImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadCMYKImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *cmyk_pixels;      unsigned int
     black,	     cyan,      height,      magenta,     yellow, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;O   cmyk_pixels=(unsigned char *) malloc(4*image->packets*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if ((cmyk_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */E   (void) ReadData((char *) cmyk_pixels,4,image->packets,image->file);    p=cmyk_pixels;    switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->red=UpScale(*p++);          q->green=UpScale(*p++);          q->blue=UpScale(*p++);         q->index=UpScale(*p++);          q->length=0;         q++;       }        break;     }      case LineInterlace:      {        /*K         Line interlacing:  CCC...MMM...YYY...KKK...CCC...MMM...YYY...KKK...        */%       for (y=0; y < image->rows; y++)        { )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {            q->red=UpScale(*p++);            q->length=0;           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { !           q->green=UpScale(*p++);            q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {             q->blue=UpScale(*p++);           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { !           q->index=UpScale(*p++);            q++;	         }        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->red=UpScale(*p++);          q->length=0;         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->green=UpScale(*p++);          q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->blue=UpScale(*p++);         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->index=UpScale(*p++);          q++;       }        break;     }    }    /*     Transform image to CMYK.   */   q=image->pixels;$   for (i=0; i < image->packets; i++)   {      cyan=q->red;     magenta=q->green;      yellow=q->blue;      black=q->index;      if ((cyan+black) > MaxRGB)       q->red=0;      else!       q->red=MaxRGB-(cyan+black); !     if ((magenta+black) > MaxRGB)        q->green=0;      else&       q->green=MaxRGB-(magenta+black);      if ((yellow+black) > MaxRGB)       q->blue=0;     else$       q->blue=MaxRGB-(yellow+black);     q->index=0;      q->length=0;     q++;   }    free((char *) cmyk_pixels);    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d F A X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadFAXImage reads a Group 3 FAX image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadFAXImage routine is:  % % %      image=ReadFAXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadFAXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadFAXImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image structure.    */   image->class=PseudoClass;    image->columns=1728;   image->rows=2156; <   image->packets=Max((image->columns*image->rows+8) >> 4,1);#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Monochrome colormap.   */    image->colormap[0].red=MaxRGB;"   image->colormap[0].green=MaxRGB;!   image->colormap[0].blue=MaxRGB;    image->colormap[1].red=0;    image->colormap[1].green=0;    image->colormap[1].blue=0;#   status=HuffmanDecodeImage(image);    if (status == False)5     PrematureExit("Unable to read image data",image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d F I T S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadFITSImage reads a FITS image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadFITSImage routine is: % & %      image=ReadFITSImage(image_info) % + %  A description of each parameter follows:  % I %    o image: Function ReadFITSImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */' static Image *ReadFITSImage(image_info) 	 ImageInfo    *image_info; {    typedef struct _FITSHeader   {      unsigned int
       simple;        int        bits_per_pixel;        unsigned int       number_of_axis,        columns,       rows,        depth;  
     double       min_data,        max_data,        zero,        scale;   } FITSHeader;      char     keyword[MaxTextLength],      value[MaxTextLength];      double
     pixel,
     scale,     scaled_pixel;      FITSHeader     fits_header;     Image      *image;      int      packet_size;     long
     count,     quantum;     register int     c,     i,     j;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *fits_pixels;      unsigned int     status,      value_expected;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image header.   */   fits_header.simple=False;    fits_header.bits_per_pixel=8;    fits_header.columns=1;   fits_header.rows=1;    fits_header.depth=1;   fits_header.min_data=0.0;    fits_header.max_data=0.0;    fits_header.zero=0.0;    fits_header.scale=1.0;   /*     Decode image header.   */   c=fgetc(image->file); 
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      } 
   for ( ; ; )    {      if (!isalnum(c))       {          c=fgetc(image->file);          count++;       }      else       {          register char 
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;+         } while (isalnum(c) || (c == '_'));          *p='\0';'         if (strcmp(keyword,"END") == 0)            break;         value_expected=False; (         while (isspace(c) || (c == '='))	         {            if (c == '=')               value_expected=True;           c=fgetc(image->file);            count++;	         } $         if (value_expected == False)           continue;          p=value;D         while (isalnum(c) || (c == '-') || (c == '+') || (c == '.'))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */*         if (strcmp(keyword,"SIMPLE") == 0)@           fits_header.simple=(*value == 'T') || (*value == 't');*         if (strcmp(keyword,"BITPIX") == 0)@           fits_header.bits_per_pixel=(unsigned int) atoi(value);)         if (strcmp(keyword,"NAXIS") == 0) @           fits_header.number_of_axis=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS1") == 0)9           fits_header.columns=(unsigned int) atoi(value); *         if (strcmp(keyword,"NAXIS2") == 0)6           fits_header.rows=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS3") == 0)7           fits_header.depth=(unsigned int) atoi(value); +         if (strcmp(keyword,"DATAMAX") == 0) +           fits_header.max_data=atof(value); +         if (strcmp(keyword,"DATAMIN") == 0) +           fits_header.min_data=atof(value); )         if (strcmp(keyword,"BZERO") == 0) '           fits_header.zero=atof(value); *         if (strcmp(keyword,"BSCALE") == 0)(           fits_header.scale=atof(value);       }      while (isspace(c))     {        c=fgetc(image->file);        count++;     }    }    while (count > 2880)     count-=2880;    for ( ; count < 2880; count++)     (void) fgetc(image->file);   /*6     Verify that required image information is defined.   */B   if ((!fits_header.simple) || (fits_header.number_of_axis < 1) ||)       (fits_header.number_of_axis > 3) || 2       (fits_header.columns*fits_header.rows) == 0)4     PrematureExit("image type not supported",image);   /*     Create linear colormap.    */%   image->columns=fits_header.columns;    image->rows=fits_header.rows;    image->class=PseudoClass;    image->colors=MaxRGB+1; L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)/     PrematureExit("Unable to open file",image); #   for (i=0; i < image->colors; i++)    { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);    }    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); +   packet_size=fits_header.bits_per_pixel/8;    if (packet_size < 0)     packet_size=(-packet_size);    fits_pixels=(unsigned char *) =     malloc(image->packets*packet_size*sizeof(unsigned char)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||.       (fits_pixels == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*5     Convert FITS pixels to runlength-encoded packets.    */B   status=ReadData((char *) fits_pixels,(unsigned int) packet_size,      image->packets,image->file);   if (status == False)?     Warning("Insufficient image data in file",image->filename); E   if ((fits_header.min_data == 0.0) && (fits_header.max_data == 0.0))      {        /*0         Determine minimum and maximum intensity.       */       p=fits_pixels;       quantum=(*p++); )       for (j=0; j < (packet_size-1); j++) (         quantum=(quantum << 8) | (*p++);       pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum)); D       fits_header.min_data=pixel*fits_header.scale+fits_header.zero;D       fits_header.max_data=pixel*fits_header.scale+fits_header.zero;(       for (i=1; i < image->packets; i++)       {          quantum=(*p++); +         for (j=0; j < (packet_size-1); j++) *           quantum=(quantum << 8) | (*p++);         pixel=(double) quantum; .         if (fits_header.bits_per_pixel == -32)1           pixel=(double) (*((float *) &quantum)); >         scaled_pixel=pixel*fits_header.scale+fits_header.zero;0         if (scaled_pixel < fits_header.min_data),           fits_header.min_data=scaled_pixel;0         if (scaled_pixel > fits_header.max_data),           fits_header.max_data=scaled_pixel;       }      }    /*5     Convert FITS pixels to runlength-encoded packets.    */   scale=1.0;3   if (fits_header.min_data != fits_header.max_data) A     scale=(MaxRGB+1)/(fits_header.max_data-fits_header.min_data);    p=fits_pixels;   q=image->pixels;$   for (i=0; i < image->packets; i++)   {      quantum=(*p++); '     for (j=0; j < (packet_size-1); j++) &       quantum=(quantum << 8) | (*p++);     pixel=(double) quantum; *     if (fits_header.bits_per_pixel == -32)-       pixel=(double) (*((float *) &quantum));      scaled_pixel=scale* F       (pixel*fits_header.scale+fits_header.zero-fits_header.min_data);     while (scaled_pixel < 0)       scaled_pixel+=(MaxRGB+1); !     while (scaled_pixel > MaxRGB)        scaled_pixel-=(MaxRGB+1); +     q->index=(unsigned short) scaled_pixel;      q->length=0;     q++;   }    free((char *) fits_pixels);    SyncImage(image);    CompressColormap(image);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G I F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGIFImage reads a Compuserve Graphics image file and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % - %  The format of the ReadGIFImage routine is:  % % %      image=ReadGIFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadGIFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or %      an error occurs.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadGIFImage(image_info)	 ImageInfo    *image_info; { 5 #define BitSet(byte,bit)  (((byte) & (bit)) == (bit)) . #define LSBFirstOrder(x,y)  (((y) << 8) | (x))     Image      *image;      int      status,      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      short int      transparency_index;      unsigned char      c,     *global_colormap,      header[MaxTextLength],     magick[12];      unsigned int     global_colors,     image_count,     interlace,     local_colormap;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a GIF file.   */3   status=ReadData((char *) magick,1,6,image->file); 4   status|=ReadData((char *) header,1,7,image->file);H   if ((status == False) || ((strncmp((char *) magick,"GIF87",5) != 0) &&1       (strncmp((char *) magick,"GIF89",5) != 0))) 0     PrematureExit("Not a GIF image file",image);   global_colors=0;)   global_colormap=(unsigned char *) NULL;    if (BitSet(header[4],0x80))      {        /*         Read global colormap.        */0       global_colors=1 << ((header[4] & 0x07)+1);'       global_colormap=(unsigned char *) 6         malloc(3*global_colors*sizeof(unsigned char));4       if (global_colormap == (unsigned char *) NULL)B         PrematureExit("Unable to read image colormap file",image);L       (void) ReadData((char *) global_colormap,3,global_colors,image->file);     }    transparency_index=(-1);   image_count=0;
   for ( ; ; )    { 1     status=ReadData((char *) &c,1,1,image->file);      if (status == False)       break;     if (c == ';')        break;  /* terminator */     if (c == '!')        { 
         /*           GIF Extension block.
         */5         status=ReadData((char *) &c,1,1,image->file);          if (status == False)@           PrematureExit("Unable to read extention block",image);         switch (c)	         {            case 0xf9:           {              /*+               Transparency extension block.              */C             while (ReadDataBlock((char *) header,image->file) > 0); (             if ((header[0] & 0x01) == 1)+               transparency_index=header[3];              break;           }            case 0xfe:           {              int                length;                /*&               Comment extension block.             */             for ( ; ; ) 
             { @               length=ReadDataBlock((char *) header,image->file);               if (length <= 0)                 break;3               if (image->comments != (char *) NULL) J                 image->comments=(char *) realloc((char *) image->comments,C                   (strlen(image->comments)+length+1)*sizeof(char));                else                 { K                   image->comments=(char *) malloc((length+1)*sizeof(char)); 7                   if (image->comments != (char *) NULL) *                     *image->comments='\0';                 } 3               if (image->comments == (char *) NULL) A                 PrematureExit("Unable to allocate memory",image); "               header[length]='\0';=               (void) strcat(image->comments,(char *) header); 
             }              break;           }            default:           { C             while (ReadDataBlock((char *) header,image->file) > 0);              break;           } 	         }        }      if (c != ',')        continue;      /*       Read image attributes.     */     if (image_count != 0)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }      image_count++;5     status=ReadData((char *) header,1,9,image->file);      if (status == False)B       PrematureExit("Unable to read left/top/width/height",image);%     interlace=BitSet(header[8],0x40); *     local_colormap=BitSet(header[8],0x80);     /*       Allocate image.      */6     image->columns=LSBFirstOrder(header[4],header[5]);3     image->rows=LSBFirstOrder(header[6],header[7]); .     image->packets=image->columns*image->rows;     if (image->packets == 0)-       PrematureExit("image size is 0",image); 2     if (image->pixels != (RunlengthPacket *) NULL)#       free((char *) image->pixels); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*       Inititialize colormap.     */     image->class=PseudoClass; P     image->colors=!local_colormap ? global_colors : 1 << ((header[8] & 0x07)+1);N     image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));0     if (image->colormap == (ColorPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      if (!local_colormap)       { 
         /*           Use global colormap.
         */         p=global_colormap;)         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }        }      else       {          unsigned char            *colormap;  
         /*           Read local colormap.
         */"         colormap=(unsigned char *)8           malloc(3*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); G         (void) ReadData((char *) colormap,3,image->colors,image->file);          p=colormap; )         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }           free((char *) colormap);       }      /*       Decode image.      */!     status=LZWDecodeImage(image);      if (interlace)       { 
         Image            *interlaced_image;           int            pass;             register RunlengthPacket
           *p;            static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */,         image_info->interlace=LineInterlace;         image->orphan=True; J         interlaced_image=CopyImage(image,image->columns,image->rows,True);         image->orphan=False;/         if (interlaced_image == (Image *) NULL) ;           PrematureExit("Unable to allocate memory",image); #         p=interlaced_image->pixels;          q=image->pixels;&         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             q=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } '         DestroyImage(interlaced_image);        }       if (transparency_index >= 0)       { 
         /*           Create matte channel. 
         */         q=image->pixels;*         for (i=0; i < image->packets; i++)	         { >           if (q->index != (unsigned short) transparency_index)             q->index=Opaque;           else!             q->index=Transparent;            q++;	         }           transparency_index=(-1);!         image->class=DirectClass;          image->matte=True;       }      if (status == False)       { 5         Warning("Corrupt GIF image",image->filename);          break;       }      CompressImage(image);    } 0   if (global_colormap != (unsigned char *) NULL)#     free((char *) global_colormap); 0   if (image->pixels == (RunlengthPacket *) NULL)-     PrematureExit("Corrupt GIF image",image); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G R A Y I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGRAYImage reads an image of raw grayscale bytes and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % . %  The format of the ReadGRAYImage routine is: % & %      image=ReadGRAYImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadGRAYImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadGRAYImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      unsigned int     height,      packets,
     width;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Create linear colormap.    */   image->class=PseudoClass;    image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); #   for (i=0; i < image->colors; i++)    { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);    }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   image->columns=width;    image->rows=height;    image->packets=0; 5   packets=Max((image->columns*image->rows+4) >> 3,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */   q=image->pixels;   q->length=MaxRunlength; 2   for (i=0; i < (image->columns*image->rows); i++)   { $     index=fgetc(image->file) & 0xff;@     if ((index == q->index) && ((int) q->length < MaxRunlength))       q->length++;     else       {           if (image->packets != 0)           q++;         image->packets++; &         if (image->packets == packets)           {              packets<<=1;-             image->pixels=(RunlengthPacket *) N               realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));:             if (image->pixels == (RunlengthPacket *) NULL)?               PrematureExit("Unable to allocate memory",image); -             q=image->pixels+image->packets-1;            }          q->index=index;          q->length=0;       }    } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    SyncImage(image);    CompressColormap(image);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H D F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadHDFImage reads a Hierarchical Data Format image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadHDFImage routine is:  % % %      image=ReadHDFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadHDFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasHDF & static Image *ReadHDFImage(image_info)	 ImageInfo    *image_info; {  #include "hdf.h"     Image      *image;      int      interlace,     is_palette,      status;      int32      height,      length, 
     width;     register int     i;     register unsigned char     *p;      register RunlengthPacket     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int
     class,     packet_size;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);   /*     Read HDF image.    */   class=DirectClass;@   status=DF24getdims(image->filename,&width,&height,&interlace);   if (status == -1)      {        class=PseudoClass;E       status=DFR8getdims(image->filename,&width,&height,&is_palette);      }    if (status == -1) I     PrematureExit("Image file or does not contain any image data",image);    do   {      /*!       Initialize image structure.      */     image->class=class;      image->columns=width;      image->rows=height; .     image->packets=image->columns*image->rows;     packet_size=1;$     if (image->class == DirectClass)       packet_size=3;      hdf_pixels=(unsigned char *)?       malloc(packet_size*image->packets*sizeof(unsigned char)); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 1     if ((hdf_pixels == (unsigned char *) NULL) || 4         (image->pixels == (RunlengthPacket *) NULL))7       PrematureExit("Unable to allocate memory",image);      q=image->pixels;$     if (image->class == PseudoClass)       {          unsigned char            *hdf_palette;   
         /*           Create colormap.
         */H         hdf_palette=(unsigned char *) malloc(768*sizeof(unsigned char));         image->colors=256;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));6         if ((hdf_palette == (unsigned char *) NULL) ||6             (image->colormap == (ColorPacket *) NULL));           PrematureExit("Unable to allocate memory",image); L         (void) DFR8getimage(image->filename,hdf_pixels,(int) image->columns,)           (int) image->rows,hdf_palette);           reference=DFR8lastref();
         /*L           Convert HDF raster image to PseudoClass runlength-encoded packets.
         */         p=hdf_palette;         if (is_palette) !           for (i=0; i < 256; i++)            { 1             image->colormap[i].red=UpScale(*p++); 3             image->colormap[i].green=UpScale(*p++); 2             image->colormap[i].blue=UpScale(*p++);           }          else+           for (i=0; i < image->colors; i++)            { /             image->colormap[i].red=(Quantum) i; 1             image->colormap[i].green=(Quantum) i; 0             image->colormap[i].blue=(Quantum) i;           } #         free((char *) hdf_palette);          p=hdf_pixels; *         for (i=0; i < image->packets; i++)	         {            q->index=(*p++);           q->length=0;           q++;	         }          SyncImage(image);        }      else       {          int            x,           y;  
         /*L           Convert HDF raster image to DirectClass runlength-encoded packets.
         */O         (void) DF24getimage(image->filename,(void *) hdf_pixels,image->columns,            image->rows);           reference=DF24lastref();         p=hdf_pixels; *         image_info->interlace=interlace+1;&         switch (image_info->interlace)	         {            case NoneInterlace:            default:           {              /*4               No interlacing:  RGBRGBRGBRGBRGBRGB...             */             q=image->pixels;.             for (i=0; i < image->packets; i++)
             { #               q->red=UpScale(*p++); %               q->green=UpScale(*p++); $               q->blue=UpScale(*p++);               q->index=0;                q->length=0;               q++;
             }              break;           }            case LineInterlace:            {              /*E               Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...              */+             for (y=0; y < image->rows; y++) 
             { /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { %                 q->red=UpScale(*p++);                  q->index=0;                  q->length=0;                 q++;               } /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { '                 q->green=UpScale(*p++);                  q++;               } /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { &                 q->blue=UpScale(*p++);                 q++;               } 
             }              break;           }            case PlaneInterlace:           {              /*=               Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...              */             q=image->pixels;.             for (i=0; i < image->packets; i++)
             { #               q->red=UpScale(*p++);                q->index=0;                q->length=0;               q++;
             }              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { %               q->green=UpScale(*p++);                q++;
             }              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { $               q->blue=UpScale(*p++);               q++;
             }              break;           } 	         }        } >     length=DFANgetlablen(image->filename,DFTAG_RIG,reference);     if (length > 0)        { 
         /*           Read the image label. 
         */         length+=MaxTextLength;1         image->label=malloc(length*sizeof(char)); *         if (image->label != (char *) NULL)P           DFANgetlabel(image->filename,DFTAG_RIG,reference,image->label,length);       } ?     length=DFANgetdesclen(image->filename,DFTAG_RIG,reference);      if (length > 0)        { 
         /*"           Read the image comments.
         */         length+=MaxTextLength;4         image->comments=malloc(length*sizeof(char));-         if (image->comments != (char *) NULL) J           DFANgetdesc(image->filename,DFTAG_RIG,reference,image->comments,             length);       }      free((char *) hdf_pixels);     CompressImage(image);      class=DirectClass;B     status=DF24getdims(image->filename,&width,&height,&interlace);     if (status == -1)        {          class=PseudoClass;G         status=DFR8getdims(image->filename,&width,&height,&is_palette);        }      if (status != -1)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }  #else & static Image *ReadHDFImage(image_info)	 ImageInfo    *image_info; { ?   Warning("HDF library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H I S T O G R A M I m a g e                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadHISTOGRAMImage reads a HISTOGRAM image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % 3 %  The format of the ReadHISTOGRAMImage routine is:  % + %      image=ReadHISTOGRAMImage(image_info)  % + %  A description of each parameter follows:  % O %    o image:  Function ReadHISTOGRAMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */, static Image *ReadHISTOGRAMImage(image_info)	 ImageInfo    *image_info; {    Image      *image;   "   image=ReadMIFFImage(image_info);   return(image); }    #ifdef HasJBIG #include "jbig.h"  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J B I G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadJBIGImage reads a JBIG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadJBIGImage routine is: % & %      image=ReadJBIGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJBIGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadJBIGImage(image_info) 	 ImageInfo    *image_info; {  #define MaxBufferSize  8192      Image      *image;      int      length,      status,      x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      register unsigned short 
     index;     size_t
     count;     struct jbg_dec_state     jbig_info;     unsigned char      bit,     buffer[MaxBufferSize];     unsigned int	     byte,      height,      packets,
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*5     Determine maximum width and height, e.g. 640x512.    */   width=65535;   height=65535; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Read JBIG file.    */   jbg_dec_init(&jbig_info); K   jbg_dec_maxsize(&jbig_info,(unsigned long) width,(unsigned long) height);    status=JBG_EAGAIN;   do   { 5     length=fread(buffer,1,MaxBufferSize,image->file);      if (length == 0)       break;
     p=buffer;      count=0;K     while ((length > 0) && ((status == JBG_EAGAIN) || (status == JBG_EOK)))      { 4       status=jbg_dec_in(&jbig_info,p,length,&count);       p+=count;        length-=count;     } :   } while ((status == JBG_EAGAIN) || (status == JBG_EOK));   /*     Initialize image structure.    */.   image->columns=jbg_dec_getwidth(&jbig_info);+   image->rows=jbg_dec_gethight(&jbig_info);    image->packets=0; 5   packets=Max((image->columns*image->rows+8) >> 4,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Create colormap.   */   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    image->colormap[0].red=0;    image->colormap[0].green=0;    image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    /*8     Convert X bitmap image to runlength-encoded packets.   */#   p=jbg_dec_getimage(&jbig_info,0);    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 
     bit=0;&     for (x=0; x < image->columns; x++)     {        if (bit == 0)          byte=(*p++);"       index=(byte & 0x80) ? 0 : 1;B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;O               image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, 1                 packets*sizeof(RunlengthPacket)); <               if (image->pixels == (RunlengthPacket *) NULL)                 { +                   jbg_dec_free(&jbig_info); C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->index=index;            q->length=0;	         }        bit++;       byte<<=1;        if (bit == 8)          bit=0;     }    }    jbg_dec_free(&jbig_info);    SyncImage(image); #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    CloseImage(image);   return(image); }  #else ' static Image *ReadJBIGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("JBIG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   #ifdef HasJPEG #include <setjmp.h>  #include "jpeglib.h" #include "jerror.h"    static Image	   *image;    static jmp_buf   error_recovery;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadJPEGImage reads a JPEG image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % . %  The format of the ReadJPEGImage routine is: % & %      image=ReadJPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJPEGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % ? %    o filename:  Specifies the name of the jpeg image to read.  %  %  */
 static int.   CommentHandler _Declare((j_decompress_ptr));  + static unsigned int GetCharacter(jpeg_info)  j_decompress_ptr   jpeg_info; {    struct jpeg_source_mgr
     *data;     data=jpeg_info->src;!   if (data->bytes_in_buffer == 0) +     (*data->fill_input_buffer) (jpeg_info);    data->bytes_in_buffer--;.   return(GETJOCTET(*data->next_input_byte++)); }   $ static int CommentHandler(jpeg_info) j_decompress_ptr   jpeg_info; { 
   long int     length;      register char      *p;      /*      Determine length of comment.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2;'   if (image->comments != (char *) NULL) >     image->comments=(char *) realloc((char *) image->comments,F       (unsigned int) (strlen(image->comments)+length+1)*sizeof(char));   else     {        image->comments=(char *)7         malloc((unsigned int) (length+1)*sizeof(char)); +       if (image->comments != (char *) NULL)          *image->comments='\0';     } '   if (image->comments == (char *) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        return(False);     }    /*     Read comment.    */,   p=image->comments+strlen(image->comments);   while (--length >= 0) !     *p++=GetCharacter(jpeg_info); 
   *p='\0';   return(True);  }   ( static void EmitMessage(jpeg_info,level) j_common_ptr   jpeg_info;   int    level; {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { L       if ((jpeg_error->num_warnings == 0) || (jpeg_error->trace_level >= 3))2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }     static void ErrorExit(jpeg_info) j_common_ptr   jpeg_info; {    EmitMessage(jpeg_info,0);    longjmp(error_recovery,1); }   ' static Image *ReadJPEGImage(image_info) 	 ImageInfo    *image_info; { 	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];  	   Quantum 	     blue, 
     green,     red;     register int     i,     j;     register JSAMPLE     *p;      register RunlengthPacket     *q;      struct jpeg_decompress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     packets;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image structure.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;&   jpeg_info.err->error_exit=ErrorExit;)   image->pixels=(RunlengthPacket *) NULL;    jpeg_pixels=(JSAMPLE *) NULL;    if (setjmp(error_recovery))      {        /*         JPEG image is corrupt.       */*       if (jpeg_pixels != (JSAMPLE *) NULL)	         { %           free((char *) jpeg_pixels); .           jpeg_destroy_decompress(&jpeg_info);	         }        DestroyImage(image);       return((Image *) NULL);      } %   jpeg_create_decompress(&jpeg_info); @   jpeg_set_marker_processor(&jpeg_info,JPEG_COM,CommentHandler);)   jpeg_stdio_src(&jpeg_info,image->file); +   (void) jpeg_read_header(&jpeg_info,True); (   if (image_info->size != (char *) NULL)     {        unsigned int         height,          width;         unsigned long          scale_factor;          /*.         Let the JPEG library subsample for us.       */.       jpeg_calc_output_dimensions(&jpeg_info);3       image->magick_columns=jpeg_info.output_width; 1       image->magick_rows=jpeg_info.output_height; #       width=jpeg_info.output_width; %       height=jpeg_info.output_height; :       ParseImageGeometry(image_info->size,&width,&height);9       scale_factor=UpShift(jpeg_info.output_width)/width; C       if (scale_factor > (UpShift(jpeg_info.output_height)/height)) =         scale_factor=UpShift(jpeg_info.output_height)/height; 4       jpeg_info.scale_denom=DownShift(scale_factor);.       jpeg_calc_output_dimensions(&jpeg_info);     }  #ifdef DCT_FLOAT_SUPPORTED"   jpeg_info.dct_method=JDCT_FLOAT; #endif$   jpeg_start_decompress(&jpeg_info);(   image->columns=jpeg_info.output_width;&   image->rows=jpeg_info.output_height;   image->packets=0; 5   packets=Max((image->columns*image->rows+2) >> 2,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   jpeg_pixels=(JSAMPLE *) G     malloc(jpeg_info.output_components*image->columns*sizeof(JSAMPLE)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||(       (jpeg_pixels == (JSAMPLE *) NULL))5     PrematureExit("Unable to allocate memory",image); 1   if (jpeg_info.out_color_space == JCS_GRAYSCALE)      {        /*&         Initialize grayscale colormap.       */       image->class=PseudoClass;        image->colors=256;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); '       for (i=0; i < image->colors; i++)        { *         image->colormap[i].red=UpScale(i);,         image->colormap[i].green=UpScale(i);+         image->colormap[i].blue=UpScale(i);        }      }    /*5     Convert JPEG pixels to runlength-encoded packets.    */   red=0;
   green=0;	   blue=0; 
   index=0;%   scanline[0]=(JSAMPROW) jpeg_pixels;    q=image->pixels;   q->length=MaxRunlength; !   for (i=0; i < image->rows; i++)    { 6     (void) jpeg_read_scanlines(&jpeg_info,scanline,1);     p=jpeg_pixels;&     for (j=0; j < image->columns; j++)     { 2       if (jpeg_info.data_precision > QuantumDepth)	         { 9           if (jpeg_info.out_color_space == JCS_GRAYSCALE) (             index=GETJSAMPLE(*p++) >> 4;           else
             { 4               red=(Quantum) (GETJSAMPLE(*p++) >> 4);6               green=(Quantum) (GETJSAMPLE(*p++) >> 4);5               blue=(Quantum) (GETJSAMPLE(*p++) >> 4); 
             } 
          }        else 8          if (jpeg_info.out_color_space == JCS_GRAYSCALE)"            index=GETJSAMPLE(*p++);
          else             {5              red=(Quantum) UpScale(GETJSAMPLE(*p++)); 7              green=(Quantum) UpScale(GETJSAMPLE(*p++)); 6              blue=(Quantum) UpScale(GETJSAMPLE(*p++));            }H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;/               image->pixels=(RunlengthPacket *) P                 realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));<               if (image->pixels == (RunlengthPacket *) NULL)                 { -                   free((char *) jpeg_pixels); 6                   jpeg_destroy_decompress(&jpeg_info);C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->red=red;            q->green=green;            q->blue=blue;            q->index=index;            q->length=0;	         }      }    } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); "   if (image->class == PseudoClass)     {        SyncImage(image);        CompressColormap(image);     }    /*     Free memory.   */   free((char *) jpeg_pixels); ,   (void) jpeg_finish_decompress(&jpeg_info);&   jpeg_destroy_decompress(&jpeg_info);   CloseImage(image);   return(image); }  #else ' static Image *ReadJPEGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("JPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d L O G O I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadLOGOImage reads a LOGO image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadLOGOImage routine is: % & %      image=ReadLOGOImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadLOGOImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadLOGOImage(image_info) 	 ImageInfo    *image_info; {  #include "logo.h"      char     *filename,!     logo_filename[MaxTextLength];      FILE
     *file;     Image      *image;      register int     i;     register unsigned char     *p;      /*     Open temporary output file.    */#   TemporaryFilename(logo_filename);     file=fopen(logo_filename,"w");   if (file == (FILE *) NULL)     { 4       Warning("Unable to write file",logo_filename);&       return(ReadXCImage(image_info));     }    p=LogoImage;%   for (i=0; i < LogoImageLength; i++)    { !     (void) fputc((char) *p,file);      p++;   }    if (ferror(file))      { E       Warning("An error has occurred writing to file",logo_filename);        (void) fclose(file);#       (void) unlink(logo_filename); &       return(ReadXCImage(image_info));     }    (void) fclose(file);    filename=image_info->filename;%   image_info->filename=logo_filename; "   image=ReadMIFFImage(image_info);    image_info->filename=filename;   if (image != (Image *) NULL)8     (void) strcpy(image->filename,image_info->filename);   (void) unlink(logo_filename);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadMAPImage reads an image of raw RGB colormap and colormap indexM %  bytes and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadMAPImage routine is:  % % %      image=ReadMAPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMAPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadMAPImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int      colors;      register int     i;     register unsigned char     *p;      unsigned char      *colormap;     unsigned int     height,      packet_size,     status, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*D     Determine width, height, and number of colors, e.g. 640x512+256.   */   width=512;
   height=512; 
   colors=256; (   if (image_info->size != (char *) NULL)K     (void) XParseGeometry(image_info->size,&colors,&colors,&width,&height);    /*     Initialize image structure.    */   image->class=PseudoClass; #   image->compression=NoCompression;    image->columns=width;    image->rows=height;    image->colors=colors; ,   image->packets=image->columns*image->rows;$   packet_size=3*(image->depth >> 3);   colormap=(unsigned char *)<     malloc(packet_size*image->colors*sizeof(unsigned char));L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));(   image->packed_pixels=(unsigned char *);     malloc(image->packets*packet_size*(image->depth >> 3)); -   if ((colormap == (unsigned char *) NULL) || 0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Read image colormap.   */M   (void) ReadData((char *) colormap,1,image->colors*packet_size,image->file); 
   p=colormap; #   for (i=0; i < image->colors; i++)    { *     ReadQuantum(image->colormap[i].red,p);,     ReadQuantum(image->colormap[i].green,p);+     ReadQuantum(image->colormap[i].blue,p);    }    free((char *) colormap);   /*6     Convert raster image to runlength-encoded packets.   */   packet_size=1;   if (image->colors > 256)     packet_size++;5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);(   image->packed_pixels=(unsigned char *)'     malloc(image->packets*packet_size); 5   if (image->packed_pixels == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image); K   (void) ReadData((char *) image->packed_pixels,packet_size,image->packets,      image->file); %   status=RunlengthDecodeImage(image);    if (status == False)     {        DestroyImages(image);        return((Image *) NULL);      }    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A T T E I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadMATTEImage reads an image of raw matte bytes and returns it.N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % / %  The format of the ReadMATTEImage routine is:  % ' %      image=ReadMATTEImage(image_info)  % + %  A description of each parameter follows:  % K %    o image:  Function ReadMATTEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */( static Image *ReadMATTEImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char
     index,     *p;      unsigned char      *matte_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   image->matte=True;   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;N   matte_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 1   if ((matte_pixels == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */F   (void) ReadData((char *) matte_pixels,1,image->packets,image->file);   p=matte_pixels;    q=image->pixels;$   for (i=0; i < image->packets; i++)   {      index=(*p++); 
     q->red=0;      q->green=0;      q->blue=0;$     q->index=(unsigned short) index;     q->length=0;     q++;   }    free((char *) matte_pixels);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d M I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMIFFImage reads a MIFF image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMIFFImage routine is: % $ %      image=ReadMIFFImage(filename) % + %  A description of each parameter follows:  % I %    o image: Function ReadMIFFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadMIFFImage(image_info) 	 ImageInfo    *image_info; {    char     keyword[MaxTextLength],      value[MaxTextLength];      Image      *image;      register int     c,     i;     register unsigned char     *p;      unsigned int     length,      packet_size,     status;      unsigned long 
     count,     packets;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    image->depth=8;    /*G     Decode image header;  header terminates one character beyond a ':'.    */   c=fgetc(image->file);    if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    do   {      /*I       Decode image header;  header terminates one character beyond a ':'.      */%     image->compression=NoCompression; $     while (isgraph(c) && (c != ':'))     {        register char          *p;          if (c == '{') 	         {            /*0             Read comment-- any text between { }.           *//           if (image->comments != (char *) NULL) 
             { -               length=strlen(image->comments); '               p=image->comments+length; 
             }            else
             { #               length=MaxTextLength; C               image->comments=(char *) malloc(length*sizeof(char));                 p=image->comments;
             } 8           for ( ; image->comments != (char *) NULL; p++)           { !             c=fgetc(image->file); )             if ((c == EOF) || (c == '}'))                break;0             if ((p-image->comments+1) >= length)               {                  *p='\0';                 length<<=1; (                 image->comments=(char *)H                   realloc((char *) image->comments,length*sizeof(char));5                 if (image->comments == (char *) NULL)                    break;:                 p=image->comments+strlen(image->comments);               } !             *p=(unsigned char) c;            } /           if (image->comments == (char *) NULL) =             PrematureExit("Unable to allocate memory",image);            *p='\0';           c=fgetc(image->file); 	         } 
       else         if (isalnum(c))            {              /*0               Determine a keyword and its value.             */             p=keyword;             do
             { 2               if ((p-keyword) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); !             } while (isalnum(c));              *p='\0';,             while (isspace(c) || (c == '='))#               c=fgetc(image->file);              p=value;-             while (!isspace(c) && (c != EOF)) 
             { 0               if ((p-value) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); 
             }              *p='\0';             /*6               Assign a value to the specified keyword.             */-             if (strcmp(keyword,"class") == 0) 3               if (strcmp(value,"PseudoClass") == 0) )                 image->class=PseudoClass;                else5                 if (strcmp(value,"DirectClass") == 0) +                   image->class=DirectClass;                  else.                   image->class=UndefinedClass;.             if (strcmp(keyword,"colors") == 0)7               image->colors=(unsigned int) atoi(value); 3             if (strcmp(keyword,"compression") == 0) 0               if (strcmp(value,"QEncoded") == 0)7                 image->compression=QEncodedCompression;                else:                 if (strcmp(value,"RunlengthEncoded") == 0)A                   image->compression=RunlengthEncodedCompression;                  else:                   image->compression=UndefinedCompression;/             if (strcmp(keyword,"columns") == 0) 8               image->columns=(unsigned int) atoi(value);-             if (strcmp(keyword,"depth") == 0) 5               image->depth=atoi(value) <= 8 ? 8 : 16; *             if (strcmp(keyword,"id") == 0)3               if (strcmp(value,"ImageMagick") == 0) (                 image->id=ImageMagickId;               else&                 image->id=UndefinedId;1             if ((strcmp(keyword,"matte") == 0) || /                 (strcmp(keyword,"alpha") == 0)) M               if ((strcmp(value,"True") == 0) || (strcmp(value,"true") == 0)) "                 image->matte=True;               else#                 image->matte=False; /             if (strcmp(keyword,"montage") == 0)                { M                 image->montage=(char *) malloc(strlen(value)+1*sizeof(char)); 4                 if (image->montage == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 4                 (void) strcpy(image->montage,value);               } /             if (strcmp(keyword,"packets") == 0) 8               image->packets=(unsigned int) atoi(value);,             if (strcmp(keyword,"rows") == 0)5               image->rows=(unsigned int) atoi(value); -             if (strcmp(keyword,"scene") == 0) 6               image->scene=(unsigned int) atoi(value);1             if (strcmp(keyword,"signature") == 0)                { )                 image->signature=(char *) 9                   malloc((strlen(value)+1)*sizeof(char)); 6                 if (image->signature == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 6                 (void) strcpy(image->signature,value);               }            }          else           c=fgetc(image->file);        while (isspace(c))         c=fgetc(image->file);      }      (void) fgetc(image->file);     /*8       Verify that required image information is defined.     */I     if ((image->id == UndefinedId) || (image->class == UndefinedClass) || P         (image->compression == UndefinedCompression) || (image->columns == 0) ||         (image->rows == 0)) <       PrematureExit("Incorrect image header in file",image);(     if (image->montage != (char *) NULL)       {          register char 
           *p;   
         /*           Image directory.
         */E         image->directory=(char *) malloc(MaxTextLength*sizeof(char)); .         if (image->directory == (char *) NULL);           PrematureExit("Unable to read image data",image);          p=image->directory; 
         do	         {            *p='\0';H           if ((((int) strlen(image->directory)+1) % MaxTextLength) == 0)
             {                /*=                 Allocate more memory for the image directory.                */J               image->directory=(char *) realloc((char *) image->directory,I                 (strlen(image->directory)+MaxTextLength+1)*sizeof(char)); 4               if (image->directory == (char *) NULL)A                 PrematureExit("Unable to read image data",image); :               p=image->directory+strlen(image->directory);
             }            c=fgetc(image->file); !           *p++=(unsigned char) c;          } while (c != '\0');       } $     if (image->class == PseudoClass)       {          unsigned int           colors;            unsigned short           value;  
         /*B           PseudoClass image cannot have matte data or be QEncoded.
         */         if (image->matte) B           PrematureExit("Matte images must be DirectClass",image);6         if (image->compression == QEncodedCompression)E           PrematureExit("QEncoded images must be DirectClass",image); 
         /*            Create image colormap.
         */         colors=image->colors;          if (colors == 0)           colors=256; K         image->colormap=(ColorPacket *) malloc(colors*sizeof(ColorPacket)); 4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          if (image->colors == 0) $           for (i=0; i < colors; i++)           { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);              image->colors++;           }          else           {              unsigned char                *colormap;               /*,               Read image colormap from file.             */.             packet_size=3*(image->depth >> 3);&             colormap=(unsigned char *)F               malloc(packet_size*image->colors*sizeof(unsigned char));3             if (colormap == (unsigned char *) NULL) ?               PrematureExit("Unable to allocate memory",image); J             (void) ReadData((char *) colormap,1,packet_size*image->colors,               image->file);              p=colormap; -             for (i=0; i < image->colors; i++) 
             { 4               ReadQuantum(image->colormap[i].red,p);6               ReadQuantum(image->colormap[i].green,p);5               ReadQuantum(image->colormap[i].blue,p); 
             } $             free((char *) colormap);           }        }      /*#       Determine packed packet size.      */$     if (image->class == PseudoClass)       {          image->packet_size=1;           if (image->colors > 256)           image->packet_size++;        }      else       { 1         image->packet_size=3*(image->depth >> 3);          if (image->matte)            image->packet_size++;        } :     if (image->compression == RunlengthEncodedCompression)       image->packet_size++; #     packet_size=image->packet_size; 2     if (image->compression == QEncodedCompression)       packet_size=1;     /*       Allocate image pixels.     */,     if (image->compression == NoCompression)0       image->packets=image->columns*image->rows;     packets=image->packets;      if (image->packets == 0))       packets=image->columns*image->rows; *     image->packed_pixels=(unsigned char *)G       malloc((unsigned int) packets*packet_size*sizeof(unsigned char)); 7     if (image->packed_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      /*"       Read image pixels from file.     */>     if ((image->compression != RunlengthEncodedCompression) ||         (image->packets != 0))D       (void) ReadData((char *) image->packed_pixels,1,(unsigned int))         packets*packet_size,image->file);      else       { 
         /*5           Number of runlength packets is unspecified. 
         */         count=0;         p=image->packed_pixels; 
         do	         { @           (void) ReadData((char *) p,1,packet_size,image->file);           image->packets++;            p+=(packet_size-1);            count+=(*p+1);           p++;	         } 5         while (count < (image->columns*image->rows));        } 3     if (image->compression ==  QEncodedCompression)        {          unsigned char            *compressed_pixels;   
         /*2           Uncompress image pixels with Q encoding.
         */2         image->packets=image->columns*image->rows;/         compressed_pixels=image->packed_pixels; D         image->packed_pixels=(unsigned char *) malloc((unsigned int)C           image->packets*image->packet_size*sizeof(unsigned char)); ;         if (image->packed_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); D         packets=QDecodeImage(compressed_pixels,image->packed_pixels,?           image->columns*(int) image->packet_size,image->rows); ;         if (packets != (image->packets*image->packet_size)) 3           PrematureExit("Q encoding failed",image); )         free((char *) compressed_pixels);        }      /*J       Unpack the packed image pixels into runlength-encoded pixel packets.     */'     status=RunlengthDecodeImage(image);      if (status == False)       {          DestroyImages(image);          return((Image *) NULL);        }      /*       Proceed to next image.     */     do     {        c=fgetc(image->file); (     } while (!isgraph(c) && (c != EOF));     if (c != EOF)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (c != EOF); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #ifdef HasMPEG #undef BitmapPad #include "mpeg.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMPEGImage reads a MPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMPEGImage routine is: % & %      image=ReadMPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadMPEGImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadMPEGImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      ImageDesc      mpeg_info;     register int     i;     register unsigned char     *p;      register RunlengthPacket     *q;      unsigned char      *mpeg_pixels;      unsigned int     status;      unsigned long      lsb_first;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate MPEG pixels.    */*   (void) OpenMPEG(image->file,&mpeg_info);M   mpeg_pixels=(unsigned char *) malloc(mpeg_info.Size*sizeof(unsigned char)); ,   if (mpeg_pixels == (unsigned char *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Read MPEG image.   */,   status=GetMPEGFrame((char *) mpeg_pixels);    if (image_info->subimage != 0)/     while (image->scene < image_info->subimage)      {         image->scene++;1        status=GetMPEGFrame((char *) mpeg_pixels);         if (status == False)           break;      }    if (status == False)     { !       free((char *) mpeg_pixels); 0       PrematureExit("Corrupt MPEG image",image);     }    while (status == True)   {      /*!       Initialize image structure.      */#     image->columns=mpeg_info.Width; #     image->rows=mpeg_info.Height-8; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*=       Convert MPEG raster image to runlength-encoded packets.      */     p=mpeg_pixels;     q=image->pixels;     lsb_first=1;     if (*(char *) &lsb_first) (       for (i=0; i < image->packets; i++)       {          q->red=UpScale(*p++);          q->green=UpScale(*p++);          q->blue=UpScale(*p++);         q->length=0;         p++;         q++;       }      else(       for (i=0; i < image->packets; i++)       {          p++;         q->blue=UpScale(*p++);         q->green=UpScale(*p++);          q->red=UpScale(*p++);          q->length=0;         q++;       }      if (image_info->verbose)       DescribeImage(image);      CompressImage(image); "     if (image_info->subimage != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;.     status=GetMPEGFrame((char *) mpeg_pixels);     if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    }    free((char *) mpeg_pixels); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #else ' static Image *ReadMPEGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("MPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M T V I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadMTVImage reads a MTV image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % - %  The format of the ReadMTVImage routine is:  % % %      image=ReadMTVImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMTVImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadMTVImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int 
     count;  	   Quantum 	     blue, 
     green,     red;     register int     i;     register RunlengthPacket     *q;      unsigned int     columns,     packets,	     rows;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read MTV image.    */5   count=fscanf(image->file,"%u %u\n",&columns,&rows);    if (count == 0) 0     PrematureExit("Not a MTV image file",image);   do   {      /*!       Initialize image structure.      */     image->columns=columns;      image->rows=rows;      image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert MTV raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength; 4     for (i=0; i < (image->columns*image->rows); i++)     { &       red=UpScale(fgetc(image->file));(       green=UpScale(fgetc(image->file));'       blue=UpScale(fgetc(image->file)); H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&+           ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;/               image->pixels=(RunlengthPacket *) P                 realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));<               if (image->pixels == (RunlengthPacket *) NULL)A                 PrematureExit("Unable to allocate memory",image); /               q=image->pixels+image->packets-1; 
             }            q->red=red;            q->green=green;            q->blue=blue;            q->index=0;            q->length=0;	         }      } %     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));      /*       Proceed to next image.     */7     count=fscanf(image->file,"%u %u\n",&columns,&rows);      if (count > 0)       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (count > 0);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d N U L L I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadNULLImage reads a NULL image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadNULLImage routine is: % & %      image=ReadNULLImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadNULLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadNULLImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;   :   Warning("Cannot read NULL images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d P C D I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadPCDImage reads a Photo CD image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a F %  pointer to the new image.  Much of the PCD decoder was derived from. %  the program hpcdtoppm(1) by Hadmut Danisch. % - %  The format of the ReadPCDImage routine is:  % % %      image=ReadPCDImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPCDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  ; static Image *OverviewImage(image_info,image,number_images) 	 ImageInfo    *image_info;   Image 	   *image;    unsigned int   number_images; {  #define ClientName  "montage"      char     *resource_value;  	   Display 
     *display;      Image 
     **images;      register int     i,     j;     XMontageInfo     montage_info;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*     Allocate images array.   */:   images=(Image **) malloc(number_images*sizeof(Image *));    if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);        return((Image *) NULL);      }    /*     Open X server connection.    */7   resource_info.background_color=DefaultTileBackground; *   resource_info.border_color=BorderColor;;:   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground; &   resource_info.gravity=CenterGravity;3   resource_info.image_geometry=DefaultTileGeometry; -   resource_info.matte_color=DefaultTileMatte; $   resource_info.title=(char *) NULL;0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {        /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);        /*3         Get user defaults from X resource database.        */B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);L       resource_info.background_color=XGetResourceInstance(resource_database,7         ClientName,"background",DefaultTileBackground); D       resource_value=XGetResourceClass(resource_database,ClientName,.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,7         ClientName,"foreground",DefaultTileForeground); J       resource_info.image_geometry=XGetResourceInstance(resource_database,8         ClientName,"imageGeometry",DefaultTileGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database, 2         ClientName,"mattecolor",DefaultTileMatte);     }    /*/     Read each image and convert them to a tile.    */   j=0;#   for (i=0; i < number_images; i++)    {      LabelImage(image,"%f"); F     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)       DescribeImage(image);      images[j]=image;     image=image->next;     j++;   }    /*"     Create the PCD Overview image.   */!   XGetMontageInfo(&montage_info);    montage_info.number_tiles=j;%   if (montage_info.number_tiles != 0) =     image=XMontageImage(display,&resource_info,&montage_info, #       image_info->filename,images); "   if (display != (Display *) NULL)     XCloseDisplay(display);    free((char *) images);   if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);    CompressImage(image);    return(image); }   & static Image *ReadPCDImage(image_info)	 ImageInfo    *image_info; {    Image      *image;   
   long int     offset;      register int     i;     register RunlengthPacket     *p;      register unsigned char     *c1,     *c2,     *y;      unsigned char 
     *chroma1, 
     *chroma2,      *header,
     *luma;     unsigned int     height,      number_images,
     overview,      rotate,      status, 
     subimage, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a PCD file.   */A   header=(unsigned char *) malloc(3*0x800*sizeof(unsigned char)); '   if (header == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image); 9   status=ReadData((char *) header,1,3*0x800,image->file); 5   overview=strncmp((char *) header,"PCD_OPA",7) == 0;    if ((status == False) ||C       ((strncmp((char *) header+0x800,"PCD",3) != 0) && !overview)) 0     PrematureExit("Not a PCD image file",image);   rotate=header[0x0e02] & 0x03; /   number_images=(header[10] << 8) | header[11];    free((char *) header);
   subimage=3;     if (image_info->subimage != 0)"     subimage=image_info->subimage;(   if (image_info->size != (char *) NULL)     { 	       int 
         x,
         y;         /*.         Determine which image size to extract.       */       width=768;       height=512; C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height); 1       for (subimage=1; subimage <= 6; subimage++)        { .         if ((width <= 192) && (height <= 128))           break;         width>>=1;         height>>=1;        }      }    if (overview)      subimage=1;    /*     Initialize image structure.    */   width=192;
   height=128; %   for (i=1; i < Min(subimage,3); i++)    {      width<<=1;     height<<=1;    }    image->columns=width;    image->rows=height;    for ( ; i < subimage; i++)   {      image->columns<<=1;      image->rows<<=1;   }    /*$     Allocate luma and chroma memory.   */,   image->packets=image->columns*image->rows;I   chroma1=(unsigned char *) malloc(image->packets*sizeof(unsigned char)); I   chroma2=(unsigned char *) malloc(image->packets*sizeof(unsigned char)); F   luma=(unsigned char *) malloc(image->packets*sizeof(unsigned char));,   if ((chroma1 == (unsigned char *) NULL) ||N       (chroma2 == (unsigned char *) NULL) || (luma == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Advance to image data.   */   offset=93;   if (overview) 
     offset=2;    else     if (subimage == 2)       offset=20;     else       if (subimage == 1)         offset=1; $   for (i=0; i < (offset*0x800); i++)     (void) fgetc(image->file);   if (overview)      {        Image          *overview_image;         register int
         j;         /*,         Read thumbnails from overview image.       */(       for (j=1; j <= number_images; j++)       { 8         (void) sprintf(image->filename,"img%04d.pcd",j);         image->scene=j;          image->columns=width;          image->rows=height; 2         image->packets=image->columns*image->rows;)         image->pixels=(RunlengthPacket *) 9           malloc(image->packets*sizeof(RunlengthPacket)); 6         if (image->pixels == (RunlengthPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          y=luma;          c1=chroma1;          c2=chroma2; #         for (i=0; i < height; i+=2) 	         { :           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;@           (void) ReadData((char *) c1,1,width >> 1,image->file);           c1+=image->columns; @           (void) ReadData((char *) c2,1,width >> 1,image->file);           c2+=image->columns; 	         } N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);
         /*6           Transfer luminance and chrominance channels.
         */         p=image->pixels;         y=luma;          c1=chroma1;          c2=chroma2; *         for (i=0; i < image->packets; i++)	         {            p->red=UpScale(*y++); "           p->green=UpScale(*c1++);!           p->blue=UpScale(*c2++);            p->index=0;            p->length=0;           p++;	         } /         TransformRGBImage(image,YCCColorspace);          CompressImage(image);           if (image_info->verbose)           DescribeImage(image);          if (j < number_images)           {              /*'               Allocate image structure.              */2             image->next=AllocateImage(image_info);.             if (image->next == (Image *) NULL)               { %                 DestroyImages(image); '                 return((Image *) NULL);                } *             image->next->file=image->file;(             image->next->previous=image;             image=image->next;           }        }        free(chroma2);       free(chroma1);       free(luma); /       while (image->previous != (Image *) NULL)          image=image->previous;       CloseImage(image);C       overview_image=OverviewImage(image_info,image,number_images);        return(overview_image);      }    /*     Allocate image pixels.   */#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Read interleaved image.    */	   y=luma; 
   c1=chroma1; 
   c2=chroma2;    for (i=0; i < height; i+=2)    { 4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;:     (void) ReadData((char *) c1,1,width >> 1,image->file);     c1+=image->columns; :     (void) ReadData((char *) c2,1,width >> 1,image->file);     c2+=image->columns;    }    if (subimage >= 4)     {        /*5         Recover luminance deltas for 1536x1024 image.        */,       Upsample(768,512,image->columns,luma);/       Upsample(384,256,image->columns,chroma1); /       Upsample(384,256,image->columns,chroma2);        image->rows=1024; #       for (i=0; i < (4*0x800); i++) "         (void) fgetc(image->file);8       status=PCDDecodeImage(image,luma,chroma1,chroma2);$       if ((subimage >= 5) && status)	         {            /*9             Recover luminance deltas for 3072x2048 image.            */2           Upsample(1536,1024,image->columns,luma);3           Upsample(768,512,image->columns,chroma1); 3           Upsample(768,512,image->columns,chroma2);            image->rows=2048; -           offset=ftell(image->file)/0x800+12; 3           (void) fseek(image->file,offset*0x800,0); <           (void) PCDDecodeImage(image,luma,chroma1,chroma2);	         }      } H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);   /*0     Transfer luminance and chrominance channels.   */   p=image->pixels;	   y=luma; 
   c1=chroma1; 
   c2=chroma2; $   for (i=0; i < image->packets; i++)   {      p->red=UpScale(*y++);      p->green=UpScale(*c1++);     p->blue=UpScale(*c2++);      p->index=0;      p->length=0;     p++;   }    free(chroma2);   free(chroma1);
   free(luma); )   TransformRGBImage(image,YCCColorspace); %   if ((rotate == 1) || (rotate == 3))      {        double         degrees;         Image          *rotated_image;          /*         Rotate image.        */)       degrees=rotate == 1 ? -90.0 : 90.0;        image->orphan=True; J       rotated_image=RotateImage(image,degrees,(ColorPacket *) NULL,False);       image->orphan=False;*       if (rotated_image != (Image *) NULL)	         {            DestroyImage(image);           image=rotated_image;	         }      }    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d P C X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadPCXImage reads a ZSoft IBM PC Paintbrush file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % - %  The format of the ReadPCXImage routine is:  % % %      image=ReadPCXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPCXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadPCXImage(image_info)	 ImageInfo    *image_info; {    typedef struct _PCXHeader    {      unsigned char        identifier,        version,       encoding,        bits_per_pixel;   
     short int        left, 
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int        bytes_per_line,        palette_info;        unsigned char        colormap_signature;    } PCXHeader;     PCXHeader      pcx_header;      Image      *image;      int 
     count,     packets;     register int     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      packet,      *pcx_colormap,     *pcx_pixels;     unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a PCX file.   */C   status=ReadData((char *) &pcx_header.identifier,1,1,image->file);    do   {      /*       Verify PCX identifier.     */=     if ((status == False) || (pcx_header.identifier != 0x0a)) 2       PrematureExit("Not a PCX image file",image);B     (void) ReadData((char *) &pcx_header.version,1,1,image->file);C     (void) ReadData((char *) &pcx_header.encoding,1,1,image->file); I     (void) ReadData((char *) &pcx_header.bits_per_pixel,1,1,image->file); 3     pcx_header.left=LSBFirstReadShort(image->file); 2     pcx_header.top=LSBFirstReadShort(image->file);4     pcx_header.right=LSBFirstReadShort(image->file);5     pcx_header.bottom=LSBFirstReadShort(image->file); D     pcx_header.horizontal_resolution=LSBFirstReadShort(image->file);B     pcx_header.vertical_resolution=LSBFirstReadShort(image->file);     /*       Read PCX raster colormap.      */8     image->columns=(pcx_header.right-pcx_header.left)+1;5     image->rows=(pcx_header.bottom-pcx_header.top)+1;      image->class=PseudoClass;      image->colors=16; D     image->colormap=(ColorPacket *) malloc(256*sizeof(ColorPacket));G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); 4     if ((image->colormap == (ColorPacket *) NULL) ||1         (pcx_colormap == (unsigned char *) NULL)) 7       PrematureExit("Unable to allocate memory",image); G     (void) ReadData((char *) pcx_colormap,3,image->colors,image->file);      p=pcx_colormap; %     for (i=0; i < image->colors; i++)      { +       image->colormap[i].red=UpScale(*p++); -       image->colormap[i].green=UpScale(*p++); ,       image->colormap[i].blue=UpScale(*p++);     } C     (void) ReadData((char *) &pcx_header.reserved,1,1,image->file); A     (void) ReadData((char *) &pcx_header.planes,1,1,image->file); =     pcx_header.bytes_per_line=LSBFirstReadShort(image->file); ;     pcx_header.palette_info=LSBFirstReadShort(image->file);      for (i=0; i < 58; i++)        (void) fgetc(image->file);     /*       Read image data.     */D     packets=image->rows*pcx_header.bytes_per_line*pcx_header.planes;G     pcx_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); -     if (pcx_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      /*       Uncompress image data.     */     p=pcx_pixels;      while (packets > 0)      {         packet=fgetc(image->file);"       if ((packet & 0xc0) != 0xc0)	         {            *p++=packet;           packets--;           continue; 	         }        count=packet & 0x3f;        packet=fgetc(image->file);       packets-=count;        while (--count >= 0)         *p++=packet;     } E     image->colors=1 << (pcx_header.bits_per_pixel*pcx_header.planes);      if (image->colors > 256)>       PrematureExit("PCX colormap exceeded 256 colors",image);     if (image->colors > 16)        { 
         /*G           256 color images have their color map at the end of the file. 
         */D         (void) ReadData((char *) &pcx_header.colormap_signature,1,1,           image->file); K         (void) ReadData((char *) pcx_colormap,3,image->colors,image->file);          p=pcx_colormap; )         for (i=0; i < image->colors; i++) 	         {D/           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++);O0           image->colormap[i].blue=UpScale(*p++);	         }        }      else       if (image->colors == 2) K         if (Intensity(image->colormap[0]) == Intensity(image->colormap[1]))            {              /*"               Monochrome colormap.             */*             image->colormap[0].red=MaxRGB;,             image->colormap[0].green=MaxRGB;+             image->colormap[0].blue=MaxRGB; %             image->colormap[1].red=0; '             image->colormap[1].green=0;R&             image->colormap[1].blue=0;           }       free((char *) pcx_colormap);     /*<       Convert PCX raster image to runlength-encoded packets.     */     if (pcx_header.planes > 1)       {          register int           bits,            mask;   
         /*%           Initialize image structure.t
         */2         image->packets=image->columns*image->rows;)         image->pixels=(RunlengthPacket *) J           malloc((image->packets+image->columns)*sizeof(RunlengthPacket));6         if (image->pixels == (RunlengthPacket *) NULL);           PrematureExit("Unable to allocate memory",image); 
         /*C           Convert multi-plane format into runlength-encoded pixels.r
         */         q=image->pixels;*         for (i=0; i < image->packets; i++)	         {            q->index=0;            q->length=0;           q++;	         } '         for (y=0; y < image->rows; y++)l	         {aG           p=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes);o5           for (i=0; i < (int) pcx_header.planes; i++)g           {e-             q=image->pixels+y*image->columns;C9             for (x=0; x < pcx_header.bytes_per_line; x++) 
             {o               bits=(*p++);2               for (mask=0x80; mask != 0; mask>>=1)               {s                  if (bits & mask)#                   q->index|=1 << i;o                 q++;               }t
             }            } 	         }.         SyncImage(image);a          CompressColormap(image);         CompressImage(image);o       }f     else       {s         register unsigned char
           *r;p           unsigned char            *scanline;           unsigned short           index;  
         /*%           Initialize image structure.E
         */         image->packets=0;c;         packets=Max((image->columns*image->rows+4) >> 3,1);c+         if (pcx_header.bits_per_pixel == 1)i=           packets=Max((image->columns*image->rows+8) >> 4,1);N)         image->pixels=(RunlengthPacket *) 2           malloc(packets*sizeof(RunlengthPacket));"         scanline=(unsigned char *)7           malloc(image->columns*sizeof(unsigned char)); :         if ((image->pixels == (RunlengthPacket *) NULL) ||1             (scanline == (unsigned char *) NULL))n;           PrematureExit("Unable to allocate memory",image);          q=image->pixels;         q->length=MaxRunlength; '         for (y=0; y < image->rows; y++)%	         {%3           p=pcx_pixels+y*pcx_header.bytes_per_line;n           r=scanline;c,           switch (pcx_header.bits_per_pixel)           {m             case 1: 
             {n               register int                 bit;  5               for (x=0; x < (image->columns-7); x+=8)t               {.,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               } ,               if ((image->columns % 8) != 0)                 { E                   for (bit=7; bit >= (8-(image->columns % 8)); bit--)n>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 })               break;
             }o             case 2:%
             {%5               for (x=0; x < (image->columns-3); x+=4)%               { %                 *r++=(*p >> 6) & 0x3; %                 *r++=(*p >> 4) & 0x3; %                 *r++=(*p >> 2) & 0x3;                   *r++=(*p) & 0x3;                 p++;               } ,               if ((image->columns % 4) != 0)                 { ?                   for (i=3; i >= (4-(image->columns % 4)); i--) .                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }                break;
             }              case 4: 
             { 5               for (x=0; x < (image->columns-1); x+=2)                {%%                 *r++=(*p >> 4) & 0xf;%                  *r++=(*p) & 0xf;                 p++;               }S,               if ((image->columns % 2) != 0)'                 *r++=(*p++ >> 4) & 0xf;                break;
             }t             case 8: 
             {f0               for (x=0; x < image->columns; x++)                 *r++=(*p++);               break;
             }l             default:               break;           }a           /*$             Transfer image scanline.           */           r=scanline;m,           for (x=0; x < image->columns; x++)           {              index=(*r++);aH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {t(                 if (image->packets != 0)                   q++;!                 image->packets++;e.                 if (image->packets == packets)                   {,                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));iB                     if (image->pixels == (RunlengthPacket *) NULL)                       { 0                         free((char *) scanline);I                         PrematureExit("Unable to allocate memory",image);                        } 5                     q=image->pixels+image->packets-1;/                   }c                 q->index=index;t                 q->length=0;               }(           }s	         }m         SyncImage(image);f          CompressColormap(image);I         image->pixels=(RunlengthPacket *) realloc((char *) image->pixels,g2           image->packets*sizeof(RunlengthPacket));          free((char *) scanline);       }a     free((char *) pcx_pixels);     /*       Proceed to next image.     */E     status=ReadData((char *) &pcx_header.identifier,1,1,image->file);x<     if ((status == True) && (pcx_header.identifier == 0x0a))       {t
         /*#           Allocate image structure.t
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);e           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }(@   } while ((status == True) && (pcx_header.identifier == 0x0a));+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }- c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%xO %                                                                             %sO %                                                                             %NO %                                                                             % O %  R e a d P D F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %mH %  Function ReadPDFImage reads a Portable Document Format image file andM %  returns it.  It allocates the memory necessary for the new Image structuren* %  and returns a pointer to the new image. %)- %  The format of the ReadPDFImage routine is:) % % %      image=ReadPDFImage(image_info)  % + %  A description of each parameter follows:l %mI %    o image:  Function ReadPDFImage returns a pointer to the image aftermL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.h % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %m %= */& static Image *ReadPDFImage(image_info)	 ImageInfo;   *image_info; {% #define MediaBox  "/MediaBox ["%     char     command[MaxTextLength], !     crop_geometry[MaxTextLength],      *device,     filename[MaxTextLength],     options[MaxTextLength], '     postscript_filename[MaxTextLength];      FILE
     *file;     Image      *image,      *next_image;     int      status;   
   long int
     filesize;g     register int     i;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);%   /*     Open temporary output file.%   */)   TemporaryFilename(postscript_filename);M&   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);   /*5     Determine if Postscript specifies a bounding box.    */   *options='\0';   *crop_geometry='\0';E   while (fgets(command,MaxTextLength-1,image->file) != (char *) NULL)a   {r8     if (strncmp(MediaBox,command,strlen(MediaBox)) == 0)       {a         inth           count,           flags,           lower_x,           lower_y,           upper_x,           upper_y,           x,           y;           unsigned int           dx_resolution,           dy_resolution,           x_resolution,a           y_resolution;i  <         if (strncmp(MediaBox,command,strlen(MediaBox)) == 0)K           count=sscanf(command,"/MediaBox [ %d %d %d %d",&lower_x,&lower_y,i             &upper_x,&upper_y);          if (count != 4)            continue; 
         /*!           Determine bounding box.;
         */E         (void) XParseGeometry(PSDensityGeometry,&x,&y,&dx_resolution,            &dy_resolution);#         x_resolution=dx_resolution; #         y_resolution=dy_resolution;_E         flags=XParseGeometry(image_info->density,&x,&y,&x_resolution,            &y_resolution);r'         if ((flags & HeightValue) == 0)u$           y_resolution=x_resolution;.         if (image_info->page == (char *) NULL)           {              unsigned int               height,                width;               /*-               Set Postscript render geometry.(             */I             width=(((lower_x+upper_x)*x_resolution+(dx_resolution >> 1))/                dx_resolution)+1;gJ             height=(((lower_x+upper_y)*y_resolution+(dy_resolution >> 1))/               dy_resolution)+1;a:             (void) sprintf(options,"-g%ux%u",width,width);             if (width < height) >               (void) sprintf(options,"-g%ux%u",height,height);/             (void) strcpy(crop_geometry,"0x0");r           }N       }i     (void) fputs(command,file);r   }_   if (ferror(file))(     {fK       Warning("An error has occurred writing to file",postscript_filename);e       (void) fclose(file);       return((Image *) NULL);e     }f   (void) fclose(file);   CloseImage(image);   filesize=image->filesize;o   DestroyImage(image);   /*@     Determine if page geometry or density options are specified.   */(   if (image_info->page != (char *) NULL)     {l#       (void) strcat(options," -g"); .       (void) strcat(options,image_info->page);     }h+   if (image_info->density != (char *) NULL)=     {t#       (void) strcat(options," -r");_1       (void) strcat(options,image_info->density);      }m   /*0     Use Ghostscript to convert Postscript image.   */   device="ppmraw";   if (image_info->monochrome)l     device="pbmraw";/   (void) strcpy(filename,image_info->filename);    for (i=0; i < 50; i++)   {w     /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   }cO   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,L     postscript_filename);     status=SystemCommand(command);
   if (status)e     { K       Warning("Portable Document translation failed",image_info->filename);p)       (void) unlink(postscript_filename);        return((Image *) NULL);i     }L!   image=ReadPNMImage(image_info);d%   (void) unlink(postscript_filename);a&   (void) unlink(image_info->filename);   if (image == (Image *) NULL)     {vK       Warning("Portable Document translation failed",image_info->filename);        return((Image *) NULL);      }b   do   {;,     (void) strcpy(image->filename,filename);     image->filesize=filesize;d     if (*crop_geometry != '\0')/0       if (Intensity(image->pixels[0]) == MaxRGB)	         {            /*!             Crop to bounding box.=           */=           TransformImage(&image,crop_geometry,(char *) NULL); ,           if (image->next != (Image *) NULL)(             image->next->previous=image;	         }      next_image=image->next;r%     if (next_image != (Image *) NULL)l       image=next_image;))   } while (next_image != (Image *) NULL);o+   while (image->previous != (Image *) NULL)z     image=image->previous;   return(image); }  a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,O %                                                                             %-O %                                                                             % O %                                                                             %UO %  R e a d P I C T I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadPICTImage reads an Apple Macintosh QuickDraw/PICT image fileG %  and returns it.  It allocates the memory necessary for the new Imagen4 %  structure and returns a pointer to the new image. %(. %  The format of the ReadPICTImage routine is: %a& %      image=ReadPICTImage(image_info) %d+ %  A description of each parameter follows:  % J %    o image:  Function ReadPICTImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.n %1A %    o image_info: Specifies a pointer to an ImageInfo structure.) %  %  */' static Image *ReadPICTImage(image_info)d	 ImageInfol   *image_info; {u   char     filename[MaxTextLength];     Imageg     *image,U     *next_image,     *proxy_image;      /*     Allocate image structure.v   */(   proxy_image=AllocateImage(image_info);$   if (proxy_image == (Image *) NULL)     return((Image *) NULL);.   /*     Open image file.   */   OpenImage(proxy_image,"rb");)   if (proxy_image->file == (FILE *) NULL)_5     PrematureExit("Unable to open file",proxy_image);;   CloseImage(proxy_image);   DestroyImage(proxy_image);   /*2     Use picttoppm to convert Macintosh PICT image.   *//   (void) strcpy(filename,image_info->filename);*@   (void) sprintf(image_info->filename,"|picttoppm %s",filename);!   image=ReadPNMImage(image_info);k   if (image == (Image *) NULL)3     PrematureExit("PICT translation failed",image);l   /*     Assign proper filename.    */   do   { ,     (void) strcpy(image->filename,filename);     next_image=image->next;(%     if (next_image != (Image *) NULL))       image=next_image;_)   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)p     image=image->previous;   return(image); }   
 #ifdef HasPNGo #include "png.h" /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %oO %                                                                             % O %                                                                             % O %  R e a d P N G I m a g e                                                    % O %                                                                             %tO %                                                                             %xO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %yI %  Function ReadPNGImage reads a Portable Network Graphics image file and M %  returns it.  It allocates the memory necessary for the new Image structure.* %  and returns a pointer to the new image. %=- %  The format of the ReadPNGImage routine is:m %-% %      image=ReadPNGImage(image_info)= %g+ %  A description of each parameter follows:  %0I %    o image:  Function ReadPNGImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.> %u %  */& static Image *ReadPNGImage(image_info)	 ImageInfo>   *image_info; {    Image-     *image;      register int     i,     x,     y;     register unsigned char     *p;m     register RunlengthPacket     *q;i  
   png_info     *ping_info;      png_struct
     *ping;     unsigned char      *png_pixels,     **scanlines;     unsigned int     bytes_per_line,      packets;     unsigned short
     index,
     value;     /*     Allocate image structure.o   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate the PNG structures    */1   ping=(png_struct *) malloc(sizeof(png_struct));o2   ping_info=(png_info *) malloc(sizeof(png_info));H   if ((ping == (png_struct *) NULL) || (ping_info == (png_info *) NULL))5     PrematureExit("Unable to allocate memory",image); )   image->pixels=(RunlengthPacket *) NULL; $   png_pixels=(unsigned char *) NULL;$   scanlines=(unsigned char **) NULL;   if (setjmp(ping->jmpbuf))n     {        /*         PNG image is corrupt.)       */9       png_read_destroy(ping,ping_info,(png_info *) NULL); /       if (scanlines != (unsigned char **) NULL) !         free((char *) scanlines); /       if (png_pixels != (unsigned char *) NULL) "         free((char *) png_pixels);       free((char *) ping);       free((char *) ping_info);:       CloseImage(image);6       if ((image->columns == 0) || (image->rows == 0))	         {;           DestroyImage(image);!           return((Image *) NULL); 	         }        return(image);     }c   /*     Prepare PNG for reading.   */   png_info_init(ping_info);i   png_read_init(ping);    png_init_io(ping,image->file);    png_read_info(ping,ping_info);*   if (ping_info->bit_depth > QuantumDepth)     {        png_set_strip_16(ping);)       ping_info->bit_depth=8;      }o    if (ping_info->bit_depth < 16)     image->depth=8;    /*     Initialize image structure.g   */"   image->columns=ping_info->width;    image->rows=ping_info->height;   image->packets=0;n5   packets=Max((image->columns*image->rows+4) >> 3,1);u    if (ping_info->bit_depth == 1)7     packets=Max((image->columns*image->rows+8) >> 4,1);aL   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   bytes_per_line=iN     Max((int) ping_info->bit_depth >> 3,1)*ping_info->channels*image->columns;   png_pixels=(unsigned char *)7     malloc(bytes_per_line*image->rows*sizeof(Quantum)); K   scanlines=(unsigned char **) malloc(image->rows*sizeof(unsigned char *)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (png_pixels == (unsigned char *) NULL) || -       (scanlines == (unsigned char **) NULL))M5     PrematureExit("Unable to allocate memory",image);    if (ping_info->num_text > 0)     {        unsigned int         length;          /*!         Initialize image comment.        */       length=1; -       for (i=0; i < ping_info->num_text; i++) P         length+=strlen(ping_info->text[i].key)+ping_info->text[i].text_length+3;%       image->comments=malloc(length);%+       if (image->comments == (char *) NULL) 9         PrematureExit("Unable to allocate memory",image);b       *image->comments='0';c-       for (i=0; i < ping_info->num_text; i++)e       {e>         (void) strcpy(image->comments,ping_info->text[i].key);,         (void) strcpy(image->comments,": ");F         p=(unsigned char *) image->comments+strlen(image->comments)-1;?         (void) strncpy(image->comments,ping_info->text[i].text, *           ping_info->text[i].text_length);*         p+=ping_info->text[i].text_length;         *p='\0';,         (void) strcpy(image->comments,"\n");       }e     }a:   if ((ping_info->color_type == PNG_COLOR_TYPE_PALETTE) ||5       (ping_info->color_type == PNG_COLOR_TYPE_GRAY))f     {        /*"         Initialize image colormap.       */       image->class=PseudoClass;R.       image->colors=1 << ping_info->bit_depth;:       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE)-         image->colors=ping_info->num_palette;tP       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); :       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE))         for (i=0; i < image->colors; i++)r	         {lD           image->colormap[i].red=UpScale(ping_info->palette[i].red);H           image->colormap[i].green=UpScale(ping_info->palette[i].green);F           image->colormap[i].blue=UpScale(ping_info->palette[i].blue);	         }h
       else)         for (i=0; i < image->colors; i++)>	         {*>           image->colormap[i].red=(MaxRGB*i)/(image->colors-1);@           image->colormap[i].green=(MaxRGB*i)/(image->colors-1);?           image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);i	         }e     })   /*     Read image scanlines.k   */"   if (image->class == DirectClass)!     if (ping_info->bit_depth < 8)e       png_set_packing(ping);!   for (i=0; i < image->rows; i++)g/     scanlines[i]=png_pixels+(bytes_per_line*i);a!   png_read_image(ping,scanlines);    png_read_end(ping,ping_info);-   /*4     Convert PNG pixels to runlength-encoded packets.   */   q=image->pixels;   q->length=MaxRunlength; "   if (image->class == DirectClass)     { 
       Quantuma
         blue,l         green,         red;         /*?         Convert image to DirectClass runlength-encoded packets.;       */@       if ((ping_info->color_type == PNG_COLOR_TYPE_RGB_ALPHA) ||?           (ping_info->color_type == PNG_COLOR_TYPE_GRAY_ALPHA))l         image->matte=True;%       for (y=0; y < image->rows; y++)        {;         p=scanlines[y]; *         for (x=0; x < image->columns; x++)	         {            ReadQuantum(red,p);M           green=red;           blue=red; A           if (ping_info->color_type != PNG_COLOR_TYPE_GRAY_ALPHA)=
             {*#               ReadQuantum(green,p); "               ReadQuantum(blue,p);
             }d           index=0;           if (image->matte) !             ReadQuantum(index,p);-L           if ((red == q->red) && (green == q->green) && (blue == q->blue) &&F               (index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {0&               if (image->packets != 0)                 q++;               image->packets++; ,               if (image->packets == packets)                 {0                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)                     { 0                       free((char *) png_pixels);G                       PrematureExit("Unable to allocate memory",image);                      } 3                   q=image->pixels+image->packets-1;c                 }                q->red=red;*               q->green=green;                q->blue=blue;                q->index=index;+               q->length=0;
             };	         }+       }      }    else     {l
       Quantumi         *quantum_scanline;         register Quantum         *r;+         /*?         Convert image to PseudoClass runlength-encoded packets.        */J       quantum_scanline=(Quantum *) malloc(image->columns*sizeof(Quantum));/       if (quantum_scanline == (Quantum *) NULL)l9         PrematureExit("Unable to allocate memory",image);M%       for (y=0; y < image->rows; y++)        {M         p=scanlines[y];          r=quantum_scanline; %         switch (ping_info->bit_depth)-	         {G           case 1:            {o             register int               bit;  9             for (x=0; x < ((int) image->columns-7); x+=8) 
             { *               for (bit=7; bit >= 0; bit--):                 *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);               p++;
             }%*             if ((image->columns % 8) != 0)               {%C                 for (bit=7; bit >= (8-(image->columns % 8)); bit--) <                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               }              break;           }            case 2:            { 9             for (x=0; x < ((int) image->columns-3); x+=4) 
             { #               *r++=(*p >> 6) & 0x3; #               *r++=(*p >> 4) & 0x3; #               *r++=(*p >> 2) & 0x3;                *r++=(*p) & 0x3;               p++;
             } *             if ((image->columns % 4) != 0)               { =                 for (i=3; i >= (4-(image->columns % 4)); i--)%,                   *r++=(*p >> (i*2)) & 0x03;                 p++;               }i             break;           }            case 4:r           {o9             for (x=0; x < ((int) image->columns-1); x+=2) 
             { #               *r++=(*p >> 4) & 0xf;t               *r++=(*p) & 0xf;               p++;
             }r*             if ((image->columns % 2) != 0)%               *r++=(*p++ >> 4) & 0xf;s             break;           }            case 8:l           {t.             for (x=0; x < image->columns; x++)               *r++=(*p++);             break;           }i           case 16:           {c.             for (x=0; x < image->columns; x++)
             {g                ReadQuantum(*r,p);               r++;
             }              break;           }e           default:             break;	         }g
         /*"           Transfer image scanline.
         */         r=quantum_scanline;a*         for (x=0; x < image->columns; x++)	         {f           index=(*r++); F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {g&               if (image->packets != 0)                 q++;               image->packets++;4,               if (image->packets == packets)                 {k                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));*@                   if (image->pixels == (RunlengthPacket *) NULL)                     {o6                       free((char *) quantum_scanline);G                       PrematureExit("Unable to allocate memory",image);x                     }[3                   q=image->pixels+image->packets-1;g                 }n               q->index=index;=               q->length=0;
             } 	         }=       } &       if (image->class == PseudoClass)         SyncImage(image);e&       free((char *) quantum_scanline);+       if (ping_info->valid & PNG_INFO_tRNS)%	         {%           /*/             Image has a transparent background.            */#           image->class=DirectClass;            image->matte=True;           q=image->pixels;,           for (i=0; i < image->packets; i++)           {              index=q->index;              q->index=Opaque;@             if (ping_info->color_type != PNG_COLOR_TYPE_PALETTE)               { :                 if (index == ping_info->trans_values.gray)'                   q->index=Transparent;                }              else/               if (index < ping_info->num_trans) 1                 q->index=ping_info->trans[index];%             q++;           }%	         }%&       if (image->class == PseudoClass)          CompressColormap(image);     }n#   image->pixels=(RunlengthPacket *)eK     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));g'   if (ping_info->valid & PNG_INFO_gAMA)e     {e
       char         gamma[MaxTextLength];i         /*          Gamma correct the image.       */2       (void) sprintf(gamma,"%f",ping_info->gamma);       GammaImage(image,gamma);     }i   /*     Free memory.   */5   png_read_destroy(ping,ping_info,(png_info *) NULL);e   free((char *) png_pixels);   free((char *) ping);   free((char *) ping_info);    CloseImage(image);   return(image); }_ #else & static Image *ReadPNGImage(image_info)	 ImageInfoI   *image_info; { ?   Warning("PNG library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }  #endif u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %lO %                                                                             %kO %  R e a d P N M I m a g e                                                    % O %                                                                             % O %                                                                             %uO %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadPNMImage reads a Portable Anymap image file and returns it.*L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %e- %  The format of the ReadPNMImage routine is:8 % % %      image=ReadPNMImage(image_info). %s+ %  A description of each parameter follows:i %aI %    o image:  Function ReadPNMImage returns a pointer to the image afteraL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */* static unsigned int PNMInteger(image,base) Imageg	   *image;f   unsigned int   base;  {  #define MaxRawValue  255     inte     c;     unsigned int
     value;     /*      Skip any leading whitespace.   */   do   {      c=fgetc(image->file);      if (c == EOF)        return(0);     if (c == '#')e       {          register char 
           *p;=           unsigned int           length;   
         /*           Read comment.)
         */-         if (image->comments != (char *) NULL)0           { +             length=strlen(image->comments); %             p=image->comments+length;            }          else           { !             length=MaxTextLength; A             image->comments=(char *) malloc(length*sizeof(char));(             p=image->comments;           } 6         for ( ; image->comments != (char *) NULL; p++)	         {=.           if ((p-image->comments+2) >= length)
             {x               *p='\0';               length<<=1; &               image->comments=(char *)F                 realloc((char *) image->comments,length*sizeof(char));3               if (image->comments == (char *) NULL)t                 break;8               p=image->comments+strlen(image->comments);
             }            c=fgetc(image->file);)(           if ((c == EOF) || (c == '\n'))             break;           *p=(unsigned char) c;y	         }"-         if (image->comments == (char *) NULL)(           { =             Warning("Memory allocation error",(char *) NULL);              return(0);           })         *p++='\n';         *p='\0';       }I   } while (!isdigit(c));   if (base == 2)     return(c-'0');   /*     Evaluate number.   */
   value=0;   do   {      value*=10;     value+=c-'0';o     c=fgetc(image->file);c     if (c == EOF)"       return(0);   }s   while (isdigit(c));a   return(value); }t  & static Image *ReadPNMImage(image_info)	 ImageInfo.   *image_info; {)   char     format;p     ImageZ     *image;   	   Quantums	     blue,o
     green,     red,     *scale;k     register int     i;     register RunlengthPacket     *q;      unsigned int     max_value,     packets,     status;-     unsigned short
     index;     /*     Allocate image structure.n   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);r   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)s/     PrematureExit("Unable to open file",image);|   /*     Read PNM image.m   */4   status=ReadData((char *) &format,1,1,image->file);   do   {"     /*       Verify PNM identifier.     */-     if ((status == False) || (format != 'P')) 2       PrematureExit("Not a PNM image file",image);     /*!       Initialize image structure.g     */     format=fgetc(image->file);     if (format == '7')"       (void) PNMInteger(image,10);(     image->columns=PNMInteger(image,10);%     image->rows=PNMInteger(image,10); *     if ((image->columns*image->rows) == 0)M       PrematureExit("Unable to read image: image dimensions are zero",image);S     image->packets=0;l7     packets=Max((image->columns*image->rows+4) >> 3,1);t+     if ((format == '1') || (format == '4'))e9       packets=Max((image->columns*image->rows+8) >> 4,1);aN     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);e+     if ((format == '1') || (format == '4'))s        max_value=1;  /* bitmap */     else%       max_value=PNMInteger(image,10);      scale=(Quantum *) NULL;e+     if ((format != '3') && (format != '6'))o       { 
         /*           Create colormap.
         */!         image->class=PseudoClass; .         image->colors=Min(max_value,MaxRGB)+1;'         image->colormap=(ColorPacket *)e4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          if (format != '7')+           for (i=0; i < image->colors; i++)            {=@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);            }=         else           {t             /*&               Initialize 332 colormap.             */             i=0;'             for (red=0; red < 8; red++)t/               for (green=0; green < 8; green++)s.                 for (blue=0; blue < 4; blue++)                 {pB                   image->colormap[i].red=(Quantum) (red*MaxRGB)/7;F                   image->colormap[i].green=(Quantum) (green*MaxRGB)/7;D                   image->colormap[i].blue=(Quantum) (blue*MaxRGB)/3;                   i++;                 }d           }        }c     else       if (max_value != MaxRGB)	         {a           /*(             Compute pixel scaling table.           */B           scale=(Quantum *) malloc((max_value+1)*sizeof(Quantum));(           if (scale == (Quantum *) NULL)=             PrematureExit("Unable to allocate memory",image);i(           for (i=0; i <= max_value; i++)G             scale[i]=(Quantum) ((i*MaxRGB+(max_value >> 1))/max_value);l	         }g     /*;       Convert PNM pixels to runlength-encoded MIFF packets.*     */     q=image->pixels;     q->length=MaxRunlength;n     switch (format)(     {        case '1':)       { 
         /*9           Convert PBM image to runlength-encoded packets.f
         */8         for (i=0; i < (image->columns*image->rows); i++)	         {t%           index=!PNMInteger(image,2); F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             { &               if (image->packets != 0)                 q++;               image->packets++;*,               if (image->packets == packets)                 {;                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image); 3                   q=image->pixels+image->packets-1;                  }                q->index=index;a               q->length=0;
             } 	         }          break;       }        case '2':        { 
         /*9           Convert PGM image to runlength-encoded packets. 
         */8         for (i=0; i < (image->columns*image->rows); i++)	         { %           index=PNMInteger(image,10); F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {a&               if (image->packets != 0)                 q++;               image->packets++;t,               if (image->packets == packets)                 {.                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));t@                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image); 3                   q=image->pixels+image->packets-1;s                 }a               q->index=index;                q->length=0;
             }g	         }i         break;       }i       case '3':(       {(
         /*9           Convert PNM image to runlength-encoded packets.m
         */8         for (i=0; i < (image->columns*image->rows); i++)	         { #           red=PNMInteger(image,10); %           green=PNMInteger(image,10);p$           blue=PNMInteger(image,10);(           if (scale != (Quantum *) NULL)
             {                red=scale[red]; !               green=scale[green];                blue=scale[blue];,
             },L           if ((red == q->red) && (green == q->green) && (blue == q->blue) &&/               ((int) q->length < MaxRunlength))              q->length++;           else
             {a&               if (image->packets != 0)                 q++;               image->packets++;i,               if (image->packets == packets)                 {a                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image);l3                   q=image->pixels+image->packets-1;                  }e               q->red=red;                q->green=green;p               q->blue=blue;l               q->index=0;)               q->length=0;
             }*	         } !         if (IsPseudoClass(image))n>           QuantizeImage(image,MaxRGB+1,8,False,RGBColorspace);         break;       }U       case '4':g       {p         unsigned charv           bit,           byte;o           unsigned int           x,           y;  
         /*=           Convert PBM raw image to runlength-encoded packets.t
         */'         for (y=0; y < image->rows; y++)a	         {            bit=0;           byte=0;a,           for (x=0; x < image->columns; x++)           {              if (bit == 0) &               byte=fgetc(image->file);(             index=(byte & 0x80) ? 0 : 1;H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {0(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;;                   }e                 q->index=index;;                 q->length=0;               }              bit++;             if (bit == 8))               bit=0;             byte<<=1;            }e	         }m         break;       }h       case '5':        case '7':        { 
         /*=           Convert PGM raw image to runlength-encoded packets.)
         */8         for (i=0; i < (image->columns*image->rows); i++)	         { '           if (max_value <= MaxRawValue) %             index=fgetc(image->file);(           else1             index=LSBFirstReadShort(image->file);eF           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             { &               if (image->packets != 0)                 q++;               image->packets++;t,               if (image->packets == packets)                 {                    packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image); 3                   q=image->pixels+image->packets-1;                  }g               q->index=index;                q->length=0;
             }g	         }e         break;       }x       case '6':l       { 
         /*@           Convert PNM raster image to runlength-encoded packets.
         */8         for (i=0; i < (image->columns*image->rows); i++)	         { '           if (max_value <= MaxRawValue)t
             { %               red=fgetc(image->file);t'               green=fgetc(image->file);i&               blue=fgetc(image->file);
             }r           else
             {a1               red=LSBFirstReadShort(image->file);r3               green=LSBFirstReadShort(image->file);(2               blue=LSBFirstReadShort(image->file);
             }w(           if (scale != (Quantum *) NULL)
             {a               red=scale[red];(!               green=scale[green];)               blue=scale[blue];-
             } L           if ((red == q->red) && (green == q->green) && (blue == q->blue) &&/               ((int) q->length < MaxRunlength))P             q->length++;           else
             {e&               if (image->packets != 0)                 q++;               image->packets++; ,               if (image->packets == packets)                 {]                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image);l3                   q=image->pixels+image->packets-1;                  }                q->red=red;U               q->green=green;-               q->blue=blue;+               q->index=0;r               q->length=0;
             } 	         }l!         if (IsPseudoClass(image)) >           QuantizeImage(image,MaxRGB+1,8,False,RGBColorspace);         break;       }        default:4         PrematureExit("Not a PNM image file",image);     }c"     if (scale != (Quantum *) NULL)       free((char *) scale); $     if (image->class == PseudoClass)       {g         SyncImage(image);t          CompressColormap(image);       }f%     image->pixels=(RunlengthPacket *)oM       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));U     /*       Proceed to next image.     */>     if ((format == '1') || (format == '2') || (format == '3'))       do       { 
         /*           Skip to end of line.
         */1         status=ReadData(&format,1,1,image->file);(         if (status == False)           break;       } while (format != '\n');g6     status=ReadData((char *) &format,1,1,image->file);,     if ((status == True) && (format == 'P'))       { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {o!             DestroyImages(image); #             return((Image *) NULL);c           }IB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } 0   } while ((status == True) && (format == 'P'));+   while (image->previous != (Image *) NULL)c     image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             % O %                                                                             % O %                                                                             %)O %  R e a d P S I m a g e                                                      %mO %                                                                             %fO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %tO %  Function ReadPSImage reads a Adobe Postscript image file and returns it.  ItGK %  allocates the memory necessary for the new Image structure and returns ag %  pointer to the new image. % , %  The format of the ReadPSImage routine is: %b$ %      image=ReadPSImage(image_info) %u+ %  A description of each parameter follows:r %tH %    o image:  Function ReadPSImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.% %%A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */% static Image *ReadPSImage(image_info) 	 ImageInfo    *image_info; { % #define BoundingBox  "%%BoundingBox:" - #define PageBoundingBox  "%%PageBoundingBox:"      char     command[MaxTextLength], !     crop_geometry[MaxTextLength],      *device,     filename[MaxTextLength],     options[MaxTextLength], '     postscript_filename[MaxTextLength];      FILE
     *file;     Image      *image,      *next_image;     int      status;   
   long int
     filesize;      register int     i;     /*     Allocate image structure.%   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)t/     PrematureExit("Unable to open file",image);t   /*     Open temporary output file.t   */)   TemporaryFilename(postscript_filename);a&   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);   /*5     Determine if Postscript specifies a bounding box.g   */   *options='\0';   *crop_geometry='\0';E   while (fgets(command,MaxTextLength-1,image->file) != (char *) NULL)s   {iB     if ((strncmp(BoundingBox,command,strlen(BoundingBox)) == 0) ||H         (strncmp(PageBoundingBox,command,strlen(PageBoundingBox)) == 0))       {          int            count,           flags,           lower_x,           lower_y,           upper_x,           upper_y,           x,           y;           unsigned int           dx_resolution,           dy_resolution,           x_resolution,f           y_resolution;)  B         if (strncmp(BoundingBox,command,strlen(BoundingBox)) == 0)P           count=sscanf(command,"%%%%BoundingBox: %d %d %d %d",&lower_x,&lower_y,             &upper_x,&upper_y); J         if (strncmp(PageBoundingBox,command,strlen(PageBoundingBox)) == 0)B           count=sscanf(command,"%%%%PageBoundingBox: %d %d %d %d",1             &lower_x,&lower_y,&upper_x,&upper_y);o         if (count != 4)m           continue;a
         /*!           Determine bounding box.-
         */E         (void) XParseGeometry(PSDensityGeometry,&x,&y,&dx_resolution,c           &dy_resolution);#         x_resolution=dx_resolution;u#         y_resolution=dy_resolution;          flags=0;1         if (image_info->density != (char *) NULL) G           flags=XParseGeometry(image_info->density,&x,&y,&x_resolution,)             &y_resolution);i'         if ((flags & HeightValue) == 0) $           y_resolution=x_resolution;.         if (image_info->page == (char *) NULL)           {c             unsigned int               height,p               width;               /*-               Set Postscript render geometry.n             */I             width=(((lower_x+upper_x)*x_resolution+(dx_resolution >> 1))/P               dx_resolution)+1;(J             height=(((lower_x+upper_y)*y_resolution+(dy_resolution >> 1))/               dy_resolution)+1;=:             (void) sprintf(options,"-g%ux%u",width,width);             if (width < height))>               (void) sprintf(options,"-g%ux%u",height,height);/             (void) strcpy(crop_geometry,"0x0");            }+       }l     (void) fputs(command,file);p   }s   if (ferror(file));     { K       Warning("An error has occurred writing to file",postscript_filename);        (void) fclose(file);       return((Image *) NULL);h     }*   (void) fclose(file);   CloseImage(image);   filesize=image->filesize;c   DestroyImage(image);   /*@     Determine if page geometry or density options are specified.   */(   if (image_info->page != (char *) NULL)     {g#       (void) strcat(options," -g"); .       (void) strcat(options,image_info->page);     } +   if (image_info->density != (char *) NULL)t     { #       (void) strcat(options," -r");e1       (void) strcat(options,image_info->density);m     }    /*0     Use Ghostscript to convert Postscript image.   */   device="ppmraw";   if (image_info->monochrome)%     device="pbmraw";/   (void) strcpy(filename,image_info->filename);    for (i=0; i < 50; i++)   {      /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   } O   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,      postscript_filename);     status=SystemCommand(command);*   if (access(image_info->filename,0) != 0)     {        /*1         Ghostscript requires a showpage operator.        */*       file=fopen(postscript_filename,"a");        if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);&       (void) fputs("showpage\n",file);       (void) fclose(file);$       status=SystemCommand(command);     } 
   if (status)e     { D       Warning("Postscript translation failed",image_info->filename);)       (void) unlink(postscript_filename);H       return((Image *) NULL);      }R!   image=ReadPNMImage(image_info);d%   (void) unlink(postscript_filename); &   (void) unlink(image_info->filename);   if (image == (Image *) NULL)     { D       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);n     }e   do   { ,     (void) strcpy(image->filename,filename);     image->filesize=filesize;      if (*crop_geometry != '\0')d0       if (Intensity(image->pixels[0]) == MaxRGB)	         {e           /*!             Crop to bounding box.            */=           TransformImage(&image,crop_geometry,(char *) NULL);g,           if (image->next != (Image *) NULL)(             image->next->previous=image;	         }e     next_image=image->next;t%     if (next_image != (Image *) NULL)        image=next_image;i)   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)m     image=image->previous;   return(image); }m   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             %oO %                                                                             %sO %                                                                             % O %  R e a d R A D I A N C E I m a g e                                          %iO %                                                                             %rO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %mI %  Function ReadRADIANCEImage reads a RADIANCE image file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % 2 %  The format of the ReadRADIANCEImage routine is: %i* %      image=ReadRADIANCEImage(image_info) %f+ %  A description of each parameter follows:  % N %    o image:  Function ReadRADIANCEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.c % A %    o image_info: Specifies a pointer to an ImageInfo structure.. %  %  */+ static Image *ReadRADIANCEImage(image_info)c	 ImageInfo(   *image_info; {    char     command[MaxTextLength],g     filename[MaxTextLength];     Imagea     *image,o     *next_image;     int      status;h     /*     Allocate image structure.|   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);e   CloseImage(image);   /*)     Use ra_ppm to convert RADIANCE image.t   *//   (void) strcpy(filename,image_info->filename); *   TemporaryFilename(image_info->filename);G   (void) sprintf(command,"ra_ppm %s %s",filename,image_info->filename);c    status=SystemCommand(command);
   if (status)-7     PrematureExit("RADIANCE translation failed",image);l   DestroyImage(image);!   image=ReadPNMImage(image_info); &   (void) unlink(image_info->filename);   if (image == (Image *) NULL)7     PrematureExit("RADIANCE translation failed",image);l   /*     Assign proper filename.    */   do   {r,     (void) strcpy(image->filename,filename);     next_image=image->next; %     if (next_image != (Image *) NULL)i       image=next_image;+)   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }l   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%DO %                                                                             %iO %                                                                             %mO %                                                                             %mO %  R e a d R G B I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadRGBImage reads an image of raw red, green, and blue bytes andlM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadRGBImage routine is:R %.% %      image=ReadRGBImage(image_info)  % + %  A description of each parameter follows:y % I %    o image:  Function ReadRGBImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %iA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadRGBImage(image_info)	 ImageInfo    *image_info; {0   Imageg     *image;+     int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;x     unsigned chars     *rgb_pixels;     unsigned int     height,+     packet_size,
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);n   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)B/     PrematureExit("Unable to open file",image);;   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;S   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.-   */   packet_size=3;-   if (strcmp(image_info->magick,"RGBA") == 0)      {-       image->matte=True;       packet_size=4;     })   image->columns=width;    image->rows=height;p,   image->packets=image->columns*image->rows;   rgb_pixels=(unsigned char *)=     malloc(packet_size*image->packets*sizeof(unsigned char));T#   image->pixels=(RunlengthPacket *)03     malloc(image->packets*sizeof(RunlengthPacket));b/   if ((rgb_pixels == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);F   /*6     Convert raster image to runlength-encoded packets.   */D   (void) ReadData((char *) rgb_pixels,3,image->packets,image->file);   p=rgb_pixels;e    switch (image_info->interlace)   {      case NoneInterlace:t     default:     {        /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {e         q->red=UpScale(*p++);,         q->green=UpScale(*p++);          q->blue=UpScale(*p++);         q->index=0;s         if (image->matte))           q->index=(*p++);         q->length=0;         q++;       },       break;     }      case LineInterlace:      {        /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...t       */%       for (y=0; y < image->rows; y++)s       { )         q=image->pixels+y*image->columns;a*         for (x=0; x < image->columns; x++)	         {e           q->red=UpScale(*p++);m           q->index=0;N           q->length=0;           q++;	         }))         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {,!           q->green=UpScale(*p++);g           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {g            q->blue=UpScale(*p++);           q++;	         }a)         q=image->pixels+y*image->columns;=         if (image->matte)i,           for (x=0; x < image->columns; x++)           { #             q->index=UpScale(*p++);n             q++;           }l       }i       break;     }e     case PlaneInterlace:     {        /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...%       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->red=UpScale(*p++);          q->index=0;          q->length=0;         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->green=UpScale(*p++);S         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->blue=UpScale(*p++);         q++;       }        q=image->pixels;       if (image->matte) *         for (i=0; i < image->packets; i++)	         { !           q->index=UpScale(*p++);            q++;	         }%       break;     }%   }%   free((char *) rgb_pixels);   CompressImage(image);    CloseImage(image);   return(image); }f   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %MO %                                                                             %sO %                                                                             %aO %  R e a d R L E I m a g e                                                    %eO %                                                                             % O %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %fG %  Function ReadRLEImage reads a run-length encoded Utah Raster Toolkit%L %  image file and returns it.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. % - %  The format of the ReadRLEImage routine is:  % % %      image=ReadRLEImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadRLEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadRLEImage(image_info)	 ImageInfo    *image_info; {% #define SkipLinesOp  0x01% #define SetColorOp  0x02 #define SkipPixelsOp  0x03 #define ByteDataOp  0x05 #define RunDataOp  0x06I #define EOFOp  0x07m     char     magick[12];      Imaget     *image;n     intp     opcode,      operand,     status,a     x,     y;     register int     i,     j;     register RunlengthPacket     *q;d     register unsigned char     *p;      unsigned char      background_color[256],     *colormap,
     pixel,
     plane,     *rle_pixels;     unsigned int     bits_per_pixel,y
     flags,     map_length,m     number_colormaps,      number_planes;     /*     Allocate image structure.r   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);e   /*$     Determine if this is a RLE file.   */3   status=ReadData((char *) magick,1,2,image->file);t?   if ((status == False) || (strncmp(magick,"\122\314",2) != 0)) 0     PrematureExit("Not a RLE image file",image);   do   {      /*       Read image header.     */*     (void) LSBFirstReadShort(image->file);*     (void) LSBFirstReadShort(image->file);2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file);,.     image->packets=image->columns*image->rows;     flags=fgetc(image->file);      image->matte=flags & 0x04;%     number_planes=fgetc(image->file);5&     bits_per_pixel=fgetc(image->file);(     number_colormaps=fgetc(image->file);'     map_length=1 << fgetc(image->file);oP     if ((number_planes == 0) || (number_planes == 2) || (bits_per_pixel != 8) ||         (image->columns == 0))8       PrematureExit("Unsupported RLE image file",image);     if (flags & 0x02)        { 
         /*4           No background color-- initialize to black.
         */)         for (i=0; i < number_planes; i++);0           background_color[i]=(unsigned char) 0;"         (void) fgetc(image->file);       }t     else       {i
         /*&           Initialize background color.
         */         p=background_color;=)         for (i=0; i < number_planes; i++)*2           *p++=(unsigned char) fgetc(image->file);       }g$     if ((number_planes & 0x01) == 0)        (void) fgetc(image->file);$     colormap=(unsigned char *) NULL;     if (number_colormaps != 0)       { 
         /*           Read image colormaps.c
         */"         colormap=(unsigned char *)D           malloc(number_colormaps*map_length*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);-         p=colormap;t,         for (i=0; i < number_colormaps; i++)(           for (j=0; j < map_length; j++)<             *p++=XDownScale(LSBFirstReadShort(image->file));       }-     if (flags & 0x08)        {l         unsigned int           length;b  
         /*           Read image comment.m
         */.         length=LSBFirstReadShort(image->file);=         image->comments=(char *) malloc(length*sizeof(char));a-         if (image->comments == (char *) NULL));           PrematureExit("Unable to allocate memory",image);0I         (void) ReadData((char *) image->comments,1,length-1,image->file);s'         image->comments[length-1]='\0'; !         if ((length & 0x01) == 0) $           (void) fgetc(image->file);       }      /*       Allocate RLE pixels.     */     if (image->matte)l       number_planes++;      rle_pixels=(unsigned char *)A       malloc(image->packets*number_planes*sizeof(unsigned char));e-     if (rle_pixels == (unsigned char *) NULL)a7       PrematureExit("Unable to allocate memory",image);**     if ((flags & 0x01) && !(flags & 0x02))       {a
         /*           Set background color. 
         */         p=rle_pixels;c*         for (i=0; i < image->packets; i++)	         {_           if (!image->matte)-             for (j=0; j < number_planes; j++)e'               *p++=background_color[j];            else
             {p3               for (j=0; j < (number_planes-1); j++) )                 *p++=background_color[j]; 5               *p++=0;  /* initialize matte channel */ 
             } 	         }_       }&     /*#       Read runlength-encoded image.p     */     plane=0;     x=0;     y=0;     opcode=fgetc(image->file);     do     {e       switch (opcode & 0x3f)       {          case SkipLinesOp: 	         {e%           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);e           x=0;           y+=operand;;           break;	         }P         case SetColorOp:	         {p%           operand=fgetc(image->file);c           plane=operand;           if (plane == 255) "             plane=number_planes-1;           x=0;           break;	         }%         case SkipPixelsOp:	         { %           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);            x+=operand;            break;	         }          case ByteDataOp:	         { %           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file); H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;           operand++;%           for (i=0; i < operand; i++)            { %             pixel=fgetc(image->file);%>             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;              p+=number_planes;u           }l           if (operand & 0x01)r&             (void) fgetc(image->file);           x+=operand;n           break;	         }          case RunDataOp:i	         { %           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);P#           pixel=fgetc(image->file);e$           (void) fgetc(image->file);           operand++;H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;%           for (i=0; i < operand; i++)t           {m>             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;              p+=number_planes;            }j           x+=operand;t           break;	         }          default:           break;       }a        opcode=fgetc(image->file);<     } while (((opcode & 0x3f) != EOFOp) && (opcode != EOF));     if (number_colormaps != 0)       {a         unsigned int           mask;p  
         /*1           Apply colormap transformation to image.p
         */         mask=(map_length-1);         p=rle_pixels;h"         if (number_colormaps == 1),           for (i=0; i < image->packets; i++)           {t3             *p=(unsigned char) colormap[*p & mask];a             p++;           }          else>           if ((number_planes >= 3) && (number_colormaps >= 3)).             for (i=0; i < image->packets; i++)/               for (j=0; j < number_planes; j++)                {-F                 *p=(unsigned char) colormap[j*map_length+(*p & mask)];                 p++;               }        }      /*!       Initialize image structure.      */%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket));a2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      q=image->pixels;     if (number_planes >= 3)m       { 
         /*H           Convert raster image to DirectClass runlength-encoded packets.
         */         p=rle_pixels; *         for (i=0; i < image->packets; i++)	         {s           q->red=UpScale(*p++);(!           q->green=UpScale(*p++);_            q->blue=UpScale(*p++);@           q->index=(unsigned short) (image->matte ? (*p++) : 0);           q->length=0;           q++;	         }        }l     else       {r
         /*           Create colormap.
         */!         image->class=PseudoClass;t"         if (number_colormaps == 0)           map_length=256; !         image->colors=map_length;m'         image->colormap=(ColorPacket *)*4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);;         p=colormap; "         if (number_colormaps == 0)+           for (i=0; i < image->colors; i++)q           {t             /*               Grayscale.             */@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);N           }u         else$           if (number_colormaps == 1)-             for (i=0; i < image->colors; i++) 
             {L               /*                 Pseudocolor.               */:               image->colormap[i].red=(Quantum) UpScale(i);<               image->colormap[i].green=(Quantum) UpScale(i);;               image->colormap[i].blue=(Quantum) UpScale(i);n
             }            else-             for (i=0; i < image->colors; i++)c
             { 1               image->colormap[i].red=UpScale(*p);/@               image->colormap[i].green=UpScale(*(p+map_length));A               image->colormap[i].blue=UpScale(*(p+map_length*2));j               p++;
             }o         p=rle_pixels;e         if (!image->matte)           {e             /*L               Convert raster image to PseudoClass runlength-encoded packets.             */.             for (i=0; i < image->packets; i++)
             {n/               q->index=(unsigned short) (*p++);L               q->length=0;               q++;
             };             SyncImage(image);            }r         else           {              /*A               Image has a matte channel-- promote to DirectClass.e             */.             for (i=0; i < image->packets; i++)
             {g-               q->red=image->colormap[*p].red;=1               q->green=image->colormap[*p].green;t1               q->blue=image->colormap[*p++].blue;s/               q->index=(unsigned short) (*p++);j               q->length=0;               q++;
             }f"             free(image->colormap);1             image->colormap=(ColorPacket *) NULL;g%             image->class=DirectClass;o             image->colors=0;           }_       }m     if (number_colormaps != 0)       free((char *) colormap);     free((char *) rle_pixels);     CompressImage(image);s     /*       Proceed to next image.     */     (void) fgetc(image->file);5     status=ReadData((char *) magick,1,2,image->file);(@     if ((status == True) && (strncmp(magick,"\122\314",2) == 0))       {*
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {R!             DestroyImages(image);j#             return((Image *) NULL);            }(B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }gD   } while ((status == True) && (strncmp(magick,"\122\314",2) == 0));+   while (image->previous != (Image *) NULL))     image=image->previous;   CloseImage(image);   return(image); }  o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %pO %                                                                             %pO %                                                                             %PO %  R e a d S G I I m a g e                                                    % O %                                                                             %;O %                                                                             %pO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eG %  Function ReadSGIImage reads a SGI RGB image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns an %  pointer to the new image. % - %  The format of the ReadSGIImage routine is:  % % %      image=ReadSGIImage(image_info)C %)+ %  A description of each parameter follows:  %sI %    o image:  Function ReadSGIImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.q %l %  */  % static void SGIDecode(packets,pixels)-
 unsigned charn   *packets, 
   *pixels; {;   unsigned char 
     count,
     pixel;     for ( ; ;)   {      pixel=(*packets++);      count=pixel & 0x7f;      if (count == 0)s       break;     if (pixel & 0x80) "       for ( ; count != 0; count--)       {l         *pixels=(*packets++);          pixels+=4;       }e     else       {z         pixel=(*packets++); $         for ( ; count != 0; count--)	         {N           *pixels=pixel;           pixels+=4;	         }p       })   }  }   & static Image *ReadSGIImage(image_info)	 ImageInfo    *image_info; {t   typedef struct _SGIHeadere   {,     unsigned short       magic;       unsigned charx       storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,=       depth;       unsigned long        minimum_value,       maximum_value;       unsigned char=       filler[492];   } SGIHeader;     Imagee     *image;e     SGIHeaderf     iris_header;     register int     i,     x,     y,     z;     register RunlengthPacket     *q;o     register unsigned char     *p;e     unsigned charr     *iris_pixels;x     /*     Allocate image structure.(   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)r/     PrematureExit("Unable to open file",image);u   /*     Read SGI raster header.    */3   iris_header.magic=MSBFirstReadShort(image->file);%   do   {%     /*       Verify SGI identifier.     */$     if (iris_header.magic != 0x01DA)1       PrematureExit("Not a SGI RGB image",image); +     iris_header.storage=fgetc(image->file); 3     iris_header.bytes_per_pixel=fgetc(image->file); )     if (iris_header.bytes_per_pixel != 1)aF       PrematureExit("Image must have 1 byte per pixel channel",image);9     iris_header.dimension=MSBFirstReadShort(image->file); 7     iris_header.columns=MSBFirstReadShort(image->file); 4     iris_header.rows=MSBFirstReadShort(image->file);5     iris_header.depth=MSBFirstReadShort(image->file); <     iris_header.minimum_value=MSBFirstReadLong(image->file);<     iris_header.maximum_value=MSBFirstReadLong(image->file);2     (void) ReadData((char *) iris_header.filler,1,=       (unsigned int) sizeof(iris_header.filler),image->file);      /*       Allocate SGI pixels.     */!     iris_pixels=(unsigned char *)IK       malloc(4*iris_header.columns*iris_header.rows*sizeof(unsigned char));p.     if (iris_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);e$     if (iris_header.storage != 0x01)       {e         unsigned chary           *scanline;  
         /*%           Read standard image format.S
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL)h;           PrematureExit("Unable to allocate memory",image);I3         for (z=0; z < (int) iris_header.depth; z++)r	         {;           p=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           {rD             (void) ReadData((char *) scanline,1,iris_header.columns,               image->file); 9             for (x=0; x < (int) iris_header.columns; x++) 
             {I               *p=scanline[x];=               p+=4;0
             }L           } 	         }v          free((char *) scanline);       }      else       {)         unsigned charn           *packets;r           unsigned int           data_order;i           unsigned longv           offset,l           *offsets,n           *runlength;)  
         /*.           Read runlength-encoded image format.
         */!         offsets=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));m!         packets=(unsigned char *)sH           malloc(((iris_header.columns << 1)+10)*sizeof(unsigned char));#         runlength=(unsigned long *)%K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); 2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL));           PrematureExit("Unable to allocate memory",image); F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)3           offsets[i]=MSBFirstReadLong(image->file); F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)5           runlength[i]=MSBFirstReadLong(image->file); 
         /*           Check data order. 
         */         offset=0;          data_order=0; E         for (y=0; ((y < (int) iris_header.rows) && !data_order); y++)%H           for (z=0; ((z < (int) iris_header.depth) && !data_order); z++)           {o7             if (offsets[y+z*iris_header.rows] < offset)m               data_order=1;g1             offset=offsets[y+z*iris_header.rows];m           }TA         offset=512+4*((iris_header.rows*iris_header.depth) << 1);P         if (data_order == 1)           { 7             for (z=0; z < (int) iris_header.depth; z++)d
             {s               p=iris_pixels;8               for (y=0; y < (int) iris_header.rows; y++)               { <                 if (offset != offsets[y+z*iris_header.rows])                   {r9                     offset=offsets[y+z*iris_header.rows];d=                     (void) fseek(image->file,(int) offset,0);                    } 3                 (void) ReadData((char *) packets,1,rN                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z); +                 p+=(iris_header.columns*4);l               }_
             }m           }          else           {              p=iris_pixels;6             for (y=0; y < (int) iris_header.rows; y++)
             {*9               for (z=0; z < (int) iris_header.depth; z++)                {n<                 if (offset != offsets[y+z*iris_header.rows])                   {g9                     offset=offsets[y+z*iris_header.rows];)=                     (void) fseek(image->file,(int) offset,0);o                   } 3                 (void) ReadData((char *) packets,1,-N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z);;               }*)               p+=(iris_header.columns*4);c
             }l           }e         free(runlength);         free(packets);         free(offsets);       }a     /*!       Initialize image structure.p     */(     image->matte=iris_header.depth == 4;'     image->columns=iris_header.columns; !     image->rows=iris_header.rows; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)l5       malloc(image->packets*sizeof(RunlengthPacket));l2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert SGI raster image to runlength-encoded packets.     */     q=image->pixels;     if (iris_header.depth >= 3)        {u
         /*E           Convert SGI image to DirectClass runlength-encoded packets.v
         */'         for (y=0; y < image->rows; y++) 	         {z?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4);-,           for (x=0; x < image->columns; x++)           {*             q->red=UpScale(*p);-%             q->green=UpScale(*(p+1));a$             q->blue=UpScale(*(p+2));             q->index=(*(p+3));             q->length=0;             p+=4;l             q++;           } 	         }a       }a     else       {p         unsigned short           index;  
         /*           Create grayscale map.g
         */!         image->class=PseudoClass;t         image->colors=256;'         image->colormap=(ColorPacket *)s4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image); )         for (i=0; i < image->colors; i++) 	         { 6           image->colormap[i].red=(Quantum) UpScale(i);8           image->colormap[i].green=(Quantum) UpScale(i);7           image->colormap[i].blue=(Quantum) UpScale(i); 	         }A
         /*E           Convert SGI image to PseudoClass runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4); ,           for (x=0; x < image->columns; x++)           { (             index=(unsigned short) (*p);             q->index=index;%             q->length=0;             p+=4;              q++;           }e           SyncImage(image);b	         }t       }      free((char *) iris_pixels);a     CompressImage(image);u     /*       Proceed to next image.     */5     iris_header.magic=MSBFirstReadShort(image->file); $     if (iris_header.magic == 0x01DA)       { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {r!             DestroyImages(image); #             return((Image *) NULL);d           }oB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } (   } while (iris_header.magic == 0x01DA);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %aO %                                                                             % O %                                                                             %gO %  R e a d S U N I m a g e                                                    %>O %                                                                             %hO %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %nM %  Function ReadSUNImage reads a SUN image file and returns it.  It allocatesRL %  the memory necessary for the new Image structure and returns a pointer to %  the new image.( %i- %  The format of the ReadSUNImage routine is:  %n% %      image=ReadSUNImage(image_info)i %U+ %  A description of each parameter follows:  %vI %    o image:  Function ReadSUNImage returns a pointer to the image afteraL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.c %sA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %b */& static Image *ReadSUNImage(image_info)	 ImageInfon   *image_info; {  #define RMT_EQUAL_RGB  1 #define RMT_NONE  0m #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_ENCODED  2% #define RT_FORMAT_RGB  3     typedef struct _SUNHeader%   {%     unsigned long        magic,       width,
       height,        depth,
       length,        type,        maptype,       maplength;   } SUNHeader;     Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      SUNHeader      sun_header;      unsigned char      *sun_data,     *sun_pixels;     unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read SUN raster header.t   */1   sun_header.magic=MSBFirstReadLong(image->file);n   do   {i     /*       Verify SUN identifier.     */'     if (sun_header.magic != 0x59a66a95)i4       PrematureExit("Not a SUN raster image",image);3     sun_header.width=MSBFirstReadLong(image->file);R4     sun_header.height=MSBFirstReadLong(image->file);3     sun_header.depth=MSBFirstReadLong(image->file); 4     sun_header.length=MSBFirstReadLong(image->file);2     sun_header.type=MSBFirstReadLong(image->file);5     sun_header.maptype=MSBFirstReadLong(image->file);d7     sun_header.maplength=MSBFirstReadLong(image->file);      switch (sun_header.maptype)      {a       case RMT_NONE:       { "         if (sun_header.depth < 24)           {              /*'               Create linear color ramp.              */0             image->colors=1 << sun_header.depth;+             image->colormap=(ColorPacket *)i8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image); -             for (i=0; i < image->colors; i++)t
             { B               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);;
             }(           })         break;       }        case RMT_EQUAL_RGB:a       {d         unsigned charc           *sun_colormap;  
         /*#           Read SUN raster colormap. 
         */-         image->colors=sun_header.maplength/3; '         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         sun_colormap=(unsigned char *)6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (sun_colormap == (unsigned char *) NULL)) ;           PrematureExit("Unable to allocate memory",image); K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file); )         for (i=0; i < image->colors; i++) :           image->colormap[i].red=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);c)         for (i=0; i < image->colors; i++) <           image->colormap[i].green=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);m)         for (i=0; i < image->colors; i++)c;           image->colormap[i].blue=UpScale(sun_colormap[i]); $         free((char *) sun_colormap);         break;       };       case RMT_RAW:m       {e         unsigned charn           *sun_colormap;  
         /*#           Read SUN raster colormap. 
         */&         sun_colormap=(unsigned char *)=           malloc(sun_header.maplength*sizeof(unsigned char)); 3         if (sun_colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); >         (void) ReadData((char *) sun_colormap,1,(unsigned int),           sun_header.maplength,image->file);$         free((char *) sun_colormap);         break;       }t       default:>         PrematureExit("Colormap type is not supported",image);     } O     sun_data=(unsigned char *) malloc(sun_header.length*sizeof(unsigned char)); +     if (sun_data == (unsigned char *) NULL)f7       PrematureExit("Unable to allocate memory",image);(I     status=ReadData((char *) sun_data,1,(unsigned int) sun_header.length,e       image->file); =     if ((status == False) && (sun_header.type != RT_ENCODED)) 7       PrematureExit("Unable to read image data",image);      sun_pixels=sun_data;&     if (sun_header.type == RT_ENCODED)       {f         unsigned int           width,           height;v  
         /*0           Read run-length encoded raster pixels.
         */?         width=sun_header.width*(((sun_header.depth-1) >> 3)+1);=!         height=sun_header.height;sP         sun_pixels=(unsigned char *) malloc(width*height*sizeof(unsigned char));1         if (sun_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); @         (void) SUNDecodeImage(sun_data,sun_pixels,width,height);          free((char *) sun_data);       }      /*!       Initialize image structure.n     */*     image->matte=(sun_header.depth == 32);E     image->class=(sun_header.depth < 24 ? PseudoClass : DirectClass);n$     image->columns=sun_header.width;"     image->rows=sun_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert SUN raster image to runlength-encoded packets.     */     p=sun_pixels;      q=image->pixels;     if (sun_header.depth == 1)%       for (y=0; y < image->rows; y++);       { 
         /*E           Convert bitmap scanline to runlength-encoded color packets.)
         */1         for (x=0; x < (image->columns >> 3); x++)c	         {r&           for (bit=7; bit >= 0; bit--)           { :             q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);             q->length=0;             q++;           }            p++;	         }m&         if ((image->columns % 8) != 0)           { ?             for (bit=7; bit >= (8-(image->columns % 8)); bit--) 
             {r<               q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);               q->length=0;               q++;
             }              p++;           } I         if ((((image->columns/8)+(image->columns % 8 ? 1 : 0)) % 2) != 0)            p++;       }s     else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++)y	         {"           /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {u             q->index=(*p++);             q->length=0;             q++;           } (           if ((image->columns % 2) != 0)             p++;	         }i
       else'         for (y=0; y < image->rows; y++) 	         {r           /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           { B             q->index=(unsigned short) (image->matte ? (*p++) : 0);/             if (sun_header.type == RT_STANDARD)                {=&                 q->blue=UpScale(*p++);'                 q->green=UpScale(*p++);o%                 q->red=UpScale(*p++);o               }              else               {r%                 q->red=UpScale(*p++);f'                 q->green=UpScale(*p++);c&                 q->blue=UpScale(*p++);               } #             if (image->colors != 0)i               { 3                 q->red=image->colormap[q->red].red;e9                 q->green=image->colormap[q->green].green; 6                 q->blue=image->colormap[q->blue].blue;               }              q->length=0;             q++;           } E           if (((image->columns % 2) != 0) && (image->matte == False))x             p++;	         }      free((char *) sun_pixels);$     if (image->class == PseudoClass)       {y         SyncImage(image);           CompressColormap(image);       }c     CompressImage(image);      /*       Proceed to next image.     */3     sun_header.magic=MSBFirstReadLong(image->file);d'     if (sun_header.magic == 0x59a66a95)        {r
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {+!             DestroyImages(image);l#             return((Image *) NULL);g           }sB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } +   } while (sun_header.magic == 0x59a66a95);b+   while (image->previous != (Image *) NULL)m     image=image->previous;   CloseImage(image);   return(image); }g m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/O %                                                                             % O %                                                                             % O %                                                                             %lO %  R e a d T A R G A I m a g e                                                %iO %                                                                             %UO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %lJ %  Function ReadTARGAImage reads a Truevision Targa image file and returnsI %  it.  It allocates the memory necessary for the new Image structure ando& %  returns a pointer to the new image. %c/ %  The format of the ReadTARGAImage routine is:; % ' %      image=ReadTARGAImage(image_info)* %U+ %  A description of each parameter follows:a %cK %    o image:  Function ReadTARGAImage returns a pointer to the image aftersL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.; %+A %    o image_info: Specifies a pointer to an ImageInfo structure.d %; %  */( static Image *ReadTARGAImage(image_info)	 ImageInfo    *image_info; {u #define TargaColormap 1, #define TargaRGB 2 #define TargaMonochrome 3  #define TargaRLEColormap  9  #define TargaRLERGB  10m #define TargaRLEMonochrome  11     typedef struct _TargaHeaderl   {      unsigned charm       id_length,       colormap_type,       image_type;        unsigned short       colormap_index,l       colormap_length;       unsigned charm       colormap_size;       unsigned short       x_origin,g       y_origin,        width,
       height;m       unsigned charE       pixel_size,        attributes;_   } TargaHeader;     Imageg     *image;e  	   Quantumm	     blue,s
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;f  
   TargaHeaderi     targa_header;)     unsigned chare     j,     k,     runlength;     unsigned int	     base, 	     flag,g	     real,=	     skip,      status,-	     true;a     unsigned short
     index;     /*     Allocate image structure.n   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);r   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)x/     PrematureExit("Unable to open file",image);o   /*"     Read TARGA header information.   */D   status=ReadData((char *) &targa_header.id_length,1,1,image->file);0   targa_header.colormap_type=fgetc(image->file);-   targa_header.image_type=fgetc(image->file);    do   {u>     if ((status == False) || (targa_header.image_type == 0) ||'         (targa_header.image_type > 11)) 4       PrematureExit("Not a TARGA image file",image);?     targa_header.colormap_index=LSBFirstReadShort(image->file); @     targa_header.colormap_length=LSBFirstReadShort(image->file);2     targa_header.colormap_size=fgetc(image->file);9     targa_header.x_origin=LSBFirstReadShort(image->file);i9     targa_header.y_origin=LSBFirstReadShort(image->file);a6     targa_header.width=LSBFirstReadShort(image->file);7     targa_header.height=LSBFirstReadShort(image->file); /     targa_header.pixel_size=fgetc(image->file);;/     targa_header.attributes=fgetc(image->file);      /*!       Initialize image structure.a     *//     image->matte=targa_header.pixel_size == 32;e&     image->columns=targa_header.width;$     image->rows=targa_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket));k2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);p$     if (targa_header.id_length != 0)       {r
         /*           TARGA image comment.
         */          image->comments=(char *):           malloc((targa_header.id_length+1)*sizeof(char));-         if (image->comments == (char *) NULL)e;           PrematureExit("Unable to allocate memory",image); N         (void) ReadData(image->comments,1,targa_header.id_length,image->file);5         image->comments[targa_header.id_length]='\0';        }=(     if (targa_header.colormap_type != 0)       {c
         /*%           Read TARGA raster colormap.*
         */<         if ((targa_header.image_type == TargaRLEColormap) ||5             (targa_header.image_type == TargaRLERGB))m#           image->class=PseudoClass; 3         image->colors=targa_header.colormap_length;)'         image->colormap=(ColorPacket *)r4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);;)         for (i=0; i < image->colors; i++) 	         { -           switch (targa_header.colormap_size)U           {g             case 8:              default:
             {                /*                 Gray scale."               */.               red=UpScale(fgetc(image->file));               green=red;               blue=red;                break;
             }              case 15:             case 16:
             {                /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file); #               k=fgetc(image->file); B               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum) P                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);               break;
             }              case 32:             case 24:
             {%               /*2                 8 bits each of blue green and red.               *//               blue=UpScale(fgetc(image->file));s0               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));               break;
             }            }a%           image->colormap[i].red=red;p)           image->colormap[i].green=green;o'           image->colormap[i].blue=blue; 	         }t       }a     /*8       Convert TARGA pixels to runlength-encoded packets.     */     base=0;      flag=0;e     index=0;     skip=False;a     real=0;i     runlength=0;     true=0;s#     for (y=0; y < image->rows; y++)*     {G       real=true;G       if (((unsigned char) (targa_header.attributes & 0x20) >> 5) == 0)           real=image->rows-real-1;,       q=image->pixels+(real*image->columns);(       for (x=0; x < image->columns; x++)       {d<         if ((targa_header.image_type == TargaRLEColormap) ||7             (targa_header.image_type == TargaRLERGB) ||a<             (targa_header.image_type == TargaRLEMonochrome))           if (runlength != 0) 
             {)               runlength--;               skip=flag != 0;g
             }(           else
             { C               status=ReadData((char *) &runlength,1,1,image->file);M"               if (status == False)A                 PrematureExit("Unable to read image data",image);m$               flag=runlength & 0x80;               if (flag != 0)                 runlength-=128;i               skip=False;y
             }*         if (!skip)*           switch (targa_header.pixel_size)           {              case 8:a             default:
             {m               /*                 Gray scale.n               */'               index=fgetc(image->file); 2               if (targa_header.colormap_type == 0)                 {a/                   red=(Quantum) UpScale(index); 1                   green=(Quantum) UpScale(index); 0                   blue=(Quantum) UpScale(index);                 }s               else                 {m1                   red=image->colormap[index].red;85                   green=image->colormap[index].green; 3                   blue=image->colormap[index].blue;e                 }n               break;
             }l             case 15:             case 16:
             {                /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file);l#               k=fgetc(image->file);sB               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum)-P                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);0               index=((unsigned short) k << 8)+j;               break;
             }-             case 24:             case 32:
             {                /*2                 8 bits each of blue green and red.               *//               blue=UpScale(fgetc(image->file)); 0               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));0               if (targa_header.pixel_size == 32))                 index=fgetc(image->file);e               break;
             }            }*         if (status == False);           PrematureExit("Unable to read image data",image);_         q->red=red;m         q->green=green;L         q->blue=blue;          q->index=index;)         q->length=0;         q++;       } G       if (((unsigned char) (targa_header.attributes & 0xc0) >> 6) == 4)e         true+=4;
       elseI         if (((unsigned char) (targa_header.attributes & 0xc0) >> 6) == 2)x           true+=2;         else           true++;        if (true >= image->rows)	         {            base++;o           true=base;	         }=     }p     (void) IsGrayImage(image);$     if (image->class == PseudoClass)       SyncImage(image);_     CompressImage(image);e     /*       Proceed to next image.     */F     status=ReadData((char *) &targa_header.id_length,1,1,image->file);2     targa_header.colormap_type=fgetc(image->file);/     targa_header.image_type=fgetc(image->file); P     status&=((targa_header.image_type != 0) && (targa_header.image_type <= 11));     if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }%   } while (status == True);%+   while (image->previous != (Image *) NULL)I     image=image->previous;   CloseImage(image);   return(image); }r e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %gO %                                                                             %nO %                                                                             % O %  R e a d T E X T I m a g e                                                  %bO %                                                                             % O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %nK %  Function ReadTEXTImage reads a text file and returns it as an image.  IteK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %L. %  The format of the ReadTEXTImage routine is: %(& %      image=ReadTEXTImage(image_info) % + %  A description of each parameter follows:e %mJ %    o image:  Function ReadTEXTImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %g */' static Image *ReadTEXTImage(image_info)a	 ImageInfoi   *image_info; {-   char     *text_status,g     text[MaxTextLength];  	   Displayc
     *display;l     Image)     *image;m     intl     status,t     offset,L     x,     y;     register int     i;     register RunlengthPacket     *p;r     RunlengthPacket      background_color;t     unsigned int     height,;
     width;     XAnnotateInfo      annotate_info;  
   XFontStructg     *font_info;      XPixelInfo     pixel_info;g     XResourceInfor     resource_info;  
   XrmDatabase      resource_database;     XStandardColormap(     *map_info;  
   XVisualInfor     *visual_info;>     /*     Allocate image structure.M   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"r");g#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);-   /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {p.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));g       DestroyImage(image);       return((Image *) NULL);      }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); )   resource_info.colormap=PrivateColormap;    /*     Allocate standard colormap.o   */#   XGetAnnotateInfo(&annotate_info); $   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)xM     Warning("Unable to create standard colormap","Memory allocation failed");    else     {        /*         Initialize visual info.u       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info);,.       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;=/       pixel_info.pixels=(unsigned long *) NULL;        /*         Initialize font info.        */,       if (image_info->font != (char *) NULL),         resource_info.font=image_info->font;8       font_info=XBestFont(display,&resource_info,False);,       if (font_info == (XFontStruct *) NULL):         Warning("Unable to load font",resource_info.font);(       annotate_info.font_info=font_info;@       annotate_info.height=font_info->ascent+font_info->descent;     } 1   if ((map_info == (XStandardColormap *) NULL) ||a.       (visual_info == (XVisualInfo *) NULL) ||*       (font_info == (XFontStruct *) NULL))     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL); 9       PrematureExit("Unable to create TEXT image",image);      }    /*     Get the Standard Colormap.   */H   XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),     map_info);K   XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,m     &pixel_info);eF   pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);   pixel_info.annotate_index=1;C   background_color.red=XDownScale(pixel_info.background_color.red);rE   background_color.green=XDownScale(pixel_info.background_color.red); D   background_color.blue=XDownScale(pixel_info.background_color.red);   background_color.index=0;    background_color.length=0;   /*     Initialize Image structure.a   */?   (void) XParseGeometry(TextPageGeometry,&x,&y,&width,&height);L(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);g   image->columns=width;;   image->rows=height;(,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)%3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL); 7       PrematureExit("Unable to allocate memory",image);P     }m   /*.     Initialize text image to background color.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)     *p++=background_color;   /*     Annotate the text image.   */A   annotate_info.text=(char *) malloc(MaxTextLength*sizeof(char)); *   if (annotate_info.text == (char *) NULL)     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL);m7       PrematureExit("Unable to allocate memory",image);e     }o   text[MaxTextLength-1]='\0';e6   text_status=fgets(text,MaxTextLength-1,image->file);   if ((int) strlen(text) > 0)e     text[strlen(text)-1]='\0';   offset=0; &   while (text_status != (char *) NULL)   {      *annotate_info.text='\0';(     if (*text != '\0')       {n
         /*            Compute width of text.
         *//         (void) strcpy(annotate_info.text,text);          annotate_info.width=N           XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));6         if ((annotate_info.width+4) >= image->columns)           {r             /*7               Reduce text until width is within bounds.e             */)             i=strlen(annotate_info.text); I             for (; (annotate_info.width+(x << 1)) >= image->columns; i--) "               annotate_info.width=J                 XTextWidth(font_info,annotate_info.text,(unsigned int) i);'             annotate_info.text[i]='\0';o>             while ((i > 0) && !isspace(annotate_info.text[i]))               i--;             if (i > 0))               annotate_info.text[i]='\0';lH             annotate_info.width=XTextWidth(font_info,annotate_info.text,*               strlen(annotate_info.text));           })
         /*#           Annotate image with text. 
         */<         (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",?           annotate_info.width,annotate_info.height,x,y+offset); N         status=XAnnotateImage(display,&pixel_info,&annotate_info,False,image);         if (status == 0)           { J             Warning("Unable to annotate image","Memory allocation error");             break;           }a       }=     /*       Get next string.     */3     if (strlen(text) != strlen(annotate_info.text))s<       (void) strcpy(text,text+strlen(annotate_info.text)+1);     else       {u<         text_status=fgets(text,MaxTextLength-1,image->file);#         if ((int) strlen(text) > 0)d$           text[strlen(text)-1]='\0';       } !     offset+=annotate_info.height;a)     if ((text_status != (char *) NULL) &&o@         (((y << 1)+offset+annotate_info.height) >= image->rows))       {.
         /*7           Page is full-- allocate next image structure.e
         */         CompressImage(image); 5         QuantizeImage(image,2,8,False,RGBColorspace);a         image->orphan=True;eF         image->next=CopyImage(image,image->columns,image->rows,False);         image->orphan=False;*         if (image->next == (Image *) NULL)           {rJ             Warning("Unable to annotate image","Memory allocation error");             break;           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;
         /*4           Initialize text image to background color.
         */         p=image->pixels;*         for (i=0; i < image->packets; i++)            *p++=background_color;         offset=0;n       }e   }g   CompressImage(image);i/   QuantizeImage(image,2,8,False,RGBColorspace);)+   while (image->previous != (Image *) NULL)=     image=image->previous;   CloseImage(image);   /*     Free resources.v   */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,3     font_info,&resource_info,(XWindowInfo *) NULL); $   free((char *) annotate_info.text);   return(image); }    #ifdef HasTIFF #ifndef va_start, #if defined(__STDC__) && !defined(NOSTDHDRS) #include <stdarg.h>  #else( #include <varargs.h> #endif #endif #include "tiffio.h"t E /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %mO %                                                                             %iO %                                                                             % O %  R e a d T I F F I m a g e                                                  %mO %                                                                             %eO %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" % G %  Function ReadTIFFImage reads a Tagged image file and returns it.  ItiK %  allocates the memory necessary for the new Image structure and returns ai %  pointer to the new image. %f. %  The format of the ReadTIFFImage routine is: %*& %      image=ReadTIFFImage(image_info) %c+ %  A description of each parameter follows:  %hJ %    o image:  Function ReadTIFFImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.r %tA %    o image_info: Specifies a pointer to an ImageInfo structure.x %  %  */  5 static void TIFFWarningMessage(module,format,warning)*
 const char
   *module,
   *format;   va_listu
   warning; {    char     message[MaxTextLength];f     register char!     *p;)     p=message;   if (module != (char *) NULL)     {        sprintf(p,"%s: ",module);m       p+=strlen(message);      }    vsprintf(p,format,warning);    strcat(p,".");!   Warning(message,(char *) NULL);& }t  ' static Image *ReadTIFFImage(image_info)g	 ImageInfoi   *image_info; {    char
     *comment;9     Imageh     *image;      intr
     range;  	   Quantum 	     blue,g
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      TIFF
     *tiff;     uint16     extra_samples,     *sample_info;1     unsigned charc     *scanline;     unsigned int     height,      method,e     packets,     status,l
     width;     unsigned short     bits_per_sample,
     index,     max_sample_value,      min_sample_value,>     photometric,     samples_per_pixel,
     value;     /*     Allocate image structure.)   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);)   /*     Open image.s   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);a,   if ((image->file == stdin) || image->pipe)     {l
       FILE         *file;  	       int 
         c;         /*6         Copy standard input or pipe to temporary file.       */.       TemporaryFilename(image_info->filename);,       file=fopen(image_info->filename,"wb");        if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);       c=fgetc(image->file);        while (c != EOF)       {r         (void) putc(c,file);         c=fgetc(image->file);e       }g       (void) fclose(file);:       (void) strcpy(image->filename,image_info->filename);       image->temporary=True;     }    CloseImage(image);*   TIFFSetErrorHandler(TIFFWarningMessage);,   TIFFSetWarningHandler(TIFFWarningMessage);&   tiff=TIFFOpen(image->filename,"rb");   if (tiff == (TIFF *) NULL)/     PrematureExit("Unable to open file",image);a    if (image_info->subimage != 0)/     while (image->scene < image_info->subimage)r     {U        image->scene++;&        status=TIFFReadDirectory(tiff);        if (status == False)28          PrematureExit("Unable to read subimage",image);     }v   do   {t     if (image_info->verbose),       TIFFPrintDirectory(tiff,stderr,False);1     TIFFGetField(tiff,TIFFTAG_IMAGEWIDTH,&width); 3     TIFFGetField(tiff,TIFFTAG_IMAGELENGTH,&height);(G     TIFFGetFieldDefaulted(tiff,TIFFTAG_BITSPERSAMPLE,&bits_per_sample); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MINSAMPLEVALUE,&min_sample_value);2I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MAXSAMPLEVALUE,&max_sample_value);>A     TIFFGetFieldDefaulted(tiff,TIFFTAG_PHOTOMETRIC,&photometric); K     TIFFGetFieldDefaulted(tiff,TIFFTAG_SAMPLESPERPIXEL,&samples_per_pixel);rE     TIFFGetFieldDefaulted(tiff,TIFFTAG_RESOLUTIONUNIT,&image->units);lI     TIFFGetFieldDefaulted(tiff,TIFFTAG_XRESOLUTION,&image->x_resolution);oI     TIFFGetFieldDefaulted(tiff,TIFFTAG_YRESOLUTION,&image->y_resolution);)     /*5       Allocate memory for the image and pixel buffer.l     */     image->columns=width;      image->rows=height;      image->depth=QuantumDepth;     if (bits_per_sample <= 8)l       image->depth=8;p     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1);g     if (bits_per_sample == 1)a9       packets=Max((image->columns*image->rows+8) >> 4,1);iN     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)       {          TIFFClose(tiff);9         PrematureExit("Unable to allocate memory",image);L       }      comment=(char *) NULL;9     TIFFGetField(tiff,TIFFTAG_IMAGEDESCRIPTION,&comment);i!     if (comment != (char *) NULL)-$       if ((int) strlen(comment) > 4)	         {2"           image->comments=(char *)D             malloc((unsigned int) (strlen(comment)+1)*sizeof(char));/           if (image->comments == (char *) NULL) 
             {a               TIFFClose(tiff);?               PrematureExit("Unable to allocate memory",image); 
             }a1           (void) strcpy(image->comments,comment);*	         }l,     range=max_sample_value-min_sample_value;     if (range < 0)       range=max_sample_value;      q=image->pixels;     q->length=MaxRunlength; 
     method=0;d5     if ((samples_per_pixel > 1) || TIFFIsTiled(tiff))        method=2; E     if ((samples_per_pixel >= 3) && (photometric == PHOTOMETRIC_RGB))d       method=1;      switch (method);     {v
       case 0:c       {1         Quantume           *quantum_scanline;           register Quantum
           *r;i  
         /*7           Convert TIFF image to PseudoClass MIFF image.,
         */!         image->class=PseudoClass;m         image->colors=range+1;'         image->colormap=(ColorPacket *)a4           malloc(image->colors*sizeof(ColorPacket));C         quantum_scanline=(Quantum *) malloc(width*sizeof(Quantum));uD         scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff)+1);8         if ((image->colormap == (ColorPacket *) NULL) ||5             (quantum_scanline == (Quantum *) NULL) ||e1             (scanline == (unsigned char *) NULL))s           {              TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);e           } 
         /*           Create colormap.
         */         switch (photometric)	         {u&           case PHOTOMETRIC_MINISBLACK:           {u-             for (i=0; i < image->colors; i++) 
             {f6               image->colormap[i].red=(MaxRGB*i)/range;8               image->colormap[i].green=(MaxRGB*i)/range;7               image->colormap[i].blue=(MaxRGB*i)/range;a
             }u             break;           }c&           case PHOTOMETRIC_MINISWHITE:           {e-             for (i=0; i < image->colors; i++) 
             {n>               image->colormap[i].red=((range-i)*MaxRGB)/range;@               image->colormap[i].green=((range-i)*MaxRGB)/range;?               image->colormap[i].blue=((range-i)*MaxRGB)/range;1
             }u             break;           }0#           case PHOTOMETRIC_PALETTE:            {2             unsigned short               *blue_colormap,m               *green_colormap,               *red_colormap;  M             TIFFGetField(tiff,TIFFTAG_COLORMAP,&red_colormap,&green_colormap,                &blue_colormap);-             for (i=0; i < image->colors; i++) 
             { J               image->colormap[i].red=((int) red_colormap[i]*MaxRGB)/65535;N               image->colormap[i].green=((int) green_colormap[i]*MaxRGB)/65535;L               image->colormap[i].blue=((int) blue_colormap[i]*MaxRGB)/65535;
             }              break;           }m           default:             break;	         } 
         /*A           Convert image to PseudoClass runlength-encoded packets.%
         */'         for (y=0; y < image->rows; y++) 	         { 7           TIFFReadScanline(tiff,(char *) scanline,y,0);            p=scanline;            r=quantum_scanline; "           switch (bits_per_sample)           {              case 1: 
             {P               register int                 bit;  2               for (x=0; x < ((int) width-7); x+=8)               { ,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               } #               if ((width % 8) != 0)                  {%<                   for (bit=7; bit >= (8-(width % 8)); bit--)>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }                break;
             }e             case 2:s
             {t2               for (x=0; x < ((int) width-3); x+=4)               { %                 *r++=(*p >> 6) & 0x3;o%                 *r++=(*p >> 4) & 0x3;t%                 *r++=(*p >> 2) & 0x3;o                  *r++=(*p) & 0x3;                 p++;               }n#               if ((width % 4) != 0)                  { 6                   for (i=3; i >= (4-(width % 4)); i--).                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }e               break;
             }f             case 4:u
             { 2               for (x=0; x < ((int) width-1); x+=2)               {n%                 *r++=(*p >> 4) & 0xf;                   *r++=(*p) & 0xf;                 p++;               } #               if ((width % 2) != 0)l'                 *r++=(*p++ >> 4) & 0xf;                break;
             }r             case 8:e
             { '               for (x=0; x < width; x++)                  *r++=(*p++);               break;
             }d             case 16:
             {n0               for (x=0; x < image->columns; x++)               { "                 ReadQuantum(*r,p);                 r++;               }                break;
             }              default:               break;           }            /*$             Transfer image scanline.           */           r=quantum_scanline; ,           for (x=0; x < image->columns; x++)           {              index=(*r++); H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {n(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {a                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));vB                     if (image->pixels == (RunlengthPacket *) NULL)                       {&0                         free((char *) scanline);8                         free((char *) quantum_scanline);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);o                       }-5                     q=image->pixels+image->packets-1;R                   };                 q->index=index;i                 q->length=0;               }            }s	         }p          free((char *) scanline);(         free((char *) quantum_scanline);(         if (image->class == PseudoClass)           {m             SyncImage(image);m$             CompressColormap(image);           }*         break;       }P
       case 1:c       {p
         /*7           Convert TIFF image to DirectClass MIFF image.a
         */D         scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff)+1);/         if (scanline == (unsigned char *) NULL)t           {g             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);o           }oG         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,S           &sample_info);         image->matte=aO           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA));D'         for (y=0; y < image->rows; y++)g	         { 7           TIFFReadScanline(tiff,(char *) scanline,y,0);-           p=scanline;r,           for (x=0; x < image->columns; x++)           {e             ReadQuantum(red,p);r!             ReadQuantum(green,p);               ReadQuantum(blue,p);             index=0;             if (image->matte) #               ReadQuantum(index,p);pN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;t.                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)                       {e(                         TIFFClose(tiff);0                         free((char *) scanline);I                         PrematureExit("Unable to allocate memory",image);*                       }g5                     q=image->pixels+image->packets-1;                    }R                 q->red=red;c                 q->green=green;                  q->blue=blue;R                 q->index=index;m                 q->length=0;               }m           } 	         }           free((char *) scanline);         break;       }a
       case 2:e       default:       {-         register uint32e
           *p,            *pixels;  
         /*7           Convert TIFF image to DirectClass MIFF image.-
         */G         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,p           &sample_info);         image->matte= O           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA));;         pixels=(uint32 *)aM           malloc((image->columns*image->rows+image->columns)*sizeof(uint32));m&         if (pixels == (uint32 *) NULL)           {[             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);o           }*K         status=TIFFReadRGBAImage(tiff,image->columns,image->rows,pixels,0);f         if (status == False)           { "             free((char *) pixels);             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);-           }e
         /*A           Convert image to DirectClass runlength-encoded packets.a
         */*         for (y=image->rows-1; y >= 0; y--)	         { $           p=pixels+y*image->columns;,           for (x=0; x < image->columns; x++)           {e&             red=UpScale(TIFFGetR(*p));(             green=UpScale(TIFFGetG(*p));'             blue=UpScale(TIFFGetB(*p));gE             index=(unsigned short) (image->matte ? TIFFGetA(*p) : 0); N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {0(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)                       {g.                         free((char *) pixels);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);                        } 5                     q=image->pixels+image->packets-1;                    }                  q->red=red;E                 q->green=green;e                 q->blue=blue;a                 q->index=index;)                 q->length=0;               }i             p++;           }>	         }g         free((char *) pixels);!         if (IsPseudoClass(image)) J           QuantizeImage(image,(unsigned int) range,8,False,RGBColorspace);         break;       }c     }>%     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));(     /*       Proceed to next image.     */"     if (image_info->subimage != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;#     status=TIFFReadDirectory(tiff);      if (status == True)e       {e
         /*#           Allocate image structure.h
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);x#             return((Image *) NULL);            }.B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True);i   TIFFClose(tiff);   if (image->temporary) (     (void) unlink(image_info->filename);+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }  #elsee' static Image *ReadTIFFImage(image_info)x	 ImageInfoa   *image_info; {4@   Warning("TIFF library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %rO %                                                                             % O %  R e a d T I L E I m a g e                                                  % O %                                                                             %>O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %fH %  Function ReadTILEImage tiles a texture on an image.  It allocates theL %  memory necessary for the new Image structure and returns a pointer to the
 %  new image.  % . %  The format of the ReadTILEImage routine is: %l& %      image=ReadTILEImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadTILEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %(A %    o image_info: Specifies a pointer to an ImageInfo structure.- %c %s */' static Image *ReadTILEImage(image_info)a	 ImageInfo    *image_info; {    Image      *image,t     *tiled_image;      intm     x,     y;     unsigned int     height,)
     width;  $   tiled_image=ReadImage(image_info);$   if (tiled_image == (Image *) NULL)     return((Image *) NULL);l   /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);l   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;x(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize Image structure.    */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;=   image->rows=height;l,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));h0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);r   /*     Tile texture onto image.   */2   for (y=0; y < image->rows; y+=tiled_image->rows):     for (x=0; x < image->columns; x+=tiled_image->columns)?       CompositeImage(image,ReplaceCompositeOp,tiled_image,x,y);    return(image); }( g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %oO %                                                                             %iO %                                                                             % O %   R e a d V I C A R I m a g e                                               %lO %                                                                             %iO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function ReadVICARImage reads a VICAR image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % / %  The format of the ReadVICARImage routine is:  % ' %      image=ReadVICARImage(image_info)  % + %  A description of each parameter follows:  % J %    o image: Function ReadVICARImage returns a pointer to the image afterO %      reading.  A null image is returned if there is a a memory shortage or if%  %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.g %i %a */( static Image *ReadVICARImage(image_info)	 ImageInfo    *image_info; {t   char     keyword[MaxTextLength],      value[MaxTextLength];a     Imagea     *image;t     long
     count;     register int     c,     i;     register RunlengthPacket     *q;l     register unsigned char     *p;e     unsigned chara     *vicar_pixels;     unsigned int     header_length,     status,      value_expected;y     /*     Allocate image structure.t   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);I   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);g   /*     Decode image header.   */   c=fgetc(image->file);g
   count=1;   if (c == EOF)t     {        DestroyImage(image);       return((Image *) NULL);;     }m   header_length=0;;   while (isgraph(c) && ((image->columns*image->rows) == 0))i   {e     if (!isalnum(c))       {          c=fgetc(image->file);u         count++;       }e     else       {          register char)
           *p;u  
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         {L.           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);r           count++;+         } while (isalnum(c) || (c == '_'));e         *p='\0';         value_expected=False;r(         while (isspace(c) || (c == '='))	         {m           if (c == '=')e              value_expected=True;           c=fgetc(image->file);            count++;	         }e$         if (value_expected == False)           continue;m         p=value;         while (isalnum(c))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */1         if (strcmp(keyword,"LABEL_RECORDS") == 0) 3           header_length=(unsigned int) atoi(value);=+         if (strcmp(keyword,"LBLSIZE") == 0)o3           header_length=(unsigned int) atoi(value);p0         if (strcmp(keyword,"RECORD_BYTES") == 0)4           image->columns=(unsigned int) atoi(value);&         if (strcmp(keyword,"NS") == 0)4           image->columns=(unsigned int) atoi(value);)         if (strcmp(keyword,"LINES") == 0)u1           image->rows=(unsigned int) atoi(value);u&         if (strcmp(keyword,"NL") == 0)1           image->rows=(unsigned int) atoi(value);y       }o     while (isspace(c))     {h       c=fgetc(image->file);e       count++;     }    }    /*      Read the rest of the header.   */   while (count < header_length)t   {      c=fgetc(image->file);      count++;   }    /*6     Verify that required image information is defined.   */(   if ((image->columns*image->rows) == 0).     PrematureExit("image size is zero",image);   /*     Create linear colormap.    */   image->class=PseudoClass;s   image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);%#   for (i=0; i < image->colors; i++))   {p0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);r   }i   /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); N   vicar_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (vicar_pixels == (unsigned char *) NULL)))5     PrematureExit("Unable to read image data",image);    /*6     Convert VICAR pixels to runlength-encoded packets.   */F   status=ReadData((char *) vicar_pixels,1,image->packets,image->file);   if (status == False);     PrematureExit("Insufficient image data in file",image);e   /*6     Convert VICAR pixels to runlength-encoded packets.   */   p=vicar_pixels;a   q=image->pixels;$   for (i=0; i < image->packets; i++)   { !     q->index=(unsigned short) *p;t     q->length=0;     p++;     q++;   }n   free((char *) vicar_pixels);   SyncImage(image);%   CompressColormap(image);   CompressImage(image);r   CloseImage(image);   return(image); }n m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             % O %                                                                             %tO %  R e a d V I D I m a g e                                                    %LO %                                                                             %nO %                                                                             %gO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%* % L %  Function ReadVIDImage reads one of more images and creates a Visual ImageG %  Directory file.  It allocates the memory necessary for the new ImageN4 %  structure and returns a pointer to the new image. % - %  The format of the ReadVIDImage routine is:a %!% %      image=ReadVIDImage(image_info)a %)+ %  A description of each parameter follows:  %hI %    o image:  Function ReadVIDImage returns a pointer to the image afteruL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadVIDImage(image_info)	 ImageInfo    *image_info; {  #define ClientName  "montage"      char     **filelist,      **list,      *resource_value;  	   Display 
     *display;      Image      *image, 
     **images;      ImageInfo      local_info;      int      number_files;      register int     i,     j;     XMontageInfo     montage_info;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*     Expand the filename.   */(   list=(char **) malloc(sizeof(char *));   if (list == (char **) NULL)n     {e7       Warning("Memory allocation error",(char *) NULL);        return((Image *) NULL);l     }t:   list[0]=(char *) malloc(strlen(image_info->filename)+1);   if (list[0] == (char *) NULL)      {T7       Warning("Memory allocation error",(char *) NULL);a       return((Image *) NULL);d     }d.   (void) strcpy(list[0],image_info->filename);   number_files=1;    filelist=list;+   ExpandFilenames(&number_files,&filelist);i   if (number_files == 0)     {t=       Warning("VID translation failed",image_info->filename);e       return((Image *) NULL);e     }a   /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));f    if (images == (Image **) NULL)     {a7       Warning("Memory allocation error",(char *) NULL);m&       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);x       free((char *) filelist);       return((Image *) NULL);      })   /*     Open X server connection.    */7   resource_info.background_color=DefaultTileBackground;f*   resource_info.border_color=BorderColor;;:   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground; &   resource_info.gravity=CenterGravity;3   resource_info.image_geometry=DefaultTileGeometry;f-   resource_info.matte_color=DefaultTileMatte;m$   resource_info.title=(char *) NULL;0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {o       /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);g       /*3         Get user defaults from X resource database.e       */B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);L       resource_info.background_color=XGetResourceInstance(resource_database,7         ClientName,"background",DefaultTileBackground);%D       resource_value=XGetResourceClass(resource_database,ClientName,.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,7         ClientName,"foreground",DefaultTileForeground); J       resource_info.image_geometry=XGetResourceInstance(resource_database,8         ClientName,"imageGeometry",DefaultTileGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database, 2         ClientName,"mattecolor",DefaultTileMatte);     }%   /*/     Read each image and convert them to a tile.%   */   j=0;"   for (i=0; i < number_files; i++)   {a     local_info=(*image_info); )     if (local_info.size == (char *) NULL)r3       local_info.size=resource_info.image_geometry;r$     local_info.filename=filelist[i];     *local_info.magick='\0';!     image=ReadImage(&local_info);a     free((char *) filelist[i]);d      if (image == (Image *) NULL)       continue;i     image->scene=j;N     LabelImage(image,"%f");hF     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)       DescribeImage(image);      images[j]=image;     j++;   }i   free((char *) filelist);   /*&     Create the visual image directory.   */!   XGetMontageInfo(&montage_info);    montage_info.number_tiles=j;   image=(Image *) NULL;,%   if (montage_info.number_tiles != 0) =     image=XMontageImage(display,&resource_info,&montage_info, #       image_info->filename,images);p"   if (display != (Display *) NULL)     XCloseDisplay(display);    free((char *) images);   if (image == (Image *) NULL)     {o=       Warning("VID translation failed",image_info->filename);e       return((Image *) NULL);(     }n   free((char *) list[0]);    free((char *) list);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             %pO %                                                                             %gO %   R e a d V I F F I m a g e                                                 %)O %                                                                             %LO %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadVIFFImage reads a Khoros Visualization image file and returns I %  it.  It allocates the memory necessary for the new Image structure andh& %  returns a pointer to the new image. %;. %  The format of the ReadVIFFImage routine is: %=& %      image=ReadVIFFImage(image_info) %a+ %  A description of each parameter follows:  % I %    o image: Function ReadVIFFImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or ifi  %      the image cannot be read. %;9 %    o filename: Specifies the name of the image to read.  %_ %_ */' static Image *ReadVIFFImage(image_info)8	 ImageInfo    *image_info; {t #define VFF_CM_genericRGB  158 #define VFF_CM_ntscRGB  1a #define VFF_CM_NONE  0 #define VFF_DEP_DECORDER  0x4; #define VFF_DEP_NSORDER  0x8 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1u #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_MS_SHARED  3 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1P #define VFF_TYP_2_BYTE  2i #define VFF_TYP_4_BYTE  4b     typedef struct _ViffHeader   {i     unsigned charn       identifier,c       file_type,       release,       version,       machine_dependency,=       reserve[3];m       char       comment[512];        unsigned longa       rows,        columns,       subrows;       long       x_offset,c       y_offset;   	     floatn       x_pixel_size,*       y_pixel_size;t       unsigned longl       location_type,       location_dimension,        number_of_images,n       number_data_bands,       data_storage_type,       data_encode_scheme,        map_scheme,        map_storage_type,g       map_rows,i       map_columns,       map_subrows,       map_enable,n       maps_per_cycle,+       color_space_model;   } ViffHeader;      Imagem     *image;      register int     bit,     i,     x,     y;     register Quantum     *p;      register RunlengthPacket     *q;0     unsigned charm     buffer[7],     *viff_pixels;i     unsigned int     bytes_per_pixel,     status;      unsigned long(     packets;     ViffHeader     viff_header;     /*     Allocate image structure.n   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);t   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)(/     PrematureExit("Unable to open file",image);p   /*"     Read VIFF header (1024 bytes).   */D   status=ReadData((char *) &viff_header.identifier,1,1,image->file);   do   {      /*       Verify VIFF identifier./     */N     if ((status == False) || ((unsigned char) viff_header.identifier != 0xab))/       PrematureExit("Not a VIFF raster",image);E     /*       Initialize VIFF image.     */5     (void) ReadData((char *) buffer,1,7,image->file);a$     viff_header.file_type=buffer[0];"     viff_header.release=buffer[1];"     viff_header.version=buffer[2];-     viff_header.machine_dependency=buffer[3];iD     (void) ReadData((char *) viff_header.comment,1,512,image->file);"     viff_header.comment[511]='\0';.     if ((int) strlen(viff_header.comment) > 4)       {[          image->comments=(char *)N           malloc((unsigned int) (strlen(viff_header.comment)+1)*sizeof(char));-         if (image->comments == (char *) NULL) ;           PrematureExit("Unable to allocate memory",image); ;         (void) strcpy(image->comments,viff_header.comment);e       }1?     if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||1<         (viff_header.machine_dependency == VFF_DEP_NSORDER))       { 7         viff_header.rows=LSBFirstReadLong(image->file); :         viff_header.columns=LSBFirstReadLong(image->file);:         viff_header.subrows=LSBFirstReadLong(image->file);;         viff_header.x_offset=LSBFirstReadLong(image->file);*;         viff_header.y_offset=LSBFirstReadLong(image->file);,G         viff_header.x_pixel_size=(float) LSBFirstReadLong(image->file); G         viff_header.y_pixel_size=(float) LSBFirstReadLong(image->file);=@         viff_header.location_type=LSBFirstReadLong(image->file);E         viff_header.location_dimension=LSBFirstReadLong(image->file);nC         viff_header.number_of_images=LSBFirstReadLong(image->file);=D         viff_header.number_data_bands=LSBFirstReadLong(image->file);D         viff_header.data_storage_type=LSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=LSBFirstReadLong(image->file);o=         viff_header.map_scheme=LSBFirstReadLong(image->file);nC         viff_header.map_storage_type=LSBFirstReadLong(image->file);f;         viff_header.map_rows=LSBFirstReadLong(image->file); >         viff_header.map_columns=LSBFirstReadLong(image->file);>         viff_header.map_subrows=LSBFirstReadLong(image->file);=         viff_header.map_enable=LSBFirstReadLong(image->file); A         viff_header.maps_per_cycle=LSBFirstReadLong(image->file); D         viff_header.color_space_model=LSBFirstReadLong(image->file);       }      else       {;7         viff_header.rows=MSBFirstReadLong(image->file);-:         viff_header.columns=MSBFirstReadLong(image->file);:         viff_header.subrows=MSBFirstReadLong(image->file);;         viff_header.x_offset=MSBFirstReadLong(image->file); ;         viff_header.y_offset=MSBFirstReadLong(image->file); G         viff_header.x_pixel_size=(float) MSBFirstReadLong(image->file); G         viff_header.y_pixel_size=(float) MSBFirstReadLong(image->file); @         viff_header.location_type=MSBFirstReadLong(image->file);E         viff_header.location_dimension=MSBFirstReadLong(image->file); C         viff_header.number_of_images=MSBFirstReadLong(image->file);cD         viff_header.number_data_bands=MSBFirstReadLong(image->file);D         viff_header.data_storage_type=MSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=MSBFirstReadLong(image->file); =         viff_header.map_scheme=MSBFirstReadLong(image->file);;C         viff_header.map_storage_type=MSBFirstReadLong(image->file); ;         viff_header.map_rows=MSBFirstReadLong(image->file); >         viff_header.map_columns=MSBFirstReadLong(image->file);>         viff_header.map_subrows=MSBFirstReadLong(image->file);=         viff_header.map_enable=MSBFirstReadLong(image->file);oA         viff_header.maps_per_cycle=MSBFirstReadLong(image->file); D         viff_header.color_space_model=MSBFirstReadLong(image->file);       }G     for (i=0; i < 420; i++)         (void) fgetc(image->file);     /*.       Verify that we can read this VIFF image.     */4     if ((viff_header.columns*viff_header.rows) == 0)G       PrematureExit("Image column or row size is not supported",image); 9     if ((viff_header.data_storage_type != VFF_TYP_BIT) &&(<         (viff_header.data_storage_type != VFF_TYP_1_BYTE) &&<         (viff_header.data_storage_type != VFF_TYP_2_BYTE) &&:         (viff_header.data_storage_type != VFF_TYP_4_BYTE))@       PrematureExit("Data storage type is not supported",image);6     if (viff_header.data_encode_scheme != VFF_DES_RAW)C       PrematureExit("Data encoding scheme is not supported",image); <     if ((viff_header.map_storage_type != VFF_MAPTYP_NONE) &&<         (viff_header.map_storage_type != VFF_MAPTYP_1_BYTE))?       PrematureExit("Map storage type is not supported",image);e9     if ((viff_header.color_space_model != VFF_CM_NONE) && <         (viff_header.color_space_model != VFF_CM_ntscRGB) &&=         (viff_header.color_space_model != VFF_CM_genericRGB)) ?       PrematureExit("Colorspace model is not supported",image); 6     if (viff_header.location_type != VFF_LOC_IMPLICIT)       { B         Warning("Location type is not supported",image->filename);         DestroyImages(image);          return((Image *) NULL);        }e*     if (viff_header.number_of_images != 1)?       PrematureExit("Number of images is not supported",image);e#     switch (viff_header.map_scheme)x     {        case VFF_MS_NONE:        { .         if (viff_header.number_data_bands < 3)           {e             /*'               Create linear color ramp.m             */=             if (viff_header.data_storage_type == VFF_TYP_BIT)                image->colors=2;             elseN               image->colors=1 << (viff_header.number_data_bands*QuantumDepth);+             image->colormap=(ColorPacket *)n8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image); -             for (i=0; i < image->colors; i++) 
             {(B               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);=
             }t           }c         break;       }        case VFF_MS_ONEPERBAND:R       case VFF_MS_SHARED:        {          unsigned charu           *viff_colormap;   
         /*$           Read VIFF raster colormap.
         */.         image->colors=viff_header.map_columns;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));'         viff_colormap=(unsigned char *) 6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||6             (viff_colormap == (unsigned char *) NULL));           PrematureExit("Unable to allocate memory",image);&L         (void) ReadData((char *) viff_colormap,1,image->colors,image->file);)         for (i=0; i < image->colors; i++)g	         {r;           image->colormap[i].red=UpScale(viff_colormap[i]);p=           image->colormap[i].green=UpScale(viff_colormap[i]); <           image->colormap[i].blue=UpScale(viff_colormap[i]);	         } %         if (viff_header.map_rows > 1)R           {)P             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++) A               image->colormap[i].green=UpScale(viff_colormap[i]);m           } %         if (viff_header.map_rows > 2)n           { P             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++)p@               image->colormap[i].blue=UpScale(viff_colormap[i]);           }i%         free((char *) viff_colormap);f         break;       }e       default:>         PrematureExit("Colormap type is not supported",image);     }      /*       Allocate VIFF pixels.r     */     bytes_per_pixel=1;8     if (viff_header.data_storage_type == VFF_TYP_2_BYTE)       bytes_per_pixel=2;8     if (viff_header.data_storage_type == VFF_TYP_4_BYTE)       bytes_per_pixel=4;5     if (viff_header.data_storage_type == VFF_TYP_BIT)a>       packets=((viff_header.columns+7) >> 3)*viff_header.rows;     else       packets=K         viff_header.columns*viff_header.rows*viff_header.number_data_bands;f!     viff_pixels=(unsigned char *)i6       malloc(bytes_per_pixel*packets*sizeof(Quantum));.     if (viff_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image); P     (void) ReadData((char *) viff_pixels,bytes_per_pixel,(unsigned int) packets,       image->file); *     switch (viff_header.data_storage_type)     { 	       int          max_value,         min_value,         value;         register Quantum         *q;          unsigned long          scale_factor;          case VFF_TYP_1_BYTE:       {          register unsigned char
           *p;            if (QuantumDepth == 8)           break;
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=viff_pixels;"         q=(Quantum *) viff_pixels;         p+=packets-1;          q+=packets-1;N#         for (i=0; i < packets; i++)f	         {u           value=(*p);e           *q=(Quantum) value;n           p--;           q--;	         }r         break;       }        case VFF_TYP_2_BYTE:       {n         register short int
           *p;_  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || @             (viff_header.machine_dependency == VFF_DEP_NSORDER))3           MSBFirstOrderShort((char *) &viff_header,a6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor. 
         */$         p=(short int *) viff_pixels;         max_value=(*p);          min_value=(*p); #         for (i=0; i < packets; i++)i	         {c           if (*p > max_value)t             max_value=(*p);=           else             if (*p < min_value)                min_value=(*p);            p++;	         }i1         if ((min_value == 0) && (max_value == 0))            scale_factor=0;/         else%           if (min_value == max_value) 
             { 5               scale_factor=UpShift(MaxRGB)/min_value;m               min_value=0;
             }            else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value);e
         /*.           Scale integer pixels to [0..MaxRGB].
         */$         p=(short int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++)o	         {=7           value=DownShift((*p-min_value)*scale_factor);            if (value > MaxRGB)              value=MaxRGB;            else             if (value < 0)               value=0;           *q=(Quantum) value;m           p++;           q++;	         }r         break;       }g       case VFF_TYP_4_BYTE:       {          register int
           *p;g  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || @             (viff_header.machine_dependency == VFF_DEP_NSORDER))2           MSBFirstOrderLong((char *) &viff_header,6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor.'
         */         p=(int *) viff_pixels;         max_value=(*p);a         min_value=(*p);'#         for (i=0; i < packets; i++)f	         {"           if (*p > max_value)l             max_value=(*p);l           else             if (*p < min_value))               min_value=(*p);)           p++;	         } 1         if ((min_value == 0) && (max_value == 0))            scale_factor=0;e         else%           if (min_value == max_value)a
             { 5               scale_factor=UpShift(MaxRGB)/min_value;t               min_value=0;
             }*           else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value);(
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=(int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++)l	         {i7           value=DownShift((*p-min_value)*scale_factor);R           if (value > MaxRGB)a             value=MaxRGB;            else             if (value < 0)               value=0;#           *q=(unsigned char) value;E           p++;           q++;	         }          break;       }r     }g     /*!       Initialize image structure.      */6     image->matte=(viff_header.number_data_bands == 4);     image->class=eF       (viff_header.number_data_bands < 3 ? PseudoClass : DirectClass);$     image->columns=viff_header.rows;$     image->rows=viff_header.columns;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)*5       malloc(image->packets*sizeof(RunlengthPacket));o2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);t     /*=       Convert VIFF raster image to runlength-encoded packets.(     */     p=(Quantum *) viff_pixels;     q=image->pixels;5     if (viff_header.data_storage_type == VFF_TYP_BIT)t       {s         unsigned int           polarity;e  
         /*E           Convert bitmap scanline to runlength-encoded color packets.a
         */H         polarity=(viff_header.machine_dependency == VFF_DEP_DECORDER) ||>           (viff_header.machine_dependency == VFF_DEP_NSORDER);'         for (y=0; y < image->rows; y++)-	         {C           /*G             Convert bitmap scanline to runlength-encoded color packets.-           */3           for (x=0; x < (image->columns >> 3); x++)            {e'             for (bit=0; bit < 8; bit++))
             { E               q->index=((*p) & (0x01 << bit) ? polarity : !polarity);a               q->length=0;               q++;
             }r             p++;           }>(           if ((image->columns % 8) != 0)
             {)<               for (bit=0; bit < (image->columns % 8); bit++)               { G                 q->index=((*p) & (0x01 << bit) ? polarity : !polarity);                  q->length=0;                 q++;               }                p++;
             } 	         }=       }      else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++)R	         {            /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } 	         } 
       else	         {p           unsigned long              offset;              /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           offset=image->columns*image->rows;)           for (y=0; y < image->rows; y++)l           { .             for (x=0; x < image->columns; x++)
             {u               q->red=(*p);%               q->green=(*(p+offset));o&               q->blue=(*(p+offset*2));%               if (image->colors != 0)                  {(5                   q->red=image->colormap[q->red].red; ;                   q->green=image->colormap[q->green].green; 8                   q->blue=image->colormap[q->blue].blue;                 } M               q->index=(unsigned short) (image->matte ? (*(p+offset*3)) : 0);                q->length=0;               p++;               q++;
             }            } 	         }-     free((char *) viff_pixels);+$     if (image->class == PseudoClass)       {          SyncImage(image);a          CompressColormap(image);       }      CompressImage(image);      /*       Proceed to next image.     */F     status=ReadData((char *) &viff_header.identifier,1,1,image->file);=     if ((status == True) && (viff_header.identifier == 0xab))e       {)
         /*#           Allocate image structure.l
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {d!             DestroyImages(image);=#             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } A   } while ((status == True) && (viff_header.identifier == 0xab));h+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %RO %                                                                             %eO %                                                                             %)O %   R e a d X I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             %NO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%> %u8 %  Procedure ReadXImage reads an image from an X window. %i+ %  The format of the ReadXImage routine is:1 %p@ %      image=ReadXImage(image_info,frame,borders,screen,descend) %u+ %  A description of each parameter follows:= %lA %    o image_info: Specifies a pointer to an ImageInfo structure.a %bL %    o frame: Specifies whether to include the window manager frame with the
 %      image.l % E %    o borders: Specifies whether borders pixels are to be saved withn %      the image.l % N %    o screen: Specifies whether the GetImage request used to obtain the imageO %      should be done on the root window, rather than directly on the specified  %      window. % O %    o descend: If this option is zero, check to see if the WM_COLORMAP_WINDOWSeJ %      property is set or if XListInstalledColormaps returns more than oneG %      colormap.  If so, the image is obtained by descending the window)= %      hierarchy and reading each subwindow and its colormap., %g %l */: Image *ReadXImage(image_info,frame,borders,screen,descend)	 ImageInfo    *image_info;   unsigned int   frame,
   borders,	   screen, 
   descend; {=
   Colormap     *colormaps;x  	   Display 
     *display;=     Image      *image;      int      status,u     x;     RectangleInfo      crop_info;     Window     *children,     client, 	     root,      target;      XTextProperty      window_name;     /*     Open X server connection.e   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {g.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return((Image *) NULL);y     }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*     Select target window.i   */   crop_info.x=0;   crop_info.y=0;   crop_info.width=0;   crop_info.height=0;d4   root=XRootWindow(display,XDefaultScreen(display));   target=(Window) NULL; 0   if ((image_info->filename != (char *) NULL) &&&       (*image_info->filename != '\0'))8     if (Latin1Compare(image_info->filename,"root") == 0)       target=root;     else       { 
         /*&           Select window by ID or name.
         */+         if (isdigit(*image_info->filename))aO           target=XWindowByID(display,root,(Window) strtol(image_info->filename,              (char **) NULL,0)); $         if (target == (Window) NULL)B           target=XWindowByName(display,root,image_info->filename);$         if (target == (Window) NULL)M           Warning("No window with specified id exists",image_info->filename);        }-   /*>     If target window is not defined, interactively select one.   */   if (target == (Window) NULL)-     target=XSelectWindow(display,&crop_info);    client=target;   if (target != root)      {'       unsigned int
         d;  B       status=XGetGeometry(display,target,&root,&x,&x,&d,&d,&d,&d);       if (status != 0)	         {u           for ( ; ; )            {              Window               parent;                /*(               Find window manager frame.             */I             status=XQueryTree(display,target,&root,&parent,&children,&d);l8             if (status && (children != (Window *) NULL))'               XFree((char *) children);(I             if (!status || (parent == (Window) NULL) || (parent == root))t               break;             target=parent;           }            /*             Get client window.           *//           client=XClientWindow(display,target);            if (!frame)p             target=client;	         }      } 
   if (screen)(     {p	       intu
         y;         Window         child;         XWindowAttributesl         window_attributes;         /*1         Obtain window image directly from screen.        */E       status=XGetWindowAttributes(display,target,&window_attributes);        if (status == False)	         { M           Warning("Unable to read X window attributes",image_info->filename);l!           XCloseDisplay(display); !           return((Image *) NULL);n	         }wB       XTranslateCoordinates(display,target,root,0,0,&x,&y,&child);       crop_info.x=x;       crop_info.y=y;.       crop_info.width=window_attributes.width;0       crop_info.height=window_attributes.height;       if (borders)	         {            /*$             Include border in image.           */6           crop_info.x-=window_attributes.border_width;6           crop_info.y-=window_attributes.border_width;?           crop_info.width+=window_attributes.border_width << 1; @           crop_info.height+=window_attributes.border_width << 1;	         }        target=root;     }    if (descend)     {r	       intd         number_colormaps,          number_windows;          /*N         If WM_COLORMAP_WINDOWS property is set or multiple colormaps, descend.       */       descend=False;       number_windows=0; M       status=XGetWMColormapWindows(display,target,&children,&number_windows);e3       if ((status == True) && (number_windows > 0)) 	         {;           descend=True;-$           XFree ((char *) children);	         } J       colormaps=XListInstalledColormaps(display,target,&number_colormaps);       if (number_colormaps > 0)l	         { #           if (number_colormaps > 1)r             descend=True;e$           XFree((char *) colormaps);	         }+     }p   /*+     Alert the user not to alter the screen.d   */   XBell(display,0);e   /*     Get image by window id.l   */   XGrabServer(display);r8   image=XGetWindowImage(display,target,borders,descend);   XUngrabServer(display);m   if (image == (Image *) NULL)B     Warning("Unable to read X window image",image_info->filename);   else     { :       (void) strcpy(image->filename,image_info->filename);<       if ((crop_info.width != 0) && (crop_info.height != 0))	         {(           Images             *cropped_image;              /*<             Crop image as defined by the cropping rectangle.           */4           cropped_image=CropImage(image,&crop_info);.           if (cropped_image != (Image *) NULL)
             {n"               DestroyImage(image);"               image=cropped_image;
             } 	         } 5       status=XGetWMName(display,target,&window_name);        if (status == True)(	         {,8           if ((image_info->filename != (char *) NULL) &&.               (*image_info->filename == '\0'))
             {a               /**                 Initialize image filename.               */H               (void) strncpy(image->filename,(char *) window_name.value,*                 (int) window_name.nitems);7               image->filename[window_name.nitems]='\0'; 
             }t,           XFree((void *) window_name.value);	         }      }    /*     Alert the user we're done.   */   XBell(display,0);e   XBell(display,0);-   CompressImage(image);    XCloseDisplay(display);i   return(image); }  m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             %mO %                                                                             %%O %                                                                             % O %  R e a d X B M I m a g e                                                    % O %                                                                             % O %                                                                             %aO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadXBMImage reads an X11 bitmap image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a% %  pointer to the new image. %%- %  The format of the ReadXBMImage routine is:  %F% %      image=ReadXBMImage(image_info)c %t+ %  A description of each parameter follows:s %eI %    o image:  Function ReadXBMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.A %sA %    o image_info: Specifies a pointer to an ImageInfo structure.e %S %g */& static int XBMInteger(file,hex_digits) FILE   *file;  	 short intr   *hex_digits; {    into     c,	     flag, 
     value;  
   value=0;	   flag=0; 
   for ( ; ; )f   {e     c=getc(file);      if (c == EOF)u       {          value=(-1);*         break;       }      c&=0xff;"     if (isascii(c) && isxdigit(c))       {n)         value=(value << 4)+hex_digits[c];e         flag++;          continue;[       }n$     if ((hex_digits[c]) < 0 && flag)       break;   }    return(value); }e  & static Image *ReadXBMImage(image_info)	 ImageInfof   *image_info; {t   char     buffer[MaxTextLength],     name[MaxTextLength];     Image      *image;t     register int     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      register unsigned shorto
     index;     short int)     hex_digits[256];     unsigned char*     bit,
     *data;     unsigned int	     byte,"     bytes_per_line,      packets,     padding,
     value,     version;     /*     Allocate image structure.y   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);;   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)m/     PrematureExit("Unable to open file",image);/   /*     Read X bitmap header.t   */D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)?     if (sscanf(buffer,"#define %*32s %u",&image->columns) == 1)o       break;D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)<     if (sscanf(buffer,"#define %*32s %u",&image->rows) == 1)       break;   /*     Scan until hex digits.   */
   version=11; D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)   {x7     if (sscanf(buffer,"static short %s = {",name) == 1)u       version=10;_     elseA       if (sscanf(buffer,"static unsigned char %s = {",name) == 1)=         version=11;=
       else:         if (sscanf(buffer,"static char %s = {",name) == 1)           version=11;)         else           continue;g*     p=(unsigned char *) strrchr(name,'_');$     if (p == (unsigned char *) NULL)       p=(unsigned char *) name;      else
       p++;)     if (strcmp("bits[]",(char *) p) == 0)        break;   }oG   if ((image->columns == 0) || (image->rows == 0) || feof(image->file)) A     PrematureExit("XBM file is not in the correct format",image);    /*     Initialize image structure.e   */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    padding=0;O   if ((image->columns % 16) && ((image->columns % 16) < 9)  && (version == 10))      padding=1;.   bytes_per_line=(image->columns+7)/8+padding;%   packets=bytes_per_line*image->rows;aA   data=(unsigned char *) malloc(packets*sizeof(unsigned char *)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||'       (data == (unsigned char *) NULL))e5     PrematureExit("Unable to allocate memory",image);u   /*     Create colormap.   */   image->class=PseudoClass;r   image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);(   image->colormap[0].red=0;    image->colormap[0].green=0;%   image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    /*     Initialize hex values.   */   hex_digits['0']=0;   hex_digits['1']=1;   hex_digits['2']=2;   hex_digits['3']=3;   hex_digits['4']=4;   hex_digits['5']=5;   hex_digits['6']=6;   hex_digits['7']=7;   hex_digits['8']=8;   hex_digits['9']=9;   hex_digits['A']=10;    hex_digits['B']=11;t   hex_digits['C']=12;r   hex_digits['D']=13;f   hex_digits['E']=14;c   hex_digits['F']=15;    hex_digits['a']=10;n   hex_digits['b']=11;)   hex_digits['c']=12;n   hex_digits['d']=13;f   hex_digits['e']=14;=   hex_digits['f']=15;    hex_digits[' ']=(-1);i   hex_digits[',']=(-1);)   hex_digits['}']=(-1);o   hex_digits['\n']=(-1);   hex_digits['\t']=(-1);   /*     Read hex image data.   */	   p=data;;   if (version == 10)"     for (x=0; x < packets; (x+=2))     {s/       value=XBMInteger(image->file,hex_digits);0       *p++=value; /       if (!padding || ((x+2) % bytes_per_line))          *p++=value >> 8;     }_   else     for (x=0; x < packets; x++)f     {n/       value=XBMInteger(image->file,hex_digits);        *p++=value;a     }s   /*8     Convert X bitmap image to runlength-encoded packets.   */	   p=data;    q=image->pixels;!   for (y=0; y < image->rows; y++)-   {n
     bit=0;&     for (x=0; x < image->columns; x++)     {s       if (bit == 0)          byte=(*p++);"       index=(byte & 0x01) ? 0 : 1;       q->index=index;)       q->length=0;
       q++;       bit++;       byte>>=1;        if (bit == 8)w         bit=0;     }v   }f   SyncImage(image);t   CompressImage(image);d   CloseImage(image);   free((char *) data);   return(image); }l o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %nO %                                                                             %(O %                                                                             %>O %  R e a d X C I m a g e                                                      %(O %                                                                             %yO %                                                                             % O %                                                                             %&O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) % G %  Function ReadXCImage creates a constant image and initializes to the>H %  X server color as specified by the filename.  It allocates the memoryI %  necessary for the new Image structure and returns a pointer to the newa	 %  image.m % , %  The format of the ReadXCImage routine is: % $ %      image=ReadXCImage(image_info) %%+ %  A description of each parameter follows:  % H %    o image:  Function ReadXCImage returns a pointer to the image afterL %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.N %E %m */% static Image *ReadXCImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      unsigned int     height, 
     width;     XColor
     color;     /*     Allocate image structure.%   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);I   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;a(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);A   /*     Initialize Image structure.R   */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;    image->rows=height;dE   image->packets=((image->columns*image->rows-1)/(MaxRunlength+1))+1;n#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));d   image->class=PseudoClass;e   image->colors=1;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Initialize colormap.   */:   (void) XQueryColorDatabase(image_info->filename,&color);/   image->colormap[0].red=XDownScale(color.red);)3   image->colormap[0].green=XDownScale(color.green);g1   image->colormap[0].blue=XDownScale(color.blue);    q=image->pixels;$   for (i=0; i < image->packets; i++)   {e     q->index=0;      q->length=MaxRunlength;N     q++;   }/   q--;M   q->length=image->columns*image->rows-(MaxRunlength+1)*(image->packets-1)-1;e   SyncImage(image);n   return(image); }  , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %mO %                                                                             % O %  R e a d X P M I m a g e                                                    %lO %                                                                             %UO %                                                                             %lO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%K %  Function ReadXBMImage reads an X11 pixmap image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadXPMImage routine is:  % % %      image=ReadXPMImage(image_info)g % + %  A description of each parameter follows:  % I %    o image:  Function ReadXPMImage returns a pointer to the image after L %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.% %% %% */
 #ifdef HasXPM% #include "xpm.h"& static Image *ReadXPMImage(image_info)	 ImageInfoa   *image_info; {r   char     *xpm_buffer;  	   Displayr
     *display;c     Imagem     *image;      inte     length,t     status,r     x,     y;     register char      *q;e     register int     i;     register RunlengthPacket     *p;B     register unsigned long
     pixel;     XColor     *colors;     XImage     *matte_image,      *ximage;     XpmAttributes      xpm_attributes;      XResourceInfo      resource_info;  
   XrmDatabaseo     resource_database;     XStandardColormape     *map_info;  
   XVisualInfoi     *visual_info;n     /*     Allocate image structure.t   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"r");g#   if (image->file == (FILE *) NULL)g/     PrematureExit("Unable to open file",image);p   /*     Read XPM file.   */   length=MaxTextLength; 2   xpm_buffer=(char *) malloc(length*sizeof(char));"   if (xpm_buffer != (char *) NULL)     {        q=xpm_buffer;)C       while (fgets(q,MaxTextLength-1,image->file) != (char *) NULL)/       {m         q+=strlen(q);(2         if ((q-xpm_buffer+MaxTextLength) > length)           {              *q='\0';             length<<=1;e             xpm_buffer=(char *)t?               realloc((char *) xpm_buffer,length*sizeof(char));),             if (xpm_buffer == (char *) NULL)               break;,             q=xpm_buffer+strlen(xpm_buffer);           }i       }*     }n"   if (xpm_buffer == (char *) NULL)5     PrematureExit("Unable to allocate memory",image);    CloseImage(image);   /*     Open X server connection.=   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {-.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));r8       PrematureExit("Unable to create XPM image",image);     }k   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);t   /*     Allocate standard colormap.i   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)aM     Warning("Unable to create standard colormap","Memory allocation failed");G   else     {        /*         Initialize visual info.        */C       visual_info=XBestVisualInfo(display,map_info,&resource_info);n.       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;+     } 1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {GF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);8       PrematureExit("Unable to create XPM image",image);     }r   /*     Initialize X colormap.   */-   map_info->colormap=XCreateColormap(display, A     XRootWindow(display,visual_info->screen),visual_info->visual,0>     visual_info->class == DirectColor ? AllocAll : AllocNone);,   if (map_info->colormap == (Colormap) NULL)     {gF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);7       PrematureExit("Unable to create colormap",image);      }m   /*     Initialize XPM attributes.   */L   xpm_attributes.valuemask=XpmColorKey | XpmColormap | XpmDepth | XpmVisual;,   xpm_attributes.visual=visual_info->visual;-   xpm_attributes.colormap=map_info->colormap; *   xpm_attributes.depth=visual_info->depth;%   xpm_attributes.color_key=XPM_COLOR;g   /*>     Read in a file in the XPM format into a X image structure.   */J   status=XpmCreateImageFromBuffer(display,xpm_buffer,&ximage,&matte_image,     &xpm_attributes);g   if (status != XpmSuccess)      {-F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);8       PrematureExit("Unable to create XPM image",image);     }    free((char *) xpm_buffer);%   XpmFreeAttributes(&xpm_attributes);o   /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {gF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);7       PrematureExit("Unable to read X colormap",image);      } O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor)) 2     for (i=0; i < visual_info->colormap_size; i++)     {        colors[i].pixel=i;       colors[i].pad=0;     }I   else     {        unsigned long 
         blue,          blue_bit,          green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0; C       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1);%I       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1); F       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       {y+         colors[i].pixel=red | green | blue;a         colors[i].pad=0;         red+=red_bit;t(         if (red > visual_info->red_mask)           red=0;         green+=green_bit;r,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit;t*         if (blue > visual_info->blue_mask)           blue=0;e       }e     } M   XQueryColors(display,map_info->colormap,colors,visual_info->colormap_size);:   /*#     Convert X image to MIFF format.u   */O   if ((visual_info->class != TrueColor) && (visual_info->class != DirectColor))%     image->class=PseudoClass;d   image->columns=ximage->width;k   image->rows=ximage->height;a,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)]3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     {i       free((char *) colors);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);7       PrematureExit("Unable to allocate memory",image);      }e   p=image->pixels;   switch (image->class)a   {      case DirectClass:a     {c       register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,i         green_mask,p         green_shift,         red_mask,=         red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;        red_shift=0;$       while ((red_mask & 0x01) == 0)       {a         red_mask>>=1;)         red_shift++;       }E)       green_mask=visual_info->green_mask;        green_shift=0;&       while ((green_mask & 0x01) == 0)       {e         green_mask>>=1;a         green_shift++;       }c'       blue_mask=visual_info->blue_mask;        blue_shift=0;t%       while ((blue_mask & 0x01) == 0)c       {e         blue_mask>>=1;         blue_shift++;f       }        /*/         Convert X image to DirectClass packets.-       */-       if ((visual_info->colormap_size > 0) &&b.           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++)e	         { ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red);b6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green);r4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);              p->index=0;b             p->length=0;             p++;           }=	         }o
       else'         for (y=0; y < image->rows; y++)i,           for (x=0; x < image->columns; x++)           {l(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;F             p->red=XDownScale(((unsigned long) color*65535)/red_mask);6             color=(pixel >> green_shift) & green_mask;J             p->green=XDownScale(((unsigned long) color*65535)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;H             p->blue=XDownScale(((unsigned long) color*65535)/blue_mask);             p->index=0;              p->length=0;             p++;           }g       break;     }      case PseudoClass:t     {r       /*         Create colormap.       *//       image->colors=visual_info->colormap_size;eP       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {)            free((char *) colors);J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);            XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL);x	         } '       for (i=0; i < image->colors; i++)        { G         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red);bK         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green);uI         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);*       }        /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++)a*         for (x=0; x < image->columns; x++)	         { :           p->index=(unsigned short) XGetPixel(ximage,x,y);           p->length=0;           p++;	         })       SyncImage(image);        break;     }e   } %   if (matte_image != (XImage *) NULL)      {        /*         Initialize image matte.0       */       image->class=DirectClass;        image->matte=True;       p=image->pixels;%       for (y=0; y < image->rows; y++) *         for (x=0; x < image->columns; x++)	         {r           p->index=Opaque;*           if (!XGetPixel(matte_image,x,y))!             p->index=Transparent;            p++;	         }e!       XDestroyImage(matte_image);i     }p"   if (image->class == PseudoClass)     CompressColormap(image);   /*     Free resources.    */   free((char *) colors);   XDestroyImage(ximage);B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   CompressImage(image);n   return(image); }n #else5& static Image *ReadXPMImage(image_info)	 ImageInfo=   *image_info; {;?   Warning("XPM library is not available",image_info->filename);p$   return(ReadMIFFImage(image_info)); }( #endif 4 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %=O %                                                                             %eO %                                                                             %nO %  R e a d X W D I m a g e                                                    % O %                                                                             %)O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %aL %  Function ReadXWDImage reads an X Window System window dump image file andM %  returns it.  It allocates the memory necessary for the new Image structureh* %  and returns a pointer to the new image. %-- %  The format of the ReadXWDImage routine is:  % % %      image=ReadXWDImage(image_info)s %i+ %  A description of each parameter follows:+ % I %    o image:  Function ReadXWDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.+ %mA %    o image_info: Specifies a pointer to an ImageInfo structure.; %  %  */& static Image *ReadXWDImage(image_info)	 ImageInfo    *image_info; {e   Image      *image;(     int      status,p     x,     y;     register int     i;     register RunlengthPacket     *q;d     register unsigned long
     pixel;     unsigned longm     lsb_first;     unsigned int     packets;     unsigned short
     index;     XColor     *colors;     XImage     *ximage;     XWDFileHeader      header;c     /*     Allocate image structure.p   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);m   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*       Read in header information.   */?   status=ReadData((char *) &header,sz_XWDheader,1,image->file);    if (status == False);     PrematureExit("Unable to read dump file header",image);-   /*@     Ensure the header byte-order is most-significant byte first.   */   lsb_first=1;   if (*(char *) &lsb_first)c5     MSBFirstOrderLong((char *) &header,sz_XWDheader);e   /*:     Check to see if the dump file is in the proper format.   */.   if (header.file_version != XWD_FILE_VERSION)<     PrematureExit("XWD file format version mismatch",image);(   if (header.header_size < sz_XWDheader)8     PrematureExit("XWD header size is too small",image);,   packets=(header.header_size-sz_XWDheader);<   image->comments=(char *) malloc((packets+1)*sizeof(char));'   if (image->comments == (char *) NULL) 5     PrematureExit("Unable to allocate memory",image); B   status=ReadData((char *) image->comments,1,packets,image->file);    image->comments[packets]='\0';   if (status == False)F     PrematureExit("Unable to  read window name from dump file",image);   /*     Initialize the X image.C   */+   ximage=(XImage *) malloc(sizeof(XImage));o    if (ximage == (XImage *) NULL)5     PrematureExit("Unable to allocate memory",image);r$   ximage->depth=header.pixmap_depth;&   ximage->format=header.pixmap_format;!   ximage->xoffset=header.xoffset;o   ximage->data=(char *) NULL;q$   ximage->width=header.pixmap_width;&   ximage->height=header.pixmap_height;'   ximage->bitmap_pad=header.bitmap_pad;//   ximage->bytes_per_line=header.bytes_per_line;]'   ximage->byte_order=header.byte_order; )   ximage->bitmap_unit=header.bitmap_unit;(3   ximage->bitmap_bit_order=header.bitmap_bit_order; /   ximage->bits_per_pixel=header.bits_per_pixel;i#   ximage->red_mask=header.red_mask; '   ximage->green_mask=header.green_mask; %   ximage->blue_mask=header.blue_mask;    status=XInitImage(ximage);   if (status == False).     PrematureExit("Invalid XWD header",image);   /*     Read colormap.   */   colors=(XColor *) NULL;    if (header.ncolors != 0)     {        XWDColor         color;  M       colors=(XColor *) malloc((unsigned int) header.ncolors*sizeof(XColor));S$       if (colors == (XColor *) NULL)9         PrematureExit("Unable to allocate memory",image);-(       for (i=0; i < header.ncolors; i++)       { C         status=ReadData((char *) &color,sz_XWDColor,1,image->file);i         if (status == False)I           PrematureExit("Unable to read color map from dump file",image);n$         colors[i].pixel=color.pixel;          colors[i].red=color.red;$         colors[i].green=color.green;"         colors[i].blue=color.blue;$         colors[i].flags=color.flags;       }        /*D         Ensure the header byte-order is most-significant byte first.       */       lsb_first=1;       if (*(char *) &lsb_first)e*         for (i=0; i < header.ncolors; i++)	         { M           MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(unsigned long));eO           MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(unsigned short)); 	         }u     }-   /*     Allocate the pixel buffer.   */    if (ximage->format == ZPixmap)2     packets=ximage->bytes_per_line*ximage->height;   else@     packets=ximage->bytes_per_line*ximage->height*ximage->depth;>   ximage->data=(char *) malloc(packets*sizeof(unsigned char));$   if (ximage->data == (char *) NULL)5     PrematureExit("Unable to allocate memory",image);e6   status=ReadData(ximage->data,1,packets,image->file);   if (status == False)6     PrematureExit("Unable to read dump pixmap",image);   /*!     Convert image to MIFF format.t   */   image->columns=ximage->width;    image->rows=ximage->height;c?   if ((colors == (XColor *) NULL) || (ximage->red_mask != 0) ||l<       (ximage->green_mask != 0) || (ximage->blue_mask != 0))     image->class=DirectClass;    else     image->class=PseudoClass;    image->colors=header.ncolors;I   image->packets=0; 5   packets=Max((image->columns*image->rows+4) >> 3,1);vL   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    q=image->pixels;   q->length=MaxRunlength;t   switch (image->class)(   {k     case DirectClass:      {        register unsigned long         color;         unsigned int
         blue,e         green,         red;         unsigned long%         blue_mask,         blue_shift,%         green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */        red_mask=ximage->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;e         red_shift++;       } $       green_mask=ximage->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } "       blue_mask=ximage->blue_mask;       blue_shift=0; %       while ((blue_mask & 0x01) == 0)o       {%         blue_mask>>=1;         blue_shift++;%       }%       /*/         Convert X image to DirectClass packets.B       */       if (image->colors != 0)c'         for (y=0; y < image->rows; y++)g	         { ,           for (x=0; x < image->columns; x++)           {r(             pixel=XGetPixel(ximage,x,y);E             index=(unsigned short) ((pixel >> red_shift) & red_mask);r.             red=XDownScale(colors[index].red);I             index=(unsigned short) ((pixel >> green_shift) & green_mask);m2             green=XDownScale(colors[index].green);G             index=(unsigned short) ((pixel >> blue_shift) & blue_mask);p0             blue=XDownScale(colors[index].blue);N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))                q->length++;             else               {x(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {e                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);a5                     q=image->pixels+image->packets-1;_                   }i                 q->red=red;                  q->green=green;                  q->blue=blue;                  q->index=0;a                 q->length=0;               }r           }G	         } 
       else'         for (y=0; y < image->rows; y++)e,           for (x=0; x < image->columns; x++)           {e(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;C             red=XDownScale(((unsigned long) color*65535)/red_mask);g6             color=(pixel >> green_shift) & green_mask;G             green=XDownScale(((unsigned long) color*65535)/green_mask);p4             color=(pixel >> blue_shift) & blue_mask;E             blue=XDownScale(((unsigned long) color*65535)/blue_mask);SN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))                q->length++;             else               {((                 if (image->packets != 0)                   q++;!                 image->packets++;e.                 if (image->packets == packets)                   {1                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));(B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);.5                     q=image->pixels+image->packets-1;h                   }S                 q->red=red;                  q->green=green;_                 q->blue=blue;e                 q->index=0;l                 q->length=0;               }p           }/       break;     }s     case PseudoClass:a     {i       /*/         Convert X image to PseudoClass packets.p       */P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); '       for (i=0; i < image->colors; i++)        { 9         image->colormap[i].red=XDownScale(colors[i].red);a=         image->colormap[i].green=XDownScale(colors[i].green);c;         image->colormap[i].blue=XDownScale(colors[i].blue);U       }a%       for (y=0; y < image->rows; y++)z*         for (x=0; x < image->columns; x++)	         { &           pixel=XGetPixel(ximage,x,y);           index=pixel;F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             { &               if (image->packets != 0)                 q++;               image->packets++;l,               if (image->packets == packets)                 {                    packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image);e3                   q=image->pixels+image->packets-1;*                 }c               q->index=index;e               q->length=0;
             }t	         }        SyncImage(image);c       CompressColormap(image);       break;     })   } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    /*     Free image and colormap.   */   if (header.ncolors != 0)     free((char *) colors);   free(ximage->data);g   free(ximage);o   CloseImage(image);   return(image); }l o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.O %                                                                             %iO %                                                                             %MO %                                                                             % O %  R e a d Y U V I m a g e                                                    %sO %                                                                             %.O %                                                                             %eO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %.O %  Function ReadYUVImage reads an image with digital YUV (CCIR 601 4:1:1) bytes G %  and returns it.  It allocates the memory necessary for the new Imagep4 %  structure and returns a pointer to the new image. %s- %  The format of the ReadYUVImage routine is:f %t% %      image=ReadYUVImage(image_info)  % + %  A description of each parameter follows:e %yI %    o image:  Function ReadYUVImage returns a pointer to the image afteroL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %)A %    o image_info: Specifies a pointer to an ImageInfo structure.s %= %l */& static Image *ReadYUVImage(image_info)	 ImageInfo(   *image_info; {    Image      *image,a     *zoomed_image;     int      x,     y;     register int     i;     register RunlengthPacket     *q;s     register unsigned char     *p;i     unsigned chars     *yuv_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */)   zoomed_image=AllocateImage(image_info);a%   if (zoomed_image == (Image *) NULL)      return((Image *) NULL);y   /*     Open image file.   */=   (void) strcpy(zoomed_image->filename,image_info->filename);    OpenImage(zoomed_image,"rb");)*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)a   /*-     Determine width and height, e.g. 640x512.s   */   width=512;
   height=512;D   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++) %     (void) fgetc(zoomed_image->file);s   /*     Read Y channel.    */#   zoomed_image->columns=width >> 1;m!   zoomed_image->rows=height >> 1; A   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;e   yuv_pixels=(unsigned char *)7     malloc((3*(width*height)/2)*sizeof(unsigned char));k*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));/   if ((yuv_pixels == (unsigned char *) NULL) ||t9       (zoomed_image->pixels == (RunlengthPacket *) NULL))t<     PrematureExit("Unable to allocate memory",zoomed_image);O   (void) ReadData((char *) yuv_pixels,1,3*(width*height)/2,zoomed_image->file);    /*     Initialize U channel.p   */   p=yuv_pixels+(width*height);   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)w   {y     q->green=UpScale(*p);      q->index=0;      q->length=0;     p++;     q++;   }    /*     Initialize V channel.    */   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)    {-     q->blue=UpScale(*p);     p++;     q++;   }    /*     Scale image.   */   zoomed_image->orphan=True;    image=ZoomImage(zoomed_image);   zoomed_image->orphan=False;;   CloseImage(zoomed_image);a   DestroyImage(zoomed_image);    if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);=   p=yuv_pixels;    q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {r     q->red=UpScale(*p);L     p++;     q++;   }i   free((char *) yuv_pixels);+   TransformRGBImage(image,YCbCrColorspace);;   CompressImage(image);    return(image); }] d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %gO %  R e a d Y U V 3 I m a g e                                                  % O %                                                                             %xO %                                                                             % O %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %sJ %  Function ReadYUV3Image reads an image with digital YUV (CCIR 601 2:1:1)M %  bytes and returns it.  It allocates the memory necessary for the new Image/K %  structure and returns a pointer to the new image.  This function differs(J %  from ReadYUVImage in that it reads the Y, U, and V planes from separate) %  files (image.Y, image.U, and image.V).  % . %  The format of the ReadYUV3Image routine is: %i& %      image=ReadYUV3Image(image_info) %f+ %  A description of each parameter follows:+ % J %    o image:  Function ReadYUV3Image returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %lA %    o image_info: Specifies a pointer to an ImageInfo structure.% %% %% */' static Image *ReadYUV3Image(image_info)%	 ImageInfo    *image_info; {    char     filename[MaxTextLength];     Image      *image,      *zoomed_image;     int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned charS     *uv_pixels,      *y_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */)   zoomed_image=AllocateImage(image_info); %   if (zoomed_image == (Image *) NULL)      return((Image *) NULL);    /*     Open image file.   *//   (void) strcpy(filename,image_info->filename);%1   (void) strcpy(zoomed_image->filename,filename);%.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".Y");l   OpenImage(zoomed_image,"rb"); *   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)R   /*-     Determine width and height, e.g. 640x512.g   */   width=512;
   height=512;n   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);r   for (i=0; i < x; i++)r%     (void) fgetc(zoomed_image->file);    /*     Read Y channel.n   */#   zoomed_image->columns=width >> 1;i!   zoomed_image->rows=height >> 1;uA   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;n   uv_pixels=(unsigned char *)M8     malloc(zoomed_image->packets*sizeof(unsigned char));   y_pixels=(unsigned char *):     malloc(4*zoomed_image->packets*sizeof(unsigned char));*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));.   if ((uv_pixels == (unsigned char *) NULL) ||-       (y_pixels == (unsigned char *) NULL) ||a9       (zoomed_image->pixels == (RunlengthPacket *) NULL)) <     PrematureExit("Unable to allocate memory",zoomed_image);P   (void) ReadData((char *) y_pixels,4,zoomed_image->packets,zoomed_image->file);   CloseImage(zoomed_image);n   /*     Read U channel.*   */1   (void) strcpy(zoomed_image->filename,filename);m.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".U");a   OpenImage(zoomed_image,"rb");,*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)*=   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,s     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;f+   for (i=0; i < zoomed_image->packets; i++)9   {5     q->green=UpScale(*p);t     q->index=0;g     q->length=0;     p++;     q++;   }a   CloseImage(zoomed_image);_   /*     Read V channel.o   */1   (void) strcpy(zoomed_image->filename,filename);m.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".V");e   OpenImage(zoomed_image,"rb");d*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image) =   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,:     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)p   {      q->blue=UpScale(*p);     p++;     q++;   }a   CloseImage(zoomed_image);-   free((char *) uv_pixels);    /*     Scale image.   */   zoomed_image->orphan=True;    image=ZoomImage(zoomed_image);   zoomed_image->orphan=False;    CloseImage(zoomed_image);l   DestroyImage(zoomed_image);    if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);]
   p=y_pixels;/   q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {>     q->red=UpScale(*p);      p++;     q++;   }M   free((char *) y_pixels);+   TransformRGBImage(image,YCbCrColorspace);;*   (void) strcpy(image->filename,filename);   CompressImage(image);a   return(image); }l a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             % O %                                                                             %)O %                                                                             %oO %   R e a d I m a g e                                                         %NO %                                                                             %iO %                                                                             %0O %                                                                             %[O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c % B %  Function ReadImage reads an image and returns it.  It allocatesL %  the memory necessary for the new Image structure and returns a pointer toJ %  the new image.  By default, the image format is determined by its magicM %  number. To specify a particular image format, precede the filename with an(M %  explicit image format name and a colon (i.e.  ps:image) or as the filenamee %  suffix  (i.e. image.ps).  % * %  The format of the ReadImage routine is: %S" %      image=ReadImage(image_info) % + %  A description of each parameter follows:a %cE %    o image: Function ReadImage returns a pointer to the image afterpL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.( %aA %    o image_info: Specifies a pointer to an ImageInfo structure.i %e %i */ Image *ReadImage(image_info)	 ImageInfo    *image_info; {    char      magic_number[MaxTextLength];     Imagey     decode_image,"     *image;      ImageInfoa     decode_info;     register charl     *p;e     register int     i;     SetImageMagick(image_info);    decode_info=(*image_info);   decode_image.temporary=False;(3   if ((strncmp(decode_info.magick,"FTP",3) == 0) ||n4       (strncmp(decode_info.magick,"HTTP",4) == 0) ||4       (strncmp(decode_info.magick,"GOPHER",6) == 0))     { 
       char         command[MaxTextLength],g          filename[MaxTextLength];         /*H         Retrieve image as specified with a WWW uniform resource locator.       */"       decode_image.temporary=True;"       TemporaryFilename(filename);P       (void) sprintf(command,WWWCommand,decode_info.magick,decode_info.filename,         filename);$       (void) SystemCommand(command);#       SetImageMagick(&decode_info);z3       (void) strcpy(decode_info.filename,filename);g     }rJ   if (!decode_info.assert || (strncmp(decode_info.magick,"SGI",3) == 0) ||1       (strncmp(decode_info.magick,"PCD",3) == 0))t     {t       /*/         Determine type from image magic number.        *//       for (i=0 ; i < sizeof(magic_number); i++)u         magic_number[i]='\0';g@       (void) strcpy(decode_image.filename,decode_info.filename);$       OpenImage(&decode_image,"rb");-       if (decode_image.file != (FILE *) NULL)c>         if ((decode_image.file == stdin) || decode_image.pipe)           {              FILE               *file;               int(               c;               /*<               Copy standard input or pipe to temporary file.             */(             decode_image.temporary=True;5             TemporaryFilename(decode_image.filename);-7             decode_info.filename=decode_image.filename; 3             file=fopen(decode_image.filename,"wb"); &             if (file == (FILE *) NULL)               {eE                 Warning("Unable to write file",decode_info.filename); '                 return((Image *) NULL);                } '             c=fgetc(decode_image.file);              while (c != EOF)
             {;"               (void) putc(c,file);)               c=fgetc(decode_image.file);e
             }!              (void) fclose(file);&             CloseImage(&decode_image);*             OpenImage(&decode_image,"rb");           }&-       if (decode_image.file != (FILE *) NULL)-	         {            /*             Read magic number.           */C           (void) ReadData(magic_number,(unsigned int) sizeof(char),)C             (unsigned int) sizeof(magic_number),decode_image.file);a:           if (((unsigned char) magic_number[0] == 0xff) &&8               ((unsigned char) magic_number[1] == 0xff))
             {u               register int                 i;                 /*6                 For PCD image type, skip to byte 2048.               */D               for (i=0; i < (int) (0x800-sizeof(magic_number)); i++)0                 (void) fgetc(decode_image.file);G               (void) ReadData(magic_number,(unsigned int) sizeof(char), G                 (unsigned int) sizeof(magic_number),decode_image.file);o
             } $           CloseImage(&decode_image);	         }s       /*#         Determine the image format.i       */)       magic_number[MaxTextLength-1]='\0'; ,       if (strncmp(magic_number,"BM",2) == 0)0         (void) strcpy(decode_info.magick,"BMP");-       if (strncmp(magic_number,"IT0",3) == 0) 1         (void) strcpy(decode_info.magick,"FITS"); .       if (strncmp(magic_number,"GIF8",4) == 0)0         (void) strcpy(decode_info.magick,"GIF");:       if (strncmp(magic_number,"\016\003\023\001",4) == 0)0         (void) strcpy(decode_info.magick,"HDF");2       if (strncmp(magic_number,"\001\332",2) == 0)0         (void) strcpy(decode_info.magick,"SGI");:       if (strncmp(magic_number,"\377\330\377\340",4) == 0)1         (void) strcpy(decode_info.magick,"JPEG"); 9       if (strncmp(magic_number,"id=ImageMagick",14) == 0) 1         (void) strcpy(decode_info.magick,"MIFF");t.       if (strncmp(magic_number,"PCD_",4) == 0)0         (void) strcpy(decode_info.magick,"PCD");0       if ((unsigned char) *magic_number == 0x0a)0         (void) strcpy(decode_info.magick,"PCX");/       if (strncmp(magic_number,"%!PDF",5) == 0) 0         (void) strcpy(decode_info.magick,"PDF");=       if ((*magic_number == 'P') && isdigit(magic_number[1]))a0         (void) strcpy(decode_info.magick,"PNM");;       if (strncmp(magic_number,"\211PNG\r\n\032\n",8) == 0)(0         (void) strcpy(decode_info.magick,"PNG");,       if (strncmp(magic_number,"%!",2) == 0)/         (void) strcpy(decode_info.magick,"PS"); 5       if (strncmp(magic_number,"#?RADIANCE",10) == 0)m0         (void) strcpy(decode_info.magick,"RAD");2       if (strncmp(magic_number,"\122\314",2) == 0)0         (void) strcpy(decode_info.magick,"RLE");:       if (strncmp(magic_number,"\131\246\152\225",4) == 0)0         (void) strcpy(decode_info.magick,"SUN");>       if ((strncmp(magic_number,"\115\115\000\052",4) == 0) ||<           (strncmp(magic_number,"\111\111\052\000",4) == 0))1         (void) strcpy(decode_info.magick,"TIFF"); 5       if ((strncmp(magic_number,"LBLSIZE",7) == 0) || 2           (strncmp(magic_number,"NJPL1I",6) == 0))2         (void) strcpy(decode_info.magick,"VICAR");0       if ((unsigned char) *magic_number == 0xab)1         (void) strcpy(decode_info.magick,"VIFF");R!       p=strchr(magic_number,'#');        if (p != (char *) NULL) (         if (strncmp(p,"#define",7) == 0)2           (void) strcpy(decode_info.magick,"XBM");3       if (strncmp(magic_number,"/* XPM */",9) == 0) 0         (void) strcpy(decode_info.magick,"XPM");A       if ((magic_number[1] == 0x00) && (magic_number[2] == 0x00))%C         if ((magic_number[5] == 0x00) && (magic_number[6] == 0x00))nE           if ((magic_number[4] == 0x07) || (magic_number[7] == 0x07)) 4             (void) strcpy(decode_info.magick,"XWD");     }u   /*6     Call appropriate image reader based on image type.   */   switch (*decode_info.magick)   { 
     case 'A':e     {R'       image=ReadAVSImage(&decode_info);n       break;     }l
     case 'B':      {e0       if (strcmp(decode_info.magick,"BIE") == 0)*         image=ReadJBIGImage(&decode_info);
       else)         image=ReadBMPImage(&decode_info);        break;     }b
     case 'C':      {a(       image=ReadCMYKImage(&decode_info);       break;     } 
     case 'E':a     {d&       image=ReadPSImage(&decode_info);       break;     }n
     case 'F':      {f0       if (strcmp(decode_info.magick,"FAX") == 0))         image=ReadFAXImage(&decode_info); 
       else*         image=ReadFITSImage(&decode_info);       break;     } 
     case 'G':a     { 0       if (strcmp(decode_info.magick,"GIF") == 0))         image=ReadGIFImage(&decode_info);i
       else4         if (strcmp(decode_info.magick,"GIF87") == 0)+           image=ReadGIFImage(&decode_info);n         else5           if (strcmp(decode_info.magick,"GRAY") == 0)a.             image=ReadGRAYImage(&decode_info);           else-             image=ReadFAXImage(&decode_info);s       break;     };
     case 'H':i     { 0       if (strcmp(decode_info.magick,"HDF") == 0))         image=ReadHDFImage(&decode_info);r
       else/         image=ReadHISTOGRAMImage(&decode_info);n       break;     } 
     case 'J':      {=1       if (strcmp(decode_info.magick,"JBIG") == 0)d*         image=ReadJBIGImage(&decode_info);
       else*         image=ReadJPEGImage(&decode_info);       break;     }g
     case 'L':      {((       image=ReadLOGOImage(&decode_info);       break;     }(
     case 'M':      {g0       if (strcmp(decode_info.magick,"MAP") == 0))         image=ReadMAPImage(&decode_info);T
       else4         if (strcmp(decode_info.magick,"MATTE") == 0)-           image=ReadMATTEImage(&decode_info);d         else5           if (strcmp(decode_info.magick,"MIFF") == 0)(.             image=ReadMIFFImage(&decode_info);           else;             if ((strcmp(decode_info.magick,"MPEG") == 0) ||>8                 (strcmp(decode_info.magick,"MPG") == 0))0               image=ReadMPEGImage(&decode_info);             else/               image=ReadMTVImage(&decode_info);o       break;     } 
     case 'N':l     {i(       image=ReadNULLImage(&decode_info);       break;     }h
     case 'P':)     { 0       if (strcmp(decode_info.magick,"PCD") == 0))         image=ReadPCDImage(&decode_info);o
       else2         if (strcmp(decode_info.magick,"PCX") == 0)+           image=ReadPCXImage(&decode_info);(         else4           if (strcmp(decode_info.magick,"PDF") == 0)-             image=ReadPDFImage(&decode_info);/           else7             if (strcmp(decode_info.magick,"PICT") == 0)r0               image=ReadPICTImage(&decode_info);             else7               if (strcmp(decode_info.magick,"PM") == 0)n1                 image=ReadXPMImage(&decode_info);f               else:                 if (strcmp(decode_info.magick,"PNG") == 0)3                   image=ReadPNGImage(&decode_info);                  else?                   if ((strcmp(decode_info.magick,"PS") == 0) ||.>                       (strcmp(decode_info.magick,"PS2") == 0))4                     image=ReadPSImage(&decode_info);                   else5                     image=ReadPNMImage(&decode_info);t       break;     } 
     case 'R':a     {m0       if (strcmp(decode_info.magick,"RAD") == 0).         image=ReadRADIANCEImage(&decode_info);
       else2         if (strcmp(decode_info.magick,"RAS") == 0)+           image=ReadSUNImage(&decode_info);s         else8           if ((strcmp(decode_info.magick,"RGB") == 0) ||7               (strcmp(decode_info.magick,"RGBA") == 0)) -             image=ReadRGBImage(&decode_info);a           else-             image=ReadRLEImage(&decode_info);        break;     }C
     case 'S':      { 0       if (strcmp(decode_info.magick,"SGI") == 0))         image=ReadSGIImage(&decode_info);N
       else)         image=ReadSUNImage(&decode_info);y       break;     }o
     case 'T':g     {r1       if (strcmp(decode_info.magick,"TEXT") == 0)r*         image=ReadTEXTImage(&decode_info);
       else2         if (strcmp(decode_info.magick,"TGA") == 0)-           image=ReadTARGAImage(&decode_info);/         else8           if ((strcmp(decode_info.magick,"TIF") == 0) ||7               (strcmp(decode_info.magick,"TIFF") == 0)) .             image=ReadTIFFImage(&decode_info);           else.             image=ReadTILEImage(&decode_info);       break;     }b
     case 'V':      { 2       if (strcmp(decode_info.magick,"VICAR") == 0)+         image=ReadVICARImage(&decode_info);a
       else2         if (strcmp(decode_info.magick,"VID") == 0)           { #             if (decode_info.assert) /               image=ReadVIDImage(&decode_info);              else0               image=ReadMIFFImage(&decode_info);           }          else,           image=ReadVIFFImage(&decode_info);       break;     } 
     case 'X':      { .       if (strcmp(decode_info.magick,"X") == 0)?         image=ReadXImage(&decode_info,False,False,False,False); 
       else1         if (strcmp(decode_info.magick,"XC") == 0)c*           image=ReadXCImage(&decode_info);         else4           if (strcmp(decode_info.magick,"XBM") == 0)-             image=ReadXBMImage(&decode_info);o           else6             if (strcmp(decode_info.magick,"XPM") == 0)/               image=ReadXPMImage(&decode_info);              else7               if (strcmp(decode_info.magick,"XV") == 0)a2                 image=ReadVIFFImage(&decode_info);               else1                 image=ReadXWDImage(&decode_info);(       break;     }_
     case 'Y':e     {00       if (strcmp(decode_info.magick,"YUV") == 0))         image=ReadYUVImage(&decode_info);;
       else*         image=ReadYUV3Image(&decode_info);       break;     }e     default:     {R/       (void) strcpy(decode_info.magick,"MIFF");y(       image=ReadMIFFImage(&decode_info);     }.   }_   if (decode_image.temporary) (     (void) unlink(decode_info.filename);   if (image != (Image *) NULL)     {        if (image->status)K         Warning("An error has occurred reading from file",image->filename);c!       if (decode_image.temporary)M<         (void) strcpy(image->filename,image_info->filename);+       if (image->comments == (char *) NULL) ;         CommentImage(image,"  Imported from %m image: %f"); A       (void) strcpy(image->magick_filename,image_info->filename); %       if (image->magick_columns == 0) -         image->magick_columns=image->columns; "       if (image->magick_rows == 0)'         image->magick_rows=image->rows; 2       image_info->interlace=decode_info.interlace;     }    return(image); }g