 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             DDDD   IIIII  SSSSS  PPPP   L       AAA   Y   Y                 % O %             D   D    I    SS     P   P  L      A   A   Y Y                  % O %             D   D    I     SSS   PPPP   L      AAAAA    Y                   % O %             D   D    I       SS  P      L      A   A    Y                   % O %             DDDD   IIIII  SSSSS  P      LLLLL  A   A    Y                   % O %                                                                             % O %                                                                             % O %          Display Machine Independent File Format Image via X11.             % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Display is a machine architecture independent image processing G %  and display program.  It can display any image in the MIFF format on C %  any workstation display running X.  Display first determines the E %  hardware capabilities of the workstation.  If the number of unique J %  colors in the image is less than or equal to the number the workstationE %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Display program command syntax is:  % > %  Usage: display [options ...] file [ [options ...] file ...] %  %  Where options include: < %    -backdrop          display image centered on a backdrop8 %    -blur factor       apply a filter to blur the image= %    -border geometry   surround image with a border of color ) %    -colormap type     Shared or Private ? %    -colors value      preferred number of colors in the image G %    -colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV 5 %    -comment string    annotate image with comment", 4 %    -compress type     RunlengthEncoded or QEncoded< %    -contrast          enhance or reduce the image contrastH %    -crop geometry     preferred size and location of the cropped image< %    -delay seconds     display the next image after pausingD %    -density geometry  vertical and horizontal density of the image; %    -despeckle         reduce the speckles within an image 6 %    -display server    display image to this X serverF %    -dither            apply Floyd/Steinberg error diffusion to imageC %    -edge              apply a filter to detect edges in the image G %    -enhance           apply a digital filter to enhance a noisy image B %    -equalize          perform histogram equalization to an image< %    -flip              flip image in the vertical direction> %    -flop              flop image in the horizontal direction@ %    -frame geometry    surround image with an ornamental border1 %    -gamma value       level of gamma correction G %    -geometry geometry preferred size and location of the Image window : %    -immutable         displayed image cannot be modified, %    -interlace type    NONE, LINE, or PLANE2 %    -label name        assign a label to an imageB %    -map type          display image using this Standard Colormap@ %    -matte             store matte channel if the image has one@ %    -modulate value    vary the brightness, saturation, and hue: %    -monochrome        transform image to black and white6 %    -negate            apply color inversion to imageI %    -noise             reduce noise with a noise peak elimination filter L %    -normalize         transform image to span the full the range of colors: %    -opaque color      change this color to the pen color@ %    -page geometry     size and location of the Postscript pageE %    -pen color         color for annotating or changing opaque color , %    -quality value     JPEG quality settingI %    -raise value       lighten/darken image edges to create a 3-D effect @ %    -roll geometry     roll an image vertically or horizontally9 %    -rotate degrees    apply Paeth rotation to the image 7 %    -sample geometry   scale image with pixel sampling * %    -scene value       image scene number1 %    -size geometry     width and height of image ; %    -sharpen factor    apply a filter to sharpen the image I %    -shear geometry    slide one edge of the image along the X or Y axis 1 %    -size geometry     width and height of image > %    -treedepth value   depth of the color classification treeH %    -update seconds    detect when image file is modified and redisplayB %    -verbose           print detailed information about the image< %    -visual type       display image using this visual typeB %    -window id         display image to background of this window- %    -write filename    write image to a file  % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, I %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor, 0 %  -name, -shared_memory, -usePixmap, or -title. % D %  Change '-' to '+' in any option above to reverse its effect.  ForH %  example, specify +matte to store the image without its matte channel. % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 2 %    1    press to map or unmap the Command widget8 %    2    press and drag to magnify a region of an image> %    3    press to load an image from a visual image directory %  %  Keyboard accelerators: # %    l    load an image from a file   %    n    display the next image" %    f    display the former image7 %    F2   select an image to load from the command line # %    w    write the image to a file 1 %    p    print the image to a Postscript printer  %    del  delete the image file  %    C    create a blank canvas . %    ,    display the next image after pausing) %    V    create a Visual Image Directory ( %    u    undo last image transformation% %    F3   cut a region from the image $ %    F4   copy a region of the image% %    F5   paste a region to the image " %    @    refresh the Image window %    <    half the image size  %    o    original image size  %    >    double the image size  %    %    resize the image0 %    r    restore the image to its original size. %    A    make image transformations permanent %    [    crop the image %    ]    chop the image0 %    |    flop image in the horizontal direction. %    -    flip image in the vertical direction/ %    /    rotate the image 90 degrees clockwise 7 %    \    rotate the image 90 degrees counter-clockwise  %    *    rotate the image %    s    shear the image  %    t    trim the image edges %    F7   vary the image hue# %    F8   vary the color saturation # %    F9   vary the color brightness ! %    g    gamma correct the image $ %    F10  sharpen the image contrast! %    F11  dull the image contrast 5 %    =    perform histogram equalization on the image 6 %    N    perform histogram normalization on the image( %    ~    negate the colors of the image( %    G    convert the image to grayscale> %    #    set the maximum number of unique colors in the image- %    D    reduce the speckles within an image , %    P    eliminate peak noise from an image %    S    sharpen the image  %    B    blur the image& %    E    detect edges within an image %    M    emboss an image  %    O    oil paint an image$ %    Z    segment the image by color& %    a    annotate the image with text %    d    draw on the image # %    c    edit an image pixel color * %    m    edit the image matte information& %    x    composite image with another# %    b    add a border to the image  %    !    add an image commentC %    R    apply image processing techniques to a region of interest - %    i    display information about the image 0 %    v    display version number of this program0 %    h    display information about this program1 %    &    display image to background of a window  %    F12  set user preferences- %    q    discard all images and exit program + %    1-9  change the level of magnification  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h" #include "widget.h"  #include "PreRvIcccm.h"  #include "display.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Function Usage displays the program command syntax. % & %  The format of the Usage routine is: %  %      Usage(terminate)  % + %  A description of each parameter follows:  % J %    o terminate: A value other than zero is returned if the program is to %      terminate immediately.  %  */ static void Usage(terminate) unsigned int   terminate; {    char     **p;  
   static char      *buttons[]=      { 6       "1    press to map or unmap the Command widget",<       "2    press and drag to magnify a region of an image",B       "3    press to load an image from a visual image directory",       (char *) NULL      },     *options[]=      { @       "-backdrop          display image centered on a backdrop",<       "-blur factor       apply a filter to blur the image",A       "-border geometry   surround image with a border of color", -       "-colormap type     Shared or Private", C       "-colors value      preferred number of colors in the image", K       "-colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV", 7       "-comment string    annotate image with comment", 8       "-compress type     RunlengthEncoded or QEncoded",@       "-contrast          enhance or reduce the image contrast",L       "-crop geometry     preferred size and location of the cropped image",@       "-delay seconds     display the next image after pausing",H       "-density geometry  vertical and horizontal density of the image",?       "-despeckle         reduce the speckles within an image", :       "-display server    display image to this X server",J       "-dither            apply Floyd/Steinberg error diffusion to image",G       "-edge              apply a filter to detect edges in the image", K       "-enhance           apply a digital filter to enhance a noisy image", F       "-equalize          perform histogram equalization to an image",@       "-flip              flip image in the vertical direction",B       "-flop              flop image in the horizontal direction",D       "-frame geometry    surround image with an ornamental border",5       "-gamma value       level of gamma correction", K       "-geometry geometry preferred size and location of the Image window", >       "-immutable         displayed image cannot be modified",0       "-interlace type    NONE, LINE, or PLANE",6       "-label name        assign a label to an image",F       "-map type          display image using this Standard Colormap",D       "-matte             store matte channel if the image has one",D       "-modulate value    vary the brightness, saturation, and hue",>       "-monochrome        transform image to black and white",:       "-negate            apply color inversion to image",M       "-noise             reduce noise with a noise peak elimination filter", L       "-normalize         transform image to span the full range of colors",>       "-opaque color      change this color to the pen color",D       "-page geometry     size and location of the Postscript page",I       "-pen color         color for annotating or changing opaque color", 0       "-quality value     JPEG quality setting",M       "-raise value       lighten/darken image edges to create a 3-D effect", D       "-roll geometry     roll an image vertically or horizontally",=       "-rotate degrees    apply Paeth rotation to the image", .       "-scene value       image scene number",5       "-size geometry     width and height of image", ;       "-sample geometry   scale image with pixel sampling", ?       "-sharpen factor    apply a filter to sharpen the image", M       "-shear geometry    slide one edge of the image along the X or Y axis", 5       "-size geometry     width and height of image", B       "-treedepth value   depth of the color classification tree",L       "-update seconds    detect when image file is modified and redisplay",F       "-verbose           print detailed information about the image",@       "-visual type       display image using this visual type",F       "-window id         display image to background of this window",1       "-write filename    write image to a file",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version);    (void) printf(N     "Usage: %s [-options ...] file [ [-options ...] file ...]\n",client_name);/   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) printf(H     "resources as command line options:  -background, -bordercolor,\n");   (void) printf(P     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor,\n");   (void) printf(7     "-name, -shared_memory, -usePixmap, or -title.\n");    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(M     "example, specify +matte to store the image without a matte channel.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); !   (void) printf("\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    if (terminate)     exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % : %  Function _XAnnotateImage annotates the image with text. % 0 %  The format of the _XAnnotateImage routine is: % 9 %    _XAnnotateImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */H static unsigned int _XAnnotateImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {  #define AnnotateModeNameOp  0  #define AnnotateModeColorOp  1 #define AnnotateModeRotateOp  2  #define AnnotateModeHelpOp  3   #define AnnotateModeDismissOp  4 #define TextModeHelpOp  0  #define TextModeDismissOp  1  
   static char      *AnnotateModeMenu[]=     {        "Font Name",       "Font Color",        "Rotate Text",
       "Help",        "Dismiss",       (char *) NULL      },     *TextModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],      *p,      text[MaxTextLength];     Cursor     cursor;      GC     annotate_context;      int      id,      x,     y;     KeySym     key_symbol;      register int     i;     static double      degrees = 0.0;     static unsigned int      font_id = 0,     pen_id = 0;      unsigned int     height,      status, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XAnnotateInfo      *annotate_info,      *previous_info;   
   XFontStruct      *font_info;      XEvent
     event,     text_event;      /*     Map Command widget.    */#   windows->command.name="Annotate";    windows->command.data=3;J   (void) XCommandWidget(display,windows,AnnotateModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { "           case AnnotateModeNameOp:           {              char'               font_name[MaxTextLength], *               *FontMenu[MaxNumberFonts+1];               int                font_number;               /*)               Initialize menu selections.              */.             for (i=0; i < MaxNumberFonts; i++)6               FontMenu[i]=resource_info->font_name[i];4             FontMenu[MaxNumberFonts-1]="Browser...";3             FontMenu[MaxNumberFonts]=(char *) NULL;              /*6               Select a font name from the pop-up menu.             */I             font_number=XMenuWidget(display,windows,AnnotateModeMenu[id], "               FontMenu,font_name);2             if (font_number == (MaxNumberFonts-1))               {                  static char 3                   font_name[MaxTextLength]="fixed";                    /*4                   Select a font name from a browser.                 */E                 resource_info->font_name[MaxNumberFonts-1]=font_name; G                 XFontBrowserWidget(display,windows,"Select",font_name); '                 if (*font_name == '\0')                    break;               } !             if (font_number >= 0)                {                  /*'                   Initialize font info.                  */O                 (void) strcpy(font_name,resource_info->font_name[font_number]); <                 font_info=XLoadQueryFont(display,font_name);6                 if (font_info == (XFontStruct *) NULL)G                   XNoticeWidget(display,windows,"Unable to load font:",                      font_name);                  else                   { (                     font_id=font_number;1                     XFreeFont(display,font_info);                    }                }              break;           } #           case AnnotateModeColorOp:            {              char(               color_name[MaxTextLength],*               *ColorMenu[MaxNumberPens+1];               int                pen_number;                /*)               Initialize menu selections.              */-             for (i=0; i < MaxNumberPens; i++) 7               ColorMenu[i]=resource_info->pen_color[i]; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */H             pen_number=XMenuWidget(display,windows,AnnotateModeMenu[id],$               ColorMenu,color_name);0             if (pen_number == (MaxNumberPens-1))               {                  static char 3                   color_name[MaxTextLength]="gray";                    /*3                   Select a pen color from a dialog.                  */E                 resource_info->pen_color[MaxNumberPens-1]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }               if (pen_number >= 0)               {                  /*                    Set pen color.                 */"                 pen_id=pen_number;K                 (void) strcpy(color_name,resource_info->pen_color[pen_id]); M                 status=XParseColor(display,windows->image.map_info->colormap, L                   color_name,&windows->image.pixel_info->pen_color[pen_id]);                  if (status == 0)P                   XNoticeWidget(display,windows,"Color is unknown to X server:",                      color_name);E                 XBestPixel(display,windows->image.map_info->colormap, 0                   (XColor *) NULL,(unsigned int)E                   Min(windows->image.visual_info->colormap_size,256), A                   &windows->image.pixel_info->pen_color[pen_id]);                }              break;           } $           case AnnotateModeRotateOp:           {              char%               command[MaxTextLength];                int                entry;               static char                *RotateMenu[]=               {                  "45",                  "90",                  "135",                 "180",                 "225",                 "270",                 "315",                 (char *) NULL,                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */&             RotateMenu[7]="Dialog...";N             entry=XMenuWidget(display,windows,AnnotateModeMenu[id],RotateMenu,               command);              if (entry < 0)               break;             if (entry != 7) .               degrees=atof(RotateMenu[entry]);             else               { .                 (void) strcpy(command,"30.0");K                 XDialogWidget(display,windows,"OK","Enter rotation angle:",                    command); %                 if (*command == '\0')                    break;&                 degrees=atof(command);               }              break;           } "           case AnnotateModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           } %           case AnnotateModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 6         if (event.xbutton.window != windows->image.id)           break;
         /*'           Change to text entering mode. 
         */         x=event.xbutton.x;         y=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       { 
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*0     Set font info and check boundary conditions.   */F   font_info=XLoadQueryFont(display,resource_info->font_name[font_id]);(   if (font_info == (XFontStruct *) NULL)     { ;       XNoticeWidget(display,windows,"Unable to load font:", +         resource_info->font_name[font_id]); )       font_info=windows->image.font_info;      } >   if ((x+font_info->max_bounds.width) >= windows->image.width)7     x=windows->image.width-font_info->max_bounds.width; 1   if (y < (font_info->ascent+font_info->descent)) +     y=font_info->ascent+font_info->descent; =   if ((font_info->max_bounds.width > windows->image.width) || H       ((font_info->ascent+font_info->descent) >= windows->image.height))     return(False);   /*"     Initialize annotate structure.   */@   annotate_info=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));.   if (annotate_info == (XAnnotateInfo *) NULL)     return(False);"   XGetAnnotateInfo(annotate_info);   annotate_info->x=x;    annotate_info->y=y; =   annotate_info->height=font_info->ascent+font_info->descent; !   annotate_info->degrees=degrees; %   annotate_info->font_info=font_info; &   annotate_info->text=(char *) malloc(N     (windows->image.width/Max(font_info->min_bounds.width,1)+2)*sizeof(char));+   if (annotate_info->text == (char *) NULL)      return(False);   /**     Create cursor and set graphic context.   */.   cursor=XCreateFontCursor(display,XC_pencil);2   XDefineCursor(display,windows->image.id,cursor);3   annotate_context=windows->image.annotate_context; 4   XSetFont(display,annotate_context,font_info->fid);*   XSetForeground(display,annotate_context,8     windows->image.pixel_info->pen_color[pen_id].pixel);   /*)     Begin annotating the image with text.    */   windows->command.name="Text";    windows->command.data=0;F   (void) XCommandWidget(display,windows,TextModeMenu,(XEvent *) NULL);   state=DefaultState; D   XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);F   text_event.xexpose.width=(unsigned int) font_info->max_bounds.width;9   text_event.xexpose.height=font_info->max_bounds.ascent+ "     font_info->max_bounds.descent;   p=annotate_info->text;   do   {      /*       Display text cursor.     */     *p='\0';F     XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */0         XSetForeground(display,annotate_context,=           windows->image.pixel_info->foreground_color.pixel); C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event); 0         XSetForeground(display,annotate_context,>           windows->image.pixel_info->pen_color[pen_id].pixel);         if (id < 0)            continue;          switch (id) 	         {            case TextModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);<             XDefineCursor(display,windows->image.id,cursor);             break;           } !           case TextModeDismissOp:            {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:             break;	         }          continue;        }      /*       Erase text cursor.     */     text_event.xexpose.x=x; 8     text_event.xexpose.y=y-font_info->max_bounds.ascent;@     XClearArea(display,windows->image.id,x,text_event.xexpose.y,@       text_event.xexpose.width,text_event.xexpose.height,False);8     XRefreshWindow(display,&windows->image,&text_event);     switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);             break;           } ,         if (event.xbutton.button == Button2)           {              /*(               Request primary selection.             */E             XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, -               windows->image.id,CurrentTime);              break;           }          break;       }        case Expose:       { %         if (event.xexpose.count == 0)            {              XAnnotateInfo                *text_info;                /*#               Refresh Image window.              */D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);$             text_info=annotate_info;7             while (text_info != (XAnnotateInfo *) NULL) 
             { E               XDrawString(display,windows->image.id,annotate_context, :                 text_info->x,text_info->y,text_info->text,)                 strlen(text_info->text)); ,               text_info=text_info->previous;
             } N             XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);           }          break;       }        case KeyPress:       {          int            length;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; N         if ((event.xkey.state & ControlMask) || (event.xkey.state & Mod1Mask))           state|=ModifierState; "         if (state & ModifierState)           switch (key_symbol)            {              case XK_u:             case XK_U:
             { #               key_symbol=XK_Delete;                break;
             }              default:               break;           }          switch (key_symbol) 	         {            case XK_BackSpace:           {              /*"               Erase one character.             */)             if (p == annotate_info->text) D               if (annotate_info->previous == (XAnnotateInfo *) NULL)                 break;               else                 {                    /*;                     Go to end of the previous line of text.                    */8                   annotate_info=annotate_info->previous;(                   p=annotate_info->text;:                   x=annotate_info->x+annotate_info->width;%                   y=annotate_info->y; 0                   if (annotate_info->width != 0)3                     p+=strlen(annotate_info->text);                    break;                 }              p--;)             x-=XTextWidth(font_info,p,1); #             text_event.xexpose.x=x; @             text_event.xexpose.y=y-font_info->max_bounds.ascent;@             XRefreshWindow(display,&windows->image,&text_event);             break;           }            case XK_Delete:            {              /*,               Erase the entire line of text.             */,             while (p != annotate_info->text)
             {                p--;+               x-=XTextWidth(font_info,p,1); %               text_event.xexpose.x=x; B               XRefreshWindow(display,&windows->image,&text_event);
             }              break;           }            case XK_Escape:            case XK_F20:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:           {              /*:               Draw a single character on the Image window.             */&             if (state & ModifierState)               break;!             if (*command == '\0')                break;             *p=(*command);L             XDrawString(display,windows->image.id,annotate_context,x,y,p,1);)             x+=XTextWidth(font_info,p,1);              p++;G             if ((x+font_info->max_bounds.width) < windows->image.width)                break;           }            case XK_Return:            case XK_KP_Enter:            {              /*/               Advance to the next line of text.              */             *p='\0';J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); >             if (annotate_info->next != (XAnnotateInfo *) NULL)               {                  /*.                   Line of text already exists.                 */2                 annotate_info=annotate_info->next;#                 x=annotate_info->x; #                 y=annotate_info->y; &                 p=annotate_info->text;                 break;               } P             annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));>             if (annotate_info->next == (XAnnotateInfo *) NULL)               return(False);2             *annotate_info->next=(*annotate_info);8             annotate_info->next->previous=annotate_info;.             annotate_info=annotate_info->next;F             annotate_info->text=(char *) malloc((windows->image.width/B               Max(font_info->min_bounds.width,1)+2)*sizeof(char));5             if (annotate_info->text == (char *) NULL)                return(False);4             annotate_info->y+=annotate_info->height;9             if (annotate_info->y > windows->image.height) 5               annotate_info->y=annotate_info->height; 7             annotate_info->next=(XAnnotateInfo *) NULL;              x=annotate_info->x;              y=annotate_info->y; "             p=annotate_info->text;             break;           } 	         }          break;       }        case KeyRelease:       { 
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);           state&=(~ModifierState);         break;       }        case SelectionNotify:        {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;
         /*7           Annotate Image window with primary selection. 
         */"         for (i=0; i < length; i++)	         {            if (data[i] != '\n')
             {                /*<                 Draw a single character on the Image window.               */               *p=data[i]; N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);+               x+=XTextWidth(font_info,p,1);                p++;I               if ((x+font_info->max_bounds.width) < windows->image.width)                  continue; 
             }            /*-             Advance to the next line of text.            */           *p='\0';H           annotate_info->width=XTextWidth(font_info,annotate_info->text,)             strlen(annotate_info->text)); <           if (annotate_info->next != (XAnnotateInfo *) NULL)
             {                /*,                 Line of text already exists.               */0               annotate_info=annotate_info->next;!               x=annotate_info->x; !               y=annotate_info->y; $               p=annotate_info->text;               continue; 
             } /           annotate_info->next=(XAnnotateInfo *) *             malloc(sizeof(XAnnotateInfo));<           if (annotate_info->next == (XAnnotateInfo *) NULL)             return(False);0           *annotate_info->next=(*annotate_info);6           annotate_info->next->previous=annotate_info;,           annotate_info=annotate_info->next;D           annotate_info->text=(char *) malloc((windows->image.width/@             Max(font_info->min_bounds.width,1)+2)*sizeof(char));3           if (annotate_info->text == (char *) NULL)              return(False);2           annotate_info->y+=annotate_info->height;7           if (annotate_info->y > windows->image.height) 3             annotate_info->y=annotate_info->height; 5           annotate_info->next=(XAnnotateInfo *) NULL;            x=annotate_info->x;            y=annotate_info->y;             p=annotate_info->text;	         }          XFree((void *) data);          break;       }        default:         break;     } !   } while (!(state & ExitState));    XFreeCursor(display,cursor);   /*2     Annotation is relative to image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    /*     Initialize annotated image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);1   while (annotate_info != (XAnnotateInfo *) NULL)    { "     if (annotate_info->width == 0)       { 
         /*>           No text on this line--  go to the next line of text.
         */.         previous_info=annotate_info->previous;+         free((char *) annotate_info->text); %         free((char *) annotate_info); $         annotate_info=previous_info;         continue;        }      /*6       Determine foreground pixel index for font color.     */.     windows->image.pixel_info->annotate_color=3       windows->image.pixel_info->pen_color[pen_id]; 0     windows->image.pixel_info->annotate_index=0;/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == ?             windows->image.pixel_info->pen_color[pen_id].pixel)            { 8             windows->image.pixel_info->annotate_index=i;             break;           }      /**       Define the annotate geometry string.     */9     x_factor=UpShift(width)/windows->image.ximage->width; '     annotate_info->x+=windows->image.x; :     annotate_info->x=DownShift(annotate_info->x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height; ;     annotate_info->y+=(windows->image.y-font_info->ascent); :     annotate_info->y=DownShift(annotate_info->y*y_factor);9     (void) sprintf(annotate_info->geometry,"%ux%u%+d%+d", >       (unsigned int) DownShift(annotate_info->width*x_factor),?       (unsigned int) DownShift(annotate_info->height*y_factor), -       annotate_info->x+x,annotate_info->y+y);      /*       Annotate image with text.      */J     status=XAnnotateImage(display,windows->image.pixel_info,annotate_info,       False,image);      if (status == 0)       return(False);     /*       Free up memory.      */*     previous_info=annotate_info->previous;'     free((char *) annotate_info->text); !     free((char *) annotate_info);       annotate_info=previous_info;   } *   XSetForeground(display,annotate_context,7     windows->image.pixel_info->foreground_color.pixel); C   XSetFont(display,annotate_context,windows->image.font_info->fid); )   XSetCursorState(display,windows,False);    XFreeFont(display,font_info);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B a c k g r o u n d I m a g e                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XBackgroundImage displays the image in the background of a window. % 1 %  The format of the XBackgroundImage routine is:  % A %    status=XBackgroundImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o status: Function XBackgroundImage return True if the image isJ %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */I static unsigned int XBackgroundImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { = #define BackgroundImageText  "  Backgrounding the image...  "   
   static char &     window_id[MaxTextLength] = "root";     XResourceInfo      background_resources;      unsigned int     status;      /*     Put image in background.   */-   XDialogWidget(display,windows,"Background", H     "Enter window id (id 0x00 selects window with pointer):",window_id);   if (*window_id == '\0')      return(False);M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); 3   XInfoWidget(display,windows,BackgroundImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);(   background_resources=(*resource_info);+   background_resources.window_id=window_id; %   background_resources.backdrop=True; ,   if (window_id[strlen(window_id)-1] == '!')     { *       window_id[strlen(window_id)-1]='\0';*       background_resources.backdrop=False;     } G   status=XDisplayBackgroundImage(display,&background_resources,*image); 
   if (status) C     XClientMessage(display,windows->image.id,windows->im_protocols, -       windows->im_retain_colors,CurrentTime); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False); M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ) %  Function XChopImage chops the X image.  % + %  The format of the XChopImage routine is:  % ; %    status=XChopImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % > %    o status: Function XChopImage return True if the image isF %      cut.  False is returned is there is a memory shortage or if the %      image fails to cut. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */C static unsigned int XChopImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { . #define ChopImageText  "  Chopping image...  " #define ChopModeDirectionOp  0 #define ChopModeHelpOp  1  #define ChopModeDismissOp  2 #define HorizontalChopOp  0  #define VerticalChopOp  1   
   static char      *ChopModeMenu[]=     {        "Direction",
       "Help",        "Dismiss",       (char *) NULL      };     char     text[MaxTextLength];     Image      *chop_image;     int      id,      x,     y;     RectangleInfo      chop_info;     static unsigned int !     direction = HorizontalChopOp;      unsigned int
     distance,      height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;  
   XSegment     segment_info;      /*     Map Command widget.    */   windows->command.name="Chop";    windows->command.data=1;F   (void) XCommandWidget(display,windows,ChopModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,ChopModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { #           case ChopModeDirectionOp:            {              char%               command[MaxTextLength];                static char                *Directions[]=               {                  "horizontal",                  "vertical",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */             direction=O               XMenuWidget(display,windows,ChopModeMenu[id],Directions,command);              break;           }            case ChopModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);             break;           } !           case ChopModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*=           User has committed to start point of chopting line. 
         */(         segment_info.x1=event.xbutton.x;(         segment_info.x2=event.xbutton.x;(         segment_info.y1=event.xbutton.y;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   
         /*&           Respond to a user key press.
         */?         (void) XLookupString((XKeyEvent *) &event.xkey,command, ?           sizeof(command),&key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);        }      } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*B     Draw line as pointer moves until the mouse button is released.   */   chop_info.width=0;   chop_info.height=0;    chop_info.x=0;   chop_info.y=0;
   distance=0; B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      if (distance > 9)        { 
         /*.           Display info and draw chopping line.
         */"         if (!windows->info.mapped)/           XMapWindow(display,windows->info.id); L         (void) sprintf(text," %ux%u%+d%+d",chop_info.width,chop_info.height,#           chop_info.x,chop_info.y); *         XInfoWidget(display,windows,text);1         XHighlightLine(display,windows->image.id, :           windows->image.highlight_context,&segment_info);       }      else       if (windows->info.mapped) G         XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      if (distance > 9) /       XHighlightLine(display,windows->image.id, 8         windows->image.highlight_context,&segment_info);     switch (event.type)      {        case ButtonPress:        { (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;         break;       }        case ButtonRelease:        { 
         /*.           User has committed to chopping line.
         */(         segment_info.x2=event.xbutton.x;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case Expose:         break;       case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;       }        default:         break;     }      /*        Check boundary conditions.     */     if (segment_info.x2 < 0)       segment_info.x2=0;     else9       if (segment_info.x2 > windows->image.ximage->width) 5         segment_info.x2=windows->image.ximage->width;      if (segment_info.y2 < 0)       segment_info.y2=0;     else:       if (segment_info.y2 > windows->image.ximage->height)6         segment_info.y2=windows->image.ximage->height;
     distance= L       ((segment_info.x2-segment_info.x1)*(segment_info.x2-segment_info.x1))+L       ((segment_info.y2-segment_info.y1)*(segment_info.y2-segment_info.y1));     /*        Compute chopping geometry.     */&     if (direction == HorizontalChopOp)       { :         chop_info.width=segment_info.x2-segment_info.x1+1;5         chop_info.x=windows->image.x+segment_info.x1;          chop_info.height=0;          chop_info.y=0;.         if (segment_info.x1 > segment_info.x2)           { >             chop_info.width=segment_info.x1-segment_info.x2+1;9             chop_info.x=windows->image.x+segment_info.x2;            }        }      else       {          chop_info.width=0;;         chop_info.height=segment_info.y2-segment_info.y1+1;          chop_info.x=0;5         chop_info.y=windows->image.y+segment_info.y1; .         if (segment_info.y1 > segment_info.y2)           { ?             chop_info.height=segment_info.y1-segment_info.y2+1; 9             chop_info.y=windows->image.y+segment_info.y2;            }        } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (distance <= 9)     return(True);    /*6     Image chopping is relative to image configuration.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); -   XInfoWidget(display,windows,ChopImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   windows->image.window_changes.width=1     windows->image.ximage->width-chop_info.width; '   windows->image.window_changes.height= 3     windows->image.ximage->height-chop_info.height;    x=0;   y=0;   width=(*image)->columns;   height=(*image)->rows;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    chop_info.x+=x; 2   chop_info.x=DownShift(chop_info.x*scale_factor);:   chop_info.width=DownShift(chop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    chop_info.y+=y; 2   chop_info.y=DownShift(chop_info.y*scale_factor);<   chop_info.height=DownShift(chop_info.height*scale_factor);   /*     Chop image.    */*   chop_image=ChopImage(*image,&chop_info);A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False); #   if (chop_image == (Image *) NULL)      return(False);   DestroyImage(*image);    *image=chop_image;   /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r E d i t I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XColorEditImage allows the user to interactively change K %  the color of one pixel for a DirectColor image or one colormap entry for G %  a PseudoClass image.  The floodfill algorithm is strongly based on a : %  similiar algorithm in "Graphics Gems" by Paul Heckbert. % 0 %  The format of the XColorEditImage routine is: % 9 %    XColorEditImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */  + static void ColorFloodfill(image,x,y,color)  Image 	   *image;    int    x,   y;   XColor   color; {    int 
     delta,	     skip, 
     start,     x1,      x2;      register RunlengthPacket     *pixel;      register XSegment      *p;      RunlengthPacket      target;   
   XSegment     *segment_stack;      /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))      return; +   target=image->pixels[y*image->columns+x]; .   if ((target.red == XDownScale(color.red)) &&2       (target.green == XDownScale(color.green)) &&.       (target.blue == XDownScale(color.blue)))     return;    /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)      { D       Warning("Unable to recolor image","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (p > segment_stack)    {      /*       Pop segment off stack.     */     p--;
     x1=p->x1; 
     x2=p->x2;      delta=p->y2;     y=p->y1+delta;     /*!       Recolor neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     { /       pixel=image->pixels+(y*image->columns+x); '       if ((pixel->red != target.red) || +           (pixel->green != target.green) || '           (pixel->blue != target.blue))          break;'       pixel->red=XDownScale(color.red); +       pixel->green=XDownScale(color.green); )       pixel->blue=XDownScale(color.blue);      }      skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) $           Push(y,start,x1-1,-delta);         x=x1+1;        }      do     {        if (!skip)	         { *           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x); -             if ((pixel->red != target.red) || 1                 (pixel->green != target.green) || -                 (pixel->blue != target.blue))                break;-             pixel->red=XDownScale(color.red); 1             pixel->green=XDownScale(color.green); /             pixel->blue=XDownScale(color.blue);            } "           Push(y,start,x-1,delta);           if (x > (x2+1)) $             Push(y,x2+1,x-1,-delta);	         }        skip=False;        for (x++; x <= x2 ; x++)       { 1         pixel=image->pixels+(y*image->columns+x); )         if ((pixel->red == target.red) && -             (pixel->green == target.green) && )             (pixel->blue == target.blue))            break;       }        start=x;     } while (x <= x2);   }    free((char *) segment_stack);  }   H static unsigned int XColorEditImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; {  #define ColorEditColorOp  0  #define ColorEditMethodOp  1 #define ColorEditUndoOp  2 #define ColorEditHelpOp  3 #define ColorEditDismissOp  4   
   static char      *ColorEditMenu[]=      {        "Pixel Color",       "Method", 
       "Undo", 
       "Help",        "Dismiss",       (char *) NULL      };     char     text[MaxTextLength];     Cursor     cursor;      int      id,      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *p;      static unsigned int      method = PointMethodOp,      pen_id = 0;      unsigned int     height,      status, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XColor
     color;     XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Color Edit";    windows->command.data=2;G   (void) XCommandWidget(display,windows,ColorEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,ColorEditMenu,&event);         if (id < 0)            continue;          switch (id) 	         {             case ColorEditColorOp:           {              char(               color_name[MaxTextLength],*               *ColorMenu[MaxNumberPens+1];               int                pen_number;                /*)               Initialize menu selections.              */-             for (i=0; i < MaxNumberPens; i++) 7               ColorMenu[i]=resource_info->pen_color[i]; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */O             pen_number=XMenuWidget(display,windows,ColorEditMenu[id],ColorMenu,                color_name);0             if (pen_number == (MaxNumberPens-1))               {                  static char 3                   color_name[MaxTextLength]="gray";                    /*3                   Select a pen color from a dialog.                  */E                 resource_info->pen_color[MaxNumberPens-1]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }               if (pen_number >= 0)               {                  /*                    Set pen color.                 */"                 pen_id=pen_number;K                 (void) strcpy(color_name,resource_info->pen_color[pen_id]); M                 status=XParseColor(display,windows->image.map_info->colormap, L                   color_name,&windows->image.pixel_info->pen_color[pen_id]);                  if (status == 0)P                   XNoticeWidget(display,windows,"Color is unknown to X server:",                      color_name);E                 XBestPixel(display,windows->image.map_info->colormap, 0                   (XColor *) NULL,(unsigned int)E                   Min(windows->image.visual_info->colormap_size,256), A                   &windows->image.pixel_info->pen_color[pen_id]);                } <             XDefineCursor(display,windows->image.id,cursor);             break;           } !           case ColorEditMethodOp:            {              char%               command[MaxTextLength];                static char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */             method= P               XMenuWidget(display,windows,ColorEditMenu[id],MethodMenu,command);<             XDefineCursor(display,windows->image.id,cursor);             break;           }            case ColorEditUndoOp:            { B             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);              break;           }            case ColorEditHelpOp:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           } "           case ColorEditDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           } 	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Exit loop.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        { 
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image); *         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     }      x_offset=x;      y_offset=y; )     if (state & UpdateConfigurationState)        {          int            x,           y;  
         /*8           Pixel edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True);          x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height); =         x_factor=UpShift(width)/windows->image.ximage->width; C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x; ?         y_factor=UpShift(height)/windows->image.ximage->height; C         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y; ;         color=windows->image.pixel_info->pen_color[pen_id]; -         if ((x_offset < 0) || (y_offset < 0))            continue; L         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue; G         XPutPixel(windows->image.ximage,x_offset,y_offset,color.pixel);          switch (method) 	         {            case PointMethodOp:            default:           {              /*=               Update color information using point algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset); )             p->red=XDownScale(color.red); -             p->green=XDownScale(color.green); +             p->blue=XDownScale(color.blue);              break;           }            case ReplaceMethodOp:            {              RunlengthPacket                target;                /*?               Update color information using replace algorithm.              */             x=0;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             {                x+=(p->length+1); =               if (x >= (y_offset*(*image)->columns+x_offset))                  break;               p++;
             } '             target=(*image)->pixels[i]; /             if ((*image)->class == DirectClass)                { #                 p=(*image)->pixels; 5                 for (i=0; i < (*image)->packets; i++)                  { /                   if ((p->red == target.red) && 3                       (p->green == target.green) && /                       (p->blue == target.blue))                      { 3                       p->red=XDownScale(color.red); 7                       p->green=XDownScale(color.green); 5                       p->blue=XDownScale(color.blue);                      }                    p++;                 }                }              else               { '                 register unsigned short                    index;  #                 index=target.index; D                 (*image)->colormap[index].red=XDownScale(color.red);H                 (*image)->colormap[index].green=XDownScale(color.green);F                 (*image)->colormap[index].blue=XDownScale(color.blue);"                 SyncImage(*image);               } /             state&=(~UpdateConfigurationState);              break;           } !           case FloodfillMethodOp:            {              /*A               Update color information using floodfill algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;;             ColorFloodfill(*image,x_offset,y_offset,color); /             state&=(~UpdateConfigurationState);              break;           }            case ResetMethodOp:            {              /*=               Update color information using reset algorithm.              */(             (*image)->class=DirectClass;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             { +               p->red=XDownScale(color.red); /               p->green=XDownScale(color.green); -               p->blue=XDownScale(color.blue);                p++;
             } /             state&=(~UpdateConfigurationState);              break;           } 	         }        } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m p o s i t e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XCompositeImage requests an image name from the user, reads M %  the image and composites it with the X window image at a location the user  %  chooses with the pointer. % 0 %  The format of the XCompositeImage routine is: % @ %    status=XCompositeImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % D %    o status: Function XCompositeImage returns True if the image isM %      composited.  False is returned is there is a memory shortage or if the $ %      image fails to be composited. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */H static unsigned int XCompositeImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { # #define CompositeModeOperatorsOp  0  #define CompositeModeBlendOp  1  #define CompositeModeHelpOp  2! #define CompositeModeDismissOp  3   
   static char      *CompositeModeMenu[]=      {        "Operators",       "Blend",
       "Help",        "Dismiss",       (char *) NULL      },#     filename[MaxTextLength] = "\0";      char     text[MaxTextLength];     Cursor     cursor;      double
     blend;     Image      *composite_image;      int      id,      x,     y;     RectangleInfo      highlight_info,      composite_info;      static unsigned int "     operator = ReplaceCompositeOp;     unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*&     Request image file name from user.   */;   XFileBrowserWidget(display,windows,"Composite",filename);    if (*filename == '\0')     return(True);    /*     Read image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);7   composite_image=ReadImage(resource_info->image_info); )   XSetCursorState(display,windows,False); (   if (composite_image == (Image *) NULL)     { F       XNoticeWidget(display,windows,"Unable to read image:",filename);       return(False);     }    /*     Map Command widget.    */$   windows->command.name="Composite";   windows->command.data=1;K   (void) XCommandWidget(display,windows,CompositeModeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);&   composite_info.x=windows->image.x+x;&   composite_info.y=windows->image.y+y;   composite_info.width=0;    composite_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); 0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   blend=0.0;   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */J         (void) sprintf(text," %+d%+d ",composite_info.x,composite_info.y);*         XInfoWidget(display,windows,text);       } "     highlight_info=composite_info;7     highlight_info.x=composite_info.x-windows->image.x; 7     highlight_info.y=composite_info.y-windows->image.y; P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &highlight_info);      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &highlight_info); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */D         id=XCommandWidget(display,windows,CompositeModeMenu,&event);         if (id < 0)            continue;          switch (id) 	         { (           case CompositeModeOperatorsOp:           {              char%               command[MaxTextLength];                static char                *OperatorMenu[]=               {                  "over",                  "in",                  "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",                  "difference",                  "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */G             operator=XMenuWidget(display,windows,CompositeModeMenu[id], &               OperatorMenu,command)+1;             break;           } $           case CompositeModeBlendOp:           {              static char -               factor[MaxTextLength] = "20.0";                /*3               Blend the two images a given percent.              */J             XSetFunction(display,windows->image.highlight_context,GXcopy);2             XDialogWidget(display,windows,"Blend",>               "Enter the blend factor (0.0 - 99.9%):",factor);L             XSetFunction(display,windows->image.highlight_context,GXinvert);              if (*factor == '\0')               break;             blend=atof(factor);              break;           } #           case CompositeModeHelpOp:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           } &           case CompositeModeDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Change cursor.
         */6         composite_info.width=composite_image->columns;4         composite_info.height=composite_image->rows;8         XDefineCursor(display,windows->image.id,cursor);:         composite_info.x=windows->image.x+event.xbutton.x;:         composite_info.y=windows->image.y+event.xbutton.y;         break;       }        case ButtonRelease:        { !         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); H         if ((composite_info.width != 0) && (composite_info.height != 0))           {              /*D               User has selected the location of the composite image.             */>             composite_info.x=windows->image.x+event.xbutton.x;>             composite_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;            int            length;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */*             DestroyImage(composite_image);             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); ,         composite_info.x=windows->image.x+x;,         composite_info.y=windows->image.y+y;         break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);    /*9     Image compositing is relative to image configuration.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    composite_info.x+=x;<   composite_info.x=DownShift(composite_info.x*scale_factor);D   composite_info.width=DownShift(composite_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    composite_info.y+=y;<   composite_info.y=DownShift(composite_info.y*scale_factor);F   composite_info.height=DownShift(composite_info.height*scale_factor);;   if ((composite_info.width != composite_image->columns) || 7       (composite_info.height != composite_image->rows))      {        Image          *scaled_image;         /*         Scale composite image.       */       scaled_image= O         ScaleImage(composite_image,composite_info.width,composite_info.height); $       DestroyImage(composite_image);)       if (scaled_image == (Image *) NULL) 	         { 1           XSetCursorState(display,windows,False);            return(False);	         } #       composite_image=scaled_image;      }    if (blend != 0.0)      {        register int
         i;         register RunlengthPacket         *p;          unsigned short         index;         /*#         Create mattes for blending.        */0       index=((int) DownScale(MaxRGB)*blend)/100;)       composite_image->class=DirectClass; "       composite_image->matte=True;        p=composite_image->pixels;2       for (i=0; i < composite_image->packets; i++)       {          p->index=index;          p++;       } H       index=(int) DownScale(MaxRGB)-((int) DownScale(MaxRGB)*blend)/100;       image->class=DirectClass;        image->matte=True;       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          p->index=index;          p++;       }         operator=BlendCompositeOp;     }    /*(     Composite image with X Image window.   */A   CompositeImage(image,operator,composite_image,composite_info.x,      composite_info.y);    DestroyImage(composite_image);)   XSetCursorState(display,windows,False);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e C o l o r m a p                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XConfigureImageColormap creates a new X colormap.  % 8 %  The format of the XConfigureImageColormap routine is: % A %    XConfigureImageColormap(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H static void XConfigureImageColormap(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { < #define ConfigureColormapText  "  Configuring colormap...  "  
   Colormap
     colormap;      /*     Make standard colormap.    */5   XInfoWidget(display,windows,ConfigureColormapText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);5   if (image->packets == (image->columns*image->rows))      CompressImage(image); I   XMakeStandardColormap(display,windows->image.visual_info,resource_info, =     image,windows->image.map_info,windows->image.pixel_info); -   colormap=windows->image.map_info->colormap; 9   XSetWindowColormap(display,windows->image.id,colormap); ;   XSetWindowColormap(display,windows->command.id,colormap); :   XSetWindowColormap(display,windows->widget.id,colormap);   if (windows->magnify.mapped)=     XSetWindowColormap(display,windows->magnify.id,colormap);    if (windows->pan.mapped)9     XSetWindowColormap(display,windows->pan.id,colormap); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False); A   XClientMessage(display,windows->image.id,windows->im_protocols, -     windows->im_update_colormap,CurrentTime);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XConfigureImage creates a new X image.  It also notifies theL %  window manager of the new image size and configures the transient widows. % 0 %  The format of the XConfigureImage routine is: % @ %    status=XConfigureImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o status: Function XConfigureImage returns True if the window is J %      resized.  False is returned is there is a memory shortage or if the %      window fails to resize. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H static unsigned int XConfigureImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { ; #define ConfigureImageText  "  Configuring image...       "      unsigned int     height, 	     mask,      status, 
     width,
     x_factor, 
     y_factor;      XSizeHints     *size_hints;     XWindowChanges     window_changes;      /**     Dismiss if window dimensions are zero.   */,   width=windows->image.window_changes.width;.   height=windows->image.window_changes.height;   if (resource_info->debug) <     (void) fprintf(stderr,"Configure Image: %dx%d=>%ux%u\n",O       windows->image.ximage->width,windows->image.ximage->height,width,height);    if ((width*height) == 0)     return(True);    /*0     Resize image to fit Image window dimensions.   */2   XInfoWidget(display,windows,ConfigureImageText);(   XSetCursorState(display,windows,True);   XFlush(display);7   x_factor=UpShift(width)/windows->image.ximage->width; 9   y_factor=UpShift(height)/windows->image.ximage->height; N   status=XMakeImage(display,resource_info,&windows->image,image,width,height);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);   if (status == False)A     XNoticeWidget(display,windows,"Unable to configure X image:",        windows->image.name);    /*3     Notify window manager of the new configuration.    */;   if (width > XDisplayWidth(display,windows->image.screen)) 7     width=XDisplayWidth(display,windows->image.screen);    window_changes.width=width; =   if (height > XDisplayHeight(display,windows->image.screen)) 9     height=XDisplayHeight(display,windows->image.screen);    window_changes.height=height;    mask=CWWidth | CWHeight;   if (resource_info->backdrop)     {        mask|=CWX | CWY;       window_changes.x= I         (XDisplayWidth(display,windows->image.screen) >> 1)-(width >> 1);        window_changes.y= K         (XDisplayHeight(display,windows->image.screen) >> 1)-(height >> 1);      } L   XReconfigureWMWindow(display,windows->image.id,windows->image.screen,mask,     &window_changes);    if (image->matte) ,     XClearWindow(display,windows->image.id);;   if ((x_factor == UpShift(1)) || (y_factor == UpShift(1))) <     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*(     Update Magnify window configuration.   */<   windows->magnify.x=DownShift(x_factor*windows->magnify.x);<   windows->magnify.y=DownShift(y_factor*windows->magnify.y);   if (windows->magnify.mapped)'     XMakeMagnifyImage(display,windows);    /*$     Update pan window configuration.   */8   windows->image.x=DownShift(x_factor*windows->image.x);8   windows->image.y=DownShift(y_factor*windows->image.y);:   windows->pan.crop_geometry=windows->image.crop_geometry;-   XBestIconSize(display,&windows->pan,image); -   while ((windows->pan.width < MinPanSize) && ,          (windows->pan.height < MinPanSize))   {      windows->pan.width<<=1;      windows->pan.height<<=1;   } 4   windows->pan.geometry=resource_info->pan_geometry;-   if (windows->pan.geometry != (char *) NULL) A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,        &windows->pan.height);*   window_changes.width=windows->pan.width;,   window_changes.height=windows->pan.height;   size_hints=XAllocSizeHints(); (   if (size_hints != (XSizeHints *) NULL)     {        /*         Set new size hints.        */4       size_hints->flags=PSize | PMinSize | PMaxSize;-       size_hints->width=window_changes.width; /       size_hints->height=window_changes.height; .       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;:       XSetNormalHints(display,windows->pan.id,size_hints);!       XFree((void *) size_hints);      } L   XReconfigureWMWindow(display,windows->pan.id,windows->pan.screen,CWWidth |     CWHeight,&window_changes);   if (windows->pan.mapped)7     XMakePanImage(display,resource_info,windows,image);    /*%     Update icon window configuration.    */;   windows->icon.crop_geometry=windows->image.crop_geometry; .   XBestIconSize(display,&windows->icon,image);+   window_changes.width=windows->icon.width; -   window_changes.height=windows->icon.height; E   XReconfigureWMWindow(display,windows->icon.id,windows->icon.screen, (     CWWidth | CWHeight,&window_changes);A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o p y I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCopyImage copies the image or a region of the image.  The imageB %  can subsequently be composited onto the image with XPasteImage. % + %  The format of the XCopyImage routine is:  % ; %    status=XCopyImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % ? %    o status: Function XCopyImage returns True if the image is J %      copyped.  False is returned is there is a memory shortage or if the! %      image fails to be copyped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */C static unsigned int XCopyImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { - #define CopyImageText  "  Copying image...  "  #define CopyModeHelpOp  0  #define CopyModeDismissOp  1 #define RectifyModeCopyOp  0 #define RectifyModeHelpOp  1 #define RectifyModeDismissOp  2   
   static char      *CopyModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      },     *RectifyModeMenu[]=      { 
       "Copy", 
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int      id,      x,     y;     KeySym     key_symbol;      RectangleInfo      copy_info,     highlight_info;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget.    */   windows->command.name="Copy";    windows->command.data=0;F   (void) XCommandWidget(display,windows,CopyModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);!   copy_info.x=windows->image.x+x; !   copy_info.y=windows->image.y+y;    copy_info.width=0;   copy_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */@         (void) sprintf(text," %+d%+d ",copy_info.x,copy_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,CopyModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         {            case CopyModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,;               "Help Viewer - Image Copying",ImageCopyHelp);              break;           } !           case CopyModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {              /*B               Note first corner of copyping rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);9             copy_info.x=windows->image.x+event.xbutton.x; 9             copy_info.y=windows->image.y+event.xbutton.y;              state|=ExitState;              break;           }          break;       }        case Expose:         break;       case KeyPress:       { 
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,;               "Help Viewer - Image Copying",ImageCopyHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         copy_info.x=windows->image.x+x; '         copy_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {        /**         User want to exit without copying.       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=copy_info.x;     y=copy_info.y;     copy_info.width=0;     copy_info.height=0;      state=DefaultState; +     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {        highlight_info=copy_info; 4       highlight_info.x=copy_info.x-windows->image.x;4       highlight_info.y=copy_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*5             Display info and draw copyping rectangle.            */N           (void) sprintf(text," %ux%u%+d%+d",copy_info.width,copy_info.height,%             copy_info.x,copy_info.y); ,           XInfoWidget(display,windows,text);5           XHighlightRegion(display,windows->image.id, >             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))3         XHighlightRegion(display,windows->image.id, <           windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */A           id=XCommandWidget(display,windows,CopyModeMenu,&event);            if (id < 0)              continue;            switch (id)            {               case CopyModeHelpOp:
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,=                 "Help Viewer - Image Copying",ImageCopyHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             } #             case CopyModeDismissOp: 
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;                state|=ExitState;                break;
             }              default:               break;           }            continue; 	         }        switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 7           copy_info.x=windows->image.x+event.xbutton.x; 7           copy_info.y=windows->image.y+event.xbutton.y;            break;	         }          case ButtonRelease: 	         {            /*5             User has committed to copyping rectangle.            */7           copy_info.x=windows->image.x+event.xbutton.x; 7           copy_info.y=windows->image.y+event.xbutton.y; 1           XSetCursorState(display,windows,False); *           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);            state|=ExitState;            break;	         }          case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.            */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 7           copy_info.x=windows->image.x+event.xmotion.x; 7           copy_info.y=windows->image.y+event.xmotion.y; 	         }          default:           break;       } L       if (((copy_info.x != x) && (copy_info.y != y)) || (state & ExitState))	         {            /*&             Check boundary conditions.           */           if (copy_info.x < 0)             copy_info.x=0;           else;             if (copy_info.x > windows->image.ximage->width) 7               copy_info.x=windows->image.ximage->width;            if (copy_info.x < x);             copy_info.width=(unsigned int) (x-copy_info.x);            else
             { =               copy_info.width=(unsigned int) (copy_info.x-x);                copy_info.x=x;
             }            if (copy_info.y < 0)             copy_info.y=0;           else<             if (copy_info.y > windows->image.ximage->height)8               copy_info.y=windows->image.ximage->height;           if (copy_info.y < y)<             copy_info.height=(unsigned int) (y-copy_info.y);           else
             { >               copy_info.height=(unsigned int) (copy_info.y-y);               copy_info.y=y;
             } 	         } #     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*F       Wait for user to grab a corner of the rectangle or press return.     */     state&=(~ExitState);     do     {        if (windows->info.mapped) 	         {            /*%             Display pointer position.            */B           (void) sprintf(text," %+d%+d ",copy_info.x,copy_info.y);,           XInfoWidget(display,windows,text);	         }        highlight_info=copy_info; 4       highlight_info.x=copy_info.x-windows->image.x;4       highlight_info.y=copy_info.y-windows->image.y;F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;            state|=ExitState;            break;	         } 1       XHighlightRegion(display,windows->image.id, :         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 1       XHighlightRegion(display,windows->image.id, :         windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);           if (id < 0)              continue;            switch (id)            { #             case RectifyModeCopyOp: 
             {                state|=ExitState;                break;
             } #             case RectifyModeHelpOp: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,=                 "Help Viewer - Image Copying",ImageCopyHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             } &             case RectifyModeDismissOp:
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;                state|=ExitState;                break;
             }              default:               break;           }            continue; 	         }        switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; M           if ((x < (copy_info.x+RoiDelta)) && (x > (copy_info.x-RoiDelta)) && K               (y < (copy_info.y+RoiDelta)) && (y > (copy_info.y-RoiDelta))) 
             { 6               copy_info.x=copy_info.x+copy_info.width;7               copy_info.y=copy_info.y+copy_info.height; .               state|=UpdateConfigurationState;               break;
             } M           if ((x < (copy_info.x+RoiDelta)) && (x > (copy_info.x-RoiDelta)) && >               (y < (copy_info.y+copy_info.height+RoiDelta)) &&<               (y > (copy_info.y+copy_info.height-RoiDelta)))
             { 6               copy_info.x=copy_info.x+copy_info.width;.               state|=UpdateConfigurationState;               break;
             } =           if ((x < (copy_info.x+copy_info.width+RoiDelta)) && =               (x > (copy_info.x+copy_info.width-RoiDelta)) && K               (y < (copy_info.y+RoiDelta)) && (y > (copy_info.y-RoiDelta))) 
             { 7               copy_info.y=copy_info.y+copy_info.height; .               state|=UpdateConfigurationState;               break;
             } =           if ((x < (copy_info.x+copy_info.width+RoiDelta)) && =               (x > (copy_info.x+copy_info.width-RoiDelta)) && >               (y < (copy_info.y+copy_info.height+RoiDelta)) &&<               (y > (copy_info.y+copy_info.height-RoiDelta)))
             { .               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease:            break;         case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                { 1                 event.xexpose.x=highlight_info.x; 1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width; ;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);                } 7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         {            /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return: 
             {                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,=                 "Help Viewer - Image Copying",ImageCopyHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);                break;
             }            }            break;	         }          case KeyRelease:           break;         case MotionNotify:	         {            /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));            x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped) 
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState)); !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);    if (state & EscapeState)     return(True);    /*0     Copy image before applying image transforms.   */   windows->info.mapped=False; -   XInfoWidget(display,windows,CopyImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    copy_info.x+=x; 2   copy_info.x=DownShift(copy_info.x*scale_factor);:   copy_info.width=DownShift(copy_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    copy_info.y+=y; 2   copy_info.y=DownShift(copy_info.y*scale_factor);<   copy_info.height=DownShift(copy_info.height*scale_factor);#   if (copy_image != (Image *) NULL)      DestroyImage(copy_image); )   copy_image=CropImage(image,&copy_info); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False); #   if (copy_image == (Image *) NULL)      return(False);   /*     Update image.    */>   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C r o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Function XCropImage crops the Image window. % + %  The format of the XCropImage routine is:  % ; %    status=XCropImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % ? %    o status: Function XCropImage returns True if the image is J %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */C static unsigned int XCropImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {  #define CropModeHelpOp  0  #define CropModeDismissOp  1 #define RectifyModeCropOp  0 #define RectifyModeHelpOp  1 #define RectifyModeDismissOp  2   
   static char      *CropModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      },     *RectifyModeMenu[]=      { 
       "Crop", 
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int      id,      x,     y;     KeySym     key_symbol;      RectangleInfo      crop_info,     highlight_info;      unsigned long 
     state;     XEvent
     event;     /*     Map Command widget.    */   windows->command.name="Crop";    windows->command.data=0;F   (void) XCommandWidget(display,windows,CropModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);!   crop_info.x=windows->image.x+x; !   crop_info.y=windows->image.y+y;    crop_info.width=0;   crop_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */@         (void) sprintf(text," %+d%+d ",crop_info.x,crop_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,CropModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         {            case CropModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Cropping",ImageCropHelp);             break;           } !           case CropModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {              /*B               Note first corner of cropping rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);9             crop_info.x=windows->image.x+event.xbutton.x; 9             crop_info.y=windows->image.y+event.xbutton.y;              state|=ExitState;              break;           }          break;       }        case Expose:         break;       case KeyPress:       { 
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Cropping",ImageCropHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         crop_info.x=windows->image.x+x; '         crop_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {        /*+         User want to exit without cropping.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=crop_info.x;     y=crop_info.y;     crop_info.width=0;     crop_info.height=0;      state=DefaultState; +     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*5             Display info and draw cropping rectangle.            */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id); N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);5           XHighlightRegion(display,windows->image.id, >             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);%       /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))3         XHighlightRegion(display,windows->image.id, <           windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */A           id=XCommandWidget(display,windows,CropModeMenu,&event);            if (id < 0)              continue;            switch (id)P           {A              case CropModeHelpOp:
             {DL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Cropping",ImageCropHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             } #             case CropModeDismissOp: 
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;                state|=ExitState;                break;
             }              default:               break;           }            continue; 	         }        switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 7           crop_info.x=windows->image.x+event.xbutton.x;e7           crop_info.y=windows->image.y+event.xbutton.y;            break;	         }          case ButtonRelease: 	         {            /*5             User has committed to cropping rectangle.e           */7           crop_info.x=windows->image.x+event.xbutton.x;o7           crop_info.y=windows->image.y+event.xbutton.y;t1           XSetCursorState(display,windows,False);t           state|=ExitState;h;           if (strcmp(windows->command.name,"Rectify") == 0)o             break;*           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);            break;	         }          case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.t           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 7           crop_info.x=windows->image.x+event.xmotion.x; 7           crop_info.y=windows->image.y+event.xmotion.y;t	         }          default:           break;       }aL       if (((crop_info.x != x) && (crop_info.y != y)) || (state & ExitState))	         {            /*&             Check boundary conditions.           */           if (crop_info.x < 0)             crop_info.x=0;           else;             if (crop_info.x > windows->image.ximage->width) 7               crop_info.x=windows->image.ximage->width;f           if (crop_info.x < x);             crop_info.width=(unsigned int) (x-crop_info.x);t           else
             {s=               crop_info.width=(unsigned int) (crop_info.x-x);                crop_info.x=x;
             }%           if (crop_info.y < 0)             crop_info.y=0;           else<             if (crop_info.y > windows->image.ximage->height)8               crop_info.y=windows->image.ximage->height;           if (crop_info.y < y)<             crop_info.height=(unsigned int) (y-crop_info.y);           else
             { >               crop_info.height=(unsigned int) (crop_info.y-y);               crop_info.y=y;
             }a	         }n#     } while (!(state & ExitState));n+     XSelectInput(display,windows->image.id,r,       windows->image.attributes.event_mask);     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;p     do     {c       if (windows->info.mapped)-	         {e           /*%             Display pointer position.d           */N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y);o,           XInfoWidget(display,windows,text);	         }o       highlight_info=crop_info;U4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {r           state|=EscapeState;r           state|=ExitState;t           break;	         }o1       XHighlightRegion(display,windows->image.id,l:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 3       if (event.xany.window == windows->command.id) 	         {p           /*5             Select a command from the Command widget.n           */H           XSetFunction(display,windows->image.highlight_context,GXcopy);D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);J           XSetFunction(display,windows->image.highlight_context,GXinvert);5           XHighlightRegion(display,windows->image.id,h>             windows->image.highlight_context,&highlight_info);           if (id >= 0)             switch (id)r
             {o%               case RectifyModeCropOp:l               {e!                 state|=ExitState;c                 break;               }a%               case RectifyModeHelpOp:                {gN                 XSetFunction(display,windows->image.highlight_context,GXcopy);D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               }w(               case RectifyModeDismissOp:               {o                 /*#                   Prematurely exit.                  */#                 state|=EscapeState; !                 state|=ExitState;h                 break;               }                default:                 break;
             }l           continue;n	         }t1       XHighlightRegion(display,windows->image.id,g:         windows->image.highlight_context,&highlight_info);       switch (event.type)s       {          case ButtonPress:s	         {i6           if (event.xbutton.window == windows->pan.id)
             {l0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }r8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x;g-           y=windows->image.y+event.xbutton.y;eM           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) &&oK               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             {e6               crop_info.x=crop_info.x+crop_info.width;7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) &&->               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             {w6               crop_info.x=crop_info.x+crop_info.width;.               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) &&m=               (x > (crop_info.x+crop_info.width-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta)))h
             { 7               crop_info.y=crop_info.y+crop_info.height;e.               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) &&e>               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             {c.               state|=UpdateConfigurationState;               break;
             }i	         }          case ButtonRelease:g           break;         case Expose:	         {u8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                {p1                 event.xexpose.x=highlight_info.x;r1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width;o;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);                }a7           if (event.xexpose.window == windows->info.id)h)             if (event.xexpose.count == 0)g0               XInfoWidget(display,windows,text);           break;	         }a         case KeyPress:	         {h           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command,fA             sizeof(command),&key_symbol,(XComposeStatus *) NULL);t           switch (key_symbol)@           {h             case XK_Escape:f             case XK_F20:!               state|=EscapeState;o             case XK_Return: 
             {a               state|=ExitState;o               break;
             }a             case XK_F1:e             case XK_Help:e
             {pL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Cropping",ImageCropHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }a             default:
             {r               XBell(display,0);b               break;
             }h           }            break;	         }a         case KeyRelease:           break;         case MotionNotify:	         {            /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));e           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)r
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen);d
             }e           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height)))d3               XMapWindow(display,windows->info.id);t           break;	         }r         default:           break;       } +       if (state & UpdateConfigurationState)h	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         }s#     } while (!(state & ExitState));i!   } while (!(state & ExitState));v@   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);h)   XSetCursorState(display,windows,False);i   if (state & EscapeState)     return(True);i:   if ((crop_info.width != windows->image.ximage->width) ||:       (crop_info.height != windows->image.ximage->height))     {        /*B         Reconfigure Image window as defined by cropping rectangle.       */9       XSetCropGeometry(display,windows,&crop_info,image); :       windows->image.window_changes.width=crop_info.width;<       windows->image.window_changes.height=crop_info.height;B       (void) XConfigureImage(display,resource_info,windows,image);     }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %                                                                             % O %   X C u t I m a g e                                                         %rO %                                                                             % O %                                                                             %vO %                                                                             %cO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %t3 %  Function XCutImage cuts a region from the image.  %i* %  The format of the XCutImage routine is: % : %    status=XCutImage(display,resource_info,windows,image) %o+ %  A description of each parameter follows:  %p> %    o status: Function XCutImage returns True if the image isI %      cutped.  False is returned is there is a memory shortage or if thew  %      image fails to be cutped. %oD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %U< %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned fromt %      ReadImage.r %d %  */B static unsigned int XCutImage(display,resource_info,windows,image) Displaye   *display;e  
 XResourceInfo    *resource_info;    XWindows   *windows;i   Image 	   *image;  {m, #define CutImageText  "  Cutting image...  " #define CutModeHelpOp  0 #define CutModeDismissOp  1i #define RectifyModeCutOp  0p #define RectifyModeHelpOp  1 #define RectifyModeDismissOp  2   
   static charl     *CutModeMenu[]=i     { 
       "Help",        "Dismiss",       (char *) NULL      },     *RectifyModeMenu[]=      {a       "Cut",
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],a     text[MaxTextLength];     Cursor     cursor;i     inth     id,l     x,     y;     KeySym     key_symbol;i     RectangleInfot
     cut_info,      highlight_info;y     register RunlengthPacket     *p;o     unsigned int     height, 
     width;     unsigned long      scale_factor,o
     state;     XEvent
     event;     /*     Map Command widget.u   */   windows->command.name="Cut";   windows->command.data=0;E   (void) XCommandWidget(display,windows,CutModeMenu,(XEvent *) NULL);l*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);e   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);    cut_info.x=windows->image.x+x;    cut_info.y=windows->image.y+y;   cut_info.width=0;    cut_info.height=0;-   cursor=XCreateFontCursor(display,XC_fleur);lO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |s     PointerMotionMask);    state=DefaultState;o   do   {l     if (windows->info.mapped)        {l
         /*#           Display pointer position.o
         */>         (void) sprintf(text," %+d%+d ",cut_info.x,cut_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);c1     if (event.xany.window == windows->command.id)p       { 
         /*3           Select a command from the Command widget.u
         */>         id=XCommandWidget(display,windows,CutModeMenu,&event);         if (id < 0)m           continue;n         switch (id) 	         {p           case CutModeHelpOp:g           {-@             XTextViewWidget(display,resource_info,windows,False,:               "Help Viewer - Image Cutping",ImageCutHelp);             break;           }             case CutModeDismissOp:           {a             /*               Prematurely exit.a             */             state|=EscapeState;e             state|=ExitState;a             break;           }i           default:             break;	         }w         continue;        }b     switch (event.type),     {        case ButtonPress:        {a4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }i,         if (event.xbutton.button == Button1)           {!             /*=               Note first corner of cut rectangle-- exit loop.              */<             XDefineCursor(display,windows->image.id,cursor);8             cut_info.x=windows->image.x+event.xbutton.x;8             cut_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;,             break;           }l         break;       }(       case Expose:         break;       case KeyPress:       {)
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);)         switch (key_symbol)t	         {r           case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.t             */             state|=EscapeState;              state|=ExitState;d             break;           }f           case XK_F1:i           case XK_Help:t           {u@             XTextViewWidget(display,resource_info,windows,False,:               "Help Viewer - Image Cutping",ImageCutHelp);             break;           }            default:           {v             XBell(display,0);f             break;           } 	         }%         break;       }%       case MotionNotify:       {%
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))a1             XMapWindow(display,windows->info.id);_&         cut_info.x=windows->image.x+x;&         cut_info.y=windows->image.y+y;         break;       }r       default:         break;     } !   } while (!(state & ExitState));iO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);o   if (state & EscapeState)     {o       /*&         User want to exit without cut.       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen);I"       XFreeCursor(display,cursor);       return(True);/     }cB   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=cut_info.x;n     y=cut_info.y;      cut_info.width=0;o     cut_info.height=0;     state=DefaultState;n+     XSelectInput(display,windows->image.id,e@       windows->image.attributes.event_mask | PointerMotionMask);     do     {c       highlight_info=cut_info;3       highlight_info.x=cut_info.x-windows->image.x; 3       highlight_info.y=cut_info.y-windows->image.y; D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*0             Display info and draw cut rectangle.           */L           (void) sprintf(text," %ux%u%+d%+d",cut_info.width,cut_info.height,#             cut_info.x,cut_info.y); ,           XInfoWidget(display,windows,text);5           XHighlightRegion(display,windows->image.id,r>             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);vD       if ((highlight_info.width > 3) && (highlight_info.height > 3))3         XHighlightRegion(display,windows->image.id,t<           windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id)m	         {            /*5             Select a command from the Command widget.            */@           id=XCommandWidget(display,windows,CutModeMenu,&event);           if (id < 0)Q             continue;n           switch (id)            {t             case CutModeHelpOp:s
             {tL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Cutping",ImageCutHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             } "             case CutModeDismissOp:
             {s               /*!                 Prematurely exit.(               */!               state|=EscapeState;                state|=ExitState;m               break;
             }              default:               break;           }o           continue; 	         }<       switch (event.type)        {w         case ButtonPress: 	         {A6           if (event.xbutton.window == windows->pan.id)
             {n0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 6           cut_info.x=windows->image.x+event.xbutton.x;6           cut_info.y=windows->image.y+event.xbutton.y;           break;	         }-         case ButtonRelease:o	         {u           /*0             User has committed to cut rectangle.           */6           cut_info.x=windows->image.x+event.xbutton.x;6           cut_info.y=windows->image.y+event.xbutton.y;1           XSetCursorState(display,windows,False);]*           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);n           state|=ExitState;            break;	         }e         case Expose:           break;         case MotionNotify:	         {f           /*1             Discard pending button motion events.B           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));=6           cut_info.x=windows->image.x+event.xmotion.x;6           cut_info.y=windows->image.y+event.xmotion.y;	         }          default:           break;       } J       if (((cut_info.x != x) && (cut_info.y != y)) || (state & ExitState))	         {n           /*&             Check boundary conditions.           */           if (cut_info.x < 0)t             cut_info.x=0;L           else:             if (cut_info.x > windows->image.ximage->width)6               cut_info.x=windows->image.ximage->width;           if (cut_info.x < x) 9             cut_info.width=(unsigned int) (x-cut_info.x);F           else
             { ;               cut_info.width=(unsigned int) (cut_info.x-x);                cut_info.x=x;M
             }            if (cut_info.y < 0)              cut_info.y=0;e           else;             if (cut_info.y > windows->image.ximage->height) 7               cut_info.y=windows->image.ximage->height;            if (cut_info.y < y) :             cut_info.height=(unsigned int) (y-cut_info.y);           else
             {s<               cut_info.height=(unsigned int) (cut_info.y-y);               cut_info.y=y; 
             }N	         }(#     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id,n,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);n     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state&=(~ExitState);     do     {        if (windows->info.mapped)"	         {            /*%             Display pointer position.o           */@           (void) sprintf(text," %+d%+d ",cut_info.x,cut_info.y);,           XInfoWidget(display,windows,text);	         }d       highlight_info=cut_info;3       highlight_info.x=cut_info.x-windows->image.x; 3       highlight_info.y=cut_info.y-windows->image.y; F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;            state|=ExitState;m           break;	         }s1       XHighlightRegion(display,windows->image.id, :         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows);a1       XHighlightRegion(display,windows->image.id, :         windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id) 	         {_           /*5             Select a command from the Command widget.o           */D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);           if (id < 0)o             continue;            switch (id)o           {e"             case RectifyModeCutOp:
             {                state|=ExitState;                break;
             } #             case RectifyModeHelpOp: 
             {TL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Cutping",ImageCutHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }N&             case RectifyModeDismissOp:
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;e               state|=ExitState;n               break;
             }a             default:               break;           }            continue;)	         }        switch (event.type)(       {7         case ButtonPress:t	         {n6           if (event.xbutton.window == windows->pan.id)
             {s0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y;tK           if ((x < (cut_info.x+RoiDelta)) && (x > (cut_info.x-RoiDelta)) &&,I               (y < (cut_info.y+RoiDelta)) && (y > (cut_info.y-RoiDelta)))e
             { 3               cut_info.x=cut_info.x+cut_info.width;D4               cut_info.y=cut_info.y+cut_info.height;.               state|=UpdateConfigurationState;               break;
             }tK           if ((x < (cut_info.x+RoiDelta)) && (x > (cut_info.x-RoiDelta)) && <               (y < (cut_info.y+cut_info.height+RoiDelta)) &&:               (y > (cut_info.y+cut_info.height-RoiDelta)))
             {(3               cut_info.x=cut_info.x+cut_info.width; .               state|=UpdateConfigurationState;               break;
             }d;           if ((x < (cut_info.x+cut_info.width+RoiDelta)) &&n;               (x > (cut_info.x+cut_info.width-RoiDelta)) && I               (y < (cut_info.y+RoiDelta)) && (y > (cut_info.y-RoiDelta)))n
             { 4               cut_info.y=cut_info.y+cut_info.height;.               state|=UpdateConfigurationState;               break;
             }s;           if ((x < (cut_info.x+cut_info.width+RoiDelta)) &&*;               (x > (cut_info.x+cut_info.width-RoiDelta)) && <               (y < (cut_info.y+cut_info.height+RoiDelta)) &&:               (y > (cut_info.y+cut_info.height-RoiDelta)))
             {h.               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease:m           break;         case Expose:	         {E8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                {X1                 event.xexpose.x=highlight_info.x;(1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width; ;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);                } 7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }n         case KeyPress:	         {t           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);i           switch (key_symbol)t           {              case XK_Escape:.             case XK_F20:!               state|=EscapeState;p             case XK_Return:>
             {                state|=ExitState;                break;
             }-             case XK_F1:              case XK_Help:+
             {eL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Cutping",ImageCutHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);o               break;
             }=           }t           break;	         }n         case KeyRelease:           break;         case MotionNotify:	         {e           /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));x           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)s
             {f@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen);=
             }*           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height)))o3               XMapWindow(display,windows->info.id);i           break;	         }+         default:           break;       }s+       if (state & UpdateConfigurationState)n	         {o(           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         }f#     } while (!(state & ExitState));n!   } while (!(state & ExitState));n@   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);n)   XSetCursorState(display,windows,False);e   if (state & EscapeState)     return(True);i   /*2     Cut region is relative to image configuration.   */   windows->info.mapped=False;r,   XInfoWidget(display,windows,CutImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;d   height=image->rows;t4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);(;   scale_factor=UpShift(width)/windows->image.ximage->width;o   cut_info.x+=x;0   cut_info.x=DownShift(cut_info.x*scale_factor);8   cut_info.width=DownShift(cut_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;(   cut_info.y+=y;0   cut_info.y=DownShift(cut_info.y*scale_factor);:   cut_info.height=DownShift(cut_info.height*scale_factor);#   if (copy_image != (Image *) NULL)      DestroyImage(copy_image);s(   copy_image=CropImage(image,&cut_info);)   XSetCursorState(display,windows,False);g   /*     Cut image.   */   image->class=DirectClass;_   if (!image->matte)     {i       /*         Initialize matte data.       */       p=image->pixels;(       for (x=0; x < image->packets; x++)       {o         p->index=Opaque;         p++;       }d       image->matte=True;     }p   if (UncompressImage(image))<'     for (y=0; y < cut_info.height; y++)h     { ?       p=image->pixels+(cut_info.y+y)*image->columns+cut_info.x; (       for (x=0; x < cut_info.width; x++)       {a         p->index=Transparent;r         p++;       }a     }a   /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);i }h a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %eO %                                                                             % O %                                                                             % O %   X D i s p l a y B a c k g r o u n d I m a g e                             %tO %                                                                             % O %                                                                             %xO %                                                                             %wO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDisplayBackgroundImage displays an image in the background of a
 %  window. %m8 %  The format of the XDisplayBackgroundImage routine is: % B %      status=XDisplayBackgroundImage(display,resource_info,image) % + %  A description of each parameter follows:. % C %    o status: Function XDisplayBackgroundImage returns True if theI, %      designated window is the root window. %uE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.t %IE %    o image: Specifies a pointer to a Image structure; returned froms %      ReadImage.  %  %  */H static unsigned int XDisplayBackgroundImage(display,resource_info,image) Display    *display;o  
 XResourceInfo    *resource_info;n   Imagen	   *image;* {U   char     visual_type[MaxTextLength];S     unsigned int     height,,     status,e
     width;     Window     root_window;     XGCValues-     context_values;      XPixelInfo     pixel_info;      XResourceInfo=     resources;     XStandardColormap      *map_info;  
   XVisualInfod     *visual_info;a     XWindowAttributes      window_attributes;  
   XWindowInfo      window_info;     /*     Determine target window.   */   window_info.id=(Window) NULL; %   window_info.ximage=(XImage *) NULL; *   window_info.matte_image=(XImage *) NULL;#   window_info.pixmap=(Pixmap) NULL; )   window_info.matte_pixmap=(Pixmap) NULL; "   window_info.shared_memory=False;;   root_window=XRootWindow(display,XDefaultScreen(display));t:   if (Latin1Compare(resource_info->window_id,"root") == 0)     window_info.id=root_window;    else     {y-       if (isdigit(*resource_info->window_id)) ?         window_info.id=XWindowByID(display,root_window,(Window)_F           strtol((char *) resource_info->window_id,(char **) NULL,0));*       if (window_info.id == (Window) NULL)         window_info.id= F           XWindowByName(display,root_window,resource_info->window_id);     } &   if (window_info.id == (Window) NULL)I     Error("No window with specified id exists",resource_info->window_id);p   /*     Determine window visual id.    */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display)); K   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display)); '   (void) strcpy(visual_type,"default");oI   status=XGetWindowAttributes(display,window_info.id,&window_attributes);    if (status != False)'     (void) sprintf(visual_type,"0x%lx", 5       XVisualIDFromVisual(window_attributes.visual));f   /*     Allocate standard colormap.s   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL);K     Error("Unable to create standard colormap","Memory allocation failed");x%   map_info->colormap=(Colormap) NULL;y+   pixel_info.pixels=(unsigned long *) NULL;R   /*     Initialize visual info.e   */   resources=(*resource_info); #   resources.map_type=(char *) NULL; $   resources.visual_type=visual_type;;   visual_info=XBestVisualInfo(display,map_info,&resources); *   if (visual_info == (XVisualInfo *) NULL)=     Error("Unable to get visual",resource_info->visual_type);t   /*     Free previous root colors.   */$   if (window_info.id == root_window).     XDestroyWindowColors(display,root_window);   /*     Initialize colormap.   */$   resources.colormap=SharedColormap;F   XMakeStandardColormap(display,visual_info,&resources,image,map_info,     &pixel_info);    /*     Graphic context superclass.h   */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);   /*'     Initialize Image window attributes.    */O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,       resource_info,&window_info);   /*     Create the X image.x   */#   window_info.width=image->columns;f3   if (window_info.width >= window_attributes.width)n.     window_info.width=window_attributes.width;!   window_info.height=image->rows; 5   if (window_info.height >= window_attributes.height) 0     window_info.height=window_attributes.height;O   status=XMakeImage(display,resource_info,&window_info,image,window_info.width,      window_info.height);   if (status == False)4     Error("Unable to create X image",(char *) NULL);   window_info.x=0;   window_info.y=0;   if (resource_info->debug)      { C       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",image->filename,e1         image->scene,image->columns,image->rows);e       if (image->colors != 0) 4         (void) fprintf(stderr,"%uc ",image->colors);2       (void) fprintf(stderr,"%s\n",image->magick);     }    /*I     Adjust image dimensions as specified by backdrop or geometry options.e   */   width=window_info.width;   height=window_info.height;   if (resource_info->backdrop)     {        /*$         Center image on root window.       */3       window_info.x=(window_attributes.width >> 1)-x)         (window_info.ximage->width >> 1);o4       window_info.y=(window_attributes.height >> 1)-*         (window_info.ximage->height >> 1);$       width=window_attributes.width;&       height=window_attributes.height;     } 5   if (resource_info->image_geometry != (char *) NULL)      {n
       char(         default_geometry[MaxTextLength];  	       int          flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints(); ,       if (size_hints == (XSizeHints *) NULL)H         Error("Unable to display on window","Memory allocation failed");$       size_hints->flags=(long) NULL;<       (void) sprintf(default_geometry,"%ux%u",width,height);4       flags=XWMGeometry(display,visual_info->screen,7         resource_info->image_geometry,default_geometry,cJ         window_info.border_width,size_hints,&window_info.x,&window_info.y,1         (int *) &width,(int *) &height,&gravity); $       if (flags & (XValue | YValue))	         { (           width=window_attributes.width;*           height=window_attributes.height;	         } !       XFree((void *) size_hints);      }    /*     Create the X pixmap.   */   window_info.pixmap=nI     XCreatePixmap(display,window_info.id,width,height,window_info.depth);n*   if (window_info.pixmap == (Pixmap) NULL)5     Error("Unable to create X pixmap",(char *) NULL);c   /*!     Display pixmap on the window.i   */C   if ((width > window_info.width) || (height > window_info.height))rK     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,=       0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,)     window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);    /*     Free resources.    */*   XFreePixmap(display,window_info.pixmap);$   XDestroyImage(window_info.ximage);0   XFreeGC(display,window_info.annotate_context);*   XFreeCursor(display,window_info.cursor);/   XFreeCursor(display,window_info.busy_cursor);w$   if (window_info.id != root_window)D     XFreeStandardColormap(display,visual_info,map_info,&pixel_info);   else4     if (pixel_info.pixels != (unsigned long *) NULL)'       free((char *) pixel_info.pixels);f   XFree((void *) map_info);a   XFree((void *) visual_info);(   return(window_info.id == root_window); }) L /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %=O %                                                                             %iO %                                                                             %xO %   X D i s p l a y I m a g e                                                 %nO %                                                                             % O %                                                                             %=O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%b %dL %  Function XDisplayImage displays an image via X11.  A new image is createdI %  and returned if the user interactively transforms the displayed image.- %i. %  The format of the XDisplayImage routine is: %gN %      loaded_image=XDisplayImage(display,resource_info,argv,argc,image,state) %e+ %  A description of each parameter follows:  %=F %    o loaded_image:  Function XDisplayImage returns an image when theF %      user chooses 'Load Image' from the command menu or picks a tileE %      from the image directory.  Otherwise a null image is returned.& %iE %    o display: Specifies a connection to an X server;  returned froma %      XOpenDisplay. %oK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %(7 %    o argv: Specifies the application's argument list.) %a/ %    o argc: Specifies the number of arguments.i %,G %    o image: Specifies an address to an address of an Image structure;t %      returned from ReadImage.k %r %W */H static Image *XDisplayImage(display,resource_info,argv,argc,image,state) Display    *display;i  
 XResourceInfo    *resource_info;*   char	   **argv;    int    argc;o   Imagee
   **image;  
 unsigned long 	   *state;v {s4 #define MagnifySize  256  /* must be a power of 2 */ #define MagickMenus  8 #define MaxWindows  10 #define MagickTitle  "Commands"i  
   static char;     *CommandMenu[]=      { 
       "File", 
       "Edit",r
       "Size",x       "Pixel Transform",       "Color Transform",       "Effects",       "Image Edit",a       "Miscellany",l
       "Quit",        (char *) NULLl     },     *FileMenu[]=     {(       "Load...",
       "Next",        "Former",        "Select...",       "Save...",       "Print...",        "Delete...",       "Canvas...",       "Slide Show...",       "Visual Directory...",       (char *) NULL      },     *EditMenu[]=     {i
       "Undo",-       "Cut",
       "Copy",        "Paste",       "Refresh",       (char *) NULLt     },     *SizeMenu[]=     {_       "Half Size",       "Original Size",       "Double Size",       "Resize...",       "Restore",       "Apply",       (char *) NULL>     },     *PixelTransformMenu[]=     {w
       "Crop",i
       "Chop", 
       "Flop",f
       "Flip",>       "Rotate Right",n       "Rotate Left",       "Rotate...",       "Shear...",r       "Trim Edges",f       (char *) NULLt     },     *ColorEnhanceMenu[]=     {D       "Hue...",_       "Saturation...",       "Brightness...",       "Gamma...",o       "Spiff",
       "Dull",o       "Equalize",t       "Normalize",       "Negate",a       "Grayscale",       "Quantize...",       (char *) NULL,     },     *EffectsMenu[]=o     {f       "Despeckle",       "Peak Noise",=       "Sharpen...",l       "Blur...",       "Edge Detect",       "Emboss",s       "Oil Painting",e       "Raise...",h       "Segment...",t       (char *) NULLr     },     *ImageEditMenu[]=a     {=       "Annotate", 
       "Draw",u       "Color",       "Matte",       "Composite...",i       "Add Border...",       "Add Frame...",l       "Comment",       "Region of Interest",i       (char *) NULLt     },     *MiscellanyMenu[]=     {(       "Image Info",        "Version",
       "Help",i       "Background...",       "Preferences...",o       (char *) NULLg     },     *ShortCutsMenu[]=d     {r
       "Next",n       "Load...",       "Save...",
       "Undo",%       "Restore",
       "Crop",%       "Gamma...",%       "Annotate",        "Image Info",        (char *) NULL      };  
   static char      **Menus[MagickMenus]=      {        FileMenu,        EditMenu,        SizeMenu,        PixelTransformMenu,        ColorEnhanceMenu,        EffectsMenu,       ImageEditMenu,       MiscellanyMenu     };     static KeySym      CommandKeys[]=     {        XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,
       XK_q     },     FileKeys[]=      {        XK_l,        XK_n,%       XK_f,%       XK_F2,       XK_s,%       XK_p,%       XK_Delete,       XK_C,        XK_comma,d
       XK_V     },     EditKeys[]=f     {o       XK_u,e       XK_F3,       XK_F4,       XK_F5,       XK_ats     },     SizeKeys[]=s     {s       XK_less,       XK_o,        XK_greater,o       XK_percent,l       XK_r, 
       XK_A     },     PixelTransformKeys[]=r     {h       XK_bracketleft,t       XK_bracketright,
       XK_bar,m       XK_minus,f       XK_slash,e       XK_backslash,        XK_asterisk,       XK_F6,
       XK_t     },     ColorEnhanceKeys[]=p     {a       XK_F7,       XK_F8,       XK_F9,       XK_g,X
       XK_F10,o
       XK_F11,        XK_equal,        XK_N,o       XK_asciitilde,       XK_G,        XK_numbersigne     },     EffectsKeys[]=     {r       XK_D,        XK_P,a       XK_S,        XK_B,s       XK_E,c       XK_M,d       XK_O,c       XK_asciicircum, 
       XK_Z     },     ImageEditKeys[]=     {u       XK_a,        XK_d,w       XK_c,m       XK_m,g       XK_x,n       XK_b,m       XK_F,a       XK_exclam,
       XK_R     },     MiscellanyKeys[]=[     {L       XK_i,t       XK_v,u       XK_h,        XK_ampersand,        XK_F12     },     ShortCutsKeys[]=     {m       XK_n,o       XK_l,        XK_s,(       XK_u,w       XK_r,"       XK_bracketleft,d       XK_g,e       XK_a,t
       XK_i     };     static KeySym_     *Keys[MagickMenus]=F     {        FileKeys,o       EditKeys,o       SizeKeys,,       PixelTransformKeys,        ColorEnhanceKeys,w       EffectsKeys,       ImageEditKeys,       MiscellanyKeys,;     };     static unsigned charB     HighlightBitmap[] = {0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55},?     ShadowBitmap[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};e     char     command[MaxTextLength],]!     resource_name[MaxTextLength];t     Image_     *displayed_image,k     *loaded_image;     ints
     entry,     id,X     status;o     KeySym     key_symbol;r     register int     i;  
   static chari%     working_directory[MaxTextLength];n     static Window      root_window;     static XClassHintT     *class_hints;W     static XFontStruct     *font_info;n     static XPixelInfos     icon_pixel,i     pixel_info;      static XPointn
     vid_info;r     static XResourceInfo     icon_resources;u     static XStandardColormap     *icon_map,     *map_info;     static XVisualInfo     *icon_visual, (     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo      *magick_windows[MaxWindows];     static XWMHints      *manager_hints;      static unsigned int      number_windows;   
   struct stat      file_info;     time_t
     timer,     time_stamp,      update_time;     unsigned int     context_mask;      XEvent
     event;     XGCValues      context_values;      XWindowChanges     window_changes;   *   if (visual_info != (XVisualInfo *) NULL)$     (void) chdir(working_directory);   else     {        /*#         Allocate standard colormap.%       */       if (resource_info->debug)%	         {%%           XSynchronize(display,True); 9           (void) fprintf(stderr,"Version: %s\n",Version);h	         }t(       map_info=XAllocStandardColormap();(       icon_map=XAllocStandardColormap();5       if ((map_info == (XStandardColormap *) NULL) ||a3           (icon_map == (XStandardColormap *) NULL)) O         Error("Unable to create standard colormap","Memory allocation failed");a)       map_info->colormap=(Colormap) NULL;f)       icon_map->colormap=(Colormap) NULL;r/       pixel_info.pixels=(unsigned long *) NULL;o,       pixel_info.annotate_context=(GC) NULL;-       pixel_info.highlight_context=(GC) NULL;n*       pixel_info.widget_context=(GC) NULL;%       font_info=(XFontStruct *) NULL;c,       icon_pixel.annotate_context=(GC) NULL;/       icon_pixel.pixels=(unsigned long *) NULL;s       /*         Allocate visual.       */&       icon_resources=(*resource_info);,       icon_resources.map_type=(char *) NULL;+       icon_resources.visual_type="default";i-       icon_resources.colormap=SharedColormap;fB       visual_info=XBestVisualInfo(display,map_info,resource_info);D       icon_visual=XBestVisualInfo(display,icon_map,&icon_resources);2       if ((visual_info == (XVisualInfo *) NULL) ||0           (icon_visual == (XVisualInfo *) NULL))A         Error("Unable to get visual",resource_info->visual_type);;       if (resource_info->debug) 	         {t-           (void) fprintf(stderr,"Visual:\n"); N           (void) fprintf(stderr,"  visual id: 0x%lx\n",visual_info->visualid);0           (void) fprintf(stderr,"  class: %s\n",2             XVisualClassName(visual_info->class));K           (void) fprintf(stderr,"  depth: %d planes\n",visual_info->depth);wC           (void) fprintf(stderr,"  size of colormap: %d entries\n",n(             visual_info->colormap_size);P           (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",:             visual_info->red_mask,visual_info->green_mask,$             visual_info->blue_mask);I           (void) fprintf(stderr,"  significant bits in color: %d bits\n",w'             visual_info->bits_per_rgb);d	         }o       /*         Allocate atoms.t       */4       windows=(XWindows *) malloc(sizeof(XWindows));'       if (windows == (XWindows *) NULL)pG         Error("Unable to create X windows","Memory allocation failed"); F       windows->wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);N       windows->wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);H       windows->wm_take_focus=XInternAtom(display,"WM_TAKE_FOCUS",False);F       windows->im_protocols=XInternAtom(display,"IM_PROTOCOLS",False);N       windows->im_update_widget=XInternAtom(display,"IM_UPDATE_WIDGET",False);"       windows->im_update_colormap=8         XInternAtom(display,"IM_UPDATE_COLORMAP",False);L       windows->im_former_image=XInternAtom(display,"IM_FORMER_IMAGE",False);H       windows->im_next_image=XInternAtom(display,"IM_NEXT_IMAGE",False);N       windows->im_retain_colors=XInternAtom(display,"IM_RETAIN_COLORS",False);<       windows->im_exit=XInternAtom(display,"IM_EXIT",False);       if (resource_info->debug))	         { 0           (void) fprintf(stderr,"Protocols:\n");<           (void) fprintf(stderr,"  Window Manager: 0x%lx\n",#             windows->wm_protocols);e=           (void) fprintf(stderr,"    delete window: 0x%lx\n", '             windows->wm_delete_window);e:           (void) fprintf(stderr,"    take focus: 0x%lx\n",$             windows->wm_take_focus);9           (void) fprintf(stderr,"  ImageMagick: 0x%lx\n",;#             windows->im_protocols); =           (void) fprintf(stderr,"    update widget: 0x%lx\n", '             windows->im_update_widget); ?           (void) fprintf(stderr,"    update colormap: 0x%lx\n",S)             windows->im_update_colormap); <           (void) fprintf(stderr,"    former image: 0x%lx\n",&             windows->im_former_image);:           (void) fprintf(stderr,"    next image: 0x%lx\n",$             windows->im_next_image);=           (void) fprintf(stderr,"    retain colors: 0x%lx\n",;'             windows->im_retain_colors);,F           (void) fprintf(stderr,"    exit: 0x%lx\n",windows->im_exit);	         }t       /*)         Allocate class and manager hints.        */$       class_hints=XAllocClassHint();$       manager_hints=XAllocWMHints();1       if ((class_hints == (XClassHint *) NULL) ||o/           (manager_hints == (XWMHints *) NULL)) :         Error("Unable to allocate X hints",(char *) NULL);       /*         Initialize window id's.;       */;       root_window=XRootWindow(display,visual_info->screen);x       number_windows=0;S8       magick_windows[number_windows++]=(&windows->icon);<       magick_windows[number_windows++]=(&windows->backdrop);9       magick_windows[number_windows++]=(&windows->image);m8       magick_windows[number_windows++]=(&windows->info);;       magick_windows[number_windows++]=(&windows->command); :       magick_windows[number_windows++]=(&windows->widget);9       magick_windows[number_windows++]=(&windows->popup);E;       magick_windows[number_windows++]=(&windows->magnify);a7       magick_windows[number_windows++]=(&windows->pan);X(       for (i=0; i < number_windows; i++),         magick_windows[i]->id=(Window) NULL;       vid_info.x=0;        vid_info.y=0;p     }o   /*!     Initialize Standard Colormap.H   */   loaded_image=(Image *) NULL;   displayed_image=(*image);i   if (resource_info->debug)h     {oM       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",displayed_image->filename, O         displayed_image->scene,displayed_image->columns,displayed_image->rows); '       if (displayed_image->colors != 0)t>         (void) fprintf(stderr,"%uc ",displayed_image->colors);<       (void) fprintf(stderr,"%s\n",displayed_image->magick);     }yJ   XMakeStandardColormap(display,visual_info,resource_info,displayed_image,     map_info,&pixel_info);   /*     Initialize font info.t   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info); 3   font_info=XBestFont(display,resource_info,False);i(   if (font_info == (XFontStruct *) NULL)5     Error("Unable to load font",resource_info->font);    /*     Initialize graphic context.f   */$   windows->context.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->context);.%   class_hints->res_name="superclass"; #   class_hints->res_class="Display"; -   manager_hints->flags=InputHint | StateHint;a   manager_hints->input=False;w.   manager_hints->initial_state=WithdrawnState;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->context);e   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);>   context_values.background=pixel_info.background_color.pixel;%   context_values.font=font_info->fid;u>   context_values.foreground=pixel_info.foreground_color.pixel;*   context_values.graphics_exposures=False;J   context_mask=GCBackground | GCFont | GCForeground | GCGraphicsExposures;/   if (pixel_info.annotate_context != (GC) NULL)e1     XFreeGC(display,pixel_info.annotate_context);    pixel_info.annotate_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);/   if (pixel_info.annotate_context == (GC) NULL)e<     Error("Unable to create graphic context",(char *) NULL);9   context_values.background=pixel_info.depth_color.pixel; -   if (pixel_info.widget_context != (GC) NULL) /     XFreeGC(display,pixel_info.widget_context);d   pixel_info.widget_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);-   if (pixel_info.widget_context == (GC) NULL)9<     Error("Unable to create graphic context",(char *) NULL);>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;   context_values.plane_mask=:     context_values.background ^ context_values.foreground;0   if (pixel_info.highlight_context != (GC) NULL)2     XFreeGC(display,pixel_info.highlight_context);E   pixel_info.highlight_context=XCreateGC(display,windows->context.id,e0     context_mask | GCPlaneMask,&context_values);0   if (pixel_info.highlight_context == (GC) NULL)<     Error("Unable to create graphic context",(char *) NULL);.   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.    */O   XGetWindowInfo(display,icon_visual,icon_map,&icon_pixel,(XFontStruct *) NULL,t$     &icon_resources,&windows->icon);6   windows->icon.geometry=resource_info->icon_geometry;8   XBestIconSize(display,&windows->icon,displayed_image);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);I   windows->icon.attributes.event_mask=ExposureMask | StructureNotifyMask;m   class_hints->res_name="icon";o-   manager_hints->flags=InputHint | StateHint;    manager_hints->input=False;w+   manager_hints->initial_state=IconicState;oF   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->icon);   if (resource_info->debug)xH     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window.    *//   if (icon_pixel.annotate_context != (GC) NULL) 1     XFreeGC(display,icon_pixel.annotate_context);x>   context_values.background=icon_pixel.background_color.pixel;>   context_values.foreground=icon_pixel.foreground_color.pixel;A   icon_pixel.annotate_context=XCreateGC(display,windows->icon.id,i1     GCBackground | GCForeground,&context_values); /   if (icon_pixel.annotate_context == (GC) NULL)2<     Error("Unable to create graphic context",(char *) NULL);=   windows->icon.annotate_context=icon_pixel.annotate_context;i   /*     Initialize Image window.   */)   if (windows->image.id != (Window) NULL).     { )       free((char *) windows->image.name);).       free((char *) windows->image.icon_name);     }fD   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->image); B   windows->image.name=(char *) malloc(MaxTextLength*sizeof(char));G   windows->image.icon_name=(char *) malloc(MaxTextLength*sizeof(char));fJ   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))F     Error("Unable to create Image window","Memory allocation failed");O   if ((resource_info->title != (char *) NULL) && !(*state & MontageImageState))d     {p       /*#         User specified window name.(       */>       (void) strcpy(windows->image.name,resource_info->title);C       (void) strcpy(windows->image.icon_name,resource_info->title);_     }d   else     {-
       char         *p;g         /*0         Window name is the base of the filename.       */F       p=displayed_image->filename+strlen(displayed_image->filename)-1;O       while ((p > displayed_image->filename) && (*(p-1) != *BasenameSeparator))c         p--;A       (void) sprintf(windows->image.name,"ImageMagick: %s[%u]",p,e          displayed_image->scene);:       if ((displayed_image->previous == (Image *) NULL) &&6           (displayed_image->next == (Image *) NULL) &&(           (displayed_image->scene == 0))@         (void) sprintf(windows->image.name,"ImageMagick: %s",p);0       (void) strcpy(windows->image.icon_name,p);     }c8   windows->image.geometry=resource_info->image_geometry;0   windows->image.width=displayed_image->columns;H   if (windows->image.width > XDisplayWidth(display,visual_info->screen))D     windows->image.width=XDisplayWidth(display,visual_info->screen);.   windows->image.height=displayed_image->rows;J   if (windows->image.height > XDisplayHeight(display,visual_info->screen))F     windows->image.height=XDisplayHeight(display,visual_info->screen);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask | G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |%<     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;   if (resource_info->immutable) L     windows->image.attributes.event_mask=ExposureMask | StructureNotifyMask;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,&     resource_info,&windows->backdrop);K   if ((resource_info->backdrop) || (windows->backdrop.id != (Window) NULL))      {        /*#         Initialize backdrop window.        */       windows->backdrop.x=0;       windows->backdrop.y=0;4       windows->backdrop.name="ImageMagick Backdrop";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen);tK       windows->backdrop.height=XDisplayHeight(display,visual_info->screen); '       windows->backdrop.border_width=0; '       windows->backdrop.immutable=True;iJ       windows->backdrop.attributes.do_not_propagate_mask=ButtonPressMask |         ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;'       class_hints->res_name="backdrop";XB       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state=r:         resource_info->iconic ? IconicState : NormalState;J       XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,         &windows->backdrop);       if (resource_info->debug)C>         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id);n1       XClearWindow(display,windows->backdrop.id); -       if (windows->image.id != (Window) NULL)h	         {y4           XDestroyWindow(display,windows->image.id);*           windows->image.id=(Window) NULL;	         })       /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition; I       windows->image.x=(XDisplayWidth(display,visual_info->screen) >> 1)-w$         (windows->image.width >> 1);J       windows->image.y=(XDisplayHeight(display,visual_info->screen) >> 1)-%         (windows->image.height >> 1);(     }_+   if (resource_info->name == (char *) NULL)a&     class_hints->res_name=client_name;   else.     class_hints->res_name=resource_info->name;>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state= 6     resource_info->iconic ? IconicState : NormalState;   XMakeWindow(display,L     (Window) (resource_info->backdrop ? windows->backdrop.id : root_window),9     argv,argc,class_hints,manager_hints,&windows->image);+   if (resource_info->debug)=J     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*!     Initialize X image structure.a   */   windows->image.x=0;l   windows->image.y=0;iJ   status=XMakeImage(display,resource_info,&windows->image,displayed_image,4     displayed_image->columns,displayed_image->rows);   if (status == False)4     Error("Unable to create X image",(char *) NULL);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);H   if (!windows->image.mapped || (windows->backdrop.id != (Window) NULL))*     XMapWindow(display,windows->image.id);   if (windows->image.mapped)<     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*     Initialize Info widget.)   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,"     resource_info,&windows->info);   windows->info.name="Info";   windows->info.border_width=1;    windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition; +   windows->info.attributes.save_under=True; 4   windows->info.attributes.win_gravity=UnmapGravity;&   windows->info.attributes.event_mask=9     ButtonPressMask | ExposureMask | StructureNotifyMask;)   class_hints->res_name="info";=?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False; +   manager_hints->initial_state=NormalState;e0   manager_hints->window_group=windows->image.id;L   XMakeWindow(display,windows->image.id,argv,argc,class_hints,manager_hints,     &windows->info);C   XSetTransientForHint(display,windows->info.id,windows->image.id);    if (windows->info.mapped) C     XWithdrawWindow(display,windows->info.id,windows->info.screen);o   if (resource_info->debug)oH     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*     Initialize Command widget.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->command); $   windows->command.data=MagickMenus;E   (void) XCommandWidget(display,windows,CommandMenu,(XEvent *) NULL); 9   (void) sprintf(resource_name,"%s.command",client_name);uO   windows->command.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);$   windows->command.name=MagickTitle;"   windows->command.border_width=0;$   windows->command.flags|=PPosition;7   windows->command.attributes.backing_store=WhenMapped;C.   windows->command.attributes.save_under=True;M   windows->command.attributes.event_mask=ButtonMotionMask | ButtonPressMask |dJ     ButtonReleaseMask | EnterWindowMask | ExposureMask | LeaveWindowMask |.     OwnerGrabButtonMask | StructureNotifyMask;"   class_hints->res_name="command";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False;l+   manager_hints->initial_state=NormalState;e0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->command);QC   windows->command.highlight_stipple=XCreateBitmapFromData(display,y6     windows->command.id,(char *) HighlightBitmap,8,8);@   windows->command.shadow_stipple=XCreateBitmapFromData(display,3     windows->command.id,(char *) ShadowBitmap,8,8); F   XSetTransientForHint(display,windows->command.id,windows->image.id);   if (windows->command.mapped),     XMapRaised(display,windows->command.id);   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);   /*     Initialize widget window.(   */*   if (windows->widget.id != (Window) NULL)(     free((char *) windows->widget.name);D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,$     resource_info,&windows->widget);C   windows->widget.name=(char *) malloc(MaxTextLength*sizeof(char)); #   if (windows->widget.name == NULL):F     Error("Unable to create Image window","Memory allocation failed");   *windows->widget.name='\0';x!   windows->widget.border_width=0; #   windows->widget.flags|=PPosition; 6   windows->widget.attributes.backing_store=WhenMapped;-   windows->widget.attributes.save_under=True;PL   windows->widget.attributes.event_mask=ButtonMotionMask | ButtonPressMask |G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |m;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;t!   class_hints->res_name="widget"; ?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;s   manager_hints->input=True;+   manager_hints->initial_state=NormalState;(0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->widget);G   windows->widget.highlight_stipple=windows->command.highlight_stipple; A   windows->widget.shadow_stipple=windows->command.shadow_stipple;1E   XSetTransientForHint(display,windows->widget.id,windows->image.id);l   if (resource_info->debug) L     (void) fprintf(stderr,"Window id: 0x%lx (widget)\n",windows->widget.id);   /*     Initialize popup window.   */)   if (windows->popup.id != (Window) NULL) '     free((char *) windows->popup.name); D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->popup); B   windows->popup.name=(char *) malloc(MaxTextLength*sizeof(char));"   if (windows->popup.name == NULL)F     Error("Unable to create Image window","Memory allocation failed");   *windows->popup.name='\0';    windows->popup.border_width=0;"   windows->popup.flags|=PPosition;5   windows->popup.attributes.backing_store=WhenMapped;P,   windows->popup.attributes.save_under=True;K   windows->popup.attributes.event_mask=ButtonMotionMask | ButtonPressMask |iG     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |s;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;     class_hints->res_name="popup";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->popup);rF   windows->popup.highlight_stipple=windows->command.highlight_stipple;@   windows->popup.shadow_stipple=windows->command.shadow_stipple;D   XSetTransientForHint(display,windows->popup.id,windows->image.id);   if (resource_info->debug) K     (void) fprintf(stderr,"Window id: 0x%lx (pop up)\n",windows->popup.id);    /*)     Initialize Magnify window and cursor.r   */+   if (windows->magnify.id != (Window) NULL)e)     free((char *) windows->magnify.name); D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->magnify);r9   (void) sprintf(resource_name,"%s.magnify",client_name); O   windows->magnify.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);D   windows->magnify.name=(char *) malloc(MaxTextLength*sizeof(char));$   if (windows->magnify.name == NULL)H     Error("Unable to create Magnify window","Memory allocation failed");M   (void) sprintf(windows->magnify.name,"Magnify %uX",resource_info->magnify); @   windows->magnify.cursor=XMakeCursor(display,windows->image.id,7     map_info->colormap,resource_info->background_color, %     resource_info->foreground_color);n/   if (windows->magnify.cursor == (Cursor) NULL),3     Error("Unable to create cursor",(char *) NULL);d%   windows->magnify.width=MagnifySize; &   windows->magnify.height=MagnifySize;$   windows->magnify.flags|=PPosition;)   windows->magnify.min_width=MagnifySize;)*   windows->magnify.min_height=MagnifySize;)   windows->magnify.width_inc=MagnifySize; *   windows->magnify.height_inc=MagnifySize;/   windows->magnify.data=resource_info->magnify; .   windows->magnify.attributes.save_under=True;=   windows->magnify.attributes.cursor=windows->magnify.cursor; N   windows->magnify.attributes.event_mask=ButtonPressMask | ButtonReleaseMask |H     ExposureMask | KeyPressMask | KeyReleaseMask | OwnerGrabButtonMask |     StructureNotifyMask;"   class_hints->res_name="magnify";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;(   manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->magnify);    if (resource_info->debug)uN     (void) fprintf(stderr,"Window id: 0x%lx (magnify)\n",windows->magnify.id);F   XSetTransientForHint(display,windows->magnify.id,windows->image.id);   if (windows->magnify.mapped),     XMapRaised(display,windows->magnify.id);   /*     Initialize panning window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,!     resource_info,&windows->pan);r   windows->pan.name="Pan Icon";e7   XBestIconSize(display,&windows->pan,displayed_image); -   while ((windows->pan.width < MinPanSize) &&w,          (windows->pan.height < MinPanSize))   {t     windows->pan.width<<=1;      windows->pan.height<<=1;   } 5   (void) sprintf(resource_name,"%s.pan",client_name);,K   windows->pan.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);-   if (windows->pan.geometry != (char *) NULL)tA     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,n       &windows->pan.height);    windows->pan.flags|=PPosition;   windows->pan.immutable=True;*   windows->pan.attributes.save_under=True;I   windows->pan.attributes.event_mask=ButtonMotionMask | ButtonPressMask | F     ButtonReleaseMask | ExposureMask | KeyPressMask | KeyReleaseMask |     StructureNotifyMask;   class_hints->res_name="pan";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;n   manager_hints->input=True;+   manager_hints->initial_state=NormalState;.0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->pan);    if (resource_info->debug) F     (void) fprintf(stderr,"Window id: 0x%lx (pan)\n",windows->pan.id);B   XSetTransientForHint(display,windows->pan.id,windows->image.id);   if (windows->image.mapped)@     if ((windows->image.width < windows->image.ximage->width) ||@         (windows->image.height < windows->image.ximage->height))*       XMapRaised(display,windows->pan.id);   /*     Respond to events.   */   SetWarningHandler(XWarning);3   timer=time((time_t *) NULL)+resource_info->delay;a   update_time=0;   if (resource_info->update)     {a       /*3         Determine when file data was last modified.        */8       status=stat(displayed_image->filename,&file_info);       if (status == 0)'         update_time=file_info.st_mtime;      }r   *state&=(~FormerImageState);   *state&=(~MontageImageState);t   *state&=(~NextImageState);   do   {f     /*       Handle a window event.     */"     if (resource_info->delay != 0)       {f*         if (timer < time((time_t *) NULL))%           if (!resource_info->update)e/             *state|=NextImageState | ExitState;            else
             {i               /*5                 Determine if image file was modified.h               */@               status=stat(displayed_image->filename,&file_info);               if (status == 0)6                 if (update_time != file_info.st_mtime)                   {                      /*&                       Redisplay image.                     */F                     loaded_image=ReadImage(resource_info->image_info);7                     if (loaded_image != (Image *) NULL) 9                       *state|=NextImageState | ExitState;-                   }r?               timer=time((time_t *) NULL)+resource_info->delay;e
             } 9         if (XEventsQueued(display,QueuedAfterFlush) == 0)t           {              /*(               Do not block if delay > 0.             */-             XDelay(display,SuspendTime << 2);=             continue;            }i       }*%     time_stamp=time((time_t *) NULL);      XNextEvent(display,&event);      if (!windows->image.stasis)(C       windows->image.stasis=(time((time_t *) NULL)-time_stamp) > 0;+1     if (event.xany.window == windows->command.id)x       { 
         /*3           Select a command from the Command widget. 
         */>         id=XCommandWidget(display,windows,CommandMenu,&event);         if (id < 0)            continue; /         (void) strcpy(command,CommandMenu[id]); #         key_symbol=CommandKeys[id];.         if (id < MagickMenus)            {              /*2               Select a command from a pop-up menu.             */H             entry=XMenuWidget(display,windows,CommandMenu[id],Menus[id],               command);D             if (entry < 0)               continue; 4             (void) strcpy(command,Menus[id][entry]);'             key_symbol=Keys[id][entry];            }e(         if (key_symbol != XK_VoidSymbol)F           loaded_image=XMagickCommand(display,resource_info,windows,0,)             key_symbol,&displayed_image);;         continue;*       }o     switch (event.type)S     {l       case ButtonPress:        {)!         if (resource_info->debug)oB           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);i0         if ((event.xbutton.button == Button3) &&-             (event.xbutton.state & Mod1Mask))l           {              /*-               Convert Alt-Button3 to Button2.              */)             event.xbutton.button=Button2; -             event.xbutton.state&=(~Mod1Mask);f           } 9         if (event.xbutton.window == windows->backdrop.id)            { G             XSetInputFocus(display,event.xbutton.window,RevertToParent, "               event.xbutton.time);             break;           } 6         if (event.xbutton.window == windows->image.id)           {g)             switch (event.xbutton.button)m
             {i               case Button1:                {n                 /*+                   Map/unmap Command widget.)                 */,                 if (windows->command.mapped)>                   XWithdrawWindow(display,windows->command.id,-                     windows->command.screen);                  else                   {aF                     (void) XCommandWidget(display,windows,CommandMenu,'                       (XEvent *) NULL);a<                     XMapRaised(display,windows->command.id);                   })                 break;               }u               case Button2:%               {%                 /*8                   User pressed the image magnify button.                 */,                 if (windows->magnify.mapped)<                   XRaiseWindow(display,windows->magnify.id);                 else                   {                      /*)                       Make magnify image.                      */:                     XSetCursorState(display,windows,True);N                     status=XMakeImage(display,resource_info,&windows->magnify,=                       displayed_image,windows->magnify.width, /                       windows->magnify.height);                      status|=K                       XMakePixmap(display,resource_info,&windows->magnify);%(                     if (status == False)L                       Error("Unable to create magnify image",(char *) NULL);<                     XMapRaised(display,windows->magnify.id);;                     XSetCursorState(display,windows,False);i                   }u6                 XMagnifyImage(display,windows,&event);                 break;               }l               case Button3:n               {m>                 if (displayed_image->montage != (char *) NULL)                   {                      /*J                       Load or delete a tile from a visual image directory.                     */J                     loaded_image=XTileImage(display,resource_info,windows,.                       displayed_image,&event);7                     if (loaded_image != (Image *) NULL)tM                       *state|=MontageImageState | NextImageState | ExitState; 0                     vid_info.x=windows->image.x;0                     vid_info.y=windows->image.y;                     break;                   }r                 /*<                   Select a command from the Short Cuts menu.                 */M                 entry=XMenuWidget(display,windows,"Short Cuts",ShortCutsMenu,o                   command);                  if (entry >= 0)eN                   loaded_image=XMagickCommand(display,resource_info,windows,0,;                     ShortCutsKeys[entry],&displayed_image);h                 break;               }g               default:                 break;
             }g             break;           }n8         if (event.xbutton.window == windows->magnify.id)           {              char%               command[MaxTextLength];t               intt               factor;                static char                *MagnifyMenu[]=t               {                  "2",                 "4",                 "5",                 "6",                 "7",                 "8",                 "9",                 "3",                 (char *) NULL,               };               static KeySym;               MagnifyKeys[]=               {v                 XK_2,f                 XK_4,,                 XK_5,_                 XK_6,e                 XK_7,                  XK_8,,                 XK_9,(                 XK_3               };               /*;               Select a magnify factor from the pop-up menu.              */N             factor=XMenuWidget(display,windows,"Magnify",MagnifyMenu,command);             if (factor >= 0)I               XMagnifyWindowCommand(display,windows,MagnifyKeys[factor]);L             break;           }s4         if (event.xbutton.window == windows->pan.id)           {>.             XPanImage(display,windows,&event);             break;           }n9         timer=time((time_t *) NULL)+resource_info->delay;l         break;       }y       case ButtonRelease:o         break;       case ClientMessage:>       {;!         if (resource_info->debug)pI           (void) fprintf(stderr,"Client Message: 0x%lx 0x%lx %d 0x%lx\n",g<             event.xclient.window,event.xclient.message_type,:             event.xclient.format,event.xclient.data.l[0]);@         if (event.xclient.message_type == windows->im_protocols)           {SC             if (*event.xclient.data.l == windows->im_update_widget)                {p2                 windows->command.name=MagickTitle;2                 windows->command.data=MagickMenus;B                 (void) XCommandWidget(display,windows,CommandMenu,#                   (XEvent *) NULL);h                 break;               }aE             if (*event.xclient.data.l == windows->im_update_colormap)H               {s                 /*=                   Update graphic context and window colormap.                  */2                 for (i=0; i < number_windows; i++)                 {*@                   if (magick_windows[i]->id == windows->icon.id)                     continue; N                   context_values.background=pixel_info.background_color.pixel;N                   context_values.foreground=pixel_info.foreground_color.pixel;H                   XChangeGC(display,magick_windows[i]->annotate_context,2                     context_mask,&context_values);F                   XChangeGC(display,magick_windows[i]->widget_context,2                     context_mask,&context_values);N                   context_values.background=pixel_info.foreground_color.pixel;N                   context_values.foreground=pixel_info.background_color.pixel;,                   context_values.plane_mask=J                     context_values.background ^ context_values.foreground;I                   XChangeGC(display,magick_windows[i]->highlight_context, @                     context_mask | GCPlaneMask,&context_values);A                   magick_windows[i]->attributes.background_pixel= 6                     pixel_info.background_color.pixel;=                   magick_windows[i]->attributes.border_pixel=p2                     pixel_info.border_color.pixel;L                   magick_windows[i]->attributes.colormap=map_info->colormap;H                   XChangeWindowAttributes(display,magick_windows[i]->id,L                     magick_windows[i]->mask,&magick_windows[i]->attributes);                 }l(                 if (windows->pan.mapped)                   {oG                     XSetWindowBackgroundPixmap(display,windows->pan.id,0+                       windows->pan.pixmap);i:                     XClearWindow(display,windows->pan.id);7                     XDrawPanRectangle(display,windows);                    }o:                 if (windows->backdrop.id != (Window) NULL)?                   XInstallColormap(display,map_info->colormap);w                 break;               } B             if (*event.xclient.data.l == windows->im_former_image)               { 5                 *state|=FormerImageState | ExitState;                  break;               }.@             if (*event.xclient.data.l == windows->im_next_image)               {o3                 *state|=NextImageState | ExitState;                  break;               } C             if (*event.xclient.data.l == windows->im_retain_colors)                {;*                 *state|=RetainColorsState;                 break;               } :             if (*event.xclient.data.l == windows->im_exit)               { "                 *state|=ExitState;                 break;               }o             break;           } 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;?         if (*event.xclient.data.l != windows->wm_delete_window)            break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {i             *state|=ExitState;             break;           }w4         if (event.xclient.window == windows->pan.id)           {              /*E               Restore original image size when pan window is deleted.>             */M             windows->image.window_changes.width=windows->image.ximage->width; O             windows->image.window_changes.height=windows->image.ximage->height;%A             (void) XConfigureImage(display,resource_info,windows,t               displayed_image);            }.         break;       }i       case ConfigureNotify:s       {h!         if (resource_info->debug) K           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d %d\n", ;             event.xconfigure.window,event.xconfigure.width,+J             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y,)             event.xconfigure.send_event); 9         if (event.xconfigure.window == windows->image.id)            {              /*3               Image window has a new configuration.n             */1             if (event.xconfigure.send_event != 0)                {                  XWindowChanges!                   window_changes;                    /*N                   Position the transient windows relative of the Image window.                 */?                 if (windows->command.geometry == (char *) NULL)f/                   if (!windows->command.mapped)p                     {_)                       windows->command.x=lE                         event.xconfigure.x-windows->command.width-25; <                       windows->command.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->command);:                       window_changes.x=windows->command.x;:                       window_changes.y=windows->command.y;G                       XReconfigureWMWindow(display,windows->command.id,.K                         windows->command.screen,CWX | CWY,&window_changes);,                     } ?                 if (windows->magnify.geometry == (char *) NULL) /                   if (!windows->magnify.mapped)i                     { )                       windows->magnify.x= E                         event.xconfigure.x+event.xconfigure.width+25;a<                       windows->magnify.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->magnify);:                       window_changes.x=windows->magnify.x;:                       window_changes.y=windows->magnify.y;G                       XReconfigureWMWindow(display,windows->magnify.id,wK                         windows->magnify.screen,CWX | CWY,&window_changes);-                     } ;                 if (windows->pan.geometry == (char *) NULL)t+                   if (!windows->pan.mapped)+                     { %                       windows->pan.x=,E                         event.xconfigure.x+event.xconfigure.width+25; %                       windows->pan.y=wF                         event.xconfigure.y+windows->magnify.height+50;F                       XConstrainWindowPosition(display,&windows->pan);6                       window_changes.x=windows->pan.x;6                       window_changes.y=windows->pan.y;C                       XReconfigureWMWindow(display,windows->pan.id,vG                         windows->pan.screen,CWX | CWY,&window_changes);                      }                }aC             if ((event.xconfigure.width == windows->image.width) &&yC                 (event.xconfigure.height == windows->image.height))s               { C                 if (windows->image.mapped && windows->image.stasis)SJ                   XRefreshWindow(display,&windows->image,(XEvent *) NULL);                 break;               } 8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             windows->image.x=0;o             windows->image.y=0;g:             if (displayed_image->montage != (char *) NULL)               {c,                 windows->image.x=vid_info.x;,                 windows->image.y=vid_info.y;               }U?             if (windows->image.mapped && windows->image.stasis)=               {n                 /*4                   Update Image window configuration.                 */K                 windows->image.window_changes.width=event.xconfigure.width;>M                 windows->image.window_changes.height=event.xconfigure.height;*E                 (void) XConfigureImage(display,resource_info,windows,*#                   displayed_image);.               }eJ             if ((event.xconfigure.width < windows->image.ximage->width) ||J                 (event.xconfigure.height < windows->image.ximage->height))               { 4                 XMapRaised(display,windows->pan.id);3                 XDrawPanRectangle(display,windows);h               }o             else&               if (windows->pan.mapped)M                 XWithdrawWindow(display,windows->pan.id,windows->pan.screen);              break;           } ;         if (event.xconfigure.window == windows->magnify.id)0           {              unsigned int               magnify;               /*5               Magnify window has a new configuration.              */:             windows->magnify.width=event.xconfigure.width;<             windows->magnify.height=event.xconfigure.height;)             if (!windows->magnify.mapped)u               break;             magnify=1;5             while (magnify <= event.xconfigure.width)                magnify<<=1;6             while (magnify <= event.xconfigure.height)               magnify<<=1;             magnify>>=1;6             if ((magnify != event.xconfigure.width) ||5                 (magnify != event.xconfigure.height))                {--                 window_changes.width=magnify;p.                 window_changes.height=magnify;A                 XReconfigureWMWindow(display,windows->magnify.id,aN                   windows->magnify.screen,CWWidth | CWHeight,&window_changes);                 break;               }aF             status=XMakeImage(display,resource_info,&windows->magnify,N               displayed_image,windows->magnify.width,windows->magnify.height);I             status|=XMakePixmap(display,resource_info,&windows->magnify);%              if (status == False)D               Error("Unable to create magnify image",(char *) NULL);/             XMakeMagnifyImage(display,windows);              break;           } 7         if (event.xconfigure.window == windows->pan.id)            {              /*6               Pan icon window has a new configuration.             */1             if (event.xconfigure.send_event != 0)                { 2                 windows->pan.x=event.xconfigure.x;2                 windows->pan.y=event.xconfigure.y;               } 6             windows->pan.width=event.xconfigure.width;8             windows->pan.height=event.xconfigure.height;             break;           }%8         if (event.xconfigure.window == windows->icon.id)           {u             /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width;s9             windows->icon.height=event.xconfigure.height;              break;           }          break;       }o       case EnterNotify:r       {r
         /*'           Selectively install colormap.p
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) 8             XInductColormap(display,map_info->colormap);         break;       }t       case Expose:       {a!         if (resource_info->debug)g>           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y);o
         /*/           Refresh windows that are now exposed. 
         */6         if (event.xexpose.window == windows->image.id)$           if (windows->image.mapped)
             {o=               XRefreshWindow(display,&windows->image,&event);m?               timer=time((time_t *) NULL)+resource_info->delay;(               break;
             }s8         if (event.xexpose.window == windows->magnify.id)'           if (event.xexpose.count == 0)m(             if (windows->magnify.mapped)               {o3                 XMakeMagnifyImage(display,windows);y                 break;               }i4         if (event.xexpose.window == windows->pan.id)'           if (event.xexpose.count == 0)d
             {l1               XDrawPanRectangle(display,windows);p               break;
             }s5         if (event.xexpose.window == windows->icon.id)p'           if (event.xexpose.count == 0))
             {r<               XRefreshWindow(display,&windows->icon,&event);               break;
             }          break;       }l       case KeyPress:       {*         int%           length;%  
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);3         if (event.xkey.window == windows->image.id) D           loaded_image=XMagickCommand(display,resource_info,windows,:             event.xkey.state,key_symbol,&displayed_image);5         if (event.xkey.window == windows->magnify.id) <           XMagnifyWindowCommand(display,windows,key_symbol);1         if (event.xkey.window == windows->pan.id)%!           if (key_symbol == XK_q) I             XWithdrawWindow(display,windows->pan.id,windows->pan.screen);i           elseA             if ((key_symbol == XK_F1) || (key_symbol == XK_Help))IB               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Panning",ImagePanHelp);             elseA               XTranslateImage(display,windows,*image,key_symbol); 9         timer=time((time_t *) NULL)+resource_info->delay;a         break;       }o       case KeyRelease:       {s
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),n/           &key_symbol,(XComposeStatus *) NULL);o!         if (resource_info->debug) G           (void) fprintf(stderr,"Key release: 0x%lx (%c)\n",key_symbol,              *command);         break;       }        case LeaveNotify:e       {f
         /*)           Selectively uninstall colormap.f
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)n:             XUninductColormap(display,map_info->colormap);         break;       }t       case MapNotify:        {i!         if (resource_info->debug)wI           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window);t6         if (event.xmap.window == windows->backdrop.id)           {wD             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime);%*             windows->backdrop.mapped=True;             break;           }d3         if (event.xmap.window == windows->image.id)T           { 6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap);s<             if (strcmp(displayed_image->magick,"LOGO") == 0)K               loaded_image=XLoadImage(display,resource_info,windows,False);nH             if ((windows->image.width < windows->image.ximage->width) ||H                 (windows->image.height < windows->image.ximage->height))2               XMapRaised(display,windows->pan.id);'             windows->image.mapped=True;c             break;           }o5         if (event.xmap.window == windows->magnify.id)            {y/             XMakeMagnifyImage(display,windows); )             windows->magnify.mapped=True;-             break;           }l1         if (event.xmap.window == windows->pan.id)c           {wI             XMakePanImage(display,resource_info,windows,displayed_image); %             windows->pan.mapped=True;i             break;           }h2         if (event.xmap.window == windows->info.id)           {b&             windows->info.mapped=True;             break;           } 2         if (event.xmap.window == windows->icon.id)           {)             /*#               Create an icon image.(             */F             XMakeStandardColormap(display,icon_visual,&icon_resources,4               displayed_image,icon_map,&icon_pixel);E             (void) XMakeImage(display,&icon_resources,&windows->icon,nH               displayed_image,windows->icon.width,windows->icon.height);G             (void) XMakePixmap(display,&icon_resources,&windows->icon); @             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id);-&             windows->icon.mapped=True;             break;           }a5         if (event.xmap.window == windows->command.id).           {d)             windows->command.mapped=True;a             break;           }i3         if (event.xmap.window == windows->popup.id)e           {s'             windows->popup.mapped=True;i             break;           }h4         if (event.xmap.window == windows->widget.id)           {h(             windows->widget.mapped=True;             break;           }h         break;       }w       case MappingNotify:f       {o1         XRefreshKeyboardMapping(&event.xmapping);L         break;       }y       case NoExpose:         break;       case ReparentNotify:       { !         if (resource_info->debug).B           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);          break;       }        case UnmapNotify:        { !         if (resource_info->debug)eM           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window);>8         if (event.xunmap.window == windows->backdrop.id)           {>+             windows->backdrop.mapped=False;t             break;           }_5         if (event.xunmap.window == windows->image.id)s           {i(             windows->image.mapped=False;             break;           }e7         if (event.xunmap.window == windows->magnify.id)d           {s*             windows->magnify.mapped=False;             break;           }(3         if (event.xunmap.window == windows->pan.id)r           {w&             windows->pan.mapped=False;             break;           }-4         if (event.xunmap.window == windows->info.id)           {('             windows->info.mapped=False;c             break;           } 4         if (event.xunmap.window == windows->icon.id)           {i9             if (map_info->colormap == icon_map->colormap)WD               XConfigureImageColormap(display,resource_info,windows,!                 displayed_image); L             XFreeStandardColormap(display,icon_visual,icon_map,&icon_pixel);'             windows->icon.mapped=False;%             break;           } 7         if (event.xunmap.window == windows->command.id)            { *             windows->command.mapped=False;             break;           } 5         if (event.xunmap.window == windows->popup.id)            { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime); (             windows->popup.mapped=False;             break;           } 6         if (event.xunmap.window == windows->widget.id)           { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);c)             windows->widget.mapped=False;T             break;           }c       }        default:       {e!         if (resource_info->debug)o?           (void) fprintf(stderr,"Event type: %d\n",event.type);_         break;       }      }s   }i    while (!(*state & ExitState));?   if ((*state & FormerImageState) || (*state & NextImageState))      *state&=(~ExitState);    /*$     Withdraw pan and Magnify window.   */   if (windows->pan.mapped)A     XWithdrawWindow(display,windows->pan.id,windows->pan.screen);r   if (windows->magnify.mapped)I     XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);r   if (windows->command.mapped)I     XWithdrawWindow(display,windows->command.id,windows->command.screen);o   if (!resource_info->backdrop)n!     if (windows->backdrop.mapped)        {tO         XWithdrawWindow(display,windows->backdrop.id,windows->backdrop.screen);s5         XDestroyWindow(display,windows->backdrop.id);s+         windows->backdrop.id=(Window) NULL;fI         XWithdrawWindow(display,windows->image.id,windows->image.screen);f2         XDestroyWindow(display,windows->image.id);(         windows->image.id=(Window) NULL;       }d(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   if (!(*state & ExitState))     { 9       if (resource_info->write_filename != (char *) NULL) L         (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,           &displayed_image);1       XInfoWidget(display,windows,LoadImageText); ,       XCheckRefreshWindows(display,windows);     }l   else     {l       /*         Destroy X windows.       */(       for (i=0; i < number_windows; i++)       {n3         if (magick_windows[i]->id != (Window) NULL) 8           XDestroyWindow(display,magick_windows[i]->id);9         if (magick_windows[i]->ximage != (XImage *) NULL)v3           XDestroyImage(magick_windows[i]->ximage);e7         if (magick_windows[i]->pixmap != (Pixmap) NULL) 9           XFreePixmap(display,magick_windows[i]->pixmap);o       }        /*         Free Standard Colormap.        */3       if (resource_info->map_type == (char *) NULL)eH         XFreeStandardColormap(display,visual_info,map_info,&pixel_info);"       XFree((void *) class_hints);$       XFree((void *) manager_hints);"       XFree((void *) icon_visual);"       XFree((void *) visual_info);       XFree((void *) icon_map);w       XFree((void *) map_info);s)       free((char *) windows->popup.name);a*       free((char *) windows->widget.name);+       free((char *) windows->magnify.name);i.       free((char *) windows->image.icon_name);)       free((char *) windows->image.name);p       free((char *) windows);('       visual_info=(XVisualInfo *) NULL; '       if (copy_image != (Image *) NULL)I!         DestroyImage(copy_image);(     }    /*     Change to home directory.    */3   (void) getcwd(working_directory,MaxTextLength-1);e.   (void) chdir(resource_info->home_directory);   *image=displayed_image;d   return(loaded_image);o }e & /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             %CO %                                                                             % O %   X D r a w I m a g e                                                       % O %                                                                             %;O %                                                                             %nO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %P? %  Function _XDrawImage draws a line or rectangle on the image., %d, %  The format of the _XDrawImage routine is: % D %    status=_XDrawImage(display,resource_info,windows,degrees,image) % + %  A description of each parameter follows:t %lE %    o status: Function _XDrawImage return True if the image is drawnwG %      upon.  False is returned is there is a memory shortage or if thet  %      image cannot be drawn on. %wD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.r %:< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */D static unsigned int _XDrawImage(display,resource_info,windows,image) Display    *display;e  
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; {r- #define DrawImageText  "  Drawing image...  "E #define DrawModePrimitiveOp  0 #define DrawModeColorOp  1 #define DrawModeWidthOp  2 #define DrawModeUndoOp  3a #define DrawModeHelpOp  4  #define DrawModeDismissOp  50 #define Swap(x,y) ((x)^=(y), (y)^=(x), (x)^=(y))  
   static chara     *DrawModeMenu[]=     {        "Primitive",       "Color",       "Width",
       "Undo", 
       "Help",l       "Dismiss",       (char *) NULL      };     char     text[MaxTextLength];     Cursor     cursor;f     double     degrees;     int      id,e     x,     y;     RectangleInfo      rectangle_info;X     register int     i;     static unsigned int      pen_id = 0,m     primitive = LinePrimitive,     line_width = 1;      unsigned int
     distance,s     height,c     status,u
     width;     unsigned longf
     state,
     x_factor, 
     y_factor;      XDrawInfo<     draw_info;     XEvent
     event;  
   XSegment     line_info;     /*     Map Command widget.)   */   windows->command.name="Draw";a   windows->command.data=3;*   XMapRaised(display,windows->command.id);F   (void) XCommandWidget(display,windows,DrawModeMenu,(XEvent *) NULL);A   XClientMessage(display,windows->image.id,windows->im_protocols,p+     windows->im_update_widget,CurrentTime);o   /*      Wait for first button press.   */   status=True;.   cursor=XCreateFontCursor(display,XC_tcross);
   for ( ; ; )r   { 4     XQueryPosition(display,windows->image.id,&x,&y);4     XDefineCursor(display,windows->image.id,cursor);+     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     state=DefaultState;o     do     {w       if (windows->info.mapped) 	         {e           /*%             Display pointer position.            */P           (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);,           XInfoWidget(display,windows,text);	         }        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 3       if (event.xany.window == windows->command.id)s	         {            /*5             Select a command from the Command widget.            */A           id=XCommandWidget(display,windows,DrawModeMenu,&event);x           if (id < 0)              continue;_           switch (id);           {h%             case DrawModePrimitiveOp:i
             {)               char'                 command[MaxTextLength];                  static char                  *Primitives[]=                 {c                   "line",i                   "rectangle",#                   "fill rectangle",i                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */P               primitive=XMenuWidget(display,windows,DrawModeMenu[id],Primitives,                 command);o               break;
             } !             case DrawModeColorOp: 
             {l               char*                 color_name[MaxTextLength],,                 *ColorMenu[MaxNumberPens+1];                 intt                 pen_number;.                 /*+                 Initialize menu selections.;               *//               for (i=0; i < MaxNumberPens; i++) 9                 ColorMenu[i]=resource_info->pen_color[i]; 6               ColorMenu[MaxNumberPens-1]="Browser...";5               ColorMenu[MaxNumberPens]=(char *) NULL;0               /*8                 Select a pen color from the pop-up menu.               */P               pen_number=XMenuWidget(display,windows,DrawModeMenu[id],ColorMenu,                 color_name);2               if (pen_number == (MaxNumberPens-1))                 {                    static charm7                     color_name[MaxTextLength] = "gray";s                     /*5                     Select a pen color from a dialog.                    */G                   resource_info->pen_color[MaxNumberPens-1]=color_name; K                   XColorBrowserWidget(display,windows,"Select",color_name);t*                   if (*color_name == '\0')                     break;                 } "               if (pen_number >= 0)                 {                    /*"                     Set pen color.                   */$                   pen_id=pen_number;M                   (void) strcpy(color_name,resource_info->pen_color[pen_id]);;O                   status=XParseColor(display,windows->image.map_info->colormap, N                     color_name,&windows->image.pixel_info->pen_color[pen_id]);"                   if (status == 0)2                     XNoticeWidget(display,windows,A                       "Color is unknown to X server",color_name);iG                   XBestPixel(display,windows->image.map_info->colormap,-2                     (XColor *) NULL,(unsigned int)G                     Min(windows->image.visual_info->colormap_size,256),wC                     &windows->image.pixel_info->pen_color[pen_id]);d                 };               break;
             }p!             case DrawModeWidthOp: 
             {)               char'                 command[MaxTextLength];                  intE                 entry;                 static char                  *WidthsMenu[]=                 {n                   "1",                   "2",                   "4",                   "6",                   "8",                    (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               WidthsMenu[5]="Dialog...";L               entry=XMenuWidget(display,windows,DrawModeMenu[id],WidthsMenu,                 command);                if (entry < 0)                 break;               if (entry != 5)o3                 line_width=atoi(WidthsMenu[entry]);                else                 {w-                   (void) strcpy(command,"3"); I                   XDialogWidget(display,windows,"Ok","Enter line width:",                      command);f'                   if (*command == '\0')                      break;+                   line_width=atoi(command);                  }y               break;
             }               case DrawModeUndoOp:
             {)D               (void) XMagickCommand(display,resource_info,windows,0,%                 (KeySym) XK_u,image);i               break;
             }o              case DrawModeHelpOp:
             { B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);>               XDefineCursor(display,windows->image.id,cursor);               break;
             }a#             case DrawModeDismissOp:d
             {n               /*!                 Prematurely exit.g               */!               state|=EscapeState;/               state|=ExitState;o               break;
             }p             default:               break;           }e:           XDefineCursor(display,windows->image.id,cursor);           continue;c	         };       switch (event.type)p       {w         case ButtonPress: 	         {n6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }            /*             Exit loop.           */           x=event.xbutton.x;           y=event.xbutton.y;           state|=ExitState;            break;	         }g         case ButtonRelease:            break;         case Expose:           break;         case KeyPress:	         {y           char#             command[MaxTextLength];t             KeySym             key_symbol;a             /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)o           {              case XK_Escape:              case XK_F20:
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;c               state|=ExitState;                break;
             }n             case XK_F1:t             case XK_Help: 
             {(B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);               break;
             },             default:
             {                XBell(display,0);i               break;
             }            }            break;	         }x         case MotionNotify:	         {t           /*2             Discard pending pointer motion events.           */D           while (XCheckMaskEvent(display,PointerMotionMask,&event));           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)m
             {d@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height)))iO                 XWithdrawWindow(display,windows->info.id,windows->info.screen);t
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height)))<3               XMapWindow(display,windows->info.id);a           break;	         }        }y#     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id,f,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);<     if (state & EscapeState)       break;     /*K       Draw line or rectangle as pointer moves until the button is released.      */     line_info.x1=x;o     line_info.y1=y;t     line_info.x2=x;      line_info.y2=y;f     distance=0;o     degrees=0.0;     rectangle_info.x=x;C     rectangle_info.y=y;      rectangle_info.width=0;      rectangle_info.height=0;D     XSetFunction(display,windows->image.highlight_context,GXinvert);     state=DefaultState;&     do     {        switch (primitive)       {y         case LinePrimitive:          default:	         {            if (distance > 9)i
             {                /*+                 Display angle of line line.a               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2- E                 line_info.y1),(double) (line_info.x2-line_info.x1))); 3               (void) sprintf(text," %.2f",degrees); 0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,u=                 windows->image.highlight_context,&line_info); 
             }t           else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            break;	         }           case RectanglePrimitive:$         case FillRectanglePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {o               /*8                 Display info and draw drawing rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);s0               XInfoWidget(display,windows,text);9               XHighlightRegion(display,windows->image.id,KB                 windows->image.highlight_context,&rectangle_info);
             }            else%             if (windows->info.mapped)vM               XWithdrawWindow(display,windows->info.id,windows->info.screen);N           break;	         }_       }        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);        switch (primitive)       {          case LinePrimitive:a         default:	         {            if (distance > 9)e5             XHighlightLine(display,windows->image.id, ;               windows->image.highlight_context,&line_info);t           break;	         }T          case RectanglePrimitive:$         case FillRectanglePrimitive:	         {IH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))7             XHighlightRegion(display,windows->image.id,;@               windows->image.highlight_context,&rectangle_info);           break;	         }        }r       switch (event.type)        {          case ButtonPress:            break;         case ButtonRelease: 	         {t           /*,             User has committed to primitive.           */'           line_info.x2=event.xbutton.x;h'           line_info.y2=event.xbutton.y;M+           rectangle_info.x=event.xbutton.x; +           rectangle_info.y=event.xbutton.y;            state|=ExitState;w           break;	         }i         case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.            */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); '           line_info.x2=event.xmotion.x;d'           line_info.y2=event.xmotion.y; +           rectangle_info.x=event.xmotion.x;-+           rectangle_info.y=event.xmotion.y; 	         }i         default:           break;       }        /*"         Check boundary conditions.       */       if (line_info.x2 < 0)          line_info.x2=0;;
       else0         if (line_info.x2 > windows->image.width),           line_info.x2=windows->image.width;       if (line_info.y2 < 0)i         line_info.y2=0;u
       else1         if (line_info.y2 > windows->image.height)i-           line_info.y2=windows->image.height;        distance=sF         ((line_info.x2-line_info.x1+1)*(line_info.x2-line_info.x1+1))+F         ((line_info.y2-line_info.y1+1)*(line_info.y2-line_info.y1+1));A       if (((rectangle_info.x != x) && (rectangle_info.y != y)) ||*           (state & ExitState))	         {s#           if (rectangle_info.x < 0)F             rectangle_info.x=0;d           else8             if (rectangle_info.x > windows->image.width)4               rectangle_info.x=windows->image.width;#           if (rectangle_info.x < x)oE             rectangle_info.width=(unsigned int) (x-rectangle_info.x);X           else
             {oG               rectangle_info.width=(unsigned int) (rectangle_info.x-x);-!               rectangle_info.x=x;.
             }i#           if (rectangle_info.y < 0)t             rectangle_info.y=0;(           else9             if (rectangle_info.y > windows->image.height)g5               rectangle_info.y=windows->image.height;o#           if (rectangle_info.y < y) F             rectangle_info.height=(unsigned int) (y-rectangle_info.y);           else
             {eH               rectangle_info.height=(unsigned int) (rectangle_info.y-y);!               rectangle_info.y=y;.
             }o	         } #     } while (!(state & ExitState));sB     XSetFunction(display,windows->image.highlight_context,GXcopy);     if (distance <= 9)       continue;f     /*1       Drawing is relative to image configuration.T     */!     draw_info.x=rectangle_info.x;%!     draw_info.y=rectangle_info.y;%M     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_Select, 
       image);      x=0;     y=0;     width=(*image)->columns;     height=(*image)->rows;6     if (windows->image.crop_geometry != (char *) NULL)O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); 9     x_factor=UpShift(width)/windows->image.ximage->width; 4     draw_info.x+=windows->image.x-(line_width >> 1);0     draw_info.x=DownShift(draw_info.x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height; 4     draw_info.y+=windows->image.y-(line_width >> 1);0     draw_info.y=DownShift(draw_info.y*y_factor);;     draw_info.width=rectangle_info.width+(line_width << 1);e,     if (draw_info.width > (*image)->columns)(       draw_info.width=(*image)->columns;=     draw_info.height=rectangle_info.height+(line_width << 1);d*     if (draw_info.height > (*image)->rows)&       draw_info.height=(*image)->rows;4     (void) sprintf(draw_info.geometry,"%ux%u%+d%+d",9       (unsigned int) DownShift(draw_info.width*x_factor),e:       (unsigned int) DownShift(draw_info.height*y_factor),#       draw_info.x+x,draw_info.y+y); "     draw_info.primitive=primitive;+     draw_info.line_info.x1=line_width >> 1;oG     draw_info.line_info.x2=line_info.x2-line_info.x1+(line_width >> 1);w+     draw_info.line_info.y1=line_width >> 1;oG     draw_info.line_info.y2=line_info.y2-line_info.y1+(line_width >> 1);/E     if ((draw_info.line_info.x2 < 0) && (draw_info.line_info.y2 < 0))        { 9         draw_info.line_info.x2=(-draw_info.line_info.x2);o9         draw_info.line_info.y2=(-draw_info.line_info.y2);e       } #     if (draw_info.line_info.x2 < 0)n       {M9         draw_info.line_info.x2=(-draw_info.line_info.x2);M<         Swap(draw_info.line_info.x1,draw_info.line_info.x2);       } #     if (draw_info.line_info.y2 < 0)a       { 9         draw_info.line_info.y2=(-draw_info.line_info.y2); <         Swap(draw_info.line_info.y1,draw_info.line_info.y2);       }r/     draw_info.rectangle_info.x=line_width >> 1;e/     draw_info.rectangle_info.y=line_width >> 1;d8     draw_info.rectangle_info.width=rectangle_info.width;:     draw_info.rectangle_info.height=rectangle_info.height;$     draw_info.line_width=line_width;     draw_info.degrees=0.0;.     windows->image.pixel_info->annotate_color=3       windows->image.pixel_info->pen_color[pen_id];d     /*       Draw primitive on image.     *//     XInfoWidget(display,windows,DrawImageText); *     XSetCursorState(display,windows,True);*     XCheckRefreshWindows(display,windows);K     status=XDrawImage(display,windows->image.pixel_info,&draw_info,*image); +     XSetCursorState(display,windows,False);d     /*8       Update image colormap and return to image drawing.     */B     XConfigureImageColormap(display,resource_info,windows,*image);A     (void) XConfigureImage(display,resource_info,windows,*image);m   }dA   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);(   return(status);d }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %wO %                                                                             %lO %                                                                             %>O %   X D r a w P a n R e c t a n g l e                                         %iO %                                                                             %)O %                                                                             % O %                                                                             %,O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %eK %  Function XDrawPanRectangle draws a rectangle in the pan window.  The pan J %  window displays a scaled image and the rectangle shows which portion of. %  the image is displayed in the Image window. %t2 %  The format of the XDrawPanRectangle routine is: % ' %    XDrawPanRectangle(display,windows)  % + %  A description of each parameter follows:n %yE %    o display: Specifies a connection to an X server;  returned fromt %      XOpenDisplay. %n< %    o windows: Specifies a pointer to a XWindows structure. %; %  */. static void XDrawPanRectangle(display,windows) Displaya   *display;    XWindows   *windows;t {.   unsigned long)     scale_factor;      RectangleInfo      highlight_info;e     /*2     Determine dimensions of the panning rectangle.   */   scale_factor=(unsigned long)?     (UpShift(windows->pan.width)/windows->image.ximage->width);x<   highlight_info.x=DownShift(windows->image.x*scale_factor);D   highlight_info.width=DownShift(windows->image.width*scale_factor);   scale_factor=(unsigned long)A     (UpShift(windows->pan.height)/windows->image.ximage->height); <   highlight_info.y=DownShift(windows->image.y*scale_factor);F   highlight_info.height=DownShift(windows->image.height*scale_factor);   /*"     Display the panning rectangle.   */(   XClearWindow(display,windows->pan.id);I   XHighlightRegion(display,windows->pan.id,windows->pan.annotate_context,      &highlight_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %fO %                                                                             % O %   X L o a d I m a g e                                                       %lO %                                                                             % O %                                                                             %oO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %*2 %  Function XLoadImage loads an image from a file. %o+ %  The format of the XLoadImage routine is:( %dC %    loaded_image=XLoadImage(display,resource_info,windows,command). %i+ %  A description of each parameter follows:( %dJ %    o loaded_image: Function XLoadImage returns an image if can be loaded9 %      successfully.  Otherwise a null image is returned.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %-K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %)< %    o windows: Specifies a pointer to a XWindows structure. %=K %    o command: A value other than zero indicates that the file is selected;+ %      from the command line argument list.  %S %c */? static Image *XLoadImage(display,resource_info,windows,command)) Display(   *display;e  
 XResourceInfo    *resource_info;r   XWindows   *windows;p   unsigned int
   command; {a   Imagei     *loaded_image;     ImageInfoo     image_info;   
   static chara#     filename[MaxTextLength] = "\0";      /*      Request file name from user.   */   if (!command)e8     XFileBrowserWidget(display,windows,"Load",filename);   else     { 
       char         **filelist,/         **files;  	       intp         count,         status;          register int
         i,
         j;         /*0         Select next image from the command line.       */B       status=XGetCommand(display,windows->image.id,&files,&count);       if (!status)	         { A           Warning("Unable to select image","XGetCommand failed");n!           return((Image *) NULL); 	         }h6       filelist=(char **) malloc(count*sizeof(char *));%       if (filelist == (char **) NULL) 	         {oG           Warning("Unable to select image","Memory allocation failed");o!           XFreeStringList(files);s!           return((Image *) NULL); 	         }n
       j=0;       for (i=1; i < count; i++)n         if (*files[i] != '-')f!           filelist[j++]=files[i];W        filelist[j]=(char *) NULL;J       XListBrowserWidget(display,windows,&windows->widget,filelist,"Load",*         "Select Image to Load:",filename);       free((char *) filelist);       XFreeStringList(files);      }d   if (*filename == '\0')     return((Image *) NULL);)   GetImageInfo(&image_info);.   (void) strcpy(image_info.filename,filename);   SetImageMagick(&image_info);)   if (strcmp(image_info.magick,"X") == 0))     {g
       char         seconds[MaxTextLength];e         /*8         User may want to delay the X server screen grab.       */!       (void) strcpy(seconds,"0");yI       XDialogWidget(display,windows,"Grab","Enter any delay in seconds:",e         seconds);h"       (void) sleep(atoi(seconds));     }    /*     Load the image.i   */-   XInfoWidget(display,windows,LoadImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);4   loaded_image=ReadImage(resource_info->image_info);A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);p%   if (loaded_image != (Image *) NULL)lC     XClientMessage(display,windows->image.id,windows->im_protocols, *       windows->im_next_image,CurrentTime);   else     { 
       char         *text,         **textlist;t  
       FILE         *file;  	       int 
         c;         register char          *p;S         unsigned int         length;          /*         Unknown image format.r       */(       file=(FILE *) fopen(filename,"r");        if (file == (FILE *) NULL)         return((Image *) NULL);        length=MaxTextLength;n0       text=(char *) malloc(length*sizeof(char));/       for (p=text ; text != (char *) NULL; p++)t       {          c=fgetc(file);         if (c == EOF)            break;!         if ((p-text+1) >= length).           {a             *p='\0';             length<<=1;iE             text=(char *) realloc((char *) text,length*sizeof(char)); &             if (text == (char *) NULL)               break;              p=text+strlen(text);           }          *p=(unsigned char) c;i       }a       (void) fclose(file);        if (text == (char *) NULL)         return((Image *) NULL);t       *p='\0';"       textlist=StringToList(text);%       if (textlist != (char **) NULL)n	         {n           char!             title[MaxTextLength];              register int             i;  >           (void) sprintf(title,"Unknown format: %s",filename);M           XTextViewWidget(display,resource_info,windows,True,title,textlist);;6           for (i=0; textlist[i] != (char *) NULL; i++)'             free((char *) textlist[i]); "           free((char *) textlist);	         }t       free((char *) text);     }    return(loaded_image);d }l B /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             %=O %                                                                             %yO %   X M a g i c k C o m m a n d                                               %.O %                                                                             % O %                                                                             %fO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) % I %  Function XMagickCommand makes a transform to the image or Image window): %  as specified by a user menu button or keyboard command. %r/ %  The format of the XMagickCommand routine is:  % E %    loaded_image=XMagickCommand(display,resource_info,windows,state,. %      key_symbol,image) %.+ %  A description of each parameter follows:  % G %    o loaded_image:  Function XMagickCommand returns an image when the_I %      user chooses 'Load Image' from the command menu.  Otherwise a null  %      image is returned.) % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %/< %    o windows: Specifies a pointer to a XWindows structure. %f %    o state: key mask.  % 2 %    o key_symbol: Specifies a command to perform. % G %    o image: Specifies a pointer to a Image structure;  XMagickCommandn> %      may transform the image and return a new image pointer. %W %e */L static Image *XMagickCommand(display,resource_info,windows,state,key_symbol,   image) Displayn   *display;>  
 XResourceInfoi   *resource_info;_   XWindows   *windows;    unsigned int   state;   KeySym
   key_symbol;_   Imageh
   **image; { ? #define ApplyTransformsText  "  Applying image transforms...  "t. #define BlurImageText  "  Blurring image...  "/ #define BorderImageText  "  Adding border...  "w6 #define DespeckleImageText  "  Despeckling image...  "= #define DullContrastText  "  Dulling the image contrast...  "(/ #define EdgeImageText  "  Detecting edges...  " 1 #define EmbossImageText  "  Embossing image...  "o. #define FlipImageText  "  Flipping image...  ". #define FlopImageText  "  Flopping image...  "- #define FrameImageText  "  Adding frame...  "pC #define GrayImageText  "  Converting the image colors to gray...  "wF #define HistogramEqualizeText  "  Equalizing the image histogram...  "H #define HistogramNormalizeText  "  Normalizing the image histogram...  "; #define ImageInfoText  "  Displaying image attributes...  "(; #define NegateImageText  "  Negating the image colors...  " 7 #define NoisyImageText  "  Eliminating peak noise...  " 6 #define OilPaintImageText  "  Oil painting image...  "2 #define RaiseImageText  "  Raising the image...  "7 #define SegmentImageText  "  Segmenting the image...  ",C #define SharpenContrastText  "  Sharpening the image contrast...  "w3 #define SharpenImageText  "  Sharpening image...  "p/ #define ShearImageText  "  Shearing image...  "n     typedef struct _ImageState   {t     unsigned int       width,
       height;        char       *crop_geometry;y  	     Image:
       *image;    } ImageState;      char
     *argv[5],r     geometry[MaxTextLength],$     modulate_factors[MaxTextLength];       Image      *loaded_image;     int      x,     y;  
   static char "     color[MaxTextLength] = "gray",     delta[MaxTextLength] = "",     Digits[]="01234567890";      static KeySyml     last_symbol = XK_0;s     static ImageStatei7     undo_image = {0, 0, (char *) NULL, (Image *) NULL};w     unsigned int     height,      status,t
     width;  (   XCheckRefreshWindows(display,windows);3   if ((key_symbol >= XK_0) && (key_symbol <= XK_9))      {g<       if (!((last_symbol >= XK_0) && (last_symbol <= XK_9)))	         {t           *delta='\0';#           resource_info->quantum=1;.	         }d       last_symbol=key_symbol; "       delta[strlen(delta)+1]='\0';3       delta[strlen(delta)]=Digits[key_symbol-XK_0];y)       resource_info->quantum=atoi(delta);p       return((Image *) NULL);p     }-   last_symbol=key_symbol; 6   if ((key_symbol == XK_u) || (key_symbol == XK_Undo))     {        /*+         Undo the last image transformation.+       */-       if (undo_image.image == (Image *) NULL)r	         {g           XBell(display,0);d!           return((Image *) NULL); 	         } ;       windows->image.window_changes.width=undo_image.width;x=       windows->image.window_changes.height=undo_image.height;+8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);<       windows->image.crop_geometry=undo_image.crop_geometry;       DestroyImage(*image);i       *image=undo_image.image;-       undo_image.crop_geometry=(char *) NULL;+&       undo_image.image=(Image *) NULL;        if (windows->image.orphan)         return((Image *) NULL); D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        return((Image *) NULL);i     }n   if (!(state & Mod5Mask))     switch (key_symbol)      {x       case XK_Up:p       case XK_KP_Up:       case XK_Down:x       case XK_KP_Down:       case XK_Left:e       case XK_KP_Left:       case XK_Right:       case XK_KP_Right:        {y          if (!(state & Mod1Mask))           break;       }        case XK_F3:|       case XK_F5:n       case XK_A:       case XK_less:        case XK_o:       case XK_greater:       case XK_percent:       case XK_t:       case XK_bracketright:(       case XK_minus:       case XK_bar:       case XK_slash:       case XK_backslash:       case XK_asterisk:        case XK_F6:.       case XK_asciitilde:        case XK_equal:       case XK_N:       case XK_F7:        case XK_F8:t       case XK_F9:d       case XK_g:       case XK_F10:       case XK_F11:       case XK_D:       case XK_P:       case XK_S:       case XK_B:       case XK_E:       case XK_M:       case XK_O:       case XK_asciicircum:       case XK_Z:       case XK_G:       case XK_numbersign:d       case XK_R:       case XK_a:       case XK_b:       case XK_F:       case XK_x:       case XK_exclam:        case XK_Select:        {.
         /*+           Save image before transformation. 
         */.         XSetCursorState(display,windows,True);.         XCheckRefreshWindows(display,windows);6         undo_image.width=windows->image.ximage->width;8         undo_image.height=windows->image.ximage->height;6         if (undo_image.crop_geometry != (char *) NULL)2           free((char *) undo_image.crop_geometry);>         undo_image.crop_geometry=windows->image.crop_geometry;:         if (windows->image.crop_geometry != (char *) NULL)           {g-             undo_image.crop_geometry=(char *)x1               malloc(MaxTextLength*sizeof(char)); :             if (undo_image.crop_geometry != (char *) NULL)5               (void) strcpy(undo_image.crop_geometry,h.                 windows->image.crop_geometry);           }a/         if (undo_image.image != (Image *) NULL) )           DestroyImage(undo_image.image);;         (*image)->orphan=True;         undo_image.image=aB           CopyImage(*image,(*image)->columns,(*image)->rows,True);         (*image)->orphan=False; /         XSetCursorState(display,windows,False);          break;       }h       default:         break;     }o   /*     Process user command.n   */   argv[0]=client_name;   loaded_image=(Image *) NULL;C   windows->image.window_changes.width=windows->image.ximage->width;eE   windows->image.window_changes.height=windows->image.ximage->height;    switch (key_symbol)(   {w     case XK_l:     {.       /*         Load image.y       */C       loaded_image=XLoadImage(display,resource_info,windows,False);i       break;     }d     case XK_n:     case XK_space:     {        /*         Display next image.d       */E       XClientMessage(display,windows->image.id,windows->im_protocols,w,         windows->im_next_image,CurrentTime);       break;     }i     case XK_f:     case XK_KP_Prior:      case XK_BackSpace:     {        /*         Display former image.r       */E       XClientMessage(display,windows->image.id,windows->im_protocols,f.         windows->im_former_image,CurrentTime);       break;     }      case XK_F2:      {e       /*         Select image.a       */2       (void) chdir(resource_info->home_directory);B       loaded_image=XLoadImage(display,resource_info,windows,True);       break;     }h     case XK_s:     {p       /*         Save image.t       */=       status=XSaveImage(display,resource_info,windows,image);i       if (status == False)	         {oC           XNoticeWidget(display,windows,"Unable to write X image:",               (*image)->filename);           break;	         }        break;     }e     case XK_p:     {&       /*         Print image.       */>       status=XPrintImage(display,resource_info,windows,image);       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to print X image:",               (*image)->filename);           break;	         }%       break;     }%     case XK_Delete:%     {        static char '         filename[MaxTextLength] = "\0";          /*         Delete image file.       */<       XFileBrowserWidget(display,windows,"Delete",filename);       if (*filename == '\0')         break;       status=unlink(filename);       if (status != False)O         XNoticeWidget(display,windows,"Unable to delete image file:",filename);        break;     }      case XK_C:     {        ImageInfo          image_info;          static char &         color[MaxTextLength] = "gray",,         geometry[MaxTextLength] = "640x480";         /*'         Query user for canvas geometry.%       */P       XDialogWidget(display,windows,"Canvas","Enter canvas geometry:",geometry);       if (*geometry == '\0')         break;:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')s         break;       /*         Create canvas.       */        GetImageInfo(&image_info);8       (void) sprintf(image_info.filename,"xc:%s",color);       image_info.size=geometry; *       loaded_image=ReadImage(&image_info);)       free((char *) image_info.filename);;E       XClientMessage(display,windows->image.id,windows->im_protocols,e,         windows->im_next_image,CurrentTime);       break;     }      case XK_comma:     {i       static char #         delay[MaxTextLength] = "5";o         /*)         Display next image after pausing.        */       resource_info->delay=0;(1       XDialogWidget(display,windows,"Slide Show",d8         "Pause how many seconds between images:",delay);       if (*delay == '\0')          break;'       resource_info->delay=atoi(delay);"E       XClientMessage(display,windows->image.id,windows->im_protocols,f,         windows->im_next_image,CurrentTime);       break;     }s     case XK_V:     {c       /*         Visual Image directory.H       */H       loaded_image=XVisualDirectoryImage(display,resource_info,windows);       break;     }      case XK_F3:      {i       /*         Cut image.       */=       (void) XCutImage(display,resource_info,windows,*image);        break;     }i     case XK_F4:d     {        /*         Copy image._       */>       (void) XCopyImage(display,resource_info,windows,*image);       break;     }t     case XK_F5:n     {i       /*         Paste image.       */?       status=XPasteImage(display,resource_info,windows,*image);        if (status == False)	         { B           XNoticeWidget(display,windows,"Unable to paste X image",              (*image)->filename);           break;	         }        break;     }n     case XK_at:;     {iC       (void) XConfigureImage(display,resource_info,windows,*image);d       break;     },     case XK_F12:     {        /*         Set user preferences.        */?       (void) XPreferencesWidget(display,resource_info,windows);o       break;     }_     case XK_A:     {+
       char&         image_geometry[MaxTextLength];  <       if ((windows->image.crop_geometry == (char *) NULL) &&@           ((*image)->columns == windows->image.ximage->width) &&>           ((*image)->rows == windows->image.ximage->height) &&.           (resource_info->number_colors == 0))         break;       /*'         Apply size transforms to image.r       */7       XInfoWidget(display,windows,ApplyTransformsText);i,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       /**         Crop and/or scale displayed image.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height); H       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         {p6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;,	         }        windows->image.x=0;t       windows->image.y=0; ,       if (resource_info->number_colors != 0)	         {O           /*5             Reduce the number of colors in the image.            */1           if (((*image)->class == DirectClass) |||B               ((*image)->colors > resource_info->number_colors) ||<               (resource_info->colorspace == GRAYColorspace))>             QuantizeImage(*image,resource_info->number_colors,>               resource_info->tree_depth,resource_info->dither,)               resource_info->colorspace);d           SyncImage(*image);	         }pD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_less:e     {p       /*         Half image size.       */L       windows->image.window_changes.width=windows->image.ximage->width >> 1;N       windows->image.window_changes.height=windows->image.ximage->height >> 1;C       (void) XConfigureImage(display,resource_info,windows,*image);r       break;     }      case XK_o:     {r       /*         Original image size.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_greater:     {_       /*         Double the image size.       */L       windows->image.window_changes.width=windows->image.ximage->width << 1;N       windows->image.window_changes.height=windows->image.ximage->height << 1;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }d     case XK_percent:     {d       unsigned int         height,r         width;         /*         Resize image.;       */)       width=windows->image.ximage->width; +       height=windows->image.ximage->height;;4       (void) sprintf(geometry,"%ux%u",width,height);-       XDialogWidget(display,windows,"Resize", A         "Enter resize geometry (e.g. 640x480!, 200%):",geometry);        if (*geometry == '\0')         break;2       ParseImageGeometry(geometry,&width,&height);0       windows->image.window_changes.width=width;2       windows->image.window_changes.height=height;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }i     case XK_r:     {i       /*2         Restore Image window to its original size.       */8       if ((windows->image.width == (*image)->columns) &&6           (windows->image.height == (*image)->rows) &&:           (windows->image.crop_geometry == (char *) NULL))	         {            XBell(display,0);i           break;	         } <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         { 6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;s           windows->image.x=0;)           windows->image.y=0;r	         }iD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }c     case XK_bracketleft:     {>       /*         Crop image.t       */>       (void) XCropImage(display,resource_info,windows,*image);       break;     }d     case XK_bracketright:x     {        /*         Chop image.d       */=       status=XChopImage(display,resource_info,windows,image);t       if (status == False)	         {d@           XNoticeWidget(display,windows,"Unable to cut X image",              (*image)->filename);           break;	         }t       break;     }e     case XK_bar:     {o       /*         Flop image scanlines.f       */1       XInfoWidget(display,windows,FlopImageText); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flop";;       MogrifyImage(resource_info->image_info,2,argv,image); E       XWithdrawWindow(display,windows->info.id,windows->info.screen);;-       XSetCursorState(display,windows,False);m8       if (windows->image.crop_geometry != (char *) NULL)	         {o           /*             Flop crop geometry.-           */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height);tJ           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,<             height,(int) (*image)->columns-(int) width-x,y);	         }e        if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);_       break;     }n     case XK_minus:     {o       /*         Flip image scanlines.        */1       XInfoWidget(display,windows,FlipImageText); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flip";;       MogrifyImage(resource_info->image_info,2,argv,image);oE       XWithdrawWindow(display,windows->info.id,windows->info.screen);>-       XSetCursorState(display,windows,False); 8       if (windows->image.crop_geometry != (char *) NULL)	         {            /*             Flip crop geometry.            */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height); J           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,:             height,x,(int) (*image)->rows-(int) height-y);	         }E        if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }o     case XK_slash:     {        /**         Rotate image 90 degrees clockwise.       */D       status=XRotateImage(display,resource_info,windows,90.0,image);       if (status == False)	         {PC           XNoticeWidget(display,windows,"Unable to rotate X image",i              (*image)->filename);           break;	         }u       break;     }g     case XK_backslash:     {        /*2         Rotate image 90 degrees counter-clockwise.       */E       status=XRotateImage(display,resource_info,windows,-90.0,image);        if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }        break;     }a     case XK_asterisk:      {i       /*         Rotate image.        */C       status=XRotateImage(display,resource_info,windows,0.0,image);w       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",e              (*image)->filename);           break;	         }t       break;     }      case XK_F6:      {c       static charm)         geometry[MaxTextLength] = "10.0";l         /*0         Query user for shear color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')t         break;N       XDialogWidget(display,windows,"Shear","Enter shear geometry:",geometry);       if (*geometry == '\0')         break;       /*         Shear image.       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image);02       XInfoWidget(display,windows,ShearImageText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";        argv[2]=color;       argv[3]="-shear";)       argv[4]=geometry; ;       MogrifyImage(resource_info->image_info,5,argv,image);fE       XWithdrawWindow(display,windows->info.id,windows->info.screen);u-       XSetCursorState(display,windows,False); <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }h     case XK_t:     {n       /*         Trim image.o       */>       status=XTrimImage(display,resource_info,windows,*image);       if (status == False)	         {.A           XNoticeWidget(display,windows,"Unable to trim X image",n              (*image)->filename);           break;	         }        break;     }g     case XK_F7:h     {n       static char.)         hue_percent[MaxTextLength] = "3";          /**         Query user for percent hue change.       */,       XDialogWidget(display,windows,"Apply",:         "Enter percent change in image hue:",hue_percent);       if (*hue_percent == '\0')d         break;       /*         Vary the image hue._       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);1       (void) strcpy(modulate_factors,"0.0,0.0,");t2       (void) strcat(modulate_factors,hue_percent);-       ModulateImage(*image,modulate_factors);t-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }s     case XK_F8:      {d       static chart1         saturation_percent[MaxTextLength] = "10";n         /*1         Query user for percent saturation change.        */,       XDialogWidget(display,windows,"Apply",H         "Enter percent change in color saturation:",saturation_percent);&       if (*saturation_percent == '\0')         break;       /*         Vary color saturation.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);-       (void) strcpy(modulate_factors,"0.0,"); 9       (void) strcat(modulate_factors,saturation_percent);s-       ModulateImage(*image,modulate_factors); -       XSetCursorState(display,windows,False);,        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }y     case XK_F9:      {        static char 0         brightness_percent[MaxTextLength] = "3";         /*1         Query user for percent brightness change.|       */,       XDialogWidget(display,windows,"Apply",H         "Enter percent change in color brightness:",brightness_percent);&       if (*brightness_percent == '\0')         break;       /*"         Vary the color brightness.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);9       (void) strcpy(modulate_factors,brightness_percent); -       ModulateImage(*image,modulate_factors); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);&       break;     }<     case XK_g:     {        static char-&         factor[MaxTextLength] = "1.6";         /*#         Query user for gamma value.        */I       XDialogWidget(display,windows,"Gamma","Enter gamma value:",factor);i       if (*factor == '\0')         break;       /*         Gamma correct image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);        GammaImage(*image,factor);-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);a       break;     }      case XK_F10:     {.       /*#         Sharpen the image contrast.n       */7       XInfoWidget(display,windows,SharpenContrastText); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);!       ContrastImage(*image,True); E       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False);o        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }      case XK_F11:     {        /*          Dull the image contrast.       */4       XInfoWidget(display,windows,DullContrastText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);"       ContrastImage(*image,False);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);_-       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }w     case XK_equal:     {f       /*4         Perform histogram equalization on the image.       */9       XInfoWidget(display,windows,HistogramEqualizeText); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       EqualizeImage(*image);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);o-       XSetCursorState(display,windows,False);y        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }a     case XK_N:     {        /*5         Perform histogram normalization on the image.        */:       XInfoWidget(display,windows,HistogramNormalizeText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       NormalizeImage(*image);mE       XWithdrawWindow(display,windows->info.id,windows->info.screen);h-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);:       break;     }      case XK_asciitilde:      {        /*         Negate colors in image.n       */3       XInfoWidget(display,windows,NegateImageText);M,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       NegateImage(*image);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);r-       XSetCursorState(display,windows,False);.        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);(       break;     }.     case XK_G:     {)       /*#         Convert image to grayscale.        */1       XInfoWidget(display,windows,GrayImageText); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);G       QuantizeImage(*image,256,8,resource_info->dither,GRAYColorspace);        SyncImage(*image);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);n-       XSetCursorState(display,windows,False);p        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);x       break;     }a     case XK_numbersign:i     {w       static char)&         colors[MaxTextLength] = "256";         /*0         Query user for maximum number of colors.       */K       XDialogWidget(display,windows,"Quantize","Maximum number of colors:",r         colors);       if (*colors == '\0')         break;       /*         Color reduce the image.W       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);7       QuantizeImage(*image,(unsigned int) atoi(colors),a0         resource_info->tree_depth,(unsigned int)I         (strchr(colors,'!') == (char *) NULL),resource_info->colorspace);o       SyncImage(*image);-       XSetCursorState(display,windows,False);u        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);u       break;     }f     case XK_D:     {_       /*         Despeckle image.       */6       XInfoWidget(display,windows,DespeckleImageText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-despeckle"; ;       MogrifyImage(resource_info->image_info,2,argv,image);tE       XWithdrawWindow(display,windows->info.id,windows->info.screen);p-       XSetCursorState(display,windows,False);;        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);u       break;     }      case XK_P:     {o       /*"         Reduce noise in the image.       */2       XInfoWidget(display,windows,NoisyImageText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-noise";y;       MogrifyImage(resource_info->image_info,2,argv,image); E       XWithdrawWindow(display,windows->info.id,windows->info.screen);%-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_S:     {        static char '         factor[MaxTextLength] = "60.0";          /*&         Query user for sharpen factor.       */.       XDialogWidget(display,windows,"Sharpen",=         "Enter the sharpening factor (0.0 - 99.9%):",factor);        if (*factor == '\0')         break;       /*          Sharpen image scanlines.       */4       XInfoWidget(display,windows,SharpenImageText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-sharpen";a       argv[2]=factor;e;       MogrifyImage(resource_info->image_info,3,argv,image);rE       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False);e        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }o     case XK_B:     {r       static charo'         factor[MaxTextLength] = "60.0";r         /*#         Query user for blur factor.        */+       XDialogWidget(display,windows,"Blur",a;         "Enter the blurring factor (0.0 - 99.9%):",factor);f       if (*factor == '\0')         break;       /*         Blur an image.       */1       XInfoWidget(display,windows,BlurImageText); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-blur";       argv[2]=factor;o;       MogrifyImage(resource_info->image_info,3,argv,image);fE       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }m     case XK_E:     {i       /*         Detect edges in image.       */1       XInfoWidget(display,windows,EdgeImageText);i,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-edge";;       MogrifyImage(resource_info->image_info,2,argv,image);wE       XWithdrawWindow(display,windows->info.id,windows->info.screen);i-       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);N       break;     }e     case XK_M:     {n       /*         Emboss image scanlines.w       */3       XInfoWidget(display,windows,EmbossImageText);p,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-emboss";;       MogrifyImage(resource_info->image_info,2,argv,image);eE       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     }t     case XK_O:     {y       /*!         OilPaint image scanlines.(       */5       XInfoWidget(display,windows,OilPaintImageText); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-paint";r;       MogrifyImage(resource_info->image_info,2,argv,image);iE       XWithdrawWindow(display,windows->info.id,windows->info.screen);)-       XSetCursorState(display,windows,False);o        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }e     case XK_asciicircum:     {a       static charf*         bevel_width[MaxTextLength] = "10";         /*#         Query user for bevel width./       */H       XDialogWidget(display,windows,"Raise","Bevel width:",bevel_width);       if (*bevel_width == '\0')o         break;       /*         Raise an image.(       */2       XInfoWidget(display,windows,RaiseImageText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);-       RaiseImage(*image,1,atoi(bevel_width));tE       XWithdrawWindow(display,windows->info.id,windows->info.screen);_-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     };     case XK_Z:     {i       static char()         threshold[MaxTextLength] = "1.5";g         /*+         Query user for smoothing threshold.        */P       XDialogWidget(display,windows,"Segment","Smoothing threshold:",threshold);       if (*threshold == '\0')a         break;       /*         Segment an image.U       */4       XInfoWidget(display,windows,SegmentImageText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);O       SegmentImage(*image,resource_info->colorspace,False,atof(threshold),1.0);        SyncImage(*image);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);a-       XSetCursorState(display,windows,False);n        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     }      case XK_R:     {n       /*D         Apply an image processing technique to a region of interest.       */<       (void) XROIImage(display,resource_info,windows,image);       break;     }      case XK_a:     {u       /*%         Annotate the image with text.;       */C       status=_XAnnotateImage(display,resource_info,windows,*image);        if (status == False)	         {eE           XNoticeWidget(display,windows,"Unable to annotate X image",n              (*image)->filename);           break;	         }o       break;     }      case XK_d:     {H       /*         Draw image.=       */>       status=_XDrawImage(display,resource_info,windows,image);       if (status == False)	         {sH           XNoticeWidget(display,windows,"Unable to draw on the X image",              (*image)->filename);           break;	         }        break;     }-     case XK_b:     {_       static char (         geometry[MaxTextLength] = "6x6";         /*1         Query user for border color and geometry.t       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0').         break;J       XDialogWidget(display,windows,"Add Border","Enter border geometry:",         geometry);       if (*geometry == '\0')         break;       /*"         Add a border to the image.       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image); 3       XInfoWidget(display,windows,BorderImageText);a,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";s       argv[2]=color;       argv[3]="-border";       argv[4]=geometry;e;       MogrifyImage(resource_info->image_info,5,argv,image);nE       XWithdrawWindow(display,windows->info.id,windows->info.screen);w-       XSetCursorState(display,windows,False); <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     }F     case XK_F:     {w       static charF(         geometry[MaxTextLength] = "6x6";         /*0         Query user for frame color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')l         break;H       XDialogWidget(display,windows,"Add Frame","Enter frame geometry:",         geometry);       if (*geometry == '\0')         break;       /*1         Surround image with an ornamental border.%       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image); 2       XInfoWidget(display,windows,FrameImageText);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-mattecolor";       argv[2]=color;       argv[3]="-frame";        argv[4]=geometry; ;       MogrifyImage(resource_info->image_info,5,argv,image); E       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False); <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }r     case XK_x:     {i       /*         Composite image.       */C       status=XCompositeImage(display,resource_info,windows,*image);i       if (status == False)	         {sF           XNoticeWidget(display,windows,"Unable to composite X image",              (*image)->filename);           break;	         }L       break;     }o     case XK_c:     {i       /*         Color edit.t       */B       status=XColorEditImage(display,resource_info,windows,image);       if (status == False)	         {aG           XNoticeWidget(display,windows,"Unable to pixel edit X image",a              (*image)->filename);           break;	         }a       break;     }      case XK_m:     {:       /*         Matte edit.n       */B       status=XMatteEditImage(display,resource_info,windows,image);       if (status == False)	         { G           XNoticeWidget(display,windows,"Unable to matte edit X image",m              (*image)->filename);           break;	         }c       break;     }*     case XK_exclam:c     {m
       char         command[MaxTextLength],v          filename[MaxTextLength];  
       FILE         *file;         /*         Edit image comment.0       */"       TemporaryFilename(filename);.       if ((*image)->comments != (char *) NULL)	         {            register char              *p;s  #           file=fopen(filename,"w"); $           if (file == (FILE *) NULL)
             {lK               XNoticeWidget(display,windows,"Unable to edit image comment",                  filename);               break;
             },5           for (p=(*image)->comments; *p != '\0'; p++).'             (void) putc((int) *p,file);.!           (void) putc('\n',file);            (void) fclose(file);	         }[5       (void) sprintf(command,EditorCommand,filename); 9       if (resource_info->editor_command != (char *) NULL) G         (void) sprintf(command,resource_info->editor_command,filename);,,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);$       status=SystemCommand(command);       if (status) N         XNoticeWidget(display,windows,"Unable to edit image comment",command);
       else	         { 1           (void) sprintf(command,"@%s",filename); '           CommentImage(*image,command); 	         }a       (void) unlink(filename);-       XSetCursorState(display,windows,False);.       break;     }"     case XK_i:     {        /*         Display image info.N       */1       XInfoWidget(display,windows,ImageInfoText);t,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);>       XDisplayImageInfo(display,resource_info,windows,*image);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);e-       XSetCursorState(display,windows,False);L       break;     }e     case XK_ampersand:     {n       /*         Background image.r       */C       status=XBackgroundImage(display,resource_info,windows,image);F       if (status == False)         break;       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);V       (*image)->orphan=False; )       if (loaded_image != (Image *) NULL) G         XClientMessage(display,windows->image.id,windows->im_protocols,".           windows->im_next_image,CurrentTime);       break;     }e     case XK_v:     { ,       XNoticeWidget(display,windows,Version,?         "Copyright 1995 E. I. du Pont de Nemours and Company");*       break;     }      case XK_h:     case XK_F1:d     case XK_Help:e     { :       XTextViewWidget(display,resource_info,windows,False,1         "Help Viewer - Display",ImageMagickHelp);y       break;     }t     case XK_q:     {K       /*         Exit program.o       */'       if (!resource_info->confirm_exit) G         XClientMessage(display,windows->image.id,windows->im_protocols,i(           windows->im_exit,CurrentTime);
       else	         {]           /*!             Confirm program exit.f           */M           status=XConfirmWidget(display,windows,"Do you really want to exit",d             client_name);d           if (status == True)eK             XClientMessage(display,windows->image.id,windows->im_protocols,s,               windows->im_exit,CurrentTime);	         }t       break;     }t     case XK_Next:      case XK_Prior:     case XK_Home:s     case XK_KP_Home:     {t9       XTranslateImage(display,windows,*image,key_symbol);n       break;     }e     case XK_Up:a     case XK_KP_Up:     case XK_Down:      case XK_KP_Down:     case XK_Left:]     case XK_KP_Left:     case XK_Right:     case XK_KP_Right:X     {        if (state & Mod1Mask) 	         {            RectangleInfoa             crop_info;             /*.             Trim one pixel from edge of image.           */           crop_info.x=0;           crop_info.y=0;7           crop_info.width=windows->image.ximage->width; 9           crop_info.height=windows->image.ximage->height; @           if ((key_symbol == XK_Up) || (key_symbol == XK_KP_Up))
             { =               if (resource_info->quantum >= crop_info.height) :                 resource_info->quantum=crop_info.height-1;7               crop_info.height-=resource_info->quantum; 
             }oD           if ((key_symbol == XK_Down) || (key_symbol == XK_KP_Down))
             { K               if (resource_info->quantum >= (crop_info.height-crop_info.y))iF                 resource_info->quantum=crop_info.height-crop_info.y-1;2               crop_info.y+=resource_info->quantum;7               crop_info.height-=resource_info->quantum;l
             } D           if ((key_symbol == XK_Left) || (key_symbol == XK_KP_Left))
             {0<               if (resource_info->quantum >= crop_info.width)9                 resource_info->quantum=crop_info.width-1; 6               crop_info.width-=resource_info->quantum;
             } F           if ((key_symbol == XK_Right) || (key_symbol == XK_KP_Right))
             {lJ               if (resource_info->quantum >= (crop_info.width-crop_info.x))E                 resource_info->quantum=crop_info.width-crop_info.x-1;T2               crop_info.x+=resource_info->quantum;6               crop_info.width-=resource_info->quantum;
             } H           if ((windows->image.x+windows->image.width) > crop_info.width)B             windows->image.x=crop_info.width-windows->image.width;J           if ((windows->image.y+windows->image.height) > crop_info.height)D             windows->image.y=crop_info.height-windows->image.height;>           XSetCropGeometry(display,windows,&crop_info,*image);>           windows->image.window_changes.width=crop_info.width;@           windows->image.window_changes.height=crop_info.height;E           XSetWindowBackgroundPixmap(display,windows->image.id,None); G           (void) XConfigureImage(display,resource_info,windows,*image);i           break;	         }N9       XTranslateImage(display,windows,*image,key_symbol);        break;     }o     case XK_Return:p     case XK_KP_Enter:(     case XK_Select:%       break;     default:     {e%       if (!IsModifierKey(key_symbol))n         XBell(display,0);e       break;     }    }    return(loaded_image);l }a ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %(O %                                                                             %oO %                                                                             %iO %   X M a g n i f y I m a g e                                                 %NO %                                                                             %tO %                                                                             %_O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c %rF %  Function XMagnifyImage magnifies portions of the image as indicatedL %  by the pointer.  The magnified portion is displayed in a separate window. %s. %  The format of the XMagnifyImage routine is: %n) %    XMagnifyImage(display,windows,event)c %r+ %  A description of each parameter follows:l %oE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %a< %    o windows: Specifies a pointer to a XWindows structure. % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.\ %v %a */0 static void XMagnifyImage(display,windows,event) Displays   *display;    XWindows   *windows;a   XEvent	   *event;  {    char     text[MaxTextLength];     register int     x,     y;     unsigned longf
     state;     /*>     Update magnified image until the mouse button is released.   */C   XDefineCursor(display,windows->image.id,windows->magnify.cursor);0   state=DefaultState;    x=event->xbutton.x;s   y=event->xbutton.y;s(   windows->magnify.x=windows->image.x+x;(   windows->magnify.y=windows->image.y+y;   do   {n     /*F       Map and unmap Info widget as text cursor crosses its boundaries.     */     if (windows->info.mapped)/       {i:         if ((x < (windows->info.x+windows->info.width)) &&9             (y < (windows->info.y+windows->info.height))) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);r       }p     else8       if ((x > (windows->info.x+windows->info.width)) ||7           (y > (windows->info.y+windows->info.height)))_-         XMapWindow(display,windows->info.id);F     if (windows->info.mapped)c       {r
         /*#           Display pointer position.w
         */N         (void) sprintf(text," %+d%+d ",windows->magnify.x,windows->magnify.y);*         XInfoWidget(display,windows,text);       }L     /*       Wait for next event.     */:     XIfEvent(display,event,XScreenEvent,(char *) windows);     switch (event->type)     {s       case ButtonPress:e         break;       case ButtonRelease:A       {a
         /*-           User has finished magnifying image.n
         */         x=event->xbutton.x;(         y=event->xbutton.y;          state|=ExitState;n         break;       };       case Expose:         break;       case MotionNotify:       { 
         /*/           Discard pending button motion events.,
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));         x=event->xmotion.x;          y=event->xmotion.y;          break;       }f       default:         break;     },     /*        Check boundary conditions.     */     if (x < 0)
       x=0;     else$       if (x >= windows->image.width)!         x=windows->image.width-1;w     if (y < 0)
       y=0;     else$      if (y >= windows->image.height)!        y=windows->image.height-1;r!   } while (!(state & ExitState));d   /*     Display magnified image.   */A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);- }_ t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %,O %                                                                             %sO %                                                                             %iO %   X M a g n i f y W i n d o w C o m m a n d                                 %nO %                                                                             %UO %                                                                             %oO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %nM %  Function XMagnifyWindowCommand moves the image within an Magnify window by , %  one pixel as specified by the key symbol. %n6 %  The format of the XMagnifyWindowCommand routine is: %m6 %    XMagnifyWindowCommand(display,windows,key_symbol) %i+ %  A description of each parameter follows:] %wD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %n< %    o windows: Specifies a pointer to a XWindows structure. %bM %    o key_symbol: Specifies a KeySym which indicates which side of the imagex %      to trim.n %y %p */= static void XMagnifyWindowCommand(display,windows,key_symbol)i Displayg   *display;    XWindows   *windows;i   KeySym
   key_symbol;b {h   /*0     User specified a magnify factor or position.   */   switch (key_symbol)e   {      case XK_q:     {sK       XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);m       break;     }      case XK_Home:f     case XK_KP_Home:     {e3       windows->magnify.x=windows->image.width >> 1;y4       windows->magnify.y=windows->image.height >> 1;       break;     }o     case XK_Left:_     case XK_KP_Left:     {n!       if (windows->magnify.x > 0)o         windows->magnify.x--;F       break;     }      case XK_Up:a     case XK_KP_Up:     {=!       if (windows->magnify.y > 0)s         windows->magnify.y--;S       break;     }r     case XK_Right:     case XK_KP_Right:n     { 8       if (windows->magnify.x < (windows->image.width-1))         windows->magnify.x++;i       break;     }a     case XK_Down:x     case XK_KP_Down:     {r9       if (windows->magnify.y < (windows->image.height-1))r         windows->magnify.y++;a       break;     }a     case XK_0:     case XK_1:     case XK_2:     case XK_3:     case XK_4:     case XK_5:     case XK_6:     case XK_7:     case XK_8:     case XK_9:     {l,       windows->magnify.data=key_symbol-XK_0;       break;     }i     case XK_KP_0:v     case XK_KP_1:,     case XK_KP_2:c     case XK_KP_3:>     case XK_KP_4:t     case XK_KP_5:n     case XK_KP_6:o     case XK_KP_7:      case XK_KP_8:=     case XK_KP_9:      {_/       windows->magnify.data=key_symbol-XK_KP_0;e       break;     }g     default:       break;   }x%   XMakeMagnifyImage(display,windows);o }  C /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %(O %                                                                             %tO %                                                                             % O %   X M a k e P a n I m a g e                                                 %nO %                                                                             %dO %                                                                             %_O %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %_M %  Function XMakePanImage creates a thumbnail of the image and displays it in_ %  the Pan icon window.a %s. %  The format of the XMakePanImage routine is: %x9 %      XMakePanImage(display,resource_info,windows,image)  %)+ %  A description of each parameter follows:g %cE %    o display: Specifies a connection to an X server;  returned fromt %      XOpenDisplay. %kK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.N %)< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.G %i %w */> static void XMakePanImage(display,resource_info,windows,image) Displayo   *display;w  
 XResourceInfo    *resource_info;t   XWindows   *windows;o   Image 	   *image;z {i   unsigned int     status;d     /*.     Create and display image for panning icon.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   windows->pan.x=windows->image.x;"   windows->pan.y=windows->image.y;>   status=XMakeImage(display,resource_info,&windows->pan,image,,     windows->pan.width,windows->pan.height);;   status|=XMakePixmap(display,resource_info,&windows->pan);t   if (status == False);     Error("Unable to create Pan icon image",(char *) NULL);nJ   XSetWindowBackgroundPixmap(display,windows->pan.id,windows->pan.pixmap);(   XClearWindow(display,windows->pan.id);%   XDrawPanRectangle(display,windows);()   XSetCursorState(display,windows,False);a }t _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             %xO %                                                                             %vO %                                                                             %cO %   X M a t t a E d i t I m a g e                                             %eO %                                                                             %aO %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %wC %  Function XMatteEditImage allows the user to interactively change-M %  the Matte channel of an image.  If the image is PseudoClass it is promoted>H %  to DirectClass before the matte information is stored.  The floodfillL %  algorithm is strongly based on a similiar algorithm in "Graphics Gems" by %  Paul Heckbert.  %L0 %  The format of the XMatteEditImage routine is: %*9 %    XMatteEditImage(display,resource_info,windows,image)i %s+ %  A description of each parameter follows:e % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.n %.< %    o windows: Specifies a pointer to a XWindows structure. %aE %    o image: Specifies a pointer to a Image structure; returned from1 %      ReadImage.a %) */  + static void MatteFloodfill(image,x,y,matte)g Image"	   *image;:   int"   x,   y;   inta   matte; {e   int 
     delta,	     skip,e
     start,     x1,*     x2;&     register RunlengthPacket     *pixel;e     register XSegment      *p;d     RunlengthPacket      target;)  
   XSegment     *segment_stack;M     /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return;r'   if ((x < 0) || (x >= image->columns))w     return;h+   target=image->pixels[y*image->columns+x];a-   if (target.index == (unsigned short) matte)c     return;i   /*     Allocate segment stack.s   */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)t     {y@       Warning("Unable to floodfill","Memory allocation failed");
       return;n     }e   /*"     Push initial segment on stack.   */   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (p > segment_stack)k   {y     /*       Pop segment off stack.     */     p--;
     x1=p->x1;k
     x2=p->x2;r     delta=p->y2;     y=p->y1+delta;     /*5       Update matte information in neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     {l/       pixel=image->pixels+(y*image->columns+x); '       if ((pixel->red != target.red) ||f+           (pixel->green != target.green) ||d)           (pixel->blue != target.blue) ||*)           (pixel->index != target.index))          break;*       pixel->index=(unsigned short) matte;     }      skip=x >= x1;o     if (!skip)       {r         start=x+1;         if (start < x1)U$           Push(y,start,x1-1,-delta);         x=x1+1;(       }i     do     {e       if (!skip)	         {.*           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x);c-             if ((pixel->red != target.red) ||.1                 (pixel->green != target.green) || /                 (pixel->blue != target.blue) ||o/                 (pixel->index != target.index))s               break;0             pixel->index=(unsigned short) matte;           }i"           Push(y,start,x-1,delta);           if (x > (x2+1))a$             Push(y,x2+1,x-1,-delta);	         }t       skip=False;e       for (x++; x <= x2 ; x++)       { 1         pixel=image->pixels+(y*image->columns+x);-)         if ((pixel->red == target.red) &&o-             (pixel->green == target.green) &&n+             (pixel->blue == target.blue) &&,+             (pixel->index == target.index))            break;       }b       start=x;     } while (x <= x2);   }d   free((char *) segment_stack);  }d  H static unsigned int XMatteEditImage(display,resource_info,windows,image) Displayd   *display;n  
 XResourceInfo)   *resource_info;w   XWindows   *windows;U   Image 
   **image; {  #define MatteEditMethodOp  0 #define MatteEditValueOp  1d #define MatteEditUndoOp  2 #define MatteEditHelpOp  3 #define MatteEditDismissOp  4r  
   static char      *MatteEditMenu[]=i     {a       "Method",        "Matte Value",
       "Undo",(
       "Help",i       "Dismiss",       (char *) NULL>     };     char     text[MaxTextLength];     Cursor     cursor;s     int>     id,>     x,
     x_offset,>     y,
     y_offset;      register int     i;     register RunlengthPacket     *p;t  
   static chart     matte[MaxTextLength] = "0";r     static unsigned intm     method = PointMethodOp;o     unsigned int     height,H
     width;     unsigned longd
     state,
     x_factor,a
     y_factor;t     XEvent
     event;     /*     Map Command widget.f   */%   windows->command.name="Matte Edit";k   windows->command.data=1;G   (void) XCommandWidget(display,windows,MatteEditMenu,(XEvent *) NULL);r*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,W+     windows->im_update_widget,CurrentTime);;   /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id,dF     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color);g2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);(   state=DefaultState;p   do   {l     if (windows->info.mapped)i       {a
         /*#           Display pointer position.i
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }r     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);.1     if (event.xany.window == windows->command.id)P       { 
         /*3           Select a command from the Command widget.t
         */@         id=XCommandWidget(display,windows,MatteEditMenu,&event);         if (id < 0)x           continue;e         switch (id)_	         {n!           case MatteEditMethodOp:s           {S             char%               command[MaxTextLength];e               static charl               *MethodMenu[]=               {r                 "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.t             */             method=wP               XMenuWidget(display,windows,MatteEditMenu[id],MethodMenu,command);<             XDefineCursor(display,windows->image.id,cursor);             break;           }t            case MatteEditValueOp:           {i             /*0               Request matte value from the user.             */N             XDialogWidget(display,windows,"Matte","Enter matte value:",matte);<             XDefineCursor(display,windows->image.id,cursor);             break;           }t           case MatteEditUndoOp:u           { B             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);b             break;           }d           case MatteEditHelpOp:m           {e@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);o             break;           }u"           case MatteEditDismissOp:           {|             /*               Prematurely exit.u             */             state|=EscapeState;d             state|=ExitState;t             break;           }t           default:             break;	         }-8         XDefineCursor(display,windows->image.id,cursor);         continue;;       }W     switch (event.type),     {g       case ButtonPress:t       {w4         if (event.xbutton.window == windows->pan.id)           {m.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }D
         /*           Update matte data.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }o       case ButtonRelease:n       {m
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image);e*         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);a         break;       }s       case Expose:         break;       case KeyPress:       {-         char!           command[MaxTextLength];r           KeySym           key_symbol;w  
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),W/           &key_symbol,(XComposeStatus *) NULL);e         switch (key_symbol)k	         {e           case XK_Escape:-           case XK_F20:           {-             /*               Prematurely exit.              */             state|=ExitState;i             break;           }a           case XK_F1:=           case XK_Help:k           {a@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);h             break;           }d           default:           {n             XBell(display,0);i             break;           }t	         }-         break;       }r       case MotionNotify:       {f
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries.o
         */!         if (windows->info.mapped)l           {n>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);p           }t         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))v1             XMapWindow(display,windows->info.id);          break;       }W       default:         break;     }      x_offset=x;e     y_offset=y;w)     if (state & UpdateConfigurationState)-       {=         inta          x,f          y;t  
         /*8           Matte edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True);          x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,_             &width,&height);=         x_factor=UpShift(width)/windows->image.ximage->width;eC         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x;n?         y_factor=UpShift(height)/windows->image.ximage->height;uC         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y;(-         if ((x_offset < 0) || (y_offset < 0))n           continue;oL         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue;_:         XPutPixel(windows->image.ximage,x_offset,y_offset,=           windows->image.pixel_info->background_color.pixel);o$         (*image)->class=DirectClass;         if (!(*image)->matte))           {x             /*$               Initialize matte data.             */             p=(*image)->pixels;w1             for (i=0; i < (*image)->packets; i++)n
             {a               p->index=Opaque;               p++;
             }o!             (*image)->matte=True;e           }_         switch (method)n	         {u           case PointMethodOp:f           default:           {-             /*=               Update matte information using point algorithm.)             */)             if (!UncompressImage(*image))-               break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset);d(             p->index=atoi(matte) & 0xff;             break;           }g           case ReplaceMethodOp:i           {y             RunlengthPacketi               target;o               /*?               Update matte information using replace algorithm.g             */             x=0;             p=(*image)->pixels;y1             for (i=0; i < (*image)->packets; i++)a
             {x               x+=(p->length+1);l=               if (x >= (y_offset*(*image)->columns+x_offset))l                 break;               p++;
             }t'             target=(*image)->pixels[i];a             p=(*image)->pixels;e1             for (i=0; i < (*image)->packets; i++)t
             {=+               if ((p->red == target.red) &&t/                   (p->green == target.green) && +                   (p->blue == target.blue))b,                 p->index=atoi(matte) & 0xff;               p++;
             }d/             state&=(~UpdateConfigurationState);f             break;           }i!           case FloodfillMethodOp:s           {n             /*A               Update matte information using floodfill algorithm.s             */)             if (!UncompressImage(*image))r               break;H             MatteFloodfill(*image,x_offset,y_offset,atoi(matte) & 0xff);/             state&=(~UpdateConfigurationState);h             break;           }d           case ResetMethodOp:            {d             /*=               Update matte information using reset algorithm.u             */             p=(*image)->pixels;g1             for (i=0; i < (*image)->packets; i++)a
             {e*               p->index=atoi(matte) & 0xff;               p++;
             } /             if ((atoi(matte) & 0xff) == Opaque)t$               (*image)->matte=False;/             state&=(~UpdateConfigurationState);;             break;           } 	         }p       }u!   } while (!(state & ExitState));nO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);sA   XWithdrawWindow(display,windows->info.id,windows->info.screen);t)   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);o }o i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %rO %                                                                             %bO %                                                                             %SO %   X P a n I m a g e                                                         %aO %                                                                             % O %                                                                             %sO %                                                                             %WO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %fH %  Function XPanImage pans the image until the mouse button is released. %w* %  The format of the XPanImage routine is: %(% %    XPanImage(display,windows,event)  % + %  A description of each parameter follows:i %.E %    o display: Specifies a connection to an X server;  returned fromI %      XOpenDisplay. %~< %    o windows: Specifies a pointer to a XWindows structure. %.H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.( %s */, static void XPanImage(display,windows,event) DisplayE   *display;    XWindows   *windows;    XEvent	   *event;  {    char     text[MaxTextLength];     Cursor     cursor;      unsigned long 
     state;     unsigned long-
     x_factor,_
     y_factor;      XRectangle
     pan_info;      /*     Define cursor.   */>   if ((windows->image.ximage->width > windows->image.width) &&>       (windows->image.ximage->height > windows->image.height))/     cursor=XCreateFontCursor(display,XC_fleur);n   else<     if (windows->image.ximage->width > windows->image.width)=       cursor=XCreateFontCursor(display,XC_sb_h_double_arrow);-     else@       if (windows->image.ximage->height > windows->image.height)?         cursor=XCreateFontCursor(display,XC_sb_v_double_arrow);u
       else3         cursor=XCreateFontCursor(display,XC_arrow); 0   XDefineCursor(display,windows->pan.id,cursor);   /*B     Pan image as pointer moves until the mouse button is released.   */   x_factor=(unsigned long)=     UpShift(windows->image.ximage->width)/windows->pan.width;f   y_factor=(unsigned long)?     UpShift(windows->image.ximage->height)/windows->pan.height;0K   pan_info.width=(unsigned short) (UpShift(windows->image.width)/x_factor); M   pan_info.height=(unsigned short) (UpShift(windows->image.height)/y_factor);o!   state=UpdateConfigurationState;M   do   {;     switch (event->type)     {        case ButtonPress:)       {o
         /*.           User choose an initial pan location.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;(         state|=UpdateConfigurationState;         break;       }n       case ButtonRelease:m       {d
         /*.           User has finished panning the image.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;4         state|=UpdateConfigurationState | ExitState;         break;       }!       case MotionNotify:       {i
         /*/           Discard pending button motion events. 
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));$         pan_info.x=event->xmotion.x;$         pan_info.y=event->xmotion.y;(         state|=UpdateConfigurationState;       }B       default:         break;     } )     if (state & UpdateConfigurationState)t       {.
         /*$           Check boundary conditions.
         */J         pan_info.x=DownShift((pan_info.x-(pan_info.width >> 1))*x_factor);         if (pan_info.x < 0)            pan_info.x=0;          elseO           if ((pan_info.x+windows->image.width) > windows->image.ximage->width) I             pan_info.x=windows->image.ximage->width-windows->image.width;oK         pan_info.y=DownShift((pan_info.y-(pan_info.height >> 1))*y_factor);d         if (pan_info.y < 0)e           pan_info.y=0;          else2           if ((pan_info.y+windows->image.height) >-                windows->image.ximage->height))K             pan_info.y=windows->image.ximage->height-windows->image.height; /         if ((windows->image.x != pan_info.x) || -             (windows->image.y != pan_info.y))m           {              /*'               Display image pan offset.m             */(             windows->image.x=pan_info.x;(             windows->image.y=pan_info.y;E             (void) sprintf(text," %ux%u%+d%+d ",windows->image.width, G               windows->image.height,windows->image.x,windows->image.y); .             XInfoWidget(display,windows,text);             /*#               Refresh Image window.              *//             XDrawPanRectangle(display,windows); D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);           }e+         state&=(~UpdateConfigurationState);        }      /*       Wait for next event.     */     if (!(state & ExitState))s<       XIfEvent(display,event,XScreenEvent,(char *) windows);!   } while (!(state & ExitState));    /*     Restore cursor.g   */=   XDefineCursor(display,windows->pan.id,windows->pan.cursor);t   XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);a }f   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %MO %                                                                             %tO %                                                                             %*O %   X P a s t e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%* % H %  Function XPasteImage pastes an image previously saved with XCopyImageI %  in the X window image at a location the user chooses with the pointer., %o, %  The format of the XPasteImage routine is: %e< %    status=XPasteImage(display,resource_info,windows,image) %*+ %  A description of each parameter follows:g %a@ %    o status: Function XPasteImage returns True if the image isI %      pasted.  False is returned is there is a memory shortage or if the   %      image fails to be pasted. % E %    o display: Specifies a connection to an X server;  returned fromh %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.S %t< %    o windows: Specifies a pointer to a XWindows structure. %rE %    o image: Specifies a pointer to a Image structure; returned frome %      ReadImage.  %  */D static unsigned int XPasteImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfoa   *resource_info;    XWindows   *windows;    Image 	   *image;  { . #define PasteImageText  "  Pasting image...  " #define PasteModeOperatorsOp  0  #define PasteModeHelpOp  1 #define PasteModeDismissOp  2   
   static char      *PasteModeMenu[]=      {        "Operator", 
       "Help",g       "Dismiss",       (char *) NULL      };     char     text[MaxTextLength];     Cursor     cursor;      Image      *paste_image;      int      id,,     x,     y;     RectangleInfo      highlight_info,      paste_info;,     static unsigned int "     operator = ReplaceCompositeOp;     unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*     Copy image.    */#   if (copy_image == (Image *) NULL)      return(False);   copy_image->orphan=True;N   paste_image=CopyImage(copy_image,copy_image->columns,copy_image->rows,True);   copy_image->orphan=False;    /*     Map Command widget.w   */    windows->command.name="Paste";   windows->command.data=1;G   (void) XCommandWidget(display,windows,PasteModeMenu,(XEvent *) NULL);)*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */)   XSetCursorState(display,windows,False);a2   XQueryPosition(display,windows->image.id,&x,&y);"   paste_info.x=windows->image.x+x;"   paste_info.y=windows->image.y+y;   paste_info.width=0;)   paste_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |t     PointerMotionMask); 0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {x     if (windows->info.mapped)d       {t
         /*#           Display pointer position.m
         */B         (void) sprintf(text," %+d%+d ",paste_info.x,paste_info.y);*         XInfoWidget(display,windows,text);       }m     highlight_info=paste_info;3     highlight_info.x=paste_info.x-windows->image.x; 3     highlight_info.y=paste_info.y-windows->image.y;>P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &highlight_info);n     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);*P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &highlight_info); 1     if (event.xany.window == windows->command.id)g       {o
         /*3           Select a command from the Command widget.f
         */@         id=XCommandWidget(display,windows,PasteModeMenu,&event);         if (id < 0)            continue;t         switch (id)u	         { $           case PasteModeOperatorsOp:           {d             char%               command[MaxTextLength];a               static charo               *OperatorMenu[]=               {o                 "over",                  "in",o                 "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",                  "difference",s                 "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */C             operator=XMenuWidget(display,windows,PasteModeMenu[id],a&               OperatorMenu,command)+1;             break;           }o           case PasteModeHelpOp:            {w@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);             break;           }m"           case PasteModeDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;d             state|=ExitState;o             break;           }            default:             break;	         }r         continue;o       }d     switch (event.type)D     {e       case ButtonPress:        { !         if (resource_info->debug)iB           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);l4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }=
         /*=           Paste rectangle is relative to image configuration.g
         */         x=0;         y=0;         width=image->columns;          height=image->rows; :         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,              &width,&height);A         scale_factor=UpShift(width)/windows->image.ximage->width; F         paste_info.width=DownShift(paste_image->columns*scale_factor);C         scale_factor=UpShift(height)/windows->image.ximage->height;tD         paste_info.height=DownShift(paste_image->rows*scale_factor);8         XDefineCursor(display,windows->image.id,cursor);6         paste_info.x=windows->image.x+event.xbutton.x;6         paste_info.y=windows->image.y+event.xbutton.y;         break;       }c       case ButtonRelease:c       {d!         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);r@         if ((paste_info.width != 0) && (paste_info.height != 0))           {              /*@               User has selected the location of the paste image.             */:             paste_info.x=windows->image.x+event.xbutton.x;:             paste_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }.         break;       }i       case Expose:         break;       case KeyPress:       {-         char!           command[MaxTextLength];u           KeySym           key_symbol;            intc           length;n  
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);d         *(command+length)='\0'; !         if (resource_info->debug)wN           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol) 	         {W           case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.n             */&             DestroyImage(paste_image);             state|=EscapeState;a             state|=ExitState;              break;           }o           case XK_F1:            case XK_Help:            {iJ             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }c           default:           {              XBell(display,0);M             break;           }d	         }          break;       }c       case MotionNotify:       {n
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)t           {;>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))aM               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }R         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);e(         paste_info.x=windows->image.x+x;(         paste_info.y=windows->image.y+y;         break;       }        default:       { !         if (resource_info->debug)u?           (void) fprintf(stderr,"Event type: %d\n",event.type);p         break;       }      }v!   } while (!(state & ExitState));e@   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);;   XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);d   if (state & EscapeState)     return(True);    /*5     Image pasting is relative to image configuration.t   */   windows->info.mapped=False;i.   XInfoWidget(display,windows,PasteImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows;d4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);g;   scale_factor=UpShift(width)/windows->image.ximage->width;e   paste_info.x+=x;4   paste_info.x=DownShift(paste_info.x*scale_factor);<   paste_info.width=DownShift(paste_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;;   paste_info.y+=y;4   paste_info.y=DownShift(paste_info.y*scale_factor);>   paste_info.height=DownShift(paste_info.height*scale_factor);   /*$     Paste image with X Image window.   */G   CompositeImage(image,operator,paste_image,paste_info.x,paste_info.y);i   DestroyImage(paste_image);)   XSetCursorState(display,windows,False);    /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image);d>   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }e   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %tO %                                                                             %iO %   X P r i n t I m a g e                                                     %wO %                                                                             %wO %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % @ %  Function XPrintImage prints an image to a Postscript printer. % , %  The format of the XPrintImage routine is: %a< %    status=XPrintImage(display,resource_info,windows,image) %c+ %  A description of each parameter follows:  % ? %    o status: Function XPrintImage return True if the image is J %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %hK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.R %n< %    o windows: Specifies a pointer to a XWindows structure. %iF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %a */D static unsigned int XPrintImage(display,resource_info,windows,image) Display    *display;_  
 XResourceInfog   *resource_info;>   XWindows   *windows;    Images
   **image; {i/ #define PrintImageText  "  Printing image...  "      char     command[MaxTextLength],      filename[MaxTextLength],     geometry[MaxTextLength];     ImageInfog     *image_info;     int      status;      /*/     Request Postscript page geometry from user.    */'   image_info=resource_info->image_info; *   (void) sprintf(geometry,PSPageGeometry);(   if (image_info->page != (char *) NULL)-     (void) strcpy(geometry,image_info->page); I   XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select", 1     "Select Postscript Page Geometry:",geometry);    if (*geometry == '\0')     return(True);o0   image_info->page=PostscriptGeometry(geometry);   /*      Request file name from user.   */(   XCheckRefreshWindows(display,windows);   TemporaryFilename(filename);@   (void) sprintf(command,resource_info->print_command,filename);B   XDialogWidget(display,windows,"Print","Print command:",command);   if (*command == '\0')      return(True);e   /*     Print image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image);o.   XInfoWidget(display,windows,PrintImageText);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);6   (void) sprintf((*image)->filename,"ps:%s",filename);'   status=WriteImage(image_info,*image); "   status&=!SystemCommand(command);   (void) unlink(filename);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);d)   XSetCursorState(display,windows,False);pM   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);h   return(status);h }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %eO %                                                                             %hO %                                                                             %LO %   X R O I I m a g e                                                         %.O %                                                                             % O %                                                                             %MO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%= %dG %  Function XROIImage applies an image processing technique to a region  %  of interest.  % * %  The format of the XROIImage routine is: % : %    status=XROIImage(display,resource_info,windows,image) % + %  A description of each parameter follows:s %y> %    o status: Function XROIImage returns True if the image isJ %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %yK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned fromm %      ReadImage.( %n %k */B static unsigned int XROIImage(display,resource_info,windows,image) Displaye   *display;i  
 XResourceInfo    *resource_info;k   XWindows   *windows;e   Image 
   **image; {y #define ApplyModeMenus  5. #define ApplyModeFileOp  0 #define ApplyModeEditOp  1$ #define ApplyModePixelTransformOp  2" #define ApplyModeColorEnhanceOp  3 #define ApplyModeEffectsOp  4  #define ApplyModeHelpOp  5 #define ApplyModeDismissOp  6s #define ROIModeHelpOp  0 #define ROIModeDismissOp  1=  
   static chary     *ROIModeMenu[]=      { 
       "Help",d       "Dismiss",       (char *) NULL,     },     *ApplyModeMenu[]=-     {P
       "File",n
       "Edit",        "Pixel Transform",       "Color Transform",       "Effects",
       "Help",        "Dismiss",       (char *) NULLf     },     *FileMenu[]=     {        "Image Info",e       (char *) NULL      },     *EditMenu[]=     { 
       "Undo",        (char *) NULLi     },     *PixelTransformMenu[]=     {c
       "Flop",o
       "Flip",        "Rotate Right",s       "Rotate Left",       (char *) NULLf     },     *ColorEnhanceMenu[]=     {r       "Hue...",x       "Saturation...",       "Brightness...",       "Gamma...",        "Spiff",
       "Dull",e       "Equalize",        "Normalize",       "Negate",o       "Grayscale",       "Quantize...",       (char *) NULLt     },     *EffectsMenu[]=>     {)       "Despeckle",       "Peak Noise",o       "Sharpen...",        "Blur...",       "Edge Detect",       "Emboss",        "Oil Painting",        "Segment",       (char *) NULLf     };  
   static char      **Menus[ApplyModeMenus]=     {N       FileMenu,v       EditMenu,t       PixelTransformMenu,n       ColorEnhanceMenu,i       EffectsMenu      };     static KeySyms     ApplyModeKeys[]=     {T       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_h, 
       XK_q     },     FileKeys[]=m     {T       XK_i,      },     EditKeys[]=-     {o       XK_u,o     },     PixelTransformKeys[]=o     {s
       XK_bar,c       XK_minus,        XK_slash,d       XK_backslash,k     },     ColorEnhanceKeys[]=d     {e       XK_F7,       XK_F8,       XK_F9,       XK_g, 
       XK_F10,n
       XK_F11,t       XK_equal,e       XK_N,h       XK_asciitilde,       XK_G,g       XK_numbersignm     },     EffectsKeys[]=     {        XK_D,s       XK_P,>       XK_S,        XK_B,w       XK_E,e       XK_M,        XK_O,;       XK_Z,o     };     static KeySymn     *Keys[ApplyModeMenus]=     {        FileKeys,        EditKeys,g       PixelTransformKeys,        ColorEnhanceKeys,p       EffectsKeys,     };     char     command[MaxTextLength],p     text[MaxTextLength];     Cursor     cursor;      intP
     entry,     id,r     x,     y;     KeySym     key_symbol;      RectangleInfoe     highlight_info, 
     roi_info;      unsigned int     height,n
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget.    */   windows->command.name="ROI";   windows->command.data=0;E   (void) XCommandWidget(display,windows,ROIModeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,l+     windows->im_update_widget,CurrentTime);o   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);    roi_info.x=windows->image.x+x;    roi_info.y=windows->image.y+y;   roi_info.width=0;w   roi_info.height=0;-   cursor=XCreateFontCursor(display,XC_fleur);oO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |d     PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)n       {m
         /*#           Display pointer position.a
         */>         (void) sprintf(text," %+d%+d ",roi_info.x,roi_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);s1     if (event.xany.window == windows->command.id)d       {d
         /*3           Select a command from the Command widget.w
         */>         id=XCommandWidget(display,windows,ROIModeMenu,&event);         if (id < 0)            continue;          switch (id) 	         {;           case ROIModeHelpOp:            { @             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);t             break;           }             case ROIModeDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;,             state|=ExitState;              break;           }s           default:             break;	         }b         continue;e       }      switch (event.type)_     {        case ButtonPress:        {s4         if (event.xbutton.window == windows->pan.id)           {;.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }m,         if (event.xbutton.button == Button1)           {              /*L               Note first corner of region of interest rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);8             roi_info.x=windows->image.x+event.xbutton.x;8             roi_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;n             break;           }          break;       }o       case Expose:         break;       case KeyPress:       {(
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {n           case XK_Escape:>           case XK_F20:           {              /*               Prematurely exit.a             */             state|=EscapeState;              state|=ExitState;              break;           }c           case XK_F1:L           case XK_Help:u           {y@             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);              break;           }m           default:           {              XBell(display,0);i             break;           }L	         }          break;       }l       case MotionNotify:       {,
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)t           {m>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))iM               XWithdrawWindow(display,windows->info.id,windows->info.screen);r           }(         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);-&         roi_info.x=windows->image.x+x;&         roi_info.y=windows->image.y+y;         break;       }        default:         break;     }d!   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);.   if (state & EscapeState)     {a       /*5         User want to exit without region of interest.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen);N"       XFreeCursor(display,cursor);       return(True);      }kB   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {f     /*I       Size rectangle as pointer moves until the mouse button is released.i     */     x=roi_info.x;,     y=roi_info.y;      roi_info.width=0;e     roi_info.height=0;     state=DefaultState;x+     XSelectInput(display,windows->image.id,o@       windows->image.attributes.event_mask | PointerMotionMask);     do     {        highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x;(3       highlight_info.y=roi_info.y-windows->image.y;cD       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*?             Display info and draw region of interest rectangle.i           */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id); L           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);e,           XInfoWidget(display,windows,text);5           XHighlightRegion(display,windows->image.id, >             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);w       /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))3         XHighlightRegion(display,windows->image.id, <           windows->image.highlight_context,&highlight_info);3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.r           */@           id=XCommandWidget(display,windows,ROIModeMenu,&event);           if (id < 0)u             continue;            switch (id)%           {%             case ROIModeHelpOp:%
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             } "             case ROIModeDismissOp:
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;n               state|=ExitState;                break;
             }              default:               break;           }%           continue;%	         }        switch (event.type)g       {          case ButtonPress:a	         { 6           if (event.xbutton.window == windows->pan.id)
             {(0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }e6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;           break;	         }          case ButtonRelease: 	         {n           /*?             User has committed to region of interest rectangle.            */6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;1           XSetCursorState(display,windows,False);u           state|=ExitState;a9           if (strcmp(windows->command.name,"Apply") == 0)a             break;(           windows->command.name="Apply";/           windows->command.data=ApplyModeMenus;nO           (void) XCommandWidget(display,windows,ApplyModeMenu,(XEvent *) NULL);            break;	         }0         case Expose:           break;         case MotionNotify:	         {p           /*1             Discard pending button motion events.d           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));[6           roi_info.x=windows->image.x+event.xmotion.x;6           roi_info.y=windows->image.y+event.xmotion.y;	         }a         default:           break;       }tJ       if (((roi_info.x != x) && (roi_info.y != y)) || (state & ExitState))	         {,           /*&             Check boundary conditions.           */           if (roi_info.x < 0)n             roi_info.x=0;r           else:             if (roi_info.x > windows->image.ximage->width)6               roi_info.x=windows->image.ximage->width;           if (roi_info.x < x)t9             roi_info.width=(unsigned int) (x-roi_info.x);E           else
             { ;               roi_info.width=(unsigned int) (roi_info.x-x);d               roi_info.x=x; 
             }d           if (roi_info.y < 0)w             roi_info.y=0;i           else;             if (roi_info.y > windows->image.ximage->height)s7               roi_info.y=windows->image.ximage->height;            if (roi_info.y < y)r:             roi_info.height=(unsigned int) (y-roi_info.y);           else
             {o<               roi_info.height=(unsigned int) (roi_info.y-y);               roi_info.y=y;g
             } 	         }r#     } while (!(state & ExitState));;+     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;      do     {        if (windows->info.mapped) 	         {/           /*%             Display pointer position.>           */L           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y); ,           XInfoWidget(display,windows,text);	         }*       highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x; 3       highlight_info.y=roi_info.y-windows->image.y; F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {v           state|=EscapeState;            state|=ExitState;            break;	         }h$       if (state & UpdateRegionState)	         { H           XSetFunction(display,windows->image.highlight_context,GXcopy);;           if ((key_symbol == XK_i) || (key_symbol == XK_u)) M             (void) XMagickCommand(display,resource_info,windows,0,key_symbol,                image);t           else
             {a               Image                  *roi_image;                  RectangleInfod                 crop_info;                 /*F                 Region of interest is relative to image configuration.               */!               crop_info=roi_info;                x=0;               y=0;&               width=(*image)->columns;$               height=(*image)->rows;@               if (windows->image.crop_geometry != (char *) NULL)I                 (void) XParseGeometry(windows->image.crop_geometry,&x,&y, "                   &width,&height);G               scale_factor=UpShift(width)/windows->image.ximage->width;                crop_info.x+=x;_>               crop_info.x=DownShift(crop_info.x*scale_factor);F               crop_info.width=DownShift(crop_info.width*scale_factor);I               scale_factor=UpShift(height)/windows->image.ximage->height;                crop_info.y+=y;e>               crop_info.y=DownShift(crop_info.y*scale_factor);H               crop_info.height=DownShift(crop_info.height*scale_factor);5               roi_image=CropImage(*image,&crop_info);c.               if (roi_image == (Image *) NULL)                 continue;                /*K                 Apply image processing technique to the region of interest.                */)               windows->image.orphan=True;aK               (void) XMagickCommand(display,resource_info,windows,Mod5Mask,m'                 key_symbol,&roi_image);=D               (void) XMagickCommand(display,resource_info,windows,0,*                 (KeySym) XK_Select,image);*               windows->image.orphan=False;A               CompositeImage(*image,ReplaceCompositeOp,roi_image,e)                 crop_info.x,crop_info.y);a&               DestroyImage(roi_image);
             } !           if (key_symbol != XK_i)s
             {o)               windows->info.mapped=False;eL               XConfigureImageColormap(display,resource_info,windows,*image);K               (void) XConfigureImage(display,resource_info,windows,*image); 
             }n0           XCheckRefreshWindows(display,windows);,           XInfoWidget(display,windows,text);J           XSetFunction(display,windows->image.highlight_context,GXinvert);&           state&=(~UpdateRegionState);	         }z1       XHighlightRegion(display,windows->image.id,_:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 3       if (event.xany.window == windows->command.id)m	         {L           /*5             Select a command from the Command widget.            */H           XSetFunction(display,windows->image.highlight_context,GXcopy);#           key_symbol=XK_VoidSymbol; B           id=XCommandWidget(display,windows,ApplyModeMenu,&event);           if (id >= 0)
             { 7               (void) strcpy(command,ApplyModeMenu[id]); +               key_symbol=ApplyModeKeys[id]; &               if (id < ApplyModeMenus)                 {=                   /*8                     Select a command from a pop-up menu.                   */P                   entry=XMenuWidget(display,windows,ApplyModeMenu[id],Menus[id],                     command); !                   if (entry >= 0)t                     {l>                       (void) strcpy(command,Menus[id][entry]);1                       key_symbol=Keys[id][entry];d                     }d                 } 
             })J           XSetFunction(display,windows->image.highlight_context,GXinvert);5           XHighlightRegion(display,windows->image.id, >             windows->image.highlight_context,&highlight_info);!           if (key_symbol == XK_h) 
             {)L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);aN               XSetFunction(display,windows->image.highlight_context,GXinvert);               continue; 
             }o!           if (key_symbol == XK_q);
             {                /*                 Exit.D               */!               state|=EscapeState;                state|=ExitState;g               continue; 
             }E*           if (key_symbol != XK_VoidSymbol)%             state|=UpdateRegionState;p           continue;:	         } 1       XHighlightRegion(display,windows->image.id,i:         windows->image.highlight_context,&highlight_info);       switch (event.type).       {          case ButtonPress:P	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; K           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) && I               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))) 
             {T3               roi_info.x=roi_info.x+roi_info.width;b4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             }aK           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) && <               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             { 3               roi_info.x=roi_info.x+roi_info.width; .               state|=UpdateConfigurationState;               break;
             } ;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) &&_;               (x > (roi_info.x+roi_info.width-RoiDelta)) &&,I               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta)))"
             {;4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             } ;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) && ;               (x > (roi_info.x+roi_info.width-RoiDelta)) &&c<               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             {..               state|=UpdateConfigurationState;               break;
             }o	         }t         case ButtonRelease:r           break;         case Expose:	         {p8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                {-1                 event.xexpose.x=highlight_info.x;W1                 event.xexpose.y=highlight_info.y;o9                 event.xexpose.width=highlight_info.width;(;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);M               }w7           if (event.xexpose.window == windows->info.id)y)             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }_         case KeyPress:	         {,           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command,eA             sizeof(command),&key_symbol,(XComposeStatus *) NULL); /           for (id=0; id < ApplyModeMenus; id++)i           { E             for (entry=0; Menus[id][entry] != (char *) NULL; entry++)l0               if (key_symbol == Keys[id][entry])                 {=+                   state|=UpdateRegionState;i                   break;                 }S*             if (state & UpdateRegionState)               break;           }i(           if (state & UpdateRegionState)             break;           switch (key_symbol)            {              case XK_Shift_L:             case XK_Shift_R:               break;             case XK_Escape:l             case XK_F20:!               state|=EscapeState;i             case XK_Return: 
             {v               state|=ExitState;)               break;
             },             case XK_F1:              case XK_Help:w
             {dL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);eN               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);3               break;
             }            }            break;	         }n         case KeyRelease:           break;         case MotionNotify:	         {c           /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));            x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped) 
             {W@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height)))nO                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }t           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height)))n3               XMapWindow(display,windows->info.id);g           break;	         }          default:           break;       }g+       if (state & UpdateConfigurationState)t	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         }.#     } while (!(state & ExitState));g!   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);e)   XSetCursorState(display,windows,False);    if (state & EscapeState)     return(True);    return(True);  }  e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             % O %                                                                             % O %                                                                             %cO %   X R o t a t e I m a g e                                                   %tO %                                                                             % O %                                                                             %xO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XRotateImage rotates the X image.  If the degrees parameterfL %  if zero, the rotation angle is computed from the slope of a line drawn by %  the user. %(- %  The format of the XRotateImage routine is:  % E %    status=XRotateImage(display,resource_info,windows,degrees,image)e %f+ %  A description of each parameter follows:s % @ %    o status: Function XRotateImage return True if the image isJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.  %&D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %nK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %f< %    o windows: Specifies a pointer to a XWindows structure. %lD %    o degrees: Specifies the number of degrees to rotate the image. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */G static unsigned int XRotateImage(display,resource_info,windows,degrees,    image) Display_   *display;   
 XResourceInfo    *resource_info;_   XWindows   *windows;    double
   degrees;   Image 
   **image; { 0 #define RotateImageText  "  Rotating image...  " #define RotateModeColorOp  0  #define RotateModeDirectionOp  1 #define RotateModeHelpOp  2  #define RotateModeDismissOp  3 #define HorizontalRotateOp  0n #define VerticalRotateOp  1   
   static char      *RotateModeMenu[]=     {s       "Pixel Color",       "Direction",
       "Help",_       "Dismiss",       (char *) NULL      };     char     text[MaxTextLength];  
   ColorPackety     background;i     double     normalized_degrees;t     Image      *rotated_image;      int      id,s     x,     y;     register int     i;     static unsigned intl#     direction = HorizontalRotateOp,_     pen_id = 0;i     unsigned int     height,r     rotations,     status,_
     width;     if (degrees == 0.0)      {        unsigned int         distance;t         unsigned longf         state;         XEvent         event;         XSegment         rotate_info;         /*         Map Command widget.        */%       windows->command.name="Rotate";g       windows->command.data=2;L       (void) XCommandWidget(display,windows,RotateModeMenu,(XEvent *) NULL);.       XMapRaised(display,windows->command.id);E       XClientMessage(display,windows->image.id,windows->im_protocols,;/         windows->im_update_widget,CurrentTime);;       /*$         Wait for first button press.       */F       XSetFunction(display,windows->image.highlight_context,GXinvert);-       XSelectInput(display,windows->image.id,aB         windows->image.attributes.event_mask | PointerMotionMask);6       XQueryPosition(display,windows->image.id,&x,&y);       rotate_info.x1=x;o       rotate_info.y1=y;        rotate_info.x2=x;S       rotate_info.y2=y;c       state=DefaultState;)       do       {o1         XHighlightLine(display,windows->image.id,+9           windows->image.highlight_context,&rotate_info);e
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows);i1         XHighlightLine(display,windows->image.id,29           windows->image.highlight_context,&rotate_info);a5         if (event.xany.window == windows->command.id))           {              /*7               Select a command from the Command widget.i             */E             id=XCommandWidget(display,windows,RotateModeMenu,&event);<             if (id < 0)r               continue;aJ             XSetFunction(display,windows->image.highlight_context,GXcopy);             switch (id)f
             {e%               case RotateModeColorOp:i               {(                 char,                   color_name[MaxTextLength],.                   *ColorMenu[MaxNumberPens+1];                   intt                   pen_number;l                   /*-                   Initialize menu selections.g                 */1                 for (i=0; i < MaxNumberPens; i++)h;                   ColorMenu[i]=resource_info->pen_color[i];e8                 ColorMenu[MaxNumberPens-1]="Browser...";7                 ColorMenu[MaxNumberPens]=(char *) NULL;*                 /*:                   Select a pen color from the pop-up menu.                 */J                 pen_number=XMenuWidget(display,windows,RotateModeMenu[id],(                   ColorMenu,color_name);4                 if (pen_number == (MaxNumberPens-1))                   {,                     static chara7                       color_name[MaxTextLength]="gray";n                       /*7                       Select a pen color from a dialog.a                     */I                     resource_info->pen_color[MaxNumberPens-1]=color_name;sM                     XColorBrowserWidget(display,windows,"Select",color_name);d,                     if (*color_name == '\0')                       break;                   } $                 if (pen_number >= 0)                   {                      /*$                       Set pen color.                     */&                     pen_id=pen_number;O                     (void) strcpy(color_name,resource_info->pen_color[pen_id]); /                     status=XParseColor(display, C                       windows->image.map_info->colormap,color_name, E                       &windows->image.pixel_info->pen_color[pen_id]); $                     if (status == 0)4                       XNoticeWidget(display,windows,C                         "Color is unknown to X server",color_name);%I                     XBestPixel(display,windows->image.map_info->colormap,e4                       (XColor *) NULL,(unsigned int)I                       Min(windows->image.visual_info->colormap_size,256), E                       &windows->image.pixel_info->pen_color[pen_id]);g                   }                  break;               } )               case RotateModeDirectionOp:s               {s                 char)                   command[MaxTextLength];                    static charn                    *Directions[]=                   { !                     "horizontal",l                     "vertical",d"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */I                 direction=XMenuWidget(display,windows,RotateModeMenu[id],n&                   Directions,command);                 break;               }n$               case RotateModeHelpOp:               {wD                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);                 break;               }s'               case RotateModeDismissOp:o               {(                 /*#                   Prematurely exit.h                 */#                 state|=EscapeState;s!                 state|=ExitState;l                 break;               }c               default:                 break;
             }%L             XSetFunction(display,windows->image.highlight_context,GXinvert);             continue;            }          switch (event.type) 	         {            case ButtonPress:            { 8             if (event.xbutton.window == windows->pan.id)               { 2                 XPanImage(display,windows,&event);2                 XInfoWidget(display,windows,text);                 break;               } J             XSetFunction(display,windows->image.highlight_context,GXcopy);             /*               Exit loop.             */+             rotate_info.x1=event.xbutton.x; +             rotate_info.y1=event.xbutton.y;%             state|=ExitState;%             break;           }%           case ButtonRelease:l             break;           case Expose:             break;           case KeyPress:           {a             char%               command[MaxTextLength];d               KeySym               key_symbol;o               /**               Respond to a user key press.             */C             (void) XLookupString((XKeyEvent *) &event.xkey,command,yC               sizeof(command),&key_symbol,(XComposeStatus *) NULL);i             switch (key_symbol) 
             {n               case XK_Escape:c               case XK_F20:               {e                 /*#                   Prematurely exit.t                 */#                 state|=EscapeState; !                 state|=ExitState;t                 break;               }d               case XK_F1:s               case XK_Help:l               {IN                 XSetFunction(display,windows->image.highlight_context,GXcopy);D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               }                default:               { !                 XBell(display,0);o                 break;               }i
             }              break;           }e           case MotionNotify:           {              /*4               Discard pending pointer motion events.             */F             while (XCheckMaskEvent(display,PointerMotionMask,&event));+             rotate_info.x1=event.xmotion.x;L+             rotate_info.y1=event.xmotion.y;l           }e	         };&         rotate_info.x2=rotate_info.x1;&         rotate_info.y2=rotate_info.y1;,         if (direction == HorizontalRotateOp)           rotate_info.x2+=32;e         else           rotate_info.y2-=32; %       } while (!(state & ExitState)); -       XSelectInput(display,windows->image.id, .         windows->image.attributes.event_mask);D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);        if (state & EscapeState)         return(True);e       /*F         Draw line as pointer moves until the mouse button is released.       */       distance=0;rF       XSetFunction(display,windows->image.highlight_context,GXinvert);       state=DefaultState;"       do       {          if (distance > 9)[           {]             /*2               Display info and draw rotation line.             */&             if (!windows->info.mapped)3               XMapWindow(display,windows->info.id);a(             (void) sprintf(text," %.2f",F               direction == VerticalRotateOp ? degrees-90.0 : degrees);.             XInfoWidget(display,windows,text);5             XHighlightLine(display,windows->image.id,r=               windows->image.highlight_context,&rotate_info);a           }n         else#           if (windows->info.mapped)nK             XWithdrawWindow(display,windows->info.id,windows->info.screen);r
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows);n         if (distance > 9)p3           XHighlightLine(display,windows->image.id,;;             windows->image.highlight_context,&rotate_info);i         switch (event.type)f	         {            case ButtonPress:e             break;           case ButtonRelease:            {              /*2               User has committed to rotation line.             */+             rotate_info.x2=event.xbutton.x;)+             rotate_info.y2=event.xbutton.y;g             state|=ExitState;(             break;           })           case Expose:             break;           case MotionNotify:           {              /*3               Discard pending button motion events.e             */E             while (XCheckMaskEvent(display,ButtonMotionMask,&event));(+             rotate_info.x2=event.xmotion.x;h+             rotate_info.y2=event.xmotion.y;)           }            default:             break;	         } 
         /*$           Check boundary conditions.
         */         if (rotate_info.x2 < 0)c           rotate_info.x2=0;(         else4           if (rotate_info.x2 > windows->image.width)0             rotate_info.x2=windows->image.width;         if (rotate_info.y2 < 0)i           rotate_info.y2=0;          else5           if (rotate_info.y2 > windows->image.height)n1             rotate_info.y2=windows->image.height;d
         /*<           Compute rotation angle from the slope of the line.
         */         degrees=0.0;         distance=rP           ((rotate_info.x2-rotate_info.x1+1)*(rotate_info.x2-rotate_info.x1+1))+P           ((rotate_info.y2-rotate_info.y1+1)*(rotate_info.y2-rotate_info.y1+1));         if (distance > 9)%C           degrees=RadiansToDegrees(-atan2((double) (rotate_info.y2- G             rotate_info.y1),(double) (rotate_info.x2-rotate_info.x1))); %       } while (!(state & ExitState)); D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen); !       windows->info.mapped=False;        if (distance <= 9)         return(True);      } $   if (direction == VerticalRotateOp)     degrees-=90.0;   if (degrees == 0.0)      return(True);    /*     Rotate image.    */   normalized_degrees=degrees; $   while (normalized_degrees < -45.0)     normalized_degrees+=360.0;;   for (rotations=0; normalized_degrees > 45.0; rotations++)c     normalized_degrees-=90.0;h    if (normalized_degrees != 0.0)O     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image);i/   XInfoWidget(display,windows,RotateImageText);g(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);N   background.red=XDownScale(windows->image.pixel_info->pen_color[pen_id].red);   background.green=nC     XDownScale(windows->image.pixel_info->pen_color[pen_id].green);eP   background.blue=XDownScale(windows->image.pixel_info->pen_color[pen_id].blue);   background.index=0;r>   rotated_image=RotateImage(*image,degrees,&background,False);A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);w&   if (rotated_image == (Image *) NULL)     return(False);   DestroyImage(*image);d   *image=rotated_image;i4   if (windows->image.crop_geometry != (char *) NULL)     {n       /*         Rotate crop geometry.t       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);n       switch (rotations % 4)       {a         default:         case 0:            break;         case 1:w	         {            /*             Rotate 90 degrees.           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",C             height,width,(int) (*image)->columns-(int) height-y,x);o           break;	         }e         case 2: 	         {a           /*             Rotate 180 degrees.l           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",7             width,height,(int) width-x,(int) height-y);m           break;	         }T         case 3:i	         {            /*             Rotate 270 degrees.            */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",?             height,width,y,(int) (*image)->rows-(int) width-x);"           break;	         }r       }      }    if (windows->image.orphan)     return(True);h    if (normalized_degrees != 0.0)     {        /*         Update image colormap.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {i           /*:             Obtain dimensions of image from crop geometry.           */C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,h             &width,&height);4           windows->image.window_changes.width=width;6           windows->image.window_changes.height=height;	         } D       XConfigureImageColormap(display,resource_info,windows,*image);     }    else9     if (((rotations % 4) == 1) || ((rotations % 4) == 3))m       {eJ         windows->image.window_changes.width=windows->image.ximage->height;J         windows->image.window_changes.height=windows->image.ximage->width;       },   /*     Update image configuration.i   */?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);t }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %sO %                                                                             %0O %                                                                             %rO %   X S a v e I m a g e                                                       %lO %                                                                             %eO %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %i0 %  Function XSaveImage saves an image to a file. % + %  The format of the XSaveImage routine is:) %L; %    status=XSaveImage(display,resource_info,windows,image)n %i+ %  A description of each parameter follows:n %.> %    o status: Function XSaveImage return True if the image isJ %      written.  False is returned is there is a memory shortage or if the %      image fails to write. %yD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.L % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.g %I %e */C static unsigned int XSaveImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfow   *resource_info;    XWindows   *windows;p   Imagea
   **image; { * #define SaveImageText  "  Save image...  "     char     filename[MaxTextLength];     ImageInfoe     *image_info;     intP     status;      register char(     *p;o     /*      Request file name from user.   */4   p=(*image)->filename+strlen((*image)->filename)-1;D   while ((p > (*image)->filename) && (*(p-1) != *BasenameSeparator))     p--;   (void) strcpy(filename,p);5   if (resource_info->write_filename != (char *) NULL)_:     (void) strcpy(filename,resource_info->write_filename);6   XFileBrowserWidget(display,windows,"Save",filename);   if (*filename == '\0')     return(True);X   if (access(filename,0) == 0)     {_       /*@         File exists-- seek user's permission before overwriting.       */B       status=XConfirmWidget(display,windows,"Overwrite",filename);       if (status == False)         return(True);_     } '   image_info=resource_info->image_info; /   (void) strcpy(image_info->filename,filename); ,   SetImageMagick(resource_info->image_info);1   if ((strcmp(image_info->magick,"JPEG") == 0) ||X.       (strcmp(image_info->magick,"JPG") == 0))     {*
       char         quality[MaxTextLength];          /*'         Request JPEG quality from user.,       */7       (void) sprintf(quality,"%u",image_info->quality);oJ       XDialogWidget(display,windows,"Save","Enter JPEG quality:",quality);       if (*quality == '\0')          return(True);_(       image_info->quality=atoi(quality);     }*0   if ((strcmp(image_info->magick,"EPS") == 0) ||/       (strcmp(image_info->magick,"PS") == 0) || .       (strcmp(image_info->magick,"PS2") == 0))     { 
       char          geometry[MaxTextLength];         /*3         Request Postscript page geometry from user.        */.       (void) sprintf(geometry,PSPageGeometry);,       if (image_info->page != (char *) NULL)1         (void) strcpy(geometry,image_info->page);mM       XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select", 5         "Select Postscript Page Geometry:",geometry);r       if (*geometry != '\0')6         image_info->page=PostscriptGeometry(geometry);     }-   /*     Write image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image);a-   XInfoWidget(display,windows,SaveImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);-   (void) strcpy((*image)->filename,filename);e'   status=WriteImage(image_info,*image); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); )   XSetCursorState(display,windows,False);_M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);m   return(status);e }f i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %sO %                                                                             % O %                                                                             %cO %   X S c r e e n E v e n t                                                   %aO %                                                                             %iO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XScreenEvent returns True if the certain events on the X servert8 %  queue is associated with the image or Magnify window. % . %  The format of the XScreenEvent function is: %W' %      XScreenEvent(display,event,data)i %e+ %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % < %    o event: Specifies a pointer to a X11 XEvent structure. %;9 %    o data: Specifies a pointer to a XWindows structure.W %e %i */+ static int XScreenEvent(display,event,data)  Displaym   *display;e   XEvent	   *event;    char   *data; {a   register int     x,     y;     register XWindowsc
     *windows;i     windows=(XWindows *) data;0   if (event->xany.window == windows->command.id)     return(True);i   switch (event->type)   {,     case ButtonPress:f     { /       if ((event->xbutton.button == Button3) &&e,           (event->xbutton.state & Mod1Mask))	         {(           /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         } 8       if (event->xbutton.window == windows->backdrop.id)D         XSetInputFocus(display,event->xbutton.window,RevertToParent,           event->xbutton.time);e       return(True);n     }n     case ButtonRelease:m     { 5       if (event->xbutton.window == windows->image.id)l$         if (windows->magnify.mapped)           {              /*%               Update magnified image.              */             x=event->xbutton.x;&             y=event->xbutton.y;f             if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;n2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1; 2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);            }-       return(True);a     }e     case ClientMessage:S     {        /*.         If client window delete message, exit.       */?       if (event->xclient.message_type != windows->wm_protocols)(         break;>       if (*event->xclient.data.l != windows->wm_delete_window)         break;7       if (event->xclient.window == windows->magnify.id) 	         { O           XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);X           return(True);l	         }_       break;     }      case Expose:     {X5       if (event->xexpose.window == windows->image.id) 	         {)8           XRefreshWindow(display,&windows->image,event);           return(True);X	         } 3       if (event->xexpose.window == windows->pan.id)v&         if (event->xexpose.count == 0)           {;/             XDrawPanRectangle(display,windows);              return(True);g           }        break;     }a     case KeyPress:     {n
       char         command[MaxTextLength];          KeySym         key_symbol;p         /*$         Respond to a user key press.       */N       (void) XLookupString((XKeyEvent *) &event->xkey,command,sizeof(command),-         &key_symbol,(XComposeStatus *) NULL);y4       if (event->xkey.window == windows->magnify.id):         XMagnifyWindowCommand(display,windows,key_symbol);       return(True);      }i     case MapNotify:(     {,4       if (event->xmap.window == windows->magnify.id)	         { -           XMakeMagnifyImage(display,windows);t'           windows->magnify.mapped=True;p           return(True);L	         } 1       if (event->xmap.window == windows->info.id)d	         { $           windows->info.mapped=True;           return(True); 	         }u       break;     }r     case MotionNotify:     { 5       if (event->xmotion.window == windows->image.id) $         if (windows->magnify.mapped)           {x             /*%               Update magnified image.              */             x=event->xmotion.x;*             y=event->xmotion.y;a             if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;f2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;w2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);y           }f       return(True);e     }s     case UnmapNotify:      {*6       if (event->xunmap.window == windows->magnify.id)	         { (           windows->magnify.mapped=False;           return(True); 	         }-3       if (event->xunmap.window == windows->info.id) 	         {c%           windows->info.mapped=False;            return(True);(	         }u       break;     }r     case KeyRelease:     case SelectionNotify:r       return(True);      default:       break;   }c   return(False); }m ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t C r o p G e o m e t r y                                           %;O %                                                                             %aO %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %uH %  Function XSetCropGeometry accepts a cropping geometry relative to theH %  Image window and translates it to a cropping geometry relative to the	 %  image._ %n1 %  The format of the XSetCropGeometry routine is:  %d6 %    XSetCropGeometry(display,windows,crop_info,image) %g+ %  A description of each parameter follows:y %sD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %d< %    o windows: Specifies a pointer to a XWindows structure. %eL %    o crop_info:  A pointer to a RectangleInfo that defines a region of the %      Image window to crop. % 7 %    o image: Specifies a pointer to a Image structure.  %a %W */= static void XSetCropGeometry(display,windows,crop_info,image). Display0   *display;o   XWindows   *windows;e  
 RectangleInfo 
   *crop_info;    Imagea	   *image;g {e   char     text[MaxTextLength];     intw     x,     y;     unsigned int     height,e
     width;     unsigned long      scale_factor;g     if (windows->info.mapped)w     {*       /*+         Display info on cropping rectangle.        */L       (void) sprintf(text," %ux%u%+d%+d",crop_info->width,crop_info->height,#         crop_info->x,crop_info->y); (       XInfoWidget(display,windows,text);     }>   /*@     Cropping geometry is relative to any previous crop geometry.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);d   else     {_       /*&         Allocate crop geometry string.       */O       windows->image.crop_geometry=(char *) malloc(MaxTextLength*sizeof(char));*8       if (windows->image.crop_geometry == (char *) NULL)<         Error("Unable to crop X image",windows->image.name);     }o   /*@     Define the crop geometry string from the cropping rectangle.   */;   scale_factor=UpShift(width)/windows->image.ximage->width;l   if (crop_info->x > 0) ,     x+=DownShift(crop_info->x*scale_factor);1   width=DownShift(crop_info->width*scale_factor);    if (width == 0)      width=1;=   scale_factor=UpShift(height)/windows->image.ximage->height;    if (crop_info->y > 0)p,     y+=DownShift(crop_info->y*scale_factor);3   height=DownShift(crop_info->height*scale_factor);(   if (height == 0)
     height=1;aN   (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,x,y); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %dO %                                                                             % O %                                                                             %oO %   X T i l e I m a g e                                                       %,O %                                                                             % O %                                                                             %iO %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XTileImage loads or deletes a selected tile from a visual G %  image directory.  The load or delete command is choosen from a menu.e %s+ %  The format of the XTileImage routine is:r %;F %    tiled_image=XTileImage(display,resource_info,windows,image,event) %s+ %  A description of each parameter follows:w %l@ %    o tiled_image:  XTileImage reads or deletes the tiled imageD %      and returns it.  A null image is returned if an error occurs. %oE %    o display: Specifies a connection to an X server;  returned fromn %      XOpenDisplay. %.K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned fromv %      ReadImage.( %dH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.e %, %x */C static Image *XTileImage(display,resource_info,windows,image,event)y Display    *display;f  
 XResourceInfoo   *resource_info;a   XWindows   *windows;r   Images	   *image;c   XEvent	   *event;) {  #define LoadVerbOp  0  #define DeleteVerbOp  1 , #define LoadVerbText  "  Loading image...  "     char     command[MaxTextLength],m     filename[MaxTextLength];     Imagea     *tiled_image;t     ints	     tile, 	     verb,      x,     y;     register chara     *p,t     *q;g     register int     i;  
   static char      *VerbMenu[]=     { 
       "Load",        "Delete",_       (char *) NULL,     };     unsigned int     height, 
     width;     unsigned long      scale_factor;m     /*:     Tile image is relative to montage image configuration.   */   x=0;   y=0;   width=image->columns;i   height=image->rows;o4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;X%   event->xbutton.x+=windows->image.x;w>   event->xbutton.x=DownShift(event->xbutton.x*scale_factor)+x;=   scale_factor=UpShift(height)/windows->image.ximage->height; %   event->xbutton.y+=windows->image.y; >   event->xbutton.y=DownShift(event->xbutton.y*scale_factor)+y;   /*L     Determine size and location of each tile in tghe visual image directory.   */   x=0;   y=0;   width=image->columns;    height=image->rows;r=   (void) XParseGeometry(image->montage,&x,&y,&width,&height);=@   tile=((event->xbutton.y-y)/height)*((image->columns-x)/width)+     (event->xbutton.x-x)/width;t   if (tile < 0)g     {        /*)         Button press is outside any tile.g       */       XBell(display,0);o       return((Image *) NULL);d     }K   /*0     Determine file name from the tile directory.   */   p=image->directory; *   for (i=tile; (i != 0) && (*p != '\0'); )   {      if (*p == '\n')d
       i--;     p++;   }v   if (*p == '\0')      {        /*)         Button press is outside any tile.4       */       XBell(display,0);s       return((Image *) NULL);m     }    /**     Select a command from the pop-up menu.   */A   verb=XMenuWidget(display,windows,"Tile Verb",VerbMenu,command);    if (verb < 0)w     return((Image *) NULL);>   q=p;&   while ((*q != '\n') && (*q != '\0'))     q++;!   (void) strncpy(filename,p,q-p);l   filename[q-p]='\0';i   /**     Perform command for the selected tile.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   tiled_image=(Image *) NULL;    switch (verb)t   {r     case DeleteVerbOp:     {i	       inte         status,t         x_offset,          y_offset;t         register RunlengthPacket         *p;g  "       if (access(filename,0) != 0)	         { O           XNoticeWidget(display,windows,"Image file does not exist:",filename);c           break;	         }T       /*         Delete tile image.       */K       status=XConfirmWidget(display,windows,"Really delete tile",filename);p       if (status == False)         break;       status=unlink(filename);       if (status != False)	         { G           XNoticeWidget(display,windows,"Unable to delete image file:",i             filename);           break;	         }l       /*-         Overwrite tile with background color..       */"       if (!UncompressImage(image))         return((Image *) NULL);(;       x_offset=width*(tile % ((image->columns-x)/width))+x;d:       y_offset=height*(tile/((image->columns-x)/width))+y;        for (y=0; y < height; y++)       {e?         p=image->pixels+((y_offset+y)*image->columns+x_offset);y!         for (x=0; x < width; x++)             *p++=(*image->pixels);       }d9       windows->image.window_changes.width=image->columns;g7       windows->image.window_changes.height=image->rows;sC       XConfigureImageColormap(display,resource_info,windows,image);pB       (void) XConfigureImage(display,resource_info,windows,image);       break;     }(     case LoadVerbOp:     {        /*         Load tile image.       */0       XInfoWidget(display,windows,LoadVerbText);,       XCheckRefreshWindows(display,windows);B       (void) strcpy(resource_info->image_info->filename,filename);7       tiled_image=ReadImage(resource_info->image_info); E       XWithdrawWindow(display,windows->info.id,windows->info.screen);i       break;     },     default:       break;   }))   XSetCursorState(display,windows,False);r   return(tiled_image); }i w /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %sO %                                                                             %nO %                                                                             %tO %   X T r a n s l a t e I m a g e                                             %sO %                                                                             % O %                                                                             %sO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%w %aG %  Function XTranslateImage translates the image within an Image windoweM %  by one pixel as specified by the key symbol.  If the image has a `montage'aM %  string the translation is respect to the width and height contained within: %  the string. %t0 %  The format of the XTranslateImage routine is: % 6 %    XTranslateImage(display,windows,image,key_symbol) % + %  A description of each parameter follows:r %mD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %c< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.u %rM %    o key_symbol: Specifies a KeySym which indicates which side of the image; %      to trim.e %g %l */= static void XTranslateImage(display,windows,image,key_symbol)r Displays   *display;_   XWindows   *windows;    Image;	   *image;    KeySym
   key_symbol;  {    char     text[MaxTextLength];     int      x,     y;     unsigned int
     x_offset,C
     y_offset;      /*)     User specified a pan position offset.    */    x_offset=windows->image.width;!   y_offset=windows->image.height; &   if (image->montage != (char *) NULL)D     (void) XParseGeometry(image->montage,&x,&y,&x_offset,&y_offset);   switch (key_symbol)d   {i     case XK_Home:      case XK_KP_Home:     {g1       windows->image.x=windows->image.width >> 1; 2       windows->image.y=windows->image.height >> 1;       break;     }      case XK_Left:      case XK_KP_Left:     {*!       windows->image.x-=x_offset;        break;     }W     case XK_Next:w     case XK_Up:t     case XK_KP_Up:     {i!       windows->image.y-=y_offset;e       break;     }w     case XK_Right:     case XK_KP_Right:;     { !       windows->image.x+=x_offset;f       break;     }r     case XK_Prior:     case XK_Down:i     case XK_KP_Down:     {d!       windows->image.y+=y_offset;        break;     }C     default:
       return;,   }w   /*     Check boundary conditions.   */   if (windows->image.x < 0)m     windows->image.x=0;    elseO     if ((windows->image.x+windows->image.width) > windows->image.ximage->width)mI       windows->image.x=windows->image.ximage->width-windows->image.width;    if (windows->image.y < 0),     windows->image.y=0;e   else2     if ((windows->image.y+windows->image.height) >'          windows->image.ximage->height)wK       windows->image.y=windows->image.ximage->height-windows->image.height;s   /*     Refresh Image window.p   */;   (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,e=     windows->image.height,windows->image.x,windows->image.y);s$   XInfoWidget(display,windows,text);(   XCheckRefreshWindows(display,windows);%   XDrawPanRectangle(display,windows);z:   XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);w }r ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             % O %                                                                             %)O %   X T r i m I m a g e                                                       % O %                                                                             % O %                                                                             %iO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) % = %  Function XTrimImage trims the edges from the Image window.w %i+ %  The format of the XTrimImage routine is:e %g; %    status=XTrimImage(display,resource_info,windows,image)) %o+ %  A description of each parameter follows:m %)? %    o status: Function XTrimImage returns True if the image is J %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.t %(D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %W< %    o windows: Specifies a pointer to a XWindows structure.< %    o windows: Specifies a pointer to a XWindows structure. %w7 %    o image: Specifies a pointer to a Image structure.l %a %i */C static unsigned int XTrimImage(display,resource_info,windows,image)y Display_   *display;*  
 XResourceInfor   *resource_info;a   XWindows   *windows;w   Imaget	   *image;  { . #define TrimImageText  "  Trimming image...  "     RectangleInfof     trim_info;     register int     x,     y;     unsigned longi     background,"
     pixel;     /*     Trim edges from image.   */(   XSetCursorState(display,windows,True);-   XInfoWidget(display,windows,TrimImageText);/(   XCheckRefreshWindows(display,windows);2   background=XGetPixel(windows->image.ximage,0,0);/   trim_info.width=windows->image.ximage->width;l2   for (x=0; x < windows->image.ximage->width; x++)   { 5     for (y=0; y < windows->image.ximage->height; y++)i     {l1       pixel=XGetPixel(windows->image.ximage,x,y);s       if (pixel != background)         break;     }a*     if (y < windows->image.ximage->height)       break;   }a   trim_info.x=x;2   if (trim_info.x == windows->image.ximage->width)     {cE       XWithdrawWindow(display,windows->info.id,windows->info.screen); -       XSetCursorState(display,windows,False);        return(False);     }w4   for (x=windows->image.ximage->width-1; x > 0; x--)   {w5     for (y=0; y < windows->image.ximage->height; y++)      {r1       pixel=XGetPixel(windows->image.ximage,x,y);n       if (pixel != background)         break;     }i*     if (y < windows->image.ximage->height)       break;   }r"   trim_info.width=x-trim_info.x+1;1   trim_info.height=windows->image.ximage->height; 3   for (y=0; y < windows->image.ximage->height; y++),   {e4     for (x=0; x < windows->image.ximage->width; x++)     {s1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     } )     if (x < windows->image.ximage->width)s       break;   }    trim_info.y=y;5   for (y=windows->image.ximage->height-1; y > 0; y--)y   {o4     for (x=0; x < windows->image.ximage->width; x++)     {n1       pixel=XGetPixel(windows->image.ximage,x,y);o       if (pixel != background)         break;     } )     if (x < windows->image.ximage->width)        break;   }i#   trim_info.height=y-trim_info.y+1;C2   if ((trim_info.width != windows->image.width) ||2       (trim_info.height != windows->image.height))     {o       /*F         Reconfigure Image window as defined by the trimming rectangle.       */9       XSetCropGeometry(display,windows,&trim_info,image);r:       windows->image.window_changes.width=trim_info.width;<       windows->image.window_changes.height=trim_info.height;B       (void) XConfigureImage(display,resource_info,windows,image);     } A   XWithdrawWindow(display,windows->info.id,windows->info.screen);()   XSetCursorState(display,windows,False);S   return(True);p }, d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %)O %                                                                             % O %                                                                             % O %   X V i s u a l D i r e c t o r y I m a g e                                 % O %                                                                             % O %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%9 %"C %  Function XVisualDirectoryImage creates a Visual Image Directory.  % 6 %  The format of the XVisualDirectoryImage routine is: %,F %    loaded_image=XVisualDirectoryImage(display,resource_info,windows) %k+ %  A description of each parameter follows:1 %-J %    o loaded_image: Function XVisualDirectoryImage returns a visual imageK %      directory if it can be created successfully.  Otherwise a null imageo %      is returned.t %sD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %iK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.g %I< %    o windows: Specifies a pointer to a XWindows structure. %m %  */B static Image *XVisualDirectoryImage(display,resource_info,windows) DisplayI   *display;p  
 XResourceInfom   *resource_info;S   XWindows   *windows;d {, #define XClientName  "montage"I #define VisualDirectoryText  "  Creating the Visual Image Directory...  "n     char     **filelist,)"     image_geometry[MaxTextLength],     *resource_value,     text[MaxTextLength],     window_id[MaxTextLength];a     Image      *image,-
     **images;      ImageInfo      local_info;m     inta     number_files;i     register int     i,     j;  
   static chard"     filename[MaxTextLength] = "*";     XMontageInfo
     vid_info;e     XResourceInfo      background_resources,s     vid_resources;  
   XrmDatabasee     resource_database;     /*      Request file name from user.   */;   XFileBrowserWidget(display,windows,"Directory",filename);    if (*filename == '\0')     return((Image *) NULL);>   /*     Expand the filename.   */,   filelist=(char **) malloc(sizeof(char *));!   if (filelist == (char **) NULL)t     {a7       Warning("Memory allocation error",(char *) NULL);        return((Image *) NULL);g     }a   number_files=1;i   filelist[0]=filename; +   ExpandFilenames(&number_files,&filelist);o   if (number_files == 0)     { 4       Warning("No image files were found",filename);       return((Image *) NULL);/     }    /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));     if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);o&       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);w       free((char *) filelist);       return((Image *) NULL);a     }    /*/     Get any Visual Image Directory X resources.    */5   resource_database=resource_info->resource_database;;!   vid_resources=(*resource_info);lH   vid_resources.background_color=XGetResourceInstance(resource_database,4     XClientName,"background",DefaultTileBackground);O   resource_value=XGetResourceClass(resource_database,XClientName,"borderWidth",      DefaultTileBorderwidth);2   vid_resources.border_width=atoi(resource_value);5   vid_resources.font=resource_info->image_info->font;*H   vid_resources.foreground_color=XGetResourceInstance(resource_database,4     XClientName,"foreground",DefaultTileForeground);F   vid_resources.image_geometry=XGetResourceInstance(resource_database,5     XClientName,"imageGeometry",DefaultTileGeometry);pC   vid_resources.matte_color=XGetResourceInstance(resource_database,i/     XClientName,"mattecolor",DefaultTileMatte);o   /*#     Set image background resources.g   */%   background_resources=vid_resources;eH   background_resources.foreground_color=resource_info->background_color;+   background_resources.window_id=window_id; K   (void) sprintf(background_resources.window_id,"0x%lx",windows->image.id); 5   background_resources.image_geometry=image_geometry;    /*/     Read each image and convert them to a tile.t   */   j=0;"   for (i=0; i < number_files; i++)   { *     XSetCursorState(display,windows,True);*     XCheckRefreshWindows(display,windows);,     local_info=(*resource_info->image_info);$     local_info.filename=filelist[i];     *local_info.magick='\0';)     if (local_info.size == (char *) NULL)i3       local_info.size=vid_resources.image_geometry;y!     image=ReadImage(&local_info);n      if (filelist[i] != filename)!       free((char *) filelist[i]);r      if (image == (Image *) NULL)       continue;i     image->scene=j;      LabelImage(image,"%f");CF     TransformImage(&image,(char *) NULL,vid_resources.image_geometry);     /*&       Center tile on the image window.     */H     (void) XDisplayBackgroundImage(display,&background_resources,image);E     (void) sprintf(text,"   Loaded %d of %d: %s   ",i+1,number_files,a       image->filename);w&     XInfoWidget(display,windows,text);*     XCheckRefreshWindows(display,windows);     images[j]=image;     j++;   }    free((char *) filelist);
   if (j == 0)c     {w0       Warning("No images were loaded",filename);       free((char *) images);       return((Image *) NULL);n     }    /*&     Create the Visual Image Directory.   */3   XInfoWidget(display,windows,VisualDirectoryText);X(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   XGetMontageInfo(&vid_info);e   vid_info.number_tiles=j;H   image=XMontageImage(display,&vid_resources,&vid_info,filename,images);)   XSetCursorState(display,windows,False);a   free((char *) images);   if (image != (Image *) NULL)C     XClientMessage(display,windows->image.id,windows->im_protocols,e*       windows->im_next_image,CurrentTime);   return(image); }n e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             % O %                                                                             %iO %   X W a r n i n g                                                           % O %                                                                             %pO %                                                                             %-O %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d %WC %  Function XWarning displays a warning message in a Notice widget.s %t) %  The format of the XWarning routine is:- %a" %      XWarning(message,qualifier) %n+ %  A description of each parameter follows:t %iG %    o message: Specifies the message to display before terminating the, %      program.v %)9 %    o qualifier: Specifies any qualifier to the message.  %  %a */' static void XWarning(message,qualifier)t char   *message,e
   *qualifier;e {h   char     text[MaxTextLength];     if (message == (char *) NULL)r     return;    (void) strcpy(text,message);   (void) strcat(text,":");0   XNoticeWidget(display,windows,text,qualifier); }a W /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %oO %                                                                             %iO %                                                                             %IO %    M a i n                                                                  %oO %                                                                             %rO %                                                                             %gO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %n %_ */ int main(argc,argv)o int;   argc;i   char	   **argv;_ {n+ #define NotInitialized  (unsigned int) (~0)m     char     *option,     *resource_value,     *server_name;X     Imagea     *image,s     *next_image;     ImageInfo      image_info;      intX     x;     register int     i,     j;     unsigned int     first_scene,     *image_marker,     image_number,s     last_scene, 
     scene;     unsigned longs
     state;     XResourceInfoa     resource_info;  
   XrmDatabasee     resource_database;     /*     Set defaults.a   */    client_name=ClientName(*argv);   display=(Display *) NULL;*   first_scene=0;F   image_marker=(unsigned int *) malloc((argc+1)*sizeof(unsigned int));,   if (image_marker == (unsigned int *) NULL)@     Error("Unable to display image","Memory allocation failed");   for (i=0; i <= argc; i++)m     image_marker[i]=argc;    image_number=0;    GetImageInfo(&image_info);   last_scene=0; '   resource_database=(XrmDatabase) NULL;    server_name=(char *) NULL;   state=DefaultState;o   /*8     Check for server name specified on the command line.   */   ExpandFilenames(&argc,&argv);m   for (i=1; i < argc; i++)   {      /*)       Check command line for server name.      */     option=argv[i];eN     if (((int) strlen(option) == 1) || ((*option != '-') && (*option != '+')))       continue;h+     if (strncmp("display",option+1,3) == 0)        {d
         /*%           User specified server name.m
         */         i++;         if (i == argc)A           Error("Missing server name on -display",(char *) NULL);          server_name=argv[i];         break;       }i(     if (strncmp("help",option+1,2) == 0)       Usage(True);   }i   /*     Open X server connection.o   */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)E     Error("Unable to connect to X server",XDisplayName(server_name));p   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);s   /*/     Get user defaults from X resource database.o   */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);m   image_info.density= M     XGetResourceClass(resource_database,client_name,"density",(char *) NULL);o   resource_value=SH     XGetResourceClass(resource_database,client_name,"interlace","none");*   image_info.interlace=UndefinedInterlace;0   if (Latin1Compare("none",resource_value) == 0)'     image_info.interlace=NoneInterlace; 0   if (Latin1Compare("line",resource_value) == 0)'     image_info.interlace=LineInterlace;r1   if (Latin1Compare("plane",resource_value) == 0)"(     image_info.interlace=PlaneInterlace;1   if (image_info.interlace == UndefinedInterlace)(:     Warning("Unrecognized interlace type",resource_value);B   image_info.page=XGetResourceClass(resource_database,client_name,"     "pageGeometry",(char *) NULL);   resource_value=aD     XGetResourceClass(resource_database,client_name,"quality","75");*   image_info.quality=atoi(resource_value);   resource_value=rG     XGetResourceClass(resource_database,client_name,"verbose","False");d,   image_info.verbose=IsTrue(resource_value);   /*     Parse command line.w   */7   for (i=1; ((i <= argc) && !(state & ExitState)); i++)*   {)     if (i < argc)        option=argv[i];e     else       if (image_number == 0)         option="logo:";>
       else         break;M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+')))d       switch (*(option+1))       {i         case 'b':e	         {e2           if (strncmp("backdrop",option+1,5) == 0)
             {e6               resource_info.backdrop=(*option == '-');               break;
             } 8           if ((strncmp("background",option+1,5) == 0) ||.               (strncmp("bg",option+1,2) == 0))
             {e;               resource_info.background_color=(char *) NULL;g!               if (*option == '-')                  {K                   i++;                    if (i == argc)H                     Error("Missing color on -background",(char *) NULL);9                   resource_info.background_color=argv[i];r                 }l               break;
             } .           if (strncmp("blur",option+1,2) == 0)
             {f!               if (*option == '-')e                 {d                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing factor on -blur",(char *) NULL);x                 }                break;
             }a-           if (strcmp("border",option+1) == 0)o
             {X!               if (*option == '-')e                 {w                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing geometry on -border",(char *) NULL);L                 }i               break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0)t
             { 7               resource_info.border_color=(char *) NULL;p!               if (*option == '-')                  {i                   i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL);g5                   resource_info.border_color=argv[i];                  }K               break;
             } 5           if (strncmp("borderwidth",option+1,7) == 0) 
             {o+               resource_info.border_width=0; !               if (*option == '-')i                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing width on -borderwidth",(char *) NULL);p;                   resource_info.border_width=atoi(argv[i]);h                 };               break;
             }_.           Error("Unrecognized option",option);           break;	         }          case 'c': 	         {s2           if (strncmp("colormap",option+1,6) == 0)
             { 5               resource_info.colormap=PrivateColormap;t!               if (*option == '-')q                 {d                   i++;                    if (i == argc)E                     Error("Missing type on -colormap",(char *) NULL);m!                   option=argv[i];l;                   resource_info.colormap=UndefinedColormap;h;                   if (Latin1Compare("private",option) == 0)n;                     resource_info.colormap=PrivateColormap;_:                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)G                     Error("Invalid colormap type on -colormap",option);+                 }h               break;
             }i0           if (strncmp("colors",option+1,7) == 0)
             { ,               resource_info.number_colors=0;!               if (*option == '-')n                 {r                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL); <                   resource_info.number_colors=atoi(argv[i]);                 }a               break;
             }(4           if (strncmp("colorspace",option+1,7) == 0)
             {X5               resource_info.colorspace=RGBColorspace;%!               if (*option == '-')e                 {f                   i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL);%!                   option=argv[i];%?                   resource_info.colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0)                     { >                       resource_info.colorspace=GRAYColorspace;6                       resource_info.number_colors=256;1                       resource_info.tree_depth=8;                      } 8                   if (Latin1Compare("ohta",option) == 0)<                     resource_info.colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0) ;                     resource_info.colorspace=RGBColorspace; 7                   if (Latin1Compare("xyz",option) == 0)%;                     resource_info.colorspace=XYZColorspace;M9                   if (Latin1Compare("ycbcr",option) == 0) =                     resource_info.colorspace=YCbCrColorspace;a7                   if (Latin1Compare("yiq",option) == 0)e;                     resource_info.colorspace=YIQColorspace;A9                   if (Latin1Compare("ypbpr",option) == 0)y=                     resource_info.colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0)o;                     resource_info.colorspace=YUVColorspace; F                   if (resource_info.colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);s                 }W               break;
             }e1           if (strncmp("comment",option+1,4) == 0)i
             {,!               if (*option == '-')t                 {p                   i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);0                 }a               break;
             }n2           if (strncmp("compress",option+1,3) == 0)
             {-!               if (*option == '-')o                 {                    i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL);(!                   option=argv[i];.D                   if (Latin1Compare("runlengthencoded",option) == 0)                     break;                   else>                     if (Latin1Compare("qencoded",option) == 0)                       break;                     elseL                       Error("Invalid compression type on -compress",option);                 }(               break;
             } 2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             {;!               if (*option == '-')w                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -crop",(char *) NULL);s                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'd':x	         { /           if (strncmp("debug",option+1,3) == 0) 
             { 3               resource_info.debug=(*option == '-');a               break;
             }*/           if (strncmp("delay",option+1,3) == 0),
             { $               resource_info.delay=0;!               if (*option == '-')=                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing seconds on -delay",(char *) NULL);)4                   resource_info.delay=atoi(argv[i]);                 }i               break;
             })1           if (strncmp("density",option+1,3) == 0)e
             { /               image_info.density=(char *) NULL;&!               if (*option == '-')a                 {/                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];                  }                break;
             } 3           if (strncmp("despeckle",option+1,3) == 0)              break;1           if (strncmp("display",option+1,3) == 0) 
             { (               server_name=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL); &                   server_name=argv[i];                 } 4               resource_info.server_name=server_name;               break;
             }%0           if (strncmp("dither",option+1,3) == 0)
             {(4               resource_info.dither=(*option == '-');               break;
             }e.           Error("Unrecognized option",option);           break;	         }o         case 'e'::	         {X.           if (strncmp("edge",option+1,2) == 0)             break;1           if (strncmp("enhance",option+1,2) == 0)              break;2           if (strncmp("equalize",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }i         case 'f': 	         {h.           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,3) == 0)
             { /               resource_info.font=(char *) NULL;o!               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);-                   resource_info.font=argv[i];i                 }.               break;
             }y8           if ((strncmp("foreground",option+1,3) == 0) ||.               (strncmp("fg",option+1,2) == 0))            {:              resource_info.foreground_color=(char *) NULL;               if (*option == '-')                {                  i++;-                  if (i == argc)-L                    Error("Missing foreground on -foreground",(char *) NULL);8                  resource_info.foreground_color=argv[i];                }               break;            }/           if (strncmp("frame",option+1,2) == 0)w
             { !               if (*option == '-')-                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing geometry on -frame",(char *) NULL);                 }:               break;
             } .           Error("Unrecognized option",option);           break;	         }a         case 'g':a	         {,/           if (strncmp("gamma",option+1,2) == 0)e
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);y                 }w               break;
             }%2           if (strncmp("geometry",option+1,2) == 0)
             { 9               resource_info.image_geometry=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing geometry on -geometry",(char *) NULL); 7                   resource_info.image_geometry=argv[i];                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)             Usage(True);.           Error("Unrecognized option",option);           break;	         }F         case 'i':g	         { 6           if (strncmp("iconGeometry",option+1,5) == 0)
             {s8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')n                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))M                     Error("Missing geometry on -iconGeometry",(char *) NULL);_6                   resource_info.icon_geometry=argv[i];                 }n               break;
             }w0           if (strncmp("iconic",option+1,5) == 0)
             {r4               resource_info.iconic=(*option == '-');               break;
             }e3           if (strncmp("immutable",option+1,5) == 0) 
             { 7               resource_info.immutable=(*option == '-');                break;
             }t3           if (strncmp("interlace",option+1,3) == 0)g
             { 1               image_info.interlace=NoneInterlace;r!               if (*option == '-')d                 {>                   i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i];=:                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace;w8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace;)9                   if (Latin1Compare("plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'l': 	         { /           if (strncmp("label",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }                break;
             }%.           Error("Unrecognized option",option);           break;	         }e         case 'm':e	         {t1           if (strncmp("magnify",option+1,3) == 0)e
             { &               resource_info.magnify=2;!               if (*option == '-')i                 {f                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing level on -magnify",(char *) NULL);:6                   resource_info.magnify=atoi(argv[i]);                 }d               break;
             }e-           if (strncmp("map",option+1,3) == 0) 
             {e3               resource_info.map_type=(char *) NULL;c!               if (*option == '-')1                 {c                   i++;                    if (i == argc)D                     Error("Missing map type on -map",(char *) NULL);1                   resource_info.map_type=argv[i];                  }o               break;
             }i,           if (strcmp("matte",option+1) == 0)             break;4           if (strncmp("mattecolor",option+1,6) == 0)
             {h6               resource_info.matte_color=(char *) NULL;!               if (*option == '-')                  {s                   i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);4                   resource_info.matte_color=argv[i];                 }u               break;
             }g2           if (strncmp("modulate",option+1,3) == 0)
             {s!               if (*option == '-'))                 {e                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing value on -modulate",(char *) NULL);                 }g               break;
             }c4           if (strncmp("monochrome",option+1,3) == 0)
             {k8               resource_info.monochrome=(*option == '-');+               if (resource_info.monochrome)e                 {-0                   resource_info.number_colors=2;-                   resource_info.tree_depth=8;;:                   resource_info.colorspace=GRAYColorspace;                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }b         case 'n': 	         {e.           if (strncmp("name",option+1,2) == 0)
             {n/               resource_info.name=(char *) NULL; !               if (*option == '-')=                 {t                   i++;                    if (i == argc)A                     Error("Missing name on -name",(char *) NULL); -                   resource_info.name=argv[i];                  }                break;
             }+0           if (strncmp("negate",option+1,2) == 0)             break;/           if (strncmp("noise",option+1,3) == 0)              break;3           if (strncmp("normalize",option+1,3) == 0)e             break;.           Error("Unrecognized option",option);           break;	         }          case 'o':a	         {a0           if (strncmp("opaque",option+1,2) == 0)
             {a!               if (*option == '-')                  {=                   i++;                    if (i == argc)D                     Error("Missing color on -opaque",(char *) NULL);                 }t               break;
             }>.           Error("Unrecognized option",option);           break;	         }          case 'p':b	         {r.           if (strncmp("page",option+1,3) == 0)
             {c,               image_info.page=(char *) NULL;!               if (*option == '-')g                 {s                   i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }f               break;
             }c-           if (strncmp("pen",option+1,2) == 0)M
             { !               if (*option == '-')                  {D                   i++;                    if (i == argc)E                     Error("Missing pen color on -pen",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }a         case 'q':r	         {c           i++;6           if ((i == argc) || !sscanf(argv[i],"%d",&x))?             Error("Missing quality on -quality",(char *) NULL); ,           image_info.quality=atoi(argv[i]);;           break;	         }          case 'r':a	         {t/           if (strncmp("raise",option+1,2) == 0)X
             {i               i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))E                 Error("Missing bevel width on -raise",(char *) NULL);o               break;
             },.           if (strncmp("roll",option+1,3) == 0)
             {s!               if (*option == '-')                  {i                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -roll",(char *) NULL);n                 }i               break;
             }s0           if (strncmp("rotate",option+1,3) == 0)
             {m!               if (*option == '-')e                 {n                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing degrees on -rotate",(char *) NULL);                 }+               break;
             }i.           Error("Unrecognized option",option);           break;	         }          case 's':.	         { 0           if (strncmp("sample",option+1,2) == 0)
             {f!               if (*option == '-')m                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing geometry on -sample",(char *) NULL);0                 }n               break;
             }n/           if (strncmp("scene",option+1,3) == 0)S
             {h               first_scene=0;               last_scene=0;t!               if (*option == '-')n                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene; J                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 }a               break;
             }a1           if (strncmp("sharpen",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing factor on -sharpen",(char *) NULL);                 }w               break;
             }a/           if (strncmp("shear",option+1,3) == 0)u
             { !               if (*option == '-')i                 {,                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))L                     Error("Missing shear geometry on -shear",(char *) NULL);                 },               break;
             }E7           if (strncmp("shared_memory",option+1,4) == 0) 
             {a?               resource_info.use_shared_memory=(*option == '-');                break;
             } .           if (strncmp("size",option+1,2) == 0)
             {t,               image_info.size=(char *) NULL;!               if (*option == '-')                  {n                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -size",(char *) NULL);n*                   image_info.size=argv[i];                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }D         case 't': 	         {m3           if (strncmp("text_font",option+1,3) == 0) 
             {b4               resource_info.text_font=(char *) NULL;!               if (*option == '-')y                 {;                   i++;                    if (i == argc)K                     Error("Missing font name on -text_font",(char *) NULL);e2                   resource_info.text_font=argv[i];                 }                break;
             }e/           if (strncmp("title",option+1,2) == 0)e
             {i0               resource_info.title=(char *) NULL;!               if (*option == '-')a                 {                    i++;                    if (i == argc)C                     Error("Missing title on -title",(char *) NULL); .                   resource_info.title=argv[i];                 }                break;
             }x5           if (strncmp("transparent",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     Error("Missing color on -transparent",(char *) NULL);w                 }                break;
             }-3           if (strncmp("treedepth",option+1,3) == 0)*
             { )               resource_info.tree_depth=0; !               if (*option == '-')                  {a                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL);M9                   resource_info.tree_depth=atoi(argv[i]);                  }e               break;
             }l.           Error("Unrecognized option",option);           break;	         }          case 'u':e	         {f0           if (strncmp("update",option+1,2) == 0)
             {n4               resource_info.update=(*option == '-');!               if (*option == '-')                  {t                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing seconds on -update",(char *) NULL);4                   resource_info.delay=atoi(argv[i]);                 }.               break;
             }d4           if (strncmp("use_pixmap",option+1,2) == 0)
             {i8               resource_info.use_pixmap=(*option == '-');               break;
             }(.           Error("Unrecognized option",option);           break;	         }+         case 'v':t	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             }t0           if (strncmp("visual",option+1,2) == 0)
             { 6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing visual class on -visual",(char *) NULL); 4                   resource_info.visual_type=argv[i];                 }a               break;
             }o.           Error("Unrecognized option",option);           break;	         }          case 'w':t	         {d0           if (strncmp("window",option+1,2) == 0)
             {i4               resource_info.window_id=(char *) NULL;!               if (*option == '-')e                 {f                   i++;                    if (i == argc)C                     Error("Missing id, name, or 'root' on -window", %                       (char *) NULL);m2                   resource_info.window_id=argv[i];                 }t               break;
             }y/           if (strncmp("write",option+1,2) == 0)c
             {i9               resource_info.write_filename=(char *) NULL;(!               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing file name on -write",(char *) NULL); 7                   resource_info.write_filename=argv[i]; B                   if (access(resource_info.write_filename,0) == 0)                     {(                       char"                         answer[2];  =                       (void) fprintf(stderr,"Overwrite %s? ",e6                         resource_info.write_filename);B                       (void) fgets(answer,sizeof(answer)-1,stdin);B                       if (!((*answer == 'y') || (*answer == 'Y')))                          exit(1);                     }a                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }*         case '?':a	         {f           Usage(True);           break;	         }          default:	         {=.           Error("Unrecognized option",option);           break;	         }        }      else<       for (scene=first_scene; scene <= last_scene ; scene++)       {m
         /*L           Option is a file name: begin by reading image from specified file.
         */2         (void) strcpy(image_info.filename,option);&         if (first_scene != last_scene)           {              char&               filename[MaxTextLength];               /*2               Form filename for multi-part images.             */?             (void) sprintf(filename,image_info.filename,scene); :             if (strcmp(filename,image_info.filename) == 0)I               (void) sprintf(filename,"%s.%u",image_info.filename,scene);e8             (void) strcpy(image_info.filename,filename);           }r0         (void) strcpy(image_info.magick,"MIFF");9         image_info.server_name=resource_info.server_name; +         image_info.font=resource_info.font;f/         image_info.dither=resource_info.dither;t7         image_info.monochrome=resource_info.monochrome; /         resource_info.image_info=(&image_info); %         image=ReadImage(&image_info);p$         if (image == (Image *) NULL)           if (i < (argc-1))              continue;e           else
             {                state|=ExitState;                break;
             }a
         do	         {            /*J             Transmogrify image as defined by the image processing options.           */"           resource_info.quantum=1;2           MogrifyImage(&image_info,i,argv,&image);(           if (first_scene != last_scene)             image->scene=scene;p           /*&             Display image to X server.           */7           if (resource_info.window_id != (char *) NULL)o
             {S               unsigned int                 status;(                 /*6                 Display image to a specified X window.               */K               status=XDisplayBackgroundImage(display,&resource_info,image);                if (status) )                 state|=RetainColorsState;                state|=ExitState; 
             }            else             do
             {                Image                  *loaded_image;                 /**                 Display image to X server.               */               loaded_image= N                 XDisplayImage(display,&resource_info,argv,argc,&image,&state);1               if (loaded_image == (Image *) NULL)                  break;P               while ((loaded_image != (Image *) NULL) && (!(state & ExitState)))               {%;                 if (loaded_image->montage != (char *) NULL)e                   {o                     /*G                       User selected a visual directory image (montage).s                     */)                     DestroyImages(image); '                     image=loaded_image;X                     break;                   }~?                 MogrifyImage(&image_info,i,argv,&loaded_image);..                 if (first_scene != last_scene)%                   image->scene=scene;eJ                 next_image=XDisplayImage(display,&resource_info,argv,argc,(                   &loaded_image,&state);*                 if (loaded_image != image).                   DestroyImages(loaded_image);(                 loaded_image=next_image;               } +             } while (!(state & ExitState));e<           if (resource_info.write_filename != (char *) NULL)
             {a               /*                 Write image.               */J               (void) strcpy(image->filename,resource_info.write_filename);3               (void) WriteImage(&image_info,image);h
             }g!           if (image_info.verbose)u!             DescribeImage(image);-           /*+             Proceed to next/previous image.w           */           next_image=image;t'           if (state & FormerImageState) 5             for (j=0; j < resource_info.quantum; j++)r
             {n.               next_image=next_image->previous;/               if (next_image == (Image *) NULL)t                 break;
             }i           else5             for (j=0; j < resource_info.quantum; j++)h
             {(*               next_image=next_image->next;/               if (next_image == (Image *) NULL)w                 break;
             }>+           if (next_image != (Image *) NULL)u             image=next_image;-I         } while ((next_image != (Image *) NULL) && !(state & ExitState)); 
         /*           Free image resources.B
         */         DestroyImages(image); (         if (!(state & FormerImageState)))           image_marker[i]=image_number++;.         else           {t             /*(               Proceed to previous image.             */!             for (i--; i > 0; i--) 6               if (image_marker[i] == (image_number-2))                 break;"             if (image_number != 0)               image_number--;b           }          if (state & ExitState)           break;       }r     /*8       Determine if we should proceed to the first image.     */     if (i == (argc-1))A       if (resource_info.confirm_exit && (state & NextImageState))B	         {M           unsigned int             status;o             /*!             Confirm program exit.            */M           status=XConfirmWidget(display,windows,"Do you really want to exit",t             client_name);a           if (status == False)
             {n               i=0;               image_number=0;w
             }o	         }o   }h    if (state & RetainColorsState)N     XRetainWindowColors(display,XRootWindow(display,XDefaultScreen(display)));   free((char *) image_marker);%   free((char *) image_info.filename);a   XCloseDisplay(display);a
   exit(0);   return(False); } 