) .TH convert 1 "19 Feb 1995" "ImageMagick"  .SH NAMED convert - converts an input file using one image format to an output# file with a differing image format.  .SH SYNOPSIS .B "convert"8 [ \fIoptions\fP ... ] \fIinput_file\fP \fIoutput_file\fP .SH DESCRIPTION M \fBconvert\fP converts an input file using one image format to an output file  with a differing image format.  5 \fBconvert\fP recognizes the following image formats:    .TP 6  .B Tag \fBDescription\fP  .PP O -------------------------------------------------------------------------------  .TP 6  .B AVS AVS X image file.  .TP 6  .B BMP$ Microsoft Windows bitmap image file. .TP 6  .B CMYK + Raw cyan, magenta, yellow, and black bytes.  .TP 6  .B EPS# Adobe Encapsulated PostScript file.  .TP 6  .B EPSF # Adobe Encapsulated PostScript file.  .TP 6  .B EPSI 1 Adobe Encapsulated PostScript Interchange format.  .TP 6  .B FAX Group 3. .TP 6  .B FITS   Flexible Image Transport System. .TP 6  .B GIF Compuserve Graphics image file.  .TP 6  .B GIF87- Compuserve Graphics image file (version 87a).  .TP 6  .B GRAY  Raw gray bytes.  .TP 6  .B HDF Hierarchical Data Format.  .TP 6  .B HISTOGRAM .TP 6  .B JBIG ; Joint Bi-level Image experts Group file interchange format.  .TP 6  .B JPEG 9 Joint Photographic Experts Group file interchange format.  .TP 6  .B MAPK Red, green, and blue colormap bytes followed by the image colormap indexes.  .TP 6  .B MATTE Raw matte bytes. .TP 6  .B MIFF  Magick image file format.  .TP 6  .B MTV MTV Raytracing image format. .TP 6  .B NULL  NULL image.  .TP 6  .B PCD	 Photo CD.  .TP 6  .B PCX ZSoft IBM PC Paintbrush file.  .TP 6  .B PDF Portable Document Format.  .TP 6  .B PICT $ Apple Macintosh QuickDraw/PICT file. .TP 6  .B PNG Portable Network Graphics. .TP 6  .B PNM Portable bitmap. .TP 6  .B PS  Adobe PostScript file. .TP 6  .B PS2 Adobe Level II PostScript file.  .TP 6  .B RAD Radiance image format. .TP 6  .B RGB Raw red, green, and blue bytes.  .TP 6  .B RGBA % Raw red, green, blue and matte bytes.  .TP 6  .B RLE. Utah Run length encoded image file; read only. .TP 6  .B SGI Irix RGB image file. .TP 6  .B SUN SUN Rasterfile.  .TP 6  .B TEXT  raw text file; read only.  .TP 6  .B TGA Truevision Targa image file. .TP 6  .B TIFF  Tagged Image File Format.  .TP 6  .B TILE  tile image with a texture. .TP 6  .B VICAR
 read only. .TP 6  .B VID Visual Image Directory.  .TP 6  .B VIFF   Khoros Visualization image file. .TP 6  .B X" select image from X server screen. .TP 6  .B XC M constant image of X server color.  Specify the desired color as the filename.  .TP 6  .B XBM X11 bitmap file. .TP 6  .B XPM X11 pixmap file. .TP 6  .B XWD' X Window System window dump image file.  .TP 6  .B YUV CCIR 601 4:1:1 file. .TP 6  .B YUV3  CCIR-601 4:1:1 files.  .PP , Options are processed in command line order.H Any option you specify on the command line remains in effect until it isJ explicitly changed by specifying the option again with a different effect. .PP A Change '-' to '+' in any option above to reverse its effect.  For E example, specify +matte to store the image without its matte channel.  .PP B By default, the image format is determined by its magic number. ToE specify a particular image format, precede the filename with an image D format name and a colon (i.e. ps:image) or specify the image type asF the filename suffix (i.e. image.ps).  See \fBDESCRIPTION\fP for a list of valid formats.  .PP E When you specify \fBX\fP as your image type, the filename has special E meaning.  It specifies an X window by id, name, or \fBroot\fP.  If no F filename is specified, the window is selected by clicking the mouse in the desired window.  .PP 7 Specify \fIinput_file\fP as \fI-\fP for standard input, F \fIoutput_file\fP as \fI-\fP for standard output.  If \fIinput_file\fPF has the extension \fB.Z\fP or \fB.gz\fP, the file is uncompressed withD \fBuncompress\fP or \fBgunzip\fP respectively.  If \fIoutput_file\fPD has the extension \fB.Z\fP or \fB.gz\fP, the file size is compressedG using with \fBcompress\fP or \fBgzip\fP respectively.  Finally, precede E the image file name with \fI|\fP to pipe to or from a system command.  .PP G Use an optional index enclosed in brackets after a file name to specify C a desired subimage of a multi-resolution image format like Photo CD I (e.g. img0001.pcd[4]) or a range for MPEG images (e.g. video.mpg[50-75]).  .PP B Single images are written with the filename you specify.  However,E multi-part images (i.e. a multi-page Postscript document) are written 8 with the filename followed by a period (\fB.\fP) and theG scene number.  You can change this behavior by embedding a \fBprintf\fP 4 format specification in the file name.  For example, .nf      image%02d.miff .fi / converts files image00.miff, image01.miff, etc.  .PP  .SH EXAMPLES .PP G To convert a \fIMIFF\fP image of a cockatoo to a SUN raster image, use:  .PP  .B+      convert cockatoo.miff sun:cockatoo.ras  .PP O To convert a multi-page \fIPostscript\fP document to individual FAX pages, use:  .PP  .B-      convert -monochrome document.ps fax:page  .PP G To convert a TIFF image to a \fIPostscript\fP A4 page with the image in   the lower left-hand corner, use: .PP  .B0      convert -page A4+0+0 image.tiff document.ps .PP O To convert a raw \fBGRAY\fP image with a 128 byte header to a portable graymap,  use: .PP  .B1      convert -size 768x512+128 gray:raw image.pgm  .PP 1 To convert a Photo CD image to a TIFF image, use:  .PP  .B3      convert -size 1536x1024 img0009.pcd image.tiff &      convert img0009.pcd[4] image.tiff .PP @ To create a visual image directory of all your JPEG images, use: .PP  .B'      convert 'vid:*.jpg' directory.miff  .PP K To annotate an image with blue text using font 12x24 at position (100,100),  use: .PP  .B]      convert -font 12x24 -pen blue -geometry +100+100 -annotate "Cockatoo" bird.jpg bird.miff  .PP ; To tile a 640x480 image with a JPEG texture with bumps use:  .PP  .B3      convert -size 640x480 tile:bumps.jpg tiled.png  .PP O To surround an icon with an ornamental border to use with \fBMosaic(1)\fP, use:  .PP  .B:      convert -mattecolor #ccc -frame 6x6 bird.jpg icon.png .SH OPTIONS  .TP 5  .B "-annotate \fIstring\fP"  annotate an image with text.  C Use this option to annotate an image with text.  Optionally you can C include the image filename, type, width, height, or scene number by B embedding special format characters.  Embed \fB%f\fP for filename,F \fB%m\fP for magick, \fB%w\fP for width, \fB%h\fP for height, \fB%s\fP9 for scene number, or \fB\\n\fP for newline.  For example,    .nf       -annotate "%m:%f %wx%h" .fi   B annotates the image with \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.  C If the first character of \fIstring\fP is \fB@\fP, the text is read = from a file titled by the remaining characters in the string.   I You can set the text position, font, and font color with \fB-geometry\fP, C \fB-font\fP, and \fB-pen\fP respectively.  Options are processed in 5 command line order so be sure to use \fB-geometry\fP, C \fB-font\fP, or \fB-pen\fP \fIbefore\fP the \fB-annotate\fP option.  .TP 5  .B "-blur \fIfactor\fP" @ blurs an image.  Specify \fIfactor\fP as the percent enhancement (0.0 - 99.9%). .TP 5 # .B "-border \fI<width>x<height>\fP" F surround the image with a border or color.  See \fBX(1)\fP for details! about the geometry specification.   M The color of the border is specified with the \fB-bordercolor\fP command line  option.  .TP 5  .B "-colors \fIvalue\fP"( preferred number of colors in the image.  G The actual number of colors in the image may be less than your request, E but never more.  Note, this is a color reduction option.  Images with I less unique colors than specified with this option will remain unchanged. , Refer to \fBquantize(9)\fP for more details.  K Note, options \fB-dither\fP, \fB-colorspace\fP, and \fB-treedepth\fP affect  the color reduction algorithm. .TP 5  .B "-colorspace \fIvalue\fP"E the type of colorspace: \fBGRAY\fP, \fBOHTA\fP, \fBRGB\fP, \fBXYZ\fP, 2 \fBYCbCr\fP, \fBYIQ\fP, \fBYPbPr\fP, or \fBYUV\fP.  @ Color reduction, by default, takes place in the RGB color space.F Empirical evidence suggests that distances in color spaces such as YUV> or YIQ correspond to perceptual color differences more closelyC than do distances in RGB space.  These color spaces may give better E results when color reducing an image.  Refer to \fBquantize(9)\fP for 
 more details.   I The \fB-colors\fP or \fB-monochrome\fP option is required for this option  to take effect.  .TP 5  .B "-comment \fIstring\fP"! annotate an image with a comment.   A By default, each image is commented with its file name.  Use this E option to assign a specific comment to the image.  Optionally you can C include the image filename, type, width, height, or scene number by B embedding special format characters.  Embed \fB%f\fP for filename,F \fB%m\fP for magick, \fB%w\fP for width, \fB%h\fP for height, \fB%s\fP9 for scene number, or \fB\\n\fP for newline.  For example,    .nf       -comment "%m:%f %wx%h"  .fi   F produces an image comment of \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.  L If the first character of \fIstring\fP is \fB@\fP, the image comment is read= from a file titled by the remaining characters in the string.  .TP 5  .B "-compress \fItype\fP" H the type of image compression: \fIQEncoded\fP or \fIRunlengthEncoded\fP.  M Specify \fB\+compress\fP to store the binary image in an uncompressed format. @ The default is the compression type of the specified image file. .TP 5  .B "-contrast"% enhance or reduce the image contrast.   : This option enhances the intensity differences between theA lighter and darker elements of the image.  Use \fB-contrast\fP to B enhance the image or \fB+contrast\fP to reduce the image contrast. .TP 5 E .B "-crop \fI<width>{%}x<height>{%}{\+-}<x offset>{\+-}<y offset>\fP" M preferred size and location of the cropped image.  See \fBX(1)\fP for details ! about the geometry specification.   M To specify a percentage width or height instead, append \fB%\fP.  For example ? to crop the image by ten percent on all sides of the image, use  \fB-crop 10%\fP.  B Use cropping to crop a particular area of an image.   Use \fB-crop5 0x0\fP to remove edges that are the background color.  .TP 5 # .B "-density \fI<width>x<height>\fP : vertical and horizontal resolution in pixels of the image.  D This option specifies an image density when decoding a Postscript orL Portable Document page.  The default is 72 pixels per inch in the horizontal and vertical direction.  .TP 5  .B "-despeckle" $ reduce the speckles within an image. .TP 5 ) .B "-display \fIhost:display[.screen]\fP" 2 specifies the X server to contact; see \fBX(1)\fP. .TP 5  .B "-dither"3 apply Floyd/Steinberg error diffusion to the image.   D The basic strategy of dithering is to trade intensity resolution forF spatial resolution by averaging the intensities of several neighboringH pixels.  Images which suffer from severe contouring when reducing colors! can be improved with this option.   B The \fB-colors\fP option is required for dithering to take effect. .TP 5 
 .B "-edge" detect edges with an image.  .TP 5  .B "-emboss" emboss the image.  .TP 5 
 .B "-enhance" 0 apply a digital filter to enhance a noisy image. .TP 5  .B "-equalize", perform histogram equalization to the image. .TP 5 
 .B "-flip"I create a "mirror image" by reflecting the image scanlines in the vertical 
 direction. .TP 5 
 .B "-flop"K create a "mirror image" by reflecting the image scanlines in the horizontal 
 direction. .TP 5  .B "-font \fIname\fP" E This option specifies the font to be used for displaying normal text.  The default is \fBfixed\fP.  .TP 5 J .B "-frame \fI<width>x<height>+<outer bevel width>+<inner bevel width>\fP"L surround the image with an an ornamental border.  See \fBX(1)\fP for details! about the geometry specification.   L The color of the border is specified with the \fB-mattecolor\fP command line option.  .TP 5  .B "-gamma \fIvalue\fP"  level of gamma correction.  E The same color image displayed on two different workstations may look ? different due to differences in the display monitor.  Use gamma B correction to adjust for this color difference.  Reasonable values extend from 0.8 to 2.3.   ? You can apply separate gamma values to the red, green, and blue D channels of the image with a gamma value list delineated with commas (i.e. 1.7,2.3,1.2).  .TP 5 1 .B "-geometry \fI<width>{%}x<height>{%}{!}{<}{>}" 6 preferred size or location of the image when encoding.  B By default, the width and height are maximum values.  That is, theG image is expanded or contracted to fit the width and height value while G maintaining the aspect ratio of the image.  Append an exclamation point ? to the geometry to force the image size to exactly the size you G specify.  For example, if you specify \fB640x480!\fP the image width is ; set to 640 pixels and height to 480.  If only one factor is 6 specified, both the width and height assume the value.  E To specify a percentage width or height instead, append \fB%\fP.  The F image size is multiplied by the width and height percentages to obtainD the final image dimensions.  To increase the size of an image, use aG value greater than 100 (e.g. 125%).  To decrease an image's size, use a  percentage less than 100.   < Use \fB<\fP to change the dimensions of the image \fIonly\fP@ if its size exceeds the geometry specification.  \fB>\fP resizes@ the image \fIonly\fP if its dimensions is less than the geometryB specification.  For example, if you specify \fB640x480>\fP and theC image size is 512x512, the image size does not change.  However, if 1 the image is 1024x1024, it is resized to 640x480.   7 There are 72 pixels per inch in Postscript coordinates.  .TP 5  .B "-interlace \fItype\fP"G the type of interlacing scheme: \fBNONE\fP, \fBLINE\fP, or \fBPLANE\fP.   E This option is used to specify the type of interlacing scheme for raw F image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNONE\fP means do not; interlace (RGBRGBRGBRGBRGBRGB...), \fBLINE\fP uses scanline H interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPLANE\fP uses0 plane interlacing (RRRRRR...GGGGGG...BBBBBB...).  A Use \fBLINE\fP, or \fBPLANE\fP to create an interlaced GIF image.  .B "-label \fIname\fP" assign a label to an image.   D Use this option to assign a specific label to the image.  OptionallyA you can include the image filename, type, width, height, or scene C number in the label by embedding special format characters.   Embed ? \fB%f\fP for filename, \fB%m\fP for magick, \fB%w\fP for width, @ \fB%h\fP for height, or \fB%s\fP for scene number.  For example, .nf       -label "%m:%f %wx%h"  .fi D produces an image label of \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.  J If the first character of \fIstring\fP is \fB@\fP, the image label is read= from a file titled by the remaining characters in the string.   I When converting to Postscript, use this option to specify a header string  to print above the image.  .TP 5  .B "-map \fIfilename\fP"2 choose a particular set of colors from this image.  A By default, color reduction chooses an optimal set of colors that C best represent the original image.  Alternatively, you can choose a * particular set of colors with this option. .TP 5  .B "-matte" ) store matte channel if the image has one.  .TP 5  .B "-modulate \fIvalue\fP"5 vary the brightness, saturation, and hue of an image.   M Specify the percent change in brightness, the color saturation, and the color G hue separated by commas.  For example, to increase the color brightness L by 20% and decrease the color saturation by 10% and leave the hue unchanged, use: \fB-modulate 20,-10\fP. .TP 5  .B "-monochrome"' transform the image to black and white.  .TP 5  .B "-negate" apply color inversion to image.   = The red, green, and blue intensities of an image are negated.  .TP 5  .B "-noise" B reduce the noise in an image with a noise peak elimination filter.  D The principal function of noise peak elimination filter is to smoothG the objects within an image without losing edge information and without G creating undesired structures.  The central idea of the algorithm is to F replace a pixel with its next neighbor in value within a 3 x 3 window,F if this pixel has been found to be noise.  A pixel is defined as noiseJ if and only if this pixel is a maximum or minimum within the 3 x 3 window. .TP 5  .B "-normalize" 7 transform image to span the full range of color values.   ) This is a contrast enhancement technique.  .TP 5  .B "-opaque \fIcolor\fP"H change this color to the pen color within the image.  See \fB-pen\fP for
 more details.  .TP 5 ? .B "-page \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP" 3 preferred size and location of the Postscript page.   C Use this option to specify the dimensions of the Postscript page in O pixels per inch or a TEXT page in pixels.  The default for a Postscript page is ; to center the image on a letter page 612 by 792 pixels. The @ margins are 1/2" (i.e.  612x792+36+36).  Other common sizes are:       Letter      612x 792     Tabloid     792x1224     Ledger     1224x 792     Legal       612x1008     Statement   396x 612     Executive   540x 720     A3          842x1190     A4          595x 842     A5          420x 595     B4          729x1032     B5          516x 729     Folio       612x 936     Quarto      610x 780     10x14       720x1008  < For convenience you can specify the page size by media (e.g. A4, Ledger, etc.).  K The page geometry is relative to the vertical and horizontal density of the 1 Postscript page.  See \fB-density\fP for details.   F To place a Postscript image with a given size on a given location on a@ page, use -page +HOFFSET+VOFFSET -geometry WIDTHxHEIGHT (fill in8 numbers). Note: this is only for generating ps, not eps.  8 The default page dimensions for a TEXT image is 612x792. .TP 5  .B "-paint"  paint the image. .TP 5  .B "-pen \fIcolor\fP" B set the color of the font or opaque color.  See \fB-annotate\fP or" \fB-opaque\fP for further details.  9 See \fBX(1)\fP for details about the color specification.  .TP 5  .B "-quality \fIvalue\fP"  JPEG quality setting.   6 Quality is 0 (worst) to 100 (best). The default is 75. .TP 5  .B "-raise \fI<bevel width>\fP" 5 lighten or darken image edges to create a 3-D effect.   H \fIBevel width\fP is the width of an edge.  Use \fB-raise\fP to create a* raised effect, otherwise use \fB+raise\fP. .TP 5 / .B "-roll \fI{\+-}<x offset>{\+-}<y offset>\fP" E roll an image vertically or horizontally.  See \fBX(1)\fP for details ! about the geometry specification.   D A negative \fIx offset\fP rolls the image left-to-right.  A negative- \fIy offset\fP rolls the image top-to-bottom.  .TP 5  .B "-rotate \fIdegrees\fP"( apply Paeth image rotation to the image.  A Empty triangles left over from rotating the image are filled with A the color defined as \fBbordercolor\fP (class \fBborderColor\fP).  See \fBX(1)\fP for details.  .TP 5  .B "-sample \fIgeometry\fP"   scale image with pixel sampling. .TP 5  .B "-scene \fIvalue\fP"  image scene number.  .TP 5  .B "-sharpen \fIweight\fP"B sharpen an image.  Specify \fIfactor\fP as the percent enhancement (0.0 - 99.9%). .TP 5 ) .B "-shear \fI<x degrees>x<y degrees>\fP" L shear the image along the X or Y axis by a positive or negative shear angle.  F Shearing slides one edge of an image along the X or Y axis, creating aE parallelogram.  An X direction shear slides an edge along the X axis, F while a Y direction shear slides an edge along the Y axis.  The amountE of the shear is controlled by a shear angle.  For X direction shears, F \fIx degrees\fP is measured relative to the Y axis, and similarly, forF Y direction shears \fIy degrees\fP is measured relative to the X axis.  A Empty triangles left over from shearing the image are filled with A the color defined as \fBbordercolor\fP (class \fBborderColor\fP).  See \fBX(1)\fP for details.  .TP 5 0 .B "-size \fI<width>{%}x<height>{%}+<offset>\fP" width and height of the image.  C Use this option to specify the width and height of raw images whose D dimensions are unknown such as \fBGRAY\fP, \fBRGB\fP, or \fBCMYK\fP.C In addition to width and height, use \fB-size\fP to skip any header D information in the image or tell the number of colors in a \fBMAP\fP% image file, (e.g. -size 640x512+256).   - For Photo CD images, choose from these sizes:   
    192x128
    384x256
    768x512   1536x1024    3072x2048   J Finally, use this option to choose a particular resolution layer of a JBIG image (e.g. -size 1024x768). .TP 5  .B "-transparency \fIcolor\fP"- make this color transparent within the image.  .TP 5  .B "-treedepth \fIvalue\fP" A Normally, this integer value is zero or one.  A zero or one tells D \fBconvert\fP to choose a optimal tree depth for the color reduction
 algorithm.  G An optimal depth generally allows the best representation of the source B image with the fastest computational speed and the least amount ofE memory.  However, the default depth is inappropriate for some images. F To assure the best representation, try values between 2 and 8 for this8 parameter.  Refer to \fBquantize(9)\fP for more details.  D The \fB-colors\fP option is required for this option to take effect. .TP 5 D .B "-undercolor \fI<undercolor factor>x<black-generation factor>\fP"? control undercolor removal and black generation on CMYK images.   ? This option enables you to perform undercolor removal and black @ generation on CMYK images-- images to be printed on a four-colorC printing system. You can control how much cyan, magenta, and yellow : to remove from your image and how much black to add to it.9 The standard undercolor removal is \fB1.0x1.0\fP.  You'll E frequently get better results, though, if the percentage of black you G add to your image is slightly higher than the percentage of C, M, and Y = you remove from it.  For example you might try \fB0.5x0.7\fP.  .TP 5  .B -verbose + print detailed information about the image.   H This information is printed: image scene number;  image name;  converted? image name;  image size;  the image class (\fIDirectClass\fP or G \fIPseudoClass\fP);  the total number of unique colors;  and the number ) of seconds to read and convert the image.  .SH ENVIRONMENT  .PP  .TP 5 
 .B DISPLAY4 To get the default host, display number, and screen. .SH SEE ALSO .B: display(1), animate(1), import(1), montage(1), mogrify(1), segment(1), combine(1), xtp(1)
 .SH COPYRIGHT 3 Copyright 1995 E. I. du Pont de Nemours and Company  .PP G Permission to use, copy, modify, distribute, and sell this software and @ its documentation for any purpose is hereby granted without fee,F provided that the above copyright notice appear in all copies and that? both that copyright notice and this permission notice appear in G supporting documentation, and that the name of E. I. du Pont de Nemours A and Company not be used in advertising or publicity pertaining to < distribution of the software without specific, written priorJ permission.  E. I. du Pont de Nemours and Company makes no representationsG about the suitability of this software for any purpose.  It is provided , "as is" without express or implied warranty. .PP I E. I. du Pont de Nemours and Company disclaims all warranties with regard E to this software, including all implied warranties of merchantability F and fitness, in no event shall E. I. du Pont de Nemours and Company be@ liable for any special, indirect or consequential damages or anyG damages whatsoever resulting from loss of use, data or profits, whether F in an action of contract, negligence or other tortuous action, arisingE out of or in connection with the use or performance of this software.  .SH AUTHORS = John Cristy, E.I. du Pont De Nemours and Company Incorporated   