 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                CCCC   OOO   N   N  V   V  EEEEE  RRRR   TTTTT               % O %               C      O   O  NN  N  V   V  E      R   R    T                 % O %               C      O   O  N N N  V   V  EEE    RRRR     T                 % O %               C      O   O  N  NN   V V   E      R R      T                 % O %                CCCC   OOO   N   N    V    EEEEE  R  R     T                 % O %                                                                             % O %                                                                             % O %                Convert an image from one format to another.                 % O %                                                                             % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                April 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. Dupont de Nemours and Company                         % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. Dupont de Nemours     % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. Dupont de Nemours and Company makes no representations  % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. Dupont de Nemours and Company disclaims all warranties with regard   % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. Dupont de Nemours and Company be      % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Convert converts an input file using one image format to an output file! %  with a differing image format.  % ! %  The convert program syntax is:  % 6 %  Usage: convert [options ...] input_file output_file %  %  Where options include: 6 %    -annotate string     annotate the image with text: %    -blur factor         apply a filter to blur the image? %    -border geometry     surround image with a border of color A %    -colors value        preferred number of colors in the image I %    -colorspace type     GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV 5 %    -comment string      annotate image with comment 6 %    -compress type       RunlengthEncoded or QEncoded> %    -contrast            enhance or reduce the image contrastJ %    -crop geometry       preferred size and location of the cropped imageF %    -density geometry    vertical and horizontal density of the image> %    -despeckle           reduce the speckles within an image"A %    -display server      obtain image or font from this X server H %    -dither              apply Floyd/Steinberg error diffusion to imageE %    -edge                apply a filter to detect edges in the image ) %    -emboss              emboss an image I %    -enhance             apply a digital filter to enhance a noisy image D %    -equalize            perform histogram equalization to an image> %    -flip                flip image in the vertical direction@ %    -flop                flop image in the horizontal direction6 %    -font name           X11 font for displaying textB %    -frame geometry      surround image with an ornamental border3 %    -gamma value         level of gamma correction A %    -geometry geometry   perferred size or location of the image . %    -interlace type      NONE, LINE, or PLANE4 %    -label name          assign a label to an imageL %    -map filename        transform image colors to match this set of colorsB %    -matte               store matte channel if the image has oneA %    -modulate value      vary the brightness, saturation and hue < %    -monochrome          transform image to black and white8 %    -negate              apply color inversion to imageK %    -noise               reduce noise with a noise peak elimination filter J %    -normalize           transform image to span the full range of colorsB %    -page geometry       size and location of the Postscript page. %    -quality value       JPEG quality setting< %    -opaque color        change this color to the pen color( %    -paint               paint an imageG %    -pen color           color for annotating or changing opaque color K %    -raise value         lighten/darken image edges to create a 3-D effect B %    -roll geometry       roll an image vertically or horizontally; %    -rotate degrees      apply Paeth rotation to the image 9 %    -sample geometry     scale image with pixel sampling , %    -scene value         image scene number= %    -sharpen factor      apply a filter to sharpen the image K %    -shear geometry      slide one edge of the image along the X or Y axis 3 %    -size geometry       width and height of image F %    -transparent color   make this color transparent within the image@ %    -treedepth value     depth of the color classification treeI %    -undercolor geometry control undercolor removal and black generation D %    -verbose             print detailed information about the image % D %  Change '-' to '+' in any option above to reverse its effect.  ForI %  example,  specify +matte to store the image without its matte channel.  % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. % 2 %  Convert recognizes the following image formats: %  %    Tag   Description8 %    --------------------------------------------------- %    AVS   AVS X image file./ %    BMP   Microsoft Windows bitmap image file. 6 %    CMYK  Raw cyan, magenta, yellow, and black bytes.. %    EPS   Adobe Encapsulated PostScript file.. %    EPSF  Adobe Encapsulated PostScript file.< %    EPSI  Adobe Encapsulated PostScript Interchange format. %    FAX   Group 3. + %    FITS  Flexible Image Transport System. * %    GIF   Compuserve Graphics image file.8 %    GIF87 Compuserve Graphics image file (version 87a). %    GRAY  Raw gray bytes.$ %    HDF   Hierarchical Data Format. %    HISTOGRAMF %    JBIG  Joint Bi-level Image experts Group file interchange format.D %    JPEG  Joint Photographic Experts Group file interchange format., %    MAP   colormap intensities and indices. %    MATTE Raw matte bytes. $ %    MIFF  Magick image file format. %    MTV %    NULL  NULL image. %    PCD   Photo CD.( %    PCX   ZSoft IBM PC Paintbrush file.$ %    PDF   Portable Document Format./ %    PICT  Apple Macintosh QuickDraw/PICT file. % %    PNG   Portable Network Graphics.  %    PNM   Portable bitmap. ! %    PS    Adobe PostScript file. * %    PS2   Adobe Level II PostScript file. %    RAD   Radiance image file. * %    RGB   Raw red, green, and blue bytes.1 %    RGBA  Raw red, green, blue, and matte bytes. 9 %    RLE   Utah Run length encoded image file; read only.  %    SGI   Irix RGB image file.  %    SUN   SUN Rasterfile.$ %    TEXT  raw text file; read only.' %    TGA   Truevision Targa image file. $ %    TIFF  Tagged Image File Format.% %    TILE  tile image with a texture.  %    VICAR read only. " %    VID   Visual Image Directory.+ %    VIFF  Khoros Visualization image file. - %    X     select image from X server screen. , %    XC    constant image of X server color. %    XBM   X11 bitmap file.  %    XPM   X11 pixmap file. 2 %    XWD   X Window System window dump image file. %    YUV   CCIR 601 1:1:1 file.   %    YUV3  CCIR 601 2:1:1 files. %  %  */   #include "magick.h"  #include "image.h" #include "utility.h" #include "X.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Procedure Usage displays the program usage; % & %  The format of the Usage routine is: %  %      Usage() %  %  */ static void Usage()  {    char     **p;  
   static char      *ImageTypes[]=     {        "Tag   Description",E       "------------------------------------------------------------",         "AVS   AVS X image file.",3       "BMP   Microsoft Windows bitmap image file.", :       "CMYK  Raw cyan, magenta, yellow, and black bytes.",2       "EPS   Adobe Encapsulated PostScript file.",2       "EPSF  Adobe Encapsulated PostScript file.",@       "EPSI  Adobe Encapsulated PostScript Interchange format.",       "FAX   Group 3.", /       "FITS  Flexible Image Transport System.", .       "GIF   Compuserve Graphics image file.",<       "GIF87 Compuserve Graphics image file (version 87a).",       "GRAY  Raw gray bytes.",(       "HDF   Hierarchical Data Format.",       "HISTOGRAM",J       "JBIG  Joint Bi-level Image experts Group file interchange format.",H       "JPEG  Joint Photographic Experts Group file interchange format.",0       "MAP   colormap intensities and indices.",       "MATTE Raw matte bytes.", (       "MIFF  Magick image file format.",       "MTV",       "NULL  NULL image.",       "PCD   Photo CD.",,       "PCX   ZSoft IBM PC Paintbrush file.",(       "PDF   Portable Document Format.",3       "PICT  Apple Macintosh QuickDraw/PICT file.", )       "PNG   Portable Network Graphics.",        "PNM   Portable bitmap.", %       "PS    Adobe PostScript file.", .       "PS2   Adobe Level II PostScript file.",#       "RAD   Radiance image file.", .       "RGB   Raw red, green, and blue bytes.",5       "RGBA  Raw red, green, blue, and matte bytes.", =       "RLE   Utah Run length encoded image file; read only.", #       "SGI   Irix RGB image file.",        "SUN   SUN Rasterfile.",(       "TEXT  raw text file; read only.",+       "TGA   Truevision Targa image file.", (       "TIFF  Tagged Image File Format.",)       "TILE  tile image with a texture.",        "VICAR read only.", &       "VID   Visual Image Directory.",/       "VIFF  Khoros Visualization image file.", 1       "X     select image from X server screen.", 0       "XC    constant image of X server color.",       "XBM   X11 bitmap file.",        "XPM   X11 pixmap file.", 6       "XWD   X Window System window dump image file.",#       "YUV   CCIR 601 1:1:1 file.", $       "YUV3  CCIR 601 2:1:1 files.",       (char *) NULL,     },     *options[]=      { :       "-annotate string     annotate the image with text",>       "-blur factor         apply a filter to blur the image",C       "-border geometry     surround image with a border of color", E       "-colors value        preferred number of colors in the image", M       "-colorspace type     GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV", 9       "-comment string      annotate image with comment", :       "-compress type       RunlengthEncoded or QEncoded",B       "-contrast            enhance or reduce the image contrast",N       "-crop geometry       preferred size and location of the cropped image",J       "-density geometry    vertical and horizontal density of the image",A       "-despeckle           reduce the speckles within an image", E       "-display server      obtain image or font from this X server", L       "-dither              apply Floyd/Steinberg error diffusion to image",I       "-edge                apply a filter to detect edges in the image", -       "-emboss              emboss an image", M       "-enhance             apply a digital filter to enhance a noisy image", H       "-equalize            perform histogram equalization to an image",B       "-flip                flip image in the vertical direction",D       "-flop                flop image in the horizontal direction",:       "-font name           X11 font for displaying text",F       "-frame geometry      surround image with an ornamental border",7       "-gamma value         level of gamma correction", E       "-geometry geometry   perferred size or location of the image", 2       "-interlace type      NONE, LINE, or PLANE",8       "-label name          assign a label to an image",P       "-map filename        transform image colors to match this set of colors",F       "-matte               store matte channel if the image has one",F       "-modulate value      vary the brightness, saturation, and hue",@       "-monochrome          transform image to black and white",<       "-negate              apply color inversion to image",O       "-noise               reduce noise with a noise peak elimination filter", N       "-normalize           transform image to span the full range of colors",F       "-page geometry       size and location of the Postscript page",2       "-quality value       JPEG quality setting",,       "-paint               paint an image",O       "-raise value         lighten/darken image edges to create a 3-D effect", K       "-pen color           color for annotating or changing opaque color", @       "-opaque color        change this color to the pen color",F       "-roll geometry       roll an image vertically or horizontally",?       "-rotate degrees      apply Paeth rotation to the image", =       "-sample geometry     scale image with pixel sampling", 0       "-scene value         image scene number",A       "-sharpen factor      apply a filter to sharpen the image", O       "-shear geometry      slide one edge of the image along the X or Y axis", 7       "-size geometry       width and height of image", J       "-transparent color   make this color transparent within the image",D       "-treedepth value     depth of the color classification tree",M       "-undercolor geometry control undercolor removal and black generation", H       "-verbose             print detailed information about the image",       (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version); C   (void) printf("Usage: %s [options ...] input_file output_file\n",      client_name); .   (void) printf("\nWhere options include:\n");+   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(O     "example,  specify +matte to store the image without an matte channel.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); F   (void) printf("\nThe following image formats are recognized: \n\n");.   for (p=ImageTypes; *p != (char *) NULL; p++)     (void) printf("  %s\n",*p); 
   exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M a i n                                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(argc,argv)  int    argc;    char
   *argv[]; { + #define NotInitialized  (unsigned int) (~0)      char     *filename,     *option;     Image      *image,      *map_image,      *next_image;     ImageInfo      image_info;      int      status,      x;     register int     i;     /*!     Initialize program variables.    */    client_name=ClientName(*argv);   if (argc < 3)      Usage();   /**     Read image and convert to MIFF format.   */   image=(Image *) NULL;    GetImageInfo(&image_info);   map_image=(Image *) NULL;    /*     Check command syntax.    */   filename=(char *) NULL;    for (i=1; i < (argc-1); i++)   {      option=argv[i]; M     if (((int) strlen(option) < 2) || ((*option != '-') && (*option != '+')))        { 
         /*           Read input image. 
         */         filename=argv[i]; 4         (void) strcpy(image_info.filename,filename);$         if (image != (Image *) NULL):           Error("input image already specified",filename);%         image=ReadImage(&image_info); $         if (image == (Image *) NULL)           exit(1);       }      else       switch(*(option+1))        {          case 'a': 	         { 2           if (strncmp("annotate",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing text on -annotate",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'b': 	         { .           if (strncmp("blur",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing factor on -blur",(char *) NULL);                  }                break;
             } 0           if (strncmp("border",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing geometry on -border",(char *) NULL);                  }                break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             { :               if ((i == argc) || !sscanf(argv[i],"%d",&x))                 {                    i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'c': 	         { 0           if (strncmp("colors",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL);                  }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { !               if (*option == '-')                  {                    unsigned int                     colorspace;                      i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL); !                   option=argv[i]; 1                   colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0).                     colorspace=GRAYColorspace;8                   if (Latin1Compare("ohta",option) == 0).                     colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0) -                     colorspace=RGBColorspace; 7                   if (Latin1Compare("xyz",option) == 0) -                     colorspace=XYZColorspace; 9                   if (Latin1Compare("ycbcr",option) == 0) /                     colorspace=YCbCrColorspace; 7                   if (Latin1Compare("yiq",option) == 0) -                     colorspace=YIQColorspace; 9                   if (Latin1Compare("ypbpr",option) == 0) /                     colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0) -                     colorspace=YUVColorspace; 8                   if (colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);                  }                break;
             } 1           if (strncmp("comment",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);                  }                break;
             } 2           if (strncmp("compress",option+1,4) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL); !                   option=argv[i]; D                   if (Latin1Compare("runlengthencoded",option) == 0)                     break;                   else>                     if (Latin1Compare("qencoded",option) == 0)                       break;                     elseL                       Error("Invalid compression type on -compress",option);                 }                break;
             } 2           if (strncmp("contrast",option+1,3) == 0)             break;2           if ((strncmp("crop",option+1,2) == 0) ||0               (strncmp("clip",option+1,2) == 0))
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -crop",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'd': 	         { 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];                  }                break;
             } 3           if (strncmp("despeckle",option+1,3) == 0)              break;1           if (strncmp("display",option+1,3) == 0) 
             { 3               image_info.server_name=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL); 1                   image_info.server_name=argv[i];                  }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 1               image_info.dither=(*option == '-');                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'e': 	         { .           if (strncmp("edge",option+1,2) == 0)             break;0           if (strncmp("emboss",option+1,2) == 0)             break;1           if (strncmp("enhance",option+1,2) == 0)              break;2           if (strncmp("equalize",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }          case 'f': 	         { .           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,2) == 0)
             { ,               image_info.font=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);*                   image_info.font=argv[i];                 }                break;
             } /           if (strncmp("frame",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing geometry on -frame",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'g': 	         { /           if (strncmp("gamma",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);                  }                break;
             } 2           if (strncmp("geometry",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing geometry on -geometry",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             {                Usage();               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'i': 	         { 3           if (strncmp("interlace",option+1,3) == 0) 
             { 1               image_info.interlace=NoneInterlace; !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);                  }                break;
             } .           Error("Unrecognized option",option);	         }          case 'l': 	         { /           if (strncmp("label",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'm': 	         { -           if (strncmp("map",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing file name on -map",(char *) NULL); =                   (void) strcpy(image_info.filename,argv[i]); 3                   map_image=ReadImage(&image_info); 2                   if (map_image == (Image *) NULL)>                     Error("Unable to read map image",argv[i]);                 }                break;
             } ,           if (strcmp("matte",option+1) == 0)             break;4           if (strncmp("mattecolor",option+1,6) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);                 }                break;
             } 2           if (strncmp("modulate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing value on -modulate",(char *) NULL);                 }                break;
             } 4           if (strncmp("monochrome",option+1,4) == 0)
             { 5               image_info.monochrome=(*option == '-');                break;
             } .           Error("Unrecognized option",option);	         }          case 'n': 	         { 0           if (strncmp("negate",option+1,3) == 0)             break;/           if (strncmp("noise",option+1,3) == 0)              break;3           if (strncmp("normalize",option+1,3) == 0)              break;.           Error("Unrecognized option",option);           break;	         }          case 'o': 	         { 0           if (strncmp("opaque",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     Error("Missing color on -opaque",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,3) == 0)
             { ,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }                break;
             } /           if (strncmp("paint",option+1,3) == 0)              break;-           if (strncmp("pen",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing pen color on -pen",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'q': 	         {            i++;6           if ((i == argc) || !sscanf(argv[i],"%d",&x))?             Error("Missing quality on -quality",(char *) NULL); +           image_info.quality=atoi(argv[i]);            break;	         }          case 'r': 	         { /           if (strncmp("raise",option+1,2) == 0) 
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))E                 Error("Missing bevel width on -raise",(char *) NULL);                break;
             } .           if (strncmp("roll",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -roll",(char *) NULL);                  }                break;
             } 0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing degrees on -rotate",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 's': 	         { 0           if (strncmp("sample",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing geometry on -sample",(char *) NULL);                  }                break;
             } /           if (strncmp("scene",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);                 }                break;
             } 1           if (strncmp("sharpen",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing factor on -sharpen",(char *) NULL);                 }                break;
             } /           if (strncmp("shear",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))L                     Error("Missing shear geometry on -shear",(char *) NULL);                 }                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -size",(char *) NULL); *                   image_info.size=argv[i];                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 't': 	         { 5           if (strncmp("transparent",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     Error("Missing color on -transparent",(char *) NULL);                  }                break;
             } 3           if (strncmp("treedepth",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'u': 	         { 4           if (strncmp("undercolor",option+1,2) == 0)
             { 2               image_info.undercolor=(char *) NULL;!               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))G                     Error("Missing undercolor geometry on -undercolor", %                       (char *) NULL); 0                   image_info.undercolor=argv[i];                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,1) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case '?': 	         {            Usage();           break;	         }          default:	         { .           Error("Unrecognized option",option);           break;	         }        }    }    if (image == (Image *) NULL)6     Error("Missing an image file name",(char *) NULL);   /*     Write images.    */   do   {      /*D       Transmogrify image as defined by the image processing options.     */+     (void) strcpy(image->filename,argv[i]); /     MogrifyImage(&image_info,argc,argv,&image); $     if (map_image != (Image *) NULL)&       MapImage(image,map_image,False);)     status=WriteImage(&image_info,image);      if (image_info.verbose)        DescribeImage(image);      next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL);    /*     Free image resources.    */+   while (image->previous != (Image *) NULL)      image=image->previous;   DestroyImages(image); "   if (map_image != (Image *) NULL)     DestroyImage(map_image);%   free((char *) image_info.filename); 
   exit(0);   return(False); } 