 .ad l  .nh ( .TH animate 1 "1 May 1994" "ImageMagick" .SH NAMEC animate - display a sequence of images on any workstation running X  .SH SYNOPSIS, .B "animate" [ \fIoptions\fP ...] \fIfile\fP& [ [ \fIoptions\fP ...] \fIfile\fP ...] .SH DESCRIPTION F \fBanimate\fP displays a sequence of images on any workstation displayA running an X server.  \fBanimate\fP first determines the hardware F capabilities of the workstation.  If the number of unique colors in anF image is less than or equal to the number the workstation can support,F the image is displayed in an X window.  Otherwise the number of colorsB in the image is first reduced to match the color resolution of the# workstation before it is displayed.  .PP J This means that a continuous-tone 24 bits-per-pixel image can display on aF 8 bit pseudo-color device or monochrome device.  In most instances theE reduced color image closely resembles the original.  Alternatively, a J monochrome or pseudo-color image sequence can display on a continuous-tone 24 bits-per-pixel device.  .PP G To help prevent color flashing on X server visuals that have colormaps, J \fBanimate\fP creates a single colormap from the image sequence.  This canF be rather time consuming.  You can speed this operation up by reducingE the colors in the image before you `animate' them.  Use \fBmogrify\fP J to color reduce the images to a single colormap.  See \fBmogrify(1)\fP forN details.  Alternatively, you can use a Standard Colormap; or a static, direct,> or true color visual.  You can define a Standard Colormap withO \fIxstdcmap\fP.  See \fBXSTDCMAP(1)\fP for details.  This method is recommended K for colormapped X server because it eliminates the need to compute a global 	 colormap.  .SH EXAMPLES. To animate a set of images of a cockatoo, use: .PP  .B      animate cockatoo.*  .PP F To animate a cockatoo image sequence while using the Standard Colormap "best", use: .PP  .B      xstdcmap -best  .B!      animate -map best cockatoo.*  .PP @ To animate an image of a cockatoo without a border centered on a backdrop, use: .PP  .B.      animate +borderwidth -backdrop cockatoo.* .SH OPTIONS  .TP 5  .B "-backdrop") display the image centered on a backdrop.   D This backdrop covers the entire workstation screen and is useful forL hiding other X window activity while viewing the image sequence.   The colorD of the backdrop is specified as the background color.  Refer to \fBX RESOURCES\fP for details.  .TP 5  .B "-colormap \fItype\fP" 4 the type of colormap: \fBShared\fP or \fBPrivate\fP.  < This option only applies when the default X server visual isF \fIPseudoColor\fP or \fIGrayScale\fP.  Refer to \fB-visual\fP for moreG details.  By default, a shared colormap is allocated.  The image shares F colors with other X clients.  Some image colors could be approximated,C therefore your image may look very different than intended.  Choose = \fBPrivate\fP and the image colors appear exactly as they are D defined.  However, other clients may go "technicolor" when the image colormap is installed. .TP 5  .B "-colors \fIvalue\fP"( preferred number of colors in the image.  G The actual number of colors in the image may be less than your request, E but never more.  Note, this is a color reduction option.  Images with I less unique colors than specified with this option will remain unchanged. , Refer to \fBquantize(9)\fP for more details.  K Note, options \fB-dither\fP, \fB-colorspace\fP, and \fB-treedepth\fP affect  the color reduction algorithm. .TP 5  .B "-colorspace \fIvalue\fP"E the type of colorspace: \fBGRAY\fP, \fBOHTA\fP, \fBRGB\fP, \fBXYZ\fP, 2 \fBYCbCr\fP, \fBYIQ\fP, \fBYPbPr\fP, or \fBYUV\fP.  @ Color reduction, by default, takes place in the RGB color space.F Empirical evidence suggests that distances in color spaces such as YUV> or YIQ correspond to perceptual color differences more closelyC than do distances in RGB space.  These color spaces may give better E results when color reducing an image.  Refer to \fBquantize(9)\fP for 
 more details.   I The \fB-colors\fP or \fB-monochrome\fP option is required for this option  to take effect.  .TP 5  .B "-delay \fImilliseconds\fP"% display the next image after pausing.   C This option is useful for regulating the display of the sequence of J images.  \fImilliseconds\fP milliseconds must expire before the display ofC the next image.  The default is 100 milliseconds between each frame  of the image sequence. .TP 5 E .B "-crop \fI<width>{%}x<height>{%}{\+-}<x offset>{\+-}<y offset>\fP" M preferred size and location of the cropped image.  See \fBX(1)\fP for details ! about the geometry specification.   M To specify a percentage width or height instead, append \fB%\fP.  For example P to crop the image by ten percent on all sides of the image, use \fB-crop 10%\fP.  B Use cropping to apply image processing options, or display, only aJ particular area of an image.  Use \fB-crop 0x0\fP to remove edges that are the background color.   ? The equivalent X resource for this option is \fBcropGeometry\fP ? (class \fBCropGeometry\fP).  See \fBX RESOURCES\fP for details.  .TP 5 # .B "-density \fI<width>x<height>\fP : vertical and horizontal resolution in pixels of the image.  M This option specifies an image density when decoding a Postscript or Portable G Document page.  The default is 72 pixels per inch in the horizontal and  vertical direction.  .TP 5 ) .B "-display \fIhost:display[.screen]\fP" 2 specifies the X server to contact; see \fBX(1)\fP. .TP 5  .B "-dither"3 apply Floyd/Steinberg error diffusion to the image.   D The basic strategy of dithering is to trade intensity resolution forF spatial resolution by averaging the intensities of several neighboringH pixels.  Images which suffer from severe contouring when reducing colors! can be improved with this option.   I The \fB-colors\fP or \fB-monochrome\fP option is required for this option  to take effect.  .TP 5  .B "-gamma \fIvalue\fP"  level of gamma correction.  E The same color image displayed on two different workstations may look ? different due to differences in the display monitor.  Use gamma B correction to adjust for this color difference.  Reasonable values extend from 0.8 to 2.3.   ? You can apply separate gamma values to the red, green, and blue D channels of the image with a gamma value list delineated with commas (i.e. 1.7,2.3,1.2).  .TP 5 R .B "-geometry \fI<width>{%}x<height>{%}{\+-}<x offset>{\+-}<y offset>{!}{<}{>}\fP"L preferred size and location of the Image window.  See \fBX(1)\fP for detailsK about the geometry specification.  By default, the window size is the image : size and the location is choosen by you when it is mapped.  B By default, the width and height are maximum values.  That is, theG image is expanded or contracted to fit the width and height value while G maintaining the aspect ratio of the image.  Append an exclamation point ? to the geometry to force the image size to exactly the size you G specify.  For example, if you specify \fB640x480!\fP the image width is ; set to 640 pixels and height to 480.  If only one factor is 6 specified, both the width and height assume the value.  E To specify a percentage width or height instead, append \fB%\fP.  The F image size is multiplied by the width and height percentages to obtainD the final image dimensions.  To increase the size of an image, use aG value greater than 100 (e.g. 125%).  To decrease an image's size, use a  percentage less than 100.   < Use \fB<\fP to change the dimensions of the image \fIonly\fP@ if its size exceeds the geometry specification.  \fB>\fP resizes@ the image \fIonly\fP if its dimensions is less than the geometryB specification.  For example, if you specify \fB640x480>\fP and theC image size is 512x512, the image size does not change.  However, if 1 the image is 1024x1024, it is resized to 640x480.   = When displaying an image on an X server, \fI<x offset>\fP and 0 \fI<y offset>\fP is relative to the root window.  ; The equivalent X resource for this option is \fBgeometry\fP ; (class \fBGeometry\fP).  See \fBX RESOURCES\fP for details.  .TP 5  .B "-interlace \fItype\fP"G the type of interlacing scheme: \fBNONE\fP, \fBLINE\fP, or \fBPLANE\fP.   E This option is used to specify the type of interlacing scheme for raw F image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNONE\fP means do not; interlace (RGBRGBRGBRGBRGBRGB...), \fBLINE\fP uses scanline H interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPLANE\fP uses0 plane interlacing (RRRRRR...GGGGGG...BBBBBB...).  A Use \fBLINE\fP, or \fBPLANE\fP to create an interlaced GIF image.  .TP 5  .B "-map \fItype\fP"0 display image using this Standard Colormap type.  * Choose from these Standard Colormap types:       best     default      gray     red 	     green      blue  H The X server must support the Standard Colormap you choose, otherwise anG error occurs.  Use \fBlist\fP as the type and \fBanimate(1)\fP searches K the list of colormap types in top-to-bottom order until one is located. See = \fBxstdcmap(1)\fP for one way of creating Standard Colormaps.  .TP 5  .B "-monochrome"' transform the image to black and white.  .TP 5  .B "-scene \fIvalue{-value}\fP"  image scene number.   H Use this option to specify an image sequence with a single filename. See/ the discussion of \fIfile\fP below for details.  .TP 5 0 .B "-size \fI<width>{%}x<height>{%}{+offset}{!}" width and height of the image.  C Use this option to specify the width and height of raw images whose D dimensions are unknown such as \fBGRAY\fP, \fBRGB\fP, or \fBCMYK\fP.C In addition to width and height, use \fB-size\fP to skip any header D information in the image or tell the number of colors in a \fBMAP\fP% image file, (e.g. -size 640x512+256).  .TP 5  .B "-treedepth \fIvalue\fP" A Normally, this integer value is zero or one.  A zero or one tells D \fBanimate\fP to choose a optimal tree depth for the color reduction
 algorithm.  G An optimal depth generally allows the best representation of the source B image with the fastest computational speed and the least amount ofE memory.  However, the default depth is inappropriate for some images. F To assure the best representation, try values between 2 and 8 for this8 parameter.  Refer to \fBquantize(9)\fP for more details.  I The \fB-colors\fP or \fB-monochrome\fP option is required for this option  to take effect.  .TP 5  .B -verbose + print detailed information about the image.   D This information is printed: image scene number;  image name;  imageJ size; the image class (\fIDirectClass\fP or \fIPseudoClass\fP);  the total? number of unique colors;  and the number of seconds to read and A transform the image.  Refer to \fBmiff(5)\fP for a description of  the image class.  H If \fB-colors\fP is also specified, the total unique colors in the imageI and color reduction error values are printed.  Refer to \fBquantize(9)\fP " for a description of these values. .TP 5  .B "-visual \fItype\fP" & animate images using this visual type.  ! Choose from these visual classes:        StaticGray
     GrayScale      StaticColor      PseudoColor 
     TrueColor      DirectColor      default      \fIvisual id\fP   K The X server must support the visual you choose, otherwise an error occurs. H If a visual is not specified, the visual class that can display the most5 simultaneous colors on the default screen is choosen.  .TP 5  .B "-window \fIid\fP" 6 set the background pixmap of this window to the image.  K \fIid\fP can be a window id or name.  Specify \fBroot\fP to select X's root  window as the target window.  ? By default the image is tiled onto the background of the target B window.   If \fB-backdrop\fP or \fB-geometry\fP are specified, the; image is surrounded by the background color.  Refer to \fBX  RESOURCES\fP for details.   C The image will not display on the root window if the image has more : unique colors than the target window colormap allows.  Use- \fB-colors\fP to reduce the number of colors.  .PP C In addition to those listed above, you can specify these standard X 6 resources as command line options:  \fB-background\fP,5 \fB-bordercolor\fP, \fB-borderwidth\fP,  \fB-font\fP, I \fB-foreground\fP, \fB-iconGeometry\fP, \fB-iconic\fP, \fB-mattecolor\fP, A \fB-name\fP, or \fB-title\fP.  See \fBX RESOURCES\fP for details.  .PP H Any option you specify on the command line remains in effect until it isJ explicitly changed by specifying the option again with a different effect.D For example, to animate two images, the first with 32 colors and the  second with only 16 colors, use: .PP 8      animate -colors 32 cockatoo.1 -colors 16 cockatoo.2 .PP , Options are processed in command line order.H Any option you specify on the command line remains in effect until it isJ explicitly changed by specifying the option again with a different effect. .PP E Change \fI-\fP to \fI\+\fP in any option above to reverse its effect. M For example, specify \fB\+dither\fP to not apply error diffusion to an image.  .PP B By default, the image format is determined by its magic number. ToE specify a particular image format, precede the filename with an image D format name and a colon (i.e. ps:image) or specify the image type asE the filename suffix (i.e. image.ps).  See \fBconvert(1)\fP for a list  of valid image formats.  .PP E When you specify \fBX\fP as your image type, the filename has special E meaning.  It specifies an X window by id, name, or \fBroot\fP.  If no F filename is specified, the window is selected by clicking the mouse in the desired window.  .PP G Specify \fIfile\fP as \fI-\fP for standard input, If \fIfile\fP has the > extension \fB.Z\fP or \fB.gz\fP, the file is uncompressed withE \fBuncompress\fP or \fBgunzip\fP respectively. Precede the image file 0 name with \fI|\fP to pipe from a system command. .PP G Use an optional index enclosed in brackets after a file name to specify C a desired subimage of a multi-resolution image format like Photo CD I (e.g. img0001.pcd[4]) or a range for MPEG images (e.g. video.mpg[50-75]).  .PP E Single images are read with the filename you specify.  Alternatively, E you can animate an image sequence with a single filename.  Define the A range of the image sequence with \fI-scene\fP.  Each image in the > range is read with the filename followed by a period (\fB.\fP)B and the scene number.  You can change this behavior by embedding aA \fBprintf\fP format specification in the file name.  For example,  .nf !         -scene 0-9 image%02d.miff  .fi @ animates files image00.miff, image01.miff, through image09.miff. .PP H Image filenames may appear in any order on the command line if the imageK format is \fIMIFF\fP (refer to \fBmiff(5)\fP and the \fBscene\fP keyword is G specified in the image.  Otherwise the images will display in the order   they appear on the command line. .SH BUTTONS 9 Press any button to map or unmap the Command widget.  See ? the next section for more information about the Command widget.  .SH COMMAND WIDGETF The Command widget lists a number of sub-menus and commands.  They are  	   Animate      Play     Step
     Repeat     Auto Reverse   Speed 
     Slower
     Faster   Direction      Forward      Reverse    Image Info   Help   Quit .PP > Menu items with a indented triangle have a sub-menu.  They areD represented above as the indented items.  To access a sub-menu item,E move the pointer to the appropriate menu and press a button and drag. C When you find the desired sub-menu item, release the button and the D command is executed.  Move the pointer away from the sub-menu if you+ decide not to execute a particular command.  .SH KEYBOARD ACCELERATORS  .TP 5  .B "p"( Press to animate the sequence of images. .TP 5  .B "s"0 Press to display the next image in the sequence. .TP 5  .B "."4 Press to continually display the sequence of images. .TP 5  .B "a"6 Press to automatically reverse the sequence of images. .TP 5  .B "<"H Press to slow the display of the images.  Refer to \fB-delay\fP for more information. .TP 5  .B ">"L Press to speed-up the display of the images.  Refer to \fB-delay\fP for more information. .TP 5  .B "f"* Press to animate in the forward direction. .TP 5  .B "r"* Press to animate in the reverse direction. .TP 5  .B "i"F Press to display information about the image.  Press any key or button to erase the information.   C This information is printed: image name;  image size; and the total % number of unique colors in the image.  .TP 5  .B "h"< Press to display helpful information about \fBanimate(1)\fP.  I Function keys \fIHELP\fP or \fIF1\fP are synonymous with the \fIh\fP key.  .TP 5  .B "q"- Press to discard all images and exit program.  .SH "X RESOURCES" A \fBanimate\fP options can appear on the command line or in your X F resource file.  Options on the command line supersede values specifiedB in your X resource file.  See \fBX(1)\fP for more information on X
 resources.  H All \fBanimate\fP options have a corresponding X resource.  In addition,9 the \fBanimate\fP program uses the following X resources:  .TP 5 & .B background (\fIclass\fP Background)J Specifies the preferred color to use for the Image window background.  The default is #ccc. .TP 5 ( .B borderColor (\fIclass\fP BorderColor)F Specifies the preferred color to use for the Image window border.  The default is black.  .TP 5 ( .B borderWidth (\fIclass\fP BorderWidth)L Specifies the width in pixels of the Image window border.  The default is 2. .TP 5 & .B font (\fIclass\fP Font or FontList)C Specifies the name of the preferred font to use in normal formatted / text.  The default is 14 point \fIHelvetica\fP.  .TP 5 & .B foreground (\fIclass\fP Foreground)K Specifies the preferred color to use for text within the Image window.  The  default is black.  .TP 5 " .B geometry (\fIclass\fP geometry)> Specifies the preferred size and position of the image window.4 It is not necessarily obeyed by all window managers. .TP 5 * .B iconGeometry (\fIclass\fP IconGeometry)A Specifies the preferred size and position of the application when @ iconified.  It is not necessarily obeyed by all window managers. .TP 5  .B iconic (\fIclass\fP Iconic)D This resource indicates that you would prefer that the application'sE windows initially not be visible as if the windows had be immediately > iconified by you.  Window managers may choose not to honor the application's request. .TP 5 & .B matteColor (\fIclass\fP MatteColor)@ Specify the color of windows.  It is used for the backgrounds of< windows, menus, and notices.  A  3D  effect  is achieved  byC using highlight and shadow colors derived from this color.  Default  value: #ddd. .TP 5  .B name (\fIclass\fP Name)> This resource specifies the name under which resources for theI application should be found.  This resource is useful in shell aliases to G distinguish between invocations of an application, without resorting to E creating links to alter the executable file name.  The default is the  application name.  .TP 5 * .B sharedMemory (\fIclass\fP SharedMemory)H This resource specifies whether animate should attempt use shared memoryF for pixmaps.  ImageMagick must be compiled with shared memory support,D and the display must support the MIT-SHM extension.  Otherwise, this* resource is ignored.  The default is True. .TP 5 # .B text_font (\fIclass\fP textFont) K Specifies the name of the preferred font to use in fixed (typewriter style) 7 formatted text.  The default is 14 point \fICourier\fP.  .TP 5  .B title (\fIclass\fP Title)H This resource specifies the title to be used for the Image window.  ThisF information is sometimes used by a window manager to provide some sortF of header identifying the window.  The default is the image file name. .SH ENVIRONMENT  .TP 5 
 .B display4 To get the default host, display number, and screen. .SH SEE ALSO .B: display(1), import(1), montage(1), mogrify(1), convert(1), segment(1), combine(1), xtp(1)
 .SH COPYRIGHT 3 Copyright 1995 E. I. du Pont de Nemours and Company  .PP G Permission to use, copy, modify, distribute, and sell this software and @ its documentation for any purpose is hereby granted without fee,F provided that the above copyright notice appear in all copies and that? both that copyright notice and this permission notice appear in G supporting documentation, and that the name of E. I. du Pont de Nemours A and Company not be used in advertising or publicity pertaining to < distribution of the software without specific, written priorJ permission.  E. I. du Pont de Nemours and Company makes no representationsG about the suitability of this software for any purpose.  It is provided , "as is" without express or implied warranty. .PP I E. I. du Pont de Nemours and Company disclaims all warranties with regard E to this software, including all implied warranties of merchantability F and fitness, in no event shall E. I. du Pont de Nemours and Company be@ liable for any special, indirect or consequential damages or anyG damages whatsoever resulting from loss of use, data or profits, whether F in an action of contract, negligence or other tortuous action, arisingE out of or in connection with the use or performance of this software.  .SH ACKNOWLEDGEMENTSG The MIT X Consortium for making network transparent graphics a reality.  .PP < Michael Halle, Spatial Imaging Group at MIT, for the initial8 implementation of Alan Paeth's image rotation algorithm. .PP C David Pensak, E. I. du Pont de Nemours and Company, for providing a 6 computing environment that made this program possible. .PP C Paul Raveling, USC Information Sciences Institute, for the original B idea of using space subdivision for the color reduction algorithm. .SH AUTHORS = John Cristy, E.I. du Pont de Nemours and Company Incorporated 