/*
**
** FileSel.h
**
** Copyright (C) 1995, 1996 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@dipmza.physik.uni-mainz.de)
**           Department of Physic
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/


#ifndef _XawFileSelection_h
#define _XawFileSelection_h

#include INC_X11(Xfuncproto.h)

#define XawFileSelectionPath 1
#define XawFileSelectionFile 2
#define XawFileSelectionBoth 3

#define XawFileSelectionRescan 	1
#define XawFileSelectionFilter 	2
#define XawFileSelectionDefaultScan 	3
#define XawFileSelectionDone 		4
#define XawFileSelectionCancel 	5

/* New Fields */

#define XtNpath "path"
#define XtCPath "Path"

#define XtNviewMode "viewMode"
#define XtCViewMode "ViewMode"
#define XtRViewMode "ViewMode"

#define XtNviewOrder "viewOrder"
#define XtCViewOrder "ViewOrder"

#define XtNhighlightPixel "highlightPixel"
#define XtCHighlightPixel "HighlightPixel"

#define XtNbuttons "buttons"
#define XtCButtons "Buttons"

#define XtNpreferredButton "preferredButton"
#define XtCPreferredButton "PreferredButton"

/* Class record constant */

extern WidgetClass file_selectionWidgetClass;

typedef struct _FileSelectionClassRec	*FileSelectionWidgetClass;
typedef struct _FileSelectionRec	*FileSelectionWidget;

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   PUBLIC ROUTINES
-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/   

_XFUNCPROTOBEGIN

extern void XawFileSelectionSetSelection(
#if NeedFunctionPrototypes
    Widget		/* FileSelectionWidget */,
    String		/* String to set */,
    int			/* indicates if Path or File should be set */
#endif
);

extern char * XawFileSelectionGetSelection(
#if NeedFunctionPrototypes
    Widget		/* FileSelectionWidget */,
    int			/* indicates if Path,File or Both should be extracted */
#endif
);

extern void XawFileSelectionScan(
#if NeedFunctionPrototypes
    Widget		/* FileSelectionWidget */,
    int			/* indicates the scan mode */
#endif
);

extern void XawFileSelectionAddButton(
#if NeedFunctionPrototypes
   Widget              /* FileSelectionWidget */,
   int                 /* indicates the desired button position */,
   XtCallbackProc      /* callback for the button */,
   XtPointer           /* callback parameter */
#endif
);

extern void XawFileSelectionRemoveButton(
#if NeedFunctionPrototypes
   Widget               /* FileSelectionWidget */,
   int                  /* indicates the position of the button */
#endif
);

_XFUNCPROTOEND

#endif /* _FileSelection_h */
