/* DWprofile table definitions */

#include uaidef
#include <X11/Intrinsic.h>
#include <Mrm/MrmAppl.h>

#define NO 0
#define OFF 0
#define ON 1

#define k_widget_uic_trans 7    /* unused UAI codes */
#define k_widget_held_list 8    /* for non-UAI widgets */
#define k_widget_all_list  9

#define k_hours_height 16
#define MAX_WIDGET UAI$_MAX_ITEM_CODE
#define PRIVS_BIAS 40
#define MAX_PRIVS PRIVS_BIAS * 2
#define MAX_PRIME 7     /* number of prime day widgets */
#define MAX_FLAGS 20    /* number of flag widgets */
#define access_menu 0
#define accounts_menu 1
#define idents_menu 2
#define privs_menu 3
#define functions_menu 4
#define find_menu 5
#define find_button 6
#define restart_button 7
#define MAX_MENUS (restart_button + 1)
#define SDATA_LEN 65   /* size of largest UAI item + 1 */

/* Type of UAF element */

#define DWP_LALPHA	1	/* Alpha with length byte */
#define DWP_INT		2	/* Integer */
#define DWP_TIME	3	/* 3 byte time vector */
#define DWP_DATE	4	/* Date */
#define DWP_PRIV	5	/* Priv vector */
#define DWP_FLAG	6	/* Login flags */
#define DWP_UIC		7	/* UIC */
#define DWP_PRIME	8	/* Primary/seconday days */
#define DWP_ENCR	9	/* Encrypted password */
#define DWP_ALPHA	10	/* Alpha, no length byte */
#define DWP_CPU		11	/* CPU time in 10 ms units */
#define DWP_RDATE	12	/* Read-only Date */
#define DWP_RINT	13	/* Read-only Integer */

/* array of UAF elements */
struct {
    int code, size, type;
} items[] = {
    {UAI$_ACCOUNT, 32, DWP_ALPHA},
    {UAI$_ASTLM, 2, DWP_INT},
    {UAI$_BATCH_ACCESS_P, 3, DWP_TIME},
    {UAI$_BATCH_ACCESS_S, 3, DWP_TIME},
    {UAI$_BIOLM, 2, DWP_INT},
    {UAI$_BYTLM, 4, DWP_INT},
    {UAI$_CLITABLES, 32, DWP_LALPHA},
    {UAI$_CPUTIM, 4, DWP_CPU},
    {UAI$_DEFCLI, 32, DWP_LALPHA},
    {UAI$_DEFDEV, 32, DWP_LALPHA},
    {UAI$_DEFDIR, 64, DWP_LALPHA},
    {UAI$_DEF_PRIV, 8, DWP_PRIV},
    {UAI$_DFWSCNT, 4, DWP_INT},
    {UAI$_DIOLM, 2, DWP_INT},
    {UAI$_DIALUP_ACCESS_P, 3, DWP_TIME},
    {UAI$_DIALUP_ACCESS_S, 3, DWP_TIME},
    {UAI$_ENQLM, 2, DWP_INT},
    {UAI$_EXPIRATION, 8, DWP_DATE},
    {UAI$_FILLM, 2, DWP_INT},
    {UAI$_FLAGS, 4, DWP_FLAG},
    {UAI$_JTQUOTA, 4, DWP_INT},
    {UAI$_LGICMD, 64, DWP_LALPHA},
    {UAI$_LASTLOGIN_I, 8, DWP_RDATE},
    {UAI$_LASTLOGIN_N, 8, DWP_RDATE},
    {UAI$_LOCAL_ACCESS_P, 3, DWP_TIME},
    {UAI$_LOCAL_ACCESS_S, 3, DWP_TIME},
    {UAI$_LOGFAILS, 2, DWP_RINT},
    {UAI$_MAXACCTJOBS, 2, DWP_INT},
    {UAI$_MAXDETACH, 2, DWP_INT},
    {UAI$_MAXJOBS, 2, DWP_INT},
    {UAI$_NETWORK_ACCESS_P, 3, DWP_TIME},
    {UAI$_NETWORK_ACCESS_S, 3, DWP_TIME},
    {UAI$_OWNER, 32, DWP_LALPHA},
    {UAI$_PBYTLM, 4, DWP_INT},
    {UAI$_PGFLQUOTA, 4, DWP_INT},
    {UAI$_PRCCNT, 2, DWP_INT},
    {UAI$_PRI, 1, DWP_INT},
    {UAI$_PRIMEDAYS, 1, DWP_PRIME},
    {UAI$_PRIV, 8, DWP_PRIV},
    {UAI$_PWD, 8, DWP_ENCR},
    {UAI$_PWD_DATE, 8, DWP_RDATE},
    {UAI$_PWD_LENGTH, 1, DWP_INT},
    {UAI$_PWD_LIFETIME, 8, DWP_DATE},
    {UAI$_PWD2_DATE, 8, DWP_RDATE},
    {UAI$_QUEPRI, 1, DWP_INT},
    {UAI$_REMOTE_ACCESS_P, 3, DWP_TIME},
    {UAI$_REMOTE_ACCESS_S, 3, DWP_TIME},
    {UAI$_SHRFILLM, 2, DWP_INT},
    {UAI$_TQCNT, 2, DWP_INT},
    {UAI$_UIC, 4, DWP_UIC},
    {UAI$_USERNAME, 12, DWP_ALPHA},
    {UAI$_WSEXTENT, 4, DWP_INT},
    {UAI$_WSQUOTA, 4, DWP_INT}, 
    {0, 0, 0}
};

/* array of UAF elements that can be selected for the 'find' button */
/* indexed by k_*_select in buttons.uil */
struct {
    int code, size, type;
    String name;
} select_data[] = {
    {UAI$_USERNAME, 12, DWP_ALPHA, "Username"},
    {UAI$_ACCOUNT, 32, DWP_ALPHA, "Account"},
    {UAI$_OWNER, 32, DWP_LALPHA, "Owner"},
    {UAI$_UIC, 4, DWP_UIC, "UIC"},
    {UAI$_DEFDEV, 32, DWP_LALPHA, "Device"},
    {UAI$_DEFDIR, 64, DWP_LALPHA, "Directory"},
    {UAI$_DEFCLI, 32, DWP_LALPHA, "CLI"},
    {UAI$_LGICMD, 64, DWP_LALPHA, "LGICMD"},
    {UAI$_CLITABLES, 32, DWP_LALPHA, "DCL Table"},
    {UAI$_PWD_LIFETIME, 8, DWP_DATE, "Pwdlifetime"},
    {UAI$_EXPIRATION, 8, DWP_DATE, "Expire Date"},
    {UAI$_LOGFAILS, 2, DWP_RINT, "Login failures"},
    { 0, 0, 0, (char *) NULL}
};


/* ubiquitous itemlist3 */
struct itemlist3 {
    short buflen;
    short itmcode;
    caddr_t bufadr;
    short *retadr;
};

typedef unsigned short int ushort;

/* Identifier list node structure */
typedef struct ident_node {
    String name;         /* name of identifier */
    Cardinal identifier; /* value of identifier */
    enum {uic_ident, account, intern_ident, user_ident} status;
                         /* uic_ident = [n,m] type identifier */
                         /* account = [n,*] type identifier */
                         /* intern_ident = interactive, batch, sys$node_x */
                         /* user_ident = regular identifier (%x080010000+n) */
    struct ident_node *next;
} ident;

/* Held identifier list node structure */
typedef struct held_node {
    String name;         /* name of identifier */
    Cardinal identifier; /* value of identifier */
    enum {original, del_orig, add_ident} status;
                         /* original = identifier was held when user read in */
                         /* del_orig = original identifier to be removed upon write */
                         /* add_ident = identifier to be added upon write */
    struct held_node *next;
} held_ident;


/* non-widget resources */
typedef struct {
    Cardinal quota, overdraft, version_limit, minimum_group, maximum_group,
        hour_size;
    int read_interval, write_interval, find_interval;
    String default_ident;
    Boolean show_access, show_accounts, show_idents, show_privs, show_work;
} ApplicationData, *ApplicationDataPtr;

static XtResource resources[] = {
    {"defaultIdent", "DefaultIdent", XtRString, sizeof(String),
     XtOffset(ApplicationDataPtr, default_ident), XtRString, ""},
    {"hourSize", "HourSize", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, hour_size), XtRString, "7"},
    {"readNotifyInterval", "PopupTime", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, read_interval), XtRString, "-2"},
    {"writeNotifyInterval", "PopupTime", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, write_interval), XtRString, "-2"},
    {"findNotifyInterval", "PopupTime", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, find_interval), XtRString, "-1"},
    {"overdraft", "Overdraft", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, overdraft), XtRString, "0"},
    {"quota", "Quota", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, quota), XtRString, "0"},
    {"showAccess", "ShowAccess", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, show_access), XtRString, "False"},
    {"showAccounts", "AutoShow", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, show_accounts), XtRString, "False"},
    {"showPrivs", "AutoShow", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, show_privs), XtRString, "False"},
    {"showIdents", "AutoShow", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, show_idents), XtRString, "False"},
    {"showWorkBox", "AutoShow", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, show_work), XtRString, "True"},
    {"versionLimit", "VersionLimit", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, version_limit), XtRString, "0"},
    {"minimumGroup", "MinimumGroup", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, minimum_group), XtRString, "0"},
    {"maximumGroup", "MaximumGroup", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, maximum_group), XtRString, "32767"}
};

#define dwp32_width 32
#define dwp32_height 32
static char dwp32_bits[] = {
   0x00, 0x00, 0x20, 0x80, 0xfe, 0xff, 0xaf, 0xbf, 0x82, 0x20, 0xa8, 0xaa,
   0xfe, 0xff, 0xaf, 0xbf, 0x82, 0x20, 0xa8, 0xaa, 0xfe, 0xff, 0xaf, 0xbf,
   0x82, 0x20, 0xa8, 0xaa, 0xfe, 0xff, 0xaf, 0xbf, 0xaa, 0xaa, 0xaa, 0xaa,
   0xfe, 0xff, 0xaf, 0xbf, 0xaa, 0xaa, 0xaa, 0xaa, 0xfe, 0xff, 0xaf, 0xbf,
   0xfe, 0xff, 0x2f, 0x80, 0xe2, 0x38, 0xee, 0xff, 0xfe, 0xff, 0xef, 0xff,
   0xe2, 0x38, 0xee, 0xff, 0xfe, 0xff, 0xef, 0xff, 0xe2, 0x38, 0xee, 0xff,
   0xfe, 0xff, 0xef, 0xff, 0xe2, 0x38, 0xee, 0xff, 0xfe, 0xff, 0xef, 0xff,
   0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0xe0, 0xff, 0xfe, 0xff, 0xef, 0xff, 0x02, 0x06, 0xe8, 0xff,
   0xfe, 0xff, 0xef, 0xff, 0x02, 0x06, 0xe8, 0xff, 0xfe, 0xff, 0xef, 0xff,
   0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff};

static String uidname[] = {
    "DWPUID:DWPROFILE.UID",
    "DWPUID:ACCESS.UID",
    "DWPUID:PRIVS.UID",
    "DWPUID:IDENTS.UID",
};

#define HELP_LIBRARY "DWPUID:DWPROFILE.HLB"
