
# line 68 "gram.y"
#include <stdio.h>
#include <ctype.h>
#include "twm.h"
#include "menus.h"
#include "icons.h"
#include "list.h"
#include "util.h"
#include "screen.h"
#include "parse.h"
#ifdef VMS
#include <decw$include/Xos.h>
#include <X11Xmu/CharSet.h>
#else
#include <X11/Xos.h>
#include <X11/Xmu/CharSet.h>
#endif

static char *Action = "";
static char *Name = "";
static char *defstring = "default";
static MenuRoot	*root, *pull = NULL;
static char *curWorkSpc;
static char *client, *workspace;
static MenuItem *lastmenuitem = (MenuItem*) 0;

static MenuRoot *GetRoot();

static Bool CheckWarpScreenArg(), CheckWarpRingArg();
static Bool CheckColormapArg();
static void GotButton(), GotKey(), GotTitleButton();
static char *ptr;
static name_list **list;
static int cont = 0;
static int color;
int mods = 0;
unsigned int mods_used = (ShiftMask | ControlMask | Mod1Mask);

extern int do_single_keyword(), do_string_keyword(), do_number_keyword();
extern name_list **do_colorlist_keyword();
extern int do_color_keyword(), do_string_savecolor();
extern int yylineno;

# line 106 "gram.y"
typedef union 
{
    int num;
    char *ptr;
} YYSTYPE;
#ifdef __cplusplus
#  include <stdio.h>
   extern "C" {
     extern void yyerror(char *);
     extern int yylex();
   }
#endif	/* __cplusplus */ 
# define LB 257
# define RB 258
# define LP 259
# define RP 260
# define MENUS 261
# define MENU 262
# define BUTTON 263
# define DEFAULT_FUNCTION 264
# define PLUS 265
# define MINUS 266
# define ALL 267
# define OR 268
# define CURSORS 269
# define PIXMAPS 270
# define ICONS 271
# define COLOR 272
# define SAVECOLOR 273
# define MONOCHROME 274
# define FUNCTION 275
# define ICONMGR_SHOW 276
# define ICONMGR 277
# define ALTER 278
# define WINDOW_FUNCTION 279
# define ZOOM 280
# define ICONMGRS 281
# define ICONMGR_GEOMETRY 282
# define ICONMGR_NOSHOW 283
# define MAKE_TITLE 284
# define ICONIFY_BY_UNMAPPING 285
# define DONT_ICONIFY_BY_UNMAPPING 286
# define NO_BORDER 287
# define NO_ICON_TITLE 288
# define NO_TITLE 289
# define AUTO_RAISE 290
# define NO_HILITE 291
# define ICON_REGION 292
# define META 293
# define SHIFT 294
# define LOCK 295
# define CONTROL 296
# define WINDOW 297
# define TITLE 298
# define ICON 299
# define ROOT 300
# define FRAME 301
# define COLON 302
# define EQUALS 303
# define SQUEEZE_TITLE 304
# define DONT_SQUEEZE_TITLE 305
# define START_ICONIFIED 306
# define NO_TITLE_HILITE 307
# define TITLE_HILITE 308
# define MOVE 309
# define RESIZE 310
# define WAITC 311
# define SELECT 312
# define KILL 313
# define LEFT_TITLEBUTTON 314
# define RIGHT_TITLEBUTTON 315
# define NUMBER 316
# define KEYWORD 317
# define NKEYWORD 318
# define CKEYWORD 319
# define CLKEYWORD 320
# define FKEYWORD 321
# define FSKEYWORD 322
# define SKEYWORD 323
# define DKEYWORD 324
# define JKEYWORD 325
# define WINDOW_RING 326
# define WARP_CURSOR 327
# define ERRORTOKEN 328
# define NO_STACKMODE 329
# define ALWAYS_ON_TOP 330
# define WORKSPACE 331
# define WORKSPACES 332
# define WORKSPCMGR_GEOMETRY 333
# define OCCUPYALL 334
# define OCCUPYLIST 335
# define MAPWINDOWCURRENTWORKSPACE 336
# define MAPWINDOWDEFAULTWORKSPACE 337
# define OPAQUEMOVE 338
# define NOOPAQUEMOVE 339
# define OPAQUERESIZE 340
# define NOOPAQUERESIZE 341
# define CHANGE_WORKSPACE_FUNCTION 342
# define DEICONIFY_FUNCTION 343
# define ICONIFY_FUNCTION 344
# define STRING 345
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
YYSTYPE yylval;
__YYSCLASS YYSTYPE yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 884 "gram.y"

yyerror(s) char *s;
{
    twmrc_error_prefix();
    fprintf (stderr, "error in input file:  %s\n", s ? s : "");
    ParseError = 1;
}
RemoveDQuote(str)
char *str;
{
    register char *i, *o;
    register n;
    register count;

    for (i=str+1, o=str; *i && *i != '\"'; o++)
    {
	if (*i == '\\')
	{
	    switch (*++i)
	    {
	    case 'n':
		*o = '\n';
		i++;
		break;
	    case 'b':
		*o = '\b';
		i++;
		break;
	    case 'r':
		*o = '\r';
		i++;
		break;
	    case 't':
		*o = '\t';
		i++;
		break;
	    case 'f':
		*o = '\f';
		i++;
		break;
	    case '0':
		if (*++i == 'x')
		    goto hex;
		else
		    --i;
	    case '1': case '2': case '3':
	    case '4': case '5': case '6': case '7':
		n = 0;
		count = 0;
		while (*i >= '0' && *i <= '7' && count < 3)
		{
		    n = (n<<3) + (*i++ - '0');
		    count++;
		}
		*o = n;
		break;
	    hex:
	    case 'x':
		n = 0;
		count = 0;
		while (i++, count++ < 2)
		{
		    if (*i >= '0' && *i <= '9')
			n = (n<<4) + (*i - '0');
		    else if (*i >= 'a' && *i <= 'f')
			n = (n<<4) + (*i - 'a') + 10;
		    else if (*i >= 'A' && *i <= 'F')
			n = (n<<4) + (*i - 'A') + 10;
		    else
			break;
		}
		*o = n;
		break;
	    case '\n':
		i++;	/* punt */
		o--;	/* to account for o++ at end of loop */
		break;
	    case '\"':
	    case '\'':
	    case '\\':
	    default:
		*o = *i++;
		break;
	    }
	}
	else
	    *o = *i++;
    }
    *o = '\0';
}

static MenuRoot *GetRoot(name, fore, back)
char *name;
char *fore, *back;
{
    MenuRoot *tmp;

    tmp = FindMenuRoot(name);
    if (tmp == NULL)
	tmp = NewMenuRoot(name);

    if (fore)
    {
	int save;

	save = Scr->FirstTime;
	Scr->FirstTime = TRUE;
	GetColor(COLOR, &tmp->highlight.fore, fore);
	GetColor(COLOR, &tmp->highlight.back, back);
	Scr->FirstTime = save;
    }

    return tmp;
}

static void GotButton (butt, func)
int butt, func;
{
    int i;
    MenuRoot *menu;
    MenuItem *item;

    for (i = 0; i < NUM_CONTEXTS; i++) {
	if ((cont & (1 << i)) == 0) continue;

	if (func == F_MENU) {
	    pull->prev = NULL;
	    AddFuncButton (butt, i, mods, func, pull, (MenuItem*) 0);
	}
	else {
	    root = GetRoot (TWM_ROOT, NULLSTR, NULLSTR);
	    item = AddToMenu (root, "x", Action, NULLSTR, func, NULLSTR, NULLSTR);
	    AddFuncButton (butt, i, mods, func, (MenuRoot*) 0, item);
	}
    }

    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}

static void GotKey(key, func)
char *key;
int func;
{
    int i;

    for (i = 0; i < NUM_CONTEXTS; i++)
    {
	if ((cont & (1 << i)) == 0) 
	  continue;

	if (func == F_MENU) {
	    pull->prev = NULL;
	    if (!AddFuncKey (key, i, mods, func, pull, Name, Action)) break;
	}
	else
	if (!AddFuncKey(key, i, mods, func, (MenuRoot*) 0, Name, Action)) 
	  break;
    }

    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}


static void GotTitleButton (bitmapname, func, rightside)
    char *bitmapname;
    int func;
    Bool rightside;
{
    if (!CreateTitleButton (bitmapname, func, Action, pull, rightside, True)) {
	twmrc_error_prefix();
	fprintf (stderr, 
		 "unable to create %s titlebutton \"%s\"\n",
		 rightside ? "right" : "left", bitmapname);
    }
    Action = "";
    pull = NULL;
}

static Bool CheckWarpScreenArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0 ||
	strcmp (s,  WARPSCREEN_BACK) == 0)
      return True;

    for (; *s && isascii(*s) && isdigit(*s); s++) ; /* SUPPRESS 530 */
    return (*s ? False : True);
}


static Bool CheckWarpRingArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0)
      return True;

    return False;
}


static Bool CheckColormapArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s, COLORMAP_NEXT) == 0 ||
	strcmp (s, COLORMAP_PREV) == 0 ||
	strcmp (s, COLORMAP_DEFAULT) == 0)
      return True;

    return False;
}


twmrc_error_prefix ()
{
    fprintf (stderr, "%s:  line %d:  ", ProgramName, yylineno);
}
__YYSCLASS yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 1,
	-2, 0,
-1, 17,
	257, 24,
	-2, 26,
-1, 18,
	257, 27,
	-2, 29,
-1, 19,
	257, 30,
	-2, 32,
-1, 20,
	257, 33,
	-2, 35,
-1, 21,
	257, 36,
	-2, 38,
-1, 30,
	257, 57,
	-2, 59,
-1, 33,
	257, 64,
	-2, 66,
-1, 34,
	257, 67,
	-2, 69,
-1, 36,
	257, 72,
	-2, 74,
-1, 38,
	257, 77,
	-2, 79,
-1, 39,
	257, 80,
	-2, 82,
-1, 42,
	257, 87,
	-2, 89,
-1, 54,
	257, 109,
	-2, 111,
-1, 55,
	257, 112,
	-2, 114,
-1, 59,
	257, 205,
	-2, 204,
-1, 60,
	257, 208,
	-2, 207,
-1, 253,
	257, 221,
	-2, 220,
-1, 278,
	257, 10,
	-2, 9,
-1, 335,
	257, 192,
	-2, 191,
	};
# define YYNPROD 281
# define YYLAST 655
__YYSCLASS yytabelem yyact[]={

    25,    82,   218,   348,    69,    62,   318,   320,    86,   272,
    63,    64,    65,   331,   337,   180,   316,   319,   124,    84,
    85,   360,   361,    79,    80,    81,    84,    85,   394,   390,
   382,   379,   317,    62,    69,   341,   311,   312,   313,   314,
   315,   309,   387,   339,   106,   107,   141,   139,   254,    88,
    62,   112,   113,   114,   115,   116,   343,   328,   119,   262,
   281,   294,    24,   279,   398,   356,    61,   354,   166,   364,
   363,   275,    69,   219,   375,     4,    84,    85,   276,   265,
   370,    43,    61,    49,    62,   259,   143,   257,    16,    15,
    45,    46,    47,    48,    44,    32,    62,   251,    50,    14,
    31,    10,    30,    40,    17,    26,    37,    38,    39,    42,
    34,     9,    68,   201,   243,    62,    62,    62,    62,   229,
   227,   258,    62,    59,    60,    41,    33,    84,    85,   181,
    62,   182,   349,    22,    23,    62,    56,    58,   183,   134,
   347,   200,    57,   203,    62,    55,    54,    62,    36,    35,
    62,    27,    11,    28,    29,    12,    13,    18,    19,    20,
    21,    51,    52,    53,    62,    62,    62,   217,   221,   202,
   178,   120,    62,   172,   123,   174,   170,   125,   126,   154,
   151,   148,   228,   230,    62,   268,   231,   130,   185,   232,
   233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
   245,    62,   128,    73,    71,   171,    62,    62,   144,   329,
   263,   332,   264,   266,   222,   253,   256,   261,   391,   385,
   383,   367,   369,   267,   351,   274,   277,   350,   323,   280,
   255,   282,   215,   283,   284,   285,   286,   287,   288,   289,
   290,   291,   292,   293,   307,   308,   271,   270,   244,   199,
   380,   321,   366,   346,   304,   306,   204,   322,   324,   325,
   252,   214,   326,   327,   330,   260,   333,   216,   334,   122,
   305,   335,   336,   225,   299,   300,   301,   302,   303,   297,
   212,   340,   186,   342,   121,   395,   196,   192,   388,   273,
   211,   224,   374,   226,   357,   269,   223,   145,   187,   344,
   132,   191,   184,   131,   295,   207,   208,   209,   210,   296,
   246,   345,   310,   298,   213,   133,   212,   175,   206,   250,
   248,   247,   189,   190,   249,   188,   211,   353,   118,   117,
   111,   173,   355,   193,   194,   195,   197,   198,   110,   278,
   109,   207,   208,   209,   210,   365,   169,   108,   220,   168,
   205,   167,   372,   105,   368,   104,   103,   373,   102,   101,
   100,    99,    98,    97,    96,    95,   153,   381,   384,    94,
    93,   150,    92,    91,   147,   386,    90,    89,   142,   140,
    78,    77,   389,    76,    75,    74,   392,    72,   393,   396,
   397,   135,   136,   137,   138,    70,   129,   399,   400,    67,
   401,   402,   127,    66,   338,   146,     8,   149,     7,   152,
     6,   155,   156,   157,   158,   159,   160,   161,   162,   163,
   164,   165,     5,     3,     2,     1,    87,    83,   358,     0,
     0,     0,     0,   176,   177,     0,     0,     0,   179,   352,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   359,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   371,     0,     0,     0,
     0,   376,     0,   377,   378,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   362 };
__YYSCLASS yytabelem yypact[]={

 -3000, -3000,  -181, -3000, -3000, -3000, -3000, -3000, -3000,  -340,
  -340,  -340, -3000, -3000,  -282,   -53,   -54, -3000, -3000, -3000,
 -3000, -3000,  -340,  -340,  -295,  -254, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000,  -340,  -340, -3000, -3000, -3000, -3000,  -302,
  -302,  -302,  -302,  -302, -3000, -3000, -3000,  -340,  -282, -3000,
 -3000,  -282, -3000,  -306,  -282,  -282,   -55,   -70, -3000, -3000,
 -3000, -3000, -3000, -3000,  -118,  -118,  -118,  -118,  -118,  -256,
  -257, -3000, -3000, -3000, -3000,  -340, -3000, -3000, -3000,  -118,
   -76,  -118,   -77,  -118,   -78,  -118,  -118,  -118,  -118,  -118,
  -118,  -118,  -118,  -118,  -118,  -118,  -191, -3000,   -81,   -84,
   -82,   -84, -3000, -3000, -3000, -3000, -3000,  -118,  -118, -3000,
 -3000,   -87,  -118, -3000,  -309, -3000, -3000, -3000,  -340, -3000,
  -340,  -120,    24, -3000, -3000, -3000, -3000, -3000, -3000,  -302,
   -88,  -302,   -88, -3000,    48,    12, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000,  -340,  -184,   -89, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
  -282,  -138,  -139, -3000, -3000,  -340, -3000, -3000,  -340,  -340,
  -340,  -340,  -340,  -340,  -340,  -340,  -340,  -340,  -340,  -144,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000,  -282, -3000, -3000,
 -3000,  -282, -3000, -3000,  -161,  -210,  -173,  -243, -3000, -3000,
 -3000, -3000,  -179,   -73,  -249,  -180,  -282, -3000,  -195, -3000,
  -198, -3000,  -340,  -340,  -340,  -340,  -340,  -340,  -340,  -340,
  -340,  -340,  -340, -3000, -3000, -3000,  -197,   -23, -3000, -3000,
  -261, -3000, -3000, -3000, -3000, -3000, -3000,  -340,  -340, -3000,
 -3000,  -340,  -340,  -201,  -245, -3000, -3000,  -340, -3000, -3000,
  -340,  -340, -3000, -3000, -3000, -3000, -3000,  -311, -3000, -3000,
  -215, -3000,  -223, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000,  -246,  -302, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,  -302,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000,  -117,  -125, -3000, -3000,  -312,  -193, -3000, -3000,
  -194, -3000, -3000, -3000, -3000, -3000, -3000,  -244,  -118, -3000,
  -188, -3000,  -189,  -302, -3000, -3000, -3000, -3000, -3000, -3000,
  -125,  -177, -3000,  -282, -3000, -3000,  -340,  -183,  -282, -3000,
  -282,  -282, -3000, -3000, -3000, -3000,  -227,  -228, -3000, -3000,
 -3000, -3000,  -184,  -260, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000,  -340, -3000, -3000, -3000,  -229, -3000,  -340,  -230,  -340,
 -3000, -3000, -3000,  -196, -3000, -3000,  -340,  -340,  -302, -3000,
  -340, -3000, -3000 };
__YYSCLASS yytabelem yypgo[]={

     0,     0,     1,    62,   112,   428,   427,   426,   425,   424,
   423,   422,   410,   408,   406,   404,   315,   403,   402,   399,
   396,   395,   387,   385,   384,   383,   381,   380,   379,   113,
   378,   377,   376,   374,   373,   372,   371,   370,   369,   366,
   365,   364,   363,   362,   361,   360,   359,   358,   356,   355,
   353,   352,     2,   351,   349,   348,   347,   346,   340,   205,
   338,   331,   330,   329,   328,   208,   321,   319,   318,   313,
   312,   310,   304,   303,   302,   300,   298,   296,   295,   294,
   292,   291,   289,   288,   285,   284,   273,   269,   267,   265,
   261,   260,   257,   253,   252,   250,   249,   248,   232,   230,
   228,     3,   227,   224,   222,   221,   220,   219,   218,   214,
   213,   212,   211,   210,   209 };
__YYSCLASS yytabelem yyr1[]={

     0,     8,     9,     9,    10,    10,    10,    10,    10,    10,
    15,    10,    10,    10,    10,    10,    17,    10,    19,    10,
    10,    10,    10,    10,    23,    10,    10,    24,    10,    10,
    25,    10,    10,    26,    10,    10,    27,    10,    10,    10,
    10,    28,    10,    30,    10,    10,    10,    10,    10,    31,
    10,    32,    10,    34,    10,    35,    10,    37,    10,    10,
    38,    10,    40,    10,    41,    10,    10,    42,    10,    10,
    43,    10,    44,    10,    10,    45,    10,    46,    10,    10,
    47,    10,    10,    48,    10,    49,    10,    50,    10,    10,
    51,    10,    53,    10,    54,    10,    56,    10,    58,    10,
    60,    10,    62,    10,    10,    10,    10,    10,    10,    63,
    10,    10,    64,    10,    10,    11,    12,    12,    13,     6,
     7,    65,    65,    68,    68,    68,    68,    68,    68,    68,
    66,    66,    69,    69,    69,    69,    69,    69,    69,    69,
    69,    69,    67,    67,    70,    70,    70,    70,    70,    70,
    70,    70,    70,    70,    70,    29,    71,    71,    72,    21,
    73,    73,    74,    22,    75,    75,    76,    76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
    76,    76,    76,    76,    76,    76,    76,    76,    59,    77,
    77,    78,    79,    78,    78,    61,    81,    81,    82,    82,
    80,    83,    83,    84,    14,    85,    14,    14,    87,    14,
    86,    86,    39,    88,    88,    89,    89,    33,    90,    90,
    91,    92,    91,    93,    94,    94,    95,    95,    95,    95,
    95,    18,    18,    18,    18,    20,    20,    20,    20,    16,
    96,    96,    97,    36,    98,    98,   100,    99,   102,    99,
   103,    99,   101,   105,   105,   106,   104,   107,   107,   108,
    57,   109,   109,   110,    55,   111,   111,   112,    52,   113,
   113,   114,   114,     2,     2,     5,     5,     5,     3,     1,
     4 };
__YYSCLASS yytabelem yyr2[]={

     0,     2,     0,     4,     2,     2,     2,     2,     2,    13,
     1,    16,     7,     5,     7,     5,     1,     6,     1,     6,
     5,     3,     5,     5,     1,     6,     3,     1,     6,     3,
     1,     6,     3,     1,     6,     3,     1,     6,     3,     9,
     9,     1,     8,     1,     8,     5,     5,     5,     5,     1,
     6,     1,     6,     1,     6,     1,     6,     1,     6,     3,
     1,     6,     1,     6,     1,     6,     3,     1,     6,     3,
     1,     6,     1,     6,     3,     1,     6,     1,     6,     3,
     1,     6,     3,     1,     6,     1,     6,     1,     6,     3,
     1,    19,     1,     9,     1,     8,     1,     6,     1,     6,
     1,     6,     1,     6,     5,     5,     5,     5,     5,     1,
     6,     3,     1,     6,     3,     3,     5,     3,     5,    13,
    13,     0,     4,     3,     3,     3,     3,     5,     5,     3,
     0,     4,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     0,     4,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     6,     0,     4,     7,     7,
     0,     4,     5,     7,     0,     4,     7,     5,     7,     5,
     7,     5,     7,     5,     7,     5,     7,     5,     7,     5,
     7,     5,     7,     5,     7,     5,     7,     5,     7,     0,
     4,     5,     1,     8,     5,     7,     0,     4,     3,     3,
     7,     0,     4,     5,     3,     1,    10,     3,     1,     6,
     0,    11,     7,     0,     4,     7,     9,     7,     0,     4,
     3,     1,     6,     7,     0,     4,     3,     5,     7,     9,
    11,     7,     9,    11,    13,     7,     9,    11,    13,     7,
     0,     4,     3,     7,     0,     4,     1,     6,     1,     8,
     1,     8,     7,     0,     4,     3,     7,     0,     4,     3,
     7,     0,     4,     5,     7,     0,     4,     3,     7,     0,
     4,     5,    15,     3,     5,     3,     5,     5,     5,     3,
     3 };
__YYSCLASS yytabelem yychk[]={

 -3000,    -8,    -9,   -10,   256,   -11,   -12,   -13,   -14,   292,
   282,   333,   336,   337,   280,   270,   269,   285,   338,   339,
   340,   341,   314,   315,    -3,    -1,   286,   332,   334,   335,
   283,   281,   276,   307,   291,   330,   329,   287,   288,   289,
   284,   306,   290,   262,   275,   271,   272,   273,   274,   264,
   279,   342,   343,   344,   327,   326,   317,   323,   318,   304,
   305,   263,   345,    -1,    -1,    -1,   -17,   -19,    -4,   316,
   -21,   257,   -22,   257,   -23,   -24,   -25,   -26,   -27,    -1,
    -1,    -1,    -2,    -6,   321,   322,   303,    -7,   303,   -31,
   -32,   -34,   -35,   -37,   -38,   -40,   -41,   -42,   -43,   -44,
   -45,   -46,   -47,   -48,   -49,   -50,    -1,    -1,   -56,   -58,
   -60,   -62,    -2,    -2,    -2,    -2,    -2,   -63,   -64,    -1,
    -4,   -85,   -87,    -4,   324,    -4,    -4,   -18,   257,   -20,
   257,   -73,   -75,   -16,   257,   -16,   -16,   -16,   -16,   303,
   -28,   303,   -30,    -1,   -65,   -65,   -16,   -33,   257,   -16,
   -36,   257,   -16,   -39,   257,   -16,   -16,   -16,   -16,   -16,
   -16,   -16,   -16,   -16,   -16,   -16,   259,   -53,   -54,   -57,
   257,   -59,   257,   -61,   257,   -59,   -16,   -16,   257,   -16,
   324,    -1,    -1,   258,   -74,   308,   258,   -76,   301,   298,
   299,   277,   263,   309,   310,   311,   262,   312,   313,   -96,
    -2,   -29,   257,    -2,   -29,   302,   -68,   293,   294,   295,
   296,   278,   268,   302,   -90,   -98,   -88,    -1,   -52,   257,
   -55,   257,  -109,   -77,   -81,   -86,    -4,   258,    -1,   258,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,   258,   -97,    -1,   -71,   -66,    -4,    -4,
   -67,   258,   -91,    -1,   258,   -99,    -1,   297,   331,   258,
   -89,    -1,   302,  -113,  -111,   258,  -110,    -1,   258,   -78,
   320,   319,   258,   -82,    -1,   320,   258,    -1,    -4,   258,
    -1,   258,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,   258,   -72,    -3,   302,   -69,   297,
   298,   299,   300,   301,   277,   293,   278,   267,   268,   302,
   -70,   297,   298,   299,   300,   301,   277,   293,   267,   278,
   268,    -1,   -92,  -100,    -1,    -1,    -1,    -1,   258,  -114,
    -1,   258,  -112,    -2,    -1,    -1,    -1,   325,   -15,   258,
    -1,   258,    -1,   302,    -2,    -2,   -93,   257,  -101,   257,
  -102,  -103,    -4,    -1,   260,    -2,   259,   -79,    -5,    -4,
   265,   266,   -16,   258,   258,    -2,   -94,  -105,  -101,  -104,
   257,    -4,   -51,    -1,   -80,   257,    -4,    -4,    -4,   258,
   -95,    -1,   258,  -106,    -1,  -107,   -52,   302,   -83,    -1,
   258,  -108,    -1,    -1,   258,   -84,    -1,    -1,   260,    -1,
    -1,    -2,    -1 };
__YYSCLASS yytabelem yydef[]={

     2,    -2,    -2,     3,     4,     5,     6,     7,     8,     0,
     0,     0,    16,    18,    21,     0,     0,    -2,    -2,    -2,
    -2,    -2,     0,     0,     0,     0,    49,    51,    53,    55,
    -2,    60,    62,    -2,    -2,    70,    -2,    75,    -2,    -2,
    83,    85,    -2,     0,     0,    96,    98,   100,   102,     0,
     0,     0,     0,     0,    -2,    -2,   115,   117,     0,    -2,
    -2,     0,   279,     0,    13,    15,     0,     0,    20,   280,
    22,   160,    23,   164,     0,     0,     0,     0,     0,    41,
    43,    45,    46,    48,   273,     0,   121,    47,   121,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    92,    94,     0,     0,
     0,     0,   104,   105,   106,   107,   108,     0,     0,   116,
   118,     0,     0,   278,     0,    12,    14,    17,     0,    19,
     0,     0,     0,    25,   240,    28,    31,    34,    37,     0,
     0,     0,     0,   274,     0,     0,    50,    52,   218,    54,
    56,   244,    58,    61,   213,    63,    65,    68,    71,    73,
    76,    78,    81,    84,    86,    88,     0,     0,     0,    97,
   261,    99,   189,   101,   196,   103,   110,   113,   210,   209,
     0,     0,     0,   159,   161,     0,   163,   165,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    39,    42,   156,    40,    44,   130,   122,   123,   124,   125,
   126,     0,   129,   142,     0,     0,     0,     0,    93,   269,
    95,   265,     0,     0,     0,     0,     0,   231,     0,   235,
     0,   162,   167,   169,   171,   173,   175,   177,   179,   181,
   183,   185,   187,   239,   241,   242,     0,     0,   128,   127,
     0,   217,   219,    -2,   243,   245,   246,     0,     0,   212,
   214,     0,     0,     0,     0,   260,   262,     0,   188,   190,
     0,     0,   195,   197,   198,   199,   206,     0,    -2,   232,
     0,   236,     0,   166,   168,   170,   172,   174,   176,   178,
   180,   182,   184,   186,   155,   157,     0,     0,   131,   132,
   133,   134,   135,   136,   137,   138,   139,   140,   141,     0,
   143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
   153,   154,     0,     0,   248,   250,     0,     0,   268,   270,
     0,   264,   266,   267,   263,    -2,   194,     0,     0,   233,
     0,   237,     0,     0,   119,   120,   222,   224,   247,   253,
     0,     0,   215,     0,    90,   271,     0,     0,     0,   275,
     0,     0,    11,   234,   238,   158,     0,     0,   249,   251,
   257,   216,     0,     0,   193,   201,   211,   276,   277,   223,
   225,   226,   252,   254,   255,     0,    91,     0,     0,   227,
   256,   258,   259,     0,   200,   202,     0,   228,     0,   203,
   229,   272,   230 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS yytoktype yytoks[] =
{
	"LB",	257,
	"RB",	258,
	"LP",	259,
	"RP",	260,
	"MENUS",	261,
	"MENU",	262,
	"BUTTON",	263,
	"DEFAULT_FUNCTION",	264,
	"PLUS",	265,
	"MINUS",	266,
	"ALL",	267,
	"OR",	268,
	"CURSORS",	269,
	"PIXMAPS",	270,
	"ICONS",	271,
	"COLOR",	272,
	"SAVECOLOR",	273,
	"MONOCHROME",	274,
	"FUNCTION",	275,
	"ICONMGR_SHOW",	276,
	"ICONMGR",	277,
	"ALTER",	278,
	"WINDOW_FUNCTION",	279,
	"ZOOM",	280,
	"ICONMGRS",	281,
	"ICONMGR_GEOMETRY",	282,
	"ICONMGR_NOSHOW",	283,
	"MAKE_TITLE",	284,
	"ICONIFY_BY_UNMAPPING",	285,
	"DONT_ICONIFY_BY_UNMAPPING",	286,
	"NO_BORDER",	287,
	"NO_ICON_TITLE",	288,
	"NO_TITLE",	289,
	"AUTO_RAISE",	290,
	"NO_HILITE",	291,
	"ICON_REGION",	292,
	"META",	293,
	"SHIFT",	294,
	"LOCK",	295,
	"CONTROL",	296,
	"WINDOW",	297,
	"TITLE",	298,
	"ICON",	299,
	"ROOT",	300,
	"FRAME",	301,
	"COLON",	302,
	"EQUALS",	303,
	"SQUEEZE_TITLE",	304,
	"DONT_SQUEEZE_TITLE",	305,
	"START_ICONIFIED",	306,
	"NO_TITLE_HILITE",	307,
	"TITLE_HILITE",	308,
	"MOVE",	309,
	"RESIZE",	310,
	"WAITC",	311,
	"SELECT",	312,
	"KILL",	313,
	"LEFT_TITLEBUTTON",	314,
	"RIGHT_TITLEBUTTON",	315,
	"NUMBER",	316,
	"KEYWORD",	317,
	"NKEYWORD",	318,
	"CKEYWORD",	319,
	"CLKEYWORD",	320,
	"FKEYWORD",	321,
	"FSKEYWORD",	322,
	"SKEYWORD",	323,
	"DKEYWORD",	324,
	"JKEYWORD",	325,
	"WINDOW_RING",	326,
	"WARP_CURSOR",	327,
	"ERRORTOKEN",	328,
	"NO_STACKMODE",	329,
	"ALWAYS_ON_TOP",	330,
	"WORKSPACE",	331,
	"WORKSPACES",	332,
	"WORKSPCMGR_GEOMETRY",	333,
	"OCCUPYALL",	334,
	"OCCUPYLIST",	335,
	"MAPWINDOWCURRENTWORKSPACE",	336,
	"MAPWINDOWDEFAULTWORKSPACE",	337,
	"OPAQUEMOVE",	338,
	"NOOPAQUEMOVE",	339,
	"OPAQUERESIZE",	340,
	"NOOPAQUERESIZE",	341,
	"CHANGE_WORKSPACE_FUNCTION",	342,
	"DEICONIFY_FUNCTION",	343,
	"ICONIFY_FUNCTION",	344,
	"STRING",	345,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * yyreds[] =
{
	"-no such reduction-",
	"twmrc : stmts",
	"stmts : /* empty */",
	"stmts : stmts stmt",
	"stmt : error",
	"stmt : noarg",
	"stmt : sarg",
	"stmt : narg",
	"stmt : squeeze",
	"stmt : ICON_REGION string DKEYWORD DKEYWORD number number",
	"stmt : ICON_REGION string DKEYWORD DKEYWORD number number",
	"stmt : ICON_REGION string DKEYWORD DKEYWORD number number win_list",
	"stmt : ICONMGR_GEOMETRY string number",
	"stmt : ICONMGR_GEOMETRY string",
	"stmt : WORKSPCMGR_GEOMETRY string number",
	"stmt : WORKSPCMGR_GEOMETRY string",
	"stmt : MAPWINDOWCURRENTWORKSPACE",
	"stmt : MAPWINDOWCURRENTWORKSPACE curwork",
	"stmt : MAPWINDOWDEFAULTWORKSPACE",
	"stmt : MAPWINDOWDEFAULTWORKSPACE defwork",
	"stmt : ZOOM number",
	"stmt : ZOOM",
	"stmt : PIXMAPS pixmap_list",
	"stmt : CURSORS cursor_list",
	"stmt : ICONIFY_BY_UNMAPPING",
	"stmt : ICONIFY_BY_UNMAPPING win_list",
	"stmt : ICONIFY_BY_UNMAPPING",
	"stmt : OPAQUEMOVE",
	"stmt : OPAQUEMOVE win_list",
	"stmt : OPAQUEMOVE",
	"stmt : NOOPAQUEMOVE",
	"stmt : NOOPAQUEMOVE win_list",
	"stmt : NOOPAQUEMOVE",
	"stmt : OPAQUERESIZE",
	"stmt : OPAQUERESIZE win_list",
	"stmt : OPAQUERESIZE",
	"stmt : NOOPAQUERESIZE",
	"stmt : NOOPAQUERESIZE win_list",
	"stmt : NOOPAQUERESIZE",
	"stmt : LEFT_TITLEBUTTON string EQUALS action",
	"stmt : RIGHT_TITLEBUTTON string EQUALS action",
	"stmt : LEFT_TITLEBUTTON string",
	"stmt : LEFT_TITLEBUTTON string binding_list",
	"stmt : RIGHT_TITLEBUTTON string",
	"stmt : RIGHT_TITLEBUTTON string binding_list",
	"stmt : button string",
	"stmt : button action",
	"stmt : string fullkey",
	"stmt : button full",
	"stmt : DONT_ICONIFY_BY_UNMAPPING",
	"stmt : DONT_ICONIFY_BY_UNMAPPING win_list",
	"stmt : WORKSPACES",
	"stmt : WORKSPACES workspc_list",
	"stmt : OCCUPYALL",
	"stmt : OCCUPYALL win_list",
	"stmt : OCCUPYLIST",
	"stmt : OCCUPYLIST occupy_list",
	"stmt : ICONMGR_NOSHOW",
	"stmt : ICONMGR_NOSHOW win_list",
	"stmt : ICONMGR_NOSHOW",
	"stmt : ICONMGRS",
	"stmt : ICONMGRS iconm_list",
	"stmt : ICONMGR_SHOW",
	"stmt : ICONMGR_SHOW win_list",
	"stmt : NO_TITLE_HILITE",
	"stmt : NO_TITLE_HILITE win_list",
	"stmt : NO_TITLE_HILITE",
	"stmt : NO_HILITE",
	"stmt : NO_HILITE win_list",
	"stmt : NO_HILITE",
	"stmt : ALWAYS_ON_TOP",
	"stmt : ALWAYS_ON_TOP win_list",
	"stmt : NO_STACKMODE",
	"stmt : NO_STACKMODE win_list",
	"stmt : NO_STACKMODE",
	"stmt : NO_BORDER",
	"stmt : NO_BORDER win_list",
	"stmt : NO_ICON_TITLE",
	"stmt : NO_ICON_TITLE win_list",
	"stmt : NO_ICON_TITLE",
	"stmt : NO_TITLE",
	"stmt : NO_TITLE win_list",
	"stmt : NO_TITLE",
	"stmt : MAKE_TITLE",
	"stmt : MAKE_TITLE win_list",
	"stmt : START_ICONIFIED",
	"stmt : START_ICONIFIED win_list",
	"stmt : AUTO_RAISE",
	"stmt : AUTO_RAISE win_list",
	"stmt : AUTO_RAISE",
	"stmt : MENU string LP string COLON string RP",
	"stmt : MENU string LP string COLON string RP menu",
	"stmt : MENU string",
	"stmt : MENU string menu",
	"stmt : FUNCTION string",
	"stmt : FUNCTION string function",
	"stmt : ICONS",
	"stmt : ICONS icon_list",
	"stmt : COLOR",
	"stmt : COLOR color_list",
	"stmt : SAVECOLOR",
	"stmt : SAVECOLOR save_color_list",
	"stmt : MONOCHROME",
	"stmt : MONOCHROME color_list",
	"stmt : DEFAULT_FUNCTION action",
	"stmt : WINDOW_FUNCTION action",
	"stmt : CHANGE_WORKSPACE_FUNCTION action",
	"stmt : DEICONIFY_FUNCTION action",
	"stmt : ICONIFY_FUNCTION action",
	"stmt : WARP_CURSOR",
	"stmt : WARP_CURSOR win_list",
	"stmt : WARP_CURSOR",
	"stmt : WINDOW_RING",
	"stmt : WINDOW_RING win_list",
	"stmt : WINDOW_RING",
	"noarg : KEYWORD",
	"sarg : SKEYWORD string",
	"sarg : SKEYWORD",
	"narg : NKEYWORD number",
	"full : EQUALS keys COLON contexts COLON action",
	"fullkey : EQUALS keys COLON contextkeys COLON action",
	"keys : /* empty */",
	"keys : keys key",
	"key : META",
	"key : SHIFT",
	"key : LOCK",
	"key : CONTROL",
	"key : ALTER number",
	"key : META number",
	"key : OR",
	"contexts : /* empty */",
	"contexts : contexts context",
	"context : WINDOW",
	"context : TITLE",
	"context : ICON",
	"context : ROOT",
	"context : FRAME",
	"context : ICONMGR",
	"context : META",
	"context : ALTER",
	"context : ALL",
	"context : OR",
	"contextkeys : /* empty */",
	"contextkeys : contextkeys contextkey",
	"contextkey : WINDOW",
	"contextkey : TITLE",
	"contextkey : ICON",
	"contextkey : ROOT",
	"contextkey : FRAME",
	"contextkey : ICONMGR",
	"contextkey : META",
	"contextkey : ALL",
	"contextkey : ALTER",
	"contextkey : OR",
	"contextkey : string",
	"binding_list : LB binding_entries RB",
	"binding_entries : /* empty */",
	"binding_entries : binding_entries binding_entry",
	"binding_entry : button COLON action",
	"pixmap_list : LB pixmap_entries RB",
	"pixmap_entries : /* empty */",
	"pixmap_entries : pixmap_entries pixmap_entry",
	"pixmap_entry : TITLE_HILITE string",
	"cursor_list : LB cursor_entries RB",
	"cursor_entries : /* empty */",
	"cursor_entries : cursor_entries cursor_entry",
	"cursor_entry : FRAME string string",
	"cursor_entry : FRAME string",
	"cursor_entry : TITLE string string",
	"cursor_entry : TITLE string",
	"cursor_entry : ICON string string",
	"cursor_entry : ICON string",
	"cursor_entry : ICONMGR string string",
	"cursor_entry : ICONMGR string",
	"cursor_entry : BUTTON string string",
	"cursor_entry : BUTTON string",
	"cursor_entry : MOVE string string",
	"cursor_entry : MOVE string",
	"cursor_entry : RESIZE string string",
	"cursor_entry : RESIZE string",
	"cursor_entry : WAITC string string",
	"cursor_entry : WAITC string",
	"cursor_entry : MENU string string",
	"cursor_entry : MENU string",
	"cursor_entry : SELECT string string",
	"cursor_entry : SELECT string",
	"cursor_entry : KILL string string",
	"cursor_entry : KILL string",
	"color_list : LB color_entries RB",
	"color_entries : /* empty */",
	"color_entries : color_entries color_entry",
	"color_entry : CLKEYWORD string",
	"color_entry : CLKEYWORD string",
	"color_entry : CLKEYWORD string win_color_list",
	"color_entry : CKEYWORD string",
	"save_color_list : LB s_color_entries RB",
	"s_color_entries : /* empty */",
	"s_color_entries : s_color_entries s_color_entry",
	"s_color_entry : string",
	"s_color_entry : CLKEYWORD",
	"win_color_list : LB win_color_entries RB",
	"win_color_entries : /* empty */",
	"win_color_entries : win_color_entries win_color_entry",
	"win_color_entry : string string",
	"squeeze : SQUEEZE_TITLE",
	"squeeze : SQUEEZE_TITLE",
	"squeeze : SQUEEZE_TITLE LB win_sqz_entries RB",
	"squeeze : DONT_SQUEEZE_TITLE",
	"squeeze : DONT_SQUEEZE_TITLE",
	"squeeze : DONT_SQUEEZE_TITLE win_list",
	"win_sqz_entries : /* empty */",
	"win_sqz_entries : win_sqz_entries string JKEYWORD signed_number number",
	"iconm_list : LB iconm_entries RB",
	"iconm_entries : /* empty */",
	"iconm_entries : iconm_entries iconm_entry",
	"iconm_entry : string string number",
	"iconm_entry : string string string number",
	"workspc_list : LB workspc_entries RB",
	"workspc_entries : /* empty */",
	"workspc_entries : workspc_entries workspc_entry",
	"workspc_entry : string",
	"workspc_entry : string",
	"workspc_entry : string workapp_list",
	"workapp_list : LB workapp_entries RB",
	"workapp_entries : /* empty */",
	"workapp_entries : workapp_entries workapp_entry",
	"workapp_entry : string",
	"workapp_entry : string string",
	"workapp_entry : string string string",
	"workapp_entry : string string string string",
	"workapp_entry : string string string string string",
	"curwork : LB string RB",
	"curwork : LB string string RB",
	"curwork : LB string string string RB",
	"curwork : LB string string string string RB",
	"defwork : LB string RB",
	"defwork : LB string string RB",
	"defwork : LB string string string RB",
	"defwork : LB string string string string RB",
	"win_list : LB win_entries RB",
	"win_entries : /* empty */",
	"win_entries : win_entries win_entry",
	"win_entry : string",
	"occupy_list : LB occupy_entries RB",
	"occupy_entries : /* empty */",
	"occupy_entries : occupy_entries occupy_entry",
	"occupy_entry : string",
	"occupy_entry : string occupy_workspc_list",
	"occupy_entry : WINDOW string",
	"occupy_entry : WINDOW string occupy_workspc_list",
	"occupy_entry : WORKSPACE string",
	"occupy_entry : WORKSPACE string occupy_window_list",
	"occupy_workspc_list : LB occupy_workspc_entries RB",
	"occupy_workspc_entries : /* empty */",
	"occupy_workspc_entries : occupy_workspc_entries occupy_workspc_entry",
	"occupy_workspc_entry : string",
	"occupy_window_list : LB occupy_window_entries RB",
	"occupy_window_entries : /* empty */",
	"occupy_window_entries : occupy_window_entries occupy_window_entry",
	"occupy_window_entry : string",
	"icon_list : LB icon_entries RB",
	"icon_entries : /* empty */",
	"icon_entries : icon_entries icon_entry",
	"icon_entry : string string",
	"function : LB function_entries RB",
	"function_entries : /* empty */",
	"function_entries : function_entries function_entry",
	"function_entry : action",
	"menu : LB menu_entries RB",
	"menu_entries : /* empty */",
	"menu_entries : menu_entries menu_entry",
	"menu_entry : string action",
	"menu_entry : string LP string COLON string RP action",
	"action : FKEYWORD",
	"action : FSKEYWORD string",
	"signed_number : number",
	"signed_number : PLUS number",
	"signed_number : MINUS number",
	"button : BUTTON number",
	"string : STRING",
	"number : NUMBER",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH
__YYSCLASS YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
__YYSCLASS int yys[ YYMAXDEPTH ];		/* state stack */
# else
__YYSCLASS YYSTYPE *yyv;			/* pointer to malloc'ed value stack */
__YYSCLASS int *yys;			/* pointer to malloc'ed stack stack */

#if defined(__STDC__) || defined (__cplusplus)
#include <stdlib.h>
#else
	extern char *malloc();
	extern char *realloc();
	extern void free();
#endif /* __STDC__ or __cplusplus */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yymaxdepth = YYMAXDEPTH;

__YYSCLASS YYSTYPE *yypv;			/* top of value stack */
__YYSCLASS int *yyps;			/* top of state stack */

__YYSCLASS int yystate;			/* current state */
__YYSCLASS int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
__YYSCLASS int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yyerror( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yyv_old = yyv;
			int * yys_old = yys;
			yymaxdepth += YYINCREMENT;
			yys = (int *) realloc(yys, yymaxdepth * sizeof(int));
			yyv = (YYSTYPE *) realloc(yyv, yymaxdepth * sizeof(YYSTYPE));
			if (yys==0 || yyv==0) {
			    yyerror( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_ps = (yy_ps - yys_old) + yys;
			yyps = (yyps - yys_old) + yys;
			yy_pv = (yy_pv - yyv_old) + yyv;
			yypv = (yypv - yyv_old) + yyv;
# endif

		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( (nl_msg(30003,"syntax error")) );
				yynerrs++;
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 9:
# line 148 "gram.y"
{
		      (void) AddIconRegion(yypvt[-4].ptr, yypvt[-3].num, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num);
		  } break;
case 10:
# line 151 "gram.y"
{
		      list = AddIconRegion(yypvt[-4].ptr, yypvt[-3].num, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num);
		  } break;
case 12:
# line 155 "gram.y"
{ if (Scr->FirstTime)
						  {
						    Scr->iconmgr->geometry= yypvt[-1].ptr;
						    Scr->iconmgr->columns=yypvt[-0].num;
						  }
						} break;
case 13:
# line 161 "gram.y"
{ if (Scr->FirstTime)
						    Scr->iconmgr->geometry = yypvt[-0].ptr;
						} break;
case 14:
# line 164 "gram.y"
{ if (Scr->FirstTime)
						  {
						    Scr->workSpaceMgr.workspaceWindow.geometry= yypvt[-1].ptr;
						    Scr->workSpaceMgr.workspaceWindow.columns=yypvt[-0].num;
						  }
						} break;
case 15:
# line 170 "gram.y"
{ if (Scr->FirstTime)
						    Scr->workSpaceMgr.workspaceWindow.geometry = yypvt[-0].ptr;
						} break;
case 16:
# line 173 "gram.y"
{} break;
case 18:
# line 176 "gram.y"
{} break;
case 20:
# line 179 "gram.y"
{ if (Scr->FirstTime)
					  {
						Scr->DoZoom = TRUE;
						Scr->ZoomCount = yypvt[-0].num;
					  }
					} break;
case 21:
# line 185 "gram.y"
{ if (Scr->FirstTime) 
						Scr->DoZoom = TRUE; } break;
case 22:
# line 187 "gram.y"
{} break;
case 23:
# line 188 "gram.y"
{} break;
case 24:
# line 189 "gram.y"
{ list = &Scr->IconifyByUn; } break;
case 26:
# line 191 "gram.y"
{ if (Scr->FirstTime) 
		    Scr->IconifyByUnmapping = TRUE; } break;
case 27:
# line 194 "gram.y"
{ list = &Scr->OpaqueMoveList; } break;
case 29:
# line 196 "gram.y"
{ if (Scr->FirstTime) Scr->DoOpaqueMove = TRUE; } break;
case 30:
# line 197 "gram.y"
{ list = &Scr->NoOpaqueMoveList; } break;
case 32:
# line 199 "gram.y"
{ if (Scr->FirstTime) Scr->DoOpaqueMove = FALSE; } break;
case 33:
# line 200 "gram.y"
{ list = &Scr->OpaqueMoveList; } break;
case 35:
# line 202 "gram.y"
{ if (Scr->FirstTime) Scr->DoOpaqueResize = TRUE; } break;
case 36:
# line 203 "gram.y"
{ list = &Scr->NoOpaqueResizeList; } break;
case 38:
# line 205 "gram.y"
{ if (Scr->FirstTime) Scr->DoOpaqueResize = FALSE; } break;
case 39:
# line 207 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, False);
					} break;
case 40:
# line 210 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, True);
					} break;
case 41:
# line 213 "gram.y"
{ CreateTitleButton(yypvt[-0].ptr, 0, NULL, NULL, FALSE, TRUE); } break;
case 43:
# line 215 "gram.y"
{ CreateTitleButton(yypvt[-0].ptr, 0, NULL, NULL, TRUE, TRUE); } break;
case 45:
# line 217 "gram.y"
{
		    root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR);
		    AddFuncButton (yypvt[-1].num, C_ROOT, 0, F_MENU, root, (MenuItem*) 0);
		} break;
case 46:
# line 221 "gram.y"
{
			if (yypvt[-0].num == F_MENU) {
			    pull->prev = NULL;
			    AddFuncButton (yypvt[-1].num, C_ROOT, 0, yypvt[-0].num, pull, (MenuItem*) 0);
			}
			else {
			    MenuItem *item;

			    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
			    item = AddToMenu (root, "x", Action,
					NULLSTR, yypvt[-0].num, NULLSTR, NULLSTR);
			    AddFuncButton (yypvt[-1].num, C_ROOT, 0, yypvt[-0].num, (MenuRoot*) 0, item);
			}
			Action = "";
			pull = NULL;
		} break;
case 47:
# line 237 "gram.y"
{ GotKey(yypvt[-1].ptr, yypvt[-0].num); } break;
case 48:
# line 238 "gram.y"
{ GotButton(yypvt[-1].num, yypvt[-0].num); } break;
case 49:
# line 240 "gram.y"
{ list = &Scr->DontIconify; } break;
case 51:
# line 242 "gram.y"
{} break;
case 53:
# line 244 "gram.y"
{ list = &Scr->OccupyAll; } break;
case 55:
# line 246 "gram.y"
{} break;
case 57:
# line 248 "gram.y"
{ list = &Scr->IconMgrNoShow; } break;
case 59:
# line 250 "gram.y"
{ Scr->IconManagerDontShow = TRUE; } break;
case 60:
# line 251 "gram.y"
{ list = &Scr->IconMgrs; } break;
case 62:
# line 253 "gram.y"
{ list = &Scr->IconMgrShow; } break;
case 64:
# line 255 "gram.y"
{ list = &Scr->NoTitleHighlight; } break;
case 66:
# line 257 "gram.y"
{ if (Scr->FirstTime)
						Scr->TitleHighlight = FALSE; } break;
case 67:
# line 259 "gram.y"
{ list = &Scr->NoHighlight; } break;
case 69:
# line 261 "gram.y"
{ if (Scr->FirstTime)
						Scr->Highlight = FALSE; } break;
case 70:
# line 263 "gram.y"
{ list = &Scr->AlwaysOnTopL; } break;
case 72:
# line 265 "gram.y"
{ list = &Scr->NoStackModeL; } break;
case 74:
# line 267 "gram.y"
{ if (Scr->FirstTime)
						Scr->StackMode = FALSE; } break;
case 75:
# line 269 "gram.y"
{ list = &Scr->NoBorder; } break;
case 77:
# line 271 "gram.y"
{ list = &Scr->NoIconTitle; } break;
case 79:
# line 273 "gram.y"
{ if (Scr->FirstTime)
						Scr->NoIconTitlebar = TRUE; } break;
case 80:
# line 275 "gram.y"
{ list = &Scr->NoTitle; } break;
case 82:
# line 277 "gram.y"
{ if (Scr->FirstTime)
						Scr->NoTitlebar = TRUE; } break;
case 83:
# line 279 "gram.y"
{ list = &Scr->MakeTitle; } break;
case 85:
# line 281 "gram.y"
{ list = &Scr->StartIconified; } break;
case 87:
# line 283 "gram.y"
{ list = &Scr->AutoRaise; } break;
case 89:
# line 285 "gram.y"
{ Scr->AutoRaiseDefault = TRUE; } break;
case 90:
# line 286 "gram.y"
{
					root = GetRoot(yypvt[-5].ptr, yypvt[-3].ptr, yypvt[-1].ptr); } break;
case 91:
# line 288 "gram.y"
{ root->real_menu = TRUE;} break;
case 92:
# line 289 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 93:
# line 290 "gram.y"
{ root->real_menu = TRUE; } break;
case 94:
# line 291 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 96:
# line 293 "gram.y"
{ list = &Scr->IconNames; } break;
case 98:
# line 295 "gram.y"
{ color = COLOR; } break;
case 100:
# line 297 "gram.y"
{} break;
case 102:
# line 299 "gram.y"
{ color = MONOCHROME; } break;
case 104:
# line 301 "gram.y"
{ Scr->DefaultFunction.func = yypvt[-0].num;
					  if (yypvt[-0].num == F_MENU)
					  {
					    pull->prev = NULL;
					    Scr->DefaultFunction.menu = pull;
					  }
					  else
					  {
					    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					    Scr->DefaultFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					  }
					  Action = "";
					  pull = NULL;
					} break;
case 105:
# line 317 "gram.y"
{ Scr->WindowFunction.func = yypvt[-0].num;
					   root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					   Scr->WindowFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					   Action = "";
					   pull = NULL;
					} break;
case 106:
# line 325 "gram.y"
{ Scr->ChangeWorkspaceFunction.func = yypvt[-0].num;
					   root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					   Scr->ChangeWorkspaceFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					   Action = "";
					   pull = NULL;
					} break;
case 107:
# line 333 "gram.y"
{ Scr->DeIconifyFunction.func = yypvt[-0].num;
					   root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					   Scr->DeIconifyFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					   Action = "";
					   pull = NULL;
					} break;
case 108:
# line 341 "gram.y"
{ Scr->IconifyFunction.func = yypvt[-0].num;
					   root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					   Scr->IconifyFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					   Action = "";
					   pull = NULL;
					} break;
case 109:
# line 349 "gram.y"
{ list = &Scr->WarpCursorL; } break;
case 111:
# line 351 "gram.y"
{ if (Scr->FirstTime) 
					    Scr->WarpCursor = TRUE; } break;
case 112:
# line 353 "gram.y"
{ list = &Scr->WindowRingL; } break;
case 114:
# line 355 "gram.y"
{ Scr->WindowRingAll = TRUE; } break;
case 115:
# line 358 "gram.y"
{ if (!do_single_keyword (yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
					"unknown singleton keyword %d\n",
						     yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 116:
# line 368 "gram.y"
{ if (!do_string_keyword (yypvt[-1].num, yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown string keyword %d (value \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 117:
# line 376 "gram.y"
{ if (!do_string_keyword (yypvt[-0].num, defstring)) {
 					    twmrc_error_prefix();
 					    fprintf (stderr,
 				"unknown string keyword %d (no value)\n",
 						     yypvt[-0].num);
 					    ParseError = 1;
 					  }
 					} break;
case 118:
# line 386 "gram.y"
{ if (!do_number_keyword (yypvt[-1].num, yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown numeric keyword %d (value %d)\n",
						     yypvt[-1].num, yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 119:
# line 398 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 120:
# line 401 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 123:
# line 408 "gram.y"
{ mods |= Mod1Mask; } break;
case 124:
# line 409 "gram.y"
{ mods |= ShiftMask; } break;
case 125:
# line 410 "gram.y"
{ mods |= LockMask; } break;
case 126:
# line 411 "gram.y"
{ mods |= ControlMask; } break;
case 127:
# line 412 "gram.y"
{ if (yypvt[-0].num < 1 || yypvt[-0].num > 5) {
					     twmrc_error_prefix();
					     fprintf (stderr, 
				"bad modifier number (%d), must be 1-5\n",
						      yypvt[-0].num);
					     ParseError = 1;
					  } else {
					     mods |= (Alt1Mask << (yypvt[-0].num - 1));
					  }
					} break;
case 128:
# line 422 "gram.y"
{ if (yypvt[-0].num < 1 || yypvt[-0].num > 5) {
					     twmrc_error_prefix();
					     fprintf (stderr, 
				"bad modifier number (%d), must be 1-5\n",
						      yypvt[-0].num);
					     ParseError = 1;
					  } else {
					     mods |= (Mod1Mask << (yypvt[-0].num - 1));
					  }
					} break;
case 129:
# line 432 "gram.y"
{ } break;
case 132:
# line 439 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 133:
# line 440 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 134:
# line 441 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 135:
# line 442 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 136:
# line 443 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 137:
# line 444 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 138:
# line 445 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 139:
# line 446 "gram.y"
{ cont |= C_ALTER_BIT; } break;
case 140:
# line 447 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 141:
# line 448 "gram.y"
{  } break;
case 144:
# line 455 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 145:
# line 456 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 146:
# line 457 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 147:
# line 458 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 148:
# line 459 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 149:
# line 460 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 150:
# line 461 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 151:
# line 462 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 152:
# line 463 "gram.y"
{ cont |= C_ALTER_BIT; } break;
case 153:
# line 464 "gram.y"
{ } break;
case 154:
# line 465 "gram.y"
{ Name = yypvt[-0].ptr; cont |= C_NAME_BIT; } break;
case 158:
# line 476 "gram.y"
{ ModifyCurrentTB(yypvt[-2].num, yypvt[-0].num, Action, pull);} break;
case 159:
# line 480 "gram.y"
{} break;
case 162:
# line 487 "gram.y"
{ SetHighlightPixmap (yypvt[-0].ptr); } break;
case 163:
# line 491 "gram.y"
{} break;
case 166:
# line 498 "gram.y"
{
			NewBitmapCursor(&Scr->FrameCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 167:
# line 500 "gram.y"
{
			NewFontCursor(&Scr->FrameCursor, yypvt[-0].ptr); } break;
case 168:
# line 502 "gram.y"
{
			NewBitmapCursor(&Scr->TitleCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 169:
# line 504 "gram.y"
{
			NewFontCursor(&Scr->TitleCursor, yypvt[-0].ptr); } break;
case 170:
# line 506 "gram.y"
{
			NewBitmapCursor(&Scr->IconCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 171:
# line 508 "gram.y"
{
			NewFontCursor(&Scr->IconCursor, yypvt[-0].ptr); } break;
case 172:
# line 510 "gram.y"
{
			NewBitmapCursor(&Scr->IconMgrCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 173:
# line 512 "gram.y"
{
			NewFontCursor(&Scr->IconMgrCursor, yypvt[-0].ptr); } break;
case 174:
# line 514 "gram.y"
{
			NewBitmapCursor(&Scr->ButtonCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 175:
# line 516 "gram.y"
{
			NewFontCursor(&Scr->ButtonCursor, yypvt[-0].ptr); } break;
case 176:
# line 518 "gram.y"
{
			NewBitmapCursor(&Scr->MoveCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 177:
# line 520 "gram.y"
{
			NewFontCursor(&Scr->MoveCursor, yypvt[-0].ptr); } break;
case 178:
# line 522 "gram.y"
{
			NewBitmapCursor(&Scr->ResizeCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 179:
# line 524 "gram.y"
{
			NewFontCursor(&Scr->ResizeCursor, yypvt[-0].ptr); } break;
case 180:
# line 526 "gram.y"
{
			NewBitmapCursor(&Scr->WaitCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 181:
# line 528 "gram.y"
{
			NewFontCursor(&Scr->WaitCursor, yypvt[-0].ptr); } break;
case 182:
# line 530 "gram.y"
{
			NewBitmapCursor(&Scr->MenuCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 183:
# line 532 "gram.y"
{
			NewFontCursor(&Scr->MenuCursor, yypvt[-0].ptr); } break;
case 184:
# line 534 "gram.y"
{
			NewBitmapCursor(&Scr->SelectCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 185:
# line 536 "gram.y"
{
			NewFontCursor(&Scr->SelectCursor, yypvt[-0].ptr); } break;
case 186:
# line 538 "gram.y"
{
			NewBitmapCursor(&Scr->DestroyCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 187:
# line 540 "gram.y"
{
			NewFontCursor(&Scr->DestroyCursor, yypvt[-0].ptr); } break;
case 188:
# line 544 "gram.y"
{} break;
case 191:
# line 552 "gram.y"
{ if (!do_colorlist_keyword (yypvt[-1].num, color,
								     yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled list color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 192:
# line 561 "gram.y"
{ list = do_colorlist_keyword(yypvt[-1].num,color,
								      yypvt[-0].ptr);
					  if (!list) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color list keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 194:
# line 572 "gram.y"
{ if (!do_color_keyword (yypvt[-1].num, color,
								 yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 195:
# line 583 "gram.y"
{} break;
case 198:
# line 590 "gram.y"
{ do_string_savecolor(color, yypvt[-0].ptr); } break;
case 199:
# line 591 "gram.y"
{ do_var_savecolor(yypvt[-0].num); } break;
case 200:
# line 594 "gram.y"
{} break;
case 203:
# line 601 "gram.y"
{ if (Scr->FirstTime &&
					      color == Scr->Monochrome)
					    AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 204:
# line 606 "gram.y"
{ 
				    if (HasShape) Scr->SqueezeTitle = TRUE;
				} break;
case 205:
# line 609 "gram.y"
{ list = &Scr->SqueezeTitleL; 
				  if (HasShape && Scr->SqueezeTitle == -1)
				    Scr->SqueezeTitle = TRUE;
				} break;
case 207:
# line 614 "gram.y"
{ Scr->SqueezeTitle = FALSE; } break;
case 208:
# line 615 "gram.y"
{ list = &Scr->DontSqueezeTitleL; } break;
case 211:
# line 620 "gram.y"
{
				if (Scr->FirstTime) {
				   do_squeeze_entry (list, yypvt[-3].ptr, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num);
				}
			} break;
case 212:
# line 628 "gram.y"
{} break;
case 215:
# line 635 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-2].ptr, (char *)
						AllocateIconManager(yypvt[-2].ptr, NULLSTR,
							yypvt[-1].ptr,yypvt[-0].num));
					} break;
case 216:
# line 641 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-3].ptr, (char *)
						AllocateIconManager(yypvt[-3].ptr,yypvt[-2].ptr,
						yypvt[-1].ptr, yypvt[-0].num));
					} break;
case 217:
# line 648 "gram.y"
{} break;
case 220:
# line 655 "gram.y"
{
			AddWorkSpace (yypvt[-0].ptr, NULLSTR, NULLSTR, NULLSTR, NULLSTR, NULLSTR);
		} break;
case 221:
# line 658 "gram.y"
{
			curWorkSpc = yypvt[-0].ptr;
		} break;
case 223:
# line 664 "gram.y"
{} break;
case 226:
# line 671 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-0].ptr, NULLSTR, NULLSTR, NULLSTR, NULLSTR);
		} break;
case 227:
# line 674 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-1].ptr, yypvt[-0].ptr, NULLSTR, NULLSTR, NULLSTR);
		} break;
case 228:
# line 677 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-2].ptr, yypvt[-1].ptr, yypvt[-0].ptr, NULLSTR, NULLSTR);
		} break;
case 229:
# line 680 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr, yypvt[-0].ptr, NULLSTR);
		} break;
case 230:
# line 683 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-4].ptr, yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr, yypvt[-0].ptr);
		} break;
case 231:
# line 688 "gram.y"
{
		    WMapCreateCurrentBackGround (yypvt[-1].ptr, NULL, NULL, NULL);
		} break;
case 232:
# line 691 "gram.y"
{
		    WMapCreateCurrentBackGround (yypvt[-2].ptr, yypvt[-1].ptr, NULL, NULL);
		} break;
case 233:
# line 694 "gram.y"
{
		    WMapCreateCurrentBackGround (yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr, NULL);
		} break;
case 234:
# line 697 "gram.y"
{
		    WMapCreateCurrentBackGround (yypvt[-4].ptr, yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr);
		} break;
case 235:
# line 702 "gram.y"
{
		    WMapCreateDefaultBackGround (yypvt[-1].ptr, NULL, NULL, NULL);
		} break;
case 236:
# line 705 "gram.y"
{
		    WMapCreateDefaultBackGround (yypvt[-2].ptr, yypvt[-1].ptr, NULL, NULL);
		} break;
case 237:
# line 708 "gram.y"
{
		    WMapCreateDefaultBackGround (yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr, NULL);
		} break;
case 238:
# line 711 "gram.y"
{
		    WMapCreateDefaultBackGround (yypvt[-4].ptr, yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr);
		} break;
case 239:
# line 716 "gram.y"
{} break;
case 242:
# line 723 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-0].ptr, 0);
					} break;
case 243:
# line 728 "gram.y"
{} break;
case 246:
# line 735 "gram.y"
{client = yypvt[-0].ptr;} break;
case 248:
# line 737 "gram.y"
{client = yypvt[-0].ptr;} break;
case 250:
# line 739 "gram.y"
{workspace = yypvt[-0].ptr;} break;
case 252:
# line 743 "gram.y"
{} break;
case 255:
# line 750 "gram.y"
{
				AddToClientsList (yypvt[-0].ptr, client);
			  } break;
case 256:
# line 754 "gram.y"
{} break;
case 259:
# line 761 "gram.y"
{
				AddToClientsList (workspace, yypvt[-0].ptr);
			  } break;
case 260:
# line 765 "gram.y"
{} break;
case 263:
# line 772 "gram.y"
{ if (Scr->FirstTime) AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 264:
# line 775 "gram.y"
{} break;
case 267:
# line 782 "gram.y"
{ AddToMenu(root, "", Action, NULLSTR, yypvt[-0].num,
						NULLSTR, NULLSTR);
					  Action = "";
					} break;
case 268:
# line 788 "gram.y"
{lastmenuitem = (MenuItem*) 0;} break;
case 271:
# line 795 "gram.y"
{
			if (yypvt[-0].num == F_SEPARATOR) {
			    if (lastmenuitem) lastmenuitem->separated = 1;
			}
			else {
			    lastmenuitem = AddToMenu(root, yypvt[-1].ptr, Action, pull, yypvt[-0].num, NULLSTR, NULLSTR);
			    Action = "";
			    pull = NULL;
			}
		} break;
case 272:
# line 805 "gram.y"
{
			if (yypvt[-0].num == F_SEPARATOR) {
			    if (lastmenuitem) lastmenuitem->separated = 1;
			}
			else {
			    lastmenuitem = AddToMenu(root, yypvt[-6].ptr, Action, pull, yypvt[-0].num, yypvt[-4].ptr, yypvt[-2].ptr);
			    Action = "";
			    pull = NULL;
			}
		} break;
case 273:
# line 817 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 274:
# line 818 "gram.y"
{
				yyval.num = yypvt[-1].num;
				Action = yypvt[-0].ptr;
				switch (yypvt[-1].num) {
				  case F_MENU:
				    pull = GetRoot (yypvt[-0].ptr, NULLSTR,NULLSTR);
				    pull->prev = root;
				    break;
				  case F_WARPRING:
				    if (!CheckWarpRingArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.warptoring argument \"%s\"\n",
						 Action);
					yyval.num = F_NOP;
				    }
				  case F_WARPTOSCREEN:
				    if (!CheckWarpScreenArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr, 
			"ignoring invalid f.warptoscreen argument \"%s\"\n", 
					         Action);
					yyval.num = F_NOP;
				    }
				    break;
				  case F_COLORMAP:
				    if (CheckColormapArg (Action)) {
					yyval.num = F_COLORMAP;
				    } else {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.colormap argument \"%s\"\n", 
						 Action);
					yyval.num = F_NOP;
				    }
				    break;
				} /* end switch */
				   } break;
case 275:
# line 859 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 276:
# line 860 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 277:
# line 861 "gram.y"
{ yyval.num = -(yypvt[-0].num); } break;
case 278:
# line 864 "gram.y"
{ yyval.num = yypvt[-0].num;
					  if (yypvt[-0].num == 0)
						yyerror("bad button 0");

					  if (yypvt[-0].num > MAX_BUTTONS)
					  {
						yyval.num = 0;
						yyerror("button number too large");
					  }
					} break;
case 279:
# line 876 "gram.y"
{ ptr = (char *)malloc(strlen(yypvt[-0].ptr)+1);
					  strcpy(ptr, yypvt[-0].ptr);
					  RemoveDQuote(ptr);
					  yyval.ptr = ptr;
					} break;
case 280:
# line 881 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
	}
	goto yystack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yys and yyv stacks */
	yys = (int *) malloc(yymaxdepth * sizeof(int));
	yyv = (YYSTYPE *) malloc(yymaxdepth * sizeof(YYSTYPE));

	if (yys==0 || yyv==0) {
	   yyerror( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yys!=0) free((char *) yys);
	if (yyv!=0) free((char *) yyv);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

