O /*****************************************************************************/ E /**                Copyright 1990 by Solbourne Computer, Inc		    **/ O /**                           Longmont, Colorado                            **/ O /**                                                                         **/ O /**                           All Rights Reserved                           **/ O /**                                                                         **/ O /**    Permission to use, copy, modify, and distribute this software and    **/ O /**    its documentation  for  any  purpose  and  without  fee is hereby    **/ O /**    granted, provided that the above copyright notice appear  in  all    **/ O /**    copies and that both  that  copyright  notice  and  this  permis-    **/ O /**    sion  notice appear in supporting  documentation,  and  that  the    **/ O /**    name  of  Solbourne  not  be  used  in  advertising  in publicity    **/ O /**    pertaining  to  distribution  of  the software  without specific,    **/ O /**    written prior permission.                                            **/ O /**                                                                         **/ O /**    SOLBOURNE  DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,    **/ O /**    INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS,    **/ O /**    IN  NO  EVENT SHALL SOLBROUNE BE LIABLE FOR ANY SPECIAL, INDIRECT    **/ O /**    OR CONSEQUENTIAL DAMAGES OR  ANY  DAMAGES  WHATSOEVER   RESULTING    **/ O /**    FROM LOSS OF USE,  DATA OR  PROFITS,  WHETHER  IN  AN  ACTION  OF    **/ O /**    CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING OUT OF OR    **/ O /**    IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.          **/ O /*****************************************************************************/    /*H  *	xshuffle.c -- makes your display into one of those 16 square puzzles.  */  *	Author		: M. Warner Losh	(imp@Solbourne.COM)   *	Version		: V01.00*  *	Version date	: Wed Aug 15 10:58:36 1990+  *	Creation date	: Sun Aug  5 10:00:03 1990   *  *	Usage:	xshuffle<  *			[-numsquares {number-of-squares}] Num squares both ways6  *			[-xnumsquares {num-squares-x}]	Num squares across4  *			[-ynumsquares {num-squares-y}]	Num squares down)  *			[-display {display}]		Display to use   *			[-border]			Draw a border!  *			[-solve]			Undo moves at end   *			[-xmax n]			Width of area  *			[-ymax n]			Height of area #  *			[-max n]			Size of square area M  *                      [-moves n]                      Maximum moves to make   */    /* Include files */    # include <stdio.h>  # include <signal.h> # include <X11/Xlib.h> # include <X11/Xatom.h>    /*  * Macro Definitions  */    /* Config parameters. */  7 #define NUM_SQUARES 16			/* Default numberof squares */ J #define MAX_SOLVE	1024*64	        /* Max number of moves saved (1024*64)*/   /* Magic numbers */ ! #define DOWN 0				/* Move down */  #define UP 1				/* Move up */ # #define RIGHT 2				/* Move rigth */ ! #define LEFT 3				/* Move left */   3 #define MODE_SCRAMBLE	0		/* We're scrambling now */ - #define MODE_SOLVE	1		/* We're solving now */ ' #define MODE_EXIT	2		/* Time to exit */   * #define X_FLAG	1			/* X coord specified */* #define Y_FLAG	2			/* Y coord specified */   /*  * Variables  */ * int moves[MAX_SOLVE];			/* Saved moves. */- int cur_move = 0;			/* Current move number */ 3 int max_moves = MAX_SOLVE;		/* Max moves to make */ 7 int solve = 0;				/* True when we are solving puzzle */ / int mode = MODE_SCRAMBLE;		/* Mode we are in */ 2 int boarder_width = 2;			/* Size of the boarder */< int nxsquares = NUM_SQUARES;		/* Number of squares across */@ int nysquares = NUM_SQUARES;		/* Number of squares veritcally */4 int speed = 1;				/* How fast to move.  Keep at 1 */. int last = -1;				/* What was the last move */- int x_size;				/* Size in pixels of square */ - int y_size;				/* Size in pixels of square */ & int y_max;				/* Biggest y we have. */& int x_max;				/* Biggest x we have. */1 int x;					/* current X of upper left of blank */ 0 int y;					/* Current Y of upper left of blank*/) int x_start = 0;			/* Start X location */ ) int y_start = 0;			/* Start Y location */   % Window w_root;				/* Puzzle window */ & Window root;				/* Real root window */) Display *dpy;				/* display connection */  GC mygc;				/* Drawing GC */3 Pixmap pm = 0;				/* Pixmap to save first square */ = unsigned long fg, bg;			/* Foreground and background pixel */ ( unsigned long scr;			/* Screen number */? int (*old_handler)();			/* Old Error handler We restore this */    /* Function Declarations */    int create_pm_handler ();  void die_usage ();
 void done ();  int main (); void move_a_square (); void move_down (); void move_left (); void move_right ();  void move_up (); void process_event (); void rand_move_a_square ();  void save_move (); void time_to_go(); void undo_move_a_square ();  int unique_match (); void usage ();  G /********************************************************************** ?  *     create_pm_handler () --- This is the handler for the one *  * 				XCreatePixmap request that we have.,  * 				All it does is to set pm to zero.  It-  * 				assumes that the only error it can get )  * 				is from CreatePixmap.  That is the '  * 				reason for the XSyncs around the   * 				XCreatePixmap.   *  
  * Arguments:   *  1  *     dpy		    -i- Display the error happened on 5  *     e		    -i- Event that caused us to get called.   *    * Returns:   *    */    int create_pm_handler (dpy, e)
 Display *dpy;  XErrorEvent *e;  {  	pm = 0;         return; & }    /* end of create_pm_handler () */  G /********************************************************************** D  *     time_to_go () --- This function is the signal handler for ^C.2  * 			 It gets called when the user wants to exit.3  * 			 If the user requested solving of the puzzle, 2  * 			 then we just bump the mode one.  Otherwise,  * 			 we set the mode to exit.   *  
  * Arguments:   *  <  *     sig	     -i- Signal number that caused us to execute.)  *     code	     -i- Code for that signal $  *     scp	     -i- Signal contexted.  *     addr	     -i- Address of the exception.  */   & void time_to_go (sig, code, scp, addr) int sig;	 int code;  struct sigcontext *scp;  char *addr;  {  	if (solve) 	 		mode++;  	else  		mode = MODE_EXIT;  }    /* end of time_to_go () */   G /********************************************************************** F  *     done () --- Gets called when we are done.  This function sleeps7  * 		   a while if we just got done solving the puzzle. 7  * 		   Then it maps a big window over all of the other 9  * 		   windows to force them to repaint.  Then it exits.   */    void done () {  	Window w;		/* big window */: 	XSetWindowAttributes att; /* Attributes for the window */" 	Visual visual;		/* Visual info */- 	unsigned long mask;	/* Mask for atributes */    	/* : 	 * If we just got done solving the puzzle, then we wait a0 	 * while.  We also flush all of Xlib's buffers. 	 */ 	if (solve && cur_move == 0) 	{	 		if (pm) : 			XCopyArea (dpy, pm, w_root, mygc, 0, 0, x_size, y_size, 				   x_start, y_start);  		XSync(dpy, False); 		sleep (3); 	}   	/* " 	 * Free the Pixmap if we need to. 	 */ 	if (pm) 		XFreePixmap (dpy, pm); 	  	/* ; 	 * Create an override redirect window, map it over all the : 	 * clients, then unmap it.  This will cause the screen to 	 * refresh.  Exit when done.  	 */ /* 	att.override_redirect = True; 	att.backing_store = False;  	att.save_under = False;: 	mask = CWOverrideRedirect | CWBackingStore | CWSaveUnder;" 	visual.visualid = CopyFromParent;5 	w = XCreateWindow (dpy, w_root, 0, 0, 9999, 9999, 0, 4 			   DefaultDepth (dpy, scr), InputOutput, &visual, 			   mask, &att); 	XMapRaised (dpy, w);  	XSync(dpy, False);  	XDestroyWindow(dpy, w); */	 	exit(1);  }    /* end of done () */   G /**********************************************************************    *     main () --- Main routine.  *  
  * Arguments:   *    *     argc    -i- Num args   *     argv    -i- args*  */*   int main (argc, argv)*	 int argc;* char **argv; {* 	int i;			/* Index for loops */pB 	int do_border = False;	/* Draw a border around all the squares */4 	char *display = NULL;	/* Text of display to use. */; 	int max_flag = 0;	/* Flag for what max's are specified. */ : 	XSetWindowAttributes att; /* Attributes for the window */" 	Visual visual;		/* Visual info */- 	unsigned long mask;	/* Mask for atributes */    	  	/* = 	 * Parse the arguments.  This is a real kludge right now, so  	 * please be kind...i 	 */ 	while (--argc)  	{. 		if (unique_match(*++argv, "-numsquares", 2)) 		{  			if (--argc) {* 				nysquares = nxsquares = atoi(*++argv); 				if (nysquares < 2) {  				  nysquares = nxsquares = 2; 				}n 			} 			elsea3 				die_usage ("-numsquares requires another arg");  			continue; 		}e' 		if (unique_match(*argv, "-moves", 2))a 		{e 			if (--argc) { 				max_moves = atoi (*++argv); 4                                 if (max_moves < 2) {.                                 max_moves = 2;!                                 }p                         }  			else . 				die_usage ("-moves requires another arg"); 			continue; 		} ) 		if (unique_match(*argv, "-display", 2))* 		{S 			if (--argc) 				display = *++argv; 			else 0 				die_usage ("-display requires another arg"); 			continue; 		}R. 		if (unique_match (*argv, "-xnumsquares", 3)) 		{E 			if (--argc) { 				nxsquares = atoi (*++argv);E 				if (nxsquares < 2) { 				  nxsquares = 2; 				}M 			} 			elseR3 				die_usage("-xnumsquares requires another arg");O 			continue; 		}R. 		if (unique_match (*argv, "-ynumsquares", 3)) 		{E 			if (--argc) { 				nysquares = atoi (*++argv);  				if (nysquares < 2) { 				  nysquares = 2; 				}O 			} 			else.3 				die_usage("-ynumsquares requires another arg");* 			continue; 		}*) 		if (unique_match (*argv, "-border", 2))  		{k 			do_border = True; 			continue; 		}r( 		if (unique_match (*argv, "-solve", 2)) 		{p
 			solve = 1;  			continue; 		}.& 		if (unique_match (*argv, "-max", 2)) 		{0 			if (--argc) 			{  				max_flag |= X_FLAG | Y_FLAG;# 				x_max = y_max = atoi (*++argv);m 			} 			else]+ 				die_usage("-max requires another arg");u 			continue; 		}q' 		if (unique_match (*argv, "-ymax", 3))a 		{} 			if (--argc) 			{ 				max_flag |= Y_FLAG;D 				y_max = atoi (*++argv);] 			} 			elser, 				die_usage("-ymax requires another arg"); 			continue; 		}r' 		if (unique_match (*argv, "-xmax", 3))	 		{x 			if (--argc) 			{ 				max_flag |= X_FLAG;  				x_max = atoi (*++argv);  			} 			elseo, 				die_usage("-xmax requires another arg"); 			continue; 		} 0 		fprintf (stderr,"Unknown option %s\n", *argv);
 		usage(); 	} 	h 	/* ! 	 * Setup the random number seed.* 	 */ 	srand (getpid());   	/*  	 * Open this display. 	 */ 	dpy = XOpenDisplay(display); 
 	if (!dpy) 	{  3 		fprintf(stderr, "xfroot: Can't open display.\n");g 		exit(1);   	}   	/*O" 	 * Trap ^C so we can do a refresh 	 */$ 	(void) signal (SIGINT, time_to_go); 	e 	/*h; 	 * Get the id of the root window.  No need for pseudo rootM> 	 * here becuase we draw on top of everything that is ontop of
 	 * the root.* 	 */ 	root = DefaultRootWindow(dpy);t   	/* % 	 * Get the default fg and bg colors.  	 */ 	scr = DefaultScreen(dpy); 	fg = WhitePixel(dpy, scr);l 	bg = BlackPixel(dpy, scr);] 		 	att.override_redirect = True; 	att.backing_store = False;r 	att.save_under = False;: 	mask = CWOverrideRedirect | CWBackingStore | CWSaveUnder;" 	visual.visualid = CopyFromParent;) 	w_root = XCreateWindow (dpy, root, 0, 0, 7 	  DisplayWidth (dpy, scr), DisplayHeight(dpy, scr), 0, 1 	  DefaultDepth (dpy, scr), InputOutput, &visual,s 	  mask, &att);e 	XMapWindow (dpy, w_root);   	/*r? 	 * Setup the GC that will let us do the magic.  Key points are ; 	 * the drawing mode IncludeInferios.  This is what lets usi 	 * draw on top of things. 	 */& 	mygc = XCreateGC (dpy, w_root, 0, 0);  	XSetForeground (dpy, mygc, fg);  	XSetBackground (dpy, mygc, bg);1 	XSetSubwindowMode (dpy, mygc, IncludeInferiors);f   	/*l* 	 * OK, find out how big to make things... 	 */ 	if ((max_flag & X_FLAG) == 0)" 		x_max = DisplayWidth (dpy, scr); 	if ((max_flag & Y_FLAG) == 0)# 		y_max = DisplayHeight (dpy, scr);i 	x_size = x_max / nxsquares; 	y_size = y_max / nysquares; 	x_max = x_size * nxsquares; 	y_max = y_size * nysquares; 	  	/*p 	 * Create the grid. 	 */ 	if (do_border)  	{: 		XSetLineAttributes (dpy, mygc, boarder_width, LineSolid, 				    CapNotLast, JoinMiter);n% 		for (i = 0; i <= y_max; i+= y_size)d1 			XDrawLine (dpy, w_root, mygc, 0, i, x_max, i);e% 		for (i = 0; i <= x_max; i+= x_size) 1 			XDrawLine (dpy, w_root, mygc, i, 0, i, y_max);( 	} 	d 	/*_( 	 * Start in the upper left hand corner. 	 */
 	x = x_start;_
 	y = y_start;d 	v 	/*(= 	 * Save the upper left hand corner square if we are going tos9 	 * solve this later.  We will later assume that if pm is)> 	 * non-zero, that it must be freed.  Also, check to make sure> 	 * that we can create this pixmap.  Some servers can't handle< 	 * all pixmap create requests.  We have to do this the hard; 	 * way.  If you know a better way (other than ignoring the 8 	 * condition), please let me know at the above address. 	 */ 	if (solve)	 	{ 		XSync (dpy, False);t5 		old_handler = XSetErrorHandler (create_pm_handler);	2 		pm = XCreatePixmap (dpy, w_root, x_size, y_size,  				    DefaultDepth(dpy, scr)); 		XSync (dpy, False);	! 		XSetErrorHandler (old_handler); 	 		if (pm)*6 			XCopyArea (dpy, w_root, pm, mygc, x_start, y_start, 				   x_size, y_size, 0, 0);v 		else: 			fprintf (stderr, "Warning: Start square not saved.\n"); 	} 	( 	/* ? 	 * Setup the mask of events.  I'm just looking for a key press* 	 * right now. 	 */< 	XSelectInput (dpy, w_root, KeyPressMask | ButtonPressMask); 		 	/*e; 	 * Loop forever.  Get a random number, move a square if itq5 	 * hasn't been just moved and is also on the screen.p 	 */
 	while (1) 	{ 		if (mode == MODE_EXIT)
 			done();5 		if (XEventsQueued (dpy, QueuedAfterReading) == 0) {l 			move_a_square();s 		}x 		else 			process_event();C 	}		 }    /* end of main () */   G /********************************************************************** C  *     process_event () --- Processes events that we are interestedu&  * 			    in.  All others are ignored.  */s   void process_event ()  {	) 	XEvent e;		/* Event we are looking at.*/g   	/* $ 	 * Read the event, and dispatch it. 	 */ 	XNextEvent(dpy, &e);* 	switch (e.type) 	{ 	/*-4 	 * KeyPress events cause us to go to the next mode. 	 */ 	case KeyPress:  	case ButtonPress: 		if (solve)
 			mode++; 		else 			mode = MODE_EXIT; 		break; 		 	/**% 	 * All XLib clients need to do this.  	 */ 	case MappingNotify: 		XRefreshKeyboardMapping (&e);g 		break;   	}" }    /* end of process_event () */ rG /**********************************************************************/D  *     move_a_square () --- Moves a square.  Will shuffle it when we+  * 			    are randomizing the screen.  Willl&  * 			    unshuffle it when we aren't.  */&   void move_a_square ()f {m 	if (mode == MODE_SCRAMBLE)r 		rand_move_a_square();y 	else  		undo_move_a_square(); " }    /* end of move_a_square () */ }G /**********************************************************************aF  *     rand_move_a_square () --- Moves a square randomly.  Updates the(  * 				 current X and Y positions.  Also  * 				 saves the move.e  */    void rand_move_a_square () {  	switch ((rand() >> 15) & 3) 	{ 	case DOWN:			/* Move down */e$ 		if (last != UP && y - y_size >= 0) 		{r 			move_down (x,y);i 			y -= y_size;n 			save_move(DOWN);d 		}				o 		break; 			X 	case UP:			/* Move up */0) 		if (last != DOWN && y + y_size < y_max)p 		{r 			move_up (x, y); 			y += y_size;  			save_move(UP);  		}  		break;   	case RIGHT:			/* Move right */p& 		if (last != LEFT && x - x_size >= 0) 		{) 			move_right (x,y); 			x -= x_size;* 			save_move(RIGHT); 		}* 		break;   	case LEFT:			/* Move left */t* 		if (last != RIGHT && x + x_size < x_max) 		{- 			move_left (x, y); 			x += x_size;  			save_move(LEFT);c 		}v 		break; 	}' }    /* end of rand_move_a_square () */r oG /**********************************************************************/C  *     undo_move_a_square () --- Undoes the latest move that hasn't   * 				 been undone.  */    void undo_move_a_square () {t 	switch (moves[--cur_move])r 	{ 	case DOWN:			/* Move down */  		move_up (x,y); 		y += y_size; 		break; 			a 	case UP:			/* Move up */  		move_down (x, y);. 		y -= y_size; 		break;   	case RIGHT:			/* Move right */i 		move_left (x,y); 		x += x_size; 		break;   	case LEFT:			/* Move left */	 		move_right (x, y); 		x -= x_size; 		break; 	} 	if (cur_move <= 0)( 		mode = MODE_EXIT;	' }    /* end of undo_move_a_square () */} 	G /**********************************************************************;E  *     save_move () --- Saves the move, iff we are solving this thing{  * 			later.  * t
  * Arguments:   *  1  *     move	    -i- Move to save (eg LEFT, RIGHT)   */    void save_move (move)_	 int move;  { 
 	last = move;  	if (solve)p 	{ 		moves[cur_move++] = move;e 		if (cur_move >= max_moves) 			mode = MODE_SOLVE;  	} }    /* end of save_move () */ *G /**********************************************************************e=  *     unique_match () --- Does st match pat for at least leni  * 			   characters?  * t
  * Arguments:u  * r<  *     st	       -i- String to match.  This is what the user  * 			   types.  *     pat	       -i- Pattern to match against+  *     len	       -i- Minimum unque length.u  * a  * Returns:O  * c?  *     SUCCESS	       --- String matches to at least the length	  * 			   requested. .  *     FAILURE	       --- Strings don't match.  */    int unique_match (st, pat, len) 	 char *st;s
 char *pat; int len; {qB 	return len <= strlen (st) && strncmp (st, pat, strlen (st)) == 0; 	(! }    /* end of unique_match () */_ dG /********************************************************************** B  *     move_right () --- Moves the square on the left of the blank  * 			 square to the right.a  *    */    void move_right () {Y 	int i;	 	_& 	for (i = x - x_size; i < x; i+=speed)= 		XCopyArea (dpy, w_root, w_root, mygc, i, y, x_size, y_size,u
 			   i+1,y);( }    /* end of move_right () */a 	G /**********************************************************************aB  *     move_left () --- Moves the square to the right of the blank  * 			square to the left  */q   void move_left ()a {  	int i;x 		& 	for (i = x + x_size; i > x; i-=speed)= 		XCopyArea (dpy, w_root, w_root, mygc, i, y, x_size, y_size,g
 			   i-1,y);e }    /* end of move_left () */  G /**********************************************************************/A  *     move_up () --- Moves the square below the blank square up.   */    void move_up ()a {  	int i;y  & 	for (i = y + y_size; i > y; i-=speed)= 		XCopyArea (dpy, w_root, w_root, mygc, x, i, x_size, y_size,t
 			   x,i-1);/ }   G /**********************************************************************;E  *     move_down () --- Moves the square above the blank square down.M  */    void move_down ()o {o 	int i;y  & 	for (i = y - y_size; i < y; i+=speed)= 		XCopyArea (dpy, w_root, w_root, mygc, x, i, x_size, y_size,l
 			   x,i+1);o }   G /**********************************************************************P;  *     usage () --- Tells the user how to use this program.c  */s  
 void usage ()a {s         fprintf (stderr, "\n");r, 	fprintf (stderr, "XShuffle [-options]\n");          fprintf (stderr, "\n");;[         fprintf (stderr, "         [-numsquares n]       : Number of squares both ways\n");sX         fprintf (stderr, "         [-xnumsquares n]      : Number of squares across\n");V         fprintf (stderr, "         [-ynumsquares n]      : Number of squares down\n");N         fprintf (stderr, "         [-display disp]       : Display to use\n");M         fprintf (stderr, "         [-border]             : Draw a border\n");yQ         fprintf (stderr, "         [-solve]              : Undo moves at end\n");uS         fprintf (stderr, "         [-max n]              : Size of square area\n");lM         fprintf (stderr, "         [-xmax n]             : Width of area\n");)N         fprintf (stderr, "         [-ymax n]             : Height of area\n");U         fprintf (stderr, "         [-moves n]            : Maximum moves to make\n");          fprintf (stderr, "\n");/	 	exit(1);o }    /* end of usage () */ sG /********************************************************************** ;  *     die_usage () --- Prints the error, then calls usage.r  * m
  * Arguments:x  * e$  *     msg	    -i- Message to print.  */	   void die_usage (msg)
 char *msg; {  	fprintf (stderr, "%s\n", msg); 	 	usage();r }    /* end of die_usage () */  