N /*****************************************************************************  *  * FACILITY:  *   XPool	DECwindows Pool game   *	   * ABSTRACT:I  *   This module contains the routines which interact with the DECwindows B  *   Toolkit.  It includes all of the widgets and their callbacks.  *
  * AUTHOR:  *   Doug Stefanelli  *   * CREATION DATE: 1-October-1989  *  * Edit History   *"  *  DS	1-Oct-1989	Original version3  *  DS	4-Dec-1989	Modified to run from XtMainLoop() C  *  DS	13-Mar-1990	Support 2 displays.  Add Ultrix support.  Modify 5  *			velocity select widget - set spin by selecting a   *			position on the cue ball.  *  */    /*#  * Routines included in this module   */ > static void handle_exposures();		/* exposure event callback */3 void enable_button();			/* activate mouse button */ 6 void disable_button();			/* deactivate mouse button */0 void got_button();			/* process button events */@ void got_position();			/* process button/cursor position info */C void enable_game_options();		/* activate options for during game */ H void enable_select_options();		/* activate options for selecting play */4 void enable_respot();			/* activate respot option */7 void disable_respot();			/* deactivate respot option */ E static void frame_complete();		/* frame timeout occurance callback */ 5 void set_frame_timeout();		/* enable frame timeout */ 8 void cancel_frame_timeout();		/* cancel frame timeout */E static void delay_complete();		/* delay timeout occurance callback */ 5 void set_delay_timeout();		/* enable delay timeout */ 8 void cancel_delay_timeout();		/* cancel delay timeout *// int init_screen();			/* initialize a display */ = void destroy_remote_screen();		/* destroy a remote display */ 6 void remove_menus();			/* take down any popup menus */A static void challenge_response();	/* challenge widget callback */ 7 int accept_challenge();			/* set up challenge widget */ 9 static void select_net();		/* net type widget callback */ D static void string_changed();		/* node string processing callback */5 void get_node();			/* set up challenge node widget */ ; static void set_skill();		/* skill level widget callback */ 3 void get_skill();			/* set up skill level widget */ C static void set_limit();		/* straight pool limit widget callback */ ; void get_limit();			/* set up straight pool limit widget */ @ static void menu_select();		/* menu selection widget callback */? void select_menu();			/* set up option menu selection widget */ H static void velocity_select();		/* velocity selection widget callback */= void get_velocity();			/* set up velocity selection widget */ ? static void provide_help();		/* help widget display callback */ < static void hide_help();		/* help widget removal callback */1 void display_about();			/* set up about widget */ / void display_help();			/* set up help widget */ 1 void select_play();			/* select play main loop */ A static void set_control();		/* control menubar widget callback */ B static void select_option();		/* option menubar widget callback */F static void select_opponent();		/* opponent menubar widget callback */> static void select_game();		/* game menubar widget callback */9 static void window_menubar();		/* set up menuar widget */ @ void open_window();			/* create & open graphics window widget */   /*  * Include files  */  #include <stdio.h> #include "xpool.h" #include "xpool_icon.h"  #include "xpool_help.h" 
 #ifdef VMS! #include <decw$include:DwtAppl.h>   #include <decw$include:Vendor.h> #include <cda$def.h> #else  #include <X11/DwtAppl.h> #include <X11/Vendor.h>  #include <cda_def.h> #endif   /*  * Local variables  */ " static char *opponent_string[] = { 	"Two Player", 	"vs. Computer", 	"Network", 
 	"Automatic",  	"AutoNet",  	"AutoLock"  	};    static char *game_string[] = { 	"Straight Pool", 
 	"8 Ball",
 	"9 Ball", 	"Rotation"  	};   ! static char *control_string[] = {  	"Start Game", 	"End Game", 	"Quit"  	};     static char *option_string[] = { 	"Preset Velocity",  	"Confirm Shots",  	"Set Computer Skill", 	"Straight Pool Limit",  	"Respot Ball" 	};    #define PRESET_VELOCITY		0 #define CONFIRM_SHOTS		1 #define COMPUTER_SKILL		2  #define STRAIGHT_LIMIT		3  #define RESPOT_BALL		4   static char *help_string[] = {	 	"About", 
 	"More About"  	};   B static XtAppContext application_context;	/* application context */  * #define num_opps	XtNumber(opponent_string)' #define num_games	XtNumber(game_string) - #define num_controls	XtNumber(control_string) + #define num_options	XtNumber(option_string) ' #define num_helps	XtNumber(help_string)   F static Widget window_widget[MAX_SCREENS];	/* graphics window widget */K static Widget dialogbox_widget[MAX_SCREENS];	/* highest level dialog box */ E static Widget helpbox_widget[MAX_SCREENS];	/* help text dialog box */ G static Widget aboutbox_widget[MAX_SCREENS];	/* help/about dialog box */ Q static Widget controlitem_widget[MAX_SCREENS][num_controls];/* control options */ N static Widget optionitem_widget[MAX_SCREENS][num_options];	/* misc. options */M static Widget menubox_widget[MAX_SCREENS];	/* hi/lo select menu dialog box */ O static Widget velocitybox_widget[MAX_SCREENS];	/* velocity select dialog box */ O static Widget velocity_widget[MAX_SCREENS];	/* velocity select slider widget */ H static Widget spin_widget[MAX_SCREENS];		/* spin select window widget */J static Widget game_widget[MAX_SCREENS];		/* game select menu bar option */Q static Widget opponent_widget[MAX_SCREENS];	/* opponent select menu bar option */   D static Widget skillbox_widget;			/* set computer skill dialog box */I static Widget limitbox_widget;			/* set straight pool limit dialog box */ B static Widget nodebox_widget;			/* challenge request dialog box */F static Widget challengebox_widget;		/* Network challenge dialog box */  ( #define min(x,y) ((x) < (y) ? (x) : (y))( #define max(x,y) ((x) > (y) ? (x) : (y))   static char *xpool_help;< static DwtFontList mnfont[MAX_SCREENS], abfont[MAX_SCREENS];) static XtIntervalId frame_timeout = NULL; ) static XtIntervalId delay_timeout = NULL; ! static unsigned char respot_ball; ! static int x_offset[MAX_SCREENS]; ! static int y_offset[MAX_SCREENS];  static int num_velocities = 0; static GC dgc[MAX_SCREENS];    /*  * Global variables   */ M Widget toplevel_widget[MAX_SCREENS];	/* Root widget ID of our application. */ @ int num_screens = 0;			/* number of displays currently active */  7 int position;				/* button/cursor position variables */  int position_mask; int pointer_x, pointer_y;   2 int game;				/* these params can be set via XRM */
 int opponent;  int network_type;  int computer_skill; 
 int limit;! unsigned char sound[MAX_SCREENS]; + unsigned char preset_velocity[MAX_SCREENS]; ) unsigned char confirm_shots[MAX_SCREENS];   < int menu_selection;			/* these params are accessed by the */> int remote_velocity;			/* program upon completion of widget */! int velocity;				/* processing */ 	 int roll; 	 int spin;  unsigned char abort_flag = 0; ! unsigned char challenge_accepted; $ unsigned char button_active = FALSE; char node[35];   /*  * External variables   */ $ extern unsigned char action_started; extern int system;   /*  * External routines  */  extern get_window(); extern void redraw_display();   P /*******************************************************************************  *3  * Exposure handling callback for the window widget   *P  ******************************************************************************/  * static void handle_exposures(w, tag, data)	 Widget w;  DwtWindowCallbackStruct *data; { 
     int s;  #     for (s=0; s<num_screens; s++) { 5 	if (XtDisplay(w) == XtDisplay(toplevel_widget[s])) { $ 	    redraw_display(s, data->event); 	    break;  	}     }  }   P /*******************************************************************************  *  * Button handling routines   *P  ******************************************************************************/   void enable_button(mask) {      button_active = TRUE;      position_mask = mask; $     if (position_mask & RESPOT_BALL) 	enable_respot();  }    void disable_button()  {      button_active = FALSE;     disable_respot();* }*   void got_button(w, tag, event)	 Widget w;  XEvent *event; {o
     int s;  !     for (s=0; s<num_screens; s++)n5 	if (XtDisplay(w) == XtDisplay(toplevel_widget[s])) { * 	    if (event->xbutton.button == Button1)# 		if (button_active && system == s):7 		    got_position(event->xbutton.x, event->xbutton.y);9 	    break;i 	} }r   void got_position(x, y)r {n     position = 0;4  "     if ((position_mask & TABLE) &&2 	(x > left_edge-border && x < right_edge+border &&1 	 y > bottom_edge-border && y < top_edge+border))e 	position = OVER_TABLE; &     else if ((position_mask & FELT) &&2 	(x > left_edge+radius && x < right_edge-radius &&1 	 y > bottom_edge+radius && y < top_edge-radius))e 	position = OVER_FELT;&     else if ((position_mask & HEAD) &&, 	(x > left_edge+radius && x < break_point &&1 	 y > bottom_edge+radius && y < top_edge-radius))t 	position = OVER_HEAD;*     else if ((position_mask & BALLRACK) &&6 	(x > left_edge-diameter && x < right_edge+diameter &&) 	 y > windowH-diameter-2 && y < windowH))t 	position = OVER_BALLRACK;  C     if (position != 0) {	/* we got a valid position, so continue */o 	pointer_x = x;s 	pointer_y = y;/ 	pool_table();     }i }*  P /*******************************************************************************  *%  * Widget sensitivity select routines   *P  ******************************************************************************/   void enable_game_options() {a
     int s;  #     for (s=0; s<num_screens; s++) {lE 	XtSetSensitive(controlitem_widget[s][0], FALSE); /* no start game *//F 	XtSetSensitive(controlitem_widget[s][1], TRUE);  /* allow end game */Y 	XtSetSensitive(optionitem_widget[s][COMPUTER_SKILL], FALSE); /* no computer skill set */eY 	XtSetSensitive(optionitem_widget[s][STRAIGHT_LIMIT], FALSE); /* no straight limit set */lR 	XtSetSensitive(optionitem_widget[s][RESPOT_BALL], FALSE);    /* no ball respot */A 	XtSetSensitive(game_widget[s], FALSE);		 /* no game selection */cH 	XtSetSensitive(opponent_widget[s], FALSE);	 /* no opponent selection */     }c }i   void enable_select_options() {e
     int s;  #     for (s=0; s<num_screens; s++) { H 	XtSetSensitive(controlitem_widget[s][0], TRUE);  /* allow start game */C 	XtSetSensitive(controlitem_widget[s][1], FALSE); /* no end game */t[ 	XtSetSensitive(optionitem_widget[s][COMPUTER_SKILL], TRUE); /* allow computer skill set */	[ 	XtSetSensitive(optionitem_widget[s][STRAIGHT_LIMIT], TRUE); /* allow straight limit set */tQ 	XtSetSensitive(optionitem_widget[s][RESPOT_BALL], FALSE);   /* no ball respot */*C 	XtSetSensitive(game_widget[s], TRUE);		 /* allow game selection */ J 	XtSetSensitive(opponent_widget[s], TRUE);	 /* allow opponent selection */     }	     abort_flag = 0;g }*  - void enable_respot()		/* allow ball respot */* { A     XtSetSensitive(optionitem_widget[system][RESPOT_BALL], TRUE);_     respot_ball = FALSE; }r  / void disable_respot()	/* disable ball respot */	 {oB     XtSetSensitive(optionitem_widget[system][RESPOT_BALL], FALSE);     respot_ball = FALSE; }b  P /*******************************************************************************  *  * Timing routines  *P  ******************************************************************************/   static void frame_complete() {c     frame_timeout = NULL;p     pool_table();p }_  $ void set_frame_timeout(milliseconds) int milliseconds;e {iZ     frame_timeout = XtAppAddTimeOut(application_context, milliseconds, frame_complete, 0); }1   void cancel_frame_timeout()d {h      if (frame_timeout != NULL) {  	XtRemoveTimeOut(frame_timeout); 	frame_timeout = NULL;     }{ }"   static void delay_complete() {e     delay_timeout = NULL;"     pool_table();o }    void set_delay_timeout(seconds)] int seconds; {PZ     delay_timeout = XtAppAddTimeOut(application_context, 1000*seconds, delay_complete, 0); }r   void cancel_delay_timeout()  {}      if (delay_timeout != NULL) {  	XtRemoveTimeOut(delay_timeout); 	delay_timeout = NULL;     }i }, "P /*******************************************************************************  *1  * Widget initialization and termination routines   *P  ******************************************************************************/   int init_screen(node_string) char *node_string; {t     Display *display;t     int ignore, s, i, len;     int zero = 0;o       if (node_string == 0) {	 	s = LOCAL;_ 	XtToolkitInitialize();t4 	application_context = XtCreateApplicationContext();6 	for (i=0, len=0; i<XtNumber(xpool_help_strings); i++)* 	    len += strlen(xpool_help_strings[i]);" 	xpool_help = (char *)malloc(len); 	if (xpool_help == 0)g& 	    xpool_help = "No help available"; 	else {b/ 	    strcpy(xpool_help, xpool_help_strings[0]);;3 	    for (i=1; i<XtNumber(xpool_help_strings); i++)w, 		strcat(xpool_help, xpool_help_strings[i]); 	}
     } else 	s = REMOTE;       display = XtOpenDisplay(0 		application_context,	/* application context */( 		node_string,		/* remote node string */* 		header,			/* Main window banner text. */" 		"Xpool",		/* Root class name. */ 		NULL,			/* No option list. */i 		0,			/* Number of options. */o% 		&zero,			/* Address of arg count */e 		0);			/* arg list */       if (display == 0) return 0;i     num_screens++;  *     toplevel_widget[s] = XtAppCreateShell(	 		header,e
 		"Xpool", 		applicationShellWidgetClass,
 		display, 		NULL,u 		0);t       /*M      * Clear all persistant widgets so they are recreated if they are reused.       */c     menubox_widget[s] = NULL;e!     velocitybox_widget[s] = NULL;t     aboutbox_widget[s] = NULL;     helpbox_widget[s] = NULL;b       if (s == LOCAL) {e; 	get_defaults(s, &game, &opponent, &computer_skill, &limit,e9 		 &network_type, &preset_velocity[s], &confirm_shots[s], * 		 &sound[s], &x_offset[s], &y_offset[s]); 	nodebox_widget = NULL;y 	skillbox_widget = NULL; 	limitbox_widget = NULL;
     } else= 	get_defaults(s, &ignore, &ignore, &ignore, &ignore, &ignore,r5 		 &preset_velocity[s], &confirm_shots[s], &sound[s],  		 &x_offset[s], &y_offset[s]);s  
     return 1;c }t   void destroy_remote_screen() {t7     XtCloseDisplay(XtDisplay(toplevel_widget[REMOTE])); /     XtUnrealizeWidget(toplevel_widget[REMOTE]);i-     XtDestroyWidget(toplevel_widget[REMOTE]);S     num_screens--; }    void remove_menus()n {u     num_velocities = 0;rT     if (velocitybox_widget[LOCAL] != NULL && XtIsManaged(velocitybox_widget[LOCAL])), 	XtUnmanageChild(velocitybox_widget[LOCAL]); }r  P /*******************************************************************************  *9  * Ask for acceptance of the challenge on the remote node[  *P  ******************************************************************************/  , static void challenge_response(w, tag, data)	 Widget w;  DwtAnyCallbackStruct *data;e {e)     XtDestroyWidget(challengebox_widget);w     challenge_accepted = tag;r     pool_table();o }    int accept_challenge(s, string)l
 char *string;n {c     XEvent event;t     Arg arglist[10];     Widget accept_widget;n     Widget refuse_widget;      Widget label_widget;
     int n;  
     n = 0;8     XtSetArg(arglist[n], DwtNunits, DwtFontUnits);		n++;?     XtSetArg(arglist[n], DwtNresize, DwtResizeShrinkWrap);	n++;*4     XtSetArg(arglist[n], DwtNborderWidth, 0);			n++;5     XtSetArg(arglist[n], DwtNmarginWidth, 20);			n++;o6     XtSetArg(arglist[n], DwtNmarginHeight, 10);			n++;7     XtSetArg(arglist[n], DwtNstyle, DwtModeless);		n++;tZ     challengebox_widget = DwtDialogBoxPopupCreate(toplevel_widget[s], header, arglist, n);  
     n = 0;+     XtSetArg(arglist[n], DwtNx, 4);				n++;l+     XtSetArg(arglist[n], DwtNy, 4);				n++; B     XtSetArg(arglist[n], DwtNlabel, DwtLatin1String(string));	n++;L     label_widget = DwtLabelCreate(challengebox_widget, "Label", arglist, n);  
     n = 0;8     XtSetArg(arglist[n], DwtNbordHighlight, TRUE);		n++;,     XtSetArg(arglist[n], DwtNx, 50);				n++;,     XtSetArg(arglist[n], DwtNy, 25);				n++;S     accept_widget = DwtPushButtonCreate(challengebox_widget, "Accept", arglist, n);)N     XtAddCallback(accept_widget, DwtNactivateCallback, challenge_response, 1);  
     n = 0;8     XtSetArg(arglist[n], DwtNbordHighlight, TRUE);		n++;-     XtSetArg(arglist[n], DwtNx, 120);				n++; ,     XtSetArg(arglist[n], DwtNy, 25);				n++;S     refuse_widget = DwtPushButtonCreate(challengebox_widget, "Refuse", arglist, n);fN     XtAddCallback(refuse_widget, DwtNactivateCallback, challenge_response, 0);  0     XtMoveWidget(challengebox_widget, 100, 100);  !     XtManageChild(accept_widget); !     XtManageChild(refuse_widget);(      XtManageChild(label_widget);'     XtManageChild(challengebox_widget);&)     XtRealizeWidget(challengebox_widget);T       if (s == 0) $ 	XtAppMainLoop(application_context);     return;      }i _P /*******************************************************************************  *(  * Get the name of the node to challenge  *P  ******************************************************************************/  $ static void select_net(w, tag, data)	 Widget w; $ DwtTogglebuttonCallbackStruct *data; {t     if (data->value) 	network_type = tag; }   ( static void string_changed(w, tag, data)	 Widget w;V DwtAnyCallbackStruct *data;i {!     int string_len;l     char *new_string;e  &     new_string = DwtSTextGetString(w);(     if (strchr(new_string, '\n') != 0) {= 	string_len = (int)strchr(new_string,'\n') - (int)new_string;*& 	if (string_len > 35) string_len = 35;' 	strncpy(node, new_string, string_len);* 	node[string_len] = '\0';*! 	XtUnmanageChild(nodebox_widget);e 	DwtSTextSetString(w, ""); 	enable_game_options();  	pool_table();     }  }S   void get_node()i {_     Arg arglist[10];1     Widget text_widget;		/* Simple text widget */i+     Widget label_widget;	/* label widget */S     Widget nettype_widget;     Widget netitem_widget[2];*
     int n;  !     if (nodebox_widget != NULL) {n 	XtManageChild(nodebox_widget);A 	return;     }g  
     n = 0;8     XtSetArg(arglist[n], DwtNunits, DwtFontUnits);		n++;5     XtSetArg(arglist[n], DwtNtakeFocus, TRUE);			n++;e?     XtSetArg(arglist[n], DwtNresize, DwtResizeShrinkWrap);	n++;t4     XtSetArg(arglist[n], DwtNborderWidth, 0);			n++;5     XtSetArg(arglist[n], DwtNmarginWidth, 20);			n++; 6     XtSetArg(arglist[n], DwtNmarginHeight, 10);			n++;5     XtSetArg(arglist[n], DwtNstyle, DwtModal);			n++;/:     XtSetArg(arglist[n], DwtNdefaultPosition, TRUE);		n++;Z     nodebox_widget = DwtDialogBoxPopupCreate(dialogbox_widget[LOCAL], header, arglist, n);  
     n = 0;+     XtSetArg(arglist[n], DwtNx, 4);				n++;_+     XtSetArg(arglist[n], DwtNy, 4);				n++;t#     XtSetArg(arglist[n], DwtNlabel,]B 	DwtLatin1String("Which node would you like to challenge?"));	n++;G     label_widget = DwtLabelCreate(nodebox_widget, "Label", arglist, n);t  
     n = 0;+     XtSetArg(arglist[n], DwtNx, 4);				n++; ,     XtSetArg(arglist[n], DwtNy, 16);				n++;/     XtSetArg(arglist[n], DwtNcols, 35);				n++;i.     XtSetArg(arglist[n], DwtNrows, 1);				n++;3     XtSetArg(arglist[n], DwtNmaxLength, 35);			n++;oE     text_widget = DwtSTextCreate(nodebox_widget, "Text", arglist, n);tL     XtAddCallback(text_widget, DwtNvalueChangedCallback, string_changed, 0);  
 #ifdef VMS
     n = 0;+     XtSetArg(arglist[n], DwtNx, 4);				n++;*,     XtSetArg(arglist[n], DwtNy, 35);				n++;0     XtSetArg(arglist[n], DwtNheight, 25);			n++;5     XtSetArg(arglist[n], DwtNmenuRadio, TRUE);			n++;mC     XtSetArg(arglist[n], DwtNmenuPacking, DwtMenuPackingNone);	n++;mK     nettype_widget = DwtMenuCreate(nodebox_widget, "Net Type", arglist, n);l  
     n = 0;H     XtSetArg(arglist[n], DwtNvalue, network_type == LOCAL ? 1 : 0); n++;8     XtSetArg(arglist[n], DwtNbordHighlight, TRUE);		n++;,     XtSetArg(arglist[n], DwtNx, 40);				n++;+     XtSetArg(arglist[n], DwtNy, 5);				n++;eX     netitem_widget[0] = DwtToggleButtonCreate(nettype_widget, "Local Area", arglist, n);R     XtAddCallback(netitem_widget[0], DwtNvalueChangedCallback, select_net, LOCAL);  
     n = 0;I     XtSetArg(arglist[n], DwtNvalue, network_type == REMOTE ? 1 : 0); n++;{8     XtSetArg(arglist[n], DwtNbordHighlight, TRUE);		n++;-     XtSetArg(arglist[n], DwtNx, 150);				n++;*+     XtSetArg(arglist[n], DwtNy, 5);				n++;*W     netitem_widget[1] = DwtToggleButtonCreate(nettype_widget, "Wide Area", arglist, n);*S     XtAddCallback(netitem_widget[1], DwtNvalueChangedCallback, select_net, REMOTE);n  "     XtManageChild(nettype_widget);(     XtManageChildren(netitem_widget, 2); #else      network_type = LOCAL;s #endif        XtManageChild(label_widget);     XtManageChild(text_widget);="     XtManageChild(nodebox_widget); }= lP /*******************************************************************************  *  * Get the computer skill leveln  *P  ******************************************************************************/  " static void set_skill(w, sw, data)	 Widget w;r
 Widget sw; DwtAnyCallbackStruct *data;+ {      Arg arglist[1];x  5     XtSetArg(arglist[0], DwtNvalue, &computer_skill);       XtGetValues(sw, arglist, 1);%     XtUnmanageChild(skillbox_widget);  }    void get_skill() {t     Arg arglist[10];     Widget skill_widget;     Widget label_widget[2];R     Widget ok_widget;U
     int n;  "     if (skillbox_widget != NULL) {  	XtManageChild(skillbox_widget); 	return;     }e  
     n = 0;8     XtSetArg(arglist[n], DwtNunits, DwtFontUnits);		n++;?     XtSetArg(arglist[n], DwtNresize, DwtResizeShrinkWrap);	n++;e4     XtSetArg(arglist[n], DwtNborderWidth, 0);			n++;5     XtSetArg(arglist[n], DwtNmarginWidth, 10);			n++;t5     XtSetArg(arglist[n], DwtNmarginHeight, 5);			n++; 5     XtSetArg(arglist[n], DwtNstyle, DwtModal);			n++;o:     XtSetArg(arglist[n], DwtNdefaultPosition, TRUE);		n++;[     skillbox_widget = DwtDialogBoxPopupCreate(dialogbox_widget[LOCAL], header, arglist, n);t  
     n = 0;:     XtSetArg(arglist[n], DwtNvalue, computer_skill);		n++;#     XtSetArg(arglist[n], DwtNtitle,o6 	DwtLatin1String("      Computer Skill Level"));		n++;+     XtSetArg(arglist[n], DwtNx, 6);				n++; ,     XtSetArg(arglist[n], DwtNy, 12);				n++;0     XtSetArg(arglist[n], DwtNwidth, 175);			n++;6     XtSetArg(arglist[n], DwtNshowValue, False);			n++;H     skill_widget = DwtScaleCreate(skillbox_widget, "Skill", arglist, n);  
     n = 0;A     XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Bad"));	n++;[+     XtSetArg(arglist[n], DwtNx, 6);				n++;e+     XtSetArg(arglist[n], DwtNy, 2);				n++;rL     label_widget[0] = DwtLabelCreate(skillbox_widget, "Label1", arglist, n);  
     n = 0;B     XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Good"));	n++;,     XtSetArg(arglist[n], DwtNx, 85);				n++;+     XtSetArg(arglist[n], DwtNy, 2);				n++;*L     label_widget[1] = DwtLabelCreate(skillbox_widget, "Label2", arglist, n);  
     n = 0;8     XtSetArg(arglist[n], DwtNbordHighlight, TRUE);		n++;,     XtSetArg(arglist[n], DwtNx, 43);				n++;,     XtSetArg(arglist[n], DwtNy, 60);				n++;G     ok_widget = DwtPushButtonCreate(skillbox_widget, "Ok", arglist, n);gL     XtAddCallback(ok_widget, DwtNactivateCallback, set_skill, skill_widget);       XtManageChild(ok_widget);e&     XtManageChildren(label_widget, 2);      XtManageChild(skill_widget);#     XtManageChild(skillbox_widget);  }   P /*******************************************************************************  *  * Get the straight pool limit  *P  ******************************************************************************/  " static void set_limit(w, lw, data)	 Widget w; 
 Widget lw; DwtAnyCallbackStruct *data;1 {	     Arg arglist[1];a  ,     XtSetArg(arglist[0], DwtNvalue, &limit);      XtGetValues(lw, arglist, 1);%     XtUnmanageChild(limitbox_widget);  }l   void get_limit() {      Arg arglist[10];     Widget limit_widget;     Widget ok_widget;D
     int n;  "     if (limitbox_widget != NULL) {  	XtManageChild(limitbox_widget); 	return;     }g  
     n = 0;8     XtSetArg(arglist[n], DwtNunits, DwtFontUnits);		n++;?     XtSetArg(arglist[n], DwtNresize, DwtResizeShrinkWrap);	n++; 4     XtSetArg(arglist[n], DwtNborderWidth, 0);			n++;5     XtSetArg(arglist[n], DwtNmarginWidth, 10);			n++; 5     XtSetArg(arglist[n], DwtNmarginHeight, 5);			n++;i5     XtSetArg(arglist[n], DwtNstyle, DwtModal);			n++;C:     XtSetArg(arglist[n], DwtNdefaultPosition, TRUE);		n++;[     limitbox_widget = DwtDialogBoxPopupCreate(dialogbox_widget[LOCAL], header, arglist, n);   
     n = 0;2     XtSetArg(arglist[n], DwtNvalue, limit);			n++;2     XtSetArg(arglist[n], DwtNminValue, 10);			n++;3     XtSetArg(arglist[n], DwtNmaxValue, 200);			n++;t#     XtSetArg(arglist[n], DwtNtitle,;5 	DwtLatin1String("      Straight Pool Limit"));		n++; +     XtSetArg(arglist[n], DwtNx, 6);				n++;a+     XtSetArg(arglist[n], DwtNy, 2);				n++;a0     XtSetArg(arglist[n], DwtNwidth, 175);			n++;H     limit_widget = DwtScaleCreate(limitbox_widget, "Limit", arglist, n);  
     n = 0;8     XtSetArg(arglist[n], DwtNbordHighlight, TRUE);		n++;,     XtSetArg(arglist[n], DwtNx, 43);				n++;,     XtSetArg(arglist[n], DwtNy, 50);				n++;G     ok_widget = DwtPushButtonCreate(limitbox_widget, "Ok", arglist, n);*L     XtAddCallback(ok_widget, DwtNactivateCallback, set_limit, limit_widget);       XtManageChild(ok_widget);S      XtManageChild(limit_widget);#     XtManageChild(limitbox_widget);t }v  P /*******************************************************************************  *9  * Generic menu widget (Used for high/low ball selection)T  *P  ******************************************************************************/  % static void menu_select(w, tag, data) 	 Widget w;  DwtAnyCallbackStruct *data;c {n,     XtUnmanageChild(menubox_widget[system]);     menu_selection = tag;i     pool_table();e }D   void select_menu(strings)a char *strings[]; {      XEvent event;      Arg arglist[10];     static Widget menu_widget;!     static Widget item_widget[2];t     int items;
     int x, y;l
     int n;       get_window(system, &x, &y);e     x += 700; y += 642;t     x = min(max(x,0),878);     y = min(max(y,0),766);  )     if (menubox_widget[system] != NULL) {r& 	for (items = 0; items < 2; items++) {F 	    XtSetArg(arglist[0], DwtNlabel, DwtLatin1String(strings[items]));1 	    XtSetValues(item_widget[items], arglist, 1);t 	}, 	XtMoveWidget(menubox_widget[system], x, y);' 	XtManageChild(menubox_widget[system]);	 	return;     }A  
     n = 0;8     XtSetArg(arglist[n], DwtNunits, DwtFontUnits);		n++;?     XtSetArg(arglist[n], DwtNresize, DwtResizeShrinkWrap);	n++; 4     XtSetArg(arglist[n], DwtNborderWidth, 0);			n++;5     XtSetArg(arglist[n], DwtNmarginWidth, 10);			n++;g6     XtSetArg(arglist[n], DwtNmarginHeight, 10);			n++;5     XtSetArg(arglist[n], DwtNstyle, DwtModal);			n++;	+     XtSetArg(arglist[n], DwtNx, x);				n++;	+     XtSetArg(arglist[n], DwtNy, y);				n++;]`     menubox_widget[system] = DwtDialogBoxPopupCreate(window_widget[system], header, arglist, n);  
     n = 0;+     XtSetArg(arglist[n], DwtNx, 4);				n++; +     XtSetArg(arglist[n], DwtNy, 4);				n++; D     XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Select"));	n++;R     menu_widget = DwtOptionMenuCreate(menubox_widget[system], "Menu", arglist, n);  )     for (items = 0; items < 2; items++) {  	n = 0;d5 	XtSetArg(arglist[n], DwtNbordHighlight, TRUE);		n++;)S 	item_widget[items] = DwtPushButtonCreate(menu_widget, strings[items], arglist, n);iO 	XtAddCallback(item_widget[items], DwtNactivateCallback, menu_select, items+1);a     }n)     XtManageChildren(item_widget, items);t     XtManageChild(menu_widget); *     XtManageChild(menubox_widget[system]);,     XtRealizeWidget(menubox_widget[system]); }  MP /*******************************************************************************  *&  * Get velocity and spin for each shot  *P  ******************************************************************************/   static void draw_spinball(s) { F     XClearWindow(XtDisplay(spin_widget[s]), XtWindow(spin_widget[s]));I     XDrawArc(XtDisplay(spin_widget[s]), XtWindow(spin_widget[s]), dgc[s],i 	35, 35, 110, 110, 0, 360*64);O     XFillRectangle(XtDisplay(spin_widget[s]), XtWindow(spin_widget[s]), dgc[s],L 	40+spin-5, 140-roll-1, 11, 3);gO     XFillRectangle(XtDisplay(spin_widget[s]), XtWindow(spin_widget[s]), dgc[s],n 	40+spin-1, 140-roll-5, 3, 11);; }   ) static void expose_spinball(w, tag, data) 	 Widget w;g DwtWindowCallbackStruct *data; { 
     int s;  #     for (s=0; s<num_screens; s++) {_5 	if (XtDisplay(w) == XtDisplay(toplevel_widget[s])) {e 	    draw_spinball(s); 	    break;b 	}     }_ },  # static void new_spin(w, tag, event)_	 Widget w;  XEvent *event; {n
     int s;     int xdist, ydist;w  !     for (s=0; s<num_screens; s++)a5 	if (XtDisplay(w) == XtDisplay(toplevel_widget[s])) {), 	    if (event->xbutton.button == Button1) {  		xdist = event->xbutton.x - 90;  		ydist = event->xbutton.y - 90;& 		if (xdist*xdist+ydist*ydist<50*50) { 		    spin = xdist + 50; 		    roll = 50 - ydist; 		    draw_spinball(s);* 		}* 	    } 	    break;t 	} }   ) static void velocity_select(w, tag, data);	 Widget w;l DwtAnyCallbackStruct *data;r {r     Arg arglist[1];e
     int s;       /*H      * If we are lagging for break, and we running in local network modeK      * and this is the remote screen, then use the variable remote_velocity       * instead of velocity.i      */l-     if (num_screens > 1 && !action_started &&;6 	XtDisplay(w) == XtDisplay(toplevel_widget[REMOTE])) {3 	XtSetArg(arglist[0], DwtNvalue, &remote_velocity);  	s = REMOTE;     } else {, 	XtSetArg(arglist[0], DwtNvalue, &velocity); 	s = system;     }e0     XtGetValues(velocity_widget[s], arglist, 1);+     XtUnmanageChild(velocitybox_widget[s]);i     if (--num_velocities == 0) 	pool_table(); }a   void get_velocity(remote)5 {	     XEvent event;g     Arg arglist[10];     Widget label_widget[3];e     Widget ok_widget;f
     int x, y;R
     int n, s;   #     s = (remote ? REMOTE : system);t     num_velocities++;L       get_window(s, &x, &y);     x += 800; y += 250;g     x = min(max(x,0),802);     y = min(max(y,0),515);  (     if (velocitybox_widget[s] != NULL) {% 	XtSetArg(arglist[0], DwtNvalue, 50); - 	XtSetValues(velocity_widget[s], arglist, 1);  	spin = 50; roll = 50;+ 	XtMoveWidget(velocitybox_widget[s], x, y);t& 	XtManageChild(velocitybox_widget[s]); 	return;     }l  
     n = 0;8     XtSetArg(arglist[n], DwtNunits, DwtFontUnits);		n++;?     XtSetArg(arglist[n], DwtNresize, DwtResizeShrinkWrap);	n++;l4     XtSetArg(arglist[n], DwtNborderWidth, 0);			n++;5     XtSetArg(arglist[n], DwtNmarginWidth, 10);			n++;D6     XtSetArg(arglist[n], DwtNmarginHeight, 10);			n++;7     XtSetArg(arglist[n], DwtNstyle, DwtModeless);		n++; +     XtSetArg(arglist[n], DwtNx, x);				n++;r+     XtSetArg(arglist[n], DwtNy, y);				n++;DZ     velocitybox_widget[s] = DwtDialogBoxPopupCreate(window_widget[s], header, arglist, n);  
     n = 0;/     XtSetArg(arglist[n], DwtNvalue, 50);			n++;;#     XtSetArg(arglist[n], DwtNtitle,g5 	DwtLatin1String("               Velocity %"));		n++;3+     XtSetArg(arglist[n], DwtNx, 6);				n++;0,     XtSetArg(arglist[n], DwtNy, 12);				n++;0     XtSetArg(arglist[n], DwtNwidth, 175);			n++;W     velocity_widget[s] = DwtScaleCreate(velocitybox_widget[s], "Velocity", arglist, n);k  
     n = 0;@     XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("0%"));	n++;+     XtSetArg(arglist[n], DwtNx, 6);				n++; +     XtSetArg(arglist[n], DwtNy, 2);				n++;*R     label_widget[0] = DwtLabelCreate(velocitybox_widget[s], "Label1", arglist, n);  
     n = 0;B     XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("100%"));	n++;,     XtSetArg(arglist[n], DwtNx, 80);				n++;+     XtSetArg(arglist[n], DwtNy, 2);				n++;	R     label_widget[1] = DwtLabelCreate(velocitybox_widget[s], "Label2", arglist, n);       spin = 50; roll = 50;n
     n = 0;0     XtSetArg(arglist[n], DwtNwidth, 180);			n++;1     XtSetArg(arglist[n], DwtNheight, 180);			n++;i+     XtSetArg(arglist[n], DwtNx, 9);				n++;b,     XtSetArg(arglist[n], DwtNy, 60);				n++;P     spin_widget[s] = DwtWindowCreate(velocitybox_widget[s], "Spin", arglist, n);J     XtAddCallback(spin_widget[s], DwtNexposeCallback, expose_spinball, 0);N     XtAddEventHandler(spin_widget[s], ButtonPressMask, FALSE, new_spin, NULL);  
     n = 0;K     XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Contact Point")); n++;i,     XtSetArg(arglist[n], DwtNx, 31);				n++;-     XtSetArg(arglist[n], DwtNy, 180);				n++;tR     label_widget[2] = DwtLabelCreate(velocitybox_widget[s], "Label3", arglist, n);  
     n = 0;8     XtSetArg(arglist[n], DwtNbordHighlight, TRUE);		n++;,     XtSetArg(arglist[n], DwtNx, 43);				n++;-     XtSetArg(arglist[n], DwtNy, 200);				n++;aM     ok_widget = DwtPushButtonCreate(velocitybox_widget[s], "Ok", arglist, n);DG     XtAddCallback(ok_widget, DwtNactivateCallback, velocity_select, 0);t       XtManageChild(ok_widget);e&     XtManageChildren(label_widget, 3);&     XtManageChild(velocity_widget[s]);"     XtManageChild(spin_widget[s]);  )     XtManageChild(velocitybox_widget[s]);  }   P /*******************************************************************************  *  * Help Routines  *P  ******************************************************************************/  & static void provide_help(w, tag, data)	 Widget w;b DwtAnyCallbackStruct *data;l {c
     int s;  !     for (s=0; s<num_screens; s++)(5 	if (XtDisplay(w) == XtDisplay(toplevel_widget[s])) {a 	    switch (tag) {d 		case 0:					/* about... */ 		    display_about(s);* 		    break;! 		case 1:					/* more about... */G 		    display_help(s); 		    break; 	    } 	    break;  	} }*  # static void hide_help(w, tag, data)*	 Widget w;* DwtAnyCallbackStruct *data;c {i
     int s;  !     for (s=0; s<num_screens; s++)a5 	if (XtDisplay(w) == XtDisplay(toplevel_widget[s])) {i( 	    if (XtIsManaged(helpbox_widget[s]))% 		XtUnmanageChild(helpbox_widget[s]);_ 	    break;a 	} }*   void display_about(s)t {e     Arg arglist[10];     XFontStruct *about_font;
     int n;  G #define ABFONT   "-Adobe-New Century Schoolbook-Bold-R-Normal--*-140-*"   %     if (aboutbox_widget[s] == NULL) { D 	about_font = XLoadQueryFont(XtDisplay(toplevel_widget[s]), ABFONT);= 	abfont[s] = DwtCreateFontList(about_font, CDA$K_ISO_LATIN1);  	n = 0;s6 	XtSetArg(arglist[n], DwtNdefaultPosition, TRUE);	n++;D 	XtSetArg(arglist[n], DwtNlabel, DwtLatin1String(ABOUT_XPOOL)); n++;1 	XtSetArg(arglist[n], DwtNfont, abfont[s]);		n++;sT 	aboutbox_widget[s] = DwtMessageBoxCreate(dialogbox_widget[s], "About", arglist, n);     }t&     XtManageChild(aboutbox_widget[s]); };   void display_help(s) {t     Arg arglist[20];     Widget helptext_widget;t     Widget ok_widget;b     XFontStruct *mono_font;t
     int n;  : #define MONOFONT "-Adobe-Courier-Medium-R-Normal--*-140-*"  $     if (helpbox_widget[s] != NULL) {% 	if (!XtIsManaged(helpbox_widget[s]))	& 	    XtManageChild(helpbox_widget[s]); 	return;     }   H     mono_font = XLoadQueryFont(XtDisplay(toplevel_widget[s]), MONOFONT);?     mnfont[s] = DwtCreateFontList(mono_font, CDA$K_ISO_LATIN1);   
     n = 0;?     XtSetArg(arglist[n], DwtNresize, DwtResizeShrinkWrap);	n++;n4     XtSetArg(arglist[n], DwtNborderWidth, 0);			n++;:     XtSetArg(arglist[n], DwtNdefaultPosition, TRUE);		n++;>     XtSetArg(arglist[n], DwtNdefaultHorizontalOffset, 3);	n++;=     XtSetArg(arglist[n], DwtNdefaultVerticalOffset, 3);		n++;r`     helpbox_widget[s] = DwtAttachedDBPopupCreate(dialogbox_widget[s], "More About", arglist, n);  
     n = 0;B     XtSetArg(arglist[n], DwtNadbTopAttachment, DwtAttachAdb);	n++;B     XtSetArg(arglist[n], DwtNadbLeftAttachment,DwtAttachAdb);	n++;/     XtSetArg(arglist[n], DwtNrows, 25);				n++;)/     XtSetArg(arglist[n], DwtNcols, 72);				n++; 3     XtSetArg(arglist[n], DwtNborderWidth,1);			n++;*6     XtSetArg(arglist[n], DwtNhalfBorder,FALSE);			n++;@     XtSetArg(arglist[n], DwtNinsertionPointVisible, FALSE);	n++;7     XtSetArg(arglist[n], DwtNresizeWidth, FALSE);		n++;*5     XtSetArg(arglist[n], DwtNeditable, FALSE);			n++;l9     XtSetArg(arglist[n], DwtNscrollVertical, TRUE);		n++;d5     XtSetArg(arglist[n], DwtNfont, mnfont[s]);			n++;t6     XtSetArg(arglist[n], DwtNvalue, xpool_help);		n++;Q     helptext_widget = DwtSTextCreate(helpbox_widget[s], "Help Text", arglist, n);t  
     n = 0;E     XtSetArg(arglist[n], DwtNadbTopAttachment, DwtAttachWidget); n++;iA     XtSetArg(arglist[n], DwtNadbTopWidget, helptext_widget);	n++;5C     XtSetArg(arglist[n], DwtNadbLeftAttachment, DwtAttachAdb);	n++;w3     XtSetArg(arglist[n], DwtNshadow, FALSE);			n++; S     ok_widget = DwtPushButtonCreate(helpbox_widget[s], "Acknowledged", arglist, n);sA     XtAddCallback(ok_widget, DwtNactivateCallback, hide_help, 0);t  #     XtManageChild(helptext_widget);t     XtManageChild(ok_widget);n%     XtManageChild(helpbox_widget[s]);  }0 <P /*******************************************************************************  *#  * Main parameter selection routine	  *P  ******************************************************************************/   void select_play() {      enable_select_options();'     XtAppMainLoop(application_context);  }*  P /*******************************************************************************  *#  * Graphics window handling widgets   *P  ******************************************************************************/  % static void set_control(w, tag, data)i	 Widget w;m DwtAnyCallbackStruct *data;a { A     if (tag == 0 && (opponent == NETWORK || opponent == AUTONET))u 	get_node();
     else {" 	if (tag > 0 && num_screens > 1 &&8 	    XtDisplay(w) == XtDisplay(toplevel_widget[REMOTE])) 	    abort_flag = ABORT_REMOTE;R 	else  	    switch (tag) {r	 		case 0:] 		    enable_game_options(); 		    break;	 		case 1:e 		    abort_flag = ABORT_GAME; 		    break;	 		case 2:h! 		    abort_flag = ABORT_PROGRAM;f 		    break; 	    } 	pool_table();     }  }o  ' static void select_option(w, tag, data)e	 Widget w;r$ DwtTogglebuttonCallbackStruct *data; {]
     int s;  !     for (s=0; s<num_screens; s++)n5 	if (XtDisplay(w) == XtDisplay(toplevel_widget[s])) {u 	    switch (tag) {  		case PRESET_VELOCITY: ' 		    preset_velocity[s] = data->value;( 		    break; 		case CONFIRM_SHOTS:;% 		    confirm_shots[s] = data->value;L 		    break;0 		case COMPUTER_SKILL:		/* get computer skill */ 		    get_skill(); 		    break;5 		case STRAIGHT_LIMIT:		/* get straight pool limit */, 		    get_limit(); 		    break; 		case RESPOT_BALL:r1 		    respot_ball = TRUE;		/* ask about respot */D 		    position = OVER_RESPOT;  		    pool_table();n 		    break; 	    } 	    break;; 	} }   ) static void select_opponent(w, tag, data)		 Widget w; $ DwtTogglebuttonCallbackStruct *data; {;     if (data->value) 	opponent = tag; }i  % static void select_game(w, tag, data)t	 Widget w;y$ DwtTogglebuttonCallbackStruct *data; {g     if (data->value) 	game = tag; }A   static void window_menubar(s)D {      Arg arglist[10];     Widget menubar_widget;     Widget control_widget;     Widget controlmenu_widget;     Widget gmenu_widget;#     Widget gitem_widget[num_games];t     Widget omenu_widget;"     Widget oitem_widget[num_opps];     Widget option_widget;g     Widget optionmenu_widget;      Widget help_widget;t     Widget helpmenu_widget;g&     Widget helpitem_widget[num_helps];     int control_items;     int game_items;y     int opp_items;     int help_items; 
     int n;  
     n = 0;I     XtSetArg(arglist[n], DwtNorientation, DwtOrientationHorizontal); n++;n4     XtSetArg(arglist[n], DwtNborderWidth, 2);			n++;1     XtSetArg(arglist[n], DwtNspacing, 15);			n++;eC     XtSetArg(arglist[n], DwtNadbLeftAttachment, DwtAttachAdb);	n++;e6     XtSetArg(arglist[n], DwtNadbLeftOffset, 0);			n++;D     XtSetArg(arglist[n], DwtNadbRightAttachment, DwtAttachAdb);	n++;6     XtSetArg(arglist[n], DwtNadbRightOffset, 0);		n++;S     menubar_widget = DwtMenuBarCreate(dialogbox_widget[s], "Menu Bar", arglist, n);   !     /* Control Menu Bar option */t  
     n = 0;     controlmenu_widget =K 	(Widget)DwtMenuPulldownCreate(menubar_widget, "Control Menu", arglist, n);b  H     for (control_items=0; control_items<num_controls; control_items++) { 	n = 0;v' 	controlitem_widget[s][control_items] =;) 		DwtPushButtonCreate(controlmenu_widget,o- 		control_string[control_items], arglist, n);t4 	XtAddCallback(controlitem_widget[s][control_items],4 		DwtNactivateCallback, set_control, control_items);     }   
     n = 0;A     XtSetArg(arglist[n], DwtNsubMenuId, controlmenu_widget);	n++;	     control_widget =C 	DwtPullDownMenuEntryCreate(menubar_widget, "Control", arglist, n);v       /* Game Menu Bar option */  
     n = 0;5     XtSetArg(arglist[n], DwtNmenuRadio, TRUE);			n++;      gmenu_widget =H 	(Widget)DwtMenuPulldownCreate(menubar_widget, "Game Menu", arglist, n);  @     for (game_items = 0; game_items < num_games; game_items++) { 	n = 0;,= 	XtSetArg(arglist[n], DwtNvalue, (game_items == game-1));n++;c 	gitem_widget[game_items] = A 	    DwtToggleButtonCreate(gmenu_widget, game_string[game_items],; 	    arglist, n);(B 	XtAddCallback(gitem_widget[game_items], DwtNvalueChangedCallback,  	    select_game, game_items+1);     }   
     n = 0;<     XtSetArg(arglist[n], DwtNsubMenuId, gmenu_widget);		n++;     game_widget[s] =@ 	DwtPullDownMenuEntryCreate(menubar_widget, "Game", arglist, n);  "     /* Opponent Menu Bar option */  
     n = 0;5     XtSetArg(arglist[n], DwtNmenuRadio, TRUE);			n++;a     omenu_widget =L 	(Widget)DwtMenuPulldownCreate(menubar_widget, "Opponent Menu", arglist, n);  <     for (opp_items = 0; opp_items < num_opps; opp_items++) { 	n = 0; @ 	XtSetArg(arglist[n], DwtNvalue, (opp_items == opponent-1));n++; 	oitem_widget[opp_items] =D 	    DwtToggleButtonCreate(omenu_widget, opponent_string[opp_items], 	    arglist, n);tA 	XtAddCallback(oitem_widget[opp_items], DwtNvalueChangedCallback, # 	    select_opponent, opp_items+1);w     }D  
     n = 0;<     XtSetArg(arglist[n], DwtNsubMenuId, omenu_widget);		n++;     opponent_widget[s] =D 	DwtPullDownMenuEntryCreate(menubar_widget, "Opponent", arglist, n);        /* Option Menu Bar option */  
     n = 0;     optionmenu_widget = J 	(Widget)DwtMenuPulldownCreate(menubar_widget, "Option Menu", arglist, n);  
     n = 0;=     XtSetArg(arglist[n], DwtNvalue, preset_velocity[s]);	n++;t+     optionitem_widget[s][PRESET_VELOCITY] =t* 		DwtToggleButtonCreate(optionmenu_widget,. 		option_string[PRESET_VELOCITY], arglist, n);8     XtAddCallback(optionitem_widget[s][PRESET_VELOCITY],< 		DwtNvalueChangedCallback, select_option, PRESET_VELOCITY);  
     n = 0;<     XtSetArg(arglist[n], DwtNvalue, confirm_shots[s]);		n++;)     optionitem_widget[s][CONFIRM_SHOTS] =l* 		DwtToggleButtonCreate(optionmenu_widget,, 		option_string[CONFIRM_SHOTS], arglist, n);6     XtAddCallback(optionitem_widget[s][CONFIRM_SHOTS],: 		DwtNvalueChangedCallback, select_option, CONFIRM_SHOTS);  
     n = 0;Q     optionitem_widget[s][COMPUTER_SKILL] = DwtPushButtonCreate(optionmenu_widget,i- 		option_string[COMPUTER_SKILL], arglist, n);]7     XtAddCallback(optionitem_widget[s][COMPUTER_SKILL],D7 		DwtNactivateCallback, select_option, COMPUTER_SKILL);w  
     n = 0;Q     optionitem_widget[s][STRAIGHT_LIMIT] = DwtPushButtonCreate(optionmenu_widget,,- 		option_string[STRAIGHT_LIMIT], arglist, n);i7     XtAddCallback(optionitem_widget[s][STRAIGHT_LIMIT],n7 		DwtNactivateCallback, select_option, STRAIGHT_LIMIT);t  
     n = 0;N     optionitem_widget[s][RESPOT_BALL] = DwtPushButtonCreate(optionmenu_widget,* 		option_string[RESPOT_BALL], arglist, n);4     XtAddCallback(optionitem_widget[s][RESPOT_BALL],4 		DwtNactivateCallback, select_option, RESPOT_BALL);  
     n = 0;@     XtSetArg(arglist[n], DwtNsubMenuId, optionmenu_widget);	n++;     option_widget =)C 	DwtPullDownMenuEntryCreate(menubar_widget, "Options", arglist, n);g       /* Help Menu Bar option */  
     n = 0;     helpmenu_widget =eH 	(Widget)DwtMenuPulldownCreate(menubar_widget, "Help Menu", arglist, n);  <     for (help_items=0; help_items<num_helps; help_items++) { 	n = 0;t 	helpitem_widget[help_items] =& 		DwtPushButtonCreate(helpmenu_widget,' 		help_string[help_items], arglist, n);t+ 	XtAddCallback(helpitem_widget[help_items],	2 		DwtNactivateCallback, provide_help, help_items);     }+  
     n = 0;>     XtSetArg(arglist[n], DwtNsubMenuId, helpmenu_widget);	n++;     help_widget =h@ 	DwtPullDownMenuEntryCreate(menubar_widget, "Help", arglist, n);  :     XtSetArg(arglist[0], DwtNmenuHelpWidget, help_widget);,     XtSetValues(menubar_widget, arglist, 1);       enable_game_options();  ;     XtManageChildren(controlitem_widget[s], control_items);w"     XtManageChild(control_widget);/     XtManageChildren(gitem_widget, game_items);C"     XtManageChild(game_widget[s]);.     XtManageChildren(oitem_widget, opp_items);&     XtManageChild(opponent_widget[s]);8     XtManageChildren(optionitem_widget[s], num_options);!     XtManageChild(option_widget);p2     XtManageChildren(helpitem_widget, help_items);     XtManageChild(help_widget);*"     XtManageChild(menubar_widget); }e  3 void open_window(s, width, height, display, window)* Display **display; Window *window;* {*>     Pixmap icon_pix;		/* pixmap to hold the icon definition */E     Pixmap bigicon_pix;		/* pixmap to hold the BIG icon definition */*     XGCValues gcv;     Arg arglist[10];
     int n;  
     n = 0;9     XtSetArg(arglist[n], DwtNunits, DwtPixelUnits);		n++;*?     XtSetArg(arglist[n], DwtNresize, DwtResizeShrinkWrap);	n++; 4     XtSetArg(arglist[n], DwtNborderWidth, 0);			n++;V     dialogbox_widget[s] = DwtAttachedDBCreate(toplevel_widget[s], header, arglist, n);       window_menubar(s);  
     n = 0;2     XtSetArg(arglist[n], DwtNwidth, width);			n++;4     XtSetArg(arglist[n], DwtNheight, height);			n++;R     window_widget[s] = DwtWindowCreate(dialogbox_widget[s], "Window", arglist, n);M     XtAddCallback(window_widget[s], DwtNexposeCallback, handle_exposures, 0); R     XtAddEventHandler(window_widget[s], ButtonPressMask, FALSE, got_button, NULL);  $     XtMoveWidget(toplevel_widget[s], 	(x_offset[s] == NOVALUE ?: 		(XWidthOfScreen(XtScreen(toplevel_widget[s]))-width)/2 : 		x_offset[s]),_ 	(y_offset[s] == NOVALUE ?< 		(XHeightOfScreen(XtScreen(toplevel_widget[s]))-height)/2 : 		y_offset[s]));  $     XtManageChild(window_widget[s]);'     XtManageChild(dialogbox_widget[s]);M(     XtRealizeWidget(toplevel_widget[s]);  +     icon_pix = XCreatePixmapFromBitmapData(*! 		XtDisplay(dialogbox_widget[s]),k  		XtWindow(dialogbox_widget[s]), 		xpool_icon_bits, 		xpool_icon_width,, 		xpool_icon_height, 		1, 0, 1);   .     bigicon_pix = XCreatePixmapFromBitmapData(! 		XtDisplay(dialogbox_widget[s]),i  		XtWindow(dialogbox_widget[s]), 		xpool_bigicon_bits,  		xpool_bigicon_width, 		xpool_bigicon_height,o 		1, 0, 1);g  
     n = 0;2     XtSetArg(arglist[n], XtNnoResize, TRUE);		n++;;     XtSetArg (arglist[n], XtNiconPixmap, bigicon_pix);	n++;t;     XtSetArg (arglist[n], XtNiconifyPixmap, icon_pix);	n++;c0     XtSetValues(toplevel_widget[s], arglist, n);  
     n = 0;?     XtSetArg(arglist[n], DwtNforeground, &gcv.foreground);	n++;b?     XtSetArg(arglist[n], DwtNbackground, &gcv.background);	n++;d1     XtGetValues(dialogbox_widget[s], arglist, n);d6     dgc[s] = XCreateGC(XtDisplay(dialogbox_widget[s]),C 	XtWindow(dialogbox_widget[s]), GCForeground | GCBackground, &gcv);m  )     *window = XtWindow(window_widget[s]);i+     *display = XtDisplay(window_widget[s]);i }t