N /*****************************************************************************  *  * FACILITY:  *   XPool	DECwindows Pool game   *	   * ABSTRACT:F  *   This module contains the routines which perform the pool ball and>  *   user interaction.  It also contains the main entry point.  *
  * AUTHOR:  *   Doug Stefanelli  *   * CREATION DATE: 1-October-1989  *  * Edit History   *)  *  DS	1-Oct-1989	(v1.0) Original version D  *  DS	4-Dec-1989	(v2.0) Modified to run from XtMainLoop().  Created  *			pool_table().H  *  DS	2-Jan-1990	(v2.1) Improve computer play.  Fix cue ball bank shots6  *			and improve shot evaluation and scratch checking.G  *  DS	13-Mar-1990	(v3.0) Support 2 displays.  Add Ultrix support.  Add 2  *			game - rotation.  Fix rules - 8-ball on break7  *			is win, leave last ball on table in straight pool. F  *  DS	11-Apr-1990	(v3.1) Misc. bug fixes.  Make computer skill levels:  *			more consistent.  Enforce hitting selected ball first  *			in 8-ball. H  *  DS	10-May-1990	(v4.0) Widen table, reduce ball overlap, fix momentum3  *			transfer at collisions, make friction and spin +  *			more realistic, tighten the ball rack.   */    /*  * Routines in this module  */ 6 int gtime();			/* return time in seconds since 1970 */* void pool_table();		/* main state table */K static int shooting_8ball();	/* returns true if the 8 ball is the target */ J static int rightmost_target();	/* returns rightmost legal ball on table */D void number_balls();		/* number all balls on the table except cue */D void unnumber_balls();		/* remove numbers from balls on the table */5 void draw_numbered_ball();	/* draw a numbered ball */ ? void replace_ball();		/* move a ball to a specified position */ 6 void spot_ball();		/* respot an illegally sunk ball */6 void spot_cue();		/* let the user spot the cue ball */I static void get_game_string();	/* return a string identifying the game */ K static void display_call();	/* display the target ball and target pocket */ M static float determine_shot();	/* determine the best shot for the computer */ > static int blocked();		/* returns true if a shot is blocked */A static int scratch();		/* returns true if a shot might scratch */ ? static void delay();		/* preprocess routine to handle delays */ O static void start_remote_read();/* preprocess routine to handle remote reads */ Q static void start_remote_write();/* preprocess routine to handle remote writes */ M static void wait_for_opponent();/* preprocess routine to wait for opponent */    /*  * Include files  */  #include <stdio.h> #include <math.h>  #include "xpool.h"
 #ifdef ultrix  #include <sys/time.h>  #endif  5 #define time_between_frames 40		/* in milliseconds */  /*  * Math macros  */ " #define absolute(x) (float)fabs(x) #define square(x) ((x)*(x)) ( #define min(x,y) ((x) < (y) ? (x) : (y))( #define max(x,y) ((x) > (y) ? (x) : (y))* #define sqroot(x) (float)sqrt((double)(x))+ #define alog10(x) (float)log10((double)(x)) 9 #define random_number ((float)rand()/(float)(0x7fffffff)) 0 #define magnitude(x,y) sqroot((x)*(x) + (y)*(y))K #define distance(x1,y1,x2,y2) sqroot(square((x2)-(x1)) + square((y2)-(y1))) ? #define distance2(x1,y1,x2,y2,x3,y3) (distance(x1,y1,x2,y2) + \   				      distance(x2,y2,x3,y3))L #define distance3(x1,y1,x2,y2,x3,y3,x4,y4) (distance2(x1,y1,x2,y2,x3,y3) + \ 					    distance(x3,y3,x4,y4)) > #define overlap(index) (square(pointer_x - (int)px[index]) + \) 			square(pointer_y - (int)py[index]) < \  			square(diameter))  B #define shooting_low_balls (selection_made && (im_high ^ my_turn))D #define shooting_high_balls (selection_made && (!im_high ^ my_turn)). #define cushion_friction .8		/* v3.1 was .9 *// #define contact_friction .75		/* v3.1 was .9 */ / #define felt_friction .986		/* v3.1 was .985 */ 2 #define high_felt_friction .94		/* v3.1 was .94 */ #define backoff_t .05  #define velocity_scale .55 #define max_skill (100./800.)  /*  * Local variables  */ - #define y_center ((top_edge + bottom_edge)/2) ( #define cue_x (break_point - 3*diameter)# #define cue_y (y_center - diameter) * #define pxinit_offset 24	/* v3.1 was 25 */* #define pyinit_offset 15	/* v3.1 was 19 */I static int pxinit0[]  = {0, 0, 1, 2, 3, 3, 4, 4, 2, 1, 2, 3, 3, 4, 4, 4}; I static int pyinit0[]  = {0, 0, 1, 0, 3, 1, 3, 1, 1, 0, 2, 2, 0, 4, 2, 0}; I static int pxinit15[] = {0, 0, 4, 4, 1, 4, 3, 3, 4, 1, 2, 4, 2, 3, 3, 2}; I static int pyinit15[] = {0, 0, 0, 4, 0, 1, 3, 0, 3, 1, 0, 2, 2, 1, 2, 1}; 7 static int pxinit9[]  = {0, 0, 1, 1, 2, 2, 3, 3, 4, 2}; 7 static int pyinit9[]  = {0, 0, 1, 0, 2, 0, 2, 1, 2, 1};   2 static float pxinit[max_balls], pyinit[max_balls];2 static float psavex[max_balls], psavey[max_balls];2 static float vsavex[max_balls], vsavey[max_balls]; static float tsave[max_balls]; static float skill;  static float spin_factor;  static float roll_x, roll_y;  static float pocket[3], dist[3];$ static float pocketx[6], pockety[6]; static float buffer[20];   static int stop_count; static int ball_selected;  static int ball_hit_first;! static int first_ball, first_pos;  static int number_sunk; " static int sunken_ball[max_balls];$ static int sunken_pocket[max_balls]; static int nbuffer[20];  static int lock_size;  static int status; static int ball_index; static int ball_count; static int buffer_index;   static char *lock_buffer;   # static unsigned char after_scratch;   static unsigned char respot_cue; static unsigned char confirmed; ! static unsigned char any_contact; " static unsigned char far_wall_hit;  static unsigned char first_shot;" static unsigned char last_shot[2];! static unsigned char hit_wall[2]; ! static unsigned char humans_turn; $ static unsigned char computers_turn;! static unsigned char remote_turn; - static unsigned char selected_ball_hit_first;    static char nodename[80];  static char username[80];  /*#  * Valid states within pool_table()   */  static int state;  static int next_state;   #define GAME_INIT			1  #define CHALLENGE_RESPONSE		2  #define NET_INIT			3 #define GAME_SELECT			4  #define GAME_SETUP			5 #define LAG_FOR_BREAK_SETUP		6 #define LAG_FOR_BREAK			7  #define GOT_LAG_VELOCITY		8  #define DO_LAG				9  #define LAG_WINNER			10  #define START_PLAY			11  #define BALLS_STOPPED			12 #define OPPONENTS_TURN			13  #define CHECK_RESPOT			14  #define HILO_SELECT			15 #define HILO_DISPLAY			16  #define HILO_RESPONSE			17 #define HILO_SET			18  #define GET_INPUT			19 #define COMPUTER_SPOT_CUE		20 # #define COMPUTER_DETERMINE_SHOT		21   #define COMPUTER_REPORT_SHOT		22! #define COMPUTER_CONFIRM_SHOT		23 $ #define COMPUTER_WAIT_BEFORE_SHOT	24 #define READ_POSITION			25 #define POSITION_READ			26 #define DISPLAY_CALL			27  #define READ_VELOCITY			28 #define VELOCITY_READ			29 #define CONFIRM_VELOCITY		30 #define PLACE_BALL			31  #define GET_CUE_POSITION		32 #define REPORT_POSITION			33 #define CALL_SHOT			34 #define GET_TARGET_BALL			35 #define GET_TARGET_POCKET		36  #define WAIT_BEFORE_SHOT		37 #define SET_DIRECTION			38 #define GOT_POSITION			39  #define DO_RESPOT			40 #define CHECK_RESPOT_BALL		41   #define CHECK_RESPOT_OVERLAP		42 #define SET_VELOCITY			43  #define GOT_VELOCITY			44  #define CONFIRM_SHOT			45  #define CONFIRM_RESPONSE		46 #define FRAME_SETUP			47 #define MOVE_BALLS			48  #define DELAY_OVER			49  #define CHECK_NET_READ			50  #define CHECK_LOCK_READ			51 #define CHECK_LOCK_WRITE		52 #define WAIT_FOR_OPPONENT		53  #define GAME_LOST			54 #define GAME_OVER			55 #define BAD_NODE			56  #define LOST_NET			57  #define LOST_LOCK			58 #define END_GAME			59  #define RESTART_GAME			60  #define SYNC_POSITIONS			61  #define SEND_POSITIONS			62  #define RECEIVE_POSITIONS		63  #define POSITION_RECEIVED		64  #define GAME_DISPLAY			65  #define GET_NAME			66  #define SEND_NAME			67 #define READ_NAME			68 #define NAME_READ			69   /*  * Global variables   */ # float px[max_balls], py[max_balls]; # float vx[max_balls], vy[max_balls];  int system;  int leftx, rightx; int num_balls; int wins, losses;  int my_score, his_score; int straight_limit;  int target_ball, target_pocket;  int balls_on_table; " unsigned char on_table[max_balls];# unsigned char off_table[max_balls];* unsigned char net_game;  unsigned char lock_game; unsigned char alternating; unsigned char im_computer; unsigned char ur_computer; unsigned char im_remote; unsigned char remote_process;  unsigned char action_started;  unsigned char balls_numbered;u unsigned char intro_displayed; unsigned char my_turn; unsigned char im_high; unsigned char selection_made;  char *player_name[2];1 #define MAX_NAME_LENGTH 12 char my_name[MAX_NAME_LENGTH]; char his_name[MAX_NAME_LENGTH];	   /*  * External variables   */c extern int num_screens;a extern int game; extern int opponent; extern int network_type; extern int computer_skill; extern int limit;r extern int menu_selection; extern int velocity; extern int roll; extern int spin; extern int remote_velocity;l' extern unsigned char preset_velocity[];i% extern unsigned char confirm_shots[];m extern unsigned char sound[];g  extern unsigned char abort_flag;( extern unsigned char challenge_accepted; extern char node[];p extern int position;  extern int pointer_x, pointer_y;   /*.  * Wide area network routines (in XPOOL_NET.C)  */  extern int get_local_user(); extern int get_remote_user();/ extern void net_open_remote(); extern void net_open_local();m extern void net_read();c extern int net_read_complete();  extern int net_write();  extern void net_close(); /*)  * Cluster lock routines (in XPOOL_ENQ.C)l  */a extern int grab_lock();( extern int lock_grabbed(); extern int lock_read();o extern int lock_write(); extern void lock_close();  /*"  * Xlib routines (in XPOOL_XLIB.C)  */r! extern void init_pool_graphics();e extern void draw_table();  extern void draw_ball(); extern void erase_ball();t extern void number_ball(); extern void add_to_ballrack(); extern void redraw_ballrack(); extern void save_text();! extern void draw_centered_text();e" extern void draw_centered_text2(); extern void draw_remote_text();e  extern void draw_remote_text2();! extern void clear_message_area();o  extern void clear_remote_area(); extern void display_score(); /*&  * X toolkit routines (in XPOOL_DWT.C)  */  extern int init_screen();t extern void remove_menus();a$ extern void destroy_remote_screen(); extern void enable_button(); extern void disable_button();t extern void accept_challenge();t extern void select_menu(); extern void get_velocity();a  extern void set_frame_timeout();  extern void set_delay_timeout();# extern void cancel_delay_timeout(); # extern void cancel_frame_timeout();<   int gtime()u {<
 #ifdef VMS     return(time());d #elsei     struct timeval tp;     struct timezone tzp;       gettimeofday(&tp, &tzp);     return(tp.tv_sec); #endif }    main(argv,argc)x
 char *argv[];)	 int argc;q {e char string[80];
 char *ptr;  7     srand(gtime());	/* initialize random # generator */x       /* define player names */t4     if (!(player_name[0] = getenv("XPOOL$PLAYER1"))) 	player_name[0] = "PLAYER 1";e4     if (!(player_name[1] = getenv("XPOOL$PLAYER2"))) 	player_name[1] = "PLAYER 2";y&     if (!(ptr = getenv("XPOOL$ME"))) { 	ptr = getenv("SYS$NODE");
 	if (!ptr) 	    strcpy(my_name, "ME");y 	else {( 	    strncpy(my_name, ptr, 12); : 	    my_name[min(strlen(ptr)-2,MAX_NAME_LENGTH-1)] = '\0'; 	}     } else { 	strcpy(my_name, ptr);# 	my_name[MAX_NAME_LENGTH-1] = '\0';      }   !     /* define pocket positions */n     pocket[0] = left_edge;+     pocket[1] = (right_edge + left_edge)/2;i     pocket[2] = right_edge;l  $     pocketx[0] = pocket[0] + radius;     pocketx[1] = pocket[1];g$     pocketx[2] = pocket[2] - radius;$     pocketx[3] = pocket[0] + radius;     pocketx[4] = pocket[1]; $     pocketx[5] = pocket[2] - radius;#     pockety[0] = top_edge - radius;.#     pockety[1] = top_edge - radius;c#     pockety[2] = top_edge - radius; &     pockety[3] = bottom_edge + radius;&     pockety[4] = bottom_edge + radius;&     pockety[5] = bottom_edge + radius;  G     /* define acceptable distances from pockets for balls to fall in */      dist[0] = diameter;      dist[1] = 1.25*radius;     dist[2] = diameter;/  4     im_remote = get_remote_user(nodename, username);       if (!init_screen(0)) {0 	printf("Unable to access target display...\n");	 	exit(1);0     } .     if (!im_remote) init_pool_graphics(LOCAL);       action_started = FALSE;1     balls_numbered = FALSE;3       if (!im_remote) {1 	num_balls = 0;, 	intro_displayed = TRUE; 	state = GAME_INIT;i 	select_play();0     } else { 	intro_displayed = FALSE;t 	my_turn = FALSE;, 	system = LOCAL; 	net_game = TRUE;f 	net_open_local();F 	sprintf(string, "You are being challenged by %s::%s, Do you accept?", 		nodename, username); 	state = NET_INIT;! 	accept_challenge(LOCAL, string);b     }  }t   o void pool_table()f {t int i,j; int bytes_read;t unsigned char bad; unsigned char last_turn; int respot_count;p int locount, hicount; ( float ax, ay, bx, by, b_size_2, a_dot_b;2 float vx1, vy1, vx2, vy2, vxtrans, vytrans, vsize; float dpx, dpy, dpx1, dpy1;t float x1, y1, x2, y2;t float a, b, c, d, t; float scale; char string[80];. static char *hilo_strings[] = {"High", "Low"};5 static char *confirm_strings[] = {"Proceed", "Redo"};s       if (abort_flag)_ 	state = END_GAME;  ,     for (;;) {			/* main state table loop */       switch (state) { 	case GAME_INIT: 	    if (intro_displayed) {g 		clear_message_area();t 		intro_displayed = FALSE; 	    } 	    draw_table(); 	    straight_limit = limit;= 	    net_game = (opponent == NETWORK || opponent == AUTONET);e( 	    lock_game = (opponent == AUTOLOCK);  	    remote_process = lock_game; 	    system = LOCAL; 	    if (net_game) { 		my_turn = TRUE;u 		state = CHALLENGE_RESPONSE;t 		if (network_type == LOCAL) {' 		    sprintf(string, "%s::0.0", node); ! 		    if (!init_screen(string)) {V 			state = BAD_NODE;	 			break;  		    }t) 		    get_local_user(nodename, username);d 		    sprintf(string,d8 			"You are being challenged by %s::%s, Do you accept?", 			nodename, username);n' 		    accept_challenge(REMOTE, string);E
 		} else { 		    remote_process = TRUE; 		    net_open_remote(node);0 		    start_remote_read(&challenge_accepted, 1); 		}_	 		return;  	    } else if (lock_game) { 		im_remote = 0; 		switch (grab_lock()) {	 		case 0:  		    my_turn = 1;4 		    draw_centered_text("WAITING FOR AN OPPONENT");  		    state = WAIT_FOR_OPPONENT; 		    delay(1);	
 		    return;P	 		case 1:U 		    my_turn = 0; 		    im_remote = 1; 		    state = GAME_SELECT;% 		    start_remote_read(nbuffer, 12);	
 		    return;O	 		case 2:_- 		    draw_centered_text("GAME IN PROGRESS");f 		    state = END_GAME;d 		    delay(6);L
 		    return; 
 		default: 		    state = LOST_LOCK; 		    break; 		}O
 	    } else {	) 		my_turn = (random_number < .5 ? 1 : 0);U 		state = GAME_SETUP;  	    } 	    break;    	case CHALLENGE_RESPONSE:n 	    if (!challenge_accepted) {E7 		draw_centered_text("THE CHALLENGE WAS NOT ACCEPTED");n 		state = END_GAME;  		delay(6);O	 		return;  	    } 	    if (num_screens > 1) {C 		init_pool_graphics(REMOTE);C 		state = GAME_DISPLAY;f
 	    } else {Y 		state = SEND_NAME; 		nbuffer[0] = game; 		nbuffer[1] = straight_limit; 		nbuffer[2] = opponent;" 		start_remote_write(nbuffer, 12); 	    } 	    break;_   	case NET_INIT: 2 	    if (net_write(&challenge_accepted, 1) <= 0) {A 		if (challenge_accepted) printf("Network connection lost...\n");n
 		exit(1); 	    }& 	    if (!challenge_accepted) exit(1); 	    init_pool_graphics(); 	    num_balls = 0;	 	    state = GAME_SELECT; $ 	    start_remote_read(nbuffer, 12); 	    return;   	case GAME_SELECT: 	    game = nbuffer[0];E! 	    straight_limit = nbuffer[1];N 	    opponent = nbuffer[2];D 	    state = GET_NAME;L 	    start_remote_read(his_name, MAX_NAME_LENGTH);	/* other player's name */ 	    return;   	case GET_NAME: ( 	    his_name[MAX_NAME_LENGTH-1] = '\0'; 	    player_name[0] = his_name;a 	    player_name[1] = my_name; 	    state = GAME_DISPLAY;2 	    start_remote_write(my_name, MAX_NAME_LENGTH); 	    break;    	case SEND_NAME: 	    state = READ_NAME;n2 	    start_remote_write(my_name, MAX_NAME_LENGTH); 	    break;a   	case READ_NAME: 	    state = NAME_READ;n2 	    start_remote_read(his_name, MAX_NAME_LENGTH); 	    return;   	case NAME_READ:( 	    his_name[MAX_NAME_LENGTH-1] = '\0'; 	    player_name[0] = my_name; 	    player_name[1] = his_name;d 	    state = GAME_DISPLAY; 	    break;n   	case GAME_DISPLAY:; 	    get_game_string(string);n  	    draw_centered_text(string); 	    if (num_screens > 1)r 		draw_remote_text(string);L 	    state = GAME_SETUP; 	    delay(5); 	    return;   	case GAME_SETUP:  	    alternating = FALSE;  	    im_computer = FALSE;s 	    ur_computer = FALSE;n 	    skill = 0.0;e   	    switch (opponent) { 		case COMPUTER:' 		    im_computer = alternating = TRUE;e; 		    skill = (float)(100-computer_skill)*(max_skill/100.);s. 		    if (game != STRAIGHT_POOL) skill *= .75; 		    break; 		case SELF: 		case AUTONET:  		case AUTOLOCK: 		    ur_computer = TRUE;s 		    im_computer = TRUE;h 		    break; 	    }   	    if (game == NINE_BALL)e 		num_balls = 10;e	 	    elsen 		num_balls = 16;e  . 	    wins = 0; losses = 0;		/* no score yet */9 	    my_score = 0; his_score = 0;	/* no balls sunk yet */l   	    if (opponent == NETWORK)s 		state = LAG_FOR_BREAK_SETUP;	 	    elsee 		state = START_PLAY;) 	    break;i   	case LAG_FOR_BREAK_SETUP:  	    for (i=0; i<num_balls; i++) 		on_table[i] = FALSE;+ 	    px[0] = px[8] = left_edge + 5.*radius;n5 	    py[0] = bottom_edge + (top_edge-bottom_edge)/3.;i8 	    py[8] = bottom_edge + 2.*(top_edge-bottom_edge)/3.;& 	    on_table[0] = on_table[8] = TRUE; 	    draw_table();  ) 	    draw_centered_text2("LAG FOR BREAK",p 				"YOU ARE WHITE");n   	    if (num_screens > 1)v$ 		draw_remote_text2("LAG FOR BREAK", 				  "YOU ARE BLACK");r   	    state = LAG_FOR_BREAK;l 	    delay(5); 	    return;   	case LAG_FOR_BREAK: 	    vy[0] = 0.; 	    vy[8] = 0.;  3 	    draw_centered_text("SET VELOCITY WITH MOUSE");n 	    get_velocity(0);) 	    if (num_screens > 1) {e5 	        draw_remote_text("SET VELOCITY WITH MOUSE");  	        get_velocity(1);n 	    } 	    state = GOT_LAG_VELOCITY; 	    return;   	case GOT_LAG_VELOCITY:i 	    hit_wall[0] = FALSE;v 	    hit_wall[1] = FALSE;n 	    state = DO_LAG;   	    clear_message_area();, 	    scale = (float)velocity*velocity_scale;B 	    vx[0] = scale + 3 - 6*random_number;	/* randomize a little */ 	    vx[0] = max(0,vx[0]); 	    if (num_screens > 1) {e 		clear_remote_area();0 		scale = (float)remote_velocity*velocity_scale;? 		vx[8] = scale + 3 - 6*random_number;	/* randomize a little */  		vx[8] = max(0,vx[8]);i
 	    } else {m2 		if (net_write(&vx[0], 4) <= 0) state = LOST_NET; 		start_remote_read(&vx[8], 4);s 	    } 	    break;a  
 	case DO_LAG:h& 	    if (vx[0] == 0. && vx[8] == 0.) { 		state = LAG_WINNER;  		delay(3);(	 		return;i
 	    } else {g) 		set_frame_timeout(time_between_frames);* 		for (i=0; i<9; i+=8) { 		    if (vx[i] != 0.) { 			erase_ball(px[i],py[i]);E 			px[i] += vx[i];# 			if (px[i] > right_edge-radius) {)! 			    px[i] = right_edge-radius; " 			    vx[i] *= -cushion_friction; 			    hit_wall[i/8] = TRUE;) 			} else if (px[i] < left_edge+radius) {   			    px[i] = left_edge+radius;" 			    vx[i] *= -cushion_friction; 			} 			if (absolute(vx[i]) < 4.)  			    if (absolute(vx[i]) < .5) 				vx[i] = 0.;X 			    else1  				vx[i] *= high_felt_friction; 			elsep 			    vx[i] *= felt_friction; 			draw_ball(i); 		    }r 		}e	 		return;e 	    }  1 	case LAG_WINNER:	/* determine who won the lag */c9 	    if (px[0] < px[8] && (hit_wall[0] ^ !hit_wall[1]) ||[  		(hit_wall[0] && !hit_wall[1])) 		my_turn = TRUE;+> 	    else if (px[0] > px[8] && (hit_wall[0] ^ !hit_wall[1]) ||  		(!hit_wall[0] && hit_wall[1])) 		my_turn = FALSE;> 	    if (num_screens > 1) system = (my_turn ? LOCAL : REMOTE); 	    state = START_PLAY; 	    break;+   	case START_PLAY:[  * 	    /* Setup ball positions and speeds */  B 	    balls_on_table = num_balls;	/* set count of balls on table */1 	    first_shot = TRUE;		/* no shots taken yet */ C 	    last_shot[0] = FALSE;	/* neither player shooting the 8-ball */t 	    last_shot[1] = FALSE;< 	    leftx = left_edge;		/* leftmost position in ballrack */> 	    rightx = right_edge;	/* rightmost position in ballrack */0 	    target_ball = -1;		/* no target ball yet */C 	    first_pos = right_edge;	/* assume 1st contact at right wall */ B 	    respot_cue = after_scratch = FALSE; /* not after a scratch */. 	    humans_turn = (my_turn && !im_computer ||2 			  !my_turn && !ur_computer && !remote_process);C 	    remote_turn = (!my_turn && remote_process || num_screens > 1);n0 	    computers_turn = (my_turn && im_computer ||6 			     !my_turn && (ur_computer && !remote_process));  " 	    for (i=0; i<num_balls; i++) { 		on_table[i] = TRUE;  		off_table[i] = FALSE;n 		if (i == 0) {   		    px[i] = pxinit[i] = cue_x;  		    py[i] = pyinit[i] = cue_y;! 		} else if (game == NINE_BALL) {_I 		    px[i] = pxinit[i] = (float)(spot_point + pxinit_offset*pxinit9[i]); X 		    py[i] = pyinit[i] = (float)(y_center + (2*pyinit9[i] - pxinit9[i])*pyinit_offset);  		} else if (game == ROTATION) {J 		    px[i] = pxinit[i] = (float)(spot_point + pxinit_offset*pxinit15[i]);Z 		    py[i] = pyinit[i] = (float)(y_center + (2*pyinit15[i] - pxinit15[i])*pyinit_offset);
 		} else {I 		    px[i] = pxinit[i] = (float)(spot_point + pxinit_offset*pxinit0[i]);aX 		    py[i] = pyinit[i] = (float)(y_center + pyinit_offset*(2*pyinit0[i] - pxinit0[i])); 		} & 		vx[i] = 0.;		/* all balls stopped */
 		vy[i] = 0.;) 	    }  ? 	    selection_made = FALSE;	/* no selection made for 8-ball */mB 	    action_started = TRUE;	/* action started (redraw ballrack) */B 	    balls_numbered = TRUE;	/* when handling exposures, # balls */ 	    draw_table(); 	    display_score();    	    if (remote_turn)  		if (num_screens > 1)* 		    draw_remote_text("OPPONENT'S TURN"); 		else, 		    draw_centered_text("OPPONENT'S TURN");  8 	    stop_count = 0;		/* set no balls stopped for now */ 	    state = GET_INPUT;c 	    break;e   #define MAX_POSITIONS 5e   	case SYNC_POSITIONS:= 	    if (remote_process) { 		ball_index = -1; 		if (my_turn) { 		    buffer_index = 0;_ 		    state = SEND_POSITIONS;o
 		} else { 		    ball_count = 0;t@ 		    for (i=0; i<num_balls; i++) if (on_table[i]) ball_count++;  		    state = RECEIVE_POSITIONS; 		}  	    } else  		state = BALLS_STOPPED; 	    break;	   	case SEND_POSITIONS: % 	    if (++ball_index == num_balls) {; 		state = BALLS_STOPPED; 		if (buffer_index > 0) {(1 		    start_remote_write(buffer, buffer_index*4);r 		    buffer_index = 0;  		}E' 	    } else if (on_table[ball_index]) {e* 		buffer[buffer_index++] = px[ball_index];* 		buffer[buffer_index++] = py[ball_index];( 		if (buffer_index == MAX_POSITIONS*2) {1 		    start_remote_write(buffer, buffer_index*4);b 		    buffer_index = 0;_ 		}N 	    } 	    break;e   	case RECEIVE_POSITIONS: 	    if (ball_count <= 0) {  		for (i=0; i<num_balls; i++)_F 		    if (on_table[i] && (psavex[i] != px[i] || psavey[i] != py[i])) {# 			erase_ball(psavex[i],psavey[i]);t 			draw_ball(i); 		    }e 		state = BALLS_STOPPED;
 	    } else {] 		state = POSITION_RECEIVED;> 		start_remote_read(buffer, 8*min(MAX_POSITIONS, ball_count));	 		return;  	    } 	    break;    	case POSITION_RECEIVED: 	    i = 0;l4 	    while(ball_count > 0  && i < MAX_POSITIONS*2) { 		if (on_table[++ball_index]) {.# 		    px[ball_index] = buffer[i++];!# 		    py[ball_index] = buffer[i++];i 		    ball_count--;  		}m 	    } 	    state = RECEIVE_POSITIONS;  	    break;m   	case BALLS_STOPPED: 	    if (game == EIGHT_BALL) 		selected_ball_hit_first =E, 			!selection_made && ball_hit_first != 8 ||/ 			last_shot[my_turn] && ball_hit_first == 8 ||  			shooting_low_balls &&2 			(ball_hit_first >= 1 && ball_hit_first <= 7) || 			shooting_high_balls && 1 			(ball_hit_first >= 9 && ball_hit_first <= 15);a 	    /*0H 	     * Check criteria for end of game.  If 8-ball and the 8 ball is offD 	     * the table, or 9-ball and the 9 ball is off the table after a, 	     * legal shot, or the table is cleared. 	     *// 	    if (game == EIGHT_BALL && (!on_table[8] ||k( 		last_shot[my_turn] && !on_table[0]) ||& 		game == NINE_BALL && !on_table[9] &&0 		first_ball == ball_hit_first && on_table[0]) { 		bad = FALSE; 		if (game == EIGHT_BALL) {  		    if (!on_table[0])n 			bad = TRUE; 		    else if (!first_shot) {a  			if (!selected_ball_hit_first) 			    bad = TRUE; 			else if (last_shot[my_turn])n& 			    for (i=0; i<number_sunk; i++) {( 				if (sunken_ball[i] == target_ball &&6 				    sunken_pocket[i] != target_pocket) bad = TRUE; 			    } 			else if (!shooting_8ball()) 			    bad = TRUE; 		    }o 		}r 		if (my_turn ^ bad) {
 		    wins++;  		    my_turn = TRUE; * 		    if (num_screens > 1) system = LOCAL;
 		} else { 		    losses++;  		    my_turn = FALSE;+ 		    if (num_screens > 1) system = REMOTE;s 		} 
 		if (bad) 		    state = GAME_LOST; 		else 		    state = GAME_OVER; 		break; 	    }  & 	    /* Another shot has been taken */   	    first_shot = FALSE; 	    respot_cue = FALSE; 	    number_balls();< 	    for (i=0; i<num_balls; i++)	/* reset velocities to 0 */ 		vx[i] = vy[i] = 0.;  	    /*nD 	     * Check for player change and for sunken balls that need to be 	     * respottedp 	     */ 	    last_turn = my_turn;_ 	    if (!on_table[0] ||; 		game != NINE_BALL && game != ROTATION && after_scratch &&E+ 		first_pos < break_point && !far_wall_hit)t 		my_turn = !my_turn;p# 	    else if (game == EIGHT_BALL) {n 		if (!selected_ball_hit_first)_ 		    my_turn = !my_turn;  		else if (selection_made) {# 		    for (i=0; i<number_sunk; i++)[ 			if (shooting_high_balls) {d% 			    if (sunken_ball[i] > 8) break;2 			} else {A% 			    if (sunken_ball[i] < 8) break;  			}/ 		    if (i == number_sunk) my_turn = !my_turn;, 		} else if (number_sunk == 0) 		    my_turn = !my_turn; 8 	    } else if (game == NINE_BALL || game == ROTATION) {7 		if (number_sunk == 0 || first_ball != ball_hit_first)( 		    my_turn = !my_turn;n( 	    } else if (game == STRAIGHT_POOL) {. 		if (number_sunk == 0 || target_ball != -1) {% 		    for (i=0; i<number_sunk; i++) {c' 			if (sunken_ball[i] == target_ball &&L0 			    sunken_pocket[i] == target_pocket) break; 		    }w/ 		    if (i == number_sunk) my_turn = !my_turn;  		}e 	    }   	    state = CHECK_RESPOT;  	    if (last_turn != my_turn) {; 		if (num_screens > 1) system = (my_turn ? LOCAL : REMOTE);r+ 		humans_turn = (my_turn && !im_computer ||]6 			      !my_turn && !ur_computer && !remote_process);@ 		remote_turn = (!my_turn && remote_process || num_screens > 1);- 		computers_turn = (my_turn && im_computer ||*3 				 !my_turn && (ur_computer && !remote_process));e 		if (remote_turn) 		    state = OPPONENTS_TURN;_ 		display_score();& 		draw_centered_text("PLAYER CHANGE"); 		if (num_screens > 1)( 		    draw_remote_text("PLAYER CHANGE"); 		delay(1);)	 		return;n 	    } 	    break;	   	case OPPONENTS_TURN:t 	    if (num_screens > 1) & 		draw_remote_text("OPPONENT'S TURN");	 	    elsel( 		draw_centered_text("OPPONENT'S TURN"); 	    state = CHECK_RESPOT; 	    break;p   	case CHECK_RESPOT:s  E 	    /* Check to see if any balls need to be put back on the table */}  / 	    if (game == EIGHT_BALL && (!on_table[0] ||]> 		after_scratch && first_pos < break_point && !far_wall_hit || 		!selected_ball_hit_first)) { 		if (!selection_made) {# 		    for (i=0; i<number_sunk; i++)  			spot_ball(sunken_ball[i]);;! 		} else if (im_high ^ my_turn) {i 		    respot_count = 0; # 		    for (i=0; i<number_sunk; i++)  			if (sunken_ball[i] > 8) {! 			    spot_ball(sunken_ball[i]);] 			    respot_count++; 			}, 		    if (respot_count == 0 && !on_table[0]) 			for (i=9; i<num_balls; i++) 			    if (!on_table[i]) { 				spot_ball(i);[
 				break; 			    }
 		} else { 		    respot_count = 0;;# 		    for (i=0; i<number_sunk; i++)(3 			if (sunken_ball[i] < 8 && sunken_ball[i] != 0) { ! 			    spot_ball(sunken_ball[i]);  			    respot_count++; 			}, 		    if (respot_count == 0 && !on_table[0]) 			for (i=1; i<8; i++) 			    if (!on_table[i]) { 				spot_ball(i);s
 				break; 			    } 		}s7 	   } else if (game == NINE_BALL || game == ROTATION) {*3 		if (!on_table[0] || first_ball != ball_hit_first)e# 		    for (i=0; i<number_sunk; i++)/ 			spot_ball(sunken_ball[i]);r 		else if (game == ROTATION) { 		    if (my_turn) {  			for (i=0; i<number_sunk; i++)" 			    my_score += sunken_ball[i]; 			if (my_score >= 61) { 			    wins++; 			    state = GAME_OVER;;
 			    break;  			} 		    } else {  			for (i=0; i<number_sunk; i++)# 			    his_score += sunken_ball[i];! 			if (his_score >= 61) {t 			    losses++; 			    state = GAME_OVER;c
 			    break;  			} 		    }r 		    display_score();  		    if (balls_on_table == 1) { 			my_score = his_score = 0;, 			draw_centered_text("THE GAME IS A DRAW"); 			if (num_screens > 1)l. 			    draw_remote_text("THE GAME IS A DRAW"); 			state = START_PLAY; 			delay(5);
 			return; 		    }l 		} ' 	   } else if (game == STRAIGHT_POOL) {n
 		bad = TRUE;( 		if (target_ball > 0)% 		    for (i=0; i<number_sunk; i++) {i' 			if (sunken_ball[i] == target_ball &&i6 			    sunken_pocket[i] == target_pocket) bad = FALSE; 		    }  		else if (number_sunk > 0)p 		    bad = FALSE; 		if (!on_table[0]) bad = TRUE; 
 		if (bad)# 		    for (i=0; i<number_sunk; i++)x 			spot_ball(sunken_ball[i]);  		else if (my_turn) {x 		    my_score += number_sunk;' 		    if (my_score >= straight_limit) { 
 			wins++; 			state = GAME_OVER;i	 			break;* 		    }]
 		} else { 		    his_score += number_sunk; ( 		    if (his_score >= straight_limit) { 			losses++; 			state = GAME_OVER;s	 			break;d 		    }a 		}m+ 		if (balls_on_table <= 2 && on_table[0]) {e 		    int last_ball = -1; C 		    balls_on_table = num_balls;	/* set count of balls on table */d= 		    leftx = left_edge;		/* leftmost position in ballrack */ ? 		    rightx = right_edge;	/* rightmost position in ballrack */;# 		    for (i=1; i<num_balls; i++) {P 			int index = i;  			if (on_table[i]) {* 			    last_ball = i;o 			    if (i == 1) continue; 			    index = 1;  			} 			on_table[index] = TRUE; 			off_table[index] = FALSE; 			px[index] = pxinit[i];d 			py[index] = pyinit[i];  		    }f! 		    for (i=1; i<num_balls; i++)P6 			if (square(pxinit[i]-px[0])+square(pyinit[i]-py[0]) 			    < square(diameter)) { 			    respot_cue = TRUE;  			    px[0] = pxinit[0];I 			    py[0] = pyinit[0];	
 			    break;T 			} 		    if (last_ball > 0) { 			for (i=1; i<num_balls; i++)+ 			    if (square(pxinit[i]-px[last_ball])+;# 				square(pyinit[i]-py[last_ball])t 				< square(diameter)) {f 				px[last_ball] = pxinit[1]; 				py[last_ball] = pyinit[1];
 				break; 			    } 		    }f 		    draw_table();p 		}l 		display_score(); 	    }  , 	    /* high/low selection for eight ball */  1 	    if (game == EIGHT_BALL && !selection_made &&b# 		on_table[0] && number_sunk > 0 &&=@ 		(!after_scratch || first_pos > break_point || far_wall_hit)) { 		state = HILO_SELECT; 	    } else  		state = GET_INPUT; 	    break;b   	case HILO_SELECT: 	    im_high = FALSE;p 	    if (humans_turn) {s1 		draw_centered_text("SELECT HIGH OR LOW BALLS");	 		select_menu(hilo_strings); 		state = HILO_RESPONSE;	 		return;;
 	    } else {e 		state = HILO_DISPLAY;O 		selection_made = TRUE; 		if (computers_turn) {e 		    hicount = locount = 0;$ 		    for (i=0; i< number_sunk; i++)5 			if (sunken_ball[i] < 8) locount++; else hicount++;_ 		    if (hicount > locount ||, 			hicount == locount && random_number < .5) 			im_high = TRUE; 		    if (remote_process) {  			nbuffer[0] = !im_high; " 			start_remote_write(nbuffer, 1); 		    }i 		    break; 		} else {	/* remote_turn */% 		    start_remote_read(&im_high, 1);t
 		    return;  		}s 	    }   	case HILO_DISPLAY:s\ 	    strcpy(string, (im_computer && ur_computer && !my_turn ? "MY OPPONENT WILL" : "I'LL"));D 	    strcat(string, (shooting_high_balls ? " BE HIGH" : " BE LOW"));  	    draw_centered_text(string); 	    if (num_screens > 1) {aX 		strcpy(string, (im_computer && ur_computer && my_turn ? "MY OPPONENT WILL" : "I'LL"));A 		strcat(string, (shooting_high_balls ? " BE HIGH" : " BE LOW"));i 		draw_remote_text(string);_ 	    } 	    state = HILO_SET; 	    delay(3); 	    return;   	case HILO_RESPONSE:: 	    if ((menu_selection == 1) ^ !my_turn) im_high = TRUE; 	    selection_made = TRUE;  	    state = HILO_SET; 	    if (num_screens > 1)T( 		draw_remote_text(shooting_high_balls ? 				 "I'LL BE HIGH" :i 				 "I'LL BE LOW"); 	    if (remote_process) { 		nbuffer[0] = !im_high;! 		start_remote_write(nbuffer, 1);k 	    } 	    break;b   	case HILO_SET:k 	    display_score();p 	    if (remote_turn)  		if (num_screens > 1)* 		    draw_remote_text("OPPONENT'S TURN"); 		else, 		    draw_centered_text("OPPONENT'S TURN"); 	    state = GET_INPUT;( 	    break;   ( 	case GET_INPUT:		/* select next shot */" 	    after_scratch = !on_table[0];0 	    respot_cue = respot_cue || after_scratch ||- 			(game == NINE_BALL || game == ROTATION) &&   			first_ball != ball_hit_first;C 	    first_pos = right_edge;	/* assume 1st contact at right wall */S   	    /* get lowest ball */  	    for (i=1; i<num_balls; i++)+ 		if (on_table[i]) {first_ball = i; break;}   ' 	    /* are we shooting the 8-ball ? */  	    if (game == EIGHT_BALL)( 		last_shot[my_turn] = shooting_8ball();   	    if (respot_cue) { 		if (game == STRAIGHT_POOL) {" 		    j = rightmost_target(1, 15); 		    if (px[j] < break_point) 			spot_ball(j); 		}  /*2 		else if (game == EIGHT_BALL && selection_made) { 		    if (last_shot[my_turn])A	 			j = 8;f! 		    else if (my_turn ^ im_high)  			j = rightmost_target(1, 7);
 		    else 			j = rightmost_target(9, 15);s 		    if (px[j] < break_point) 			spot_ball(j); 		}s */ 	    }   	    if (humans_turn)  		state = PLACE_BALL;a 	    else if (computers_turn)  		state = COMPUTER_SPOT_CUE;	 	    else, 		state = READ_POSITION; 	    break;    	case COMPUTER_SPOT_CUE:% 	    state = COMPUTER_DETERMINE_SHOT;R" 	    if (respot_cue || first_shot)
 		spot_cue();  	    if (remote_process) { 		buffer[0] = px[0]; 		buffer[1] = py[0];  		start_remote_write(buffer, 8); 	    } 	    break;=   	case COMPUTER_DETERMINE_SHOT: 	    determine_shot();@ 	    display_call(my_turn || num_screens == 1 ? LOCAL : REMOTE);" 	    state = COMPUTER_REPORT_SHOT;0 	    if (game == STRAIGHT_POOL && !first_shot ||- 		game == EIGHT_BALL && last_shot[my_turn]) {_ 		if (remote_process) {(2 		    nbuffer[0] = target_ball;	/* calling shot */! 		    nbuffer[1] = target_pocket;_% 		    start_remote_write(nbuffer, 8);c 		} else if (num_screens > 1)	- 		    display_call(my_turn ? REMOTE : LOCAL);m 	    } 	    break;p   	case COMPUTER_REPORT_SHOT:p# 	    state = COMPUTER_CONFIRM_SHOT;e 	    if (remote_process) { 		buffer[0] = vx[0]; 		buffer[1] = vy[0]; 		buffer[2] = roll_x;; 		buffer[3] = roll_y;" 		buffer[4] = spin_factor;! 		start_remote_write(buffer, 20);t 	    }
 	   break;   	case COMPUTER_CONFIRM_SHOT:' 	    state = COMPUTER_WAIT_BEFORE_SHOT;  	    if (remote_process) { 		nbuffer[0] = TRUE;! 		start_remote_write(nbuffer, 1);w 	    } 	    break;E    	case COMPUTER_WAIT_BEFORE_SHOT: 	    state = FRAME_SETUP;  	    if (net_game) { 		delay(2);s	 		return;a 	    } 	    break;c   	case READ_POSITION: 	    state = POSITION_READ;(" 	    start_remote_read(buffer, 8); 	    return;   	case POSITION_READ: 	    x1 = buffer[0]; 	    y1 = buffer[1]; 	    replace_ball(x1, y1, 0); 0 	    if (game == STRAIGHT_POOL && !first_shot ||- 		game == EIGHT_BALL && last_shot[my_turn]) {	 		state = DISPLAY_CALL;	  		start_remote_read(nbuffer, 8);	 		return;n
 	    } else {) 		state = READ_VELOCITY; 		break; 	    }   	case DISPLAY_CALL:} 	    target_ball = nbuffer[0];  	    target_pocket = nbuffer[1]; 	    display_call(LOCAL);n 	    state = READ_VELOCITY;) 	    break;;   	case READ_VELOCITY: 	    state = VELOCITY_READ; # 	    start_remote_read(buffer, 20);i 	    return;   	case VELOCITY_READ: 	    vx[0] = buffer[0];a 	    vy[0] = buffer[1];  	    roll_x = buffer[2]; 	    roll_y = buffer[3]; 	    spin_factor = buffer[4];; 	    state = CONFIRM_VELOCITY;& 	    start_remote_read(&confirmed, 1); 	    return;   	case CONFIRM_VELOCITY:N 	    if (confirmed)A 		state = FRAME_SETUP;	 	    elses 		state = READ_VELOCITY; 	    break;i   	case PLACE_BALL:+& 	    if (!respot_cue && !first_shot) { 		state = REPORT_POSITION; 		break;
 	    } else {f< 	        draw_centered_text2("POSITION CUE BALL WITH MOUSE"," 				    "THEN PRESS LEFT BUTTON");6 		enable_button(first_shot || game == STRAIGHT_POOL ||% 			game == EIGHT_BALL ? HEAD : FELT);e 		state = GET_CUE_POSITION;e	 		return;b 	    }   	case GET_CUE_POSITION:t" 	    for (i=1; i<num_balls; i++) {" 		if (on_table[i] && overlap(i)) {; 		    draw_centered_text2("POSITION OVERLAPS ANOTHER BALL",) 					"TRY AGAIN");
 		    return;	 		}_ 	    }9 	    replace_ball((float)pointer_x, (float)pointer_y, 0);  	    clear_message_area(); 	    state = REPORT_POSITION;T 	    break;l   	case REPORT_POSITION: 	    state = CALL_SHOT;g 	    if (remote_process) { 		buffer[0] = px[0]; 		buffer[1] = py[0];  		start_remote_write(buffer, 8); 	    } 	    break;    	case CALL_SHOT:4 	    if (game == EIGHT_BALL && last_shot[my_turn]) { 		pointer_x = (int)px[8];e 		pointer_y = (int)py[8];A 		state = GET_TARGET_BALL; 		break;6 	    } else if (game != STRAIGHT_POOL || first_shot) { 		position = 0;a 		state = SET_DIRECTION; 		break;
 	    } else { 4 		draw_centered_text2("CALL TARGET BALL WITH MOUSE"," 				    "THEN PRESS LEFT BUTTON"); 		enable_button(FELT); 		state = GET_TARGET_BALL;	 		return;u 	    }   	case GET_TARGET_BALL:  	    for (i=1; i<num_balls; i++)" 		if (on_table[i] && overlap(i)) { 		    target_ball = i;: 		    draw_centered_text2("CALL TARGET POCKET WITH MOUSE", 					"THEN PRESS LEFT BUTTON");	 		    enable_button(TABLE);e  		    state = GET_TARGET_POCKET;
 		    return;i 		}  	    return;   	case GET_TARGET_POCKET: 	    target_pocket = -1; 	    for (i=0; i<3; i++) {E 		if (square(pointer_x-(int)pocket[i]) + square(pointer_y-top_edge) <  		    square(2*diameter)) {i 		    target_pocket = i; 		    break;O 		} else if (square(pointer_x-(int)pocket[i]) + square(pointer_y-bottom_edge) <i 		    square(2*diameter)) {[ 		    target_pocket = 3+i; 		    break; 		}+ 	    } 	    if (target_pocket != -1) {( 		state = WAIT_BEFORE_SHOT;u 		disable_button();  		display_call(LOCAL); 		if (num_screens > 1) 		    display_call(REMOTE);	 		if (remote_process) {	 		    nbuffer[0] = target_ball;(! 		    nbuffer[1] = target_pocket;s% 		    start_remote_write(nbuffer, 8);q 		}p 		break; 	    } 	    return;   	case WAIT_BEFORE_SHOT:x 	    position = 0;E 	    enable_button(im_computer || net_game ? TABLE : TABLE | RESPOT);	 	    state = SET_DIRECTION;i  	    delay(remote_turn ? 5 : 2); 	    return;   	case SET_DIRECTION: 	    if (position != 0) {L 		state = GOT_POSITION;  		break; 	    }1 	    draw_centered_text2("SET TARGET WITH MOUSE",> 				"THEN PRESS LEFT BUTTON");E 	    enable_button(im_computer || net_game ? TABLE : TABLE | RESPOT);k 	    state = GOT_POSITION; 	    return;   	case GOT_POSITION:_ 	    clear_message_area();! 	    if (position == OVER_RESPOT)	 		state = DO_RESPOT; 	    else {  		disable_button();e# 		vx[0] = (float)pointer_x - px[0];O# 		vy[0] = (float)pointer_y - py[0];  		state = SET_VELOCITY;  	    } 	    break;n   	case DO_RESPOT:/ 	    draw_centered_text2("SELECT BALL TO SPOT",  				"THEN PRESS LEFT BUTTON");$ 	    enable_button(FELT | BALLRACK); 	    state = CHECK_RESPOT_BALL;< 	    return;           case CHECK_RESPOT_BALL:s" 	    for (i=0; i<num_balls; i++) { 		if (overlap(i)) {b& 		    if (position == OVER_BALLRACK) { 			spot_ball(i); 			display_score();e 			position = 0; 			state = SET_DIRECTION;s	 			break;  		    } else {2 			draw_centered_text2("POSITION BALL WITH MOUSE",# 					    "THEN PRESS LEFT BUTTON");" 			enable_button(FELT);i 			ball_selected = i;s  			state = CHECK_RESPOT_OVERLAP;
 			return; 		    }t 		}; 	    } 	    return;   	case CHECK_RESPOT_OVERLAP:c  	    for (i=0; i<num_balls; i++)8 		if (on_table[i] && i != ball_selected && overlap(i)) {; 		    draw_centered_text2("POSITION OVERLAPS ANOTHER BALL",t 					"TRY AGAIN");
 		    return;L 		    } E 	    replace_ball((float)pointer_x, (float)pointer_y, ball_selected);c 	    position = 0; 	    state = SET_DIRECTION;c 	    break;R   	case SET_VELOCITY:_# 	    if (preset_velocity[system]) {r 		roll = 50; 		spin = 50;% 		velocity = (first_shot ? 100 : 50);" 		state = GOT_VELOCITY;r 		break;
 	    } else {e. 		draw_centered_text2("SET VELOCITY AND SPIN", 				    "WITH MOUSE"); 		get_velocity(0); 		state = GOT_VELOCITY;p	 		return;r 	    }   	case GOT_VELOCITY:  	    clear_message_area();$ 	    vsize = magnitude(vx[0],vy[0]); 	    if (vsize == 0.)E 		vsize = vx[0] = vy[0] = 1.;I0 	    roll_x = vx[0]*(float)(roll-50)/(40*vsize);0 	    roll_y = vy[0]*(float)(roll-50)/(40*vsize); 	    if (roll > 0) {# 		roll_x *= (first_shot ? .1 : .5);e# 		roll_y *= (first_shot ? .1 : .5);  	    }5 	    spin_factor = (float)(velocity*(50-spin))/2000.;;, 	    scale = (float)velocity*velocity_scale; 	    vx[0] *= scale/vsize; 	    vy[0] *= scale/vsize;   	    state = CONFIRM_SHOT; 	    if (remote_process) { 		buffer[0] = vx[0]; 		buffer[1] = vy[0]; 		buffer[2] = roll_x;	 		buffer[3] = roll_y;o 		buffer[4] = spin_factor;! 		start_remote_write(buffer, 20);T 	    } 	    break;i   	case CONFIRM_SHOT: ! 	    if (confirm_shots[system]) {s 		draw_arrow(); % 		draw_centered_text("CONFIRM SHOT");s 		select_menu(confirm_strings);s 		state = CONFIRM_RESPONSE;		 		return; 
 	    } else {i 		state = FRAME_SETUP; 		if (remote_process) {  		    nbuffer[0] = TRUE;% 		    start_remote_write(nbuffer, 1);  		}o 		break; 	    }   	case CONFIRM_RESPONSE:n 	    clear_message_area(); 	    erase_arrow();o 	    if (menu_selection == 2) {R 		position = 0;e 		state = SET_DIRECTION; 	    } elsee 		state = FRAME_SETUP;   	    if (remote_process) {% 		nbuffer[0] = (menu_selection == 1); ! 		start_remote_write(nbuffer, 1);  	    } 	    break;{   	case FRAME_SETUP:/ 	    any_contact = FALSE;		/* no contact yet */e: 	    far_wall_hit = FALSE;		/* far wall hasn't been hit */0 	    ball_hit_first = 0;			/* nothing hit yet */+ 	    number_sunk = 0;			/* no balls sunk */ - 	    stop_count = 0;			/* reset stop count */  	    unnumber_balls(); 	    state = MOVE_BALLS; 	    break;t   	case MOVE_BALLS:	( 	    if (stop_count == balls_on_table) { 		state = SYNC_POSITIONS;o 		break;
 	    } else {t) 		set_frame_timeout(time_between_frames);u 		stop_count = 0;e 		for (i=0; i<num_balls; i++) {p 		    if (!off_table[i]) { 			if (!on_table[i]) { 			    off_table[i] = TRUE;R 			    balls_on_table--;' 			    erase_ball(psavex[i],psavey[i]);c 			    add_to_ballrack(i); 			    continue; 			}  + 			/* Calculate new position of the ball */  	u) 			psavex[i] = px[i];		/* old position */e 			psavey[i] = py[i]; ' 			px[i] += vx[i];			/* new position */: 			py[i] += vy[i];* 			vsavex[i] = vx[i];		/* save velocity */ 			vsavey[i] = vy[i];T. 			tsave[i] = 1.;			/* assume full movement */  > 			/* Determine if the ball came in contact with any border */  7 			if (px[i] >= right_edge-radius) {	/* right wall ? */a" 			    vx[i] *= -cushion_friction;! 			    vy[i] *= cushion_friction;E- 			    if (!any_contact) far_wall_hit = TRUE;r 			    if (vsavex[i] != 0) {; 				tsave[i] = (right_edge - radius - psavex[i])/vsavex[i];l+ 				py[i] = vsavey[i]*tsave[i] + psavey[i];L 				tsave[i] += backoff_t; 			    }# 			    px[i] = right_edge - radius;   = 			    /* Did the ball go in a pocket on the right wall ?? */   2 			    if (absolute(px[i]-pocket[2]) <= dist[2] &&+ 				(absolute(py[i]-top_edge) <= dist[2] ||=. 				absolute(py[i]-bottom_edge) <= dist[2])) {! 				sunken_ball[number_sunk] = i;a, 				if (absolute(py[i]-top_edge) <= dist[2])' 				    sunken_pocket[number_sunk] = 2;  				else' 				    sunken_pocket[number_sunk] = 5;; 				number_sunk++; 				on_table[i] = FALSE;
 				continue;] 			    }( 			    if (i == 0 && spin_factor != 0) { 				vy[0] -= 15*spin_factor; 				spin_factor *= .1; 			    }< 			} else if (px[i] <= left_edge+radius) {	/* left wall ? */" 			    vx[i] *= -cushion_friction;! 			    vy[i] *= cushion_friction;M 			    if (vsavex[i] != 0) {: 				tsave[i] = (left_edge + radius - psavex[i])/vsavex[i];+ 				py[i] = vsavey[i]*tsave[i] + psavey[i];E 				tsave[i] += backoff_t; 			    }" 			    px[i] = left_edge + radius;  < 			    /* Did the ball go in a pocket on the left wall ?? */  2 			    if (absolute(px[i]-pocket[0]) <= dist[0] &&+ 				(absolute(py[i]-top_edge) <= dist[0] ||	. 				absolute(py[i]-bottom_edge) <= dist[0])) {! 				sunken_ball[number_sunk] = i;r, 				if (absolute(py[i]-top_edge) <= dist[0])' 				    sunken_pocket[number_sunk] = 0;t 				else' 				    sunken_pocket[number_sunk] = 3;I 				number_sunk++; 				on_table[i] = FALSE;
 				continue;p 			    }( 			    if (i == 0 && spin_factor != 0) { 				vy[0] += 15*spin_factor; 				spin_factor *= .1; 			    } 			}  4 			if (py[i] >= top_edge-radius) {		/* top wall ? */! 			    vx[i] *= cushion_friction;u" 			    vy[i] *= -cushion_friction; 			    if (vsavey[i] != 0) {9 				tsave[i] = (top_edge - radius - psavey[i])/vsavey[i];l+ 				px[i] = vsavex[i]*tsave[i] + psavex[i];] 				tsave[i] += backoff_t; 			    }! 			    py[i] = top_edge - radius;   ; 			    /* Did the ball go in a pocket on the top wall ?? */=   			    for (j=0; j<3; j++) {/ 				if (absolute(px[i]-pocket[j]) <= dist[j]) {C' 				    vsize = magnitude(vx[i],vy[i]);E$ 				    if (j != 1 || vsize == 0. ||4 					(vsize <= 5. && absolute(vy[i]/vsize) > .07) ||" 					absolute(vy[i]/vsize) > .2) {" 					sunken_ball[number_sunk] = i;$ 					sunken_pocket[number_sunk] = j; 					number_sunk++;r 					on_table[i] = FALSE;G 					break;H	 				    }	 				}N 			    } 			    if (j < 3) continue;t( 			    if (i == 0 && spin_factor != 0) { 				vx[0] += 15*spin_factor; 				spin_factor *= .1; 			    }@ 			} else if (py[i] <= bottom_edge+radius) { /* bottom wall ? */! 			    vx[i] *= cushion_friction;s" 			    vy[i] *= -cushion_friction; 			    if (vsavey[i] != 0) {< 				tsave[i] = (bottom_edge + radius - psavey[i])/vsavey[i];+ 				px[i] = vsavex[i]*tsave[i] + psavex[i];d 				tsave[i] += backoff_t; 			    }$ 			    py[i] = bottom_edge + radius;  > 			    /* Did the ball go in a pocket on the bottom wall ?? */   			    for (j=0; j<3; j++) {/ 				if (absolute(px[i]-pocket[j]) <= dist[j]) { ' 				    vsize = magnitude(vx[i],vy[i]);e$ 				    if (j != 1 || vsize == 0. ||4 					(vsize <= 5. && absolute(vy[i]/vsize) > .07) ||" 					absolute(vy[i]/vsize) > .2) {" 					sunken_ball[number_sunk] = i;( 					sunken_pocket[number_sunk] = j + 3; 					number_sunk++;u 					on_table[i] = FALSE;e 					break;B	 				    }) 				}  			    } 			    if (j < 3) continue;m( 			    if (i == 0 && spin_factor != 0) { 				vx[0] -= 15*spin_factor; 				spin_factor *= .1; 			    } 			}  ( 			/* factor in backspin and sidespin */   			if (i == 0) {; 			    if (tsave[0] < 1.) {   /* the cue ball hit a wall */o' 				if (roll_x != 0. || roll_y != 0.) {O 				    vx[0] += roll_x*5; 				    vy[0] += roll_y*5; 				    roll_x *= .25; 				    roll_y *= .25; 				}s 			    } else {P$ 				if (absolute(spin_factor) > .05) 				    spin_factor *= .98;x 				else 				    spin_factor = 0.;y 				vx[0] += roll_x; 				vy[0] += roll_y;1 				if (absolute(roll_x)+absolute(roll_y) > .1) {S 				    roll_x *= .97; 				    roll_y *= .97;
 				} else 				    roll_x = roll_y = 0.;  			    } 			}  ( 			/* Reduce velocity due to friction */  . 			if (absolute(vx[i])+absolute(vy[i]) < 4.) {2 			    if (absolute(vx[i])+absolute(vy[i]) < .5) {1 				if (i != 0 || roll_x == 0. && roll_y == 0.) {{ 				    stop_count++;d 				    vx[i] = vy[i] = 0.;  				}	 			    } else {C  				vx[i] *= high_felt_friction;  				vy[i] *= high_felt_friction; 			    } 			} else {	 			    vx[i] *= felt_friction; 			    vy[i] *= felt_friction; 			} 		    }	/* !off_table[i] */K 		}	/* for i=1 to num_balls */   		/* 		 * Check for collisions  		 *> 		 * This section of code relies on the fact the projection of: 		 * one vector (the current velocity vector) onto another6 		 * (the angle of incidence) is given by the formula: 		 * 		 * 			(a.b)    b! 		 * 	projection =    ----- x ---l 		 * 			 |b|    |b|f 		 *< 		 * All of the momentum of one ball in the direction of the< 		 * angle of incidence is transferred to the other ball and 		 * vice versa. 		 */  		for (i=0; i<num_balls-1; i++)	! 		for (j=i+1; j<num_balls; j++) {"' 		    if (on_table[i] && on_table[j]) {  			/* ? 			 * Since the balls move more than one pixel per frame, their @ 			 * current position is not necessarily their initial point ofA 			 * contact.  To calculate the initial point of contact we mustv: 			 * parameterize the motion of the two balls in contact: 			 *x 			 * 			x = dx*t + x0 			 * 			y = dy*t + y0 			 *)5 			 * The distance between the two balls is given by:v 			 *  			 * 		    2		 2	      2l& 			 * 		dist  = (x2 - x1)  + (y2 - y1) 			 *r@ 			 * Using the parametric equations you can calculate the first< 			 * point at which the balls meet by setting 'dist' to the: 			 * diameter of one ball, substituting the parameterized?  			 * equations into the distance formula and solving for 't'.r 			 */ 			x1 = psavex[i]; 			y1 = psavey[i]; 			x2 = psavex[j]; 			y2 = psavey[j]; 			dpx = vsavex[i];; 			dpy = vsavey[i];e 			dpx1 = vsavex[j]; 			dpy1 = vsavey[j];+ 			a = square(dpx1-dpx) + square(dpy1-dpy);e2 			if (a == 0) continue;		/* both not moving??? */8 			c = square(x2-x1) + square(y2-y1) - square(diameter);8 			if (c > 10000.) continue;	/* too far away to touch */1 			b = 2*((dpx1-dpx)*(x2-x1)+(dpy1-dpy)*(y2-y1));e 			/*TD 			 * When we solve for t in the above equation, we get the formula: 			 *  			 * 		a*t**2 + b*t + c = 0 			 *eD 			 * By using the quadratic formula, we can solve for t.  There are 			 * some special cases._ 			 *O9 			 * 	-- If a=0, the velocity of the 2 balls are exactly_; 			 * 	   the same in which case no collision should occur.e= 			 * 	-- If b**2-4ac < 0, the solution is imaginary in whichE> 			 * 	   case the balls would never touch given their current 			 * 	   directions.f: 			 * 	-- If t < 0, the balls were already touching before 			 *	   this frame.= 			 * 	-- If t > 1, the balls will not touch until after this	 			 *	   frame.u 			 */ 			d = square(b) - 4*a*c;  			if (d < 0) continue;  			t = .5*(-b - sqroot(d))/a; # 			if (t < 0. || t >= 1.) continue;)  0 			if (!any_contact) {	/* record 1st ball hit */ 			    ball_hit_first = j; 			    any_contact = TRUE; 			    first_pos = (int)px[j]; 			} 			x1 += dpx*t;f 			y1 += dpy*t;{ 			x2 += dpx1*t; 			y2 += dpy1*t; 			/*i5 			 * Reset the position of both balls to the initial(4 			 * point of contact unless they have already been# 			 * reset to an earlier position.t 			 */" 			if (t < tsave[i]) tsave[i] = t;" 			if (t < tsave[j]) tsave[j] = t;   			ax = vsavex[i]; 			ay = vsavey[i]; 			bx = x2 - x1; 			by = y2 - y1;& 			b_size_2 = square(bx) + square(by); 			if (b_size_2 == 0) continue;T 			a_dot_b = ax*bx + ay*by;m 			vx1 = a_dot_b*bx/b_size_2;e 			vy1 = a_dot_b*by/b_size_2;c 			ax = vsavex[j]; 			ay = vsavey[j]; 			a_dot_b = ax*bx + ay*by;  			vx2 = a_dot_b*bx/b_size_2;s 			vy2 = a_dot_b*by/b_size_2;   ) 			/* Reset velocities after collision */f   			vxtrans = vx2 - vx1;  			vytrans = vy2 - vy1;	 			vx[i] += vxtrans; 			vy[i] += vytrans; 			vx[j] -= vxtrans; 			vy[j] -= vytrans; 			vx[i] *= contact_friction;+ 			vy[i] *= contact_friction;p 			vx[j] *= contact_friction;  			vy[j] *= contact_friction;p   			/* factor in spin */*   			if (i == 0) {, 			    if ((roll_x != 0. || roll_y != 0.) &&# 				(vx[0] != 0. || vy[0] != 0.)) {  				float scale = max(1.,d' 					(square(vxtrans)+square(vytrans))/r, 					(square(vsavex[0])+square(vsavey[0]))); 				vx[0] += roll_x*10*scale;c 				vy[0] += roll_y*10*scale;e 				roll_x *= (1.-.6*scale); 				roll_y *= (1.-.6*scale); 			    } 			    if (spin_factor != 0) { 				dpx = py[j] - py[0]; 				dpy = px[0] - px[j]; 				vsize = magnitude(dpx,dpy);  				if (vsize > 0) {) 				    vx[0] += dpx*7*spin_factor/vsize;e) 				    vy[0] += dpy*7*spin_factor/vsize;* 				    spin_factor *= .3; 				}* 			    } 			}  4 			/* Make a little noise for the collision ????? */  - 		    }	/* if (on_table[i] && on_table[j]) */ ! 		}	/* for (i...) & for (j...) */  		/*7 		 * Now, back up any balls that collided this frame to+ 		 * their collision points. 		 */  		for (i=0; i<num_balls; i++) ) 		    if (on_table[i] && tsave[i] < 1.) {<% 			t = max(0., tsave[i] - backoff_t);d# 			px[i] = psavex[i] + vsavex[i]*t;]# 			py[i] = psavey[i] + vsavey[i]*t;k 		    }u 		/*> 		 * Check for any overlapping balls.  If there are, back both@ 		 * balls up to the earliest time of any collision for the two. 		 */r 		for (i=0; i<num_balls-1; i++) 5 		    if (on_table[i] && (vx[i] != 0. || vy[i] != 0))   			for (j=i+1; j<num_balls; j++)9 			    if (on_table[j] && (vx[j] != 0. || vy[j] != 0.) &&	- 				square(px[i]-px[j])+square(py[i]-py[j]) <) 				square(diameter)) {  				int index1, index2;i' 				if (tsave[i] == tsave[j]) continue;  				if (tsave[i] < tsave[j]) { 				    index1 = i; index2 = j;  				} else { 				    index1 = j; index2 = i;s 				}++ 				t = max(0., tsave[index1] - backoff_t); 3 				px[index2] = psavex[index2] + vsavex[index2]*t; 3 				py[index2] = psavey[index2] + vsavey[index2]*t;  			    }  * 		/* Redraw those balls that have moved */   		for (i=0; i<num_balls; i++)sF 		    if (on_table[i] && (psavex[i] != px[i] || psavey[i] != py[i])) {# 			erase_ball(psavex[i],psavey[i]);z 			draw_ball(i); 		    }(	 		return;) 	    }   	case DELAY_OVER:m 	    cancel_delay_timeout(); 	    state = next_state; 	    break;k   	case CHECK_NET_READ:F+ 	    if (!net_read_complete(&bytes_read)) { 2 		set_delay_timeout(1);		/* check back in a bit */	 		return;a 	    } 	    if (bytes_read <= 0)f 		state = LOST_NET;o	 	    else	 		state = next_state;y 	    break;_   	case CHECK_LOCK_READ:0 	    status = lock_read(lock_buffer, lock_size); 	    if (status == 0) {t2 		set_delay_timeout(1);		/* check back in a bit */	 		return;  	    } 	    if (status < 0) 		state = LOST_LOCK;	 	    else] 		state = next_state;v 	    break;f   	case CHECK_LOCK_WRITE:]1 	    status = lock_write(lock_buffer, lock_size);g 	    if (status == 0) {o2 		set_delay_timeout(1);		/* check back in a bit */	 		return;p 	    } 	    if (status < 0) 		state = LOST_LOCK;	 	    else, 		state = next_state;  	    break;    	case WAIT_FOR_OPPONENT: 	    if (lock_grabbed()) { 		state = SEND_NAME; 		nbuffer[0] = game; 		nbuffer[1] = straight_limit; 		nbuffer[2] = opponent;" 		start_remote_write(nbuffer, 12); 		break;
 	    } else {F 		set_delay_timeout(1);		 		return;	 	    }   	case GAME_LOST:b 	    sprintf(string, "SORRY %s, YOU LOSE", (my_turn^im_remote ? player_name[1] : player_name[0]));  	    draw_centered_text(string);3 	    if (num_screens > 1) draw_remote_text(string);) 	    state = GAME_OVER;  	    delay(5); 	    return;   	case GAME_OVER: 	    display_score(); > 	    my_score = 0; his_score = 0;	/* reset balls sunk count */b 	    sprintf(string, "CONGRATULATIONS %s", (my_turn^im_remote ? player_name[0] : player_name[1]));  	    draw_centered_text(string);3 	    if (num_screens > 1) draw_remote_text(string);0 	    state = START_PLAY; 	    delay(5); 	    return;   	case BAD_NODE:y; 	    draw_centered_text("UNABLE TO ACCESS TARGET DISPLAY");	 	    state = END_GAME; 	    delay(6); 	    return;   	case LOST_NET:v3 	    draw_centered_text2("NETWORK CONNECTION LOST",a 				"GAME OVER");) 	    state = END_GAME; 	    delay(6); 	    return;   	case LOST_LOCK:8 	    draw_centered_text2("ERROR ACCESSING CLUSTER LOCK", 				"GAME OVER");i 	    state = END_GAME; 	    delay(6); 	    return;   	case END_GAME:	 	    erase_arrow();i 	    disable_button(); 	    remove_menus(); 	    cancel_delay_timeout(); 	    cancel_frame_timeout(); 	    if (net_game) 		if (num_screens > 1) { 		    destroy_remote_screen(); 		    system = LOCAL;	 		} else 		    net_close(); 	    else if (lock_game) 		lock_close(im_remote);> 	    if (net_game && im_remote || abort_flag == ABORT_PROGRAM)
 		exit(1); 	    else {m 		state = RESTART_GAME; # 		if (abort_flag == ABORT_REMOTE) {-8 		    draw_centered_text("YOUR OPPONENT HAS WITHDRAWN"); 		    abort_flag = 0;t 		    delay(6);a
 		    return;c
 		} else { 		    abort_flag = 0;a 		    break; 		}. 	    }   	case RESTART_GAME:l 	    action_started = FALSE; 	    balls_numbered = FALSE; 	    num_balls = 0;[ 	    draw_table();- 	    draw_centered_text2("*** GAME OVER ***",f 				"USE MENU BAR TO RESTART");i 	    enable_select_options();t 	    state = GAME_INIT;c 	    return;     }			/* switch (state) */     }			/* for (;;) loop */e }e   static int shooting_8ball()t {:     int i, start;x  '     if (!selection_made) return(FALSE);)     start = 9;%     if (my_turn ^ im_high) start = 1;v 	for (i=start; i<start+7; i++)$ 	    if (on_table[i]) return(FALSE);     return(TRUE);  }s  ' static int rightmost_target(start, end)a {t
     int i;     int rightmost = -1;l       for (i=start; i<=end; i++) 	if (on_table[i])nA 	    if (rightmost == -1 || px[i] > px[rightmost]) rightmost = i;i     return(rightmost); }f   void number_balls()  {s
     int i;       for (i=1; i<num_balls; i++);! 	if (on_table[i]) number_ball(i);e       balls_numbered = TRUE; }d   void unnumber_balls()  {s
     int i;       for (i=1; i<num_balls; i++)- 	if (on_table[i]) draw_ball(i);	       balls_numbered = FALSE;= }u   void draw_numbered_ball(index) {i     draw_ball(index);0'     if (index != 0) number_ball(index);/ }	   void replace_ball(x,y,index) float x, y;) {      if (on_table[index]) {! 	erase_ball(px[index],py[index]);  	px[index] = x;  	py[index] = y;2     } else { 	px[index] = x;y 	py[index] = y;t 	balls_on_table++; 	on_table[index] = TRUE; 	off_table[index] = FALSE; 	redraw_ballrack();0     }e     draw_numbered_ball(index); }    void spot_ball(index)c {a# float x0,y0,t1,t2,earliest_t,value;  unsigned char free_space;l int i;  ;     if (index == 0) return;		/*  don't spot the cue ball */h     x0 = spot_point;$     y0 = (top_edge + bottom_edge)/2;     earliest_t = 0.;     free_space = FALSE;	     while (!free_space) {- 	free_space = TRUE;  	for (i=0; i<num_balls; i++) 	    if (on_table[i]) { 0 		value = square(diameter) - square(py[i] - y0); 		if (value > 0) {( 		    t1 = (px[i] - x0) - sqroot(value);( 		    t2 = (px[i] - x0) + sqroot(value);/ 		    if (t1 < earliest_t && t2 > earliest_t) {  			earliest_t = t2;t 			free_space = FALSE; 		    }) 		}; 	    }' 	if (earliest_t > spot_offset-radius) {  	    y0 += radius; 	    earliest_t = 0.;  	    free_space = FALSE; 	}     }h     if (on_table[index])! 	erase_ball(px[index],py[index]);e
     else { 	on_table[index] = TRUE; 	off_table[index] = FALSE; 	balls_on_table++; 	redraw_ballrack();t     }       px[index] = earliest_t + x0;     py[index] = y0;      draw_numbered_ball(index); }z   void spot_cue()s {r:     float best_shot, maxmag, save_x, save_y, old_x, old_y;&     float width, height, left, bottom;     int tries;     unsigned char overlaps;s
     int i, j;        if (on_table[0]) { 	old_x = px[0];  	old_y = py[0];b     }e     best_shot = -10000.;A     if ((game == NINE_BALL || game == ROTATION) && !first_shot) {a4 	left = max(left_edge+radius+1, px[first_ball]-125);8 	bottom = max(bottom_edge+radius+1, py[first_ball]-125);6 	width = min(right_edge-px[first_ball]-radius-2, 250);5 	height = min(top_edge-py[first_ball]-radius-2, 250);n 	tries = 10;     } else { 	left = left_edge + radius + 1;*# 	bottom = bottom_edge + radius + 1;l. 	width = break_point - left_edge - radius - 2;0 	height = top_edge - bottom_edge - diameter - 2; 	tries = 2;t# 	if (game == EIGHT_BALL) tries = 5;e     }[     if (first_shot) {;$ 	px[0] = left + width*random_number;' 	py[0] = bottom + height*random_number;      } else { 	for (i=0; i<tries; i++) {	 	    do {} 		overlaps = FALSE;t% 		px[0] = left + width*random_number;	( 		py[0] = bottom + height*random_number; 		for (j=1; j<num_balls; j++) . 		    if (on_table[j] && square(px[0]-px[j]) +, 			square(py[0]-py[j]) < square(diameter)) { 			overlaps = TRUE;=	 			break;* 		    }} 	    } while (overlaps);   	    maxmag = determine_shot();/ 	    if (maxmag > best_shot) { 		best_shot = maxmag;	 		save_x = px[0];  		save_y = py[0];	 	    } 	} 	px[0] = save_x; 	py[0] = save_y;     }      if (!on_table[0]) {t 	balls_on_table++; 	on_table[0] = TRUE; 	off_table[0] = FALSE; 	redraw_ballrack();  	display_score();e
     } else 	erase_ball(old_x,old_y);]       draw_ball(0);p }]  # static void get_game_string(string) 
 char *string;k {r#     strcpy(string, "THE GAME IS ");,     switch (game) {s 	case STRAIGHT_POOL:2 	    sprintf(string, "%sSTRAIGHT POOL,  LIMIT %d", 		    string, straight_limit); 	    break;  	case NINE_BALL:! 	    strcat(string, "NINE BALL");m 	    break;  	case EIGHT_BALL:[" 	    strcat(string, "EIGHT BALL"); 	    break;e 	case ROTATION:a  	    strcat(string, "ROTATION"); 	    break;	     }n }1   static void display_call(where)v {]     char string[35];  9     if (target_ball == -1 || target_pocket == -1) return;	  <     sprintf(string, "%d BALL IN THE %s POCKET", target_ball,A 	(target_pocket == 1 || target_pocket == 4) ? "SIDE" : "CORNER");      if (where == LOCAL)y 	draw_centered_text(string);     else 	draw_remote_text(string); }    static float determine_shot()  {o)     float dpx, dpy, dpx1, dpy1, pfx, pfy;bI     float psize, psize1, maxmag, dot, newmax, vsize, newvx, newvy, scale;x8     float ax, ay, bx, by, amag2, bmag2, adotb, vx1, vy1;M     float newpfx, newpfy, newdpx, newdpy, savemax, newsize, savepfx, savepfy;tF     float savedpx, savedpy, savesize, newpos1, newpos2, t, amag, bmag;$     float newvx1, newvy1, bad_value;'     static unsigned char bank[6][4] = {n 			0, 0, 1, 1, 			1, 0, 1, 1, 			1, 0, 0, 1, 			0, 1, 1, 0, 			1, 1, 1, 0,
 			1, 1, 0, 0y 			};b     unsigned char none_of_mine;      int i, j, k, jj;  $     /* special case for the break */       if (first_shot) {_ 	pfx = px[1] - diameter;% 	pfy = py[1] + 10*(.5-random_number);i 	vx1 = pfx - px[0];t 	vy1 = pfy - py[0];e 	vsize = magnitude(vx1,vy1);& 	scale = (45.+8.*random_number)/vsize; 	vx[0] = scale*vx1;w 	vy[0] = scale*vy1;k 	return(0.);     }a       maxmag = -1e20;a  +     /* check if any of my balls on table */u  /     if (game == EIGHT_BALL && selection_made) {L 	none_of_mine = TRUE;t 	if (shooting_high_balls) {  	    for (i=9; i<16; i++):( 		if (on_table[i]) none_of_mine = FALSE;	 	} else {	 	    for (i=1; i<8; i++)( 		if (on_table[i]) none_of_mine = FALSE; 	}     }	!     for (i=1; i<num_balls; i++) {	 	if (on_table[i]) {F  . 	    /* Check for special object ball rules */   	    if (game == EIGHT_BALL) r 		if (!selection_made) { 		    if (i == 8) continue;n 		} else if (none_of_mine) { 		    if (i != 8) continue;;# 		} else if (shooting_high_balls) {t 		    if (i <= 8) continue;=
 		} else { 		    if (i >= 8) continue;; 		}c   	    dpx = px[i] - px[0];s 	    dpy = py[i] - py[0];;  	    psize = magnitude(dpx,dpy);   	    for (j=0; j<6; j++) { 		/*9 		 * Find the position to aim at to sink the current balla 		 * (pfx,pfy) 		 */a 		dpx1 = pocketx[j]-px[i]; 		dpy1 = pockety[j]-py[i];  		psize1 = magnitude(dpx1,dpy1);% 		pfx = px[i] - diameter*dpx1/psize1;t% 		pfy = py[i] - diameter*dpy1/psize1;t   		/*6 		 * Set newmax to the cosine of the angle between the9 		 * cue ball's line of travel and the line of collision.  		 */_ 		dot = dpx*dpx1 + dpy*dpy1; 		newmax = dot/(psize*psize1);   		/*7 		 * If the cosine is small, then the angle is sharp soO 		 * downgrade its value.d 		 */"! 		if (newmax < 0.25) newmax -= 4;	   		/*< 		 * Are there any balls between the cue ball and the target 		 * ball ?A 		 */ , 		if (blocked(px[0], py[0], pfx, pfy, i, 0))A 		    newmax -= (game == NINE_BALL || game == ROTATION ? 12 : 4);_   		bad_value = 0;  , 		/* Side pockets are hard for big angles */   		if (j == 1 || j == 4) 3 		    bad_value -= .75*(1 - absolute(dpy1/psize1));e 		/*	(8 		 * Are there any balls between the target ball and the
 		 * pocket ?b 		 */g: 		if (blocked(px[i], py[i], pocketx[j], pockety[j], i, 0)) 		    bad_value -= 2;_   		newmax += bad_value;  + 		/* Check for special target ball rules */H  A 		if ((game == NINE_BALL || game == ROTATION) && first_ball != i)	 		    newmax -= 100;? 		if (game != NINE_BALL && game != ROTATION && after_scratch &&  		    px[i] < break_point) 		    newmax -= 100;   		newvx = pfx - px[0]; 		newvy = pfy - py[0];  ) 		if (scratch(newvx, newvy, pfx, pfy, i))f 		    newmax -= 10;O   		if (newmax > maxmag) {0 		    vsize = distance2(	pocketx[j], pockety[j], 					px[i], py[i], 					px[0], py[0]);  		    newmax -= vsize/1500.; 		    if (newmax > maxmag) { 			scale = vsize;a 			vx1 = newvx;s 			vy1 = newvy;t 			maxmag = newmax;r 			target_pocket = j;  			target_ball = i;v 		    }= 		};   		/*******************/o 		/* Look for combos */; 		/*******************/    		for (k=1; k<num_balls; k++) {,! 		   if (k != i && on_table[k] &&h# 			(game != EIGHT_BALL || i != 8 &&e6 			(!selection_made || shooting_high_balls && k > 8 ||# 			shooting_low_balls && k < 8)) &&i@ 			(game != NINE_BALL && game != ROTATION || first_ball == k) &&> 			(game == NINE_BALL || game == ROTATION || !after_scratch || 			 px[k] >= break_point)) { 			bx = pfx - px[k]; 			by = pfy - py[k]; 			bmag = magnitude(bx,by);1$ 			newmax = 1;		/* assume maximum */ 			if (bmag == 0) { + 			    newpfx = pfx - diameter*dpx1/psize1;u+ 			    newpfy = pfy - diameter*dpy1/psize1;0 			} else {e) 			    newpfx = px[k] - diameter*bx/bmag;p) 			    newpfy = py[k] - diameter*by/bmag;  			    ax = newpfx - px[0];e 			    ay = newpfy - py[0];  			    amag = magnitude(ax,ay);2 			    if (amag != 0) {] 				adotb = ax*bx + ay*by; 				newmax = adotb/(amag*bmag);] 				if (newmax < 0) continue;A 			    } 			} 			ax = pocketx[j] - px[i];n 			ay = pockety[j] - py[i];o 			amag = magnitude(ax,ay);a 			bx = pfx - px[k]; 			by = pfy - py[k]; 			bmag = magnitude(bx,by);  			/*n4 			 * Set the value for this shot based on the angle4 			 * of collision of the cue and the first ball and6 			 * the first and the second ball.  Use the formula: 			 *!5 			 *   value = (1+cos(angle1))*(1+cos(angle2))/2 - 1b 			 *+4 			 * This will give a value in the range -1.5 to 1. 			 */ 			if (bmag != 0) {f 			    adotb = ax*bx + ay*by;i6 			    newmax = .5*(newmax+1)*(1+adotb/(amag*bmag))-1; 			}   			/* Sharp angles are tough */t   			if (newmax < -.5) continue;! 			if (newmax < 0.2) newmax -= 4;   3 			if (blocked(px[0], py[0], newpfx, newpfy, i, k))sB 			    newmax -= (game == NINE_BALL || game == ROTATION ? 12 : 4);- 			if (blocked(px[k], py[k], pfx, pfy, i, k))e 			    newmax -= 2;y 			newmax += bad_value;o  - 			newmax -= .4;		/* reduce combo attempts */;  2 			/* If playing 9-ball, a 9-ball combo is good */# 			if (game == NINE_BALL && i == 9)y 			    newmax += .5;  4 			/* If playing rotation, a high # combo is good */ 			if (game == ROTATION)+ 			    newmax += (float)(i-first_ball)*.05;t   			newvx = newpfx - px[0]; 			newvy = newpfy - py[0];  0 			if (scratch(newvx, newvy, newpfx, newpfy, k)) 			    newmax -= 10;  $ 			/* Gets worse with skill level */  ' 			if (alternating) newmax -= skill*10;a   			if (newmax > maxmag) {t1 			    vsize = distance3(	pocketx[j], pockety[j],] 						px[i], py[i],( 						px[k], py[k],  						px[0], py[0]); 			    newmax -= vsize/1500.;t 			    if (newmax > maxmag) {  				scale = vsize; 				vx1 = newvx; 				vy1 = newvy; 				maxmag = newmax; 				target_pocket = j; 				target_ball = i; 			    } 			} 		    }w 		}	/* looking for combos */  4 		/* Don't try any more if invalid nine ball shot */  A 		if ((game == NINE_BALL || game == ROTATION) && first_ball != i)  		    continue;t  $ 		/********************************/$ 		/* Look for cue ball bank shots */$ 		/********************************/   		for (k=0; k<4; k++) {v< 		    if (k != 2 && game != NINE_BALL && game != ROTATION &&2 			after_scratch && px[i] < break_point) continue; 		    if (bank[j][k]) {f 			if (k == 0) {" 			   newpfx = left_edge + radius;. 			   newpfy = pfy - (pfy-py[0])*(newpfx-pfx)/ 				    (2*newpfx-pfx-px[0]);  			} else if (k == 1) { ! 			   newpfy = top_edge - radius; . 			   newpfx = pfx - (pfx-px[0])*(newpfy-pfy)/ 				    (2*newpfy-pfy-py[0]);y 			} else if (k == 2) {p# 			   newpfx = right_edge - radius; . 			   newpfy = pfy - (pfy-py[0])*(newpfx-pfx)/ 				    (2*newpfx-pfx-px[0]);b 			} else if (k == 3) {a$ 			   newpfy = bottom_edge + radius;. 			   newpfx = pfx - (pfx-px[0])*(newpfy-pfy)/ 				    (2*newpfy-pfy-py[0]);a 			} 			newdpx = pfx - newpfx;k 			newdpy = pfy - newpfy;H& 			newsize = magnitude(newdpx,newdpy);# 			dot = newdpx*dpx1 + newdpy*dpy1;n% 			if (newsize != 0 && psize1 != 0) { % 			    newmax = dot/(newsize*psize1);   # 			    /* Sharp angles are tough */N    			    if (newmax < 0) continue;& 			    if (newmax < 0.25) newmax -= 4;  & 			    /* Don't try these too often */ 			    newmax -= 1;T  ( 			    /* Gets worse with skill level */  + 			    if (alternating) newmax -= skill*25;[  7 			    if (blocked(px[0], py[0], newpfx, newpfy, i, 0))e? 				newmax -= (game == NINE_BALL || game == ROTATION ? 12 : 4);b3 			    if (blocked(newpfx, newpfy, pfx, pfy, i, 0))S 				newmax -= 2; 			    newmax += bad_value;d   			    newvx = pfx - newpfx; 			    newvy = pfy - newpfx;. 			    if (scratch(newvx, newvy, pfx, pfy, i)) 				newmax -= 10;p   			    for (jj=0; jj<6; jj++)s$ 				if (square(pocketx[jj]-newpfx) +$ 				    square(pockety[jj]-newpfy) < 				    square(diameter)) {d 				    newmax -= 10;a 				    break; 				}x   			    if (newmax > maxmag) {f- 				vsize = distance3(pocketx[j], pockety[j],i 						  px[i], py[i],, 						  newpfx, newpfy,e 						  px[0], py[0]); 				newmax -= vsize/1500.; 				if (newmax > maxmag) { 				    scale = vsize; 				    vx1 = newpfx - px[0];1 				    vy1 = newpfy - py[0];} 				    maxmag = newmax; 				    target_pocket = j; 				    target_ball = i; 				}h 			    } 			} 		    }s 		}	/* cue ball bank shots */e  ? 		if (game != NINE_BALL && game != ROTATION && after_scratch && ! 		    px[i] < break_point) break;i  ' 		/***********************************/b' 		/* Look for target ball bank shots */=' 		/***********************************/    		for (k=0; k<4; k++) {c 		   if (bank[j][k]) { 			if (k == 0) {# 			    newpfx = left_edge + radius;_0 			    newpfy = pockety[j] - (pockety[j]-py[i])* 				     (newpfx-pocketx[j])/1% 				     (2*newpfx-pocketx[j]-px[i]);n 			} else if (k == 1) { " 			    newpfy = top_edge - radius;0 			    newpfx = pocketx[j] - (pocketx[j]-px[i])* 				     (newpfy-pockety[j])/ % 				     (2*newpfy-pockety[j]-py[i]);p 			} else if (k == 2) {/$ 			    newpfx = right_edge - radius;0 			    newpfy = pockety[j] - (pockety[j]-py[i])* 				     (newpfx-pocketx[j])/{% 				     (2*newpfx-pocketx[j]-px[i]);e 			} else if (k == 3) { % 			    newpfy = bottom_edge + radius;l0 			    newpfx = pocketx[j] - (pocketx[j]-px[i])* 				     (newpfy-pockety[j])/=% 				     (2*newpfy-pockety[j]-py[i]);e 			} 			newdpx = newpfx - px[i];+ 			newdpy = newpfy - py[i];i& 			newsize = magnitude(newdpx,newdpy); 			if (newsize == 0) continue;- 			savepfx = px[i] - diameter*newdpx/newsize;;- 			savepfy = py[i] - diameter*newdpy/newsize;i 			savedpx = savepfx - px[0];f 			savedpy = savepfy - py[0];1) 			savesize = magnitude(savedpx,savedpy);f 			if (savesize == 0) continue;b) 			dot = newdpx*savedpx + newdpy*savedpy;i# 			newmax = dot/(newsize*savesize);d   			/* Sharp angles are tough */;   			if (newmax < 0) continue;" 			if (newmax < 0.25) newmax -= 4;  - 			/* Side pockets are hard for big angles */<  0 			if ((j == 1 || j == 4) && (k == 0 || k == 2)) 			    newmax -= 1.5; 5 			if (blocked(px[0], py[0], savepfx, savepfy, i, 0))0B 			    newmax -= (game == NINE_BALL || game == ROTATION ? 12 : 4);7 			if (blocked(savepfx, savepfy, newpfx, newpfy, i, 0))d 			    newmax -= 2;r= 			if (blocked(newpfx, newpfy, pocketx[j], pockety[j], i, 0)). 			    newmax -= 2;/   			newvx = savepfx - px[0];e 			newvy = savepfy - py[0];e2 			if (scratch(newvx, newvy, savepfx, savepfy, i)) 			    newmax -= 10;  , 			/* Check for collisions on the rebound */   			bx = px[i] - savepfx; 			by = py[i] - savepfy; 			bmag2 = bx*bx + by*by;f 			dot = newvx*bx + newvy*by;  			newvx1 = dot*bx/bmag2;i 			newvy1 = dot*by/bmag2;	 			if (k == 0 || k == 2) { 			    if (newvx1 == 0) {t 				newpos1 = py[i]; 				newpos2 = py[i]; 			    } else {	( 				t = absolute((newpfx-px[i])/newvx1);) 				newpos1 = savepfy + (newvy-newvy1)*t;  				newpos2 = py[i] + newvy1*t;f 			    } 			} else if (newvy1 == 0) { 			    newpos1 = px[i];y 			    newpos2 = px[i];  			} else {y+ 			    t = absolute((newpfy-py[i])/newvy1);f, 			    newpos1 = savepfx + (newvx-newvx1)*t;" 			    newpos2 = px[i] + newvx1*t; 			}- 			if (absolute(newpos1-newpos2) <= 3*radius)a 			    newmax -= 3;	  $ 			/* Gets worse with skill level */  ' 			if (alternating) newmax -= skill*10;    			if (newmax > maxmag) {+1 			    vsize = distance3(	pocketx[j], pockety[j],! 						newpfx, newpfy,& 						px[i], py[i],d 						px[0], py[0]); 			    newmax -= vsize/1500.;_ 			    if (newmax > maxmag) {! 				scale = vsize; 				vx1 = newvx; 				vy1 = newvy; 				maxmag = newmax; 				target_pocket = j; 				target_ball = i; 			    } 			} 		    }   		}	/* target ball bank shots */# 	    }	    /* for each pocket... */1 	}	/* if on_table... */	      }	    /* for each ball... */  <     maxmag += scale/750.;		/* don't factor in length here */     vsize = magnitude(vx1,vy1);}.     scale = (5. + 12.*alog10(scale+1.))/vsize;     if (maxmag < -8.)y4 	scale *= .6;			/* if real bad shot, reduce speed */     else if (maxmag < -1.)5 	scale *= 1.4;			/* if somewhat bad, then hit hard */=       vx[0] = scale*vx1;     vy[0] = scale*vy1;<     if (alternating) {			/* add randomness if alternating */ 	float rand1, rand2, r1, r2;   	r1 = .5 - random_number;[ 	r2 = .5 - random_number;x* 	if (absolute(r2) > absolute(r1)) r1 = r2; 	rand1 = 10.*skill*r1; 	r1 = .5 - random_number;  	r2 = .5 - random_number; * 	if (absolute(r2) > absolute(r1)) r1 = r2; 	rand2 = 10.*skill*r1;' 	if (random_number < skill/max_skill) {. 	    rand1 *= 1.5; 	    rand2 *= 1.5; 	}2 	if (maxmag < -10.) {		/* extra for tough shots */ 	    rand1 *= 6.;v 	    rand2 *= 6.;1 	} else if (maxmag < .5) {  	    rand1 *= (1.5 - maxmag*.4);  	    rand2 *= (1.5 - maxmag*.4); 	} 	vx[0] += rand1; 	vy[0] += rand2;     }h     return(maxmag);* }   2 static int blocked(x1, y1, x2, y2, index1, index2)* float x1, y1;		/* the starting position */( float x2, y2;		/* the ending position */" int index1;		/* the source ball */" int index2;		/* the target ball */ { .     float ax, ay, bx, by, amag2, bmag2, adotb;
     int i;       /*I      * Set vector a (ax,ay) to point from starting point to ending point.b      */b     ax = x2 - x1;/     ay = y2 - y1;N3     amag2 = ax*ax + ay*ay;		/* size of a squared */p     if (amag2 == 0) return(0);4     for (i=1; i<num_balls; i++)		/* for each ball */1 	if (i != index1 && i != index2 && on_table[i]) {  	    /*	C 	     * Set vector b to point from the starting point to this ball.f 	     */ 	    bx = px[i] - x1;	 	    by = py[i] - y1;l 	    adotb = ax*bx + ay*by;i3 	    bmag2 = bx*bx + by*by;	/* size of b squared */t 	    /*v> 	     * See if this ball is close enough to the line of travel; 	     * to cause a collision.  Use the following formula to= 	     * determine closeness: 	     *m6 	     *    |closeness|**2 = |b|**2 - |b*cosine(ab)|**2 	     *	B 	     * Note that cosine(ab) = a.b/(|a|*|b|).  Do a quick check to? 	     * ensure cosine(ab) > 0 which implies the two vectors aret= 	     * within 90 degrees of each other (pointing in the sameN 	     * general direction).& 	     */ 	    if (adotb > 0 &&e; 		absolute(bmag2-adotb*adotb/amag2) < square(diameter+2) &&  		bmag2 < amag2) return(1);* 	}     return(0); }*  / static int scratch(newvx, newvy, cx, cy, index) 3 float newvx, newvy;	/* the direction of the shot */r+ float cx, cy;		/* the point of collision */ ! int index;		/* the target ball */{ {	C     float ax, ay, bx, by, amag2, bmag2, adotb, scale, amag, cosine;e
     int i;       /*9      * Set vector a (ax,ay) to the direction of the shot.yE      * Set vector b (bx,by) to point from the collision point through       * the target ball.0      */}     ax = newvx;      ay = newvy;=     bx = px[index] - cx;     by = py[index] - cy;3     bmag2 = bx*bx + by*by;		/* size of b squared */	     if (bmag2 == 0) return(0);     adotb = ax*bx + ay*by;<     scale = adotb/bmag2;		/* size of projection of a on b */       /*E      * Save angle between cue ball direction and collision direction.       */e>     cosine = absolute(adotb/(magnitude(ax,ay)*sqroot(bmag2)));       /*B      * Now set vector a to the direction of the cue ball after the      * collision.h      */s     ax = newvx - scale*bx;     ay = newvy - scale*by;3     amag2 = ax*ax + ay*ay;		/* size of a squared */      if (amag2 == 0) return(0);     amag = sqroot(amag2);e  2     for (i=0; i<6; i++) {		/* check each pocket */ 	/*m? 	 * Set vector b to point from the collision point to a pocket.f 	 */ 	bx = pocketx[i] - cx; 	by = pockety[i] - cy; 	bmag2 = bx*bx + by*by;	 	if (bmag2 == 0) continue; 	adotb = ax*bx + ay*by;	 	/*m= 	 * Compare the vector from the collision point to the pocketn> 	 * with the direction vector of the cue ball after collision.> 	 * If they are close enough, then a scratch is possible.  Get? 	 * the projection of vector b onto vector a.  Then compare thep= 	 * size of the vector between vector b and the new vector tom 	 * the size of the pocket.	 	 * > 	 *    |distance from scratch|**2 = |b|**2 - |b*cosine(ab)|**2 	 *o< 	 * In addition, make sure the cue will be going fast enough; 	 * after the collision.  This depends on the directness ofe3 	 * the collision and the distance from the pocket.  	 */? 	if (absolute(bmag2 - adotb*adotb/amag2) < square(3.*radius)) {wB 	    if (blocked(cx, cy, pocketx[i], pockety[i], 0, index)) break;) 	    if (bmag2 > 90000. && cosine > .8 ||a# 		bmag2 > 10000. && cosine > .87 ||L" 		bmag2 > 1000. && cosine > .92 ||4 		bmag2 > 500. && adotb/(amag*sqroot(bmag2)) < .5 || 		cosine > .95) break; 	    return(1);o 	}     }t     return(0); }=   static void delay(n) {*     next_state = state;k     set_delay_timeout(n);b     state = DELAY_OVER;  }{  ) static void start_remote_read(addr, size)  char *addr;k	 int size;o {t     next_state = state;e     set_delay_timeout(1);      if (lock_game) { 	lock_buffer = addr; 	lock_size = size; 	state = CHECK_LOCK_READ;;     } else { 	net_read(addr, size); 	state = CHECK_NET_READ;     }c }y  * static void start_remote_write(addr, size) char *addr;f	 int size;/ {	     if (lock_game) { 	next_state = state; 	lock_buffer = addr; 	lock_size = size; 	state = CHECK_LOCK_WRITE;     } else {  	if (net_write(addr, size) <= 0) 	    state = LOST_NET;     }w } 