 /*	 
 **  Xodometer  **  Written by Mark H. GranoffJ **             PATHWORKS Server Engineering, Digital Equipment Corporation! **             Littleton, MA, USA  **             17 March 1993 **  K **  If you make improvements or enhancements to Xodometer, please send them 5 **  back to the author at granoff@keptin.lkg.dec.com.  ** **  N **  This software is provided as is with no warranty of any kind, expressed orK **  implied. Neither Digital Equipment Corporation nor Mark Granoff will be 3 **  held accountable for your use of this software.  **  M **  This software is released into the public domain and may be redistributed I **  freely provided that all source module headers remain intact in their M **  entirety, and that all components of this kit are redistributed together.  **   **  Modification History **  --------------------2 **  19 Mar 1993	M. Granoff  v1.0  Initial release.E **   3 Aug 1993 M. Granoff  v1.2  Added automatic trip reset feature. P **   5 Jan 1994 M. Granoff  v1.3  Ported to Alpha; moved mi/km button into popup4 **				  menu; removed 'Trip' fixed label; added font **				  resource. N **   6 Jan 1994 M. Granoff  x1.4  Main window no longer grabs input focus when **				  realized.  **   */	    #define module_name XODOMETER  #define module_vers "1.3"    #ifdef __alpha& #pragma module module_name module_vers #pragma nostandard #else  /* __vax */ #module module_name module_vers  #endif /* __alpha */   #ifdef __alpha #pragma standard #endif /* __alpha */   #include <stdio.h> #include <descrip.h> #include <math.h>  #include <ctype.h> #include <time.h>  #include <X11/Xlib.h>  #include <X11/Xutil.h> #include <X11/Xatom.h> #include <X11/StringDefs.h>  #include <X11/MwmUtil.h> #include <Xm/Xm.h> #include <Xm/MainW.h>  #include <Xm/Label.h>  #include <Xm/RowColumn.h>  #include <Xm/CascadeB.h> #include <Xm/PushB.h>  #include <Xm/ToggleB.h>  #include "Xodometer.bit" /* module level stuff */  % static	char progName[] = "Xodometer"; & static	char progClass[] = "Xodometer";$ static  char progVersion[] = "v1.3"; static	Display *display;, static	Window root, *RootIDRet, *ChildIDRet; static	int WinX, WinY; static	unsigned int StateMask; static  XrmDatabase db; " static	int XCoord = 0, YCoord = 0;* static	int lastXCoord = 0, lastYCoord = 0;6 static	int pointerScreen = -1, lastPointerScreen = -1; static	int Enabled = TRUE;! static	int UseKilometers = FALSE;  static  int AutoReset = TRUE; 2 static  double Distance = 0.0, TripDistance = 0.0; static  int debug = 0; static	char *fontName;U static	char defaultFontName[] = "-adobe-helvetica-bold-r-normal--24-240-*-*-*-*-*-*";  static	char startDate_s[128]; # static	int cyclesSinceLastSave = 0;  typedef struct     {  	struct tm lt; 	double Odometer;      } _odometerInfo; _odometerInfo odometerInfo;   V static  Widget TopLevel, MainWindow, MainDialog, DistanceLabel, TripLabel, TripButton; #if 0 I static  Widget FormatOptions, FormatPulldown, fMilesButton, fKilosButton;  #endifJ static  Widget puMenu, puMenuLabel, puMenuLabel1, puSep1, puOnOff, puAuto,) 	puFormat, puSaveSettings, puSep, puQuit;   # static XrmOptionDescRec options[] =  	    {E 	    {"-background", ".background", XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-bg",         ".background", XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-display",    ".display",    XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-foreground", ".foreground", XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-fg",         ".foreground", XrmoptionSepArg, (caddr_t) NULL}, E 	    {"-geometry",   ".geometry",   XrmoptionSepArg, (caddr_t) NULL}, < 	    {"-iconic",	    ".iconic",	   XrmoptionNoArg, "FALSE"},; 	    {"-help",	    ".help",       XrmoptionNoArg, "FALSE"}, = 	    {"-format",	    ".format",	   XrmoptionSepArg, "miles"}, = 	    {"-orientation",".orientation",XrmoptionSepArg, "left"}, 8 	    {"-state",	    ".state",	   XrmoptionSepArg, "on"},< 	    {"-autoreset",  ".autoreset",  XrmoptionSepArg,  "on"},F 	    {"-font",       ".font",       XrmoptionSepArg, defaultFontName},K 	    {"-debug",	    ".debug",	   XrmoptionNoArg, "FALSE"}, /* Leave last */  	    }; A static optcount = (sizeof options) / (sizeof (XrmOptionDescRec));    #define MAX_SCREEN 16  typedef struct     { 
 	Window root; 
 	Screen *scr;  	int height, width;  	double PixelsPerMM;     } _screenInfo;# _screenInfo screenInfo[MAX_SCREEN];  static int screenCount;   * $DESCRIPTOR (interval_d, "0 00:00:00.10"); unsigned int interval_q[2];  #define SAVE_FREQUENCY 10  #define MAXARGS 253 #define DEFAULTS "decw$user_defaults:xodometer.dat" 0 #define SAVED_ODOMETER "sys$login:xodometer.sav" #define K_Left 1 #define K_Right 2  #define K_Top 3  #define K_Bottom 4& static int screenOrientation = K_Left;  " char *GetResource(char *, char *);' void PutStringResource(char *, char *); % void PutNumericResource(char *, int);  void Usage(char **); void CleanUp();  void SetupTimer(); void SetAutoResetTimer();  void AutoResetAST(); void QueryPointer(); void FindAllScreens(); void ReadOdometer(); void WriteOdometer();    void OnOffCB();  void MilesKilosCB(); void QuitCB(); void SaveSettingsCB(); void puPostMenu(); void TripButtonCB(); void AutoResetCB();   $ main(unsigned int argc,char *argv[]) {      XtAppContext    appContext;      Arg args[MAXARGS];     Pixmap icon_pixmap; G     int gx, gy, gw, gh;		/* main window geometry x, y, width, height */        int n, i, status;      char geombuff[32];     char windowTitle[128];     char puMenuLabel_s[128];     char *format_p;      char *state_p;     char *orientation_p;     char *autoreset_p;     char distance_s[10];     long int decor;        Font font;     XFontStruct *fontStruct;     XmFontList fontList;  )     /* Initialize the resource manager */      XrmInitialize();  &     db = XrmGetFileDatabase(DEFAULTS);  F     XrmParseCommand(&db, options, optcount, "xodometer", &argc, argv);  ,     if (ResourcePresent("debug")) debug = 1;.     if (debug) printf("Debug mode active.\n");  ,     if (ResourcePresent("help") || argc>1) { 	Usage(&argv[0]);  	CleanUp(0);	 	exit(1);      }            /* Initialize the toolkit */     TopLevel = XtAppInitialize( 2 	    &appContext,			/* App. context is returned */( 	    progClass,			/* Root class name. */% 	    options,			/* No option list. */ ) 	    optcount,			/* Number of options. */ $ 	    &argc,				/* Address of argc */ 	    argv,				/* argv */& 	    NULL,				/* Fallback resources */) 	    NULL,				/* No override resources */ . 	    0);				/* Number of override resources */  "     display = XtDisplay(TopLevel);     if (display==NULL) {  	printf("can't open display\n"); 	CleanUp(0);
 	exit(-1);     }        FindAllScreens();   4     fontName = GetResource("font", defaultFontName);(     font = XLoadFont(display, fontName);     if (font==0) {* 	printf("can't load font %s\n", fontName); 	CleanUp(0);
 	exit(-1);     } 3     fontStruct = XLoadQueryFont(display, fontName); F     fontList = XmFontListCreate(fontStruct, XmSTRING_DEFAULT_CHARSET);  6     root = RootWindow(display,DefaultScreen(display));F     icon_pixmap = XCreateBitmapFromData(display, root, xodometer_bits,( 					xodometer_width, xodometer_height);  -     format_p = GetResource("format","miles");      switch (*format_p)     { 
 	case 'm': 	case 'M':   /* miles */" 	    UseKilometers = FALSE; break;
 	case 'k': 	case 'K':   /* kilometers */ " 	    UseKilometers = TRUE;  break;	 	default: 6 	    printf("invalid display format: %s\n", format_p); 	    CleanUp(0); 	    exit(20);     } )     PutStringResource("format",format_p);   (     state_p = GetResource("state","on");     state_p++;     switch (*state_p)      { 
 	case 'f': 	case 'F':   /* off */ 	    Enabled = FALSE; break;
 	case 'n': 	case 'N':   /* on */  	    Enabled = TRUE;  break;	 	default:  	    state_p--; , 	    printf("invalid state: %s\n", state_p); 	    CleanUp(0); 	    exit(20);     }      state_p--;'     PutStringResource("state",state_p);   0     autoreset_p = GetResource("autoreset","on");     autoreset_p++;     switch (*autoreset_p)      { 
 	case 'f': 	case 'F':   /* off */ 	    AutoReset = FALSE; break;
 	case 'n': 	case 'N':   /* on */  	    AutoReset = TRUE;  break;	 	default:  	    autoreset_p--; 4 	    printf("invalid autoreset: %s\n", autoreset_p); 	    CleanUp(0); 	    exit(20);     }      autoreset_p--;/     PutStringResource("autoreset",autoreset_p);   6     orientation_p = GetResource("orientation","left");     switch (*orientation_p)      { 
 	case 'l':
 	case 'L':' 	    screenOrientation = K_Left; break; 
 	case 'r':
 	case 'R':( 	    screenOrientation = K_Right; break;
 	case 't':
 	case 'T':& 	    screenOrientation = K_Top; break;
 	case 'b':
 	case 'B':) 	    screenOrientation = K_Bottom; break; 	 	default: ? 	    printf("invalid screen orientation: %s\n", orientation_p);  	    CleanUp(0); 	    exit(20);     } 3     PutStringResource("orientation",orientation_p);        ReadOdometer();        /* Top level details */ 
     n = 0;4     XtSetArg(args[n],XtNallowShellResize,TRUE); n++;6     sprintf(geombuff,"%s",GetResource("geometry",""));1     XParseGeometry(geombuff, &gx, &gy, &gw, &gh); +     PutStringResource("geometry",geombuff); #     XtSetArg(args[n],XmNx,gx); n++; #     XtSetArg(args[n],XmNy,gy); n++; '     XtSetArg(args[n],XmNwidth,gw); n++; (     XtSetArg(args[n],XmNheight,gh); n++;6     XtSetArg(args[n],XtNiconPixmap, icon_pixmap); n++;#     if (ResourcePresent("iconic"))       { ' 	XtSetArg(args[n],XtNiconic,TRUE); n++;      } 1     XtSetArg(args[n],XmNiconName, progName); n++; 9     sprintf(windowTitle, "%s %s", progName, progVersion); 2     XtSetArg(args[n],XmNtitle, windowTitle);  n++;X     decor = MWM_DECOR_BORDER | MWM_DECOR_RESIZEH | MWM_DECOR_TITLE | MWM_DECOR_MINIMIZE;5     XtSetArg(args[n], XmNmwmDecorations, decor); n++; C     XtSetArg(args[n], XtNinput, FALSE); n++; /* Don't grab focus */ "     XtSetValues(TopLevel,&args,n);        /* Create the main window */
     n = 0;%     XtSetArg(args[n], XmNx, gx); n++; %     XtSetArg(args[n], XmNy, gy); n++; )     XtSetArg(args[n], XmNwidth, gw); n++; *     XtSetArg(args[n], XmNheight, gh); n++;A     MainWindow = XmCreateMainWindow(TopLevel, progName, args, n);      XtManageChild(MainWindow);  -     /* Create a dialog box to hold a label */ 
     n = 0;6     XtSetArg(args[n], XmNdefaultPosition, False); n++;?     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_WORK_AREA); n++; A     MainDialog = XmCreateForm(MainWindow, "MainDialog", args, n);      XtManageChild(MainDialog);  +     /* Create a label for odometer value */ 
     n = 0;     if (Enabled)     {  	if (UseKilometers) / 	    sprintf(distance_s, "%.5f", Distance*1.6);  	else + 	    sprintf(distance_s, "%.5f", Distance); ] 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate(distance_s, XmSTRING_DEFAULT_CHARSET));      }      else[ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("------", XmSTRING_DEFAULT_CHARSET));      n++;2     XtSetArg(args[n], XmNfontList, fontList); n++;:     XtSetArg(args[n], XmNalignment, XmALIGNMENT_END); n++;3     XtSetArg(args[n], XmNrecomputeSize, True); n++; <     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;=     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; H     DistanceLabel = XmCreateLabel(MainDialog, "DistanceLabel", args, n);!     XtManageChild(DistanceLabel);   0     /* Create a label for trip odometer value */
     n = 0;     if (Enabled)\ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("0.00000", XmSTRING_DEFAULT_CHARSET));     else[ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("------", XmSTRING_DEFAULT_CHARSET));      n++;2     XtSetArg(args[n], XmNfontList, fontList); n++;:     XtSetArg(args[n], XmNalignment, XmALIGNMENT_END); n++;3     XtSetArg(args[n], XmNrecomputeSize, True); n++; >     XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;8     XtSetArg(args[n], XmNtopWidget, DistanceLabel); n++;=     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; @     TripLabel = XmCreateLabel(MainDialog, "TripLabel", args, n);     XtManageChild(TripLabel);   E     /* Realize the widget heirarchy, creating and mapping windows. */      XtRealizeWidget(TopLevel);       /* Create Popup menu */   =     puMenu = XmCreatePopupMenu(TopLevel, "popMenu", NULL, 0); L     XtAddEventHandler(TopLevel, ButtonPressMask, False, puPostMenu, puMenu);  1     sprintf(puMenuLabel_s, "%s since", progName); 
     n = 0;@     XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;h     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate(puMenuLabel_s, XmSTRING_DEFAULT_CHARSET)); n++;F     puMenuLabel = XmCreateLabelGadget(puMenu, "puMenuLabel", args, n);     XtManageChild(puMenuLabel);   .     sprintf(puMenuLabel_s, "%s", startDate_s);
     n = 0;:     XtSetArg(args[n], XmNalignment, XmALIGNMENT_END); n++;h     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate(puMenuLabel_s, XmSTRING_DEFAULT_CHARSET)); n++;H     puMenuLabel1 = XmCreateLabelGadget(puMenu, "puMenuLabel1", args, n);      XtManageChild(puMenuLabel1);  <     XtSetArg(args[0], XmNseparatorType, XmSHADOW_ETCHED_IN);C     puSep1 = XmCreateSeparatorGadget(puMenu, "separator", args, 1);      XtManageChild(puSep1);  
     n = 0;     if (Enabled)\ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Disable", XmSTRING_DEFAULT_CHARSET));     else[ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Enable", XmSTRING_DEFAULT_CHARSET));      n++;F     puOnOff = XmCreatePushButtonGadget(puMenu, "pushbutton", args, n);?     XtAddCallback(puOnOff, XmNactivateCallback, OnOffCB, NULL);      XtManageChild(puOnOff);   5     /* Create a push button to reset Trip odometer */ 
     n = 0;h     XtSetArg(args[n], XmNlabelString, XmStringCreateLtoR("Reset Trip" , XmSTRING_DEFAULT_CHARSET)); n++;8     XtSetArg(args[n], XmNaccelerator, "Alt<Key>T"); n++;g     XtSetArg(args[n], XmNacceleratorText, XmStringCreateLtoR("Alt/T" , XmSTRING_DEFAULT_CHARSET)); n++; I     TripButton = XmCreatePushButtonGadget(puMenu, "TripButton", args, n); G     XtAddCallback(TripButton, XmNactivateCallback, TripButtonCB, NULL);      XtManageChild(TripButton);  $     /* Create 'Auto Reset' toggle */
     n = 0;l     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Auto Trip Reset", XmSTRING_DEFAULT_CHARSET)); n++;0     XtSetArg(args[n], XmNvalue, AutoReset); n++;?     XtSetArg(args[n], XmNset, (AutoReset ? True : False)); n++; F     puAuto = XmCreateToggleButtonGadget(puMenu, "AutoReset", args, n);F     XtAddCallback(puAuto, XmNvalueChangedCallback, AutoResetCB, NULL);     XtManageChild(puAuto);  
     n = 0;     if (UseKilometers)_ 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Show miles", XmSTRING_DEFAULT_CHARSET));      elsed 	XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Show kilometers", XmSTRING_DEFAULT_CHARSET));     n++;G     puFormat = XmCreatePushButtonGadget(puMenu, "pushbutton", args, n); E     XtAddCallback(puFormat, XmNactivateCallback, MilesKilosCB, NULL);      XtManageChild(puFormat);  
     n = 0;j     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Save Settings", XmSTRING_DEFAULT_CHARSET)); n++;M     puSaveSettings = XmCreatePushButtonGadget(puMenu, "pushbutton", args, n); M     XtAddCallback(puSaveSettings, XmNactivateCallback, SaveSettingsCB, NULL); "     XtManageChild(puSaveSettings);  <     XtSetArg(args[0], XmNseparatorType, XmSHADOW_ETCHED_IN);B     puSep = XmCreateSeparatorGadget(puMenu, "separator", args, 1);     XtManageChild(puSep);   
     n = 0;a     XtSetArg(args[n], XmNlabelString, XmStringLtoRCreate("Quit", XmSTRING_DEFAULT_CHARSET)); n++; 8     XtSetArg(args[n], XmNaccelerator, "Alt<Key>Q"); n++;g     XtSetArg(args[n], XmNacceleratorText, XmStringCreateLtoR("Alt/Q" , XmSTRING_DEFAULT_CHARSET)); n++; E     puQuit = XmCreatePushButtonGadget(puMenu, "pushbutton", args, n); =     XtAddCallback(puQuit, XmNactivateCallback, QuitCB, NULL);      XtManageChild(puQuit);     2     lastXCoord = lastYCoord = XCoord = YCoord = 0;  2     status = sys$bintim(&interval_d, &interval_q);     SetupTimer(); '     if (AutoReset) SetAutoResetTimer();   &     /* Wait for something to happen */3     XtAppMainLoop(appContext);  /* Never returns */  }    void Usage(argv0) 
 char **argv0;  {      int i = 0;     5     printf("\nUsage:  %s [-option ...]\n\n", *argv0);S*     printf("where -option includes:\n\n");     while (i<optcount-1)     { % 	printf("\t%s\n", options[i].option);  	i++;*     }u     return;m }s   /*/  * Routine to get one resource value, supplyingk   * a default if it's not defined  * c  */  char *GetResource(resrc, def)s char *resrc, *def; {      XrmValue value;      char *reptype;%     char fullname[64], fullclass[64];a     char *ptr;     int up;      #     strcpy(fullname, "xodometer.");      strcat(fullname, resrc);      strcpy(fullclass, fullname);  1     ptr = fullclass;	/* capitalize class name! */      up  = 1;     while (*ptr) {0 	if (up && islower(*ptr)) *ptr = _toupper(*ptr); 	up = *ptr++ == '.'; 	}  B     if (XrmGetResource(db, fullname, fullclass, &reptype, &value)) 	return value.addr ;       if (display) {0 	ptr = XGetDefault(display, "xodometer", resrc); 	if (ptr) return ptr;r 	}       return def;  }J     /*7  * Routine to put a string resource value into databaseo  */p" void PutStringResource(resrc, val) char *resrc, *val; {	     XrmValue value;6     char *reptype;%     char fullname[64], fullclass[64];u     char *ptr;     int up;d     #     strcpy(fullname, "xodometer.");E     strcat(fullname, resrc);      strcpy(fullclass, fullname);  1     ptr = fullclass;	/* capitalize class name! */      up  = 1;     while (*ptr) {0 	if (up && islower(*ptr)) *ptr = _toupper(*ptr); 	up = *ptr++ == '.'; 	}       /* Set the new value */t     value.addr = val;i!     value.size = strlen(val) + 1;<     /* Update the database */i5     XrmPutResource(&db, fullname, XtRString, &value);< }/     /*8  * Routine to put a numeric resource value into database  */u# void PutNumericResource(resrc, val)  char *resrc; int val; {c     XrmValue value;      char *reptype;%     char fullname[64], fullclass[64];e     char *ptr;     int up;o     char tmp[256];     #     strcpy(fullname, "xodometer.");]     strcat(fullname, resrc);      strcpy(fullclass, fullname);  1     ptr = fullclass;	/* capitalize class name! */a     up  = 1;     while (*ptr) {0 	if (up && islower(*ptr)) *ptr = _toupper(*ptr); 	up = *ptr++ == '.'; 	}       tmp[0] = '\0';     sprintf(tmp, "%d", val);     /* Set the new value */      value.addr = tmp;t!     value.size = strlen(tmp) + 1;t     /* Update the database */l5     XrmPutResource(&db, fullname, XtRString, &value);  }      /*&  * Routine to see if resource present.  */i int ResourcePresent(resrc) char *resrc; {t     XrmValue value;t     char *reptype;%     char fullname[64], fullclass[64];a     char *ptr;     int up;t     #     strcpy(fullname, "xodometer.");e     strcat(fullname, resrc);      strcpy(fullclass, fullname);  1     ptr = fullclass;	/* capitalize class name! */      up  = 1;     while (*ptr) {0 	if (up && islower(*ptr)) *ptr = _toupper(*ptr); 	up = *ptr++ == '.'; 	}  B     if (XrmGetResource(db, fullname, fullclass, &reptype, &value)) 	return 1 ;d       if (display) {0 	ptr = XGetDefault(display, "xodometer", resrc); 	if (ptr) return 1;S 	}  
     return 0;u }t   void FindAllScreens()e {p     int i = 0;     int Dh, DhMM, Dw, DwMM;c&     double vPixelsPerMM, hPixelsPerMM;     '     screenCount = ScreenCount(display);t_     if (debug) printf("Display has %d screen%s\n", screenCount, (screenCount == 1 ? "" : "s"));}       while (i < screenCount)g     { % 	if (debug) printf("Screen %d\n", i); - 	screenInfo[i].root = RootWindow(display, i);,2 	screenInfo[i].scr = XScreenOfDisplay(display, i);     ? 	screenInfo[i].height = Dh = HeightOfScreen(screenInfo[i].scr);	, 	DhMM = HeightMMOfScreen(screenInfo[i].scr);= 	screenInfo[i].width = Dw = WidthOfScreen(screenInfo[i].scr); + 	DwMM = WidthMMOfScreen(screenInfo[i].scr);    	if (debug)t 	{: 	    printf("\tHeight is %d pixels (%d mm).\n", Dh, DhMM);9 	    printf("\tWidth is %d pixels (%d mm).\n", Dw, DwMM);" 	} 	t* 	vPixelsPerMM = (double)Dh / (double)DhMM;* 	hPixelsPerMM = (double)Dw / (double)DwMM;A 	screenInfo[i].PixelsPerMM = (vPixelsPerMM + hPixelsPerMM) / 2.0;,   	if (debug)e 	{B 	    printf("\tVertical pixels/mm  are %2.5f mm\n", vPixelsPerMM);C 	    printf("\tHorizontal pixels/mm are %2.5f mm\n", hPixelsPerMM); L 	    printf("\tAverage pixels/mm are %.2f mm\n", screenInfo[i].PixelsPerMM); 	} 	r 	i++;;     }e }f c void SetupTimer()] { 1     $DESCRIPTOR (now, "XX-XXX-XXXX XX:XX:XX.XX");,      int now_bin[2], next_bin[2];     int n, tlen, nlen;     int status;   D     sys$asctim(&nlen, &now, 0, 0);			    /* Get the time/date now */@     sys$bintim(&now, &now_bin);				    /* Convert to quadword */W     lib$add_times(&now_bin, &interval_q, &next_bin);	    /* Add timer interval to it */iX     sys$setimr(0, next_bin, QueryPointer, 0, 0);	    /* Set a timer for that time */     }  d void QueryPointer()h {*     if (Enabled)     { # 	lastPointerScreen = pointerScreen;e 	lastXCoord = XCoord;T 	lastYCoord = YCoord;t@ 	XQueryPointer (display, root, &RootIDRet, &ChildIDRet, &XCoord,) 		    &YCoord, &WinX, &WinY, &StateMask);O 	if (CalcDistance()) 	{ 	    refresh_window(TRUE); 	    cyclesSinceLastSave++;M 	    if (debug)B] 		printf("Save Freq: %d  Cycles Since Last Save: %d\n", SAVE_FREQUENCY, cyclesSinceLastSave); / 	    if (cyclesSinceLastSave >= SAVE_FREQUENCY)p 		WriteOdometer(); 	}     }        SetupTimer();o }e t void OnOffCB(widget,tag,reason)      Widget widget;     char *tag;      XmAnyCallbackStruct *reason;   {      Arg args[1];     char buf[32];o     (     if (Enabled)		/* then turn it off */     {  	Enabled = FALSE;_ 	sys$cantim(0,0);c 	lastXCoord = lastYCoord = 0;  	strcpy(buf, "Enable");n     } )     else 								   /* turn it back on */      {i 	Enabled = TRUE; 	strcpy(buf, "Disable");     }(  Y     XtSetArg(args[0], XmNlabelString, XmStringLtoRCreate(buf, XmSTRING_DEFAULT_CHARSET));x#     XtSetValues(puOnOff, &args, 1);e     refresh_window(Enabled);     if (Enabled) 	SetupTimer();     else 	WriteOdometer();( }o e$ void MilesKilosCB(widget,tag,reason)     Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {      Arg args[1];     char buf[32];a  ,     if (UseKilometers)	/* switch to miles */     {  	UseKilometers = FALSE;R  	strcpy(buf, "Show kilometers");     }      else     {  	UseKilometers = TRUE; 	strcpy(buf, "Show miles");c     } Y     XtSetArg(args[0], XmNlabelString, XmStringLtoRCreate(buf, XmSTRING_DEFAULT_CHARSET));N$     XtSetValues(puFormat, &args, 1);     refresh_window(Enabled); }  o$ void TripButtonCB(widget,tag,reason)     Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {e     TripDistance = 0.0;      refresh_window(Enabled); }  o void SetAutoResetTimer() {d'     $DESCRIPTOR (tomorrow, "TOMORROW");s     int tomorrow_bin[2];^     int	flags = 121;	/* Flags for convert_date_string; default all time fields and the year */     int status;u     P     status = lib$convert_date_string(&tomorrow, &tomorrow_bin, 0, &flags, 0, 0);7 /*    status = sys$bintim(&tomorrow, &tomorrow_bin); */e      if (debug & (!(status & 1))) 	lib$signal(status);?     status = sys$setimr ( 0, tomorrow_bin, AutoResetAST, 1, 0);g      if (debug & (!(status & 1))) 	lib$signal(status); }   # void AutoResetCB(widget,tag,reason)      Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {      int status;i       if (AutoReset)     {e%         status = sys$cantim ( 1, 0 );i 	if (debug & (!(status & 1)))\ 	    lib$signal(status); 	AutoReset = FALSE;;     }      else     {s 	AutoReset = TRUE; 	SetAutoResetTimer();      }u          if (debug)J 	printf("AutoResetCB: Auto Reset %sabled.\n", (AutoReset ? "En" : "Dis"));      }    void AutoResetAST(); {c     TripDistance = 0.0;      refresh_window(Enabled);     SetAutoResetTimer(); }e -- static void SaveSettingsCB(widget,tag,reason);     Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {R     char geom[25];
     int n;     Position x, y;     Dimension w, h;o     Arg args[MAXARGS];  
     n = 0;%     XtSetArg(args[n], XmNx, &x); n++;s%     XtSetArg(args[n], XmNy, &y); n++;L)     XtSetArg(args[n], XmNwidth, &w); n++;**     XtSetArg(args[n], XmNheight, &h); n++;$     XtGetValues(TopLevel, &args, n);-     sprintf(geom, "%dx%d+%d+%d", w, h, x, y);C(     PutStringResource("geometry", geom);       if (UseKilometers)* 	PutStringResource("format","kilometers");     else% 	PutStringResource("format","miles");;       if (Enabled)! 	PutStringResource("state","on");s     else" 	PutStringResource("state","off"); 	      switch (screenOrientation)     {n> 	case K_Left : PutStringResource("orientation","left"); break;@ 	case K_Right : PutStringResource("orientation","right"); break;< 	case K_Top : PutStringResource("orientation","top"); break;B 	case K_Bottom : PutStringResource("orientation","bottom"); break;     };       if (AutoReset)% 	PutStringResource("autoreset","on");      else& 	PutStringResource("autoreset","off");     (     PutStringResource("font", fontName);  %     XrmPutFileDatabase(db, DEFAULTS);m     return;R }u ( /*2  * Delete resource database and purge working set   */  void CleanUp(int saveOdometer) {e     long inadr[2];     int status;]       inadr[0] = 0x00000000;     inadr[1] = 0x7fffffff;  
     if (db) {]         XrmFreeDatabase(db);         db = NULL;     }   '     if (display!=NULL && display->db) {c 	XrmFreeDatabase(display->db); 	display->db = NULL;     }        status = sys$purgws(inadr);;0     if ((status&1)==0) printf("purge failed\n");       if (saveOdometer)i 	WriteOdometer();s   }    a void QuitCB(widget,tag,reason)     Widget widget;     char *tag;      XmAnyCallbackStruct *reason; {M     sys$cantim(0, 0);C     CleanUp(1);C     exit(1); }  e( static void  puPostMenu(w, popup, event)     Widget         w;[     Widget         popup;/     XButtonEvent  *event;  {e     int         status;;!     if (event->button != Button3)/         return;   "     XmMenuPosition(puMenu, event);     XtManageChild (puMenu);; }+   refresh_window(int flag) {h     char distance_s[256];a     char trip_s[256]; 
     int n;     Arg args[10];M  
     if (flag)l     {a 	if (UseKilometers)t 	{/ 	    sprintf(distance_s, "%.5f", Distance*1.6);x/ 	    sprintf(trip_s, "%.5f", TripDistance*1.6);g 	} 	elsef 	{+ 	    sprintf(distance_s, "%.5f", Distance); + 	    sprintf(trip_s, "%.5f", TripDistance);  	}     }g     else     {a 	strcpy (distance_s, "------");  	strcpy (trip_s, "------");g     }   `     XtSetArg(args[0], XmNlabelString, XmStringCreateLtoR(distance_s, XmSTRING_DEFAULT_CHARSET));)     XtSetValues(DistanceLabel, &args, 1);c  \     XtSetArg(args[0], XmNlabelString, XmStringCreateLtoR(trip_s, XmSTRING_DEFAULT_CHARSET));%     XtSetValues(TripLabel, &args, 1);I }D U. #define MAX(_a,_b) ((_a) > (_b) ? (_a) : (_b)) int CalcDistance() {S     double dist, sum;"
     int X, Y;U3     double distMM, distInches, distFeet, distMiles;n(     double oldDistance, oldTripDistance;(     double newDistance, newTripDistance;)     int i = 0, j, finalScreen, increment;e     +     if (lastXCoord == 0 && lastYCoord == 0)m 	return FALSE;  5     if (lastXCoord == XCoord && lastYCoord == YCoord)M 	return FALSE; 	n3     /* Figure out which screen the pointer is on */a     if (screenCount > 1) 	while (i < screenCount)) 	    if (RootIDRet == screenInfo[i].root)/ 		break;	 	    else( 		i++;       pointerScreen = i;          /*	 K     **  Adjust XCoord or YCoord for the screen its on, relative to screen 0s     **	and screenOrientation.o     */  F     if (lastPointerScreen != -1 && pointerScreen != lastPointerScreen)     {s 	switch (screenOrientation)A 	{ 	    case K_Left:t 	    case K_Top: 		finalScreen = 0;/ 		j = MAX(pointerScreen,lastPointerScreen) - 1;e 		increment = -1;p 		break; 	    case K_Right: 	    case K_Bottom:g9 		finalScreen = MAX(pointerScreen,lastPointerScreen) - 1;[ 		j = 0; 		increment = 1; 		break; 	} 	  	dor 	{ 	    switch (screenOrientation)T 	    { 		case K_Left: 		case K_Right:r, 		    if (pointerScreen > lastPointerScreen)! 			XCoord += screenInfo[j].width;*
 		    else% 			lastXCoord += screenInfo[j].width;  		    break;
 		case K_Top:= 		case K_Bottom:, 		    if (pointerScreen > lastPointerScreen)" 			YCoord += screenInfo[j].height;
 		    else& 			lastYCoord += screenInfo[j].height; 		    break; 	    } 	    if (j != finalScreen) 		j += increment;a 	} while (j != finalScreen);     };  ,     /* Calculate distance in pixels first */       X = XCoord - lastXCoord;     X = X*X;          Y = YCoord - lastYCoord;     Y = Y*Y;           sum = (double)X + (double)Y;     dist = sqrt(sum);e        /* Convert to millimeters */:     distMM = dist / screenInfo[pointerScreen].PixelsPerMM;       /* Convert to inches */      distInches = distMM * 0.04;i       /* Convert to feet */L!     distFeet = distInches / 12.0;        /* Convert to miles */"     distMiles = distFeet / 5280.0;  #     oldDistance = Distance*10000.0;a     Distance += distMiles;#     newDistance = Distance*10000.0;_  +     oldTripDistance = TripDistance*10000.0;n     TripDistance +=distMiles; +     newTripDistance = TripDistance*10000.0;(  A     if ((unsigned int)oldDistance == (unsigned int)newDistance &&bG         (unsigned int)oldTripDistance == (unsigned int)newTripDistance)r 	return FALSE;     else
 	return TRUE;G }F T void ReadOdometer(); {      int bt;m     struct tm *lt;     static char *month[12] = { 	"Jan", "Feb", "Mar", "Apr", 	"May", "Jun", "Jul", "Aug", 	"Sep", "Oct", "Nov", "Dec"u     };     static char *wday[7] = { 	"Sun", "Mon", "Tue", "Wed", 	"Thu", "Fri", "Sat"     };
     int f;  5     memset (&odometerInfo, 0, sizeof(_odometerInfo));T     ,     f = open (SAVED_ODOMETER, O_RDWR, 0600);     if (f==-1)     { " 	f = creat (SAVED_ODOMETER, 0600); 	if (f==-1)g 	{7 	    printf("can't create file: %s\n", SAVED_ODOMETER);r 	    CleanUp(0);
 	    exit(0);e 	} 	time(&bt);t 	lt = localtime (&bt);2 	memcpy (&odometerInfo.lt, lt, sizeof(struct tm));1 	write (f, &odometerInfo, sizeof(_odometerInfo));      }e     else     {t0 	read (f, &odometerInfo, sizeof(_odometerInfo));" 	Distance = odometerInfo.Odometer;     }e     close (f);  6     sprintf (startDate_s, "%s %s %d 19%d %02d:%02d\n",# 	    wday[odometerInfo.lt.tm_wday],m# 	    month[odometerInfo.lt.tm_mon],+ 	    odometerInfo.lt.tm_mday,B 	    odometerInfo.lt.tm_year,, 	    odometerInfo.lt.tm_hour,u 	    odometerInfo.lt.tm_min);A }R   void WriteOdometer() {e
     int f;  ,     f = open (SAVED_ODOMETER, O_RDWR, 0600);     if (f==-1)     {r1 	printf("can't open file: %s\n", SAVED_ODOMETER);U 	CleanUp(0);	 	exit(0);      }r  =     if (debug) printf("Writing odometer %.5f ...", Distance);X  %     odometerInfo.Odometer = Distance; 4     write (f, &odometerInfo, sizeof(_odometerInfo));     close (f);  #     if (debug) printf("  Done.\n");C          cyclesSinceLastSave = 0; }a