 /*  *  XIMQ  *9  *   Copyright  1991, 1994 Digital Equipment Corporation   *   All rights reserved.   *J  *   Permission to use, copy, modify, and distribute this software and itsQ  *   documentation for any purpose, without fee, and without written agreement is O  *   hereby granted, provided that the above copyright notice and the following :  *   two paragraphs appear in all copies of this software.  *O  *   IN NO EVENT SHALL DIGITAL EQUIPMENT CORPORATION BE LIABLE TO ANY PARTY FOR P  *   DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT7  *   OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION.   *I  *   DIGITAL EQUIPMENT CORPORATION SPECIFICALLY DISCLAIMS ANY WARRANTIES, M  *   INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY N  *   AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER ISP  *   ON AN "AS IS" BASIS, AND DIGITAL EQUIPMENT CORPORATION HAS NO OBLIGATION TOK  *   PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.   *
  * Module:  *  *	FIND_POSITION.C  *  * Abstract:  *J  *      This is a user-mode subroutine that can be used to find the "best"H  *      location for a new window.  The user can specify a compass pointJ  *      where the placement should begin, and select X or Y ordering.  TheJ  *      normal mode searches for unoccluded regions of the screen and thenH  *      gives added value for being near the compass location.  The userG  *      can also provide a associated window that the new window should I  *      appear near.  When the associated window is supplied, some amount M  *      of occlusion is tolerated in the region around the associated window. K  *      This routine will work on both Motif and XUI, and it can be used to J  *      position the new window within the root window - or by supplying aO  *      user window instead of the root, it can be used to position subwindows.   *  * Routine description:   *  *	int/  *	FindBestWindowPosition( display, rootWindow, .  *                              width, height,4  *                              placement, priority,1  *                              xReturn, yReturn, 6  *                              maxDepth, assocWindow)  *  *  display		- display id /  *  root		- id of the window to use as the root A  *  width, height	- width and height of proposed window in pixels P  *  placement           - placement 0 to 9 (X11 values, default = CenterGravity)B  *  priority		- 0 = programmed, 1 = Scan X first, 2 = Scan Y first@  *  x, y		- address of integers to return proposed location into-  *  maxDepth		- recursion limit (default = 3) I  *  assocWindow		- a window that the new window should be near (may be 0)   *
  * Author:  *  *      Fred Kleinsorge   *  *  Creation date:  *  *      April 1991  *  *  Modification history:   *  */  #include <stdio.h> #include <decw$include:Xlib.h> #include <decw$include:Xutil.h>   $ extern int FindBestWindowPosition(); static void BuildWindowMap();    /*H  *  Motif has a border that is about 10 pixels.  So in width there is anG  *  additional 20 pixels in the actual window that will be created.  In H  *  Y there is another 20 pixel or so banner.  So, fudge the window sizeI  *  to allow for decoration when doing placement.  Also, the returned X,Y G  *  placement will be offset to anticipate decoration (since the WM may >  *  place the window at X,Y and let the decoration be -delta).  *  */  #define FUDGEWIDTH 32  #define FUDGEXOFF  16  #define FUDGEHEIGHT 48 #define FUDGEBANNER 32   /*H  *  Control the limit of recursion.  More recursion doesn't buy anythingE  *  unless the number of layered windows is taken into account in the M  *  placement (it is not currently).  You need a depth of at least 3 for XUI, P  *  but 1 is sufficient for Motif (3 doesn't hurt, it just wastes a few cycles).  *  */  #define MAXDEPTH 3   /*K  *  Resolution.  This defines the grid the screen is resolved to.  Too many H  *  and the algorithm is slow, too few and the placement is coarse.  The.  *  higher the number the finer the placement.  *  */  #define XRES 24  #define YRES 16    /*  *  FindBestWindowPosition  *K  *  Find the "best" position for the proposed window using a low-resolution H  *  map of subwindows of the "root" window and the placement informationI  *  supplied.  The placement allows compass direction of where the window H  *  should be located - and the priority indicates a preference in whichK  *  direction the search is done in first (X or Y or let the routine pick). H  *  The "maxDepth" can limit recursion on the search for subwindows (theI  *  default is 3 to allow the routine to work on both XUI and Motif). The G  *  assocWindow provides a "gravity well" window that the window should G  *  appear near if possible.  The normal strategy is to find unoccluded E  *  positions, and there is a bonus value if the position is near the L  *  compass location (and unoccluded) or if supplied, the associated window.I  *  When supplied, the assocWindow will allow "some" occlusion within the B  *  bonus region if there is no unoccluded area within the region.  *  *  display		- display id +  *  root		- id of window to use as the root 7  *  width, height	- width and height of proposed window L  *  placement           - gravity of placement (0-9) default = CenterGravity(  *  gravity		- 0 = default, 1 = X, 2 = Y;  *  x, y		- address of integers to return proposed location +  *  maxDepth		- limit recursion (default 3) B  *  assocWindow		- a window that the proposed window shold be near  *  */ @ int FindBestWindowPosition( Display *display, Window rootWindow,9 			    int width, int height, int placement, int gravity, Y                             int *xReturn, int *yReturn, int maxDepth, Window assocWindow)  {    Window foo, root;    XWindowAttributes wat, bonus; C   int level = 0, i, j, x, y, chunkX, chunkY, windowMap[XRES][YRES], B       xOrder[XRES], yOrder[YRES], widthChunks, heightChunks, maxD,M       proposedX1, proposedX2, proposedY1, proposedY2, suggestedX, suggestedY, F       perfect = 0, best = 0, score = 0, adjustedWidth, adjustedHeight,E       minor, major, priority = 0, bonusX1, bonusY1, bonusX2, bonusY2, "       bonusValid = 0, nonOccluded;    /* =   *  Set X, Y or let the placement pick it priority on search    *    */3   if ((gravity > 2) || (gravity < 0)) priority = 0;      else priority = gravity;    /* H   *  Set max depth, this is how deep in the structure to look.  NormallyB   *  a very shallow look (1 below the root) is all that is needed.   *    */%   if (maxDepth == 0) maxD = MAXDEPTH;      else maxD = maxDepth;     /* H   *  Get the root window ID.  Note, the "root" could simply be a regularF   *  window - and this call could be to find locations for subwindows.   *    */:   if (rootWindow == 0) root = XDefaultRootWindow(display);     else root = rootWindow;     /* J   *  Fudge the width and height to account for possible window decorations   *    */'   adjustedWidth  = width  + FUDGEWIDTH; (   adjustedHeight = height + FUDGEHEIGHT;    /* >   *  Get the root width and height to set up the clipping area   *    */,   XGetWindowAttributes(display, root, &wat);    /* H   *  Compute the number of bits in each screen chunk for the low-res map   *    */*   chunkX = (wat.width + (XRES-1))  / XRES;*   chunkY = (wat.height + (YRES-1)) / YRES;    /* E   *  Compute the number of chunks in the proposed window (rounded up)    *    */8   widthChunks  = (adjustedWidth  + (chunkX-1)) / chunkX;8   heightChunks = (adjustedHeight + (chunkY-1)) / chunkY;    /* H   *  See if there is a window to place the new window near, and if thereI   *  is, get it's geometry.  To do this, first get the attributes to find I   *  it's width and then translate (0,0) into the root windows coordinate J   *  space, and then translate the width and height (which is +1 off) into   *  the roots space.    *    */   if (assocWindow != 0)      { 9       XGetWindowAttributes(display, assocWindow, &bonus);         /* 5       *  Translate (0,0) to the root coordinate space        *        */;       if (XTranslateCoordinates(display, assocWindow, root, !                             0, 0, 7                             &bonusX1, &bonusY1, &foo))  	         {           /* F           *  If it translated above, the window is on the same screen,B           *  Now, translate the width and height to get X2 and Y2.           *            */;           XTranslateCoordinates(display, assocWindow, root, >                                 bonus.width-1, bonus.height-1,:                                 &bonusX2, &bonusY2, &foo);            /* O           *  Turn the coordinates into chunk coordinates.  The region for bonus Q           *  points is 1.5 times the width or height of the requested window that -           *  surrounds the associated window.            * .           *    +---------------------------+ -N           *    |        Bonus Region       |  1.5 x height of requested window.           *    |    +-----------------+    | -,           *    |    |   assocWindow   |    |,           *    |    |                 |    |,           *    |    |                 |    |,           *    |    +-----------------+    |,           *    |                           |,           *    +---------------------------+,           *                           !    !J           *                              + 1.5 x width of requested window           *            */\           bonusX2  = (bonusX2 + (chunkX-1) + (adjustedWidth + (adjustedWidth/2)))  / chunkX;O           bonusX1  = (bonusX1 - (adjustedWidth + (adjustedWidth/2)))  / chunkX; ^           bonusY2  = (bonusY2 + (chunkY-1) + (adjustedHeight + (adjustedHeight/2)))  / chunkY;Q           bonusY1  = (bonusY1 - (adjustedHeight + (adjustedHeight/2)))  / chunkY;             /* 1           *  Clip it to be within the root window            *            */'           if (bonusX1 < 0) bonusX1 = 0; 0           if (bonusX1 >= XRES) bonusX1 = XRES-1;'           if (bonusY1 < 0) bonusY1 = 0; 0           if (bonusY1 >= YRES) bonusY1 = YRES-1;'           if (bonusX2 < 0) bonusX2 = 0; 0           if (bonusX2 >= XRES) bonusX2 = XRES-1;'           if (bonusY2 < 0) bonusY2 = 0; 0           if (bonusY2 >= YRES) bonusY2 = YRES-1;            /*            *  The bonus is valid            *            */           bonusValid = 1;   	         }      }     /* J   *  Clear the window map array.  This array is a map of what parts of the   *  root are occluded.    *    */   for (i = 0; i < YRES; i += 1)      { #       for (j = 0; j < XRES; j += 1) 	         {            windowMap[j][i] = 0;	         }      }     /* H   *  Set up the ordered list of the screen sections to search for a freeB   *  area.  This routine uses the ...Gravity symbols to select theI   *  pattern.  The default is a center-out search, the north, south, east E   *  and west patterns vary the search to use top-bottom, bottom-top, 4   *  left-right, right-left search patterns as well.   * ,   *  0 = CenterGravity (default, equiv to 5)   *  1 = NorthWestGravity 1   *  2 = NorthGravity               1     2     3    *  3 = NorthEastGravity 1   *  4 = WestGravity                4     5     6    *  5 = CenterGravity1   *  6 = EastGravity                7     8     9    *  7 = SouthWestGravity    *  8 = SouthGravity    *  9 = SouthEastGravity    *    */   switch (placement)     {          case NorthWestGravity:  %         for (i = 0; i < XRES; i += 1)            {              xOrder[i] = i;           }   %         for (i = 0; i < YRES; i += 1)            {              yOrder[i] = i;           }   (         if (priority == 0) priority = 1;  	        /* <         *  Add a bonus if located in the top-left 1/3 of the8         *  screen unless there is already a gravity well         *  established. 	         *          *  +-----+-----+-----+         *  |     |           |         *  |     |           |         *  +-----+           +         *  |                 |         *  |                 |         *  +                 +         *  |                 |         *  |                 |         *  +-----+-----+-----+
         */         if (!bonusValid)           {              bonusX1 = 0;             bonusY1 = 0;             bonusX2 = XRES/3;              bonusY2 = YRES/3;              bonusValid = 1;            }            break;         case NorthGravity:  %         for (i = 0; i < XRES; i += 1)            { 2             if (i & 1) xOrder[i] = (XRES/2)+(i/2);2               else xOrder[i] = ((XRES/2)-1)-(i/2);           }   %         for (i = 0; i < YRES; i += 1)            {              yOrder[i] = i;           }   (         if (priority == 0) priority = 1;  	        /* 7         *  Add a bonus if located in the top 1/3 of the 8         *  screen unless there is already a gravity well         *  established. 	         *          *  +-----+-----+-----+         *  |                 |         *  |                 |         *  +-----------------+         *  |                 |         *  |                 |         *  +                 +         *  |                 |         *  |                 |         *  +-----+-----+-----+	         * 
         */         if (!bonusValid)           {              bonusX1 = 0;             bonusY1 = 0;             bonusX2 = XRES-1;              bonusY2 = YRES/3;              bonusValid = 1;            }            break;         case NorthEastGravity:  %         for (i = 0; i < XRES; i += 1)            { %             xOrder[i] = (XRES-1) - i;            }   %         for (i = 0; i < YRES; i += 1)            {              yOrder[i] = i;           }   (         if (priority == 0) priority = 1;  	        /* =         *  Add a bonus if located in the top-right 1/3 of the 8         *  screen unless there is already a gravity well         *  established. 	         *          *  +-----+-----+-----+         *  |           |     |         *  |           |     |         *  +           +-----+         *  |                 |         *  |                 |         *  +                 +         *  |                 |         *  |                 |         *  +-----+-----+-----+	         * 
         */         if (!bonusValid)           {              bonusX1 = XRES/3;              bonusY1 = 0;             bonusX2 = XRES-1;              bonusY2 = YRES/3;              bonusValid = 1;            }            break;         case WestGravity:   %         for (i = 0; i < XRES; i += 1)            {              xOrder[i] = i;           }   %         for (i = 0; i < YRES; i += 1)            { 2             if (i & 1) yOrder[i] = (YRES/2)+(i/2);2               else yOrder[i] = ((YRES/2)-1)-(i/2);           }   (         if (priority == 0) priority = 2;  	        /* 8         *  Add a bonus if located in the left 1/3 of the8         *  screen unless there is already a gravity well         *  established. 	         *          *  +-----+-----+-----+         *  |     |           |         *  |     |           |         *  +     |           +         *  |     |           |         *  |     |           |         *  +     |           +         *  |     |           |         *  |     |           |         *  +-----+-----+-----+	         * 
         */         if (!bonusValid)           {              bonusX1 = 0;             bonusY1 = 0;             bonusX2 = XRES/3;              bonusY2 = YRES-1;              bonusValid = 1;            }            break;         case EastGravity:   %         for (i = 0; i < XRES; i += 1)            { %             xOrder[i] = (XRES-1) - i;            }   %         for (i = 0; i < YRES; i += 1)            { 2             if (i & 1) yOrder[i] = (YRES/2)+(i/2);2               else yOrder[i] = ((YRES/2)-1)-(i/2);           }   (         if (priority == 0) priority = 2;  	        /* 9         *  Add a bonus if located in the right 1/3 of the 8         *  screen unless there is already a gravity well         *  established. 	         *          *  +-----+-----+-----+         *  |           |     |         *  |           |     |         *  +           |     +         *  |           |     |         *  |           |     |         *  +           |     +         *  |           |     |         *  |           |     |         *  +-----+-----+-----+	         *i
         */         if (!bonusValid)           {,             bonusX1 = XRES/3;i             bonusY1 = 0;             bonusX2 = XRES-1;t             bonusY2 = YRES-1;              bonusValid = 1;            }s           break;         case SouthWestGravity:  %         for (i = 0; i < XRES; i += 1)            {R             xOrder[i] = i;           }N  %         for (i = 0; i < YRES; i += 1)H           { %             yOrder[i] = (YRES-1) - i;*           }U  (         if (priority == 0) priority = 1;  	        /* ?         *  Add a bonus if located in the bottom-left 1/3 of theE8         *  screen unless there is already a gravity well         *  established.E	         *          *  +-----+-----+-----+         *  |                 |         *  |                 |         *  +                 +         *  |                 |         *  |                 |         *  +-----+           +         *  |     |           |         *  |     |           |         *  +-----+-----+-----+	         *.
         */         if (!bonusValid)           {r             bonusX1 = 0;             bonusY1 = YRES/3;              bonusX2 = XRES/3;h             bonusY2 = YRES-1;e             bonusValid = 1;e           }            break;         case SouthGravity:  %         for (i = 0; i < XRES; i += 1)i           { 2             if (i & 1) xOrder[i] = (XRES/2)+(i/2);2               else xOrder[i] = ((XRES/2)-1)-(i/2);           }i  %         for (i = 0; i < YRES; i += 1)c           { %             yOrder[i] = (YRES-1) - i;h           }I  (         if (priority == 0) priority = 1;  	        /* :         *  Add a bonus if located in the bottom 1/3 of the8         *  screen unless there is already a gravity well         *  established.s	         *          *  +-----+-----+-----+         *  |                 |         *  |                 |         *  +                 +         *  |                 |         *  |                 |         *  +-----------------+         *  |                 |         *  |                 |         *  +-----+-----+-----+	         *w
         */         if (!bonusValid)           {              bonusX1 = 0;             bonusY1 = YRES/3;              bonusX2 = XRES-1;u             bonusY2 = YRES-1;*             bonusValid = 1;            }r           break;         case SouthEastGravity:  %         for (i = 0; i < XRES; i += 1)            {e%             xOrder[i] = (XRES-1) - i;W           }n  %         for (i = 0; i < YRES; i += 1)a           { %             yOrder[i] = (YRES-1) - i;            }a  (         if (priority == 0) priority = 1;  	        /*h@         *  Add a bonus if located in the bottom-right 1/3 of the8         *  screen unless there is already a gravity well         *  established.t	         *l         *  +-----+-----+-----+         *  |                 |         *  |                 |         *  +                 +         *  |                 |         *  |                 |         *  +           +-----+         *  |           |     |         *  |           |     |         *  +-----+-----+-----+	         *n
         */         if (!bonusValid)           {e             bonusX1 = XRES/3;a             bonusY1 = YRES/3;              bonusX2 = XRES-1;G             bonusY2 = YRES-1;1             bonusValid = 1;d           }N           break;         case CenterGravity:n       default:  %         for (i = 0; i < XRES; i += 1)m           {d2             if (i & 1) xOrder[i] = (XRES/2)+(i/2);2               else xOrder[i] = ((XRES/2)-1)-(i/2);           }   %         for (i = 0; i < YRES; i += 1)e           { 2             if (i & 1) yOrder[i] = (YRES/2)+(i/2);2               else yOrder[i] = ((YRES/2)-1)-(i/2);           }r  (         if (priority == 0) priority = 1;  	        /*o:         *  Add a bonus if located in the middle 1/3 of the8         *  screen unless there is already a gravity well         *  established.*	         *i         *  +-----+-----+-----+         *  |                 |         *  |                 |         *  +     +-----+     +         *  |     |     |     |         *  |     |     |     |         *  +     +-----+     +         *  |                 |         *  |                 |         *  +-----+-----+-----+	         *o
         */         if (!bonusValid)           {u             bonusX1 = XRES/3;"             bonusY1 = YRES/3;r"             bonusX2 = bonusX1 * 2;"             bonusY2 = bonusY1 * 2;             bonusValid = 1;*           }            break;       }i    /*a5   *  Walk the window tree and build the occlusion map    *l   */)   BuildWindowMap( display, root, 0, 0, 0,a3                   chunkX, chunkY, maxD, &windowMap, ;                   wat.x, wat.y, wat.width-1, wat.height-1);s    /*dF   *  Now find the best fit.  A "perfect score" is the first completelyE   *  empty area found in our scan using the pattern we built earlier.eE   *  If there is a associated window - then a perfect score is doublesE   *  the normal perfect score.  This means that a unoccluded spot was :   *  found in the bonus area around the associated window.   *C   */   best    = 0;    /*0+   *  Get the score for an unoccluded window    *t   */-   nonOccluded = (heightChunks * widthChunks);i    /*u'   *  If the bonus area is valid, add itw   *    */   if (bonusValid)s     {         /**<       *  A perfect score would be twice the unoccluded score       *	       */        perfect = nonOccluded * 2;     }i   else     perfect = nonOccluded;    /*u   *  Select X or Y precedence    *w   */   if (priority > 1)w     {o       major = XRES;u       minor = YRES;n     }    else     {,       major = YRES;o       minor = XRES;      }d      /*      *  Major     *u     */"     for (i = 0; i < major; i += 1)       {2  	        /*          *  Minor	         *s
         */&         for (j = 0; j < minor; j += 1)           {j
            /* J             *  Propose a location.  Use the ordered search list and locate             *  a rectangle. 
             *t             */             if (priority > 1)s               {/9                 proposedX1 = xOrder[i] - (widthChunks/2); :                 proposedY1 = yOrder[j] - (heightChunks/2);               }              else               {a9                 proposedX1 = xOrder[j] - (widthChunks/2);.:                 proposedY1 = yOrder[i] - (heightChunks/2);               }h  /             if (proposedX1 < 0) proposedX1 = 0; /             if (proposedY1 < 0) proposedY1 = 0;n            o6             proposedX2 = proposedX1 + (widthChunks-1);8             if (proposedX2 >= XRES) proposedX2 = XRES-1;  7             proposedY2 = proposedY1 + (heightChunks-1);a8             if (proposedY2 >= YRES) proposedY2 = YRES-1;               score = 0;  
            /*D7             *  For each unoccluded chunk, score a point 
             *              */9             for (y = proposedY1; y <= proposedY2; y += 1)b               {t=                 for (x = proposedX1; x <= proposedX2; x += 1)n                   {s9                     if (windowMap[x][y] == 0) score += 1;;                   }g               }             
            /*t.             *  Now, try to localize the window
             *              */             if (bonusValid)n               { $                 int xx = proposedX1;$                 int yy = proposedY1;                  /*o!                 *  Trivial rejectt                 *i                 */.                 if ((proposedX1 > bonusX2)  ||.                     (proposedY1 > bonusY2)  ||.                     (proposedX2 < bonusX1)  ||+                     (proposedY2 < bonusY1))n                   {a                   }f                 else                   {d                    /*sA                     *  Intersect the window with the bonus regiono                     *                      */C                     if (bonusX1 > proposedX1) proposedX1 = bonusX1; C                     if (bonusY1 > proposedY1) proposedY1 = bonusY1; C                     if (bonusX2 < proposedX2) proposedX2 = bonusX2;vC                     if (bonusY2 < proposedY2) proposedY2 = bonusY2;                       /*2O                     *  If this is a real window, then add 1 for each block thatsO                     *  intersects and is unoccluded (a strong relationship that Q                     *  allows "some" overlap) - if it is synthetic then the bonus Q                     *  only counts if there is no occlusion, and it is only worth P                     *  1 point (a weak relationship that encourages no overlap).                     *c                     */)                     if (assocWindow != 0)-                       {|                        /*|I                         *  For each unoccluded chunk of the bonus region, (                         *  score a point                         *|                         */E                         for (y = proposedY1; y <= proposedY2; y += 1)-                           { I                             for (x = proposedX1; x <= proposedX2; x += 1)-                               { E                                 if (windowMap[x][y] == 0) score += 1;d                               } &                           }                                  }d                     else;                       if (score >= nonOccluded) score += 1;W                     })                  proposedX1 = xx;                  proposedY1 = yy;               }t  
            /*cA             *  Remember the high score as it's suggested locationH
             *h             */             if (score > best)                {t                 best = score; (                 suggestedX = proposedX1;(                 suggestedY = proposedY1;               }   (             if (score == perfect) break;             }   	        /*s:         *  Exit from the loop if we detect a perfect score	         *o
         */$         if (score == perfect) break;         }b    /*=   *  Now return the suggestion   *b   *//   *xReturn = (suggestedX * chunkX) + FUDGEXOFF;s1   *yReturn = (suggestedY * chunkY) + FUDGEBANNER;o    /*d4   *  Return the score, in case someone is interested   *    */   return (score);  }a f /*;  *  void BuildWindowMap(display, window, level, xOff, yOff,i<  *                      chunkX, chunkY, maxDepth, windowMap,7  *                      clipX1, clipY1, clipX2, clipY2)   *L  *  Build a map representing the occupied portions of the root window.  This3  *  procedure is recursive to a programmable depth.G  *  *  display			- display ID)  *  window			- window ID of current levela'  *  level			- how deep we currently ares5  *  XOff, YOff			- Accumulated offset from root (0,0)p>  *  chunkX, chunkY		- number of bits for window map resolution.  *  maxDepth			- How deep can the recursion go-  *  windowMap			- Address of window map array ,  *  clip..			- Bounds to clip window against  *  */ 7 void BuildWindowMap(display, window, level, xOff, yOff, 8                     chunkX, chunkY, maxDepth, windowMap,3                     clipX1, clipY1, clipX2, clipY2)u   Display *display;S   Window window;I   int level, xOff, yOff, chunkX, chunkY, maxDepth, windowMap[XRES][YRES];    { !   Window root, parent, *children; 4   int nchildren, x, x1, x2, y, y1, y2, w, h, weight;   XWindowAttributes wat;       {=        /* )       *  Get information about the window        *        */2       XGetWindowAttributes(display, window, &wat);        /*n        *  Ignore unmapped windows       *        */&       if (wat.map_state == IsUnmapped)	         {            return; 	         }         /*+@       *  Get actual x and y positions by accumulating the offset       *  from the root.        *+       */       x = wat.x + xOff;        y = wat.y + yOff;        w = x + wat.width;       h = y + wat.height;           /* D       *  Do a trivial reject for windows that are not on the screen.       *        */H       if ( (w < clipX1) || (h < clipY1) || (x > clipX2) || (y > clipY2))	         { <           return; /* Window is not in the clipping bounds */	         }         /*V8       *  Compute intersection of the clip and the window       *t       */!       if (w > clipX2) w = clipX2; !       if (h > clipY2) h = clipY2;)!       if (x < clipX1) x = clipX1; !       if (y < clipY1) y = clipY1;1        /* +       *  Find the windows children (if any)        *        */I       XQueryTree(display, window, &root, &parent, &children, &nchildren);i        /* M       *  If this isn't the root, then build the screen map of window coverage        *        */       if (window != root)l	         {              x1 = x / chunkX;           y1 = y / chunkY;           x2 = w / chunkX;           y2 = h / chunkY;            /* H           *  If the window covers the entire area - ignore it.  It meansD           *  that there is complete occlusion.  So why bother.  This1           *  handles the XUI pseudo-root as well.            *+           */B 	  if ((x1 != 0) || (x2 != XRES-1) || (y1 != 0) || (y2 != YRES-1))
             { +               for (h = y1; h <= y2; h += 1)                  { /                   for (w = x1; w <= x2; w += 1)1                     { +                       windowMap[w][h] += 1;                      }                  } 
             } 	         }r        /*-G       *  Recurse for each child until the max depth is reached or there        *  are no more children.       *        */       if (nchildren)	         {            register int i; !           register Window *child;p            /*h$           *  Recurse for every child           *v           */"           if (level+1 <= maxDepth)F             for (i = 0, child = children; i < nchildren; ++i, ++child)               { A                   BuildWindowMap(display, *child, level+1, x, y,  C                                chunkX, chunkY, maxDepth, windowMap, ?                                clipX1, clipY1, clipX2, clipY2);                }-            /* I           *  The query allocates a chunk of memory that needs to be freed            *            */           XFree(children);        }     }    } 