N /*****************************************************************************' Table 13-3: Commands for CD-ROM Devices N ******************************************************************************2                                          OperationF         Command Name                        Code       Type    SectionN *****************************************************************************/N #define SCSI_CHANGE_DEFINITION              0x40    /*  O      7.2.1        */N #define SCSI_COMPARE                        0x39    /*  O      7.2.2        */N #define SCSI_COPY                           0x18    /*  O      7.2.3        */N #define SCSI_COPY_AND_VERIFY                0x3A    /*  O      7.2.4        */N #define SCSI_INQUIRY                        0x12    /*  M      7.2.5        */N #define SCSI_LOCK_UNLOCK_CACHE              0x36    /*  O      8.2.2        */N #define SCSI_LOG_SELECT                     0x4C    /*  O      7.2.6        */N #define SCSI_LOG_SENSE                      0x4D    /*  O      7.2.7        */N #define SCSI_MODE_SELECT_6                  0x15    /*  O      7.2.8        */N #define SCSI_MODE_SELECT_10                 0x55    /*  O      7.2.9        */N #define SCSI_MODE_SENSE_6                   0x1A    /*  O      7.2.10       */N #define SCSI_MODE_SENSE_10                  0x5A    /*  O      7.2.11       */N #define SCSI_PAUSE_RESUME                   0x4B    /*  O     13.2.1        */N #define SCSI_PLAY_AUDIO_10                  0x45    /*  O*    13.2.2        */N #define SCSI_PLAY_AUDIO_12                  0xA5    /*  O*    13.2.3        */N #define SCSI_PLAY_AUDIO_MSF                 0x47    /*  O*    13.2.4        */N #define SCSI_PLAY_AUDIO_TRACK_INDEX         0x48    /*  O*    13.2.5        */N #define SCSI_PLAY_TRACK_RELATIVE_10         0x49    /*  O*    13.2.6        */N #define SCSI_PLAY_TRACK_RELATIVE_12         0xA9    /*  O*    13.2.7        */N #define SCSI_PRE_FETCH                      0x34    /*  O      8.2.3        */N #define SCSI_PREVENT_ALLOW_MEDIUM_REMOVAL   0x1E    /*  O      8.2.4        */N #define SCSI_READ_6                         0x08    /*  O      8.2.5        */N #define SCSI_READ_10                        0x28    /*  M      8.2.6        */N #define SCSI_READ_12                        0xA8    /*  O     15.2.4        */N #define SCSI_READ_BUFFER                    0x3C    /*  O      7.2.12       */N #define SCSI_READ_CD_ROM_CAPACITY           0x25    /*  M     13.2.8        */N #define SCSI_READ_HEADER                    0x44    /*  O     13.2.9        */N #define SCSI_READ_LONG                      0x3E    /*  O      8.2.9        */N #define SCSI_READ_SUBCHANNEL                0x42    /*  O     13.2.10       */N #define SCSI_READ_TOC                       0x43    /*  O     13.2.11       */N #define SCSI_RECEIVE_DIAGNOSTIC_RESULTS     0x1C    /*  O      7.2.13       */N #define SCSI_RELEASE                        0x17    /*  M      8.2.11       */N #define SCSI_REQUEST_SENSE                  0x03    /*  M      7.2.14       */N #define SCSI_RESERVE                        0x16    /*  M      8.2.12       */N #define SCSI_REZERO_UNIT                    0x01    /*  O      8.2.13       */N #define SCSI_SEARCH_DATA_EQUAL_10           0x31    /*  O      8.2.14.1     */N #define SCSI_SEARCH_DATA_EQUAL_12           0xB1    /*  O     15.2.8        */N #define SCSI_SEARCH_DATA_HIGH_10            0x30    /*  O      8.2.14.2     */N #define SCSI_SEARCH_DATA_HIGH_12            0xB0    /*  O     15.2.8        */N #define SCSI_SEARCH_DATA_LOW_10             0x32    /*  O      8.2.14.3     */N #define SCSI_SEARCH DATA_LOW_12             0xB2    /*  O     15.2.8        */N #define SCSI_SEEK_6                         0x0B    /*  O      8.2.15       */N #define SCSI_SEEK_10                        0x2B    /*  O      8.2.15       */N #define SCSI_SEND_DIAGNOSTIC                0x1D    /*  M      7.2.15       */N #define SCSI_SET_LIMITS_10                  0x33    /*  O      8.2.16       */N #define SCSI_SET_LIMITS_12                  0xB3    /*  O     15.2.9        */N #define SCSI_START_STOP_UNIT                0x1B    /*  O      8.2.17       */N #define SCSI_SYNCHRONIZE_CACHE              0x35    /*  O      8.2.18       */N #define SCSI_TEST_UNIT_READY                0x00    /*  M      7.2.16       */N #define SCSI_VERIFY_10                      0x2F    /*  O     15.2.11       */N #define SCSI_VERIFY_12                      0xAF    /*  O     15.2.12       */N #define SCSI_WRITE_BUFFER                   0x3B    /*  O      7.2.17       */N /*****************************************************************************1   Key: M  =  Command implementation is mandatory. 0        O  =  Command implementation is optional.K        *  =  If any of the PLAY AUDIO commands (as indicated by an * in the G            'Type' column in Table 13-3) are implemented, the PLAY AUDIO 6            command shall be implemented by the target.N *****************************************************************************/   typedef struct {      unsigned opcode : 8;     unsigned : 1;      unsigned msf : 1;      unsigned : 3;      unsigned lun : 3;      unsigned : 6;      unsigned subq : 1;     unsigned : 1; &     unsigned sub_chan_data_format : 8;     unsigned : 8;      unsigned : 8;      unsigned track_number : 8;%     unsigned char allocation_length1; %     unsigned char allocation_length0;      unsigned control : 8;  } scsi_read_subchannel;    typedef struct {      unsigned opcode : 8;     unsigned immediate : 1;      unsigned : 4;      unsigned lun : 3;      unsigned : 8;      unsigned : 8;      unsigned start : 1;      unsigned load_eject : 1;     unsigned : 6;      unsigned control : 8;  } scsi_start_stop_unit;    typedef struct {      unsigned opcode : 8;     unsigned : 5;      unsigned lun : 3;      unsigned : 8;      unsigned : 8;      unsigned prevent : 1;      unsigned : 7;      unsigned control : 8; $ } scsi_prevent_allow_medium_removal;   typedef struct {      unsigned opcode : 8;*     unsigned enable_vital_product_data: 1;     unsigned : 4;      unsigned lun : 3;      unsigned page_code : 8;      unsigned : 8; $     unsigned char allocation_length;     unsigned control : 8;  } scsi_inquiry;    typedef struct {      unsigned opcode : 8;     unsigned : 5;      unsigned lun : 3;      unsigned : 8;      unsigned : 8; $     unsigned char allocation_length;     unsigned control : 8;  } scsi_request_sense;    typedef struct {      unsigned opcode : 8;     unsigned : 5;      unsigned lun : 3;      unsigned : 8;      unsigned start_m : 8;      unsigned start_s : 8;      unsigned start_f : 8;      unsigned end_m : 8;      unsigned end_s : 8;      unsigned end_f : 8;      unsigned control : 8;  } scsi_play_audio_msf;   typedef struct {      unsigned opcode : 8;     unsigned : 5;      unsigned lun : 3;      unsigned : 8;      unsigned : 8;      unsigned start_track : 8;      unsigned start_index : 8;      unsigned : 8;      unsigned end_track : 8;      unsigned end_index : 8;      unsigned control : 8;  } scsi_play_audio_track_index;   typedef struct {      unsigned opcode : 8;     unsigned : 1;      unsigned msf : 1;      unsigned : 3;      unsigned lun : 3;      unsigned : 8;      unsigned : 8;      unsigned : 8;      unsigned : 8;       unsigned starting_track : 8;$     unsigned allocation_length1 : 8;$     unsigned allocation_length0 : 8;     unsigned control : 8;  } scsi_read_toc;   typedef struct {      unsigned opcode : 8;     unsigned : 3;      unsigned dbd : 1;      unsigned : 1;      unsigned lun : 3;      unsigned page_code : 6;      unsigned pc : 2;     unsigned : 8; #     unsigned allocation_length : 8;      unsigned control : 8;  } scsi_mode_sense_6;   typedef struct {      unsigned opcode : 8;     unsigned : 3;      unsigned dbd : 1;      unsigned : 1;      unsigned lun : 3;      unsigned page_code : 6;      unsigned pc : 2;     unsigned : 8;      unsigned : 8;      unsigned : 8;      unsigned : 8; $     unsigned allocation_length1 : 8;$     unsigned allocation_length0 : 8;     unsigned control : 8;  } scsi_mode_sense_10;    typedef struct {      unsigned opcode : 8;     unsigned sp : 1;     unsigned : 3;      unsigned pf : 1;     unsigned lun : 3;      unsigned : 8;      unsigned : 8; '     unsigned parameter_list_length : 8;      unsigned control : 8;  } scsi_mode_select_6;    typedef struct {      unsigned opcode : 8;     unsigned extent : 1;'     unsigned third_party_device_id : 3;      unsigned third_party : 1;      unsigned lun : 3;       unsigned reservation_id : 8;%     unsigned extent_list_length1 : 8; %     unsigned extent_list_length0 : 8;      unsigned control : 8;  } scsi_reserve;    typedef struct {      unsigned opcode : 8;     unsigned extent : 1;'     unsigned third_party_device_id : 3;      unsigned third_party : 1;      unsigned lun : 3;       unsigned reservation_id : 8;     unsigned : 8;      unsigned : 8;      unsigned control : 8;  } scsi_release;    typedef struct {      unsigned opcode : 8;     unsigned : 5;      unsigned lun : 3;      unsigned : 8;      unsigned : 8;      unsigned : 8;      unsigned control : 8;  } scsi_test_unit_ready;    typedef struct {      unsigned opcode : 8;     unsigned : 5;          unsigned lun : 3;          unsigned : 8;          unsigned : 8;          unsigned : 8;          unsigned : 8;          unsigned : 8;          unsigned : 8;          unsigned resume : 1;     unsigned : 7;          unsigned control : 8;  } scsi_pause_resume;