N /***************************************************************************** I. Numeric Order Codes  L This Appendix contains SCSI-2 additional sense codes and operation codes in C numeric order as a reference.  In the event of a conflict with the  M alphabetical definitions of these codes in Table 7-41 and in the appropriate  I tables of commands in sections 7 through 17, those definitions should be   regarded as correct.O ******************************************************************************/  struct {      unsigned char asc;     unsigned char ascq;      unsigned direct_access : 1; #     unsigned sequential_access : 1;      unsigned printer : 1;      unsigned processor : 1;      unsigned worm : 1;     unsigned cdrom : 1;      unsigned scanner : 1;      unsigned optical : 1;      unsigned media_changer : 1;      unsigned communication : 1;      char *description; } sense_key_info[] =   { 4 /*    asc  ascq  D T L P W R S O M C  Description */I     {0x00, 0x00, 1,1,1,1,1,1,1,1,1,1, "NO ADDITIONAL SENSE INFORMATION"}, ;     {0x00, 0x01, 0,1,0,0,0,0,0,0,0,0, "FILEMARK DETECTED"}, J     {0x00, 0x02, 0,1,0,0,0,0,1,0,0,0, "END-OF-PARTITION/MEDIUM DETECTED"},:     {0x00, 0x03, 0,1,0,0,0,0,0,0,0,0, "SETMARK DETECTED"},P     {0x00, 0x04, 0,1,0,0,0,0,1,0,0,0, "BEGINNING-OF-PARTITION/MEDIUM DETECTED"},>     {0x00, 0x05, 0,1,0,0,0,0,1,0,0,0, "END-OF-DATA DETECTED"},@     {0x00, 0x06, 1,1,1,1,1,1,1,1,1,1, "I/O PROCESS TERMINATED"},J     {0x00, 0x11, 0,0,0,0,0,1,0,0,0,0, "AUDIO PLAY OPERATION IN PROGRESS"},E     {0x00, 0x12, 0,0,0,0,0,1,0,0,0,0, "AUDIO PLAY OPERATION PAUSED"}, U     {0x00, 0x13, 0,0,0,0,0,1,0,0,0,0, "AUDIO PLAY OPERATION SUCCESSFULLY COMPLETED"}, S     {0x00, 0x14, 0,0,0,0,0,1,0,0,0,0, "AUDIO PLAY OPERATION STOPPED DUE TO ERROR"}, K     {0x00, 0x15, 0,0,0,0,0,1,0,0,0,0, "NO CURRENT AUDIO STATUS TO RETURN"}, @     {0x01, 0x00, 1,0,0,0,1,0,0,1,0,0, "NO INDEX/SECTOR SIGNAL"},:     {0x02, 0x00, 1,0,0,0,1,1,0,1,1,0, "NO SEEK COMPLETE"},G     {0x03, 0x00, 1,1,1,0,1,0,1,1,0,0, "PERIPHERAL DEVICE WRITE FAULT"}, :     {0x03, 0x01, 0,1,0,0,0,0,0,0,0,0, "NO WRITE CURRENT"},@     {0x03, 0x02, 0,1,0,0,0,0,0,0,0,0, "EXCESSIVE WRITE ERRORS"},V     {0x04, 0x00, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT NOT READY, CAUSE NOT REPORTABLE"},V     {0x04, 0x01, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT IS IN PROCESS OF BECOMING READY"},_     {0x04, 0x02, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT NOT READY, INITIALIZING COMMAND REQUIRED"}, ^     {0x04, 0x03, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT NOT READY, MANUAL INTERVENTION REQUIRED"},T     {0x04, 0x04, 1,1,1,0,0,0,0,1,0,0, "LOGICAL UNIT NOT READY, FORMAT IN PROGRESS"},T     {0x05, 0x00, 1,1,1,0,1,1,1,1,1,1, "LOGICAL UNIT DOES NOT RESPOND TO SELECTION"},E     {0x06, 0x00, 1,0,0,0,1,1,0,1,1,0, "NO REFERENCE POSITION FOUND"}, N     {0x07, 0x00, 1,1,1,0,1,1,1,1,1,0, "MULTIPLE PERIPHERAL DEVICES SELECTED"},L     {0x08, 0x00, 1,1,1,0,1,1,1,1,1,1, "LOGICAL UNIT COMMUNICATION FAILURE"},M     {0x08, 0x01, 1,1,1,0,1,1,1,1,1,1, "LOGICAL UNIT COMMUNICATION TIME-OUT"}, Q     {0x08, 0x02, 1,1,1,0,1,1,1,1,1,1, "LOGICAL UNIT COMMUNICATION PARITY ERROR"}, ?     {0x09, 0x00, 1,1,0,0,1,1,0,1,0,0, "TRACK FOLLOWING ERROR"}, @     {0x09, 0x01, 0,0,0,0,1,1,0,1,0,0, "TRACKING SERVO FAILURE"},=     {0x09, 0x02, 0,0,0,0,1,1,0,1,0,0, "FOCUS SERVO FAILURE"}, ?     {0x09, 0x03, 0,0,0,0,1,1,0,1,0,0, "SPINDLE SERVO FAILURE"}, <     {0x0A, 0x00, 1,1,1,1,1,1,1,1,1,1, "ERROR LOG OVERFLOW"},*     {0x0B, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},5     {0x0C, 0x00, 0,1,0,0,0,0,1,0,0,0, "WRITE ERROR"}, V     {0x0C, 0x01, 1,0,0,0,1,0,0,1,0,0, "WRITE ERROR RECOVERED WITH AUTO REALLOCATION"},P     {0x0C, 0x02, 1,0,0,0,1,0,0,1,0,0, "WRITE ERROR - AUTO REALLOCATION FAILED"},*     {0x0D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x0E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x0F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},=     {0x10, 0x00, 1,0,0,0,1,0,0,1,0,0, "ID CRC OR ECC ERROR"}, @     {0x11, 0x00, 1,1,0,0,1,1,1,1,0,0, "UNRECOVERED READ ERROR"},@     {0x11, 0x01, 1,1,0,0,1,0,1,1,0,0, "READ RETRIES EXHAUSTED"},C     {0x11, 0x02, 1,1,0,0,1,0,1,1,0,0, "ERROR TOO LONG TO CORRECT"}, >     {0x11, 0x03, 1,1,0,0,1,0,1,1,0,0, "MULTIPLE READ ERRORS"},Y     {0x11, 0x04, 1,0,0,0,1,0,0,1,0,0, "UNRECOVERED READ ERROR - AUTO REALLOCATE FAILED"}, B     {0x11, 0x05, 0,0,0,0,1,1,0,1,0,0, "L-EC UNCORRECTABLE ERROR"},@     {0x11, 0x06, 0,0,0,0,1,1,0,1,0,0, "CIRC UNRECOVERED ERROR"},E     {0x11, 0x07, 0,0,0,0,1,0,0,1,0,0, "DATA RESYCHRONIZATION ERROR"}, ?     {0x11, 0x08, 0,1,0,0,0,0,0,0,0,0, "INCOMPLETE BLOCK READ"}, 6     {0x11, 0x09, 0,1,0,0,0,0,0,0,0,0, "NO GAP FOUND"},<     {0x11, 0x0A, 1,1,0,0,0,0,0,1,0,0, "MISCORRECTED ERROR"},Y     {0x11, 0x0B, 1,0,0,0,1,0,0,1,0,0, "UNRECOVERED READ ERROR - RECOMMEND REASSIGNMENT"}, ]     {0x11, 0x0C, 1,0,0,0,1,0,0,1,0,0, "UNRECOVERED READ ERROR - RECOMMEND REWRITE THE DATA"}, M     {0x12, 0x00, 1,0,0,0,1,0,0,1,0,0, "ADDRESS MARK NOT FOUND FOR ID FIELD"}, O     {0x13, 0x00, 1,0,0,0,1,0,0,1,0,0, "ADDRESS MARK NOT FOUND FOR DATA FIELD"}, C     {0x14, 0x00, 1,1,1,0,1,1,1,1,0,0, "RECORDED ENTITY NOT FOUND"}, :     {0x14, 0x01, 1,1,0,0,1,1,0,1,0,0, "RECORD NOT FOUND"},G     {0x14, 0x02, 0,1,0,0,0,0,0,0,0,0, "FILEMARK OR SETMARK NOT FOUND"}, ?     {0x14, 0x03, 0,1,0,0,0,0,0,0,0,0, "END-OF-DATA NOT FOUND"}, >     {0x14, 0x04, 0,1,0,0,0,0,0,0,0,0, "BLOCK SEQUENCE ERROR"},B     {0x15, 0x00, 1,1,1,0,1,1,1,1,1,0, "RANDOM POSITIONING ERROR"},F     {0x15, 0x01, 1,1,1,0,1,1,1,1,1,0, "MECHANICAL POSITIONING ERROR"},V     {0x15, 0x02, 1,1,0,0,1,1,0,1,0,0, "POSITIONING ERROR DETECTED BY READ OF MEDIUM"},I     {0x16, 0x00, 1,0,0,0,1,0,0,1,0,0, "DATA SYNCHRONIZATION MARK ERROR"}, Y     {0x17, 0x00, 1,1,0,0,1,1,1,1,0,0, "RECOVERED DATA WITH NO ERROR CORRECTION APPLIED"}, E     {0x17, 0x01, 1,1,0,0,1,1,1,1,0,0, "RECOVERED DATA WITH RETRIES"}, R     {0x17, 0x02, 1,1,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH POSITIVE HEAD OFFSET"},R     {0x17, 0x03, 1,1,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH NEGATIVE HEAD OFFSET"},Y     {0x17, 0x04, 0,0,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH RETRIES AND/OR CIRC APPLIED"}, Q     {0x17, 0x05, 1,0,0,0,1,1,0,1,0,0, "RECOVERED DATA USING PREVIOUS SECTOR ID"}, \     {0x17, 0x06, 1,0,0,0,1,0,0,1,0,0, "RECOVERED DATA WITHOUT ECC - DATA AUTO-REALLOCATED"},]     {0x17, 0x07, 1,0,0,0,1,0,0,1,0,0, "RECOVERED DATA WITHOUT ECC - RECOMMEND REASSIGNMENT"}, V     {0x18, 0x00, 1,1,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH ERROR CORRECTION APPLIED"},b     {0x18, 0x01, 1,0,0,0,1,1,0,1,0,0, "RECOVERED DATA WITH ERROR CORRECTION AND RETRIES APPLIED"},P     {0x18, 0x02, 1,0,0,0,1,1,0,1,0,0, "RECOVERED DATA - DATA AUTO-REALLOCATED"},B     {0x18, 0x03, 0,0,0,0,0,1,0,0,0,0, "RECOVERED DATA WITH CIRC"},A     {0x18, 0x04, 0,0,0,0,0,1,0,0,0,0, "RECOVERED DATA WITH LEC"}, Q     {0x18, 0x05, 1,0,0,0,1,1,0,1,0,0, "RECOVERED DATA - RECOMMEND REASSIGNMENT"}, ;     {0x19, 0x00, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST ERROR"}, C     {0x19, 0x01, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST NOT AVAILABLE"}, K     {0x19, 0x02, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST ERROR IN PRIMARY LIST"}, I     {0x19, 0x03, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST ERROR IN GROWN LIST"}, E     {0x1A, 0x00, 1,1,1,1,1,1,1,1,1,1, "PARAMETER LIST LENGTH ERROR"}, I     {0x1B, 0x00, 1,1,1,1,1,1,1,1,1,1, "SYNCHRONOUS DATA TRANSFER ERROR"}, ?     {0x1C, 0x00, 1,0,0,0,0,0,0,1,0,0, "DEFECT LIST NOT FOUND"}, G     {0x1C, 0x01, 1,0,0,0,0,0,0,1,0,0, "PRIMARY DEFECT LIST NOT FOUND"}, E     {0x1C, 0x02, 1,0,0,0,0,0,0,1,0,0, "GROWN DEFECT LIST NOT FOUND"}, L     {0x1D, 0x00, 1,0,0,0,1,0,0,1,0,0, "MISCOMPARE DURING VERIFY OPERATION"},J     {0x1E, 0x00, 1,0,0,0,1,0,0,1,0,0, "RECOVERED ID WITH ECC CORRECTION"},*     {0x1F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},H     {0x20, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID COMMAND OPERATION CODE"},L     {0x21, 0x00, 1,1,0,0,1,1,0,1,1,0, "LOGICAL BLOCK ADDRESS OUT OF RANGE"},A     {0x21, 0x01, 0,0,0,0,0,0,0,0,1,0, "INVALID ELEMENT ADDRESS"}, ^     {0x22, 0x00, 1,0,0,0,0,0,0,0,0,0, "ILLEGAL FUNCTION (SHOULD USE 20 00, 24 00, OR 26 00)"},*     {0x23, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},>     {0x24, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID FIELD IN CDB"},D     {0x25, 0x00, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT NOT SUPPORTED"},I     {0x26, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID FIELD IN PARAMETER LIST"}, A     {0x26, 0x01, 1,1,1,1,1,1,1,1,1,1, "PARAMETER NOT SUPPORTED"}, A     {0x26, 0x02, 1,1,1,1,1,1,1,1,1,1, "PARAMETER VALUE INVALID"}, L     {0x26, 0x03, 1,1,1,1,1,1,1,1,1,1, "THRESHOLD PARAMETERS NOT SUPPORTED"},9     {0x27, 0x00, 1,1,0,0,1,0,0,1,0,0, "WRITE PROTECTED"}, a     {0x28, 0x00, 1,1,1,1,1,1,1,1,1,1, "NOT READY TO READY TRANSITION (MEDIUM MAY HAVE CHANGED)"}, K     {0x28, 0x01, 0,0,0,0,0,0,0,0,1,0, "IMPORT OR EXPORT ELEMENT ACCESSED"}, W     {0x29, 0x00, 1,1,1,1,1,1,1,1,1,1, "POWER ON, RESET, OR BUS DEVICE RESET OCCURRED"}, <     {0x2A, 0x00, 1,1,1,0,1,1,1,1,1,1, "PARAMETERS CHANGED"},A     {0x2A, 0x01, 1,1,1,0,1,1,1,1,1,1, "MODE PARAMETERS CHANGED"}, @     {0x2A, 0x02, 1,1,1,0,1,1,1,1,1,1, "LOG PARAMETERS CHANGED"},Z     {0x2B, 0x00, 1,1,1,1,1,1,1,1,0,1, "COPY CANNOT EXECUTE SINCE HOST CANNOT DISCONNECT"},@     {0x2C, 0x00, 1,1,1,1,1,1,1,1,1,1, "COMMAND SEQUENCE ERROR"},D     {0x2C, 0x01, 0,0,0,0,0,0,1,0,0,0, "TOO MANY WINDOWS SPECIFIED"},R     {0x2C, 0x02, 0,0,0,0,0,0,1,0,0,0, "INVALID COMBINATION OF WINDOWS SPECIFIED"},L     {0x2D, 0x00, 0,1,0,0,0,0,0,0,0,0, "OVERWRITE ERROR ON UPDATE IN PLACE"},*     {0x2E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},O     {0x2F, 0x00, 1,1,1,1,1,1,1,1,1,1, "COMMANDS CLEARED BY ANOTHER INITIATOR"}, G     {0x30, 0x00, 1,1,0,0,1,1,0,1,1,0, "INCOMPATIBLE MEDIUM INSTALLED"}, M     {0x30, 0x01, 1,1,0,0,1,1,0,1,0,0, "CANNOT READ MEDIUM - UNKNOWN FORMAT"}, R     {0x30, 0x02, 1,1,0,0,1,1,0,1,0,0, "CANNOT READ MEDIUM - INCOMPATIBLE FORMAT"},F     {0x30, 0x03, 1,1,0,0,0,0,0,0,0,0, "CLEANING CARTRIDGE INSTALLED"},A     {0x31, 0x00, 1,1,0,0,1,0,0,1,0,0, "MEDIUM FORMAT CORRUPTED"}, ?     {0x31, 0x01, 1,0,1,0,0,0,0,1,0,0, "FORMAT COMMAND FAILED"}, L     {0x32, 0x00, 1,0,0,0,1,0,0,1,0,0, "NO DEFECT SPARE LOCATION AVAILABLE"},D     {0x32, 0x01, 1,0,0,0,1,0,0,1,0,0, "DEFECT LIST UPDATE FAILURE"},;     {0x33, 0x00, 0,1,0,0,0,0,0,0,0,0, "TAPE LENGTH ERROR"}, *     {0x34, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x35, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},G     {0x36, 0x00, 0,0,1,0,0,0,0,0,0,0, "RIBBON, INK, OR TONER FAILURE"}, ;     {0x37, 0x00, 1,1,1,0,1,1,1,1,1,1, "ROUNDED PARAMETER"}, *     {0x38, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},I     {0x39, 0x00, 1,1,1,0,1,1,1,1,1,1, "SAVING PARAMETERS NOT SUPPORTED"}, <     {0x3A, 0x00, 1,1,1,0,1,1,1,1,1,0, "MEDIUM NOT PRESENT"},F     {0x3B, 0x00, 0,1,1,0,0,0,0,0,0,0, "SEQUENTIAL POSITIONING ERROR"},T     {0x3B, 0x01, 0,1,0,0,0,0,0,0,0,0, "TAPE POSITION ERROR AT BEGINNING-OF-MEDIUM"},N     {0x3B, 0x02, 0,1,0,0,0,0,0,0,0,0, "TAPE POSITION ERROR AT END-OF-MEDIUM"},Z     {0x3B, 0x03, 0,0,1,0,0,0,0,0,0,0, "TAPE OR ELECTRONIC VERTICAL FORMS UNIT NOT READY"},6     {0x3B, 0x04, 0,0,1,0,0,0,0,0,0,0, "SLEW FAILURE"},3     {0x3B, 0x05, 0,0,1,0,0,0,0,0,0,0, "PAPER JAM"}, E     {0x3B, 0x06, 0,0,1,0,0,0,0,0,0,0, "FAILED TO SENSE TOP-OF-FORM"}, H     {0x3B, 0x07, 0,0,1,0,0,0,0,0,0,0, "FAILED TO SENSE BOTTOM-OF-FORM"},:     {0x3B, 0x08, 0,1,0,0,0,0,0,0,0,0, "REPOSITION ERROR"},A     {0x3B, 0x09, 0,0,0,0,0,0,1,0,0,0, "READ PAST END OF MEDIUM"}, G     {0x3B, 0x0A, 0,0,0,0,0,0,1,0,0,0, "READ PAST BEGINNING OF MEDIUM"}, E     {0x3B, 0x0B, 0,0,0,0,0,0,1,0,0,0, "POSITION PAST END OF MEDIUM"}, K     {0x3B, 0x0C, 0,0,0,0,0,0,1,0,0,0, "POSITION PAST BEGINNING OF MEDIUM"}, I     {0x3B, 0x0D, 0,0,0,0,0,0,0,0,1,0, "MEDIUM DESTINATION ELEMENT FULL"}, E     {0x3B, 0x0E, 0,0,0,0,0,0,0,0,1,0, "MEDIUM SOURCE ELEMENT EMPTY"}, *     {0x3C, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},J     {0x3D, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID BITS IN IDENTIFY MESSAGE"},R     {0x3E, 0x00, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT HAS NOT SELF-CONFIGURED YET"},R     {0x3F, 0x00, 1,1,1,1,1,1,1,1,1,1, "TARGET OPERATING CONDITIONS HAVE CHANGED"},D     {0x3F, 0x01, 1,1,1,1,1,1,1,1,1,1, "MICROCODE HAS BEEN CHANGED"},F     {0x3F, 0x02, 1,1,1,1,1,1,1,1,1,1, "CHANGED OPERATING DEFINITION"},B     {0x3F, 0x03, 1,1,1,1,1,1,1,1,1,1, "INQUIRY DATA HAS CHANGED"},H     {0x40, 0x00, 1,0,0,0,0,0,0,0,0,0, "RAM FAILURE (SHOULD USE 40 NN)"},V     {0x40, 0x00, 1,1,1,1,1,1,1,1,1,1, "DIAGNOSTIC FAILURE ON COMPONENT NN (80H-FFH)"},N     {0x41, 0x00, 1,0,0,0,0,0,0,0,0,0, "DATA PATH FAILURE (SHOULD USE 40 NN)"},Z     {0x42, 0x00, 1,0,0,0,0,0,0,0,0,0, "POWER-ON OR SELF-TEST FAILURE (SHOULD USE 40 NN)"},7     {0x43, 0x00, 1,1,1,1,1,1,1,1,1,1, "MESSAGE ERROR"}, A     {0x44, 0x00, 1,1,1,1,1,1,1,1,1,1, "INTERNAL TARGET FAILURE"}, D     {0x45, 0x00, 1,1,1,1,1,1,1,1,1,1, "SELECT OR RESELECT FAILURE"},A     {0x46, 0x00, 1,1,1,1,1,1,1,1,1,1, "UNSUCCESSFUL SOFT RESET"}, ;     {0x47, 0x00, 1,1,1,1,1,1,1,1,1,1, "SCSI PARITY ERROR"}, S     {0x48, 0x00, 1,1,1,1,1,1,1,1,1,1, "INITIATOR DETECTED ERROR MESSAGE RECEIVED"}, ?     {0x49, 0x00, 1,1,1,1,1,1,1,1,1,1, "INVALID MESSAGE ERROR"}, =     {0x4A, 0x00, 1,1,1,1,1,1,1,1,1,1, "COMMAND PHASE ERROR"}, :     {0x4B, 0x00, 1,1,1,1,1,1,1,1,1,1, "DATA PHASE ERROR"},P     {0x4C, 0x00, 1,1,1,1,1,1,1,1,1,1, "LOGICAL UNIT FAILED SELF-CONFIGURATION"},*     {0x4D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},G     {0x4E, 0x00, 1,1,1,1,1,1,1,1,1,1, "OVERLAPPED COMMANDS ATTEMPTED"}, *     {0x4F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},<     {0x50, 0x00, 0,1,0,0,0,0,0,0,0,0, "WRITE APPEND ERROR"},E     {0x50, 0x01, 0,1,0,0,0,0,0,0,0,0, "WRITE APPEND POSITION ERROR"}, J     {0x50, 0x02, 0,1,0,0,0,0,0,0,0,0, "POSITION ERROR RELATED TO TIMING"},7     {0x51, 0x00, 0,1,0,0,0,0,0,1,0,0, "ERASE FAILURE"}, 9     {0x52, 0x00, 0,1,0,0,0,0,0,0,0,0, "CARTRIDGE FAULT"}, D     {0x53, 0x00, 1,1,1,0,1,1,1,1,1,0, "MEDIA LOAD OR EJECT FAILED"},=     {0x53, 0x01, 0,1,0,0,0,0,0,0,0,0, "UNLOAD TAPE FAILURE"}, B     {0x53, 0x02, 1,1,0,0,1,1,0,1,1,0, "MEDIUM REMOVAL PREVENTED"},O     {0x54, 0x00, 0,0,0,1,0,0,0,0,0,0, "SCSI TO HOST SYSTEM INTERFACE FAILURE"}, A     {0x55, 0x00, 0,0,0,1,0,0,0,0,0,0, "SYSTEM RESOURCE FAILURE"}, *     {0x56, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},M     {0x57, 0x00, 0,0,0,0,0,1,0,0,0,0, "UNABLE TO RECOVER TABLE-OF-CONTENTS"}, C     {0x58, 0x00, 0,0,0,0,0,0,0,1,0,0, "GENERATION DOES NOT EXIST"}, <     {0x59, 0x00, 0,0,0,0,0,0,0,1,0,0, "UPDATED BLOCK READ"},^     {0x5A, 0x00, 1,1,1,1,1,1,1,1,1,0, "OPERATOR REQUEST OR STATE CHANGE INPUT (UNSPECIFIED)"},I     {0x5A, 0x01, 1,1,0,0,1,1,0,1,1,0, "OPERATOR MEDIUM REMOVAL REQUEST"}, I     {0x5A, 0x02, 1,1,0,0,1,0,0,1,0,0, "OPERATOR SELECTED WRITE PROTECT"}, H     {0x5A, 0x03, 1,1,0,0,1,0,0,1,0,0, "OPERATOR SELECTED WRITE PERMIT"},7     {0x5B, 0x00, 1,1,1,1,1,1,1,1,1,0, "LOG EXCEPTION"}, A     {0x5B, 0x01, 1,1,1,1,1,1,1,1,1,0, "THRESHOLD CONDITION MET"}, @     {0x5B, 0x02, 1,1,1,1,1,1,1,1,1,0, "LOG COUNTER AT MAXIMUM"},B     {0x5B, 0x03, 1,1,1,1,1,1,1,1,1,0, "LOG LIST CODES EXHAUSTED"},;     {0x5C, 0x00, 1,0,0,0,0,0,0,1,0,0, "RPL STATUS CHANGE"}, ?     {0x5C, 0x01, 1,0,0,0,0,0,0,1,0,0, "SPINDLES SYNCHRONIZED"}, C     {0x5C, 0x02, 1,0,0,0,0,0,0,1,0,0, "SPINDLES NOT SYNCHRONIZED"}, *     {0x5D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x5E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x5F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},6     {0x60, 0x00, 0,0,0,0,0,0,1,0,0,0, "LAMP FAILURE"},A     {0x61, 0x00, 0,0,0,0,0,0,1,0,0,0, "VIDEO ACQUISITION ERROR"}, A     {0x61, 0x01, 0,0,0,0,0,0,1,0,0,0, "UNABLE TO ACQUIRE VIDEO"}, 6     {0x61, 0x02, 0,0,0,0,0,0,1,0,0,0, "OUT OF FOCUS"},E     {0x62, 0x00, 0,0,0,0,0,0,1,0,0,0, "SCAN HEAD POSITIONING ERROR"}, T     {0x63, 0x00, 0,0,0,0,0,1,0,0,0,0, "END OF USER AREA ENCOUNTERED ON THIS TRACK"},E     {0x64, 0x00, 0,0,0,0,0,1,0,0,0,0, "ILLEGAL MODE FOR THIS TRACK"}, *     {0x65, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x66, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x67, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x68, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x69, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x6A, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x6B, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x6C, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x6D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x6E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x6F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x70, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x71, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x72, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x73, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x74, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x75, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x76, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x77, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x78, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x79, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x7A, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x7B, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x7C, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x7D, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},*     {0x7E, 0x00, 1,1,1,1,1,1,1,1,1,1, ""},)     {0x7F, 0x00, 1,1,1,1,1,1,1,1,1,1, ""}*C     /**************************************************************d     80 XX     \n%     THROUGH    >     VENDOR SPECIFIC._     FF XX     /        XX 80     \_C     THROUGH    >     VENDOR SPECIFIC QUALIFICATION OF STANDARD ASC.      XX FF     /r?                      ALL CODES NOT SHOWN ARE BLANK OR RESERVED. C     **************************************************************/d };         struct {      unsigned char opcode;s      unsigned char direct_access;$     unsigned char sequential_access;     unsigned char printer;     unsigned char processor;     unsigned char worm;      unsigned char cdrom;     unsigned char scanner;     unsigned char optical;      unsigned char media_changer;      unsigned char communication;     char *description; } opcode_table[] =   {0O /******************************************************************************0 Device Columns M = Mandatory Key:           O = Optional                  V = Vendor unique#                  = Reserved (Blank)0  $    D          = Direct-Access Device(     T         = Sequential-Access Device      L        = Printer Device        P       = Processor Device!        W      = Write-Once DeviceO         R     = CD-ROM DeviceM          S    = Scanner Device%           O   = Optical Memory Device %            M  = Medium Changer Device1$             C = Communication DeviceO ******************************************************************************/SO /* Opcode   D   T   L   P   W   R   S   O   M   C   Description              */0G     {0x00, 'M','M','M','M','M','M','M','M','M','M', "TEST UNIT READY"},0>     {0x01, ' ','M',' ',' ',' ',' ',' ',' ',' ',' ', "REWIND"},C     {0x01, 'O',' ','V',' ','O','O',' ','O','O',' ', "REZERO UNIT"},18     {0x02, 'V','V','V','V','V','V',' ',' ','V',' ', ""},E     {0x03, 'M','M','M','M','M','M','M','M','M','M', "REQUEST SENSE"},C>     {0x04, ' ',' ','O',' ',' ',' ',' ',' ',' ',' ', "FORMAT"},C     {0x04, 'M',' ',' ',' ',' ',' ',' ','O',' ',' ', "FORMAT UNIT"},,I     {0x05, 'V','M','V','V','V','V',' ',' ','V',' ', "READ BLOCK LIMITS"},Q8     {0x06, 'V','V','V','V','V','V',' ',' ','V',' ', ""},Q     {0x07, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "INITIALIZE ELEMENT STATUS"},LG     {0x07, 'O','V','V',' ','O',' ',' ','O','V',' ', "REASSIGN BLOCKS"},1G     {0x08, ' ',' ',' ',' ',' ',' ',' ',' ',' ','M', "GET MESSAGE(06)"},0@     {0x08, 'O','M','V',' ','O','O',' ','O','V',' ', "READ(06)"},?     {0x08, ' ',' ',' ','O',' ',' ',' ',' ',' ',' ', "RECEIVE"},,8     {0x09, 'V','V','V','V','V','V',' ',' ','V',' ', ""},=     {0x0A, ' ',' ','M',' ',' ',' ',' ',' ',' ',' ', "PRINT"}, H     {0x0A, ' ',' ',' ',' ',' ',' ',' ',' ',' ','M', "SEND MESSAGE(06)"},@     {0x0A, ' ',' ',' ','M',' ',' ',' ',' ',' ',' ', "SEND(06)"},A     {0x0A, 'O','M',' ',' ','O',' ',' ','O','V',' ', "WRITE(06)"},S@     {0x0B, 'O',' ',' ',' ','O','O',' ','O','V',' ', "SEEK(06)"},F     {0x0B, ' ',' ','O',' ',' ',' ',' ',' ',' ',' ', "SLEW AND PRINT"},8     {0x0C, 'V','V','V','V','V','V',' ',' ','V',' ', ""},8     {0x0D, 'V','V','V','V','V','V',' ',' ','V',' ', ""},8     {0x0E, 'V','V','V','V','V','V',' ',' ','V',' ', ""},D     {0x0F, 'V','O','V','V','V','V',' ',' ','V',' ', "READ REVERSE"},J     {0x10, ' ',' ','O',' ','O',' ',' ',' ',' ',' ', "SYNCHRONIZE BUFFER"},G     {0x10, 'V','M',' ','V','V','V',' ',' ',' ',' ', "WRITE FILEMARKS"},1=     {0x11, 'V','M','V','V','V','V',' ',' ',' ',' ', "SPACE"}, ?     {0x12, 'M','M','M','M','M','M','M','M','M','M', "INQUIRY"},RB     {0x13, 'V','O','V','V','V','V',' ',' ',' ',' ', "VERIFY(06)"},M     {0x14, 'V','O','O','V','V','V',' ',' ',' ',' ', "RECOVER BUFFERED DATA"},TG     {0x15, 'O','M','O',' ','O','O','O','O','O','O', "MODE SELECT(06)"}, ?     {0x16, 'M',' ',' ',' ','M','M',' ','M','O',' ', "RESERVE"},RD     {0x16, ' ','M','M',' ',' ',' ','M',' ',' ',' ', "RESERVE UNIT"},?     {0x17, 'M',' ',' ',' ','M','M',' ','M','O',' ', "RELEASE"},ND     {0x17, ' ','M','M',' ',' ',' ','M',' ',' ',' ', "RELEASE UNIT"},<     {0x18, 'O','O','O','O','O','O','O','O',' ',' ', "COPY"},=     {0x19, 'V','M','V','V','V','V',' ',' ',' ',' ', "ERASE"}, F     {0x1A, 'O','M','O',' ','O','O','O','O','O','O', "MODE SENSE(06)"},C     {0x1B, ' ','O',' ',' ',' ',' ',' ',' ',' ',' ', "LOAD UNLOAD"}, <     {0x1B, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "SCAN"},B     {0x1B, ' ',' ','O',' ',' ',' ',' ',' ',' ',' ', "STOP PRINT"},G     {0x1B, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "STOP START UNIT"}, R     {0x1C, 'O','O','O','O','O','O','O','O','O','O', "RECEIVE DIAGNOSTIC RESULTS"},G     {0x1D, 'M','M','M','M','M','M','M','M','M','M', "SEND DIAGNOSTIC"}, T     {0x1E, 'O','O',' ',' ','O','O',' ','O','O',' ', "PREVENT ALLOW MEDIUM REMOVAL"},8     {0x1F, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x20, 'V',' ',' ',' ','V','V',' ','V',' ',' ', ""},8     {0x21, 'V',' ',' ',' ','V','V',' ','V',' ',' ', ""},8     {0x22, 'V',' ',' ',' ','V','V',' ','V',' ',' ', ""},8     {0x23, 'V',' ',' ',' ','V','V',' ','V',' ',' ', ""},B     {0x24, 'V',' ',' ',' ','V','V','M',' ',' ',' ', "SET WINDOW"},B     {0x25, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "GET WINDOW"},E     {0x25, 'M',' ',' ',' ','M',' ',' ','M',' ',' ', "READ CAPACITY"},1L     {0x25, ' ',' ',' ',' ',' ','M',' ',' ',' ',' ', "READ CD-ROM CAPACITY"},8     {0x26, 'V',' ',' ',' ','V','V',' ',' ',' ',' ', ""},8     {0x27, 'V',' ',' ',' ','V','V',' ',' ',' ',' ', ""},G     {0x28, ' ',' ',' ',' ',' ',' ',' ',' ',' ','O', "GET MESSAGE(10)"},R@     {0x28, 'M',' ',' ',' ','M','M','M','M',' ',' ', "READ(10)"},G     {0x29, 'V',' ',' ',' ','V','V',' ','O',' ',' ', "READ GENERATION"}, H     {0x2A, ' ',' ',' ',' ',' ',' ',' ',' ',' ','O', "SEND MESSAGE(10)"},@     {0x2A, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "SEND(10)"},A     {0x2A, 'M',' ',' ',' ','M',' ',' ','M',' ',' ', "WRITE(10)"},0>     {0x2B, ' ','O',' ',' ',' ',' ',' ',' ',' ',' ', "LOCATE"},K     {0x2B, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "POSITION TO ELEMENT"},L@     {0x2B, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SEEK(10)"},A     {0x2C, 'V',' ',' ',' ',' ',' ',' ','O',' ',' ', "ERASE(10)"},1J     {0x2D, 'V',' ',' ',' ','O',' ',' ','O',' ',' ', "READ UPDATED BLOCK"},L     {0x2E, 'O',' ',' ',' ','O',' ',' ','O',' ',' ', "WRITE AND VERIFY(10)"},B     {0x2F, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "VERIFY(10)"},L     {0x30, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA HIGH(10)"},G     {0x31, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "OBJECT POSITION"},0M     {0x31, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA EQUAL(10)"}, K     {0x32, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA LOW(10)"}, F     {0x33, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SET LIMITS(10)"},N     {0x34, ' ',' ',' ',' ',' ',' ','O',' ',' ',' ', "GET DATA BUFFER STATUS"},A     {0x34, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "PRE-FETCH"},FE     {0x34, ' ','O',' ',' ',' ',' ',' ',' ',' ',' ', "READ POSITION"},DI     {0x35, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "SYNCHRONIZE CACHE"},CI     {0x36, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "LOCK UNLOCK CACHE"},IL     {0x37, 'O',' ',' ',' ',' ',' ',' ','O',' ',' ', "READ DEFECT DATA(10)"},C     {0x38, ' ',' ',' ',' ','O',' ',' ','O',' ',' ', "MEDIUM SCAN"}, ?     {0x39, 'O','O','O','O','O','O','O','O',' ',' ', "COMPARE"},"G     {0x3A, 'O','O','O','O','O','O','O','O',' ',' ', "COPY AND VERIFY"},AD     {0x3B, 'O','O','O','O','O','O','O','O','O','O', "WRITE BUFFER"},C     {0x3C, 'O','O','O','O','O','O','O','O','O','O', "READ BUFFER"}, D     {0x3D, ' ',' ',' ',' ','O',' ',' ','O',' ',' ', "UPDATE BLOCK"},A     {0x3E, 'O',' ',' ',' ','O','O',' ','O',' ',' ', "READ LONG"},,B     {0x3F, 'O',' ',' ',' ','O',' ',' ','O',' ',' ', "WRITE LONG"},I     {0x40, 'O','O','O','O','O','O','O','O','O','O', "CHANGE DEFINITION"},}B     {0x41, 'O',' ',' ',' ',' ',' ',' ',' ',' ',' ', "WRITE SAME"},H     {0x42, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "READ SUB-CHANNEL"},@     {0x43, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "READ TOC"},C     {0x44, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "READ HEADER"}, F     {0x45, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY AUDIO(10)"},8     {0x46, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},F     {0x47, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY AUDIO MSF"},N     {0x48, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY AUDIO TRACK INDEX"},O     {0x49, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY TRACK RELATIVE(10)"},18     {0x4A, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},D     {0x4B, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PAUSE RESUME"},B     {0x4C, 'O','O','O','O','O','O','O','O','O','O', "LOG SELECT"},A     {0x4D, 'O','O','O','O','O','O','O','O','O','O', "LOG SENSE"},08     {0x4E, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x4F, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x50, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x51, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x52, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x53, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x54, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},G     {0x55, 'O','O','O',' ','O','O','O','O','O','O', "MODE SELECT(10)"},D8     {0x56, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x57, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x58, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x59, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},F     {0x5A, 'O','O','O',' ','O','O','O','O','O','O', "MODE SENSE(10)"},8     {0x5B, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x5C, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x5D, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x5E, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0x5F, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xA0, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xA1, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xA2, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xA3, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xA4, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},C     {0xA5, ' ',' ',' ',' ',' ',' ',' ',' ','M',' ', "MOVE MEDIUM"},1F     {0xA5, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY AUDIO(12)"},G     {0xA6, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "EXCHANGE MEDIUM"},,8     {0xA7, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},G     {0xA8, ' ',' ',' ',' ',' ',' ',' ',' ',' ','O', "GET MESSAGE(12)"},T@     {0xA8, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "READ(12)"},O     {0xA9, ' ',' ',' ',' ',' ','O',' ',' ',' ',' ', "PLAY TRACK RELATIVE(12)"},3H     {0xAA, ' ',' ',' ',' ',' ',' ',' ',' ',' ','O', "SEND MESSAGE(12)"},A     {0xAA, ' ',' ',' ',' ','O',' ',' ','O',' ',' ', "WRITE(12)"}, 8     {0xAB, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},A     {0xAC, ' ',' ',' ',' ',' ',' ',' ','O',' ',' ', "ERASE(12)"}, 8     {0xAD, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},L     {0xAE, ' ',' ',' ',' ','O',' ',' ','O',' ',' ', "WRITE AND VERIFY(12)"},B     {0xAF, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "VERIFY(12)"},L     {0xB0, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA HIGH(12)"},M     {0xB1, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA EQUAL(12)"},PK     {0xB2, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "SEARCH DATA LOW(12)"},1F     {0xB3, ' ',' ',' ',' ','O','O',' ','O',' ',' ', "SET LIMITS(12)"},8     {0xB4, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xB5, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},V     {0xB5, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "REQUEST VOLUME ELEMENT ADDRESS"},8     {0xB6, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},G     {0xB6, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "SEND VOLUME TAG"},DL     {0xB7, ' ',' ',' ',' ',' ',' ',' ','O',' ',' ', "READ DEFECT DATA(12)"},8     {0xB8, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},K     {0xB8, ' ',' ',' ',' ',' ',' ',' ',' ','O',' ', "READ ELEMENT STATUS"},08     {0xB9, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xBA, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xBB, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xBC, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xBD, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},8     {0xBE, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""},7     {0xBF, ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ', ""}  };