 /*       CD_PLAYER Version 0.3      By Joe Meadows  O     Released to the Public Domain. Yep, this means you can do anything with it. O     I'd personally like you to keep this header intact, so that folks can track N     what's happened, who's done what, and so forth, as well as be able to findA     pointers back to where they can get the most current version.   I     The most current version of this program should be available from the H     fileserver at the FHCRC, by sending mail to VMSSERV@FHCRCVAX.bitnet.L     Alternatively, the internet address VMSSERV@SPOCK.FHCRC.ORG should work.L     Within the mail message, you should include the line: "SEND CD.PACKAGE".       Requirements:   K         You need a logical name "DECW$CD_PLAYER" defined to point to the CD A         drive (name borrowed from decw$examples:decw$cdplayer.c).      L         You need a CDrom drive that supports audio. Third party drives whichJ         support the SCSI audio standards should work, but I've only had anH         RRD42 to test with. Hopefully I haven't built in any unnecessary         dependencies.   K         You need DIAGNOSE and PHY_IO privilege. The program could cause the I         SCSI bus to reset or hang. I haven't had any destructive problems M         yet, but it is quite possible. You can INSTALL the program with these J         privileges to make it generally available to non-privileged users.  I         If you are running a version of VMS prior to 5.4, you may need to L         configure your workstation not to autoconfigure the CDROM drive, andK         then configure it manually to use the generic (GK) driver. A sample H         SYCONFIG.COM is included. The key is to set the sysgen parameterM         SCSI_NOAUTO correctly. The unit id and controller determine which bit D         needs to be set to force the drive to not be autoconfigured.M         DKA0 = %x0001, DKA700 = %x0080, DKB0 = %x0100, DKB700 = %x8000, etc..   F         You need Motif, VAX C (hmm, I'll have to GNU'ize this), and of3         course, VAX/VMS (to be alphatized shortly?)        Future directions:  N         Add a balance control. Add a 'mono' control (I believe it's possible).O         Add a database (I'll be using the complete TOC (table of contents) from I         the disk as a key into a database). Add track programming (and/or M         prefered track programming). Shuffle play. Improved resource handling /         (and include customize menu). Add Help.   N         General code cleanup (hey, I'm just [re]learning Motif and SCSI junk).       Modification history: @         June 2, 1992    First release - no warranty of any sort.9         June 7, 1992    A few mods, nothing too exciting. A         Jun. 10, 92     Rename to CD_PLAYER, and general cleanup, D                         include VUE$CD_PLAYER.COM, and CD_PLAYER.DATJ         Jun. 13, 92     More cleanup, rename UIL objects, change behaviourC                         of the lock toggle, improve handling of the 3                         play/resume/stop radio-box. ,         Aug. 28, 92     Initial cut at DB... */   #include <Mrm/MrmAppl.h> #include <Xm/Text.h> #include <X11/Xresource.h>   #include <descrip.h> #include <ctype.h>  ' typedef struct dsc$descriptor_s string; ; #define string_dynamic {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0} $ #define PPTR(x) ((x)->dsc$a_pointer)# #define PLEN(x) ((x)->dsc$w_length) # #define SPTR(x) ((x).dsc$a_pointer) " #define SLEN(x) ((x).dsc$w_length)    * #define MAX(a,b) (((b) > (a)) ? (b) : (a))* #define MIN(a,b) (((b) < (a)) ? (b) : (a))  . #define nFiles(x) (sizeof(x) / sizeof(char *))5 #define nRegs(x) (sizeof(x) / sizeof(MrmRegisterArg))    #define mainWindow 0 #define labelAlbumTitle 1  #define labelAlbumTotalTime 2  #define labelAlbumRemaining 3  #define labelAlbumTotalTracks 4  #define labelSongTitle 5 #define labelSongTotalTime 6 /* #define xxx 7 */  #define arrowLeft 8  #define scaleCurrentTrack 9  #define arrowRight 10  #define listTracks 11  /* #define xxx 12 */ /* #define xxx 13 */! #define labelAlbumCurrentTrack 14  #define sliderTrackTime 15 #define buttonPlay 16  #define buttonResume 17  #define buttonStop 18  #define sliderLabel 19 #define buttonEject 20 #define buttonLock 21  #define sliderVolume 22  #define sliderVolumeLabel 23 #define sliderAlbumTime 24 #define sliderAlbumLabel 25  #define buttonAutoPlay 26  #define buttonAutoEject 27" #define buttonAlbumSliderAction 28! #define buttonSongSliderAction 29 " #define buttonTrackSliderAction 30! #define windowIntervalSelector 31  #define intervalSlider 32  #define intervalSliderLabel 33 #define textAlbumTitle 34  #define button_form 35 #define buttonShufflePlay 36 #define MaxWidgets 37   % static char *gbl_title = "CD Player"; ( static char *gbl_app_name = "Cd_player"; static MrmHierarchy Hierarchy; static MrmCode class; - static Widget topLevel, WidgetId[MaxWidgets];    void     WidgetCreated(),     ChangeTrack(),     ChangeSlider(),      PlayButtonToggled(),     ResumeButtonToggled(),     StopButtonToggled(),     EjectButtonPushed(),     LockButtonToggled(),     volumeDrag(),      volumeChanged(),      update_track_slider_label(),     update_song_slider_label(),       update_album_slider_label(),     AutoPlayButtonToggled(),     AutoEjectButtonToggled(),      AlbumSliderActionToggled(),      SongSliderActionToggled(),     TrackSliderActionToggled(),      update_interval_slider(),      change_interval(),     change_interval_ok(),      change_interval_apply(),     change_interval_cancel(),      ShuffleButtonToggled(),      ExitProc(),      album_title_changed(),     save_customize_settings(),D     /* above routines are UIL callbacks, below are used locally.. */     handle_disk_change(),      handle_display_update();   MrmRegisterArg regvec[] =  { =     {"WidgetCreated",               (caddr_t) WidgetCreated}, ;     {"ChangeTrack",                 (caddr_t) ChangeTrack}, I     {"update_track_slider_label",   (caddr_t) update_track_slider_label}, H     {"update_song_slider_label",    (caddr_t) update_song_slider_label},J     {"update_album_slider_label",   (caddr_t) update_album_slider_label}, A     {"PlayButtonToggled",           (caddr_t) PlayButtonToggled}, C     {"ResumeButtonToggled",         (caddr_t) ResumeButtonToggled}, A     {"StopButtonToggled",           (caddr_t) StopButtonToggled}, A     {"LockButtonToggled",           (caddr_t) LockButtonToggled}, A     {"EjectButtonPushed",           (caddr_t) EjectButtonPushed}, :     {"volumeDrag",                  (caddr_t) volumeDrag},=     {"volumeChanged",               (caddr_t) volumeChanged}, E     {"AutoPlayButtonToggled",       (caddr_t) AutoPlayButtonToggled}, F     {"AutoEjectButtonToggled",      (caddr_t) AutoEjectButtonToggled},H     {"AlbumSliderActionToggled",    (caddr_t) AlbumSliderActionToggled},G     {"SongSliderActionToggled",     (caddr_t) SongSliderActionToggled}, H     {"TrackSliderActionToggled",    (caddr_t) TrackSliderActionToggled},G     {"update_interval_slider",      (caddr_t) update_interval_slider},  ?     {"change_interval",             (caddr_t) change_interval}, B     {"ok_change_interval",          (caddr_t) change_interval_ok},E     {"apply_change_interval",       (caddr_t) change_interval_apply}, F     {"cancel_change_interval",      (caddr_t) change_interval_cancel},D     {"ShuffleButtonToggled",        (caddr_t) ShuffleButtonToggled},C     {"album_title_changed",         (caddr_t) album_title_changed}, G     {"save_customize_settings",     (caddr_t) save_customize_settings}, 7     {"ExitProc",                    (caddr_t) ExitProc}  };   static char media_id[15];     static XtAppContext app_context;  
 static int     gbl_interval_wannabe,      gbl_interval_original,     gbl_interval;    static Boolean     gbl_db_open = 0,     gbl_lock_cd = 0,     gbl_auto_play = 0,     gbl_auto_eject = 0,      gbl_cd_was_playing = 0,      gbl_shuffle_play = 0,       gbl_album_slider_action = 0,     gbl_album_slider_inuse = 0,      gbl_song_slider_action = 0,      gbl_song_slider_inuse = 0,      gbl_track_slider_action = 0,     gbl_track_slider_inuse = 0;     A /* get_value convenience routine (ok, so it should be a macro) */ : void get_value(Widget widget, void *resource, void *value) {      Arg arg;  #     XtSetArg(arg, resource, value); !     XtGetValues(widget, &arg, 1);  }   A /* set_value convenience routine (ok, so it should be a macro) */ : void set_value(Widget widget, void *resource, void *value) {      Arg arg;  #     XtSetArg(arg, resource, value); !     XtSetValues(widget, &arg, 1);  }    main(int argc, char *argv[]) {      int status;        status = cd_allocate();      if (!(status & 1))     { C         printf("Unable to allocate a channel to DECW$CD_PLAYER\n");          return status;     }   $     status = db_open_cd_databases();     if (!(status & 1))     { 6         printf("Unable to open/create CD database\n");         gbl_db_open = 0;     }      else     {          gbl_db_open = 1;     }        MrmInitialize();  @     topLevel = XtAppInitialize(&app_context, gbl_app_name, NULL,>                                0, &argc, argv, NULL, NULL, 0);  B     status = MrmOpenHierarchy(1, &gbl_app_name, NULL, &Hierarchy);     if (status != MrmSUCCESS)      { >         printf("Error accessing UID file %s\n", gbl_app_name);         return status;     }   ,     MrmRegisterNames(regvec, nRegs(regvec));     if (status != MrmSUCCESS)      { A         printf("Unable to  register names for UIL interface.\n");          return status;     }   ?     status = MrmFetchWidget(Hierarchy, "main_window", topLevel, <                              &WidgetId[mainWindow], &class);     if (status != MrmSUCCESS)      { I         printf("Error Fetching main window widget from UIL interface\n");          return status;     }        handle_disk_change();      if (cd_is_playing())     { 5         set_value(WidgetId[buttonPlay],   XmNset, 1); 5         set_value(WidgetId[buttonResume], XmNset, 0); 5         set_value(WidgetId[buttonStop],   XmNset, 0);      }   J     /* set the minimum height for the window (we get errors if smaller) */*     set_value(topLevel, XmNminHeight, 35);  ,     /* Make it visible, then wait forever */(     XtManageChild(WidgetId[mainWindow]);     XtRealizeWidget(topLevel);  E     status = MrmFetchWidget(Hierarchy, "interval_selector", topLevel, H                              &WidgetId[windowIntervalSelector], &class);     if (status != MrmSUCCESS)      { N         printf("Error Fetching IntervalSelector widget from UIL interface\n");         return status;     }        setup_timer();     XtAppMainLoop(app_context);  }    /*=     A routine that is called when a widget is created so that      we can record its widget ID  */I void WidgetCreated(Widget widget, char *tag, XmAnyCallbackStruct *reason)  {      char buffer[10], *string;      static int volume_broken;      int left, right;       WidgetId[*tag] = widget;     switch (*tag)      {        case buttonAutoPlay:D         get_value(WidgetId[buttonAutoPlay], XmNset, &gbl_auto_play);         break;       case buttonAutoEject: F         get_value(WidgetId[buttonAutoEject], XmNset, &gbl_auto_eject);         break;       case buttonShufflePlay: J         get_value(WidgetId[buttonShufflePlay], XmNset, &gbl_shuffle_play);         break;       case buttonLock:>         get_value(WidgetId[buttonLock], XmNset, &gbl_lock_cd);         break;       case intervalSlider:E         get_value(WidgetId[intervalSlider], XmNvalue, &gbl_interval);          if (gbl_interval == 0)	         {              gbl_interval = 20;H             set_value(WidgetId[intervalSlider], XmNvalue, gbl_interval);	         } ;         set_value(WidgetId[intervalSlider], XmNminimum, 1);          break;       case intervalSliderLabel: >         sprintf(buffer, "%3.2f", (float)gbl_interval / 100.0);9         string = XmStringCreateLtoR(buffer, "ISO8859-1"); I         set_value(WidgetId[intervalSliderLabel], XmNlabelString, string);          XtFree(string);          break;    D       /* These next three case statements are to enable removing theK         volume widget in case the CPU/CDROM don't support volume changes */        case sliderTrackTime: I         /* see if the other widgets exist yet, and if volume is broken */ 6         if (WidgetId[textAlbumTitle] && volume_broken)	         { C             /* rearrange screen to prepare for removal of volume */              set_value 
             ( )                 WidgetId[textAlbumTitle],                  XmNtopWidget, )                 WidgetId[sliderTrackTime]              );,             /* remove the volume widget.. */'             if (WidgetId[sliderVolume]) 
             { 8                 XtDestroyWidget(WidgetId[sliderVolume]);+                 WidgetId[sliderVolume] = 0; 
             } 	         }          break;       case sliderVolume:/         /* see if volume changes work or not */ 6         /* only works if a disc is present though.. */         volume_broken = 0;         if (cd_ready()) 	         { )             cd_get_volume(&left, &right);              --left; --right;/             if (cd_set_volume(left, right) & 1) 
             {                   ++left; ++right;E                 cd_set_volume(left, right); /* return it to normal */ 
             }              else
             { "                 volume_broken = 1;
             } 	         } G         /* if it's broke, and the other widgets exist, fix things up */ S         if (WidgetId[textAlbumTitle] && volume_broken && WidgetId[sliderTrackTime]) 	         {              set_value 
             ( )                 WidgetId[textAlbumTitle],                  XmNtopWidget, )                 WidgetId[sliderTrackTime]              );'             if (WidgetId[sliderVolume]) 
             { 8                 XtDestroyWidget(WidgetId[sliderVolume]);+                 WidgetId[sliderVolume] = 0; 
             } 	         }          break;       case textAlbumTitle:K         /* if volume's broke, and the other widgets exist, fix things up */ Q         if (WidgetId[sliderVolume] && volume_broken && WidgetId[sliderTrackTime]) 	         {              set_value 
             ( )                 WidgetId[textAlbumTitle],                  XmNtopWidget, )                 WidgetId[sliderTrackTime]              );'             if (WidgetId[sliderVolume]) 
             { 8                 XtDestroyWidget(WidgetId[sliderVolume]);+                 WidgetId[sliderVolume] = 0; 
             } 	         }          break;     }  }   L void PlayButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason) {      Boolean set;  
     if (*tag)      {          set = 1;     }      else     { 6         get_value(WidgetId[buttonPlay], XmNset, &set);     }        if (set)+     {   /* the button was just pushed in */          if (cd_ready() & 1) 	         {              int track;  !             if (gbl_shuffle_play) 
             { #                 cd_shuffle_play(0); 
             }              else
             { I                 get_value(WidgetId[scaleCurrentTrack], XmNvalue, &track); *                 if (track == 0) track = 1;B                 cd_play_track_index(track, 1, cd_last_track(), 1);'                 gbl_cd_was_playing = 0; 
             } 9             set_value(WidgetId[buttonPlay],   XmNset, 1); 9             set_value(WidgetId[buttonResume], XmNset, 0); 9             set_value(WidgetId[buttonStop],   XmNset, 0); 	         }          else	         { 9             set_value(WidgetId[buttonPlay],   XmNset, 0); 9             set_value(WidgetId[buttonResume], XmNset, 0); 9             set_value(WidgetId[buttonStop],   XmNset, 1); 	         }      }  }   N void ResumeButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason) {      Boolean set;  
     if (*tag)      {          set = 1;     }      else     { 8         get_value(WidgetId[buttonResume], XmNset, &set);     }        if (set)+     {   /* the button was just pushed in */          if (cd_ready() & 1) 	         {              cd_resume();#             gbl_cd_was_playing = 0; 9             set_value(WidgetId[buttonPlay],   XmNset, 1); 9             set_value(WidgetId[buttonResume], XmNset, 0);E9             set_value(WidgetId[buttonStop],   XmNset, 0);u	         }.         else	         {d9             set_value(WidgetId[buttonPlay],   XmNset, 0);h9             set_value(WidgetId[buttonResume], XmNset, 0);e9             set_value(WidgetId[buttonStop],   XmNset, 1);i	         }n     }c }o  L void StopButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)E {   /* when the Stop button is in, the Play button should say Play */R     Boolean set;  
     if (*tag)V     {e         set = 1;     }e     else     { 6         get_value(WidgetId[buttonStop], XmNset, &set);     }g       if (set)+     {   /* the button was just pushed in */u         cd_stop_unit();          gbl_cd_was_playing = 0;E  5         set_value(WidgetId[buttonPlay],   XmNset, 0);w5         set_value(WidgetId[buttonResume], XmNset, 0); 5         set_value(WidgetId[buttonStop],   XmNset, 1);      }w }h    L void LockButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason) { :     get_value(WidgetId[buttonLock], XmNset, &gbl_lock_cd);     if (gbl_lock_cd)     {          cd_lock();     }      else     {e         cd_unlock();     }h }   P void AutoPlayButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason) {,@     get_value(WidgetId[buttonAutoPlay], XmNset, &gbl_auto_play); }   Q void AutoEjectButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)f {uB     get_value(WidgetId[buttonAutoEject], XmNset, &gbl_auto_eject); }o  O void ShuffleButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)n {uF     get_value(WidgetId[buttonShufflePlay], XmNset, &gbl_shuffle_play); }C  L void EjectButtonPushed(Widget widget, int *tag, XmAnyCallbackStruct *reason) {l'     cd_unlock(); /* for good measure */h     cd_eject();      handle_disk_change();e }i  S void AlbumSliderActionToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)B { 8     get_value(WidgetId[buttonAlbumSliderAction], XmNset,(               &gbl_album_slider_action); }r  R void SongSliderActionToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason) {c7     get_value(WidgetId[buttonSongSliderAction], XmNset,.'               &gbl_song_slider_action);h }o  S void TrackSliderActionToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)r { 8     get_value(WidgetId[buttonTrackSliderAction], XmNset,(               &gbl_track_slider_action); }   N void album_title_changed(Widget widget, int *tag, XmAnyCallbackStruct *reason) {I     char *value;  $     value = XmTextGetString(widget);!     db_modify_album_title(value);2     XtFree(value);     set_title(1);s }.  F void ChangeTrack(Widget widget, int *tag, XmAnyCallbackStruct *reason) {,     int value = *tag;A     int track, min, max;  =     get_value(WidgetId[scaleCurrentTrack], XmNvalue, &track);R=     get_value(WidgetId[scaleCurrentTrack], XmNminimum, &min); =     get_value(WidgetId[scaleCurrentTrack], XmNmaximum, &max);m       track += value; !     if (track < min) track = min;/!     if (track > max) track = max;9<     set_value(WidgetId[scaleCurrentTrack], XmNvalue, track); }u  G void volumeDrag(Widget widget, char *tag, XmScaleCallbackStruct *scale)e {t      static int last_value = 255;  #     if (scale->value != last_value)c     {C=         if (!(cd_set_volume(scale->value, scale->value) & 1))nE         {   /* recover from error here, put up a dialog box. etc.. */pD             set_value(WidgetId[sliderVolume], XmNvalue, last_value);	         }          else0         {   /* update label and change volume */%             char *string, buffer[20];)  &             last_value = scale->value;J             sprintf(buffer, "%4.1f%%", (float)last_value / 255.0 * 100.0);=             string = XmStringCreateLtoR(buffer, "ISO8859-1"); K             set_value(WidgetId[sliderVolumeLabel], XmNlabelString, string);e             XtFree(string);f	         }f     }d }n  J void volumeChanged(Widget widget, char *tag, XmScaleCallbackStruct *scale) {e      static int last_value = 255;     int value;  8     get_value(WidgetId[sliderVolume], XmNvalue, &value);     value += *tag;       if (value != last_value)     { ,         if (cd_set_volume(value, value) & 1)0         {   /* update label and change volume */%             char *string, buffer[20];n               last_value = value;rJ             sprintf(buffer, "%4.1f%%", (float)last_value / 255.0 * 100.0);=             string = XmStringCreateLtoR(buffer, "ISO8859-1");2K             set_value(WidgetId[sliderVolumeLabel], XmNlabelString, string);d             XtFree(string);f	         }l         elseE         {   /* recover from error here, put up a dialog box. etc.. */fD             set_value(WidgetId[sliderVolume], XmNvalue, last_value);	         }t     }  }l    U void update_track_slider_label(Widget widget, int *tag, XmScaleCallbackStruct *scale)d {      static int last_value = 0;  %     gbl_track_slider_inuse = !(*tag);e  !     if (scale->value < 1) return;l  4     if ((*tag == 1) || (scale->value != last_value))     {o!         char *string, buffer[20];   "         last_value = scale->value;[         if (((*tag == 1) || gbl_track_slider_action) && (last_value != cd_current_track())))	         {aC             cd_play_track_index(last_value, 1, cd_last_track(), 1);B	         }d         /* update label */*         sprintf(buffer, "%d", last_value);9         string = XmStringCreateLtoR(buffer, "ISO8859-1");rL         set_value(WidgetId[labelAlbumCurrentTrack], XmNlabelString, string);         XtFree(string);r     }c })  U void update_album_slider_label(Widget widget, int *tag, XmScaleCallbackStruct *scale)c {o     static int last_value = 0;  %     gbl_album_slider_inuse = !(*tag);   A     if ((*tag ==1) || ((scale->value / 75) != (last_value / 75)));     {R!         char *string, buffer[20];i  3         if ((*tag == 1) || gbl_album_slider_action) 	         {eA             cd_play_frame_to_end(scale->value + cd_start_time());k	         }e           /* update label */  "         last_value = scale->value;:         sprintf(buffer, "%d:%02d", (last_value / 75) / 60,;                                    (last_value / 75) % 60);e  9         string = XmStringCreateLtoR(buffer, "ISO8859-1");nF         set_value(WidgetId[sliderAlbumLabel], XmNlabelString, string);         XtFree(string);n     }" }   R void update_interval_slider(Widget widget, int *tag, XmScaleCallbackStruct *scale) {k     static int last_value = 0;  5     if ((*tag ==1) || ((scale->value != last_value)))      {e!         char *string, buffer[20];o           if (*tag == 1)	         { 0             gbl_interval_wannabe = scale->value;	         }g           /* update label */"         last_value = scale->value;<         sprintf(buffer, "%3.2f", (float)last_value / 100.0);9         string = XmStringCreateLtoR(buffer, "ISO8859-1");lI         set_value(WidgetId[intervalSliderLabel], XmNlabelString, string);}         XtFree(string);o     }d }   D void ExitProc(Widget widget, char *tag, XmAnyCallbackStruct *reason) { C     /* cd_stop_unit(); */   /* hmm, do I want to do this or not? */      cd_unlock();     cd_deallocate();     exit(1); }l  U void update_song_slider_label(Widget widget, char *tag, XmScaleCallbackStruct *scale)  {n     static int last_value = -1;l  $     gbl_song_slider_inuse = !(*tag);  B     if ((*tag == 1) || ((scale->value / 75) != (last_value / 75)))     {o!         char *string, buffer[20];e  2         if ((*tag == 1) || gbl_song_slider_action)	         {eG             cd_play_frame_to_end(cd_song_start_time(0) + scale->value); 	         }            /* update label */"         last_value = scale->value;:         sprintf(buffer, "%d:%02d", (last_value / 75) / 60,;                                    (last_value / 75) % 60); 9         string = XmStringCreateLtoR(buffer, "ISO8859-1"); A         set_value(WidgetId[sliderLabel], XmNlabelString, string);a         XtFree(string);l     }= }    house_keeping_timer()t {      static int was_ready = 0;e       cd_start_cache_io();       if (cd_ready())o     {e         if (was_ready)	         {a$             handle_display_update();              if (cd_is_playing())
             { )                 if (! gbl_cd_was_playing)e                 {dA                     set_value(WidgetId[buttonPlay],   XmNset, 1);oA                     set_value(WidgetId[buttonResume], XmNset, 0);lA                     set_value(WidgetId[buttonStop],   XmNset, 0);v+                     gbl_cd_was_playing = 1;u                 };
             }g             else
             {e'                 if (gbl_cd_was_playing)t                 {)B                     if (!(gbl_shuffle_play && cd_shuffle_play(0)))                     { 7                         if (gbl_auto_eject) cd_eject();RE                         set_value(WidgetId[buttonPlay],   XmNset, 0);aE                         set_value(WidgetId[buttonResume], XmNset, 0);cE                         set_value(WidgetId[buttonStop],   XmNset, 1); '                         cd_stop_unit(); /                         gbl_cd_was_playing = 0;i                     }p                 } 
             } 	         }          else	         {0             was_ready = 1;'             if (gbl_lock_cd) cd_lock();y!             handle_disk_change();   -             /* should add db logic here... */%             if (gbl_db_open)
             {                  static stringr/                     short_key = string_dynamic,E2                     null_string = {1, 0, 0, "\0"},1                     album_title = string_dynamic;;  8                 if (!(db_album_title(&album_title) & 1))                 { -                     db_add_album(&short_key);]C                     XmTextSetString(WidgetId[labelAlbumTitle], "");r!                     set_title(1);m                 }                  else                 {a;                     str$append(&album_title, &null_string); R                     XmTextSetString(WidgetId[labelAlbumTitle], SPTR(album_title));9                     /* position to beginning of text.. */]O                     set_value(WidgetId[labelAlbumTitle], XmNcursorPosition, 0);e!                     set_title(1);(                 }g
             }   2             if (gbl_auto_play && !cd_is_playing())
             {m%                 if (gbl_shuffle_play)v                 {='                     cd_shuffle_play(0);c                 }                  else                 {oQ                     cd_play_track_index(cd_first_track(), 1, cd_last_track(), 1);f                 }t;                 /* fix up all the labels and buttons eh? */s=                 set_value(WidgetId[buttonPlay],   XmNset, 1);t=                 set_value(WidgetId[buttonResume], XmNset, 0); =                 set_value(WidgetId[buttonStop],   XmNset, 0);d
             }e	         }h     },     else     {u         if (was_ready)	         {08             static string null_string = {1, 0, 0, "\0"};               was_ready = 0;!             handle_disk_change(); 9             set_value(WidgetId[buttonPlay],   XmNset, 0);b9             set_value(WidgetId[buttonResume], XmNset, 0); 9             set_value(WidgetId[buttonStop],   XmNset, 1);o;             XmTextSetString(WidgetId[labelAlbumTitle], "");              set_title(0); 	         }a     }g     cd_end_cache_io(); X     setup_timer(); }y  
 setup_timer(); { 5     /* set up timer to run some interval from now. */LL     XtAppAddTimeOut(app_context, gbl_interval * 10, house_keeping_timer, 0); }    void handle_disk_change()i {]     Arg arg[3];i     char buffer[252];(     char *string;      int min, cur, max, argc;       min = cd_first_track();a     max = cd_last_track();"     if (max <= min) max = min + 1;'     cur = MIN(cd_current_track(), max);i     cur = MAX(min, cur);     
     argc = 0;a1     XtSetArg(arg[argc], XmNminimum, min); ++argc;%1     XtSetArg(arg[argc], XmNmaximum, max); ++argc;g1     XtSetArg(arg[argc], XmNvalue,   cur); ++argc; 8     XtSetValues(WidgetId[scaleCurrentTrack], arg, argc);       sprintf(buffer, "%d", cur); 5     string = XmStringCreateLtoR(buffer, "ISO8859-1");aH     set_value(WidgetId[labelAlbumCurrentTrack], XmNlabelString, string);     XtFree(string);o  +     sprintf(buffer, "%d", cd_last_track()); 5     string = XmStringCreateLtoR(buffer, "ISO8859-1");oG     set_value(WidgetId[labelAlbumTotalTracks], XmNlabelString, string);)     XtFree(string);        /* cd_read_media_id(); */e       handle_display_update(); }    void handle_display_update() {      char buffer[252];x     char *string;      static int         saved_left = -1,         saved_right = -1,          saved_album_total = -1,r!         saved_album_current = -1,          saved_song_total = -1,          saved_song_current = -1,         saved_track = -1,s         saved_first_track = -1,i         saved_last_track = -1;     int tmp, left, right;         tmp = cd_album_total_time();!     if (tmp != saved_album_total)w     {n         Arg arg[3];l         int argc, cur;            saved_album_total = tmp;F         if (tmp < 0) tmp = 0; /* weird, programming error no doubt. */C         sprintf(buffer, "%d:%02d", tmp / 75 / 60, (tmp / 75) % 60);s9         string = XmStringCreateLtoR(buffer, "ISO8859-1"); I         set_value(WidgetId[labelAlbumTotalTime], XmNlabelString, string);t         if (tmp == 0) tmp = 1;8         cur = cd_album_current_time() - cd_start_time();         if (cur < 0) cur = 0;          cur = MIN(cur, tmp);         argc = 0;i5         XtSetArg(arg[argc], XmNmaximum, tmp); ++argc;x3         XtSetArg(arg[argc], XmNvalue, cur); ++argc;TC         if (tmp > 150) /* for any album longer than two seconds! */ 	         {t?             XtSetArg(arg[argc], XmNscaleMultiple, 150); ++argc; 	         }d:         XtSetValues(WidgetId[sliderAlbumTime], arg, argc);     };        tmp = cd_song_total_time(0);      if (tmp != saved_song_total)     {m         Arg arg[3];          int cur, argc;           saved_song_total = tmp; F         if (tmp < 0) tmp = 0; /* weird, programming error no doubt. */C         sprintf(buffer, "%d:%02d", tmp / 75 / 60, (tmp / 75) % 60);s9         string = XmStringCreateLtoR(buffer, "ISO8859-1"); H         set_value(WidgetId[labelSongTotalTime], XmNlabelString, string);         if (tmp == 0) tmp = 1;%         cur = cd_song_current_time();          if (cur < 0) cur = 0;          cur = MIN(cur, tmp);         argc = 0;]5         XtSetArg(arg[argc], XmNmaximum, tmp); ++argc;g3         XtSetArg(arg[argc], XmNvalue, cur); ++argc;VL         if (tmp > 150) /* should be for any song longer than two seconds! */	         {g?             XtSetArg(arg[argc], XmNscaleMultiple, 150); ++argc; 	         }e:         XtSetValues(WidgetId[sliderTrackTime], arg, argc);     };        if (!gbl_album_slider_inuse)     {]8         tmp = cd_album_current_time() - cd_start_time();         if (tmp < 0) tmp = 0; 5         if ((tmp / 75) != (saved_album_current / 75)) 	         { &             saved_album_current = tmp;J             if (tmp < 0) tmp = 0; /* weird, programming error no doubt. */G             sprintf(buffer, "%d:%02d", tmp / 75 / 60, (tmp / 75) % 60);k=             string = XmStringCreateLtoR(buffer, "ISO8859-1"); J             set_value(WidgetId[sliderAlbumLabel], XmNlabelString, string);             XtFree(string);g.             tmp = MIN(tmp, saved_album_total);@             set_value(WidgetId[sliderAlbumTime], XmNvalue, tmp);
         };     };       if (!gbl_song_slider_inuse)g     {t%         tmp = cd_song_current_time(); 4         if ((tmp / 75) != (saved_song_current / 75))	         {]%             saved_song_current = tmp;(G             sprintf(buffer, "%d:%02d", tmp / 75 / 60, (tmp / 75) % 60);o=             string = XmStringCreateLtoR(buffer, "ISO8859-1");tE             set_value(WidgetId[sliderLabel], XmNlabelString, string);              XtFree(string);g-             tmp = MIN(tmp, saved_song_total); @             set_value(WidgetId[sliderTrackTime], XmNvalue, tmp);
         };     };          if (!gbl_track_slider_inuse)     {*)         tmp = MAX(cd_current_track(), 1);          if (tmp != saved_track) 	         {d=             if (tmp > cd_last_track()) tmp = cd_last_track();              saved_track = tmp;B             set_value(WidgetId[scaleCurrentTrack], XmNvalue, tmp);'             sprintf(buffer, "%d", tmp); =             string = XmStringCreateLtoR(buffer, "ISO8859-1");bP             set_value(WidgetId[labelAlbumCurrentTrack], XmNlabelString, string);             XtFree(string);i             set_title(1);t
         };     };  )     if (cd_get_volume(&left, &right) & 1)i     {n9         if (left != saved_left && WidgetId[sliderVolume])b	         {,N             saved_left = left;  /* for now, assume left and right are same. */>             set_value(WidgetId[sliderVolume], XmNvalue, left);D             sprintf(buffer, "%4.1f%%", (float)left / 255.0 * 100.0);=             string = XmStringCreateLtoR(buffer, "ISO8859-1"); K             set_value(WidgetId[sliderVolumeLabel], XmNlabelString, string);              XtFree(string);u	         }b     }s }]  J void change_interval(Widget widget, int *tag, XmAnyCallbackStruct *reason) {h     char buffer[10], *string;d     4     XtManageChild(WidgetId[windowIntervalSelector]);  @     set_value(WidgetId[intervalSlider], XmNvalue, gbl_interval);  :     sprintf(buffer, "%3.2f", (float)gbl_interval / 100.0);5     string = XmStringCreateLtoR(buffer, "ISO8859-1");oE     set_value(WidgetId[intervalSliderLabel], XmNlabelString, string);      XtFree(string);t  (     gbl_interval_wannabe = gbl_interval;)     gbl_interval_original = gbl_interval;, }t  M void change_interval_ok(Widget widget, int *tag, XmAnyCallbackStruct *reason), {N(     gbl_interval = gbl_interval_wannabe;6     XtUnmanageChild(WidgetId[windowIntervalSelector]); }*  Q void change_interval_cancel(Widget widget, int *tag, XmAnyCallbackStruct *reason)  {      char buffer[10], *string; )     gbl_interval = gbl_interval_original;o  :     sprintf(buffer, "%3.2f", (float)gbl_interval / 100.0);5     string = XmStringCreateLtoR(buffer, "ISO8859-1");rE     set_value(WidgetId[intervalSliderLabel], XmNlabelString, string);      XtFree(string);t  6     XtUnmanageChild(WidgetId[windowIntervalSelector]); }m  P void change_interval_apply(Widget widget, int *tag, XmAnyCallbackStruct *reason) {b(     gbl_interval = gbl_interval_wannabe; }d   void shuffle_mode_on() {s     gbl_shuffle_play = 1;n6     set_value(WidgetId[buttonShufflePlay], XmNset, 1); }g   void shuffle_mode_off()a {a     gbl_shuffle_play = 0; 6     set_value(WidgetId[buttonShufflePlay], XmNset, 0); }    set_title()a {s     unsigned char buff[500];,     static unsigned char ctrl_replace = 183;       if (cd_first_track())      {r&         if (WidgetId[labelAlbumTitle])	         {              unsigned char *tmp;              int i;  =             tmp = XmTextGetString(WidgetId[labelAlbumTitle]);g@             /* replace control characters with something else */P             for (i = 0; tmp[i]; ++i) if (iscntrl(tmp[i])) tmp[i] = ctrl_replace;             sprintfg
             (n                 buff,i                  "%s (%d of %d)",*                 strlen(tmp)?tmp:gbl_title,#                 cd_current_track(),t                 cd_last_track())             );             XtFree(tmp);	         }a,         set_value(topLevel, XmNtitle, buff);/         set_value(topLevel, XmNiconName, buff);s     }      else     {t4         sprintf(buff, "%s: insert disc", gbl_title);,         set_value(topLevel, XmNtitle, buff);4         set_value(topLevel, XmNiconName, gbl_title);     }r }    void save_customize_settings() { "     static XrmDatabase new_db = 0;     char resource_db_name[252];   I     sprintf(resource_db_name, "decw$user_defaults:%s.dat", gbl_app_name);        if (new_db == 0)     {2"         /* get the old database */6         new_db = XrmGetFileDatabase(resource_db_name);           if (new_db == 0)	         { 9             XrmPutFileDatabase(new_db, resource_db_name); :             new_db = XrmGetFileDatabase(resource_db_name);	         }e     }        if (new_db == 0)     { $         /* something weird here.. */=         printf("unable to open/create resource database?\n");      }i     else     {54         /* merge in any changes the user requests */          Dimension width, height;         Position x,y;a         int value;         Boolean bool;s         char buffer[256];)  >         get_value(WidgetId[intervalSlider], XmNvalue, &value);A         modify_db_value(new_db, "*interval_slider.value", value);   7         get_value(WidgetId[buttonLock], XmNset, &bool);*:         modify_db_value(new_db, "*lock_toggle.set", bool);  ;         get_value(WidgetId[buttonAutoPlay], XmNset, &bool);,?         modify_db_value(new_db, "*auto_play_toggle.set", bool);   <         get_value(WidgetId[buttonAutoEject], XmNset, &bool);@         modify_db_value(new_db, "*auto_eject_toggle.set", bool);  >         get_value(WidgetId[buttonShufflePlay], XmNset, &bool);=         modify_db_value(new_db, "*shuffle_toggle.set", bool);S  &         get_value(topLevel, XmNx, &x);)         modify_db_value(new_db, ".x", x);*  &         get_value(topLevel, XmNy, &y);)         modify_db_value(new_db, ".y", y);!  .         get_value(topLevel, XmNwidth, &width);1         modify_db_value(new_db, ".width", width);   0         get_value(topLevel, XmNheight, &height);3         modify_db_value(new_db, ".height", height);   %         /* output the new database */,5         XrmPutFileDatabase(new_db, resource_db_name);a     }  }   8 modify_db_value(XrmDatabase db, char *string, int value) {n     XrmValue val;      char buffer[15];     char resource[500];l  4     sprintf(resource, "%s%s", gbl_app_name, string);  !     sprintf(buffer, "%d", value);d     val.addr = buffer;"     val.size = strlen(buffer) + 1;  3     XrmPutResource(&db, resource, XtRString, &val);  } 