 #ifndef CD_DEBUG #define CD_DEBUG 0 #endif   #include ssdef #include descrip #include ctype #include "cdrom.h" #include "cdrom-data.h"    typedef struct {      short length;      short code;      void *buffer;      short *retlenaddr; } ItemList;   , #define BYTE_0(a)  ((a)        & 0x000000ff), #define BYTE_1(a) (((a) >> 8)  & 0x000000ff), #define BYTE_2(a) (((a) >> 16) & 0x000000ff), #define BYTE_3(a) (((a) >> 24) & 0x000000ff)   static short     channel;  
 static int     cd__toc_valid = 0,     cd__loaded = 0,      cd__ready = 0,     cd__changed = 0,     cd__track_number = 0,      cd__index_number = 0,      cd__status = 0,      cd__tracks = 0,      cd__shuffle_mode = 0,      cd__debug = CD_DEBUG;    static scsi_read_toc_data      cd__toc;  ! static scsi_current_position_data 
     cd__cpos;   
 static struct  {      scsi_mode_header_6 header;%     scsi_mode_block_descriptor block; "     scsi_param_audio_control page; }      cd__audio_control_data,      cd__audio_control_mask;   ' int cd_get_toc(scsi_read_toc_data *toc)  { '     if (! cd__toc_valid) cd_read_toc(); "     if (! cd__toc_valid) return 0;       *toc = cd__toc; 
     return 1;  }    int cd_start_time()  { '     if (! cd__toc_valid) cd_read_toc(); "     if (! cd__toc_valid) return 0;  >     return cd__toc.track[0].absolute_address.msf.m * 60 * 75 +9            cd__toc.track[0].absolute_address.msf.s * 75 + 3            cd__toc.track[0].absolute_address.msf.f;  }    int cd_final_time()  { '     int tracks, length, entries, total;   '     if (! cd__toc_valid) cd_read_toc(); "     if (! cd__toc_valid) return 0;  3     length = (cd__toc.header.toc_data_length1 << 8) .             | cd__toc.header.toc_data_length0;E     entries = ((length - 2) / sizeof (scsi_read_toc_track_data)) - 1;   D     return cd__toc.track[entries].absolute_address.msf.m * 60 * 75 +?            cd__toc.track[entries].absolute_address.msf.s * 75 + =            cd__toc.track[entries].absolute_address.msf.f - 1;  }    int cd_album_total_time()  { -     return cd_final_time() - cd_start_time();  }      int cd_album_current_time()  { )     if (!(cd_get_status() & 1)) return 0;   8     return (cd__cpos.absolute_address.msf.m * 60 * 75) +3            (cd__cpos.absolute_address.msf.s * 75) + ,             cd__cpos.absolute_address.msf.f; }    int cd_album_remaining_time()  { ;     return cd_album_total_time() - cd_album_current_time();  }   ! int cd_song_total_time(int track)  { +     int length, entries, start, end, total;      int m, s, f, i;   '     if (! cd__toc_valid) cd_read_toc(); "     if (! cd__toc_valid) return 0;  /     if (track == 0) track = cd_current_track();      if (track == 0) return 0;   3     length = (cd__toc.header.toc_data_length1 << 8) .             | cd__toc.header.toc_data_length0;?     entries = (length - 2) / sizeof (scsi_read_toc_track_data);        i = track - 1;/     if (cd__toc.track[i].track_number != track) I     {   /* if it wasn't a simple mapping of tracks, let's look for it. */ L         /* mind you, I'm not sure if this sort of thing can happen or not */         i = 0;H         while((i < entries) && (cd__toc.track[i].track_number != track))	         {              ++i;	         }      }        end = 0;/     if (track == cd__toc.track[i].track_number)      {          start = ?             cd__toc.track[i].absolute_address.msf.m * 75 * 60 + :             cd__toc.track[i].absolute_address.msf.s * 75 +4             cd__toc.track[i].absolute_address.msf.f;         if ((i + 1) < entries)	         {              end = F                 cd__toc.track[i+1].absolute_address.msf.m * 75 * 60 + @                 cd__toc.track[i+1].absolute_address.msf.s * 75 +:                 cd__toc.track[i+1].absolute_address.msf.f;	         }      }   -     return (start < end) ? (end - start) : 0;  }   ! int cd_song_start_time(int track)  { "     int length, entries, start, i;  '     if (! cd__toc_valid) cd_read_toc(); "     if (! cd__toc_valid) return 0;  /     if (track == 0) track = cd_current_track();   3     length = (cd__toc.header.toc_data_length1 << 8) .             | cd__toc.header.toc_data_length0;?     entries = (length - 2) / sizeof (scsi_read_toc_track_data);          i = track - 1;/     if (cd__toc.track[i].track_number != track)      {          i = 0;H         while((i < entries) && (cd__toc.track[i].track_number != track))	         {              ++i;	         }      }   /     if (track != cd__toc.track[i].track_number)      {          return 0;      }   ?     return  cd__toc.track[i].absolute_address.msf.m * 60 * 75 + :             cd__toc.track[i].absolute_address.msf.s * 75 +4             cd__toc.track[i].absolute_address.msf.f; }    int cd_song_current_time() { )     if (!(cd_get_status() & 1)) return 0;   <     return cd__cpos.track_relative_address.msf.m * 60 * 75 +7            cd__cpos.track_relative_address.msf.s * 75 + 1            cd__cpos.track_relative_address.msf.f;  }    int cd_song_remaining_time() { :     return cd_song_total_time(0) - cd_song_current_time(); }    int cd_tracks()  { '     if (! cd__toc_valid) cd_read_toc(); (     if (! cd__toc_valid) cd__tracks = 0;     return cd__tracks; }    int cd_status()  { %     if (! cd_ready()) cd__status = 0;      return cd__status; }    int cd_is_playing()  {      int play_state;        switch(cd_status())      { C       case 0x11: /* Audio play operation in progress.            */          play_state = 1;          break;K       case 0x12: /* Audio play operation paused - ? so, is it "playing?" */        default:         play_state = 0;          break;     }      return play_state; }    int cd_is_paused() {      int pause_state;       switch(cd_status())      { B       case 0: /* hmm, disk must not be ready                    */C       case 0x13: /* Audio play operation successfully completed. */ C       case 0x14: /* Audio play operation stopped due to error.   */ C       case 0x15: /* No current audio status to return            */ C       case 0x11: /* Audio play operation in progress.            */          pause_state = 0;         break;C       case 0x12: /* Audio play operation paused.                 */          pause_state = 1;         break;     }      return pause_state;  }    int cd_current_track() { +     if (! cd_ready()) cd__track_number = 0;      return cd__track_number; }    int cd_first_track() { '     if (! cd__toc_valid) cd_read_toc(); 8     if (! cd__toc_valid) cd__toc.header.first_track = 0;&     return cd__toc.header.first_track; }    int cd_last_track()  { '     if (! cd__toc_valid) cd_read_toc(); 7     if (! cd__toc_valid) cd__toc.header.last_track = 0; %     return cd__toc.header.last_track;  }   % int cd_play_frame_to_end(int start_f)  {       int end_f = cd_final_time();       if (cd__shuffle_mode)      { ?         end_f = cd_song_start_time(cd_current_track() + 1) - 1;      } L     return cd_play_msf(start_f / 75 / 60, (start_f / 75) % 60, start_f % 75,G                        end_f / 75 / 60, (end_f / 75) % 60, end_f % 75);  }   2 int cd_play_frame_to_frame(int start_f, int end_f) { L     return cd_play_msf(start_f / 75 / 60, (start_f / 75) % 60, start_f % 75,G                        end_f / 75 / 60, (end_f / 75) % 60, end_f % 75);  }    int cd_play_msf  ( *     int start_m, int start_s, int start_f,#     int end_m, int end_s, int end_f  )  {      static scsi_play_audio_msf
         cmd = 	         { 0             SCSI_PLAY_AUDIO_MSF,    /* opcode */2             0,                      /* reserved */-             0,                      /* lun */ 2             0,                      /* reserved */5             0, 0, 0,                /* start m/s/f */ 3             0, 0, 0,                /* end m/s/f */ 1             0                       /* control */ 
         };       cmd.start_m = start_m;     cmd.start_s = start_s;     cmd.start_f = start_f;     cmd.end_m = end_m;     cmd.end_s = end_s;     cmd.end_f = end_f;  6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }    int cd_play_track_index  ( %     int start_track, int start_index,       int end_track, int end_index )  { &     static scsi_play_audio_track_index
         cmd = 	         { 8             SCSI_PLAY_AUDIO_TRACK_INDEX,    /* opcode */:             0,                              /* reserved */5             0,                              /* lun */ :             0, 0,                           /* reserved */C             0, 0,                           /* start track/index */ :             0,                              /* reserved */A             0, 0,                           /* end track/index */ 9             0                               /* control */ 
         };"     cmd.start_track = start_track;"     cmd.start_index = start_index;     cmd.end_track = end_track;     cmd.end_index = end_index;       cd__shuffle_mode  = 0;  6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }   
 static int     cd__cache_io = 0,      cd__cache_get_status,      cd__cache_test_unit_ready;   int cd_start_cache_io()  {      /*B         if you want to save a few I/O's, use cd_get_status_start()L         to indicate that all calls until the next time cd_get_status_start()@         is called should be ignored (i.e. use 'old' cached data)     */     cd__cache_io = 1;      cd__cache_get_status = 0; "     cd__cache_test_unit_ready = 0; }    int cd_end_cache_io()  {      cd__cache_io = 0;  }      int cd_read_media_id() { 0     static scsi_media_catalog_data cd__media_id;       static scsi_read_subchannel 
         cmd = 	         { >             SCSI_READ_SUBCHANNEL,   /* opcode               */>             0,                      /* reserved             */K             0, /* no need to request msf.. 1, */ /* msf                  */ >             0,                      /* reserved             */>             0,                      /* lun                  */>             0,                      /* reserved             */>             1,                      /* subq                 */>             0,                      /* reserved             */>             0x02,                   /* sub_chan_data_format */>             0, 0,                   /* reserved             */>             0,                      /* track_number         */>             0,                      /* allocation_length1   */>             0,                      /* allocation_length0   */>             0                       /* control              */
         };     int status;        status = cd_read_subchannel                  ( %                     &cmd, sizeof cmd, 6                     &cd__media_id, sizeof cd__media_id                 );
     if (0)     { /* if (0) */     if (status & 1)      { "         if (cd__media_id.mc_valid)	         {              int i;  "             printf("Media ID:\n");  #             printf("      ascii:"); $             for (i = 0; i < 15; ++i)
             { 6                 if (isprint(cd__media_id.media_id[i]))                 { <                     printf(" %c", cd__media_id.media_id[i]);                 }                  else                 { >                     printf(" (%d)", cd__media_id.media_id[i]);                 } 
             }              printf("\n");   #             printf("    decimal:"); M             for (i = 0; i < 15; ++i) printf(" %d", cd__media_id.media_id[i]);              printf("\n");   #             printf("hexadecimal:"); O             for (i = 0; i < 15; ++i) printf(" %02x", cd__media_id.media_id[i]);              printf("\n"); 	         }          else	         { .             printf("Media ID Not valid...\n");	         }      }      } /* if (0) */       return status; }    int cd_get_status()  {      static scsi_read_subchannel 
         cmd = 	         { >             SCSI_READ_SUBCHANNEL,   /* opcode               */>             0,                      /* reserved             */>             1,                      /* msf                  */>             0,                      /* reserved             */>             0,                      /* lun                  */>             0,                      /* reserved             */>             1,                      /* subq                 */>             0,                      /* reserved             */>             0x01,                   /* sub_chan_data_format */>             0, 0,                   /* reserved             */>             0,                      /* track_number         */>             0,                      /* allocation_length1   */>             0,                      /* allocation_length0   */>             0                       /* control              */
         };     static int status;       if (cd__cache_io)      { &         if (cd__cache_get_status == 0)	         { %             cd__cache_get_status = 1; (             status = cd_read_subchannel(9                                         &cmd, sizeof cmd, B                                         &cd__cpos, sizeof cd__cpos)                                        ); 	         }      }        if (status & 1)      { &         if (!cd__ready) cd__ready = 1;           if (cd__changed)6         {   /* the disk was unloaded and reloaded.. */             cd__changed = 0;             cd_read_toc();"         }   /* if (cd__changed) */  +         cd__status = cd__cpos.audio_status; 1         cd__track_number = cd__cpos.track_number; 1         cd__index_number = cd__cpos.index_number;      }   /* if (status & 1) */      else     { %         if (cd__ready) cd__ready = 0;      }        return status; }   /* cd_get_status() */    int cd_read_subchannel ( +     scsi_read_subchannel *cmd, int cmd_len,      void *data, int data_len ) = {   /* attempt to get the current status of the CD player. */ /     cmd->allocation_length1 = BYTE_1(data_len); /     cmd->allocation_length0 = BYTE_0(data_len); <     return cd_execute_command(cmd, cmd_len, data, data_len); }    int cd_loaded()  {      cd_get_status();     return cd__loaded; }    int cd_ready() {      cd_get_status();       return cd__ready;  }   I int cd_request_sense(scsi_request_sense_data *data, unsigned char length)  {      static scsi_request_sense 
         cmd = 	         { 0             SCSI_REQUEST_SENSE,     /* opcode */2             0,                      /* reserved */-             0,                      /* lun */ 2             0, 0,                   /* reserved */;             0,                      /* allocation_length */ 1             0                       /* control */ 
         };  #     cmd.allocation_length = length; >     return cd_execute_command(&cmd, sizeof cmd, data, length); }   = int cd_inquiry(scsi_inquiry_data *data, unsigned char length)  {      static scsi_inquiry 
         cmd = 	         { B             SCSI_INQUIRY,       /* opcode                       */B             0,                  /* enable_vital_product_data    */B             0,                  /* reserved                     */B             0,                  /* lun                          */B             0,                  /* page_code                    */B             0,                  /* reserved                     */B             0,                  /* allocation_length;           */B             0                   /* control                      */
         };  #     cmd.allocation_length = length; >     return cd_execute_command(&cmd, sizeof cmd, data, length); }    int cd_eject() {      static scsi_start_stop_unit 
         cmd = 	         { 0             SCSI_START_STOP_UNIT,   /* opcode */3             0,                      /* immediate */ 2             0,                      /* reserved */-             0,                      /* lun */ 2             0, 0,                   /* reserved *//             0,                      /* start */ 4             1,                      /* load_eject */2             0,                      /* reserved */1             0                       /* control */ 
         };  6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }    int cd_start_unit()  {      static scsi_start_stop_unit 
         cmd = 	         { 0             SCSI_START_STOP_UNIT,   /* opcode */3             0,                      /* immediate */u2             0,                      /* reserved */-             0,                      /* lun */ 2             0, 0,                   /* reserved *//             1,                      /* start */i4             0,                      /* load_eject */2             0,                      /* reserved */1             0                       /* control */E
         };  6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }i   int cd_stop_unit() {,     static scsi_start_stop_unite
         cmd =d	         { 0             SCSI_START_STOP_UNIT,   /* opcode */3             0,                      /* immediate */ 2             0,                      /* reserved */-             0,                      /* lun */ 2             0, 0,                   /* reserved *//             0,                      /* start */a4             0,                      /* load_eject */2             0,                      /* reserved */1             0                       /* control */t
         };  6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); })  
 int cd_lock()_ {_,     static scsi_prevent_allow_medium_removal
         cmd = 	         {aB             SCSI_PREVENT_ALLOW_MEDIUM_REMOVAL,      /* opcode   */B             0,                                      /* reserved */B             0,                                      /* lun      */B             0, 0,                                   /* reserved */B             1,                                      /* prevent  */B             0,                                      /* reserved */B             0                                       /* control  */4         };                                            6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }a   int cd_unlock()e {n,     static scsi_prevent_allow_medium_removal
         cmd = 	         {_B             SCSI_PREVENT_ALLOW_MEDIUM_REMOVAL,      /* opcode   */B             0,                                      /* reserved */B             0,                                      /* lun      */B             0, 0,                                   /* reserved */B             0,                                      /* prevent  */B             0,                                      /* reserved */B             0                                       /* control  */
         };  6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }    int cd_allocate()o {_*     $DESCRIPTOR(player, "DECW$CD_PLAYER");#     scsi_inquiry_data inquiry_data;      int status;(  1     status = sys$assign(&player, &channel, 0, 0);a%     if (!(status & 1)) return status;r  <     status = cd_inquiry(&inquiry_data, sizeof inquiry_data);%     if (!(status & 1)) return status;g  4     if (inquiry_data.device_type != 5) /* cdrom ? */     { 0         printf("This device isn't a CD-ROM?\n");         return SS$_ABORT;      }   
     return 1;c }]   int cd_deallocate()  {      return sys$dassgn(channel);p }g   typedef struct o {f     unsigned char opcode;      /* etc.. */ 
 } command;  T int cd_execute_command(command *cmd_addr, int cmd_len, int *data_addr, int data_len) {c #   define FLAGS_READ 1k #   define FLAGS_DISCONNECT 2;     static struct      {          int              opcode,t             flags,             command_address,             command_length,a             data_address,*             data_length,             pad_length,s             phase_timeout,             disconnect_timeout,.             reserved[6];     } gk_desc = K         {1, FLAGS_READ + FLAGS_DISCONNECT, 0,0,0,0, 0, 0, 60, 0,0,0,0,0,0};s     globalvalue IO$_DIAGNOSE; 	 	long into
         i,         status;.
     short int          gk_iosb[4];. 	unsigned char scsi_status;s  '     gk_desc.command_address = cmd_addr,r%     gk_desc.command_length = cmd_len;n%     gk_desc.data_address = data_addr; #     gk_desc.data_length = data_len;   < 	status = sys$qiow (0, channel, IO$_DIAGNOSE, gk_iosb, 0, 0,, 			   &gk_desc, sizeof gk_desc, 0, 0, 0, 0);  " 	if (!(status & 1)) return status;     status = gk_iosb[0];" 	if (!(status & 1)) return status;  @     /* change status to low word = 0, high word = scsi status */,     status = (gk_iosb[3] & 0x0000ff00) << 8;       switch (gk_iosb[3] >> 8)     {t       case STATUS_GOOD:          status = 1;i         break;"       case STATUS_CHECK_CONDITION:3         if (cmd_addr->opcode != SCSI_REQUEST_SENSE) 7         {   /* we don't want to get recursive here.. */ !             cd_check_condition(); 	         }d         elseJ         { /* we got a check_condition error on a request sense command. */L /***************************************************************************M   The target shall return CHECK CONDITION status for a REQUEST SENSE command  C only to report errors specific to the command itself.  For example: J   (1) A non-zero reserved bit is detected in the command descriptor block.?   (2) An unrecovered parity error is detected on the data bus.  =   (3) A target malfunction prevents return of the sense data. L ***************************************************************************/-             static int recursion_warning = 0;t'             if (recursion_warning == 0)f
             { $                 ++recursion_warning;%                 cd_check_condition(); $                 --recursion_warning;
             }              else
             {eQ                 printf("Programmer foo-bar'd. Aborting cd_execute_command().\n"); &                 lib$signal(SS$_ABORT);
             } 
         };         break;       default:         break;     }; 	return status;  }u   int cd_check_condition() {_'     scsi_request_sense_data sense_data;   @     if (!(cd_request_sense(&sense_data, sizeof sense_data) & 1))     { %         /* why couldn't we? weird. *//I         printf("Programmer foo-bar'd. Aborting cd_check_condition().\n");i         lib$signal(SS$_ABORT);H     } /* if (!(cd_request_sense(&sense_data, sizeof sense_data) & 1)) */   #define MEDIUM_NOT_PRESENT 0x3a * #define NOT_READY_TO_READY_TRANSITION 0x28!     switch (sense_data.sense_key)r     {        case SENSE_KEY_NOT_READY:a         cd__toc_valid = 0;         cd__ready = 0;1         if (sense_data.asc == MEDIUM_NOT_PRESENT)a	         {              cd__loaded = 0; 	         }r         break;$       case SENSE_KEY_UNIT_ATTENTION:<         if (sense_data.asc == NOT_READY_TO_READY_TRANSITION)	         {t             cd__toc_valid = 0;F             cd__changed = 1; /* cd may have changed, assume it did. */             cd__loaded = 1; C         } /* if (sense_data.adc == NOT_READY_TO_READY_TRANSITION)*/)         break;)     } /* switch (sense_data.sense_key) */.  9     if (cd__debug) cd__print_sense_key_info(&sense_data); 
     return 1;  }d   int cd_read_toc()  {(     static scsi_read_toc
         cmd = 	         {t0             SCSI_READ_TOC,          /* opcode */2             0,                      /* reserved */5             1,                      /* msf format? */72             0,                      /* reserved */-             0,                      /* lun */ 2             0, 0, 0, 0,             /* reserved */8             0,                      /* starting track */:             BYTE_1(sizeof cd__toc), /* alloc length msb */:             BYTE_0(sizeof cd__toc), /* alloc length lsb */1             0                       /* control */t,         };                                       int status;                _  2     /* erase out old contents - just to be safe */(     memset(&cd__toc, 0, sizeof cd__toc);  L     status = cd_execute_command(&cmd, sizeof cmd, &cd__toc, sizeof cd__toc);     if (status & 1)      { 0         /* we have a valid table of contents! */:         /* let's see how many things they passed back...*/%         unsigned int length, entries;m           cd__toc_valid = 1;  7         length = (cd__toc.header.toc_data_length1 << 8)_3                  | cd__toc.header.toc_data_length0;nC         entries = (length - 2) / sizeof (scsi_read_toc_track_data); P         cd__tracks = cd__toc.header.last_track - cd__toc.header.first_track + 1;     } /* if (status & 1) */      return status; }d   int cd_change_all_pages()  {      unsigned char buffer[256];     int length;,  -     cd__get_all_pages(buffer, sizeof buffer);        length = buffer[0];   >     /* play with the buffer while in DEBUG here.. what fun! */  -     return cd__set_all_pages(buffer, length);  }   4 cd__get_all_pages(unsigned char *buffer, int length) {x     static scsi_mode_sense_6
         cmd = 	         {r8             SCSI_MODE_SENSE_6,              /* opcode */:             0,                              /* reserved */5             0,                              /* dbd */r:             0,                              /* reserved */5             0,                              /* lun */ ;             0x3f,                           /* page_code */ 4             0,                              /* pc */:             0,                              /* reserved */C             0,                              /* allocation_length */o9             0                               /* control */d
         };     #     cmd.allocation_length = length;sQ     if (cmd.allocation_length == 256) cmd.allocation_length = 0; /* weird huh? */   C     return cd_execute_command ( &cmd, sizeof cmd, buffer, length );t }i  8 int cd__set_all_pages(unsigned char *buffer, int length) {o     static scsi_mode_select_6i
         cmd = 	         {_8             SCSI_MODE_SELECT_6,             /* opcode */;             0,                              /* save page */_:             0,                              /* reserved */=             1,                              /* page format */ 5             0,                              /* lun */*:             0, 0,                           /* reserved */G             0,                              /* parameter list length */ 9             0                               /* control *//
         };     '     cmd.parameter_list_length = length;   C     return cd_execute_command ( &cmd, sizeof cmd, buffer, length );  }     int cd__get_audio_control_page() {a     static scsi_mode_sense_6
         cmd = 	         {r8             SCSI_MODE_SENSE_6,              /* opcode */:             0,                              /* reserved */5             0,                              /* dbd */ :             0,                              /* reserved */5             0,                              /* lun */;;             0x0e,                           /* page_code */ 4             0,                              /* pc */:             0,                              /* reserved */G             sizeof cd__audio_control_data,  /* allocation_length lsb */ 9             0                               /* control */ 
         };          return cd_execute_command      (          &cmd, sizeof cmd,)          &cd__audio_control_data,%         sizeof cd__audio_control_data      ); }(  % int cd__get_audio_control_page_mask()  {      static scsi_mode_sense_6
         cmd =_	         {[8             SCSI_MODE_SENSE_6,              /* opcode */:             0,                              /* reserved */5             0,                              /* dbd */ :             0,                              /* reserved */5             0,                              /* lun */_;             0x0e,                           /* page_code */ 4             1,                              /* pc */:             0,                              /* reserved */G             sizeof cd__audio_control_mask,  /* allocation_length lsb */ 9             0                               /* control */ 
         };     static int repeat = 0;       if (! repeat)a	     {     !         return cd_execute_command 	         (              &cmd, sizeof cmd,R$             &cd__audio_control_mask,)             sizeof cd__audio_control_mask 
         );         ++repeat;      }      else     {          return 1;      }  }/  ( int cd_get_volume(int *left, int *right) {e     int status;   *     status = cd__get_audio_control_page();%     if (!(status & 1)) return status;   7     *left  = cd__audio_control_data.page.port_0_volume; 7     *right = cd__audio_control_data.page.port_1_volume;   
     return 1;  }   & int cd_set_volume(int left, int right) {1     static scsi_mode_select_6_
         cmd = 	         { 8             SCSI_MODE_SELECT_6,             /* opcode */;             0,                              /* save page */ :             0,                              /* reserved */=             1,                              /* page format */ 5             0,                              /* lun */ :             0, 0,                           /* reserved */G             sizeof cd__audio_control_data,  /* parameter list length */ 9             0                               /* control */_
         };     int status;   *     status = cd__get_audio_control_page();%     if (!(status & 1)) return status;   7     cd__audio_control_data.header.mode_data_length = 0; 5     cd__audio_control_data.page.port_0_volume = left; 6     cd__audio_control_data.page.port_1_volume = right;       return cd_execute_command      (d         &cmd, sizeof cmd,e          &cd__audio_control_data,%         sizeof cd__audio_control_data      ); }c   int cd_reserve() {      static scsi_reserveu
         cmd = 	         {r>             SCSI_RESERVE,       /* opcode                   */>             0,                  /* extent                   */>             0,                  /* third_party_device_id    */>             0,                  /* third_party              */>             0,                  /* lun                      */>             0,                  /* reservation_id           */>             0,                  /* extent_list_length1      */>             0,                  /* extent_list_length0      */>             0                   /* control                  */:         };                                                6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }    int cd_release() {      static scsi_releasen
         cmd =_	         {*>             SCSI_RELEASE,       /* opcode                   */>             0,                  /* extent                   */>             0,                  /* third_party_device_id    */>             0,                  /* third_party              */>             0,                  /* lun                      */>             0,                  /* reservation_id           */>             0, 0,               /* reserved                 */>             0                   /* control                  */          };                      6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }t   int cd_test_unit_ready() {      static scsi_test_unit_readyI
         cmd =*	         { 2             SCSI_TEST_UNIT_READY,   /* opcode   */2             0,                      /* reserved */2             0,                      /* lun      */2             0, 0, 0,                /* reserved */2             0                       /* control  */
         };     static int status;       if (cd__cache_io)      {r+         if (cd__cache_test_unit_ready == 0),	         { *             cd__cache_test_unit_ready = 1;@             status = cd_execute_command(&cmd, sizeof cmd, 0, 0);	         }      }m       if (status & 1)e     {          cd__ready = 1;F         cd__loaded = 1; /* well, if it's ready, it must be loaded.. */     }s     else     {          cd__ready = 0;     }        return status; }_   int cd_pause() {      static scsi_pause_resume
         cmd =a	         { .             SCSI_PAUSE_RESUME,  /* opcode   */.             0,                  /* reserved */.             0,                  /* lun      */.             0,0,0,0,0,0,        /* reserved */.             0,                  /* resume   */.             0,                  /* reserved */.             0                   /* control  */
         };  6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }e   int cd_resume()  {n     static scsi_pause_resume
         cmd =_	         { .             SCSI_PAUSE_RESUME,  /* opcode   */.             0,                  /* reserved */.             0,                  /* lun      */.             0,0,0,0,0,0,        /* reserved */.             1,                  /* resume   */.             0,                  /* reserved */.             0                   /* control  */
         };  6     return cd_execute_command(&cmd, sizeof cmd, 0, 0); }    #include <math.h>r #include <time.h>  #define NULL (void *)(0)   int cd_shuffle_play(int flag)e {n     static int         order[100],          next = 0;d         if (next == 0)     {s         int i;           srand(time(NULL));  (         for (i = 0; i < cd__tracks; ++i)	         {              order[i] = i; 	         }d  (         for (i = 0; i < cd__tracks; ++i)	         {e             int tmp, swap;'             swap = rand() % cd__tracks;0             tmp = order[i];e#             order[i] = order[swap];              order[swap] = tmp;	         }   (         for (i = 0; i < cd__tracks; ++i)	         {              int tmp, swap;'             swap = rand() % cd__tracks;l             tmp = order[i];n#             order[i] = order[swap];              order[swap] = tmp;	         }c           next = 0;e     }m       if (next < cd__tracks)     { >         cd_play_track_index( order[next], 1, order[next], 1 );         cd__shuffle_mode = 1;          ++next;      }s     else     {          next = 0;      }      return next; }n