 /*  L The following description describes my intent for the near future. CurrentlyM the stuff is implemented differently, but this is what I'd rather wish I did, ; and what I'd like to see it be. Let me know what you think!   + Album DB Layout: Contains album information   # [rtype][long-key][unique-key][data]        rtype = unsigned byte >     long key = 250 bytes (TOC or Media ID + first part of TOC)%     [unique-key]  = unsigned longword      data = variable length  G     Primary key = rtype + long-key (allow duplicates or not? easier not H         to, but it actually is possible to have duplicates [not likely])H         The layout of the key is to aid in collecting all those annoying-         NULLs together at the end of the key! L     Secondary key = rtype+unique-key (for reverse lookups from related DB's)L     Tertiary key might be rtype+data (that would allow you to quickly search         by album name).   =     if rtype = 0 and long-key = NULLS and unique-key = 0 then   2         data = [next-unique-key][DB creation time]  /             next-unique-key = unsigned longword 1             DB creation time = quadword VMS time.   I             next-unique-key is a short key to be used as an index to SONG G                 DB, as well as other future DB's. This is the key which I                 you can use to "join" multiple DB's. When the album DB is P                 created, this is set to 1, and incremented for every new record.L             DB creation time is a magic number used to verify that a song DBM                 (and other related DB's) are really part of the same group of                  related DB's.        if rtype = 1 then G         long-key = compressed TOC of CD (no media ID was present on CD) N             note that toc is compressed to 20 bits per track, up to 100 tracks-             is legal. 2000 bits is 250 bytes. 1         unique-key = index for joining to Song DB          data = album title       Maybe another rtype:L         data = soundex form of album title (to aid in album title searches!)  ) Song DB layout: Contains song information    [album-key][track][rtype][data]   K     primary key = album-key + track + rtype (note that the order was chosen F         to make a sequential trek through the file appear reasonable).N     Secondary key should be rtype+data (that would allow you to use a ComposerL         DB to make requests like "display all songs performed by Baba Maal")  !     album-key = unsigned longword      track = unsigned byte      rtype = unsigned byte      data = variable length       if rtype = 1 then '         data = song title (for "track")        if rtype = 0 then )         data = [final-track][group-title] M             the tracks between "track" and "final-track" are to be considered 0             as a single "group" i.e. a symphony.  1     Maybe an extra rtype for soundex song titles?      Other Possible DB's include:  C PreferredTrack: To keep track of listeners preferences per album...    [album-key][rtype][data]  K     Primary key is album-key+rtype. seems like no dupes should be allowed..   B     album-key = unsigned longword (maps to unique-key in Album DB)     rtype = unsigned byte        if rtype = 0 then +         data = [track][track][track][etc..] !             track = unsigned byte      maybe: if rtype = 1 then3         data = [volume][track][track][track][etc..] @             volume = unsigned byte - volume to play the album at!             track = unsigned byte      maybe: if rtype = 2 thenC         data = [volume][track][volume][track][volume][track][etc..] @             volume = unsigned byte - volume to play the album at!             track = unsigned byte   L Library DB: For those who want to keep track of what discs they own, and whoN they may have loaned it to.... (hey, who knows? I know I want some way to haveM a big master DB, and yet have a way of keeping track of what disc's I own for $ insurance purposes if nothing else).)     [album-key][rtype][data] (any ideas?)   N Composer DB: This would require additional rtypes in the Album and Song DB, itI would be used to link a song or album to an artist. This DB would contain N artist name and the other DB's would contain pointers to this DB (you wouldn'tL really want all those names stored in each of the other DB's right? I mean -L what's "relational" stand for anyway!) Note the Album and Song mods wouldn'tJ require new DB's, or translating/converting, or whatever - we've made them extensible for a reason!       [composer-key][rtype][data] I         composer key = unsigned longword - maps to unique-key in Album DB        Primary key is composer-key I     Secondary could be rtype + data (to aid in search for a given artist)   #     rtype = 0, data = composer name 6     rtype = 1, data = soundex version of composer name  7     Album DB would then need new rtype, i.e. rtype = 10 .     album record would then be something like:F         [10][long-key][unique-key/composer-key]     ! no data requiredH         This could be used to indicate that all (or most?) tracks are byM         the given artist. To find all albums by a given artist you would then G         search the composer DB, get the "composer-key", then search the O         Album DB key "rtype+unique-key" using [10] + composer-key as the value. 7     Song DB would have new rtype as well, i.e. rtype 10 3         [album-key][track][10][data = composer-key] J         This would be used to indicate a given track is by a given artist.  0 Manufacturer/Label DB: referenced via Album DB. /     same sort of mods required as composer db..    */     /*  P I have to figure out what the user interface is before I get too far along here.  M I ought to have a pop-up when an unrecognized disc gets loaded (i.e. it isn't M in the database). Also a pull-down menu item for bringing up the same pop-up. I Anyway, I should be able to specify what CD database to use, using a file I requestor, I'll have to look into that. Copy from one database to another N would be good (so that I can have a personal db with discs I own, vs. a master& db with any old disc I care to enter).  H Until I get a user interface figured out, how about a single DB, pointed? to by the logicals ALBUM and SONGS (default of sys$login:.dat).   N The DB dialog box upon instantiation should get the current TOC from the disc,N and use the data to populate itself. It should look it up in the DB and set upN "add", "modify", and "delete" buttons, if the disc is new, it should ghost theO "modify" and "delete" buttons. There should be a list widget (perhaps) with 'n'  entries - one for each song.  ( +--------------------------------------+( | Album (43:23) : editable title       |B | Tracks:                            ^ |  (i.e. with a scroll bar)( |      1 (3:23) : editable title     | |( |      2 (4:21) : editable title     | |( |      3 (2:13) : editable title     v |( |      ...                             |( +--------------------------------------+   ??I Let's see, maybe a row column widget - two columns with track label/time, O and track name (text field). one row for the album name, n rows for the tracks.    */   #include <descrip.h> #include <rms.h> #include <ssdef.h> #include "cdrom-data.h"   ' typedef struct dsc$descriptor_s string; ; #define string_dynamic {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}   $ #define PPTR(x) ((x)->dsc$a_pointer)# #define PLEN(x) ((x)->dsc$w_length) # #define SPTR(x) ((x).dsc$a_pointer) " #define SLEN(x) ((x).dsc$w_length)  ) static struct RAB *ctx_album, *ctx_songs;   J /* the key size is 250 bytes for the TOC, plus 1 byte for a record type */ #define LONG_KEY_SIZE 251     # #define ALBUM_DB_NAME       "album" 0 #define ALBUM_DB_DEFAULT    "sys$login:album.cd" #define ALBUM_KEY0_LENGTH 1+250  #define ALBUM_KEY1_LENGTH 1+4 8 #define ALBUM_KEY2_LENGTH 1+50  /* reasonable length? */   struct AlbumRecord {      unsigned char rtype;	     union      {          struct	         { '             unsigned char media_id[15]; 4             unsigned char first_part_of_toc[250-15];         } media_variant;         unsigned char toc[250];      } long_key;      unsigned long unique_key; M     unsigned char data[];   /* unknown length, must use struct via pointer */  };   #define SONG_KEY0_LENGTH 4+1+18 #define SONG_KEY1_LENGTH 1+50   /* reasonable length? */   struct SongRecord  {      unsigned long album_key;     unsigned char track;     unsigned char rtype;M     unsigned char data[];   /* unknown length, must use struct via pointer */  };  N /* short key size includes: unique album id, plus track #, plus record type */ #define SHORT_KEY_SIZE 6   string *db__cvt_toc_to_key() { C     static unsigned char b[1+15+250];   /* to make coding lazier */ 3     static string dummy = {LONG_KEY_SIZE, 0, 0, b};      scsi_read_toc_data toc; !     int i, nibble, index, status;      unsigned long int l;       status = cd_get_toc(&toc);     if (!(status & 1))     {          lib$signal(status);          return 0;      }   ,     for (i = 0; i < sizeof b; ++i) b[i] = 0;  )     index = 1;  /* skip the rtype byte */ ?     /* if the media id is valid, then set the rtype field to 1, .         and put the media id before the TOC */     /* .. yeah, someday .. */        /* compress the toc */     nibble = 0; 0     for (i = 0; i <= toc.header.last_track; ++i)     {   =         l = (toc.track[i].absolute_address.msf.m * 60 * 75) + 8             (toc.track[i].absolute_address.msf.s * 75) +0             toc.track[i].absolute_address.msf.f;G         if (l > 0xfffff) /* 20 bits total (only 19 needed actually!) */ 	         { B             printf("Internal coding error, db__cvt_toc_to_key\n");             return 0; 	         }          if (nibble) 	         { (             b[index] |= (l & 0x0f) << 4;             l = l >> 4; "             b[++index] = l & 0xff;             l = l >> 8; "             b[++index] = l & 0xff;	         }          else	         {               b[index] = l & 0xff;             l = l >> 8; "             b[++index] = l & 0xff;             l = l >> 8; "             b[++index] = l & 0x0f;	         }          nibble = !nibble;      }      return &dummy; }   % int db_modify_album_title(char *name)  { ,     string *long_key = db__cvt_toc_to_key();*     static string record = string_dynamic;     string key = {0, 0, 0, 0};5     string fixed_part = {LONG_KEY_SIZE + 4, 0, 0, 0}; 2     string name_desc = {strlen(name), 0, 0, name};     char *buffer;      int status;     >     status = db_lookup_record( ctx_album, long_key, &record );     if (status & 1)      { (         SPTR(fixed_part) = SPTR(record);5         str$concat(&record, &fixed_part, &name_desc); "         SLEN(key) = LONG_KEY_SIZE;!         SPTR(key) = SPTR(record); >         status = db_update_record( ctx_album, &key,  &record);     }        return status; }   " int db_album_title(string *record) {      int status; %     status = db_lookup_album(record);      if (status & 1)      { F         int skip = LONG_KEY_SIZE + 4 + 1;   /* + 1 for str$right... */2         status = str$right(record, record, &skip);     }      return status; }   # int db_lookup_album(string *record)  { ,     string *long_key = db__cvt_toc_to_key();       int status;   =     status = db_lookup_record( ctx_album, long_key, record ); %     if (!(status & 1)) return status;       return db_unlock(ctx_album); }   L static char null_key[LONG_KEY_SIZE]; /* null record, contains short key.. */    int db_add_album(string *record) { .     static string tmp_record = string_dynamic;9     string index_key = {sizeof null_key, 0, 0, null_key}; ,     string *long_key = db__cvt_toc_to_key();     int *unique_key, i, status; $     string short_key = {4, 0, 0, 0};  7     /* we need to create a short_key and return it.. */ P     /* perform read of dummy record, short key contains next short key to use */D     /* increment it, update the record, then use the short key... */D     status = db_lookup_record( ctx_album, &index_key, &tmp_record );     if (status == RMS$_RNF) *     {   /* oooh, first time apparently? */5         /* append longword '0' to end of record... */          int zero = 0; 2         string first_short_key = {4, 0, 0, &zero};-         str$copy_dx(&tmp_record, &index_key); 2         str$append(&tmp_record, &first_short_key);E         status = db_add_record( ctx_album, &index_key,  &tmp_record); )         if (!(status & 1)) return status; .         /* 'get' the record, and lock it... */H         status = db_lookup_record( ctx_album, &index_key,  &tmp_record);     } %     if (!(status & 1)) return status;   C     unique_key = (int *) ( (int)SPTR(tmp_record) + LONG_KEY_SIZE );      ++(*unique_key);D     status = db_update_record( ctx_album, &index_key,  &tmp_record);%     if (!(status & 1)) return status;   '     str$copy_dx(&tmp_record, long_key); !     SPTR(short_key) = unique_key; (     str$append(&tmp_record, &short_key);?     status = db_add_record( ctx_album, long_key, &tmp_record ); %     if (!(status & 1)) return status;         return db_unlock(ctx_album); }    db_open_cd_databases() {      int status;   +     status = db__open_album_db(&ctx_album); %     if (!(status & 1)) return status;   Q     status = db__open("songs", "sys$login:songs.cd", &ctx_songs, SHORT_KEY_SIZE); %     if (!(status & 1)) return status;   
     return 1;  }   ' db__open_album_db(struct RAB **context)  {      struct FAB *fab;     struct RAB *rab;     struct XABKEY *xab1, *xab2;      int status;   %     rab = malloc(sizeof(struct RAB));      if (rab == 0)      {          return SS$_INSFMEM;      } 1     memcpy(rab, &cc$rms_rab, sizeof(struct RAB));      *context = rab;   %     fab = malloc(sizeof(struct FAB));      if (fab == 0)      {          db__free_rms(rab);         return SS$_INSFMEM;      } /     memcpy(fab,&cc$rms_fab,sizeof(struct FAB));      rab->rab$l_fab = fab;   &     fab->fab$l_dna = ALBUM_DB_DEFAULT;.     fab->fab$b_dns = strlen(ALBUM_DB_DEFAULT);#     fab->fab$l_fna = ALBUM_DB_NAME; +     fab->fab$b_fns = strlen(ALBUM_DB_NAME); C     fab->fab$b_fac = FAB$M_GET | FAB$M_PUT | FAB$M_UPD | FAB$M_DEL; O     fab->fab$b_shr = FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD | FAB$M_SHRDEL;   )     xab1 = malloc(sizeof(struct XABKEY));      if (xab1 == 0)     {          db__free_rms(rab);         return SS$_INSFMEM;      } 8     memcpy(xab1, &cc$rms_xabkey, sizeof(struct XABKEY));     fab->fab$l_xab = xab1;  )     xab2 = malloc(sizeof(struct XABKEY));      if (xab2 == 0)     {          db__free_rms(rab);         return SS$_INSFMEM;      } 8     memcpy(xab2, &cc$rms_xabkey, sizeof(struct XABKEY));     xab1->xab$l_nxt = xab2;        status = sys$open(fab);      if (status == RMS$_PRV) N     {   /* if we can't modify the DB, we oughtta at least try allow reading */*         fab->fab$l_dna = ALBUM_DB_DEFAULT;2         fab->fab$b_dns = strlen(ALBUM_DB_DEFAULT);'         fab->fab$l_fna = ALBUM_DB_NAME; /         fab->fab$b_fns = strlen(ALBUM_DB_NAME); #         fab->fab$b_fac = FAB$M_GET; S         fab->fab$b_shr = FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD | FAB$M_SHRDEL;          status = sys$open(fab);      }      if (!(status & 1))     { #         fab->fab$b_org = FAB$C_IDX; "         fab->fab$b_rat = FAB$M_CR;#         fab->fab$b_rfm = FAB$C_VAR;   $         xab1->xab$b_dtp = XAB$C_STG;         xab1->xab$w_pos0 = 0; -         xab1->xab$b_siz0 = ALBUM_KEY0_LENGTH; L         xab1->xab$l_knm = "compressed table of contents    "; /* 32 bytes */           xab2->xab$b_ref = 1;$         xab2->xab$b_dtp = XAB$C_STG;-         xab2->xab$w_pos0 = ALBUM_KEY0_LENGTH;          xab2->xab$b_siz0 = 4;          xab2->xab$w_pos1 = 0;          xab2->xab$b_siz1 = 1; 0         xab2->xab$b_flg = XAB$M_CHG | XAB$M_DUP;L         xab2->xab$l_knm = "record type and short key       "; /* 32 bytes */!         status = sys$create(fab);      }        if (!(status & 1))     {          db__free_rms(rab);         *context = 0;          return status;     }        status = sys$connect(rab);     if (! (status & 1))      {          sys$close(fab);          db__free_rms(rab);         *context = 0;          return status;     }   
     return 1;  }   1 db__open(filespec, defaultspec, context, keysize) !     char *filespec, *defaultspec;      struct RAB **context;      int keysize; {o     struct FAB *fab;     struct RAB *rab;     struct XABKEY *xab;u     int status;d  %     rab = malloc(sizeof(struct RAB));o     if (rab == 0)k     {t         return SS$_INSFMEM;u     }a1     memcpy(rab, &cc$rms_rab, sizeof(struct RAB));k     *context = rab;p  %     fab = malloc(sizeof(struct FAB));t     if (fab == 0)      {          db__free_rms(rab);         return SS$_INSFMEM;      }v/     memcpy(fab,&cc$rms_fab,sizeof(struct FAB));k     rab->rab$l_fab = fab;?  !     fab->fab$l_dna = defaultspec;a)     fab->fab$b_dns = strlen(defaultspec);eC     fab->fab$b_fac = FAB$M_GET | FAB$M_PUT | FAB$M_UPD | FAB$M_DEL;      fab->fab$l_fna = filespec;&     fab->fab$b_fns = strlen(filespec);O     fab->fab$b_shr = FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD | FAB$M_SHRDEL;mT     /* fab->fab$b_acmodes = 1; */ /* disable anything less then exec mode logical */  (     xab = malloc(sizeof(struct XABKEY));     if (xab == 0)      {          db__free_rms(rab);         return SS$_INSFMEM;      }t5     memcpy(xab,&cc$rms_xabkey,sizeof(struct XABKEY));o     fab->fab$l_xab = xab;        status = sys$open(fab);   !     if (!(status & 1) && keysize)      { #         fab->fab$b_org = FAB$C_IDX;r"         fab->fab$b_rat = FAB$M_CR;#         fab->fab$b_rfm = FAB$C_VAR;n#         xab->xab$b_dtp = XAB$C_STG;          xab->xab$w_pos0 = 0;"         xab->xab$b_siz0 = keysize;!         status = sys$create(fab);e     }i       if (!(status & 1))     {f         db__free_rms(rab);         *context = 0;d         return status;     }a       status = sys$connect(rab);     if (! (status & 1))e     {e         sys$close(fab);m         db__free_rms(rab);         *context = 0;          return status;     }m  
     return 1;s }r    " db_lookup_record(rab, key, record)     struct RAB *rab;     string *key, *record;k {=:     char buffer[4096]; /* this oughta be big enough eh? */"     string s1 = {0, 0, 0, buffer};     int status;r  3     /* set up the key and buffer address/lengths */o     rab->rab$l_kbf = PPTR(key);m     rab->rab$b_ksz = PLEN(key);e     rab->rab$b_rac = RAB$C_KEY;u5     rab->rab$l_rop = RAB$M_RLK; /* lock the record */      rab->rab$l_ubf = buffer;#     rab->rab$w_usz = sizeof buffer;e       status = sys$get(rab);%     if (!(status & 1)) return status;s  %     s1.dsc$w_length = rab->rab$w_rsz; $     return str$copy_dx(record, &s1); }     3 db_lookup_record_via_index(rab, index, key, record)      struct RAB *rab;     int index;     string *key, *record;e {h:     char buffer[4096]; /* this oughta be big enough eh? */"     string s1 = {0, 0, 0, buffer};     int status;i  3     /* set up the key and buffer address/lengths */n     rab->rab$l_kbf = PPTR(key);      rab->rab$b_ksz = PLEN(key);s     rab->rab$b_rac = RAB$C_KEY; 5     rab->rab$l_rop = RAB$M_RLK; /* lock the record */      rab->rab$l_ubf = buffer;#     rab->rab$w_usz = sizeof buffer;s       rab->rab$b_krf = index;      status = sys$get(rab);     rab->rab$b_krf = 0;b%     if (!(status & 1)) return status;d  %     s1.dsc$w_length = rab->rab$w_rsz;d$     return str$copy_dx(record, &s1); })   db_next_record(rab, record)      struct RAB *rab;     string *record;c {t:     char buffer[4096]; /* this oughta be big enough eh? */"     string s1 = {0, 0, 0, buffer};     int status;r  3     /* set up the key and buffer address/lengths */e     rab->rab$b_rac = RAB$C_SEQ; 5     rab->rab$l_rop = RAB$M_NLK; /* lock the record */t     rab->rab$l_ubf = buffer;#     rab->rab$w_usz = sizeof buffer;[       status = sys$get(rab);%     if (!(status & 1)) return status;h  %     s1.dsc$w_length = rab->rab$w_rsz;b$     return str$copy_dx(record, &s1); }    db_delete_record(rab, key)     struct RAB *rab;     string *key; {.     int status;   3     /* set up the key and buffer address/lengths */t     rab->rab$l_kbf = PPTR(key);h     rab->rab$b_ksz = PLEN(key);u     rab->rab$b_rac = RAB$C_KEY;b5     rab->rab$l_rop = RAB$M_RLK; /* lock the record */        status = sys$get(rab);%     if (!(status & 1)) return status;e       return sys$delete(rab);o }    db_add_record(rab, key, val)     struct RAB *rab;     string *key, *val; {t3     /* set up the key and buffer address/lengths */a     rab->rab$l_kbf = PPTR(key);B     rab->rab$b_ksz = PLEN(key);i     rab->rab$b_rac = RAB$C_KEY;      rab->rab$l_rbf = PPTR(val);u     rab->rab$w_rsz = PLEN(val);e5     rab->rab$l_rop = RAB$M_RLK; /* lock the record */r       return sys$put(rab); }y   db_update_record(rab, key, val)u     struct RAB *rab;     string *key, *val; { 3     /* set up the key and buffer address/lengths */o     rab->rab$l_kbf = PPTR(key);a     rab->rab$b_ksz = PLEN(key);t     rab->rab$l_rbf = PPTR(val);      rab->rab$w_rsz = PLEN(val);o;     rab->rab$l_rop = RAB$M_NLK; /* don't lock the record */        return sys$update(rab);o }w   db_unlock(rab)     struct RAB *rab; {l     int status;e       status = sys$free(rab);e'     if (status == RMS$_RNL) status = 1;i     return status; })   db__free_rms(struct RAB *rab)  {i     if (rab)     {s)         struct FAB *fab = rab->rab$l_fab;          if (fab)	         {h             struct NAM&                 *nam = fab->fab$l_nam;             struct XAB&                 *xab = fab->fab$l_xab,                 *nxt;a             if (nam) free(nam);a             while (xab) 
             { 1                 struct XAB *nxt = xab->xab$l_nxt;a                 free(xab);                 xab = nxt;
             }              free(fab);	         }d         free(rab);     }  }*