G /********************************************************************** L Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved tonal.c G **********************************************************************/ G /********************************************************************** G  * MPEG/audio coding/decoding software, work in progress              * G  *   NOT for public distribution until verified and approved by the   * G  *   MPEG/audio committee.  For further information, please contact   * G  *   Davis Pan, 508-493-2241, e-mail: pan@3d.enet.dec.com             * G  *                                                                    * G  * VERSION 3.9t                                                       * G  *   changes made since last update:                                  * G  *   date   programmers         comment                               * G  * 2/25/91  Douglas Wong        start of version 1.1 records          * G  * 3/06/91  Douglas Wong        rename: setup.h to endef.h            * G  *                              updated I_psycho_one and II_psycho_one* G  * 3/11/91  W. J. Carter        Added Douglas Wong's updates dated    * G  *                              3/9/91 for I_Psycho_One() and for     * G  *                              II_Psycho_One().                      * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  *                              Located and fixed numerous software   * G  *                              bugs and table data errors.           * G  * 6/11/91  Davis Pan           corrected several bugs                * G  *                              based on comments from H. Fuchs       * G  * 01jul91  dpwe (Aware Inc.)   Made pow() args float                 * G  *                              Removed logical bug in I_tonal_label: * G  *                              Sometimes *tone returned == STOP      * G  * 7/10/91  Earle Jennings      no change necessary in port to MsDos  * G  * 11sep91  dpwe@aware.com      Subtracted 90.3dB from II_f_f_t peaks * G  * 10/1/91  Peter W. Farrett    Updated II_Psycho_One(),I_Psycho_One()* G  *                              to include comments.                  * G  *11/29/91  Masahiro Iwadare    Bug fix regarding POWERNORM           * G  *                              fixed several other miscellaneous bugs* G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 2/12/92  Masahiro Iwadare    Fixed some potential bugs in          * G  *          Davis Pan           subsampling()                         * G  * 2/25/92  Masahiro Iwadare    Fixed some more potential bugs        * H  * 6/24/92  Tan Ah Peng         Modified window for FFT               * G  *                              (denominator N-1 to N)                * G  *                              Updated all critical band rate &      * G  *                              absolute threshold tables and critical* I  *                              boundaries for use with Layer I & II  *   G  *                              Corrected boundary limits for tonal   * G  *                              component computation                 * G  *                              Placement of non-tonal component at   * G  *                              geometric mean of critical band       * G  *                              (previous placement method commented  * G  *                               out - can be used if desired)        * G  * 3/01/93  Mike Li             Infinite looping fix in noise_label() * G  * 3/19/93  Jens Spille         fixed integer overflow problem in     * G  *                              psychoacoutic model 1                 * G  * 3/19/93  Giorgio Dimino      modifications to better account for   * G  *                              tonal and non-tonal components        * G  * 5/28/93 Sriram Jayasimha     "London" mod. to psychoacoustic model1* G  * 8/05/93 Masahiro Iwadare     noise_label modification "option"     * H  **********************************************************************/   #include "common.h"  #include "encoder.h"B #define LONDON                  /* enable "LONDON" modification */F #define MAKE_SENSE              /* enable "MAKE_SENSE" modification */E #define MI_OPTION               /* enable "MI_OPTION" modification */ H /**********************************************************************/ /*C /*        This module implements the psychoacoustic model I for the D /* MPEG encoder layer II. It uses simplified tonal and noise maskingD /* threshold analysis to generate SMR for the encoder bit allocation /* routine.  /*H /**********************************************************************/   int crit_band; int FAR *cbound;
 int sub_size;   A void read_cbound(lay,freq)  /* this function reads in critical */ A int lay, freq;              /* band boundaries                 */  {   int i,j,k; 
  FILE *fp;  char r[16], t[80];     strcpy(r, "2cb1");   r[0] = (char) lay + '0';   r[3] = (char) freq + '0';B  if( !(fp = OpenTableFile(r)) ){       /* check boundary values */1     printf("Please check %s boundary table\n",r);      exit(1);  }B  fgets(t,80,fp);               /* read input for critical bands */  sscanf(t,"%d\n",&crit_band); C  cbound = (int FAR *) mem_alloc(sizeof(int) * crit_band, "cbound"); =  for(i=0;i<crit_band;i++){   /* continue to read input for */ ?     fgets(t,80,fp);            /* critical band boundaries   */      sscanf(t,"%d %d\n",&j, &k);      if(i==j) cbound[j] = k; *     else {                     /* error */@        printf("Please check index %d in cbound table %s\n",i,r);        exit(1);      }   }  fclose(fp);	 }           A void read_freq_band(ltg,lay,freq)  /* this function reads in   */ A int lay, freq;                     /* frequency bands and bark */ = g_ptr FAR *ltg;                /* values                   */  {   int i,j, k;  double b,c;
  FILE *fp;  char r[16], t[80];     strcpy(r, "2th1");   r[0] = (char) lay + '0';   r[3] = (char) freq + '0';<  if( !(fp = OpenTableFile(r)) ){   /* check freq. values  */<     printf("Please check frequency and cband table %s\n",r);     exit(1);  }A  fgets(t,80,fp);              /* read input for freq. subbands */   sscanf(t,"%d\n",&sub_size);B  *ltg = (g_ptr FAR ) mem_alloc(sizeof(g_thres) * sub_size, "ltg");G  (*ltg)[0].line = 0;          /* initialize global masking threshold */   (*ltg)[0].bark = 0;  (*ltg)[0].hear = 0;A  for(i=1;i<sub_size;i++){    /* continue to read freq. subband */ A     fgets(t,80,fp);          /* and assign                     */ /     sscanf(t,"%d %d %lf %lf\n",&j, &k, &b, &c);      if(i == j){         (*ltg)[j].line = k;        (*ltg)[j].bark = b;        (*ltg)[j].hear = c;     } (     else {                   /* error */A        printf("Please check index %d in freq-cb table %s\n",i,r);         exit(1);      }   }  fclose(fp); }   B void make_map(power, ltg)       /* this function calculates the */> mask FAR power[HAN_SIZE];   /* global masking threshold     */ g_thres FAR *ltg;  { 	  int i,j;   @  for(i=1;i<sub_size;i++) for(j=ltg[i-1].line;j<=ltg[i].line;j++)     power[j].map = i;  }    double add_db(a,b) double a,b;  {   a = pow(10.0,a/10.0);  b = pow(10.0,b/10.0);  return 10 * log10(a+b); }   B /****************************************************************/ /*6 /*        Fast Fourier transform of the input samples. /*B /****************************************************************/  C void II_f_f_t(sample, power)      /* this function calculates an */ ? double FAR sample[FFT_SIZE];  /* FFT analysis for the freq.  */*? mask FAR power[HAN_SIZE];     /* domain                      */, {l  int i,j,k,L,l=0;o  int ip, le, le1;*  double t_r, t_i, u_r, u_i;*   static int M, MM1, init = 0, N;  double *x_r, *x_i, *energy;  static int *rev;*  static double *w_r, *w_i;  1  x_r = (double *) mem_alloc(sizeof(DFFT), "x_r"); 1  x_i = (double *) mem_alloc(sizeof(DFFT), "x_i");l7  energy = (double *) mem_alloc(sizeof(DFFT), "energy");t9  for(i=0;i<FFT_SIZE;i++) x_r[i] = x_i[i] = energy[i] = 0;v  if(!init){91     rev = (int *) mem_alloc(sizeof(IFFT), "rev"); 3     w_r = (double *) mem_alloc(sizeof(D10), "w_r"); 3     w_i = (double *) mem_alloc(sizeof(D10), "w_i");      M = 10;      MM1 = 9;     N = FFT_SIZE;a     for(L=0;L<M;L++){d        le = 1 << (M-L);         le1 = le >> 1;t        w_r[L] = cos(PI/le1);        w_i[L] = -sin(PI/le1);      }2=     for(i=0;i<FFT_SIZE;rev[i] = l,i++) for(j=0,l=0;j<10;j++){         k=(i>>j) & 1;%        l |= (k<<9-j);                f     } 
     init = 1;   }C  memcpy( (char *) x_r, (char *) sample, sizeof(double) * FFT_SIZE);1  for(L=0;L<MM1;L++){     le = 1 << (M-L);     le1 = le >> 1;     u_r = 1;     u_i = 0;     for(j=0;j<le1;j++){h        for(i=j;i<N;i+=le){           ip = i + le1; !           t_r = x_r[i] + x_r[ip]; !           t_i = x_i[i] + x_i[ip];r%           x_r[ip] = x_r[i] - x_r[ip]; %           x_i[ip] = x_i[i] - x_i[ip];o           x_r[i] = t_r;s           x_i[i] = t_i;            t_r = x_r[ip];2           x_r[ip] = x_r[ip] * u_r - x_i[ip] * u_i;.           x_i[ip] = x_i[ip] * u_r + t_r * u_i;        }        t_r = u_r; )        u_r = u_r * w_r[L] - u_i * w_i[L]; )        u_i = u_i * w_r[L] + t_r * w_i[L];a     })  }  for(i=0;i<N;i+=2){      ip = i + 1;      t_r = x_r[i] + x_r[ip];o     t_i = x_i[i] + x_i[ip];      x_r[ip] = x_r[i] - x_r[ip];      x_i[ip] = x_i[i] - x_i[ip];      x_r[i] = t_r;      x_i[i] = t_i; 2     energy[i] = x_r[i] * x_r[i] + x_i[i] * x_i[i];  }&  for(i=0;i<FFT_SIZE;i++) if(i<rev[i]){     t_r = energy[i];     energy[i] = energy[rev[i]];a     energy[rev[i]] = t_r;o  }C  for(i=0;i<HAN_SIZE;i++){    /* calculate power density spectrum */ -     if (energy[i] < 1E-20) energy[i] = 1E-20;i3     power[i].x = 10 * log10(energy[i]) + POWERNORM;      power[i].next = STOP;      power[i].type = FALSE;  }  mem_free((void **) &x_r);  mem_free((void **) &x_i);  mem_free((void **) &energy);  }   B /****************************************************************/ /*, /*         Window the incoming audio signal. /*B /****************************************************************/  C void II_hann_win(sample)          /* this function calculates a  */s? double FAR sample[FFT_SIZE];  /* Hann window for PCM (input) */eC {                                 /* samples for a 1024-pt. FFT  */   register int i;  register double sqrt_8_over_3;   static int init = 0;   static double FAR *window;   F  if(!init){  /* calculate window function for the Fourier transform */>     window = (double FAR *) mem_alloc(sizeof(DFFT), "window");&     sqrt_8_over_3 = pow(8.0/3.0, 0.5);     for(i=0;i<FFT_SIZE;i++){         /* Hann window formula */I        window[i]=sqrt_8_over_3*0.5*(1-cos(2.0*PI*i/(FFT_SIZE)))/FFT_SIZE;      }d
     init = 1;   }0  for(i=0;i<FFT_SIZE;i++) sample[i] *= window[i]; }n  E /*******************************************************************/  /*D /*        This function finds the maximum spectral component in eachC /* subband and return them to the encoder for time-domain thresholdn /* determination.  /*E /*******************************************************************/t #ifndef LONDON void II_pick_max(power, spike) double FAR spike[SBLIMIT]; mask FAR power[HAN_SIZE];  {   double max;	  int i,j;   K  for(i=0;i<HAN_SIZE;spike[i>>4] = max, i+=16)      /* calculate the      */oK  for(j=0, max = DBMIN;j<16;j++)                    /* maximum spectral   */ K     max = (max>power[i+j].x) ? max : power[i+j].x; /* component in each  */eK }                                                  /* subband from bound */sK                                                    /* 4-16               */i #else  void II_pick_max(power, spike) double FAR spike[SBLIMIT]; mask FAR power[HAN_SIZE];  {r  double sum;	  int i,j;i  9  for(i=0;i<HAN_SIZE;spike[i>>4] = 10.0*log10(sum), i+=16) K                                                    /* calculate the      */LJ  for(j=0, sum = pow(10.0,0.1*DBMIN);j<16;j++)      /* sum of spectral   */K    sum += pow(10.0,0.1*power[i+j].x);              /* component in each  */*K }                                                  /* subband from bound */"K                                                    /* 4-16               */  #endif  B /****************************************************************/ /*? /*        This function labels the tonal component in the power* /* spectrum. /*B /****************************************************************/  F void II_tonal_label(power, tone)  /* this function extracts (tonal) */B mask FAR power[HAN_SIZE];     /* sinusoidals from the spectrum  */
 int *tone; { B  int i,j, last = LAST, first, run, last_but_one = LAST; /* dpwe */  double max;    *tone = LAST;  for(i=2;i<HAN_SIZE-12;i++){<     if(power[i].x>power[i-1].x && power[i].x>=power[i+1].x){        power[i].type = TONE;        power[i].next = LAST;-        if(last != LAST) power[last].next = i;         else first = *tone = i;        last = i;     }t  }
  last = LAST;,  first = *tone;   *tone = LAST;P  while(first != LAST){               /* the conditions for the tonal          */P     if(first<3 || first>500) run = 0;/* otherwise k+/-j will be out of bounds */P     else if(first<63) run = 2;       /* components in layer II, which         */P     else if(first<127) run = 3;      /* are the boundaries for calc.          */P     else if(first<255) run = 6;      /* the tonal components                  */     else run = 12;G     max = power[first].x - 7;        /* after calculation of tonal   */ G     for(j=2;j<=run;j++)              /* components, set to local max *//<        if(max < power[first-j].x || max < power[first+j].x){$           power[first].type = FALSE;           break;        }C     if(power[first].type == TONE){   /* extract tonal components */         int help=first;%        if(*tone==LAST) *tone = first; E        while((power[help].next!=LAST)&&(power[help].next-first)<=run)t            help=power[help].next;        help=power[help].next;p        power[first].next=help;        if((first-last)<=run){ B           if(last_but_one != LAST) power[last_but_one].next=first;        }C        if(first>1 && first<500){     /* calculate the sum of the */}C           double tmp;                /* powers of the components */ ;           tmp = add_db(power[first-1].x, power[first+1].x);s7           power[first].x = add_db(power[first].x, tmp);         }        for(j=1;j<=run;j++){r6           power[first-j].x = power[first+j].x = DBMIN;;           power[first-j].next = power[first+j].next = STOP;d<           power[first-j].type = power[first+j].type = FALSE;        }        last_but_one=last;l        last = first;!        first = power[first].next;]     } 
     else {        int ll;>        if(last == LAST); /* *tone = power[first].next; dpwe */1        else power[last].next = power[first].next;         ll = first;!        first = power[first].next;         power[ll].next = STOP;d     }a  } },  B /****************************************************************/ /*: /*        This function groups all the remaining non-tonal? /* spectral lines into critical band where they are replaced byt /* one single line.o /*B /****************************************************************/         # void noise_label(power, noise, ltg)0 g_thres FAR *ltg;  mask FAR *power; int *noise;* {*  int i,j, centre, last = LAST;  double index, weight, sum;tD                               /* calculate the remaining spectral */D  for(i=0;i<crit_band-1;i++){  /* lines for non-tonal components   */A      for(j=cbound[i],weight = 0.0,sum = DBMIN;j<cbound[i+1];j++){*"         if(power[j].type != TONE){#            if(power[j].x != DBMIN){ +               sum = add_db(power[j].x,sum);0N /* the line below and others under the "MAKE_SENSE" condition are an alternateL    interpretation of "geometric mean". This approach may make more sense but+    it has not been tested with hardware. */D #ifdef MAKE_SENSEiP               weight += pow(10.0, power[j].x/10.0) * (ltg[power[j].map].bark-i); #endif!               power[j].x = DBMIN;;            }G         }   /*  check to see if the spectral line is low dB, and if  */fF      }      /* so replace the center of the critical band, which is */F             /* the center freq. of the noise component              */   #ifdef MAKE_SENSE_;      if(sum <= DBMIN)  centre = (cbound[i+1]+cbound[i]) /2;       else {>*         index = weight/pow(10.0,sum/10.0);O         centre = cbound[i] + (int) (index * (double) (cbound[i+1]-cbound[i]) );0      } ) #else I      index = (double)( ((double)cbound[i]) * ((double)(cbound[i+1]-1)) );=(      centre = (int)(pow(index,0.5)+0.5); #endif  9     /* locate next non-tonal component until finished; */19     /* add to list of non-tonal components             */  #ifdef MI_OPTION?      /* Masahiro Iwadare's fix for infinite looping problem? */ $      if(power[centre].type == TONE) A        if (power[centre+1].type == TONE) centre++; else centre--;  #else 5      /* Mike Li's fix for infinite looping problem */r.      if(power[centre].type == FALSE) centre++;  %      if(power[centre].type == NOISE){ 5        if(power[centre].x >= ltg[power[i].map].hear){_H          if(sum >= ltg[power[i].map].hear) sum = add_db(power[j].x,sum);
          else           sum = power[centre].x;]        }      } #endif&      if(last == LAST) *noise = centre;      else {i"         power[centre].next = LAST;"         power[last].next = centre;      }      power[centre].x = sum;_(      power[centre].type = NOISE;              last = centre;i
  }         }i  B /****************************************************************/ /*= /*        This function reduces the number of noise and tonal , /* component for further threshold analysis. /*B /****************************************************************/  ) void subsampling(power, ltg, tone, noise)R mask FAR power[HAN_SIZE];  g_thres FAR *ltg;] int *tone, *noise; {m  int i, old;  ?  i = *tone; old = STOP;    /* calculate tonal components for */ ?  while(i!=LAST){           /* reduction of spectral lines    */*,     if(power[i].x < ltg[power[i].map].hear){        power[i].type = FALSE;*        power[i].x = DBMIN;-        if(old == STOP) *tone = power[i].next;m,        else power[old].next = power[i].next;     }b     else old = i;I     i = power[i].next;  }D  i = *noise; old = STOP;    /* calculate non-tonal components for */D  while(i!=LAST){            /* reduction of spectral lines        */,     if(power[i].x < ltg[power[i].map].hear){        power[i].type = FALSE;         power[i].x = DBMIN;.        if(old == STOP) *noise = power[i].next;,        else power[old].next = power[i].next;     }      else old = i;      i = power[i].next;  }  i = *tone; old = STOP;oF  while(i != LAST){                              /* if more than one */F     if(power[i].next == LAST)break;             /* tonal component  */F     if(ltg[power[power[i].next].map].bark -     /* is less than .5  */F        ltg[power[i].map].bark < 0.5) {          /* bark, take the   */F        if(power[power[i].next].x > power[i].x ){/* maximum          */0           if(old == STOP) *tone = power[i].next;/           else power[old].next = power[i].next;*            power[i].type = FALSE;           power[i].x = DBMIN;k           i = power[i].next;        }
        else {],           power[power[i].next].type = FALSE;)           power[power[i].next].x = DBMIN; 4           power[i].next = power[power[i].next].next;           old = i;        }     }r
     else {       old = i;       i = power[i].next;     }/  } }n  B /****************************************************************/ /*? /*        This function calculates the individual threshold and = /* sum with the quiet threshold to find the global threshold.r /*B /****************************************************************/  1 void threshold(power, ltg, tone, noise, bit_rate)> mask FAR power[HAN_SIZE];6 g_thres FAR *ltg;  int *tone, *noise, bit_rate; { 
  int k, t;  double dz, tmps, vf;0    for(k=1;k<sub_size;k++){<     ltg[k].x = DBMIN;sH     t = *tone;          /* calculate individual masking threshold for */H     while(t != LAST){   /* components in order to find the global     */K        if(ltg[k].bark-ltg[power[t].map].bark >= -3.0 && /*threshold (LTG)*/-3           ltg[k].bark-ltg[power[t].map].bark <8.0){*N           dz = ltg[k].bark-ltg[power[t].map].bark; /* distance of bark value*/H           tmps = -1.525-0.275*ltg[power[t].map].bark - 4.5 + power[t].x;<              /* masking function for lower & upper slopes */A           if(-3<=dz && dz<-1) vf = 17*(dz+1)-(0.4*power[t].x +6);RB           else if(-1<=dz && dz<0) vf = (0.4 *power[t].x + 6) * dz;/           else if(0<=dz && dz<1) vf = (-17*dz);uK           else if(1<=dz && dz<8) vf = -(dz-1) * (17-0.15 *power[t].x) - 17;-           tmps += vf;        e,           ltg[k].x = add_db(ltg[k].x, tmps);        }        t = power[t].next;i     }=  D     t = *noise;        /* calculate individual masking threshold  */D     while(t != LAST){  /* for non-tonal components to find LTG    */7        if(ltg[k].bark-ltg[power[t].map].bark >= -3.0 && 3           ltg[k].bark-ltg[power[t].map].bark <8.0){ O           dz = ltg[k].bark-ltg[power[t].map].bark; /* distance of bark value */ G           tmps = -1.525-0.175*ltg[power[t].map].bark -0.5 + power[t].x; <              /* masking function for lower & upper slopes */A           if(-3<=dz && dz<-1) vf = 17*(dz+1)-(0.4*power[t].x +6); B           else if(-1<=dz && dz<0) vf = (0.4 *power[t].x + 6) * dz;/           else if(0<=dz && dz<1) vf = (-17*dz);fK           else if(1<=dz && dz<8) vf = -(dz-1) * (17-0.15 *power[t].x) - 17;l           tmps += vf; ,           ltg[k].x = add_db(ltg[k].x, tmps);        }        t = power[t].next;;     } <     if(bit_rate<96)ltg[k].x = add_db(ltg[k].hear, ltg[k].x);7     else ltg[k].x = add_db(ltg[k].hear-12.0, ltg[k].x);   } }t  B /****************************************************************/ /*? /*        This function finds the minimum masking threshold and # /* return the value to the encoder.r /*B /****************************************************************/  ' void II_minimum_mask(ltg,ltmin,sblimit)s g_thres FAR *ltg;  double FAR ltmin[SBLIMIT]; int sblimit; {h  double min;	  int i,j;     j=1;t  for(i=0;i<sblimit;i++)eL     if(j>=sub_size-1)                   /* check subband limit, and       */L        ltmin[i] = ltg[sub_size-1].hear; /* calculate the minimum masking  */L     else {                              /* level of LTMIN for each subband*/        min = ltg[j].x;2        while(ltg[j].line>>4 == i && j < sub_size){(        if(min>ltg[j].x)  min = ltg[j].x;        j++;      }}     ltmin[i] = min;=  } }   C /*****************************************************************/l /*= /*        This procedure is called in musicin to pick out thes+ /* smaller of the scalefactor or threshold.t /*C /*****************************************************************/e  ) void II_smr(ltmin, spike, scale, sblimit) : double FAR spike[SBLIMIT], scale[SBLIMIT], ltmin[SBLIMIT]; int sblimit; {   int i;   double max;                 I  for(i=0;i<sblimit;i++){                     /* determine the signal   */eI     max = 20 * log10(scale[i] * 32768) - 10; /* level for each subband */*I     if(spike[i]>max) max = spike[i];         /* for the maximum scale  */0I     max -= ltmin[i];                         /* factors                */      ltmin[i] = max;   } }w         B /****************************************************************/ /*= /*        This procedure calls all the necessary functions tot( /* complete the psychoacoustic analysis. /*B /****************************************************************/  / void II_Psycho_One(buffer, scale, ltmin, fr_ps)u short FAR buffer[2][1152];0 double FAR scale[2][SBLIMIT], ltmin[2][SBLIMIT]; frame_params *fr_ps; {r  layer *info = fr_ps->header;m  int   stereo = fr_ps->stereo;   int   sblimit = fr_ps->sblimit;  int k,i, tone=0, noise=0;  static char init = 0;  static int off[2] = {256,256};   double *sample;
  DSBL *spike;m  static D1408 *fft_buf;   static mask_ptr FAR power;;  static g_ptr FAR ltg;  7  sample = (double *) mem_alloc(sizeof(DFFT), "sample"); 4  spike = (DSBL *) mem_alloc(sizeof(D2SBL), "spike");8      /* call functions for critical boundaries, freq. */2  if(!init){  /* bands, bark values, and mapping */G     fft_buf = (D1408 *) mem_alloc((long) sizeof(D1408) * 2, "fft_buf"); H     power = (mask_ptr FAR ) mem_alloc(sizeof(mask) * HAN_SIZE, "power");4     read_cbound(info->lay,info->sampling_frequency);<     read_freq_band(&ltg,info->lay,info->sampling_frequency);     make_map(power,ltg);;     for (i=0;i<1408;i++) fft_buf[0][i] = fft_buf[1][i] = 0;f
     init = 1;t  }J  for(k=0;k<stereo;k++){  /* check pcm input for 3 blocks of 384 samples */P     for(i=0;i<1152;i++) fft_buf[k][(i+off[k])%1408]= (double)buffer[k][i]/SCALE;I     for(i=0;i<FFT_SIZE;i++) sample[i] = fft_buf[k][(i+1216+off[k])%1408];i     off[k] += 1152;p     off[k] %= 1408;eJ                             /* call functions for windowing PCM samples,*/J     II_hann_win(sample);    /* location of spectral components in each  */J     for(i=0;i<HAN_SIZE;i++) power[i].x = DBMIN;  /*subband with labeling*/J     II_f_f_t(sample, power);                     /*locate remaining non-*/J     II_pick_max(power, &spike[k][0]);            /*tonal sinusoidals,   */J     II_tonal_label(power, &tone);                /*reduce noise & tonal */J     noise_label(power, &noise, ltg);             /*components, find     */J     subsampling(power, ltg, &tone, &noise);      /*global & minimal     */J     threshold(power, ltg, &tone, &noise,         /*threshold, and sgnl- */J       bitrate[info->lay-1][info->bitrate_index]/stereo); /*to-mask ratio*/0     II_minimum_mask(ltg, &ltmin[k][0], sblimit);F     II_smr(&ltmin[k][0], &spike[k][0], &scale[k][0], sblimit);          }  mem_free((void **) &sample);e  mem_free((void **) &spike); }_  H /**********************************************************************/ /*C /*        This module implements the psychoacoustic model I for the C /* MPEG encoder layer I. It uses simplified tonal and noise masking[D /* threshold analysis to generate SMR for the encoder bit allocation /* routine.i /*H /**********************************************************************/  B /****************************************************************/ /*6 /*        Fast Fourier transform of the input samples. /*B /****************************************************************/  B void I_f_f_t(sample, power)         /* this function calculates */> double FAR sample[FFT_SIZE/2];  /* an FFT analysis for the  */> mask FAR power[HAN_SIZE/2];     /* freq. domain             */ {   int i,j,k,L,l=0;d  int ip, le, le1;e  double t_r, t_i, u_r, u_i;l   static int M, MM1, init = 0, N;  double *x_r, *x_i, *energy;  static int *rev;   static double *w_r, *w_i;  2  x_r = (double *) mem_alloc(sizeof(DFFT2), "x_r");2  x_i = (double *) mem_alloc(sizeof(DFFT2), "x_i");8  energy = (double *) mem_alloc(sizeof(DFFT2), "energy");;  for(i=0;i<FFT_SIZE/2;i++) x_r[i] = x_i[i] = energy[i] = 0;w  if(!init){m2     rev = (int *) mem_alloc(sizeof(IFFT2), "rev");2     w_r = (double *) mem_alloc(sizeof(D9), "w_r");2     w_i = (double *) mem_alloc(sizeof(D9), "w_i");
     M = 9;     MM1 = 8;     N = FFT_SIZE/2;e     for(L=0;L<M;L++){         le = 1 << (M-L);o        le1 = le >> 1;         w_r[L] = cos(PI/le1);        w_i[L] = -sin(PI/le1);      }[>     for(i=0;i<FFT_SIZE/2;rev[i] = l,i++) for(j=0,l=0;j<9;j++){        k=(i>>j) & 1;%        l |= (k<<8-j);                x     } 
     init = 1;*  }E  memcpy( (char *) x_r, (char *) sample, sizeof(double) * FFT_SIZE/2);   for(L=0;L<MM1;L++){     le = 1 << (M-L);     le1 = le >> 1;     u_r = 1;     u_i = 0;     for(j=0;j<le1;j++){o        for(i=j;i<N;i+=le){           ip = i + le1;*!           t_r = x_r[i] + x_r[ip];s!           t_i = x_i[i] + x_i[ip];a%           x_r[ip] = x_r[i] - x_r[ip];e%           x_i[ip] = x_i[i] - x_i[ip];t           x_r[i] = t_r;l           x_i[i] = t_i;k           t_r = x_r[ip];2           x_r[ip] = x_r[ip] * u_r - x_i[ip] * u_i;.           x_i[ip] = x_i[ip] * u_r + t_r * u_i;        }        t_r = u_r;t)        u_r = u_r * w_r[L] - u_i * w_i[L]; )        u_i = u_i * w_r[L] + t_r * w_i[L];3     }*  }  for(i=0;i<N;i+=2){      ip = i + 1;t     t_r = x_r[i] + x_r[ip];      t_i = x_i[i] + x_i[ip];g     x_r[ip] = x_r[i] - x_r[ip];o     x_i[ip] = x_i[i] - x_i[ip];-     x_r[i] = t_r;e     x_i[i] = t_i;52     energy[i] = x_r[i] * x_r[i] + x_i[i] * x_i[i];  }(  for(i=0;i<FFT_SIZE/2;i++) if(i<rev[i]){     t_r = energy[i];     energy[i] = energy[rev[i]];      energy[rev[i]] = t_r;f  }F  for(i=0;i<HAN_SIZE/2;i++){                     /* calculate power  */F     if(energy[i] < 1E-20) energy[i] = 1E-20;    /* density spectrum */6        power[i].x = 10 * log10(energy[i]) + POWERNORM;        power[i].next = STOP;        power[i].type = FALSE;t  }  mem_free((void **) &x_r);  mem_free((void **) &x_i);  mem_free((void **) &energy);  }h  B /****************************************************************/ /*, /*         Window the incoming audio signal. /*B /****************************************************************/  E void I_hann_win(sample)             /* this function calculates a  */ A double FAR sample[FFT_SIZE/2];  /* Hann window for PCM (input) */ E {                                   /* samples for a 512-pt. FFT   */f  register int i;  register double sqrt_8_over_3;)  static int init = 0;1  static double FAR *window;r  F  if(!init){  /* calculate window function for the Fourier transform */?     window = (double FAR *) mem_alloc(sizeof(DFFT2), "window"); &     sqrt_8_over_3 = pow(8.0/3.0, 0.5);     for(i=0;i<FFT_SIZE/2;i++){       /* Hann window formula */.N       window[i]=sqrt_8_over_3*0.5*(1-cos(2.0*PI*i/(FFT_SIZE/2)))/(FFT_SIZE/2);     }l
     init = 1;b  }2  for(i=0;i<FFT_SIZE/2;i++) sample[i] *= window[i]; }*  E /*******************************************************************/t /*D /*        This function finds the maximum spectral component in eachC /* subband and return them to the encoder for time-domain threshold* /* determination.I /*E /*******************************************************************/L #ifndef LONDON void I_pick_max(power, spike)j double FAR spike[SBLIMIT]; mask FAR power[HAN_SIZE/2];e {   double max;	  int i,j;k  7  /* calculate the spectral component in each subband */e.  for(i=0;i<HAN_SIZE/2;spike[i>>3] = max, i+=8)P     for(j=0, max = DBMIN;j<8;j++) max = (max>power[i+j].x) ? max : power[i+j].x; }m #elseg void I_pick_max(power, spike)e double FAR spike[SBLIMIT]; mask FAR power[HAN_SIZE];n {l  double sum;	  int i,j;   :  for(i=0;i<HAN_SIZE/2;spike[i>>3] = 10.0*log10(sum), i+=8)K                                                    /* calculate the      */ J  for(j=0, sum = pow(10.0,0.1*DBMIN);j<8;j++)       /* sum of spectral   */K    sum += pow(10.0,0.1*power[i+j].x);              /* component in each  */eK }                                                  /* subband from bound */a #endifB /****************************************************************/ /*? /*        This function labels the tonal component in the powern /* spectrum. /*B /****************************************************************/  B void I_tonal_label(power, tone)     /* this function extracts   */> mask FAR power[HAN_SIZE/2];     /* (tonal) sinusoidals from */B int *tone;                          /* the spectrum             */ {*"  int i,j, last = LAST, first, run;  double max;  int last_but_one= LAST;    *tone = LAST;  for(i=2;i<HAN_SIZE/2-6;i++){s<     if(power[i].x>power[i-1].x && power[i].x>=power[i+1].x){        power[i].type = TONE;        power[i].next = LAST;-        if(last != LAST) power[last].next = i;u        else first = *tone = i;        last = i;     }]  }
  last = LAST;;  first = *tone;r  *tone = LAST;H  while(first != LAST){                /* conditions for the tonal     */P     if(first<3 || first>250) run = 0; /* otherwise k+/-j will be out of bounds*/H     else if(first<63) run = 2;        /* components in layer I, which */J     else if(first<127) run = 3;       /* are the boundaries for calc.   */I     else run = 6;                     /* the tonal components          */i     max = power[first].x - 7; J     for(j=2;j<=run;j++)  /* after calc. of tonal components, set to loc.*/J        if(max < power[first-j].x || max < power[first+j].x){   /* max   */$           power[first].type = FALSE;           break;        }D     if(power[first].type == TONE){    /* extract tonal components */        int help=first;'        if(*tone == LAST) *tone = first;fE        while((power[help].next!=LAST)&&(power[help].next-first)<=run)0            help=power[help].next;        help=power[help].next;;        power[first].next=help;        if((first-last)<=run){oB           if(last_but_one != LAST) power[last_but_one].next=first;        }C        if(first>1 && first<255){     /* calculate the sum of the */]C           double tmp;                /* powers of the components */ ;           tmp = add_db(power[first-1].x, power[first+1].x);h7           power[first].x = add_db(power[first].x, tmp);         }        for(j=1;j<=run;j++){o6           power[first-j].x = power[first+j].x = DBMIN;P           power[first-j].next = power[first+j].next = STOP; /*dpwe: 2nd was .x*/<           power[first-j].type = power[first+j].type = FALSE;        }        last_but_one=last;         last = first;!        first = power[first].next;,     },
     else {        int ll;?        if(last == LAST) ; /* *tone = power[first].next; dpwe */ 1        else power[last].next = power[first].next;g        ll = first;!        first = power[first].next;         power[ll].next = STOP;t     }d  } }                                                           B /****************************************************************/ /*? /*        This function finds the minimum masking threshold andi# /* return the value to the encoder.* /*B /****************************************************************/   void I_minimum_mask(ltg,ltmin) g_thres FAR *ltg;  double FAR ltmin[SBLIMIT]; {I  double min;	  int i,j;n    j=1;a  for(i=0;i<SBLIMIT;i++)yL     if(j>=sub_size-1)                   /* check subband limit, and       */L        ltmin[i] = ltg[sub_size-1].hear; /* calculate the minimum masking  */L     else {                              /* level of LTMIN for each subband*/        min = ltg[j].x;2        while(ltg[j].line>>3 == i && j < sub_size){,           if (min>ltg[j].x)  min = ltg[j].x;           j++;        }        ltmin[i] = min;     }/ }o  C /*****************************************************************/p /*= /*        This procedure is called in musicin to pick out thek+ /* smaller of the scalefactor or threshold.i /*C /*****************************************************************/g   void I_smr(ltmin, spike, scale)b: double FAR spike[SBLIMIT], scale[SBLIMIT], ltmin[SBLIMIT]; {_  int i;i  double max;                 J  for(i=0;i<SBLIMIT;i++){                      /* determine the signal   */J     max = 20 * log10(scale[i] * 32768) - 10;  /* level for each subband */J     if(spike[i]>max) max = spike[i];          /* for the scalefactor    */     max -= ltmin[i];     ltmin[i] = max;   } }a         B /****************************************************************/ /*= /*        This procedure calls all the necessary functions to ( /* complete the psychoacoustic analysis. /*B /****************************************************************/  . void I_Psycho_One(buffer, scale, ltmin, fr_ps) short FAR buffer[2][1152];0 double FAR scale[2][SBLIMIT], ltmin[2][SBLIMIT]; frame_params *fr_ps; {i  int stereo = fr_ps->stereo;   the_layer info = fr_ps->header;  int k,i, tone=0, noise=0;  static char init = 0;  static int off[2] = {256,256};   double *sample;
  DSBL *spike;   static D640 *fft_buf;  static mask_ptr FAR power;   static g_ptr FAR ltg;  8  sample = (double *) mem_alloc(sizeof(DFFT2), "sample");4  spike = (DSBL *) mem_alloc(sizeof(D2SBL), "spike");?             /* call functions for critical boundaries, freq. */ >  if(!init){ /* bands, bark values, and mapping              */>     fft_buf = (D640 *) mem_alloc(sizeof(D640) * 2, "fft_buf");J     power = (mask_ptr FAR ) mem_alloc(sizeof(mask) * HAN_SIZE/2, "power");4     read_cbound(info->lay,info->sampling_frequency);<     read_freq_band(&ltg,info->lay,info->sampling_frequency);     make_map(power,ltg);9     for(i=0;i<640;i++) fft_buf[0][i] = fft_buf[1][i] = 0;e
     init = 1;t  }?  for(k=0;k<stereo;k++){    /* check PCM input for a block of */0?     for(i=0;i<384;i++)     /* 384 samples for a 512-pt. FFT  */y?        fft_buf[k][(i+off[k])%640]= (double) buffer[k][i]/SCALE;i     for(i=0;i<FFT_SIZE/2;i++) 2        sample[i] = fft_buf[k][(i+448+off[k])%640];     off[k] += 384;     off[k] %= 640;I                         /* call functions for windowing PCM samples,   */wI     I_hann_win(sample); /* location of spectral components in each     */ I     for(i=0;i<HAN_SIZE/2;i++) power[i].x = DBMIN;   /* subband with    */*I     I_f_f_t(sample, power);              /* labeling, locate remaining */ I     I_pick_max(power, &spike[k][0]);     /* non-tonal sinusoidals,     */*I     I_tonal_label(power, &tone);         /* reduce noise & tonal com., */*I     noise_label(power, &noise, ltg);     /* find global & minimal      */iI     subsampling(power, ltg, &tone, &noise);  /* threshold, and sgnl-   */rI     threshold(power, ltg, &tone, &noise,     /* to-mask ratio          */s8       bitrate[info->lay-1][info->bitrate_index]/stereo);&     I_minimum_mask(ltg, &ltmin[k][0]);<     I_smr(&ltmin[k][0], &spike[k][0], &scale[k][0]);          }  mem_free((void **) &sample);   mem_free((void **) &spike); };