G /********************************************************************** L Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
 musicout.cG **********************************************************************/ G /********************************************************************** G  * MPEG/audio coding/decoding software, work in progress              * G  *   NOT for public distribution until verified and approved by the   * G  *   MPEG/audio committee.  For further information, please contact   * G  *   Davis Pan, 508-493-2241, e-mail: pan@3d.enet.dec.com             * G  *                                                                    * G  * VERSION 3.9                                                        * G  *   changes made since last update:                                  * G  *   date   programmers                comment                        * G  * 2/25/91  Douglas Wong        start of version 1.0 records          * G  * 3/06/91  Douglas Wong        rename setup.h to dedef.h             * G  *                              removed extraneous variables          * G  *                              removed window_samples (now part of   * G  *                              filter_samples)                       * G  * 3/07/91  Davis Pan           changed output file to "codmusic"     * G  * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         * G  *                              Incorporated new "out_fifo()" which   * G  *                              writes out last incomplete buffer.    * G  *                              Incorporated all AIFF routines which  * G  *                              are also compatible with SUN.         * G  *                              Incorporated user interface for       * G  *                              specifying sound file names.          * G  *                              Also incorporated user interface for  * G  *                              writing AIFF compatible sound files.  * G  * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  * G  *                              args to out_fifo (were glob refs).    * G  *                              Used new 'frame_params' struct.       * G  *                              Clean,simplify, track clipped output  * G  *                              and total bits/frame received.        * G  * 7/10/91  Earle Jennings      changed to floats to FLOAT            * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              buffer_CRC and recover_CRC_error      * G  *                              Additions and revisions are marked    * G  *                              with "dhl" for clarity                * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  *19 aug 92 Soren H. Nielsen    Changed MS-DOS file name extensions.  * G  * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        * G  *         Daniel Lauzon, and                                         * G  *         Bill Truerniet                                             * H  **********************************************************************/   #include        "common.h" #include        "decoder.h"   E /********************************************************************  /*B /*        This part contains the MPEG I decoder for Layers I & II. /*G /*********************************************************************/   A /****************************************************************  /*A /*        For MS-DOS user (Turbo c) change all instance of malloc A /*        to _farmalloc and free to _farfree. Compiler model hugh F /*        Also make sure all the pointer specified are changed to far. /*C /*****************************************************************/   F /********************************************************************* /*< /* Core of the Layer II decoder.  Default layer is Layer II. /*G /*********************************************************************/   2 /* Global variable definitions for "musicout.c" */   char *programName;   /* Implementations */    main(argc, argv)	 int argc;  char **argv; { ! typedef short PCM[2][3][SBLIMIT];      PCM FAR *pcm_sample;( typedef unsigned int SAM[2][3][SBLIMIT];     SAM FAR *sample;" typedef double FRA[2][3][SBLIMIT];     FRA FAR *fraction; typedef double VE[2][HAN_SIZE];      VE FAR *w;       Bit_stream_struc  bs;      frame_params      fr_ps;     layer             info;       FILE              *musicout;$     unsigned long     sample_frames;  >     int               i, j, k, stereo, done=FALSE, clip, sync;K     int               error_protection, crc_error_count, total_error_count;      int               x;8     char              default_file_name[MAX_NAME_SIZE]; '     unsigned int      old_crc, new_crc; ?     unsigned int      bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT], 1                       scale_index[2][3][SBLIMIT]; A     unsigned long     bitsPerSlot, samplesPerFrame, frameNum = 0; -     unsigned long     frameBits, gotBits = 0; $     IFF_AIFF          pcm_aiff_data;7     char              encoded_file_name[MAX_NAME_SIZE]; 7     char              decoded_file_name[MAX_NAME_SIZE];      char              t[50];      int               need_aiff;     int topSb = 0;   #ifdef  MACINTOSH ,     console_options.nrows = MAC_WINDOW_SIZE;     argc = ccommand(&argv);  #endif  >     /* Most large variables are declared dynamically to ensure-        compatibility with smaller machines */   G     pcm_sample = (PCM FAR *) mem_alloc((long) sizeof(PCM), "PCM Samp"); A     sample = (SAM FAR *) mem_alloc((long) sizeof(SAM), "Sample"); E     fraction = (FRA FAR *) mem_alloc((long) sizeof(FRA), "fraction"); 5     w = (VE FAR *) mem_alloc((long) sizeof(VE), "w");        fr_ps.header = &info; <     fr_ps.tab_num = -1;                /* no table loaded */     fr_ps.alloc = NULL; @     for (i=0;i<HAN_SIZE;i++) for (j=0;j<2;j++) (*w)[j][i] = 0.0;       programName = argv[0];?     if(argc==1) {        /* no command line args -> interact */         do { :           printf ("Enter encoded file name <required>: ");#           gets (encoded_file_name); 0           if (encoded_file_name[0] == NULL_CHAR):              printf ("Encoded file name is required. \n");3        } while (encoded_file_name[0] == NULL_CHAR); E        printf (">>> Encoded file name is: %s \n", encoded_file_name);               x=0;     while (x <= MAX_NAME_SIZE)     { )         default_file_name[x] = NULL_CHAR;          ++x;	         }      x=0;     while (x <= 8)     { /    default_file_name[x] = encoded_file_name[x]; '     if (encoded_file_name[++x] == '.')           x = 9;        }         )     strcat(default_file_name,DFLT_OPEXT);   8     printf("Enter MPEG decoded output file name <%s>: ",1            default_file_name); /* 92-08-19 shn */      gets(decoded_file_name);,     if (decoded_file_name[0] == NULL_CHAR) {   >         /* replace old extension with new one, 92-08-19 shn */3        strcpy(decoded_file_name,default_file_name);      }                      J        printf (">>> MPEG decoded file name is: %s \n", decoded_file_name);          printf(M           "Do you wish to write an AIFF compatible sound file ? (y/<n>) : ");*        gets(t);*4        if (*t == 'y' || *t == 'Y') need_aiff = TRUE;5        else                        need_aiff = FALSE;v        if (need_aiff)*J             printf(">>> An AIFF compatible sound file will be written\n");J        else printf(">>> A non-headered PCM sound file will be written\n");          printf(L           "Do you wish to exit (last chance before decoding) ? (y/<n>) : ");        gets(t); +        if (*t == 'y' || *t == 'Y') exit(0);e     } )     else {        /* interpret CL Args */*        int i=0, err=0;          need_aiff = FALSE;o#        encoded_file_name[0] = '\0'; #        decoded_file_name[0] = '\0';   $        while(++i<argc && err == 0) {)           char c, *token, *arg, *nextArg;            int  argUsed;i             token = argv[i];           if(*token++ == '-') { 0              if(i+1 < argc) nextArg = argv[i+1];)              else           nextArg = "";               argUsed = 0;r"              while(c = *token++) {=                 if(*token /* NumericQ(token) */) arg = token; ?                 else                             arg = nextArg;*                 switch(c) { =                    case 's':  topSb = atoi(arg); argUsed = 1; 4                       if(topSb<1 || topSb>SBLIMIT) {G                          fprintf(stderr, "%s: -s band %s not %d..%d\n",*?                                  programName, arg, 1, SBLIMIT); !                          err = 1;                        }i                       break;6                    case 'A':  need_aiff = TRUE; break;L                    default:   fprintf(stderr,"%s: unrecognized option %c\n",6                                       programName, c);%                       err = 1; break;                  }r                 if(argUsed) { H                    if(arg == token) token = ""; /* no more from token */?                    else             ++i; /* skip arg we used */e)                    arg = ""; argUsed = 0;r                 }l              }           }1           else {-              if(encoded_file_name[0] == '\0')*3                 strcpy(encoded_file_name, argv[i]);g              else*0                 if(decoded_file_name[0] == '\0')6                    strcpy(decoded_file_name, argv[i]);                 else {"                    fprintf(stderr,H                            "%s: excess arg %s\n", programName, argv[i]);                    err = 1;                  }            }1        }  L        if(err || encoded_file_name[0] == '\0') usage();  /* never returns */  )        if(decoded_file_name[0] == '\0') { 7           strcpy(decoded_file_name, encoded_file_name); 0           strcat(decoded_file_name, DFLT_OPEXT);        }       }e1     /* report results of dialog / command line */ 5     printf("Input file = '%s'  output file = '%s'\n", 1            encoded_file_name, decoded_file_name);rA     if(need_aiff) printf("Output file written in AIFF format\n");r  B     if(strcmp(decoded_file_name,"stdout") == 0) musicout = stdout;
     else {D          if ((musicout = fopen(decoded_file_name, "w+b")) == NULL) {E             printf ("Could not create \"%s\".\n", decoded_file_name);a             exit(1);
          }     }   ;     open_bit_stream_r(&bs, encoded_file_name, BUFFER_SIZE);        if (need_aiff)5        if (aiff_seek_to_sound_data(musicout) == -1) { A           printf("Could not seek to PCM sound data in \"%s\".\n", $                  decoded_file_name);           exit(1);        }       sample_frames = 0;       while (!end_bs(&bs)) {  9        sync = seek_sync(&bs, SYNC_WORD, SYNC_WORD_LNGTH); )        frameBits = sstell(&bs) - gotBits; L        if(frameNum > 0)        /* don't want to print on 1st loop; no lay */#           if(frameBits%bitsPerSlot)nB              fprintf(stderr,"Got %ld bits = %ld slots plus %ld\n",N                      frameBits, frameBits/bitsPerSlot, frameBits%bitsPerSlot);        gotBits += frameBits;          if (!sync) { .           printf("Frame cannot be located\n");0           printf("Input stream may be empty\n");           done = TRUE;,           /* finally write out the buffer */C           if (info.lay == 2) out_fifo(*pcm_sample, 3, &fr_ps, done,*@                                       musicout, &sample_frames);C           else               out_fifo(*pcm_sample, 1, &fr_ps, done,*@                                       musicout, &sample_frames);           break;        }           decode_info(&bs, &fr_ps);        hdr_to_frps(&fr_ps);         stereo = fr_ps.stereo;f0        error_protection = info.error_protection;        crc_error_count = 0;d        total_error_count = 0;*M        if(frameNum == 0) WriteHdr(&fr_ps, stdout);  /* printout layer/mode */*  ?        fprintf(stderr, "{%4lu}\r", frameNum++); fflush(stderr);r7        if (error_protection) buffer_CRC(&bs, &old_crc);*          switch (info.lay) {             case 1: {*<              bitsPerSlot = 32;        samplesPerFrame = 384;5              I_decode_bitalloc(&bs,bit_alloc,&fr_ps);sA              I_decode_scale(&bs, bit_alloc, scale_index, &fr_ps);r  $              if (error_protection) {8                 I_CRC_calc(&fr_ps, bit_alloc, &new_crc);)                 if (new_crc != old_crc) {L%                    crc_error_count++; '                    total_error_count++; B                    recover_CRC_error(*pcm_sample, crc_error_count,G                                      &fr_ps, musicout, &sample_frames);                     break;n                 }j)                 else crc_error_count = 0;n              }                clip = 0;*              for (i=0;i<SCALE_BLOCK;i++) {@                 I_buffer_sample(&bs,(*sample),bit_alloc,&fr_ps);H                 I_dequantize_sample(*sample,*fraction,bit_alloc,&fr_ps);E                 I_denormalize_sample((*fraction),scale_index,&fr_ps);[<                 if(topSb>0)        /* clear channels to 0 */5                    for(j=topSb; j<fr_ps.sblimit; ++j),-                       for(k=0; k<stereo; ++k)d2                          (*fraction)[k][0][j] = 0;  (                 for (j=0;j<stereo;j++) {H                    clip += SubBandSynthesis (&((*fraction)[j][0][0]), j,H                                              &((*pcm_sample)[j][0][0]));                 }D6                 out_fifo(*pcm_sample, 1, &fr_ps, done,3                          musicout, &sample_frames);u              }F              if(clip > 0) printf("%d output samples clipped\n", clip);              break;M           })             case 2: {A<              bitsPerSlot = 8;        samplesPerFrame = 1152;8              II_decode_bitalloc(&bs, bit_alloc, &fr_ps);I              II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps);=  %              if (error_protection) {  @                 II_CRC_calc(&fr_ps, bit_alloc, scfsi, &new_crc);)                 if (new_crc != old_crc) {]%                    crc_error_count++;;'                    total_error_count++;lB                    recover_CRC_error(*pcm_sample, crc_error_count,G                                      &fr_ps, musicout, &sample_frames);                     break;[                 } )                 else crc_error_count = 0;q              }                clip = 0;*              for (i=0;i<SCALE_BLOCK;i++) {A                 II_buffer_sample(&bs,(*sample),bit_alloc,&fr_ps); M                 II_dequantize_sample((*sample),bit_alloc,(*fraction),&fr_ps);LK                 II_denormalize_sample((*fraction),scale_index,&fr_ps,i>>2);d  D                 if(topSb>0)        /* debug : clear channels to 0 */5                    for(j=topSb; j<fr_ps.sblimit; ++j) -                       for(k=0; k<stereo; ++k) /                          (*fraction)[k][0][j] = /                          (*fraction)[k][1][j] =n2                          (*fraction)[k][2][j] = 0;  :                 for (j=0;j<3;j++) for (k=0;k<stereo;k++) {H                    clip += SubBandSynthesis (&((*fraction)[k][j][0]), k,H                                              &((*pcm_sample)[k][j][0]));                 }:@                 out_fifo(*pcm_sample, 3, &fr_ps, done, musicout,)                          &sample_frames);               }?              if(clip > 0) printf("%d samples clipped\n", clip);=              break;            }           }       }L       if (need_aiff) {0        pcm_aiff_data.numChannels       = stereo;7        pcm_aiff_data.numSampleFrames   = sample_frames; ,        pcm_aiff_data.sampleSize        = 16;N        pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000; #ifdef IFF_LONG       5        pcm_aiff_data.sampleType        = IFF_ID_SSND;) #else 8        strncpy(&pcm_aiff_data.sampleType,IFF_ID_SSND,4); #endif+        pcm_aiff_data.blkAlgn.offset    = 0;c+        pcm_aiff_data.blkAlgn.blockSize = 0;l  a@        if (aiff_write_headers(musicout, &pcm_aiff_data) == -1) {<           printf("Could not write AIFF headers to \"%s\"\n",$                  decoded_file_name);           exit(2);        }     }i  D     printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",6            (FLOAT) gotBits / (frameNum * bitsPerSlot),:            (FLOAT) gotBits / (frameNum * samplesPerFrame),;            (FLOAT) gotBits / (frameNum * samplesPerFrame) * ,            s_freq[info.sampling_frequency]);       close_bit_stream_r(&bs);     fclose(musicout);;  1     /* for the correct AIFF header information */o1     /*             on the Macintosh            */d1     /* the file type and the file creator for  */ 1     /* Macintosh compatible Digidesign is set  */    #ifdef  MACINTOSH D     if (need_aiff) set_mac_file_attr(decoded_file_name, VOL_REF_NUM,G                                      CREATR_DEC_AIFF, FILTYP_DEC_AIFF); D     else           set_mac_file_attr(decoded_file_name, VOL_REF_NUM,G                                      CREATR_DEC_BNRY, FILTYP_DEC_BNRY);  #endif  B     printf("Decoding of \"%s\" is finished\n", encoded_file_name);N     printf("The decoded PCM output file name is \"%s\"\n", decoded_file_name);     if (need_aiff)G        printf("\"%s\" has been written with AIFF header information\n", !               decoded_file_name);        exit( 0 ); }l  . static void usage()  /* print syntax & exit */ {     fprintf(stderr,J       "usage: %s                         queries for all arguments, or\n",        programName);    fprintf(stderr,?       "       %s [-A][-s sb] inputBS [outPCM]\n", programName);     fprintf(stderr,"where\n");rE    fprintf(stderr," -A       write an AIFF output PCM sound file\n");[M    fprintf(stderr," -s sb    resynth only up to this sb (debugging only)\n"); C    fprintf(stderr," inputBS  input bit stream of encoded audio\n");eG    fprintf(stderr," outPCM   output PCM sound file (dflt inName+%s)\n",d            DFLT_OPEXT);_    exit(1);  } 