G /********************************************************************** L Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved	 musicin.c G **********************************************************************/ G /********************************************************************** G  * MPEG/audio coding/decoding software, work in progress              * G  *   NOT for public distribution until verified and approved by the   * G  *   MPEG/audio committee.  For further information, please contact   * G  *   Davis Pan, 508-493-2241, e-mail: pan@3d.enet.dec.com             * G  *                                                                    * G  * VERSION 4.0                                                        * G  *   changes made since last update:                                  * G  *   date   programmers         comment                               * G  * 3/01/91  Douglas Wong,       start of version 1.1 records          * G  *          Davis Pan                                                 * G  * 3/06/91  Douglas Wong,       rename: setup.h to endef.h            * G  *                              removed extraneous variables          * G  * 3/21/91  J.Georges Fritsch   introduction of the bit-stream        * G  *                              package. This package allows you      * G  *                              to generate the bit-stream in a       * G  *                              binary or ascii format                * G  * 3/31/91  Bill Aspromonte     replaced the read of the SB matrix    * G  *                              by an "code generated" one            * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  *                              Incorporated Jean-Georges Fritsch's   * G  *                              "bitstream.c" package.                * G  *                              Modified to strictly adhere to        * G  *                              encoded bitstream specs, including    * G  *                              "Berlin changes".                     * G  *                              Modified user interface dialog & code * G  *                              to accept any input & output          * G  *                              filenames desired.  Also added        * G  *                              de-emphasis prompt and final bail-out * G  *                              opportunity before encoding.          * G  *                              Added AIFF PCM sound file reading     * G  *                              capability.                           * G  *                              Modified PCM sound file handling to   * G  *                              process all incoming samples and fill * G  *                              out last encoded frame with zeros     * G  *                              (silence) if needed.                  * G  *                              Located and fixed numerous software   * G  *                              bugs and table data errors.           * G  * 27jun91  dpwe (Aware Inc)    Used new frame_params struct.         * G  *                              Clear all automatic arrays.           * G  *                              Changed some variable names,          * G  *                              simplified some code.                 * G  *                              Track number of bits actually sent.   * G  *                              Fixed padding slot, stereo bitrate    * G  *                              Added joint-stereo : scales L+R.      * G  * 6/12/91  Earle Jennings      added fix for MS_DOS in obtain_param  * G  * 6/13/91  Earle Jennings      added stack length adjustment before  * G  *                              main for MS_DOS                       * G  * 7/10/91  Earle Jennings      conversion of all float to FLOAT      * G  *                              port to MsDos from MacIntosh completed* G  * 8/ 8/91  Jens Spille         Change for MS-C6.00                   * G  * 8/22/91  Jens Spille         new obtain_parameters()               * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              I_CRC_calc, II_CRC_calc and encode_CRC* G  *                              Additions and revisions are marked    * G  *                              with "dhl" for clarity                * G  *11/11/91 Katherine Wang       Documentation of code.                * G  *                                (variables in documentation are     * G  *                                surround by the # symbol, and an '*'* G  *                                denotes layer I or II versions)     * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 2/25/92  Masahiro Iwadare    made code cleaner and more consistent * G  * 8/07/92  Mike Coleman        make exit() codes return error status * G  *                              made slight changes for portability   * G  *19 aug 92 Soren H. Nielsen    Changed MS-DOS file name extensions.  * G  * 8/25/92  Shaun Astarabadi    Replaced rint() function with explicit* G  *                              rounding for portability with MSDOS.  * G  * 9/22/92  jddevine@aware.com  Fixed _scale_factor_calc() calls.     * G  *10/19/92  Masahiro Iwadare    added info->mode and info->mode_ext   * G  *                              updates for AIFF format files         * G  * 3/10/93  Kevin Peterson      In parse_args, only set non default   * G  *                              bit rate if specified in arg list.    * G  *                              Use return value from aiff_read_hdrs  * G  *                              to fseek to start of sound data       * G  * 7/26/93  Davis Pan           fixed bug in printing info->mode_ext  * G  *                              value for joint stereo condition      * G  * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        * G  *         Daniel Lauzon, and                                         * G  *         Bill Truerniet                                             * H  **********************************************************************/     #ifndef VMS  #include <dos.h> #endif #include "common.h"  #include "encoder.h"  1 /* Global variable definitions for "musicin.c" */    FILE               *musicin; Bit_stream_struc   bs;  char               *programName;   /* Implementations */   I /************************************************************************  /* /* obtain_parameters /*E /* PURPOSE:  Prompts for and reads user input for encoding parameters  /*' /* SEMANTICS:  The parameters read are:  /* - input and output filenames K /* - sampling frequency (if AIFF file, will read from the AIFF file header)  /* - layer number 6 /* - mode (stereo, joint stereo, dual channel or mono)# /* - psychoacoustic model (I or II) , /* - total bitrate, irrespective of the modeH /* - de-emphasis, error protection, copyright and original or copy flags /*J /************************************************************************/   voidM obtain_parameters(fr_ps,psy,num_samples,original_file_name,encoded_file_name)  frame_params    *fr_ps;  int             *psy;  unsigned long   *num_samples; 2 char            original_file_name[MAX_NAME_SIZE];1 char            encoded_file_name[MAX_NAME_SIZE];    { 
     int j;
     int x;*     char default_file_name[MAX_NAME_SIZE];     long int freq;     int model, brt;      char t[50];      IFF_AIFF pcm_aiff_data;       layer *info = fr_ps->header;     long soundPosition;    	     do  { 8        printf("Enter PCM input file name <required>: ");         gets(original_file_name);.        if (original_file_name[0] == NULL_CHAR)4        printf("PCM input file name is required.\n");1     } while (original_file_name[0] == NULL_CHAR); C     printf(">>> PCM input file name is: %s\n", original_file_name);    >     if ((musicin = fopen(original_file_name, "rb")) == NULL) {>        printf("Could not find \"%s\".\n", original_file_name);        exit(1);      }      x=0;     while (x <= MAX_NAME_SIZE)     { " 	default_file_name[x] = NULL_CHAR; 	++x;  	}     x=0;     while (x <= 8)     { 0    default_file_name[x] = original_file_name[x];(     if (original_file_name[++x] == '.')  	x = 9;         }      '     strcat(default_file_name,DFLT_EXT);   8     printf("Enter MPEG encoded output file name <%s>: ",* 	   default_file_name); /* 92-08-19 shn */     gets(encoded_file_name);,     if (encoded_file_name[0] == NULL_CHAR) {   7 	/* replace old extension with new one, 92-08-19 shn */ 3        strcpy(encoded_file_name,default_file_name);  /*A 	strcat(strcpy(encoded_file_name, original_file_name), DFLT_EXT);  */       }            L     printf(">>> MPEG encoded output file name is: %s\n", encoded_file_name);   ;     open_bit_stream_w(&bs, encoded_file_name, BUFFER_SIZE);    M     if ((soundPosition = aiff_read_headers(musicin, &pcm_aiff_data)) != -1) {   :        printf(">>> Using Audio IFF sound file headers\n");  6        aiff_check(original_file_name, &pcm_aiff_data);  :        if (fseek(musicin, soundPosition, SEEK_SET) != 0) {: 	  printf("Could not seek to PCM sound data in \"%s\".\n", 		 original_file_name);  	  exit(1);         }  N        info->sampling_frequency = SmpFrqIndex((long)pcm_aiff_data.sampleRate);9        printf(">>> %.f Hz sampling frequency selected\n", ! 	      pcm_aiff_data.sampleRate);   6        /* Determine number of samples in sound file */ #ifndef MS_DOS1        *num_samples = pcm_aiff_data.numChannels * & 		      pcm_aiff_data.numSampleFrames; #else 9        *num_samples = (long)(pcm_aiff_data.numChannels) * . 		      (long)(pcm_aiff_data.numSampleFrames); #endif       } ;     else {    /* Not using Audio IFF sound file headers. */   ?        printf("What is the sampling frequency? <44100>[Hz]: ");         gets(t);         freq = atol(t);        switch (freq) {- 	  case 48000 : info->sampling_frequency = 1; ; 	      printf(">>> %ld Hz sampling freq selected\n", freq); 
 	      break; - 	  case 44100 : info->sampling_frequency = 0; ; 	      printf(">>> %ld Hz sampling freq selected\n", freq); 
 	      break; - 	  case 32000 : info->sampling_frequency = 2; ; 	      printf(">>> %ld Hz sampling freq selected\n", freq); 
 	      break; , 	  default:    info->sampling_frequency = 0;; 	      printf(">>> Default 44.1 kHz samp freq selected\n");         }   .        if (fseek(musicin, 0, SEEK_SET) != 0) {: 	  printf("Could not seek to PCM sound data in \"%s\".\n", 		  original_file_name); 	  exit(1);         }   E        /* Declare sound file to have "infinite" number of samples. */ #        *num_samples = MAX_U_32_NUM;        }   0     printf("Which layer do you want to use?\n");2     printf("Available: Layer (1), Layer (<2>): ");     gets(t);     switch(*t){ H        case '1': info->lay = 1; printf(">>> Using Layer %s\n",t); break;H        case '2': info->lay = 2; printf(">>> Using Layer %s\n",t); break;M        default:  info->lay = 2; printf(">>> Using default Layer 2\n"); break;      }   (     printf("Which mode do you want?\n");6     printf("Available: (<s>)tereo, (j)oint stereo, ");1     printf("(d)ual channel, s(i)ngle Channel: ");      gets(t);     switch(*t){         case 's':        case 'S':2 	  info->mode = MPG_MD_STEREO; info->mode_ext = 0;# 	  printf(">>> Using mode %s\n",t); 	 	  break;         case 'j':        case 'J':$ 	  info->mode = MPG_MD_JOINT_STEREO;# 	  printf(">>> Using mode %s\n",t); 	 	  break;         case 'd':        case 'D':8 	  info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext = 0;# 	  printf(">>> Using mode %s\n",t); 	 	  break;         case 'i':        case 'I':0 	  info->mode = MPG_MD_MONO; info->mode_ext = 0;# 	  printf(">>> Using mode %s\n",t); 	 	  break;         default: 2 	  info->mode = MPG_MD_STEREO; info->mode_ext = 0;- 	  printf(">>> Using default stereo mode\n"); 	 	  break;      }   C     printf("Which psychoacoustic model do you want to use? <2>: ");      gets(t);     model = atoi(t);!     if (model > 2 || model < 1) { 0        printf(">>> Default model 2 selected\n");        *psy = 2;     } 
     else {        *psy = model;<        printf(">>> Using psychoacoustic model %d\n", model);     }    @     printf("What is the total bitrate? <%u>[kbps]: ", DFLT_BRT);     gets(t);     brt = atoi(t);     if (brt == 0) brt = -10;     j=0;     while (j<15) {1        if (bitrate[info->lay-1][j] == brt) break;         j++;      }      if (j==15) {7        printf(">>> Using default %u kbps\n", DFLT_BRT);         for (j=0;j<15;j++) - 	  if (bitrate[info->lay-1][j] == DFLT_BRT) {  	     info->bitrate_index = j; 	     break; 	  }     } 	     else{         info->bitrate_index = j; B        printf(">>> Bitrate = %d kbps\n", bitrate[info->lay-1][j]);     }    A     printf("What type of de-emphasis should the decoder use?\n"); H     printf("Available: (<n>)one, (5)0/15 microseconds, (c)citt j.17: ");     gets(t);.     if (*t != 'n' && *t != '5' && *t != 'c') {4        printf(">>> Using default no de-emphasis\n");        info->emphasis = 0;     } 
     else {.        if (*t == 'n')      info->emphasis = 0;.        else if (*t == '5') info->emphasis = 1;.        else if (*t == 'c') info->emphasis = 3;.        printf(">>> Using de-emphasis %s\n",t);     }    = /*  Start 2. Part changes for CD Ver 3.2; jsp; 22-Aug-1991 */    <     printf("Do you want to set the private bit? (y/<n>): ");     gets(t);4     if (*t == 'y' || *t == 'Y') info->extension = 1;4     else                        info->extension = 0;8     if(info->extension) printf(">>> Private bit set\n");<     else                printf(">>> Private bit not set\n");   3 /*  End changes for CD Ver 3.2; jsp; 22-Aug-1991 */    6     printf("Do you want error protection? (y/<n>): ");     gets(t);>     if (*t == 'y' || *t == 'Y') info->error_protection = TRUE;?     else                        info->error_protection = FALSE; E     if(info->error_protection) printf(">>> Error protection used\n"); 3     else printf(">>> Error protection not used\n");    5     printf("Is the material copyrighted? (y/<n>): ");      gets(t);4     if (*t == 'y' || *t == 'Y') info->copyright = 1;4     else                        info->copyright = 0;=     if(info->copyright) printf(">>> Copyrighted material\n"); A     else                printf(">>> Material not copyrighted\n");    .     printf("Is this the original? (y/<n>): ");     gets(t);3     if (*t == 'y' || *t == 'Y') info->original = 1; 3     else                        info->original = 0; 9     if(info->original) printf(">>> Original material\n"); =     else               printf(">>> Material not original\n");    K     printf("Do you wish to exit (last chance before encoding)? (y/<n>): ");      gets(t);(     if (*t == 'y' || *t == 'Y') exit(0); }   I /************************************************************************  /*
 /* parse_args  /*B /* PURPOSE:  Sets encoding parameters to the specifications of the: /* command line.  Default settings are used for parameters% /* not specified in the command line.  /*D /* SEMANTICS:  The command line is parsed according to the following
 /* syntax: /*& /* -l  is followed by the layer number /* -m  is followed by the mode5 /* -p  is followed by the psychoacoustic model number ' /* -s  is followed by the sampling rate A /* -b  is followed by the total bitrate, irrespective of the mode ' /* -d  is followed by the emphasis flag*5 /* -c  is followed by the copyright/no_copyright flagh4 /* -o  is followed by the original/not_original flag6 /* -e  is followed by the error_protection on/off flag /*F /* If the input file is in AIFF format, the sampling frequency is read /* from the AIFF header. /*G /* The input and output filenames are read into #inpath# and #outpath#.  /*J /************************************************************************/    void@ parse_args(argc, argv, fr_ps, psy, num_samples, inPath, outPath)
 int     argc;s char    **argv;1 frame_params  *fr_ps;e
 int     *psy;  unsigned long *num_samples;  char    inPath[MAX_NAME_SIZE]; char    outPath[MAX_NAME_SIZE];  {     FLOAT srate;     int   brate;     layer *info = fr_ps->header;d    int   err = 0, i = 0;    IFF_AIFF pcm_aiff_data;    long samplerate;a    long soundPosition;       /* preset defaults */)    inPath[0] = '\0';   outPath[0] = '\0';v    info->lay = DFLT_LAY;    switch(DFLT_MOD) { F       case 's': info->mode = MPG_MD_STEREO; info->mode_ext = 0; break;J       case 'd': info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext=0; break;8       case 'j': info->mode = MPG_MD_JOINT_STEREO; break;D       case 'm': info->mode = MPG_MD_MONO; info->mode_ext = 0; break;       default:C 	 fprintf(stderr, "%s: Bad mode dflt %c\n", programName, DFLT_MOD); 
 	 abort();    }    *psy = DFLT_PSY;iL    if((info->sampling_frequency = SmpFrqIndex((long)(1000*DFLT_SFQ))) < 0) {L       fprintf(stderr, "%s: bad sfrq default %.2f\n", programName, DFLT_SFQ);       abort();    }F    if((info->bitrate_index = BitrateIndex(info->lay, DFLT_BRT)) < 0) {M       fprintf(stderr, "%s: bad default bitrate %u\n", programName, DFLT_BRT);        abort();    }    switch(DFLT_EMP) {e*       case 'n': info->emphasis = 0; break;*       case '5': info->emphasis = 1; break;*       case 'c': info->emphasis = 3; break;       default: rC 	 fprintf(stderr, "%s: Bad emph dflt %c\n", programName, DFLT_EMP);c
 	 abort();    }K    info->copyright = 0; info->original = 0; info->error_protection = FALSE;*       /* process args */      while(++i<argc && err == 0) {%       char c, *token, *arg, *nextArg;        int  argUsed;   u       token = argv[i];       if(*token++ == '-') {e% 	 if(i+1 < argc) nextArg = argv[i+1];* 	 else           nextArg = ""; 	 argUsed = 0; 	 while(c = *token++) {*2 	    if(*token /* NumericQ(token) */) arg = token;4 	    else                             arg = nextArg; 	    switch(c) {< 	       case 'l':        info->lay = atoi(arg); argUsed = 1;$ 		  if(info->lay<1 || info->lay>2) {> 		     fprintf(stderr,"%s: -l layer must be 1 or 2, not %s\n", 			  programName, arg);  		     err = 1;s 		  }n
 		  break;% 	       case 'm':        argUsed = 1;  		  if (*arg == 's')9 		    { info->mode = MPG_MD_STEREO; info->mode_ext = 0; }  		  else if (*arg == 'd') = 		    { info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext=0; }  		  else if (*arg == 'j') + 		    { info->mode = MPG_MD_JOINT_STEREO; }t 		  else if (*arg == 'm')27 		    { info->mode = MPG_MD_MONO; info->mode_ext = 0; } 
 		  else {< 		    fprintf(stderr,"%s: -m mode must be s/d/j/m not %s\n", 			    programName, arg);  		    err = 1; 		  } 
 		  break;7 	       case 'p':        *psy = atoi(arg); argUsed = 1;p 		  if(*psy<1 || *psy>2) {> 		     fprintf(stderr,"%s: -p model must be 1 or 2, not %s\n", 			     programName, arg); 		     err = 1;  		  }i
 		  break;   	       case 's':  		  argUsed = 1; 		  srate = atof( arg );2 		  /* samplerate = rint( 1000.0 * srate ); $A  */3 		  samplerate = (long) (( 1000.0 * srate ) + 0.5); I 		  if( (info->sampling_frequency = SmpFrqIndex((long) samplerate)) < 0 )  		      err = 1;
 		  break; 		   	       case 'b':          		  argUsed = 1; 		  brate = atoi(arg);  C 		  if( (info->bitrate_index = BitrateIndex(info->lay, brate)) < 0)  		     err=1;                  c	 		 break; % 	       case 'd':        argUsed = 1;f; 		  if (*arg == 'n')                    info->emphasis = 0; ; 		  else if (*arg == '5')               info->emphasis = 1;.; 		  else if (*arg == 'c')               info->emphasis = 3; 
 		  else {: 		     fprintf(stderr,"%s: -d emp must be n/5/c not %s\n", 			     programName, arg); 		     err = 1;  		  } 
 		  break;- 		case 'c':       info->copyright = 1; break;e- 		case 'o':       info->original  = 1; break; 7 		case 'e':       info->error_protection = TRUE; break; 9 		default:        fprintf(stderr,"%s: unrec option %c\n",  					programName, c);  				err = 1; break;  	    } 	    if(argUsed) {B 	       if(arg == token)    token = "";   /* no more from token */@ 	       else                ++i;          /* skip arg we used */ 	       arg = ""; argUsed = 0; 	    } 	 }        }        else {6 	 if(inPath[0] == '\0')       strcpy(inPath, argv[i]);7 	 else if(outPath[0] == '\0') strcpy(outPath, argv[i]);  	 else {A 	    fprintf(stderr,"%s: excess arg %s\n", programName, argv[i]); 
 	    err = 1;r 	 }o       }c    }  =    if(err || inPath[0] == '\0') usage();  /* never returns */   e    if(outPath[0] == '\0') {*       strcpy(outPath, inPath);        strcat(outPath, DFLT_EXT);    }   1    if ((musicin = fopen(inPath, "rb")) == NULL) {q1       printf("Could not find \"%s\".\n", inPath);n       exit(1);    }   0    open_bit_stream_w(&bs, outPath, BUFFER_SIZE);  L    if ((soundPosition = aiff_read_headers(musicin, &pcm_aiff_data)) != -1) {  9       printf(">>> Using Audio IFF sound file headers\n");   )       aiff_check(inPath, &pcm_aiff_data);*  9       if (fseek(musicin, soundPosition, SEEK_SET) != 0) {iB 	 printf("Could not seek to PCM sound data in \"%s\".\n", inPath);
 	 exit(1);       }0  M       info->sampling_frequency = SmpFrqIndex((long)pcm_aiff_data.sampleRate); 8       printf(">>> %.f Hz sampling frequency selected\n",  	     pcm_aiff_data.sampleRate);  5       /* Determine number of samples in sound file */u #ifndef MS_DOS0       *num_samples = pcm_aiff_data.numChannels *% 		     pcm_aiff_data.numSampleFrames;r #elsey8       *num_samples = (long)(pcm_aiff_data.numChannels) *- 		     (long)(pcm_aiff_data.numSampleFrames);a #endif-       if ( pcm_aiff_data.numChannels == 1 ) {  	info->mode = MPG_MD_MONO; 	info->mode_ext = 0;       }     }:    else {    /* Not using Audio IFF sound file headers. */  -       if (fseek(musicin, 0, SEEK_SET) != 0) { B 	 printf("Could not seek to PCM sound data in \"%s\".\n", inPath);
 	 exit(1);       }u  vD       /* Declare sound file to have "infinite" number of samples. */"       *num_samples = MAX_U_32_NUM;      }   }i  I /************************************************************************  /* /* print_config  /*0 /* PURPOSE:  Prints the encoding parameters used /*J /************************************************************************/    void6 print_config(fr_ps, psy, num_samples, inPath, outPath) frame_params *fr_ps;
 int     *psy;  unsigned long *num_samples;* char    inPath[MAX_NAME_SIZE]; char    outPath[MAX_NAME_SIZE];i {e  layer *info = fr_ps->header;f  i'    printf("Encoding configuration:\n"); (    if(info->mode != MPG_MD_JOINT_STEREO)=       printf("Layer=%s   mode=%s   extn=%d   psy model=%d\n",b7 	     layer_names[info->lay-1], mode_names[info->mode],s 	     info->mode_ext, *psy);K    else printf("Layer=%s   mode=%s   extn=data dependant   psy model=%d\n",s@ 	       layer_names[info->lay-1], mode_names[info->mode], *psy);8    printf("samp frq=%.1f kHz   total bitrate=%d kbps\n",$ 	  s_freq[info->sampling_frequency],. 	  bitrate[info->lay-1][info->bitrate_index]);=    printf("de-emph=%d   c/right=%d   orig=%d   errprot=%d\n",,3 	  info->emphasis, info->copyright, info->original,s 	  info->error_protection);tE    printf("input file: '%s'   output file: '%s'\n", inPath, outPath);n }o  iI /************************************************************************* /* /* main* /*: /* PURPOSE:  MPEG I Encoder supporting layers 1 and 2, and1 /* psychoacoustic models 1 (MUSICAM) and 2 (AT&T)_ /*E /* SEMANTICS:  One overlapping frame of audio of up to 2 channels are . /* processed at a time in the following order:+ /* (associated routines are in parentheses)E /*6 /* 1.  Filter sliding window of data to get 32 subband /* samples per channel. " /* (window_subband,filter_subband) /*< /* 2.  If joint stereo mode, combine left and right channels  /* for subbands above #jsbound#. /* (*_combine_LR)  /*< /* 3.  Calculate scalefactors for the frame, and if layer 2,1 /* also calculate scalefactor select information.a /* (*_scale_factor_calc) /*= /* 4.  Calculate psychoacoustic masking levels using selectedl /* psychoacoustic model. /* (*_Psycho_One, psycho_anal) /*= /* 5.  Perform iterative bit allocation for subbands with lowm9 /* mask_to_noise ratios using masking levels from step 4.  /* (*_main_bit_allocation) /*= /* 6.  If error protection flag is active, add redundancy for  /* error protection. /* (*_CRC_calc)d /*@ /* 7.  Pack bit allocation, scalefactors, and scalefactor select( /* information (layer 2) onto bitstream.> /* (*_encode_bit_alloc,*_encode_scale,II_transmission_pattern) /*5 /* 8.  Quantize subbands and pack them into bitstreamL. /* (*_subband_quantization, *_sample_encoding) /*J /************************************************************************/   main(argc, argv)
 int     argc;e char    **argv;C {)/ typedef double SBS[2][3][SCALE_BLOCK][SBLIMIT];2     SBS  FAR        *sb_sample;o- typedef double JSBS[3][SCALE_BLOCK][SBLIMIT];(     JSBS FAR        *j_sample; typedef double IN[2][HAN_SIZE];      IN   FAR        *win_que;"5 typedef unsigned int SUB[2][3][SCALE_BLOCK][SBLIMIT];l     SUB  FAR        *subband;a  (     frame_params fr_ps;U     layer info; +     char original_file_name[MAX_NAME_SIZE];s*     char encoded_file_name[MAX_NAME_SIZE];     short FAR **win_buf;! static short FAR buffer[2][1152];a= static unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT];e? static unsigned int scalar[2][3][SBLIMIT], j_scale[3][SBLIMIT];tK static double FAR ltmin[2][SBLIMIT], lgmin[2][SBLIMIT], max_sc[2][SBLIMIT];      FLOAT snr32[32];     short sam[2][1056]; "     int whole_SpF, extra_slot = 0;3     double avg_slots_per_frame, frac_SpF, slot_lag;y(     int model, stereo, error_protection; static unsigned int crc;     int i, j, k, adb; =     unsigned long bitsPerSlot, samplesPerFrame, frameNum = 0;f*     unsigned long frameBits, sentBits = 0;     unsigned long num_samples;   #ifdef  MACINTOSH),     console_options.nrows = MAC_WINDOW_SIZE;     argc = ccommand(&argv);s #endif  >     /* Most large variables are declared dynamically to ensure-        compatibility with smaller machines */   @     sb_sample = (SBS FAR *) mem_alloc(sizeof(SBS), "sb_sample");@     j_sample = (JSBS FAR *) mem_alloc(sizeof(JSBS), "j_sample");:     win_que = (IN FAR *) mem_alloc(sizeof(IN), "Win_que");;     subband = (SUB FAR *) mem_alloc(sizeof(SUB),"subband");eE     win_buf = (short FAR **) mem_alloc(sizeof(short *)*2, "win_buf");)        /* clear buffers */2/     memset((char *) buffer, 0, sizeof(buffer));t5     memset((char *) bit_alloc, 0, sizeof(bit_alloc)); /     memset((char *) scalar, 0, sizeof(scalar)); 1     memset((char *) j_scale, 0, sizeof(j_scale)); -     memset((char *) scfsi, 0, sizeof(scfsi));m-     memset((char *) ltmin, 0, sizeof(ltmin));n-     memset((char *) lgmin, 0, sizeof(lgmin));r/     memset((char *) max_sc, 0, sizeof(max_sc)); -     memset((char *) snr32, 0, sizeof(snr32));u)     memset((char *) sam, 0, sizeof(sam));   _     fr_ps.header = &info; 9     fr_ps.tab_num = -1;             /* no table loaded */v     fr_ps.alloc = NULL; !     info.version = MPEG_AUDIO_ID;h       programName = argv[0];.     if(argc==1)     /* no command-line args */6        obtain_parameters(&fr_ps, &model, &num_samples,+ 			 original_file_name, encoded_file_name);l     else;        parse_args(argc, argv, &fr_ps, &model, &num_samples,r+ 		  original_file_name, encoded_file_name);f.     print_config(&fr_ps, &model, &num_samples,* 		 original_file_name, encoded_file_name);       hdr_to_frps(&fr_ps);     stereo = fr_ps.stereo;-     error_protection = info.error_protection;;  fD     if (info.lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }D     else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }5     /* Figure average number of 'slots' per frame. */ >     /* Bitrate means TOTAL for both channels, not per side. */4     avg_slots_per_frame = ((double)samplesPerFrame /( 			   s_freq[info.sampling_frequency]) *7 			  ((double)bitrate[info.lay-1][info.bitrate_index] /x 			   (double)bitsPerSlot);m*     whole_SpF = (int) avg_slots_per_frame;+     printf("slots/frame = %d\n",whole_SpF);x8     frac_SpF  = avg_slots_per_frame - (double)whole_SpF;     slot_lag  = -frac_SpF;C     printf("frac SpF=%.3f, tot bitrate=%d kbps, s freq=%.1f kHz\n",s6 	   frac_SpF, bitrate[info.lay-1][info.bitrate_index],% 	   s_freq[info.sampling_frequency]);l  s     if (frac_SpF != 0)@        printf("Fractional number of slots, padding required\n");     else info.padding = 0;  dK     while (get_audio(musicin, buffer, num_samples, stereo, info.lay) > 0) {"  =        fprintf(stderr, "{%4lu}", frameNum++); fflush(stderr); "        win_buf[0] = &buffer[0][0];"        win_buf[1] = &buffer[1][0];        if (frac_SpF != 0) {j$ 	  if (slot_lag > (frac_SpF-1.0) ) { 	     slot_lag -= frac_SpF;  	     extra_slot = 0;  	     info.padding = 0; 3 	     /*  printf("No padding for this frame\n"); */  	  }	 	  else {e 	     extra_slot = 1;  	     info.padding = 1;  	     slot_lag += (1-frac_SpF); 3 	     /*  printf("Padding for this frame\n");    */l 	  }        }2        adb = (whole_SpF+extra_slot) * bitsPerSlot;          switch (info.lay) {  fJ /***************************** Layer I **********************************/    	  case 1 :n! 	     for (j=0;j<SCALE_BLOCK;j++)  	     for (k=0;k<stereo;k++) {4 		window_subband(&win_buf[k], &(*win_que)[k][0], k);? 		filter_subband(&(*win_que)[k][0], &(*sb_sample)[k][0][j][0]);  	     }(  6 	     I_scale_factor_calc(*sb_sample, scalar, stereo);4 	     if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {& 		I_combine_LR(*sb_sample, *j_sample);- 		I_scale_factor_calc(j_sample, &j_scale, 1);* 	     }   r( 	     put_scale(scalar, &fr_ps, max_sc);  <B 	     if (model == 1) I_Psycho_One(buffer, max_sc, ltmin, &fr_ps); 	     else { 		for (k=0;k<stereo;k++) {> 		   psycho_anal(&buffer[k][0],&sam[k][0], k, info.lay, snr32,7 			       (FLOAT)s_freq[info.sampling_frequency]*1000);t= 		   for (i=0;i<SBLIMIT;i++) ltmin[k][i] = (double) snr32[i];- 		}9 	     }    < 	     I_main_bit_allocation(ltmin, bit_alloc, &adb, &fr_ps);  ;@ 	     if (error_protection) I_CRC_calc(&fr_ps, bit_alloc, &crc);    	     encode_info(&fr_ps, &bs);>  o1 	     if (error_protection) encode_CRC(crc, &bs);o  p1 	     I_encode_bit_alloc(bit_alloc, &fr_ps, &bs);i5 	     I_encode_scale(scalar, bit_alloc, &fr_ps, &bs);fD 	     I_subband_quantization(scalar, *sb_sample, j_scale, *j_sample,% 				    bit_alloc, *subband, &fr_ps); : 	     I_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);* 	     for (i=0;i<adb;i++) put1bit(&bs, 0);	 	  break;n   J /***************************** Layer 2 **********************************/  r 	  case 2 : 3 	     for (i=0;i<3;i++) for (j=0;j<SCALE_BLOCK;j++)= 		for (k=0;k<stereo;k++) {7 		   window_subband(&win_buf[k], &(*win_que)[k][0], k);nB 		   filter_subband(&(*win_que)[k][0], &(*sb_sample)[k][i][j][0]); 		}   eB 		II_scale_factor_calc(*sb_sample, scalar, stereo, fr_ps.sblimit);% 		pick_scale(scalar, &fr_ps, max_sc);f0 		if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {9 		   II_combine_LR(*sb_sample, *j_sample, fr_ps.sblimit);*@ 		   II_scale_factor_calc(j_sample, &j_scale, 1, fr_ps.sblimit);< 		}       /* this way we calculate more mono than we need */ 			/* but it is cheap */  a? 		if (model == 1) II_Psycho_One(buffer, max_sc, ltmin, &fr_ps);i 		else { 		   for (k=0;k<stereo;k++) {S1 		      psycho_anal(&buffer[k][0],&sam[k][0], k, o 				 info.lay, snr32,*2 				 (FLOAT)s_freq[info.sampling_frequency]*1000);@ 		      for (i=0;i<SBLIMIT;i++) ltmin[k][i] = (double) snr32[i]; 		   } 		}    1 		II_transmission_pattern(scalar, scfsi, &fr_ps);b@ 		II_main_bit_allocation(ltmin, scfsi, bit_alloc, &adb, &fr_ps);    		if (error_protection) 1 		   II_CRC_calc(&fr_ps, bit_alloc, scfsi, &crc);*    		encode_info(&fr_ps, &bs);n  o- 		if (error_protection) encode_CRC(crc, &bs);r  c. 		II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);9 		II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs);I6 		II_subband_quantization(scalar, *sb_sample, j_scale,2 				      *j_sample, bit_alloc, *subband, &fr_ps);7 		II_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);*& 		for (i=0;i<adb;i++) put1bit(&bs, 0);	 	  break;m  mJ /***************************** Layer 3 **********************************/   	  case 3 : break;          }  n*        frameBits = sstell(&bs) - sentBits;:        if(frameBits%bitsPerSlot)   /* a program failure */9 	  fprintf(stderr,"Sent %ld bits = %ld slots plus %ld\n",e% 		  frameBits, frameBits/bitsPerSlot,t 		  frameBits%bitsPerSlot);l        sentBits += frameBits;r       }u       close_bit_stream_w(&bs);  D     printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",0 	   (FLOAT) sentBits / (frameNum * bitsPerSlot),4 	   (FLOAT) sentBits / (frameNum * samplesPerFrame),5 	   (FLOAT) sentBits / (frameNum * samplesPerFrame) *'% 	   s_freq[info.sampling_frequency]);a       if (fclose(musicin) != 0){?        printf("Could not close \"%s\".\n", original_file_name);(        exit(2);m     }t   #ifdef  MACINTOSHDE     set_mac_file_attr(encoded_file_name, VOL_REF_NUM, CREATOR_ENCODE,n 		      FILETYPE_ENCODE);l #endif  K     printf("Encoding of \"%s\" with psychoacoustic model %d is finished\n",r 	   original_file_name, model);;;     printf("The MPEG encoded output file name is \"%s\"\n",D 	    encoded_file_name);     exit(0); }:  dI /************************************************************************s /* /* usage /*I /* PURPOSE:  Writes command line syntax to the file specified by #stderr#s /*J /************************************************************************/  . static void usage()  /* print syntax & exit */ {D     fprintf(stderr,;H     "usage: %s                         queries for all arguments, or\n", 	    programName);     fprintf(stderr, D     "       %s [-l lay][-m mode][-p psy][-s sfrq][-b br][-d emp]\n", 	    programName);     fprintf(stderr, 1     "          [-c][-o][-e] inputPCM [outBS]\n");a     fprintf(stderr,"where\n");O     fprintf(stderr," -l lay   use layer <lay> coding   (dflt %4u)\n",DFLT_LAY);kO     fprintf(stderr," -m mode  channel mode : s/d/j/m   (dflt %4c)\n",DFLT_MOD); O     fprintf(stderr," -p psy   psychoacoustic model 1/2 (dflt %4u)\n",DFLT_PSY);UQ     fprintf(stderr," -s sfrq  input smpl rate in kHz   (dflt %4.1f)\n",DFLT_SFQ); O     fprintf(stderr," -b br    total bitrate in kbps    (dflt %4u)\n",DFLT_BRT);	O     fprintf(stderr," -d emp   de-emphasis n/5/c        (dflt %4c)\n",DFLT_EMP);n4     fprintf(stderr," -c       mark as copyright\n");3     fprintf(stderr," -o       mark as original\n");U7     fprintf(stderr," -e       add error protection\n");'J     fprintf(stderr," inputPCM input PCM sound file (standard or AIFF)\n");U     fprintf(stderr," outBS    output bit stream of encoded audio (dflt inName+%s)\n",t 	    DFLT_EXT);      exit(1); }o  I /************************************************************************  /*
 /* aiff_check  /*E /* PURPOSE:  Checks AIFF header information to make sure it is valid.f /*           Exits if not. /*J /************************************************************************/  ) void aiff_check(file_name, pcm_aiff_data);< char *file_name;          /* Pointer to name of AIFF file */> IFF_AIFF *pcm_aiff_data;  /* Pointer to AIFF data structure */ {)   #ifdef IFF_LONGs3     if (pcm_aiff_data->sampleType != IFF_ID_SSND) {  #else	<     if (strncmp(&pcm_aiff_data->sampleType,IFF_ID_SSND,4)) { #endif?        printf("Sound data is not PCM in \"%s\".\n", file_name);=        exit(1);o     }b  :     if(SmpFrqIndex((long)pcm_aiff_data->sampleRate) < 0) {)        printf("in \"%s\".\n", file_name);f        exit(1);      }   F     if (pcm_aiff_data->sampleSize != sizeof(short) * BITS_IN_A_BYTE) {1 	printf("Sound data is not %d bits in \"%s\".\n", 3 	       sizeof(short) * BITS_IN_A_BYTE, file_name);f	 	exit(1);:     }   -     if (pcm_aiff_data->numChannels != MONO &&g( 	pcm_aiff_data->numChannels != STEREO) {J        printf("Sound data is not mono or stereo in \"%s\".\n", file_name);        exit(1);      }e  0     if (pcm_aiff_data->blkAlgn.blockSize != 0) {H        printf("Block size is not %lu bytes in \"%s\".\n", 0, file_name);        exit(1);      }e  -     if (pcm_aiff_data->blkAlgn.offset != 0) {=J        printf("Block offset is not %lu bytes in \"%s\".\n", 0, file_name);        exit(1);      }    }e