G /********************************************************************** L Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved encode.cG **********************************************************************/ G /********************************************************************** G  * MPEG/audio coding/decoding software, work in progress              * G  *   NOT for public distribution until verified and approved by the   * G  *   MPEG/audio committee.  For further information, please contact   * G  *   Davis Pan, 508-493-2241, e-mail: pan@3d.enet.dec.com             * G  *                                                                    * G  * VERSION 3.9t                                                       * G  *   changes made since last update:                                  * G  *   date   programmers         comment                               * G  * 3/01/91  Douglas Wong,       start of version 1.1 records          * G  *          Davis Pan                                                 * G  * 3/06/91  Douglas Wong        rename: setup.h to endef.h            * G  *                                      efilter to enfilter           * G  *                                      ewindow to enwindow           * G  *                              integrated "quantizer", "scalefactor",* G  *                              and "transmission" files              * G  *                              update routine "window_subband"       * G  * 3/31/91  Bill Aspromonte     replaced read_filter by               * G  *                              create_an_filter                      * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  *                              Incorporated Jean-Georges Fritsch's   * G  *                              "bitstream.c" package.                * G  *                              Incorporated Bill Aspromonte's        * G  *                              filterbank coefficient matrix         * G  *                              calculation routines and added        * G  *                              roundoff to coincide with specs.      * G  *                              Modified to strictly adhere to        * G  *                              encoded bitstream specs, including    * G  *                              "Berlin changes".                     * G  *                              Modified PCM sound file handling to   * G  *                              process all incoming samples and fill * G  *                              out last encoded frame with zeros     * G  *                              (silence) if needed.                  * G  *                              Located and fixed numerous software   * G  *                              bugs and table data errors.           * G  * 19jun91  dpwe (Aware)        moved "alloc_*" reader to common.c    * G  *                              Globals sblimit, alloc replaced by new* G  *                              struct 'frame_params' passed as arg.  * G  *                              Added JOINT STEREO coding, layers I,II* G  *                              Affects: *_bit_allocation,            * G  *                              subband_quantization, encode_bit_alloc* G  *                              sample_encoding                       * G  * 6/10/91  Earle Jennings      modified II_subband_quantization to   * G  *                              resolve type cast problem for MS_DOS  * G  * 6/11/91  Earle Jennings      modified to avoid overflow on MS_DOS  * G  *                              in routine filter_subband             * G  * 7/10/91  Earle Jennings      port to MsDos from MacIntosh version  * G  * 8/ 8/91  Jens Spille         Change for MS-C6.00                   * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced function encode_CRC  * G  *11/ 8/91  Kathy Wang          Documentation of code                 * G  *                              All variablenames are referred to     * G  *                              with surrounding pound (#) signs      * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 6/16/92  Shaun Astarabadi    Changed I_scale_factor_calc() and     * G  *                              II_scale_factor_calc() to use scale   * G  *                              factor 0 thru 62 only and not to      * G  *                              encode index 63 into the bit stream.  * G  * 7/27/92  Mike Li             (re-)Port to MS-DOS                   * G  * 9/22/92  jddevine@aware.com  Fixed _scale_factor_calc() defs       * G  * 3/31/93  Giogio Dimino       changed II_a_bit_allocation() from:   * G  *                              if( ad > ...) to if(ad >= ...)        * G  * 8/05/93  TEST                changed I_a_bit_allocation() from:    * G  *                              if( ad > ...) to if(ad >= ...)        * H  **********************************************************************/    #include "common.h"  #include "encoder.h"  
 #ifdef MS_DOS   extern unsigned _stklen = 16384; #endif    J /*=======================================================================\I |                                                                       | I | This segment contains all the core routines of the encoder,           | I | except for the psychoacoustic models.                                 | I |                                                                       | I | The user can select either one of the two psychoacoustic              | I | models. Model I is a simple tonal and noise masking threshold         | I | generator, and Model II is a more sophisticated cochlear masking      | I | threshold generator. Model I is recommended for lower complexity      | I | applications whereas Model II gives better subjective quality at low  | I | bit rates.                                                            | I |                                                                       | I | Layers I and II of mono, stereo, and joint stereo modes are supported.| I | Routines associated with a given layer are prefixed by "I_" for layer | I | 1 and "II_" for layer 2.                                              | J \=======================================================================*/   J /************************************************************************/ /* /* read_samples()  /*< /* PURPOSE:  reads the PCM samples from a file to the buffer /* /*  SEMANTICS:C /* Reads #samples_read# number of shorts from #musicin# filepointer ? /* into #sample_buffer[]#.  Returns the number of samples read.  /*J /************************************************************************/  K unsigned long read_samples(musicin, sample_buffer, num_samples, frame_size)  FILE *musicin; short sample_buffer[2304];& unsigned long num_samples, frame_size; {      unsigned long samples_read; )     static unsigned long samples_to_read;      static char init = TRUE;       if (init) { &         samples_to_read = num_samples;         init = FALSE;      } &     if (samples_to_read >= frame_size)"         samples_read = frame_size;     else'         samples_read = samples_to_read;      if ((samples_read = O          fread(sample_buffer, sizeof(short), (int)samples_read, musicin)) == 0)**         printf("Hit end of audio data\n");$     samples_to_read -= samples_read;8     if (samples_read < frame_size && samples_read > 0) {N         printf("Insufficient PCM input for one frame - fillout with zeros\n");M         for (; samples_read < frame_size; sample_buffer[samples_read++] = 0);*         samples_to_read = 0;     }o     return(samples_read);  }   J /************************************************************************/ /* /* get_audio() /*C /* PURPOSE:  reads a frame of audio data from a file to the buffer,n= /*   aligns the data for future processing, and separates the  /*   left and right channels /* /*  SEMANTICS:F /* Calls read_samples() to read a frame of audio data from filepointerG /* #musicin# to #insampl[]#.  The data is shifted to make sure the data L /* is centered for the 1024pt window to be used by the psychoacoustic model,G /* and to compensate for the 256 sample delay from the filter bank. ForcE /* stereo, the channels are also demultiplexed into #buffer[0][]# and  /* #buffer[1][]# /*J /************************************************************************/   B unsigned long get_audio(musicin, buffer, num_samples, stereo, lay) FILE *musicin; short FAR buffer[2][1152]; unsigned long num_samples; int stereo, lay; { 	    int j;n    short insamp[2304];    unsigned long samples_read;       if (lay == 1){a,       if(stereo == 2){ /* layer 1, stereo */B          samples_read = read_samples(musicin, insamp, num_samples,:                                      (unsigned long) 768);          for(j=0;j<448;j++) {              if(j<64) {/                buffer[0][j] = buffer[0][j+384];a/                buffer[1][j] = buffer[1][j+384]; 
             }              else {.                buffer[0][j] = insamp[2*j-128];.                buffer[1][j] = insamp[2*j-127];
             } 
          }       }         else { /* layer 1, mono */B          samples_read = read_samples(musicin, insamp, num_samples,:                                      (unsigned long) 384);          for(j=0;j<448;j++){             if(j<64) {/                buffer[0][j] = buffer[0][j+384];                  buffer[1][j] = 0;
             }t             else {+                buffer[0][j] = insamp[j-64];n                 buffer[1][j] = 0;
             } 
          }       }     }	    else { 3       if(stereo == 2){ /* layer 2 (or 3), stereo */ B          samples_read = read_samples(musicin, insamp, num_samples,;                                      (unsigned long) 2304);           for(j=0;j<1152;j++) {'             buffer[0][j] = insamp[2*j]; )             buffer[1][j] = insamp[2*j+1]; 
          }       } '       else { /* layer 2 (or 3), mono */iB          samples_read = read_samples(musicin, insamp, num_samples,;                                      (unsigned long) 1152);           for(j=0;j<1152;j++){o%             buffer[0][j] = insamp[j];              buffer[1][j] = 0;p
          }       }     }    return(samples_read); }r  _J /************************************************************************/ /* /* read_ana_window() /*F /* PURPOSE:  Reads encoder window file "enwindow" into array #ana_win# /*J /************************************************************************/    void read_ana_window(ana_win)d double FAR ana_win[HAN_SIZE];* {1     int i,j[4];n
     FILE *fp;d     double f[4];     char t[150];   .     if (!(fp = OpenTableFile("enwindow") ) ) {A        printf("Please check analysis window table 'enwindow'\n");i        exit(1);D     }      for (i=0;i<512;i+=4) {        fgets(t, 150, fp);nD        sscanf(t,"C[%d] = %lf C[%d] = %lf C[%d] = %lf C[%d] = %lf\n",,               j, f,j+1,f+1,j+2,f+2,j+3,f+3);        if (i==j[0]) {6           ana_win[i] = f[0];           ana_win[i+1] = f[1];           ana_win[i+2] = f[2];           ana_win[i+3] = f[3];        }
        else { ;           printf("Check index in analysis window table\n");            exit(1);        }        fgets(t,150,fp);e     }      fclose(fp);- }e  J /************************************************************************/ /* /* window_subband()/ /*. /* PURPOSE:  Overlapping window on PCM samples /*
 /* SEMANTICS: D /* 32 16-bit pcm samples are scaled to fractional 2's complement andG /* concatenated to the end of the window buffer #x#. The updated window*H /* buffer #x# is then windowed by the analysis window #c# to produce the /* windowed sample #z# /*J /************************************************************************/  b! void window_subband(buffer, z, k)  short FAR **buffer;  double FAR z[HAN_SIZE];t int k; {a'     typedef double FAR XX[2][HAN_SIZE];      static XX FAR *x;r
     int i, j;      static off[2] = {0,0};     static char init = 0;J     static double FAR *c;*     if (!init) {J         c = (double FAR *) mem_alloc(sizeof(double) * HAN_SIZE, "window");         read_ana_window(c);v1         x = (XX FAR *) mem_alloc(sizeof(XX),"x");          for (i=0;i<2;i++)e$             for (j=0;j<HAN_SIZE;j++)                 (*x)[i][j] = 0;c         init = 1;*     }   7     /* replace 32 oldest samples with 32 new samples */ J     for (i=0;i<32;i++) (*x)[k][31-i+off[k]] = (double) *(*buffer)++/SCALE;4     /* shift samples into proper window positions */J     for (i=0;i<HAN_SIZE;i++) z[i] = (*x)[k][(i+off[k])&HAN_SIZE-1] * c[i];A     off[k] += 480;              /*offset is modulo (HAN_SIZE-1)*/c     off[k] &= HAN_SIZE-1;*   }/   J /************************************************************************/ /* /* create_ana_filter() /*= /* PURPOSE:  Calculates the analysis filter bank coefficientsn /*
 /* SEMANTICS:iD /* Calculates the analysis filterbank coefficients and rounds to theA /* 9th decimal place accuracy of the filterbank tables in the ISO*5 /* document.  The coefficients are stored in #filter#i /*J /************************************************************************/    void create_ana_filter(filter) double FAR filter[SBLIMIT][64];= {=    register int i,k;       for (i=0; i<32; i++)        for (k=0; k<64; k++) {K           if ((filter[i][k] = 1e9*cos((double)((2*i+1)*(16-k)*PI64))) >= 0) 3              modf(filter[i][k]+0.5, &filter[i][k]);            else3              modf(filter[i][k]-0.5, &filter[i][k]);            filter[i][k] *= 1e-9;s    } }l  J /************************************************************************/ /* /* filter_subband()  /*= /* PURPOSE:  Calculates the analysis filter bank coefficientso /*
 /* SEMANTICS:rM /*      The windowed samples #z# is filtered by the digital filter matrix #m#eE /* to produce the subband samples #s#. This done by first selectivelyuE /* picking out values from the windowed samples, and then multiplying ; /* them by the filter matrix, producing 32 subband samples.  /*J /************************************************************************/  e void filter_subband(z,s)# double FAR z[HAN_SIZE], s[SBLIMIT];l {r    double y[64];    int i,j;  static char init = 0;a"    typedef double MM[SBLIMIT][64]; static MM FAR *m; 
 #ifdef MS_DOS=    long    SIZE_OF_MM;     SIZE_OF_MM      = SBLIMIT*64;    SIZE_OF_MM      *= 8;    if (!init) {*6        m = (MM FAR *) mem_alloc(SIZE_OF_MM, "filter");        create_ana_filter(*m);e        init = 1;    } #else     if (!init) {E6        m = (MM FAR *) mem_alloc(sizeof(MM), "filter");        create_ana_filter(*m);         init = 1;    } #endifD    for (i=0;i<64;i++) for (j=0, y[i] = 0;j<8;j++) y[i] += z[i+64*j];    for (i=0;i<SBLIMIT;i++)=        for (j=0, s[i]= 0;j<64;j++) s[i] += (*m)[i][j] * y[j];m }m  J /************************************************************************/ /* /* encode_info() /*C /* PURPOSE:  Puts the syncword and header information on the outputs
 /* bitstream.  /*J /************************************************************************/  ; void encode_info(fr_ps,bs) frame_params *fr_ps; Bit_stream_struc *bs;  { $         layer *info = fr_ps->header;   G         putbits(bs,0xfff,12);                    /* syncword 12 bits */ G         put1bit(bs,info->version);               /* ID        1 bit  */*G         putbits(bs,4-info->lay,2);               /* layer     2 bits */lM         put1bit(bs,!info->error_protection);     /* bit set => no err prot */n*         putbits(bs,info->bitrate_index,4);/         putbits(bs,info->sampling_frequency,2);a"         put1bit(bs,info->padding);B         put1bit(bs,info->extension);             /* private_bit */!         putbits(bs,info->mode,2);*%         putbits(bs,info->mode_ext,2);*$         put1bit(bs,info->copyright);#         put1bit(bs,info->original); %         putbits(bs,info->emphasis,2);  }   iJ /************************************************************************/ /* /* mod() /*7 /* PURPOSE:  Returns the absolute value of its argumentd /*J /************************************************************************/   
 double mod(a) 	 double a;r {f     return (a > 0) ? a : -a; }y  eJ /************************************************************************/ /* /* I_combine_LR    (Layer I) /* II_combine_LR   (Layer II)x /*? /* PURPOSE:Combines left and right channels into a mono channel* /*H /* SEMANTICS:  The average of left and right subband samples is put into /* #joint_sample#e /*< /* Layer I and II differ in frame length and # subbands used /*J /************************************************************************/  m* void I_combine_LR(sb_sample, joint_sample)1 double FAR sb_sample[2][3][SCALE_BLOCK][SBLIMIT];e1 double FAR joint_sample[3][SCALE_BLOCK][SBLIMIT];s/ {   /* make a filtered mono for joint stereo */      int sb, smp;  n     for(sb = 0; sb<SBLIMIT; ++sb)*       for(smp = 0; smp<SCALE_BLOCK; ++smp)'         joint_sample[0][smp][sb] = .5 *8J                     (sb_sample[0][0][smp][sb] + sb_sample[1][0][smp][sb]); }    4 void II_combine_LR(sb_sample, joint_sample, sblimit)1 double FAR sb_sample[2][3][SCALE_BLOCK][SBLIMIT]; 1 double FAR joint_sample[3][SCALE_BLOCK][SBLIMIT];  int sblimit;. {  /* make a filtered mono for joint stereo */    int sb, smp, sufr;         for(sb = 0; sb<sblimit; ++sb)*       for(smp = 0; smp<SCALE_BLOCK; ++smp)&          for(sufr = 0; sufr<3; ++sufr)K             joint_sample[sufr][smp][sb] = .5 * (sb_sample[0][sufr][smp][sb] J                                            + sb_sample[1][sufr][smp][sb]); }    I /************************************************************************  /*$ /* I_scale_factor_calc     (Layer I)% /* II_scale_factor_calc    (Layer II)r /*D /* PURPOSE:For each subband, calculate the scale factor for each set /* of the 12 subband samples /*E /* SEMANTICS:  Pick the scalefactor #multiple[]# just larger than the*; /* absolute value of the peak subband sample of 12 samples, = /* and store the corresponding scalefactor index in #scalar#.m /*< /* Layer II has three sets of 12-subband samples for a given /* subband.  /*J /************************************************************************/  u1 void I_scale_factor_calc(sb_sample,scalar,stereo)=0 double FAR sb_sample[][3][SCALE_BLOCK][SBLIMIT];" unsigned int scalar[][3][SBLIMIT]; int stereo;* {*    int i,j, k;    double s[SBLIMIT];        for (k=0;k<stereo;k++) {P      for (i=0;i<SBLIMIT;i++)E        for (j=1, s[i] = mod(sb_sample[k][0][0][i]);j<SCALE_BLOCK;j++)*/          if (mod(sb_sample[k][0][j][i]) > s[i]) .             s[i] = mod(sb_sample[k][0][j][i]);  H      for (i=0;i<SBLIMIT;i++)H        for (j=SCALE_RANGE-2,scalar[k][0][i]=0;j>=0;j--) /* $A 6/16/92 */#          if (s[i] <= multiple[j]) {               scalar[k][0][i] = j;             break;
          }    } }(  J /******************************** Layer II ******************************/  n: void II_scale_factor_calc(sb_sample,scalar,stereo,sblimit)0 double FAR sb_sample[][3][SCALE_BLOCK][SBLIMIT];" unsigned int scalar[][3][SBLIMIT]; int stereo,sblimit;  {_   int i,j, k,t;    double s[SBLIMIT];  f,   for (k=0;k<stereo;k++) for (t=0;t<3;t++) {     for (i=0;i<sblimit;i++)rD       for (j=1, s[i] = mod(sb_sample[k][t][0][i]);j<SCALE_BLOCK;j++).         if (mod(sb_sample[k][t][j][i]) > s[i])/              s[i] = mod(sb_sample[k][t][j][i]);*  *   for (i=0;i<sblimit;i++)*H     for (j=SCALE_RANGE-2,scalar[k][t][i]=0;j>=0;j--)    /* $A 6/16/92 */        if (s[i] <= multiple[j]) {          scalar[k][t][i] = j;e          break;o       }oD       for (i=sblimit;i<SBLIMIT;i++) scalar[k][t][i] = SCALE_RANGE-1;     }d }n  I /************************************************************************e /* /* pick_scale  (Layer II)* /*C /* PURPOSE:For each subband, puts the smallest scalefactor of the 3 7 /* associated with a frame into #max_sc#.  This is usedr" /* used by Psychoacoustic Model I./ /* (I would recommend changin max_sc to min_sc)  /*J /************************************************************************/  n& void pick_scale(scalar, fr_ps, max_sc)# unsigned int scalar[2][3][SBLIMIT];A frame_params *fr_ps; double FAR max_sc[2][SBLIMIT]; {    int i,j,k,max;   int stereo  = fr_ps->stereo;   int sblimit = fr_ps->sblimit;   o   for (k=0;k<stereo;k++)8     for (i=0;i<sblimit;max_sc[k][i] = multiple[max],i++).       for (j=1, max = scalar[k][0][i];j<3;j++):          if (max > scalar[k][j][i]) max = scalar[k][j][i];D   for (i=sblimit;i<SBLIMIT;i++) max_sc[0][i] = max_sc[1][i] = 1E-20; }t  I /************************************************************************  /* /* put_scale   (Layer I) /*= /* PURPOSE:Sets #max_sc# to the scalefactor index in #scalar.I) /* This is used by Psychoacoustic Model I  /*J /************************************************************************/   % void put_scale(scalar, fr_ps, max_sc) # unsigned int scalar[2][3][SBLIMIT];c frame_params *fr_ps; double FAR max_sc[2][SBLIMIT]; {s    int i,j,k, max;    int stereo  = fr_ps->stereo;d     int sblimit = fr_ps->sblimit;  n1    for (k=0;k<stereo;k++) for (i=0;i<SBLIMIT;i++)s1         max_sc[k][i] = multiple[scalar[k][0][i]];* }*  *I /************************************************************************l /** /* II_transmission_pattern (Layer II only) /*C /* PURPOSE:For a given subband, determines whether to send 1, 2, or): /* all 3 of the scalefactors, and fills in the scalefactor! /* select information accordinglym /*I /* SEMANTICS:  The subbands and channels are classified based on how muchr@ /* the scalefactors changes over its three values (corresponding@ /* to the 3 sets of 12 samples per subband).  The classificationE /* will send 1 or 2 scalefactors instead of three if the scalefactorse; /* do not change much.  The scalefactor select information, % /* #scfsi#, is filled in accordingly.t /*J /************************************************************************/   2 void II_transmission_pattern(scalar, scfsi, fr_ps)# unsigned int scalar[2][3][SBLIMIT];t unsigned int scfsi[2][SBLIMIT];a frame_params *fr_ps; {d    int stereo  = fr_ps->stereo;*     int sblimit = fr_ps->sblimit;    int dscf[2];*    int class[2],i,j,k;> static int pattern[5][5] = {0x123, 0x122, 0x122, 0x133, 0x123,>                             0x113, 0x111, 0x111, 0x444, 0x113,>                             0x111, 0x111, 0x111, 0x333, 0x113,>                             0x222, 0x222, 0x222, 0x333, 0x123,?                             0x123, 0x122, 0x122, 0x133, 0x123};O  M    for (k=0;k<stereo;k++)_      for (i=0;i<sblimit;i++) {4        dscf[0] =  (scalar[k][0][i]-scalar[k][1][i]);4        dscf[1] =  (scalar[k][1][i]-scalar[k][2][i]);        for (j=0;j<2;j++) {'          if (dscf[j]<=-3) class[j] = 0; ;          else if (dscf[j] > -3 && dscf[j] <0) class[j] = 1;<2               else if (dscf[j] == 0) class[j] = 2;E                    else if (dscf[j] > 0 && dscf[j] < 3) class[j] = 3;**                         else class[j] = 4;        }-        switch (pattern[class[0]][class[1]]) {e)          case 0x123 :    scfsi[k][i] = 0;                           break;*)          case 0x122 :    scfsi[k][i] = 3;*;                          scalar[k][2][i] = scalar[k][1][i];_                          break;a)          case 0x133 :    scfsi[k][i] = 3;b;                          scalar[k][1][i] = scalar[k][2][i];                           break;;)          case 0x113 :    scfsi[k][i] = 1; ;                          scalar[k][1][i] = scalar[k][0][i];i                          break;>)          case 0x111 :    scfsi[k][i] = 2; M                          scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];s                          break;u)          case 0x222 :    scfsi[k][i] = 2;sM                          scalar[k][0][i] = scalar[k][2][i] = scalar[k][1][i];,                          break;d)          case 0x333 :    scfsi[k][i] = 2;gM                          scalar[k][0][i] = scalar[k][1][i] = scalar[k][2][i];)                          break;*)          case 0x444 :    scfsi[k][i] = 2;*?                          if (scalar[k][0][i] > scalar[k][2][i])u@                               scalar[k][0][i] = scalar[k][2][i];M                          scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];n       }?    } }    I /************************************************************************* /* /* I_encode_scale  (Layer I) /* II_encode_scale (Layer II)I /*@ /* PURPOSE:The encoded scalar factor information is arranged and1 /* queued into the output fifo to be transmitted.t /*8 /* For Layer II, the three scale factors associated with< /* a given subband and channel are transmitted in accordance. /* with the scfsi, which is transmitted first. /*J /************************************************************************/  s1 void I_encode_scale(scalar, bit_alloc, fr_ps, bs)j# unsigned int scalar[2][3][SBLIMIT];s# unsigned int bit_alloc[2][SBLIMIT];n frame_params *fr_ps; Bit_stream_struc *bs;  {;    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;    int i,j;p  01    for (i=0;i<SBLIMIT;i++) for (j=0;j<stereo;j++)09       if (bit_alloc[j][i]) putbits(bs,scalar[j][0][i],6);_ }b  _J /***************************** Layer II  ********************************/  B9 void II_encode_scale(bit_alloc, scfsi, scalar, fr_ps, bs) 6 unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT];# unsigned int scalar[2][3][SBLIMIT];  frame_params *fr_ps; Bit_stream_struc *bs;  {;    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;
    int i,j,k;s  l1    for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++) 5      if (bit_alloc[k][i])  putbits(bs,scfsi[k][i],2);*  *1    for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++)*K      if (bit_alloc[k][i])  /* above jsbound, bit_alloc[0][i] == ba[1][i] */r         switch (scfsi[k][i]) {$            case 0: for (j=0;j<3;j++)3                      putbits(bs,scalar[k][j][i],6);s                    break;h            case 1:1            case 3: putbits(bs,scalar[k][0][i],6);t1                    putbits(bs,scalar[k][2][i],6);e                    break;t1            case 2: putbits(bs,scalar[k][0][i],6);e	         }b }d  mJ /*=======================================================================\J |                                                                        |J |      The following routines are done after the masking threshold       |J | has been calculated by the fft analysis routines in the Psychoacoustic |J | model. Using the MNR calculated, the actual number of bits allocated   |J | to each subband is found iteratively.                                  |J |                                                                        |J \=======================================================================*/  lI /************************************************************************  /*  /* I_bits_for_nonoise  (Layer I)! /* II_bits_for_nonoise (Layer II)} /*; /* PURPOSE:Returns the number of bits required to produce a*G /* mask-to-noise ratio better or equal to the noise/no_noise threshold.b /*
 /* SEMANTICS:s3 /* bbal = # bits needed for encoding bit allocationaC /* bsel = # bits needed for encoding scalefactor select informationbA /* banc = # bits needed for ancillary data (header info included)  /*? /* For each subband and channel, will add bits until one of the] /* following occurs:@ /* - Hit maximum number of bits we can allocate for that subband= /* - MNR is better than or equal to the minimum masking leveli /*   (NOISY_MIN_MNR)B /* Then the bits required for scalefactors, scfsi, bit allocation,A /* and the subband samples are tallied (#req_bits#) and returned.e /*F /* (NOISY_MIN_MNR) is the smallest MNR a subband can have before it isA /* counted as 'noisy' by the logic which chooses the number of JS* /* subbands. /* /* Joint stereo is supported.  /*J /************************************************************************/  9 static double snr[18] = {0.00, 7.00, 11.00, 16.00, 20.84,e4                          25.28, 31.59, 37.75, 43.84,;                          49.89, 55.93, 61.96, 67.98, 74.01,*5                          80.03, 86.05, 92.01, 98.01};n  ' int I_bits_for_nonoise(perm_smr, fr_ps)n  double FAR perm_smr[2][SBLIMIT]; frame_params *fr_ps; {o
    int i,j,k;[    int stereo  = fr_ps->stereo;;     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    int req_bits = 0;  +/    /* initial b_anc (header) allocation bits */eB    req_bits = 32 + 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );       for(i=0; i<SBLIMIT; ++i) .      for(j=0; j<((i<jsbound)?stereo:1); ++j) {        for(k=0;k<14; ++k)i9          if( (-perm_smr[j][i] + snr[k]) >= NOISY_MIN_MNR)*,            break; /* we found enough bits */I          if(stereo == 2 && i >= jsbound)     /* check other JS channel */#            for(;k<14; ++k)F              if( (-perm_smr[1-j][i] + snr[k]) >= NOISY_MIN_MNR) break;K          if(k>0) req_bits += (k+1)*SCALE_BLOCK + 6*((i>=jsbound)?stereo:1);     }    return req_bits;B }I  cJ /***************************** Layer II  ********************************/   / int II_bits_for_nonoise(perm_smr, scfsi, fr_ps)=  double FAR perm_smr[2][SBLIMIT]; unsigned int scfsi[2][SBLIMIT];i frame_params *fr_ps; {]    int sb,ch,ba;    int stereo  = fr_ps->stereo;*     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;3    int req_bits = 0, bbal = 0, berr = 0, banc = 32;s-    int maxAlloc, sel_bits, sc_bits, smp_bits;lG static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */m      /* added 92-08-11 shn */d>    if (fr_ps->header->error_protection) berr=16; else berr=0;   r    for (sb=0; sb<jsbound; ++sb)c+      bbal += stereo * (*alloc)[sb][0].bits;p%    for (sb=jsbound; sb<sblimit; ++sb)l"      bbal += (*alloc)[sb][0].bits;!    req_bits = banc + bbal + berr;        for(sb=0; sb<sblimit; ++sb)2      for(ch=0; ch<((sb<jsbound)?stereo:1); ++ch) {.        maxAlloc = (1<<(*alloc)[sb][0].bits)-1;)        sel_bits = sc_bits = smp_bits = 0; $        for(ba=0;ba<maxAlloc-1; ++ba)K          if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])I              >= NOISY_MIN_MNR)2             break;      /* we found enough bits */D        if(stereo == 2 && sb >= jsbound) /* check other JS channel */"          for(;ba<maxAlloc-1; ++ba)N            if( (-perm_smr[1-ch][sb]+ snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])                 >= NOISY_MIN_MNR)              break;3        if(ba>0) { S          smp_bits = SCALE_BLOCK * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);25          /* scale factor bits required for subband */r          sel_bits = 2;3          sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];s+          if(stereo == 2 && sb >= jsbound) {].            /* each new js sb has L+R scfsis */            sel_bits += 2;=8            sc_bits  += 6 * sfsPerScfsi[scfsi[1-ch][sb]];
          }/          req_bits += smp_bits+sel_bits+sc_bits;c        }    }    return req_bits;  }(  fI /************************************************************************j /*$ /* I_main_bit_allocation   (Layer I)% /* II_main_bit_allocation  (Layer II)x /*A /* PURPOSE:For joint stereo mode, determines which of the 4 jointcB /* stereo modes is needed.  Then calls *_a_bit_allocation(), whichG /* allocates bits for each of the subbands until there are no more bitss7 /* left, or the MNR is at the noise/no_noise threshold.s /*
 /* SEMANTICS:a /*> /* For joint stereo mode, joint stereo is changed to stereo if? /* there are enough bits to encode stereo at or better than the]= /* no-noise threshold (NOISY_MIN_MNR).  Otherwise, the system B /* iteratively allocates less bits by using joint stereo until one /* of the following occurs:s< /* - there are no more noisy subbands (MNR >= NOISY_MIN_MNR)A /* - mode_ext has been reduced to 0, which means that all but the]? /*   lowest 4 subbands have been converted from stereo to joint 2 /*   stereo, and no more subbands may be converted /*I /*     This function calls *_bits_for_nonoise() and *_a_bit_allocation().[ /*J /************************************************************************/   ; void I_main_bit_allocation(perm_smr, bit_alloc, adb, fr_ps)]  double FAR perm_smr[2][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT]; 	 int *adb;  frame_params *fr_ps; {]    int  noisy_sbs;    int  mode, mode_ext, lay, i;}    int  rq_db, av_db = *adb; static  int init = 0;*  *    if(init == 0) {$      /* rearrange snr for layer I */      snr[2] = snr[3];(*      for (i=3;i<16;i++) snr[i] = snr[i+2];      init = 1;    }  r;    if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO) {t)      fr_ps->header->mode = MPG_MD_STEREO;o!      fr_ps->header->mode_ext = 0;a%      fr_ps->jsbound = fr_ps->sblimit;d=      if(rq_db = I_bits_for_nonoise(perm_smr, fr_ps) > *adb) {*1        fr_ps->header->mode = MPG_MD_JOINT_STEREO;*@        mode_ext = 4;           /* 3 is least severe reduction */         lay = fr_ps->header->lay;        do {n           --mode_ext;[3           fr_ps->jsbound = js_bound(lay, mode_ext);s6           rq_db = I_bits_for_nonoise(perm_smr, fr_ps);2        } while( (rq_db > *adb) && (mode_ext > 0));*        fr_ps->header->mode_ext = mode_ext;D      }    /* well we either eliminated noisy sbs or mode_ext == 0 */    }C    noisy_sbs = I_a_bit_allocation(perm_smr, bit_alloc, adb, fr_ps);d }_  oJ /***************************** Layer II  ********************************/  IC void II_main_bit_allocation(perm_smr, scfsi, bit_alloc, adb, fr_ps)a  double FAR perm_smr[2][SBLIMIT]; unsigned int scfsi[2][SBLIMIT];t# unsigned int bit_alloc[2][SBLIMIT];i	 int *adb;j frame_params *fr_ps; {     int  noisy_sbs, nn;    int  mode, mode_ext, lay;    int  rq_db, av_db = *adb;  l;    if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO) {i)      fr_ps->header->mode = MPG_MD_STEREO;b!      fr_ps->header->mode_ext = 0;b%      fr_ps->jsbound = fr_ps->sblimit; E      if((rq_db=II_bits_for_nonoise(perm_smr, scfsi, fr_ps)) > *adb) { 1        fr_ps->header->mode = MPG_MD_JOINT_STEREO; @        mode_ext = 4;           /* 3 is least severe reduction */         lay = fr_ps->header->lay;        do {t          --mode_ext;2          fr_ps->jsbound = js_bound(lay, mode_ext);=          rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps);=2        } while( (rq_db > *adb) && (mode_ext > 0));*        fr_ps->header->mode_ext = mode_ext;D      }    /* well we either eliminated noisy sbs or mode_ext == 0 */    }K    noisy_sbs = II_a_bit_allocation(perm_smr, scfsi, bit_alloc, adb, fr_ps);f }a  yI /************************************************************************e /*  /* I_a_bit_allocation  (Layer I)! /* II_a_bit_allocation (Layer II)e /*B /* PURPOSE:Adds bits to the subbands with the lowest mask-to-noise? /* ratios, until the maximum number of bits for the subband has= /* been allocated. /*
 /* SEMANTICS:=C /* 1. Find the subband and channel with the smallest MNR (#min_sb#,* /*    and #min_ch#) B /* 2. Calculate the increase in bits needed if we increase the bit) /*    allocation to the next higher levelfF /* 3. If there are enough bits available for increasing the resolutionD /*    in #min_sb#, #min_ch#, and the subband has not yet reached itsB /*    maximum allocation, update the bit allocation, MNR, and bits /*    available accordinglymD /* 4. Repeat until there are no more bits left, or no more available? /*    subbands. (A subband is still available until the maximumeA /*    number of bits for the subband has been allocated, or therecC /*    aren't enough bits to go to the next higher resolution in the  /*    subband.)e /*J /************************************************************************/  aN int I_a_bit_allocation(perm_smr, bit_alloc, adb, fr_ps) /* return noisy sbs */  double FAR perm_smr[2][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT]; 	 int *adb;t frame_params *fr_ps; {c;    int i, k, smpl_bits, scale_bits, min_sb, min_ch, oth_ch;s2    int bspl, bscf, ad, noisy_sbs, done = 0, bbal ;!    double mnr[2][SBLIMIT], small;*    char used[2][SBLIMIT];l    int stereo  = fr_ps->stereo;6     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc; static char init= 0; static int banc=32, berr=0;8  3    if (!init) {8       init = 1;iO       if (fr_ps->header->error_protection) berr = 16;  /* added 92-08-11 shn */*    }9    bbal = 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );i    *adb -= bbal + berr + banc;    ad= *adb;  _3    for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++) { %      mnr[k][i]=snr[0]-perm_smr[k][i];r      bit_alloc[k][i] = 0;n      used[k][i] = 0;    }    bspl = bscf = 0;0  <    do  {.      /* locate the subband with minimum SMR */6      small = mnr[0][0]+1;    min_sb = -1; min_ch = -1;3      for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++)k.        /* go on only if there are bits left */2        if (used[k][i] != 2 && small > mnr[k][i]) {          small = mnr[k][i];+!          min_sb = i;  min_ch = k;]        }:      if(min_sb > -1) {   /* there was something to find */4        /* first step of bit allocation is biggest */N        if (used[min_ch][min_sb])  { smpl_bits = SCALE_BLOCK; scale_bits = 0; }E        else                       { smpl_bits = 24; scale_bits = 6; }f9        if(min_sb >= jsbound)        scale_bits *= stereo;i  [8        /* check to see enough bits were available for */6        /* increasing resolution in the minimum band */  i8        if (ad >= bspl + bscf + scale_bits + smpl_bits) {8          bspl += smpl_bits; /* bit for subband sample */7          bscf += scale_bits; /* bit for scale factor */s%          bit_alloc[min_ch][min_sb]++;29          used[min_ch][min_sb] = 1; /* subband has bits */18          mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb]@                                + snr[bit_alloc[min_ch][min_sb]];A          /* Check if subband has been fully allocated max bits */+I          if (bit_alloc[min_ch][min_sb] ==  14 ) used[min_ch][min_sb] = 2;         }9        else            /* no room to improve this band */?A          used[min_ch][min_sb] = 2; /*   for allocation anymore */ -        if(stereo == 2 && min_sb >= jsbound) { :          oth_ch = 1-min_ch;  /* joint-st : fix other ch */?          bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb];>5          used[oth_ch][min_sb] = used[min_ch][min_sb];n8          mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb]@                                + snr[bit_alloc[oth_ch][min_sb]];        }      }B    } while(min_sb>-1);     /* i.e. still some sub-bands to find */  A    /* Calculate the number of bits left, add on to pointed var */     ad -= bspl+bscf;_
    *adb = ad;c  (    /* see how many channels are noisy */$    noisy_sbs = 0; small = mnr[0][0];    for(k=0; k<stereo; ++k) {"      for(i = 0; i< SBLIMIT; ++i) {3        if(mnr[k][i] < NOISY_MIN_MNR)   ++noisy_sbs; 9        if(small > mnr[k][i])           small = mnr[k][i];s      }    }    return noisy_sbs; }   J /***************************** Layer II  ********************************/  b? int II_a_bit_allocation(perm_smr, scfsi, bit_alloc, adb, fr_ps)_  double FAR perm_smr[2][SBLIMIT]; unsigned int scfsi[2][SBLIMIT];*# unsigned int bit_alloc[2][SBLIMIT];_	 int *adb;i frame_params *fr_ps; {n@    int i, min_ch, min_sb, oth_ch, k, increment, scale, seli, ba;/    int bspl, bscf, bsel, ad, noisy_sbs, bbal=0;e!    double mnr[2][SBLIMIT], small;l    char used[2][SBLIMIT];t    int stereo  = fr_ps->stereo;u     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc; static char init= 0; static int banc=32, berr=0;hG static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */r  a    if (!init) {         init = 1;  M        if (fr_ps->header->error_protection) berr=16; /* added 92-08-11 shn */o    }    for (i=0; i<jsbound; ++i)*      bbal += stereo * (*alloc)[i][0].bits;"    for (i=jsbound; i<sblimit; ++i)!      bbal += (*alloc)[i][0].bits;w    *adb -= bbal + berr + banc;
    ad = *adb;b  s3    for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++) {e%      mnr[k][i]=snr[0]-perm_smr[k][i];d      bit_alloc[k][i] = 0;c      used[k][i] = 0;    }    bspl = bscf = bsel = 0;  *    do  {.      /* locate the subband with minimum SMR */0      small = 999999.0; min_sb = -1; min_ch = -1;2      for (i=0;i<sblimit;i++) for(k=0;k<stereo;++k)3        if (used[k][i]  != 2 && small > mnr[k][i]) {n          small = mnr[k][i];;!          min_sb = i;  min_ch = k;o      }:      if(min_sb > -1) {   /* there was something to find */=        /* find increase in bit allocation in subband [min] */eW        increment = SCALE_BLOCK * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].group *;L                         (*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);         if (used[min_ch][min_sb])W          increment -= SCALE_BLOCK * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]].group*(M                            (*alloc)[min_sb][bit_alloc[min_ch][min_sb]].bits);o  =9        /* scale factor bits required for subband [min] */ D        oth_ch = 1 - min_ch;    /* above js bound, need both chans */2        if (used[min_ch][min_sb]) scale = seli = 0;D        else {          /* this channel had no bits or scfs before */          seli = 2;8          scale = 6 * sfsPerScfsi[scfsi[min_ch][min_sb]];/          if(stereo == 2 && min_sb >= jsbound) {*.            /* each new js sb has L+R scfsis */            seli += 2;y;            scale += 6 * sfsPerScfsi[scfsi[oth_ch][min_sb]]; 
          }        }8        /* check to see enough bits were available for */6        /* increasing resolution in the minimum band */A        if (ad >= bspl + bscf + bsel + seli + scale + increment) {t>          ba = ++bit_alloc[min_ch][min_sb]; /* next up alloc */:          bspl += increment;  /* bits for subband sample */8          bscf += scale;      /* bits for scale factor */6          bsel += seli;       /* bits for scfsi code */9          used[min_ch][min_sb] = 1; /* subband has bits */f:          mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +A                                snr[(*alloc)[min_sb][ba].quant+1];)A          /* Check if subband has been fully allocated max bits */ M          if (ba >= (1<<(*alloc)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;_        }E        else used[min_ch][min_sb] = 2; /* can't increase this alloc */s-        if(min_sb >= jsbound && stereo == 2) {s/          /* above jsbound, alloc applies L+R */wD          ba = bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb];5          used[oth_ch][min_sb] = used[min_ch][min_sb];n:          mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb] +A                                snr[(*alloc)[min_sb][ba].quant+1];*        }      }<    } while(min_sb > -1);   /* until could find no channel */*    /* Calculate the number of bits left */%    ad -= bspl+bscf+bsel;   *adb = ad; J    for (i=sblimit;i<SBLIMIT;i++) for (k=0;k<stereo;k++) bit_alloc[k][i]=0;  mI    noisy_sbs = 0;  small = mnr[0][0];      /* calc worst noise in case */=    for(k=0;k<stereo;++k) {      for (i=0;i<sblimit;i++) {0        if (small > mnr[k][i]) small = mnr[k][i];K        if(mnr[k][i] < NOISY_MIN_MNR) ++noisy_sbs; /* noise is not masked */e        }    }    return noisy_sbs; }g  iI /************************************************************************d /*$ /* I_subband_quantization  (Layer I)% /* II_subband_quantization (Layer II)l /*B /* PURPOSE:Quantizes subband samples to appropriate number of bits /*G /* SEMANTICS:  Subband samples are divided by their scalefactors, whichd@ /* makes the quantization more efficient. The scaled samples areB /* quantized by the function a*x+b, where a and b are functions ofB /* the number of quantization levels. The result is then truncated= /* to the appropriate number of bits and the MSB is inverted.* /*C /* Note that for fractional 2's complement, inverting the MSB for ar5 /* negative number x is equivalent to adding 1 to it.n /*J /************************************************************************/    static double a[17] = { B   0.750000000, 0.625000000, 0.875000000, 0.562500000, 0.937500000,B   0.968750000, 0.984375000, 0.992187500, 0.996093750, 0.998046875,B   0.999023438, 0.999511719, 0.999755859, 0.999877930, 0.999938965,   0.999969482, 0.999984741 };s  n static double b[17] = {fG   -0.250000000, -0.375000000, -0.125000000, -0.437500000, -0.062500000,iG   -0.031250000, -0.015625000, -0.007812500, -0.003906250, -0.001953125,)G   -0.000976563, -0.000488281, -0.000244141, -0.000122070, -0.000061035,s   -0.000030518, -0.000015259 };   dA void I_subband_quantization(scalar, sb_samples, j_scale, j_samps,+5                             bit_alloc, sbband, fr_ps)m# unsigned int scalar[2][3][SBLIMIT];02 double FAR sb_samples[2][3][SCALE_BLOCK][SBLIMIT];! unsigned int j_scale[3][SBLIMIT];sM double FAR j_samps[3][SCALE_BLOCK][SBLIMIT]; /* L+R for j-stereo if necess */-# unsigned int bit_alloc[2][SBLIMIT];(4 unsigned int FAR sbband[2][3][SCALE_BLOCK][SBLIMIT]; frame_params *fr_ps; {u    int i, j, k, n, sig;     int stereo  = fr_ps->stereo;r     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    double d; static char init = 0;o      if (!init) {       init = 1;E      /* rearrange quantization coef to correspond to layer I table */t      a[1] = a[2]; b[1] = b[2];9      for (i=2;i<15;i++) { a[i] = a[i+2]; b[i] = b[i+2]; }l    }6    for (j=0;j<SCALE_BLOCK;j++) for (i=0;i<SBLIMIT;i++)+      for (k=0;k<((i<jsbound)?stereo:1);k++)g        if (bit_alloc[k][i]) { L          /* for joint stereo mode, have to construct a single subband streamH             for the js channels.  At present, we calculate a set of monoG             subband samples and pass them through the scaling system tor;             generate an alternate normalised sample stream.i  hM             Could normalise both streams (divide by their scfs), then averagerF             them.  In bad conditions, this could give rise to spuriousL             cancellations.  Instead, we could just select the sb stream fromI             the larger channel (higher scf), in which case _that_ channel K             would be 'properly' reconstructed, and the mate would just be a M             scaled version.  Spec recommends averaging the two (unnormalised)=F             subband channels, then normalising this new signal withoutK             actually sending this scale factor... This means looking ahead.s          */ &          if(stereo == 2 && i>=jsbound)-            /* use the joint data passed in */r:            d = j_samps[0][j][i] / multiple[j_scale[0][i]];
          elsenB            d = sb_samples[k][0][j][i] / multiple[scalar[k][0][i]];7          /* scale and quantize floating point sample */           n = bit_alloc[k][i];r!          d = d * a[n-1] + b[n-1]; B          /* extract MSB N-1 bits from the floating point sample */          if (d >= 0) sig = 1;0$          else { sig = 0; d += 1.0; }D          sbband[k][0][j][i] = (unsigned int) (d * (double) (1L<<n));@          /* tag the inverted sign bit to sbband at position N */-          if (sig) sbband[k][0][j][i] |= 1<<n;*        } }*  *J /***************************** Layer II  ********************************/  mB void II_subband_quantization(scalar, sb_samples, j_scale, j_samps,6                              bit_alloc, sbband, fr_ps)# unsigned int scalar[2][3][SBLIMIT];_2 double FAR sb_samples[2][3][SCALE_BLOCK][SBLIMIT];! unsigned int j_scale[3][SBLIMIT]; , double FAR j_samps[3][SCALE_BLOCK][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT]; 4 unsigned int FAR sbband[2][3][SCALE_BLOCK][SBLIMIT]; frame_params *fr_ps; {f    int i, j, k, s, n, qnt, sig;f    int stereo  = fr_ps->stereo;c     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    unsigned int stps;i    double d;"    al_table *alloc = fr_ps->alloc;      for (s=0;s<3;s++)       for (j=0;j<SCALE_BLOCK;j++)        for (i=0;i<sblimit;i++)/          for (k=0;k<((i<jsbound)?stereo:1);k++)=!            if (bit_alloc[k][i]) {e;              /* scale and quantize floating point sample */)K              if(stereo == 2 && i>=jsbound)       /* use j-stereo samples */ >                d = j_samps[s][j][i] / multiple[j_scale[s][i]];              elserF                d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];              if (mod(d) > 1.0)C                printf("Not scaled properly %d %d %d %d\n",k,s,j,i);s6              qnt = (*alloc)[i][bit_alloc[k][i]].quant;%              d = d * a[qnt] + b[qnt]; F              /* extract MSB N-1 bits from the floating point sample */!              if (d >= 0) sig = 1;i(              else { sig = 0; d += 1.0; }              n = 0;h #ifndef MS_DOS7              stps = (*alloc)[i][bit_alloc[k][i]].steps;](              while ((1L<<n) < stps) n++; #elsem6              while  ( ( (unsigned long)(1L<<(long)n) <L                        ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)                          & 0xffff                         )($                        ) && ( n <16)                      ) n++;  #endif              n--;[H              sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));D              /* tag the inverted sign bit to sbband at position N */I              /* The bit inversion is a must for grouping with 3,5,9 steps;1                 so it is done for all subbands */s1              if (sig) sbband[k][s][j][i] |= 1<<n;a            }            for (s=0;s<3;s++)*              for (j=sblimit;j<SBLIMIT;j++)Y                for (i=0;i<SCALE_BLOCK;i++) for (k=0;k<stereo;k++) sbband[k][s][i][j] = 0;s }e   I /************************************************************************h /*  /* I_encode_bit_alloc  (Layer I)! /* II_encode_bit_alloc (Layer II)t /*; /* PURPOSE:Writes bit allocation information onto bitstream  /*> /* Layer I uses 4 bits/subband for bit allocation information,6 /* and Layer II uses 4,3,2, or 0 bits depending on the /* quantization table used.  /*J /************************************************************************/   - void I_encode_bit_alloc(bit_alloc, fr_ps, bs)_# unsigned int bit_alloc[2][SBLIMIT];* frame_params *fr_ps; Bit_stream_struc *bs;m {c    int i,k;     int stereo  = fr_ps->stereo;r     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;       for (i=0;i<SBLIMIT;i++)J      for (k=0;k<((i<jsbound)?stereo:1);k++) putbits(bs,bit_alloc[k][i],4); }_   J /***************************** Layer II  ********************************/   . void II_encode_bit_alloc(bit_alloc, fr_ps, bs)# unsigned int bit_alloc[2][SBLIMIT];i frame_params *fr_ps; Bit_stream_struc *bs;i {b    int i,k;[    int stereo  = fr_ps->stereo;t     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;       for (i=0;i<sblimit;i++)+      for (k=0;k<((i<jsbound)?stereo:1);k++) 7        putbits(bs,bit_alloc[k][i],(*alloc)[i][0].bits);n }    I /************************************************************************  /*  /* I_sample_encoding   (Layer I)! /* II_sample_encoding  (Layer II)[ /*? /* PURPOSE:Put one frame of subband samples on to the bitstreamt /*C /* SEMANTICS:  The number of bits allocated per sample is read from+7 /* the bit allocation information #bit_alloc#.  Layer 2 : /* supports writing grouped samples for quantization steps /* that are not a power of 2.  /*J /************************************************************************/  *4 void I_sample_encoding(sbband, bit_alloc, fr_ps, bs)4 unsigned int FAR sbband[2][3][SCALE_BLOCK][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT];t frame_params *fr_ps; Bit_stream_struc *bs;S {S
    int i,j,k;a    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;  e    for(j=0;j<SCALE_BLOCK;j++) {x      for(i=0;i<SBLIMIT;i++)n,        for(k=0;k<((i<jsbound)?stereo:1);k++)N          if(bit_alloc[k][i]) putbits(bs,sbband[k][0][j][i],bit_alloc[k][i]+1);    } }*  *J /***************************** Layer II  ********************************/  t5 void II_sample_encoding(sbband, bit_alloc, fr_ps, bs)*4 unsigned int FAR sbband[2][3][SCALE_BLOCK][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT];[ frame_params *fr_ps; Bit_stream_struc *bs;0 {,    unsigned int temp;0    unsigned int i,j,k,s,x,y;    int stereo  = fr_ps->stereo;0     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;       for (s=0;s<3;s++)!      for (j=0;j<SCALE_BLOCK;j+=3)0        for (i=0;i<sblimit;i++)/          for (k=0;k<((i<jsbound)?stereo:1);k++)7!            if (bit_alloc[k][i]) {);              if ((*alloc)[i][bit_alloc[k][i]].group == 3) {0A                for (x=0;x<3;x++) putbits(bs,sbband[k][s][j+x][i],qL                                          (*alloc)[i][bit_alloc[k][i]].bits);              }              else {d5                y =(*alloc)[i][bit_alloc[k][i]].steps;3*                temp = sbband[k][s][j][i] +0                       sbband[k][s][j+1][i] * y +3                       sbband[k][s][j+2][i] * y * y;nB                putbits(bs,temp,(*alloc)[i][bit_alloc[k][i]].bits);              }            } }r  ;I /************************************************************************l /*
 /* encode_CRCi /*J /************************************************************************/    void encode_CRC(crc, bs) unsigned int crc;  Bit_stream_struc *bs;r {p    putbits(bs, crc, 16); } 