G /********************************************************************** L Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved common.cG **********************************************************************/ G /********************************************************************** G  * MPEG/audio coding/decoding software, work in progress              * G  *   NOT for public distribution until verified and approved by the   * G  *   MPEG/audio committee.  For further information, please contact   * G  *   Davis Pan, 508-493-2241, e-mail: pan@3d.enet.dec.com             * G  *                                                                    * G  * VERSION 4.0                                                        * G  *   changes made since last update:                                  * G  *   date   programmers         comment                               * G  * 2/25/91  Doulas Wong,        start of version 1.0 records          * G  *          Davis Pan                                                 * G  * 5/10/91  W. Joseph Carter    Created this file for all common      * G  *                              functions and global variables.       * G  *                              Ported to Macintosh and Unix.         * G  *                              Added Jean-Georges Fritsch's          * G  *                              "bitstream.c" package.                * G  *                              Added routines to handle AIFF PCM     * G  *                              sound files.                          * G  *                              Added "mem_alloc()" and "mem_free()"  * G  *                              routines for memory allocation        * G  *                              portability.                          * G  *                              Added routines to convert between     * G  *                              Apple SANE extended floating point    * G  *                              format and IEEE double precision      * G  *                              floating point format.  For AIFF.     * G  * 02jul91 dpwe (Aware Inc)     Moved allocation table input here;    * G  *                              Tables read from subdir TABLES_PATH.  * G  *                              Added some debug printout fns (Write*)* G  * 7/10/91 Earle Jennings       replacement of the one float by FLOAT * G  *                              port to MsDos from MacIntosh version  * G  * 8/ 5/91 Jean-Georges Fritsch fixed bug in open_bit_stream_r()      * G  *10/ 1/91 S.I. Sudharsanan,    Ported to IBM AIX platform.           * G  *         Don H. Lee,                                                * G  *         Peter W. Farrett                                           * G  *10/3/91  Don H. Lee           implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              I_CRC_calc, II_CRC_calc and           * G  *                              update_CRC. Additions and revisions   * G  *                              are marked with dhl for clarity       * G  *10/18/91 Jean-Georges Fritsch fixed bug in update_CRC(),            * G  *                              II_CRC_calc() and I_CRC_calc()        * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 3/20/92 Jean-Georges Fritsch  fixed bug in start-of-frame search   * G  * 6/15/92 Juan Pineda          added refill_buffer(bs) "n"           * G  *                              initialization                        * G  * 7/08/92 Susanne Ritscher     MS-DOS, MSC6.0 port fixes             * G  * 7/27/92 Mike Li               (re-)Port to MS-DOS                  * G  * 8/19/92 Soren H. Nielsen     Fixed bug in I_CRC_calc and in        * G  *                              II_CRC_calc.  Added function: new_ext * G  *                              for better MS-DOS compatability       * G  * 3/10/93 Kevin Peterson       changed aiff_read_headers to handle   * G  *                              chunks in any order.  now returns     * G  *                              position of sound data in file.       * G  * 3/31/93 Jens Spille          changed IFF_* string compares to use  * G  *                              strcmp()                              * C  * 5/30/93 Masahiro Iwadare	?? the previous modification does not * -  *				  work. recovered to the original. ?? * G  * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        * G  *         Daniel Lauzon, and                                         * G  *         Bill Truerniet                                             * H  **********************************************************************/  H /*********************************************************************** *  *  Global Include Files  * H ***********************************************************************/   #include        "common.h"   #ifdef  MACINTOSH    #include        <SANE.h> #include        <pascal.h>   #endif   #include <ctype.h>  H /*********************************************************************** *  *  Global Variable Definitions * H ***********************************************************************/  G char *mode_names[4] = { "stereo", "j-stereo", "dual-ch", "single-ch" }; , char *layer_names[3] = { "I", "II", "III" };  & double  s_freq[4] = {44.1, 48, 32, 0};   int     bitrate[3][15] = {C           {0,32,64,96,128,160,192,224,256,288,320,352,384,416,448}, @           {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384},>           {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}
         };   double FAR multiple[64] = { 5 2.00000000000000, 1.58740105196820, 1.25992104989487, G 1.00000000000000, 0.79370052598410, 0.62996052494744, 0.50000000000000, G 0.39685026299205, 0.31498026247372, 0.25000000000000, 0.19842513149602, G 0.15749013123686, 0.12500000000000, 0.09921256574801, 0.07874506561843, G 0.06250000000000, 0.04960628287401, 0.03937253280921, 0.03125000000000, G 0.02480314143700, 0.01968626640461, 0.01562500000000, 0.01240157071850, G 0.00984313320230, 0.00781250000000, 0.00620078535925, 0.00492156660115, G 0.00390625000000, 0.00310039267963, 0.00246078330058, 0.00195312500000, G 0.00155019633981, 0.00123039165029, 0.00097656250000, 0.00077509816991, G 0.00061519582514, 0.00048828125000, 0.00038754908495, 0.00030759791257, G 0.00024414062500, 0.00019377454248, 0.00015379895629, 0.00012207031250, G 0.00009688727124, 0.00007689947814, 0.00006103515625, 0.00004844363562, G 0.00003844973907, 0.00003051757813, 0.00002422181781, 0.00001922486954, G 0.00001525878906, 0.00001211090890, 0.00000961243477, 0.00000762939453, G 0.00000605545445, 0.00000480621738, 0.00000381469727, 0.00000302772723, G 0.00000240310869, 0.00000190734863, 0.00000151386361, 0.00000120155435,  1E-20  };  H /*********************************************************************** *  *  Global Function Definitions * H ***********************************************************************/  E /* The system uses a variety of data files.  By opening them via this 5    function, we can accommodate various locations. */    FILE *OpenTableFile(name)  char *name;  {  char fulname[80]; 
 char *envdir;  FILE *f;        fulname[0] = '\0';    #ifdef TABLES_PATHM        strcpy(fulname, TABLES_PATH);   /* default relative path for tables */ I #endif /* TABLES_PATH */          /* (includes terminal path seperator */   F #ifdef UNIX                       /* envir. variables for UNIX only */        {         char *getenv();   B         envdir = getenv(MPEGTABENV);   /* check for environment */         if(envdir != NULL)$             strcpy(fulname, envdir);D         strcat(fulname, PATH_SEPARATOR);  /* add a "/" on the end */       }  #endif /* UNIX */   
 #ifdef VMS        {         char *getenv();   B         envdir = getenv(MPEGTABENV);   /* check for environment */         if(envdir != NULL)$             strcpy(fulname, envdir);       }  #endif       strcat(fulname, name);(     if( (f=fopen(fulname,"r"))==NULL ) {B         fprintf(stderr,"OpenTable: could not find %s\n", fulname);   #ifdef UNIX            if(envdir != NULL)K             fprintf(stderr,"Check %s directory '%s'\n",MPEGTABENV, envdir);            elseI             fprintf(stderr,"Check local directory './%s' or setenv %s\n", -                     TABLES_PATH, MPEGTABENV); / #else /* not unix : no environment variables */      #ifdef TABLES_PATHI             fprintf(stderr,"Check local directory './%s'\n",TABLES_PATH);  #endif /* TABLES_PATH */   #endif /* UNIX */        } 
     return f;  }   H /*********************************************************************** /*H /* Read one of the data files ("alloc_*") specifying the bit allocation/? /* quatization parameters for each subband in layer II encoding  /*H /**********************************************************************/  N int read_bit_alloc(table, alloc)        /* read in table, return # subbands */
 int table; al_table *alloc; { &         unsigned int a, b, c, d, i, j;         FILE *fp;          char name[16], t[80];          int sblim;            strcpy(name, "alloc_0");           switch (table) {6                 case 0 : name[6] = '0';         break;6                 case 1 : name[6] = '1';         break;6                 case 2 : name[6] = '2';         break;6                 case 3 : name[6] = '3';         break;(                 default : name[6] = '0';	         }   *         if (!(fp = OpenTableFile(name))) {G                 printf("Please check bit allocation table %s\n", name);                  exit(1);	         }   8         printf("using bit allocation table %s\n", name);           fgets(t, 80, fp); "         sscanf(t, "%d\n", &sblim);         while (!feof(fp)) { !                 fgets(t, 80, fp); I                 sscanf(t, "%d %d %d %d %d %d\n", &i, &j, &a, &b, &c, &d); 1                         (*alloc)[i][j].steps = a; 1                         (*alloc)[i][j].bits  = b; 1                         (*alloc)[i][j].group = c; 1                         (*alloc)[i][j].quant = d; 	         }          fclose(fp);          return sblim;  }   H /*********************************************************************** /*C /* Using the decoded info the appropriate possible quantization per  /* subband table is loaded /*H /**********************************************************************/  I int pick_table(fr_ps)   /* choose table, load if necess, return # sb's */  frame_params *fr_ps; { 1         int table, lay, ws, bsp, br_per_ch, sfrq; M         int sblim = fr_ps->sblimit;     /* return current value if no load */   %         lay = fr_ps->header->lay - 1; +         bsp = fr_ps->header->bitrate_index; 6         br_per_ch = bitrate[lay][bsp] / fr_ps->stereo;/         ws = fr_ps->header->sampling_frequency;          sfrq = s_freq[ws];K         /* decision rules refer to per-channel bitrates (kbits/sec/chan) */ .         if ((sfrq == 48 && br_per_ch >= 56) ||<             (br_per_ch >= 56 && br_per_ch <= 80)) table = 0;:         else if (sfrq != 48 && br_per_ch >= 96) table = 1;:         else if (sfrq != 32 && br_per_ch <= 48) table = 2;         else table = 3; &         if (fr_ps->tab_num != table) {#            if (fr_ps->tab_num >= 0) 1               mem_free((void **)&(fr_ps->alloc)); F            fr_ps->alloc = (al_table FAR *) mem_alloc(sizeof(al_table),B                                                          "alloc");H            sblim = read_bit_alloc(fr_ps->tab_num = table, fr_ps->alloc);	         }          return sblim;  }    int js_bound(lay, m_ext) int lay, m_ext;  { B static int jsb_table[3][4] =  { { 4, 8, 12, 16 }, { 4, 8, 12, 16},K                                 { 0, 4, 8, 16} };  /* lay+m_e -> jsbound */   /     if(lay<1 || lay >3 || m_ext<0 || m_ext>3) { K         fprintf(stderr, "js_bound bad layer/modext (%d/%d)\n", lay, m_ext);          exit(1);     } $     return(jsb_table[lay-1][m_ext]); }   J void hdr_to_frps(fr_ps) /* interpret data in hdr str to fields in fr_ps */ frame_params *fr_ps; { : layer *hdr = fr_ps->header;     /* (or pass in as arg?) */  #     fr_ps->actual_mode = hdr->mode; 7     fr_ps->stereo = (hdr->mode == MPG_MD_MONO) ? 1 : 2; C     if (hdr->lay == 2)          fr_ps->sblimit = pick_table(fr_ps); 9     else                        fr_ps->sblimit = SBLIMIT; (     if(hdr->mode == MPG_MD_JOINT_STEREO);         fr_ps->jsbound = js_bound(hdr->lay, hdr->mode_ext);      else(         fr_ps->jsbound = fr_ps->sblimit;*     /* alloc, tab_num set in pick_table */ }    void WriteHdr(fr_ps, s)  frame_params *fr_ps; FILE *s; {  layer *info = fr_ps->header;  G    fprintf(s, "HDR:  s=FFF, id=%X, l=%X, ep=%X, br=%X, sf=%X, pd=%X, ", =            info->version, info->lay, !info->error_protection, I            info->bitrate_index, info->sampling_frequency, info->padding); 7    fprintf(s, "pr=%X, m=%X, js=%X, c=%X, o=%X, e=%X\n", 7            info->extension, info->mode, info->mode_ext, <            info->copyright, info->original, info->emphasis);?    fprintf(s, "layer=%s, tot bitrate=%d, sfrq=%.1f, mode=%s, ", O            layer_names[info->lay-1], bitrate[info->lay-1][info->bitrate_index], E            s_freq[info->sampling_frequency], mode_names[info->mode]); +    fprintf(s, "sblim=%d, jsbd=%d, ch=%d\n", :            fr_ps->sblimit, fr_ps->jsbound, fr_ps->stereo);
    fflush(s);  }   % void WriteBitAlloc(bit_alloc, f_p, s) # unsigned int bit_alloc[2][SBLIMIT];  frame_params *f_p; FILE *s; {  int i,j; int st = f_p->stereo;  int sbl = f_p->sblimit;  int jsb = f_p->jsbound;        fprintf(s, "BITA ");     for(i=0; i<sbl; ++i) {$         if(i == jsb) fprintf(s,"-");         for(j=0; j<st; ++j) /             fprintf(s, "%1x", bit_alloc[j][i]);      } "     fprintf(s, "\n");   fflush(s); }   3 void WriteScale(bit_alloc, scfsi, scalar, fr_ps, s) M unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT], scalar[2][3][SBLIMIT];  frame_params *fr_ps; FILE *s; {  int stereo  = fr_ps->stereo; int sblimit = fr_ps->sblimit; ! int lay     = fr_ps->header->lay; 
 int i,j,k;           if(lay == 2) {              fprintf(s, "SFSI ");:             for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++)B                 if (bit_alloc[k][i])  fprintf(s,"%d",scfsi[k][i]);"             fprintf(s, "\nSCFs ");$             for (k=0;k<stereo;k++) {'                 for (i=0;i<sblimit;i++) (                     if (bit_alloc[k][i]).                         switch (scfsi[k][i]) {3                           case 0: for (j=0;j<3;j++) D                                   fprintf(s,"%2d%c",scalar[k][j][i],:                                           (j==2)?';':'-');(                                   break;!                           case 1: D                           case 3: fprintf(s,"%2d-",scalar[k][0][i]);D                                   fprintf(s,"%2d;",scalar[k][2][i]);(                                   break;D                           case 2: fprintf(s,"%2d;",scalar[k][0][i]);                         } !                 fprintf(s, "\n"); 
             } 	         }          else{   /* lay == 1 */              fprintf(s, "SCFs ");:             for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++)H                 if (bit_alloc[k][i])  fprintf(s,"%2d;",scalar[k][0][i]);             fprintf(s, "\n"); 	         }  }   2 void WriteSamples(ch, sample, bit_alloc, fr_ps, s) int ch; ! unsigned int FAR sample[SBLIMIT];   unsigned int bit_alloc[SBLIMIT]; frame_params *fr_ps; FILE *s; {  int i; int stereo = fr_ps->stereo;  int sblimit = fr_ps->sblimit;            fprintf(s, "SMPL ");         for (i=0;i<sblimit;i++) '                 if ( bit_alloc[i] != 0) 1                     fprintf(s, "%d:", sample[i]); 1         if(ch==(stereo-1) )     fprintf(s, "\n"); 1         else                    fprintf(s, "\t");l }e  C int NumericQ(s) /* see if a string lookd like a numeric argument */X char *s; {f
 char    c;  F     while( (c = *s++)!='\0' && isspace((int)c)) /* strip leading ws */	         ;n     if( c == '+' || c == '-' )A         c = *s++;               /* perhaps skip leading + or - */      return isdigit((int)c);  }f  F int BitrateIndex(layr, bRate)   /* convert bitrate in kbps to index */$ int     layr;           /* 1 or 2 */8 int     bRate;          /* legal rates from 32 to 448 */ {e int     index = 0; int     found = 0;  !     while(!found && index<15)   { +         if(bitrate[layr-1][index] == bRate)%             found = 1;         else             ++index;     } 
     if(found)u         return(index);
     else {O         fprintf(stderr, "BitrateIndex: %d (layer %d) is not a legal bitrate\n",n                 bRate, layr);L$         return(-1);     /* Error! */     }  }e  = int SmpFrqIndex(sRate)  /* convert samp frq in Hz to index */*= long sRate;             /* legal rates 32000, 44100, 48000 */o {"     if(sRate == 44100L)c         return(0);     else if(sRate == 48000L)         return(1);     else if(sRate == 32000L)         return(2);
     else {P         fprintf(stderr, "SmpFrqIndex: %ld is not a legal sample rate\n", sRate);%         return(-1);      /* Error! */e     }; }   P /******************************************************************************* *87 *  Allocate number of bytes of memory equal to "block"." * P *******************************************************************************/  ! void  FAR *mem_alloc(block, item)' unsigned long   block; char            *item; {]       void    *ptr;;   #ifdef  MACINTOSHe     ptr = NewPtr(block); #endif   #ifdef MSC60W     /*ptr = (void FAR *) _fmalloc((unsigned int)block);*/ /* far memory, 92-07-08 sr */ Q     ptr = (void FAR *) malloc((unsigned int)block); /* far memory, 93-08-24 ss */  #endif  . #if ! defined (MACINTOSH) && ! defined (MSC60)%     ptr = (void FAR *) malloc(block);t #endif       if (ptr != NULL){ 
 #ifdef  MSC60;L         _fmemset(ptr, 0, (unsigned int)block); /* far memory, 92-07-08 sr */ #elses         memset(ptr, 0, block); #endif     }&	     else{ 0         printf("Unable to allocate %s\n", item);         exit(0);     }*     return(ptr); }b    M /****************************************************************************l *)) *  Free memory pointed to by "*ptr_addr".o *fN *****************************************************************************/   void    mem_free(ptr_addr) void    **ptr_addr;d {i       if (*ptr_addr != NULL){a #ifdef  MACINTOSHs         DisposPtr(*ptr_addr);* #else*         free(*ptr_addr); #endif         *ptr_addr = NULL;      }i   }b  P /******************************************************************************* * F *  Check block of memory all equal to a single byte, else return FALSE *rP *******************************************************************************/   int memcheck(array, test, num) char *array;? int test;       /* but only tested as a char (bottom 8 bits) */e int num; { 	  int i=0;>  )    while (array[i] == test && i<num) i++;s    if (i==num) return TRUE;o    else return FALSE;a }l  M /****************************************************************************  * L *  Routines to convert between the Apple SANE extended floating point formatK *  and the IEEE double precision floating point format.  These routines arehH *  called from within the Audio Interchange File Format (AIFF) routines. *aN *****************************************************************************/   /*: *** Apple's 80-bit SANE extended has the following format:     1       15      1            631 +-+-------------+-+-----------------------------+"1 |s|       e     |i|            f                |m1 +-+-------------+-+-----------------------------+n0   msb        lsb   msb                       lsb  C The value v of the number is determined by these fields as follows: F If 0 <= e < 32767,              then v = (-1)^s * 2^(e-16383) * (i.f).N If e == 32767 and f == 0,       then v = (-1)^s * (infinity), regardless of i.A If e == 32767 and f != 0,       then v is a NaN, regardless of i.   F *** IEEE Draft Standard 754 Double Precision has the following format:   MSBr+ +-+---------+-----------------------------+l+ |1| 11 Bits |           52 Bits           |e+ +-+---------+-----------------------------+   ^     ^                ^a  |     |                |r   Sign  Exponent         Mantissa */  N /***************************************************************************** *  *  double_to_extended()  * J *  Purpose:     Convert from IEEE double precision format to SANE extended *               format.n *dL *  Passed:      Pointer to the double precision number and a pointer to what? *               will hold the Apple SANE extended format value.r *,H *  Outputs:     The SANE extended format pointer will be filled with the  *               converted value. *% *  Returned:    Nothing. *,N *****************************************************************************/  " void    double_to_extended(pd, ps) double  *pd; char    ps[10];f {n   #ifdef  MACINTOSHs  &         x96tox80(pd, (extended *) ps);   #elsei  ! register unsigned long  top2bits;    register unsigned short *ps2;g register IEEE_DBL       *p_dbl;f register SANE_EXT       *p_ext;r  .    p_dbl = (IEEE_DBL *) pd;l    p_ext = (SANE_EXT *) ps;a%    top2bits = p_dbl->hi & 0xc0000000; 9    p_ext->l1 = ((p_dbl->hi >> 4) & 0x3ff0000) | top2bits;o5    p_ext->l1 |= ((p_dbl->hi >> 5) & 0x7fff) | 0x8000; .    p_ext->l2 = (p_dbl->hi << 27) & 0xf8000000;0    p_ext->l2 |= ((p_dbl->lo >> 5) & 0x07ffffff);*    ps2 = (unsigned short *) & (p_dbl->lo);	    ps2++;I%    p_ext->s1 = (*ps2 << 11) & 0xf800;    #endif   }   N /***************************************************************************** *( *  extended_to_double(); *sJ *  Purpose:     Convert from SANE extended format to IEEE double precision *               format., *1M *  Passed:      Pointer to the Apple SANE extended format value and a pointerWG *               to what will hold the the IEEE double precision number.[ *IL *  Outputs:     The IEEE double precision format pointer will be filled with$ *               the converted value. *  *  Returned:    Nothing. *nN *****************************************************************************/  " void    extended_to_double(ps, pd) char    ps[10];t double  *pd; {s   #ifdef  MACINTOSH   !    x80tox96((extended *) ps, pd);,   #elsei  ! register unsigned long  top2bits;C   register IEEE_DBL       *p_dbl;e register SANE_EXT       *p_ext;0      p_dbl = (IEEE_DBL *) pd;     p_ext = (SANE_EXT *) ps; %    top2bits = p_ext->l1 & 0xc0000000;i:    p_dbl->hi = ((p_ext->l1 << 4) & 0x3ff00000) | top2bits;+    p_dbl->hi |= (p_ext->l1 << 5) & 0xffff0;%)    p_dbl->hi |= (p_ext->l2 >> 27) & 0x1f; -    p_dbl->lo = (p_ext->l2 << 5) & 0xffffffe0; ;    p_dbl->lo |= (unsigned long) ((p_ext->s1 >> 11) & 0x1f);a   #endif   }      /****  for debugging p
 showchar(str)s char str[4]; {  int i;& for (i=0;i<4;i++) printf("%c",str[i]);
 printf("\n");[ }; ****/   N /***************************************************************************** *"5 *  Read Audio Interchange File Format (AIFF) headers.  * N *****************************************************************************/  5 int             aiff_read_headers(file_ptr, aiff_ptr)0 FILE            *file_ptr; IFF_AIFF        *aiff_ptr; {(   register char   i; register long   seek_offset; register long   sound_position;   $ char            temp_sampleRate[10];   ChunkHeader     Header;) Chunk           FormChunk; CommonChunk     CommChunk; SoundDataChunk  SndDChunk;  )    if (fseek(file_ptr, 0, SEEK_SET) != 0)        return(-1);r  :    if (fread(&FormChunk, sizeof(Chunk), 1, file_ptr) != 1)       return(-1);    #ifdef IFF_LONG :    if (*(unsigned long *) FormChunk.ckID != IFF_ID_FORM ||<        *(unsigned long *) FormChunk.formType != IFF_ID_AIFF)       return(-1);y #elsec  /    if (strncmp(FormChunk.ckID,IFF_ID_FORM,4) ||g1        strncmp(FormChunk.formType,IFF_ID_AIFF,4))*       return(-1);* #endif      /**0     * chunks need not be in any particular order     */  B    while (fread(&Header, sizeof(ChunkHeader), 1, file_ptr) == 1) {   #ifdef IFF_LONG   9       if (*(unsigned long *)Header.ckID == IFF_ID_COMM) {p   #else 4       if (strncmp(Header.ckID,IFF_ID_COMM,4) == 0) { #endif   	 /* 	  * read comm chunk 	  */ L          if (fread(&CommChunk.numChannels, sizeof(short), 1, file_ptr) != 1)             return(-1);   H          if (fread(&CommChunk.numSampleFrames, sizeof(unsigned long), 1,"                    file_ptr) != 1)             return(-1);:  K          if (fread(&CommChunk.sampleSize, sizeof(short), 1, file_ptr) != 1)              return(-1);   M          if (fread(CommChunk.sampleRate, sizeof(char[10]), 1, file_ptr) != 1)*             return(-1);   /          for (i = 0; i < sizeof(char[10]); i++)19             temp_sampleRate[i] = CommChunk.sampleRate[i];   D          extended_to_double(temp_sampleRate, &aiff_ptr->sampleRate);  0 	 aiff_ptr->numChannels = CommChunk.numChannels;8 	 aiff_ptr->numSampleFrames = CommChunk.numSampleFrames;. 	 aiff_ptr->sampleSize = CommChunk.sampleSize;   #ifdef IFF_LONG A       } else if (*(unsigned long *)Header.ckID == IFF_ID_SSND) {   #else ;       } else if (strncmp(Header.ckID,IFF_ID_SSND,4) == 0) {  #endif 	 /* 	  * read ssnd chunk 	  */ ? 	 if (fread(&SndDChunk.offset, sizeof(long), 1, file_ptr) != 1)l 	    return(-1);  B 	 if (fread(&SndDChunk.blockSize, sizeof(long), 1, file_ptr) != 1) 	    return(-1);  . 	 aiff_ptr->blkAlgn.offset = SndDChunk.offset;4 	 aiff_ptr->blkAlgn.blockSize = SndDChunk.blockSize;7 	 aiff_ptr->sampleType = *(unsigned long *)Header.ckID;  	  	 /*" 	  * record position of sound data 	  */   # 	 sound_position = ftell(file_ptr);t   	 /*5 	  * skip over sound data to look at remaining chunks  	  */a  ?          seek_offset = Header.ckSize - sizeof(SoundDataChunk) +               sizeof(ChunkHeader);  9          if (fseek(file_ptr, seek_offset, SEEK_CUR) != 0)b             return(-1);          } else {   	 /* 	  * skip unknown chunku 	  */W   	 seek_offset = Header.ckSize;  9          if (fseek(file_ptr, seek_offset, SEEK_CUR) != 0)              return(-1);t         }m      }      return(sound_position);   }r  N /***************************************************************************** * M *  Seek past some Audio Interchange File Format (AIFF) headers to sound data.  * N *****************************************************************************/  ' int   aiff_seek_to_sound_data(file_ptr)  FILE  *file_ptr; {n  N    if (fseek(file_ptr, sizeof(Chunk) + sizeof(SoundDataChunk), SEEK_SET) != 0)       return(-1);   
    return(0);    }   P /******************************************************************************* * 6 *  Write Audio Interchange File Format (AIFF) headers. * P *******************************************************************************/  6 int             aiff_write_headers(file_ptr, aiff_ptr) FILE            *file_ptr; IFF_AIFF        *aiff_ptr; {    register char   i; register long   seek_offset;  $ char            temp_sampleRate[10];   Chunk           FormChunk; CommonChunk     CommChunk; SoundDataChunk  SndDChunk;   #ifdef IFF_LONG 7    *(unsigned long *) FormChunk.ckID     = IFF_ID_FORM; 7    *(unsigned long *) FormChunk.formType = IFF_ID_AIFF; 7    *(unsigned long *) CommChunk.ckID     = IFF_ID_COMM;  #else )    strncpy(FormChunk.ckID,IFF_ID_FORM,4);i-    strncpy(FormChunk.formType,IFF_ID_AIFF,4); )    strncpy(CommChunk.ckID,IFF_ID_COMM,4);  #endif  >    double_to_extended(&aiff_ptr->sampleRate, temp_sampleRate);  )    for (i = 0; i < sizeof(char[10]); i++)a3       CommChunk.sampleRate[i] = temp_sampleRate[i];r  =    CommChunk.numChannels             = aiff_ptr->numChannels;JA    CommChunk.numSampleFrames         = aiff_ptr->numSampleFrames; <    CommChunk.sampleSize              = aiff_ptr->sampleSize;@    SndDChunk.offset                  = aiff_ptr->blkAlgn.offset;C    SndDChunk.blockSize               = aiff_ptr->blkAlgn.blockSize; <    *(unsigned long *) SndDChunk.ckID = aiff_ptr->sampleType;  5    CommChunk.ckSize = sizeof(CommChunk.numChannels) + H       sizeof(CommChunk.numSampleFrames) + sizeof(CommChunk.sampleSize) +#       sizeof(CommChunk.sampleRate);   D    SndDChunk.ckSize = sizeof(SoundDataChunk) - sizeof(ChunkHeader) +D       (CommChunk.sampleSize + BITS_IN_A_BYTE - 1) / BITS_IN_A_BYTE *8       CommChunk.numChannels * CommChunk.numSampleFrames;  N    FormChunk.ckSize = sizeof(Chunk) + SndDChunk.ckSize + sizeof(ChunkHeader) +       CommChunk.ckSize;   )    if (fseek(file_ptr, 0, SEEK_SET) != 0)        return(-1);   ;    if (fwrite(&FormChunk, sizeof(Chunk), 1, file_ptr) != 1)e       return(-1);o  D    if (fwrite(&SndDChunk, sizeof(SoundDataChunk), 1, file_ptr) != 1)       return(-1);O  <    seek_offset = SndDChunk.ckSize - sizeof(SoundDataChunk) +       sizeof(ChunkHeader);  3    if (fseek(file_ptr, seek_offset, SEEK_CUR) != 0)        return(-1);   <    if (fwrite(CommChunk.ckID, sizeof(ID), 1, file_ptr) != 1)       return(-1);*  A    if (fwrite(&CommChunk.ckSize, sizeof(long), 1, file_ptr) != 1)        return(-1);i  G    if (fwrite(&CommChunk.numChannels, sizeof(short), 1, file_ptr) != 1)*       return(-1);   C    if (fwrite(&CommChunk.numSampleFrames, sizeof(unsigned long), 1,c               file_ptr) != 1)f       return(-1);.  F    if (fwrite(&CommChunk.sampleSize, sizeof(short), 1, file_ptr) != 1)       return(-1);   H    if (fwrite(CommChunk.sampleRate, sizeof(char[10]), 1, file_ptr) != 1)       return(-1);*  
    return(0);n   }4  N /***************************************************************************** *  *  bit_stream.c package 5 *  Author:  Jean-Georges Fritsch, C-Cube Microsystems] *{N *****************************************************************************/  E /********************************************************************,>   This package provides functions to write (exclusive or read)4   information from (exclusive or to) the bit stream.  E   If the bit stream is opened in read mode only the get functions are0C   available. If the bit stream is opened in write mode only the put5   functions are available.E ********************************************************************/6  L /*open_bit_stream_w(); open the device to write the bit stream into it    */L /*open_bit_stream_r(); open the device to read the bit stream from it     */L /*close_bit_stream();  close the device containing the bit stream         */L /*alloc_buffer();      open and initialize the buffer;                    */L /*desalloc_buffer();   empty and close the buffer                         */L /*back_track_buffer();     goes back N bits in the buffer                 */L /*unsigned int get1bit();  read 1 bit from the bit stream                 */L /*unsigned long getbits(); read N bits from the bit stream                */N /*unsigned long byte_ali_getbits();   read the next byte aligned N bits from*/N /*                                    the bit stream                        */N /*unsigned long look_ahead(); grep the next N bits in the bit stream without*/N /*                            changing the buffer pointer                   */0 /*put1bit(); write 1 bit from the bit stream  */0 /*put1bit(); write 1 bit from the bit stream  */0 /*putbits(); write N bits from the bit stream */N /*byte_ali_putbits(); write byte aligned the next N bits into the bit stream*/N /*unsigned long sstell(); return the current bit stream length (in bits)    */N /*int end_bs(); return 1 if the end of bit stream reached otherwise 0       */N /*int seek_sync(); return 1 if a sync word was found in the bit stream      */N /*                 otherwise returns 0                                      */  N /* refill the buffer from the input device when the buffer becomes empty    */ int refill_buffer(bs) 2 Bit_stream_struc *bs;   /* bit stream structure */ { 2    register int i=bs->buf_size-2-bs->buf_byte_idx;    register unsigned long n=1;    register int index=0;    char val[2];"  !    while ((i>=0) && (!bs->eob)) {i         if (bs->format == BINARY)uD          n = fread(&bs->buf[i--], sizeof(unsigned char), 1, bs->pt);         else {"          while((index < 2) && n) {<             n = fread(&val[index], sizeof(char), 1, bs->pt);!             switch (val[index]) {                    case 0x30:                   case 0x31:                   case 0x32:                   case 0x33:                   case 0x34:                   case 0x35:                   case 0x36:                   case 0x37:                   case 0x38:                   case 0x39:                   case 0x41:                   case 0x42:                   case 0x43:                   case 0x44:                   case 0x45:                   case 0x46:                   index++;                   break;!                   default: break; 
             })
          }  A          if (val[0] <= 0x39)   bs->buf[i] = (val[0] - 0x30) << 4;H9                  else  bs->buf[i] = (val[0] - 0x37) << 4;0?          if (val[1] <= 0x39)   bs->buf[i--] |= (val[1] - 0x30);07                  else  bs->buf[i--] |= (val[1] - 0x37);           index = 0;0       }          if (!n) {l          bs->eob= i+1;       }p       }  }   % static char *he = "0123456789ABCDEF";   H /* empty the buffer to the output device when the buffer becomes full */ void empty_buffer(bs, minimum)2 Bit_stream_struc *bs;   /* bit stream structure */8 int minimum;            /* end of the buffer to empty */ {*    register int i;   #if BS_FORMAT == BINARY*(    for (i=bs->buf_size-1;i>=minimum;i--)<       fwrite(&bs->buf[i], sizeof(unsigned char), 1, bs->pt); #elsed*    for (i=bs->buf_size-1;i>=minimum;i--) {        char val[2];f/        val[0] = he[((bs->buf[i] >> 4) & 0x0F)];o(        val[1] = he[(bs->buf[i] & 0x0F)];,        fwrite(val, sizeof(char), 2, bs->pt);    } #endif      for (i=minimum-1; i>=0; i--)*8        bs->buf[bs->buf_size - minimum + i] = bs->buf[i];  0    bs->buf_byte_idx = bs->buf_size -1 - minimum;    bs->buf_bit_idx = 8;  }d  5 /* open the device to write the bit stream into it */;, void open_bit_stream_w(bs, bs_filenam, size)2 Bit_stream_struc *bs;   /* bit stream structure */9 char *bs_filenam;       /* name of the bit stream file */ 0 int size;               /* size of the buffer */ {*4    if ((bs->pt = fopen(bs_filenam, "wb")) == NULL) {7       printf("Could not create \"%s\".\n", bs_filenam);d       exit(1);    }    alloc_buffer(bs, size);    bs->buf_byte_idx = size-1;*    bs->buf_bit_idx=8;r    bs->totbit=0;    bs->mode = WRITE_MODE;     bs->eob = FALSE;)    bs->eobs = FALSE; }   4 /* open the device to read the bit stream from it */, void open_bit_stream_r(bs, bs_filenam, size)2 Bit_stream_struc *bs;   /* bit stream structure */9 char *bs_filenam;       /* name of the bit stream file */o0 int size;               /* size of the buffer */ {F    register unsigned long n;#    register unsigned char flag = 1;*    unsigned char val;   4    if ((bs->pt = fopen(bs_filenam, "rb")) == NULL) {5       printf("Could not find \"%s\".\n", bs_filenam);e       exit(1);    }      do {w7      n = fread(&val, sizeof(unsigned char), 1, bs->pt);t      switch (val) {e       case 0x30:       case 0x31:       case 0x32:       case 0x33:       case 0x34:       case 0x35:       case 0x36:       case 0x37:       case 0x38:       case 0x39:       case 0x41:       case 0x42:       case 0x43:       case 0x44:       case 0x45:       case 0x46:       case 0xa:  /* \n */        case 0xd:  /* cr */*       case 0x1a:  /* sub */*           break;  5       default: /* detection of an binary character */x           flag--;o           break;      }      } while (flag & n);      if (flag) {G       printf ("the bit stream file %s is an ASCII file\n", bs_filenam);        bs->format = ASCII;-    }	    else {-       bs->format = BINARY;G       printf ("the bit stream file %s is a BINARY file\n", bs_filenam);r    }      fclose(bs->pt);  4    if ((bs->pt = fopen(bs_filenam, "rb")) == NULL) {5       printf("Could not find \"%s\".\n", bs_filenam);        exit(1);    }      alloc_buffer(bs, size);    bs->buf_byte_idx=0;    bs->buf_bit_idx=0;g    bs->totbit=0;    bs->mode = READ_MODE;    bs->eob = FALSE;s    bs->eobs = FALSE; }   C /*close the device containing the bit stream after a read process*/  void close_bit_stream_r(bs)-2 Bit_stream_struc *bs;   /* bit stream structure */ {     fclose(bs->pt);    desalloc_buffer(bs);g }E  D /*close the device containing the bit stream after a write process*/ void close_bit_stream_w(bs)*2 Bit_stream_struc *bs;   /* bit stream structure */ { &    empty_buffer(bs, bs->buf_byte_idx);    fclose(bs->pt);    desalloc_buffer(bs);t }   $ /*open and initialize the buffer; */ void alloc_buffer(bs, size)t2 Bit_stream_struc *bs;   /* bit stream structure */	 int size;o {tA    bs->buf = (unsigned char FAR *) mem_alloc(size*sizeof(unsigned                char), "buffer");     bs->buf_size = size;  }t   /*empty and close the buffer */* void desalloc_buffer(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {b    free(bs->buf);p }   A int putmask[9]={0x0, 0x1, 0x3, 0x7, 0xf, 0x1f, 0x3f, 0x7f, 0xff};9G int clearmask[9]={0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x0};s  B void back_track_buffer(bs, N) /* goes back N bits in the buffer */2 Bit_stream_struc *bs;   /* bit stream structure */ int N; {     int tmp = N - (N/8)*8;*    register int i;      bs->totbit -= N;0I    for (i=bs->buf_byte_idx;i< bs->buf_byte_idx+N/8-1;i++) bs->buf[i] = 0;1    bs->buf_byte_idx += N/8;f'    if ( (tmp + bs->buf_bit_idx) <= 8) {<       bs->buf_bit_idx += tmp;2    }	    else {>       bs->buf_byte_idx ++;#       bs->buf_bit_idx += (tmp - 8);     };    bs->buf[bs->buf_byte_idx] &= clearmask[bs->buf_bit_idx];  }*  9 int mask[8]={0x1, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80};*  # /*read 1 bit from the bit stream */( unsigned int get1bit(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {n    unsigned int bit;    register int i;      bs->totbit++;      if (!bs->buf_bit_idx) {         bs->buf_bit_idx = 8;         bs->buf_byte_idx--;hK         if ((bs->buf_byte_idx < MINIMUM) || (bs->buf_byte_idx < bs->eob)) {o              if (bs->eob)l                  bs->eobs = TRUE;              else {R2                 for (i=bs->buf_byte_idx; i>=0;i--)J                   bs->buf[bs->buf_size-1-bs->buf_byte_idx+i] = bs->buf[i];"                 refill_buffer(bs);2                 bs->buf_byte_idx = bs->buf_size-1;              }	         }e    };    bit = bs->buf[bs->buf_byte_idx]&mask[bs->buf_bit_idx-1]; $    bit = bit >> (bs->buf_bit_idx-1);    bs->buf_bit_idx--;E    return(bit);  }e  $ /*write 1 bit from the bit stream */ void put1bit(bs, bit) 2 Bit_stream_struc *bs;   /* bit stream structure */: int bit;                /* bit to write into the buffer */ {>    bs->totbit++;  A    bs->buf[bs->buf_byte_idx] |= (bit&0x1) << (bs->buf_bit_idx-1);d    bs->buf_bit_idx--;g    if (!bs->buf_bit_idx) {        bs->buf_bit_idx = 8;         bs->buf_byte_idx--;         if (bs->buf_byte_idx < 0)$           empty_buffer(bs, MINIMUM);%        bs->buf[bs->buf_byte_idx] = 0;*    } }*  7 /*look ahead for the next N bits from the bit stream */  unsigned long look_ahead(bs, N)e2 Bit_stream_struc *bs;   /* bit stream structure */H int N;                  /* number of bits to read from the bit stream */ {i  unsigned long val=0;r  register int j = N;  register int k, tmp;_(  register int bit_idx = bs->buf_bit_idx;*  register int byte_idx = bs->buf_byte_idx;    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);    while (j > 0) {     if (!bit_idx) {h         bit_idx = 8;         byte_idx--;f     }l     k = MIN (j, bit_idx); -     tmp = bs->buf[byte_idx]&putmask[bit_idx];s     tmp = tmp >> (bit_idx-k);)     val |= tmp << (j-k);     bit_idx -= k;i     j -= k;   }
  return(val);k }!  # /*read N bit from the bit stream */g unsigned long getbits(bs, N)2 Bit_stream_struc *bs;   /* bit stream structure */H int N;                  /* number of bits to read from the bit stream */ {D  unsigned long val=0;n  register int i;  register int j = N;  register int k, tmp;c    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);    bs->totbit += N;n  while (j > 0) {    if (!bs->buf_bit_idx) {         bs->buf_bit_idx = 8;         bs->buf_byte_idx--;)K         if ((bs->buf_byte_idx < MINIMUM) || (bs->buf_byte_idx < bs->eob)) {n              if (bs->eob))                  bs->eobs = TRUE;              else { 2                 for (i=bs->buf_byte_idx; i>=0;i--)K                    bs->buf[bs->buf_size-1-bs->buf_byte_idx+i] = bs->buf[i]; "                 refill_buffer(bs);2                 bs->buf_byte_idx = bs->buf_size-1;              }	         }     }     k = MIN (j, bs->buf_bit_idx);<    tmp = bs->buf[bs->buf_byte_idx]&putmask[bs->buf_bit_idx];$    tmp = tmp >> (bs->buf_bit_idx-k);    val |= tmp << (j-k);p    bs->buf_bit_idx -= k;
    j -= k;  }
  return(val);t }e  % /*write N bits into the bit stream */a void putbits(bs, val, N)2 Bit_stream_struc *bs;   /* bit stream structure */: unsigned int val;       /* val to write into the buffer */3 int N;                  /* number of bits of val */  {   register int j = N;  register int k, tmp;F    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);    bs->totbit += N;*  while (j > 0) {    k = MIN(j, bs->buf_bit_idx);     tmp = val >> (j-k);H    bs->buf[bs->buf_byte_idx] |= (tmp&putmask[k]) << (bs->buf_bit_idx-k);    bs->buf_bit_idx -= k;    if (!bs->buf_bit_idx) {        bs->buf_bit_idx = 8;p        bs->buf_byte_idx--;         if (bs->buf_byte_idx < 0)$           empty_buffer(bs, MINIMUM);%        bs->buf[bs->buf_byte_idx] = 0;o    }
    j -= k;  } }n  2 /*write N bits byte aligned into the bit stream */! void byte_ali_putbits(bs, val, N)u2 Bit_stream_struc *bs;   /* bit stream structure */: unsigned int val;       /* val to write into the buffer */3 int N;                  /* number of bits of val */C { "  unsigned long aligning, sstell();    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);  aligning = sstell(bs)%8;s  if (aligning)6      putbits(bs, (unsigned int)0, (int)(8-aligning));     putbits(bs, val, N);  }r  : /*read the next bute aligned N bits from the bit stream */% unsigned long byte_ali_getbits(bs, N)s2 Bit_stream_struc *bs;   /* bit stream structure */3 int N;                  /* number of bits of val */* {*"  unsigned long aligning, sstell();    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);  aligning = sstell(bs)%8;k  if (aligning)#     getbits(bs, (int)(8-aligning));)    return(getbits(bs, N)); }*  2 /*return the current bit stream length (in bits)*/ unsigned long sstell(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {*   return(bs->totbit);* }*  ' /*return the status of the bit stream*/ 0 /* returns 1 if end of bit stream was reached */4 /* returns 0 if end of bit stream was not reached */ int end_bs(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {r   return(bs->eobs);l }t  H /*this function seeks for a byte aligned sync word in the bit stream and5   places the bit stream pointer right after the sync.gJ   This function returns 1 if the sync was found otherwise it returns 0  */ int seek_sync(bs, sync, N)2 Bit_stream_struc *bs;   /* bit stream structure *// long sync;      /* sync word maximum 32 bits */i& int N;          /* sync word length */ {,  double pow();!  unsigned long aligning, stell();e  unsigned long val;e)  long maxi = (int)pow(2.0, (FLOAT)N) - 1;a     aligning = sstell(bs)%ALIGNING;  if (aligning)*     getbits(bs, (int)(ALIGNING-aligning));     val = getbits(bs, N);m1   while (((val&maxi) != sync) && (!end_bs(bs))) {C         val <<= ALIGNING; %         val |= getbits(bs, ALIGNING);C   }u    if (end_bs(bs)) return(0);f  else return(1); } N /***************************************************************************** *i *  End of bit_stream.c package *nN *****************************************************************************/  N /***************************************************************************** *e *  CRC error protection packageS *)N *****************************************************************************/  & void I_CRC_calc(fr_ps, bit_alloc, crc) frame_params *fr_ps;# unsigned int bit_alloc[2][SBLIMIT];* unsigned int *crc; {a         int i, k;u$         layer *info = fr_ps->header;$         int stereo  = fr_ps->stereo;%         int jsbound = fr_ps->jsbound;k  :         *crc = 0xffff; /* changed from '0' 92-08-11 shn */0         update_CRC(info->bitrate_index, 4, crc);5         update_CRC(info->sampling_frequency, 2, crc);f*         update_CRC(info->padding, 1, crc);,         update_CRC(info->extension, 1, crc);'         update_CRC(info->mode, 2, crc);d+         update_CRC(info->mode_ext, 2, crc); ,         update_CRC(info->copyright, 1, crc);+         update_CRC(info->original, 1, crc);m+         update_CRC(info->emphasis, 2, crc);            for (i=0;i<SBLIMIT;i++)C6                 for (k=0;k<((i<jsbound)?stereo:1);k++)<                         update_CRC(bit_alloc[k][i], 4, crc); }o  . void II_CRC_calc(fr_ps, bit_alloc, scfsi, crc) frame_params *fr_ps;6 unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT]; unsigned int *crc; {          int i, k; $         layer *info = fr_ps->header;$         int stereo  = fr_ps->stereo;%         int sblimit = fr_ps->sblimit;n%         int jsbound = fr_ps->jsbound;_'         al_table *alloc = fr_ps->alloc;r  :         *crc = 0xffff; /* changed from '0' 92-08-11 shn */0         update_CRC(info->bitrate_index, 4, crc);5         update_CRC(info->sampling_frequency, 2, crc);M*         update_CRC(info->padding, 1, crc);,         update_CRC(info->extension, 1, crc);'         update_CRC(info->mode, 2, crc);*+         update_CRC(info->mode_ext, 2, crc);s,         update_CRC(info->copyright, 1, crc);+         update_CRC(info->original, 1, crc);t+         update_CRC(info->emphasis, 2, crc);o           for (i=0;i<sblimit;i++)c6                 for (k=0;k<((i<jsbound)?stereo:1);k++)N                         update_CRC(bit_alloc[k][i], (*alloc)[i][0].bits, crc);           for (i=0;i<sblimit;i++)*&                 for (k=0;k<stereo;k++),                         if (bit_alloc[k][i])@                                 update_CRC(scfsi[k][i], 2, crc); }m  " void update_CRC(data, length, crc)  unsigned int data, length, *crc; {a%         unsigned int  masking, carry;e           masking = 1 << length;           while((masking >>= 1)){(&                 carry = *crc & 0x8000;                 *crc <<= 1;a/                 if (!carry ^ !(data & masking)) 1                         *crc ^= CRC16_POLYNOMIAL; 	         }e         *crc &= 0xffff;  }/  N /***************************************************************************** *i& *  End of CRC error protection package *xN *****************************************************************************/   #ifdef  MACINTOSH N /***************************************************************************** *t! *  Set Macintosh file attributes.h *iN *****************************************************************************/  ? void    set_mac_file_attr(fileName, vRefNum, creator, fileType)u  char    fileName[MAX_NAME_SIZE]; short   vRefNum; OsType  creator; OsType  fileType;e {x   short   theFile;' char    pascal_fileName[MAX_NAME_SIZE];u FInfo   fndrInfo;s  3         CtoPstr(strcpy(pascal_fileName, fileName));i  3         FSOpen(pascal_fileName, vRefNum, &theFile);*6         GetFInfo(pascal_fileName, vRefNum, &fndrInfo);%         fndrInfo.fdCreator = creator; #         fndrInfo.fdType = fileType; 6         SetFInfo(pascal_fileName, vRefNum, &fndrInfo);         FSClose(theFile);r   }m #endif     #ifdef  MS_DOSK /* ------------------------------------------------------------------------e new_ext.4 Puts a new extension name on a file name <filename>.( Removes the last extension name, if any. 92-08-19 shnK ------------------------------------------------------------------------ */ , char *new_ext(char *filename, char *extname) {,   int found, dotpos;   char newname[80];e  "   /* First, strip the extension */#   dotpos=strlen(filename); found=0;s   do   {      switch (filename[dotpos])      {         case '.' : found=1; break;6       case '\\':                  /* used by MS-DOS */4       case '/' :                  /* used by UNIX */K       case ':' : found=-1; break; /* used by MS-DOS in drive designation */a9       default  : dotpos--; if (dotpos<0) found=-1; break;a     }:   } while (found==0);e*   if (found==-1) strcpy(newname,filename);H   if (found== 1) strncpy(newname,filename,dotpos); newname[dotpos]='\0';   strcat(newname,extname);   return(newname); }  #endif