G /********************************************************************** L Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
 musicout.cG **********************************************************************/ G /********************************************************************** G  * MPEG/audio coding/decoding software, work in progress              * G  *   NOT for public distribution until verified and approved by the   * G  *   MPEG/audio committee.  For further information, please contact   * G  *   Davis Pan, 708-538-5671, e-mail: pan@ukraine.corp.mot.com        * G  *                                                                    * G  * VERSION 4.3                                                        * G  *   changes made since last update:                                  * G  *   date   programmers                comment                        * G  * 2/25/91  Douglas Wong        start of version 1.0 records          * G  * 3/06/91  Douglas Wong        rename setup.h to dedef.h             * G  *                              removed extraneous variables          * G  *                              removed window_samples (now part of   * G  *                              filter_samples)                       * G  * 3/07/91  Davis Pan           changed output file to "codmusic"     * G  * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         * G  *                              Incorporated new "out_fifo()" which   * G  *                              writes out last incomplete buffer.    * G  *                              Incorporated all AIFF routines which  * G  *                              are also compatible with SUN.         * G  *                              Incorporated user interface for       * G  *                              specifying sound file names.          * G  *                              Also incorporated user interface for  * G  *                              writing AIFF compatible sound files.  * G  * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  * G  *                              args to out_fifo (were glob refs).    * G  *                              Used new 'frame_params' struct.       * G  *                              Clean,simplify, track clipped output  * G  *                              and total bits/frame received.        * G  * 7/10/91  Earle Jennings      changed to floats to FLOAT            * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              buffer_CRC and recover_CRC_error      * G  *                              Additions and revisions are marked    * G  *                              with "dhl" for clarity                * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  *19 aug 92 Soren H. Nielsen    Changed MS-DOS file name extensions.  * G  * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        * G  *         Daniel Lauzon, and                                         * G  *         Bill Truerniet                                             * G  *--------------------------------------------------------------------* G  * 4/23/92  J. Pineda           Added code for layer III.  LayerIII   * G  *          Amit Gulati         decoding is currently performed in    * G  *                              two-passes for ease of sideinfo and   * G  *                              maindata buffering and decoding.      * G  *                              The second (computation) pass is      * G  *                              activated with "decode -3 <outfile>"  * G  * 10/25/92 Amit Gulati         Modified usage() for layerIII         * G  * 12/10/92 Amit Gulati         Changed processing order of re-order- * G  *                              -ing step.  Fixed adjustment of       * G  *                              main_data_end pointer to exclude      * G  *                              side information.                     * G  *  9/07/93 Toshiyuki Ishino    Integrated Layer III with Ver 3.9.    * G  *--------------------------------------------------------------------* G  * 11/20/93 Masahiro Iwadare    Integrated Layer III with Ver 4.0.    * G  *--------------------------------------------------------------------* G  *  7/14/94 Juergen Koller      Bug fixes in Layer III code           * G  *--------------------------------------------------------------------* G  * 08/11/94 IIS                 Bug fixes in Layer III code           * G  *--------------------------------------------------------------------* G  * 11/04/94 Jon Rowlands        Prototype fixes                       * H  **********************************************************************/   #include        "common.h" #include        "decoder.h"   E /********************************************************************  /*B /*        This part contains the MPEG I decoder for Layers I & II. /*G /*********************************************************************/   A /****************************************************************  /*A /*        For MS-DOS user (Turbo c) change all instance of malloc A /*        to _farmalloc and free to _farfree. Compiler model hugh F /*        Also make sure all the pointer specified are changed to far. /*C /*****************************************************************/   F /********************************************************************* /*< /* Core of the Layer II decoder.  Default layer is Layer II. /*G /*********************************************************************/   2 /* Global variable definitions for "musicout.c" */   char *programName; int main_data_slots(); int side_info_slots();   /* Implementations */    main(argc, argv)	 int argc;  char **argv; { % /*typedef short PCM[2][3][SBLIMIT];*/ ' typedef short PCM[2][SSLIMIT][SBLIMIT];      PCM FAR *pcm_sample;( typedef unsigned int SAM[2][3][SBLIMIT];     SAM FAR *sample;" typedef double FRA[2][3][SBLIMIT];     FRA FAR *fraction; typedef double VE[2][HAN_SIZE];      VE FAR *w;       Bit_stream_struc  bs;      frame_params      fr_ps;     layer             info;       FILE              *musicout;$     unsigned long     sample_frames;  A     int               i, j, k, x, stereo, done=FALSE, clip, sync; K     int               error_protection, crc_error_count, total_error_count; '     unsigned int      old_crc, new_crc; ?     unsigned int      bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT], 1                       scale_index[2][3][SBLIMIT]; A     unsigned long     bitsPerSlot, samplesPerFrame, frameNum = 0; -     unsigned long     frameBits, gotBits = 0; $     IFF_AIFF          pcm_aiff_data;7     char              encoded_file_name[MAX_NAME_SIZE]; 7     char              decoded_file_name[MAX_NAME_SIZE]; 0     char	      default_file_name[MAX_NAME_SIZE];     char              t[50];      int               need_aiff;0     int               need_esps;        /* MI */     int topSb = 0;   III_scalefac_t III_scalefac; III_side_info_t III_side_info;   #ifdef  MACINTOSH ,     console_options.nrows = MAC_WINDOW_SIZE;     argc = ccommand(&argv);  #endif  >     /* Most large variables are declared dynamically to ensure-        compatibility with smaller machines */   G     pcm_sample = (PCM FAR *) mem_alloc((long) sizeof(PCM), "PCM Samp");*A     sample = (SAM FAR *) mem_alloc((long) sizeof(SAM), "Sample");gE     fraction = (FRA FAR *) mem_alloc((long) sizeof(FRA), "fraction");*5     w = (VE FAR *) mem_alloc((long) sizeof(VE), "w");*       fr_ps.header = &info;*<     fr_ps.tab_num = -1;                /* no table loaded */     fr_ps.alloc = NULL; @     for (i=0;i<HAN_SIZE;i++) for (j=0;j<2;j++) (*w)[j][i] = 0.0;       programName = argv[0];?     if(argc==1) {        /* no command line args -> interact */P        do {6:           printf ("Enter encoded file name <required>: ");#           gets (encoded_file_name); 0           if (encoded_file_name[0] == NULL_CHAR):              printf ("Encoded file name is required. \n");3        } while (encoded_file_name[0] == NULL_CHAR); E        printf (">>> Encoded file name is: %s \n", encoded_file_name);                x=0;     while (x <= MAX_NAME_SIZE)     {1" 	default_file_name[x] = NULL_CHAR; 	++x;  	}     x=0;     while (x <= 8)     { /    default_file_name[x] = encoded_file_name[x];e'     if (encoded_file_name[++x] == '.')   	x = 9;         }     e)     strcat(default_file_name,DFLT_OPEXT);   8     printf("Enter MPEG decoded output file name <%s>: ",* 	   default_file_name); /* 92-08-19 shn */     gets(decoded_file_name);,     if (decoded_file_name[0] == NULL_CHAR) {  t7 	/* replace old extension with new one, 92-08-19 shn */ 3        strcpy(decoded_file_name,default_file_name);         }       J        printf (">>> MPEG decoded file name is: %s \n", decoded_file_name);          printf(M           "Do you wish to write an AIFF compatible sound file ? (y/<n>) : ");i        gets(t); 4        if (*t == 'y' || *t == 'Y') need_aiff = TRUE;5        else                        need_aiff = FALSE;         if (need_aiff)lJ             printf(">>> An AIFF compatible sound file will be written\n");J        else printf(">>> A non-headered PCM sound file will be written\n");          printf(L           "Do you wish to exit (last chance before decoding) ? (y/<n>) : ");        gets(t); +        if (*t == 'y' || *t == 'Y') exit(0);      }*)     else {        /* interpret CL Args */m        int i=0, err=0;          need_aiff = FALSE; "        need_esps = FALSE;	/* MI */#        encoded_file_name[0] = '\0'; #        decoded_file_name[0] = '\0';   $        while(++i<argc && err == 0) {)           char c, *token, *arg, *nextArg;            int  argUsed;n             token = argv[i];           if(*token++ == '-') { 0              if(i+1 < argc) nextArg = argv[i+1];)              else           nextArg = "";               argUsed = 0; "              while(c = *token++) {=                 if(*token /* NumericQ(token) */) arg = token; ?                 else                             arg = nextArg;                  switch(c) {r=                    case 's':  topSb = atoi(arg); argUsed = 1; 4                       if(topSb<1 || topSb>SBLIMIT) {G                          fprintf(stderr, "%s: -s band %s not %d..%d\n",/?                                  programName, arg, 1, SBLIMIT); !                          err = 1;o                       }g                       break;6                    case 'A':  need_aiff = TRUE; break;?                    case 'E':  need_esps = TRUE; break;	/* MI */5L                    default:   fprintf(stderr,"%s: unrecognized option %c\n",6                                       programName, c);%                       err = 1; break;                  }a                 if(argUsed) { H                    if(arg == token) token = ""; /* no more from token */?                    else             ++i; /* skip arg we used */a)                    arg = ""; argUsed = 0;                  }               }           }/           else {-              if(encoded_file_name[0] == '\0') 3                 strcpy(encoded_file_name, argv[i]);               else 0                 if(decoded_file_name[0] == '\0')6                    strcpy(decoded_file_name, argv[i]);                 else {"                    fprintf(stderr,H                            "%s: excess arg %s\n", programName, argv[i]);                    err = 1;r                 }            }         }  L        if(err || encoded_file_name[0] == '\0') usage();  /* never returns */  )        if(decoded_file_name[0] == '\0') { 7           strcpy(decoded_file_name, encoded_file_name);o0           strcat(decoded_file_name, DFLT_OPEXT);        }       }e1     /* report results of dialog / command line */ 5     printf("Input file = '%s'  output file = '%s'\n",91            encoded_file_name, decoded_file_name);eA     if(need_aiff) printf("Output file written in AIFF format\n");tJ     if(need_esps) printf("Output file written in ESPS format\n"); /* MI */  ?     if ((musicout = fopen(decoded_file_name, "w+b")) == NULL) { @        printf ("Could not create \"%s\".\n", decoded_file_name);        exit(1);      }   ;     open_bit_stream_r(&bs, encoded_file_name, BUFFER_SIZE);-       if (need_aiff)5        if (aiff_seek_to_sound_data(musicout) == -1) {.A           printf("Could not seek to PCM sound data in \"%s\".\n",-$                  decoded_file_name);           exit(1);        }       sample_frames = 0;       while (!end_bs(&bs)) {  9        sync = seek_sync(&bs, SYNC_WORD, SYNC_WORD_LNGTH); )        frameBits = sstell(&bs) - gotBits; L        if(frameNum > 0)        /* don't want to print on 1st loop; no lay */#           if(frameBits%bitsPerSlot)rB              fprintf(stderr,"Got %ld bits = %ld slots plus %ld\n",N                      frameBits, frameBits/bitsPerSlot, frameBits%bitsPerSlot);        gotBits += frameBits;          if (!sync) {*.           printf("Frame cannot be located\n");0           printf("Input stream may be empty\n");           done = TRUE;,           /* finally write out the buffer */C           if (info.lay != 1) out_fifo(*pcm_sample, 3, &fr_ps, done,*@                                       musicout, &sample_frames);C           else               out_fifo(*pcm_sample, 1, &fr_ps, done, @                                       musicout, &sample_frames);           break;        }           decode_info(&bs, &fr_ps);        hdr_to_frps(&fr_ps);*        stereo = fr_ps.stereo;*0        error_protection = info.error_protection;        crc_error_count = 0;L        total_error_count = 0; M        if(frameNum == 0) WriteHdr(&fr_ps, stdout);  /* printout layer/mode */*   #ifdef ESPS*! if (frameNum == 0 && need_esps) {u9 esps_write_header(musicout,(long) sample_frames, (double) ' s_freq[info.sampling_frequency] * 1000,o" (int) stereo, decoded_file_name );
 } /* MI */ #endif  =        fprintf(stderr, "{%4lu}", frameNum++); fflush(stderr);L7        if (error_protection) buffer_CRC(&bs, &old_crc);n          switch (info.lay) {             case 1: {e<              bitsPerSlot = 32;        samplesPerFrame = 384;5              I_decode_bitalloc(&bs,bit_alloc,&fr_ps);tA              I_decode_scale(&bs, bit_alloc, scale_index, &fr_ps);   $              if (error_protection) {8                 I_CRC_calc(&fr_ps, bit_alloc, &new_crc);)                 if (new_crc != old_crc) {p%                    crc_error_count++;r'                    total_error_count++;uB                    recover_CRC_error(*pcm_sample, crc_error_count,G                                      &fr_ps, musicout, &sample_frames);_                    break;                  }i)                 else crc_error_count = 0;               }                clip = 0;*              for (i=0;i<SCALE_BLOCK;i++) {@                 I_buffer_sample(&bs,(*sample),bit_alloc,&fr_ps);H                 I_dequantize_sample(*sample,*fraction,bit_alloc,&fr_ps);E                 I_denormalize_sample((*fraction),scale_index,&fr_ps); <                 if(topSb>0)        /* clear channels to 0 */5                    for(j=topSb; j<fr_ps.sblimit; ++j);-                       for(k=0; k<stereo; ++k)I2                          (*fraction)[k][0][j] = 0;  (                 for (j=0;j<stereo;j++) {H                    clip += SubBandSynthesis (&((*fraction)[j][0][0]), j,H                                              &((*pcm_sample)[j][0][0]));                 }M6                 out_fifo(*pcm_sample, 1, &fr_ps, done,3                          musicout, &sample_frames);               }F              if(clip > 0) printf("%d output samples clipped\n", clip);              break;            }=             case 2: {_<              bitsPerSlot = 8;        samplesPerFrame = 1152;8              II_decode_bitalloc(&bs, bit_alloc, &fr_ps);I              II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps);/  %              if (error_protection) {  @                 II_CRC_calc(&fr_ps, bit_alloc, scfsi, &new_crc);)                 if (new_crc != old_crc) { %                    crc_error_count++;U'                    total_error_count++;iB                    recover_CRC_error(*pcm_sample, crc_error_count,G                                      &fr_ps, musicout, &sample_frames);i                    break;=                 } )                 else crc_error_count = 0;x              }                clip = 0;*              for (i=0;i<SCALE_BLOCK;i++) {A                 II_buffer_sample(&bs,(*sample),bit_alloc,&fr_ps);)M                 II_dequantize_sample((*sample),bit_alloc,(*fraction),&fr_ps); K                 II_denormalize_sample((*fraction),scale_index,&fr_ps,i>>2);)  D                 if(topSb>0)        /* debug : clear channels to 0 */5                    for(j=topSb; j<fr_ps.sblimit; ++j) -                       for(k=0; k<stereo; ++k)e/                          (*fraction)[k][0][j] = /                          (*fraction)[k][1][j] =i2                          (*fraction)[k][2][j] = 0;  :                 for (j=0;j<3;j++) for (k=0;k<stereo;k++) {H                    clip += SubBandSynthesis (&((*fraction)[k][j][0]), k,H                                              &((*pcm_sample)[k][j][0]));                 } @                 out_fifo(*pcm_sample, 3, &fr_ps, done, musicout,)                          &sample_frames);d              }?              if(clip > 0) printf("%d samples clipped\n", clip);h              break;            }n             case 3: {               int nSlots;<              int gr, ch, ss, sb, main_data_end, flush_main ; 	     int  bytes_to_discard ;i! 	     static int frame_start = 0;=<              bitsPerSlot = 8;        samplesPerFrame = 1152;  <              III_get_side_info(&bs, &III_side_info, &fr_ps);-              nSlots = main_data_slots(fr_ps);h@              for (; nSlots > 0; nSlots--)  /* read main data. */:                 hputbuf((unsigned int) getbits(&bs,8), 8);: 	     main_data_end = hsstell() / 8; /*of privious frame*/;              if ( flush_main=(hsstell() % bitsPerSlot) ) {  :                 hgetbits((int)(bitsPerSlot - flush_main)); 		main_data_end ++;a 	     }n;              bytes_to_discard = frame_start - main_data_endx1  			            - III_side_info.main_data_begin ; '              if( main_data_end > 4096 )d%              {   frame_start -= 4096;1&                  rewindNbytes( 4096 );              }  3              frame_start += main_data_slots(fr_ps); (              if (bytes_to_discard < 0) {P          printf("Not enough main data to decode frame %d.  Frame discarded.\n", -                         frameNum - 1); break;               }J              for (; bytes_to_discard > 0; bytes_to_discard--) hgetbits(8);                clip = 0;#              for (gr=0;gr<2;gr++) {oF                double lr[2][SBLIMIT][SSLIMIT],ro[2][SBLIMIT][SSLIMIT];  ,                for (ch=0; ch<stereo; ch++) {J                  long int is[SBLIMIT][SSLIMIT];   /* Quantized samples. */!                  int part2_start; )                  part2_start = hsstell();;I                  III_get_scale_factors(III_scalefac,&III_side_info,gr,ch,  			&fr_ps); K                  III_hufman_decode(is, &III_side_info, ch, gr, part2_start,n+                                    &fr_ps);dA                  III_dequantize_sample(is, ro[ch], &III_scalefac,cO                                    &(III_side_info.ch[ch].gr[gr]), ch, &fr_ps);;                }-                III_stereo(ro,lr,III_scalefac, C                             &(III_side_info.ch[0].gr[gr]), &fr_ps); ,                for (ch=0; ch<stereo; ch++) {0                     double re[SBLIMIT][SSLIMIT];O                     double hybridIn[SBLIMIT][SSLIMIT];/* Hybrid filter input */eN                     double hybridOut[SBLIMIT][SSLIMIT];/* Hybrid filter out */K                     double polyPhaseIn[SBLIMIT];     /* PolyPhase Input. */r  J                     III_reorder (lr[ch],re,&(III_side_info.ch[ch].gr[gr]),*                                   &fr_ps);L                     III_antialias(re, hybridIn, /* Antialias butterflies. */J                                   &(III_side_info.ch[ch].gr[gr]), &fr_ps);J                     for (sb=0; sb<SBLIMIT; sb++) { /* Hybrid synthesis. */G                         III_hybrid(hybridIn[sb], hybridOut[sb], sb, ch,eK                                    &(III_side_info.ch[ch].gr[gr]), &fr_ps);                      }fP                     for (ss=0;ss<18;ss++) /*Frequency inversion for polyphase.*/3                        for (sb=0; sb<SBLIMIT; sb++)-/                           if ((ss%2) && (sb%2)) D                              hybridOut[sb][ss] = -hybridOut[sb][ss];E                     for (ss=0;ss<18;ss++) { /* Polyphase synthesis */ 4                         for (sb=0; sb<SBLIMIT; sb++)@                             polyPhaseIn[sb] = hybridOut[sb][ss];B                         clip += SubBandSynthesis (polyPhaseIn, ch,O                                                   &((*pcm_sample)[ch][ss][0]));s                         }l                     } ?                 /* Output PCM sample points for one granule. */tA                 out_fifo(*pcm_sample, 18, &fr_ps, done, musicout, )                          &sample_frames);y              }@              if(clip > 0) printf("%d samples clipped.\n", clip);              break;            }         }     }u       if (need_aiff) {0        pcm_aiff_data.numChannels       = stereo;7        pcm_aiff_data.numSampleFrames   = sample_frames; ,        pcm_aiff_data.sampleSize        = 16;N        pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000; #ifdef IFF_LONGp5        pcm_aiff_data.sampleType        = IFF_ID_SSND;t #else 8        strncpy(&pcm_aiff_data.sampleType,IFF_ID_SSND,4); #endif+        pcm_aiff_data.blkAlgn.offset    = 0; +        pcm_aiff_data.blkAlgn.blockSize = 0;f  @        if (aiff_write_headers(musicout, &pcm_aiff_data) == -1) {<           printf("Could not write AIFF headers to \"%s\"\n",$                  decoded_file_name);           exit(2);        }     }n  D     printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",6            (FLOAT) gotBits / (frameNum * bitsPerSlot),:            (FLOAT) gotBits / (frameNum * samplesPerFrame),;            (FLOAT) gotBits / (frameNum * samplesPerFrame) *i,            s_freq[info.sampling_frequency]);       close_bit_stream_r(&bs);     fclose(musicout);   1     /* for the correct AIFF header information */ 1     /*             on the Macintosh            */ 1     /* the file type and the file creator for  */ 1     /* Macintosh compatible Digidesign is set  */r   #ifdef  MACINTOSH D     if (need_aiff) set_mac_file_attr(decoded_file_name, VOL_REF_NUM,G                                      CREATR_DEC_AIFF, FILTYP_DEC_AIFF); D     else           set_mac_file_attr(decoded_file_name, VOL_REF_NUM,G                                      CREATR_DEC_BNRY, FILTYP_DEC_BNRY);; #endif  B     printf("Decoding of \"%s\" is finished\n", encoded_file_name);N     printf("The decoded PCM output file name is \"%s\"\n", decoded_file_name);     if (need_aiff)G        printf("\"%s\" has been written with AIFF header information\n",f!               decoded_file_name);t       exit( 0 ); }   . static void usage()  /* print syntax & exit */ {     fprintf(stderr,J       "usage: %s                         queries for all arguments, or\n",        programName);    fprintf(stderr,?       "       %s [-A][-s sb] inputBS [outPCM]\n", programName);,    fprintf(stderr,"where\n"); E    fprintf(stderr," -A       write an AIFF output PCM sound file\n"); M    fprintf(stderr," -s sb    resynth only up to this sb (debugging only)\n");uC    fprintf(stderr," inputBS  input bit stream of encoded audio\n");fG    fprintf(stderr," outPCM   output PCM sound file (dflt inName+%s)\n",=            DFLT_OPEXT);     exit(1);b }P