/* polyiamond.h -- polyiamonds for tertris */

/* Maximum number of triangles was chosen to be 8 because if 9, it leaves a */
/*  hole:  @ @   */
/*        @ @ @  */
/*        @   @  */
/*         @ @   */
/*  likewise, 2 was chosen for diagonal mode because if 3, it leaves a hole: */
/*   @   */
/*       */
/*  @ @  */

/* '+' Prelude part */
/*   1st number = number of triangles in a polyiamond */
/*   2nd number = number of distinct polyiamonds & rotations & reflections */
/*   3rd number = number of distinct polyiamonds & reflections */
/*   4th number = number of distinct polyiamonds */
/*   5th number = 0 do not allow rotation and reflection */
/*                1 allow rotation but not reflection */
/*                2 allow rotation and reflection */
/*   6th number = diagonal mode to consider? 0 or 1 (if 0, no 8-12) */
/*   7th number = diagonal number of distinct polyiamonds & rots & refls */
/*   8th number = diagonal number of distinct polyiamonds & reflections */
/*   9th number = diagonal number of distinct polyiamonds */
/*  10th number = 0 do not allow rotation and reflection for diagonal mode */
/*                1 allow rotation but not reflection for diagonal mode */
/*                2 allow rotation and reflection for diagonal mode */

/* '*' Main parts */
/*   1st number = n-> consider an 6n^2 hexagon */
/* '#' polyiamond group (follows a '*') */
/*   1st number = number of triangles in a polyiamond */
/*   2nd number = number of polyiamonds (incl rot & refl) in a 6n^2 hexagon */
/*   3rd number = if it is there, number of polyiamonds (incl rot & refl) */
/*       in a 6n^2 hexagon with diagonal mode */
/* The polyiamond (follows a '#') */
/*   1st number = numbered polyiamond (there for your benefit) */
/*   2nd number = rotation pointer (usually the next polyiamond) */
/*   3rd number = reflection pointer */
/*   4th number = number of rows down to start */
/*   5th number = start number (0, 1, or 2) */
/*       0=> starter for no turns permitted (no reflections or rotations) */
/*       1=> starter for allow rotations and no turns permitted */
/*       2=> starter for reflections, rotations, and no turns permitted */
/*   Next number (if diagonal mode) = start number for diagonal mode */
/*   The proceeding 2 or 3 numbers are repeated for gradual appearance */
/*       Pieces either JUMPIN or appear GRADUALly */
/*   The last group of 6n^2 numbers is the actual polyiamond */
/*       0=>    empty triangle */
/*       1..8=> used triangle */
/* '~' debug (preceeds a '#') */
/*   1st number = number of polyiamonds to skip */

static /* const */ char * polyiamond_data[] = {

/* PRELUDE */
/* + Polyiamond States(None Rot Refl) Style Diagonal [States(N R R) Style] */
/* + 2 1 1 1 0 1    2 1 1 0 */
"+ 2 3 1 1 0 1    12 3 3 1",
"+ 3 6 1 1 0 0",
"+ 4 14 4 3 1 0",
"+ 5 36 6 4 2 0",
"+ 6 94 19 12 2 0",
"+ 7 272 49 27 2 0",
"+ 8 675 120 66 2 0",

/* MAIN */
/* * X    (polyiamond fills 6X^2 hexagon) */
/* # Polyiamond Number_of_Polyiamonds_Normal [Number_of_Polyiamonds_Diagonal] */
/* Ref_Num Ptr_Rot Ptr_Refl (Start_Location Start_N [Start_D])J&G Shape_Array */
/* * 1 */
/* # 1 1 */
/* 0 1 0  0 2 0 0   0 8 0  0 0 0 */
/* 1 0 0  1 0 1 2   0 0 0  0 8 0 */
"* 1",
"# 2 3 12",
"0 1 2   0 2 2 0 0 0   2 1 0  0 0 0",
"1 2 1   0 0 0 1 2 2   1 0 0  4 0 0",
"2 0 0   1 0 0 1 0 0   0 0 0  2 4 0",

"3 4 3    0 0 0 1 0 0   8 0 8  0 0 0",
"4 5 8    0 0 0 1 0 2   0 8 0  8 0 0",
"5 6 7    0 0 0 1 0 0   8 0 0  0 8 0",
"6 7 6    1 0 2 1 0 0   0 0 0  8 0 8",
"7 8 5    0 0 0 1 0 0   0 0 8  0 8 0",
"8 3 4    0 0 0 1 0 0   0 8 0  0 0 8",
"9 10 10  0 0 2 1 0 0   8 0 0  0 0 8",
"10 11 9  0 0 0 1 0 0   0 0 8  8 0 0",
"11 9 11  0 0 0 1 0 2   0 8 0  0 8 0",
"# 3 6",
"0 1 0  0 2 0 0   2 3 4  0 0 0",
"1 2 5  0 0 1 2   3 1 0  4 0 0",
"2 3 4  0 0 1 0   1 0 0  6 4 0",
"3 4 3  1 0 1 0   0 0 0  2 6 1",
"4 5 2  0 0 1 0   0 0 1  0 2 5",
"5 0 1  0 0 1 0   0 2 5  0 0 4",
"# 4 6",
"0 1 5  0 2 1 0   3 3 4  4 0 0",
"1 2 4  0 0 1 2   3 1 0  6 4 0",
"2 3 3  0 0 1 0   1 0 0  6 6 1",
"3 4 2  0 0 1 0   0 0 1  2 6 5",
"4 5 1  0 0 1 0   0 2 5  0 2 5",
"5 0 0  0 0 1 0   2 3 5  0 0 4",
"# 5 6",
"0 1 0  0 2 1 0   3 3 5  4 0 4",
"1 2 5  0 0 1 2   3 3 4  6 4 0",
"2 3 4  0 0 1 0   3 1 0  6 6 1",
"3 4 3  0 0 1 0   1 0 1  6 6 5",
"4 5 2  0 0 1 0   0 2 5  2 6 5",
"5 0 1  0 0 1 0   2 3 5  0 2 5",
"# 6 1",
"0 0 0  0 2 1 2   3 3 5  6 6 5",
"* 2",
"# 4 8",
"0 1 3  1 2 1 0   0 0 0 0 0  2 3 6 1 0 0 0  0 0 0 0 0 0 0  0 0 0 0 0",
"1 2 5  0 0 2 2   1 0 0 0 0  3 5 0 0 0 0 0  4 0 0 0 0 0 0  0 0 0 0 0",
"2 0 4  1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"3 4 0  2 1 2 0   0 0 0 0 0  0 0 0 0 0 0 0  2 6 3 4 0 0 0  0 0 0 0 0",
"4 5 2  1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"5 3 1  1 0 3 1   0 0 0 0 0  1 0 0 0 0 0 0  6 5 0 0 0 0 0  4 0 0 0 0",
"6 7 6  1 2 2 0   0 0 0 0 0  0 0 1 0 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"7 6 7  1 0 2 2   0 0 0 0 0  0 2 7 1 0 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"# 5 30",
"0 1 0     1 2 1 0   0 0 0 0 0  2 3 6 3 4 0 0  0 0 0 0 0 0 0  0 0 0 0 0",
"1 2 5     1 0 3 2   0 0 0 0 0  0 0 3 1 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"2 3 4     0 0 2 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"3 4 3     1 0 2 0   0 0 0 0 0  0 0 0 0 0 0 0  2 6 3 6 1 0 0  0 0 0 0 0",
"4 5 2     0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"5 0 1     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"6 7 12    1 2 2 0   0 0 0 0 0  3 3 6 1 0 0 0  4 0 0 0 0 0 0  0 0 0 0 0",
"7 8 17    0 0 2 0   1 0 0 0 0  3 5 0 0 0 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"8 9 16    1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"9 10 15   1 0 2 0   0 0 0 0 0  0 0 0 0 1 0 0  0 2 3 6 5 0 0  0 0 0 0 0",
"10 11 14  1 0 3 1   0 0 0 0 0  0 2 5 0 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"11 6 13   1 0 2 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"12 13 6   1 1 2 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 0 4 0 0  0 0 0 0 0",
"13 14 11  1 0 2 0   0 0 0 0 0  0 0 3 3 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"14 15 10  1 0 3 2   0 0 0 0 0  3 1 0 0 0 0 0  6 5 0 0 0 0 0  4 0 0 0 0",
"15 16 9   1 0 2 0   0 0 0 0 0  1 0 0 0 0 0 0  6 6 3 4 0 0 0  0 0 0 0 0",
"16 17 8   1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"17 12 7   0 0 2 0   1 0 0 0 0  0 6 5 0 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"18 19 24  1 2 2 0   0 0 0 0 0  2 3 7 1 0 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"19 20 29  1 0 3 1   0 0 0 0 0  0 0 1 0 0 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"20 21 28  1 0 2 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"21 22 27  1 0 2 0   0 0 0 0 0  0 0 1 0 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"22 23 26  0 0 2 0   0 0 1 0 0  0 2 7 5 0 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"23 18 25  1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"24 25 18  1 1 2 0   0 0 0 0 0  0 2 7 3 4 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"25 26 23  1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"26 27 22  0 0 2 0   1 0 0 0 0  0 6 7 1 0 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"27 28 21  1 0 2 0   0 0 0 0 0  0 0 1 0 0 0 0  2 6 7 4 0 0 0  0 0 0 0 0",
"28 29 20  1 0 2 0   0 0 0 0 0  0 2 7 1 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"29 24 19  1 0 3 2   0 0 0 0 0  0 0 1 0 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"# 6 93",
"0 1 3     1 2 1 0   0 0 0 0 0  2 3 6 3 6 1 0  0 0 0 0 0 0 0  0 0 0 0 0",
"1 2 5     0 0 3 2   0 0 1 0 0  0 0 3 5 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"2 0 4     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"3 4 0     2 1 2 0   0 0 0 0 0  0 0 0 0 0 0 0  2 6 3 6 3 4 0  0 0 0 0 0",
"4 5 2     0 0 2 0   0 0 3 1 0  0 0 3 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"5 3 1     0 0 3 1   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"6 7 12    1 2 2 0   0 0 0 0 0  3 3 6 3 4 0 0  4 0 0 0 0 0 0  0 0 0 0 0",
"7 8 17    0 0 2 0   3 1 0 0 0  3 5 0 0 0 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"8 9 16    0 0 2 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"9 10 15   1 0 2 0   0 0 0 0 0  0 0 0 0 1 0 0  2 6 3 6 5 0 0  0 0 0 0 0",
"10 11 14  0 0 2 0   0 2 5 0 0  0 0 3 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"11 6 13   1 0 3 1   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"12 13 6   1 1 2 0   0 0 0 0 0  2 3 6 3 5 0 0  0 0 0 0 4 0 0  0 0 0 0 0",
"13 14 11  1 0 3 2   0 0 0 0 0  0 0 3 3 4 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"14 15 10  1 0 3 0   0 0 0 0 0  3 1 0 0 0 0 0  6 5 0 0 0 0 0  6 4 0 0 0",
"15 16 9   1 0 2 0   0 0 0 0 0  1 0 0 0 0 0 0  6 6 3 6 1 0 0  0 0 0 0 0",
"16 17 8   0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"17 12 7   1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"18 19 18  1 2 2 0   0 0 0 0 0  2 3 7 3 4 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"19 20 23  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"20 21 22  0 0 2 0   1 0 0 0 0  0 6 7 1 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"21 22 21  1 0 2 0   0 0 0 0 0  0 0 1 0 0 0 0  2 6 7 6 1 0 0  0 0 0 0 0",
"22 23 20  0 0 2 2   0 0 1 0 0  0 2 7 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"23 18 19  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"24 25 30  1 2 2 0   0 0 0 0 0  0 2 7 3 6 1 0  0 0 4 0 0 0 0  0 0 0 0 0",
"25 26 35  0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"26 27 34  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"27 28 33  1 0 2 0   0 0 0 0 0  0 0 0 0 1 0 0  0 2 3 6 7 4 0  0 0 0 0 0",
"28 29 32  1 0 3 2   0 0 0 0 0  0 2 7 1 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"29 24 31  0 0 2 0   1 0 0 0 0  2 7 5 0 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"30 31 24  1 1 2 0   0 0 0 0 0  0 2 6 3 7 1 0  0 0 0 0 4 0 0  0 0 0 0 0",
"31 32 29  0 0 2 0   0 0 1 0 0  0 0 3 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"32 33 28  1 0 3 1   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"33 34 27  1 0 2 0   0 0 0 0 0  0 0 1 0 0 0 0  0 2 7 6 3 4 0  0 0 0 0 0",
"34 35 26  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 7 5 0 0 0 0  4 0 0 0 0",
"35 30 25  0 0 2 0   1 0 0 0 0  0 6 5 0 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"36 37 42  1 2 2 0   0 0 0 0 0  0 2 7 3 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"37 38 47  0 0 2 0   3 1 0 0 0  2 7 5 0 0 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"38 39 46  1 0 3 0   0 0 0 0 0  1 0 0 0 0 0 0  6 7 3 4 0 0 0  4 0 0 0 0",
"39 40 45  1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  2 6 7 4 0 0 0  0 0 0 0 0",
"40 41 44  0 0 2 2   1 0 0 0 0  0 6 7 1 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"41 36 43  1 0 3 0   0 0 0 0 0  0 0 1 0 0 0 0  2 6 7 5 0 0 0  0 0 4 0 0",
"42 43 36  1 1 2 0   0 0 0 0 0  2 3 7 1 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"43 44 41  0 0 2 0   1 0 0 0 0  3 7 6 1 0 0 0  4 0 0 0 0 0 0  0 0 0 0 0",
"44 45 40  1 0 3 1   0 0 0 0 0  0 0 1 0 0 0 0  2 7 5 0 0 0 0  6 4 0 0 0",
"45 46 39  1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"46 47 38  0 0 2 0   0 0 1 0 0  2 3 7 5 0 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"47 42 37  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"48 49 52  1 2 2 0   0 0 0 0 0  0 2 7 3 4 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"49 50 51  1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"50 51 50  1 0 3 2   0 0 0 0 0  0 0 1 0 1 0 0  0 0 6 7 5 0 0  0 0 4 0 0",
"51 52 49  1 0 2 0   0 0 0 0 0  0 0 0 2 5 0 0  0 0 2 6 7 4 0  0 0 0 0 0",
"52 53 48  1 0 2 0   0 0 0 0 0  0 0 2 3 7 1 0  0 0 0 2 5 0 0  0 0 0 0 0",
"53 48 53  0 0 2 0   0 0 1 0 0  0 0 3 7 5 0 0  0 0 4 0 4 0 0  0 0 0 0 0",
"54 55 60  1 2 2 0   0 0 0 0 0  0 0 3 3 7 1 0  0 0 4 0 4 0 0  0 0 0 0 0",
"55 56 65  0 0 2 1   0 0 1 0 0  0 0 3 7 4 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"56 57 64  1 0 2 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"57 58 63  1 0 2 0   0 0 0 0 0  0 0 1 0 1 0 0  0 2 7 6 5 0 0  0 0 0 0 0",
"58 59 62  1 0 3 0   0 0 0 0 0  0 0 0 2 5 0 0  0 0 2 7 5 0 0  0 0 4 0 0",
"59 54 61  1 0 2 0   0 0 0 0 0  0 0 2 3 5 0 0  0 0 0 2 7 4 0  0 0 0 0 0",
"60 61 54  1 1 2 0   0 0 0 0 0  0 2 7 3 5 0 0  0 0 4 0 4 0 0  0 0 0 0 0",
"61 62 59  1 0 2 0   0 0 0 0 0  0 0 3 3 4 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"62 63 58  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"63 64 57  1 0 2 0   0 0 0 0 0  0 0 1 0 1 0 0  0 0 6 6 7 4 0  0 0 0 0 0",
"64 65 56  1 0 2 0   0 0 0 0 0  0 0 0 2 7 1 0  0 0 2 6 5 0 0  0 0 0 0 0",
"65 60 55  0 0 2 2   0 0 1 0 0  0 0 2 7 5 0 0  0 0 0 2 5 0 0  0 0 0 0 0",
"66 67 68  1 2 3 2   0 0 0 0 0  0 0 1 0 0 0 0  2 7 7 4 0 0 0  4 0 0 0 0",
"67 68 67  1 0 2 0   0 0 0 0 0  0 2 7 1 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"68 66 66  0 0 2 0   1 0 0 0 0  2 7 7 1 0 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"69 70 74  1 2 2 0   0 0 0 0 0  0 0 3 3 6 1 0  0 2 5 0 0 0 0  0 0 0 0 0",
"70 71 73  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"71 72 72  1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"72 73 71  1 0 2 0   0 0 0 0 0  0 0 0 0 3 1 0  0 2 3 6 5 0 0  0 0 0 0 0",
"73 74 70  0 0 3 2   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"74 69 69  1 0 2 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"75 76 81  1 2 2 0   0 0 0 0 0  0 0 3 3 6 1 0  0 0 6 4 0 0 0  0 0 0 0 0",
"76 77 86  0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"77 78 85  1 0 2 0   0 0 0 0 0  0 2 5 0 1 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"78 79 84  1 0 2 0   0 0 0 0 0  0 0 0 2 5 0 0  0 2 3 6 5 0 0  0 0 0 0 0",
"79 80 83  1 0 3 2   0 0 0 0 0  0 0 2 3 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"80 75 82  1 0 2 0   0 0 0 0 0  0 0 3 3 5 0 0  0 0 4 0 6 4 0  0 0 0 0 0",
"81 82 75  1 1 2 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 2 5 0 0  0 0 0 0 0",
"82 83 80  1 0 2 0   0 0 0 0 0  0 0 3 3 5 0 0  0 2 5 0 4 0 0  0 0 0 0 0",
"83 84 79  1 0 3 1   0 0 0 0 0  0 0 3 3 4 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"84 85 78  1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"85 86 77  1 0 2 0   0 0 0 0 0  0 0 1 0 3 1 0  0 0 6 6 5 0 0  0 0 0 0 0",
"86 81 76  0 0 2 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 2 6 5 0 0  0 0 0 0 0",
"87 88 90  0 2 2 0   0 0 1 0 0  3 3 6 5 0 0 0  4 0 0 0 0 0 0  0 0 0 0 0",
"88 89 92  1 0 3 1   0 0 0 0 0  0 2 5 0 0 0 0  0 3 5 0 0 0 0  6 4 0 0 0",
"89 87 91  1 0 2 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"90 91 87  1 1 3 0   0 0 0 0 0  1 0 0 0 0 0 0  6 6 3 5 0 0 0  0 0 4 0 0",
"91 92 89  1 0 2 0   0 0 0 0 0  0 0 3 3 4 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"92 90 88  0 0 2 2   3 1 0 0 0  0 6 5 0 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"# 7 248",
"0 1 0        1 2 1 0   0 0 0 0 0  2 3 6 3 6 3 4  0 0 0 0 0 0 0  0 0 0 0 0",
"1 2 5        0 0 3 2   0 0 3 1 0  0 0 3 5 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"2 3 4        0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"3 4 3        2 0 2 0   0 0 0 0 0  0 0 0 0 0 0 0  2 6 3 6 3 6 1  0 0 0 0 0",
"4 5 2        0 0 3 0   0 0 0 0 1  0 0 0 0 3 5 0  0 0 0 3 5 0 0  0 2 5 0 0",
"5 0 1        0 0 3 0   0 2 5 0 0  0 0 0 6 5 0 0  0 0 0 0 6 5 0  0 0 0 0 4",
"6 7 12       1 2 2 0   0 0 0 0 0  3 3 6 3 6 1 0  4 0 0 0 0 0 0  0 0 0 0 0",
"7 8 17       0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 3 5 0 0 0 0  6 4 0 0 0",
"8 9 16       1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 5 0 0 0  0 0 6 6 1",
"9 10 15      1 0 2 0   0 0 0 0 0  0 0 0 0 0 0 1  0 2 3 6 3 6 5  0 0 0 0 0",
"10 11 14     0 0 3 2   0 2 5 0 0  0 0 3 5 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"11 6 13      1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"12 13 6      1 1 2 0   0 0 0 0 0  0 2 6 3 6 3 5  0 0 0 0 0 0 4  0 0 0 0 0",
"13 14 11     0 0 2 0   0 0 3 3 4  0 0 3 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"14 15 10     0 0 3 1   3 1 0 0 0  0 6 5 0 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"15 16 9      1 0 2 0   0 0 0 0 0  1 0 0 0 0 0 0  6 6 3 6 3 4 0  0 0 0 0 0",
"16 17 8      0 0 2 0   0 0 3 1 0  0 0 3 5 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"17 12 7      0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 0 6 5 0  0 0 0 2 5",
"18 19 24     1 2 2 0   0 0 0 0 0  2 3 7 3 6 1 0  0 0 4 0 0 0 0  0 0 0 0 0",
"19 20 29     0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"20 21 28     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 1 0 0  0 0 6 4 0",
"21 22 27     1 0 2 0   0 0 0 0 0  0 0 0 0 1 0 0  0 2 3 6 7 6 1  0 0 0 0 0",
"22 23 26     0 0 3 2   0 0 1 0 0  0 2 7 5 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"23 18 25     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 5 0 0 0  0 0 6 4 0",
"24 25 18     1 1 2 0   0 0 0 0 0  0 2 6 3 7 3 4  0 0 0 0 4 0 0  0 0 0 0 0",
"25 26 23     0 0 2 0   0 0 3 1 0  0 0 3 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"26 27 22     0 0 3 1   1 0 0 0 0  0 6 7 1 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"27 28 21     1 0 2 0   0 0 0 0 0  0 0 1 0 0 0 0  2 6 7 6 3 4 0  0 0 0 0 0",
"28 29 20     0 0 2 0   0 0 3 1 0  0 2 7 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"29 24 19     0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"30 31 36     1 2 2 0   0 0 0 0 0  0 2 7 3 6 3 4  0 0 4 0 0 0 0  0 0 0 0 0",
"31 32 41     0 0 2 0   0 0 3 1 0  0 0 3 5 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"32 33 40     0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"33 34 39     1 0 2 0   0 0 0 0 0  0 0 0 0 1 0 0  2 6 3 6 7 4 0  0 0 0 0 0",
"34 35 38     0 0 2 2   0 2 7 1 0  0 0 3 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"35 30 37     0 0 3 0   1 0 0 0 0  2 7 5 0 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"36 37 30     1 1 2 0   0 0 0 0 0  2 3 6 3 7 1 0  0 0 0 0 4 0 0  0 0 0 0 0",
"37 38 35     0 0 3 0   0 0 1 0 0  0 0 3 7 4 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"38 39 34     1 0 3 1   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"39 40 33     1 0 2 0   0 0 0 0 0  0 0 1 0 0 0 0  0 2 7 6 3 6 1  0 0 0 0 0",
"40 41 32     0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  2 7 5 0 0 0 0  4 0 0 0 0",
"41 36 31     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 5 0 0 0  0 2 7 4 0",
"42 43 48     0 2 2 0   1 0 0 0 0  3 7 6 3 4 0 0  4 0 0 0 0 0 0  0 0 0 0 0",
"43 44 53     1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 7 5 0 0 0 0  6 4 0 0 0",
"44 45 52     0 0 2 0   1 0 0 0 0  0 6 5 0 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"45 46 51     1 0 3 0   0 0 0 0 0  0 0 0 0 1 0 0  2 6 3 7 5 0 0  0 0 4 0 0",
"46 47 50     0 0 2 0   0 2 5 0 0  0 0 3 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"47 42 49     1 0 3 1   0 0 0 0 0  2 3 7 1 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"48 49 42     0 1 2 0   0 0 1 0 0  2 3 6 7 5 0 0  0 0 0 0 4 0 0  0 0 0 0 0",
"49 50 47     1 0 3 2   0 0 0 0 0  0 2 7 3 4 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"50 51 46     0 0 2 0   3 1 0 0 0  2 7 5 0 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"51 52 45     1 0 3 0   0 0 0 0 0  1 0 0 0 0 0 0  6 7 3 6 1 0 0  4 0 0 0 0",
"52 53 44     0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  2 6 7 4 0 0 0  0 0 0 0 0",
"53 48 43     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 1 0 0  0 2 5 0 0",
"54 55 60     0 2 2 0   1 0 0 0 0  2 7 7 3 4 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"55 56 65     1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 7 7 4 0 0 0  4 0 0 0 0",
"56 57 64     0 0 2 0   1 0 0 0 0  0 6 7 1 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"57 58 63     1 0 3 0   0 0 0 0 0  0 0 1 0 0 0 0  2 6 7 7 1 0 0  0 0 4 0 0",
"58 59 62     0 0 2 2   0 0 1 0 0  0 2 7 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"59 54 61     1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"60 61 54     0 1 2 0   0 0 1 0 0  2 3 7 7 4 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"61 62 59     1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"62 63 58     0 0 2 1   1 0 0 0 0  2 7 7 1 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"63 64 57     1 0 3 0   0 0 0 0 0  0 0 1 0 0 0 0  2 7 7 6 1 0 0  4 0 0 0 0",
"64 65 56     0 0 2 0   0 0 1 0 0  0 2 7 5 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"65 60 55     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 7 1 0 0  0 0 4 0 0",
"66 67 72     0 2 2 0   0 0 1 0 0  3 3 6 7 4 0 0  4 0 0 0 0 0 0  0 0 0 0 0",
"67 68 77     1 0 3 1   0 0 0 0 0  0 2 7 1 0 0 0  0 3 5 0 0 0 0  6 4 0 0 0",
"68 69 76     0 0 2 0   1 0 0 0 0  2 7 5 0 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"69 70 75     1 0 3 0   0 0 0 0 0  0 0 0 0 1 0 0  2 7 3 6 5 0 0  4 0 0 0 0",
"70 71 74     0 0 2 0   0 2 5 0 0  0 0 3 5 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"71 66 73     1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"72 73 66     0 1 2 0   1 0 0 0 0  2 7 6 3 5 0 0  0 0 0 0 4 0 0  0 0 0 0 0",
"73 74 71     1 0 3 0   0 0 0 0 0  0 0 3 3 4 0 0  2 7 5 0 0 0 0  4 0 0 0 0",
"74 75 70     0 0 2 0   3 1 0 0 0  0 6 5 0 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"75 76 69     1 0 3 0   0 0 0 0 0  1 0 0 0 0 0 0  6 6 3 7 1 0 0  0 0 4 0 0",
"76 77 68     0 0 2 0   0 0 1 0 0  0 0 3 7 4 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"77 72 67     1 0 3 2   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"78 79 78     1 2 2 0   0 0 0 0 0  0 2 7 3 7 1 0  0 0 4 0 4 0 0  0 0 0 0 0",
"79 80 83     0 0 2 0   0 0 1 0 0  0 0 3 7 4 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"80 81 82     1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"81 82 81     1 0 2 0   0 0 0 0 0  0 0 1 0 1 0 0  0 2 7 6 7 4 0  0 0 0 0 0",
"82 83 80     1 0 3 2   0 0 0 0 0  0 0 0 2 7 1 0  0 0 2 7 5 0 0  0 0 4 0 0",
"83 78 79     0 0 2 0   0 0 1 0 0  0 0 2 7 5 0 0  0 0 0 2 7 4 0  0 0 0 0 0",
"84 85 90     1 2 2 0   0 0 0 0 0  0 2 7 3 6 1 0  0 0 6 4 0 0 0  0 0 0 0 0",
"85 86 95     0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"86 87 94     1 0 3 0   0 0 0 0 0  0 2 5 0 1 0 0  0 0 6 7 5 0 0  0 0 4 0 0",
"87 88 93     1 0 2 0   0 0 0 0 0  0 0 0 2 5 0 0  0 2 3 6 7 4 0  0 0 0 0 0",
"88 89 92     1 0 3 2   0 0 0 0 0  0 0 2 3 7 1 0  0 0 0 3 5 0 0  0 0 4 0 0",
"89 84 91     0 0 2 0   0 0 1 0 0  0 0 3 7 5 0 0  0 0 4 0 6 4 0  0 0 0 0 0",
"90 91 84     1 1 2 0   0 0 0 0 0  0 2 6 3 7 1 0  0 0 0 2 5 0 0  0 0 0 0 0",
"91 92 89     0 0 2 0   0 0 1 0 0  0 0 3 7 5 0 0  0 2 5 0 4 0 0  0 0 0 0 0",
"92 93 88     1 0 3 1   0 0 0 0 0  0 2 7 3 4 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"93 94 87     1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  0 2 7 6 3 4 0  0 0 0 0 0",
"94 95 86     1 0 3 0   0 0 0 0 0  0 0 1 0 3 1 0  0 0 6 7 5 0 0  0 0 4 0 0",
"95 90 85     0 0 2 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 2 6 7 4 0  0 0 0 0 0",
"96 97 102    1 2 2 0   0 0 0 0 0  0 2 7 3 6 1 0  0 2 5 0 0 0 0  0 0 0 0 0",
"97 98 107    0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"98 99 106    1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 3 4 0  0 0 4 0 0",
"99 100 105   1 0 2 0   0 0 0 0 0  0 0 0 0 3 1 0  0 2 3 6 7 4 0  0 0 0 0 0",
"100 101 104  0 0 3 2   1 0 0 0 0  0 6 7 1 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"101 96 103   1 0 3 0   0 0 0 0 0  0 0 1 0 0 0 0  2 6 7 5 0 0 0  0 0 6 4 0",
"102 103 96   1 1 2 0   0 0 0 0 0  0 2 6 3 7 1 0  0 0 0 0 6 4 0  0 0 0 0 0",
"103 104 101  0 0 2 0   0 0 1 0 0  0 0 3 7 6 1 0  0 2 5 0 0 0 0  0 0 0 0 0",
"104 105 100  0 0 3 1   0 0 1 0 0  0 2 7 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"105 106 99   1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 6 3 4 0  0 0 0 0 0",
"106 107 98   0 0 2 0   0 0 3 1 0  2 3 7 5 0 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"107 102 97   0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"108 109 114  1 2 2 0   0 0 0 0 0  0 0 2 3 7 3 4  0 0 0 2 5 0 0  0 0 0 0 0",
"109 110 119  0 0 2 0   0 0 3 1 0  0 0 3 7 5 0 0  0 0 4 0 4 0 0  0 0 0 0 0",
"110 111 118  0 0 2 0   1 0 0 0 0  0 6 7 3 4 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"111 112 117  1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  2 6 7 6 1 0 0  0 0 0 0 0",
"112 113 116  1 0 3 2   0 0 0 0 0  0 0 1 0 1 0 0  0 0 6 7 5 0 0  0 2 5 0 0",
"113 108 115  1 0 3 0   0 0 0 0 0  0 0 0 2 5 0 0  0 0 2 6 7 5 0  0 0 0 0 4",
"114 115 108  1 1 2 0   0 0 0 0 0  2 3 7 3 4 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"115 116 113  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  0 3 7 6 1 0 0  4 0 0 0 0",
"116 117 112  1 0 3 1   0 0 0 0 0  0 0 1 0 1 0 0  0 0 6 7 5 0 0  0 0 6 4 0",
"117 118 111  1 0 2 0   0 0 0 0 0  0 0 0 2 5 0 0  0 0 2 6 7 6 1  0 0 0 0 0",
"118 119 110  0 0 2 0   0 0 0 0 1  0 0 2 3 7 5 0  0 0 0 2 5 0 0  0 0 0 0 0",
"119 114 109  0 0 2 0   0 2 5 0 0  0 0 3 7 5 0 0  0 0 4 0 4 0 0  0 0 0 0 0",
"120 121 126  1 2 2 0   0 0 0 0 0  0 0 3 3 7 3 4  0 0 4 0 4 0 0  0 0 0 0 0",
"121 122 131  0 0 2 0   0 0 3 1 0  0 0 3 7 4 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"122 123 130  0 0 2 0   1 0 0 0 0  0 6 7 1 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"123 124 129  1 0 2 0   0 0 0 0 0  0 0 1 0 1 0 0  2 6 7 6 5 0 0  0 0 0 0 0",
"124 125 128  1 0 3 2   0 0 0 0 0  0 0 0 2 5 0 0  0 0 2 7 5 0 0  0 2 5 0 0",
"125 120 127  1 0 3 0   0 0 0 0 0  0 0 2 3 5 0 0  0 0 0 2 7 5 0  0 0 0 0 4",
"126 127 120  1 1 2 0   0 0 0 0 0  2 3 7 3 5 0 0  0 0 4 0 4 0 0  0 0 0 0 0",
"127 128 125  1 0 3 0   0 0 0 0 0  0 0 3 3 4 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"128 129 124  1 0 3 1   0 0 0 0 0  0 0 3 1 0 0 0  0 0 6 7 1 0 0  0 0 6 4 0",
"129 130 123  1 0 2 0   0 0 0 0 0  0 0 1 0 1 0 0  0 0 6 6 7 6 1  0 0 0 0 0",
"130 131 122  0 0 2 0   0 0 0 0 1  0 0 0 2 7 5 0  0 0 2 6 5 0 0  0 0 0 0 0",
"131 126 121  0 0 2 0   0 2 5 0 0  0 0 2 7 5 0 0  0 0 0 2 5 0 0  0 0 0 0 0",
"132 133 138  1 2 2 0   0 0 0 0 0  0 0 3 3 6 3 4  0 0 6 4 0 0 0  0 0 0 0 0",
"133 134 143  0 0 2 0   0 0 3 1 0  0 0 3 5 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"134 135 142  0 0 2 0   1 0 0 0 0  0 6 5 0 1 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"135 136 143  1 0 2 0   0 0 0 0 0  0 0 0 2 5 0 0  2 6 3 6 5 0 0  0 0 0 0 0",
"136 137 140  1 0 3 2   0 0 0 0 0  0 0 2 3 5 0 0  0 0 0 3 5 0 0  0 2 5 0 0",
"137 132 139  1 0 3 0   0 0 0 0 0  0 0 3 3 5 0 0  0 0 4 0 6 5 0  0 0 0 0 4",
"138 139 132  1 1 2 0   0 0 0 0 0  2 3 6 3 5 0 0  0 0 0 2 5 0 0  0 0 0 0 0",
"139 140 137  1 0 3 0   0 0 0 0 0  0 0 3 3 5 0 0  0 3 5 0 4 0 0  4 0 0 0 0",
"140 143 136  1 0 3 1   0 0 0 0 0  0 0 3 3 4 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"141 142 135  1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  0 0 6 6 3 6 1  0 0 0 0 0",
"142 143 134  0 0 2 0   0 0 0 0 1  0 0 1 0 3 5 0  0 0 6 6 5 0 0  0 0 0 0 0",
"143 138 133  0 0 2 0   0 2 5 0 0  0 0 0 6 5 0 0  0 0 2 6 5 0 0  0 0 0 0 0",
"144 145 150  1 2 2 0   0 0 0 0 0  0 0 3 3 6 3 4  0 2 5 0 0 0 0  0 0 0 0 0",
"145 146 155  0 0 3 0   0 0 3 1 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"146 147 154  0 0 2 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"147 148 153  1 0 2 0   0 0 0 0 0  0 0 0 0 3 1 0  2 6 3 6 5 0 0  0 0 0 0 0",
"148 149 152  0 0 3 2   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 2 5 0 0",
"149 144 151  1 0 3 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 0 6 5 0  0 0 0 0 4",
"150 151 144  1 1 2 0   0 0 0 0 0  2 3 6 3 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"151 152 149  1 0 3 0   0 0 0 0 0  0 0 3 3 6 1 0  0 3 5 0 0 0 0  4 0 0 0 0",
"152 153 148  0 0 3 1   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"153 154 147  1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 6 3 6 1  0 0 0 0 0",
"154 155 146  0 0 2 0   0 0 0 0 1  0 0 0 0 3 5 0  0 2 3 6 5 0 0  0 0 0 0 0",
"155 150 145  0 0 3 0   0 2 5 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"156 157 156  1 2 2 0   0 0 0 0 0  3 3 6 3 5 0 0  4 0 0 0 4 0 0  0 0 0 0 0",
"157 158 161  0 0 2 0   3 3 4 0 0  3 5 0 0 0 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"158 159 160  1 0 3 0   0 0 0 0 0  3 1 0 0 0 0 0  6 5 0 0 0 0 0  6 6 1 0 0",
"159 160 159  1 0 2 0   0 0 0 0 0  1 0 0 0 1 0 0  6 6 3 6 5 0 0  0 0 0 0 0",
"160 161 158  0 0 2 0   0 2 5 0 0  0 0 3 5 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"161 156 157  1 0 3 2   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"162 163 168  1 2 2 0   0 0 0 0 0  0 0 3 3 6 1 0  2 6 5 0 0 0 0  0 0 0 0 0",
"163 164 173  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"164 165 172  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 6 3 5 0  0 0 0 0 4",
"165 166 171  1 0 2 0   0 0 0 0 0  0 0 0 0 3 3 4  0 2 3 6 5 0 0  0 0 0 0 0",
"166 167 170  0 0 3 2   0 0 3 1 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"167 162 169  0 0 2 0   1 0 0 0 0  0 6 6 3 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"168 169 162  1 1 2 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 0 6 6 1  0 0 0 0 0",
"169 170 167  0 0 2 0   0 0 0 0 1  0 0 3 3 6 5 0  0 2 5 0 0 0 0  0 0 0 0 0",
"170 171 166  0 0 3 1   0 2 5 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"171 172 165  1 0 2 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"172 173 164  1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 3 3 6 5 0 0  4 0 0 0 0",
"173 168 163  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 6 4 0",
"174 175 180  1 2 2 0   0 0 0 0 0  0 0 0 2 7 3 4  0 0 2 6 5 0 0  0 0 0 0 0",
"175 176 185  0 0 2 0   0 0 3 1 0  0 0 2 7 5 0 0  0 0 0 2 5 0 0  0 0 0 0 0",
"176 177 184  0 0 2 0   1 0 0 0 0  0 6 7 3 5 0 0  0 0 4 0 4 0 0  0 0 0 0 0",
"177 178 183  1 0 2 0   0 0 0 0 0  0 0 3 3 4 0 0  2 6 7 4 0 0 0  0 0 0 0 0",
"178 179 182  1 0 3 2   0 0 0 0 0  0 0 3 1 0 0 0  0 0 6 7 1 0 0  0 2 5 0 0",
"179 174 181  1 0 3 0   0 0 0 0 0  0 0 1 0 1 0 0  0 0 6 6 7 5 0  0 0 0 0 4",
"180 181 174  1 1 2 0   0 0 0 0 0  2 3 7 1 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"181 182 179  1 0 3 0   0 0 0 0 0  0 0 1 0 1 0 0  0 3 7 6 5 0 0  4 0 0 0 0",
"182 183 178  1 0 3 1   0 0 0 0 0  0 0 0 2 5 0 0  0 0 2 7 5 0 0  0 0 6 4 0",
"183 184 177  1 0 2 0   0 0 0 0 0  0 0 2 3 5 0 0  0 0 0 2 7 6 1  0 0 0 0 0",
"184 185 176  0 0 2 0   0 0 0 0 1  0 0 3 3 7 5 0  0 0 4 0 4 0 0  0 0 0 0 0",
"185 180 175  0 0 2 0   0 2 5 0 0  0 0 3 7 4 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"186 187 192  1 2 2 0   0 0 0 0 0  0 2 7 3 5 0 0  0 0 4 0 6 4 0  0 0 0 0 0",
"187 188 197  1 0 2 0   0 0 0 0 0  0 0 3 3 6 1 0  0 2 7 4 0 0 0  0 0 0 0 0",
"188 189 196  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"189 190 195  1 0 2 0   0 0 0 0 0  0 2 5 0 1 0 0  0 0 6 6 7 4 0  0 0 0 0 0",
"190 191 194  1 0 2 0   0 0 0 0 0  0 0 0 2 7 1 0  0 2 3 6 5 0 0  0 0 0 0 0",
"191 186 193  0 0 3 2   0 0 1 0 0  0 0 2 7 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"192 193 186  1 1 2 0   0 0 0 0 0  0 0 3 3 7 1 0  0 2 5 0 4 0 0  0 0 0 0 0",
"193 194 191  0 0 3 1   0 0 1 0 0  0 0 3 7 4 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"194 195 190  1 0 2 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"195 196 189  1 0 2 0   0 0 0 0 0  0 0 1 0 3 1 0  0 2 7 6 5 0 0  0 0 0 0 0",
"196 197 188  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 2 7 5 0 0  0 0 4 0 0",
"197 192 187  1 0 2 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 2 7 4 0  0 0 0 0 0",
"198 199 204  1 2 2 0   0 0 0 0 0  0 2 7 3 4 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"199 200 209  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  0 2 7 7 1 0 0  0 0 4 0 0",
"200 201 208  1 0 3 0   0 0 0 0 0  0 0 1 0 1 0 0  0 0 6 7 7 4 0  0 0 4 0 0",
"201 202 207  1 0 2 0   0 0 0 0 0  0 0 0 2 7 1 0  0 0 2 6 7 4 0  0 0 0 0 0",
"202 203 206  0 0 2 2   0 0 1 0 0  0 0 2 7 7 1 0  0 0 0 2 5 0 0  0 0 0 0 0",
"203 198 205  0 0 2 0   0 0 1 0 0  0 2 7 7 5 0 0  0 0 4 0 4 0 0  0 0 0 0 0",
"204 205 198  1 1 2 0   0 0 0 0 0  0 0 2 3 7 1 0  0 0 0 2 7 4 0  0 0 0 0 0",
"205 206 203  0 0 2 0   0 0 1 0 0  0 0 3 7 7 1 0  0 0 4 0 4 0 0  0 0 0 0 0",
"206 207 202  0 0 2 1   0 0 1 0 0  0 2 7 7 4 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"207 208 201  1 0 2 0   0 0 0 0 0  0 2 7 1 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"208 209 200  1 0 3 0   0 0 0 0 0  0 0 1 0 1 0 0  0 2 7 7 5 0 0  0 0 4 0 0",
"209 204 199  1 0 3 0   0 0 0 0 0  0 0 0 2 5 0 0  0 0 2 7 7 4 0  0 0 4 0 0",
"210 211 210  1 2 3 2   0 0 0 0 0  0 0 3 3 5 0 0  0 0 6 7 5 0 0  0 0 4 0 0",
"211 212 215  1 0 2 0   0 0 0 0 0  0 0 3 3 5 0 0  0 0 6 6 7 4 0  0 0 0 0 0",
"212 213 214  1 0 2 0   0 0 0 0 0  0 0 3 3 7 1 0  0 0 6 6 5 0 0  0 0 0 0 0",
"213 214 213  0 0 2 0   0 0 1 0 0  0 0 3 7 5 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"214 215 212  1 0 2 0   0 0 0 0 0  0 2 7 3 5 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"215 210 211  1 0 2 0   0 0 0 0 0  0 0 3 3 5 0 0  0 2 7 6 5 0 0  0 0 0 0 0",
"216 216 217  0 2 2 2   1 0 0 0 0  0 6 7 3 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"217 217 216  1 1 3 1   0 0 0 0 0  0 2 5 0 0 0 0  0 3 7 6 1 0 0  4 0 0 0 0",
"218 219 218  1 2 2 0   0 0 0 0 0  0 0 3 3 5 0 0  0 2 5 0 6 4 0  0 0 0 0 0",
"219 220 223  1 0 3 0   0 0 0 0 0  0 0 3 3 6 1 0  0 0 6 5 0 0 0  0 0 4 0 0",
"220 221 222  0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"221 222 221  1 0 2 0   0 0 0 0 0  0 2 5 0 3 1 0  0 0 6 6 5 0 0  0 0 0 0 0",
"222 223 220  0 0 2 0   0 0 1 0 0  0 0 0 6 5 0 0  0 2 3 6 5 0 0  0 0 0 0 0",
"223 218 219  1 0 3 2   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"224 225 230  1 2 2 0   0 0 0 0 0  0 0 3 3 7 1 0  0 0 4 0 6 4 0  0 0 0 0 0",
"225 226 235  0 0 2 1   0 0 1 0 0  0 0 3 7 6 1 0  0 0 6 4 0 0 0  0 0 0 0 0",
"226 227 234  0 0 2 0   0 0 1 0 0  0 2 7 5 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"227 228 233  1 0 2 0   0 0 0 0 0  0 2 5 0 1 0 0  0 2 7 6 5 0 0  0 0 0 0 0",
"228 229 232  1 0 3 0   0 0 0 0 0  0 0 0 2 5 0 0  0 2 3 7 5 0 0  0 0 4 0 0",
"229 224 231  1 0 3 0   0 0 0 0 0  0 0 2 3 5 0 0  0 0 0 3 7 4 0  0 0 4 0 0",
"230 231 224  1 1 2 0   0 0 0 0 0  0 2 7 3 5 0 0  0 2 5 0 4 0 0  0 0 0 0 0",
"231 232 229  1 0 3 0   0 0 0 0 0  0 0 3 3 4 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"232 233 228  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  0 0 6 7 3 4 0  0 0 4 0 0",
"233 234 227  1 0 2 0   0 0 0 0 0  0 0 1 0 3 1 0  0 0 6 6 7 4 0  0 0 0 0 0",
"234 235 226  0 0 2 0   0 0 1 0 0  0 0 0 6 7 1 0  0 0 2 6 5 0 0  0 0 0 0 0",
"235 230 225  0 0 2 2   0 0 1 0 0  0 2 6 7 5 0 0  0 0 0 2 5 0 0  0 0 0 0 0",
"236 237 242  1 2 2 0   0 0 0 0 0  0 0 3 3 5 0 0  0 0 4 0 6 6 1  0 0 0 0 0",
"237 238 247  0 0 2 0   0 0 0 0 1  0 0 3 3 6 5 0  0 0 6 4 0 0 0  0 0 0 0 0",
"238 239 246  0 0 2 0   0 2 5 0 0  0 0 3 5 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"239 240 245  1 0 2 0   0 0 0 0 0  2 3 5 0 1 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"240 241 244  1 0 3 0   0 0 0 0 0  0 0 0 2 5 0 0  0 3 3 6 5 0 0  4 0 0 0 0",
"241 236 243  1 0 3 1   0 0 0 0 0  0 0 2 3 5 0 0  0 0 0 3 5 0 0  0 0 6 4 0",
"242 243 236  1 1 2 0   0 0 0 0 0  0 0 3 3 5 0 0  2 6 5 0 4 0 0  0 0 0 0 0",
"243 244 241  1 0 3 2   0 0 0 0 0  0 0 3 3 4 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"244 245 240  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  0 0 6 6 3 5 0  0 0 0 0 4",
"245 246 239  1 0 2 0   0 0 0 0 0  0 0 1 0 3 3 4  0 0 6 6 5 0 0  0 0 0 0 0",
"246 247 238  0 0 2 0   0 0 3 1 0  0 0 0 6 5 0 0  0 0 2 6 5 0 0  0 0 0 0 0",
"247 242 237  0 0 2 0   1 0 0 0 0  0 6 6 3 5 0 0  0 0 0 2 5 0 0  0 0 0 0 0",
"# 8 651",
"0 1 6        1 2 2 0   0 0 0 0 0  3 3 6 3 6 3 4  4 0 0 0 0 0 0  0 0 0 0 0",
"1 2 11       0 0 3 2   0 0 3 1 0  0 0 3 5 0 0 0  0 3 5 0 0 0 0  6 4 0 0 0",
"2 3 10       0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 5 0 0 0  0 0 6 6 1",
"3 4 9        1 0 2 0   0 0 0 0 0  0 0 0 0 0 0 1  2 6 3 6 3 6 5  0 0 0 0 0",
"4 5 8        0 0 3 0   0 0 0 2 5  0 0 0 0 3 5 0  0 0 0 3 5 0 0  0 2 5 0 0",
"5 0 7        0 0 3 0   2 3 5 0 0  0 0 0 6 5 0 0  0 0 0 0 6 5 0  0 0 0 0 4",
"6 7 0        1 1 2 0   0 0 0 0 0  2 3 6 3 6 3 5  0 0 0 0 0 0 4  0 0 0 0 0",
"7 8 5        0 0 3 0   0 0 3 3 4  0 0 3 5 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"8 9 4        0 0 3 0   3 1 0 0 0  0 6 5 0 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"9 10 3       1 0 2 0   0 0 0 0 0  1 0 0 0 0 0 0  6 6 3 6 3 6 1  0 0 0 0 0",
"10 11 2      0 0 3 0   0 0 0 0 1  0 0 0 0 3 5 0  0 0 0 3 5 0 0  2 6 5 0 0",
"11 6 1       0 0 3 1   0 2 5 0 0  0 0 0 6 5 0 0  0 0 0 0 6 5 0  0 0 0 2 5",
"12 13 18     1 2 2 0   0 0 0 0 0  2 3 7 3 6 3 4  0 0 4 0 0 0 0  0 0 0 0 0",
"13 14 23     0 0 3 2   0 0 3 1 0  0 0 3 5 0 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"14 15 22     0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 7 1 0 0  0 0 6 4 0",
"15 16 21     1 0 2 0   0 0 0 0 0  0 0 0 0 1 0 0  2 6 3 6 7 6 1  0 0 0 0 0",
"16 17 20     0 0 3 0   0 0 0 0 1  0 0 0 2 7 5 0  0 0 0 3 5 0 0  0 2 5 0 0",
"17 12 19     0 0 3 0   0 2 5 0 0  0 0 2 7 5 0 0  0 0 0 0 6 5 0  0 0 0 0 4",
"18 19 12     1 1 2 0   0 0 0 0 0  2 3 6 3 7 3 4  0 0 0 0 4 0 0  0 0 0 0 0",
"19 20 17     0 0 3 0   0 0 3 1 0  0 0 3 7 4 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"20 21 16     0 0 3 0   1 0 0 0 0  0 6 7 1 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"21 22 15     1 0 2 0   0 0 0 0 0  0 0 1 0 0 0 0  2 6 7 6 3 6 1  0 0 0 0 0",
"22 23 14     0 0 3 0   0 0 0 0 1  0 0 0 0 3 5 0  0 0 2 7 5 0 0  0 2 5 0 0",
"23 18 13     0 0 3 1   0 2 5 0 0  0 0 0 6 5 0 0  0 0 0 2 7 5 0  0 0 0 0 4",
"24 25 30     2 2 3 0   0 0 0 0 0  0 0 0 0 0 0 0  2 7 3 6 3 6 1  4 0 0 0 0",
"25 26 35     0 0 3 0   0 0 0 0 1  0 0 0 0 3 5 0  0 0 0 3 5 0 0  0 2 7 4 0",
"26 27 34     0 0 3 0   0 2 5 0 0  0 0 0 6 5 0 0  0 0 0 0 6 7 1  0 0 0 0 4",
"27 28 33     0 0 1 0   0 0 0 0 1  2 3 6 3 6 7 4  0 0 0 0 0 0 0  0 0 0 0 0",
"28 29 32     0 0 3 2   0 2 7 1 0  0 0 3 5 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"29 24 31     0 0 3 0   1 0 0 0 0  2 7 5 0 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"30 31 24     2 1 3 0   0 0 0 0 0  0 0 0 0 0 0 0  2 6 3 6 3 7 1  0 0 0 0 4",
"31 32 29     0 0 3 0   0 0 0 0 1  0 0 0 0 3 7 4  0 0 0 3 5 0 0  0 2 5 0 0",
"32 33 28     0 0 3 1   0 2 7 1 0  0 0 0 6 5 0 0  0 0 0 0 6 5 0  0 0 0 0 4",
"33 34 27     0 0 1 0   1 0 0 0 0  2 7 6 3 6 3 4  0 0 0 0 0 0 0  0 0 0 0 0",
"34 35 26     0 0 3 0   0 0 3 1 0  0 0 3 5 0 0 0  2 7 5 0 0 0 0  4 0 0 0 0",
"35 30 25     0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 5 0 0 0  0 2 7 4 0",
"36 37 36     2 2 3 0   0 0 0 0 0  0 0 0 0 0 0 0  2 6 3 7 3 6 1  0 0 4 0 0",
"37 38 41     0 0 3 0   0 0 0 0 1  0 0 0 0 3 5 0  0 0 0 3 7 4 0  0 2 5 0 0",
"38 39 40     0 0 3 0   0 2 5 0 0  0 0 0 6 7 1 0  0 0 0 0 6 5 0  0 0 0 0 4",
"39 40 39     0 0 1 0   0 0 1 0 0  2 3 6 7 6 3 4  0 0 0 0 0 0 0  0 0 0 0 0",
"40 41 38     0 0 3 2   0 0 3 1 0  0 2 7 5 0 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"41 36 37     0 0 3 2   1 0 0 0 0  0 6 5 0 0 0 0  0 2 7 5 0 0 0  0 0 6 4 0",
"42 43 48     1 2 2 0   0 0 0 0 0  3 3 6 3 7 1 0  4 0 0 0 4 0 0  0 0 0 0 0",
"43 44 53     0 0 3 0   0 0 1 0 0  0 0 3 7 4 0 0  0 3 5 0 0 0 0  6 4 0 0 0",
"44 45 52     1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 5 0 0 0  0 0 6 6 1",
"45 46 51     1 0 2 0   0 0 0 0 0  0 0 1 0 0 0 1  0 2 7 6 3 6 5  0 0 0 0 0",
"46 47 50     0 0 3 2   0 0 0 2 5  0 0 0 0 3 5 0  0 0 2 7 5 0 0  0 0 4 0 0",
"47 42 49     0 0 2 0   2 3 5 0 0  0 0 0 6 5 0 0  0 0 0 2 7 4 0  0 0 0 0 0",
"48 49 42     1 1 2 0   0 0 0 0 0  0 2 7 3 6 3 5  0 0 4 0 0 0 4  0 0 0 0 0",
"49 50 47     0 0 2 0   0 0 3 3 4  0 0 3 5 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"50 51 46     0 0 3 1   3 1 0 0 0  0 6 5 0 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"51 52 45     1 0 2 0   0 0 0 0 0  1 0 0 0 1 0 0  6 6 3 6 7 4 0  0 0 0 0 0",
"52 53 44     1 0 3 0   0 0 0 0 0  0 0 0 2 7 1 0  0 0 0 3 5 0 0  2 6 5 0 0",
"53 48 43     0 0 3 0   0 0 1 0 0  0 0 2 7 5 0 0  0 0 0 0 6 5 0  0 0 0 2 5",
"54 55 60     1 2 2 0   0 0 0 0 0  3 3 7 3 6 1 0  4 0 4 0 0 0 0  0 0 0 0 0",
"55 56 65     0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 3 7 4 0 0 0  6 4 0 0 0",
"56 57 64     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 1 0 0  0 0 6 6 1",
"57 58 63     1 0 2 0   0 0 0 0 0  0 0 0 0 1 0 1  0 2 3 6 7 6 5  0 0 0 0 0",
"58 59 62     0 0 3 2   0 0 0 2 5  0 0 0 2 7 5 0  0 0 0 3 5 0 0  0 0 4 0 0",
"59 54 61     0 0 2 0   2 3 5 0 0  0 0 2 7 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"60 61 54     1 1 2 0   0 0 0 0 0  0 2 6 3 7 3 5  0 0 0 0 4 0 4  0 0 0 0 0",
"61 62 59     0 0 2 0   0 0 3 3 4  0 0 3 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"62 63 58     0 0 3 1   3 1 0 0 0  0 6 7 1 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"63 64 57     1 0 2 0   0 0 0 0 0  1 0 1 0 0 0 0  6 6 7 6 3 4 0  0 0 0 0 0",
"64 65 56     1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 0 2 7 5 0 0  2 6 5 0 0",
"65 60 55     0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 2 7 5 0  0 0 0 2 5",
"66 67 72     1 2 2 0   0 0 0 0 0  3 3 6 3 6 1 0  6 4 0 0 0 0 0  0 0 0 0 0",
"67 68 77     0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 3 5 0 0 0 0  6 6 1 0 0",
"68 69 76     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 5 0 1 0  0 0 6 6 5",
"69 70 75     1 0 2 0   0 0 0 0 0  0 0 0 0 0 2 5  0 2 3 6 3 6 5  0 0 0 0 0",
"70 71 74     0 0 3 2   0 0 2 3 5  0 0 0 0 3 5 0  0 0 0 3 5 0 0  0 0 4 0 0",
"71 66 73     0 0 2 0   3 3 5 0 0  0 4 0 6 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"72 73 66     1 1 2 0   0 0 0 0 0  0 2 6 3 6 3 5  0 0 0 0 0 2 5  0 0 0 0 0",
"73 74 71     0 0 2 0   0 0 3 3 5  0 0 3 5 0 4 0  0 2 5 0 0 0 0  0 0 0 0 0",
"74 75 70     0 0 3 1   3 3 4 0 0  0 6 5 0 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"75 76 69     1 0 2 0   0 0 0 0 0  3 1 0 0 0 0 0  6 6 3 6 3 4 0  0 0 0 0 0",
"76 77 68     1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 1 0 3 5 0 0  6 6 5 0 0",
"77 72 67     0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 0 6 5 0  0 0 2 6 5",
"78 79 84     0 2 2 0   1 0 0 0 0  3 7 6 3 6 1 0  4 0 0 0 0 0 0  0 0 0 0 0",
"79 80 89     0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  2 7 5 0 0 0 0  6 4 0 0 0",
"80 81 88     1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 5 0 0 0  0 2 7 6 1",
"81 82 87     1 0 3 0   0 0 0 0 0  0 0 0 0 0 0 1  0 2 3 6 3 7 5  0 0 0 0 4",
"82 83 86     0 0 3 2   0 0 0 2 5  0 0 0 0 3 7 4  0 0 0 3 5 0 0  0 0 4 0 0",
"83 78 85     0 0 2 0   2 3 7 1 0  0 0 0 6 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"84 85 78     0 1 2 0   0 0 0 0 1  0 2 6 3 6 7 5  0 0 0 0 0 0 4  0 0 0 0 0",
"85 86 83     0 0 2 0   0 2 7 3 4  0 0 3 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"86 87 82     0 0 3 1   3 1 0 0 0  2 7 5 0 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"87 88 81     1 0 3 0   0 0 0 0 0  1 0 0 0 0 0 0  6 7 3 6 3 4 0  4 0 0 0 0",
"88 89 80     1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 0 0 3 5 0 0  2 6 7 4 0",
"89 84 79     0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 0 6 7 1  0 0 0 2 5",
"90 91 96     0 2 2 0   0 0 1 0 0  3 3 6 7 6 1 0  4 0 0 0 0 0 0  0 0 0 0 0",
"91 92 101    0 0 3 2   0 0 1 0 0  0 2 7 5 0 0 0  0 3 5 0 0 0 0  6 4 0 0 0",
"92 93 100    1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 5 0 0 0  0 0 6 6 1",
"93 94 99     1 0 3 0   0 0 0 0 0  0 0 0 0 0 0 1  0 2 3 7 3 6 5  0 0 4 0 0",
"94 95 98     0 0 3 0   0 0 0 2 5  0 0 0 0 3 5 0  0 0 0 3 7 4 0  0 0 4 0 0",
"95 90 97     0 0 2 0   2 3 5 0 0  0 0 0 6 7 1 0  0 0 0 0 6 4 0  0 0 0 0 0",
"96 97 90     0 1 2 0   0 0 1 0 0  0 2 6 7 6 3 5  0 0 0 0 0 0 4  0 0 0 0 0",
"97 98 95     0 0 2 0   0 0 3 3 4  0 2 7 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"98 99 94     0 0 3 0   3 1 0 0 0  0 6 5 0 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"99 100 93    1 0 3 0   0 0 0 0 0  1 0 0 0 0 0 0  6 6 3 7 3 4 0  0 0 4 0 0",
"100 101 92   1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 0 0 3 7 4 0  2 6 5 0 0",
"101 96 91    0 0 3 1   0 0 1 0 0  0 0 0 6 7 1 0  0 0 0 0 6 5 0  0 0 0 2 5",
"102 103 105  0 2 2 0   0 0 0 0 1  3 3 6 3 6 5 0  4 0 0 0 0 0 0  0 0 0 0 0",
"103 104 107  0 0 3 2   0 2 5 0 0  0 0 3 5 0 0 0  0 3 5 0 0 0 0  6 4 0 0 0",
"104 102 106  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 5 0 0 0  0 0 6 6 1",
"105 106 102  1 1 3 0   0 0 0 0 0  1 0 0 0 0 0 0  6 6 3 6 3 5 0  0 0 0 0 4",
"106 107 104  0 0 2 0   0 0 3 3 4  0 0 3 5 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"107 105 103  0 0 3 1   3 1 0 0 0  0 6 5 0 0 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"108 109 114  1 2 2 0   0 0 0 0 0  2 3 7 3 7 1 0  0 0 4 0 4 0 0  0 0 0 0 0",
"109 110 119  0 0 3 2   0 0 1 0 0  0 0 3 7 4 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"110 111 118  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 7 1 0 0  0 0 6 4 0",
"111 112 117  1 0 2 0   0 0 0 0 0  0 0 1 0 1 0 0  0 2 7 6 7 6 1  0 0 0 0 0",
"112 113 116  0 0 3 0   0 0 0 0 1  0 0 0 2 7 5 0  0 0 2 7 5 0 0  0 0 4 0 0",
"113 108 115  0 0 2 0   0 2 5 0 0  0 0 2 7 5 0 0  0 0 0 2 7 4 0  0 0 0 0 0",
"114 115 108  1 1 2 0   0 0 0 0 0  0 2 7 3 7 3 4  0 0 4 0 4 0 0  0 0 0 0 0",
"115 116 113  0 0 2 0   0 0 3 1 0  0 0 3 7 4 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"116 117 112  0 0 3 0   1 0 0 0 0  0 6 7 1 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"117 118 111  1 0 2 0   0 0 0 0 0  0 0 1 0 1 0 0  2 6 7 6 7 4 0  0 0 0 0 0",
"118 119 110  1 0 3 0   0 0 0 0 0  0 0 0 2 7 1 0  0 0 2 7 5 0 0  0 2 5 0 0",
"119 114 109  0 0 3 2   0 0 1 0 0  0 0 2 7 5 0 0  0 0 0 2 7 5 0  0 0 0 0 4",
"120 121 123  0 2 2 0   0 0 1 0 0  2 3 7 7 6 1 0  0 0 4 0 0 0 0  0 0 0 0 0",
"121 122 125  0 0 3 2   0 0 1 0 0  0 2 7 5 0 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"122 120 124  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 7 1 0 0  0 0 6 4 0",
"123 124 120  1 1 3 0   0 0 0 0 0  0 0 1 0 0 0 0  2 6 7 7 3 4 0  0 0 4 0 0",
"124 125 122  0 0 2 0   0 0 3 1 0  0 2 7 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"125 123 121  0 0 3 1   1 0 0 0 0  0 6 7 1 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"126 127 132  0 2 2 0   1 0 0 0 0  2 7 7 3 6 1 0  0 0 4 0 0 0 0  0 0 0 0 0",
"127 128 137  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  2 7 7 4 0 0 0  4 0 0 0 0",
"128 129 136  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 1 0 0  0 2 7 4 0",
"129 130 135  1 0 3 0   0 0 0 0 0  0 0 0 0 1 0 0  0 2 3 6 7 7 1  0 0 0 0 4",
"130 131 134  0 0 3 0   0 0 0 0 1  0 0 0 2 7 7 4  0 0 0 3 5 0 0  0 0 4 0 0",
"131 126 133  0 0 3 2   1 0 0 0 0  2 7 7 1 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"132 133 126  0 1 2 0   0 0 0 0 1  0 2 6 3 7 7 4  0 0 0 0 4 0 0  0 0 0 0 0",
"133 134 131  0 0 3 1   0 0 0 0 1  0 0 0 2 7 7 4  0 0 0 3 5 0 0  0 0 4 0 0",
"134 135 130  0 0 3 0   1 0 0 0 0  2 7 7 1 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"135 136 129  1 0 3 0   0 0 0 0 0  0 0 1 0 0 0 0  2 7 7 6 3 4 0  4 0 0 0 0",
"136 137 128  1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 0 2 7 5 0 0  0 2 7 4 0",
"137 132 127  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 2 7 7 1  0 0 0 0 4",
"138 139 144  0 2 2 0   0 0 0 0 0  2 3 7 3 6 1 0  0 2 5 0 0 0 0  0 0 0 0 0",
"139 140 149  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 3 7 5 0 0 0  4 0 4 0 0",
"140 141 148  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 3 4 0  0 0 6 4 0",
"141 142 147  1 0 2 0   0 0 0 0 0  0 0 0 0 3 1 0  0 2 3 6 7 6 1  0 0 0 0 0",
"142 143 146  0 0 3 2   0 0 1 0 1  0 0 0 6 7 5 0  0 0 0 3 5 0 0  0 0 4 0 0",
"143 138 145  0 0 2 0   0 2 5 0 0  0 2 6 7 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"144 145 138  1 1 2 0   0 0 0 0 0  0 2 6 3 7 3 4  0 0 0 0 6 4 0  0 0 0 0 0",
"145 146 143  0 0 2 0   0 0 3 1 0  0 0 3 7 6 1 0  0 2 5 0 0 0 0  0 0 0 0 0",
"146 147 142  0 0 3 1   1 0 1 0 0  0 6 7 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"147 148 141  1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 0  2 6 7 6 3 4 0  0 0 0 0 0",
"148 149 140  0 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 2 3 7 5 0 0  0 2 5 0 0",
"149 144 139  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 3 7 5 0  0 0 4 0 4",
"150 151 156  1 2 2 0   0 0 0 0 0  2 3 7 3 6 1 0  0 0 6 4 0 0 0  0 0 0 0 0",
"151 152 161  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 3 7 6 1 0 0  4 0 0 0 0",
"152 153 160  1 0 3 2   0 0 0 0 0  0 2 5 0 1 0 0  0 0 6 7 5 0 0  0 0 6 4 0",
"153 154 159  1 0 2 0   0 0 0 0 0  0 0 0 2 5 0 0  0 2 3 6 7 6 1  0 0 0 0 0",
"154 155 158  0 0 3 0   0 0 0 0 1  0 0 2 3 7 5 0  0 0 0 3 5 0 0  0 0 4 0 0",
"155 150 157  0 0 2 0   0 2 5 0 0  0 0 3 7 5 0 0  0 0 4 0 6 4 0  0 0 0 0 0",
"156 157 150  1 1 2 0   0 0 0 0 0  0 2 6 3 7 3 4  0 0 0 2 5 0 0  0 0 0 0 0",
"157 158 155  0 0 2 0   0 0 3 1 0  0 0 3 7 5 0 0  0 2 5 0 4 0 0  0 0 0 0 0",
"158 159 154  0 0 3 0   1 0 0 0 0  0 6 7 3 4 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"159 160 153  1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  2 6 7 6 3 4 0  0 0 0 0 0",
"160 161 152  1 0 3 2   0 0 0 0 0  0 0 1 0 3 1 0  0 0 6 7 5 0 0  0 2 5 0 0",
"161 156 151  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 2 6 7 5 0  0 0 0 0 4",
"162 163 165  1 2 3 0   0 0 0 0 0  0 0 0 0 1 0 0  2 7 3 6 7 4 0  4 0 0 0 0",
"163 164 167  0 0 2 0   0 2 7 1 0  0 0 3 5 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"164 162 166  0 0 3 1   1 0 0 0 0  2 7 5 0 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"165 166 162  0 1 2 0   1 0 0 0 0  2 7 6 3 7 1 0  0 0 0 0 4 0 0  0 0 0 0 0",
"166 167 164  0 0 3 2   0 0 1 0 0  0 0 3 7 4 0 0  2 7 5 0 0 0 0  4 0 0 0 0",
"167 165 163  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 5 0 0 0  0 2 7 4 0",
"168 169 174  1 2 2 0   0 0 0 0 0  2 3 6 3 7 1 0  0 0 0 0 6 4 0  0 0 0 0 0",
"169 170 179  0 0 3 2   0 0 1 0 0  0 0 3 7 6 1 0  0 3 5 0 0 0 0  4 0 0 0 0",
"170 171 178  0 0 3 0   0 0 1 0 0  0 2 7 5 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"171 172 177  1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 6 3 6 1  0 0 0 0 0",
"172 173 176  0 0 3 0   0 0 0 0 1  0 0 0 0 3 5 0  0 2 3 7 5 0 0  0 0 4 0 0",
"173 168 175  0 0 3 0   0 2 5 0 0  0 0 0 6 5 0 0  0 0 0 3 7 4 0  0 0 4 0 0",
"174 175 168  1 1 2 0   0 0 0 0 0  0 2 7 3 6 3 4  0 2 5 0 0 0 0  0 0 0 0 0",
"175 176 173  0 0 3 0   0 0 3 1 0  0 0 3 5 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"176 177 172  0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 7 3 4 0  0 0 4 0 0",
"177 178 171  1 0 2 0   0 0 0 0 0  0 0 0 0 3 1 0  2 6 3 6 7 4 0  0 0 0 0 0",
"178 179 170  0 0 3 0   0 0 1 0 0  0 0 0 6 7 1 0  0 0 0 3 5 0 0  0 2 5 0 0",
"179 174 169  0 0 3 1   0 0 1 0 0  0 2 6 7 5 0 0  0 0 0 0 6 5 0  0 0 0 0 4",
"180 181 186  1 2 2 0   0 0 0 0 0  2 3 6 3 7 1 0  0 0 0 2 5 0 0  0 0 0 0 0",
"181 182 191  0 0 3 2   0 0 1 0 0  0 0 3 7 5 0 0  0 3 5 0 4 0 0  4 0 0 0 0",
"182 183 190  1 0 3 0   0 0 0 0 0  0 2 7 3 4 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"183 184 189  1 0 2 0   0 0 0 0 0  0 0 3 1 0 0 0  0 2 7 6 3 6 1  0 0 0 0 0",
"184 185 188  0 0 3 0   0 0 0 0 1  0 0 1 0 3 5 0  0 0 6 7 5 0 0  0 0 4 0 0",
"185 180 187  1 0 3 0   0 2 5 0 0  0 0 0 6 5 0 0  0 0 2 6 7 4 0  0 0 0 0 0",
"186 187 180  1 1 2 0   0 0 0 0 0  0 2 7 3 6 3 4  0 0 6 4 0 0 0  0 0 0 0 0",
"187 188 185  1 0 3 0   0 0 3 1 0  0 0 3 5 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"188 189 184  0 0 3 0   1 0 0 0 0  0 6 5 0 1 0 0  0 0 6 7 5 0 0  0 0 4 0 0",
"189 190 183  1 0 2 0   0 0 0 0 0  0 0 0 2 5 0 0  2 6 3 6 7 4 0  0 0 0 0 0",
"190 191 182  1 0 3 0   0 0 0 0 0  0 0 2 3 7 1 0  0 0 0 3 5 0 0  0 2 5 0 0",
"191 186 181  0 0 3 1   0 0 1 0 0  0 0 3 7 5 0 0  0 0 4 0 6 5 0  0 0 0 0 4",
"192 193 198  1 2 3 0   0 0 0 0 0  0 0 1 0 1 0 0  0 3 7 6 7 4 0  4 0 0 0 0",
"193 194 203  1 0 3 0   0 0 0 0 0  0 0 0 2 7 1 0  0 0 2 7 5 0 0  0 0 6 4 0",
"194 195 202  0 0 2 0   0 0 1 0 0  0 0 2 7 5 0 0  0 0 0 2 7 6 1  0 0 0 0 0",
"195 196 201  0 0 2 0   0 0 0 0 1  0 2 7 3 7 5 0  0 0 4 0 4 0 0  0 0 0 0 0",
"196 197 200  0 0 2 0   0 2 5 0 0  0 0 3 7 4 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"197 192 199  1 0 3 2   0 0 0 0 0  2 3 7 1 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"198 199 192  1 1 3 0   0 0 0 0 0  0 0 1 0 1 0 0  0 2 7 6 7 5 0  0 0 0 0 4",
"199 200 197  1 0 3 1   0 0 0 0 0  0 0 0 2 7 3 4  0 0 2 7 5 0 0  0 0 4 0 0",
"200 201 196  0 0 2 0   0 0 3 1 0  0 0 2 7 5 0 0  0 0 0 2 7 4 0  0 0 0 0 0",
"201 202 195  0 0 2 0   1 0 0 0 0  0 6 7 3 7 1 0  0 0 4 0 4 0 0  0 0 0 0 0",
"202 203 194  0 0 2 0   0 0 1 0 0  0 0 3 7 4 0 0  2 6 7 4 0 0 0  0 0 0 0 0",
"203 198 193  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 7 1 0 0  0 2 5 0 0",
"204 205 210  0 2 2 0   1 0 0 0 0  3 7 6 3 5 0 0  4 0 0 0 4 0 0  0 0 0 0 0",
"205 206 215  1 0 3 0   0 0 0 0 0  0 0 3 3 4 0 0  2 7 5 0 0 0 0  6 4 0 0 0",
"206 207 214  0 0 2 0   3 1 0 0 0  0 6 5 0 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"207 208 213  1 0 3 0   0 0 0 0 0  1 0 0 0 1 0 0  6 6 3 7 5 0 0  0 0 4 0 0",
"208 209 212  0 0 2 0   0 2 5 0 0  0 0 3 7 4 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"209 204 211  1 0 3 1   0 0 0 0 0  2 3 7 1 0 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"210 211 204  0 1 2 0   0 0 1 0 0  3 3 6 7 5 0 0  4 0 0 0 4 0 0  0 0 0 0 0",
"211 212 209  1 0 3 2   0 0 0 0 0  0 2 7 3 4 0 0  0 3 5 0 0 0 0  6 4 0 0 0",
"212 213 208  0 0 2 0   3 1 0 0 0  2 7 5 0 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"213 214 207  1 0 3 0   0 0 0 0 0  1 0 0 0 1 0 0  6 7 3 6 5 0 0  4 0 0 0 0",
"214 215 206  0 0 2 0   0 2 5 0 0  0 0 3 5 0 0 0  2 6 7 4 0 0 0  0 0 0 0 0",
"215 210 205  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 7 1 0 0  0 2 5 0 0",
"216 217 222  0 2 2 0   1 0 0 0 0  3 7 7 3 4 0 0  4 0 4 0 0 0 0  0 0 0 0 0",
"217 218 227  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 7 7 4 0 0 0  6 4 0 0 0",
"218 219 226  0 0 2 0   1 0 0 0 0  0 6 7 1 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"219 220 225  1 0 3 0   0 0 0 0 0  0 0 1 0 1 0 0  2 6 7 7 5 0 0  0 0 4 0 0",
"220 221 224  0 0 2 2   0 2 5 0 0  0 2 7 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"221 216 223  1 0 3 0   0 0 0 0 0  2 3 7 1 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"222 223 216  0 1 2 0   0 0 1 0 0  2 3 7 7 5 0 0  0 0 4 0 4 0 0  0 0 0 0 0",
"223 224 221  1 0 3 0   0 0 0 0 0  0 2 7 3 4 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"224 225 220  0 0 2 1   3 1 0 0 0  2 7 7 1 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"225 226 219  1 0 3 0   0 0 0 0 0  1 0 1 0 0 0 0  6 7 7 6 1 0 0  4 0 0 0 0",
"226 227 218  0 0 2 0   0 0 1 0 0  0 2 7 5 0 0 0  2 6 7 4 0 0 0  0 0 0 0 0",
"227 222 217  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 7 1 0 0  0 2 5 0 0",
"228 229 234  0 2 2 0   1 0 0 0 0  3 7 6 3 4 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"229 230 239  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 7 5 0 0 0 0  6 6 1 0 0",
"230 231 238  0 0 2 0   1 0 0 0 0  0 6 5 0 1 0 0  0 2 7 6 5 0 0  0 0 0 0 0",
"231 232 237  1 0 3 0   0 0 0 0 0  0 0 0 2 5 0 0  2 6 3 7 5 0 0  0 0 4 0 0",
"232 233 236  0 0 2 2   2 3 5 0 0  0 0 3 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"233 228 235  1 0 3 0   0 0 0 0 0  3 3 7 1 0 0 0  4 0 6 5 0 0 0  0 0 4 0 0",
"234 235 228  0 1 2 0   0 0 1 0 0  2 3 6 7 5 0 0  0 0 0 2 5 0 0  0 0 0 0 0",
"235 236 233  1 0 3 0   0 0 0 0 0  0 2 7 3 5 0 0  0 3 5 0 4 0 0  4 0 0 0 0",
"236 237 232  0 0 2 1   3 3 4 0 0  2 7 5 0 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"237 238 231  1 0 3 0   0 0 0 0 0  3 1 0 0 0 0 0  6 7 3 6 1 0 0  4 0 0 0 0",
"238 239 230  0 0 2 0   0 0 1 0 0  1 0 3 5 0 0 0  6 6 7 4 0 0 0  0 0 0 0 0",
"239 234 229  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 1 0 0  2 6 5 0 0",
"240 241 246  0 2 2 0   0 0 1 0 0  0 0 3 7 6 3 4  0 2 5 0 0 0 0  0 0 0 0 0",
"241 242 251  0 0 3 1   0 0 3 1 0  0 2 7 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"242 243 250  0 0 2 0   1 0 0 0 0  0 6 5 0 0 0 0  0 2 7 6 3 4 0  0 0 0 0 0",
"243 244 249  1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  2 6 3 7 5 0 0  0 0 4 0 0",
"244 245 248  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 3 7 4 0  0 2 5 0 0",
"245 240 247  1 0 3 0   0 0 0 0 0  0 2 6 3 7 1 0  0 0 0 0 6 5 0  0 0 0 0 4",
"246 247 240  0 1 2 0   0 0 1 0 0  2 3 6 7 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"247 248 245  1 0 3 0   0 0 0 0 0  0 2 7 3 6 1 0  0 3 5 0 0 0 0  4 0 0 0 0",
"248 249 244  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 2 7 5 0 0 0  0 0 6 4 0",
"249 250 243  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 3 6 1  0 0 4 0 0",
"250 251 242  0 0 2 0   0 0 0 0 1  0 0 0 0 3 5 0  0 2 3 6 7 4 0  0 0 0 0 0",
"251 246 241  0 0 3 2   0 2 5 0 0  0 0 0 6 7 1 0  0 0 0 3 5 0 0  0 0 4 0 0",
"252 253 258  1 2 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 3 7 6 3 4 0  4 0 0 0 0",
"253 254 263  0 0 2 0   0 0 3 1 0  2 3 7 5 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"254 255 262  0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 3 7 6 1 0 0  4 0 0 0 0",
"255 256 261  1 0 3 0   0 0 0 0 0  0 0 0 0 1 0 0  2 6 3 7 5 0 0  0 0 6 4 0",
"256 257 260  0 0 2 0   0 2 5 0 0  0 0 3 7 6 1 0  0 2 5 0 0 0 0  0 0 0 0 0",
"257 252 259  0 0 3 1   0 0 1 0 0  2 3 7 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"258 259 252  0 1 2 0   0 0 3 1 0  2 3 6 7 5 0 0  0 0 0 0 4 0 0  0 0 0 0 0",
"259 260 257  0 0 3 2   1 0 0 0 0  0 6 7 3 4 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"260 261 256  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 6 7 5 0 0 0  0 0 6 4 0",
"261 262 255  0 0 2 0   1 0 0 0 0  0 6 7 3 6 1 0  0 2 5 0 0 0 0  0 0 0 0 0",
"262 263 254  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  2 6 7 5 0 0 0  0 0 4 0 0",
"263 258 253  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 3 4 0  0 2 5 0 0",
"264 265 270  1 2 3 0   0 0 0 0 0  1 0 0 0 0 0 0  6 7 3 6 1 0 0  6 4 0 0 0",
"265 266 275  0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  2 6 7 6 1 0 0  0 0 0 0 0",
"266 267 274  1 0 3 0   0 0 0 0 0  0 2 5 0 1 0 0  0 0 6 7 5 0 0  0 2 5 0 0",
"267 268 273  0 0 2 0   0 2 5 0 0  2 3 6 7 5 0 0  0 0 0 0 4 0 0  0 0 0 0 0",
"268 269 272  1 0 3 2   0 0 0 0 0  2 3 7 3 4 0 0  0 3 5 0 0 0 0  4 0 0 0 0",
"269 264 271  0 0 2 0   3 1 0 0 0  3 7 5 0 0 0 0  4 0 6 4 0 0 0  0 0 0 0 0",
"270 271 264  1 1 3 0   0 0 0 0 0  0 0 0 0 1 0 0  2 6 3 7 5 0 0  0 2 5 0 0",
"271 272 269  0 0 2 0   0 2 5 0 0  0 0 3 7 5 0 0  0 2 5 0 4 0 0  0 0 0 0 0",
"272 273 268  1 0 3 2   0 0 0 0 0  2 3 7 3 4 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"273 274 267  0 0 2 0   3 1 0 0 0  3 7 6 3 4 0 0  4 0 0 0 0 0 0  0 0 0 0 0",
"274 275 266  1 0 3 0   0 0 0 0 0  1 0 3 1 0 0 0  6 7 5 0 0 0 0  6 4 0 0 0",
"275 270 265  0 0 2 0   1 0 0 0 0  0 6 5 0 0 0 0  2 6 7 6 1 0 0  0 0 0 0 0",
"276 277 276  1 2 3 0   0 0 0 0 0  0 0 1 0 0 0 0  2 7 7 7 1 0 0  4 0 4 0 0",
"277 278 281  0 0 2 2   0 0 1 0 0  0 2 7 7 4 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"278 279 280  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 2 7 7 1 0 0  0 0 4 0 0",
"279 280 279  0 0 2 0   1 0 1 0 0  2 7 7 7 4 0 0  0 0 4 0 0 0 0  0 0 0 0 0",
"280 281 278  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  2 7 7 4 0 0 0  4 0 0 0 0",
"281 276 277  0 0 2 0   1 0 0 0 0  2 7 7 1 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"282 283 288  0 2 2 0   0 0 1 0 0  3 3 7 7 4 0 0  4 0 4 0 0 0 0  0 0 0 0 0",
"283 284 293  1 0 3 2   0 0 0 0 0  0 2 7 1 0 0 0  0 3 7 4 0 0 0  6 4 0 0 0",
"284 285 292  0 0 2 0   1 0 0 0 0  2 7 7 1 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"285 286 291  1 0 3 0   0 0 0 0 0  0 0 1 0 1 0 0  2 7 7 6 5 0 0  4 0 0 0 0",
"286 287 290  0 0 2 0   0 2 5 0 0  0 2 7 5 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"287 288 289  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 2 7 7 1 0 0  0 0 4 0 0",
"288 289 282  0 1 2 0   1 0 0 0 0  2 7 7 3 5 0 0  0 0 4 0 4 0 0  0 0 0 0 0",
"289 290 287  1 0 3 0   0 0 0 0 0  0 0 3 3 4 0 0  2 7 7 4 0 0 0  4 0 0 0 0",
"290 291 286  0 0 2 0   3 1 0 0 0  0 6 7 1 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"291 292 285  1 0 3 0   0 0 0 0 0  1 0 1 0 0 0 0  6 6 7 7 1 0 0  0 0 4 0 0",
"292 293 284  0 0 2 0   0 0 1 0 0  0 2 7 7 4 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"293 288 283  1 0 3 1   0 0 0 0 0  0 2 7 1 0 0 0  0 2 7 5 0 0 0  0 2 5 0 0",
"294 295 296  0 2 2 0   0 0 1 0 0  2 3 7 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"295 296 295  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 3 7 5 0 0 0  4 0 4 0 0",
"296 297 294  0 0 2 0   1 0 0 0 0  2 7 7 3 4 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"297 298 299  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 7 7 6 1 0 0  4 0 0 0 0",
"298 299 298  0 0 2 2   1 0 1 0 0  0 6 7 5 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"299 294 297  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  2 6 7 7 1 0 0  0 0 4 0 0",
"300 301 306  0 2 2 0   1 0 0 0 0  2 7 7 3 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"301 302 311  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 7 7 5 0 0 0  4 0 4 0 0",
"302 303 310  0 0 2 0   1 0 0 0 0  0 6 7 3 4 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"303 304 309  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 6 7 7 1 0 0  0 0 4 0 0",
"304 305 308  0 0 2 2   1 0 1 0 0  0 6 7 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"305 300 307  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  2 6 7 5 0 0 0  0 0 4 0 0",
"306 307 300  0 1 2 0   0 0 1 0 0  2 3 7 7 4 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"307 308 305  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 3 7 6 1 0 0  4 0 0 0 0",
"308 309 304  0 0 2 1   1 0 1 0 0  2 7 7 5 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"309 310 303  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  2 7 7 6 1 0 0  4 0 0 0 0",
"310 311 302  0 0 2 0   0 0 1 0 0  2 3 7 5 0 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"311 306 301  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 3 7 7 1 0 0  4 0 4 0 0",
"312 313 318  1 2 3 0   0 0 0 0 0  0 0 0 0 1 0 0  2 7 3 6 5 0 0  6 4 0 0 0",
"313 314 323  0 0 2 0   0 2 5 0 0  0 0 3 5 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"314 315 322  1 0 3 1   0 0 0 0 0  2 3 5 0 1 0 0  0 0 6 7 5 0 0  0 0 4 0 0",
"315 316 321  0 0 2 0   0 2 5 0 0  3 3 6 7 4 0 0  4 0 0 0 0 0 0  0 0 0 0 0",
"316 317 320  1 0 3 0   0 0 0 0 0  2 3 7 1 0 0 0  0 3 5 0 0 0 0  6 4 0 0 0",
"317 312 319  0 0 2 0   1 0 0 0 0  3 7 5 0 0 0 0  4 0 6 6 1 0 0  0 0 0 0 0",
"318 319 312  1 1 3 0   0 0 0 0 0  1 0 0 0 0 0 0  6 6 3 7 1 0 0  0 2 5 0 0",
"319 320 317  0 0 2 0   0 0 1 0 0  0 0 3 7 5 0 0  2 6 5 0 4 0 0  0 0 0 0 0",
"320 321 316  1 0 3 0   0 0 0 0 0  0 2 7 3 4 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"321 322 315  0 0 2 0   3 1 0 0 0  2 7 6 3 5 0 0  0 0 0 0 4 0 0  0 0 0 0 0",
"322 323 314  1 0 3 2   0 0 0 0 0  1 0 3 3 4 0 0  6 7 5 0 0 0 0  4 0 0 0 0",
"323 318 313  0 0 2 0   3 1 0 0 0  0 6 5 0 0 0 0  2 6 7 4 0 0 0  0 0 0 0 0",
"324 325 330  1 2 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 6 3 7 1  0 0 0 0 4",
"325 326 335  0 0 2 0   0 0 0 0 1  0 0 0 0 3 7 4  0 2 3 6 5 0 0  0 0 0 0 0",
"326 327 334  0 0 3 1   0 2 7 1 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"327 328 333  0 0 2 0   1 0 0 0 0  2 7 6 3 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"328 329 332  1 0 3 0   0 0 0 0 0  0 0 3 3 6 1 0  2 7 5 0 0 0 0  4 0 0 0 0",
"329 324 331  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 2 7 4 0",
"330 331 324  1 1 3 0   0 0 0 0 0  0 0 0 0 3 1 0  2 7 3 6 5 0 0  4 0 0 0 0",
"331 332 329  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 2 7 4 0",
"332 333 328  1 0 3 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 0 6 7 1  0 0 0 0 4",
"333 334 327  0 0 2 0   0 0 0 0 1  0 0 3 3 6 7 4  0 2 5 0 0 0 0  0 0 0 0 0",
"334 335 326  0 0 3 2   0 2 7 1 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"335 330 325  0 0 2 0   1 0 0 0 0  2 7 5 0 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"336 337 342  0 2 2 0   1 0 0 0 0  3 7 6 3 4 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"337 338 347  1 0 3 2   0 0 0 0 0  0 0 3 1 0 0 0  2 7 5 0 0 0 0  6 6 1 0 0",
"338 339 346  0 0 2 0   1 0 0 0 0  0 6 5 0 1 0 0  0 2 7 6 5 0 0  0 0 0 0 0",
"339 340 345  1 0 3 0   0 0 0 0 0  0 0 0 2 5 0 0  2 6 3 7 5 0 0  0 0 4 0 0",
"340 341 344  0 0 2 0   2 3 5 0 0  0 0 3 7 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"341 336 343  1 0 3 0   0 0 0 0 0  3 3 7 1 0 0 0  4 0 6 5 0 0 0  0 0 4 0 0",
"342 343 336  0 1 2 0   0 0 1 0 0  2 3 6 7 5 0 0  0 0 0 2 5 0 0  0 0 0 0 0",
"343 344 341  1 0 3 0   0 0 0 0 0  0 2 7 3 5 0 0  0 3 5 0 4 0 0  4 0 0 0 0",
"344 345 340  0 0 2 0   3 3 4 0 0  2 7 5 0 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"345 346 339  1 0 3 0   0 0 0 0 0  3 1 0 0 0 0 0  6 7 3 6 1 0 0  4 0 0 0 0",
"346 347 338  0 0 2 0   0 0 1 0 0  1 0 3 5 0 0 0  6 6 7 4 0 0 0  0 0 0 0 0",
"347 342 337  1 0 3 1   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 1 0 0  2 6 5 0 0",
"348 349 354  0 2 2 0   0 0 0 0 1  0 2 7 3 6 5 0  0 2 5 0 0 0 0  0 0 0 0 0",
"349 350 359  0 0 3 0   0 2 5 0 0  0 0 3 5 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"350 351 358  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 7 3 4 0  0 0 4 0 0",
"351 352 357  1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 3 3 6 7 4 0  4 0 0 0 0",
"352 353 356  0 0 3 2   0 0 1 0 0  0 0 0 6 7 1 0  0 0 0 3 5 0 0  0 0 6 4 0",
"353 348 355  0 0 2 0   0 0 1 0 0  0 2 6 7 5 0 0  0 0 0 0 6 6 1  0 0 0 0 0",
"354 355 348  0 1 2 0   1 0 0 0 0  0 6 6 3 7 1 0  0 0 0 0 6 4 0  0 0 0 0 0",
"355 356 353  0 0 2 0   0 0 1 0 0  0 0 3 7 6 1 0  2 6 5 0 0 0 0  0 0 0 0 0",
"356 357 352  0 0 3 1   0 0 1 0 0  0 2 7 5 0 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"357 358 351  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 6 3 5 0  0 0 0 0 4",
"358 359 350  1 0 3 0   0 0 0 0 0  0 0 0 0 3 3 4  0 2 3 7 5 0 0  0 0 4 0 0",
"359 354 349  0 0 3 0   3 1 0 0 0  0 6 5 0 0 0 0  0 3 7 4 0 0 0  4 0 0 0 0",
"360 361 360  1 2 2 0   0 0 0 0 0  0 2 7 3 7 1 0  0 0 6 6 5 0 0  0 0 0 0 0",
"361 362 365  0 0 2 0   0 0 1 0 0  0 0 3 7 5 0 0  0 2 7 6 5 0 0  0 0 0 0 0",
"362 363 364  1 0 3 2   0 0 0 0 0  0 2 7 3 5 0 0  0 0 6 7 5 0 0  0 0 4 0 0",
"363 364 363  1 0 2 0   0 0 0 0 0  0 0 3 3 5 0 0  0 2 7 6 7 4 0  0 0 0 0 0",
"364 365 362  1 0 3 0   0 0 0 0 0  0 0 3 3 7 1 0  0 0 6 7 5 0 0  0 0 4 0 0",
"365 360 361  0 0 2 0   0 0 1 0 0  0 0 3 7 5 0 0  0 0 6 6 7 4 0  0 0 0 0 0",
"366 367 372  1 2 2 0   0 0 0 0 0  0 2 7 3 7 1 0  0 2 5 0 4 0 0  0 0 0 0 0",
"367 368 377  0 0 3 2   0 0 1 0 0  0 0 3 7 4 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"368 369 376  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 7 3 4 0  0 0 4 0 0",
"369 370 375  1 0 2 0   0 0 0 0 0  0 0 1 0 3 1 0  0 2 7 6 7 4 0  0 0 0 0 0",
"370 371 374  0 0 3 0   0 0 1 0 0  0 0 0 6 7 1 0  0 0 2 7 5 0 0  0 0 4 0 0",
"371 366 373  0 0 2 0   0 0 1 0 0  0 2 6 7 5 0 0  0 0 0 2 7 4 0  0 0 0 0 0",
"372 373 366  1 1 2 0   0 0 0 0 0  0 2 7 3 7 1 0  0 0 4 0 6 4 0  0 0 0 0 0",
"373 374 371  0 0 2 0   0 0 1 0 0  0 0 3 7 6 1 0  0 2 7 4 0 0 0  0 0 0 0 0",
"374 375 370  0 0 3 0   0 0 1 0 0  0 2 7 5 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"375 376 369  1 0 2 0   0 0 0 0 0  0 2 5 0 1 0 0  0 2 7 6 7 4 0  0 0 0 0 0",
"376 377 368  1 0 3 0   0 0 0 0 0  0 0 0 2 7 1 0  0 2 3 7 5 0 0  0 0 4 0 0",
"377 372 367  0 0 3 1   0 0 1 0 0  0 0 2 7 5 0 0  0 0 0 3 7 4 0  0 0 4 0 0",
"378 379 384  1 2 2 0   0 0 0 0 0  0 2 7 3 6 1 0  0 2 7 4 0 0 0  0 0 0 0 0",
"379 380 389  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 2 7 7 1 0 0  0 0 4 0 0",
"380 381 388  1 0 3 0   0 0 0 0 0  0 2 5 0 1 0 0  0 0 6 7 7 4 0  0 0 4 0 0",
"381 382 387  1 0 2 0   0 0 0 0 0  0 0 0 2 7 1 0  0 2 3 6 7 4 0  0 0 0 0 0",
"382 383 386  0 0 3 1   0 0 1 0 0  0 0 2 7 7 1 0  0 0 0 3 5 0 0  0 0 4 0 0",
"383 378 385  0 0 2 0   0 0 1 0 0  0 2 7 7 5 0 0  0 0 4 0 6 4 0  0 0 0 0 0",
"384 385 378  1 1 2 0   0 0 0 0 0  0 2 6 3 7 1 0  0 0 0 2 7 4 0  0 0 0 0 0",
"385 386 383  0 0 2 0   0 0 1 0 0  0 0 3 7 7 1 0  0 2 5 0 4 0 0  0 0 0 0 0",
"386 387 382  0 0 3 1   0 0 1 0 0  0 2 7 7 4 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"387 388 381  1 0 2 0   0 0 0 0 0  0 2 7 1 0 0 0  0 2 7 6 3 4 0  0 0 0 0 0",
"388 389 380  1 0 3 0   0 0 0 0 0  0 0 1 0 3 1 0  0 2 7 7 5 0 0  0 0 4 0 0",
"389 384 379  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 2 7 7 4 0  0 0 4 0 0",
"390 391 394  1 2 3 2   0 0 0 0 0  0 2 7 3 6 1 0  0 0 6 5 0 0 0  0 0 4 0 0",
"391 392 393  0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  0 2 7 6 3 4 0  0 0 0 0 0",
"392 393 392  1 0 3 0   0 0 0 0 0  0 2 5 0 3 1 0  0 0 6 7 5 0 0  0 0 4 0 0",
"393 394 391  0 0 2 0   0 0 1 0 0  0 0 0 6 5 0 0  0 2 3 6 7 4 0  0 0 0 0 0",
"394 395 390  1 0 3 0   0 0 0 0 0  0 2 6 3 7 1 0  0 0 0 3 5 0 0  0 0 4 0 0",
"395 390 395  0 0 2 0   0 0 1 0 0  0 0 3 7 5 0 0  0 2 5 0 6 4 0  0 0 0 0 0",
"396 397 402  0 2 2 0   0 0 1 0 0  0 2 7 7 6 1 0  0 0 6 4 0 0 0  0 0 0 0 0",
"397 398 407  0 0 2 0   0 0 1 0 0  0 2 7 5 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"398 399 406  1 0 3 0   0 0 0 0 0  0 2 5 0 1 0 0  0 2 7 7 5 0 0  0 0 4 0 0",
"399 400 405  1 0 3 0   0 0 0 0 0  0 0 0 2 5 0 0  0 2 3 7 7 4 0  0 0 4 0 0",
"400 401 404  1 0 3 1   0 0 0 0 0  0 0 2 3 7 1 0  0 0 0 3 7 4 0  0 0 4 0 0",
"401 396 403  0 0 2 0   0 0 1 0 0  0 0 3 7 7 1 0  0 0 4 0 6 4 0  0 0 0 0 0",
"402 403 396  0 1 2 0   0 0 1 0 0  0 2 6 7 7 1 0  0 0 0 2 5 0 0  0 0 0 0 0",
"403 404 401  0 0 2 0   0 0 1 0 0  0 2 7 7 5 0 0  0 2 5 0 4 0 0  0 0 0 0 0",
"404 405 400  1 0 3 2   0 0 0 0 0  0 2 7 3 4 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"405 406 399  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  0 2 7 7 3 4 0  0 0 4 0 0",
"406 407 398  1 0 3 0   0 0 0 0 0  0 0 1 0 3 1 0  0 0 6 7 7 4 0  0 0 4 0 0",
"407 402 397  0 0 2 0   0 0 1 0 0  0 0 0 6 7 1 0  0 0 2 6 7 4 0  0 0 0 0 0",
"408 409 413  0 2 2 0   0 0 1 0 0  0 2 7 7 6 1 0  0 2 5 0 0 0 0  0 0 0 0 0",
"409 410 412  0 0 3 2   0 0 1 0 0  0 2 7 5 0 0 0  0 2 7 5 0 0 0  0 0 4 0 0",
"410 411 411  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 2 7 7 3 4 0  0 0 4 0 0",
"411 412 410  1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 2 3 7 7 4 0  0 0 4 0 0",
"412 413 409  0 0 3 0   0 0 1 0 0  0 0 0 6 7 1 0  0 0 0 3 7 4 0  0 0 4 0 0",
"413 408 408  0 0 2 0   0 0 1 0 0  0 2 6 7 7 1 0  0 0 0 0 6 4 0  0 0 0 0 0",
"414 415 420  1 2 2 0   0 0 0 0 0  0 2 7 3 6 1 0  2 6 5 0 0 0 0  0 0 0 0 0",
"415 416 425  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 2 7 5 0 0 0  0 2 5 0 0",
"416 417 424  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 7 3 5 0  0 0 4 0 4",
"417 418 423  1 0 2 0   0 0 0 0 0  0 0 0 0 3 3 4  0 2 3 6 7 4 0  0 0 0 0 0",
"418 419 422  0 0 3 1   0 0 3 1 0  0 0 0 6 7 1 0  0 0 0 3 5 0 0  0 0 4 0 0",
"419 414 421  0 0 2 0   1 0 1 0 0  0 6 6 7 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"420 421 414  1 1 2 0   0 0 0 0 0  0 2 6 3 7 1 0  0 0 0 0 6 6 1  0 0 0 0 0",
"421 422 419  0 0 2 0   0 0 1 0 1  0 0 3 7 6 5 0  0 2 5 0 0 0 0  0 0 0 0 0",
"422 423 418  0 0 3 2   0 2 5 0 0  0 2 7 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"423 424 417  1 0 2 0   0 0 0 0 0  2 3 5 0 0 0 0  0 2 7 6 3 4 0  0 0 0 0 0",
"424 425 416  1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 3 3 7 5 0 0  4 0 4 0 0",
"425 420 415  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 3 7 4 0  0 0 6 4 0",
"426 427 426  1 2 2 0   0 0 0 0 0  2 3 7 3 4 0 0  0 2 7 4 0 0 0  0 0 0 0 0",
"427 428 431  0 0 2 0   3 1 0 0 0  3 7 7 1 0 0 0  4 0 4 0 0 0 0  0 0 0 0 0",
"428 429 430  1 0 3 0   0 0 0 0 0  1 0 1 0 0 0 0  6 7 7 4 0 0 0  6 4 0 0 0",
"429 430 429  1 0 2 0   0 0 0 0 0  0 2 7 1 0 0 0  2 6 7 6 1 0 0  0 0 0 0 0",
"430 431 428  0 0 3 2   1 0 1 0 0  2 7 7 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"431 426 427  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  2 7 7 5 0 0 0  4 0 4 0 0",
"432 433 438  1 2 2 0   0 0 0 0 0  3 3 7 3 4 0 0  4 0 6 4 0 0 0  0 0 0 0 0",
"433 434 443  0 0 2 2   3 1 0 0 0  3 7 6 1 0 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"434 435 442  1 0 3 0   0 0 0 0 0  1 0 1 0 0 0 0  6 7 5 0 0 0 0  6 6 1 0 0",
"435 436 441  1 0 2 0   0 0 0 0 0  0 2 5 0 1 0 0  2 6 7 6 5 0 0  0 0 0 0 0",
"436 437 440  0 0 2 0   0 2 5 0 0  2 3 7 5 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"437 432 439  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 3 7 5 0 0 0  4 0 4 0 0",
"438 439 432  1 1 2 0   0 0 0 0 0  2 3 7 3 5 0 0  0 2 5 0 4 0 0  0 0 0 0 0",
"439 440 437  0 0 2 0   3 3 4 0 0  3 7 5 0 0 0 0  4 0 4 0 0 0 0  0 0 0 0 0",
"440 441 436  1 0 3 0   0 0 0 0 0  3 1 0 0 0 0 0  6 7 3 4 0 0 0  6 4 0 0 0",
"441 442 435  1 0 2 0   0 0 0 0 0  1 0 3 1 0 0 0  6 6 7 6 1 0 0  0 0 0 0 0",
"442 443 434  0 0 2 0   1 0 1 0 0  0 6 7 5 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"443 438 433  1 0 3 1   0 0 0 0 0  0 2 5 0 0 0 0  2 6 7 5 0 0 0  0 2 5 0 0",
"444 445 450  1 2 2 0   0 0 0 0 0  0 0 3 3 7 3 4  0 0 6 6 5 0 0  0 0 0 0 0",
"445 446 455  0 0 2 0   0 0 3 1 0  0 0 3 7 5 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"446 447 454  0 0 2 0   1 0 0 0 0  0 6 7 3 5 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"447 448 453  1 0 2 0   0 0 0 0 0  0 0 3 3 5 0 0  2 6 7 6 5 0 0  0 0 0 0 0",
"448 449 452  1 0 3 1   0 0 0 0 0  0 0 3 3 5 0 0  0 0 6 7 5 0 0  0 2 5 0 0",
"449 444 451  1 0 3 0   0 0 0 0 0  0 0 3 3 5 0 0  0 0 6 6 7 5 0  0 0 0 0 4",
"450 451 444  1 1 2 0   0 0 0 0 0  2 3 7 3 5 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"451 452 449  1 0 3 0   0 0 0 0 0  0 0 3 3 5 0 0  0 3 7 6 5 0 0  4 0 0 0 0",
"452 453 448  1 0 3 2   0 0 0 0 0  0 0 3 3 5 0 0  0 0 6 7 5 0 0  0 0 6 4 0",
"453 454 447  1 0 2 0   0 0 0 0 0  0 0 3 3 5 0 0  0 0 6 6 7 6 1  0 0 0 0 0",
"454 455 446  0 0 2 0   0 0 0 0 1  0 0 3 3 7 5 0  0 0 6 6 5 0 0  0 0 0 0 0",
"455 450 445  0 0 2 0   0 2 5 0 0  0 0 3 7 5 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"456 457 456  1 2 2 0   0 0 0 0 0  3 3 7 3 5 0 0  4 0 4 0 4 0 0  0 0 0 0 0",
"457 458 461  0 0 2 0   3 3 4 0 0  3 7 4 0 0 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"458 459 460  1 0 3 0   0 0 0 0 0  3 1 0 0 0 0 0  6 7 1 0 0 0 0  6 6 1 0 0",
"459 460 459  1 0 2 0   0 0 0 0 0  1 0 1 0 1 0 0  6 6 7 6 5 0 0  0 0 0 0 0",
"460 461 458  0 0 2 0   0 2 5 0 0  0 2 7 5 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"461 456 457  1 0 3 2   0 0 0 0 0  2 3 5 0 0 0 0  0 2 7 5 0 0 0  0 2 5 0 0",
"462 463 468  1 2 2 0   0 0 0 0 0  0 0 3 3 7 3 4  0 2 5 0 4 0 0  0 0 0 0 0",
"463 464 473  0 0 3 2   0 0 3 1 0  0 0 3 7 4 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"464 465 472  0 0 2 0   1 0 0 0 0  0 6 7 1 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"465 466 471  1 0 2 0   0 0 0 0 0  0 0 1 0 3 1 0  2 6 7 6 5 0 0  0 0 0 0 0",
"466 467 470  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 2 7 5 0 0  0 2 5 0 0",
"467 462 469  1 0 3 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 2 7 5 0  0 0 0 0 4",
"468 469 462  1 1 2 0   0 0 0 0 0  2 3 7 3 5 0 0  0 0 4 0 6 4 0  0 0 0 0 0",
"469 470 467  1 0 3 0   0 0 0 0 0  0 0 3 3 6 1 0  0 3 7 4 0 0 0  4 0 0 0 0",
"470 471 466  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 7 1 0 0  0 0 6 4 0",
"471 472 465  1 0 2 0   0 0 0 0 0  0 2 5 0 1 0 0  0 0 6 6 7 6 1  0 0 0 0 0",
"472 473 464  0 0 2 0   0 0 0 0 1  0 0 0 2 7 5 0  0 2 3 6 5 0 0  0 0 0 0 0",
"473 468 463  0 0 3 1   0 2 5 0 0  0 0 2 7 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"474 475 479  1 2 3 0   0 0 0 0 0  0 0 3 3 6 3 4  0 3 5 0 0 0 0  4 0 0 0 0",
"475 476 478  0 0 3 2   0 0 3 1 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"476 477 477  0 0 2 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 6 3 6 1  0 0 0 0 0",
"477 478 476  0 0 2 0   0 0 0 0 1  0 0 0 0 3 5 0  2 6 3 6 5 0 0  0 0 0 0 0",
"478 479 475  0 0 3 0   0 2 5 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 2 5 0 0",
"479 474 474  1 0 3 0   0 0 0 0 0  2 3 6 3 5 0 0  0 0 0 0 6 5 0  0 0 0 0 4",
"480 481 486  1 2 2 0   0 0 0 0 0  0 0 3 3 6 3 4  2 6 5 0 0 0 0  0 0 0 0 0",
"481 482 491  0 0 3 0   0 0 3 1 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"482 483 490  0 0 3 0   1 0 0 0 0  0 6 5 0 0 0 0  0 0 6 6 3 5 0  0 0 0 0 4",
"483 484 489  1 0 2 0   0 0 0 0 0  0 0 0 0 3 3 4  2 6 3 6 5 0 0  0 0 0 0 0",
"484 485 488  0 0 3 1   0 0 3 1 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 2 5 0 0",
"485 480 487  0 0 3 0   1 0 0 0 0  0 6 6 3 5 0 0  0 0 0 0 6 5 0  0 0 0 0 4",
"486 487 480  1 1 2 0   0 0 0 0 0  2 3 6 3 5 0 0  0 0 0 0 6 6 1  0 0 0 0 0",
"487 488 485  0 0 3 0   0 0 0 0 1  0 0 3 3 6 5 0  0 3 5 0 0 0 0  4 0 0 0 0",
"488 489 484  0 0 3 2   0 2 5 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"489 490 483  1 0 2 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 6 3 6 1  0 0 0 0 0",
"490 491 482  0 0 3 0   0 0 0 0 1  0 0 0 0 3 5 0  0 3 3 6 5 0 0  4 0 0 0 0",
"491 486 481  0 0 3 0   0 2 5 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 6 4 0",
"492 493 498  1 2 2 0   0 0 0 0 0  0 0 3 3 6 3 5  0 2 5 0 0 0 4  0 0 0 0 0",
"493 494 503  0 0 3 2   0 0 3 3 4  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"494 495 502  0 0 2 0   3 1 0 0 0  0 6 5 0 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"495 496 501  1 0 2 0   0 0 0 0 0  1 0 0 0 3 1 0  6 6 3 6 5 0 0  0 0 0 0 0",
"496 497 500  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  2 6 5 0 0",
"497 492 499  1 0 3 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 0 6 5 0  0 0 0 2 5",
"498 499 492  1 1 2 0   0 0 0 0 0  3 3 6 3 5 0 0  4 0 0 0 6 4 0  0 0 0 0 0",
"499 500 497  1 0 3 0   0 0 0 0 0  0 0 3 3 6 1 0  0 3 5 0 0 0 0  6 4 0 0 0",
"500 501 496  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 6 6 1",
"501 502 495  1 0 2 0   0 0 0 0 0  0 2 5 0 0 0 1  0 0 6 6 3 6 5  0 0 0 0 0",
"502 503 494  0 0 2 0   0 0 0 2 5  0 0 0 0 3 5 0  0 2 3 6 5 0 0  0 0 0 0 0",
"503 498 493  0 0 3 1   2 3 5 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"504 505 510  1 2 2 0   0 0 0 0 0  0 0 3 3 6 3 4  0 2 7 4 0 0 0  0 0 0 0 0",
"505 506 515  0 0 3 0   0 0 3 1 0  0 0 3 5 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"506 507 514  0 0 2 0   1 0 0 0 0  0 6 5 0 1 0 0  0 0 6 6 7 4 0  0 0 0 0 0",
"507 508 513  1 0 2 0   0 0 0 0 0  0 0 0 2 7 1 0  2 6 3 6 5 0 0  0 0 0 0 0",
"508 509 512  0 0 3 1   0 0 1 0 0  0 0 2 7 5 0 0  0 0 0 3 5 0 0  0 2 5 0 0",
"509 504 511  1 0 3 0   0 0 0 0 0  0 2 7 3 5 0 0  0 0 4 0 6 5 0  0 0 0 0 4",
"510 511 504  1 1 2 0   0 0 0 0 0  2 3 6 3 5 0 0  0 0 0 2 7 4 0  0 0 0 0 0",
"511 512 509  1 0 3 0   0 0 0 0 0  0 0 3 3 7 1 0  0 3 5 0 4 0 0  4 0 0 0 0",
"512 513 508  0 0 3 2   0 0 1 0 0  0 0 3 7 4 0 0  0 0 6 5 0 0 0  0 0 6 4 0",
"513 514 507  1 0 2 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 6 3 6 1  0 0 0 0 0",
"514 515 506  0 0 2 0   0 0 0 0 1  0 0 1 0 3 5 0  0 2 7 6 5 0 0  0 0 0 0 0",
"515 510 505  0 0 3 0   0 2 5 0 0  0 0 0 6 5 0 0  0 0 2 7 5 0 0  0 0 4 0 0",
"516 517 522  1 2 2 0   0 0 0 0 0  3 3 6 3 5 0 0  6 4 0 0 4 0 0  0 0 0 0 0",
"517 518 527  0 0 2 0   3 3 4 0 0  3 5 0 0 0 0 0  6 6 1 0 0 0 0  0 0 0 0 0",
"518 519 526  1 0 3 0   0 0 0 0 0  3 1 0 0 0 0 0  6 5 0 1 0 0 0  6 6 5 0 0",
"519 520 525  1 0 2 0   0 0 0 0 0  1 0 0 2 5 0 0  6 6 3 6 5 0 0  0 0 0 0 0",
"520 521 524  0 0 2 1   2 3 5 0 0  0 0 3 5 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"521 516 523  1 0 3 0   0 0 0 0 0  3 3 5 0 0 0 0  4 0 6 5 0 0 0  0 2 5 0 0",
"522 523 516  1 1 2 0   0 0 0 0 0  3 3 6 3 5 0 0  4 0 0 2 5 0 0  0 0 0 0 0",
"523 524 521  0 0 2 0   3 3 5 0 0  3 5 0 4 0 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"524 525 520  1 0 3 2   0 0 0 0 0  3 3 4 0 0 0 0  6 5 0 0 0 0 0  6 6 1 0 0",
"525 526 519  1 0 2 0   0 0 0 0 0  3 1 0 0 1 0 0  6 6 3 6 5 0 0  0 0 0 0 0",
"526 527 518  0 0 2 0   0 2 5 0 0  1 0 3 5 0 0 0  6 6 5 0 0 0 0  0 0 0 0 0",
"527 522 517  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 5 0 0 0  2 6 5 0 0",
"528 529 534  1 2 3 0   0 0 0 0 0  0 0 3 3 6 3 4  0 0 6 5 0 0 0  0 0 4 0 0",
"529 530 539  0 0 2 0   0 0 3 1 0  0 0 3 5 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"530 531 538  0 0 2 0   1 0 0 0 0  0 6 5 0 3 1 0  0 0 6 6 5 0 0  0 0 0 0 0",
"531 532 537  0 0 2 0   0 0 1 0 0  0 0 0 6 5 0 0  2 6 3 6 5 0 0  0 0 0 0 0",
"532 533 536  1 0 3 1   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 3 5 0 0  0 2 5 0 0",
"533 528 535  1 0 3 0   0 0 0 0 0  0 0 3 3 5 0 0  0 2 5 0 6 5 0  0 0 0 0 4",
"534 535 528  1 1 3 0   0 0 0 0 0  2 3 6 3 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"535 536 533  1 0 3 0   0 0 0 0 0  0 0 3 3 5 0 0  0 3 5 0 6 4 0  4 0 0 0 0",
"536 537 532  1 0 3 2   0 0 0 0 0  0 0 3 3 6 1 0  0 0 6 5 0 0 0  0 0 6 4 0",
"537 538 531  0 0 2 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 6 3 6 1  0 0 0 0 0",
"538 539 530  0 0 2 0   0 0 0 0 1  0 2 5 0 3 5 0  0 0 6 6 5 0 0  0 0 0 0 0",
"539 534 529  0 0 2 0   0 2 5 0 0  0 0 0 6 5 0 0  0 2 3 6 5 0 0  0 0 0 0 0",
"540 541 546  0 2 2 0   1 0 0 0 0  0 6 7 3 4 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"541 542 551  1 0 3 0   0 0 0 0 0  0 0 3 1 0 0 0  2 6 7 5 0 0 0  0 2 5 0 0",
"542 543 550  0 0 2 0   1 0 0 0 0  0 6 7 3 5 0 0  0 2 5 0 4 0 0  0 0 0 0 0",
"543 544 549  1 0 3 1   0 0 0 0 0  0 0 3 3 4 0 0  2 6 7 5 0 0 0  0 0 4 0 0",
"544 545 548  0 0 2 0   3 1 0 0 0  0 6 7 3 4 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"545 540 547  1 0 3 0   0 0 0 0 0  1 0 3 1 0 0 0  6 6 7 5 0 0 0  0 0 4 0 0",
"546 547 540  0 1 2 0   0 0 1 0 0  2 3 7 5 0 0 0  0 0 6 6 1 0 0  0 0 0 0 0",
"547 548 545  1 0 3 0   0 0 0 0 0  0 2 5 0 1 0 0  0 3 7 6 5 0 0  4 0 0 0 0",
"548 549 544  0 0 2 2   0 2 5 0 0  2 3 7 5 0 0 0  0 0 6 4 0 0 0  0 0 0 0 0",
"549 550 543  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 3 7 6 1 0 0  4 0 0 0 0",
"550 551 542  0 0 2 0   0 0 1 0 0  3 3 7 5 0 0 0  4 0 6 4 0 0 0  0 0 0 0 0",
"551 546 541  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 3 7 6 1 0 0  6 4 0 0 0",
"552 553 558  1 2 2 0   0 0 0 0 0  0 0 3 3 6 1 0  2 6 7 4 0 0 0  0 0 0 0 0",
"553 554 563  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 7 1 0 0  0 2 5 0 0",
"554 555 562  1 0 3 0   0 0 0 0 0  0 2 5 0 1 0 0  0 0 6 6 7 5 0  0 0 0 0 4",
"555 556 561  1 0 2 0   0 0 0 0 0  0 0 0 2 7 3 4  0 2 3 6 5 0 0  0 0 0 0 0",
"556 557 560  0 0 3 1   0 0 3 1 0  0 0 2 7 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"557 552 559  0 0 2 0   1 0 0 0 0  0 6 7 3 5 0 0  0 0 4 0 6 4 0  0 0 0 0 0",
"558 559 552  1 1 2 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 2 7 6 1  0 0 0 0 0",
"559 560 557  0 0 2 0   0 0 0 0 1  0 0 3 3 7 5 0  0 2 5 0 4 0 0  0 0 0 0 0",
"560 561 556  0 0 3 2   0 2 5 0 0  0 0 3 7 4 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"561 562 555  1 0 2 0   0 0 0 0 0  2 3 7 1 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"562 563 554  1 0 3 0   0 0 0 0 0  0 0 1 0 3 1 0  0 3 7 6 5 0 0  4 0 0 0 0",
"563 558 553  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 2 7 5 0 0  0 0 6 4 0",
"564 565 570  1 2 2 0   0 0 0 0 0  0 0 3 3 7 1 0  2 6 5 0 4 0 0  0 0 0 0 0",
"565 566 575  0 0 3 1   0 0 1 0 0  0 0 3 7 4 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"566 567 574  1 0 3 0   0 0 0 0 0  0 2 7 1 0 0 0  0 0 6 6 3 5 0  0 0 0 0 4",
"567 568 573  1 0 2 0   0 0 0 0 0  0 0 1 0 3 3 4  0 2 7 6 5 0 0  0 0 0 0 0",
"568 569 572  0 0 3 0   0 0 3 1 0  0 0 0 6 5 0 0  0 0 2 7 5 0 0  0 0 4 0 0",
"569 564 571  0 0 2 0   1 0 0 0 0  0 6 6 3 5 0 0  0 0 0 2 7 4 0  0 0 0 0 0",
"570 571 564  1 1 2 0   0 0 0 0 0  0 2 7 3 5 0 0  0 0 4 0 6 6 1  0 0 0 0 0",
"571 572 569  0 0 2 0   0 0 0 0 1  0 0 3 3 6 5 0  0 2 7 4 0 0 0  0 0 0 0 0",
"572 573 568  0 0 3 0   0 2 5 0 0  0 0 3 5 0 0 0  0 0 6 7 1 0 0  0 0 4 0 0",
"573 574 567  1 0 2 0   0 0 0 0 0  2 3 5 0 1 0 0  0 0 6 6 7 4 0  0 0 0 0 0",
"574 575 566  1 0 3 0   0 0 0 0 0  0 0 0 2 7 1 0  0 3 3 6 5 0 0  4 0 0 0 0",
"575 570 565  0 0 3 2   0 0 1 0 0  0 0 2 7 5 0 0  0 0 0 3 5 0 0  0 0 6 4 0",
"576 577 582  1 2 2 0   0 0 0 0 0  1 0 3 3 6 1 0  6 6 5 0 0 0 0  0 0 0 0 0",
"577 578 587  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  2 6 5 0 0",
"578 579 586  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  0 0 6 6 3 5 0  0 0 0 2 5",
"579 580 585  1 0 2 0   0 0 0 0 0  0 0 0 0 3 3 5  0 2 3 6 5 0 4  0 0 0 0 0",
"580 581 584  0 0 3 1   0 0 3 3 4  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"581 576 583  0 0 2 0   3 1 0 0 0  0 6 6 3 5 0 0  0 0 0 0 6 4 0  0 0 0 0 0",
"582 583 576  1 1 2 0   0 0 0 0 0  0 2 6 3 5 0 1  0 0 0 0 6 6 5  0 0 0 0 0",
"583 584 581  0 0 2 0   0 0 0 2 5  0 0 3 3 6 5 0  0 2 5 0 0 0 0  0 0 0 0 0",
"584 585 580  0 0 3 2   2 3 5 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 0 4 0 0",
"585 586 579  1 0 2 0   0 0 0 0 0  3 3 5 0 0 0 0  4 0 6 6 3 4 0  0 0 0 0 0",
"586 587 578  1 0 3 0   0 0 0 0 0  0 0 0 0 3 1 0  0 3 3 6 5 0 0  6 4 0 0 0",
"587 582 577  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 6 6 1",
"588 589 593  0 2 2 0   0 0 0 0 1  0 0 3 3 6 5 0  2 6 5 0 0 0 0  0 0 0 0 0",
"589 590 592  0 0 3 0   0 2 5 0 0  0 0 3 5 0 0 0  0 0 6 5 0 0 0  0 2 5 0 0",
"590 591 591  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 0 6 6 3 5 0  0 0 0 0 4",
"591 592 590  1 0 3 0   0 0 0 0 0  0 0 0 0 3 3 4  0 3 3 6 5 0 0  4 0 0 0 0",
"592 593 589  0 0 3 2   0 0 3 1 0  0 0 0 6 5 0 0  0 0 0 3 5 0 0  0 0 6 4 0",
"593 588 588  0 0 2 0   1 0 0 0 0  0 6 6 3 5 0 0  0 0 0 0 6 6 1  0 0 0 0 0",
"594 595 597  1 2 2 0   0 0 0 0 0  0 2 7 3 4 0 0  2 6 7 4 0 0 0  0 0 0 0 0",
"595 596 599  0 0 2 1   3 1 0 0 0  2 7 7 1 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"596 594 598  1 0 3 0   0 0 0 0 0  1 0 1 0 0 0 0  6 7 7 5 0 0 0  4 0 4 0 0",
"597 598 594  1 1 2 0   0 0 0 0 0  2 3 7 1 0 0 0  0 2 7 6 1 0 0  0 0 0 0 0",
"598 599 596  0 0 2 0   1 0 1 0 0  3 7 7 5 0 0 0  4 0 4 0 0 0 0  0 0 0 0 0",
"599 597 595  1 0 3 2   0 0 0 0 0  0 2 5 0 0 0 0  2 7 7 4 0 0 0  6 4 0 0 0",
"600 601 606  1 2 2 0   0 0 0 0 0  3 3 7 1 0 0 0  4 0 6 6 1 0 0  0 0 0 0 0",
"601 602 611  0 0 2 2   1 0 1 0 0  3 7 6 5 0 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"602 603 610  1 0 3 0   0 0 0 0 0  0 2 5 0 0 0 0  2 7 5 0 0 0 0  6 6 1 0 0",
"603 604 609  1 0 2 0   0 0 0 0 0  2 3 5 0 1 0 0  0 2 7 6 5 0 0  0 0 0 0 0",
"604 605 608  0 0 2 0   0 2 5 0 0  3 3 7 5 0 0 0  4 0 4 0 0 0 0  0 0 0 0 0",
"605 600 607  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 3 7 4 0 0 0  6 4 0 0 0",
"606 607 600  1 1 2 0   0 0 0 0 0  0 2 7 3 5 0 0  2 6 5 0 4 0 0  0 0 0 0 0",
"607 608 605  0 0 2 0   3 3 4 0 0  2 7 5 0 0 0 0  0 2 5 0 0 0 0  0 0 0 0 0",
"608 609 604  1 0 3 0   0 0 0 0 0  3 1 0 0 0 0 0  6 7 3 5 0 0 0  4 0 4 0 0",
"609 610 603  1 0 2 0   0 0 0 0 0  1 0 3 3 4 0 0  6 6 7 4 0 0 0  0 0 0 0 0",
"610 611 602  0 0 2 0   3 1 0 0 0  0 6 7 1 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"611 606 601  1 0 3 1   0 0 0 0 0  1 0 1 0 0 0 0  6 6 7 5 0 0 0  0 2 5 0 0",
"612 613 614  1 2 2 0   0 0 0 0 0  0 0 3 3 7 1 0  0 2 7 6 5 0 0  0 0 0 0 0",
"613 614 613  0 0 3 2   0 0 1 0 0  0 0 3 7 5 0 0  0 0 6 7 5 0 0  0 0 4 0 0",
"614 612 612  1 0 2 0   0 0 0 0 0  0 2 7 3 5 0 0  0 0 6 6 7 4 0  0 0 0 0 0",
"615 616 621  1 2 2 0   0 0 0 0 0  0 0 3 3 7 1 0  0 2 5 0 6 4 0  0 0 0 0 0",
"616 617 626  0 0 3 2   0 0 1 0 0  0 0 3 7 6 1 0  0 0 6 5 0 0 0  0 0 4 0 0",
"617 618 625  0 0 2 0   0 0 1 0 0  0 2 7 5 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"618 619 624  1 0 2 0   0 0 0 0 0  0 2 5 0 3 1 0  0 2 7 6 5 0 0  0 0 0 0 0",
"619 620 623  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 2 3 7 5 0 0  0 0 4 0 0",
"620 615 622  1 0 3 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 3 7 4 0  0 0 4 0 0",
"621 622 615  1 1 2 0   0 0 0 0 0  0 2 7 3 5 0 0  0 2 5 0 6 4 0  0 0 0 0 0",
"622 623 620  1 0 3 0   0 0 0 0 0  0 0 3 3 6 1 0  0 2 7 5 0 0 0  0 0 4 0 0",
"623 624 619  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 7 3 4 0  0 0 4 0 0",
"624 625 618  1 0 2 0   0 0 0 0 0  0 2 5 0 3 1 0  0 0 6 6 7 4 0  0 0 0 0 0",
"625 626 617  0 0 2 0   0 0 1 0 0  0 0 0 6 7 1 0  0 2 3 6 5 0 0  0 0 0 0 0",
"626 621 616  0 0 3 1   0 0 1 0 0  0 2 6 7 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"627 628 630  1 2 2 0   0 0 0 0 0  0 0 3 3 7 1 0  0 0 6 6 7 4 0  0 0 0 0 0",
"628 629 629  0 0 2 0   0 0 1 0 0  0 0 3 7 7 1 0  0 0 6 6 5 0 0  0 0 0 0 0",
"629 630 628  0 0 2 0   0 0 1 0 0  0 2 7 7 5 0 0  0 0 6 6 5 0 0  0 0 0 0 0",
"630 631 627  1 0 2 0   0 0 0 0 0  0 2 7 3 5 0 0  0 2 7 6 5 0 0  0 0 0 0 0",
"631 632 632  1 0 3 2   0 0 0 0 0  0 0 3 3 5 0 0  0 2 7 7 5 0 0  0 0 4 0 0",
"632 627 631  1 0 3 0   0 0 0 0 0  0 0 3 3 5 0 0  0 0 6 7 7 4 0  0 0 4 0 0",
"633 634 639  1 2 2 0   0 0 0 0 0  0 0 3 3 5 0 0  0 2 5 0 6 6 1  0 0 0 0 0",
"634 635 644  0 0 3 2   0 0 0 0 1  0 0 3 3 6 5 0  0 0 6 5 0 0 0  0 0 4 0 0",
"635 636 643  0 0 2 0   0 2 5 0 0  0 0 3 5 0 0 0  0 0 6 6 3 4 0  0 0 0 0 0",
"636 637 642  1 0 2 0   0 0 0 0 0  2 3 5 0 3 1 0  0 0 6 6 5 0 0  0 0 0 0 0",
"637 638 641  0 0 3 0   0 0 1 0 0  0 0 0 6 5 0 0  0 3 3 6 5 0 0  4 0 0 0 0",
"638 633 640  1 0 3 0   0 0 0 0 0  0 2 6 3 5 0 0  0 0 0 3 5 0 0  0 0 6 4 0",
"639 640 633  1 1 2 0   0 0 0 0 0  0 0 3 3 5 0 0  2 6 5 0 6 4 0  0 0 0 0 0",
"640 641 638  1 0 3 0   0 0 0 0 0  0 0 3 3 6 1 0  0 0 6 5 0 0 0  0 2 5 0 0",
"641 642 637  0 0 3 0   0 0 1 0 0  0 0 3 5 0 0 0  0 0 6 6 3 5 0  0 0 0 0 4",
"642 643 636  1 0 2 0   0 0 0 0 0  0 2 5 0 3 3 4  0 0 6 6 5 0 0  0 0 0 0 0",
"643 644 635  0 0 2 0   0 0 3 1 0  0 0 0 6 5 0 0  0 2 3 6 5 0 0  0 0 0 0 0",
"644 639 634  0 0 3 1   1 0 0 0 0  0 6 6 3 5 0 0  0 0 0 3 5 0 0  0 0 4 0 0",
"645 646 648  1 2 2 0   0 0 0 0 0  3 3 5 0 1 0 0  4 0 6 6 5 0 0  0 0 0 0 0",
"646 647 650  0 0 2 2   0 2 5 0 0  3 3 6 5 0 0 0  6 4 0 0 0 0 0  0 0 0 0 0",
"647 645 649  1 0 3 0   0 0 0 0 0  2 3 5 0 0 0 0  0 3 5 0 0 0 0  6 6 1 0 0",
"648 649 645  1 1 2 0   0 0 0 0 0  1 0 3 3 5 0 0  6 6 5 0 4 0 0  0 0 0 0 0",
"649 650 647  0 0 2 0   3 3 4 0 0  0 6 5 0 0 0 0  2 6 5 0 0 0 0  0 0 0 0 0",
"650 648 646  1 0 3 1   0 0 0 0 0  3 1 0 0 0 0 0  6 6 3 5 0 0 0  0 2 5 0 0",
"* 3",
"# 8 24",
"0 1 3  2 2 2 0      0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  2 3 6 3 6 3 6 1 0 0 0",
"                    0 0 0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"1 2 5  1 0 5 2      0 0 0 0 0 0 0  0 0 0 0 1 0 0 0 0  0 0 0 0 3 5 0 0 0 0 0",
"                    0 0 0 3 5 0 0 0 0 0 0  0 3 5 0 0 0 0 0 0  4 0 0 0 0 0 0",
"2 0 4  1 0 4 0      0 0 0 0 0 0 0  0 2 5 0 0 0 0 0 0  0 0 0 6 5 0 0 0 0 0 0",
"                    0 0 0 0 6 5 0 0 0 0 0  0 0 0 0 6 4 0 0 0  0 0 0 0 0 0 0",
"3 4 0  3 1 3 0      0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0 0 0",
"                    2 6 3 6 3 6 3 4 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"4 5 2  1 0 4 0      0 0 0 0 0 0 0  0 0 0 0 3 1 0 0 0  0 0 0 0 3 5 0 0 0 0 0",
"                    0 0 0 3 5 0 0 0 0 0 0  0 2 5 0 0 0 0 0 0  0 0 0 0 0 0 0",
"5 3 1  0 0 4 1      1 0 0 0 0 0 0  0 6 5 0 0 0 0 0 0  0 0 0 6 5 0 0 0 0 0 0",
"                    0 0 0 0 6 5 0 0 0 0 0  0 0 0 0 4 0 0 0 0  0 0 0 0 0 0 0",
"6 7 12  2 2 3 0     0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 3 3 6 3 6 1 0 0 0",
"                    0 2 5 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"7 8 17  0 0 4 0     1 0 0 0 0 0 0  3 5 0 0 0 0 0 0 0  3 5 0 0 0 0 0 0 0 0 0",
"                    6 5 0 0 0 0 0 0 0 0 0  4 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"8 9 16  2 0 4 0     0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 2 5 0 0 0 0 0 0 0 0",
"                    0 0 6 5 0 0 0 0 0 0 0  0 0 6 6 3 4 0 0 0  0 0 0 0 0 0 0",
"9 10 15  2 0 3 0    0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 3 1 0 0 0",
"                    0 2 3 6 3 6 5 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"10 11 14  0 0 4 2   1 0 0 0 0 0 0  0 6 5 0 0 0 0 0 0  0 0 3 5 0 0 0 0 0 0 0",
"                    0 3 5 0 0 0 0 0 0 0 0  4 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"11 6 13  2 0 4 0    0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 2 6 3 5 0 0 0 0 0 0",
"                    0 0 0 0 6 5 0 0 0 0 0  0 0 0 0 6 4 0 0 0  0 0 0 0 0 0 0",
"12 13 6  2 1 3 0    0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 2 6 3 6 3 5 0 0 0 0",
"                    0 0 0 0 0 0 6 4 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"13 14 11  1 0 3 0   0 0 0 0 0 0 0  0 0 3 3 6 1 0 0 0  0 0 3 5 0 0 0 0 0 0 0",
"                    0 2 5 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"14 15 10  1 0 5 1   0 0 0 0 0 0 0  1 0 0 0 0 0 0 0 0  3 5 0 0 0 0 0 0 0 0 0",
"                    6 5 0 0 0 0 0 0 0 0 0  6 5 0 0 0 0 0 0 0  4 0 0 0 0 0 0",
"15 16 9  2 0 3 0    0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 2 5 0 0 0 0 0 0 0 0",
"                    0 0 6 6 3 6 3 4 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"16 17 8  1 0 3 0    0 0 0 0 0 0 0  0 0 0 0 3 1 0 0 0  0 0 0 0 3 5 0 0 0 0 0",
"                    0 2 3 6 5 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"17 12 7  1 0 5 0    0 0 0 0 0 0 0  1 0 0 0 0 0 0 0 0  0 6 5 0 0 0 0 0 0 0 0",
"                    0 0 6 5 0 0 0 0 0 0 0  0 3 5 0 0 0 0 0 0  4 0 0 0 0 0 0",
"18 19 21  2 2 3 0   0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 3 3 6 1 0 0 0",
"                    0 2 3 6 5 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"19 20 23  0 0 4 2   1 0 0 0 0 0 0  3 5 0 0 0 0 0 0 0  0 6 5 0 0 0 0 0 0 0 0",
"                    0 3 5 0 0 0 0 0 0 0 0  4 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"20 18 22  2 0 4 0   0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 2 5 0 0 0 0 0 0 0 0",
"                    0 0 6 6 3 5 0 0 0 0 0  0 0 0 0 6 4 0 0 0  0 0 0 0 0 0 0",
"21 22 18  2 1 3 0   0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 2 6 3 5 0 0 0 0 0 0",
"                    0 0 0 0 6 6 3 4 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"22 23 20  1 0 3 0   0 0 0 0 0 0 0  0 0 0 0 3 1 0 0 0  0 0 3 3 6 5 0 0 0 0 0",
"                    0 2 5 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0 0 0  0 0 0 0 0 0 0",
"23 21 19  1 0 5 1   0 0 0 0 0 0 0  1 0 0 0 0 0 0 0 0  0 6 5 0 0 0 0 0 0 0 0",
"                    0 3 5 0 0 0 0 0 0 0 0  6 5 0 0 0 0 0 0 0  4 0 0 0 0 0 0"};
