.\" GENERIC X-BASED TERTRIS
.\"
.\" tertris.man
.\"
.\" ##
.\"
.\" Copyright (c) 1993 - 95	David A. Bagley, bagleyd@perry.njit.edu
.\"
.\" Taken from GENERIC X-BASED TETRIS
.\"
.\" Copyright (c) 1992 - 95	Q. Alex Zhao, azhao@cc.gatech.edu
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH TERTRIS 6 "28 Dec 95" "V1.2.0"
.SH NAME
tertris \- Yet Another tetris Game on X
.SH SYNOPSIS
.B /usr/games/tertris
[-s] [-l <start level>] [-p <prefilled lines>]
[-n <triangles in each polyiamond>] [-showNext] [-beep]
[-diagonal] [-mixed] [-bonus] [-ccw] [-fixedFill]
[-suddenAppear] [-scorefile <filename>] [-u <name>]
[-display <display>] [-geometry <geometry>]
[-iconGeometry <geometry>] [-{background | bg} <color>]
[-{foreground | fg} <color>] [-bigFont <font>] [-tinyFont <font>]
[-xrm <resource specification>]
.SH DESCRIPTION
.LP
This is a game of "\fITertris\fP" for the X Window System.
.LP
The program lists the top 15 players at the end, each player may has at
most three scores. With the option \fB\-s\fP, it shows all the players
and scores.
.LP
Key "\fBj\fP" moves the block left, "\fBl\fP" moves right,
"\fBk\fP" rotates, "\fBi\fP" reflects. Left-handed people may want to
use "\fBs\fP", "\fBf\fP", "\fBd\fP", "\fBe\fP" respectively. Or maybe
someone wants to try the arrow keys...  The space bar drops a block
quickly. Use "\fBCTRL-L\fP" key combination to redraw \- in case the
program messes something up.
.LP
As usual, "\fB+\fP" and "\fB\-\fP" speed up or lower down the speed. Note
that you don't need to press the "\fISHIFT\fP" key \- "\fB=\fP" and
"\fB_\fP" also work. The "\fBb\fP" key toggles "beep", and "\fBn\fP"
toggles "show next". The "\fB<\fP" and the "\fB>\fP" increase or decrease
the number or triangles per polyiamond. Again, you don't need to press the
"\fISHIFT\fP" key \- "\fB,\fP" and "\fB.\fP" also work. "\fBr\fP" toggles
grid and if available, "\fBg\fP" toggles diagonal mode, "\fBm\fP" toggles
mixed mode, and "\fBo\fP" toggles bonus mode.
.LP
If you press "\fBp\fP", the game will be paused, and the window
will be iconified \- just in case your boss suddenly appears at your
door ;o). When the tertris window loses its focus, it also goes to
"paused" mode except it doesn't iconify itself.
.LP
To get high scores, don't use "show next" mode, try starting at a
higher level and try to let "tertris" eat more than one line at a time.
.SH OPTIONS
.TP 8
.B \-s
This option lets the program only list all the recorded scores then exit.
.TP 8
.B \-l \fIlevel\fP
This option starts the program at the specified level (resource name
"\fIstartLevel\fP").
.TP 8
.B \-p \fIlines\fP
This option indicates that the program should start with some of the lines
being randomly filled (resource name "\fIpreFilledLines\fP").
.TP 8
.B \-n \fItriangles\fP
This option starts the program with the specified number of triangles in
each polyiamond (resource name "\fItriangles\fP").
.TP 8
.B \-showNext
This option tells the program start in "show next" mode (resource name
"\fIshowNext\fP").
.TP 8
.B \-beep
This option turns the sound on (resource name "\fIbeep\fP").
.TP 8
.B \-diagonal
This option turns diagonal mode on (only available on -n <2>)
(resource name "\fIdiagonal\fP").
.TP 8
.B \-mixed
This option turns the mixed mode on (not available for -n 2 since there
is nothing to mix it with). This allows polyiamonds of less triangles
than the maximum determined by -n (resource name "\fImixed\fP").
.TP 8
.B \-bonus
This option turns the bonus on (not available for -n 8 or diagonal).
Option allows greater size polyiamonds on any automatic level change
(resource name "\fIbonus\fP").
.TP 8
.B \-ccw
The rotate key will now rotate pieces ccw (resource name "\fIccw\fP").
.TP 8
.B \-fixedFill
Works only with the -p option where it fixes the number of boxes to be
filled to 4 random blocks per row. (resource name "\fIfixedFill\fP").
.TP 8
.B \-suddenAppear
Polyiamonds will now suddenly appear within the window. Now one cannot
rotate a piece above the window. (resource name "\fIsuddenAppear\fP").
.TP 8
.B \-scorefile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-u \fIname\fP
This option sets alternative player name.
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the tertris window (resource
name "\fIgeometry\fP").
.TP 8
.B \-iconGeometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the position of the icon (resource name "\fIiconGeometry\fP").
.TP 8
.B \-{background | bg} \fIcolor\fP
This option specifies the background of the tertris window (resource name
"\fIbackground\fP").
.TP 8
.B \-{foreground | fg} \fIcolor\fP
This option specifies the foreground of the tertris window (resource name
"\fIforeground\fP").
.TP 8
.B \-bigFont \fIfont\fP
This option sets the font used in drawing titles and important messages
(resource name "\fIbigFont\fP").
.TP 8
.B \-tinyFont \fIfont\fP
This option sets the font used in drawing status information
(resource name "\fItinyFont\fP").
.TP 8
.B \-xrm <\fIresource specification\fP>
Another method of specifying preferences.
.SH SEE ALSO
.LP
X(1), xtetris(6), xmris(6), tetris(6), welltris(6), hextris(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1993-95, David A. Bagley, <\fIbagleyd@perry.njit.edu\fP>.
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Problems with this version, send bug reports (or fixes):
.RS
David Albert Bagley,	<\fIbagleyd@perry.njit.edu\fP>
.RE
The basis for this program is tetris by:
.RS
Q. Alex Zhao,	<\fIazhao@cc.gatech.edu\fP>
.RE
.LP
The most updated source could be found on \fIftp.x.org\fP under
\fI/contrib/games\fP.
.SH ACKNOWLEDGEMENTS
.LP
Thanks go to people who helped me in improving the program.
