/* user-telnet-server.c
 *   Based upon Ken's post to INFO-MULTINET on 16-Sep-1994
 *
 */

/* build notes:
 *
 *   need to define SYS, NETINET, VMS, etc. properly (see LC:BUILD.COM)
 *
 *   need to link against MULTINET_SOCKET_LIBRARY, also
 *   MULTINET_VMS_SHAREABLE (for set_jib_username)
 *
 */


/* from KAA message in INFO-MULTINET:

    I would typically do this by writing my own TELNET server. Here is
an example of how you might do it. This code can be compiled and run
on an alternate port. If you set the "Validation_OK" flag and a username
around the "#ifdef notdef" it will automatically log all connections
into that account.


							    Ken
*/


/*
 *	Copyright (C) 1984, 1985, 1986	SRI International
 *	Copyright (C) 1988, 1989, 1990, 1992 TGV, Incorporated
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <vms/inetiodef.h>
#include <prcdef.h>
#include <iodef.h>

#define NETPTY_PROTOCOL       (1)
#define NETPTY_INITIAL_STRING (2)
#define NETPTY_ACCPORNAM      (3)
#define NETPTY_CREATE_VTA     (5)
#define NETPTY_UNIT_NTY       (0x8000)
#define NETPTY_UNIT_VTA       (0x8001)

/*
 *	This is a "user-written" TELNET server...
 */

main()
{
	unsigned short int Channel;
	register int Status;
	unsigned short int IOSB[4];
	char Name[256];
	struct sockaddr_in Peer_Socket;
	int i, NTY_Unit, VTA_Unit;
	char NTY_Name[32];
	char Validation_Username[64], Saved_Username[64], Dummy[64];
	int Validation_OK=0;
	struct hostent *hp;
	static int Protocol=1;	    /* TELNET protocol */
	struct {
	    unsigned short Length;
	    unsigned short Code;
	    char *Ptr;
	    unsigned short *RetLen;
	} ItmLst[8], *Itm=ItmLst;

	Itm->Length = sizeof(Protocol);
	Itm->Code   = NETPTY_PROTOCOL;
	Itm->Ptr    = &Protocol;
	Itm->RetLen = 0;
	Itm++;

	Itm->Length = sizeof(VTA_Unit);
	Itm->Code   = NETPTY_UNIT_VTA;
	Itm->Ptr    = &VTA_Unit;
	Itm->RetLen = 0;
	Itm++;

	Itm->Length = sizeof(NTY_Unit);
	Itm->Code   = NETPTY_UNIT_NTY;
	Itm->Ptr    = &NTY_Unit;
	Itm->RetLen = 0;
	Itm++;

	/*
	 *	Get a channel to the socket
	 */

	Status = SYS$ASSIGN(String_Descriptor("SYS$OUTPUT"),&Channel,0,0);
	if (!(Status&1)) SYS$EXIT(Status);

	/*
	 *	Get the remote peer's sockaddr
	 */
	i = sizeof(Peer_Socket);
	if (getpeername(Channel, &Peer_Socket, &i) >= 0) {
	    /*
	     *	    Find the 'name' of the remote port and pass this to
	     *	    the kernel. This will be used by the VMS V5 kernel to
	     *	    fill in the terminal ACCPORNAM field.
	     *	    Note this is passed as a counted string.
	     */
	    if (hp=gethostbyaddr(&Peer_Socket.sin_addr, sizeof(struct in_addr),
				 AF_INET)) {
		strcpy(Name, hp->h_name);
	    } else {
		sprintf(Name,"[%s]",inet_ntoa(Peer_Socket.sin_addr.s_addr));
	    }
	    Itm->Length = strlen(Name);
	    Itm->Code	= NETPTY_ACCPORNAM;
	    Itm->Ptr	= Name;
	    Itm->RetLen = 0;
	    Itm++;
	}

	/*
	 *	Here we do the special validation..
	 */

#ifdef notdef
	Validation_OK=1;	/* AUTOLOGIN */
	strcpy(Validation_Username, "HELP");
#endif notdef

	if (Validation_OK) {
	    Itm->Length = 0;
	    Itm->Code	= NETPTY_CREATE_VTA;
	    Itm->Ptr	= 0;
	    Itm->RetLen = 0;
	    Itm++;
	} else {
	    Itm->Length = 1;
	    Itm->Code	= NETPTY_INITIAL_STRING;
	    Itm->Ptr	= "\r",
	    Itm->RetLen = 0;
	    Itm++;
	}
	Itm->Length = Itm->Code = 0;
	/*
	 *	Connect the NET PTY
	 */
	Status = SYS$QIOW(0,
			  Channel,
			  IO$_NETWORK_PTY,
			  IOSB,
			  0,
			  0,
			  0,
			  0,
			  0,
			  0,
			  0,
			  ItmLst);
	if (!(Status & 1) ||
	    !(IOSB[0] & 1)) {
		socket_write(Channel, "Sorry, No PTYS\r\n", 16);
		exit(1);
	}

	/*
	 *	If we are supposed to autologin a user, then create
	 *	the process now. If not, then JOB_CONTROL has already
	 *	done it for us.
	 */

	if (Validation_OK) {
	    /*
	     *	    Figure out the name of the terminal to $CREPRC it on.
	     */
	    if (VTA_Unit) {
		sprintf(NTY_Name, "_VTA%d:", VTA_Unit);
	    } else {
		sprintf(NTY_Name, "_NTY%d:", NTY_Unit);
	    }
	    /*
	     *	    Activate LOGINOUT to start up DCL
	     *	    (need to check Activation status!)
	     */
	    set_jib_username(Validation_Username,
			     strlen(Validation_Username),
			     Saved_Username,
			     sizeof(Saved_Username));
	    Status = SYS$CREPRC(0,
				String_Descriptor("SYS$SYSTEM:LOGINOUT"),
				String_Descriptor(NTY_Name),
				String_Descriptor(NTY_Name),
				String_Descriptor(NTY_Name),
				0,
				0,
				String_Descriptor(NTY_Name),
				4,			    /* Priority     */
				0x00010004,		    /* UIC = [1,4]  */
				0,			    /* Term MBX     */
				PRC$M_INTER|PRC$M_NOPASSWORD);
	    /*
	     *	    Restore the old username
	     */
	    set_jib_username(Saved_Username,
			     sizeof(Saved_Username),
			     Dummy,
			     sizeof(Dummy));
	    if (!(Status&1)) SYS$EXIT(Status);
	}
	/*
	 *	Dump the NETWORK Channel
	 */
	socket_close(Channel);
	exit(1);
}

